package Bencher::Scenario::AppHr::Completion;

our $DATE = '2016-01-07'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

use Bencher::ScenarioUtil::Completion qw(make_completion_participant);

our $scenario = {
    summary => 'Benchmark completion response time, to monitor regression',
    modules => {
        'App::hr' => 0,
    },
    participants => [
        make_completion_participant(
            name=>'optname_common_help',
            cmdline=>"_hr --hel^",
        ),
        make_completion_participant(
            name=>'optname_common_version',
            cmdline=>"_hr --vers^",
        ),
        make_completion_participant(
            name=>'optname_random_color',
            cmdline=>"_hr --random^",
        ),
        make_completion_participant(
            name=>'optval_height',
            cmdline=>"_hr --height ^",
        ),
    ],
};

1;
# ABSTRACT: Benchmark completion response time, to monitor regression

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::AppHr::Completion - Benchmark completion response time, to monitor regression

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::AppHr::Completion (from Perl distribution Bencher-Scenarios-AppHr), released on 2016-01-07.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m AppHr::Completion

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<App::hr> 0.24

=head1 BENCHMARK PARTICIPANTS

=over

=item * optname_common_help (perl_code)

Run command (with COMP_LINE & COMP_POINT set, "^" marks COMP_POINT): _hr --hel^.



=item * optname_common_version (perl_code)

Run command (with COMP_LINE & COMP_POINT set, "^" marks COMP_POINT): _hr --vers^.



=item * optname_random_color (perl_code)

Run command (with COMP_LINE & COMP_POINT set, "^" marks COMP_POINT): _hr --random^.



=item * optval_height (perl_code)

Run command (with COMP_LINE & COMP_POINT set, "^" marks COMP_POINT): _hr --height ^.



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+------------------------+------+------+---------+---------+
 | seq | name                   | rate | time | errors  | samples |
 +-----+------------------------+------+------+---------+---------+
 | 2   | optname_random_color   | 22   | 46ms | 0.00076 | 20      |
 | 1   | optname_common_version | 22   | 45ms | 0.0004  | 20      |
 | 3   | optval_height          | 23   | 43ms | 0.00028 | 20      |
 | 0   | optname_common_help    | 24   | 42ms | 0.00019 | 20      |
 +-----+------------------------+------+------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-AppHr>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-AppHr>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-AppHr>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
