package Bencher::Scenario::LogAny;

our $DATE = '2016-01-02'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Log::Any',

    participants => [
        {name=>'log_trace', code_template=>'state $log = do { require Log::Any; Log::Any->get_logger }; $log->trace("")'},
        {name=>'if_trace' , code_template=>'state $log = do { require Log::Any; Log::Any->get_logger }; if ($log->is_trace) {}'},
    ],
};

1;
# ABSTRACT: Benchmark Log::Any

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LogAny

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::LogAny (from Perl distribution Bencher-Scenario-LogAny), released on 2015-01-02.

=head1 SYNOPSIS

=head1 DESCRIPTION

Early release. Todos include: benchmark enabled level, adapters, string
formatting.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-LogAny>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-LogAny>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-LogAny>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
