package Bencher::Scenario::CloneModules::Startup;

our $DATE = '2016-03-10'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup of various data cloning modules',
    module_startup => 1,
    participants => [
        {module=>'Clone'},
        {module=>'Clone::PP'},
        #{module=>'Clone::Any'}, # i no longer recommend using this
        {module=>'Clone::Util'},
        {module=>'Data::Clone'},
        {module=>'Function::Fallback::CoreOrPP'},
        {module=>'Sereal::Dclone'},
        {module=>'Storable'},
    ],
    #datasets => [
    #],
    on_failure => 'skip',
};

1;
# ABSTRACT: Benchmark startup of various data cloning modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::CloneModules::Startup - Benchmark startup of various data cloning modules

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::CloneModules::Startup (from Perl distribution Bencher-Scenario-CloneModules), released on 2016-03-10.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m CloneModules::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Clone> 0.38

L<Clone::PP> 1.06

L<Clone::Util> 0.01

L<Data::Clone> 0.004

L<Function::Fallback::CoreOrPP> 0.07

L<Sereal::Dclone> 0.001

L<Storable> 2.53

=head1 BENCHMARK PARTICIPANTS

=over

=item * Clone (perl_code)

L<Clone>



=item * Clone::PP (perl_code)

L<Clone::PP>



=item * Clone::Util (perl_code)

L<Clone::Util>



=item * Data::Clone (perl_code)

L<Data::Clone>



=item * Function::Fallback::CoreOrPP (perl_code)

L<Function::Fallback::CoreOrPP>



=item * Sereal::Dclone (perl_code)

L<Sereal::Dclone>



=item * Storable (perl_code)

L<Storable>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark cloning a 1000-element array (C<< bencher -m CloneModules::Startup --include-datasets-json '["array1000"]' >>):

 +------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                  | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +------------------------------+-----------+------------------------+------------+---------+---------+
 | Sereal::Dclone               | 14        | 9.2                    | 1          | 4.4e-05 | 20      |
 | Storable                     | 14        | 9.2                    | 1          | 4.7e-05 | 20      |
 | Clone                        | 11        | 6.2                    | 1.3        | 4.9e-05 | 20      |
 | Data::Clone                  | 9.3       | 4.5                    | 1.6        | 5.2e-05 | 20      |
 | Clone::PP                    | 8.5       | 3.7                    | 1.7        | 3.7e-05 | 20      |
 | Clone::Util                  | 8.2       | 3.4                    | 1.8        | 3.9e-05 | 20      |
 | Function::Fallback::CoreOrPP | 8.1       | 3.3                    | 1.8        | 4.7e-05 | 20      |
 | perl -e1 (baseline)          | 4.8       | 0                      | 3          | 2.1e-05 | 21      |
 +------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-CloneModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-CloneModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-CloneModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
