use 5.006;
use strict;
use warnings FATAL => 'all';
use Module::Build;

my $builder = Module::Build->new(
    meta_merge => {
        resources => {
            repository => 'https://github.com/smartcatai/SergeSmartcatPlugin',
        },
    },
    module_name              => 'SmartCAT::Serge',
    license                  => 'perl',
    dist_author              => 'Aleksey Ignatiev <a.ignatyev@smartcat.pro>',
    dist_version_from        => 'lib/SmartCAT/Serge.pm',
    release_status           => 'stable',
    configure_requires => {
        'Module::Build'      => 0,
    },
    requires => {
        'App::Cmd::Setup'        => '0.331'
    },
    add_to_cleanup           => ['Makefile.PL', 'MYMETA.*', 'META.*'],
    create_makefile_pl       => 'traditional',
);

$builder->create_build_script();
