package Chart::Plotly::Trace::Attribute::Contour;
use Moose;

our $VERSION = '0.007';    # VERSION

=encoding utf-8

=head1 NAME 

Chart::Plotly::Trace::Attribute::Contour

=head1 SYNOPSIS

	use HTML::Show;
	use Chart::Plotly;
	use Chart::Plotly::Trace::Attribute::Contour;
	my $contour = Chart::Plotly::Trace::Attribute::Contour->new(x => [1 .. 5], y => [1 .. 5]);
	
	HTML::Show::show(Chart::Plotly::render_full_html(data => [$contour]));


=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#contour>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=cut

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=cut

sub TO_JSON {
    my $self = shift;
    my %hash = %$self;
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

=head1 ATTRIBUTES

=over

=cut

=item * color

Sets the color of the contour lines.

=cut

has color => ( is            => 'rw',
               documentation => "Sets the color of the contour lines.", );

=item * show

Sets whether or not dynamic contours are shown on hover

=cut

has show => ( is            => 'rw',
              isa           => "Bool",
              documentation => "Sets whether or not dynamic contours are shown on hover",
);

=item * width

Sets the width of the contour lines.

=cut

has width => ( is            => 'rw',
               isa           => "Num",
               documentation => "Sets the width of the contour lines.",
);

=item * name

Sets the trace name

=cut

has name => ( is            => 'rw',
              isa           => "Str",
              documentation => "Sets the trace name",
);

=pod

=back

=cut

__PACKAGE__->meta->make_immutable();
1;
