package WebService::PayPal::PaymentsAdvanced::Response::Sale::CreditCard;
$WebService::PayPal::PaymentsAdvanced::Response::Sale::CreditCard::VERSION = '0.000007';
use Moo;

extends 'WebService::PayPal::PaymentsAdvanced::Response::Sale';

with(
    'WebService::PayPal::PaymentsAdvanced::Role::HasCreditCard',
);

1;

=pod

=encoding UTF-8

=head1 NAME

WebService::PayPal::PaymentsAdvanced::Response::Sale::CreditCard - Response class for credit card Sale transactions

=head1 VERSION

version 0.000007

=head1 DESCRIPTION

Response class for credit card Sale transactions C<TRXTYPE=S>  You should not
create this response object directly. This class inherits from
L<WebService::PayPal::PaymentsAdvanced::Response::Sale> and includes the
methods provided by
L<WebService::PayPal::PaymentsAdvanced::Role::HasCreditCard>.

=head1 AUTHOR

Olaf Alders <olaf@wundercounter.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by MaxMind, Inc..

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

__END__
# ABSTRACT: Response class for credit card Sale transactions

