package WebService::PayPal::PaymentsAdvanced::Response::Inquiry;
$WebService::PayPal::PaymentsAdvanced::Response::Inquiry::VERSION = '0.000006';
use Moo;

extends 'WebService::PayPal::PaymentsAdvanced::Response';

with 'WebService::PayPal::PaymentsAdvanced::Role::HasTransactionTime',
    'WebService::PayPal::PaymentsAdvanced::Role::HasTender';

1;

=pod

=encoding UTF-8

=head1 NAME

WebService::PayPal::PaymentsAdvanced::Response::Inquiry - Response class for Inquiry transactions

=head1 VERSION

version 0.000006

=head1 DESCRIPTION

Response class for Inquiry transactions C<TRXTYPE=I>  You should not create
this response object directly. This class inherits from
L<WebService::PayPal::PaymentsAdvanced::Response> and includes the methods
provided by L<WebService::PayPal::PaymentsAdvanced::Role::HasTransactionTime>
and L<WebService::PayPal::PaymentsAdvanced::Role::HasTransactionTender>.

=head1 AUTHOR

Olaf Alders <olaf@wundercounter.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by MaxMind, Inc..

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

__END__

# ABSTRACT: Response class for Inquiry transactions

