
use strict ;
use warnings ;

use Module::Build;

my %all_modules ;
my @split_modules ;

my @pm_files = qw(
lib/Config/Hierarchical.pm
lib/Config/Hierarchical/Tie/ReadOnly.pm
lib/Config/Hierarchical/Delta.pm
);

for(@pm_files)
	{
	$all_modules{$_} = $_ ;
	push @split_modules, $_ ;
	}

sub GetVersionandRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'Config-Hierarchical_USE_SVK_VERSION_FOR_DIST'})
	{
	my @svk_log = `svk log -r HEAD -q` ;
	if(@svk_log)
		{
		my ($revision) = $svk_log[1] =~ m/^r([0-9]+):/ ;
		print "using SVK revision $revision.\n" ;
		return("${version}.${revision}") ;
		}
	else
		{
		print "Couldn't get SVK revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

my $code = <<'EOC'
use strict ;
use warnings ;

#~ use Data::TreeDumper ;
#~ print DumpTree \@_, 'args:' ;

sub GetVersionandRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'Config-Hierarchical_USE_SVK_VERSION_FOR_DIST'})
	{
	my @svk_log = `svk log -r HEAD -q` ;
	if(@svk_log)
		{
		my ($revision) = $svk_log[1] =~ m/^r([0-9]+):/ ;
		print "using SVK revision $revision.\n" ;
		return("${version}.${revision}") ;
		}
	else
		{
		print "Couldn't get SVK revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

#~ sub ACTION_
#~ {
#~ my $self = shift;
#~ print "\n";
#~ }

sub ACTION_build 
{
my $self = shift;

if($ENV{'Config-Hierarchical_USE_SVK_VERSION_FOR_DIST'})
	{
	my ($version) = GetVersionandRevisionFrom('lib/Config/Hierarchical.pm') ;
	
	print "Generating version module ($version)\n" ;
	
	open VERSION, '>', 'Version.pm' or die "can't generate Version module: $!\n" ;
	
	print VERSION <<EOV ;
	
	# version module automatically generated by the build system
	
	package Config::Version ;
	
	sub GetVersion {return '$version'} ;
	
	1 ;
	
	# end of generated version module
EOV
	
	close VERSION ;
	}
	
$self->SUPER::ACTION_build(@_);
}

#~ sub ACTION_latest
#~ {
#~ ACTION_dist(@_) ;
#~ if($ENV{'Config-Hierarchical_USE_SVK_VERSION_FOR_DIST'})
	#~ {
	#~ my ($version) = GetVersionandRevisionFrom('lib/Config/Hierarchical.pm') ;
	
	#~ my $source = "PerlBuildSystem-$pbs_version.tar.gz" ;
	#~ my $destination = "PerlBuildSystem-latest.tar.gz" ;
	
	#~ use Net::SCP qw(scp iscp);
	#~ iscp($source, "nadim\@firewall:/var/www/localhost/htdocs/files_for_download/$destination");
	#~ }
#~ }

#~ sub ACTION_dist
#~ {
#~ my $self = shift;

#~ if($ENV{'Config-Hierarchical_USE_SVK_VERSION_FOR_DIST'})
	#~ {
	#~ my $have_svk = $self->do_system('svk --version');
	
	#~ if($have_svk)
		#~ {
		#~ if($self->do_system('svk log -x -v > SVK_Changes'))
			#~ {
			#~ use File::Copy;
			#~ move('SVK_Changes', 'Changes') ;
			#~ }
		#~ else
			#~ {
			#~ print "Couldn't get SVK log, 'Changes' will not be generated from SVK log!\n" ;
			#~ }
		#~ }
	#~ else
		#~ {
		#~ print "SVK not found, 'Changes' will not be generated from SVK log!\n" ;
		#~ }
	#~ }
	
#~ $self->SUPER::ACTION_dist();

#~ if($ENV{'Config-Hierarchical_USE_SVK_VERSION_FOR_DIST'})
	#~ {
	#~ my ($pbs_version) = GetVersionandRevisionFrom('lib/Config/Hierarchical.pm') ;
	
	#~ my $source = "PerlBuildSystem-$pbs_version.tar.gz" ;
	#~ my $destination = "PerlBuildSystem-bleed.tar.gz" ;
	
	#~ use Net::SCP qw(scp iscp);
	#~ iscp($source, "nadim\@firewall:/var/www/localhost/htdocs/files_for_download/$destination");
	#~ }
#~ };

sub ACTION_inject
{
#~ my $self = shift;

# check cpan if mini inject is installed
# build
# from $self find how to update 02packages.details.txt.gz

die "'inject' not implemented yet!\n";
}

sub ACTION_update_cpan_mini
{
# build test and make a dist
die "'update_mini_cpan' not implemented yet!\n";
}

EOC
;

my $class = Module::Build->subclass(class => 'Config::Hierarchical', code => $code) ;

my $build = $class->new
	(
	module_name => 'Config::Hierarchical',
	
	dist_version => GetVersionandRevisionFrom('lib/Config/Hierarchical.pm'),
	
	license => 'perl',
	
	requires => 
		{
		'Readonly'         => 0,
		'Data::Compare'    => 0,
		'Sub::Install'     => 0,
		'Data::TreeDumper' => 0,
		'Test::Cookbook' => 0.02,
		
		'Test::Block' => 0,
		'Test::Dependencies' => 0,
		'Test::Distribution' => 0,
		'Test::Exception' => 0,
		'Test::NoWarnings' => 0,
		'Test::Warn' => 0,
		'Test::Perl::Critic' => 0,
		'Test::Pod' => 0,
		'Test::Pod::Coverage' => 0,
		'Test::Spelling' => 0,
		'Test::Strict' => 0,
		},
		
	pm_files     => \%all_modules,
	autosplit    => \@split_modules,
	
	#~ script_files => 'script/xxx.pl',
	dist_author  => 'Khemir Nadim ibn Hamouda. <nadim@khemir.net>',
	dist_abstract => 'configuration variable hierachical container',
	);
	
$build->create_build_script;
  
