# This Makefile.PL for VideoLAN-LibVLC was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.48.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

our %PREREQ_PM;
BEGIN {
	%PREREQ_PM= (
		'Alien::VideoLAN::LibVLC' => '0.04',
		'ExtUtils::Depends'       => '0.405',
	);
	
	# If the prereqs for this script are missing,
	# write out a Makefile that tells CPAN to install them
	my $use_prereqs_code= join('', map { "use $_ '$PREREQ_PM{$_}'; " } keys %PREREQ_PM).'1;';
	print $use_prereqs_code."\n";
	unless (eval $use_prereqs_code) {
		warn "$@\n";
		WriteMakefile(
				NAME         => 'VideoLAN::LibVLC',
				PREREQ_FATAL => 1,
				PREREQ_PM    => \%PREREQ_PM,
		);
		exit 1; # not reached
	}
}

my $dep= ExtUtils::Depends->new('VideoLAN::LibVLC');

my %libvlc_info= Alien::VideoLAN::LibVLC->find_libvlc();

$dep->set_libs(join ' ', @{ $libvlc_info{ldflags} });
$dep->set_inc(join ' ', @{ $libvlc_info{cflags} });
$dep->add_c('PerlVLC.c');
$dep->add_xs('LibVLC.xs');
$dep->add_pm(map { my $n= $_; $n =~ s/^lib/\$(INST_LIB)/; $_ => $n } <lib/*/*.pm>, <lib/*/*/*.pm>);
$dep->add_typemaps('typemap');
$dep->install('PerlVLC.h');

mkdir 'build', 0777;
$dep->save_config('build/IFiles.pm');

my %WriteMakefileArgs = (
  "ABSTRACT" => "Decode audio/video files using LibVLC",
  "AUTHOR" => "Michael Conrad <mike\@nrdvana.net>",
  "CONFIGURE_REQUIRES" => {
    "Alien::VideoLAN::LibVLC" => "0.04",
    "ExtUtils::Depends" => "0.405",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "VideoLAN-LibVLC",
  "LICENSE" => "perl",
  "NAME" => "VideoLAN::LibVLC",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Exporter::Extensible" => 0,
    "IO::Handle" => 0,
    "Scalar::Util" => 0,
    "Socket" => 0,
    "XSLoader" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Devel::Peek" => 0,
    "File::Spec::Functions" => 0,
    "FindBin" => 0,
    "Log::Any" => 0,
    "Log::Any::Adapter::TAP" => 0,
    "Test::More" => 0,
    "Time::HiRes" => 0,
    "Try::Tiny" => 0
  },
  "VERSION" => "0.02",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    $dep->get_makefile_vars,
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Devel::Peek" => 0,
  "Exporter::Extensible" => 0,
  "File::Spec::Functions" => 0,
  "FindBin" => 0,
  "IO::Handle" => 0,
  "Log::Any" => 0,
  "Log::Any::Adapter::TAP" => 0,
  "Scalar::Util" => 0,
  "Socket" => 0,
  "Test::More" => 0,
  "Time::HiRes" => 0,
  "Try::Tiny" => 0,
  "XSLoader" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
