package Data::TableReader::Decoder::XLS;
$Data::TableReader::Decoder::XLS::VERSION = '0.001';
use Moo 2;
use Carp;
extends 'Data::TableReader::Decoder::Spreadsheet';

# ABSTRACT: Access sheets/rows of a Microsoft Excel '97 spreadsheet


sub _build_workbook {
	my $self= shift;
	
	my $wbook;
	my $f= $self->file_handle;
	if (ref $f and ref($f)->can('worksheets')) {
		$wbook= $f;
	} else {
		require Spreadsheet::ParseExcel;
		$wbook= Spreadsheet::ParseExcel->new->parse($f);
	}
	defined $wbook or croak "Can't parse file '".$self->file_name."'";
	return $wbook;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::TableReader::Decoder::XLS - Access sheets/rows of a Microsoft Excel '97 spreadsheet

=head1 VERSION

version 0.001

=head1 DESCRIPTION

See L<Data::TableReader::Decoder::Spreadsheet>.
This subclass simply initializes the parser with an instance of
L<Spreadsheet::ParseExcel>.

=head1 AUTHOR

Michael Conrad <mike@nrdvana.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Michael Conrad.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
