#!perl

use strict;
use warnings;
use utf8;

use LWP::Online ':skip_all';
use Test::More 0.88 tests => 4;
use WebService::BambooHR;
my $domain  = 'testperl';
my $api_key = 'bfb359256c9d9e26b37309420f478f03ec74599b';
my $bamboo;
my @changes;

SKIP: {

    my $bamboo = WebService::BambooHR->new(
                        company => $domain,
                        api_key => $api_key);
    ok(defined($bamboo), "create BambooHR class");

    eval {
        @changes = $bamboo->changed_employees('1900-01-20T00:00:01Z');
    };
    ok(!$@ && @changes > 0, 'get changes list');

    ok(@changes == 198, 'expected number of changes');

    my $changes_string = render_changes(\@changes);
    my $expected_changes_string = read_data();
    is($changes_string, $expected_changes_string, "compare changes fields");

};

sub render_changes
{
    my $changes_ref = shift;
    my $result = "id|action|lastChanged\n";

    foreach my $change (sort { $a->id <=> $b->id } @$changes_ref) {
        $result .= $change->id
                   .'|'
                   .$change->action
                   .'|'
                   .$change->lastChanged
                   ."\n";
    }

    return $result;
}

sub read_data
{
    local $/;
    return scalar <DATA>;
}

__DATA__
id|action|lastChanged
0|Updated|2014-02-14T19:48:29+00:00
36|Updated|2011-08-11T16:17:15+00:00
11629|Updated|2014-02-15T07:51:15+00:00
11631|Updated|2014-02-15T07:51:15+00:00
11632|Updated|2014-01-24T23:11:42+00:00
11633|Deleted|2012-01-10T23:59:34+00:00
11634|Updated|2014-01-24T23:11:42+00:00
11635|Updated|2014-01-24T23:11:42+00:00
11636|Updated|2014-01-24T23:11:42+00:00
11637|Updated|2014-01-24T23:11:42+00:00
11638|Updated|2014-01-24T23:11:42+00:00
11639|Updated|2014-01-24T23:11:42+00:00
11640|Updated|2014-01-24T23:11:42+00:00
11641|Updated|2014-01-24T23:11:42+00:00
11642|Updated|2014-01-24T23:11:42+00:00
11643|Updated|2014-01-24T23:11:42+00:00
11644|Updated|2014-02-14T19:48:29+00:00
11645|Updated|2014-01-24T23:11:42+00:00
11648|Updated|2014-01-24T23:11:42+00:00
11651|Updated|2014-01-24T23:11:42+00:00
11652|Updated|2014-01-24T23:11:42+00:00
11653|Updated|2014-01-24T23:11:42+00:00
11654|Updated|2014-01-24T23:11:42+00:00
11655|Updated|2014-01-24T23:11:42+00:00
11656|Updated|2014-01-24T23:11:42+00:00
11658|Updated|2014-01-24T23:11:42+00:00
11660|Updated|2014-01-24T23:11:42+00:00
11661|Updated|2014-01-24T23:11:42+00:00
11662|Updated|2014-01-24T23:11:42+00:00
11663|Updated|2014-01-24T23:11:42+00:00
11667|Updated|2014-01-24T23:11:42+00:00
11670|Updated|2014-01-24T23:11:42+00:00
11674|Updated|2014-01-24T23:11:42+00:00
11676|Updated|2014-01-24T23:11:42+00:00
11677|Updated|2014-01-24T23:11:42+00:00
11678|Updated|2014-01-24T23:11:42+00:00
11679|Updated|2014-01-24T23:11:42+00:00
11680|Updated|2014-01-24T23:11:42+00:00
11682|Updated|2014-01-24T23:11:42+00:00
11683|Updated|2014-01-24T23:11:42+00:00
11685|Updated|2014-01-24T23:11:42+00:00
11686|Updated|2014-01-24T23:11:42+00:00
11687|Updated|2014-01-24T23:11:42+00:00
11691|Updated|2014-01-24T23:11:42+00:00
11693|Updated|2014-01-24T23:11:42+00:00
11697|Updated|2014-01-24T23:11:42+00:00
11700|Updated|2014-01-24T23:11:42+00:00
11702|Updated|2014-02-15T07:51:15+00:00
11703|Updated|2014-01-24T23:11:42+00:00
11708|Updated|2014-01-24T23:11:42+00:00
11713|Updated|2014-01-24T23:11:42+00:00
11715|Updated|2014-01-24T23:11:42+00:00
11716|Updated|2014-02-15T07:51:15+00:00
11719|Updated|2014-01-24T23:11:42+00:00
11843|Updated|2014-01-24T23:11:42+00:00
12768|Updated|2014-01-24T23:11:42+00:00
14171|Updated|2014-01-24T23:11:42+00:00
15766|Updated|2014-01-24T23:11:42+00:00
16651|Updated|2014-01-24T23:11:42+00:00
16652|Updated|2014-01-24T23:11:42+00:00
17418|Updated|2014-01-24T23:11:42+00:00
18625|Updated|2011-08-11T16:17:15+00:00
18626|Updated|2011-08-11T16:17:15+00:00
18627|Updated|2011-08-11T16:17:15+00:00
18629|Updated|2011-08-11T16:17:15+00:00
18631|Updated|2011-08-11T16:17:15+00:00
18633|Updated|2011-08-11T16:17:15+00:00
18634|Updated|2011-08-11T16:17:15+00:00
18635|Updated|2011-08-11T16:17:15+00:00
18638|Updated|2011-08-11T16:17:15+00:00
18641|Updated|2011-08-11T16:17:15+00:00
18642|Updated|2011-08-11T16:17:15+00:00
18643|Updated|2011-08-11T16:17:15+00:00
18644|Updated|2011-08-11T16:17:15+00:00
18645|Updated|2011-08-11T16:17:15+00:00
18646|Updated|2011-08-11T16:17:15+00:00
18649|Updated|2011-08-11T16:17:15+00:00
18651|Updated|2011-08-11T16:17:15+00:00
18655|Updated|2011-08-11T16:17:15+00:00
18657|Updated|2011-08-11T16:17:15+00:00
18658|Updated|2011-08-11T16:17:15+00:00
18661|Updated|2011-08-11T16:17:15+00:00
18662|Updated|2011-08-11T16:17:15+00:00
18664|Updated|2011-08-11T16:17:15+00:00
18665|Updated|2011-08-11T16:17:15+00:00
18666|Updated|2011-08-11T16:17:15+00:00
18667|Updated|2011-08-11T16:17:15+00:00
18668|Updated|2011-08-11T16:17:15+00:00
18729|Updated|2014-01-24T23:11:42+00:00
18730|Updated|2014-01-24T23:11:42+00:00
18740|Updated|2014-01-24T23:11:42+00:00
18882|Updated|2011-08-11T16:17:15+00:00
19547|Updated|2011-08-11T16:17:15+00:00
19906|Updated|2011-08-11T16:17:15+00:00
22712|Updated|2014-01-24T23:11:42+00:00
25995|Updated|2014-01-24T23:11:42+00:00
25997|Updated|2014-01-24T23:11:42+00:00
25999|Updated|2014-01-24T23:11:42+00:00
26006|Updated|2014-01-24T23:11:42+00:00
26049|Updated|2014-01-24T23:11:42+00:00
26056|Updated|2014-01-24T23:11:42+00:00
26057|Updated|2014-01-24T23:11:42+00:00
26059|Deleted|2012-01-10T23:59:47+00:00
26061|Updated|2014-01-24T23:11:42+00:00
34813|Updated|2014-01-24T23:11:42+00:00
35136|Updated|2014-01-24T23:11:42+00:00
35519|Updated|2011-08-11T16:17:15+00:00
35570|Updated|2011-08-11T16:17:15+00:00
35909|Updated|2014-01-24T23:11:42+00:00
36010|Updated|2011-08-11T16:17:15+00:00
36011|Updated|2011-08-11T16:17:15+00:00
36012|Updated|2011-08-11T16:17:15+00:00
36015|Updated|2011-08-11T16:17:15+00:00
36016|Updated|2011-08-11T16:17:15+00:00
36024|Updated|2011-08-11T16:17:15+00:00
36025|Updated|2011-08-11T16:17:15+00:00
36042|Updated|2014-01-24T23:11:42+00:00
38953|Updated|2014-01-24T23:11:42+00:00
39828|Updated|2014-02-14T19:48:29+00:00
39829|Updated|2014-01-24T23:11:42+00:00
40116|Updated|2014-01-24T23:11:42+00:00
40186|Updated|2011-08-11T16:17:15+00:00
40214|Updated|2014-01-24T23:11:42+00:00
40226|Updated|2011-08-11T16:17:15+00:00
40238|Updated|2011-08-11T16:17:15+00:00
40331|Updated|2014-01-24T23:11:42+00:00
40335|Updated|2014-01-24T23:11:42+00:00
40338|Updated|2014-01-24T23:11:42+00:00
40339|Updated|2014-01-24T23:11:42+00:00
40342|Updated|2014-01-24T23:11:42+00:00
40343|Updated|2014-01-24T23:11:42+00:00
40344|Updated|2014-01-24T23:11:42+00:00
40345|Updated|2014-01-24T23:11:42+00:00
40346|Deleted|2012-01-10T23:58:36+00:00
40347|Inserted|2014-02-14T19:48:29+00:00
40348|Deleted|2012-11-27T18:20:42+00:00
40349|Deleted|2012-11-27T18:21:19+00:00
40350|Deleted|2012-11-27T18:21:23+00:00
40351|Deleted|2012-11-27T18:19:06+00:00
40352|Deleted|2012-11-27T18:20:36+00:00
40353|Deleted|2012-11-27T18:19:24+00:00
40354|Deleted|2012-11-27T18:20:54+00:00
40355|Deleted|2012-11-27T18:21:07+00:00
40356|Deleted|2012-11-27T18:21:27+00:00
40357|Deleted|2012-11-27T18:19:32+00:00
40358|Deleted|2012-11-27T18:19:37+00:00
40359|Deleted|2012-11-27T18:20:15+00:00
40360|Deleted|2012-11-27T18:20:02+00:00
40361|Deleted|2012-11-27T18:20:20+00:00
40362|Deleted|2012-11-27T18:19:47+00:00
40363|Deleted|2012-11-27T18:21:39+00:00
40364|Deleted|2012-11-27T18:19:42+00:00
40365|Deleted|2012-11-27T18:20:10+00:00
40366|Deleted|2012-11-27T18:21:00+00:00
40367|Deleted|2012-11-27T18:20:46+00:00
40368|Deleted|2012-11-27T18:19:52+00:00
40369|Deleted|2012-11-27T18:20:06+00:00
40370|Deleted|2012-11-27T18:19:57+00:00
40371|Deleted|2012-11-27T18:20:31+00:00
40372|Deleted|2012-11-27T18:21:13+00:00
40373|Deleted|2012-11-27T18:19:01+00:00
40374|Deleted|2012-11-27T18:20:26+00:00
40375|Deleted|2012-11-27T18:21:44+00:00
40376|Deleted|2012-11-27T18:21:33+00:00
40377|Inserted|2014-01-24T23:11:42+00:00
40378|Inserted|2014-01-24T23:11:42+00:00
40379|Inserted|2014-01-24T23:11:42+00:00
40380|Inserted|2014-01-24T23:11:42+00:00
40381|Inserted|2014-01-24T23:11:42+00:00
40382|Inserted|2014-01-24T23:11:42+00:00
40383|Inserted|2014-01-24T23:11:42+00:00
40384|Inserted|2014-01-24T23:11:42+00:00
40385|Inserted|2014-01-24T23:11:42+00:00
40386|Inserted|2014-01-24T23:11:42+00:00
40387|Inserted|2014-01-24T23:11:42+00:00
40388|Inserted|2014-01-24T23:11:42+00:00
40389|Inserted|2014-01-24T23:11:42+00:00
40390|Inserted|2014-01-24T23:11:42+00:00
40391|Inserted|2014-01-24T23:11:42+00:00
40392|Inserted|2014-01-24T23:11:42+00:00
40393|Inserted|2014-01-24T23:11:42+00:00
40394|Inserted|2014-01-24T23:11:42+00:00
40395|Inserted|2014-01-24T23:11:42+00:00
40396|Inserted|2014-01-24T23:11:42+00:00
40397|Inserted|2014-01-24T23:11:42+00:00
40398|Inserted|2014-01-24T23:11:42+00:00
40399|Inserted|2014-01-24T23:11:42+00:00
40400|Inserted|2014-01-24T23:11:42+00:00
40401|Inserted|2014-01-24T23:11:42+00:00
40402|Inserted|2014-01-24T23:11:42+00:00
40403|Inserted|2014-01-24T23:11:42+00:00
40404|Inserted|2014-01-24T23:11:42+00:00
40405|Inserted|2014-01-24T23:11:42+00:00
40406|Inserted|2014-01-24T23:11:42+00:00
40407|Inserted|2014-01-24T23:11:42+00:00
40408|Inserted|2014-01-24T23:11:42+00:00
40409|Inserted|2014-01-24T23:11:42+00:00
40410|Inserted|2014-01-24T23:11:42+00:00
