# -*- Mode: CPerl -*-

$TEST_DIR = './t';
#use lib qw(../blib/lib ../blib/arch); $TEST_DIR = '.'; # for debugging

use DDC::XS;

# load common subs
do "$TEST_DIR/common.plt"
  or die("could not load $TEST_DIR/common.plt");

my @hse =
  (
   qw(NoSort RandomSort),
   (map {("LessBy$_","GreaterBy$_")}
    qw(Date Size FreeBiblField Rank MiddleContext LeftContext RightContext CountKey CountValue)),
  );

my @constants =
  (
   ##--------------------------------------------------------------
   ## Constants: generic
   qw(library_version),

   ##--------------------------------------------------------------
   ## Constants: HitSortEnum
   @hse,
  );

plan(test => (2*@constants) + (2*@hse));

##-- 1..($NC=2*@constants): test constant subs
my ($sub);
foreach (@constants) {
  isok("can($_)", (defined($sub=DDC::XS->can($_))));
  isok("defined($_())",  defined($sub) && defined($sub->()));
}

##-- ($NC+1)..(($NC+1)*2*@hse) : hitsortenum
foreach (@hse) {
  my $e = DDC::XS->can($_)->();
  isok("\@HitSortEnum{$_}",   defined($e) && $DDC::XS::HitSortEnum{$_} == $e);
  isok("\@HitSortEnum[$_()]", defined($e) && $DDC::XS::HitSortEnum[$e] eq $_);
}

print "\n";

