use 5.008001;
use strict;
use warnings;

package BSON::Code;
# ABSTRACT: JavaScript code data for BSON

our $VERSION = '0.15'; # TRIAL

sub new {
    my ( $class, $code, $scope ) = @_;
    bless { code => $code, scope => $scope }, $class;
}

sub code {
    $_[0]->{code};
}

sub scope {
    $_[0]->{scope};
}

sub length {
    length( $_[0]->code );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

BSON::Code - JavaScript code data for BSON

=head1 VERSION

version 0.15

=head1 SYNOPSIS

    use BSON;

    my $code = BSON::Code->new(q[
        function be_weird(a) {
            if ( a > 20 ) {
                alert("It's too big!")
            }
            return function(b){
                alert(b)
            }
        }
    ]);

=head1 DESCRIPTION

This module is needed for L<BSON> and it manages BSON's code element.

=head1 METHODS

=head2 new

Main constructor which takes two parameters: A string with JavaScript code
and an optional hashref with scope. 

    my $code = BSON::Code->new($js_code, { a => 6, b => 14 });

=head2 code

Returns the JavaScript code.

=head2 scope

Returns the scope hashref.

=head2 length

Returns the length of the JavaScript code.

=head1 SEE ALSO

L<BSON>

=head1 AUTHORS

=over 4

=item *

minimalist <minimalist@lavabit.com>

=item *

David Golden <david@mongodb.com>

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by minimalist and MongoDB, Inc..

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
