package MyTypes::CommonItemData;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(MyTypes::PermissionItemData);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Permissions_of :ATTR(:get<Permissions>);
my %Categories_of :ATTR(:get<Categories>);
my %Title_of :ATTR(:get<Title>);
my %Editor_of :ATTR(:get<Editor>);
my %AlertTemplate_of :ATTR(:get<AlertTemplate>);
my %Url_of :ATTR(:get<Url>);
my %Comment_of :ATTR(:get<Comment>);
my %AlertRecipients_of :ATTR(:get<AlertRecipients>);

__PACKAGE__->_factory(
    [ qw(        Permissions
        Categories
        Title
        Editor
        AlertTemplate
        Url
        Comment
        AlertRecipients

    ) ],
    {
        'Permissions' => \%Permissions_of,
        'Categories' => \%Categories_of,
        'Title' => \%Title_of,
        'Editor' => \%Editor_of,
        'AlertTemplate' => \%AlertTemplate_of,
        'Url' => \%Url_of,
        'Comment' => \%Comment_of,
        'AlertRecipients' => \%AlertRecipients_of,
    },
    {
        'Permissions' => 'MyTypes::ArrayOfPermission',
        'Categories' => 'MyTypes::ArrayOfString',
        'Title' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Editor' => 'MyTypes::NUser',
        'AlertTemplate' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Url' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Comment' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'AlertRecipients' => 'MyTypes::HstringAddressesSalutations',
    },
    {

        'Permissions' => 'Permissions',
        'Categories' => 'Categories',
        'Title' => 'Title',
        'Editor' => 'Editor',
        'AlertTemplate' => 'AlertTemplate',
        'Url' => 'Url',
        'Comment' => 'Comment',
        'AlertRecipients' => 'AlertRecipients',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::CommonItemData

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CommonItemData from the namespace http://tempuri2.org/.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Categories


=item * Title


=item * Editor


=item * AlertTemplate


=item * Url


=item * Comment


=item * AlertRecipients




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::CommonItemData
   Categories =>  { # MyTypes::ArrayOfString
     Category =>  $some_value, # string
   },
   Title =>  $some_value, # string
   Editor =>  { value => $some_value },
   AlertTemplate =>  $some_value, # string
   Url =>  $some_value, # string
   Comment =>  $some_value, # string
   AlertRecipients => 
 # No documentation generated for complexContent / extension yet
,
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

