package MyTypes::AttachmentItemData;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(MyTypes::CommonItemData);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Permissions_of :ATTR(:get<Permissions>);
my %Categories_of :ATTR(:get<Categories>);
my %Title_of :ATTR(:get<Title>);
my %Editor_of :ATTR(:get<Editor>);
my %AlertTemplate_of :ATTR(:get<AlertTemplate>);
my %Url_of :ATTR(:get<Url>);
my %Comment_of :ATTR(:get<Comment>);
my %AlertRecipients_of :ATTR(:get<AlertRecipients>);
my %Attachments_of :ATTR(:get<Attachments>);

__PACKAGE__->_factory(
    [ qw(        Permissions
        Categories
        Title
        Editor
        AlertTemplate
        Url
        Comment
        AlertRecipients
        Attachments

    ) ],
    {
        'Permissions' => \%Permissions_of,
        'Categories' => \%Categories_of,
        'Title' => \%Title_of,
        'Editor' => \%Editor_of,
        'AlertTemplate' => \%AlertTemplate_of,
        'Url' => \%Url_of,
        'Comment' => \%Comment_of,
        'AlertRecipients' => \%AlertRecipients_of,
        'Attachments' => \%Attachments_of,
    },
    {
        'Permissions' => 'MyTypes::ArrayOfPermission',
        'Categories' => 'MyTypes::ArrayOfString',
        'Title' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Editor' => 'MyTypes::NUser',
        'AlertTemplate' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Url' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Comment' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'AlertRecipients' => 'MyTypes::HstringAddressesSalutations',
        'Attachments' => 'MyTypes::ArrayOfAttachment',
    },
    {

        'Permissions' => 'Permissions',
        'Categories' => 'Categories',
        'Title' => 'Title',
        'Editor' => 'Editor',
        'AlertTemplate' => 'AlertTemplate',
        'Url' => 'Url',
        'Comment' => 'Comment',
        'AlertRecipients' => 'AlertRecipients',
        'Attachments' => 'Attachments',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::AttachmentItemData

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AttachmentItemData from the namespace http://tempuri2.org/.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Attachments




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::AttachmentItemData
   Attachments =>  { # MyTypes::ArrayOfAttachment
     Attachment =>  { # MyTypes::Attachment
       Data =>  $some_value, # base64Binary
       Operation => $some_value, # AttachmentOperation
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

