
package MyElements::ModifyCalendarEntry;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://tempuri2.org/' }

__PACKAGE__->__set_name('ModifyCalendarEntry');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %calendarName_of :ATTR(:get<calendarName>);
my %id_of :ATTR(:get<id>);
my %User_of :ATTR(:get<User>);
my %modifyData_of :ATTR(:get<modifyData>);

__PACKAGE__->_factory(
    [ qw(        calendarName
        id
        User
        modifyData

    ) ],
    {
        'calendarName' => \%calendarName_of,
        'id' => \%id_of,
        'User' => \%User_of,
        'modifyData' => \%modifyData_of,
    },
    {
        'calendarName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'User' => 'MyTypes::NUser',
        'modifyData' => 'MyTypes::CalendarModifyData',
    },
    {

        'calendarName' => 'calendarName',
        'id' => 'id',
        'User' => 'User',
        'modifyData' => 'modifyData',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::ModifyCalendarEntry

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
ModifyCalendarEntry from the namespace http://tempuri2.org/.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * calendarName

 $element->set_calendarName($data);
 $element->get_calendarName();




=back
=item * id

 $element->set_id($data);
 $element->get_id();




=back
=item * User

 $element->set_User($data);
 $element->get_User();




=back
=item * modifyData

 $element->set_modifyData($data);
 $element->get_modifyData();




=back


=head1 METHODS

=head2 new

 my $element = MyElements::ModifyCalendarEntry->new($data);

Constructor. The following data structure may be passed to new():

 {
   calendarName =>  $some_value, # string
   id =>  $some_value, # int
   User =>  { value => $some_value },
   modifyData =>  { # MyTypes::CalendarModifyData
     Description =>  $some_value, # string
     EventDate =>  $some_value, # dateTime
     EndDate =>  $some_value, # dateTime
     ReminderDate =>  $some_value, # dateTime
     ReminderTemplate =>  $some_value, # string
     FAllDayEvent =>  $some_value, # boolean
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

