package MyTypes::SerializedItem;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS = 'MyTypes::SerializedItem::_SerializedItem::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Attachments_of :ATTR(:get<Attachments>);
my %Fields_of :ATTR(:get<Fields>);

__PACKAGE__->_factory(
    [ qw(        Attachments
        Fields

    ) ],
    {
        'Attachments' => \%Attachments_of,
        'Fields' => \%Fields_of,
    },
    {
        'Attachments' => 'MyTypes::ArrayOfString1',
        'Fields' => 'MyTypes::ArrayOfField',
    },
    {

        'Attachments' => 'Attachments',
        'Fields' => 'Fields',
    }
);

} # end BLOCK




package MyTypes::SerializedItem::_SerializedItem::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %ID_of :ATTR(:get<ID>);

__PACKAGE__->_factory(
    [ qw(
        ID
    ) ],
    {

        ID => \%ID_of,
    },
    {
        ID => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    }
);

} # end BLOCK



1;


=pod

=head1 NAME

MyTypes::SerializedItem

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SerializedItem from the namespace http://tempuri2.org/.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Attachments


=item * Fields




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::SerializedItem
   Attachments =>  { # MyTypes::ArrayOfString1
     Attachment =>  $some_value, # string
   },
   Fields =>  { # MyTypes::ArrayOfField
     Field => ,
   },
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class MyTypes::SerializedItem::_SerializedItem::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * ID



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::int|SOAP::WSDL::XSD::Typelib::Builtin::int>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

