package CPAN::cpanfile::Environment;
use strict;
use CPAN::cpanfile::Result;

my @bindings = qw(
    on requires recommends suggests conflicts
    osname perl
    configure_requires build_requires test_requires author_requires
);

my $file_id = 1;

sub import {
    my($class, $result_ref) = @_;
    my $pkg = caller;

    $$result_ref = CPAN::cpanfile::Result->new;
    for my $binding (@bindings) {
        no strict 'refs';
        *{"$pkg\::$binding"} = sub { $$result_ref->$binding(@_) };
    }
}

sub parse {
    my $file = shift;

    my $code = do {
        open my $fh, "<", $file or die "$file: $!";
        join '', <$fh>;
    };

    my $res = eval sprintf <<EVAL, $file_id++;
package CPAN::cpanfile::Sandbox%d;
my \$_result;
no warnings;
use CPAN::cpanfile::Environment \\\$_result;

$code;

\$_result;
EVAL

    if (my $err = $@ || $!) { die "Parsing $file failed: $err" };

    return $res;
}

1;
