# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#	dig_for.t
#
######################### We start with some black magic to print on failure.
# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN {
	$| = 1; print "1..6\n"; 
	*CORE::GLOBAL::localtime = \&localtime;
}
END {print "not ok 1\n" unless $loaded;}

#use diagnostics;
use Digest::MD5 qw(
	md5_hex
);
use Net::DNS::Dig;
use Net::DNS::Codes qw(:all);
use Net::DNS::ToolKit qw(
	put1char
	get1char
	inet_aton
);
use Net::DNS::ToolKit::RR;
#use Net::DNS::ToolKit::Debug qw(
#	print_head
#	print_buf
#);

$loaded = 1;
print "ok 1\n";
######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$test = 2;

sub ok {
  print "ok $test\n";
  ++$test;
}

$Net::DNS::Dig::VERSION = sprintf("%d.%02d",0,1);       # always test as version 0.01

*set_names = \&Net::DNS::Dig::_get_nameservers;

package MyTest;

require './recurse2txt';

package main;

sub expect {
  my $x = shift;
  my @exp;
  foreach(split(/\n/,$x)) {
    if ($_ =~ /0x\w+\s+(\d+) /) {
      push @exp,$1;
    }
  }
  return @exp;
}

sub print_ptrs {
  foreach(@_) {
    print "$_ ";
  }
  print "\n";
}

sub chk_exp {
  my($bp,$exp) = @_;
  my @expect = expect($$exp);
  foreach(0..length($$bp) -1) {
    $char = get1char($bp,$_);
    next if $char == $expect[$_];
    print "buffer mismatch $_, got: $char, exp: $expect[$_]\nnot ";
    last;
  }
  &ok;
}

my $ques = q
| 0	:  0011_1000  0x38   56  8  
  1	:  1010_0010  0xA2  162    
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0110  0x06    6    
  13	:  0110_0111  0x67  103  g  
  14	:  0110_1111  0x6F  111  o  
  15	:  0110_1111  0x6F  111  o  
  16	:  0110_0111  0x67  103  g  
  17	:  0110_1100  0x6C  108  l  
  18	:  0110_0101  0x65  101  e  
  19	:  0000_0011  0x03    3    
  20	:  0110_0011  0x63   99  c  
  21	:  0110_1111  0x6F  111  o  
  22	:  0110_1101  0x6D  109  m  
  23	:  0000_0000  0x00    0    
  24	:  0000_0000  0x00    0    
  25	:  0000_0001  0x01    1    
  26	:  0000_0000  0x00    0    
  27	:  0000_0001  0x01    1    |;

my $ans = q
| 0	:  0011_1000  0x38   56  8  
  1	:  1010_0010  0xA2  162    
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0101  0x05    5    
  8	:  0000_0000  0x00    0    
  9	:  0000_0100  0x04    4    
  10	:  0000_0000  0x00    0    
  11	:  0000_0100  0x04    4    
  12	:  0000_0110  0x06    6    
  13	:  0110_0111  0x67  103  g  
  14	:  0110_1111  0x6F  111  o  
  15	:  0110_1111  0x6F  111  o  
  16	:  0110_0111  0x67  103  g  
  17	:  0110_1100  0x6C  108  l  
  18	:  0110_0101  0x65  101  e  
  19	:  0000_0011  0x03    3    
  20	:  0110_0011  0x63   99  c  
  21	:  0110_1111  0x6F  111  o  
  22	:  0110_1101  0x6D  109  m  
  23	:  0000_0000  0x00    0    
  24	:  0000_0000  0x00    0    
  25	:  0000_0001  0x01    1    
  26	:  0000_0000  0x00    0    
  27	:  0000_0001  0x01    1    
  28	:  1100_0000  0xC0  192    
  29	:  0000_1100  0x0C   12    
  30	:  0000_0000  0x00    0    
  31	:  0000_0001  0x01    1    
  32	:  0000_0000  0x00    0    
  33	:  0000_0001  0x01    1    
  34	:  0000_0000  0x00    0    
  35	:  0000_0000  0x00    0    
  36	:  0000_0001  0x01    1    
  37	:  0001_0101  0x15   21    
  38	:  0000_0000  0x00    0    
  39	:  0000_0100  0x04    4    
  40	:  0100_1010  0x4A   74  J  
  41	:  0111_1101  0x7D  125  }  
  42	:  1110_0000  0xE0  224    
  43	:  1001_0001  0x91  145    
  44	:  1100_0000  0xC0  192    
  45	:  0000_1100  0x0C   12    
  46	:  0000_0000  0x00    0    
  47	:  0000_0001  0x01    1    
  48	:  0000_0000  0x00    0    
  49	:  0000_0001  0x01    1    
  50	:  0000_0000  0x00    0    
  51	:  0000_0000  0x00    0    
  52	:  0000_0001  0x01    1    
  53	:  0001_0101  0x15   21    
  54	:  0000_0000  0x00    0    
  55	:  0000_0100  0x04    4    
  56	:  0100_1010  0x4A   74  J  
  57	:  0111_1101  0x7D  125  }  
  58	:  1110_0000  0xE0  224    
  59	:  1001_0010  0x92  146    
  60	:  1100_0000  0xC0  192    
  61	:  0000_1100  0x0C   12    
  62	:  0000_0000  0x00    0    
  63	:  0000_0001  0x01    1    
  64	:  0000_0000  0x00    0    
  65	:  0000_0001  0x01    1    
  66	:  0000_0000  0x00    0    
  67	:  0000_0000  0x00    0    
  68	:  0000_0001  0x01    1    
  69	:  0001_0101  0x15   21    
  70	:  0000_0000  0x00    0    
  71	:  0000_0100  0x04    4    
  72	:  0100_1010  0x4A   74  J  
  73	:  0111_1101  0x7D  125  }  
  74	:  1110_0000  0xE0  224    
  75	:  1001_0011  0x93  147    
  76	:  1100_0000  0xC0  192    
  77	:  0000_1100  0x0C   12    
  78	:  0000_0000  0x00    0    
  79	:  0000_0001  0x01    1    
  80	:  0000_0000  0x00    0    
  81	:  0000_0001  0x01    1    
  82	:  0000_0000  0x00    0    
  83	:  0000_0000  0x00    0    
  84	:  0000_0001  0x01    1    
  85	:  0001_0101  0x15   21    
  86	:  0000_0000  0x00    0    
  87	:  0000_0100  0x04    4    
  88	:  0100_1010  0x4A   74  J  
  89	:  0111_1101  0x7D  125  }  
  90	:  1110_0000  0xE0  224    
  91	:  1001_0100  0x94  148    
  92	:  1100_0000  0xC0  192    
  93	:  0000_1100  0x0C   12    
  94	:  0000_0000  0x00    0    
  95	:  0000_0001  0x01    1    
  96	:  0000_0000  0x00    0    
  97	:  0000_0001  0x01    1    
  98	:  0000_0000  0x00    0    
  99	:  0000_0000  0x00    0    
  100	:  0000_0001  0x01    1    
  101	:  0001_0101  0x15   21    
  102	:  0000_0000  0x00    0    
  103	:  0000_0100  0x04    4    
  104	:  0100_1010  0x4A   74  J  
  105	:  0111_1101  0x7D  125  }  
  106	:  1110_0000  0xE0  224    
  107	:  1001_0000  0x90  144    
  108	:  1100_0000  0xC0  192    
  109	:  0000_1100  0x0C   12    
  110	:  0000_0000  0x00    0    
  111	:  0000_0010  0x02    2    
  112	:  0000_0000  0x00    0    
  113	:  0000_0001  0x01    1    
  114	:  0000_0000  0x00    0    
  115	:  0000_0000  0x00    0    
  116	:  1100_1111  0xCF  207    
  117	:  1001_1011  0x9B  155    
  118	:  0000_0000  0x00    0    
  119	:  0000_0110  0x06    6    
  120	:  0000_0011  0x03    3    
  121	:  0110_1110  0x6E  110  n  
  122	:  0111_0011  0x73  115  s  
  123	:  0011_0010  0x32   50  2  
  124	:  1100_0000  0xC0  192    
  125	:  0000_1100  0x0C   12    
  126	:  1100_0000  0xC0  192    
  127	:  0000_1100  0x0C   12    
  128	:  0000_0000  0x00    0    
  129	:  0000_0010  0x02    2    
  130	:  0000_0000  0x00    0    
  131	:  0000_0001  0x01    1    
  132	:  0000_0000  0x00    0    
  133	:  0000_0000  0x00    0    
  134	:  1100_1111  0xCF  207    
  135	:  1001_1011  0x9B  155    
  136	:  0000_0000  0x00    0    
  137	:  0000_0110  0x06    6    
  138	:  0000_0011  0x03    3    
  139	:  0110_1110  0x6E  110  n  
  140	:  0111_0011  0x73  115  s  
  141	:  0011_0001  0x31   49  1  
  142	:  1100_0000  0xC0  192    
  143	:  0000_1100  0x0C   12    
  144	:  1100_0000  0xC0  192    
  145	:  0000_1100  0x0C   12    
  146	:  0000_0000  0x00    0    
  147	:  0000_0010  0x02    2    
  148	:  0000_0000  0x00    0    
  149	:  0000_0001  0x01    1    
  150	:  0000_0000  0x00    0    
  151	:  0000_0000  0x00    0    
  152	:  1100_1111  0xCF  207    
  153	:  1001_1011  0x9B  155    
  154	:  0000_0000  0x00    0    
  155	:  0000_0110  0x06    6    
  156	:  0000_0011  0x03    3    
  157	:  0110_1110  0x6E  110  n  
  158	:  0111_0011  0x73  115  s  
  159	:  0011_0100  0x34   52  4  
  160	:  1100_0000  0xC0  192    
  161	:  0000_1100  0x0C   12    
  162	:  1100_0000  0xC0  192    
  163	:  0000_1100  0x0C   12    
  164	:  0000_0000  0x00    0    
  165	:  0000_0010  0x02    2    
  166	:  0000_0000  0x00    0    
  167	:  0000_0001  0x01    1    
  168	:  0000_0000  0x00    0    
  169	:  0000_0000  0x00    0    
  170	:  1100_1111  0xCF  207    
  171	:  1001_1011  0x9B  155    
  172	:  0000_0000  0x00    0    
  173	:  0000_0110  0x06    6    
  174	:  0000_0011  0x03    3    
  175	:  0110_1110  0x6E  110  n  
  176	:  0111_0011  0x73  115  s  
  177	:  0011_0011  0x33   51  3  
  178	:  1100_0000  0xC0  192    
  179	:  0000_1100  0x0C   12    
  180	:  1100_0000  0xC0  192    
  181	:  1000_1010  0x8A  138    
  182	:  0000_0000  0x00    0    
  183	:  0000_0001  0x01    1    
  184	:  0000_0000  0x00    0    
  185	:  0000_0001  0x01    1    
  186	:  0000_0000  0x00    0    
  187	:  0000_0011  0x03    3    
  188	:  0111_0010  0x72  114  r  
  189	:  1001_1100  0x9C  156    
  190	:  0000_0000  0x00    0    
  191	:  0000_0100  0x04    4    
  192	:  1101_1000  0xD8  216    
  193	:  1110_1111  0xEF  239    
  194	:  0010_0000  0x20   32     
  195	:  0000_1010  0x0A   10    
  196	:  1100_0000  0xC0  192    
  197	:  0111_1000  0x78  120  x  
  198	:  0000_0000  0x00    0    
  199	:  0000_0001  0x01    1    
  200	:  0000_0000  0x00    0    
  201	:  0000_0001  0x01    1    
  202	:  0000_0000  0x00    0    
  203	:  0000_0011  0x03    3    
  204	:  0111_0010  0x72  114  r  
  205	:  1001_1100  0x9C  156    
  206	:  0000_0000  0x00    0    
  207	:  0000_0100  0x04    4    
  208	:  1101_1000  0xD8  216    
  209	:  1110_1111  0xEF  239    
  210	:  0010_0010  0x22   34  "  
  211	:  0000_1010  0x0A   10    
  212	:  1100_0000  0xC0  192    
  213	:  1010_1110  0xAE  174    
  214	:  0000_0000  0x00    0    
  215	:  0000_0001  0x01    1    
  216	:  0000_0000  0x00    0    
  217	:  0000_0001  0x01    1    
  218	:  0000_0000  0x00    0    
  219	:  0000_0011  0x03    3    
  220	:  0111_0010  0x72  114  r  
  221	:  1001_1100  0x9C  156    
  222	:  0000_0000  0x00    0    
  223	:  0000_0100  0x04    4    
  224	:  1101_1000  0xD8  216    
  225	:  1110_1111  0xEF  239    
  226	:  0010_0100  0x24   36  $  
  227	:  0000_1010  0x0A   10    
  228	:  1100_0000  0xC0  192    
  229	:  1001_1100  0x9C  156    
  230	:  0000_0000  0x00    0    
  231	:  0000_0001  0x01    1    
  232	:  0000_0000  0x00    0    
  233	:  0000_0001  0x01    1    
  234	:  0000_0000  0x00    0    
  235	:  0000_0011  0x03    3    
  236	:  0111_0010  0x72  114  r  
  237	:  1001_1100  0x9C  156    
  238	:  0000_0000  0x00    0    
  239	:  0000_0100  0x04    4    
  240	:  1101_1000  0xD8  216    
  241	:  1110_1111  0xEF  239    
  242	:  0010_0110  0x26   38  &  
  243	:  0000_1010  0x0A   10    |;

# ; <<>> dig.pl 1.10 <<>> -d google.com
# ;;
# ;; Got answer.
# ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 14498
# ;; flags: qr rd ra; QUERY: 1, ANSWER: 5, AUTHORITY: 4, ADDITIONAL: 4
# 
# ;; QUESTION SECTION:
# ;google.com.		IN	A
# 
# ;; ANSWER SECTION:
# google.com.	277	IN	A	74.125.224.145 
# google.com.	277	IN	A	74.125.224.146 
# google.com.	277	IN	A	74.125.224.147 
# google.com.	277	IN	A	74.125.224.148 
# google.com.	277	IN	A	74.125.224.144 
# 
# ;; AUTHORITY SECTION:
# google.com.	53147	IN	NS	ns2.google.com. 
# google.com.	53147	IN	NS	ns1.google.com. 
# google.com.	53147	IN	NS	ns4.google.com. 
# google.com.	53147	IN	NS	ns3.google.com. 
# 
# ;; ADDITIONAL SECTION:
# ns1.google.com.	225948	IN	A	216.239.32.10 
# ns2.google.com.	225948	IN	A	216.239.34.10 
# ns3.google.com.	225948	IN	A	216.239.36.10 
# ns4.google.com.	225948	IN	A	216.239.38.10 
# 
# ;; Query time: 51 ms
# ;; SERVER: 192.168.1.171# 53(192.168.1.171)
# ;; WHEN: Sun Oct  2 19:47:50 2011
# ;; MSG SIZE rcvd: 244 -- XFR size: 14 records
# 

# input:	data pointer
# returns:	pointer to query buffer
#
sub makebuf {
  my $dp = shift;
  my @data = split("\n",$$dp);
  my $off = 0;
  my $buffer = '';
  foreach (@data) {
    $_ =~ /0x.{2}\s+(\d+)/;
    $off = put1char(\$buffer,$off,$1);
  }
  return \$buffer;
}

{
	undef local $^W;
	*Net::DNS::Dig::ndd_gethostbyname2 = \&mygethostbyname2;
	*Net::DNS::Dig::ndd_gethostbyname = \&mygethostbyname;
	*Net::DNS::Dig::ndd_gethostbyaddr = \&mygethostbyaddr;
	*Net::DNS::Dig::_query = \&myquery;
	*Net::DNS::Dig::_tquery = \&myquery;
	*Net::DNS::Dig::_elapsed = \&myelapsed;
}

# dummy localtime
sub localtime {
  return 'Mon Oct  3 13:41:57 2011';
}

# dummy mygethostbyname
sub mygethostbyname {
  return inet_aton('97.65.43.21') if $_[0] =~ /[a-zA-Z]/;	# is a name
  return inet_aton($_[0]);				# else decode IP address
}

# dummy mygethostbyname2
sub mygethostbyname2 {
  die "$_[0] - BAD BRANCH\n";
}

# dummy mygethostbyaddr
sub mygethostbyaddr {
  return 'my.test.domain.com';
}

# dummy elapsed
sub myelapsed {
  my($self) = @_;
  $self->{ELAPSED} = 45;
}

my $myrptr;
my $mybptr;

# dummy query processor
sub myquery {
  my($self,$bp) = @_;
  $$bp = $$mybptr;
  return $myrptr;
}

my $ap = makebuf(\$ans);
my $qp = makebuf(\$ques);

my($get,$put,$parse) = new Net::DNS::ToolKit::RR;

Net::DNS::Dig::_set_NS(inet_aton('12.34.56.78'),inet_aton('23.45.67.89'));

## test 2	check object contents
my $dig = new Net::DNS::Dig;
$dig->{PeerAddr} = ['2.3.4.5'];
set_names($dig);
$myrptr = $ap;
$mybptr = $qp;
my $rp = $dig->for('dummyname','a');
my $exp = q|141	= {
	'ADDITIONAL'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'ns1.google.com',
		'RDATA'	=> [' 
	',],
		'RDLEN'	=> 4,
		'TTL'	=> 225948,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns2.google.com',
		'RDATA'	=> ['"
	',],
		'RDLEN'	=> 4,
		'TTL'	=> 225948,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns3.google.com',
		'RDATA'	=> ['$
	',],
		'RDLEN'	=> 4,
		'TTL'	=> 225948,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns4.google.com',
		'RDATA'	=> ['&
	',],
		'RDLEN'	=> 4,
		'TTL'	=> 225948,
		'TYPE'	=> 1,
	},
],
	'ANSWER'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['J}',],
		'RDLEN'	=> 4,
		'TTL'	=> 277,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['J}',],
		'RDLEN'	=> 4,
		'TTL'	=> 277,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['J}',],
		'RDLEN'	=> 4,
		'TTL'	=> 277,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['J}',],
		'RDLEN'	=> 4,
		'TTL'	=> 277,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['J}',],
		'RDLEN'	=> 4,
		'TTL'	=> 277,
		'TYPE'	=> 1,
	},
],
	'AUTHORITY'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['ns2.google.com',],
		'RDLEN'	=> 6,
		'TTL'	=> 53147,
		'TYPE'	=> 2,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['ns1.google.com',],
		'RDLEN'	=> 6,
		'TTL'	=> 53147,
		'TYPE'	=> 2,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['ns4.google.com',],
		'RDLEN'	=> 6,
		'TTL'	=> 53147,
		'TYPE'	=> 2,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'RDATA'	=> ['ns3.google.com',],
		'RDLEN'	=> 6,
		'TTL'	=> 53147,
		'TYPE'	=> 2,
	},
],
	'BYTES'	=> 244,
	'Class'	=> 'IN',
	'ELAPSED'	=> 45,
	'HEADER'	=> {
		'AA'	=> 0,
		'AD'	=> 0,
		'ANCOUNT'	=> 5,
		'ARCOUNT'	=> 4,
		'CD'	=> 0,
		'ID'	=> 14498,
		'MBZ'	=> 0,
		'NSCOUNT'	=> 4,
		'OPCODE'	=> 0,
		'QDCOUNT'	=> 1,
		'QR'	=> 1,
		'RA'	=> 1,
		'RCODE'	=> 0,
		'RD'	=> 1,
		'TC'	=> 0,
	},
	'NRECS'	=> 14,
	'PeerAddr'	=> ['2.3.4.5',],
	'PeerPort'	=> 53,
	'Proto'	=> 'UDP',
	'QUESTION'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'google.com',
		'TYPE'	=> 1,
	},
],
	'Recursion'	=> 1,
	'SERVER'	=> '2.3.4.5',
	'Timeout'	=> 15,
	'_SS'	=> {
		'2.3.4.5'	=> '',
	},
};
|;

#print MyTest::Dumper($dig);
my $got = MyTest::Dumper($dig);
print "dig_for failed\ngot: $got\nexp: $exp\nnot "
	unless $got eq $exp;
&ok;

my $ques3 = q
| 0	:  0101_0010  0x52   82  R  
  1	:  1001_0101  0x95  149    
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0111  0x07    7    
  13	:  0110_0101  0x65  101  e  
  14	:  0111_1000  0x78  120  x  
  15	:  0110_0001  0x61   97  a  
  16	:  0110_1101  0x6D  109  m  
  17	:  0111_0000  0x70  112  p  
  18	:  0110_1100  0x6C  108  l  
  19	:  0110_0101  0x65  101  e  
  20	:  0000_0011  0x03    3    
  21	:  0110_0011  0x63   99  c  
  22	:  0110_1111  0x6F  111  o  
  23	:  0110_1101  0x6D  109  m  
  24	:  0000_0000  0x00    0    
  25	:  0000_0000  0x00    0    
  26	:  1111_1100  0xFC  252    
  27	:  0000_0000  0x00    0    
  28	:  0000_0001  0x01    1    |;

my $ans3 = q
| 0	:  0101_0010  0x52   82  R  
  1	:  1001_0101  0x95  149    
  2	:  1000_0101  0x85  133    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0011_0110  0x36   54  6  
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0111  0x07    7    
  13	:  0110_0101  0x65  101  e  
  14	:  0111_1000  0x78  120  x  
  15	:  0110_0001  0x61   97  a  
  16	:  0110_1101  0x6D  109  m  
  17	:  0111_0000  0x70  112  p  
  18	:  0110_1100  0x6C  108  l  
  19	:  0110_0101  0x65  101  e  
  20	:  0000_0011  0x03    3    
  21	:  0110_0011  0x63   99  c  
  22	:  0110_1111  0x6F  111  o  
  23	:  0110_1101  0x6D  109  m  
  24	:  0000_0000  0x00    0    
  25	:  0000_0000  0x00    0    
  26	:  1111_1100  0xFC  252    
  27	:  0000_0000  0x00    0    
  28	:  0000_0001  0x01    1    
  29	:  1100_0000  0xC0  192    
  30	:  0000_1100  0x0C   12    
  31	:  0000_0000  0x00    0    
  32	:  0000_0110  0x06    6    
  33	:  0000_0000  0x00    0    
  34	:  0000_0001  0x01    1    
  35	:  0000_0000  0x00    0    
  36	:  0000_0000  0x00    0    
  37	:  0010_1010  0x2A   42  *  
  38	:  0011_0000  0x30   48  0  
  39	:  0000_0000  0x00    0    
  40	:  0011_0000  0x30   48  0  
  41	:  0000_0101  0x05    5    
  42	:  0110_1110  0x6E  110  n  
  43	:  0110_0001  0x61   97  a  
  44	:  0110_1101  0x6D  109  m  
  45	:  0110_0101  0x65  101  e  
  46	:  0111_0011  0x73  115  s  
  47	:  0000_0111  0x07    7    
  48	:  0110_0101  0x65  101  e  
  49	:  0111_1000  0x78  120  x  
  50	:  0110_0001  0x61   97  a  
  51	:  0110_1101  0x6D  109  m  
  52	:  0111_0000  0x70  112  p  
  53	:  0110_1100  0x6C  108  l  
  54	:  0110_0101  0x65  101  e  
  55	:  0000_0011  0x03    3    
  56	:  0110_1110  0x6E  110  n  
  57	:  0110_0101  0x65  101  e  
  58	:  0111_0100  0x74  116  t  
  59	:  0000_0000  0x00    0    
  60	:  0000_0110  0x06    6    
  61	:  0111_0011  0x73  115  s  
  62	:  0111_1001  0x79  121  y  
  63	:  0111_0011  0x73  115  s  
  64	:  0110_0001  0x61   97  a  
  65	:  0110_0100  0x64  100  d  
  66	:  0110_1101  0x6D  109  m  
  67	:  1100_0000  0xC0  192    
  68	:  0000_1100  0x0C   12    
  69	:  0111_0111  0x77  119  w  
  70	:  1101_1110  0xDE  222    
  71	:  1111_0100  0xF4  244    
  72	:  1111_0110  0xF6  246    
  73	:  0000_0000  0x00    0    
  74	:  0000_0000  0x00    0    
  75	:  1010_1000  0xA8  168    
  76	:  1100_0000  0xC0  192    
  77	:  0000_0000  0x00    0    
  78	:  0000_0000  0x00    0    
  79	:  0000_1110  0x0E   14    
  80	:  0001_0000  0x10   16    
  81	:  0000_0000  0x00    0    
  82	:  0000_0011  0x03    3    
  83	:  1111_0100  0xF4  244    
  84	:  1000_0000  0x80  128    
  85	:  0000_0000  0x00    0    
  86	:  0000_0000  0x00    0    
  87	:  0010_1010  0x2A   42  *  
  88	:  0011_0000  0x30   48  0  
  89	:  1100_0000  0xC0  192    
  90	:  0000_1100  0x0C   12    
  91	:  0000_0000  0x00    0    
  92	:  0000_0010  0x02    2    
  93	:  0000_0000  0x00    0    
  94	:  0000_0001  0x01    1    
  95	:  0000_0000  0x00    0    
  96	:  0000_0000  0x00    0    
  97	:  0010_1010  0x2A   42  *  
  98	:  0011_0000  0x30   48  0  
  99	:  0000_0000  0x00    0    
  100	:  0000_0110  0x06    6    
  101	:  0000_0011  0x03    3    
  102	:  0110_1110  0x6E  110  n  
  103	:  0111_0011  0x73  115  s  
  104	:  0011_0001  0x31   49  1  
  105	:  1100_0000  0xC0  192    
  106	:  0000_1100  0x0C   12    
  107	:  1100_0000  0xC0  192    
  108	:  0000_1100  0x0C   12    
  109	:  0000_0000  0x00    0    
  110	:  0000_0010  0x02    2    
  111	:  0000_0000  0x00    0    
  112	:  0000_0001  0x01    1    
  113	:  0000_0000  0x00    0    
  114	:  0000_0000  0x00    0    
  115	:  0010_1010  0x2A   42  *  
  116	:  0011_0000  0x30   48  0  
  117	:  0000_0000  0x00    0    
  118	:  0000_0110  0x06    6    
  119	:  0000_0011  0x03    3    
  120	:  0110_1110  0x6E  110  n  
  121	:  0111_0011  0x73  115  s  
  122	:  0011_0000  0x30   48  0  
  123	:  1100_0000  0xC0  192    
  124	:  0000_1100  0x0C   12    
  125	:  1100_0000  0xC0  192    
  126	:  0000_1100  0x0C   12    
  127	:  0000_0000  0x00    0    
  128	:  0000_0001  0x01    1    
  129	:  0000_0000  0x00    0    
  130	:  0000_0001  0x01    1    
  131	:  0000_0000  0x00    0    
  132	:  0000_0000  0x00    0    
  133	:  0010_1010  0x2A   42  *  
  134	:  0011_0000  0x30   48  0  
  135	:  0000_0000  0x00    0    
  136	:  0000_0100  0x04    4    
  137	:  1101_0011  0xD3  211    
  138	:  1110_0111  0xE7  231    
  139	:  1001_0001  0x91  145    
  140	:  1110_1000  0xE8  232    
  141	:  1100_0000  0xC0  192    
  142	:  0000_1100  0x0C   12    
  143	:  0000_0000  0x00    0    
  144	:  0000_1111  0x0F   15    
  145	:  0000_0000  0x00    0    
  146	:  0000_0001  0x01    1    
  147	:  0000_0000  0x00    0    
  148	:  0000_0000  0x00    0    
  149	:  0010_1010  0x2A   42  *  
  150	:  0011_0000  0x30   48  0  
  151	:  0000_0000  0x00    0    
  152	:  0000_1000  0x08    8    
  153	:  0000_0000  0x00    0    
  154	:  0000_1010  0x0A   10    
  155	:  0000_0011  0x03    3    
  156	:  0110_1101  0x6D  109  m  
  157	:  0111_1000  0x78  120  x  
  158	:  0011_0001  0x31   49  1  
  159	:  1100_0000  0xC0  192    
  160	:  0000_1100  0x0C   12    
  161	:  1100_0000  0xC0  192    
  162	:  0000_1100  0x0C   12    
  163	:  0000_0000  0x00    0    
  164	:  0000_1111  0x0F   15    
  165	:  0000_0000  0x00    0    
  166	:  0000_0001  0x01    1    
  167	:  0000_0000  0x00    0    
  168	:  0000_0000  0x00    0    
  169	:  0010_1010  0x2A   42  *  
  170	:  0011_0000  0x30   48  0  
  171	:  0000_0000  0x00    0    
  172	:  0000_1000  0x08    8    
  173	:  0000_0000  0x00    0    
  174	:  0011_0010  0x32   50  2  
  175	:  0000_0011  0x03    3    
  176	:  0110_1101  0x6D  109  m  
  177	:  0111_1000  0x78  120  x  
  178	:  0011_0010  0x32   50  2  
  179	:  1100_0000  0xC0  192    
  180	:  0000_1100  0x0C   12    
  181	:  1100_0000  0xC0  192    
  182	:  0000_1100  0x0C   12    
  183	:  0000_0000  0x00    0    
  184	:  0000_1111  0x0F   15    
  185	:  0000_0000  0x00    0    
  186	:  0000_0001  0x01    1    
  187	:  0000_0000  0x00    0    
  188	:  0000_0000  0x00    0    
  189	:  0010_1010  0x2A   42  *  
  190	:  0011_0000  0x30   48  0  
  191	:  0000_0000  0x00    0    
  192	:  0000_1000  0x08    8    
  193	:  0000_0000  0x00    0    
  194	:  0110_0100  0x64  100  d  
  195	:  0000_0011  0x03    3    
  196	:  0110_1101  0x6D  109  m  
  197	:  0111_1000  0x78  120  x  
  198	:  0011_0011  0x33   51  3  
  199	:  1100_0000  0xC0  192    
  200	:  0000_1100  0x0C   12    
  201	:  0000_1010  0x0A   10    
  202	:  0111_0011  0x73  115  s  
  203	:  0111_0100  0x74  116  t  
  204	:  0111_0010  0x72  114  r  
  205	:  0110_1111  0x6F  111  o  
  206	:  0110_1110  0x6E  110  n  
  207	:  0110_0111  0x67  103  g  
  208	:  0110_1000  0x68  104  h  
  209	:  0110_1111  0x6F  111  o  
  210	:  0110_1100  0x6C  108  l  
  211	:  0110_0100  0x64  100  d  
  212	:  1100_0000  0xC0  192    
  213	:  0000_1100  0x0C   12    
  214	:  0000_0000  0x00    0    
  215	:  0000_0101  0x05    5    
  216	:  0000_0000  0x00    0    
  217	:  0000_0001  0x01    1    
  218	:  0000_0000  0x00    0    
  219	:  0000_0000  0x00    0    
  220	:  0010_1010  0x2A   42  *  
  221	:  0011_0000  0x30   48  0  
  222	:  0000_0000  0x00    0    
  223	:  0000_0010  0x02    2    
  224	:  1100_0000  0xC0  192    
  225	:  0110_0101  0x65  101  e  
  226	:  0000_0011  0x03    3    
  227	:  0110_0110  0x66  102  f  
  228	:  0111_0100  0x74  116  t  
  229	:  0111_0000  0x70  112  p  
  230	:  1100_0000  0xC0  192    
  231	:  0000_1100  0x0C   12    
  232	:  0000_0000  0x00    0    
  233	:  0000_0101  0x05    5    
  234	:  0000_0000  0x00    0    
  235	:  0000_0001  0x01    1    
  236	:  0000_0000  0x00    0    
  237	:  0000_0000  0x00    0    
  238	:  0010_1010  0x2A   42  *  
  239	:  0011_0000  0x30   48  0  
  240	:  0000_0000  0x00    0    
  241	:  0000_0010  0x02    2    
  242	:  1100_0000  0xC0  192    
  243	:  0110_0101  0x65  101  e  
  244	:  0000_0100  0x04    4    
  245	:  0110_1000  0x68  104  h  
  246	:  0110_1111  0x6F  111  o  
  247	:  0110_1101  0x6D  109  m  
  248	:  0110_0101  0x65  101  e  
  249	:  1100_0000  0xC0  192    
  250	:  0000_1100  0x0C   12    
  251	:  0000_0000  0x00    0    
  252	:  0000_0101  0x05    5    
  253	:  0000_0000  0x00    0    
  254	:  0000_0001  0x01    1    
  255	:  0000_0000  0x00    0    
  256	:  0000_0000  0x00    0    
  257	:  0010_1010  0x2A   42  *  
  258	:  0011_0000  0x30   48  0  
  259	:  0000_0000  0x00    0    
  260	:  0000_0010  0x02    2    
  261	:  1100_0000  0xC0  192    
  262	:  0110_0101  0x65  101  e  
  263	:  0000_0010  0x02    2    
  264	:  0110_1100  0x6C  108  l  
  265	:  0110_0010  0x62   98  b  
  266	:  1100_0000  0xC0  192    
  267	:  0000_1100  0x0C   12    
  268	:  0000_0000  0x00    0    
  269	:  0000_0101  0x05    5    
  270	:  0000_0000  0x00    0    
  271	:  0000_0001  0x01    1    
  272	:  0000_0000  0x00    0    
  273	:  0000_0000  0x00    0    
  274	:  0010_1010  0x2A   42  *  
  275	:  0011_0000  0x30   48  0  
  276	:  0000_0000  0x00    0    
  277	:  0000_1100  0x0C   12    
  278	:  0000_1001  0x09    9    
  279	:  0110_1100  0x6C  108  l  
  280	:  0110_1111  0x6F  111  o  
  281	:  0110_0011  0x63   99  c  
  282	:  0110_0001  0x61   97  a  
  283	:  0110_1100  0x6C  108  l  
  284	:  0110_1000  0x68  104  h  
  285	:  0110_1111  0x6F  111  o  
  286	:  0111_0011  0x73  115  s  
  287	:  0111_0100  0x74  116  t  
  288	:  1100_0000  0xC0  192    
  289	:  0000_1100  0x0C   12    
  290	:  1100_0001  0xC1  193    
  291	:  0001_0110  0x16   22    
  292	:  0000_0000  0x00    0    
  293	:  0000_0001  0x01    1    
  294	:  0000_0000  0x00    0    
  295	:  0000_0001  0x01    1    
  296	:  0000_0000  0x00    0    
  297	:  0000_0000  0x00    0    
  298	:  0010_1010  0x2A   42  *  
  299	:  0011_0000  0x30   48  0  
  300	:  0000_0000  0x00    0    
  301	:  0000_0100  0x04    4    
  302	:  0111_1111  0x7F  127    
  303	:  0000_0000  0x00    0    
  304	:  0000_0000  0x00    0    
  305	:  0000_0001  0x01    1    
  306	:  0000_1000  0x08    8    
  307	:  0110_1100  0x6C  108  l  
  308	:  0110_1111  0x6F  111  o  
  309	:  0110_1111  0x6F  111  o  
  310	:  0111_0000  0x70  112  p  
  311	:  0110_0010  0x62   98  b  
  312	:  0110_0001  0x61   97  a  
  313	:  0110_0011  0x63   99  c  
  314	:  0110_1011  0x6B  107  k  
  315	:  1100_0000  0xC0  192    
  316	:  0000_1100  0x0C   12    
  317	:  0000_0000  0x00    0    
  318	:  0000_0101  0x05    5    
  319	:  0000_0000  0x00    0    
  320	:  0000_0001  0x01    1    
  321	:  0000_0000  0x00    0    
  322	:  0000_0000  0x00    0    
  323	:  0010_1010  0x2A   42  *  
  324	:  0011_0000  0x30   48  0  
  325	:  0000_0000  0x00    0    
  326	:  0000_0010  0x02    2    
  327	:  1100_0001  0xC1  193    
  328	:  0001_0110  0x16   22    
  329	:  1100_0000  0xC0  192    
  330	:  1001_1011  0x9B  155    
  331	:  0000_0000  0x00    0    
  332	:  0000_0001  0x01    1    
  333	:  0000_0000  0x00    0    
  334	:  0000_0001  0x01    1    
  335	:  0000_0000  0x00    0    
  336	:  0000_0000  0x00    0    
  337	:  0010_1010  0x2A   42  *  
  338	:  0011_0000  0x30   48  0  
  339	:  0000_0000  0x00    0    
  340	:  0000_0100  0x04    4    
  341	:  0001_1100  0x1C   28    
  342	:  0000_0010  0x02    2    
  343	:  0100_0011  0x43   67  C  
  344	:  0011_0010  0x32   50  2  
  345	:  1100_0000  0xC0  192    
  346	:  1001_1011  0x9B  155    
  347	:  0000_0000  0x00    0    
  348	:  0000_1111  0x0F   15    
  349	:  0000_0000  0x00    0    
  350	:  0000_0001  0x01    1    
  351	:  0000_0000  0x00    0    
  352	:  0000_0000  0x00    0    
  353	:  0010_1010  0x2A   42  *  
  354	:  0011_0000  0x30   48  0  
  355	:  0000_0000  0x00    0    
  356	:  0000_0100  0x04    4    
  357	:  0000_0000  0x00    0    
  358	:  0000_1010  0x0A   10    
  359	:  1100_0000  0xC0  192    
  360	:  1001_1011  0x9B  155    
  361	:  1100_0000  0xC0  192    
  362	:  1001_1011  0x9B  155    
  363	:  0000_0000  0x00    0    
  364	:  0001_0000  0x10   16    
  365	:  0000_0000  0x00    0    
  366	:  0000_0001  0x01    1    
  367	:  0000_0000  0x00    0    
  368	:  0000_0000  0x00    0    
  369	:  0010_1010  0x2A   42  *  
  370	:  0011_0000  0x30   48  0  
  371	:  0000_0000  0x00    0    
  372	:  0000_1110  0x0E   14    
  373	:  0000_1101  0x0D   13    
  374	:  0111_0110  0x76  118  v  
  375	:  0011_1101  0x3D   61  =  
  376	:  0111_0011  0x73  115  s  
  377	:  0111_0000  0x70  112  p  
  378	:  0110_0110  0x66  102  f  
  379	:  0011_0001  0x31   49  1  
  380	:  0010_0000  0x20   32     
  381	:  0110_0001  0x61   97  a  
  382	:  0010_0000  0x20   32     
  383	:  0010_1101  0x2D   45  -  
  384	:  0110_0001  0x61   97  a  
  385	:  0110_1100  0x6C  108  l  
  386	:  0110_1100  0x6C  108  l  
  387	:  1100_0000  0xC0  192    
  388	:  0110_0101  0x65  101  e  
  389	:  0000_0000  0x00    0    
  390	:  0000_0001  0x01    1    
  391	:  0000_0000  0x00    0    
  392	:  0000_0001  0x01    1    
  393	:  0000_0000  0x00    0    
  394	:  0000_0000  0x00    0    
  395	:  0010_1010  0x2A   42  *  
  396	:  0011_0000  0x30   48  0  
  397	:  0000_0000  0x00    0    
  398	:  0000_0100  0x04    4    
  399	:  0011_0011  0x33   51  3  
  400	:  1110_0111  0xE7  231    
  401	:  0001_0010  0x12   18    
  402	:  1001_0010  0x92  146    
  403	:  1100_0000  0xC0  192    
  404	:  0110_0101  0x65  101  e  
  405	:  0000_0000  0x00    0    
  406	:  0000_1111  0x0F   15    
  407	:  0000_0000  0x00    0    
  408	:  0000_0001  0x01    1    
  409	:  0000_0000  0x00    0    
  410	:  0000_0000  0x00    0    
  411	:  0010_1010  0x2A   42  *  
  412	:  0011_0000  0x30   48  0  
  413	:  0000_0000  0x00    0    
  414	:  0000_0100  0x04    4    
  415	:  0000_0000  0x00    0    
  416	:  0000_1010  0x0A   10    
  417	:  1100_0000  0xC0  192    
  418	:  1001_1011  0x9B  155    
  419	:  1100_0000  0xC0  192    
  420	:  0110_0101  0x65  101  e  
  421	:  0000_0000  0x00    0    
  422	:  0001_0000  0x10   16    
  423	:  0000_0000  0x00    0    
  424	:  0000_0001  0x01    1    
  425	:  0000_0000  0x00    0    
  426	:  0000_0000  0x00    0    
  427	:  0010_1010  0x2A   42  *  
  428	:  0011_0000  0x30   48  0  
  429	:  0000_0000  0x00    0    
  430	:  0000_1110  0x0E   14    
  431	:  0000_1101  0x0D   13    
  432	:  0111_0110  0x76  118  v  
  433	:  0011_1101  0x3D   61  =  
  434	:  0111_0011  0x73  115  s  
  435	:  0111_0000  0x70  112  p  
  436	:  0110_0110  0x66  102  f  
  437	:  0011_0001  0x31   49  1  
  438	:  0010_0000  0x20   32     
  439	:  0110_0001  0x61   97  a  
  440	:  0010_0000  0x20   32     
  441	:  0010_1101  0x2D   45  -  
  442	:  0110_0001  0x61   97  a  
  443	:  0110_1100  0x6C  108  l  
  444	:  0110_1100  0x6C  108  l  
  445	:  1100_0000  0xC0  192    
  446	:  1010_1111  0xAF  175    
  447	:  0000_0000  0x00    0    
  448	:  0000_0001  0x01    1    
  449	:  0000_0000  0x00    0    
  450	:  0000_0001  0x01    1    
  451	:  0000_0000  0x00    0    
  452	:  0000_0000  0x00    0    
  453	:  0010_1010  0x2A   42  *  
  454	:  0011_0000  0x30   48  0  
  455	:  0000_0000  0x00    0    
  456	:  0000_0100  0x04    4    
  457	:  1101_0011  0xD3  211    
  458	:  1110_0111  0xE7  231    
  459	:  1001_0001  0x91  145    
  460	:  1110_0001  0xE1  225    
  461	:  1100_0000  0xC0  192    
  462	:  1010_1111  0xAF  175    
  463	:  0000_0000  0x00    0    
  464	:  0000_1111  0x0F   15    
  465	:  0000_0000  0x00    0    
  466	:  0000_0001  0x01    1    
  467	:  0000_0000  0x00    0    
  468	:  0000_0000  0x00    0    
  469	:  0010_1010  0x2A   42  *  
  470	:  0011_0000  0x30   48  0  
  471	:  0000_0000  0x00    0    
  472	:  0000_0100  0x04    4    
  473	:  0000_0000  0x00    0    
  474	:  0000_1010  0x0A   10    
  475	:  1100_0000  0xC0  192    
  476	:  1010_1111  0xAF  175    
  477	:  1100_0000  0xC0  192    
  478	:  1010_1111  0xAF  175    
  479	:  0000_0000  0x00    0    
  480	:  0001_0000  0x10   16    
  481	:  0000_0000  0x00    0    
  482	:  0000_0001  0x01    1    
  483	:  0000_0000  0x00    0    
  484	:  0000_0000  0x00    0    
  485	:  0010_1010  0x2A   42  *  
  486	:  0011_0000  0x30   48  0  
  487	:  0000_0000  0x00    0    
  488	:  0000_1110  0x0E   14    
  489	:  0000_1101  0x0D   13    
  490	:  0111_0110  0x76  118  v  
  491	:  0011_1101  0x3D   61  =  
  492	:  0111_0011  0x73  115  s  
  493	:  0111_0000  0x70  112  p  
  494	:  0110_0110  0x66  102  f  
  495	:  0011_0001  0x31   49  1  
  496	:  0010_0000  0x20   32     
  497	:  0110_0001  0x61   97  a  
  498	:  0010_0000  0x20   32     
  499	:  0010_1101  0x2D   45  -  
  500	:  0110_0001  0x61   97  a  
  501	:  0110_1100  0x6C  108  l  
  502	:  0110_1100  0x6C  108  l  
  503	:  0000_0101  0x05    5    
  504	:  0110_1101  0x6D  109  m  
  505	:  0110_0001  0x61   97  a  
  506	:  0110_1001  0x69  105  i  
  507	:  0110_1100  0x6C  108  l  
  508	:  0011_0100  0x34   52  4  
  509	:  1100_0000  0xC0  192    
  510	:  0000_1100  0x0C   12    
  511	:  0000_0000  0x00    0    
  512	:  0000_0001  0x01    1    
  513	:  0000_0000  0x00    0    
  514	:  0000_0001  0x01    1    
  515	:  0000_0000  0x00    0    
  516	:  0000_0000  0x00    0    
  517	:  0010_1010  0x2A   42  *  
  518	:  0011_0000  0x30   48  0  
  519	:  0000_0000  0x00    0    
  520	:  0000_0100  0x04    4    
  521	:  0001_1100  0x1C   28    
  522	:  0000_0010  0x02    2    
  523	:  0100_0011  0x43   67  C  
  524	:  0011_0011  0x33   51  3  
  525	:  1100_0001  0xC1  193    
  526	:  1111_0111  0xF7  247    
  527	:  0000_0000  0x00    0    
  528	:  0000_1111  0x0F   15    
  529	:  0000_0000  0x00    0    
  530	:  0000_0001  0x01    1    
  531	:  0000_0000  0x00    0    
  532	:  0000_0000  0x00    0    
  533	:  0010_1010  0x2A   42  *  
  534	:  0011_0000  0x30   48  0  
  535	:  0000_0000  0x00    0    
  536	:  0000_0100  0x04    4    
  537	:  0000_0000  0x00    0    
  538	:  0000_1010  0x0A   10    
  539	:  1100_0001  0xC1  193    
  540	:  1111_0111  0xF7  247    
  541	:  1100_0001  0xC1  193    
  542	:  1111_0111  0xF7  247    
  543	:  0000_0000  0x00    0    
  544	:  0001_0000  0x10   16    
  545	:  0000_0000  0x00    0    
  546	:  0000_0001  0x01    1    
  547	:  0000_0000  0x00    0    
  548	:  0000_0000  0x00    0    
  549	:  0010_1010  0x2A   42  *  
  550	:  0011_0000  0x30   48  0  
  551	:  0000_0000  0x00    0    
  552	:  0000_1110  0x0E   14    
  553	:  0000_1101  0x0D   13    
  554	:  0111_0110  0x76  118  v  
  555	:  0011_1101  0x3D   61  =  
  556	:  0111_0011  0x73  115  s  
  557	:  0111_0000  0x70  112  p  
  558	:  0110_0110  0x66  102  f  
  559	:  0011_0001  0x31   49  1  
  560	:  0010_0000  0x20   32     
  561	:  0110_0001  0x61   97  a  
  562	:  0010_0000  0x20   32     
  563	:  0010_1101  0x2D   45  -  
  564	:  0110_0001  0x61   97  a  
  565	:  0110_1100  0x6C  108  l  
  566	:  0110_1100  0x6C  108  l  
  567	:  0000_0101  0x05    5    
  568	:  0110_1101  0x6D  109  m  
  569	:  0110_0001  0x61   97  a  
  570	:  0110_1001  0x69  105  i  
  571	:  0110_1100  0x6C  108  l  
  572	:  0011_0001  0x31   49  1  
  573	:  1100_0000  0xC0  192    
  574	:  0000_1100  0x0C   12    
  575	:  0000_0000  0x00    0    
  576	:  0000_0001  0x01    1    
  577	:  0000_0000  0x00    0    
  578	:  0000_0001  0x01    1    
  579	:  0000_0000  0x00    0    
  580	:  0000_0000  0x00    0    
  581	:  0010_1010  0x2A   42  *  
  582	:  0011_0000  0x30   48  0  
  583	:  0000_0000  0x00    0    
  584	:  0000_0100  0x04    4    
  585	:  1101_0011  0xD3  211    
  586	:  1110_0111  0xE7  231    
  587	:  1001_0001  0x91  145    
  588	:  1110_0010  0xE2  226    
  589	:  1100_0010  0xC2  194    
  590	:  0011_0111  0x37   55  7  
  591	:  0000_0000  0x00    0    
  592	:  0001_0000  0x10   16    
  593	:  0000_0000  0x00    0    
  594	:  0000_0001  0x01    1    
  595	:  0000_0000  0x00    0    
  596	:  0000_0000  0x00    0    
  597	:  0010_1010  0x2A   42  *  
  598	:  0011_0000  0x30   48  0  
  599	:  0000_0000  0x00    0    
  600	:  0000_1110  0x0E   14    
  601	:  0000_1101  0x0D   13    
  602	:  0111_0110  0x76  118  v  
  603	:  0011_1101  0x3D   61  =  
  604	:  0111_0011  0x73  115  s  
  605	:  0111_0000  0x70  112  p  
  606	:  0110_0110  0x66  102  f  
  607	:  0011_0001  0x31   49  1  
  608	:  0010_0000  0x20   32     
  609	:  0110_0001  0x61   97  a  
  610	:  0010_0000  0x20   32     
  611	:  0010_1101  0x2D   45  -  
  612	:  0110_0001  0x61   97  a  
  613	:  0110_1100  0x6C  108  l  
  614	:  0110_1100  0x6C  108  l  
  615	:  1100_0010  0xC2  194    
  616	:  0011_0111  0x37   55  7  
  617	:  0000_0000  0x00    0    
  618	:  0000_0001  0x01    1    
  619	:  0000_0000  0x00    0    
  620	:  0000_0001  0x01    1    
  621	:  0000_0000  0x00    0    
  622	:  0000_0000  0x00    0    
  623	:  0010_1010  0x2A   42  *  
  624	:  0011_0000  0x30   48  0  
  625	:  0000_0000  0x00    0    
  626	:  0000_0100  0x04    4    
  627	:  0001_1100  0x1C   28    
  628	:  0000_0010  0x02    2    
  629	:  0100_0011  0x43   67  C  
  630	:  0011_1000  0x38   56  8  
  631	:  1100_0010  0xC2  194    
  632	:  0011_0111  0x37   55  7  
  633	:  0000_0000  0x00    0    
  634	:  0001_0000  0x10   16    
  635	:  0000_0000  0x00    0    
  636	:  0000_0001  0x01    1    
  637	:  0000_0000  0x00    0    
  638	:  0000_0000  0x00    0    
  639	:  0010_1010  0x2A   42  *  
  640	:  0011_0000  0x30   48  0  
  641	:  0000_0000  0x00    0    
  642	:  0000_1110  0x0E   14    
  643	:  0000_1101  0x0D   13    
  644	:  0111_0110  0x76  118  v  
  645	:  0011_1101  0x3D   61  =  
  646	:  0111_0011  0x73  115  s  
  647	:  0111_0000  0x70  112  p  
  648	:  0110_0110  0x66  102  f  
  649	:  0011_0001  0x31   49  1  
  650	:  0010_0000  0x20   32     
  651	:  0110_0001  0x61   97  a  
  652	:  0010_0000  0x20   32     
  653	:  0010_1101  0x2D   45  -  
  654	:  0110_0001  0x61   97  a  
  655	:  0110_1100  0x6C  108  l  
  656	:  0110_1100  0x6C  108  l  
  657	:  1100_0000  0xC0  192    
  658	:  1100_0011  0xC3  195    
  659	:  0000_0000  0x00    0    
  660	:  0000_0001  0x01    1    
  661	:  0000_0000  0x00    0    
  662	:  0000_0001  0x01    1    
  663	:  0000_0000  0x00    0    
  664	:  0000_0000  0x00    0    
  665	:  0010_1010  0x2A   42  *  
  666	:  0011_0000  0x30   48  0  
  667	:  0000_0000  0x00    0    
  668	:  0000_0100  0x04    4    
  669	:  0001_1100  0x1C   28    
  670	:  0000_0010  0x02    2    
  671	:  0100_0011  0x43   67  C  
  672	:  0011_0100  0x34   52  4  
  673	:  1100_0000  0xC0  192    
  674	:  1100_0011  0xC3  195    
  675	:  0000_0000  0x00    0    
  676	:  0001_0000  0x10   16    
  677	:  0000_0000  0x00    0    
  678	:  0000_0001  0x01    1    
  679	:  0000_0000  0x00    0    
  680	:  0000_0000  0x00    0    
  681	:  0010_1010  0x2A   42  *  
  682	:  0011_0000  0x30   48  0  
  683	:  0000_0000  0x00    0    
  684	:  0000_1110  0x0E   14    
  685	:  0000_1101  0x0D   13    
  686	:  0111_0110  0x76  118  v  
  687	:  0011_1101  0x3D   61  =  
  688	:  0111_0011  0x73  115  s  
  689	:  0111_0000  0x70  112  p  
  690	:  0110_0110  0x66  102  f  
  691	:  0011_0001  0x31   49  1  
  692	:  0010_0000  0x20   32     
  693	:  0110_0001  0x61   97  a  
  694	:  0010_0000  0x20   32     
  695	:  0010_1101  0x2D   45  -  
  696	:  0110_0001  0x61   97  a  
  697	:  0110_1100  0x6C  108  l  
  698	:  0110_1100  0x6C  108  l  
  699	:  0000_0010  0x02    2    
  700	:  0111_0011  0x73  115  s  
  701	:  0111_0100  0x74  116  t  
  702	:  1100_0000  0xC0  192    
  703	:  0000_1100  0x0C   12    
  704	:  0000_0000  0x00    0    
  705	:  0000_1111  0x0F   15    
  706	:  0000_0000  0x00    0    
  707	:  0000_0001  0x01    1    
  708	:  0000_0000  0x00    0    
  709	:  0000_0000  0x00    0    
  710	:  0010_1010  0x2A   42  *  
  711	:  0011_0000  0x30   48  0  
  712	:  0000_0000  0x00    0    
  713	:  0000_0100  0x04    4    
  714	:  0000_0000  0x00    0    
  715	:  0000_1010  0x0A   10    
  716	:  1100_0010  0xC2  194    
  717	:  0011_0111  0x37   55  7  
  718	:  1100_0010  0xC2  194    
  719	:  1011_1011  0xBB  187    
  720	:  0000_0000  0x00    0    
  721	:  0000_1111  0x0F   15    
  722	:  0000_0000  0x00    0    
  723	:  0000_0001  0x01    1    
  724	:  0000_0000  0x00    0    
  725	:  0000_0000  0x00    0    
  726	:  0010_1010  0x2A   42  *  
  727	:  0011_0000  0x30   48  0  
  728	:  0000_0000  0x00    0    
  729	:  0000_0100  0x04    4    
  730	:  0000_0000  0x00    0    
  731	:  0110_0100  0x64  100  d  
  732	:  1100_0000  0xC0  192    
  733	:  1100_0011  0xC3  195    
  734	:  0000_0011  0x03    3    
  735	:  0110_0100  0x64  100  d  
  736	:  0110_1110  0x6E  110  n  
  737	:  0111_0011  0x73  115  s  
  738	:  1100_0000  0xC0  192    
  739	:  0000_1100  0x0C   12    
  740	:  0000_0000  0x00    0    
  741	:  0000_0001  0x01    1    
  742	:  0000_0000  0x00    0    
  743	:  0000_0001  0x01    1    
  744	:  0000_0000  0x00    0    
  745	:  0000_0000  0x00    0    
  746	:  0010_1010  0x2A   42  *  
  747	:  0011_0000  0x30   48  0  
  748	:  0000_0000  0x00    0    
  749	:  0000_0100  0x04    4    
  750	:  0001_1100  0x1C   28    
  751	:  0000_0010  0x02    2    
  752	:  0100_0011  0x43   67  C  
  753	:  0011_0010  0x32   50  2  
  754	:  1100_0000  0xC0  192    
  755	:  0111_0111  0x77  119  w  
  756	:  0000_0000  0x00    0    
  757	:  0000_0001  0x01    1    
  758	:  0000_0000  0x00    0    
  759	:  0000_0001  0x01    1    
  760	:  0000_0000  0x00    0    
  761	:  0000_0000  0x00    0    
  762	:  0010_1010  0x2A   42  *  
  763	:  0011_0000  0x30   48  0  
  764	:  0000_0000  0x00    0    
  765	:  0000_0100  0x04    4    
  766	:  1101_0011  0xD3  211    
  767	:  1110_0111  0xE7  231    
  768	:  1001_0001  0x91  145    
  769	:  1110_0001  0xE1  225    
  770	:  1100_0000  0xC0  192    
  771	:  0111_0111  0x77  119  w  
  772	:  0000_0000  0x00    0    
  773	:  0000_1111  0x0F   15    
  774	:  0000_0000  0x00    0    
  775	:  0000_0001  0x01    1    
  776	:  0000_0000  0x00    0    
  777	:  0000_0000  0x00    0    
  778	:  0010_1010  0x2A   42  *  
  779	:  0011_0000  0x30   48  0  
  780	:  0000_0000  0x00    0    
  781	:  0000_0100  0x04    4    
  782	:  0000_0000  0x00    0    
  783	:  0000_1010  0x0A   10    
  784	:  1100_0000  0xC0  192    
  785	:  1010_1111  0xAF  175    
  786	:  1100_0000  0xC0  192    
  787	:  0111_0111  0x77  119  w  
  788	:  0000_0000  0x00    0    
  789	:  0001_0000  0x10   16    
  790	:  0000_0000  0x00    0    
  791	:  0000_0001  0x01    1    
  792	:  0000_0000  0x00    0    
  793	:  0000_0000  0x00    0    
  794	:  0010_1010  0x2A   42  *  
  795	:  0011_0000  0x30   48  0  
  796	:  0000_0000  0x00    0    
  797	:  0000_1110  0x0E   14    
  798	:  0000_1101  0x0D   13    
  799	:  0111_0110  0x76  118  v  
  800	:  0011_1101  0x3D   61  =  
  801	:  0111_0011  0x73  115  s  
  802	:  0111_0000  0x70  112  p  
  803	:  0110_0110  0x66  102  f  
  804	:  0011_0001  0x31   49  1  
  805	:  0010_0000  0x20   32     
  806	:  0110_0001  0x61   97  a  
  807	:  0010_0000  0x20   32     
  808	:  0010_1101  0x2D   45  -  
  809	:  0110_0001  0x61   97  a  
  810	:  0110_1100  0x6C  108  l  
  811	:  0110_1100  0x6C  108  l  
  812	:  0000_0100  0x04    4    
  813	:  0111_0000  0x70  112  p  
  814	:  0110_1111  0x6F  111  o  
  815	:  0111_0000  0x70  112  p  
  816	:  0011_0011  0x33   51  3  
  817	:  1100_0000  0xC0  192    
  818	:  0000_1100  0x0C   12    
  819	:  0000_0000  0x00    0    
  820	:  0000_0101  0x05    5    
  821	:  0000_0000  0x00    0    
  822	:  0000_0001  0x01    1    
  823	:  0000_0000  0x00    0    
  824	:  0000_0000  0x00    0    
  825	:  0010_1010  0x2A   42  *  
  826	:  0011_0000  0x30   48  0  
  827	:  0000_0000  0x00    0    
  828	:  0000_0010  0x02    2    
  829	:  1100_0001  0xC1  193    
  830	:  1111_0111  0xF7  247    
  831	:  0000_0110  0x06    6    
  832	:  0110_0001  0x61   97  a  
  833	:  0110_1101  0x6D  109  m  
  834	:  0110_0010  0x62   98  b  
  835	:  0110_1100  0x6C  108  l  
  836	:  0110_1001  0x69  105  i  
  837	:  0110_1110  0x6E  110  n  
  838	:  1100_0000  0xC0  192    
  839	:  0000_1100  0x0C   12    
  840	:  0000_0000  0x00    0    
  841	:  0000_0101  0x05    5    
  842	:  0000_0000  0x00    0    
  843	:  0000_0001  0x01    1    
  844	:  0000_0000  0x00    0    
  845	:  0000_0000  0x00    0    
  846	:  0010_1010  0x2A   42  *  
  847	:  0011_0000  0x30   48  0  
  848	:  0000_0000  0x00    0    
  849	:  0000_0010  0x02    2    
  850	:  1100_0000  0xC0  192    
  851	:  0010_1111  0x2F   47  /  
  852	:  0000_1010  0x0A   10    
  853	:  0110_1100  0x6C  108  l  
  854	:  0110_1001  0x69  105  i  
  855	:  0111_0100  0x74  116  t  
  856	:  0111_0100  0x74  116  t  
  857	:  0110_1100  0x6C  108  l  
  858	:  0110_0101  0x65  101  e  
  859	:  0110_0110  0x66  102  f  
  860	:  0110_1001  0x69  105  i  
  861	:  0111_0011  0x73  115  s  
  862	:  0110_1000  0x68  104  h  
  863	:  1100_0000  0xC0  192    
  864	:  0000_1100  0x0C   12    
  865	:  0000_0000  0x00    0    
  866	:  0000_0001  0x01    1    
  867	:  0000_0000  0x00    0    
  868	:  0000_0001  0x01    1    
  869	:  0000_0000  0x00    0    
  870	:  0000_0000  0x00    0    
  871	:  0010_1010  0x2A   42  *  
  872	:  0011_0000  0x30   48  0  
  873	:  0000_0000  0x00    0    
  874	:  0000_0100  0x04    4    
  875	:  0001_1100  0x1C   28    
  876	:  0000_0010  0x02    2    
  877	:  0100_0011  0x43   67  C  
  878	:  0011_0011  0x33   51  3  
  879	:  1100_0011  0xC3  195    
  880	:  0101_0100  0x54   84  T  
  881	:  0000_0000  0x00    0    
  882	:  0000_1111  0x0F   15    
  883	:  0000_0000  0x00    0    
  884	:  0000_0001  0x01    1    
  885	:  0000_0000  0x00    0    
  886	:  0000_0000  0x00    0    
  887	:  0010_1010  0x2A   42  *  
  888	:  0011_0000  0x30   48  0  
  889	:  0000_0000  0x00    0    
  890	:  0000_0100  0x04    4    
  891	:  0000_0000  0x00    0    
  892	:  0000_1010  0x0A   10    
  893	:  1100_0001  0xC1  193    
  894	:  1111_0111  0xF7  247    
  895	:  1100_0011  0xC3  195    
  896	:  0101_0100  0x54   84  T  
  897	:  0000_0000  0x00    0    
  898	:  0001_0000  0x10   16    
  899	:  0000_0000  0x00    0    
  900	:  0000_0001  0x01    1    
  901	:  0000_0000  0x00    0    
  902	:  0000_0000  0x00    0    
  903	:  0010_1010  0x2A   42  *  
  904	:  0011_0000  0x30   48  0  
  905	:  0000_0000  0x00    0    
  906	:  0000_1110  0x0E   14    
  907	:  0000_1101  0x0D   13    
  908	:  0111_0110  0x76  118  v  
  909	:  0011_1101  0x3D   61  =  
  910	:  0111_0011  0x73  115  s  
  911	:  0111_0000  0x70  112  p  
  912	:  0110_0110  0x66  102  f  
  913	:  0011_0001  0x31   49  1  
  914	:  0010_0000  0x20   32     
  915	:  0110_0001  0x61   97  a  
  916	:  0010_0000  0x20   32     
  917	:  0010_1101  0x2D   45  -  
  918	:  0110_0001  0x61   97  a  
  919	:  0110_1100  0x6C  108  l  
  920	:  0110_1100  0x6C  108  l  
  921	:  0000_0100  0x04    4    
  922	:  0110_1100  0x6C  108  l  
  923	:  0110_1111  0x6F  111  o  
  924	:  0110_1111  0x6F  111  o  
  925	:  0110_1011  0x6B  107  k  
  926	:  1100_0000  0xC0  192    
  927	:  0000_1100  0x0C   12    
  928	:  0000_0000  0x00    0    
  929	:  0000_0101  0x05    5    
  930	:  0000_0000  0x00    0    
  931	:  0000_0001  0x01    1    
  932	:  0000_0000  0x00    0    
  933	:  0000_0000  0x00    0    
  934	:  0010_1010  0x2A   42  *  
  935	:  0011_0000  0x30   48  0  
  936	:  0000_0000  0x00    0    
  937	:  0000_0010  0x02    2    
  938	:  1100_0000  0xC0  192    
  939	:  0010_1111  0x2F   47  /  
  940	:  0000_0011  0x03    3    
  941	:  0111_0011  0x73  115  s  
  942	:  0110_0101  0x65  101  e  
  943	:  0110_0101  0x65  101  e  
  944	:  1100_0000  0xC0  192    
  945	:  0000_1100  0x0C   12    
  946	:  0000_0000  0x00    0    
  947	:  0000_0101  0x05    5    
  948	:  0000_0000  0x00    0    
  949	:  0000_0001  0x01    1    
  950	:  0000_0000  0x00    0    
  951	:  0000_0000  0x00    0    
  952	:  0010_1010  0x2A   42  *  
  953	:  0011_0000  0x30   48  0  
  954	:  0000_0000  0x00    0    
  955	:  0000_1001  0x09    9    
  956	:  0000_0110  0x06    6    
  957	:  0110_1100  0x6C  108  l  
  958	:  0110_1111  0x6F  111  o  
  959	:  0110_1111  0x6F  111  o  
  960	:  0110_1011  0x6B  107  k  
  961	:  0111_0101  0x75  117  u  
  962	:  0111_0000  0x70  112  p  
  963	:  1100_0000  0xC0  192    
  964	:  0010_1111  0x2F   47  /  
  965	:  0000_0011  0x03    3    
  966	:  0111_0111  0x77  119  w  
  967	:  0111_0111  0x77  119  w  
  968	:  0111_0111  0x77  119  w  
  969	:  1100_0011  0xC3  195    
  970	:  1010_1100  0xAC  172    
  971	:  0000_0000  0x00    0    
  972	:  0000_0101  0x05    5    
  973	:  0000_0000  0x00    0    
  974	:  0000_0001  0x01    1    
  975	:  0000_0000  0x00    0    
  976	:  0000_0000  0x00    0    
  977	:  0010_1010  0x2A   42  *  
  978	:  0011_0000  0x30   48  0  
  979	:  0000_0000  0x00    0    
  980	:  0000_0010  0x02    2    
  981	:  1100_0011  0xC3  195    
  982	:  1011_1100  0xBC  188    
  983	:  0000_0100  0x04    4    
  984	:  0110_0010  0x62   98  b  
  985	:  0110_1111  0x6F  111  o  
  986	:  0111_0010  0x72  114  r  
  987	:  0110_0111  0x67  103  g  
  988	:  1100_0000  0xC0  192    
  989	:  0000_1100  0x0C   12    
  990	:  0000_0000  0x00    0    
  991	:  0000_0001  0x01    1    
  992	:  0000_0000  0x00    0    
  993	:  0000_0001  0x01    1    
  994	:  0000_0000  0x00    0    
  995	:  0000_0000  0x00    0    
  996	:  0010_1010  0x2A   42  *  
  997	:  0011_0000  0x30   48  0  
  998	:  0000_0000  0x00    0    
  999	:  0000_0100  0x04    4    
  1000	:  1101_0011  0xD3  211    
  1001	:  1110_0111  0xE7  231    
  1002	:  1001_0001  0x91  145    
  1003	:  1110_0110  0xE6  230    
  1004	:  1100_0011  0xC3  195    
  1005	:  1101_0111  0xD7  215    
  1006	:  0000_0000  0x00    0    
  1007	:  0000_1111  0x0F   15    
  1008	:  0000_0000  0x00    0    
  1009	:  0000_0001  0x01    1    
  1010	:  0000_0000  0x00    0    
  1011	:  0000_0000  0x00    0    
  1012	:  0010_1010  0x2A   42  *  
  1013	:  0011_0000  0x30   48  0  
  1014	:  0000_0000  0x00    0    
  1015	:  0000_0100  0x04    4    
  1016	:  0000_0000  0x00    0    
  1017	:  0000_1010  0x0A   10    
  1018	:  1100_0000  0xC0  192    
  1019	:  1001_1011  0x9B  155    
  1020	:  1100_0011  0xC3  195    
  1021	:  1101_0111  0xD7  215    
  1022	:  0000_0000  0x00    0    
  1023	:  0000_1111  0x0F   15    
  1024	:  0000_0000  0x00    0    
  1025	:  0000_0001  0x01    1    
  1026	:  0000_0000  0x00    0    
  1027	:  0000_0000  0x00    0    
  1028	:  0010_1010  0x2A   42  *  
  1029	:  0011_0000  0x30   48  0  
  1030	:  0000_0000  0x00    0    
  1031	:  0000_0100  0x04    4    
  1032	:  0000_0000  0x00    0    
  1033	:  0001_0100  0x14   20    
  1034	:  1100_0000  0xC0  192    
  1035	:  1010_1111  0xAF  175    
  1036	:  0000_0100  0x04    4    
  1037	:  0111_0011  0x73  115  s  
  1038	:  0110_1101  0x6D  109  m  
  1039	:  0111_0100  0x74  116  t  
  1040	:  0111_0000  0x70  112  p  
  1041	:  1100_0000  0xC0  192    
  1042	:  0000_1100  0x0C   12    
  1043	:  0000_0000  0x00    0    
  1044	:  0000_0101  0x05    5    
  1045	:  0000_0000  0x00    0    
  1046	:  0000_0001  0x01    1    
  1047	:  0000_0000  0x00    0    
  1048	:  0000_0000  0x00    0    
  1049	:  0010_1010  0x2A   42  *  
  1050	:  0011_0000  0x30   48  0  
  1051	:  0000_0000  0x00    0    
  1052	:  0000_0010  0x02    2    
  1053	:  1100_0001  0xC1  193    
  1054	:  1111_0111  0xF7  247    
  1055	:  0000_1000  0x08    8    
  1056	:  0111_0100  0x74  116  t  
  1057	:  0110_1001  0x69  105  i  
  1058	:  0110_1101  0x6D  109  m  
  1059	:  0110_0101  0x65  101  e  
  1060	:  0110_1000  0x68  104  h  
  1061	:  0110_1111  0x6F  111  o  
  1062	:  0111_0011  0x73  115  s  
  1063	:  0111_0100  0x74  116  t  
  1064	:  1100_0000  0xC0  192    
  1065	:  0000_1100  0x0C   12    
  1066	:  0000_0000  0x00    0    
  1067	:  0000_0101  0x05    5    
  1068	:  0000_0000  0x00    0    
  1069	:  0000_0001  0x01    1    
  1070	:  0000_0000  0x00    0    
  1071	:  0000_0000  0x00    0    
  1072	:  0010_1010  0x2A   42  *  
  1073	:  0011_0000  0x30   48  0  
  1074	:  0000_0000  0x00    0    
  1075	:  0000_0010  0x02    2    
  1076	:  1100_0000  0xC0  192    
  1077	:  0111_0111  0x77  119  w  
  1078	:  0000_1000  0x08    8    
  1079	:  0110_1101  0x6D  109  m  
  1080	:  0110_1111  0x6F  111  o  
  1081	:  0111_0101  0x75  117  u  
  1082	:  0110_1110  0x6E  110  n  
  1083	:  0111_0100  0x74  116  t  
  1084	:  0110_0001  0x61   97  a  
  1085	:  0110_1001  0x69  105  i  
  1086	:  0110_1110  0x6E  110  n  
  1087	:  1100_0000  0xC0  192    
  1088	:  0000_1100  0x0C   12    
  1089	:  0000_0000  0x00    0    
  1090	:  0000_1111  0x0F   15    
  1091	:  0000_0000  0x00    0    
  1092	:  0000_0001  0x01    1    
  1093	:  0000_0000  0x00    0    
  1094	:  0000_0000  0x00    0    
  1095	:  0010_1010  0x2A   42  *  
  1096	:  0011_0000  0x30   48  0  
  1097	:  0000_0000  0x00    0    
  1098	:  0001_0011  0x13   19    
  1099	:  0000_0000  0x00    0    
  1100	:  0000_1010  0x0A   10    
  1101	:  0000_0101  0x05    5    
  1102	:  0110_1101  0x6D  109  m  
  1103	:  0110_0001  0x61   97  a  
  1104	:  0110_1001  0x69  105  i  
  1105	:  0110_1100  0x6C  108  l  
  1106	:  0011_0001  0x31   49  1  
  1107	:  0000_1000  0x08    8    
  1108	:  0110_1101  0x6D  109  m  
  1109	:  0111_1000  0x78  120  x  
  1110	:  0110_1101  0x6D  109  m  
  1111	:  0110_0001  0x61   97  a  
  1112	:  0110_1001  0x69  105  i  
  1113	:  0110_1100  0x6C  108  l  
  1114	:  0110_0101  0x65  101  e  
  1115	:  0111_0010  0x72  114  r  
  1116	:  1100_0000  0xC0  192    
  1117	:  0001_0100  0x14   20    
  1118	:  0000_0011  0x03    3    
  1119	:  0111_0111  0x77  119  w  
  1120	:  0111_0111  0x77  119  w  
  1121	:  0111_0111  0x77  119  w  
  1122	:  1100_0000  0xC0  192    
  1123	:  0000_1100  0x0C   12    
  1124	:  0000_0000  0x00    0    
  1125	:  0000_0101  0x05    5    
  1126	:  0000_0000  0x00    0    
  1127	:  0000_0001  0x01    1    
  1128	:  0000_0000  0x00    0    
  1129	:  0000_0000  0x00    0    
  1130	:  0010_1010  0x2A   42  *  
  1131	:  0011_0000  0x30   48  0  
  1132	:  0000_0000  0x00    0    
  1133	:  0000_0010  0x02    2    
  1134	:  1100_0000  0xC0  192    
  1135	:  0000_1100  0x0C   12    
  1136	:  0000_0111  0x07    7    
  1137	:  0111_0000  0x70  112  p  
  1138	:  0110_1111  0x6F  111  o  
  1139	:  0110_1100  0x6C  108  l  
  1140	:  0110_0101  0x65  101  e  
  1141	:  0110_0011  0x63   99  c  
  1142	:  0110_0001  0x61   97  a  
  1143	:  0111_0100  0x74  116  t  
  1144	:  1100_0000  0xC0  192    
  1145	:  0000_1100  0x0C   12    
  1146	:  0000_0000  0x00    0    
  1147	:  0000_1101  0x0D   13    
  1148	:  0000_0000  0x00    0    
  1149	:  0000_0001  0x01    1    
  1150	:  0000_0000  0x00    0    
  1151	:  0000_0000  0x00    0    
  1152	:  0010_1010  0x2A   42  *  
  1153	:  0011_0000  0x30   48  0  
  1154	:  0000_0000  0x00    0    
  1155	:  0001_0110  0x16   22    
  1156	:  0000_1000  0x08    8    
  1157	:  0111_0010  0x72  114  r  
  1158	:  0110_0101  0x65  101  e  
  1159	:  0111_0011  0x73  115  s  
  1160	:  0110_0101  0x65  101  e  
  1161	:  0111_0010  0x72  114  r  
  1162	:  0111_0110  0x76  118  v  
  1163	:  0110_0101  0x65  101  e  
  1164	:  0110_0100  0x64  100  d  
  1165	:  0000_1100  0x0C   12    
  1166	:  0110_0110  0x66  102  f  
  1167	:  0110_1111  0x6F  111  o  
  1168	:  0111_0010  0x72  114  r  
  1169	:  0010_0000  0x20   32     
  1170	:  0111_0000  0x70  112  p  
  1171	:  0110_1111  0x6F  111  o  
  1172	:  0110_1100  0x6C  108  l  
  1173	:  0110_1001  0x69  105  i  
  1174	:  0111_0100  0x74  116  t  
  1175	:  0110_1001  0x69  105  i  
  1176	:  0110_0011  0x63   99  c  
  1177	:  0111_0011  0x73  115  s  
  1178	:  1100_0000  0xC0  192    
  1179	:  0000_1100  0x0C   12    
  1180	:  0000_0000  0x00    0    
  1181	:  0000_0110  0x06    6    
  1182	:  0000_0000  0x00    0    
  1183	:  0000_0001  0x01    1    
  1184	:  0000_0000  0x00    0    
  1185	:  0000_0000  0x00    0    
  1186	:  0010_1010  0x2A   42  *  
  1187	:  0011_0000  0x30   48  0  
  1188	:  0000_0000  0x00    0    
  1189	:  0001_1000  0x18   24    
  1190	:  1100_0000  0xC0  192    
  1191	:  0010_1001  0x29   41  )  
  1192	:  1100_0000  0xC0  192    
  1193	:  0011_1100  0x3C   60  <  
  1194	:  0111_0111  0x77  119  w  
  1195	:  1101_1110  0xDE  222    
  1196	:  1111_0100  0xF4  244    
  1197	:  1111_0110  0xF6  246    
  1198	:  0000_0000  0x00    0    
  1199	:  0000_0000  0x00    0    
  1200	:  1010_1000  0xA8  168    
  1201	:  1100_0000  0xC0  192    
  1202	:  0000_0000  0x00    0    
  1203	:  0000_0000  0x00    0    
  1204	:  0000_1110  0x0E   14    
  1205	:  0001_0000  0x10   16    
  1206	:  0000_0000  0x00    0    
  1207	:  0000_0011  0x03    3    
  1208	:  1111_0100  0xF4  244    
  1209	:  1000_0000  0x80  128    
  1210	:  0000_0000  0x00    0    
  1211	:  0000_0000  0x00    0    
  1212	:  0010_1010  0x2A   42  *  
  1213	:  0011_0000  0x30   48  0  |;

# ; <<>> dig.pl 1.11 <<>> -d -t axfr @eagle.is.bizsystems.com example.com
# ;;
# example.com.		  10800	IN	SOA	names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800 
# example.com.		  10800	IN	NS	ns1.example.com. 
# example.com.		  10800	IN	NS	ns0.example.com. 
# example.com.		  10800	IN	A	211.231.145.232 
# example.com.		  10800	IN	MX	10 mx1.example.com. 
# example.com.		  10800	IN	MX	50 mx2.example.com. 
# example.com.		  10800	IN	MX	100 mx3.example.com. 
# stronghold.example.com. 10800	IN	CNAME	ns1.example.com. 
# ftp.example.com.	  10800	IN	CNAME	ns1.example.com. 
# home.example.com.	  10800	IN	CNAME	ns1.example.com. 
# lb.example.com.	  10800	IN	CNAME	localhost.example.com. 
# localhost.example.com.  10800	IN	A	127.0.0.1 
# loopback.example.com.	  10800	IN	CNAME	localhost.example.com. 
# mx1.example.com.	  10800	IN	A	28.2.67.50 
# mx1.example.com.	  10800	IN	MX	10 mx1.example.com. 
# mx1.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# ns1.example.com.	  10800	IN	A	51.231.18.146 
# ns1.example.com.	  10800	IN	MX	10 mx1.example.com. 
# ns1.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mx2.example.com.	  10800	IN	A	211.231.145.225 
# mx2.example.com.	  10800	IN	MX	10 mx2.example.com. 
# mx2.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mail4.example.com.	  10800	IN	A	28.2.67.51 
# mail4.example.com.	  10800	IN	MX	10 mail4.example.com. 
# mail4.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mail1.example.com.	  10800	IN	A	211.231.145.226 
# mail1.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mail1.example.com.	  10800	IN	A	28.2.67.56 
# mail1.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mx3.example.com.	  10800	IN	A	28.2.67.52 
# mx3.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# st.example.com.	  10800	IN	MX	10 mail1.example.com. 
# st.example.com.	  10800	IN	MX	100 mx3.example.com. 
# dns.example.com.	  10800	IN	A	28.2.67.50 
# ns0.example.com.	  10800	IN	A	211.231.145.225 
# ns0.example.com.	  10800	IN	MX	10 mx2.example.com. 
# ns0.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# pop3.example.com.	  10800	IN	CNAME	mail4.example.com. 
# amblin.example.com.	  10800	IN	CNAME	example.net. 
# littlefish.example.com. 10800	IN	A	28.2.67.51 
# littlefish.example.com. 10800	IN	MX	10 mail4.example.com. 
# littlefish.example.com. 10800	IN	TXT	"v=spf1 a -all" 
# look.example.com.	  10800	IN	CNAME	example.net. 
# see.example.com.	  10800	IN	CNAME	lookup.example.net. 
# www.see.example.com.	  10800	IN	CNAME	lookup.example.net. 
# borg.example.com.	  10800	IN	A	211.231.145.230 
# borg.example.com.	  10800	IN	MX	10 mx1.example.com. 
# borg.example.com.	  10800	IN	MX	20 mx2.example.com. 
# smtp.example.com.	  10800	IN	CNAME	mail4.example.com. 
# timehost.example.com.	  10800	IN	CNAME	ns0.example.com. 
# mountain.example.com.	  10800	IN	MX	10 mail1.mxmailer.com. 
# www.example.com.	  10800	IN	CNAME	example.com. 
# polecat.example.com.	  10800	IN	HINFO	"reserved" "for politics" 
# example.com.		  10800	IN	SOA	names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800 
# 
# ;; Query time: 332 ms
# ;; SERVER: 192.168.1.164# 53(names.example.net)
# ;; WHEN: Tue Oct  4 18:53:02 2011
# ;; MSG SIZE rcvd: 1214 -- XFR size: 55 records
# 


$ap = makebuf(\$ans3);
$qp = makebuf(\$ques3);

## test 3	check object contents
$dig = new Net::DNS::Dig( PeerAddr => ['my.domain.com','6.5.4.3']);
set_names($dig);
$myrptr = $ap;
$mybptr = $qp;
$rp = $dig->for('dummyname','axfr');
$exp = q|496	= {
	'ANSWER'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['names.example.net','sysadm.example.com',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 48,
		'TTL'	=> 10800,
		'TYPE'	=> 6,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['ns1.example.com',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 2,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['ns0.example.com',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 2,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> [10,'mx1.example.com',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> [50,'mx2.example.com',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> [100,'mx3.example.com',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'stronghold.example.com',
		'RDATA'	=> ['ns1.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ftp.example.com',
		'RDATA'	=> ['ns1.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'home.example.com',
		'RDATA'	=> ['ns1.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'lb.example.com',
		'RDATA'	=> ['localhost.example.com',],
		'RDLEN'	=> 12,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'localhost.example.com',
		'RDATA'	=> ['  ',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'loopback.example.com',
		'RDATA'	=> ['localhost.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx1.example.com',
		'RDATA'	=> ['C2',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx1.example.com',
		'RDATA'	=> [10,'mx1.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx1.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns1.example.com',
		'RDATA'	=> ['3',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns1.example.com',
		'RDATA'	=> [10,'mx1.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns1.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx2.example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx2.example.com',
		'RDATA'	=> [10,'mx2.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx2.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail4.example.com',
		'RDATA'	=> ['C3',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail4.example.com',
		'RDATA'	=> [10,'mail4.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail4.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail1.example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail1.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail1.example.com',
		'RDATA'	=> ['C8',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail1.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx3.example.com',
		'RDATA'	=> ['C4',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx3.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'st.example.com',
		'RDATA'	=> [10,'mail1.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'st.example.com',
		'RDATA'	=> [100,'mx3.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'dns.example.com',
		'RDATA'	=> ['C2',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns0.example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns0.example.com',
		'RDATA'	=> [10,'mx2.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns0.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'pop3.example.com',
		'RDATA'	=> ['mail4.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'amblin.example.com',
		'RDATA'	=> ['example.net',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'littlefish.example.com',
		'RDATA'	=> ['C3',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'littlefish.example.com',
		'RDATA'	=> [10,'mail4.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'littlefish.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'look.example.com',
		'RDATA'	=> ['example.net',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'see.example.com',
		'RDATA'	=> ['lookup.example.net',],
		'RDLEN'	=> 9,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'www.see.example.com',
		'RDATA'	=> ['lookup.example.net',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'borg.example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'borg.example.com',
		'RDATA'	=> [10,'mx1.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'borg.example.com',
		'RDATA'	=> [20,'mx2.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'smtp.example.com',
		'RDATA'	=> ['mail4.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'timehost.example.com',
		'RDATA'	=> ['ns0.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mountain.example.com',
		'RDATA'	=> [10,'mail1.mxmailer.com',],
		'RDLEN'	=> 19,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'www.example.com',
		'RDATA'	=> ['example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'polecat.example.com',
		'RDATA'	=> ['reserved','for politics',],
		'RDLEN'	=> 22,
		'TTL'	=> 10800,
		'TYPE'	=> 13,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['names.example.net','sysadm.example.com',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 24,
		'TTL'	=> 10800,
		'TYPE'	=> 6,
	},
],
	'BYTES'	=> 1214,
	'Class'	=> 'IN',
	'ELAPSED'	=> 45,
	'HEADER'	=> {
		'AA'	=> 1,
		'AD'	=> 0,
		'ANCOUNT'	=> 54,
		'ARCOUNT'	=> 0,
		'CD'	=> 0,
		'ID'	=> 21141,
		'MBZ'	=> 0,
		'NSCOUNT'	=> 0,
		'OPCODE'	=> 0,
		'QDCOUNT'	=> 1,
		'QR'	=> 1,
		'RA'	=> 0,
		'RCODE'	=> 0,
		'RD'	=> 1,
		'TC'	=> 0,
	},
	'NRECS'	=> 55,
	'PeerAddr'	=> ['my.domain.com','6.5.4.3',],
	'PeerPort'	=> 53,
	'Proto'	=> 'UDP',
	'QUESTION'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'TYPE'	=> 252,
	},
],
	'Recursion'	=> 1,
	'SERVER'	=> 'my.domain.com',
	'Timeout'	=> 15,
	'_SS'	=> {
		'6.5.4.3'	=> '',
		'my.domain.com'	=> 'aA+',
	},
};
|;

#print MyTest::Dumper($dig);
$got = MyTest::Dumper($dig);
print "dig_for failed\ngot: $got\nexp: $exp\nnot "
	unless $rp && $got eq $exp;
&ok;

## test 4	convert to text for debuging
$exp = q|497	= {
	'ANSWER'	=> [{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['names.example.net.','sysadm.example.com.',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 48,
		'TTL'	=> 10800,
		'TYPE'	=> 'SOA',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 'NS',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['ns0.example.com.',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 'NS',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['211.231.145.232',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [50,'mx2.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [100,'mx3.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'stronghold.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ftp.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'home.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'lb.example.com.',
		'RDATA'	=> ['localhost.example.com.',],
		'RDLEN'	=> 12,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'localhost.example.com.',
		'RDATA'	=> ['127.0.0.1',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'loopback.example.com.',
		'RDATA'	=> ['localhost.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> ['28.2.67.50',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> ['51.231.18.146',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> ['211.231.145.225',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> [10,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> ['28.2.67.51',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> [10,'mail4.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['211.231.145.226',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['28.2.67.56',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx3.example.com.',
		'RDATA'	=> ['28.2.67.52',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx3.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'st.example.com.',
		'RDATA'	=> [10,'mail1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'st.example.com.',
		'RDATA'	=> [100,'mx3.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'dns.example.com.',
		'RDATA'	=> ['28.2.67.50',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> ['211.231.145.225',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> [10,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'pop3.example.com.',
		'RDATA'	=> ['mail4.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'amblin.example.com.',
		'RDATA'	=> ['example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> ['28.2.67.51',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> [10,'mail4.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'look.example.com.',
		'RDATA'	=> ['example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'see.example.com.',
		'RDATA'	=> ['lookup.example.net.',],
		'RDLEN'	=> 9,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'www.see.example.com.',
		'RDATA'	=> ['lookup.example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> ['211.231.145.230',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> [20,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'smtp.example.com.',
		'RDATA'	=> ['mail4.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'timehost.example.com.',
		'RDATA'	=> ['ns0.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mountain.example.com.',
		'RDATA'	=> [10,'mail1.mxmailer.com.',],
		'RDLEN'	=> 19,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'www.example.com.',
		'RDATA'	=> ['example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'polecat.example.com.',
		'RDATA'	=> ['"reserved"','"for politics"',],
		'RDLEN'	=> 22,
		'TTL'	=> 10800,
		'TYPE'	=> 'HINFO',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['names.example.net.','sysadm.example.com.',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 24,
		'TTL'	=> 10800,
		'TYPE'	=> 'SOA',
	},
],
	'BYTES'	=> 1214,
	'Class'	=> 'IN',
	'ELAPSED'	=> 45,
	'HEADER'	=> {
		'AA'	=> 1,
		'AD'	=> 0,
		'ANCOUNT'	=> 54,
		'ARCOUNT'	=> 0,
		'CD'	=> 0,
		'ID'	=> 21141,
		'MBZ'	=> 0,
		'NSCOUNT'	=> 0,
		'OPCODE'	=> 'QUERY',
		'QDCOUNT'	=> 1,
		'QR'	=> 1,
		'RA'	=> 0,
		'RCODE'	=> 'NOERROR',
		'RD'	=> 1,
		'TC'	=> 0,
	},
	'NRECS'	=> 55,
	'PeerAddr'	=> ['my.domain.com','6.5.4.3',],
	'PeerPort'	=> 53,
	'Proto'	=> 'UDP',
	'QUESTION'	=> [{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'TYPE'	=> 'AXFR',
	},
],
	'Recursion'	=> 1,
	'SERVER'	=> 'my.domain.com',
	'TEXT'	=> '
; <<>> Net::DNS::Dig 0.01 <<>> -t axfr example.com.
;;
example.com.	10800	IN	SOA	 names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800
example.com.	10800	IN	NS	 ns1.example.com.
example.com.	10800	IN	NS	 ns0.example.com.
example.com.	10800	IN	A	 211.231.145.232
example.com.	10800	IN	MX	 10 mx1.example.com.
example.com.	10800	IN	MX	 50 mx2.example.com.
example.com.	10800	IN	MX	 100 mx3.example.com.
stronghold.example.com.	10800	IN	CNAME	 ns1.example.com.
ftp.example.com.	10800	IN	CNAME	 ns1.example.com.
home.example.com.	10800	IN	CNAME	 ns1.example.com.
lb.example.com.	10800	IN	CNAME	 localhost.example.com.
localhost.example.com.	10800	IN	A	 127.0.0.1
loopback.example.com.	10800	IN	CNAME	 localhost.example.com.
mx1.example.com.	10800	IN	A	 28.2.67.50
mx1.example.com.	10800	IN	MX	 10 mx1.example.com.
mx1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
ns1.example.com.	10800	IN	A	 51.231.18.146
ns1.example.com.	10800	IN	MX	 10 mx1.example.com.
ns1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mx2.example.com.	10800	IN	A	 211.231.145.225
mx2.example.com.	10800	IN	MX	 10 mx2.example.com.
mx2.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail4.example.com.	10800	IN	A	 28.2.67.51
mail4.example.com.	10800	IN	MX	 10 mail4.example.com.
mail4.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail1.example.com.	10800	IN	A	 211.231.145.226
mail1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail1.example.com.	10800	IN	A	 28.2.67.56
mail1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mx3.example.com.	10800	IN	A	 28.2.67.52
mx3.example.com.	10800	IN	TXT	 "v=spf1 a -all"
st.example.com.	10800	IN	MX	 10 mail1.example.com.
st.example.com.	10800	IN	MX	 100 mx3.example.com.
dns.example.com.	10800	IN	A	 28.2.67.50
ns0.example.com.	10800	IN	A	 211.231.145.225
ns0.example.com.	10800	IN	MX	 10 mx2.example.com.
ns0.example.com.	10800	IN	TXT	 "v=spf1 a -all"
pop3.example.com.	10800	IN	CNAME	 mail4.example.com.
amblin.example.com.	10800	IN	CNAME	 example.net.
littlefish.example.com.	10800	IN	A	 28.2.67.51
littlefish.example.com.	10800	IN	MX	 10 mail4.example.com.
littlefish.example.com.	10800	IN	TXT	 "v=spf1 a -all"
look.example.com.	10800	IN	CNAME	 example.net.
see.example.com.	10800	IN	CNAME	 lookup.example.net.
www.see.example.com.	10800	IN	CNAME	 lookup.example.net.
borg.example.com.	10800	IN	A	 211.231.145.230
borg.example.com.	10800	IN	MX	 10 mx1.example.com.
borg.example.com.	10800	IN	MX	 20 mx2.example.com.
smtp.example.com.	10800	IN	CNAME	 mail4.example.com.
timehost.example.com.	10800	IN	CNAME	 ns0.example.com.
mountain.example.com.	10800	IN	MX	 10 mail1.mxmailer.com.
www.example.com.	10800	IN	CNAME	 example.com.
polecat.example.com.	10800	IN	HINFO	 "reserved" "for politics"
example.com.	10800	IN	SOA	 names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800
;; Query time: 45 ms
;; SERVER: 97.65.43.21# 53(my.domain.com)
;; WHEN: Mon Oct  3 13:41:57 2011
;; MSG SIZE rcvd: 1214 -- XFR size: 55 records
',
	'Timeout'	=> 15,
	'_SS'	=> {
		'6.5.4.3'	=> '',
		'my.domain.com'	=> 'aA+',
	},
};
|;

my $tobj = $dig->to_text;
$got = MyTest::Dumper($tobj);
print "text conversion failed\ngot: $got\nexp: $exp\nnot "
	unless $got eq $exp;
&ok;

######################### this section tests long tcp responses

my $qxa = q
| 0	:  0110_0010  0x62   98  b  
  1	:  0111_1100  0x7C  124  |.'|'.q|  
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0111  0x07    7    
  13	:  0110_0101  0x65  101  e  
  14	:  0111_1000  0x78  120  x  
  15	:  0110_0001  0x61   97  a  
  16	:  0110_1101  0x6D  109  m  
  17	:  0111_0000  0x70  112  p  
  18	:  0110_1100  0x6C  108  l  
  19	:  0110_0101  0x65  101  e  
  20	:  0000_0011  0x03    3    
  21	:  0110_1110  0x6E  110  n  
  22	:  0110_0101  0x65  101  e  
  23	:  0111_0100  0x74  116  t  
  24	:  0000_0000  0x00    0    
  25	:  0000_0000  0x00    0    
  26	:  1111_1100  0xFC  252    
  27	:  0000_0000  0x00    0    
  28	:  0000_0001  0x01    1    |;

my $axa1 = q
| 0	:  0110_0010  0x62   98  b  
  1	:  0111_1100  0x7C  124  |.'|'.q|  
  2	:  1000_0100  0x84  132    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0111  0x07    7    
  7	:  0001_1001  0x19   25    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0111  0x07    7    
  13	:  0110_0101  0x65  101  e  
  14	:  0111_1000  0x78  120  x  
  15	:  0110_0001  0x61   97  a  
  16	:  0110_1101  0x6D  109  m  
  17	:  0111_0000  0x70  112  p  
  18	:  0110_1100  0x6C  108  l  
  19	:  0110_0101  0x65  101  e  
  20	:  0000_0011  0x03    3    
  21	:  0110_1110  0x6E  110  n  
  22	:  0110_0101  0x65  101  e  
  23	:  0111_0100  0x74  116  t  
  24	:  0000_0000  0x00    0    
  25	:  0000_0000  0x00    0    
  26	:  1111_1100  0xFC  252    
  27	:  0000_0000  0x00    0    
  28	:  0000_0001  0x01    1    
  29	:  1100_0000  0xC0  192    
  30	:  0000_1100  0x0C   12    
  31	:  0000_0000  0x00    0    
  32	:  0000_0110  0x06    6    
  33	:  0000_0000  0x00    0    
  34	:  0000_0001  0x01    1    
  35	:  0000_0000  0x00    0    
  36	:  0000_0000  0x00    0    
  37	:  0010_1010  0x2A   42  *  
  38	:  0011_0000  0x30   48  0  
  39	:  0000_0000  0x00    0    
  40	:  0011_1100  0x3C   60  <  
  41	:  0000_0011  0x03    3    
  42	:  0110_1110  0x6E  110  n  
  43	:  0111_0011  0x73  115  s  
  44	:  0011_0010  0x32   50  2  
  45	:  0000_1010  0x0A   10    
  46	:  0110_0010  0x62   98  b  
  47	:  0110_1001  0x69  105  i  
  48	:  0111_1010  0x7A  122  z  
  49	:  0111_0011  0x73  115  s  
  50	:  0111_1001  0x79  121  y  
  51	:  0111_0011  0x73  115  s  
  52	:  0111_0100  0x74  116  t  
  53	:  0110_0101  0x65  101  e  
  54	:  0110_1101  0x6D  109  m  
  55	:  0111_0011  0x73  115  s  
  56	:  1100_0000  0xC0  192    
  57	:  0001_0100  0x14   20    
  58	:  0000_0110  0x06    6    
  59	:  0111_0011  0x73  115  s  
  60	:  0111_1001  0x79  121  y  
  61	:  0111_0011  0x73  115  s  
  62	:  0110_0001  0x61   97  a  
  63	:  0110_0100  0x64  100  d  
  64	:  0110_1101  0x6D  109  m  
  65	:  0000_1010  0x0A   10    
  66	:  0110_0010  0x62   98  b  
  67	:  0110_1001  0x69  105  i  
  68	:  0111_1010  0x7A  122  z  
  69	:  0111_0011  0x73  115  s  
  70	:  0111_1001  0x79  121  y  
  71	:  0111_0011  0x73  115  s  
  72	:  0111_0100  0x74  116  t  
  73	:  0110_0101  0x65  101  e  
  74	:  0110_1101  0x6D  109  m  
  75	:  0111_0011  0x73  115  s  
  76	:  0000_0011  0x03    3    
  77	:  0110_0011  0x63   99  c  
  78	:  0110_1111  0x6F  111  o  
  79	:  0110_1101  0x6D  109  m  
  80	:  0000_0000  0x00    0    
  81	:  0111_0111  0x77  119  w  
  82	:  1100_1111  0xCF  207    
  83	:  0001_1101  0x1D   29    
  84	:  0001_0110  0x16   22    
  85	:  0000_0000  0x00    0    
  86	:  0000_0000  0x00    0    
  87	:  1010_1000  0xA8  168    
  88	:  1100_0000  0xC0  192    
  89	:  0000_0000  0x00    0    
  90	:  0000_0000  0x00    0    
  91	:  0000_1110  0x0E   14    
  92	:  0001_0000  0x10   16    
  93	:  0000_0000  0x00    0    
  94	:  0000_0011  0x03    3    
  95	:  1111_0100  0xF4  244    
  96	:  1000_0000  0x80  128    
  97	:  0000_0000  0x00    0    
  98	:  0000_0000  0x00    0    
  99	:  0010_1010  0x2A   42  *  
  100	:  0011_0000  0x30   48  0  
  101	:  1100_0000  0xC0  192    
  102	:  0000_1100  0x0C   12    
  103	:  0000_0000  0x00    0    
  104	:  0000_0010  0x02    2    
  105	:  0000_0000  0x00    0    
  106	:  0000_0001  0x01    1    
  107	:  0000_0000  0x00    0    
  108	:  0000_0000  0x00    0    
  109	:  0010_1010  0x2A   42  *  
  110	:  0011_0000  0x30   48  0  
  111	:  0000_0000  0x00    0    
  112	:  0000_0110  0x06    6    
  113	:  0000_0011  0x03    3    
  114	:  0110_1110  0x6E  110  n  
  115	:  0111_0011  0x73  115  s  
  116	:  0011_0000  0x30   48  0  
  117	:  1100_0000  0xC0  192    
  118	:  0000_1100  0x0C   12    
  119	:  1100_0000  0xC0  192    
  120	:  0000_1100  0x0C   12    
  121	:  0000_0000  0x00    0    
  122	:  0000_0010  0x02    2    
  123	:  0000_0000  0x00    0    
  124	:  0000_0001  0x01    1    
  125	:  0000_0000  0x00    0    
  126	:  0000_0000  0x00    0    
  127	:  0010_1010  0x2A   42  *  
  128	:  0011_0000  0x30   48  0  
  129	:  0000_0000  0x00    0    
  130	:  0000_0110  0x06    6    
  131	:  0000_0011  0x03    3    
  132	:  0110_1110  0x6E  110  n  
  133	:  0111_0011  0x73  115  s  
  134	:  0011_0001  0x31   49  1  
  135	:  1100_0000  0xC0  192    
  136	:  0000_1100  0x0C   12    
  137	:  1100_0000  0xC0  192    
  138	:  0000_1100  0x0C   12    
  139	:  0000_0000  0x00    0    
  140	:  0000_0001  0x01    1    
  141	:  0000_0000  0x00    0    
  142	:  0000_0001  0x01    1    
  143	:  0000_0000  0x00    0    
  144	:  0000_0000  0x00    0    
  145	:  0010_1010  0x2A   42  *  
  146	:  0011_0000  0x30   48  0  
  147	:  0000_0000  0x00    0    
  148	:  0000_0100  0x04    4    
  149	:  1101_0011  0xD3  211    
  150	:  1110_0111  0xE7  231    
  151	:  1001_0001  0x91  145    
  152	:  1110_1000  0xE8  232    
  153	:  1100_0000  0xC0  192    
  154	:  0000_1100  0x0C   12    
  155	:  0000_0000  0x00    0    
  156	:  0000_1111  0x0F   15    
  157	:  0000_0000  0x00    0    
  158	:  0000_0001  0x01    1    
  159	:  0000_0000  0x00    0    
  160	:  0000_0000  0x00    0    
  161	:  0010_1010  0x2A   42  *  
  162	:  0011_0000  0x30   48  0  
  163	:  0000_0000  0x00    0    
  164	:  0000_1000  0x08    8    
  165	:  0000_0000  0x00    0    
  166	:  0000_1010  0x0A   10    
  167	:  0000_0011  0x03    3    
  168	:  0110_1101  0x6D  109  m  
  169	:  0111_1000  0x78  120  x  
  170	:  0011_0001  0x31   49  1  
  171	:  1100_0000  0xC0  192    
  172	:  0000_1100  0x0C   12    
  173	:  1100_0000  0xC0  192    
  174	:  0000_1100  0x0C   12    
  175	:  0000_0000  0x00    0    
  176	:  0000_1111  0x0F   15    
  177	:  0000_0000  0x00    0    
  178	:  0000_0001  0x01    1    
  179	:  0000_0000  0x00    0    
  180	:  0000_0000  0x00    0    
  181	:  0010_1010  0x2A   42  *  
  182	:  0011_0000  0x30   48  0  
  183	:  0000_0000  0x00    0    
  184	:  0000_1000  0x08    8    
  185	:  0000_0000  0x00    0    
  186	:  0011_0010  0x32   50  2  
  187	:  0000_0011  0x03    3    
  188	:  0110_1101  0x6D  109  m  
  189	:  0111_1000  0x78  120  x  
  190	:  0011_0010  0x32   50  2  
  191	:  1100_0000  0xC0  192    
  192	:  0000_1100  0x0C   12    
  193	:  1100_0000  0xC0  192    
  194	:  0000_1100  0x0C   12    
  195	:  0000_0000  0x00    0    
  196	:  0000_1111  0x0F   15    
  197	:  0000_0000  0x00    0    
  198	:  0000_0001  0x01    1    
  199	:  0000_0000  0x00    0    
  200	:  0000_0000  0x00    0    
  201	:  0010_1010  0x2A   42  *  
  202	:  0011_0000  0x30   48  0  
  203	:  0000_0000  0x00    0    
  204	:  0000_1000  0x08    8    
  205	:  0000_0000  0x00    0    
  206	:  0110_0100  0x64  100  d  
  207	:  0000_0011  0x03    3    
  208	:  0110_1101  0x6D  109  m  
  209	:  0111_1000  0x78  120  x  
  210	:  0011_0011  0x33   51  3  
  211	:  1100_0000  0xC0  192    
  212	:  0000_1100  0x0C   12    
  213	:  0000_1000  0x08    8    
  214	:  0100_0001  0x41   65  A  
  215	:  0010_1101  0x2D   45  -  
  216	:  0011_0101  0x35   53  5  
  217	:  0011_0000  0x30   48  0  
  218	:  0010_1101  0x2D   45  -  
  219	:  0011_0000  0x30   48  0  
  220	:  0011_0000  0x30   48  0  
  221	:  0011_0001  0x31   49  1  
  222	:  1100_0000  0xC0  192    
  223	:  0000_1100  0x0C   12    
  224	:  0000_0000  0x00    0    
  225	:  0000_0001  0x01    1    
  226	:  0000_0000  0x00    0    
  227	:  0000_0001  0x01    1    
  228	:  0000_0000  0x00    0    
  229	:  0000_0000  0x00    0    
  230	:  0010_1010  0x2A   42  *  
  231	:  0011_0000  0x30   48  0  
  232	:  0000_0000  0x00    0    
  233	:  0000_0100  0x04    4    
  234	:  0010_1101  0x2D   45  -  
  235	:  0100_0011  0x43   67  C  
  236	:  0011_0010  0x32   50  2  
  237	:  0000_0001  0x01    1    
  238	:  0000_1000  0x08    8    
  239	:  0100_0001  0x41   65  A  
  240	:  0010_1101  0x2D   45  -  
  241	:  0011_0101  0x35   53  5  
  242	:  0011_0000  0x30   48  0  
  243	:  0010_1101  0x2D   45  -  
  244	:  0011_0000  0x30   48  0  
  245	:  0011_0000  0x30   48  0  
  246	:  0011_0010  0x32   50  2  
  247	:  1100_0000  0xC0  192    
  248	:  0000_1100  0x0C   12    
  249	:  0000_0000  0x00    0    
  250	:  0000_0001  0x01    1    
  251	:  0000_0000  0x00    0    
  252	:  0000_0001  0x01    1    
  253	:  0000_0000  0x00    0    
  254	:  0000_0000  0x00    0    
  255	:  0010_1010  0x2A   42  *  
  256	:  0011_0000  0x30   48  0  
  257	:  0000_0000  0x00    0    
  258	:  0000_0100  0x04    4    
  259	:  0010_1101  0x2D   45  -  
  260	:  0100_0011  0x43   67  C  
  261	:  0011_0010  0x32   50  2  
  262	:  0000_0010  0x02    2    
  263	:  0000_1000  0x08    8    
  264	:  0100_0001  0x41   65  A  
  265	:  0010_1101  0x2D   45  -  
  266	:  0011_0101  0x35   53  5  
  267	:  0011_0000  0x30   48  0  
  268	:  0010_1101  0x2D   45  -  
  269	:  0011_0000  0x30   48  0  
  270	:  0011_0000  0x30   48  0  
  271	:  0011_0011  0x33   51  3  
  272	:  1100_0000  0xC0  192    
  273	:  0000_1100  0x0C   12    
  274	:  0000_0000  0x00    0    
  275	:  0000_0001  0x01    1    
  276	:  0000_0000  0x00    0    
  277	:  0000_0001  0x01    1    
  278	:  0000_0000  0x00    0    
  279	:  0000_0000  0x00    0    
  280	:  0010_1010  0x2A   42  *  
  281	:  0011_0000  0x30   48  0  
  282	:  0000_0000  0x00    0    
  283	:  0000_0100  0x04    4    
  284	:  0010_1101  0x2D   45  -  
  285	:  0100_0011  0x43   67  C  
  286	:  0011_0010  0x32   50  2  
  287	:  0000_0011  0x03    3    
  288	:  0000_1000  0x08    8    
  289	:  0100_0001  0x41   65  A  
  290	:  0010_1101  0x2D   45  -  
  291	:  0011_0101  0x35   53  5  
  292	:  0011_0000  0x30   48  0  
  293	:  0010_1101  0x2D   45  -  
  294	:  0011_0000  0x30   48  0  
  295	:  0011_0000  0x30   48  0  
  296	:  0011_0100  0x34   52  4  
  297	:  1100_0000  0xC0  192    
  298	:  0000_1100  0x0C   12    
  299	:  0000_0000  0x00    0    
  300	:  0000_0001  0x01    1    
  301	:  0000_0000  0x00    0    
  302	:  0000_0001  0x01    1    
  303	:  0000_0000  0x00    0    
  304	:  0000_0000  0x00    0    
  305	:  0010_1010  0x2A   42  *  
  306	:  0011_0000  0x30   48  0  
  307	:  0000_0000  0x00    0    
  308	:  0000_0100  0x04    4    
  309	:  0010_1101  0x2D   45  -  
  310	:  0100_0011  0x43   67  C  
  311	:  0011_0010  0x32   50  2  
  312	:  0000_0100  0x04    4    
  313	:  0000_1000  0x08    8    
  314	:  0100_0001  0x41   65  A  
  315	:  0010_1101  0x2D   45  -  
  316	:  0011_0101  0x35   53  5  
  317	:  0011_0000  0x30   48  0  
  318	:  0010_1101  0x2D   45  -  
  319	:  0011_0000  0x30   48  0  
  320	:  0011_0000  0x30   48  0  
  321	:  0011_0101  0x35   53  5  
  322	:  1100_0000  0xC0  192    
  323	:  0000_1100  0x0C   12    
  324	:  0000_0000  0x00    0    
  325	:  0000_0001  0x01    1    
  326	:  0000_0000  0x00    0    
  327	:  0000_0001  0x01    1    
  328	:  0000_0000  0x00    0    
  329	:  0000_0000  0x00    0    
  330	:  0010_1010  0x2A   42  *  
  331	:  0011_0000  0x30   48  0  
  332	:  0000_0000  0x00    0    
  333	:  0000_0100  0x04    4    
  334	:  0010_1101  0x2D   45  -  
  335	:  0100_0011  0x43   67  C  
  336	:  0011_0010  0x32   50  2  
  337	:  0000_0101  0x05    5    
  338	:  0000_1000  0x08    8    
  339	:  0100_0001  0x41   65  A  
  340	:  0010_1101  0x2D   45  -  
  341	:  0011_0101  0x35   53  5  
  342	:  0011_0000  0x30   48  0  
  343	:  0010_1101  0x2D   45  -  
  344	:  0011_0000  0x30   48  0  
  345	:  0011_0000  0x30   48  0  
  346	:  0011_0110  0x36   54  6  
  347	:  1100_0000  0xC0  192    
  348	:  0000_1100  0x0C   12    
  349	:  0000_0000  0x00    0    
  350	:  0000_0001  0x01    1    
  351	:  0000_0000  0x00    0    
  352	:  0000_0001  0x01    1    
  353	:  0000_0000  0x00    0    
  354	:  0000_0000  0x00    0    
  355	:  0010_1010  0x2A   42  *  
  356	:  0011_0000  0x30   48  0  
  357	:  0000_0000  0x00    0    
  358	:  0000_0100  0x04    4    
  359	:  0010_1101  0x2D   45  -  
  360	:  0100_0011  0x43   67  C  
  361	:  0011_0010  0x32   50  2  
  362	:  0000_0110  0x06    6    
  363	:  0000_1000  0x08    8    
  364	:  0100_0001  0x41   65  A  
  365	:  0010_1101  0x2D   45  -  
  366	:  0011_0101  0x35   53  5  
  367	:  0011_0000  0x30   48  0  
  368	:  0010_1101  0x2D   45  -  
  369	:  0011_0000  0x30   48  0  
  370	:  0011_0000  0x30   48  0  
  371	:  0011_0111  0x37   55  7  
  372	:  1100_0000  0xC0  192    
  373	:  0000_1100  0x0C   12    
  374	:  0000_0000  0x00    0    
  375	:  0000_0001  0x01    1    
  376	:  0000_0000  0x00    0    
  377	:  0000_0001  0x01    1    
  378	:  0000_0000  0x00    0    
  379	:  0000_0000  0x00    0    
  380	:  0010_1010  0x2A   42  *  
  381	:  0011_0000  0x30   48  0  
  382	:  0000_0000  0x00    0    
  383	:  0000_0100  0x04    4    
  384	:  0010_1101  0x2D   45  -  
  385	:  0100_0011  0x43   67  C  
  386	:  0011_0010  0x32   50  2  
  387	:  0000_0111  0x07    7    
  388	:  0000_1000  0x08    8    
  389	:  0100_0001  0x41   65  A  
  390	:  0010_1101  0x2D   45  -  
  391	:  0011_0101  0x35   53  5  
  392	:  0011_0000  0x30   48  0  
  393	:  0010_1101  0x2D   45  -  
  394	:  0011_0000  0x30   48  0  
  395	:  0011_0000  0x30   48  0  
  396	:  0011_1000  0x38   56  8  
  397	:  1100_0000  0xC0  192    
  398	:  0000_1100  0x0C   12    
  399	:  0000_0000  0x00    0    
  400	:  0000_0001  0x01    1    
  401	:  0000_0000  0x00    0    
  402	:  0000_0001  0x01    1    
  403	:  0000_0000  0x00    0    
  404	:  0000_0000  0x00    0    
  405	:  0010_1010  0x2A   42  *  
  406	:  0011_0000  0x30   48  0  
  407	:  0000_0000  0x00    0    
  408	:  0000_0100  0x04    4    
  409	:  0010_1101  0x2D   45  -  
  410	:  0100_0011  0x43   67  C  
  411	:  0011_0010  0x32   50  2  
  412	:  0000_1000  0x08    8    
  413	:  0000_1000  0x08    8    
  414	:  0100_0001  0x41   65  A  
  415	:  0010_1101  0x2D   45  -  
  416	:  0011_0101  0x35   53  5  
  417	:  0011_0000  0x30   48  0  
  418	:  0010_1101  0x2D   45  -  
  419	:  0011_0000  0x30   48  0  
  420	:  0011_0000  0x30   48  0  
  421	:  0011_1001  0x39   57  9  
  422	:  1100_0000  0xC0  192    
  423	:  0000_1100  0x0C   12    
  424	:  0000_0000  0x00    0    
  425	:  0000_0001  0x01    1    
  426	:  0000_0000  0x00    0    
  427	:  0000_0001  0x01    1    
  428	:  0000_0000  0x00    0    
  429	:  0000_0000  0x00    0    
  430	:  0010_1010  0x2A   42  *  
  431	:  0011_0000  0x30   48  0  
  432	:  0000_0000  0x00    0    
  433	:  0000_0100  0x04    4    
  434	:  0010_1101  0x2D   45  -  
  435	:  0100_0011  0x43   67  C  
  436	:  0011_0010  0x32   50  2  
  437	:  0000_1001  0x09    9    
  438	:  0000_1000  0x08    8    
  439	:  0100_0001  0x41   65  A  
  440	:  0010_1101  0x2D   45  -  
  441	:  0011_0101  0x35   53  5  
  442	:  0011_0000  0x30   48  0  
  443	:  0010_1101  0x2D   45  -  
  444	:  0011_0000  0x30   48  0  
  445	:  0011_0001  0x31   49  1  
  446	:  0011_0000  0x30   48  0  
  447	:  1100_0000  0xC0  192    
  448	:  0000_1100  0x0C   12    
  449	:  0000_0000  0x00    0    
  450	:  0000_0001  0x01    1    
  451	:  0000_0000  0x00    0    
  452	:  0000_0001  0x01    1    
  453	:  0000_0000  0x00    0    
  454	:  0000_0000  0x00    0    
  455	:  0010_1010  0x2A   42  *  
  456	:  0011_0000  0x30   48  0  
  457	:  0000_0000  0x00    0    
  458	:  0000_0100  0x04    4    
  459	:  0010_1101  0x2D   45  -  
  460	:  0100_0011  0x43   67  C  
  461	:  0011_0010  0x32   50  2  
  462	:  0000_1010  0x0A   10    
  463	:  0000_1000  0x08    8    
  464	:  0100_0001  0x41   65  A  
  465	:  0010_1101  0x2D   45  -  
  466	:  0011_0101  0x35   53  5  
  467	:  0011_0000  0x30   48  0  
  468	:  0010_1101  0x2D   45  -  
  469	:  0011_0000  0x30   48  0  
  470	:  0011_0001  0x31   49  1  
  471	:  0011_0001  0x31   49  1  
  472	:  1100_0000  0xC0  192    
  473	:  0000_1100  0x0C   12    
  474	:  0000_0000  0x00    0    
  475	:  0000_0001  0x01    1    
  476	:  0000_0000  0x00    0    
  477	:  0000_0001  0x01    1    
  478	:  0000_0000  0x00    0    
  479	:  0000_0000  0x00    0    
  480	:  0010_1010  0x2A   42  *  
  481	:  0011_0000  0x30   48  0  
  482	:  0000_0000  0x00    0    
  483	:  0000_0100  0x04    4    
  484	:  0010_1101  0x2D   45  -  
  485	:  0100_0011  0x43   67  C  
  486	:  0011_0010  0x32   50  2  
  487	:  0000_1011  0x0B   11    
  488	:  0000_1000  0x08    8    
  489	:  0100_0001  0x41   65  A  
  490	:  0010_1101  0x2D   45  -  
  491	:  0011_0101  0x35   53  5  
  492	:  0011_0000  0x30   48  0  
  493	:  0010_1101  0x2D   45  -  
  494	:  0011_0000  0x30   48  0  
  495	:  0011_0001  0x31   49  1  
  496	:  0011_0010  0x32   50  2  
  497	:  1100_0000  0xC0  192    
  498	:  0000_1100  0x0C   12    
  499	:  0000_0000  0x00    0    
  500	:  0000_0001  0x01    1    
  501	:  0000_0000  0x00    0    
  502	:  0000_0001  0x01    1    
  503	:  0000_0000  0x00    0    
  504	:  0000_0000  0x00    0    
  505	:  0010_1010  0x2A   42  *  
  506	:  0011_0000  0x30   48  0  
  507	:  0000_0000  0x00    0    
  508	:  0000_0100  0x04    4    
  509	:  0010_1101  0x2D   45  -  
  510	:  0100_0011  0x43   67  C  
  511	:  0011_0010  0x32   50  2  
  512	:  0000_1100  0x0C   12    
  513	:  0000_1000  0x08    8    
  514	:  0100_0001  0x41   65  A  
  515	:  0010_1101  0x2D   45  -  
  516	:  0011_0101  0x35   53  5  
  517	:  0011_0000  0x30   48  0  
  518	:  0010_1101  0x2D   45  -  
  519	:  0011_0000  0x30   48  0  
  520	:  0011_0001  0x31   49  1  
  521	:  0011_0011  0x33   51  3  
  522	:  1100_0000  0xC0  192    
  523	:  0000_1100  0x0C   12    
  524	:  0000_0000  0x00    0    
  525	:  0000_0001  0x01    1    
  526	:  0000_0000  0x00    0    
  527	:  0000_0001  0x01    1    
  528	:  0000_0000  0x00    0    
  529	:  0000_0000  0x00    0    
  530	:  0010_1010  0x2A   42  *  
  531	:  0011_0000  0x30   48  0  
  532	:  0000_0000  0x00    0    
  533	:  0000_0100  0x04    4    
  534	:  0010_1101  0x2D   45  -  
  535	:  0100_0011  0x43   67  C  
  536	:  0011_0010  0x32   50  2  
  537	:  0000_1101  0x0D   13    
  538	:  0000_1000  0x08    8    
  539	:  0100_0001  0x41   65  A  
  540	:  0010_1101  0x2D   45  -  
  541	:  0011_0101  0x35   53  5  
  542	:  0011_0000  0x30   48  0  
  543	:  0010_1101  0x2D   45  -  
  544	:  0011_0000  0x30   48  0  
  545	:  0011_0001  0x31   49  1  
  546	:  0011_0100  0x34   52  4  
  547	:  1100_0000  0xC0  192    
  548	:  0000_1100  0x0C   12    
  549	:  0000_0000  0x00    0    
  550	:  0000_0001  0x01    1    
  551	:  0000_0000  0x00    0    
  552	:  0000_0001  0x01    1    
  553	:  0000_0000  0x00    0    
  554	:  0000_0000  0x00    0    
  555	:  0010_1010  0x2A   42  *  
  556	:  0011_0000  0x30   48  0  
  557	:  0000_0000  0x00    0    
  558	:  0000_0100  0x04    4    
  559	:  0010_1101  0x2D   45  -  
  560	:  0100_0011  0x43   67  C  
  561	:  0011_0010  0x32   50  2  
  562	:  0000_1110  0x0E   14    
  563	:  0000_1000  0x08    8    
  564	:  0100_0001  0x41   65  A  
  565	:  0010_1101  0x2D   45  -  
  566	:  0011_0101  0x35   53  5  
  567	:  0011_0000  0x30   48  0  
  568	:  0010_1101  0x2D   45  -  
  569	:  0011_0000  0x30   48  0  
  570	:  0011_0001  0x31   49  1  
  571	:  0011_0101  0x35   53  5  
  572	:  1100_0000  0xC0  192    
  573	:  0000_1100  0x0C   12    
  574	:  0000_0000  0x00    0    
  575	:  0000_0001  0x01    1    
  576	:  0000_0000  0x00    0    
  577	:  0000_0001  0x01    1    
  578	:  0000_0000  0x00    0    
  579	:  0000_0000  0x00    0    
  580	:  0010_1010  0x2A   42  *  
  581	:  0011_0000  0x30   48  0  
  582	:  0000_0000  0x00    0    
  583	:  0000_0100  0x04    4    
  584	:  0010_1101  0x2D   45  -  
  585	:  0100_0011  0x43   67  C  
  586	:  0011_0010  0x32   50  2  
  587	:  0000_1111  0x0F   15    
  588	:  0000_1000  0x08    8    
  589	:  0100_0001  0x41   65  A  
  590	:  0010_1101  0x2D   45  -  
  591	:  0011_0101  0x35   53  5  
  592	:  0011_0000  0x30   48  0  
  593	:  0010_1101  0x2D   45  -  
  594	:  0011_0000  0x30   48  0  
  595	:  0011_0001  0x31   49  1  
  596	:  0011_0110  0x36   54  6  
  597	:  1100_0000  0xC0  192    
  598	:  0000_1100  0x0C   12    
  599	:  0000_0000  0x00    0    
  600	:  0000_0001  0x01    1    
  601	:  0000_0000  0x00    0    
  602	:  0000_0001  0x01    1    
  603	:  0000_0000  0x00    0    
  604	:  0000_0000  0x00    0    
  605	:  0010_1010  0x2A   42  *  
  606	:  0011_0000  0x30   48  0  
  607	:  0000_0000  0x00    0    
  608	:  0000_0100  0x04    4    
  609	:  0010_1101  0x2D   45  -  
  610	:  0100_0011  0x43   67  C  
  611	:  0011_0010  0x32   50  2  
  612	:  0001_0000  0x10   16    
  613	:  0000_1000  0x08    8    
  614	:  0100_0001  0x41   65  A  
  615	:  0010_1101  0x2D   45  -  
  616	:  0011_0101  0x35   53  5  
  617	:  0011_0000  0x30   48  0  
  618	:  0010_1101  0x2D   45  -  
  619	:  0011_0000  0x30   48  0  
  620	:  0011_0001  0x31   49  1  
  621	:  0011_0111  0x37   55  7  
  622	:  1100_0000  0xC0  192    
  623	:  0000_1100  0x0C   12    
  624	:  0000_0000  0x00    0    
  625	:  0000_0001  0x01    1    
  626	:  0000_0000  0x00    0    
  627	:  0000_0001  0x01    1    
  628	:  0000_0000  0x00    0    
  629	:  0000_0000  0x00    0    
  630	:  0010_1010  0x2A   42  *  
  631	:  0011_0000  0x30   48  0  
  632	:  0000_0000  0x00    0    
  633	:  0000_0100  0x04    4    
  634	:  0010_1101  0x2D   45  -  
  635	:  0100_0011  0x43   67  C  
  636	:  0011_0010  0x32   50  2  
  637	:  0001_0001  0x11   17    
  638	:  0000_1000  0x08    8    
  639	:  0100_0001  0x41   65  A  
  640	:  0010_1101  0x2D   45  -  
  641	:  0011_0101  0x35   53  5  
  642	:  0011_0000  0x30   48  0  
  643	:  0010_1101  0x2D   45  -  
  644	:  0011_0000  0x30   48  0  
  645	:  0011_0001  0x31   49  1  
  646	:  0011_1000  0x38   56  8  
  647	:  1100_0000  0xC0  192    
  648	:  0000_1100  0x0C   12    
  649	:  0000_0000  0x00    0    
  650	:  0000_0001  0x01    1    
  651	:  0000_0000  0x00    0    
  652	:  0000_0001  0x01    1    
  653	:  0000_0000  0x00    0    
  654	:  0000_0000  0x00    0    
  655	:  0010_1010  0x2A   42  *  
  656	:  0011_0000  0x30   48  0  
  657	:  0000_0000  0x00    0    
  658	:  0000_0100  0x04    4    
  659	:  0010_1101  0x2D   45  -  
  660	:  0100_0011  0x43   67  C  
  661	:  0011_0010  0x32   50  2  
  662	:  0001_0010  0x12   18    
  663	:  0000_1000  0x08    8    
  664	:  0100_0001  0x41   65  A  
  665	:  0010_1101  0x2D   45  -  
  666	:  0011_0101  0x35   53  5  
  667	:  0011_0000  0x30   48  0  
  668	:  0010_1101  0x2D   45  -  
  669	:  0011_0000  0x30   48  0  
  670	:  0011_0001  0x31   49  1  
  671	:  0011_1001  0x39   57  9  
  672	:  1100_0000  0xC0  192    
  673	:  0000_1100  0x0C   12    
  674	:  0000_0000  0x00    0    
  675	:  0000_0001  0x01    1    
  676	:  0000_0000  0x00    0    
  677	:  0000_0001  0x01    1    
  678	:  0000_0000  0x00    0    
  679	:  0000_0000  0x00    0    
  680	:  0010_1010  0x2A   42  *  
  681	:  0011_0000  0x30   48  0  
  682	:  0000_0000  0x00    0    
  683	:  0000_0100  0x04    4    
  684	:  0010_1101  0x2D   45  -  
  685	:  0100_0011  0x43   67  C  
  686	:  0011_0010  0x32   50  2  
  687	:  0001_0011  0x13   19    
  688	:  0000_1000  0x08    8    
  689	:  0100_0001  0x41   65  A  
  690	:  0010_1101  0x2D   45  -  
  691	:  0011_0101  0x35   53  5  
  692	:  0011_0000  0x30   48  0  
  693	:  0010_1101  0x2D   45  -  
  694	:  0011_0000  0x30   48  0  
  695	:  0011_0010  0x32   50  2  
  696	:  0011_0000  0x30   48  0  
  697	:  1100_0000  0xC0  192    
  698	:  0000_1100  0x0C   12    
  699	:  0000_0000  0x00    0    
  700	:  0000_0001  0x01    1    
  701	:  0000_0000  0x00    0    
  702	:  0000_0001  0x01    1    
  703	:  0000_0000  0x00    0    
  704	:  0000_0000  0x00    0    
  705	:  0010_1010  0x2A   42  *  
  706	:  0011_0000  0x30   48  0  
  707	:  0000_0000  0x00    0    
  708	:  0000_0100  0x04    4    
  709	:  0010_1101  0x2D   45  -  
  710	:  0100_0011  0x43   67  C  
  711	:  0011_0010  0x32   50  2  
  712	:  0001_0100  0x14   20    
  713	:  0000_1000  0x08    8    
  714	:  0100_0001  0x41   65  A  
  715	:  0010_1101  0x2D   45  -  
  716	:  0011_0101  0x35   53  5  
  717	:  0011_0000  0x30   48  0  
  718	:  0010_1101  0x2D   45  -  
  719	:  0011_0000  0x30   48  0  
  720	:  0011_0010  0x32   50  2  
  721	:  0011_0001  0x31   49  1  
  722	:  1100_0000  0xC0  192    
  723	:  0000_1100  0x0C   12    
  724	:  0000_0000  0x00    0    
  725	:  0000_0001  0x01    1    
  726	:  0000_0000  0x00    0    
  727	:  0000_0001  0x01    1    
  728	:  0000_0000  0x00    0    
  729	:  0000_0000  0x00    0    
  730	:  0010_1010  0x2A   42  *  
  731	:  0011_0000  0x30   48  0  
  732	:  0000_0000  0x00    0    
  733	:  0000_0100  0x04    4    
  734	:  0010_1101  0x2D   45  -  
  735	:  0100_0011  0x43   67  C  
  736	:  0011_0010  0x32   50  2  
  737	:  0001_0101  0x15   21    
  738	:  0000_1000  0x08    8    
  739	:  0100_0001  0x41   65  A  
  740	:  0010_1101  0x2D   45  -  
  741	:  0011_0101  0x35   53  5  
  742	:  0011_0000  0x30   48  0  
  743	:  0010_1101  0x2D   45  -  
  744	:  0011_0000  0x30   48  0  
  745	:  0011_0010  0x32   50  2  
  746	:  0011_0010  0x32   50  2  
  747	:  1100_0000  0xC0  192    
  748	:  0000_1100  0x0C   12    
  749	:  0000_0000  0x00    0    
  750	:  0000_0001  0x01    1    
  751	:  0000_0000  0x00    0    
  752	:  0000_0001  0x01    1    
  753	:  0000_0000  0x00    0    
  754	:  0000_0000  0x00    0    
  755	:  0010_1010  0x2A   42  *  
  756	:  0011_0000  0x30   48  0  
  757	:  0000_0000  0x00    0    
  758	:  0000_0100  0x04    4    
  759	:  0010_1101  0x2D   45  -  
  760	:  0100_0011  0x43   67  C  
  761	:  0011_0010  0x32   50  2  
  762	:  0001_0110  0x16   22    
  763	:  0000_1000  0x08    8    
  764	:  0100_0001  0x41   65  A  
  765	:  0010_1101  0x2D   45  -  
  766	:  0011_0101  0x35   53  5  
  767	:  0011_0000  0x30   48  0  
  768	:  0010_1101  0x2D   45  -  
  769	:  0011_0000  0x30   48  0  
  770	:  0011_0010  0x32   50  2  
  771	:  0011_0011  0x33   51  3  
  772	:  1100_0000  0xC0  192    
  773	:  0000_1100  0x0C   12    
  774	:  0000_0000  0x00    0    
  775	:  0000_0001  0x01    1    
  776	:  0000_0000  0x00    0    
  777	:  0000_0001  0x01    1    
  778	:  0000_0000  0x00    0    
  779	:  0000_0000  0x00    0    
  780	:  0010_1010  0x2A   42  *  
  781	:  0011_0000  0x30   48  0  
  782	:  0000_0000  0x00    0    
  783	:  0000_0100  0x04    4    
  784	:  0010_1101  0x2D   45  -  
  785	:  0100_0011  0x43   67  C  
  786	:  0011_0010  0x32   50  2  
  787	:  0001_0111  0x17   23    
  788	:  0000_1000  0x08    8    
  789	:  0100_0001  0x41   65  A  
  790	:  0010_1101  0x2D   45  -  
  791	:  0011_0101  0x35   53  5  
  792	:  0011_0000  0x30   48  0  
  793	:  0010_1101  0x2D   45  -  
  794	:  0011_0000  0x30   48  0  
  795	:  0011_0010  0x32   50  2  
  796	:  0011_0100  0x34   52  4  
  797	:  1100_0000  0xC0  192    
  798	:  0000_1100  0x0C   12    
  799	:  0000_0000  0x00    0    
  800	:  0000_0001  0x01    1    
  801	:  0000_0000  0x00    0    
  802	:  0000_0001  0x01    1    
  803	:  0000_0000  0x00    0    
  804	:  0000_0000  0x00    0    
  805	:  0010_1010  0x2A   42  *  
  806	:  0011_0000  0x30   48  0  
  807	:  0000_0000  0x00    0    
  808	:  0000_0100  0x04    4    
  809	:  0010_1101  0x2D   45  -  
  810	:  0100_0011  0x43   67  C  
  811	:  0011_0010  0x32   50  2  
  812	:  0001_1000  0x18   24    
  813	:  0000_1000  0x08    8    
  814	:  0100_0001  0x41   65  A  
  815	:  0010_1101  0x2D   45  -  
  816	:  0011_0101  0x35   53  5  
  817	:  0011_0000  0x30   48  0  
  818	:  0010_1101  0x2D   45  -  
  819	:  0011_0000  0x30   48  0  
  820	:  0011_0010  0x32   50  2  
  821	:  0011_0101  0x35   53  5  
  822	:  1100_0000  0xC0  192    
  823	:  0000_1100  0x0C   12    
  824	:  0000_0000  0x00    0    
  825	:  0000_0001  0x01    1    
  826	:  0000_0000  0x00    0    
  827	:  0000_0001  0x01    1    
  828	:  0000_0000  0x00    0    
  829	:  0000_0000  0x00    0    
  830	:  0010_1010  0x2A   42  *  
  831	:  0011_0000  0x30   48  0  
  832	:  0000_0000  0x00    0    
  833	:  0000_0100  0x04    4    
  834	:  0010_1101  0x2D   45  -  
  835	:  0100_0011  0x43   67  C  
  836	:  0011_0010  0x32   50  2  
  837	:  0001_1001  0x19   25    
  838	:  0000_1000  0x08    8    
  839	:  0100_0001  0x41   65  A  
  840	:  0010_1101  0x2D   45  -  
  841	:  0011_0101  0x35   53  5  
  842	:  0011_0000  0x30   48  0  
  843	:  0010_1101  0x2D   45  -  
  844	:  0011_0000  0x30   48  0  
  845	:  0011_0010  0x32   50  2  
  846	:  0011_0110  0x36   54  6  
  847	:  1100_0000  0xC0  192    
  848	:  0000_1100  0x0C   12    
  849	:  0000_0000  0x00    0    
  850	:  0000_0001  0x01    1    
  851	:  0000_0000  0x00    0    
  852	:  0000_0001  0x01    1    
  853	:  0000_0000  0x00    0    
  854	:  0000_0000  0x00    0    
  855	:  0010_1010  0x2A   42  *  
  856	:  0011_0000  0x30   48  0  
  857	:  0000_0000  0x00    0    
  858	:  0000_0100  0x04    4    
  859	:  0010_1101  0x2D   45  -  
  860	:  0100_0011  0x43   67  C  
  861	:  0011_0010  0x32   50  2  
  862	:  0001_1010  0x1A   26    
  863	:  0000_1000  0x08    8    
  864	:  0100_0001  0x41   65  A  
  865	:  0010_1101  0x2D   45  -  
  866	:  0011_0101  0x35   53  5  
  867	:  0011_0000  0x30   48  0  
  868	:  0010_1101  0x2D   45  -  
  869	:  0011_0000  0x30   48  0  
  870	:  0011_0010  0x32   50  2  
  871	:  0011_0111  0x37   55  7  
  872	:  1100_0000  0xC0  192    
  873	:  0000_1100  0x0C   12    
  874	:  0000_0000  0x00    0    
  875	:  0000_0001  0x01    1    
  876	:  0000_0000  0x00    0    
  877	:  0000_0001  0x01    1    
  878	:  0000_0000  0x00    0    
  879	:  0000_0000  0x00    0    
  880	:  0010_1010  0x2A   42  *  
  881	:  0011_0000  0x30   48  0  
  882	:  0000_0000  0x00    0    
  883	:  0000_0100  0x04    4    
  884	:  0010_1101  0x2D   45  -  
  885	:  0100_0011  0x43   67  C  
  886	:  0011_0010  0x32   50  2  
  887	:  0001_1011  0x1B   27    
  888	:  0000_1000  0x08    8    
  889	:  0100_0001  0x41   65  A  
  890	:  0010_1101  0x2D   45  -  
  891	:  0011_0101  0x35   53  5  
  892	:  0011_0000  0x30   48  0  
  893	:  0010_1101  0x2D   45  -  
  894	:  0011_0000  0x30   48  0  
  895	:  0011_0010  0x32   50  2  
  896	:  0011_1000  0x38   56  8  
  897	:  1100_0000  0xC0  192    
  898	:  0000_1100  0x0C   12    
  899	:  0000_0000  0x00    0    
  900	:  0000_0001  0x01    1    
  901	:  0000_0000  0x00    0    
  902	:  0000_0001  0x01    1    
  903	:  0000_0000  0x00    0    
  904	:  0000_0000  0x00    0    
  905	:  0010_1010  0x2A   42  *  
  906	:  0011_0000  0x30   48  0  
  907	:  0000_0000  0x00    0    
  908	:  0000_0100  0x04    4    
  909	:  0010_1101  0x2D   45  -  
  910	:  0100_0011  0x43   67  C  
  911	:  0011_0010  0x32   50  2  
  912	:  0001_1100  0x1C   28    
  913	:  0000_1000  0x08    8    
  914	:  0100_0001  0x41   65  A  
  915	:  0010_1101  0x2D   45  -  
  916	:  0011_0101  0x35   53  5  
  917	:  0011_0000  0x30   48  0  
  918	:  0010_1101  0x2D   45  -  
  919	:  0011_0000  0x30   48  0  
  920	:  0011_0010  0x32   50  2  
  921	:  0011_1001  0x39   57  9  
  922	:  1100_0000  0xC0  192    
  923	:  0000_1100  0x0C   12    
  924	:  0000_0000  0x00    0    
  925	:  0000_0001  0x01    1    
  926	:  0000_0000  0x00    0    
  927	:  0000_0001  0x01    1    
  928	:  0000_0000  0x00    0    
  929	:  0000_0000  0x00    0    
  930	:  0010_1010  0x2A   42  *  
  931	:  0011_0000  0x30   48  0  
  932	:  0000_0000  0x00    0    
  933	:  0000_0100  0x04    4    
  934	:  0010_1101  0x2D   45  -  
  935	:  0100_0011  0x43   67  C  
  936	:  0011_0010  0x32   50  2  
  937	:  0001_1101  0x1D   29    
  938	:  0000_1000  0x08    8    
  939	:  0100_0001  0x41   65  A  
  940	:  0010_1101  0x2D   45  -  
  941	:  0011_0101  0x35   53  5  
  942	:  0011_0000  0x30   48  0  
  943	:  0010_1101  0x2D   45  -  
  944	:  0011_0000  0x30   48  0  
  945	:  0011_0011  0x33   51  3  
  946	:  0011_0000  0x30   48  0  
  947	:  1100_0000  0xC0  192    
  948	:  0000_1100  0x0C   12    
  949	:  0000_0000  0x00    0    
  950	:  0000_0001  0x01    1    
  951	:  0000_0000  0x00    0    
  952	:  0000_0001  0x01    1    
  953	:  0000_0000  0x00    0    
  954	:  0000_0000  0x00    0    
  955	:  0010_1010  0x2A   42  *  
  956	:  0011_0000  0x30   48  0  
  957	:  0000_0000  0x00    0    
  958	:  0000_0100  0x04    4    
  959	:  0010_1101  0x2D   45  -  
  960	:  0100_0011  0x43   67  C  
  961	:  0011_0010  0x32   50  2  
  962	:  0001_1110  0x1E   30    
  963	:  0000_1000  0x08    8    
  964	:  0100_0001  0x41   65  A  
  965	:  0010_1101  0x2D   45  -  
  966	:  0011_0101  0x35   53  5  
  967	:  0011_0000  0x30   48  0  
  968	:  0010_1101  0x2D   45  -  
  969	:  0011_0000  0x30   48  0  
  970	:  0011_0011  0x33   51  3  
  971	:  0011_0001  0x31   49  1  
  972	:  1100_0000  0xC0  192    
  973	:  0000_1100  0x0C   12    
  974	:  0000_0000  0x00    0    
  975	:  0000_0001  0x01    1    
  976	:  0000_0000  0x00    0    
  977	:  0000_0001  0x01    1    
  978	:  0000_0000  0x00    0    
  979	:  0000_0000  0x00    0    
  980	:  0010_1010  0x2A   42  *  
  981	:  0011_0000  0x30   48  0  
  982	:  0000_0000  0x00    0    
  983	:  0000_0100  0x04    4    
  984	:  0010_1101  0x2D   45  -  
  985	:  0100_0011  0x43   67  C  
  986	:  0011_0010  0x32   50  2  
  987	:  0001_1111  0x1F   31    
  988	:  0000_1000  0x08    8    
  989	:  0100_0001  0x41   65  A  
  990	:  0010_1101  0x2D   45  -  
  991	:  0011_0101  0x35   53  5  
  992	:  0011_0000  0x30   48  0  
  993	:  0010_1101  0x2D   45  -  
  994	:  0011_0000  0x30   48  0  
  995	:  0011_0011  0x33   51  3  
  996	:  0011_0010  0x32   50  2  
  997	:  1100_0000  0xC0  192    
  998	:  0000_1100  0x0C   12    
  999	:  0000_0000  0x00    0    
  1000	:  0000_0001  0x01    1    
  1001	:  0000_0000  0x00    0    
  1002	:  0000_0001  0x01    1    
  1003	:  0000_0000  0x00    0    
  1004	:  0000_0000  0x00    0    
  1005	:  0010_1010  0x2A   42  *  
  1006	:  0011_0000  0x30   48  0  
  1007	:  0000_0000  0x00    0    
  1008	:  0000_0100  0x04    4    
  1009	:  0010_1101  0x2D   45  -  
  1010	:  0100_0011  0x43   67  C  
  1011	:  0011_0010  0x32   50  2  
  1012	:  0010_0000  0x20   32     
  1013	:  0000_1000  0x08    8    
  1014	:  0100_0001  0x41   65  A  
  1015	:  0010_1101  0x2D   45  -  
  1016	:  0011_0101  0x35   53  5  
  1017	:  0011_0000  0x30   48  0  
  1018	:  0010_1101  0x2D   45  -  
  1019	:  0011_0000  0x30   48  0  
  1020	:  0011_0011  0x33   51  3  
  1021	:  0011_0011  0x33   51  3  
  1022	:  1100_0000  0xC0  192    
  1023	:  0000_1100  0x0C   12    
  1024	:  0000_0000  0x00    0    
  1025	:  0000_0001  0x01    1    
  1026	:  0000_0000  0x00    0    
  1027	:  0000_0001  0x01    1    
  1028	:  0000_0000  0x00    0    
  1029	:  0000_0000  0x00    0    
  1030	:  0010_1010  0x2A   42  *  
  1031	:  0011_0000  0x30   48  0  
  1032	:  0000_0000  0x00    0    
  1033	:  0000_0100  0x04    4    
  1034	:  0010_1101  0x2D   45  -  
  1035	:  0100_0011  0x43   67  C  
  1036	:  0011_0010  0x32   50  2  
  1037	:  0010_0001  0x21   33  !  
  1038	:  0000_1000  0x08    8    
  1039	:  0100_0001  0x41   65  A  
  1040	:  0010_1101  0x2D   45  -  
  1041	:  0011_0101  0x35   53  5  
  1042	:  0011_0000  0x30   48  0  
  1043	:  0010_1101  0x2D   45  -  
  1044	:  0011_0000  0x30   48  0  
  1045	:  0011_0011  0x33   51  3  
  1046	:  0011_0100  0x34   52  4  
  1047	:  1100_0000  0xC0  192    
  1048	:  0000_1100  0x0C   12    
  1049	:  0000_0000  0x00    0    
  1050	:  0000_0001  0x01    1    
  1051	:  0000_0000  0x00    0    
  1052	:  0000_0001  0x01    1    
  1053	:  0000_0000  0x00    0    
  1054	:  0000_0000  0x00    0    
  1055	:  0010_1010  0x2A   42  *  
  1056	:  0011_0000  0x30   48  0  
  1057	:  0000_0000  0x00    0    
  1058	:  0000_0100  0x04    4    
  1059	:  0010_1101  0x2D   45  -  
  1060	:  0100_0011  0x43   67  C  
  1061	:  0011_0010  0x32   50  2  
  1062	:  0010_0010  0x22   34  "  
  1063	:  0000_1000  0x08    8    
  1064	:  0100_0001  0x41   65  A  
  1065	:  0010_1101  0x2D   45  -  
  1066	:  0011_0101  0x35   53  5  
  1067	:  0011_0000  0x30   48  0  
  1068	:  0010_1101  0x2D   45  -  
  1069	:  0011_0000  0x30   48  0  
  1070	:  0011_0011  0x33   51  3  
  1071	:  0011_0101  0x35   53  5  
  1072	:  1100_0000  0xC0  192    
  1073	:  0000_1100  0x0C   12    
  1074	:  0000_0000  0x00    0    
  1075	:  0000_0001  0x01    1    
  1076	:  0000_0000  0x00    0    
  1077	:  0000_0001  0x01    1    
  1078	:  0000_0000  0x00    0    
  1079	:  0000_0000  0x00    0    
  1080	:  0010_1010  0x2A   42  *  
  1081	:  0011_0000  0x30   48  0  
  1082	:  0000_0000  0x00    0    
  1083	:  0000_0100  0x04    4    
  1084	:  0010_1101  0x2D   45  -  
  1085	:  0100_0011  0x43   67  C  
  1086	:  0011_0010  0x32   50  2  
  1087	:  0010_0011  0x23   35  #  
  1088	:  0000_1000  0x08    8    
  1089	:  0100_0001  0x41   65  A  
  1090	:  0010_1101  0x2D   45  -  
  1091	:  0011_0101  0x35   53  5  
  1092	:  0011_0000  0x30   48  0  
  1093	:  0010_1101  0x2D   45  -  
  1094	:  0011_0000  0x30   48  0  
  1095	:  0011_0011  0x33   51  3  
  1096	:  0011_0110  0x36   54  6  
  1097	:  1100_0000  0xC0  192    
  1098	:  0000_1100  0x0C   12    
  1099	:  0000_0000  0x00    0    
  1100	:  0000_0001  0x01    1    
  1101	:  0000_0000  0x00    0    
  1102	:  0000_0001  0x01    1    
  1103	:  0000_0000  0x00    0    
  1104	:  0000_0000  0x00    0    
  1105	:  0010_1010  0x2A   42  *  
  1106	:  0011_0000  0x30   48  0  
  1107	:  0000_0000  0x00    0    
  1108	:  0000_0100  0x04    4    
  1109	:  0010_1101  0x2D   45  -  
  1110	:  0100_0011  0x43   67  C  
  1111	:  0011_0010  0x32   50  2  
  1112	:  0010_0100  0x24   36  $  
  1113	:  0000_1000  0x08    8    
  1114	:  0100_0001  0x41   65  A  
  1115	:  0010_1101  0x2D   45  -  
  1116	:  0011_0101  0x35   53  5  
  1117	:  0011_0000  0x30   48  0  
  1118	:  0010_1101  0x2D   45  -  
  1119	:  0011_0000  0x30   48  0  
  1120	:  0011_0011  0x33   51  3  
  1121	:  0011_0111  0x37   55  7  
  1122	:  1100_0000  0xC0  192    
  1123	:  0000_1100  0x0C   12    
  1124	:  0000_0000  0x00    0    
  1125	:  0000_0001  0x01    1    
  1126	:  0000_0000  0x00    0    
  1127	:  0000_0001  0x01    1    
  1128	:  0000_0000  0x00    0    
  1129	:  0000_0000  0x00    0    
  1130	:  0010_1010  0x2A   42  *  
  1131	:  0011_0000  0x30   48  0  
  1132	:  0000_0000  0x00    0    
  1133	:  0000_0100  0x04    4    
  1134	:  0010_1101  0x2D   45  -  
  1135	:  0100_0011  0x43   67  C  
  1136	:  0011_0010  0x32   50  2  
  1137	:  0010_0101  0x25   37  %  
  1138	:  0000_1000  0x08    8    
  1139	:  0100_0001  0x41   65  A  
  1140	:  0010_1101  0x2D   45  -  
  1141	:  0011_0101  0x35   53  5  
  1142	:  0011_0000  0x30   48  0  
  1143	:  0010_1101  0x2D   45  -  
  1144	:  0011_0000  0x30   48  0  
  1145	:  0011_0011  0x33   51  3  
  1146	:  0011_1000  0x38   56  8  
  1147	:  1100_0000  0xC0  192    
  1148	:  0000_1100  0x0C   12    
  1149	:  0000_0000  0x00    0    
  1150	:  0000_0001  0x01    1    
  1151	:  0000_0000  0x00    0    
  1152	:  0000_0001  0x01    1    
  1153	:  0000_0000  0x00    0    
  1154	:  0000_0000  0x00    0    
  1155	:  0010_1010  0x2A   42  *  
  1156	:  0011_0000  0x30   48  0  
  1157	:  0000_0000  0x00    0    
  1158	:  0000_0100  0x04    4    
  1159	:  0010_1101  0x2D   45  -  
  1160	:  0100_0011  0x43   67  C  
  1161	:  0011_0010  0x32   50  2  
  1162	:  0010_0110  0x26   38  &  
  1163	:  0000_1000  0x08    8    
  1164	:  0100_0001  0x41   65  A  
  1165	:  0010_1101  0x2D   45  -  
  1166	:  0011_0101  0x35   53  5  
  1167	:  0011_0000  0x30   48  0  
  1168	:  0010_1101  0x2D   45  -  
  1169	:  0011_0000  0x30   48  0  
  1170	:  0011_0011  0x33   51  3  
  1171	:  0011_1001  0x39   57  9  
  1172	:  1100_0000  0xC0  192    
  1173	:  0000_1100  0x0C   12    
  1174	:  0000_0000  0x00    0    
  1175	:  0000_0001  0x01    1    
  1176	:  0000_0000  0x00    0    
  1177	:  0000_0001  0x01    1    
  1178	:  0000_0000  0x00    0    
  1179	:  0000_0000  0x00    0    
  1180	:  0010_1010  0x2A   42  *  
  1181	:  0011_0000  0x30   48  0  
  1182	:  0000_0000  0x00    0    
  1183	:  0000_0100  0x04    4    
  1184	:  0010_1101  0x2D   45  -  
  1185	:  0100_0011  0x43   67  C  
  1186	:  0011_0010  0x32   50  2  
  1187	:  0010_0111  0x27   39  '  
  1188	:  0000_1000  0x08    8    
  1189	:  0100_0001  0x41   65  A  
  1190	:  0010_1101  0x2D   45  -  
  1191	:  0011_0101  0x35   53  5  
  1192	:  0011_0000  0x30   48  0  
  1193	:  0010_1101  0x2D   45  -  
  1194	:  0011_0000  0x30   48  0  
  1195	:  0011_0100  0x34   52  4  
  1196	:  0011_0000  0x30   48  0  
  1197	:  1100_0000  0xC0  192    
  1198	:  0000_1100  0x0C   12    
  1199	:  0000_0000  0x00    0    
  1200	:  0000_0001  0x01    1    
  1201	:  0000_0000  0x00    0    
  1202	:  0000_0001  0x01    1    
  1203	:  0000_0000  0x00    0    
  1204	:  0000_0000  0x00    0    
  1205	:  0010_1010  0x2A   42  *  
  1206	:  0011_0000  0x30   48  0  
  1207	:  0000_0000  0x00    0    
  1208	:  0000_0100  0x04    4    
  1209	:  0010_1101  0x2D   45  -  
  1210	:  0100_0011  0x43   67  C  
  1211	:  0011_0010  0x32   50  2  
  1212	:  0010_1000  0x28   40  (  
  1213	:  0000_1000  0x08    8    
  1214	:  0100_0001  0x41   65  A  
  1215	:  0010_1101  0x2D   45  -  
  1216	:  0011_0101  0x35   53  5  
  1217	:  0011_0000  0x30   48  0  
  1218	:  0010_1101  0x2D   45  -  
  1219	:  0011_0000  0x30   48  0  
  1220	:  0011_0100  0x34   52  4  
  1221	:  0011_0001  0x31   49  1  
  1222	:  1100_0000  0xC0  192    
  1223	:  0000_1100  0x0C   12    
  1224	:  0000_0000  0x00    0    
  1225	:  0000_0001  0x01    1    
  1226	:  0000_0000  0x00    0    
  1227	:  0000_0001  0x01    1    
  1228	:  0000_0000  0x00    0    
  1229	:  0000_0000  0x00    0    
  1230	:  0010_1010  0x2A   42  *  
  1231	:  0011_0000  0x30   48  0  
  1232	:  0000_0000  0x00    0    
  1233	:  0000_0100  0x04    4    
  1234	:  0010_1101  0x2D   45  -  
  1235	:  0100_0011  0x43   67  C  
  1236	:  0011_0010  0x32   50  2  
  1237	:  0010_1001  0x29   41  )  
  1238	:  0000_1000  0x08    8    
  1239	:  0100_0001  0x41   65  A  
  1240	:  0010_1101  0x2D   45  -  
  1241	:  0011_0101  0x35   53  5  
  1242	:  0011_0000  0x30   48  0  
  1243	:  0010_1101  0x2D   45  -  
  1244	:  0011_0000  0x30   48  0  
  1245	:  0011_0100  0x34   52  4  
  1246	:  0011_0010  0x32   50  2  
  1247	:  1100_0000  0xC0  192    
  1248	:  0000_1100  0x0C   12    
  1249	:  0000_0000  0x00    0    
  1250	:  0000_0001  0x01    1    
  1251	:  0000_0000  0x00    0    
  1252	:  0000_0001  0x01    1    
  1253	:  0000_0000  0x00    0    
  1254	:  0000_0000  0x00    0    
  1255	:  0010_1010  0x2A   42  *  
  1256	:  0011_0000  0x30   48  0  
  1257	:  0000_0000  0x00    0    
  1258	:  0000_0100  0x04    4    
  1259	:  0010_1101  0x2D   45  -  
  1260	:  0100_0011  0x43   67  C  
  1261	:  0011_0010  0x32   50  2  
  1262	:  0010_1010  0x2A   42  *  
  1263	:  0000_1000  0x08    8    
  1264	:  0100_0001  0x41   65  A  
  1265	:  0010_1101  0x2D   45  -  
  1266	:  0011_0101  0x35   53  5  
  1267	:  0011_0000  0x30   48  0  
  1268	:  0010_1101  0x2D   45  -  
  1269	:  0011_0000  0x30   48  0  
  1270	:  0011_0100  0x34   52  4  
  1271	:  0011_0011  0x33   51  3  
  1272	:  1100_0000  0xC0  192    
  1273	:  0000_1100  0x0C   12    
  1274	:  0000_0000  0x00    0    
  1275	:  0000_0001  0x01    1    
  1276	:  0000_0000  0x00    0    
  1277	:  0000_0001  0x01    1    
  1278	:  0000_0000  0x00    0    
  1279	:  0000_0000  0x00    0    
  1280	:  0010_1010  0x2A   42  *  
  1281	:  0011_0000  0x30   48  0  
  1282	:  0000_0000  0x00    0    
  1283	:  0000_0100  0x04    4    
  1284	:  0010_1101  0x2D   45  -  
  1285	:  0100_0011  0x43   67  C  
  1286	:  0011_0010  0x32   50  2  
  1287	:  0010_1011  0x2B   43  +  
  1288	:  0000_1000  0x08    8    
  1289	:  0100_0001  0x41   65  A  
  1290	:  0010_1101  0x2D   45  -  
  1291	:  0011_0101  0x35   53  5  
  1292	:  0011_0000  0x30   48  0  
  1293	:  0010_1101  0x2D   45  -  
  1294	:  0011_0000  0x30   48  0  
  1295	:  0011_0100  0x34   52  4  
  1296	:  0011_0100  0x34   52  4  
  1297	:  1100_0000  0xC0  192    
  1298	:  0000_1100  0x0C   12    
  1299	:  0000_0000  0x00    0    
  1300	:  0000_0001  0x01    1    
  1301	:  0000_0000  0x00    0    
  1302	:  0000_0001  0x01    1    
  1303	:  0000_0000  0x00    0    
  1304	:  0000_0000  0x00    0    
  1305	:  0010_1010  0x2A   42  *  
  1306	:  0011_0000  0x30   48  0  
  1307	:  0000_0000  0x00    0    
  1308	:  0000_0100  0x04    4    
  1309	:  0010_1101  0x2D   45  -  
  1310	:  0100_0011  0x43   67  C  
  1311	:  0011_0010  0x32   50  2  
  1312	:  0010_1100  0x2C   44  ,  
  1313	:  0000_1000  0x08    8    
  1314	:  0100_0001  0x41   65  A  
  1315	:  0010_1101  0x2D   45  -  
  1316	:  0011_0101  0x35   53  5  
  1317	:  0011_0000  0x30   48  0  
  1318	:  0010_1101  0x2D   45  -  
  1319	:  0011_0000  0x30   48  0  
  1320	:  0011_0100  0x34   52  4  
  1321	:  0011_0101  0x35   53  5  
  1322	:  1100_0000  0xC0  192    
  1323	:  0000_1100  0x0C   12    
  1324	:  0000_0000  0x00    0    
  1325	:  0000_0001  0x01    1    
  1326	:  0000_0000  0x00    0    
  1327	:  0000_0001  0x01    1    
  1328	:  0000_0000  0x00    0    
  1329	:  0000_0000  0x00    0    
  1330	:  0010_1010  0x2A   42  *  
  1331	:  0011_0000  0x30   48  0  
  1332	:  0000_0000  0x00    0    
  1333	:  0000_0100  0x04    4    
  1334	:  0010_1101  0x2D   45  -  
  1335	:  0100_0011  0x43   67  C  
  1336	:  0011_0010  0x32   50  2  
  1337	:  0010_1101  0x2D   45  -  
  1338	:  0000_1000  0x08    8    
  1339	:  0100_0001  0x41   65  A  
  1340	:  0010_1101  0x2D   45  -  
  1341	:  0011_0101  0x35   53  5  
  1342	:  0011_0000  0x30   48  0  
  1343	:  0010_1101  0x2D   45  -  
  1344	:  0011_0000  0x30   48  0  
  1345	:  0011_0100  0x34   52  4  
  1346	:  0011_0110  0x36   54  6  
  1347	:  1100_0000  0xC0  192    
  1348	:  0000_1100  0x0C   12    
  1349	:  0000_0000  0x00    0    
  1350	:  0000_0001  0x01    1    
  1351	:  0000_0000  0x00    0    
  1352	:  0000_0001  0x01    1    
  1353	:  0000_0000  0x00    0    
  1354	:  0000_0000  0x00    0    
  1355	:  0010_1010  0x2A   42  *  
  1356	:  0011_0000  0x30   48  0  
  1357	:  0000_0000  0x00    0    
  1358	:  0000_0100  0x04    4    
  1359	:  0010_1101  0x2D   45  -  
  1360	:  0100_0011  0x43   67  C  
  1361	:  0011_0010  0x32   50  2  
  1362	:  0010_1110  0x2E   46  .  
  1363	:  0000_1000  0x08    8    
  1364	:  0100_0001  0x41   65  A  
  1365	:  0010_1101  0x2D   45  -  
  1366	:  0011_0101  0x35   53  5  
  1367	:  0011_0000  0x30   48  0  
  1368	:  0010_1101  0x2D   45  -  
  1369	:  0011_0000  0x30   48  0  
  1370	:  0011_0100  0x34   52  4  
  1371	:  0011_0111  0x37   55  7  
  1372	:  1100_0000  0xC0  192    
  1373	:  0000_1100  0x0C   12    
  1374	:  0000_0000  0x00    0    
  1375	:  0000_0001  0x01    1    
  1376	:  0000_0000  0x00    0    
  1377	:  0000_0001  0x01    1    
  1378	:  0000_0000  0x00    0    
  1379	:  0000_0000  0x00    0    
  1380	:  0010_1010  0x2A   42  *  
  1381	:  0011_0000  0x30   48  0  
  1382	:  0000_0000  0x00    0    
  1383	:  0000_0100  0x04    4    
  1384	:  0010_1101  0x2D   45  -  
  1385	:  0100_0011  0x43   67  C  
  1386	:  0011_0010  0x32   50  2  
  1387	:  0010_1111  0x2F   47  /  
  1388	:  0000_1000  0x08    8    
  1389	:  0100_0001  0x41   65  A  
  1390	:  0010_1101  0x2D   45  -  
  1391	:  0011_0101  0x35   53  5  
  1392	:  0011_0000  0x30   48  0  
  1393	:  0010_1101  0x2D   45  -  
  1394	:  0011_0000  0x30   48  0  
  1395	:  0011_0100  0x34   52  4  
  1396	:  0011_1000  0x38   56  8  
  1397	:  1100_0000  0xC0  192    
  1398	:  0000_1100  0x0C   12    
  1399	:  0000_0000  0x00    0    
  1400	:  0000_0001  0x01    1    
  1401	:  0000_0000  0x00    0    
  1402	:  0000_0001  0x01    1    
  1403	:  0000_0000  0x00    0    
  1404	:  0000_0000  0x00    0    
  1405	:  0010_1010  0x2A   42  *  
  1406	:  0011_0000  0x30   48  0  
  1407	:  0000_0000  0x00    0    
  1408	:  0000_0100  0x04    4    
  1409	:  0010_1101  0x2D   45  -  
  1410	:  0100_0011  0x43   67  C  
  1411	:  0011_0010  0x32   50  2  
  1412	:  0011_0000  0x30   48  0  
  1413	:  0000_1000  0x08    8    
  1414	:  0100_0001  0x41   65  A  
  1415	:  0010_1101  0x2D   45  -  
  1416	:  0011_0101  0x35   53  5  
  1417	:  0011_0000  0x30   48  0  
  1418	:  0010_1101  0x2D   45  -  
  1419	:  0011_0000  0x30   48  0  
  1420	:  0011_0100  0x34   52  4  
  1421	:  0011_1001  0x39   57  9  
  1422	:  1100_0000  0xC0  192    
  1423	:  0000_1100  0x0C   12    
  1424	:  0000_0000  0x00    0    
  1425	:  0000_0001  0x01    1    
  1426	:  0000_0000  0x00    0    
  1427	:  0000_0001  0x01    1    
  1428	:  0000_0000  0x00    0    
  1429	:  0000_0000  0x00    0    
  1430	:  0010_1010  0x2A   42  *  
  1431	:  0011_0000  0x30   48  0  
  1432	:  0000_0000  0x00    0    
  1433	:  0000_0100  0x04    4    
  1434	:  0010_1101  0x2D   45  -  
  1435	:  0100_0011  0x43   67  C  
  1436	:  0011_0010  0x32   50  2  
  1437	:  0011_0001  0x31   49  1  
  1438	:  0000_1000  0x08    8    
  1439	:  0100_0001  0x41   65  A  
  1440	:  0010_1101  0x2D   45  -  
  1441	:  0011_0101  0x35   53  5  
  1442	:  0011_0000  0x30   48  0  
  1443	:  0010_1101  0x2D   45  -  
  1444	:  0011_0000  0x30   48  0  
  1445	:  0011_0101  0x35   53  5  
  1446	:  0011_0000  0x30   48  0  
  1447	:  1100_0000  0xC0  192    
  1448	:  0000_1100  0x0C   12    
  1449	:  0000_0000  0x00    0    
  1450	:  0000_0001  0x01    1    
  1451	:  0000_0000  0x00    0    
  1452	:  0000_0001  0x01    1    
  1453	:  0000_0000  0x00    0    
  1454	:  0000_0000  0x00    0    
  1455	:  0010_1010  0x2A   42  *  
  1456	:  0011_0000  0x30   48  0  
  1457	:  0000_0000  0x00    0    
  1458	:  0000_0100  0x04    4    
  1459	:  0010_1101  0x2D   45  -  
  1460	:  0100_0011  0x43   67  C  
  1461	:  0011_0010  0x32   50  2  
  1462	:  0011_0010  0x32   50  2  
  1463	:  0000_1000  0x08    8    
  1464	:  0100_0001  0x41   65  A  
  1465	:  0010_1101  0x2D   45  -  
  1466	:  0011_0101  0x35   53  5  
  1467	:  0011_0000  0x30   48  0  
  1468	:  0010_1101  0x2D   45  -  
  1469	:  0011_0000  0x30   48  0  
  1470	:  0011_0101  0x35   53  5  
  1471	:  0011_0001  0x31   49  1  
  1472	:  1100_0000  0xC0  192    
  1473	:  0000_1100  0x0C   12    
  1474	:  0000_0000  0x00    0    
  1475	:  0000_0001  0x01    1    
  1476	:  0000_0000  0x00    0    
  1477	:  0000_0001  0x01    1    
  1478	:  0000_0000  0x00    0    
  1479	:  0000_0000  0x00    0    
  1480	:  0010_1010  0x2A   42  *  
  1481	:  0011_0000  0x30   48  0  
  1482	:  0000_0000  0x00    0    
  1483	:  0000_0100  0x04    4    
  1484	:  0010_1101  0x2D   45  -  
  1485	:  0100_0011  0x43   67  C  
  1486	:  0011_0010  0x32   50  2  
  1487	:  0011_0011  0x33   51  3  
  1488	:  0000_1000  0x08    8    
  1489	:  0100_0001  0x41   65  A  
  1490	:  0010_1101  0x2D   45  -  
  1491	:  0011_0101  0x35   53  5  
  1492	:  0011_0000  0x30   48  0  
  1493	:  0010_1101  0x2D   45  -  
  1494	:  0011_0000  0x30   48  0  
  1495	:  0011_0101  0x35   53  5  
  1496	:  0011_0010  0x32   50  2  
  1497	:  1100_0000  0xC0  192    
  1498	:  0000_1100  0x0C   12    
  1499	:  0000_0000  0x00    0    
  1500	:  0000_0001  0x01    1    
  1501	:  0000_0000  0x00    0    
  1502	:  0000_0001  0x01    1    
  1503	:  0000_0000  0x00    0    
  1504	:  0000_0000  0x00    0    
  1505	:  0010_1010  0x2A   42  *  
  1506	:  0011_0000  0x30   48  0  
  1507	:  0000_0000  0x00    0    
  1508	:  0000_0100  0x04    4    
  1509	:  0010_1101  0x2D   45  -  
  1510	:  0100_0011  0x43   67  C  
  1511	:  0011_0010  0x32   50  2  
  1512	:  0011_0100  0x34   52  4  
  1513	:  0000_1000  0x08    8    
  1514	:  0100_0001  0x41   65  A  
  1515	:  0010_1101  0x2D   45  -  
  1516	:  0011_0101  0x35   53  5  
  1517	:  0011_0000  0x30   48  0  
  1518	:  0010_1101  0x2D   45  -  
  1519	:  0011_0000  0x30   48  0  
  1520	:  0011_0101  0x35   53  5  
  1521	:  0011_0011  0x33   51  3  
  1522	:  1100_0000  0xC0  192    
  1523	:  0000_1100  0x0C   12    
  1524	:  0000_0000  0x00    0    
  1525	:  0000_0001  0x01    1    
  1526	:  0000_0000  0x00    0    
  1527	:  0000_0001  0x01    1    
  1528	:  0000_0000  0x00    0    
  1529	:  0000_0000  0x00    0    
  1530	:  0010_1010  0x2A   42  *  
  1531	:  0011_0000  0x30   48  0  
  1532	:  0000_0000  0x00    0    
  1533	:  0000_0100  0x04    4    
  1534	:  0010_1101  0x2D   45  -  
  1535	:  0100_0011  0x43   67  C  
  1536	:  0011_0010  0x32   50  2  
  1537	:  0011_0101  0x35   53  5  
  1538	:  0000_1000  0x08    8    
  1539	:  0100_0001  0x41   65  A  
  1540	:  0010_1101  0x2D   45  -  
  1541	:  0011_0101  0x35   53  5  
  1542	:  0011_0000  0x30   48  0  
  1543	:  0010_1101  0x2D   45  -  
  1544	:  0011_0000  0x30   48  0  
  1545	:  0011_0101  0x35   53  5  
  1546	:  0011_0100  0x34   52  4  
  1547	:  1100_0000  0xC0  192    
  1548	:  0000_1100  0x0C   12    
  1549	:  0000_0000  0x00    0    
  1550	:  0000_0001  0x01    1    
  1551	:  0000_0000  0x00    0    
  1552	:  0000_0001  0x01    1    
  1553	:  0000_0000  0x00    0    
  1554	:  0000_0000  0x00    0    
  1555	:  0010_1010  0x2A   42  *  
  1556	:  0011_0000  0x30   48  0  
  1557	:  0000_0000  0x00    0    
  1558	:  0000_0100  0x04    4    
  1559	:  0010_1101  0x2D   45  -  
  1560	:  0100_0011  0x43   67  C  
  1561	:  0011_0010  0x32   50  2  
  1562	:  0011_0110  0x36   54  6  
  1563	:  0000_1000  0x08    8    
  1564	:  0100_0001  0x41   65  A  
  1565	:  0010_1101  0x2D   45  -  
  1566	:  0011_0101  0x35   53  5  
  1567	:  0011_0000  0x30   48  0  
  1568	:  0010_1101  0x2D   45  -  
  1569	:  0011_0000  0x30   48  0  
  1570	:  0011_0101  0x35   53  5  
  1571	:  0011_0101  0x35   53  5  
  1572	:  1100_0000  0xC0  192    
  1573	:  0000_1100  0x0C   12    
  1574	:  0000_0000  0x00    0    
  1575	:  0000_0001  0x01    1    
  1576	:  0000_0000  0x00    0    
  1577	:  0000_0001  0x01    1    
  1578	:  0000_0000  0x00    0    
  1579	:  0000_0000  0x00    0    
  1580	:  0010_1010  0x2A   42  *  
  1581	:  0011_0000  0x30   48  0  
  1582	:  0000_0000  0x00    0    
  1583	:  0000_0100  0x04    4    
  1584	:  0010_1101  0x2D   45  -  
  1585	:  0100_0011  0x43   67  C  
  1586	:  0011_0010  0x32   50  2  
  1587	:  0011_0111  0x37   55  7  
  1588	:  0000_1000  0x08    8    
  1589	:  0100_0001  0x41   65  A  
  1590	:  0010_1101  0x2D   45  -  
  1591	:  0011_0101  0x35   53  5  
  1592	:  0011_0000  0x30   48  0  
  1593	:  0010_1101  0x2D   45  -  
  1594	:  0011_0000  0x30   48  0  
  1595	:  0011_0101  0x35   53  5  
  1596	:  0011_0110  0x36   54  6  
  1597	:  1100_0000  0xC0  192    
  1598	:  0000_1100  0x0C   12    
  1599	:  0000_0000  0x00    0    
  1600	:  0000_0001  0x01    1    
  1601	:  0000_0000  0x00    0    
  1602	:  0000_0001  0x01    1    
  1603	:  0000_0000  0x00    0    
  1604	:  0000_0000  0x00    0    
  1605	:  0010_1010  0x2A   42  *  
  1606	:  0011_0000  0x30   48  0  
  1607	:  0000_0000  0x00    0    
  1608	:  0000_0100  0x04    4    
  1609	:  0010_1101  0x2D   45  -  
  1610	:  0100_0011  0x43   67  C  
  1611	:  0011_0010  0x32   50  2  
  1612	:  0011_1000  0x38   56  8  
  1613	:  0000_1000  0x08    8    
  1614	:  0100_0001  0x41   65  A  
  1615	:  0010_1101  0x2D   45  -  
  1616	:  0011_0101  0x35   53  5  
  1617	:  0011_0000  0x30   48  0  
  1618	:  0010_1101  0x2D   45  -  
  1619	:  0011_0000  0x30   48  0  
  1620	:  0011_0101  0x35   53  5  
  1621	:  0011_0111  0x37   55  7  
  1622	:  1100_0000  0xC0  192    
  1623	:  0000_1100  0x0C   12    
  1624	:  0000_0000  0x00    0    
  1625	:  0000_0001  0x01    1    
  1626	:  0000_0000  0x00    0    
  1627	:  0000_0001  0x01    1    
  1628	:  0000_0000  0x00    0    
  1629	:  0000_0000  0x00    0    
  1630	:  0010_1010  0x2A   42  *  
  1631	:  0011_0000  0x30   48  0  
  1632	:  0000_0000  0x00    0    
  1633	:  0000_0100  0x04    4    
  1634	:  0010_1101  0x2D   45  -  
  1635	:  0100_0011  0x43   67  C  
  1636	:  0011_0010  0x32   50  2  
  1637	:  0011_1001  0x39   57  9  
  1638	:  0000_1000  0x08    8    
  1639	:  0100_0001  0x41   65  A  
  1640	:  0010_1101  0x2D   45  -  
  1641	:  0011_0101  0x35   53  5  
  1642	:  0011_0000  0x30   48  0  
  1643	:  0010_1101  0x2D   45  -  
  1644	:  0011_0000  0x30   48  0  
  1645	:  0011_0101  0x35   53  5  
  1646	:  0011_1000  0x38   56  8  
  1647	:  1100_0000  0xC0  192    
  1648	:  0000_1100  0x0C   12    
  1649	:  0000_0000  0x00    0    
  1650	:  0000_0001  0x01    1    
  1651	:  0000_0000  0x00    0    
  1652	:  0000_0001  0x01    1    
  1653	:  0000_0000  0x00    0    
  1654	:  0000_0000  0x00    0    
  1655	:  0010_1010  0x2A   42  *  
  1656	:  0011_0000  0x30   48  0  
  1657	:  0000_0000  0x00    0    
  1658	:  0000_0100  0x04    4    
  1659	:  0010_1101  0x2D   45  -  
  1660	:  0100_0011  0x43   67  C  
  1661	:  0011_0010  0x32   50  2  
  1662	:  0011_1010  0x3A   58  :  
  1663	:  0000_1000  0x08    8    
  1664	:  0100_0001  0x41   65  A  
  1665	:  0010_1101  0x2D   45  -  
  1666	:  0011_0101  0x35   53  5  
  1667	:  0011_0000  0x30   48  0  
  1668	:  0010_1101  0x2D   45  -  
  1669	:  0011_0000  0x30   48  0  
  1670	:  0011_0101  0x35   53  5  
  1671	:  0011_1001  0x39   57  9  
  1672	:  1100_0000  0xC0  192    
  1673	:  0000_1100  0x0C   12    
  1674	:  0000_0000  0x00    0    
  1675	:  0000_0001  0x01    1    
  1676	:  0000_0000  0x00    0    
  1677	:  0000_0001  0x01    1    
  1678	:  0000_0000  0x00    0    
  1679	:  0000_0000  0x00    0    
  1680	:  0010_1010  0x2A   42  *  
  1681	:  0011_0000  0x30   48  0  
  1682	:  0000_0000  0x00    0    
  1683	:  0000_0100  0x04    4    
  1684	:  0010_1101  0x2D   45  -  
  1685	:  0100_0011  0x43   67  C  
  1686	:  0011_0010  0x32   50  2  
  1687	:  0011_1011  0x3B   59  ;  
  1688	:  0000_1000  0x08    8    
  1689	:  0100_0001  0x41   65  A  
  1690	:  0010_1101  0x2D   45  -  
  1691	:  0011_0101  0x35   53  5  
  1692	:  0011_0000  0x30   48  0  
  1693	:  0010_1101  0x2D   45  -  
  1694	:  0011_0000  0x30   48  0  
  1695	:  0011_0110  0x36   54  6  
  1696	:  0011_0000  0x30   48  0  
  1697	:  1100_0000  0xC0  192    
  1698	:  0000_1100  0x0C   12    
  1699	:  0000_0000  0x00    0    
  1700	:  0000_0001  0x01    1    
  1701	:  0000_0000  0x00    0    
  1702	:  0000_0001  0x01    1    
  1703	:  0000_0000  0x00    0    
  1704	:  0000_0000  0x00    0    
  1705	:  0010_1010  0x2A   42  *  
  1706	:  0011_0000  0x30   48  0  
  1707	:  0000_0000  0x00    0    
  1708	:  0000_0100  0x04    4    
  1709	:  0010_1101  0x2D   45  -  
  1710	:  0100_0011  0x43   67  C  
  1711	:  0011_0010  0x32   50  2  
  1712	:  0011_1100  0x3C   60  <  
  1713	:  0000_1000  0x08    8    
  1714	:  0100_0001  0x41   65  A  
  1715	:  0010_1101  0x2D   45  -  
  1716	:  0011_0101  0x35   53  5  
  1717	:  0011_0000  0x30   48  0  
  1718	:  0010_1101  0x2D   45  -  
  1719	:  0011_0000  0x30   48  0  
  1720	:  0011_0110  0x36   54  6  
  1721	:  0011_0001  0x31   49  1  
  1722	:  1100_0000  0xC0  192    
  1723	:  0000_1100  0x0C   12    
  1724	:  0000_0000  0x00    0    
  1725	:  0000_0001  0x01    1    
  1726	:  0000_0000  0x00    0    
  1727	:  0000_0001  0x01    1    
  1728	:  0000_0000  0x00    0    
  1729	:  0000_0000  0x00    0    
  1730	:  0010_1010  0x2A   42  *  
  1731	:  0011_0000  0x30   48  0  
  1732	:  0000_0000  0x00    0    
  1733	:  0000_0100  0x04    4    
  1734	:  0010_1101  0x2D   45  -  
  1735	:  0100_0011  0x43   67  C  
  1736	:  0011_0010  0x32   50  2  
  1737	:  0011_1101  0x3D   61  =  
  1738	:  0000_1000  0x08    8    
  1739	:  0100_0001  0x41   65  A  
  1740	:  0010_1101  0x2D   45  -  
  1741	:  0011_0101  0x35   53  5  
  1742	:  0011_0000  0x30   48  0  
  1743	:  0010_1101  0x2D   45  -  
  1744	:  0011_0000  0x30   48  0  
  1745	:  0011_0110  0x36   54  6  
  1746	:  0011_0010  0x32   50  2  
  1747	:  1100_0000  0xC0  192    
  1748	:  0000_1100  0x0C   12    
  1749	:  0000_0000  0x00    0    
  1750	:  0000_0001  0x01    1    
  1751	:  0000_0000  0x00    0    
  1752	:  0000_0001  0x01    1    
  1753	:  0000_0000  0x00    0    
  1754	:  0000_0000  0x00    0    
  1755	:  0010_1010  0x2A   42  *  
  1756	:  0011_0000  0x30   48  0  
  1757	:  0000_0000  0x00    0    
  1758	:  0000_0100  0x04    4    
  1759	:  0010_1101  0x2D   45  -  
  1760	:  0100_0011  0x43   67  C  
  1761	:  0011_0010  0x32   50  2  
  1762	:  0011_1110  0x3E   62  >  
  1763	:  0000_1000  0x08    8    
  1764	:  0100_0001  0x41   65  A  
  1765	:  0010_1101  0x2D   45  -  
  1766	:  0011_0101  0x35   53  5  
  1767	:  0011_0000  0x30   48  0  
  1768	:  0010_1101  0x2D   45  -  
  1769	:  0011_0000  0x30   48  0  
  1770	:  0011_0110  0x36   54  6  
  1771	:  0011_0011  0x33   51  3  
  1772	:  1100_0000  0xC0  192    
  1773	:  0000_1100  0x0C   12    
  1774	:  0000_0000  0x00    0    
  1775	:  0000_0001  0x01    1    
  1776	:  0000_0000  0x00    0    
  1777	:  0000_0001  0x01    1    
  1778	:  0000_0000  0x00    0    
  1779	:  0000_0000  0x00    0    
  1780	:  0010_1010  0x2A   42  *  
  1781	:  0011_0000  0x30   48  0  
  1782	:  0000_0000  0x00    0    
  1783	:  0000_0100  0x04    4    
  1784	:  0010_1101  0x2D   45  -  
  1785	:  0100_0011  0x43   67  C  
  1786	:  0011_0010  0x32   50  2  
  1787	:  0011_1111  0x3F   63  ?  
  1788	:  0000_1000  0x08    8    
  1789	:  0100_0001  0x41   65  A  
  1790	:  0010_1101  0x2D   45  -  
  1791	:  0011_0101  0x35   53  5  
  1792	:  0011_0000  0x30   48  0  
  1793	:  0010_1101  0x2D   45  -  
  1794	:  0011_0000  0x30   48  0  
  1795	:  0011_0110  0x36   54  6  
  1796	:  0011_0100  0x34   52  4  
  1797	:  1100_0000  0xC0  192    
  1798	:  0000_1100  0x0C   12    
  1799	:  0000_0000  0x00    0    
  1800	:  0000_0001  0x01    1    
  1801	:  0000_0000  0x00    0    
  1802	:  0000_0001  0x01    1    
  1803	:  0000_0000  0x00    0    
  1804	:  0000_0000  0x00    0    
  1805	:  0010_1010  0x2A   42  *  
  1806	:  0011_0000  0x30   48  0  
  1807	:  0000_0000  0x00    0    
  1808	:  0000_0100  0x04    4    
  1809	:  0010_1101  0x2D   45  -  
  1810	:  0100_0011  0x43   67  C  
  1811	:  0011_0010  0x32   50  2  
  1812	:  0100_0000  0x40   64  @  
  1813	:  0000_1000  0x08    8    
  1814	:  0100_0001  0x41   65  A  
  1815	:  0010_1101  0x2D   45  -  
  1816	:  0011_0101  0x35   53  5  
  1817	:  0011_0000  0x30   48  0  
  1818	:  0010_1101  0x2D   45  -  
  1819	:  0011_0000  0x30   48  0  
  1820	:  0011_0110  0x36   54  6  
  1821	:  0011_0101  0x35   53  5  
  1822	:  1100_0000  0xC0  192    
  1823	:  0000_1100  0x0C   12    
  1824	:  0000_0000  0x00    0    
  1825	:  0000_0001  0x01    1    
  1826	:  0000_0000  0x00    0    
  1827	:  0000_0001  0x01    1    
  1828	:  0000_0000  0x00    0    
  1829	:  0000_0000  0x00    0    
  1830	:  0010_1010  0x2A   42  *  
  1831	:  0011_0000  0x30   48  0  
  1832	:  0000_0000  0x00    0    
  1833	:  0000_0100  0x04    4    
  1834	:  0010_1101  0x2D   45  -  
  1835	:  0100_0011  0x43   67  C  
  1836	:  0011_0010  0x32   50  2  
  1837	:  0100_0001  0x41   65  A  
  1838	:  0000_1000  0x08    8    
  1839	:  0100_0001  0x41   65  A  
  1840	:  0010_1101  0x2D   45  -  
  1841	:  0011_0101  0x35   53  5  
  1842	:  0011_0000  0x30   48  0  
  1843	:  0010_1101  0x2D   45  -  
  1844	:  0011_0000  0x30   48  0  
  1845	:  0011_0110  0x36   54  6  
  1846	:  0011_0110  0x36   54  6  
  1847	:  1100_0000  0xC0  192    
  1848	:  0000_1100  0x0C   12    
  1849	:  0000_0000  0x00    0    
  1850	:  0000_0001  0x01    1    
  1851	:  0000_0000  0x00    0    
  1852	:  0000_0001  0x01    1    
  1853	:  0000_0000  0x00    0    
  1854	:  0000_0000  0x00    0    
  1855	:  0010_1010  0x2A   42  *  
  1856	:  0011_0000  0x30   48  0  
  1857	:  0000_0000  0x00    0    
  1858	:  0000_0100  0x04    4    
  1859	:  0010_1101  0x2D   45  -  
  1860	:  0100_0011  0x43   67  C  
  1861	:  0011_0010  0x32   50  2  
  1862	:  0100_0010  0x42   66  B  
  1863	:  0000_1000  0x08    8    
  1864	:  0100_0001  0x41   65  A  
  1865	:  0010_1101  0x2D   45  -  
  1866	:  0011_0101  0x35   53  5  
  1867	:  0011_0000  0x30   48  0  
  1868	:  0010_1101  0x2D   45  -  
  1869	:  0011_0000  0x30   48  0  
  1870	:  0011_0110  0x36   54  6  
  1871	:  0011_0111  0x37   55  7  
  1872	:  1100_0000  0xC0  192    
  1873	:  0000_1100  0x0C   12    
  1874	:  0000_0000  0x00    0    
  1875	:  0000_0001  0x01    1    
  1876	:  0000_0000  0x00    0    
  1877	:  0000_0001  0x01    1    
  1878	:  0000_0000  0x00    0    
  1879	:  0000_0000  0x00    0    
  1880	:  0010_1010  0x2A   42  *  
  1881	:  0011_0000  0x30   48  0  
  1882	:  0000_0000  0x00    0    
  1883	:  0000_0100  0x04    4    
  1884	:  0010_1101  0x2D   45  -  
  1885	:  0100_0011  0x43   67  C  
  1886	:  0011_0010  0x32   50  2  
  1887	:  0100_0011  0x43   67  C  
  1888	:  0000_1000  0x08    8    
  1889	:  0100_0001  0x41   65  A  
  1890	:  0010_1101  0x2D   45  -  
  1891	:  0011_0101  0x35   53  5  
  1892	:  0011_0000  0x30   48  0  
  1893	:  0010_1101  0x2D   45  -  
  1894	:  0011_0000  0x30   48  0  
  1895	:  0011_0110  0x36   54  6  
  1896	:  0011_1000  0x38   56  8  
  1897	:  1100_0000  0xC0  192    
  1898	:  0000_1100  0x0C   12    
  1899	:  0000_0000  0x00    0    
  1900	:  0000_0001  0x01    1    
  1901	:  0000_0000  0x00    0    
  1902	:  0000_0001  0x01    1    
  1903	:  0000_0000  0x00    0    
  1904	:  0000_0000  0x00    0    
  1905	:  0010_1010  0x2A   42  *  
  1906	:  0011_0000  0x30   48  0  
  1907	:  0000_0000  0x00    0    
  1908	:  0000_0100  0x04    4    
  1909	:  0010_1101  0x2D   45  -  
  1910	:  0100_0011  0x43   67  C  
  1911	:  0011_0010  0x32   50  2  
  1912	:  0100_0100  0x44   68  D  
  1913	:  0000_1000  0x08    8    
  1914	:  0100_0001  0x41   65  A  
  1915	:  0010_1101  0x2D   45  -  
  1916	:  0011_0101  0x35   53  5  
  1917	:  0011_0000  0x30   48  0  
  1918	:  0010_1101  0x2D   45  -  
  1919	:  0011_0000  0x30   48  0  
  1920	:  0011_0110  0x36   54  6  
  1921	:  0011_1001  0x39   57  9  
  1922	:  1100_0000  0xC0  192    
  1923	:  0000_1100  0x0C   12    
  1924	:  0000_0000  0x00    0    
  1925	:  0000_0001  0x01    1    
  1926	:  0000_0000  0x00    0    
  1927	:  0000_0001  0x01    1    
  1928	:  0000_0000  0x00    0    
  1929	:  0000_0000  0x00    0    
  1930	:  0010_1010  0x2A   42  *  
  1931	:  0011_0000  0x30   48  0  
  1932	:  0000_0000  0x00    0    
  1933	:  0000_0100  0x04    4    
  1934	:  0010_1101  0x2D   45  -  
  1935	:  0100_0011  0x43   67  C  
  1936	:  0011_0010  0x32   50  2  
  1937	:  0100_0101  0x45   69  E  
  1938	:  0000_1000  0x08    8    
  1939	:  0100_0001  0x41   65  A  
  1940	:  0010_1101  0x2D   45  -  
  1941	:  0011_0101  0x35   53  5  
  1942	:  0011_0000  0x30   48  0  
  1943	:  0010_1101  0x2D   45  -  
  1944	:  0011_0000  0x30   48  0  
  1945	:  0011_0111  0x37   55  7  
  1946	:  0011_0000  0x30   48  0  
  1947	:  1100_0000  0xC0  192    
  1948	:  0000_1100  0x0C   12    
  1949	:  0000_0000  0x00    0    
  1950	:  0000_0001  0x01    1    
  1951	:  0000_0000  0x00    0    
  1952	:  0000_0001  0x01    1    
  1953	:  0000_0000  0x00    0    
  1954	:  0000_0000  0x00    0    
  1955	:  0010_1010  0x2A   42  *  
  1956	:  0011_0000  0x30   48  0  
  1957	:  0000_0000  0x00    0    
  1958	:  0000_0100  0x04    4    
  1959	:  0010_1101  0x2D   45  -  
  1960	:  0100_0011  0x43   67  C  
  1961	:  0011_0010  0x32   50  2  
  1962	:  0100_0110  0x46   70  F  
  1963	:  0000_1000  0x08    8    
  1964	:  0100_0001  0x41   65  A  
  1965	:  0010_1101  0x2D   45  -  
  1966	:  0011_0101  0x35   53  5  
  1967	:  0011_0000  0x30   48  0  
  1968	:  0010_1101  0x2D   45  -  
  1969	:  0011_0000  0x30   48  0  
  1970	:  0011_0111  0x37   55  7  
  1971	:  0011_0001  0x31   49  1  
  1972	:  1100_0000  0xC0  192    
  1973	:  0000_1100  0x0C   12    
  1974	:  0000_0000  0x00    0    
  1975	:  0000_0001  0x01    1    
  1976	:  0000_0000  0x00    0    
  1977	:  0000_0001  0x01    1    
  1978	:  0000_0000  0x00    0    
  1979	:  0000_0000  0x00    0    
  1980	:  0010_1010  0x2A   42  *  
  1981	:  0011_0000  0x30   48  0  
  1982	:  0000_0000  0x00    0    
  1983	:  0000_0100  0x04    4    
  1984	:  0010_1101  0x2D   45  -  
  1985	:  0100_0011  0x43   67  C  
  1986	:  0011_0010  0x32   50  2  
  1987	:  0100_0111  0x47   71  G  
  1988	:  0000_1000  0x08    8    
  1989	:  0100_0001  0x41   65  A  
  1990	:  0010_1101  0x2D   45  -  
  1991	:  0011_0101  0x35   53  5  
  1992	:  0011_0000  0x30   48  0  
  1993	:  0010_1101  0x2D   45  -  
  1994	:  0011_0000  0x30   48  0  
  1995	:  0011_0111  0x37   55  7  
  1996	:  0011_0010  0x32   50  2  
  1997	:  1100_0000  0xC0  192    
  1998	:  0000_1100  0x0C   12    
  1999	:  0000_0000  0x00    0    
  2000	:  0000_0001  0x01    1    
  2001	:  0000_0000  0x00    0    
  2002	:  0000_0001  0x01    1    
  2003	:  0000_0000  0x00    0    
  2004	:  0000_0000  0x00    0    
  2005	:  0010_1010  0x2A   42  *  
  2006	:  0011_0000  0x30   48  0  
  2007	:  0000_0000  0x00    0    
  2008	:  0000_0100  0x04    4    
  2009	:  0010_1101  0x2D   45  -  
  2010	:  0100_0011  0x43   67  C  
  2011	:  0011_0010  0x32   50  2  
  2012	:  0100_1000  0x48   72  H  
  2013	:  0000_1000  0x08    8    
  2014	:  0100_0001  0x41   65  A  
  2015	:  0010_1101  0x2D   45  -  
  2016	:  0011_0101  0x35   53  5  
  2017	:  0011_0000  0x30   48  0  
  2018	:  0010_1101  0x2D   45  -  
  2019	:  0011_0000  0x30   48  0  
  2020	:  0011_0111  0x37   55  7  
  2021	:  0011_0011  0x33   51  3  
  2022	:  1100_0000  0xC0  192    
  2023	:  0000_1100  0x0C   12    
  2024	:  0000_0000  0x00    0    
  2025	:  0000_0001  0x01    1    
  2026	:  0000_0000  0x00    0    
  2027	:  0000_0001  0x01    1    
  2028	:  0000_0000  0x00    0    
  2029	:  0000_0000  0x00    0    
  2030	:  0010_1010  0x2A   42  *  
  2031	:  0011_0000  0x30   48  0  
  2032	:  0000_0000  0x00    0    
  2033	:  0000_0100  0x04    4    
  2034	:  0010_1101  0x2D   45  -  
  2035	:  0100_0011  0x43   67  C  
  2036	:  0011_0010  0x32   50  2  
  2037	:  0100_1001  0x49   73  I  
  2038	:  0000_1000  0x08    8    
  2039	:  0100_0001  0x41   65  A  
  2040	:  0010_1101  0x2D   45  -  
  2041	:  0011_0101  0x35   53  5  
  2042	:  0011_0000  0x30   48  0  
  2043	:  0010_1101  0x2D   45  -  
  2044	:  0011_0000  0x30   48  0  
  2045	:  0011_0111  0x37   55  7  
  2046	:  0011_0100  0x34   52  4  
  2047	:  1100_0000  0xC0  192    
  2048	:  0000_1100  0x0C   12    
  2049	:  0000_0000  0x00    0    
  2050	:  0000_0001  0x01    1    
  2051	:  0000_0000  0x00    0    
  2052	:  0000_0001  0x01    1    
  2053	:  0000_0000  0x00    0    
  2054	:  0000_0000  0x00    0    
  2055	:  0010_1010  0x2A   42  *  
  2056	:  0011_0000  0x30   48  0  
  2057	:  0000_0000  0x00    0    
  2058	:  0000_0100  0x04    4    
  2059	:  0010_1101  0x2D   45  -  
  2060	:  0100_0011  0x43   67  C  
  2061	:  0011_0010  0x32   50  2  
  2062	:  0100_1010  0x4A   74  J  
  2063	:  0000_1000  0x08    8    
  2064	:  0100_0001  0x41   65  A  
  2065	:  0010_1101  0x2D   45  -  
  2066	:  0011_0101  0x35   53  5  
  2067	:  0011_0000  0x30   48  0  
  2068	:  0010_1101  0x2D   45  -  
  2069	:  0011_0000  0x30   48  0  
  2070	:  0011_0111  0x37   55  7  
  2071	:  0011_0101  0x35   53  5  
  2072	:  1100_0000  0xC0  192    
  2073	:  0000_1100  0x0C   12    
  2074	:  0000_0000  0x00    0    
  2075	:  0000_0001  0x01    1    
  2076	:  0000_0000  0x00    0    
  2077	:  0000_0001  0x01    1    
  2078	:  0000_0000  0x00    0    
  2079	:  0000_0000  0x00    0    
  2080	:  0010_1010  0x2A   42  *  
  2081	:  0011_0000  0x30   48  0  
  2082	:  0000_0000  0x00    0    
  2083	:  0000_0100  0x04    4    
  2084	:  0010_1101  0x2D   45  -  
  2085	:  0100_0011  0x43   67  C  
  2086	:  0011_0010  0x32   50  2  
  2087	:  0100_1011  0x4B   75  K  
  2088	:  0000_1000  0x08    8    
  2089	:  0100_0001  0x41   65  A  
  2090	:  0010_1101  0x2D   45  -  
  2091	:  0011_0101  0x35   53  5  
  2092	:  0011_0000  0x30   48  0  
  2093	:  0010_1101  0x2D   45  -  
  2094	:  0011_0000  0x30   48  0  
  2095	:  0011_0111  0x37   55  7  
  2096	:  0011_0110  0x36   54  6  
  2097	:  1100_0000  0xC0  192    
  2098	:  0000_1100  0x0C   12    
  2099	:  0000_0000  0x00    0    
  2100	:  0000_0001  0x01    1    
  2101	:  0000_0000  0x00    0    
  2102	:  0000_0001  0x01    1    
  2103	:  0000_0000  0x00    0    
  2104	:  0000_0000  0x00    0    
  2105	:  0010_1010  0x2A   42  *  
  2106	:  0011_0000  0x30   48  0  
  2107	:  0000_0000  0x00    0    
  2108	:  0000_0100  0x04    4    
  2109	:  0010_1101  0x2D   45  -  
  2110	:  0100_0011  0x43   67  C  
  2111	:  0011_0010  0x32   50  2  
  2112	:  0100_1100  0x4C   76  L  
  2113	:  0000_1000  0x08    8    
  2114	:  0100_0001  0x41   65  A  
  2115	:  0010_1101  0x2D   45  -  
  2116	:  0011_0101  0x35   53  5  
  2117	:  0011_0000  0x30   48  0  
  2118	:  0010_1101  0x2D   45  -  
  2119	:  0011_0000  0x30   48  0  
  2120	:  0011_0111  0x37   55  7  
  2121	:  0011_0111  0x37   55  7  
  2122	:  1100_0000  0xC0  192    
  2123	:  0000_1100  0x0C   12    
  2124	:  0000_0000  0x00    0    
  2125	:  0000_0001  0x01    1    
  2126	:  0000_0000  0x00    0    
  2127	:  0000_0001  0x01    1    
  2128	:  0000_0000  0x00    0    
  2129	:  0000_0000  0x00    0    
  2130	:  0010_1010  0x2A   42  *  
  2131	:  0011_0000  0x30   48  0  
  2132	:  0000_0000  0x00    0    
  2133	:  0000_0100  0x04    4    
  2134	:  0010_1101  0x2D   45  -  
  2135	:  0100_0011  0x43   67  C  
  2136	:  0011_0010  0x32   50  2  
  2137	:  0100_1101  0x4D   77  M  
  2138	:  0000_1000  0x08    8    
  2139	:  0100_0001  0x41   65  A  
  2140	:  0010_1101  0x2D   45  -  
  2141	:  0011_0101  0x35   53  5  
  2142	:  0011_0000  0x30   48  0  
  2143	:  0010_1101  0x2D   45  -  
  2144	:  0011_0000  0x30   48  0  
  2145	:  0011_0111  0x37   55  7  
  2146	:  0011_1000  0x38   56  8  
  2147	:  1100_0000  0xC0  192    
  2148	:  0000_1100  0x0C   12    
  2149	:  0000_0000  0x00    0    
  2150	:  0000_0001  0x01    1    
  2151	:  0000_0000  0x00    0    
  2152	:  0000_0001  0x01    1    
  2153	:  0000_0000  0x00    0    
  2154	:  0000_0000  0x00    0    
  2155	:  0010_1010  0x2A   42  *  
  2156	:  0011_0000  0x30   48  0  
  2157	:  0000_0000  0x00    0    
  2158	:  0000_0100  0x04    4    
  2159	:  0010_1101  0x2D   45  -  
  2160	:  0100_0011  0x43   67  C  
  2161	:  0011_0010  0x32   50  2  
  2162	:  0100_1110  0x4E   78  N  
  2163	:  0000_1000  0x08    8    
  2164	:  0100_0001  0x41   65  A  
  2165	:  0010_1101  0x2D   45  -  
  2166	:  0011_0101  0x35   53  5  
  2167	:  0011_0000  0x30   48  0  
  2168	:  0010_1101  0x2D   45  -  
  2169	:  0011_0000  0x30   48  0  
  2170	:  0011_0111  0x37   55  7  
  2171	:  0011_1001  0x39   57  9  
  2172	:  1100_0000  0xC0  192    
  2173	:  0000_1100  0x0C   12    
  2174	:  0000_0000  0x00    0    
  2175	:  0000_0001  0x01    1    
  2176	:  0000_0000  0x00    0    
  2177	:  0000_0001  0x01    1    
  2178	:  0000_0000  0x00    0    
  2179	:  0000_0000  0x00    0    
  2180	:  0010_1010  0x2A   42  *  
  2181	:  0011_0000  0x30   48  0  
  2182	:  0000_0000  0x00    0    
  2183	:  0000_0100  0x04    4    
  2184	:  0010_1101  0x2D   45  -  
  2185	:  0100_0011  0x43   67  C  
  2186	:  0011_0010  0x32   50  2  
  2187	:  0100_1111  0x4F   79  O  
  2188	:  0000_1000  0x08    8    
  2189	:  0100_0001  0x41   65  A  
  2190	:  0010_1101  0x2D   45  -  
  2191	:  0011_0101  0x35   53  5  
  2192	:  0011_0000  0x30   48  0  
  2193	:  0010_1101  0x2D   45  -  
  2194	:  0011_0000  0x30   48  0  
  2195	:  0011_1000  0x38   56  8  
  2196	:  0011_0000  0x30   48  0  
  2197	:  1100_0000  0xC0  192    
  2198	:  0000_1100  0x0C   12    
  2199	:  0000_0000  0x00    0    
  2200	:  0000_0001  0x01    1    
  2201	:  0000_0000  0x00    0    
  2202	:  0000_0001  0x01    1    
  2203	:  0000_0000  0x00    0    
  2204	:  0000_0000  0x00    0    
  2205	:  0010_1010  0x2A   42  *  
  2206	:  0011_0000  0x30   48  0  
  2207	:  0000_0000  0x00    0    
  2208	:  0000_0100  0x04    4    
  2209	:  0010_1101  0x2D   45  -  
  2210	:  0100_0011  0x43   67  C  
  2211	:  0011_0010  0x32   50  2  
  2212	:  0101_0000  0x50   80  P  
  2213	:  0000_1000  0x08    8    
  2214	:  0100_0001  0x41   65  A  
  2215	:  0010_1101  0x2D   45  -  
  2216	:  0011_0101  0x35   53  5  
  2217	:  0011_0000  0x30   48  0  
  2218	:  0010_1101  0x2D   45  -  
  2219	:  0011_0000  0x30   48  0  
  2220	:  0011_1000  0x38   56  8  
  2221	:  0011_0001  0x31   49  1  
  2222	:  1100_0000  0xC0  192    
  2223	:  0000_1100  0x0C   12    
  2224	:  0000_0000  0x00    0    
  2225	:  0000_0001  0x01    1    
  2226	:  0000_0000  0x00    0    
  2227	:  0000_0001  0x01    1    
  2228	:  0000_0000  0x00    0    
  2229	:  0000_0000  0x00    0    
  2230	:  0010_1010  0x2A   42  *  
  2231	:  0011_0000  0x30   48  0  
  2232	:  0000_0000  0x00    0    
  2233	:  0000_0100  0x04    4    
  2234	:  0010_1101  0x2D   45  -  
  2235	:  0100_0011  0x43   67  C  
  2236	:  0011_0010  0x32   50  2  
  2237	:  0101_0001  0x51   81  Q  
  2238	:  0000_1000  0x08    8    
  2239	:  0100_0001  0x41   65  A  
  2240	:  0010_1101  0x2D   45  -  
  2241	:  0011_0101  0x35   53  5  
  2242	:  0011_0000  0x30   48  0  
  2243	:  0010_1101  0x2D   45  -  
  2244	:  0011_0000  0x30   48  0  
  2245	:  0011_1000  0x38   56  8  
  2246	:  0011_0010  0x32   50  2  
  2247	:  1100_0000  0xC0  192    
  2248	:  0000_1100  0x0C   12    
  2249	:  0000_0000  0x00    0    
  2250	:  0000_0001  0x01    1    
  2251	:  0000_0000  0x00    0    
  2252	:  0000_0001  0x01    1    
  2253	:  0000_0000  0x00    0    
  2254	:  0000_0000  0x00    0    
  2255	:  0010_1010  0x2A   42  *  
  2256	:  0011_0000  0x30   48  0  
  2257	:  0000_0000  0x00    0    
  2258	:  0000_0100  0x04    4    
  2259	:  0010_1101  0x2D   45  -  
  2260	:  0100_0011  0x43   67  C  
  2261	:  0011_0010  0x32   50  2  
  2262	:  0101_0010  0x52   82  R  
  2263	:  0000_1000  0x08    8    
  2264	:  0100_0001  0x41   65  A  
  2265	:  0010_1101  0x2D   45  -  
  2266	:  0011_0101  0x35   53  5  
  2267	:  0011_0000  0x30   48  0  
  2268	:  0010_1101  0x2D   45  -  
  2269	:  0011_0000  0x30   48  0  
  2270	:  0011_1000  0x38   56  8  
  2271	:  0011_0011  0x33   51  3  
  2272	:  1100_0000  0xC0  192    
  2273	:  0000_1100  0x0C   12    
  2274	:  0000_0000  0x00    0    
  2275	:  0000_0001  0x01    1    
  2276	:  0000_0000  0x00    0    
  2277	:  0000_0001  0x01    1    
  2278	:  0000_0000  0x00    0    
  2279	:  0000_0000  0x00    0    
  2280	:  0010_1010  0x2A   42  *  
  2281	:  0011_0000  0x30   48  0  
  2282	:  0000_0000  0x00    0    
  2283	:  0000_0100  0x04    4    
  2284	:  0010_1101  0x2D   45  -  
  2285	:  0100_0011  0x43   67  C  
  2286	:  0011_0010  0x32   50  2  
  2287	:  0101_0011  0x53   83  S  
  2288	:  0000_1000  0x08    8    
  2289	:  0100_0001  0x41   65  A  
  2290	:  0010_1101  0x2D   45  -  
  2291	:  0011_0101  0x35   53  5  
  2292	:  0011_0000  0x30   48  0  
  2293	:  0010_1101  0x2D   45  -  
  2294	:  0011_0000  0x30   48  0  
  2295	:  0011_1000  0x38   56  8  
  2296	:  0011_0100  0x34   52  4  
  2297	:  1100_0000  0xC0  192    
  2298	:  0000_1100  0x0C   12    
  2299	:  0000_0000  0x00    0    
  2300	:  0000_0001  0x01    1    
  2301	:  0000_0000  0x00    0    
  2302	:  0000_0001  0x01    1    
  2303	:  0000_0000  0x00    0    
  2304	:  0000_0000  0x00    0    
  2305	:  0010_1010  0x2A   42  *  
  2306	:  0011_0000  0x30   48  0  
  2307	:  0000_0000  0x00    0    
  2308	:  0000_0100  0x04    4    
  2309	:  0010_1101  0x2D   45  -  
  2310	:  0100_0011  0x43   67  C  
  2311	:  0011_0010  0x32   50  2  
  2312	:  0101_0100  0x54   84  T  
  2313	:  0000_1000  0x08    8    
  2314	:  0100_0001  0x41   65  A  
  2315	:  0010_1101  0x2D   45  -  
  2316	:  0011_0101  0x35   53  5  
  2317	:  0011_0000  0x30   48  0  
  2318	:  0010_1101  0x2D   45  -  
  2319	:  0011_0000  0x30   48  0  
  2320	:  0011_1000  0x38   56  8  
  2321	:  0011_0101  0x35   53  5  
  2322	:  1100_0000  0xC0  192    
  2323	:  0000_1100  0x0C   12    
  2324	:  0000_0000  0x00    0    
  2325	:  0000_0001  0x01    1    
  2326	:  0000_0000  0x00    0    
  2327	:  0000_0001  0x01    1    
  2328	:  0000_0000  0x00    0    
  2329	:  0000_0000  0x00    0    
  2330	:  0010_1010  0x2A   42  *  
  2331	:  0011_0000  0x30   48  0  
  2332	:  0000_0000  0x00    0    
  2333	:  0000_0100  0x04    4    
  2334	:  0010_1101  0x2D   45  -  
  2335	:  0100_0011  0x43   67  C  
  2336	:  0011_0010  0x32   50  2  
  2337	:  0101_0101  0x55   85  U  
  2338	:  0000_1000  0x08    8    
  2339	:  0100_0001  0x41   65  A  
  2340	:  0010_1101  0x2D   45  -  
  2341	:  0011_0101  0x35   53  5  
  2342	:  0011_0000  0x30   48  0  
  2343	:  0010_1101  0x2D   45  -  
  2344	:  0011_0000  0x30   48  0  
  2345	:  0011_1000  0x38   56  8  
  2346	:  0011_0110  0x36   54  6  
  2347	:  1100_0000  0xC0  192    
  2348	:  0000_1100  0x0C   12    
  2349	:  0000_0000  0x00    0    
  2350	:  0000_0001  0x01    1    
  2351	:  0000_0000  0x00    0    
  2352	:  0000_0001  0x01    1    
  2353	:  0000_0000  0x00    0    
  2354	:  0000_0000  0x00    0    
  2355	:  0010_1010  0x2A   42  *  
  2356	:  0011_0000  0x30   48  0  
  2357	:  0000_0000  0x00    0    
  2358	:  0000_0100  0x04    4    
  2359	:  0010_1101  0x2D   45  -  
  2360	:  0100_0011  0x43   67  C  
  2361	:  0011_0010  0x32   50  2  
  2362	:  0101_0110  0x56   86  V  
  2363	:  0000_1000  0x08    8    
  2364	:  0100_0001  0x41   65  A  
  2365	:  0010_1101  0x2D   45  -  
  2366	:  0011_0101  0x35   53  5  
  2367	:  0011_0000  0x30   48  0  
  2368	:  0010_1101  0x2D   45  -  
  2369	:  0011_0000  0x30   48  0  
  2370	:  0011_1000  0x38   56  8  
  2371	:  0011_0111  0x37   55  7  
  2372	:  1100_0000  0xC0  192    
  2373	:  0000_1100  0x0C   12    
  2374	:  0000_0000  0x00    0    
  2375	:  0000_0001  0x01    1    
  2376	:  0000_0000  0x00    0    
  2377	:  0000_0001  0x01    1    
  2378	:  0000_0000  0x00    0    
  2379	:  0000_0000  0x00    0    
  2380	:  0010_1010  0x2A   42  *  
  2381	:  0011_0000  0x30   48  0  
  2382	:  0000_0000  0x00    0    
  2383	:  0000_0100  0x04    4    
  2384	:  0010_1101  0x2D   45  -  
  2385	:  0100_0011  0x43   67  C  
  2386	:  0011_0010  0x32   50  2  
  2387	:  0101_0111  0x57   87  W  
  2388	:  0000_1000  0x08    8    
  2389	:  0100_0001  0x41   65  A  
  2390	:  0010_1101  0x2D   45  -  
  2391	:  0011_0101  0x35   53  5  
  2392	:  0011_0000  0x30   48  0  
  2393	:  0010_1101  0x2D   45  -  
  2394	:  0011_0000  0x30   48  0  
  2395	:  0011_1000  0x38   56  8  
  2396	:  0011_1000  0x38   56  8  
  2397	:  1100_0000  0xC0  192    
  2398	:  0000_1100  0x0C   12    
  2399	:  0000_0000  0x00    0    
  2400	:  0000_0001  0x01    1    
  2401	:  0000_0000  0x00    0    
  2402	:  0000_0001  0x01    1    
  2403	:  0000_0000  0x00    0    
  2404	:  0000_0000  0x00    0    
  2405	:  0010_1010  0x2A   42  *  
  2406	:  0011_0000  0x30   48  0  
  2407	:  0000_0000  0x00    0    
  2408	:  0000_0100  0x04    4    
  2409	:  0010_1101  0x2D   45  -  
  2410	:  0100_0011  0x43   67  C  
  2411	:  0011_0010  0x32   50  2  
  2412	:  0101_1000  0x58   88  X  
  2413	:  0000_1000  0x08    8    
  2414	:  0100_0001  0x41   65  A  
  2415	:  0010_1101  0x2D   45  -  
  2416	:  0011_0101  0x35   53  5  
  2417	:  0011_0000  0x30   48  0  
  2418	:  0010_1101  0x2D   45  -  
  2419	:  0011_0000  0x30   48  0  
  2420	:  0011_1000  0x38   56  8  
  2421	:  0011_1001  0x39   57  9  
  2422	:  1100_0000  0xC0  192    
  2423	:  0000_1100  0x0C   12    
  2424	:  0000_0000  0x00    0    
  2425	:  0000_0001  0x01    1    
  2426	:  0000_0000  0x00    0    
  2427	:  0000_0001  0x01    1    
  2428	:  0000_0000  0x00    0    
  2429	:  0000_0000  0x00    0    
  2430	:  0010_1010  0x2A   42  *  
  2431	:  0011_0000  0x30   48  0  
  2432	:  0000_0000  0x00    0    
  2433	:  0000_0100  0x04    4    
  2434	:  0010_1101  0x2D   45  -  
  2435	:  0100_0011  0x43   67  C  
  2436	:  0011_0010  0x32   50  2  
  2437	:  0101_1001  0x59   89  Y  
  2438	:  0000_1000  0x08    8    
  2439	:  0100_0001  0x41   65  A  
  2440	:  0010_1101  0x2D   45  -  
  2441	:  0011_0101  0x35   53  5  
  2442	:  0011_0000  0x30   48  0  
  2443	:  0010_1101  0x2D   45  -  
  2444	:  0011_0000  0x30   48  0  
  2445	:  0011_1001  0x39   57  9  
  2446	:  0011_0000  0x30   48  0  
  2447	:  1100_0000  0xC0  192    
  2448	:  0000_1100  0x0C   12    
  2449	:  0000_0000  0x00    0    
  2450	:  0000_0001  0x01    1    
  2451	:  0000_0000  0x00    0    
  2452	:  0000_0001  0x01    1    
  2453	:  0000_0000  0x00    0    
  2454	:  0000_0000  0x00    0    
  2455	:  0010_1010  0x2A   42  *  
  2456	:  0011_0000  0x30   48  0  
  2457	:  0000_0000  0x00    0    
  2458	:  0000_0100  0x04    4    
  2459	:  0010_1101  0x2D   45  -  
  2460	:  0100_0011  0x43   67  C  
  2461	:  0011_0010  0x32   50  2  
  2462	:  0101_1010  0x5A   90  Z  
  2463	:  0000_1000  0x08    8    
  2464	:  0100_0001  0x41   65  A  
  2465	:  0010_1101  0x2D   45  -  
  2466	:  0011_0101  0x35   53  5  
  2467	:  0011_0000  0x30   48  0  
  2468	:  0010_1101  0x2D   45  -  
  2469	:  0011_0000  0x30   48  0  
  2470	:  0011_1001  0x39   57  9  
  2471	:  0011_0001  0x31   49  1  
  2472	:  1100_0000  0xC0  192    
  2473	:  0000_1100  0x0C   12    
  2474	:  0000_0000  0x00    0    
  2475	:  0000_0001  0x01    1    
  2476	:  0000_0000  0x00    0    
  2477	:  0000_0001  0x01    1    
  2478	:  0000_0000  0x00    0    
  2479	:  0000_0000  0x00    0    
  2480	:  0010_1010  0x2A   42  *  
  2481	:  0011_0000  0x30   48  0  
  2482	:  0000_0000  0x00    0    
  2483	:  0000_0100  0x04    4    
  2484	:  0010_1101  0x2D   45  -  
  2485	:  0100_0011  0x43   67  C  
  2486	:  0011_0010  0x32   50  2  
  2487	:  0101_1011  0x5B   91  [  
  2488	:  0000_1000  0x08    8    
  2489	:  0100_0001  0x41   65  A  
  2490	:  0010_1101  0x2D   45  -  
  2491	:  0011_0101  0x35   53  5  
  2492	:  0011_0000  0x30   48  0  
  2493	:  0010_1101  0x2D   45  -  
  2494	:  0011_0000  0x30   48  0  
  2495	:  0011_1001  0x39   57  9  
  2496	:  0011_0010  0x32   50  2  
  2497	:  1100_0000  0xC0  192    
  2498	:  0000_1100  0x0C   12    
  2499	:  0000_0000  0x00    0    
  2500	:  0000_0001  0x01    1    
  2501	:  0000_0000  0x00    0    
  2502	:  0000_0001  0x01    1    
  2503	:  0000_0000  0x00    0    
  2504	:  0000_0000  0x00    0    
  2505	:  0010_1010  0x2A   42  *  
  2506	:  0011_0000  0x30   48  0  
  2507	:  0000_0000  0x00    0    
  2508	:  0000_0100  0x04    4    
  2509	:  0010_1101  0x2D   45  -  
  2510	:  0100_0011  0x43   67  C  
  2511	:  0011_0010  0x32   50  2  
  2512	:  0101_1100  0x5C   92  \  
  2513	:  0000_1000  0x08    8    
  2514	:  0100_0001  0x41   65  A  
  2515	:  0010_1101  0x2D   45  -  
  2516	:  0011_0101  0x35   53  5  
  2517	:  0011_0000  0x30   48  0  
  2518	:  0010_1101  0x2D   45  -  
  2519	:  0011_0000  0x30   48  0  
  2520	:  0011_1001  0x39   57  9  
  2521	:  0011_0011  0x33   51  3  
  2522	:  1100_0000  0xC0  192    
  2523	:  0000_1100  0x0C   12    
  2524	:  0000_0000  0x00    0    
  2525	:  0000_0001  0x01    1    
  2526	:  0000_0000  0x00    0    
  2527	:  0000_0001  0x01    1    
  2528	:  0000_0000  0x00    0    
  2529	:  0000_0000  0x00    0    
  2530	:  0010_1010  0x2A   42  *  
  2531	:  0011_0000  0x30   48  0  
  2532	:  0000_0000  0x00    0    
  2533	:  0000_0100  0x04    4    
  2534	:  0010_1101  0x2D   45  -  
  2535	:  0100_0011  0x43   67  C  
  2536	:  0011_0010  0x32   50  2  
  2537	:  0101_1101  0x5D   93  ]  
  2538	:  0000_1000  0x08    8    
  2539	:  0100_0001  0x41   65  A  
  2540	:  0010_1101  0x2D   45  -  
  2541	:  0011_0101  0x35   53  5  
  2542	:  0011_0000  0x30   48  0  
  2543	:  0010_1101  0x2D   45  -  
  2544	:  0011_0000  0x30   48  0  
  2545	:  0011_1001  0x39   57  9  
  2546	:  0011_0100  0x34   52  4  
  2547	:  1100_0000  0xC0  192    
  2548	:  0000_1100  0x0C   12    
  2549	:  0000_0000  0x00    0    
  2550	:  0000_0001  0x01    1    
  2551	:  0000_0000  0x00    0    
  2552	:  0000_0001  0x01    1    
  2553	:  0000_0000  0x00    0    
  2554	:  0000_0000  0x00    0    
  2555	:  0010_1010  0x2A   42  *  
  2556	:  0011_0000  0x30   48  0  
  2557	:  0000_0000  0x00    0    
  2558	:  0000_0100  0x04    4    
  2559	:  0010_1101  0x2D   45  -  
  2560	:  0100_0011  0x43   67  C  
  2561	:  0011_0010  0x32   50  2  
  2562	:  0101_1110  0x5E   94  ^  
  2563	:  0000_1000  0x08    8    
  2564	:  0100_0001  0x41   65  A  
  2565	:  0010_1101  0x2D   45  -  
  2566	:  0011_0101  0x35   53  5  
  2567	:  0011_0000  0x30   48  0  
  2568	:  0010_1101  0x2D   45  -  
  2569	:  0011_0000  0x30   48  0  
  2570	:  0011_1001  0x39   57  9  
  2571	:  0011_0101  0x35   53  5  
  2572	:  1100_0000  0xC0  192    
  2573	:  0000_1100  0x0C   12    
  2574	:  0000_0000  0x00    0    
  2575	:  0000_0001  0x01    1    
  2576	:  0000_0000  0x00    0    
  2577	:  0000_0001  0x01    1    
  2578	:  0000_0000  0x00    0    
  2579	:  0000_0000  0x00    0    
  2580	:  0010_1010  0x2A   42  *  
  2581	:  0011_0000  0x30   48  0  
  2582	:  0000_0000  0x00    0    
  2583	:  0000_0100  0x04    4    
  2584	:  0010_1101  0x2D   45  -  
  2585	:  0100_0011  0x43   67  C  
  2586	:  0011_0010  0x32   50  2  
  2587	:  0101_1111  0x5F   95  _  
  2588	:  0000_1000  0x08    8    
  2589	:  0100_0001  0x41   65  A  
  2590	:  0010_1101  0x2D   45  -  
  2591	:  0011_0101  0x35   53  5  
  2592	:  0011_0000  0x30   48  0  
  2593	:  0010_1101  0x2D   45  -  
  2594	:  0011_0000  0x30   48  0  
  2595	:  0011_1001  0x39   57  9  
  2596	:  0011_0110  0x36   54  6  
  2597	:  1100_0000  0xC0  192    
  2598	:  0000_1100  0x0C   12    
  2599	:  0000_0000  0x00    0    
  2600	:  0000_0001  0x01    1    
  2601	:  0000_0000  0x00    0    
  2602	:  0000_0001  0x01    1    
  2603	:  0000_0000  0x00    0    
  2604	:  0000_0000  0x00    0    
  2605	:  0010_1010  0x2A   42  *  
  2606	:  0011_0000  0x30   48  0  
  2607	:  0000_0000  0x00    0    
  2608	:  0000_0100  0x04    4    
  2609	:  0010_1101  0x2D   45  -  
  2610	:  0100_0011  0x43   67  C  
  2611	:  0011_0010  0x32   50  2  
  2612	:  0110_0000  0x60   96  `  
  2613	:  0000_1000  0x08    8    
  2614	:  0100_0001  0x41   65  A  
  2615	:  0010_1101  0x2D   45  -  
  2616	:  0011_0101  0x35   53  5  
  2617	:  0011_0000  0x30   48  0  
  2618	:  0010_1101  0x2D   45  -  
  2619	:  0011_0000  0x30   48  0  
  2620	:  0011_1001  0x39   57  9  
  2621	:  0011_0111  0x37   55  7  
  2622	:  1100_0000  0xC0  192    
  2623	:  0000_1100  0x0C   12    
  2624	:  0000_0000  0x00    0    
  2625	:  0000_0001  0x01    1    
  2626	:  0000_0000  0x00    0    
  2627	:  0000_0001  0x01    1    
  2628	:  0000_0000  0x00    0    
  2629	:  0000_0000  0x00    0    
  2630	:  0010_1010  0x2A   42  *  
  2631	:  0011_0000  0x30   48  0  
  2632	:  0000_0000  0x00    0    
  2633	:  0000_0100  0x04    4    
  2634	:  0010_1101  0x2D   45  -  
  2635	:  0100_0011  0x43   67  C  
  2636	:  0011_0010  0x32   50  2  
  2637	:  0110_0001  0x61   97  a  
  2638	:  0000_1000  0x08    8    
  2639	:  0100_0001  0x41   65  A  
  2640	:  0010_1101  0x2D   45  -  
  2641	:  0011_0101  0x35   53  5  
  2642	:  0011_0000  0x30   48  0  
  2643	:  0010_1101  0x2D   45  -  
  2644	:  0011_0000  0x30   48  0  
  2645	:  0011_1001  0x39   57  9  
  2646	:  0011_1000  0x38   56  8  
  2647	:  1100_0000  0xC0  192    
  2648	:  0000_1100  0x0C   12    
  2649	:  0000_0000  0x00    0    
  2650	:  0000_0001  0x01    1    
  2651	:  0000_0000  0x00    0    
  2652	:  0000_0001  0x01    1    
  2653	:  0000_0000  0x00    0    
  2654	:  0000_0000  0x00    0    
  2655	:  0010_1010  0x2A   42  *  
  2656	:  0011_0000  0x30   48  0  
  2657	:  0000_0000  0x00    0    
  2658	:  0000_0100  0x04    4    
  2659	:  0010_1101  0x2D   45  -  
  2660	:  0100_0011  0x43   67  C  
  2661	:  0011_0010  0x32   50  2  
  2662	:  0110_0010  0x62   98  b  
  2663	:  0000_1000  0x08    8    
  2664	:  0100_0001  0x41   65  A  
  2665	:  0010_1101  0x2D   45  -  
  2666	:  0011_0101  0x35   53  5  
  2667	:  0011_0000  0x30   48  0  
  2668	:  0010_1101  0x2D   45  -  
  2669	:  0011_0000  0x30   48  0  
  2670	:  0011_1001  0x39   57  9  
  2671	:  0011_1001  0x39   57  9  
  2672	:  1100_0000  0xC0  192    
  2673	:  0000_1100  0x0C   12    
  2674	:  0000_0000  0x00    0    
  2675	:  0000_0001  0x01    1    
  2676	:  0000_0000  0x00    0    
  2677	:  0000_0001  0x01    1    
  2678	:  0000_0000  0x00    0    
  2679	:  0000_0000  0x00    0    
  2680	:  0010_1010  0x2A   42  *  
  2681	:  0011_0000  0x30   48  0  
  2682	:  0000_0000  0x00    0    
  2683	:  0000_0100  0x04    4    
  2684	:  0010_1101  0x2D   45  -  
  2685	:  0100_0011  0x43   67  C  
  2686	:  0011_0010  0x32   50  2  
  2687	:  0110_0011  0x63   99  c  
  2688	:  0000_1000  0x08    8    
  2689	:  0100_0001  0x41   65  A  
  2690	:  0010_1101  0x2D   45  -  
  2691	:  0011_0101  0x35   53  5  
  2692	:  0011_0000  0x30   48  0  
  2693	:  0010_1101  0x2D   45  -  
  2694	:  0011_0001  0x31   49  1  
  2695	:  0011_0000  0x30   48  0  
  2696	:  0011_0000  0x30   48  0  
  2697	:  1100_0000  0xC0  192    
  2698	:  0000_1100  0x0C   12    
  2699	:  0000_0000  0x00    0    
  2700	:  0000_0001  0x01    1    
  2701	:  0000_0000  0x00    0    
  2702	:  0000_0001  0x01    1    
  2703	:  0000_0000  0x00    0    
  2704	:  0000_0000  0x00    0    
  2705	:  0010_1010  0x2A   42  *  
  2706	:  0011_0000  0x30   48  0  
  2707	:  0000_0000  0x00    0    
  2708	:  0000_0100  0x04    4    
  2709	:  0010_1101  0x2D   45  -  
  2710	:  0100_0011  0x43   67  C  
  2711	:  0011_0010  0x32   50  2  
  2712	:  0110_0100  0x64  100  d  
  2713	:  0000_1000  0x08    8    
  2714	:  0100_0001  0x41   65  A  
  2715	:  0010_1101  0x2D   45  -  
  2716	:  0011_0101  0x35   53  5  
  2717	:  0011_0000  0x30   48  0  
  2718	:  0010_1101  0x2D   45  -  
  2719	:  0011_0001  0x31   49  1  
  2720	:  0011_0000  0x30   48  0  
  2721	:  0011_0001  0x31   49  1  
  2722	:  1100_0000  0xC0  192    
  2723	:  0000_1100  0x0C   12    
  2724	:  0000_0000  0x00    0    
  2725	:  0000_0001  0x01    1    
  2726	:  0000_0000  0x00    0    
  2727	:  0000_0001  0x01    1    
  2728	:  0000_0000  0x00    0    
  2729	:  0000_0000  0x00    0    
  2730	:  0010_1010  0x2A   42  *  
  2731	:  0011_0000  0x30   48  0  
  2732	:  0000_0000  0x00    0    
  2733	:  0000_0100  0x04    4    
  2734	:  0010_1101  0x2D   45  -  
  2735	:  0100_0011  0x43   67  C  
  2736	:  0011_0010  0x32   50  2  
  2737	:  0110_0101  0x65  101  e  
  2738	:  0000_1000  0x08    8    
  2739	:  0100_0001  0x41   65  A  
  2740	:  0010_1101  0x2D   45  -  
  2741	:  0011_0101  0x35   53  5  
  2742	:  0011_0000  0x30   48  0  
  2743	:  0010_1101  0x2D   45  -  
  2744	:  0011_0001  0x31   49  1  
  2745	:  0011_0000  0x30   48  0  
  2746	:  0011_0010  0x32   50  2  
  2747	:  1100_0000  0xC0  192    
  2748	:  0000_1100  0x0C   12    
  2749	:  0000_0000  0x00    0    
  2750	:  0000_0001  0x01    1    
  2751	:  0000_0000  0x00    0    
  2752	:  0000_0001  0x01    1    
  2753	:  0000_0000  0x00    0    
  2754	:  0000_0000  0x00    0    
  2755	:  0010_1010  0x2A   42  *  
  2756	:  0011_0000  0x30   48  0  
  2757	:  0000_0000  0x00    0    
  2758	:  0000_0100  0x04    4    
  2759	:  0010_1101  0x2D   45  -  
  2760	:  0100_0011  0x43   67  C  
  2761	:  0011_0010  0x32   50  2  
  2762	:  0110_0110  0x66  102  f  
  2763	:  0000_1000  0x08    8    
  2764	:  0100_0001  0x41   65  A  
  2765	:  0010_1101  0x2D   45  -  
  2766	:  0011_0101  0x35   53  5  
  2767	:  0011_0000  0x30   48  0  
  2768	:  0010_1101  0x2D   45  -  
  2769	:  0011_0001  0x31   49  1  
  2770	:  0011_0000  0x30   48  0  
  2771	:  0011_0011  0x33   51  3  
  2772	:  1100_0000  0xC0  192    
  2773	:  0000_1100  0x0C   12    
  2774	:  0000_0000  0x00    0    
  2775	:  0000_0001  0x01    1    
  2776	:  0000_0000  0x00    0    
  2777	:  0000_0001  0x01    1    
  2778	:  0000_0000  0x00    0    
  2779	:  0000_0000  0x00    0    
  2780	:  0010_1010  0x2A   42  *  
  2781	:  0011_0000  0x30   48  0  
  2782	:  0000_0000  0x00    0    
  2783	:  0000_0100  0x04    4    
  2784	:  0010_1101  0x2D   45  -  
  2785	:  0100_0011  0x43   67  C  
  2786	:  0011_0010  0x32   50  2  
  2787	:  0110_0111  0x67  103  g  
  2788	:  0000_1000  0x08    8    
  2789	:  0100_0001  0x41   65  A  
  2790	:  0010_1101  0x2D   45  -  
  2791	:  0011_0101  0x35   53  5  
  2792	:  0011_0000  0x30   48  0  
  2793	:  0010_1101  0x2D   45  -  
  2794	:  0011_0001  0x31   49  1  
  2795	:  0011_0000  0x30   48  0  
  2796	:  0011_0100  0x34   52  4  
  2797	:  1100_0000  0xC0  192    
  2798	:  0000_1100  0x0C   12    
  2799	:  0000_0000  0x00    0    
  2800	:  0000_0001  0x01    1    
  2801	:  0000_0000  0x00    0    
  2802	:  0000_0001  0x01    1    
  2803	:  0000_0000  0x00    0    
  2804	:  0000_0000  0x00    0    
  2805	:  0010_1010  0x2A   42  *  
  2806	:  0011_0000  0x30   48  0  
  2807	:  0000_0000  0x00    0    
  2808	:  0000_0100  0x04    4    
  2809	:  0010_1101  0x2D   45  -  
  2810	:  0100_0011  0x43   67  C  
  2811	:  0011_0010  0x32   50  2  
  2812	:  0110_1000  0x68  104  h  
  2813	:  0000_1000  0x08    8    
  2814	:  0100_0001  0x41   65  A  
  2815	:  0010_1101  0x2D   45  -  
  2816	:  0011_0101  0x35   53  5  
  2817	:  0011_0000  0x30   48  0  
  2818	:  0010_1101  0x2D   45  -  
  2819	:  0011_0001  0x31   49  1  
  2820	:  0011_0000  0x30   48  0  
  2821	:  0011_0101  0x35   53  5  
  2822	:  1100_0000  0xC0  192    
  2823	:  0000_1100  0x0C   12    
  2824	:  0000_0000  0x00    0    
  2825	:  0000_0001  0x01    1    
  2826	:  0000_0000  0x00    0    
  2827	:  0000_0001  0x01    1    
  2828	:  0000_0000  0x00    0    
  2829	:  0000_0000  0x00    0    
  2830	:  0010_1010  0x2A   42  *  
  2831	:  0011_0000  0x30   48  0  
  2832	:  0000_0000  0x00    0    
  2833	:  0000_0100  0x04    4    
  2834	:  0010_1101  0x2D   45  -  
  2835	:  0100_0011  0x43   67  C  
  2836	:  0011_0010  0x32   50  2  
  2837	:  0110_1001  0x69  105  i  
  2838	:  0000_1000  0x08    8    
  2839	:  0100_0001  0x41   65  A  
  2840	:  0010_1101  0x2D   45  -  
  2841	:  0011_0101  0x35   53  5  
  2842	:  0011_0000  0x30   48  0  
  2843	:  0010_1101  0x2D   45  -  
  2844	:  0011_0001  0x31   49  1  
  2845	:  0011_0000  0x30   48  0  
  2846	:  0011_0110  0x36   54  6  
  2847	:  1100_0000  0xC0  192    
  2848	:  0000_1100  0x0C   12    
  2849	:  0000_0000  0x00    0    
  2850	:  0000_0001  0x01    1    
  2851	:  0000_0000  0x00    0    
  2852	:  0000_0001  0x01    1    
  2853	:  0000_0000  0x00    0    
  2854	:  0000_0000  0x00    0    
  2855	:  0010_1010  0x2A   42  *  
  2856	:  0011_0000  0x30   48  0  
  2857	:  0000_0000  0x00    0    
  2858	:  0000_0100  0x04    4    
  2859	:  0010_1101  0x2D   45  -  
  2860	:  0100_0011  0x43   67  C  
  2861	:  0011_0010  0x32   50  2  
  2862	:  0110_1010  0x6A  106  j  
  2863	:  0000_1000  0x08    8    
  2864	:  0100_0001  0x41   65  A  
  2865	:  0010_1101  0x2D   45  -  
  2866	:  0011_0101  0x35   53  5  
  2867	:  0011_0000  0x30   48  0  
  2868	:  0010_1101  0x2D   45  -  
  2869	:  0011_0001  0x31   49  1  
  2870	:  0011_0000  0x30   48  0  
  2871	:  0011_0111  0x37   55  7  
  2872	:  1100_0000  0xC0  192    
  2873	:  0000_1100  0x0C   12    
  2874	:  0000_0000  0x00    0    
  2875	:  0000_0001  0x01    1    
  2876	:  0000_0000  0x00    0    
  2877	:  0000_0001  0x01    1    
  2878	:  0000_0000  0x00    0    
  2879	:  0000_0000  0x00    0    
  2880	:  0010_1010  0x2A   42  *  
  2881	:  0011_0000  0x30   48  0  
  2882	:  0000_0000  0x00    0    
  2883	:  0000_0100  0x04    4    
  2884	:  0010_1101  0x2D   45  -  
  2885	:  0100_0011  0x43   67  C  
  2886	:  0011_0010  0x32   50  2  
  2887	:  0110_1011  0x6B  107  k  
  2888	:  0000_1000  0x08    8    
  2889	:  0100_0001  0x41   65  A  
  2890	:  0010_1101  0x2D   45  -  
  2891	:  0011_0101  0x35   53  5  
  2892	:  0011_0000  0x30   48  0  
  2893	:  0010_1101  0x2D   45  -  
  2894	:  0011_0001  0x31   49  1  
  2895	:  0011_0000  0x30   48  0  
  2896	:  0011_1000  0x38   56  8  
  2897	:  1100_0000  0xC0  192    
  2898	:  0000_1100  0x0C   12    
  2899	:  0000_0000  0x00    0    
  2900	:  0000_0001  0x01    1    
  2901	:  0000_0000  0x00    0    
  2902	:  0000_0001  0x01    1    
  2903	:  0000_0000  0x00    0    
  2904	:  0000_0000  0x00    0    
  2905	:  0010_1010  0x2A   42  *  
  2906	:  0011_0000  0x30   48  0  
  2907	:  0000_0000  0x00    0    
  2908	:  0000_0100  0x04    4    
  2909	:  0010_1101  0x2D   45  -  
  2910	:  0100_0011  0x43   67  C  
  2911	:  0011_0010  0x32   50  2  
  2912	:  0110_1100  0x6C  108  l  
  2913	:  0000_1000  0x08    8    
  2914	:  0100_0001  0x41   65  A  
  2915	:  0010_1101  0x2D   45  -  
  2916	:  0011_0101  0x35   53  5  
  2917	:  0011_0000  0x30   48  0  
  2918	:  0010_1101  0x2D   45  -  
  2919	:  0011_0001  0x31   49  1  
  2920	:  0011_0000  0x30   48  0  
  2921	:  0011_1001  0x39   57  9  
  2922	:  1100_0000  0xC0  192    
  2923	:  0000_1100  0x0C   12    
  2924	:  0000_0000  0x00    0    
  2925	:  0000_0001  0x01    1    
  2926	:  0000_0000  0x00    0    
  2927	:  0000_0001  0x01    1    
  2928	:  0000_0000  0x00    0    
  2929	:  0000_0000  0x00    0    
  2930	:  0010_1010  0x2A   42  *  
  2931	:  0011_0000  0x30   48  0  
  2932	:  0000_0000  0x00    0    
  2933	:  0000_0100  0x04    4    
  2934	:  0010_1101  0x2D   45  -  
  2935	:  0100_0011  0x43   67  C  
  2936	:  0011_0010  0x32   50  2  
  2937	:  0110_1101  0x6D  109  m  
  2938	:  0000_1000  0x08    8    
  2939	:  0100_0001  0x41   65  A  
  2940	:  0010_1101  0x2D   45  -  
  2941	:  0011_0101  0x35   53  5  
  2942	:  0011_0000  0x30   48  0  
  2943	:  0010_1101  0x2D   45  -  
  2944	:  0011_0001  0x31   49  1  
  2945	:  0011_0001  0x31   49  1  
  2946	:  0011_0000  0x30   48  0  
  2947	:  1100_0000  0xC0  192    
  2948	:  0000_1100  0x0C   12    
  2949	:  0000_0000  0x00    0    
  2950	:  0000_0001  0x01    1    
  2951	:  0000_0000  0x00    0    
  2952	:  0000_0001  0x01    1    
  2953	:  0000_0000  0x00    0    
  2954	:  0000_0000  0x00    0    
  2955	:  0010_1010  0x2A   42  *  
  2956	:  0011_0000  0x30   48  0  
  2957	:  0000_0000  0x00    0    
  2958	:  0000_0100  0x04    4    
  2959	:  0010_1101  0x2D   45  -  
  2960	:  0100_0011  0x43   67  C  
  2961	:  0011_0010  0x32   50  2  
  2962	:  0110_1110  0x6E  110  n  
  2963	:  0000_1000  0x08    8    
  2964	:  0100_0001  0x41   65  A  
  2965	:  0010_1101  0x2D   45  -  
  2966	:  0011_0101  0x35   53  5  
  2967	:  0011_0000  0x30   48  0  
  2968	:  0010_1101  0x2D   45  -  
  2969	:  0011_0001  0x31   49  1  
  2970	:  0011_0001  0x31   49  1  
  2971	:  0011_0001  0x31   49  1  
  2972	:  1100_0000  0xC0  192    
  2973	:  0000_1100  0x0C   12    
  2974	:  0000_0000  0x00    0    
  2975	:  0000_0001  0x01    1    
  2976	:  0000_0000  0x00    0    
  2977	:  0000_0001  0x01    1    
  2978	:  0000_0000  0x00    0    
  2979	:  0000_0000  0x00    0    
  2980	:  0010_1010  0x2A   42  *  
  2981	:  0011_0000  0x30   48  0  
  2982	:  0000_0000  0x00    0    
  2983	:  0000_0100  0x04    4    
  2984	:  0010_1101  0x2D   45  -  
  2985	:  0100_0011  0x43   67  C  
  2986	:  0011_0010  0x32   50  2  
  2987	:  0110_1111  0x6F  111  o  
  2988	:  0000_1000  0x08    8    
  2989	:  0100_0001  0x41   65  A  
  2990	:  0010_1101  0x2D   45  -  
  2991	:  0011_0101  0x35   53  5  
  2992	:  0011_0000  0x30   48  0  
  2993	:  0010_1101  0x2D   45  -  
  2994	:  0011_0001  0x31   49  1  
  2995	:  0011_0001  0x31   49  1  
  2996	:  0011_0010  0x32   50  2  
  2997	:  1100_0000  0xC0  192    
  2998	:  0000_1100  0x0C   12    
  2999	:  0000_0000  0x00    0    
  3000	:  0000_0001  0x01    1    
  3001	:  0000_0000  0x00    0    
  3002	:  0000_0001  0x01    1    
  3003	:  0000_0000  0x00    0    
  3004	:  0000_0000  0x00    0    
  3005	:  0010_1010  0x2A   42  *  
  3006	:  0011_0000  0x30   48  0  
  3007	:  0000_0000  0x00    0    
  3008	:  0000_0100  0x04    4    
  3009	:  0010_1101  0x2D   45  -  
  3010	:  0100_0011  0x43   67  C  
  3011	:  0011_0010  0x32   50  2  
  3012	:  0111_0000  0x70  112  p  
  3013	:  0000_1000  0x08    8    
  3014	:  0100_0001  0x41   65  A  
  3015	:  0010_1101  0x2D   45  -  
  3016	:  0011_0101  0x35   53  5  
  3017	:  0011_0000  0x30   48  0  
  3018	:  0010_1101  0x2D   45  -  
  3019	:  0011_0001  0x31   49  1  
  3020	:  0011_0001  0x31   49  1  
  3021	:  0011_0011  0x33   51  3  
  3022	:  1100_0000  0xC0  192    
  3023	:  0000_1100  0x0C   12    
  3024	:  0000_0000  0x00    0    
  3025	:  0000_0001  0x01    1    
  3026	:  0000_0000  0x00    0    
  3027	:  0000_0001  0x01    1    
  3028	:  0000_0000  0x00    0    
  3029	:  0000_0000  0x00    0    
  3030	:  0010_1010  0x2A   42  *  
  3031	:  0011_0000  0x30   48  0  
  3032	:  0000_0000  0x00    0    
  3033	:  0000_0100  0x04    4    
  3034	:  0010_1101  0x2D   45  -  
  3035	:  0100_0011  0x43   67  C  
  3036	:  0011_0010  0x32   50  2  
  3037	:  0111_0001  0x71  113  q  
  3038	:  0000_1000  0x08    8    
  3039	:  0100_0001  0x41   65  A  
  3040	:  0010_1101  0x2D   45  -  
  3041	:  0011_0101  0x35   53  5  
  3042	:  0011_0000  0x30   48  0  
  3043	:  0010_1101  0x2D   45  -  
  3044	:  0011_0001  0x31   49  1  
  3045	:  0011_0001  0x31   49  1  
  3046	:  0011_0100  0x34   52  4  
  3047	:  1100_0000  0xC0  192    
  3048	:  0000_1100  0x0C   12    
  3049	:  0000_0000  0x00    0    
  3050	:  0000_0001  0x01    1    
  3051	:  0000_0000  0x00    0    
  3052	:  0000_0001  0x01    1    
  3053	:  0000_0000  0x00    0    
  3054	:  0000_0000  0x00    0    
  3055	:  0010_1010  0x2A   42  *  
  3056	:  0011_0000  0x30   48  0  
  3057	:  0000_0000  0x00    0    
  3058	:  0000_0100  0x04    4    
  3059	:  0010_1101  0x2D   45  -  
  3060	:  0100_0011  0x43   67  C  
  3061	:  0011_0010  0x32   50  2  
  3062	:  0111_0010  0x72  114  r  
  3063	:  0000_1000  0x08    8    
  3064	:  0100_0001  0x41   65  A  
  3065	:  0010_1101  0x2D   45  -  
  3066	:  0011_0101  0x35   53  5  
  3067	:  0011_0000  0x30   48  0  
  3068	:  0010_1101  0x2D   45  -  
  3069	:  0011_0001  0x31   49  1  
  3070	:  0011_0001  0x31   49  1  
  3071	:  0011_0101  0x35   53  5  
  3072	:  1100_0000  0xC0  192    
  3073	:  0000_1100  0x0C   12    
  3074	:  0000_0000  0x00    0    
  3075	:  0000_0001  0x01    1    
  3076	:  0000_0000  0x00    0    
  3077	:  0000_0001  0x01    1    
  3078	:  0000_0000  0x00    0    
  3079	:  0000_0000  0x00    0    
  3080	:  0010_1010  0x2A   42  *  
  3081	:  0011_0000  0x30   48  0  
  3082	:  0000_0000  0x00    0    
  3083	:  0000_0100  0x04    4    
  3084	:  0010_1101  0x2D   45  -  
  3085	:  0100_0011  0x43   67  C  
  3086	:  0011_0010  0x32   50  2  
  3087	:  0111_0011  0x73  115  s  
  3088	:  0000_1000  0x08    8    
  3089	:  0100_0001  0x41   65  A  
  3090	:  0010_1101  0x2D   45  -  
  3091	:  0011_0101  0x35   53  5  
  3092	:  0011_0000  0x30   48  0  
  3093	:  0010_1101  0x2D   45  -  
  3094	:  0011_0001  0x31   49  1  
  3095	:  0011_0001  0x31   49  1  
  3096	:  0011_0110  0x36   54  6  
  3097	:  1100_0000  0xC0  192    
  3098	:  0000_1100  0x0C   12    
  3099	:  0000_0000  0x00    0    
  3100	:  0000_0001  0x01    1    
  3101	:  0000_0000  0x00    0    
  3102	:  0000_0001  0x01    1    
  3103	:  0000_0000  0x00    0    
  3104	:  0000_0000  0x00    0    
  3105	:  0010_1010  0x2A   42  *  
  3106	:  0011_0000  0x30   48  0  
  3107	:  0000_0000  0x00    0    
  3108	:  0000_0100  0x04    4    
  3109	:  0010_1101  0x2D   45  -  
  3110	:  0100_0011  0x43   67  C  
  3111	:  0011_0010  0x32   50  2  
  3112	:  0111_0100  0x74  116  t  
  3113	:  0000_1000  0x08    8    
  3114	:  0100_0001  0x41   65  A  
  3115	:  0010_1101  0x2D   45  -  
  3116	:  0011_0101  0x35   53  5  
  3117	:  0011_0000  0x30   48  0  
  3118	:  0010_1101  0x2D   45  -  
  3119	:  0011_0001  0x31   49  1  
  3120	:  0011_0001  0x31   49  1  
  3121	:  0011_0111  0x37   55  7  
  3122	:  1100_0000  0xC0  192    
  3123	:  0000_1100  0x0C   12    
  3124	:  0000_0000  0x00    0    
  3125	:  0000_0001  0x01    1    
  3126	:  0000_0000  0x00    0    
  3127	:  0000_0001  0x01    1    
  3128	:  0000_0000  0x00    0    
  3129	:  0000_0000  0x00    0    
  3130	:  0010_1010  0x2A   42  *  
  3131	:  0011_0000  0x30   48  0  
  3132	:  0000_0000  0x00    0    
  3133	:  0000_0100  0x04    4    
  3134	:  0010_1101  0x2D   45  -  
  3135	:  0100_0011  0x43   67  C  
  3136	:  0011_0010  0x32   50  2  
  3137	:  0111_0101  0x75  117  u  
  3138	:  0000_1000  0x08    8    
  3139	:  0100_0001  0x41   65  A  
  3140	:  0010_1101  0x2D   45  -  
  3141	:  0011_0101  0x35   53  5  
  3142	:  0011_0000  0x30   48  0  
  3143	:  0010_1101  0x2D   45  -  
  3144	:  0011_0001  0x31   49  1  
  3145	:  0011_0001  0x31   49  1  
  3146	:  0011_1000  0x38   56  8  
  3147	:  1100_0000  0xC0  192    
  3148	:  0000_1100  0x0C   12    
  3149	:  0000_0000  0x00    0    
  3150	:  0000_0001  0x01    1    
  3151	:  0000_0000  0x00    0    
  3152	:  0000_0001  0x01    1    
  3153	:  0000_0000  0x00    0    
  3154	:  0000_0000  0x00    0    
  3155	:  0010_1010  0x2A   42  *  
  3156	:  0011_0000  0x30   48  0  
  3157	:  0000_0000  0x00    0    
  3158	:  0000_0100  0x04    4    
  3159	:  0010_1101  0x2D   45  -  
  3160	:  0100_0011  0x43   67  C  
  3161	:  0011_0010  0x32   50  2  
  3162	:  0111_0110  0x76  118  v  
  3163	:  0000_1000  0x08    8    
  3164	:  0100_0001  0x41   65  A  
  3165	:  0010_1101  0x2D   45  -  
  3166	:  0011_0101  0x35   53  5  
  3167	:  0011_0000  0x30   48  0  
  3168	:  0010_1101  0x2D   45  -  
  3169	:  0011_0001  0x31   49  1  
  3170	:  0011_0001  0x31   49  1  
  3171	:  0011_1001  0x39   57  9  
  3172	:  1100_0000  0xC0  192    
  3173	:  0000_1100  0x0C   12    
  3174	:  0000_0000  0x00    0    
  3175	:  0000_0001  0x01    1    
  3176	:  0000_0000  0x00    0    
  3177	:  0000_0001  0x01    1    
  3178	:  0000_0000  0x00    0    
  3179	:  0000_0000  0x00    0    
  3180	:  0010_1010  0x2A   42  *  
  3181	:  0011_0000  0x30   48  0  
  3182	:  0000_0000  0x00    0    
  3183	:  0000_0100  0x04    4    
  3184	:  0010_1101  0x2D   45  -  
  3185	:  0100_0011  0x43   67  C  
  3186	:  0011_0010  0x32   50  2  
  3187	:  0111_0111  0x77  119  w  
  3188	:  0000_1000  0x08    8    
  3189	:  0100_0001  0x41   65  A  
  3190	:  0010_1101  0x2D   45  -  
  3191	:  0011_0101  0x35   53  5  
  3192	:  0011_0000  0x30   48  0  
  3193	:  0010_1101  0x2D   45  -  
  3194	:  0011_0001  0x31   49  1  
  3195	:  0011_0010  0x32   50  2  
  3196	:  0011_0000  0x30   48  0  
  3197	:  1100_0000  0xC0  192    
  3198	:  0000_1100  0x0C   12    
  3199	:  0000_0000  0x00    0    
  3200	:  0000_0001  0x01    1    
  3201	:  0000_0000  0x00    0    
  3202	:  0000_0001  0x01    1    
  3203	:  0000_0000  0x00    0    
  3204	:  0000_0000  0x00    0    
  3205	:  0010_1010  0x2A   42  *  
  3206	:  0011_0000  0x30   48  0  
  3207	:  0000_0000  0x00    0    
  3208	:  0000_0100  0x04    4    
  3209	:  0010_1101  0x2D   45  -  
  3210	:  0100_0011  0x43   67  C  
  3211	:  0011_0010  0x32   50  2  
  3212	:  0111_1000  0x78  120  x  
  3213	:  0000_1000  0x08    8    
  3214	:  0100_0001  0x41   65  A  
  3215	:  0010_1101  0x2D   45  -  
  3216	:  0011_0101  0x35   53  5  
  3217	:  0011_0000  0x30   48  0  
  3218	:  0010_1101  0x2D   45  -  
  3219	:  0011_0001  0x31   49  1  
  3220	:  0011_0010  0x32   50  2  
  3221	:  0011_0001  0x31   49  1  
  3222	:  1100_0000  0xC0  192    
  3223	:  0000_1100  0x0C   12    
  3224	:  0000_0000  0x00    0    
  3225	:  0000_0001  0x01    1    
  3226	:  0000_0000  0x00    0    
  3227	:  0000_0001  0x01    1    
  3228	:  0000_0000  0x00    0    
  3229	:  0000_0000  0x00    0    
  3230	:  0010_1010  0x2A   42  *  
  3231	:  0011_0000  0x30   48  0  
  3232	:  0000_0000  0x00    0    
  3233	:  0000_0100  0x04    4    
  3234	:  0010_1101  0x2D   45  -  
  3235	:  0100_0011  0x43   67  C  
  3236	:  0011_0010  0x32   50  2  
  3237	:  0111_1001  0x79  121  y  
  3238	:  0000_1000  0x08    8    
  3239	:  0100_0001  0x41   65  A  
  3240	:  0010_1101  0x2D   45  -  
  3241	:  0011_0101  0x35   53  5  
  3242	:  0011_0000  0x30   48  0  
  3243	:  0010_1101  0x2D   45  -  
  3244	:  0011_0001  0x31   49  1  
  3245	:  0011_0010  0x32   50  2  
  3246	:  0011_0010  0x32   50  2  
  3247	:  1100_0000  0xC0  192    
  3248	:  0000_1100  0x0C   12    
  3249	:  0000_0000  0x00    0    
  3250	:  0000_0001  0x01    1    
  3251	:  0000_0000  0x00    0    
  3252	:  0000_0001  0x01    1    
  3253	:  0000_0000  0x00    0    
  3254	:  0000_0000  0x00    0    
  3255	:  0010_1010  0x2A   42  *  
  3256	:  0011_0000  0x30   48  0  
  3257	:  0000_0000  0x00    0    
  3258	:  0000_0100  0x04    4    
  3259	:  0010_1101  0x2D   45  -  
  3260	:  0100_0011  0x43   67  C  
  3261	:  0011_0010  0x32   50  2  
  3262	:  0111_1010  0x7A  122  z  
  3263	:  0000_1000  0x08    8    
  3264	:  0100_0001  0x41   65  A  
  3265	:  0010_1101  0x2D   45  -  
  3266	:  0011_0101  0x35   53  5  
  3267	:  0011_0000  0x30   48  0  
  3268	:  0010_1101  0x2D   45  -  
  3269	:  0011_0001  0x31   49  1  
  3270	:  0011_0010  0x32   50  2  
  3271	:  0011_0011  0x33   51  3  
  3272	:  1100_0000  0xC0  192    
  3273	:  0000_1100  0x0C   12    
  3274	:  0000_0000  0x00    0    
  3275	:  0000_0001  0x01    1    
  3276	:  0000_0000  0x00    0    
  3277	:  0000_0001  0x01    1    
  3278	:  0000_0000  0x00    0    
  3279	:  0000_0000  0x00    0    
  3280	:  0010_1010  0x2A   42  *  
  3281	:  0011_0000  0x30   48  0  
  3282	:  0000_0000  0x00    0    
  3283	:  0000_0100  0x04    4    
  3284	:  0010_1101  0x2D   45  -  
  3285	:  0100_0011  0x43   67  C  
  3286	:  0011_0010  0x32   50  2  
  3287	:  0111_1011  0x7B  123  {  
  3288	:  0000_1000  0x08    8    
  3289	:  0100_0001  0x41   65  A  
  3290	:  0010_1101  0x2D   45  -  
  3291	:  0011_0101  0x35   53  5  
  3292	:  0011_0000  0x30   48  0  
  3293	:  0010_1101  0x2D   45  -  
  3294	:  0011_0001  0x31   49  1  
  3295	:  0011_0010  0x32   50  2  
  3296	:  0011_0100  0x34   52  4  
  3297	:  1100_0000  0xC0  192    
  3298	:  0000_1100  0x0C   12    
  3299	:  0000_0000  0x00    0    
  3300	:  0000_0001  0x01    1    
  3301	:  0000_0000  0x00    0    
  3302	:  0000_0001  0x01    1    
  3303	:  0000_0000  0x00    0    
  3304	:  0000_0000  0x00    0    
  3305	:  0010_1010  0x2A   42  *  
  3306	:  0011_0000  0x30   48  0  
  3307	:  0000_0000  0x00    0    
  3308	:  0000_0100  0x04    4    
  3309	:  0010_1101  0x2D   45  -  
  3310	:  0100_0011  0x43   67  C  
  3311	:  0011_0010  0x32   50  2  
  3312	:  0111_1100  0x7C  124  |.'|'.q|  
  3313	:  0000_1000  0x08    8    
  3314	:  0100_0001  0x41   65  A  
  3315	:  0010_1101  0x2D   45  -  
  3316	:  0011_0101  0x35   53  5  
  3317	:  0011_0000  0x30   48  0  
  3318	:  0010_1101  0x2D   45  -  
  3319	:  0011_0001  0x31   49  1  
  3320	:  0011_0010  0x32   50  2  
  3321	:  0011_0101  0x35   53  5  
  3322	:  1100_0000  0xC0  192    
  3323	:  0000_1100  0x0C   12    
  3324	:  0000_0000  0x00    0    
  3325	:  0000_0001  0x01    1    
  3326	:  0000_0000  0x00    0    
  3327	:  0000_0001  0x01    1    
  3328	:  0000_0000  0x00    0    
  3329	:  0000_0000  0x00    0    
  3330	:  0010_1010  0x2A   42  *  
  3331	:  0011_0000  0x30   48  0  
  3332	:  0000_0000  0x00    0    
  3333	:  0000_0100  0x04    4    
  3334	:  0010_1101  0x2D   45  -  
  3335	:  0100_0011  0x43   67  C  
  3336	:  0011_0010  0x32   50  2  
  3337	:  0111_1101  0x7D  125  }  
  3338	:  0000_1000  0x08    8    
  3339	:  0100_0001  0x41   65  A  
  3340	:  0010_1101  0x2D   45  -  
  3341	:  0011_0101  0x35   53  5  
  3342	:  0011_0000  0x30   48  0  
  3343	:  0010_1101  0x2D   45  -  
  3344	:  0011_0001  0x31   49  1  
  3345	:  0011_0010  0x32   50  2  
  3346	:  0011_0110  0x36   54  6  
  3347	:  1100_0000  0xC0  192    
  3348	:  0000_1100  0x0C   12    
  3349	:  0000_0000  0x00    0    
  3350	:  0000_0001  0x01    1    
  3351	:  0000_0000  0x00    0    
  3352	:  0000_0001  0x01    1    
  3353	:  0000_0000  0x00    0    
  3354	:  0000_0000  0x00    0    
  3355	:  0010_1010  0x2A   42  *  
  3356	:  0011_0000  0x30   48  0  
  3357	:  0000_0000  0x00    0    
  3358	:  0000_0100  0x04    4    
  3359	:  0010_1101  0x2D   45  -  
  3360	:  0100_0011  0x43   67  C  
  3361	:  0011_0010  0x32   50  2  
  3362	:  0111_1110  0x7E  126  ~  
  3363	:  0000_1000  0x08    8    
  3364	:  0100_0001  0x41   65  A  
  3365	:  0010_1101  0x2D   45  -  
  3366	:  0011_0101  0x35   53  5  
  3367	:  0011_0000  0x30   48  0  
  3368	:  0010_1101  0x2D   45  -  
  3369	:  0011_0001  0x31   49  1  
  3370	:  0011_0010  0x32   50  2  
  3371	:  0011_0111  0x37   55  7  
  3372	:  1100_0000  0xC0  192    
  3373	:  0000_1100  0x0C   12    
  3374	:  0000_0000  0x00    0    
  3375	:  0000_0001  0x01    1    
  3376	:  0000_0000  0x00    0    
  3377	:  0000_0001  0x01    1    
  3378	:  0000_0000  0x00    0    
  3379	:  0000_0000  0x00    0    
  3380	:  0010_1010  0x2A   42  *  
  3381	:  0011_0000  0x30   48  0  
  3382	:  0000_0000  0x00    0    
  3383	:  0000_0100  0x04    4    
  3384	:  0010_1101  0x2D   45  -  
  3385	:  0100_0011  0x43   67  C  
  3386	:  0011_0010  0x32   50  2  
  3387	:  0111_1111  0x7F  127    
  3388	:  0000_1000  0x08    8    
  3389	:  0100_0001  0x41   65  A  
  3390	:  0010_1101  0x2D   45  -  
  3391	:  0011_0101  0x35   53  5  
  3392	:  0011_0000  0x30   48  0  
  3393	:  0010_1101  0x2D   45  -  
  3394	:  0011_0001  0x31   49  1  
  3395	:  0011_0010  0x32   50  2  
  3396	:  0011_1000  0x38   56  8  
  3397	:  1100_0000  0xC0  192    
  3398	:  0000_1100  0x0C   12    
  3399	:  0000_0000  0x00    0    
  3400	:  0000_0001  0x01    1    
  3401	:  0000_0000  0x00    0    
  3402	:  0000_0001  0x01    1    
  3403	:  0000_0000  0x00    0    
  3404	:  0000_0000  0x00    0    
  3405	:  0010_1010  0x2A   42  *  
  3406	:  0011_0000  0x30   48  0  
  3407	:  0000_0000  0x00    0    
  3408	:  0000_0100  0x04    4    
  3409	:  0010_1101  0x2D   45  -  
  3410	:  0100_0011  0x43   67  C  
  3411	:  0011_0010  0x32   50  2  
  3412	:  1000_0000  0x80  128    
  3413	:  0000_1000  0x08    8    
  3414	:  0100_0001  0x41   65  A  
  3415	:  0010_1101  0x2D   45  -  
  3416	:  0011_0101  0x35   53  5  
  3417	:  0011_0000  0x30   48  0  
  3418	:  0010_1101  0x2D   45  -  
  3419	:  0011_0001  0x31   49  1  
  3420	:  0011_0010  0x32   50  2  
  3421	:  0011_1001  0x39   57  9  
  3422	:  1100_0000  0xC0  192    
  3423	:  0000_1100  0x0C   12    
  3424	:  0000_0000  0x00    0    
  3425	:  0000_0001  0x01    1    
  3426	:  0000_0000  0x00    0    
  3427	:  0000_0001  0x01    1    
  3428	:  0000_0000  0x00    0    
  3429	:  0000_0000  0x00    0    
  3430	:  0010_1010  0x2A   42  *  
  3431	:  0011_0000  0x30   48  0  
  3432	:  0000_0000  0x00    0    
  3433	:  0000_0100  0x04    4    
  3434	:  0010_1101  0x2D   45  -  
  3435	:  0100_0011  0x43   67  C  
  3436	:  0011_0010  0x32   50  2  
  3437	:  1000_0001  0x81  129    
  3438	:  0000_1000  0x08    8    
  3439	:  0100_0001  0x41   65  A  
  3440	:  0010_1101  0x2D   45  -  
  3441	:  0011_0101  0x35   53  5  
  3442	:  0011_0000  0x30   48  0  
  3443	:  0010_1101  0x2D   45  -  
  3444	:  0011_0001  0x31   49  1  
  3445	:  0011_0011  0x33   51  3  
  3446	:  0011_0000  0x30   48  0  
  3447	:  1100_0000  0xC0  192    
  3448	:  0000_1100  0x0C   12    
  3449	:  0000_0000  0x00    0    
  3450	:  0000_0001  0x01    1    
  3451	:  0000_0000  0x00    0    
  3452	:  0000_0001  0x01    1    
  3453	:  0000_0000  0x00    0    
  3454	:  0000_0000  0x00    0    
  3455	:  0010_1010  0x2A   42  *  
  3456	:  0011_0000  0x30   48  0  
  3457	:  0000_0000  0x00    0    
  3458	:  0000_0100  0x04    4    
  3459	:  0010_1101  0x2D   45  -  
  3460	:  0100_0011  0x43   67  C  
  3461	:  0011_0010  0x32   50  2  
  3462	:  1000_0010  0x82  130    
  3463	:  0000_1000  0x08    8    
  3464	:  0100_0001  0x41   65  A  
  3465	:  0010_1101  0x2D   45  -  
  3466	:  0011_0101  0x35   53  5  
  3467	:  0011_0000  0x30   48  0  
  3468	:  0010_1101  0x2D   45  -  
  3469	:  0011_0001  0x31   49  1  
  3470	:  0011_0011  0x33   51  3  
  3471	:  0011_0001  0x31   49  1  
  3472	:  1100_0000  0xC0  192    
  3473	:  0000_1100  0x0C   12    
  3474	:  0000_0000  0x00    0    
  3475	:  0000_0001  0x01    1    
  3476	:  0000_0000  0x00    0    
  3477	:  0000_0001  0x01    1    
  3478	:  0000_0000  0x00    0    
  3479	:  0000_0000  0x00    0    
  3480	:  0010_1010  0x2A   42  *  
  3481	:  0011_0000  0x30   48  0  
  3482	:  0000_0000  0x00    0    
  3483	:  0000_0100  0x04    4    
  3484	:  0010_1101  0x2D   45  -  
  3485	:  0100_0011  0x43   67  C  
  3486	:  0011_0010  0x32   50  2  
  3487	:  1000_0011  0x83  131    
  3488	:  0000_1000  0x08    8    
  3489	:  0100_0001  0x41   65  A  
  3490	:  0010_1101  0x2D   45  -  
  3491	:  0011_0101  0x35   53  5  
  3492	:  0011_0000  0x30   48  0  
  3493	:  0010_1101  0x2D   45  -  
  3494	:  0011_0001  0x31   49  1  
  3495	:  0011_0011  0x33   51  3  
  3496	:  0011_0010  0x32   50  2  
  3497	:  1100_0000  0xC0  192    
  3498	:  0000_1100  0x0C   12    
  3499	:  0000_0000  0x00    0    
  3500	:  0000_0001  0x01    1    
  3501	:  0000_0000  0x00    0    
  3502	:  0000_0001  0x01    1    
  3503	:  0000_0000  0x00    0    
  3504	:  0000_0000  0x00    0    
  3505	:  0010_1010  0x2A   42  *  
  3506	:  0011_0000  0x30   48  0  
  3507	:  0000_0000  0x00    0    
  3508	:  0000_0100  0x04    4    
  3509	:  0010_1101  0x2D   45  -  
  3510	:  0100_0011  0x43   67  C  
  3511	:  0011_0010  0x32   50  2  
  3512	:  1000_0100  0x84  132    
  3513	:  0000_1000  0x08    8    
  3514	:  0100_0001  0x41   65  A  
  3515	:  0010_1101  0x2D   45  -  
  3516	:  0011_0101  0x35   53  5  
  3517	:  0011_0000  0x30   48  0  
  3518	:  0010_1101  0x2D   45  -  
  3519	:  0011_0001  0x31   49  1  
  3520	:  0011_0011  0x33   51  3  
  3521	:  0011_0011  0x33   51  3  
  3522	:  1100_0000  0xC0  192    
  3523	:  0000_1100  0x0C   12    
  3524	:  0000_0000  0x00    0    
  3525	:  0000_0001  0x01    1    
  3526	:  0000_0000  0x00    0    
  3527	:  0000_0001  0x01    1    
  3528	:  0000_0000  0x00    0    
  3529	:  0000_0000  0x00    0    
  3530	:  0010_1010  0x2A   42  *  
  3531	:  0011_0000  0x30   48  0  
  3532	:  0000_0000  0x00    0    
  3533	:  0000_0100  0x04    4    
  3534	:  0010_1101  0x2D   45  -  
  3535	:  0100_0011  0x43   67  C  
  3536	:  0011_0010  0x32   50  2  
  3537	:  1000_0101  0x85  133    
  3538	:  0000_1000  0x08    8    
  3539	:  0100_0001  0x41   65  A  
  3540	:  0010_1101  0x2D   45  -  
  3541	:  0011_0101  0x35   53  5  
  3542	:  0011_0000  0x30   48  0  
  3543	:  0010_1101  0x2D   45  -  
  3544	:  0011_0001  0x31   49  1  
  3545	:  0011_0011  0x33   51  3  
  3546	:  0011_0100  0x34   52  4  
  3547	:  1100_0000  0xC0  192    
  3548	:  0000_1100  0x0C   12    
  3549	:  0000_0000  0x00    0    
  3550	:  0000_0001  0x01    1    
  3551	:  0000_0000  0x00    0    
  3552	:  0000_0001  0x01    1    
  3553	:  0000_0000  0x00    0    
  3554	:  0000_0000  0x00    0    
  3555	:  0010_1010  0x2A   42  *  
  3556	:  0011_0000  0x30   48  0  
  3557	:  0000_0000  0x00    0    
  3558	:  0000_0100  0x04    4    
  3559	:  0010_1101  0x2D   45  -  
  3560	:  0100_0011  0x43   67  C  
  3561	:  0011_0010  0x32   50  2  
  3562	:  1000_0110  0x86  134    
  3563	:  0000_1000  0x08    8    
  3564	:  0100_0001  0x41   65  A  
  3565	:  0010_1101  0x2D   45  -  
  3566	:  0011_0101  0x35   53  5  
  3567	:  0011_0000  0x30   48  0  
  3568	:  0010_1101  0x2D   45  -  
  3569	:  0011_0001  0x31   49  1  
  3570	:  0011_0011  0x33   51  3  
  3571	:  0011_0101  0x35   53  5  
  3572	:  1100_0000  0xC0  192    
  3573	:  0000_1100  0x0C   12    
  3574	:  0000_0000  0x00    0    
  3575	:  0000_0001  0x01    1    
  3576	:  0000_0000  0x00    0    
  3577	:  0000_0001  0x01    1    
  3578	:  0000_0000  0x00    0    
  3579	:  0000_0000  0x00    0    
  3580	:  0010_1010  0x2A   42  *  
  3581	:  0011_0000  0x30   48  0  
  3582	:  0000_0000  0x00    0    
  3583	:  0000_0100  0x04    4    
  3584	:  0010_1101  0x2D   45  -  
  3585	:  0100_0011  0x43   67  C  
  3586	:  0011_0010  0x32   50  2  
  3587	:  1000_0111  0x87  135    
  3588	:  0000_1000  0x08    8    
  3589	:  0100_0001  0x41   65  A  
  3590	:  0010_1101  0x2D   45  -  
  3591	:  0011_0101  0x35   53  5  
  3592	:  0011_0000  0x30   48  0  
  3593	:  0010_1101  0x2D   45  -  
  3594	:  0011_0001  0x31   49  1  
  3595	:  0011_0011  0x33   51  3  
  3596	:  0011_0110  0x36   54  6  
  3597	:  1100_0000  0xC0  192    
  3598	:  0000_1100  0x0C   12    
  3599	:  0000_0000  0x00    0    
  3600	:  0000_0001  0x01    1    
  3601	:  0000_0000  0x00    0    
  3602	:  0000_0001  0x01    1    
  3603	:  0000_0000  0x00    0    
  3604	:  0000_0000  0x00    0    
  3605	:  0010_1010  0x2A   42  *  
  3606	:  0011_0000  0x30   48  0  
  3607	:  0000_0000  0x00    0    
  3608	:  0000_0100  0x04    4    
  3609	:  0010_1101  0x2D   45  -  
  3610	:  0100_0011  0x43   67  C  
  3611	:  0011_0010  0x32   50  2  
  3612	:  1000_1000  0x88  136    
  3613	:  0000_1000  0x08    8    
  3614	:  0100_0001  0x41   65  A  
  3615	:  0010_1101  0x2D   45  -  
  3616	:  0011_0101  0x35   53  5  
  3617	:  0011_0000  0x30   48  0  
  3618	:  0010_1101  0x2D   45  -  
  3619	:  0011_0001  0x31   49  1  
  3620	:  0011_0011  0x33   51  3  
  3621	:  0011_0111  0x37   55  7  
  3622	:  1100_0000  0xC0  192    
  3623	:  0000_1100  0x0C   12    
  3624	:  0000_0000  0x00    0    
  3625	:  0000_0001  0x01    1    
  3626	:  0000_0000  0x00    0    
  3627	:  0000_0001  0x01    1    
  3628	:  0000_0000  0x00    0    
  3629	:  0000_0000  0x00    0    
  3630	:  0010_1010  0x2A   42  *  
  3631	:  0011_0000  0x30   48  0  
  3632	:  0000_0000  0x00    0    
  3633	:  0000_0100  0x04    4    
  3634	:  0010_1101  0x2D   45  -  
  3635	:  0100_0011  0x43   67  C  
  3636	:  0011_0010  0x32   50  2  
  3637	:  1000_1001  0x89  137    
  3638	:  0000_1000  0x08    8    
  3639	:  0100_0001  0x41   65  A  
  3640	:  0010_1101  0x2D   45  -  
  3641	:  0011_0101  0x35   53  5  
  3642	:  0011_0000  0x30   48  0  
  3643	:  0010_1101  0x2D   45  -  
  3644	:  0011_0001  0x31   49  1  
  3645	:  0011_0011  0x33   51  3  
  3646	:  0011_1000  0x38   56  8  
  3647	:  1100_0000  0xC0  192    
  3648	:  0000_1100  0x0C   12    
  3649	:  0000_0000  0x00    0    
  3650	:  0000_0001  0x01    1    
  3651	:  0000_0000  0x00    0    
  3652	:  0000_0001  0x01    1    
  3653	:  0000_0000  0x00    0    
  3654	:  0000_0000  0x00    0    
  3655	:  0010_1010  0x2A   42  *  
  3656	:  0011_0000  0x30   48  0  
  3657	:  0000_0000  0x00    0    
  3658	:  0000_0100  0x04    4    
  3659	:  0010_1101  0x2D   45  -  
  3660	:  0100_0011  0x43   67  C  
  3661	:  0011_0010  0x32   50  2  
  3662	:  1000_1010  0x8A  138    
  3663	:  0000_1000  0x08    8    
  3664	:  0100_0001  0x41   65  A  
  3665	:  0010_1101  0x2D   45  -  
  3666	:  0011_0101  0x35   53  5  
  3667	:  0011_0000  0x30   48  0  
  3668	:  0010_1101  0x2D   45  -  
  3669	:  0011_0001  0x31   49  1  
  3670	:  0011_0011  0x33   51  3  
  3671	:  0011_1001  0x39   57  9  
  3672	:  1100_0000  0xC0  192    
  3673	:  0000_1100  0x0C   12    
  3674	:  0000_0000  0x00    0    
  3675	:  0000_0001  0x01    1    
  3676	:  0000_0000  0x00    0    
  3677	:  0000_0001  0x01    1    
  3678	:  0000_0000  0x00    0    
  3679	:  0000_0000  0x00    0    
  3680	:  0010_1010  0x2A   42  *  
  3681	:  0011_0000  0x30   48  0  
  3682	:  0000_0000  0x00    0    
  3683	:  0000_0100  0x04    4    
  3684	:  0010_1101  0x2D   45  -  
  3685	:  0100_0011  0x43   67  C  
  3686	:  0011_0010  0x32   50  2  
  3687	:  1000_1011  0x8B  139    
  3688	:  0000_1000  0x08    8    
  3689	:  0100_0001  0x41   65  A  
  3690	:  0010_1101  0x2D   45  -  
  3691	:  0011_0101  0x35   53  5  
  3692	:  0011_0000  0x30   48  0  
  3693	:  0010_1101  0x2D   45  -  
  3694	:  0011_0001  0x31   49  1  
  3695	:  0011_0100  0x34   52  4  
  3696	:  0011_0000  0x30   48  0  
  3697	:  1100_0000  0xC0  192    
  3698	:  0000_1100  0x0C   12    
  3699	:  0000_0000  0x00    0    
  3700	:  0000_0001  0x01    1    
  3701	:  0000_0000  0x00    0    
  3702	:  0000_0001  0x01    1    
  3703	:  0000_0000  0x00    0    
  3704	:  0000_0000  0x00    0    
  3705	:  0010_1010  0x2A   42  *  
  3706	:  0011_0000  0x30   48  0  
  3707	:  0000_0000  0x00    0    
  3708	:  0000_0100  0x04    4    
  3709	:  0010_1101  0x2D   45  -  
  3710	:  0100_0011  0x43   67  C  
  3711	:  0011_0010  0x32   50  2  
  3712	:  1000_1100  0x8C  140    
  3713	:  0000_1000  0x08    8    
  3714	:  0100_0001  0x41   65  A  
  3715	:  0010_1101  0x2D   45  -  
  3716	:  0011_0101  0x35   53  5  
  3717	:  0011_0000  0x30   48  0  
  3718	:  0010_1101  0x2D   45  -  
  3719	:  0011_0001  0x31   49  1  
  3720	:  0011_0100  0x34   52  4  
  3721	:  0011_0001  0x31   49  1  
  3722	:  1100_0000  0xC0  192    
  3723	:  0000_1100  0x0C   12    
  3724	:  0000_0000  0x00    0    
  3725	:  0000_0001  0x01    1    
  3726	:  0000_0000  0x00    0    
  3727	:  0000_0001  0x01    1    
  3728	:  0000_0000  0x00    0    
  3729	:  0000_0000  0x00    0    
  3730	:  0010_1010  0x2A   42  *  
  3731	:  0011_0000  0x30   48  0  
  3732	:  0000_0000  0x00    0    
  3733	:  0000_0100  0x04    4    
  3734	:  0010_1101  0x2D   45  -  
  3735	:  0100_0011  0x43   67  C  
  3736	:  0011_0010  0x32   50  2  
  3737	:  1000_1101  0x8D  141    
  3738	:  0000_1000  0x08    8    
  3739	:  0100_0001  0x41   65  A  
  3740	:  0010_1101  0x2D   45  -  
  3741	:  0011_0101  0x35   53  5  
  3742	:  0011_0000  0x30   48  0  
  3743	:  0010_1101  0x2D   45  -  
  3744	:  0011_0001  0x31   49  1  
  3745	:  0011_0100  0x34   52  4  
  3746	:  0011_0010  0x32   50  2  
  3747	:  1100_0000  0xC0  192    
  3748	:  0000_1100  0x0C   12    
  3749	:  0000_0000  0x00    0    
  3750	:  0000_0001  0x01    1    
  3751	:  0000_0000  0x00    0    
  3752	:  0000_0001  0x01    1    
  3753	:  0000_0000  0x00    0    
  3754	:  0000_0000  0x00    0    
  3755	:  0010_1010  0x2A   42  *  
  3756	:  0011_0000  0x30   48  0  
  3757	:  0000_0000  0x00    0    
  3758	:  0000_0100  0x04    4    
  3759	:  0010_1101  0x2D   45  -  
  3760	:  0100_0011  0x43   67  C  
  3761	:  0011_0010  0x32   50  2  
  3762	:  1000_1110  0x8E  142    
  3763	:  0000_1000  0x08    8    
  3764	:  0100_0001  0x41   65  A  
  3765	:  0010_1101  0x2D   45  -  
  3766	:  0011_0101  0x35   53  5  
  3767	:  0011_0000  0x30   48  0  
  3768	:  0010_1101  0x2D   45  -  
  3769	:  0011_0001  0x31   49  1  
  3770	:  0011_0100  0x34   52  4  
  3771	:  0011_0011  0x33   51  3  
  3772	:  1100_0000  0xC0  192    
  3773	:  0000_1100  0x0C   12    
  3774	:  0000_0000  0x00    0    
  3775	:  0000_0001  0x01    1    
  3776	:  0000_0000  0x00    0    
  3777	:  0000_0001  0x01    1    
  3778	:  0000_0000  0x00    0    
  3779	:  0000_0000  0x00    0    
  3780	:  0010_1010  0x2A   42  *  
  3781	:  0011_0000  0x30   48  0  
  3782	:  0000_0000  0x00    0    
  3783	:  0000_0100  0x04    4    
  3784	:  0010_1101  0x2D   45  -  
  3785	:  0100_0011  0x43   67  C  
  3786	:  0011_0010  0x32   50  2  
  3787	:  1000_1111  0x8F  143    
  3788	:  0000_1000  0x08    8    
  3789	:  0100_0001  0x41   65  A  
  3790	:  0010_1101  0x2D   45  -  
  3791	:  0011_0101  0x35   53  5  
  3792	:  0011_0000  0x30   48  0  
  3793	:  0010_1101  0x2D   45  -  
  3794	:  0011_0001  0x31   49  1  
  3795	:  0011_0100  0x34   52  4  
  3796	:  0011_0100  0x34   52  4  
  3797	:  1100_0000  0xC0  192    
  3798	:  0000_1100  0x0C   12    
  3799	:  0000_0000  0x00    0    
  3800	:  0000_0001  0x01    1    
  3801	:  0000_0000  0x00    0    
  3802	:  0000_0001  0x01    1    
  3803	:  0000_0000  0x00    0    
  3804	:  0000_0000  0x00    0    
  3805	:  0010_1010  0x2A   42  *  
  3806	:  0011_0000  0x30   48  0  
  3807	:  0000_0000  0x00    0    
  3808	:  0000_0100  0x04    4    
  3809	:  0010_1101  0x2D   45  -  
  3810	:  0100_0011  0x43   67  C  
  3811	:  0011_0010  0x32   50  2  
  3812	:  1001_0000  0x90  144    
  3813	:  0000_1000  0x08    8    
  3814	:  0100_0001  0x41   65  A  
  3815	:  0010_1101  0x2D   45  -  
  3816	:  0011_0101  0x35   53  5  
  3817	:  0011_0000  0x30   48  0  
  3818	:  0010_1101  0x2D   45  -  
  3819	:  0011_0001  0x31   49  1  
  3820	:  0011_0100  0x34   52  4  
  3821	:  0011_0101  0x35   53  5  
  3822	:  1100_0000  0xC0  192    
  3823	:  0000_1100  0x0C   12    
  3824	:  0000_0000  0x00    0    
  3825	:  0000_0001  0x01    1    
  3826	:  0000_0000  0x00    0    
  3827	:  0000_0001  0x01    1    
  3828	:  0000_0000  0x00    0    
  3829	:  0000_0000  0x00    0    
  3830	:  0010_1010  0x2A   42  *  
  3831	:  0011_0000  0x30   48  0  
  3832	:  0000_0000  0x00    0    
  3833	:  0000_0100  0x04    4    
  3834	:  0010_1101  0x2D   45  -  
  3835	:  0100_0011  0x43   67  C  
  3836	:  0011_0010  0x32   50  2  
  3837	:  1001_0001  0x91  145    
  3838	:  0000_1000  0x08    8    
  3839	:  0100_0001  0x41   65  A  
  3840	:  0010_1101  0x2D   45  -  
  3841	:  0011_0101  0x35   53  5  
  3842	:  0011_0000  0x30   48  0  
  3843	:  0010_1101  0x2D   45  -  
  3844	:  0011_0001  0x31   49  1  
  3845	:  0011_0100  0x34   52  4  
  3846	:  0011_0110  0x36   54  6  
  3847	:  1100_0000  0xC0  192    
  3848	:  0000_1100  0x0C   12    
  3849	:  0000_0000  0x00    0    
  3850	:  0000_0001  0x01    1    
  3851	:  0000_0000  0x00    0    
  3852	:  0000_0001  0x01    1    
  3853	:  0000_0000  0x00    0    
  3854	:  0000_0000  0x00    0    
  3855	:  0010_1010  0x2A   42  *  
  3856	:  0011_0000  0x30   48  0  
  3857	:  0000_0000  0x00    0    
  3858	:  0000_0100  0x04    4    
  3859	:  0010_1101  0x2D   45  -  
  3860	:  0100_0011  0x43   67  C  
  3861	:  0011_0010  0x32   50  2  
  3862	:  1001_0010  0x92  146    
  3863	:  0000_1000  0x08    8    
  3864	:  0100_0001  0x41   65  A  
  3865	:  0010_1101  0x2D   45  -  
  3866	:  0011_0101  0x35   53  5  
  3867	:  0011_0000  0x30   48  0  
  3868	:  0010_1101  0x2D   45  -  
  3869	:  0011_0001  0x31   49  1  
  3870	:  0011_0100  0x34   52  4  
  3871	:  0011_0111  0x37   55  7  
  3872	:  1100_0000  0xC0  192    
  3873	:  0000_1100  0x0C   12    
  3874	:  0000_0000  0x00    0    
  3875	:  0000_0001  0x01    1    
  3876	:  0000_0000  0x00    0    
  3877	:  0000_0001  0x01    1    
  3878	:  0000_0000  0x00    0    
  3879	:  0000_0000  0x00    0    
  3880	:  0010_1010  0x2A   42  *  
  3881	:  0011_0000  0x30   48  0  
  3882	:  0000_0000  0x00    0    
  3883	:  0000_0100  0x04    4    
  3884	:  0010_1101  0x2D   45  -  
  3885	:  0100_0011  0x43   67  C  
  3886	:  0011_0010  0x32   50  2  
  3887	:  1001_0011  0x93  147    
  3888	:  0000_1000  0x08    8    
  3889	:  0100_0001  0x41   65  A  
  3890	:  0010_1101  0x2D   45  -  
  3891	:  0011_0101  0x35   53  5  
  3892	:  0011_0000  0x30   48  0  
  3893	:  0010_1101  0x2D   45  -  
  3894	:  0011_0001  0x31   49  1  
  3895	:  0011_0100  0x34   52  4  
  3896	:  0011_1000  0x38   56  8  
  3897	:  1100_0000  0xC0  192    
  3898	:  0000_1100  0x0C   12    
  3899	:  0000_0000  0x00    0    
  3900	:  0000_0001  0x01    1    
  3901	:  0000_0000  0x00    0    
  3902	:  0000_0001  0x01    1    
  3903	:  0000_0000  0x00    0    
  3904	:  0000_0000  0x00    0    
  3905	:  0010_1010  0x2A   42  *  
  3906	:  0011_0000  0x30   48  0  
  3907	:  0000_0000  0x00    0    
  3908	:  0000_0100  0x04    4    
  3909	:  0010_1101  0x2D   45  -  
  3910	:  0100_0011  0x43   67  C  
  3911	:  0011_0010  0x32   50  2  
  3912	:  1001_0100  0x94  148    
  3913	:  0000_1000  0x08    8    
  3914	:  0100_0001  0x41   65  A  
  3915	:  0010_1101  0x2D   45  -  
  3916	:  0011_0101  0x35   53  5  
  3917	:  0011_0000  0x30   48  0  
  3918	:  0010_1101  0x2D   45  -  
  3919	:  0011_0001  0x31   49  1  
  3920	:  0011_0100  0x34   52  4  
  3921	:  0011_1001  0x39   57  9  
  3922	:  1100_0000  0xC0  192    
  3923	:  0000_1100  0x0C   12    
  3924	:  0000_0000  0x00    0    
  3925	:  0000_0001  0x01    1    
  3926	:  0000_0000  0x00    0    
  3927	:  0000_0001  0x01    1    
  3928	:  0000_0000  0x00    0    
  3929	:  0000_0000  0x00    0    
  3930	:  0010_1010  0x2A   42  *  
  3931	:  0011_0000  0x30   48  0  
  3932	:  0000_0000  0x00    0    
  3933	:  0000_0100  0x04    4    
  3934	:  0010_1101  0x2D   45  -  
  3935	:  0100_0011  0x43   67  C  
  3936	:  0011_0010  0x32   50  2  
  3937	:  1001_0101  0x95  149    
  3938	:  0000_1000  0x08    8    
  3939	:  0100_0001  0x41   65  A  
  3940	:  0010_1101  0x2D   45  -  
  3941	:  0011_0101  0x35   53  5  
  3942	:  0011_0000  0x30   48  0  
  3943	:  0010_1101  0x2D   45  -  
  3944	:  0011_0001  0x31   49  1  
  3945	:  0011_0101  0x35   53  5  
  3946	:  0011_0000  0x30   48  0  
  3947	:  1100_0000  0xC0  192    
  3948	:  0000_1100  0x0C   12    
  3949	:  0000_0000  0x00    0    
  3950	:  0000_0001  0x01    1    
  3951	:  0000_0000  0x00    0    
  3952	:  0000_0001  0x01    1    
  3953	:  0000_0000  0x00    0    
  3954	:  0000_0000  0x00    0    
  3955	:  0010_1010  0x2A   42  *  
  3956	:  0011_0000  0x30   48  0  
  3957	:  0000_0000  0x00    0    
  3958	:  0000_0100  0x04    4    
  3959	:  0010_1101  0x2D   45  -  
  3960	:  0100_0011  0x43   67  C  
  3961	:  0011_0010  0x32   50  2  
  3962	:  1001_0110  0x96  150    
  3963	:  0000_1000  0x08    8    
  3964	:  0100_0001  0x41   65  A  
  3965	:  0010_1101  0x2D   45  -  
  3966	:  0011_0101  0x35   53  5  
  3967	:  0011_0000  0x30   48  0  
  3968	:  0010_1101  0x2D   45  -  
  3969	:  0011_0001  0x31   49  1  
  3970	:  0011_0101  0x35   53  5  
  3971	:  0011_0001  0x31   49  1  
  3972	:  1100_0000  0xC0  192    
  3973	:  0000_1100  0x0C   12    
  3974	:  0000_0000  0x00    0    
  3975	:  0000_0001  0x01    1    
  3976	:  0000_0000  0x00    0    
  3977	:  0000_0001  0x01    1    
  3978	:  0000_0000  0x00    0    
  3979	:  0000_0000  0x00    0    
  3980	:  0010_1010  0x2A   42  *  
  3981	:  0011_0000  0x30   48  0  
  3982	:  0000_0000  0x00    0    
  3983	:  0000_0100  0x04    4    
  3984	:  0010_1101  0x2D   45  -  
  3985	:  0100_0011  0x43   67  C  
  3986	:  0011_0010  0x32   50  2  
  3987	:  1001_0111  0x97  151    
  3988	:  0000_1000  0x08    8    
  3989	:  0100_0001  0x41   65  A  
  3990	:  0010_1101  0x2D   45  -  
  3991	:  0011_0101  0x35   53  5  
  3992	:  0011_0000  0x30   48  0  
  3993	:  0010_1101  0x2D   45  -  
  3994	:  0011_0001  0x31   49  1  
  3995	:  0011_0101  0x35   53  5  
  3996	:  0011_0010  0x32   50  2  
  3997	:  1100_0000  0xC0  192    
  3998	:  0000_1100  0x0C   12    
  3999	:  0000_0000  0x00    0    
  4000	:  0000_0001  0x01    1    
  4001	:  0000_0000  0x00    0    
  4002	:  0000_0001  0x01    1    
  4003	:  0000_0000  0x00    0    
  4004	:  0000_0000  0x00    0    
  4005	:  0010_1010  0x2A   42  *  
  4006	:  0011_0000  0x30   48  0  
  4007	:  0000_0000  0x00    0    
  4008	:  0000_0100  0x04    4    
  4009	:  0010_1101  0x2D   45  -  
  4010	:  0100_0011  0x43   67  C  
  4011	:  0011_0010  0x32   50  2  
  4012	:  1001_1000  0x98  152    
  4013	:  0000_1000  0x08    8    
  4014	:  0100_0001  0x41   65  A  
  4015	:  0010_1101  0x2D   45  -  
  4016	:  0011_0101  0x35   53  5  
  4017	:  0011_0000  0x30   48  0  
  4018	:  0010_1101  0x2D   45  -  
  4019	:  0011_0001  0x31   49  1  
  4020	:  0011_0101  0x35   53  5  
  4021	:  0011_0011  0x33   51  3  
  4022	:  1100_0000  0xC0  192    
  4023	:  0000_1100  0x0C   12    
  4024	:  0000_0000  0x00    0    
  4025	:  0000_0001  0x01    1    
  4026	:  0000_0000  0x00    0    
  4027	:  0000_0001  0x01    1    
  4028	:  0000_0000  0x00    0    
  4029	:  0000_0000  0x00    0    
  4030	:  0010_1010  0x2A   42  *  
  4031	:  0011_0000  0x30   48  0  
  4032	:  0000_0000  0x00    0    
  4033	:  0000_0100  0x04    4    
  4034	:  0010_1101  0x2D   45  -  
  4035	:  0100_0011  0x43   67  C  
  4036	:  0011_0010  0x32   50  2  
  4037	:  1001_1001  0x99  153    
  4038	:  0000_1000  0x08    8    
  4039	:  0100_0001  0x41   65  A  
  4040	:  0010_1101  0x2D   45  -  
  4041	:  0011_0101  0x35   53  5  
  4042	:  0011_0000  0x30   48  0  
  4043	:  0010_1101  0x2D   45  -  
  4044	:  0011_0001  0x31   49  1  
  4045	:  0011_0101  0x35   53  5  
  4046	:  0011_0100  0x34   52  4  
  4047	:  1100_0000  0xC0  192    
  4048	:  0000_1100  0x0C   12    
  4049	:  0000_0000  0x00    0    
  4050	:  0000_0001  0x01    1    
  4051	:  0000_0000  0x00    0    
  4052	:  0000_0001  0x01    1    
  4053	:  0000_0000  0x00    0    
  4054	:  0000_0000  0x00    0    
  4055	:  0010_1010  0x2A   42  *  
  4056	:  0011_0000  0x30   48  0  
  4057	:  0000_0000  0x00    0    
  4058	:  0000_0100  0x04    4    
  4059	:  0010_1101  0x2D   45  -  
  4060	:  0100_0011  0x43   67  C  
  4061	:  0011_0010  0x32   50  2  
  4062	:  1001_1010  0x9A  154    
  4063	:  0000_1000  0x08    8    
  4064	:  0100_0001  0x41   65  A  
  4065	:  0010_1101  0x2D   45  -  
  4066	:  0011_0101  0x35   53  5  
  4067	:  0011_0000  0x30   48  0  
  4068	:  0010_1101  0x2D   45  -  
  4069	:  0011_0001  0x31   49  1  
  4070	:  0011_0101  0x35   53  5  
  4071	:  0011_0101  0x35   53  5  
  4072	:  1100_0000  0xC0  192    
  4073	:  0000_1100  0x0C   12    
  4074	:  0000_0000  0x00    0    
  4075	:  0000_0001  0x01    1    
  4076	:  0000_0000  0x00    0    
  4077	:  0000_0001  0x01    1    
  4078	:  0000_0000  0x00    0    
  4079	:  0000_0000  0x00    0    
  4080	:  0010_1010  0x2A   42  *  
  4081	:  0011_0000  0x30   48  0  
  4082	:  0000_0000  0x00    0    
  4083	:  0000_0100  0x04    4    
  4084	:  0010_1101  0x2D   45  -  
  4085	:  0100_0011  0x43   67  C  
  4086	:  0011_0010  0x32   50  2  
  4087	:  1001_1011  0x9B  155    
  4088	:  0000_1000  0x08    8    
  4089	:  0100_0001  0x41   65  A  
  4090	:  0010_1101  0x2D   45  -  
  4091	:  0011_0101  0x35   53  5  
  4092	:  0011_0000  0x30   48  0  
  4093	:  0010_1101  0x2D   45  -  
  4094	:  0011_0001  0x31   49  1  
  4095	:  0011_0101  0x35   53  5  
  4096	:  0011_0110  0x36   54  6  
  4097	:  1100_0000  0xC0  192    
  4098	:  0000_1100  0x0C   12    
  4099	:  0000_0000  0x00    0    
  4100	:  0000_0001  0x01    1    
  4101	:  0000_0000  0x00    0    
  4102	:  0000_0001  0x01    1    
  4103	:  0000_0000  0x00    0    
  4104	:  0000_0000  0x00    0    
  4105	:  0010_1010  0x2A   42  *  
  4106	:  0011_0000  0x30   48  0  
  4107	:  0000_0000  0x00    0    
  4108	:  0000_0100  0x04    4    
  4109	:  0010_1101  0x2D   45  -  
  4110	:  0100_0011  0x43   67  C  
  4111	:  0011_0010  0x32   50  2  
  4112	:  1001_1100  0x9C  156    
  4113	:  0000_1000  0x08    8    
  4114	:  0100_0001  0x41   65  A  
  4115	:  0010_1101  0x2D   45  -  
  4116	:  0011_0101  0x35   53  5  
  4117	:  0011_0000  0x30   48  0  
  4118	:  0010_1101  0x2D   45  -  
  4119	:  0011_0001  0x31   49  1  
  4120	:  0011_0101  0x35   53  5  
  4121	:  0011_0111  0x37   55  7  
  4122	:  1100_0000  0xC0  192    
  4123	:  0000_1100  0x0C   12    
  4124	:  0000_0000  0x00    0    
  4125	:  0000_0001  0x01    1    
  4126	:  0000_0000  0x00    0    
  4127	:  0000_0001  0x01    1    
  4128	:  0000_0000  0x00    0    
  4129	:  0000_0000  0x00    0    
  4130	:  0010_1010  0x2A   42  *  
  4131	:  0011_0000  0x30   48  0  
  4132	:  0000_0000  0x00    0    
  4133	:  0000_0100  0x04    4    
  4134	:  0010_1101  0x2D   45  -  
  4135	:  0100_0011  0x43   67  C  
  4136	:  0011_0010  0x32   50  2  
  4137	:  1001_1101  0x9D  157    
  4138	:  0000_1000  0x08    8    
  4139	:  0100_0001  0x41   65  A  
  4140	:  0010_1101  0x2D   45  -  
  4141	:  0011_0101  0x35   53  5  
  4142	:  0011_0000  0x30   48  0  
  4143	:  0010_1101  0x2D   45  -  
  4144	:  0011_0001  0x31   49  1  
  4145	:  0011_0101  0x35   53  5  
  4146	:  0011_1000  0x38   56  8  
  4147	:  1100_0000  0xC0  192    
  4148	:  0000_1100  0x0C   12    
  4149	:  0000_0000  0x00    0    
  4150	:  0000_0001  0x01    1    
  4151	:  0000_0000  0x00    0    
  4152	:  0000_0001  0x01    1    
  4153	:  0000_0000  0x00    0    
  4154	:  0000_0000  0x00    0    
  4155	:  0010_1010  0x2A   42  *  
  4156	:  0011_0000  0x30   48  0  
  4157	:  0000_0000  0x00    0    
  4158	:  0000_0100  0x04    4    
  4159	:  0010_1101  0x2D   45  -  
  4160	:  0100_0011  0x43   67  C  
  4161	:  0011_0010  0x32   50  2  
  4162	:  1001_1110  0x9E  158    
  4163	:  0000_1000  0x08    8    
  4164	:  0100_0001  0x41   65  A  
  4165	:  0010_1101  0x2D   45  -  
  4166	:  0011_0101  0x35   53  5  
  4167	:  0011_0000  0x30   48  0  
  4168	:  0010_1101  0x2D   45  -  
  4169	:  0011_0001  0x31   49  1  
  4170	:  0011_0101  0x35   53  5  
  4171	:  0011_1001  0x39   57  9  
  4172	:  1100_0000  0xC0  192    
  4173	:  0000_1100  0x0C   12    
  4174	:  0000_0000  0x00    0    
  4175	:  0000_0001  0x01    1    
  4176	:  0000_0000  0x00    0    
  4177	:  0000_0001  0x01    1    
  4178	:  0000_0000  0x00    0    
  4179	:  0000_0000  0x00    0    
  4180	:  0010_1010  0x2A   42  *  
  4181	:  0011_0000  0x30   48  0  
  4182	:  0000_0000  0x00    0    
  4183	:  0000_0100  0x04    4    
  4184	:  0010_1101  0x2D   45  -  
  4185	:  0100_0011  0x43   67  C  
  4186	:  0011_0010  0x32   50  2  
  4187	:  1001_1111  0x9F  159    
  4188	:  0000_1000  0x08    8    
  4189	:  0100_0001  0x41   65  A  
  4190	:  0010_1101  0x2D   45  -  
  4191	:  0011_0101  0x35   53  5  
  4192	:  0011_0000  0x30   48  0  
  4193	:  0010_1101  0x2D   45  -  
  4194	:  0011_0001  0x31   49  1  
  4195	:  0011_0110  0x36   54  6  
  4196	:  0011_0000  0x30   48  0  
  4197	:  1100_0000  0xC0  192    
  4198	:  0000_1100  0x0C   12    
  4199	:  0000_0000  0x00    0    
  4200	:  0000_0001  0x01    1    
  4201	:  0000_0000  0x00    0    
  4202	:  0000_0001  0x01    1    
  4203	:  0000_0000  0x00    0    
  4204	:  0000_0000  0x00    0    
  4205	:  0010_1010  0x2A   42  *  
  4206	:  0011_0000  0x30   48  0  
  4207	:  0000_0000  0x00    0    
  4208	:  0000_0100  0x04    4    
  4209	:  0010_1101  0x2D   45  -  
  4210	:  0100_0011  0x43   67  C  
  4211	:  0011_0010  0x32   50  2  
  4212	:  1010_0000  0xA0  160    
  4213	:  0000_1000  0x08    8    
  4214	:  0100_0001  0x41   65  A  
  4215	:  0010_1101  0x2D   45  -  
  4216	:  0011_0101  0x35   53  5  
  4217	:  0011_0000  0x30   48  0  
  4218	:  0010_1101  0x2D   45  -  
  4219	:  0011_0001  0x31   49  1  
  4220	:  0011_0110  0x36   54  6  
  4221	:  0011_0001  0x31   49  1  
  4222	:  1100_0000  0xC0  192    
  4223	:  0000_1100  0x0C   12    
  4224	:  0000_0000  0x00    0    
  4225	:  0000_0001  0x01    1    
  4226	:  0000_0000  0x00    0    
  4227	:  0000_0001  0x01    1    
  4228	:  0000_0000  0x00    0    
  4229	:  0000_0000  0x00    0    
  4230	:  0010_1010  0x2A   42  *  
  4231	:  0011_0000  0x30   48  0  
  4232	:  0000_0000  0x00    0    
  4233	:  0000_0100  0x04    4    
  4234	:  0010_1101  0x2D   45  -  
  4235	:  0100_0011  0x43   67  C  
  4236	:  0011_0010  0x32   50  2  
  4237	:  1010_0001  0xA1  161    
  4238	:  0000_1000  0x08    8    
  4239	:  0100_0001  0x41   65  A  
  4240	:  0010_1101  0x2D   45  -  
  4241	:  0011_0101  0x35   53  5  
  4242	:  0011_0000  0x30   48  0  
  4243	:  0010_1101  0x2D   45  -  
  4244	:  0011_0001  0x31   49  1  
  4245	:  0011_0110  0x36   54  6  
  4246	:  0011_0010  0x32   50  2  
  4247	:  1100_0000  0xC0  192    
  4248	:  0000_1100  0x0C   12    
  4249	:  0000_0000  0x00    0    
  4250	:  0000_0001  0x01    1    
  4251	:  0000_0000  0x00    0    
  4252	:  0000_0001  0x01    1    
  4253	:  0000_0000  0x00    0    
  4254	:  0000_0000  0x00    0    
  4255	:  0010_1010  0x2A   42  *  
  4256	:  0011_0000  0x30   48  0  
  4257	:  0000_0000  0x00    0    
  4258	:  0000_0100  0x04    4    
  4259	:  0010_1101  0x2D   45  -  
  4260	:  0100_0011  0x43   67  C  
  4261	:  0011_0010  0x32   50  2  
  4262	:  1010_0010  0xA2  162    
  4263	:  0000_1000  0x08    8    
  4264	:  0100_0001  0x41   65  A  
  4265	:  0010_1101  0x2D   45  -  
  4266	:  0011_0101  0x35   53  5  
  4267	:  0011_0000  0x30   48  0  
  4268	:  0010_1101  0x2D   45  -  
  4269	:  0011_0001  0x31   49  1  
  4270	:  0011_0110  0x36   54  6  
  4271	:  0011_0011  0x33   51  3  
  4272	:  1100_0000  0xC0  192    
  4273	:  0000_1100  0x0C   12    
  4274	:  0000_0000  0x00    0    
  4275	:  0000_0001  0x01    1    
  4276	:  0000_0000  0x00    0    
  4277	:  0000_0001  0x01    1    
  4278	:  0000_0000  0x00    0    
  4279	:  0000_0000  0x00    0    
  4280	:  0010_1010  0x2A   42  *  
  4281	:  0011_0000  0x30   48  0  
  4282	:  0000_0000  0x00    0    
  4283	:  0000_0100  0x04    4    
  4284	:  0010_1101  0x2D   45  -  
  4285	:  0100_0011  0x43   67  C  
  4286	:  0011_0010  0x32   50  2  
  4287	:  1010_0011  0xA3  163    
  4288	:  0000_1000  0x08    8    
  4289	:  0100_0001  0x41   65  A  
  4290	:  0010_1101  0x2D   45  -  
  4291	:  0011_0101  0x35   53  5  
  4292	:  0011_0000  0x30   48  0  
  4293	:  0010_1101  0x2D   45  -  
  4294	:  0011_0001  0x31   49  1  
  4295	:  0011_0110  0x36   54  6  
  4296	:  0011_0100  0x34   52  4  
  4297	:  1100_0000  0xC0  192    
  4298	:  0000_1100  0x0C   12    
  4299	:  0000_0000  0x00    0    
  4300	:  0000_0001  0x01    1    
  4301	:  0000_0000  0x00    0    
  4302	:  0000_0001  0x01    1    
  4303	:  0000_0000  0x00    0    
  4304	:  0000_0000  0x00    0    
  4305	:  0010_1010  0x2A   42  *  
  4306	:  0011_0000  0x30   48  0  
  4307	:  0000_0000  0x00    0    
  4308	:  0000_0100  0x04    4    
  4309	:  0010_1101  0x2D   45  -  
  4310	:  0100_0011  0x43   67  C  
  4311	:  0011_0010  0x32   50  2  
  4312	:  1010_0100  0xA4  164    
  4313	:  0000_1000  0x08    8    
  4314	:  0100_0001  0x41   65  A  
  4315	:  0010_1101  0x2D   45  -  
  4316	:  0011_0101  0x35   53  5  
  4317	:  0011_0000  0x30   48  0  
  4318	:  0010_1101  0x2D   45  -  
  4319	:  0011_0001  0x31   49  1  
  4320	:  0011_0110  0x36   54  6  
  4321	:  0011_0101  0x35   53  5  
  4322	:  1100_0000  0xC0  192    
  4323	:  0000_1100  0x0C   12    
  4324	:  0000_0000  0x00    0    
  4325	:  0000_0001  0x01    1    
  4326	:  0000_0000  0x00    0    
  4327	:  0000_0001  0x01    1    
  4328	:  0000_0000  0x00    0    
  4329	:  0000_0000  0x00    0    
  4330	:  0010_1010  0x2A   42  *  
  4331	:  0011_0000  0x30   48  0  
  4332	:  0000_0000  0x00    0    
  4333	:  0000_0100  0x04    4    
  4334	:  0010_1101  0x2D   45  -  
  4335	:  0100_0011  0x43   67  C  
  4336	:  0011_0010  0x32   50  2  
  4337	:  1010_0101  0xA5  165    
  4338	:  0000_1000  0x08    8    
  4339	:  0100_0001  0x41   65  A  
  4340	:  0010_1101  0x2D   45  -  
  4341	:  0011_0101  0x35   53  5  
  4342	:  0011_0000  0x30   48  0  
  4343	:  0010_1101  0x2D   45  -  
  4344	:  0011_0001  0x31   49  1  
  4345	:  0011_0110  0x36   54  6  
  4346	:  0011_0110  0x36   54  6  
  4347	:  1100_0000  0xC0  192    
  4348	:  0000_1100  0x0C   12    
  4349	:  0000_0000  0x00    0    
  4350	:  0000_0001  0x01    1    
  4351	:  0000_0000  0x00    0    
  4352	:  0000_0001  0x01    1    
  4353	:  0000_0000  0x00    0    
  4354	:  0000_0000  0x00    0    
  4355	:  0010_1010  0x2A   42  *  
  4356	:  0011_0000  0x30   48  0  
  4357	:  0000_0000  0x00    0    
  4358	:  0000_0100  0x04    4    
  4359	:  0010_1101  0x2D   45  -  
  4360	:  0100_0011  0x43   67  C  
  4361	:  0011_0010  0x32   50  2  
  4362	:  1010_0110  0xA6  166    
  4363	:  0000_1000  0x08    8    
  4364	:  0100_0001  0x41   65  A  
  4365	:  0010_1101  0x2D   45  -  
  4366	:  0011_0101  0x35   53  5  
  4367	:  0011_0000  0x30   48  0  
  4368	:  0010_1101  0x2D   45  -  
  4369	:  0011_0001  0x31   49  1  
  4370	:  0011_0110  0x36   54  6  
  4371	:  0011_0111  0x37   55  7  
  4372	:  1100_0000  0xC0  192    
  4373	:  0000_1100  0x0C   12    
  4374	:  0000_0000  0x00    0    
  4375	:  0000_0001  0x01    1    
  4376	:  0000_0000  0x00    0    
  4377	:  0000_0001  0x01    1    
  4378	:  0000_0000  0x00    0    
  4379	:  0000_0000  0x00    0    
  4380	:  0010_1010  0x2A   42  *  
  4381	:  0011_0000  0x30   48  0  
  4382	:  0000_0000  0x00    0    
  4383	:  0000_0100  0x04    4    
  4384	:  0010_1101  0x2D   45  -  
  4385	:  0100_0011  0x43   67  C  
  4386	:  0011_0010  0x32   50  2  
  4387	:  1010_0111  0xA7  167    
  4388	:  0000_1000  0x08    8    
  4389	:  0100_0001  0x41   65  A  
  4390	:  0010_1101  0x2D   45  -  
  4391	:  0011_0101  0x35   53  5  
  4392	:  0011_0000  0x30   48  0  
  4393	:  0010_1101  0x2D   45  -  
  4394	:  0011_0001  0x31   49  1  
  4395	:  0011_0110  0x36   54  6  
  4396	:  0011_1000  0x38   56  8  
  4397	:  1100_0000  0xC0  192    
  4398	:  0000_1100  0x0C   12    
  4399	:  0000_0000  0x00    0    
  4400	:  0000_0001  0x01    1    
  4401	:  0000_0000  0x00    0    
  4402	:  0000_0001  0x01    1    
  4403	:  0000_0000  0x00    0    
  4404	:  0000_0000  0x00    0    
  4405	:  0010_1010  0x2A   42  *  
  4406	:  0011_0000  0x30   48  0  
  4407	:  0000_0000  0x00    0    
  4408	:  0000_0100  0x04    4    
  4409	:  0010_1101  0x2D   45  -  
  4410	:  0100_0011  0x43   67  C  
  4411	:  0011_0010  0x32   50  2  
  4412	:  1010_1000  0xA8  168    
  4413	:  0000_1000  0x08    8    
  4414	:  0100_0001  0x41   65  A  
  4415	:  0010_1101  0x2D   45  -  
  4416	:  0011_0101  0x35   53  5  
  4417	:  0011_0000  0x30   48  0  
  4418	:  0010_1101  0x2D   45  -  
  4419	:  0011_0001  0x31   49  1  
  4420	:  0011_0110  0x36   54  6  
  4421	:  0011_1001  0x39   57  9  
  4422	:  1100_0000  0xC0  192    
  4423	:  0000_1100  0x0C   12    
  4424	:  0000_0000  0x00    0    
  4425	:  0000_0001  0x01    1    
  4426	:  0000_0000  0x00    0    
  4427	:  0000_0001  0x01    1    
  4428	:  0000_0000  0x00    0    
  4429	:  0000_0000  0x00    0    
  4430	:  0010_1010  0x2A   42  *  
  4431	:  0011_0000  0x30   48  0  
  4432	:  0000_0000  0x00    0    
  4433	:  0000_0100  0x04    4    
  4434	:  0010_1101  0x2D   45  -  
  4435	:  0100_0011  0x43   67  C  
  4436	:  0011_0010  0x32   50  2  
  4437	:  1010_1001  0xA9  169    
  4438	:  0000_1000  0x08    8    
  4439	:  0100_0001  0x41   65  A  
  4440	:  0010_1101  0x2D   45  -  
  4441	:  0011_0101  0x35   53  5  
  4442	:  0011_0000  0x30   48  0  
  4443	:  0010_1101  0x2D   45  -  
  4444	:  0011_0001  0x31   49  1  
  4445	:  0011_0111  0x37   55  7  
  4446	:  0011_0000  0x30   48  0  
  4447	:  1100_0000  0xC0  192    
  4448	:  0000_1100  0x0C   12    
  4449	:  0000_0000  0x00    0    
  4450	:  0000_0001  0x01    1    
  4451	:  0000_0000  0x00    0    
  4452	:  0000_0001  0x01    1    
  4453	:  0000_0000  0x00    0    
  4454	:  0000_0000  0x00    0    
  4455	:  0010_1010  0x2A   42  *  
  4456	:  0011_0000  0x30   48  0  
  4457	:  0000_0000  0x00    0    
  4458	:  0000_0100  0x04    4    
  4459	:  0010_1101  0x2D   45  -  
  4460	:  0100_0011  0x43   67  C  
  4461	:  0011_0010  0x32   50  2  
  4462	:  1010_1010  0xAA  170    
  4463	:  0000_1000  0x08    8    
  4464	:  0100_0001  0x41   65  A  
  4465	:  0010_1101  0x2D   45  -  
  4466	:  0011_0101  0x35   53  5  
  4467	:  0011_0000  0x30   48  0  
  4468	:  0010_1101  0x2D   45  -  
  4469	:  0011_0001  0x31   49  1  
  4470	:  0011_0111  0x37   55  7  
  4471	:  0011_0001  0x31   49  1  
  4472	:  1100_0000  0xC0  192    
  4473	:  0000_1100  0x0C   12    
  4474	:  0000_0000  0x00    0    
  4475	:  0000_0001  0x01    1    
  4476	:  0000_0000  0x00    0    
  4477	:  0000_0001  0x01    1    
  4478	:  0000_0000  0x00    0    
  4479	:  0000_0000  0x00    0    
  4480	:  0010_1010  0x2A   42  *  
  4481	:  0011_0000  0x30   48  0  
  4482	:  0000_0000  0x00    0    
  4483	:  0000_0100  0x04    4    
  4484	:  0010_1101  0x2D   45  -  
  4485	:  0100_0011  0x43   67  C  
  4486	:  0011_0010  0x32   50  2  
  4487	:  1010_1011  0xAB  171    
  4488	:  0000_1000  0x08    8    
  4489	:  0100_0001  0x41   65  A  
  4490	:  0010_1101  0x2D   45  -  
  4491	:  0011_0101  0x35   53  5  
  4492	:  0011_0000  0x30   48  0  
  4493	:  0010_1101  0x2D   45  -  
  4494	:  0011_0001  0x31   49  1  
  4495	:  0011_0111  0x37   55  7  
  4496	:  0011_0010  0x32   50  2  
  4497	:  1100_0000  0xC0  192    
  4498	:  0000_1100  0x0C   12    
  4499	:  0000_0000  0x00    0    
  4500	:  0000_0001  0x01    1    
  4501	:  0000_0000  0x00    0    
  4502	:  0000_0001  0x01    1    
  4503	:  0000_0000  0x00    0    
  4504	:  0000_0000  0x00    0    
  4505	:  0010_1010  0x2A   42  *  
  4506	:  0011_0000  0x30   48  0  
  4507	:  0000_0000  0x00    0    
  4508	:  0000_0100  0x04    4    
  4509	:  0010_1101  0x2D   45  -  
  4510	:  0100_0011  0x43   67  C  
  4511	:  0011_0010  0x32   50  2  
  4512	:  1010_1100  0xAC  172    
  4513	:  0000_1000  0x08    8    
  4514	:  0100_0001  0x41   65  A  
  4515	:  0010_1101  0x2D   45  -  
  4516	:  0011_0101  0x35   53  5  
  4517	:  0011_0000  0x30   48  0  
  4518	:  0010_1101  0x2D   45  -  
  4519	:  0011_0001  0x31   49  1  
  4520	:  0011_0111  0x37   55  7  
  4521	:  0011_0011  0x33   51  3  
  4522	:  1100_0000  0xC0  192    
  4523	:  0000_1100  0x0C   12    
  4524	:  0000_0000  0x00    0    
  4525	:  0000_0001  0x01    1    
  4526	:  0000_0000  0x00    0    
  4527	:  0000_0001  0x01    1    
  4528	:  0000_0000  0x00    0    
  4529	:  0000_0000  0x00    0    
  4530	:  0010_1010  0x2A   42  *  
  4531	:  0011_0000  0x30   48  0  
  4532	:  0000_0000  0x00    0    
  4533	:  0000_0100  0x04    4    
  4534	:  0010_1101  0x2D   45  -  
  4535	:  0100_0011  0x43   67  C  
  4536	:  0011_0010  0x32   50  2  
  4537	:  1010_1101  0xAD  173    
  4538	:  0000_1000  0x08    8    
  4539	:  0100_0001  0x41   65  A  
  4540	:  0010_1101  0x2D   45  -  
  4541	:  0011_0101  0x35   53  5  
  4542	:  0011_0000  0x30   48  0  
  4543	:  0010_1101  0x2D   45  -  
  4544	:  0011_0001  0x31   49  1  
  4545	:  0011_0111  0x37   55  7  
  4546	:  0011_0100  0x34   52  4  
  4547	:  1100_0000  0xC0  192    
  4548	:  0000_1100  0x0C   12    
  4549	:  0000_0000  0x00    0    
  4550	:  0000_0001  0x01    1    
  4551	:  0000_0000  0x00    0    
  4552	:  0000_0001  0x01    1    
  4553	:  0000_0000  0x00    0    
  4554	:  0000_0000  0x00    0    
  4555	:  0010_1010  0x2A   42  *  
  4556	:  0011_0000  0x30   48  0  
  4557	:  0000_0000  0x00    0    
  4558	:  0000_0100  0x04    4    
  4559	:  0010_1101  0x2D   45  -  
  4560	:  0100_0011  0x43   67  C  
  4561	:  0011_0010  0x32   50  2  
  4562	:  1010_1110  0xAE  174    
  4563	:  0000_1000  0x08    8    
  4564	:  0100_0001  0x41   65  A  
  4565	:  0010_1101  0x2D   45  -  
  4566	:  0011_0101  0x35   53  5  
  4567	:  0011_0000  0x30   48  0  
  4568	:  0010_1101  0x2D   45  -  
  4569	:  0011_0001  0x31   49  1  
  4570	:  0011_0111  0x37   55  7  
  4571	:  0011_0101  0x35   53  5  
  4572	:  1100_0000  0xC0  192    
  4573	:  0000_1100  0x0C   12    
  4574	:  0000_0000  0x00    0    
  4575	:  0000_0001  0x01    1    
  4576	:  0000_0000  0x00    0    
  4577	:  0000_0001  0x01    1    
  4578	:  0000_0000  0x00    0    
  4579	:  0000_0000  0x00    0    
  4580	:  0010_1010  0x2A   42  *  
  4581	:  0011_0000  0x30   48  0  
  4582	:  0000_0000  0x00    0    
  4583	:  0000_0100  0x04    4    
  4584	:  0010_1101  0x2D   45  -  
  4585	:  0100_0011  0x43   67  C  
  4586	:  0011_0010  0x32   50  2  
  4587	:  1010_1111  0xAF  175    
  4588	:  0000_1000  0x08    8    
  4589	:  0100_0001  0x41   65  A  
  4590	:  0010_1101  0x2D   45  -  
  4591	:  0011_0101  0x35   53  5  
  4592	:  0011_0000  0x30   48  0  
  4593	:  0010_1101  0x2D   45  -  
  4594	:  0011_0001  0x31   49  1  
  4595	:  0011_0111  0x37   55  7  
  4596	:  0011_0110  0x36   54  6  
  4597	:  1100_0000  0xC0  192    
  4598	:  0000_1100  0x0C   12    
  4599	:  0000_0000  0x00    0    
  4600	:  0000_0001  0x01    1    
  4601	:  0000_0000  0x00    0    
  4602	:  0000_0001  0x01    1    
  4603	:  0000_0000  0x00    0    
  4604	:  0000_0000  0x00    0    
  4605	:  0010_1010  0x2A   42  *  
  4606	:  0011_0000  0x30   48  0  
  4607	:  0000_0000  0x00    0    
  4608	:  0000_0100  0x04    4    
  4609	:  0010_1101  0x2D   45  -  
  4610	:  0100_0011  0x43   67  C  
  4611	:  0011_0010  0x32   50  2  
  4612	:  1011_0000  0xB0  176    
  4613	:  0000_1000  0x08    8    
  4614	:  0100_0001  0x41   65  A  
  4615	:  0010_1101  0x2D   45  -  
  4616	:  0011_0101  0x35   53  5  
  4617	:  0011_0000  0x30   48  0  
  4618	:  0010_1101  0x2D   45  -  
  4619	:  0011_0001  0x31   49  1  
  4620	:  0011_0111  0x37   55  7  
  4621	:  0011_0111  0x37   55  7  
  4622	:  1100_0000  0xC0  192    
  4623	:  0000_1100  0x0C   12    
  4624	:  0000_0000  0x00    0    
  4625	:  0000_0001  0x01    1    
  4626	:  0000_0000  0x00    0    
  4627	:  0000_0001  0x01    1    
  4628	:  0000_0000  0x00    0    
  4629	:  0000_0000  0x00    0    
  4630	:  0010_1010  0x2A   42  *  
  4631	:  0011_0000  0x30   48  0  
  4632	:  0000_0000  0x00    0    
  4633	:  0000_0100  0x04    4    
  4634	:  0010_1101  0x2D   45  -  
  4635	:  0100_0011  0x43   67  C  
  4636	:  0011_0010  0x32   50  2  
  4637	:  1011_0001  0xB1  177    
  4638	:  0000_1000  0x08    8    
  4639	:  0100_0001  0x41   65  A  
  4640	:  0010_1101  0x2D   45  -  
  4641	:  0011_0101  0x35   53  5  
  4642	:  0011_0000  0x30   48  0  
  4643	:  0010_1101  0x2D   45  -  
  4644	:  0011_0001  0x31   49  1  
  4645	:  0011_0111  0x37   55  7  
  4646	:  0011_1000  0x38   56  8  
  4647	:  1100_0000  0xC0  192    
  4648	:  0000_1100  0x0C   12    
  4649	:  0000_0000  0x00    0    
  4650	:  0000_0001  0x01    1    
  4651	:  0000_0000  0x00    0    
  4652	:  0000_0001  0x01    1    
  4653	:  0000_0000  0x00    0    
  4654	:  0000_0000  0x00    0    
  4655	:  0010_1010  0x2A   42  *  
  4656	:  0011_0000  0x30   48  0  
  4657	:  0000_0000  0x00    0    
  4658	:  0000_0100  0x04    4    
  4659	:  0010_1101  0x2D   45  -  
  4660	:  0100_0011  0x43   67  C  
  4661	:  0011_0010  0x32   50  2  
  4662	:  1011_0010  0xB2  178    
  4663	:  0000_1000  0x08    8    
  4664	:  0100_0001  0x41   65  A  
  4665	:  0010_1101  0x2D   45  -  
  4666	:  0011_0101  0x35   53  5  
  4667	:  0011_0000  0x30   48  0  
  4668	:  0010_1101  0x2D   45  -  
  4669	:  0011_0001  0x31   49  1  
  4670	:  0011_0111  0x37   55  7  
  4671	:  0011_1001  0x39   57  9  
  4672	:  1100_0000  0xC0  192    
  4673	:  0000_1100  0x0C   12    
  4674	:  0000_0000  0x00    0    
  4675	:  0000_0001  0x01    1    
  4676	:  0000_0000  0x00    0    
  4677	:  0000_0001  0x01    1    
  4678	:  0000_0000  0x00    0    
  4679	:  0000_0000  0x00    0    
  4680	:  0010_1010  0x2A   42  *  
  4681	:  0011_0000  0x30   48  0  
  4682	:  0000_0000  0x00    0    
  4683	:  0000_0100  0x04    4    
  4684	:  0010_1101  0x2D   45  -  
  4685	:  0100_0011  0x43   67  C  
  4686	:  0011_0010  0x32   50  2  
  4687	:  1011_0011  0xB3  179    
  4688	:  0000_1000  0x08    8    
  4689	:  0100_0001  0x41   65  A  
  4690	:  0010_1101  0x2D   45  -  
  4691	:  0011_0101  0x35   53  5  
  4692	:  0011_0000  0x30   48  0  
  4693	:  0010_1101  0x2D   45  -  
  4694	:  0011_0001  0x31   49  1  
  4695	:  0011_1000  0x38   56  8  
  4696	:  0011_0000  0x30   48  0  
  4697	:  1100_0000  0xC0  192    
  4698	:  0000_1100  0x0C   12    
  4699	:  0000_0000  0x00    0    
  4700	:  0000_0001  0x01    1    
  4701	:  0000_0000  0x00    0    
  4702	:  0000_0001  0x01    1    
  4703	:  0000_0000  0x00    0    
  4704	:  0000_0000  0x00    0    
  4705	:  0010_1010  0x2A   42  *  
  4706	:  0011_0000  0x30   48  0  
  4707	:  0000_0000  0x00    0    
  4708	:  0000_0100  0x04    4    
  4709	:  0010_1101  0x2D   45  -  
  4710	:  0100_0011  0x43   67  C  
  4711	:  0011_0010  0x32   50  2  
  4712	:  1011_0100  0xB4  180    
  4713	:  0000_1000  0x08    8    
  4714	:  0100_0001  0x41   65  A  
  4715	:  0010_1101  0x2D   45  -  
  4716	:  0011_0101  0x35   53  5  
  4717	:  0011_0000  0x30   48  0  
  4718	:  0010_1101  0x2D   45  -  
  4719	:  0011_0001  0x31   49  1  
  4720	:  0011_1000  0x38   56  8  
  4721	:  0011_0001  0x31   49  1  
  4722	:  1100_0000  0xC0  192    
  4723	:  0000_1100  0x0C   12    
  4724	:  0000_0000  0x00    0    
  4725	:  0000_0001  0x01    1    
  4726	:  0000_0000  0x00    0    
  4727	:  0000_0001  0x01    1    
  4728	:  0000_0000  0x00    0    
  4729	:  0000_0000  0x00    0    
  4730	:  0010_1010  0x2A   42  *  
  4731	:  0011_0000  0x30   48  0  
  4732	:  0000_0000  0x00    0    
  4733	:  0000_0100  0x04    4    
  4734	:  0010_1101  0x2D   45  -  
  4735	:  0100_0011  0x43   67  C  
  4736	:  0011_0010  0x32   50  2  
  4737	:  1011_0101  0xB5  181    
  4738	:  0000_1000  0x08    8    
  4739	:  0100_0001  0x41   65  A  
  4740	:  0010_1101  0x2D   45  -  
  4741	:  0011_0101  0x35   53  5  
  4742	:  0011_0000  0x30   48  0  
  4743	:  0010_1101  0x2D   45  -  
  4744	:  0011_0001  0x31   49  1  
  4745	:  0011_1000  0x38   56  8  
  4746	:  0011_0010  0x32   50  2  
  4747	:  1100_0000  0xC0  192    
  4748	:  0000_1100  0x0C   12    
  4749	:  0000_0000  0x00    0    
  4750	:  0000_0001  0x01    1    
  4751	:  0000_0000  0x00    0    
  4752	:  0000_0001  0x01    1    
  4753	:  0000_0000  0x00    0    
  4754	:  0000_0000  0x00    0    
  4755	:  0010_1010  0x2A   42  *  
  4756	:  0011_0000  0x30   48  0  
  4757	:  0000_0000  0x00    0    
  4758	:  0000_0100  0x04    4    
  4759	:  0010_1101  0x2D   45  -  
  4760	:  0100_0011  0x43   67  C  
  4761	:  0011_0010  0x32   50  2  
  4762	:  1011_0110  0xB6  182    
  4763	:  0000_1000  0x08    8    
  4764	:  0100_0001  0x41   65  A  
  4765	:  0010_1101  0x2D   45  -  
  4766	:  0011_0101  0x35   53  5  
  4767	:  0011_0000  0x30   48  0  
  4768	:  0010_1101  0x2D   45  -  
  4769	:  0011_0001  0x31   49  1  
  4770	:  0011_1000  0x38   56  8  
  4771	:  0011_0011  0x33   51  3  
  4772	:  1100_0000  0xC0  192    
  4773	:  0000_1100  0x0C   12    
  4774	:  0000_0000  0x00    0    
  4775	:  0000_0001  0x01    1    
  4776	:  0000_0000  0x00    0    
  4777	:  0000_0001  0x01    1    
  4778	:  0000_0000  0x00    0    
  4779	:  0000_0000  0x00    0    
  4780	:  0010_1010  0x2A   42  *  
  4781	:  0011_0000  0x30   48  0  
  4782	:  0000_0000  0x00    0    
  4783	:  0000_0100  0x04    4    
  4784	:  0010_1101  0x2D   45  -  
  4785	:  0100_0011  0x43   67  C  
  4786	:  0011_0010  0x32   50  2  
  4787	:  1011_0111  0xB7  183    
  4788	:  0000_1000  0x08    8    
  4789	:  0100_0001  0x41   65  A  
  4790	:  0010_1101  0x2D   45  -  
  4791	:  0011_0101  0x35   53  5  
  4792	:  0011_0000  0x30   48  0  
  4793	:  0010_1101  0x2D   45  -  
  4794	:  0011_0001  0x31   49  1  
  4795	:  0011_1000  0x38   56  8  
  4796	:  0011_0100  0x34   52  4  
  4797	:  1100_0000  0xC0  192    
  4798	:  0000_1100  0x0C   12    
  4799	:  0000_0000  0x00    0    
  4800	:  0000_0001  0x01    1    
  4801	:  0000_0000  0x00    0    
  4802	:  0000_0001  0x01    1    
  4803	:  0000_0000  0x00    0    
  4804	:  0000_0000  0x00    0    
  4805	:  0010_1010  0x2A   42  *  
  4806	:  0011_0000  0x30   48  0  
  4807	:  0000_0000  0x00    0    
  4808	:  0000_0100  0x04    4    
  4809	:  0010_1101  0x2D   45  -  
  4810	:  0100_0011  0x43   67  C  
  4811	:  0011_0010  0x32   50  2  
  4812	:  1011_1000  0xB8  184    
  4813	:  0000_1000  0x08    8    
  4814	:  0100_0001  0x41   65  A  
  4815	:  0010_1101  0x2D   45  -  
  4816	:  0011_0101  0x35   53  5  
  4817	:  0011_0000  0x30   48  0  
  4818	:  0010_1101  0x2D   45  -  
  4819	:  0011_0001  0x31   49  1  
  4820	:  0011_1000  0x38   56  8  
  4821	:  0011_0101  0x35   53  5  
  4822	:  1100_0000  0xC0  192    
  4823	:  0000_1100  0x0C   12    
  4824	:  0000_0000  0x00    0    
  4825	:  0000_0001  0x01    1    
  4826	:  0000_0000  0x00    0    
  4827	:  0000_0001  0x01    1    
  4828	:  0000_0000  0x00    0    
  4829	:  0000_0000  0x00    0    
  4830	:  0010_1010  0x2A   42  *  
  4831	:  0011_0000  0x30   48  0  
  4832	:  0000_0000  0x00    0    
  4833	:  0000_0100  0x04    4    
  4834	:  0010_1101  0x2D   45  -  
  4835	:  0100_0011  0x43   67  C  
  4836	:  0011_0010  0x32   50  2  
  4837	:  1011_1001  0xB9  185    
  4838	:  0000_1000  0x08    8    
  4839	:  0100_0001  0x41   65  A  
  4840	:  0010_1101  0x2D   45  -  
  4841	:  0011_0101  0x35   53  5  
  4842	:  0011_0000  0x30   48  0  
  4843	:  0010_1101  0x2D   45  -  
  4844	:  0011_0001  0x31   49  1  
  4845	:  0011_1000  0x38   56  8  
  4846	:  0011_0110  0x36   54  6  
  4847	:  1100_0000  0xC0  192    
  4848	:  0000_1100  0x0C   12    
  4849	:  0000_0000  0x00    0    
  4850	:  0000_0001  0x01    1    
  4851	:  0000_0000  0x00    0    
  4852	:  0000_0001  0x01    1    
  4853	:  0000_0000  0x00    0    
  4854	:  0000_0000  0x00    0    
  4855	:  0010_1010  0x2A   42  *  
  4856	:  0011_0000  0x30   48  0  
  4857	:  0000_0000  0x00    0    
  4858	:  0000_0100  0x04    4    
  4859	:  0010_1101  0x2D   45  -  
  4860	:  0100_0011  0x43   67  C  
  4861	:  0011_0010  0x32   50  2  
  4862	:  1011_1010  0xBA  186    
  4863	:  0000_1000  0x08    8    
  4864	:  0100_0001  0x41   65  A  
  4865	:  0010_1101  0x2D   45  -  
  4866	:  0011_0101  0x35   53  5  
  4867	:  0011_0000  0x30   48  0  
  4868	:  0010_1101  0x2D   45  -  
  4869	:  0011_0001  0x31   49  1  
  4870	:  0011_1000  0x38   56  8  
  4871	:  0011_0111  0x37   55  7  
  4872	:  1100_0000  0xC0  192    
  4873	:  0000_1100  0x0C   12    
  4874	:  0000_0000  0x00    0    
  4875	:  0000_0001  0x01    1    
  4876	:  0000_0000  0x00    0    
  4877	:  0000_0001  0x01    1    
  4878	:  0000_0000  0x00    0    
  4879	:  0000_0000  0x00    0    
  4880	:  0010_1010  0x2A   42  *  
  4881	:  0011_0000  0x30   48  0  
  4882	:  0000_0000  0x00    0    
  4883	:  0000_0100  0x04    4    
  4884	:  0010_1101  0x2D   45  -  
  4885	:  0100_0011  0x43   67  C  
  4886	:  0011_0010  0x32   50  2  
  4887	:  1011_1011  0xBB  187    
  4888	:  0000_1000  0x08    8    
  4889	:  0100_0001  0x41   65  A  
  4890	:  0010_1101  0x2D   45  -  
  4891	:  0011_0101  0x35   53  5  
  4892	:  0011_0000  0x30   48  0  
  4893	:  0010_1101  0x2D   45  -  
  4894	:  0011_0001  0x31   49  1  
  4895	:  0011_1000  0x38   56  8  
  4896	:  0011_1000  0x38   56  8  
  4897	:  1100_0000  0xC0  192    
  4898	:  0000_1100  0x0C   12    
  4899	:  0000_0000  0x00    0    
  4900	:  0000_0001  0x01    1    
  4901	:  0000_0000  0x00    0    
  4902	:  0000_0001  0x01    1    
  4903	:  0000_0000  0x00    0    
  4904	:  0000_0000  0x00    0    
  4905	:  0010_1010  0x2A   42  *  
  4906	:  0011_0000  0x30   48  0  
  4907	:  0000_0000  0x00    0    
  4908	:  0000_0100  0x04    4    
  4909	:  0010_1101  0x2D   45  -  
  4910	:  0100_0011  0x43   67  C  
  4911	:  0011_0010  0x32   50  2  
  4912	:  1011_1100  0xBC  188    
  4913	:  0000_1000  0x08    8    
  4914	:  0100_0001  0x41   65  A  
  4915	:  0010_1101  0x2D   45  -  
  4916	:  0011_0101  0x35   53  5  
  4917	:  0011_0000  0x30   48  0  
  4918	:  0010_1101  0x2D   45  -  
  4919	:  0011_0001  0x31   49  1  
  4920	:  0011_1000  0x38   56  8  
  4921	:  0011_1001  0x39   57  9  
  4922	:  1100_0000  0xC0  192    
  4923	:  0000_1100  0x0C   12    
  4924	:  0000_0000  0x00    0    
  4925	:  0000_0001  0x01    1    
  4926	:  0000_0000  0x00    0    
  4927	:  0000_0001  0x01    1    
  4928	:  0000_0000  0x00    0    
  4929	:  0000_0000  0x00    0    
  4930	:  0010_1010  0x2A   42  *  
  4931	:  0011_0000  0x30   48  0  
  4932	:  0000_0000  0x00    0    
  4933	:  0000_0100  0x04    4    
  4934	:  0010_1101  0x2D   45  -  
  4935	:  0100_0011  0x43   67  C  
  4936	:  0011_0010  0x32   50  2  
  4937	:  1011_1101  0xBD  189    
  4938	:  0000_1000  0x08    8    
  4939	:  0100_0001  0x41   65  A  
  4940	:  0010_1101  0x2D   45  -  
  4941	:  0011_0101  0x35   53  5  
  4942	:  0011_0000  0x30   48  0  
  4943	:  0010_1101  0x2D   45  -  
  4944	:  0011_0001  0x31   49  1  
  4945	:  0011_1001  0x39   57  9  
  4946	:  0011_0000  0x30   48  0  
  4947	:  1100_0000  0xC0  192    
  4948	:  0000_1100  0x0C   12    
  4949	:  0000_0000  0x00    0    
  4950	:  0000_0001  0x01    1    
  4951	:  0000_0000  0x00    0    
  4952	:  0000_0001  0x01    1    
  4953	:  0000_0000  0x00    0    
  4954	:  0000_0000  0x00    0    
  4955	:  0010_1010  0x2A   42  *  
  4956	:  0011_0000  0x30   48  0  
  4957	:  0000_0000  0x00    0    
  4958	:  0000_0100  0x04    4    
  4959	:  0010_1101  0x2D   45  -  
  4960	:  0100_0011  0x43   67  C  
  4961	:  0011_0010  0x32   50  2  
  4962	:  1011_1110  0xBE  190    
  4963	:  0000_1000  0x08    8    
  4964	:  0100_0001  0x41   65  A  
  4965	:  0010_1101  0x2D   45  -  
  4966	:  0011_0101  0x35   53  5  
  4967	:  0011_0000  0x30   48  0  
  4968	:  0010_1101  0x2D   45  -  
  4969	:  0011_0001  0x31   49  1  
  4970	:  0011_1001  0x39   57  9  
  4971	:  0011_0001  0x31   49  1  
  4972	:  1100_0000  0xC0  192    
  4973	:  0000_1100  0x0C   12    
  4974	:  0000_0000  0x00    0    
  4975	:  0000_0001  0x01    1    
  4976	:  0000_0000  0x00    0    
  4977	:  0000_0001  0x01    1    
  4978	:  0000_0000  0x00    0    
  4979	:  0000_0000  0x00    0    
  4980	:  0010_1010  0x2A   42  *  
  4981	:  0011_0000  0x30   48  0  
  4982	:  0000_0000  0x00    0    
  4983	:  0000_0100  0x04    4    
  4984	:  0010_1101  0x2D   45  -  
  4985	:  0100_0011  0x43   67  C  
  4986	:  0011_0010  0x32   50  2  
  4987	:  1011_1111  0xBF  191    
  4988	:  0000_1000  0x08    8    
  4989	:  0100_0001  0x41   65  A  
  4990	:  0010_1101  0x2D   45  -  
  4991	:  0011_0101  0x35   53  5  
  4992	:  0011_0000  0x30   48  0  
  4993	:  0010_1101  0x2D   45  -  
  4994	:  0011_0001  0x31   49  1  
  4995	:  0011_1001  0x39   57  9  
  4996	:  0011_0010  0x32   50  2  
  4997	:  1100_0000  0xC0  192    
  4998	:  0000_1100  0x0C   12    
  4999	:  0000_0000  0x00    0    
  5000	:  0000_0001  0x01    1    
  5001	:  0000_0000  0x00    0    
  5002	:  0000_0001  0x01    1    
  5003	:  0000_0000  0x00    0    
  5004	:  0000_0000  0x00    0    
  5005	:  0010_1010  0x2A   42  *  
  5006	:  0011_0000  0x30   48  0  
  5007	:  0000_0000  0x00    0    
  5008	:  0000_0100  0x04    4    
  5009	:  0010_1101  0x2D   45  -  
  5010	:  0100_0011  0x43   67  C  
  5011	:  0011_0010  0x32   50  2  
  5012	:  1100_0000  0xC0  192    
  5013	:  0000_1000  0x08    8    
  5014	:  0100_0001  0x41   65  A  
  5015	:  0010_1101  0x2D   45  -  
  5016	:  0011_0101  0x35   53  5  
  5017	:  0011_0000  0x30   48  0  
  5018	:  0010_1101  0x2D   45  -  
  5019	:  0011_0001  0x31   49  1  
  5020	:  0011_1001  0x39   57  9  
  5021	:  0011_0011  0x33   51  3  
  5022	:  1100_0000  0xC0  192    
  5023	:  0000_1100  0x0C   12    
  5024	:  0000_0000  0x00    0    
  5025	:  0000_0001  0x01    1    
  5026	:  0000_0000  0x00    0    
  5027	:  0000_0001  0x01    1    
  5028	:  0000_0000  0x00    0    
  5029	:  0000_0000  0x00    0    
  5030	:  0010_1010  0x2A   42  *  
  5031	:  0011_0000  0x30   48  0  
  5032	:  0000_0000  0x00    0    
  5033	:  0000_0100  0x04    4    
  5034	:  0010_1101  0x2D   45  -  
  5035	:  0100_0011  0x43   67  C  
  5036	:  0011_0010  0x32   50  2  
  5037	:  1100_0001  0xC1  193    
  5038	:  0000_1000  0x08    8    
  5039	:  0100_0001  0x41   65  A  
  5040	:  0010_1101  0x2D   45  -  
  5041	:  0011_0101  0x35   53  5  
  5042	:  0011_0000  0x30   48  0  
  5043	:  0010_1101  0x2D   45  -  
  5044	:  0011_0001  0x31   49  1  
  5045	:  0011_1001  0x39   57  9  
  5046	:  0011_0100  0x34   52  4  
  5047	:  1100_0000  0xC0  192    
  5048	:  0000_1100  0x0C   12    
  5049	:  0000_0000  0x00    0    
  5050	:  0000_0001  0x01    1    
  5051	:  0000_0000  0x00    0    
  5052	:  0000_0001  0x01    1    
  5053	:  0000_0000  0x00    0    
  5054	:  0000_0000  0x00    0    
  5055	:  0010_1010  0x2A   42  *  
  5056	:  0011_0000  0x30   48  0  
  5057	:  0000_0000  0x00    0    
  5058	:  0000_0100  0x04    4    
  5059	:  0010_1101  0x2D   45  -  
  5060	:  0100_0011  0x43   67  C  
  5061	:  0011_0010  0x32   50  2  
  5062	:  1100_0010  0xC2  194    
  5063	:  0000_1000  0x08    8    
  5064	:  0100_0001  0x41   65  A  
  5065	:  0010_1101  0x2D   45  -  
  5066	:  0011_0101  0x35   53  5  
  5067	:  0011_0000  0x30   48  0  
  5068	:  0010_1101  0x2D   45  -  
  5069	:  0011_0001  0x31   49  1  
  5070	:  0011_1001  0x39   57  9  
  5071	:  0011_0101  0x35   53  5  
  5072	:  1100_0000  0xC0  192    
  5073	:  0000_1100  0x0C   12    
  5074	:  0000_0000  0x00    0    
  5075	:  0000_0001  0x01    1    
  5076	:  0000_0000  0x00    0    
  5077	:  0000_0001  0x01    1    
  5078	:  0000_0000  0x00    0    
  5079	:  0000_0000  0x00    0    
  5080	:  0010_1010  0x2A   42  *  
  5081	:  0011_0000  0x30   48  0  
  5082	:  0000_0000  0x00    0    
  5083	:  0000_0100  0x04    4    
  5084	:  0010_1101  0x2D   45  -  
  5085	:  0100_0011  0x43   67  C  
  5086	:  0011_0010  0x32   50  2  
  5087	:  1100_0011  0xC3  195    
  5088	:  0000_1000  0x08    8    
  5089	:  0100_0001  0x41   65  A  
  5090	:  0010_1101  0x2D   45  -  
  5091	:  0011_0101  0x35   53  5  
  5092	:  0011_0000  0x30   48  0  
  5093	:  0010_1101  0x2D   45  -  
  5094	:  0011_0001  0x31   49  1  
  5095	:  0011_1001  0x39   57  9  
  5096	:  0011_0110  0x36   54  6  
  5097	:  1100_0000  0xC0  192    
  5098	:  0000_1100  0x0C   12    
  5099	:  0000_0000  0x00    0    
  5100	:  0000_0001  0x01    1    
  5101	:  0000_0000  0x00    0    
  5102	:  0000_0001  0x01    1    
  5103	:  0000_0000  0x00    0    
  5104	:  0000_0000  0x00    0    
  5105	:  0010_1010  0x2A   42  *  
  5106	:  0011_0000  0x30   48  0  
  5107	:  0000_0000  0x00    0    
  5108	:  0000_0100  0x04    4    
  5109	:  0010_1101  0x2D   45  -  
  5110	:  0100_0011  0x43   67  C  
  5111	:  0011_0010  0x32   50  2  
  5112	:  1100_0100  0xC4  196    
  5113	:  0000_1000  0x08    8    
  5114	:  0100_0001  0x41   65  A  
  5115	:  0010_1101  0x2D   45  -  
  5116	:  0011_0101  0x35   53  5  
  5117	:  0011_0000  0x30   48  0  
  5118	:  0010_1101  0x2D   45  -  
  5119	:  0011_0001  0x31   49  1  
  5120	:  0011_1001  0x39   57  9  
  5121	:  0011_0111  0x37   55  7  
  5122	:  1100_0000  0xC0  192    
  5123	:  0000_1100  0x0C   12    
  5124	:  0000_0000  0x00    0    
  5125	:  0000_0001  0x01    1    
  5126	:  0000_0000  0x00    0    
  5127	:  0000_0001  0x01    1    
  5128	:  0000_0000  0x00    0    
  5129	:  0000_0000  0x00    0    
  5130	:  0010_1010  0x2A   42  *  
  5131	:  0011_0000  0x30   48  0  
  5132	:  0000_0000  0x00    0    
  5133	:  0000_0100  0x04    4    
  5134	:  0010_1101  0x2D   45  -  
  5135	:  0100_0011  0x43   67  C  
  5136	:  0011_0010  0x32   50  2  
  5137	:  1100_0101  0xC5  197    
  5138	:  0000_1000  0x08    8    
  5139	:  0100_0001  0x41   65  A  
  5140	:  0010_1101  0x2D   45  -  
  5141	:  0011_0101  0x35   53  5  
  5142	:  0011_0000  0x30   48  0  
  5143	:  0010_1101  0x2D   45  -  
  5144	:  0011_0001  0x31   49  1  
  5145	:  0011_1001  0x39   57  9  
  5146	:  0011_1000  0x38   56  8  
  5147	:  1100_0000  0xC0  192    
  5148	:  0000_1100  0x0C   12    
  5149	:  0000_0000  0x00    0    
  5150	:  0000_0001  0x01    1    
  5151	:  0000_0000  0x00    0    
  5152	:  0000_0001  0x01    1    
  5153	:  0000_0000  0x00    0    
  5154	:  0000_0000  0x00    0    
  5155	:  0010_1010  0x2A   42  *  
  5156	:  0011_0000  0x30   48  0  
  5157	:  0000_0000  0x00    0    
  5158	:  0000_0100  0x04    4    
  5159	:  0010_1101  0x2D   45  -  
  5160	:  0100_0011  0x43   67  C  
  5161	:  0011_0010  0x32   50  2  
  5162	:  1100_0110  0xC6  198    
  5163	:  0000_1000  0x08    8    
  5164	:  0100_0001  0x41   65  A  
  5165	:  0010_1101  0x2D   45  -  
  5166	:  0011_0101  0x35   53  5  
  5167	:  0011_0000  0x30   48  0  
  5168	:  0010_1101  0x2D   45  -  
  5169	:  0011_0001  0x31   49  1  
  5170	:  0011_1001  0x39   57  9  
  5171	:  0011_1001  0x39   57  9  
  5172	:  1100_0000  0xC0  192    
  5173	:  0000_1100  0x0C   12    
  5174	:  0000_0000  0x00    0    
  5175	:  0000_0001  0x01    1    
  5176	:  0000_0000  0x00    0    
  5177	:  0000_0001  0x01    1    
  5178	:  0000_0000  0x00    0    
  5179	:  0000_0000  0x00    0    
  5180	:  0010_1010  0x2A   42  *  
  5181	:  0011_0000  0x30   48  0  
  5182	:  0000_0000  0x00    0    
  5183	:  0000_0100  0x04    4    
  5184	:  0010_1101  0x2D   45  -  
  5185	:  0100_0011  0x43   67  C  
  5186	:  0011_0010  0x32   50  2  
  5187	:  1100_0111  0xC7  199    
  5188	:  0000_1000  0x08    8    
  5189	:  0100_0001  0x41   65  A  
  5190	:  0010_1101  0x2D   45  -  
  5191	:  0011_0101  0x35   53  5  
  5192	:  0011_0000  0x30   48  0  
  5193	:  0010_1101  0x2D   45  -  
  5194	:  0011_0010  0x32   50  2  
  5195	:  0011_0000  0x30   48  0  
  5196	:  0011_0000  0x30   48  0  
  5197	:  1100_0000  0xC0  192    
  5198	:  0000_1100  0x0C   12    
  5199	:  0000_0000  0x00    0    
  5200	:  0000_0001  0x01    1    
  5201	:  0000_0000  0x00    0    
  5202	:  0000_0001  0x01    1    
  5203	:  0000_0000  0x00    0    
  5204	:  0000_0000  0x00    0    
  5205	:  0010_1010  0x2A   42  *  
  5206	:  0011_0000  0x30   48  0  
  5207	:  0000_0000  0x00    0    
  5208	:  0000_0100  0x04    4    
  5209	:  0010_1101  0x2D   45  -  
  5210	:  0100_0011  0x43   67  C  
  5211	:  0011_0010  0x32   50  2  
  5212	:  1100_1000  0xC8  200    
  5213	:  0000_1000  0x08    8    
  5214	:  0100_0001  0x41   65  A  
  5215	:  0010_1101  0x2D   45  -  
  5216	:  0011_0101  0x35   53  5  
  5217	:  0011_0000  0x30   48  0  
  5218	:  0010_1101  0x2D   45  -  
  5219	:  0011_0010  0x32   50  2  
  5220	:  0011_0000  0x30   48  0  
  5221	:  0011_0001  0x31   49  1  
  5222	:  1100_0000  0xC0  192    
  5223	:  0000_1100  0x0C   12    
  5224	:  0000_0000  0x00    0    
  5225	:  0000_0001  0x01    1    
  5226	:  0000_0000  0x00    0    
  5227	:  0000_0001  0x01    1    
  5228	:  0000_0000  0x00    0    
  5229	:  0000_0000  0x00    0    
  5230	:  0010_1010  0x2A   42  *  
  5231	:  0011_0000  0x30   48  0  
  5232	:  0000_0000  0x00    0    
  5233	:  0000_0100  0x04    4    
  5234	:  0010_1101  0x2D   45  -  
  5235	:  0100_0011  0x43   67  C  
  5236	:  0011_0010  0x32   50  2  
  5237	:  1100_1001  0xC9  201    
  5238	:  0000_1000  0x08    8    
  5239	:  0100_0001  0x41   65  A  
  5240	:  0010_1101  0x2D   45  -  
  5241	:  0011_0101  0x35   53  5  
  5242	:  0011_0000  0x30   48  0  
  5243	:  0010_1101  0x2D   45  -  
  5244	:  0011_0010  0x32   50  2  
  5245	:  0011_0000  0x30   48  0  
  5246	:  0011_0010  0x32   50  2  
  5247	:  1100_0000  0xC0  192    
  5248	:  0000_1100  0x0C   12    
  5249	:  0000_0000  0x00    0    
  5250	:  0000_0001  0x01    1    
  5251	:  0000_0000  0x00    0    
  5252	:  0000_0001  0x01    1    
  5253	:  0000_0000  0x00    0    
  5254	:  0000_0000  0x00    0    
  5255	:  0010_1010  0x2A   42  *  
  5256	:  0011_0000  0x30   48  0  
  5257	:  0000_0000  0x00    0    
  5258	:  0000_0100  0x04    4    
  5259	:  0010_1101  0x2D   45  -  
  5260	:  0100_0011  0x43   67  C  
  5261	:  0011_0010  0x32   50  2  
  5262	:  1100_1010  0xCA  202    
  5263	:  0000_1000  0x08    8    
  5264	:  0100_0001  0x41   65  A  
  5265	:  0010_1101  0x2D   45  -  
  5266	:  0011_0101  0x35   53  5  
  5267	:  0011_0000  0x30   48  0  
  5268	:  0010_1101  0x2D   45  -  
  5269	:  0011_0010  0x32   50  2  
  5270	:  0011_0000  0x30   48  0  
  5271	:  0011_0011  0x33   51  3  
  5272	:  1100_0000  0xC0  192    
  5273	:  0000_1100  0x0C   12    
  5274	:  0000_0000  0x00    0    
  5275	:  0000_0001  0x01    1    
  5276	:  0000_0000  0x00    0    
  5277	:  0000_0001  0x01    1    
  5278	:  0000_0000  0x00    0    
  5279	:  0000_0000  0x00    0    
  5280	:  0010_1010  0x2A   42  *  
  5281	:  0011_0000  0x30   48  0  
  5282	:  0000_0000  0x00    0    
  5283	:  0000_0100  0x04    4    
  5284	:  0010_1101  0x2D   45  -  
  5285	:  0100_0011  0x43   67  C  
  5286	:  0011_0010  0x32   50  2  
  5287	:  1100_1011  0xCB  203    
  5288	:  0000_1000  0x08    8    
  5289	:  0100_0001  0x41   65  A  
  5290	:  0010_1101  0x2D   45  -  
  5291	:  0011_0101  0x35   53  5  
  5292	:  0011_0000  0x30   48  0  
  5293	:  0010_1101  0x2D   45  -  
  5294	:  0011_0010  0x32   50  2  
  5295	:  0011_0000  0x30   48  0  
  5296	:  0011_0100  0x34   52  4  
  5297	:  1100_0000  0xC0  192    
  5298	:  0000_1100  0x0C   12    
  5299	:  0000_0000  0x00    0    
  5300	:  0000_0001  0x01    1    
  5301	:  0000_0000  0x00    0    
  5302	:  0000_0001  0x01    1    
  5303	:  0000_0000  0x00    0    
  5304	:  0000_0000  0x00    0    
  5305	:  0010_1010  0x2A   42  *  
  5306	:  0011_0000  0x30   48  0  
  5307	:  0000_0000  0x00    0    
  5308	:  0000_0100  0x04    4    
  5309	:  0010_1101  0x2D   45  -  
  5310	:  0100_0011  0x43   67  C  
  5311	:  0011_0010  0x32   50  2  
  5312	:  1100_1100  0xCC  204    
  5313	:  0000_1000  0x08    8    
  5314	:  0100_0001  0x41   65  A  
  5315	:  0010_1101  0x2D   45  -  
  5316	:  0011_0101  0x35   53  5  
  5317	:  0011_0000  0x30   48  0  
  5318	:  0010_1101  0x2D   45  -  
  5319	:  0011_0010  0x32   50  2  
  5320	:  0011_0000  0x30   48  0  
  5321	:  0011_0101  0x35   53  5  
  5322	:  1100_0000  0xC0  192    
  5323	:  0000_1100  0x0C   12    
  5324	:  0000_0000  0x00    0    
  5325	:  0000_0001  0x01    1    
  5326	:  0000_0000  0x00    0    
  5327	:  0000_0001  0x01    1    
  5328	:  0000_0000  0x00    0    
  5329	:  0000_0000  0x00    0    
  5330	:  0010_1010  0x2A   42  *  
  5331	:  0011_0000  0x30   48  0  
  5332	:  0000_0000  0x00    0    
  5333	:  0000_0100  0x04    4    
  5334	:  0010_1101  0x2D   45  -  
  5335	:  0100_0011  0x43   67  C  
  5336	:  0011_0010  0x32   50  2  
  5337	:  1100_1101  0xCD  205    
  5338	:  0000_1000  0x08    8    
  5339	:  0100_0001  0x41   65  A  
  5340	:  0010_1101  0x2D   45  -  
  5341	:  0011_0101  0x35   53  5  
  5342	:  0011_0000  0x30   48  0  
  5343	:  0010_1101  0x2D   45  -  
  5344	:  0011_0010  0x32   50  2  
  5345	:  0011_0000  0x30   48  0  
  5346	:  0011_0110  0x36   54  6  
  5347	:  1100_0000  0xC0  192    
  5348	:  0000_1100  0x0C   12    
  5349	:  0000_0000  0x00    0    
  5350	:  0000_0001  0x01    1    
  5351	:  0000_0000  0x00    0    
  5352	:  0000_0001  0x01    1    
  5353	:  0000_0000  0x00    0    
  5354	:  0000_0000  0x00    0    
  5355	:  0010_1010  0x2A   42  *  
  5356	:  0011_0000  0x30   48  0  
  5357	:  0000_0000  0x00    0    
  5358	:  0000_0100  0x04    4    
  5359	:  0010_1101  0x2D   45  -  
  5360	:  0100_0011  0x43   67  C  
  5361	:  0011_0010  0x32   50  2  
  5362	:  1100_1110  0xCE  206    
  5363	:  0000_1000  0x08    8    
  5364	:  0100_0001  0x41   65  A  
  5365	:  0010_1101  0x2D   45  -  
  5366	:  0011_0101  0x35   53  5  
  5367	:  0011_0000  0x30   48  0  
  5368	:  0010_1101  0x2D   45  -  
  5369	:  0011_0010  0x32   50  2  
  5370	:  0011_0000  0x30   48  0  
  5371	:  0011_0111  0x37   55  7  
  5372	:  1100_0000  0xC0  192    
  5373	:  0000_1100  0x0C   12    
  5374	:  0000_0000  0x00    0    
  5375	:  0000_0001  0x01    1    
  5376	:  0000_0000  0x00    0    
  5377	:  0000_0001  0x01    1    
  5378	:  0000_0000  0x00    0    
  5379	:  0000_0000  0x00    0    
  5380	:  0010_1010  0x2A   42  *  
  5381	:  0011_0000  0x30   48  0  
  5382	:  0000_0000  0x00    0    
  5383	:  0000_0100  0x04    4    
  5384	:  0010_1101  0x2D   45  -  
  5385	:  0100_0011  0x43   67  C  
  5386	:  0011_0010  0x32   50  2  
  5387	:  1100_1111  0xCF  207    
  5388	:  0000_1000  0x08    8    
  5389	:  0100_0001  0x41   65  A  
  5390	:  0010_1101  0x2D   45  -  
  5391	:  0011_0101  0x35   53  5  
  5392	:  0011_0000  0x30   48  0  
  5393	:  0010_1101  0x2D   45  -  
  5394	:  0011_0010  0x32   50  2  
  5395	:  0011_0000  0x30   48  0  
  5396	:  0011_1000  0x38   56  8  
  5397	:  1100_0000  0xC0  192    
  5398	:  0000_1100  0x0C   12    
  5399	:  0000_0000  0x00    0    
  5400	:  0000_0001  0x01    1    
  5401	:  0000_0000  0x00    0    
  5402	:  0000_0001  0x01    1    
  5403	:  0000_0000  0x00    0    
  5404	:  0000_0000  0x00    0    
  5405	:  0010_1010  0x2A   42  *  
  5406	:  0011_0000  0x30   48  0  
  5407	:  0000_0000  0x00    0    
  5408	:  0000_0100  0x04    4    
  5409	:  0010_1101  0x2D   45  -  
  5410	:  0100_0011  0x43   67  C  
  5411	:  0011_0010  0x32   50  2  
  5412	:  1101_0000  0xD0  208    
  5413	:  0000_1000  0x08    8    
  5414	:  0100_0001  0x41   65  A  
  5415	:  0010_1101  0x2D   45  -  
  5416	:  0011_0101  0x35   53  5  
  5417	:  0011_0000  0x30   48  0  
  5418	:  0010_1101  0x2D   45  -  
  5419	:  0011_0010  0x32   50  2  
  5420	:  0011_0000  0x30   48  0  
  5421	:  0011_1001  0x39   57  9  
  5422	:  1100_0000  0xC0  192    
  5423	:  0000_1100  0x0C   12    
  5424	:  0000_0000  0x00    0    
  5425	:  0000_0001  0x01    1    
  5426	:  0000_0000  0x00    0    
  5427	:  0000_0001  0x01    1    
  5428	:  0000_0000  0x00    0    
  5429	:  0000_0000  0x00    0    
  5430	:  0010_1010  0x2A   42  *  
  5431	:  0011_0000  0x30   48  0  
  5432	:  0000_0000  0x00    0    
  5433	:  0000_0100  0x04    4    
  5434	:  0010_1101  0x2D   45  -  
  5435	:  0100_0011  0x43   67  C  
  5436	:  0011_0010  0x32   50  2  
  5437	:  1101_0001  0xD1  209    
  5438	:  0000_1000  0x08    8    
  5439	:  0100_0001  0x41   65  A  
  5440	:  0010_1101  0x2D   45  -  
  5441	:  0011_0101  0x35   53  5  
  5442	:  0011_0000  0x30   48  0  
  5443	:  0010_1101  0x2D   45  -  
  5444	:  0011_0010  0x32   50  2  
  5445	:  0011_0001  0x31   49  1  
  5446	:  0011_0000  0x30   48  0  
  5447	:  1100_0000  0xC0  192    
  5448	:  0000_1100  0x0C   12    
  5449	:  0000_0000  0x00    0    
  5450	:  0000_0001  0x01    1    
  5451	:  0000_0000  0x00    0    
  5452	:  0000_0001  0x01    1    
  5453	:  0000_0000  0x00    0    
  5454	:  0000_0000  0x00    0    
  5455	:  0010_1010  0x2A   42  *  
  5456	:  0011_0000  0x30   48  0  
  5457	:  0000_0000  0x00    0    
  5458	:  0000_0100  0x04    4    
  5459	:  0010_1101  0x2D   45  -  
  5460	:  0100_0011  0x43   67  C  
  5461	:  0011_0010  0x32   50  2  
  5462	:  1101_0010  0xD2  210    
  5463	:  0000_1000  0x08    8    
  5464	:  0100_0001  0x41   65  A  
  5465	:  0010_1101  0x2D   45  -  
  5466	:  0011_0101  0x35   53  5  
  5467	:  0011_0000  0x30   48  0  
  5468	:  0010_1101  0x2D   45  -  
  5469	:  0011_0010  0x32   50  2  
  5470	:  0011_0001  0x31   49  1  
  5471	:  0011_0001  0x31   49  1  
  5472	:  1100_0000  0xC0  192    
  5473	:  0000_1100  0x0C   12    
  5474	:  0000_0000  0x00    0    
  5475	:  0000_0001  0x01    1    
  5476	:  0000_0000  0x00    0    
  5477	:  0000_0001  0x01    1    
  5478	:  0000_0000  0x00    0    
  5479	:  0000_0000  0x00    0    
  5480	:  0010_1010  0x2A   42  *  
  5481	:  0011_0000  0x30   48  0  
  5482	:  0000_0000  0x00    0    
  5483	:  0000_0100  0x04    4    
  5484	:  0010_1101  0x2D   45  -  
  5485	:  0100_0011  0x43   67  C  
  5486	:  0011_0010  0x32   50  2  
  5487	:  1101_0011  0xD3  211    
  5488	:  0000_1000  0x08    8    
  5489	:  0100_0001  0x41   65  A  
  5490	:  0010_1101  0x2D   45  -  
  5491	:  0011_0101  0x35   53  5  
  5492	:  0011_0000  0x30   48  0  
  5493	:  0010_1101  0x2D   45  -  
  5494	:  0011_0010  0x32   50  2  
  5495	:  0011_0001  0x31   49  1  
  5496	:  0011_0010  0x32   50  2  
  5497	:  1100_0000  0xC0  192    
  5498	:  0000_1100  0x0C   12    
  5499	:  0000_0000  0x00    0    
  5500	:  0000_0001  0x01    1    
  5501	:  0000_0000  0x00    0    
  5502	:  0000_0001  0x01    1    
  5503	:  0000_0000  0x00    0    
  5504	:  0000_0000  0x00    0    
  5505	:  0010_1010  0x2A   42  *  
  5506	:  0011_0000  0x30   48  0  
  5507	:  0000_0000  0x00    0    
  5508	:  0000_0100  0x04    4    
  5509	:  0010_1101  0x2D   45  -  
  5510	:  0100_0011  0x43   67  C  
  5511	:  0011_0010  0x32   50  2  
  5512	:  1101_0100  0xD4  212    
  5513	:  0000_1000  0x08    8    
  5514	:  0100_0001  0x41   65  A  
  5515	:  0010_1101  0x2D   45  -  
  5516	:  0011_0101  0x35   53  5  
  5517	:  0011_0000  0x30   48  0  
  5518	:  0010_1101  0x2D   45  -  
  5519	:  0011_0010  0x32   50  2  
  5520	:  0011_0001  0x31   49  1  
  5521	:  0011_0011  0x33   51  3  
  5522	:  1100_0000  0xC0  192    
  5523	:  0000_1100  0x0C   12    
  5524	:  0000_0000  0x00    0    
  5525	:  0000_0001  0x01    1    
  5526	:  0000_0000  0x00    0    
  5527	:  0000_0001  0x01    1    
  5528	:  0000_0000  0x00    0    
  5529	:  0000_0000  0x00    0    
  5530	:  0010_1010  0x2A   42  *  
  5531	:  0011_0000  0x30   48  0  
  5532	:  0000_0000  0x00    0    
  5533	:  0000_0100  0x04    4    
  5534	:  0010_1101  0x2D   45  -  
  5535	:  0100_0011  0x43   67  C  
  5536	:  0011_0010  0x32   50  2  
  5537	:  1101_0101  0xD5  213    
  5538	:  0000_1000  0x08    8    
  5539	:  0100_0001  0x41   65  A  
  5540	:  0010_1101  0x2D   45  -  
  5541	:  0011_0101  0x35   53  5  
  5542	:  0011_0000  0x30   48  0  
  5543	:  0010_1101  0x2D   45  -  
  5544	:  0011_0010  0x32   50  2  
  5545	:  0011_0001  0x31   49  1  
  5546	:  0011_0100  0x34   52  4  
  5547	:  1100_0000  0xC0  192    
  5548	:  0000_1100  0x0C   12    
  5549	:  0000_0000  0x00    0    
  5550	:  0000_0001  0x01    1    
  5551	:  0000_0000  0x00    0    
  5552	:  0000_0001  0x01    1    
  5553	:  0000_0000  0x00    0    
  5554	:  0000_0000  0x00    0    
  5555	:  0010_1010  0x2A   42  *  
  5556	:  0011_0000  0x30   48  0  
  5557	:  0000_0000  0x00    0    
  5558	:  0000_0100  0x04    4    
  5559	:  0010_1101  0x2D   45  -  
  5560	:  0100_0011  0x43   67  C  
  5561	:  0011_0010  0x32   50  2  
  5562	:  1101_0110  0xD6  214    
  5563	:  0000_1000  0x08    8    
  5564	:  0100_0001  0x41   65  A  
  5565	:  0010_1101  0x2D   45  -  
  5566	:  0011_0101  0x35   53  5  
  5567	:  0011_0000  0x30   48  0  
  5568	:  0010_1101  0x2D   45  -  
  5569	:  0011_0010  0x32   50  2  
  5570	:  0011_0001  0x31   49  1  
  5571	:  0011_0101  0x35   53  5  
  5572	:  1100_0000  0xC0  192    
  5573	:  0000_1100  0x0C   12    
  5574	:  0000_0000  0x00    0    
  5575	:  0000_0001  0x01    1    
  5576	:  0000_0000  0x00    0    
  5577	:  0000_0001  0x01    1    
  5578	:  0000_0000  0x00    0    
  5579	:  0000_0000  0x00    0    
  5580	:  0010_1010  0x2A   42  *  
  5581	:  0011_0000  0x30   48  0  
  5582	:  0000_0000  0x00    0    
  5583	:  0000_0100  0x04    4    
  5584	:  0010_1101  0x2D   45  -  
  5585	:  0100_0011  0x43   67  C  
  5586	:  0011_0010  0x32   50  2  
  5587	:  1101_0111  0xD7  215    
  5588	:  0000_1000  0x08    8    
  5589	:  0100_0001  0x41   65  A  
  5590	:  0010_1101  0x2D   45  -  
  5591	:  0011_0101  0x35   53  5  
  5592	:  0011_0000  0x30   48  0  
  5593	:  0010_1101  0x2D   45  -  
  5594	:  0011_0010  0x32   50  2  
  5595	:  0011_0001  0x31   49  1  
  5596	:  0011_0110  0x36   54  6  
  5597	:  1100_0000  0xC0  192    
  5598	:  0000_1100  0x0C   12    
  5599	:  0000_0000  0x00    0    
  5600	:  0000_0001  0x01    1    
  5601	:  0000_0000  0x00    0    
  5602	:  0000_0001  0x01    1    
  5603	:  0000_0000  0x00    0    
  5604	:  0000_0000  0x00    0    
  5605	:  0010_1010  0x2A   42  *  
  5606	:  0011_0000  0x30   48  0  
  5607	:  0000_0000  0x00    0    
  5608	:  0000_0100  0x04    4    
  5609	:  0010_1101  0x2D   45  -  
  5610	:  0100_0011  0x43   67  C  
  5611	:  0011_0010  0x32   50  2  
  5612	:  1101_1000  0xD8  216    
  5613	:  0000_1000  0x08    8    
  5614	:  0100_0001  0x41   65  A  
  5615	:  0010_1101  0x2D   45  -  
  5616	:  0011_0101  0x35   53  5  
  5617	:  0011_0000  0x30   48  0  
  5618	:  0010_1101  0x2D   45  -  
  5619	:  0011_0010  0x32   50  2  
  5620	:  0011_0001  0x31   49  1  
  5621	:  0011_0111  0x37   55  7  
  5622	:  1100_0000  0xC0  192    
  5623	:  0000_1100  0x0C   12    
  5624	:  0000_0000  0x00    0    
  5625	:  0000_0001  0x01    1    
  5626	:  0000_0000  0x00    0    
  5627	:  0000_0001  0x01    1    
  5628	:  0000_0000  0x00    0    
  5629	:  0000_0000  0x00    0    
  5630	:  0010_1010  0x2A   42  *  
  5631	:  0011_0000  0x30   48  0  
  5632	:  0000_0000  0x00    0    
  5633	:  0000_0100  0x04    4    
  5634	:  0010_1101  0x2D   45  -  
  5635	:  0100_0011  0x43   67  C  
  5636	:  0011_0010  0x32   50  2  
  5637	:  1101_1001  0xD9  217    
  5638	:  0000_1000  0x08    8    
  5639	:  0100_0001  0x41   65  A  
  5640	:  0010_1101  0x2D   45  -  
  5641	:  0011_0101  0x35   53  5  
  5642	:  0011_0000  0x30   48  0  
  5643	:  0010_1101  0x2D   45  -  
  5644	:  0011_0010  0x32   50  2  
  5645	:  0011_0001  0x31   49  1  
  5646	:  0011_1000  0x38   56  8  
  5647	:  1100_0000  0xC0  192    
  5648	:  0000_1100  0x0C   12    
  5649	:  0000_0000  0x00    0    
  5650	:  0000_0001  0x01    1    
  5651	:  0000_0000  0x00    0    
  5652	:  0000_0001  0x01    1    
  5653	:  0000_0000  0x00    0    
  5654	:  0000_0000  0x00    0    
  5655	:  0010_1010  0x2A   42  *  
  5656	:  0011_0000  0x30   48  0  
  5657	:  0000_0000  0x00    0    
  5658	:  0000_0100  0x04    4    
  5659	:  0010_1101  0x2D   45  -  
  5660	:  0100_0011  0x43   67  C  
  5661	:  0011_0010  0x32   50  2  
  5662	:  1101_1010  0xDA  218    
  5663	:  0000_1000  0x08    8    
  5664	:  0100_0001  0x41   65  A  
  5665	:  0010_1101  0x2D   45  -  
  5666	:  0011_0101  0x35   53  5  
  5667	:  0011_0000  0x30   48  0  
  5668	:  0010_1101  0x2D   45  -  
  5669	:  0011_0010  0x32   50  2  
  5670	:  0011_0001  0x31   49  1  
  5671	:  0011_1001  0x39   57  9  
  5672	:  1100_0000  0xC0  192    
  5673	:  0000_1100  0x0C   12    
  5674	:  0000_0000  0x00    0    
  5675	:  0000_0001  0x01    1    
  5676	:  0000_0000  0x00    0    
  5677	:  0000_0001  0x01    1    
  5678	:  0000_0000  0x00    0    
  5679	:  0000_0000  0x00    0    
  5680	:  0010_1010  0x2A   42  *  
  5681	:  0011_0000  0x30   48  0  
  5682	:  0000_0000  0x00    0    
  5683	:  0000_0100  0x04    4    
  5684	:  0010_1101  0x2D   45  -  
  5685	:  0100_0011  0x43   67  C  
  5686	:  0011_0010  0x32   50  2  
  5687	:  1101_1011  0xDB  219    
  5688	:  0000_1000  0x08    8    
  5689	:  0100_0001  0x41   65  A  
  5690	:  0010_1101  0x2D   45  -  
  5691	:  0011_0101  0x35   53  5  
  5692	:  0011_0000  0x30   48  0  
  5693	:  0010_1101  0x2D   45  -  
  5694	:  0011_0010  0x32   50  2  
  5695	:  0011_0010  0x32   50  2  
  5696	:  0011_0000  0x30   48  0  
  5697	:  1100_0000  0xC0  192    
  5698	:  0000_1100  0x0C   12    
  5699	:  0000_0000  0x00    0    
  5700	:  0000_0001  0x01    1    
  5701	:  0000_0000  0x00    0    
  5702	:  0000_0001  0x01    1    
  5703	:  0000_0000  0x00    0    
  5704	:  0000_0000  0x00    0    
  5705	:  0010_1010  0x2A   42  *  
  5706	:  0011_0000  0x30   48  0  
  5707	:  0000_0000  0x00    0    
  5708	:  0000_0100  0x04    4    
  5709	:  0010_1101  0x2D   45  -  
  5710	:  0100_0011  0x43   67  C  
  5711	:  0011_0010  0x32   50  2  
  5712	:  1101_1100  0xDC  220    
  5713	:  0000_1000  0x08    8    
  5714	:  0100_0001  0x41   65  A  
  5715	:  0010_1101  0x2D   45  -  
  5716	:  0011_0101  0x35   53  5  
  5717	:  0011_0000  0x30   48  0  
  5718	:  0010_1101  0x2D   45  -  
  5719	:  0011_0010  0x32   50  2  
  5720	:  0011_0010  0x32   50  2  
  5721	:  0011_0001  0x31   49  1  
  5722	:  1100_0000  0xC0  192    
  5723	:  0000_1100  0x0C   12    
  5724	:  0000_0000  0x00    0    
  5725	:  0000_0001  0x01    1    
  5726	:  0000_0000  0x00    0    
  5727	:  0000_0001  0x01    1    
  5728	:  0000_0000  0x00    0    
  5729	:  0000_0000  0x00    0    
  5730	:  0010_1010  0x2A   42  *  
  5731	:  0011_0000  0x30   48  0  
  5732	:  0000_0000  0x00    0    
  5733	:  0000_0100  0x04    4    
  5734	:  0010_1101  0x2D   45  -  
  5735	:  0100_0011  0x43   67  C  
  5736	:  0011_0010  0x32   50  2  
  5737	:  1101_1101  0xDD  221    
  5738	:  0000_1000  0x08    8    
  5739	:  0100_0001  0x41   65  A  
  5740	:  0010_1101  0x2D   45  -  
  5741	:  0011_0101  0x35   53  5  
  5742	:  0011_0000  0x30   48  0  
  5743	:  0010_1101  0x2D   45  -  
  5744	:  0011_0010  0x32   50  2  
  5745	:  0011_0010  0x32   50  2  
  5746	:  0011_0010  0x32   50  2  
  5747	:  1100_0000  0xC0  192    
  5748	:  0000_1100  0x0C   12    
  5749	:  0000_0000  0x00    0    
  5750	:  0000_0001  0x01    1    
  5751	:  0000_0000  0x00    0    
  5752	:  0000_0001  0x01    1    
  5753	:  0000_0000  0x00    0    
  5754	:  0000_0000  0x00    0    
  5755	:  0010_1010  0x2A   42  *  
  5756	:  0011_0000  0x30   48  0  
  5757	:  0000_0000  0x00    0    
  5758	:  0000_0100  0x04    4    
  5759	:  0010_1101  0x2D   45  -  
  5760	:  0100_0011  0x43   67  C  
  5761	:  0011_0010  0x32   50  2  
  5762	:  1101_1110  0xDE  222    
  5763	:  0000_1000  0x08    8    
  5764	:  0100_0001  0x41   65  A  
  5765	:  0010_1101  0x2D   45  -  
  5766	:  0011_0101  0x35   53  5  
  5767	:  0011_0000  0x30   48  0  
  5768	:  0010_1101  0x2D   45  -  
  5769	:  0011_0010  0x32   50  2  
  5770	:  0011_0010  0x32   50  2  
  5771	:  0011_0011  0x33   51  3  
  5772	:  1100_0000  0xC0  192    
  5773	:  0000_1100  0x0C   12    
  5774	:  0000_0000  0x00    0    
  5775	:  0000_0001  0x01    1    
  5776	:  0000_0000  0x00    0    
  5777	:  0000_0001  0x01    1    
  5778	:  0000_0000  0x00    0    
  5779	:  0000_0000  0x00    0    
  5780	:  0010_1010  0x2A   42  *  
  5781	:  0011_0000  0x30   48  0  
  5782	:  0000_0000  0x00    0    
  5783	:  0000_0100  0x04    4    
  5784	:  0010_1101  0x2D   45  -  
  5785	:  0100_0011  0x43   67  C  
  5786	:  0011_0010  0x32   50  2  
  5787	:  1101_1111  0xDF  223    
  5788	:  0000_1000  0x08    8    
  5789	:  0100_0001  0x41   65  A  
  5790	:  0010_1101  0x2D   45  -  
  5791	:  0011_0101  0x35   53  5  
  5792	:  0011_0000  0x30   48  0  
  5793	:  0010_1101  0x2D   45  -  
  5794	:  0011_0010  0x32   50  2  
  5795	:  0011_0010  0x32   50  2  
  5796	:  0011_0100  0x34   52  4  
  5797	:  1100_0000  0xC0  192    
  5798	:  0000_1100  0x0C   12    
  5799	:  0000_0000  0x00    0    
  5800	:  0000_0001  0x01    1    
  5801	:  0000_0000  0x00    0    
  5802	:  0000_0001  0x01    1    
  5803	:  0000_0000  0x00    0    
  5804	:  0000_0000  0x00    0    
  5805	:  0010_1010  0x2A   42  *  
  5806	:  0011_0000  0x30   48  0  
  5807	:  0000_0000  0x00    0    
  5808	:  0000_0100  0x04    4    
  5809	:  0010_1101  0x2D   45  -  
  5810	:  0100_0011  0x43   67  C  
  5811	:  0011_0010  0x32   50  2  
  5812	:  1110_0000  0xE0  224    
  5813	:  0000_1000  0x08    8    
  5814	:  0100_0001  0x41   65  A  
  5815	:  0010_1101  0x2D   45  -  
  5816	:  0011_0101  0x35   53  5  
  5817	:  0011_0000  0x30   48  0  
  5818	:  0010_1101  0x2D   45  -  
  5819	:  0011_0010  0x32   50  2  
  5820	:  0011_0010  0x32   50  2  
  5821	:  0011_0101  0x35   53  5  
  5822	:  1100_0000  0xC0  192    
  5823	:  0000_1100  0x0C   12    
  5824	:  0000_0000  0x00    0    
  5825	:  0000_0001  0x01    1    
  5826	:  0000_0000  0x00    0    
  5827	:  0000_0001  0x01    1    
  5828	:  0000_0000  0x00    0    
  5829	:  0000_0000  0x00    0    
  5830	:  0010_1010  0x2A   42  *  
  5831	:  0011_0000  0x30   48  0  
  5832	:  0000_0000  0x00    0    
  5833	:  0000_0100  0x04    4    
  5834	:  0010_1101  0x2D   45  -  
  5835	:  0100_0011  0x43   67  C  
  5836	:  0011_0010  0x32   50  2  
  5837	:  1110_0001  0xE1  225    
  5838	:  0000_1000  0x08    8    
  5839	:  0100_0001  0x41   65  A  
  5840	:  0010_1101  0x2D   45  -  
  5841	:  0011_0101  0x35   53  5  
  5842	:  0011_0000  0x30   48  0  
  5843	:  0010_1101  0x2D   45  -  
  5844	:  0011_0010  0x32   50  2  
  5845	:  0011_0010  0x32   50  2  
  5846	:  0011_0110  0x36   54  6  
  5847	:  1100_0000  0xC0  192    
  5848	:  0000_1100  0x0C   12    
  5849	:  0000_0000  0x00    0    
  5850	:  0000_0001  0x01    1    
  5851	:  0000_0000  0x00    0    
  5852	:  0000_0001  0x01    1    
  5853	:  0000_0000  0x00    0    
  5854	:  0000_0000  0x00    0    
  5855	:  0010_1010  0x2A   42  *  
  5856	:  0011_0000  0x30   48  0  
  5857	:  0000_0000  0x00    0    
  5858	:  0000_0100  0x04    4    
  5859	:  0010_1101  0x2D   45  -  
  5860	:  0100_0011  0x43   67  C  
  5861	:  0011_0010  0x32   50  2  
  5862	:  1110_0010  0xE2  226    
  5863	:  0000_1000  0x08    8    
  5864	:  0100_0001  0x41   65  A  
  5865	:  0010_1101  0x2D   45  -  
  5866	:  0011_0101  0x35   53  5  
  5867	:  0011_0000  0x30   48  0  
  5868	:  0010_1101  0x2D   45  -  
  5869	:  0011_0010  0x32   50  2  
  5870	:  0011_0010  0x32   50  2  
  5871	:  0011_0111  0x37   55  7  
  5872	:  1100_0000  0xC0  192    
  5873	:  0000_1100  0x0C   12    
  5874	:  0000_0000  0x00    0    
  5875	:  0000_0001  0x01    1    
  5876	:  0000_0000  0x00    0    
  5877	:  0000_0001  0x01    1    
  5878	:  0000_0000  0x00    0    
  5879	:  0000_0000  0x00    0    
  5880	:  0010_1010  0x2A   42  *  
  5881	:  0011_0000  0x30   48  0  
  5882	:  0000_0000  0x00    0    
  5883	:  0000_0100  0x04    4    
  5884	:  0010_1101  0x2D   45  -  
  5885	:  0100_0011  0x43   67  C  
  5886	:  0011_0010  0x32   50  2  
  5887	:  1110_0011  0xE3  227    
  5888	:  0000_1000  0x08    8    
  5889	:  0100_0001  0x41   65  A  
  5890	:  0010_1101  0x2D   45  -  
  5891	:  0011_0101  0x35   53  5  
  5892	:  0011_0000  0x30   48  0  
  5893	:  0010_1101  0x2D   45  -  
  5894	:  0011_0010  0x32   50  2  
  5895	:  0011_0010  0x32   50  2  
  5896	:  0011_1000  0x38   56  8  
  5897	:  1100_0000  0xC0  192    
  5898	:  0000_1100  0x0C   12    
  5899	:  0000_0000  0x00    0    
  5900	:  0000_0001  0x01    1    
  5901	:  0000_0000  0x00    0    
  5902	:  0000_0001  0x01    1    
  5903	:  0000_0000  0x00    0    
  5904	:  0000_0000  0x00    0    
  5905	:  0010_1010  0x2A   42  *  
  5906	:  0011_0000  0x30   48  0  
  5907	:  0000_0000  0x00    0    
  5908	:  0000_0100  0x04    4    
  5909	:  0010_1101  0x2D   45  -  
  5910	:  0100_0011  0x43   67  C  
  5911	:  0011_0010  0x32   50  2  
  5912	:  1110_0100  0xE4  228    
  5913	:  0000_1000  0x08    8    
  5914	:  0100_0001  0x41   65  A  
  5915	:  0010_1101  0x2D   45  -  
  5916	:  0011_0101  0x35   53  5  
  5917	:  0011_0000  0x30   48  0  
  5918	:  0010_1101  0x2D   45  -  
  5919	:  0011_0010  0x32   50  2  
  5920	:  0011_0010  0x32   50  2  
  5921	:  0011_1001  0x39   57  9  
  5922	:  1100_0000  0xC0  192    
  5923	:  0000_1100  0x0C   12    
  5924	:  0000_0000  0x00    0    
  5925	:  0000_0001  0x01    1    
  5926	:  0000_0000  0x00    0    
  5927	:  0000_0001  0x01    1    
  5928	:  0000_0000  0x00    0    
  5929	:  0000_0000  0x00    0    
  5930	:  0010_1010  0x2A   42  *  
  5931	:  0011_0000  0x30   48  0  
  5932	:  0000_0000  0x00    0    
  5933	:  0000_0100  0x04    4    
  5934	:  0010_1101  0x2D   45  -  
  5935	:  0100_0011  0x43   67  C  
  5936	:  0011_0010  0x32   50  2  
  5937	:  1110_0101  0xE5  229    
  5938	:  0000_1000  0x08    8    
  5939	:  0100_0001  0x41   65  A  
  5940	:  0010_1101  0x2D   45  -  
  5941	:  0011_0101  0x35   53  5  
  5942	:  0011_0000  0x30   48  0  
  5943	:  0010_1101  0x2D   45  -  
  5944	:  0011_0010  0x32   50  2  
  5945	:  0011_0011  0x33   51  3  
  5946	:  0011_0000  0x30   48  0  
  5947	:  1100_0000  0xC0  192    
  5948	:  0000_1100  0x0C   12    
  5949	:  0000_0000  0x00    0    
  5950	:  0000_0001  0x01    1    
  5951	:  0000_0000  0x00    0    
  5952	:  0000_0001  0x01    1    
  5953	:  0000_0000  0x00    0    
  5954	:  0000_0000  0x00    0    
  5955	:  0010_1010  0x2A   42  *  
  5956	:  0011_0000  0x30   48  0  
  5957	:  0000_0000  0x00    0    
  5958	:  0000_0100  0x04    4    
  5959	:  0010_1101  0x2D   45  -  
  5960	:  0100_0011  0x43   67  C  
  5961	:  0011_0010  0x32   50  2  
  5962	:  1110_0110  0xE6  230    
  5963	:  0000_1000  0x08    8    
  5964	:  0100_0001  0x41   65  A  
  5965	:  0010_1101  0x2D   45  -  
  5966	:  0011_0101  0x35   53  5  
  5967	:  0011_0000  0x30   48  0  
  5968	:  0010_1101  0x2D   45  -  
  5969	:  0011_0010  0x32   50  2  
  5970	:  0011_0011  0x33   51  3  
  5971	:  0011_0001  0x31   49  1  
  5972	:  1100_0000  0xC0  192    
  5973	:  0000_1100  0x0C   12    
  5974	:  0000_0000  0x00    0    
  5975	:  0000_0001  0x01    1    
  5976	:  0000_0000  0x00    0    
  5977	:  0000_0001  0x01    1    
  5978	:  0000_0000  0x00    0    
  5979	:  0000_0000  0x00    0    
  5980	:  0010_1010  0x2A   42  *  
  5981	:  0011_0000  0x30   48  0  
  5982	:  0000_0000  0x00    0    
  5983	:  0000_0100  0x04    4    
  5984	:  0010_1101  0x2D   45  -  
  5985	:  0100_0011  0x43   67  C  
  5986	:  0011_0010  0x32   50  2  
  5987	:  1110_0111  0xE7  231    
  5988	:  0000_1000  0x08    8    
  5989	:  0100_0001  0x41   65  A  
  5990	:  0010_1101  0x2D   45  -  
  5991	:  0011_0101  0x35   53  5  
  5992	:  0011_0000  0x30   48  0  
  5993	:  0010_1101  0x2D   45  -  
  5994	:  0011_0010  0x32   50  2  
  5995	:  0011_0011  0x33   51  3  
  5996	:  0011_0010  0x32   50  2  
  5997	:  1100_0000  0xC0  192    
  5998	:  0000_1100  0x0C   12    
  5999	:  0000_0000  0x00    0    
  6000	:  0000_0001  0x01    1    
  6001	:  0000_0000  0x00    0    
  6002	:  0000_0001  0x01    1    
  6003	:  0000_0000  0x00    0    
  6004	:  0000_0000  0x00    0    
  6005	:  0010_1010  0x2A   42  *  
  6006	:  0011_0000  0x30   48  0  
  6007	:  0000_0000  0x00    0    
  6008	:  0000_0100  0x04    4    
  6009	:  0010_1101  0x2D   45  -  
  6010	:  0100_0011  0x43   67  C  
  6011	:  0011_0010  0x32   50  2  
  6012	:  1110_1000  0xE8  232    
  6013	:  0000_1000  0x08    8    
  6014	:  0100_0001  0x41   65  A  
  6015	:  0010_1101  0x2D   45  -  
  6016	:  0011_0101  0x35   53  5  
  6017	:  0011_0000  0x30   48  0  
  6018	:  0010_1101  0x2D   45  -  
  6019	:  0011_0010  0x32   50  2  
  6020	:  0011_0011  0x33   51  3  
  6021	:  0011_0011  0x33   51  3  
  6022	:  1100_0000  0xC0  192    
  6023	:  0000_1100  0x0C   12    
  6024	:  0000_0000  0x00    0    
  6025	:  0000_0001  0x01    1    
  6026	:  0000_0000  0x00    0    
  6027	:  0000_0001  0x01    1    
  6028	:  0000_0000  0x00    0    
  6029	:  0000_0000  0x00    0    
  6030	:  0010_1010  0x2A   42  *  
  6031	:  0011_0000  0x30   48  0  
  6032	:  0000_0000  0x00    0    
  6033	:  0000_0100  0x04    4    
  6034	:  0010_1101  0x2D   45  -  
  6035	:  0100_0011  0x43   67  C  
  6036	:  0011_0010  0x32   50  2  
  6037	:  1110_1001  0xE9  233    
  6038	:  0000_1000  0x08    8    
  6039	:  0100_0001  0x41   65  A  
  6040	:  0010_1101  0x2D   45  -  
  6041	:  0011_0101  0x35   53  5  
  6042	:  0011_0000  0x30   48  0  
  6043	:  0010_1101  0x2D   45  -  
  6044	:  0011_0010  0x32   50  2  
  6045	:  0011_0011  0x33   51  3  
  6046	:  0011_0100  0x34   52  4  
  6047	:  1100_0000  0xC0  192    
  6048	:  0000_1100  0x0C   12    
  6049	:  0000_0000  0x00    0    
  6050	:  0000_0001  0x01    1    
  6051	:  0000_0000  0x00    0    
  6052	:  0000_0001  0x01    1    
  6053	:  0000_0000  0x00    0    
  6054	:  0000_0000  0x00    0    
  6055	:  0010_1010  0x2A   42  *  
  6056	:  0011_0000  0x30   48  0  
  6057	:  0000_0000  0x00    0    
  6058	:  0000_0100  0x04    4    
  6059	:  0010_1101  0x2D   45  -  
  6060	:  0100_0011  0x43   67  C  
  6061	:  0011_0010  0x32   50  2  
  6062	:  1110_1010  0xEA  234    
  6063	:  0000_1000  0x08    8    
  6064	:  0100_0001  0x41   65  A  
  6065	:  0010_1101  0x2D   45  -  
  6066	:  0011_0101  0x35   53  5  
  6067	:  0011_0000  0x30   48  0  
  6068	:  0010_1101  0x2D   45  -  
  6069	:  0011_0010  0x32   50  2  
  6070	:  0011_0011  0x33   51  3  
  6071	:  0011_0101  0x35   53  5  
  6072	:  1100_0000  0xC0  192    
  6073	:  0000_1100  0x0C   12    
  6074	:  0000_0000  0x00    0    
  6075	:  0000_0001  0x01    1    
  6076	:  0000_0000  0x00    0    
  6077	:  0000_0001  0x01    1    
  6078	:  0000_0000  0x00    0    
  6079	:  0000_0000  0x00    0    
  6080	:  0010_1010  0x2A   42  *  
  6081	:  0011_0000  0x30   48  0  
  6082	:  0000_0000  0x00    0    
  6083	:  0000_0100  0x04    4    
  6084	:  0010_1101  0x2D   45  -  
  6085	:  0100_0011  0x43   67  C  
  6086	:  0011_0010  0x32   50  2  
  6087	:  1110_1011  0xEB  235    
  6088	:  0000_1000  0x08    8    
  6089	:  0100_0001  0x41   65  A  
  6090	:  0010_1101  0x2D   45  -  
  6091	:  0011_0101  0x35   53  5  
  6092	:  0011_0000  0x30   48  0  
  6093	:  0010_1101  0x2D   45  -  
  6094	:  0011_0010  0x32   50  2  
  6095	:  0011_0011  0x33   51  3  
  6096	:  0011_0110  0x36   54  6  
  6097	:  1100_0000  0xC0  192    
  6098	:  0000_1100  0x0C   12    
  6099	:  0000_0000  0x00    0    
  6100	:  0000_0001  0x01    1    
  6101	:  0000_0000  0x00    0    
  6102	:  0000_0001  0x01    1    
  6103	:  0000_0000  0x00    0    
  6104	:  0000_0000  0x00    0    
  6105	:  0010_1010  0x2A   42  *  
  6106	:  0011_0000  0x30   48  0  
  6107	:  0000_0000  0x00    0    
  6108	:  0000_0100  0x04    4    
  6109	:  0010_1101  0x2D   45  -  
  6110	:  0100_0011  0x43   67  C  
  6111	:  0011_0010  0x32   50  2  
  6112	:  1110_1100  0xEC  236    
  6113	:  0000_1000  0x08    8    
  6114	:  0100_0001  0x41   65  A  
  6115	:  0010_1101  0x2D   45  -  
  6116	:  0011_0101  0x35   53  5  
  6117	:  0011_0000  0x30   48  0  
  6118	:  0010_1101  0x2D   45  -  
  6119	:  0011_0010  0x32   50  2  
  6120	:  0011_0011  0x33   51  3  
  6121	:  0011_0111  0x37   55  7  
  6122	:  1100_0000  0xC0  192    
  6123	:  0000_1100  0x0C   12    
  6124	:  0000_0000  0x00    0    
  6125	:  0000_0001  0x01    1    
  6126	:  0000_0000  0x00    0    
  6127	:  0000_0001  0x01    1    
  6128	:  0000_0000  0x00    0    
  6129	:  0000_0000  0x00    0    
  6130	:  0010_1010  0x2A   42  *  
  6131	:  0011_0000  0x30   48  0  
  6132	:  0000_0000  0x00    0    
  6133	:  0000_0100  0x04    4    
  6134	:  0010_1101  0x2D   45  -  
  6135	:  0100_0011  0x43   67  C  
  6136	:  0011_0010  0x32   50  2  
  6137	:  1110_1101  0xED  237    
  6138	:  0000_1000  0x08    8    
  6139	:  0100_0001  0x41   65  A  
  6140	:  0010_1101  0x2D   45  -  
  6141	:  0011_0101  0x35   53  5  
  6142	:  0011_0000  0x30   48  0  
  6143	:  0010_1101  0x2D   45  -  
  6144	:  0011_0010  0x32   50  2  
  6145	:  0011_0011  0x33   51  3  
  6146	:  0011_1000  0x38   56  8  
  6147	:  1100_0000  0xC0  192    
  6148	:  0000_1100  0x0C   12    
  6149	:  0000_0000  0x00    0    
  6150	:  0000_0001  0x01    1    
  6151	:  0000_0000  0x00    0    
  6152	:  0000_0001  0x01    1    
  6153	:  0000_0000  0x00    0    
  6154	:  0000_0000  0x00    0    
  6155	:  0010_1010  0x2A   42  *  
  6156	:  0011_0000  0x30   48  0  
  6157	:  0000_0000  0x00    0    
  6158	:  0000_0100  0x04    4    
  6159	:  0010_1101  0x2D   45  -  
  6160	:  0100_0011  0x43   67  C  
  6161	:  0011_0010  0x32   50  2  
  6162	:  1110_1110  0xEE  238    
  6163	:  0000_1000  0x08    8    
  6164	:  0100_0001  0x41   65  A  
  6165	:  0010_1101  0x2D   45  -  
  6166	:  0011_0101  0x35   53  5  
  6167	:  0011_0000  0x30   48  0  
  6168	:  0010_1101  0x2D   45  -  
  6169	:  0011_0010  0x32   50  2  
  6170	:  0011_0011  0x33   51  3  
  6171	:  0011_1001  0x39   57  9  
  6172	:  1100_0000  0xC0  192    
  6173	:  0000_1100  0x0C   12    
  6174	:  0000_0000  0x00    0    
  6175	:  0000_0001  0x01    1    
  6176	:  0000_0000  0x00    0    
  6177	:  0000_0001  0x01    1    
  6178	:  0000_0000  0x00    0    
  6179	:  0000_0000  0x00    0    
  6180	:  0010_1010  0x2A   42  *  
  6181	:  0011_0000  0x30   48  0  
  6182	:  0000_0000  0x00    0    
  6183	:  0000_0100  0x04    4    
  6184	:  0010_1101  0x2D   45  -  
  6185	:  0100_0011  0x43   67  C  
  6186	:  0011_0010  0x32   50  2  
  6187	:  1110_1111  0xEF  239    
  6188	:  0000_1000  0x08    8    
  6189	:  0100_0001  0x41   65  A  
  6190	:  0010_1101  0x2D   45  -  
  6191	:  0011_0101  0x35   53  5  
  6192	:  0011_0000  0x30   48  0  
  6193	:  0010_1101  0x2D   45  -  
  6194	:  0011_0010  0x32   50  2  
  6195	:  0011_0100  0x34   52  4  
  6196	:  0011_0000  0x30   48  0  
  6197	:  1100_0000  0xC0  192    
  6198	:  0000_1100  0x0C   12    
  6199	:  0000_0000  0x00    0    
  6200	:  0000_0001  0x01    1    
  6201	:  0000_0000  0x00    0    
  6202	:  0000_0001  0x01    1    
  6203	:  0000_0000  0x00    0    
  6204	:  0000_0000  0x00    0    
  6205	:  0010_1010  0x2A   42  *  
  6206	:  0011_0000  0x30   48  0  
  6207	:  0000_0000  0x00    0    
  6208	:  0000_0100  0x04    4    
  6209	:  0010_1101  0x2D   45  -  
  6210	:  0100_0011  0x43   67  C  
  6211	:  0011_0010  0x32   50  2  
  6212	:  1111_0000  0xF0  240    
  6213	:  0000_1000  0x08    8    
  6214	:  0100_0001  0x41   65  A  
  6215	:  0010_1101  0x2D   45  -  
  6216	:  0011_0101  0x35   53  5  
  6217	:  0011_0000  0x30   48  0  
  6218	:  0010_1101  0x2D   45  -  
  6219	:  0011_0010  0x32   50  2  
  6220	:  0011_0100  0x34   52  4  
  6221	:  0011_0001  0x31   49  1  
  6222	:  1100_0000  0xC0  192    
  6223	:  0000_1100  0x0C   12    
  6224	:  0000_0000  0x00    0    
  6225	:  0000_0001  0x01    1    
  6226	:  0000_0000  0x00    0    
  6227	:  0000_0001  0x01    1    
  6228	:  0000_0000  0x00    0    
  6229	:  0000_0000  0x00    0    
  6230	:  0010_1010  0x2A   42  *  
  6231	:  0011_0000  0x30   48  0  
  6232	:  0000_0000  0x00    0    
  6233	:  0000_0100  0x04    4    
  6234	:  0010_1101  0x2D   45  -  
  6235	:  0100_0011  0x43   67  C  
  6236	:  0011_0010  0x32   50  2  
  6237	:  1111_0001  0xF1  241    
  6238	:  0000_1000  0x08    8    
  6239	:  0100_0001  0x41   65  A  
  6240	:  0010_1101  0x2D   45  -  
  6241	:  0011_0101  0x35   53  5  
  6242	:  0011_0000  0x30   48  0  
  6243	:  0010_1101  0x2D   45  -  
  6244	:  0011_0010  0x32   50  2  
  6245	:  0011_0100  0x34   52  4  
  6246	:  0011_0010  0x32   50  2  
  6247	:  1100_0000  0xC0  192    
  6248	:  0000_1100  0x0C   12    
  6249	:  0000_0000  0x00    0    
  6250	:  0000_0001  0x01    1    
  6251	:  0000_0000  0x00    0    
  6252	:  0000_0001  0x01    1    
  6253	:  0000_0000  0x00    0    
  6254	:  0000_0000  0x00    0    
  6255	:  0010_1010  0x2A   42  *  
  6256	:  0011_0000  0x30   48  0  
  6257	:  0000_0000  0x00    0    
  6258	:  0000_0100  0x04    4    
  6259	:  0010_1101  0x2D   45  -  
  6260	:  0100_0011  0x43   67  C  
  6261	:  0011_0010  0x32   50  2  
  6262	:  1111_0010  0xF2  242    
  6263	:  0000_1000  0x08    8    
  6264	:  0100_0001  0x41   65  A  
  6265	:  0010_1101  0x2D   45  -  
  6266	:  0011_0101  0x35   53  5  
  6267	:  0011_0000  0x30   48  0  
  6268	:  0010_1101  0x2D   45  -  
  6269	:  0011_0010  0x32   50  2  
  6270	:  0011_0100  0x34   52  4  
  6271	:  0011_0011  0x33   51  3  
  6272	:  1100_0000  0xC0  192    
  6273	:  0000_1100  0x0C   12    
  6274	:  0000_0000  0x00    0    
  6275	:  0000_0001  0x01    1    
  6276	:  0000_0000  0x00    0    
  6277	:  0000_0001  0x01    1    
  6278	:  0000_0000  0x00    0    
  6279	:  0000_0000  0x00    0    
  6280	:  0010_1010  0x2A   42  *  
  6281	:  0011_0000  0x30   48  0  
  6282	:  0000_0000  0x00    0    
  6283	:  0000_0100  0x04    4    
  6284	:  0010_1101  0x2D   45  -  
  6285	:  0100_0011  0x43   67  C  
  6286	:  0011_0010  0x32   50  2  
  6287	:  1111_0011  0xF3  243    
  6288	:  0000_1000  0x08    8    
  6289	:  0100_0001  0x41   65  A  
  6290	:  0010_1101  0x2D   45  -  
  6291	:  0011_0101  0x35   53  5  
  6292	:  0011_0000  0x30   48  0  
  6293	:  0010_1101  0x2D   45  -  
  6294	:  0011_0010  0x32   50  2  
  6295	:  0011_0100  0x34   52  4  
  6296	:  0011_0100  0x34   52  4  
  6297	:  1100_0000  0xC0  192    
  6298	:  0000_1100  0x0C   12    
  6299	:  0000_0000  0x00    0    
  6300	:  0000_0001  0x01    1    
  6301	:  0000_0000  0x00    0    
  6302	:  0000_0001  0x01    1    
  6303	:  0000_0000  0x00    0    
  6304	:  0000_0000  0x00    0    
  6305	:  0010_1010  0x2A   42  *  
  6306	:  0011_0000  0x30   48  0  
  6307	:  0000_0000  0x00    0    
  6308	:  0000_0100  0x04    4    
  6309	:  0010_1101  0x2D   45  -  
  6310	:  0100_0011  0x43   67  C  
  6311	:  0011_0010  0x32   50  2  
  6312	:  1111_0100  0xF4  244    
  6313	:  0000_1000  0x08    8    
  6314	:  0100_0001  0x41   65  A  
  6315	:  0010_1101  0x2D   45  -  
  6316	:  0011_0101  0x35   53  5  
  6317	:  0011_0000  0x30   48  0  
  6318	:  0010_1101  0x2D   45  -  
  6319	:  0011_0010  0x32   50  2  
  6320	:  0011_0100  0x34   52  4  
  6321	:  0011_0101  0x35   53  5  
  6322	:  1100_0000  0xC0  192    
  6323	:  0000_1100  0x0C   12    
  6324	:  0000_0000  0x00    0    
  6325	:  0000_0001  0x01    1    
  6326	:  0000_0000  0x00    0    
  6327	:  0000_0001  0x01    1    
  6328	:  0000_0000  0x00    0    
  6329	:  0000_0000  0x00    0    
  6330	:  0010_1010  0x2A   42  *  
  6331	:  0011_0000  0x30   48  0  
  6332	:  0000_0000  0x00    0    
  6333	:  0000_0100  0x04    4    
  6334	:  0010_1101  0x2D   45  -  
  6335	:  0100_0011  0x43   67  C  
  6336	:  0011_0010  0x32   50  2  
  6337	:  1111_0101  0xF5  245    
  6338	:  0000_1000  0x08    8    
  6339	:  0100_0001  0x41   65  A  
  6340	:  0010_1101  0x2D   45  -  
  6341	:  0011_0101  0x35   53  5  
  6342	:  0011_0000  0x30   48  0  
  6343	:  0010_1101  0x2D   45  -  
  6344	:  0011_0010  0x32   50  2  
  6345	:  0011_0100  0x34   52  4  
  6346	:  0011_0110  0x36   54  6  
  6347	:  1100_0000  0xC0  192    
  6348	:  0000_1100  0x0C   12    
  6349	:  0000_0000  0x00    0    
  6350	:  0000_0001  0x01    1    
  6351	:  0000_0000  0x00    0    
  6352	:  0000_0001  0x01    1    
  6353	:  0000_0000  0x00    0    
  6354	:  0000_0000  0x00    0    
  6355	:  0010_1010  0x2A   42  *  
  6356	:  0011_0000  0x30   48  0  
  6357	:  0000_0000  0x00    0    
  6358	:  0000_0100  0x04    4    
  6359	:  0010_1101  0x2D   45  -  
  6360	:  0100_0011  0x43   67  C  
  6361	:  0011_0010  0x32   50  2  
  6362	:  1111_0110  0xF6  246    
  6363	:  0000_1000  0x08    8    
  6364	:  0100_0001  0x41   65  A  
  6365	:  0010_1101  0x2D   45  -  
  6366	:  0011_0101  0x35   53  5  
  6367	:  0011_0000  0x30   48  0  
  6368	:  0010_1101  0x2D   45  -  
  6369	:  0011_0010  0x32   50  2  
  6370	:  0011_0100  0x34   52  4  
  6371	:  0011_0111  0x37   55  7  
  6372	:  1100_0000  0xC0  192    
  6373	:  0000_1100  0x0C   12    
  6374	:  0000_0000  0x00    0    
  6375	:  0000_0001  0x01    1    
  6376	:  0000_0000  0x00    0    
  6377	:  0000_0001  0x01    1    
  6378	:  0000_0000  0x00    0    
  6379	:  0000_0000  0x00    0    
  6380	:  0010_1010  0x2A   42  *  
  6381	:  0011_0000  0x30   48  0  
  6382	:  0000_0000  0x00    0    
  6383	:  0000_0100  0x04    4    
  6384	:  0010_1101  0x2D   45  -  
  6385	:  0100_0011  0x43   67  C  
  6386	:  0011_0010  0x32   50  2  
  6387	:  1111_0111  0xF7  247    
  6388	:  0000_1000  0x08    8    
  6389	:  0100_0001  0x41   65  A  
  6390	:  0010_1101  0x2D   45  -  
  6391	:  0011_0101  0x35   53  5  
  6392	:  0011_0000  0x30   48  0  
  6393	:  0010_1101  0x2D   45  -  
  6394	:  0011_0010  0x32   50  2  
  6395	:  0011_0100  0x34   52  4  
  6396	:  0011_1000  0x38   56  8  
  6397	:  1100_0000  0xC0  192    
  6398	:  0000_1100  0x0C   12    
  6399	:  0000_0000  0x00    0    
  6400	:  0000_0001  0x01    1    
  6401	:  0000_0000  0x00    0    
  6402	:  0000_0001  0x01    1    
  6403	:  0000_0000  0x00    0    
  6404	:  0000_0000  0x00    0    
  6405	:  0010_1010  0x2A   42  *  
  6406	:  0011_0000  0x30   48  0  
  6407	:  0000_0000  0x00    0    
  6408	:  0000_0100  0x04    4    
  6409	:  0010_1101  0x2D   45  -  
  6410	:  0100_0011  0x43   67  C  
  6411	:  0011_0010  0x32   50  2  
  6412	:  1111_1000  0xF8  248    
  6413	:  0000_1000  0x08    8    
  6414	:  0100_0001  0x41   65  A  
  6415	:  0010_1101  0x2D   45  -  
  6416	:  0011_0101  0x35   53  5  
  6417	:  0011_0000  0x30   48  0  
  6418	:  0010_1101  0x2D   45  -  
  6419	:  0011_0010  0x32   50  2  
  6420	:  0011_0100  0x34   52  4  
  6421	:  0011_1001  0x39   57  9  
  6422	:  1100_0000  0xC0  192    
  6423	:  0000_1100  0x0C   12    
  6424	:  0000_0000  0x00    0    
  6425	:  0000_0001  0x01    1    
  6426	:  0000_0000  0x00    0    
  6427	:  0000_0001  0x01    1    
  6428	:  0000_0000  0x00    0    
  6429	:  0000_0000  0x00    0    
  6430	:  0010_1010  0x2A   42  *  
  6431	:  0011_0000  0x30   48  0  
  6432	:  0000_0000  0x00    0    
  6433	:  0000_0100  0x04    4    
  6434	:  0010_1101  0x2D   45  -  
  6435	:  0100_0011  0x43   67  C  
  6436	:  0011_0010  0x32   50  2  
  6437	:  1111_1001  0xF9  249    
  6438	:  0000_1000  0x08    8    
  6439	:  0100_0001  0x41   65  A  
  6440	:  0010_1101  0x2D   45  -  
  6441	:  0011_0101  0x35   53  5  
  6442	:  0011_0000  0x30   48  0  
  6443	:  0010_1101  0x2D   45  -  
  6444	:  0011_0010  0x32   50  2  
  6445	:  0011_0101  0x35   53  5  
  6446	:  0011_0000  0x30   48  0  
  6447	:  1100_0000  0xC0  192    
  6448	:  0000_1100  0x0C   12    
  6449	:  0000_0000  0x00    0    
  6450	:  0000_0001  0x01    1    
  6451	:  0000_0000  0x00    0    
  6452	:  0000_0001  0x01    1    
  6453	:  0000_0000  0x00    0    
  6454	:  0000_0000  0x00    0    
  6455	:  0010_1010  0x2A   42  *  
  6456	:  0011_0000  0x30   48  0  
  6457	:  0000_0000  0x00    0    
  6458	:  0000_0100  0x04    4    
  6459	:  0010_1101  0x2D   45  -  
  6460	:  0100_0011  0x43   67  C  
  6461	:  0011_0010  0x32   50  2  
  6462	:  1111_1010  0xFA  250    
  6463	:  0000_1000  0x08    8    
  6464	:  0100_0001  0x41   65  A  
  6465	:  0010_1101  0x2D   45  -  
  6466	:  0011_0101  0x35   53  5  
  6467	:  0011_0000  0x30   48  0  
  6468	:  0010_1101  0x2D   45  -  
  6469	:  0011_0010  0x32   50  2  
  6470	:  0011_0101  0x35   53  5  
  6471	:  0011_0001  0x31   49  1  
  6472	:  1100_0000  0xC0  192    
  6473	:  0000_1100  0x0C   12    
  6474	:  0000_0000  0x00    0    
  6475	:  0000_0001  0x01    1    
  6476	:  0000_0000  0x00    0    
  6477	:  0000_0001  0x01    1    
  6478	:  0000_0000  0x00    0    
  6479	:  0000_0000  0x00    0    
  6480	:  0010_1010  0x2A   42  *  
  6481	:  0011_0000  0x30   48  0  
  6482	:  0000_0000  0x00    0    
  6483	:  0000_0100  0x04    4    
  6484	:  0010_1101  0x2D   45  -  
  6485	:  0100_0011  0x43   67  C  
  6486	:  0011_0010  0x32   50  2  
  6487	:  1111_1011  0xFB  251    
  6488	:  0000_1000  0x08    8    
  6489	:  0100_0001  0x41   65  A  
  6490	:  0010_1101  0x2D   45  -  
  6491	:  0011_0101  0x35   53  5  
  6492	:  0011_0000  0x30   48  0  
  6493	:  0010_1101  0x2D   45  -  
  6494	:  0011_0010  0x32   50  2  
  6495	:  0011_0101  0x35   53  5  
  6496	:  0011_0010  0x32   50  2  
  6497	:  1100_0000  0xC0  192    
  6498	:  0000_1100  0x0C   12    
  6499	:  0000_0000  0x00    0    
  6500	:  0000_0001  0x01    1    
  6501	:  0000_0000  0x00    0    
  6502	:  0000_0001  0x01    1    
  6503	:  0000_0000  0x00    0    
  6504	:  0000_0000  0x00    0    
  6505	:  0010_1010  0x2A   42  *  
  6506	:  0011_0000  0x30   48  0  
  6507	:  0000_0000  0x00    0    
  6508	:  0000_0100  0x04    4    
  6509	:  0010_1101  0x2D   45  -  
  6510	:  0100_0011  0x43   67  C  
  6511	:  0011_0010  0x32   50  2  
  6512	:  1111_1100  0xFC  252    
  6513	:  0000_1000  0x08    8    
  6514	:  0100_0001  0x41   65  A  
  6515	:  0010_1101  0x2D   45  -  
  6516	:  0011_0101  0x35   53  5  
  6517	:  0011_0000  0x30   48  0  
  6518	:  0010_1101  0x2D   45  -  
  6519	:  0011_0010  0x32   50  2  
  6520	:  0011_0101  0x35   53  5  
  6521	:  0011_0011  0x33   51  3  
  6522	:  1100_0000  0xC0  192    
  6523	:  0000_1100  0x0C   12    
  6524	:  0000_0000  0x00    0    
  6525	:  0000_0001  0x01    1    
  6526	:  0000_0000  0x00    0    
  6527	:  0000_0001  0x01    1    
  6528	:  0000_0000  0x00    0    
  6529	:  0000_0000  0x00    0    
  6530	:  0010_1010  0x2A   42  *  
  6531	:  0011_0000  0x30   48  0  
  6532	:  0000_0000  0x00    0    
  6533	:  0000_0100  0x04    4    
  6534	:  0010_1101  0x2D   45  -  
  6535	:  0100_0011  0x43   67  C  
  6536	:  0011_0010  0x32   50  2  
  6537	:  1111_1101  0xFD  253    
  6538	:  0000_1000  0x08    8    
  6539	:  0100_0001  0x41   65  A  
  6540	:  0010_1101  0x2D   45  -  
  6541	:  0011_0101  0x35   53  5  
  6542	:  0011_0000  0x30   48  0  
  6543	:  0010_1101  0x2D   45  -  
  6544	:  0011_0010  0x32   50  2  
  6545	:  0011_0101  0x35   53  5  
  6546	:  0011_0100  0x34   52  4  
  6547	:  1100_0000  0xC0  192    
  6548	:  0000_1100  0x0C   12    
  6549	:  0000_0000  0x00    0    
  6550	:  0000_0001  0x01    1    
  6551	:  0000_0000  0x00    0    
  6552	:  0000_0001  0x01    1    
  6553	:  0000_0000  0x00    0    
  6554	:  0000_0000  0x00    0    
  6555	:  0010_1010  0x2A   42  *  
  6556	:  0011_0000  0x30   48  0  
  6557	:  0000_0000  0x00    0    
  6558	:  0000_0100  0x04    4    
  6559	:  0010_1101  0x2D   45  -  
  6560	:  0100_0011  0x43   67  C  
  6561	:  0011_0010  0x32   50  2  
  6562	:  1111_1110  0xFE  254    
  6563	:  0000_1000  0x08    8    
  6564	:  0100_0001  0x41   65  A  
  6565	:  0010_1101  0x2D   45  -  
  6566	:  0011_0101  0x35   53  5  
  6567	:  0011_0001  0x31   49  1  
  6568	:  0010_1101  0x2D   45  -  
  6569	:  0011_0000  0x30   48  0  
  6570	:  0011_0000  0x30   48  0  
  6571	:  0011_0001  0x31   49  1  
  6572	:  1100_0000  0xC0  192    
  6573	:  0000_1100  0x0C   12    
  6574	:  0000_0000  0x00    0    
  6575	:  0000_0001  0x01    1    
  6576	:  0000_0000  0x00    0    
  6577	:  0000_0001  0x01    1    
  6578	:  0000_0000  0x00    0    
  6579	:  0000_0000  0x00    0    
  6580	:  0010_1010  0x2A   42  *  
  6581	:  0011_0000  0x30   48  0  
  6582	:  0000_0000  0x00    0    
  6583	:  0000_0100  0x04    4    
  6584	:  0010_1101  0x2D   45  -  
  6585	:  0100_0011  0x43   67  C  
  6586	:  0011_0011  0x33   51  3  
  6587	:  0000_0001  0x01    1    
  6588	:  0000_1000  0x08    8    
  6589	:  0100_0001  0x41   65  A  
  6590	:  0010_1101  0x2D   45  -  
  6591	:  0011_0101  0x35   53  5  
  6592	:  0011_0001  0x31   49  1  
  6593	:  0010_1101  0x2D   45  -  
  6594	:  0011_0000  0x30   48  0  
  6595	:  0011_0000  0x30   48  0  
  6596	:  0011_0010  0x32   50  2  
  6597	:  1100_0000  0xC0  192    
  6598	:  0000_1100  0x0C   12    
  6599	:  0000_0000  0x00    0    
  6600	:  0000_0001  0x01    1    
  6601	:  0000_0000  0x00    0    
  6602	:  0000_0001  0x01    1    
  6603	:  0000_0000  0x00    0    
  6604	:  0000_0000  0x00    0    
  6605	:  0010_1010  0x2A   42  *  
  6606	:  0011_0000  0x30   48  0  
  6607	:  0000_0000  0x00    0    
  6608	:  0000_0100  0x04    4    
  6609	:  0010_1101  0x2D   45  -  
  6610	:  0100_0011  0x43   67  C  
  6611	:  0011_0011  0x33   51  3  
  6612	:  0000_0010  0x02    2    
  6613	:  0000_1000  0x08    8    
  6614	:  0100_0001  0x41   65  A  
  6615	:  0010_1101  0x2D   45  -  
  6616	:  0011_0101  0x35   53  5  
  6617	:  0011_0001  0x31   49  1  
  6618	:  0010_1101  0x2D   45  -  
  6619	:  0011_0000  0x30   48  0  
  6620	:  0011_0000  0x30   48  0  
  6621	:  0011_0011  0x33   51  3  
  6622	:  1100_0000  0xC0  192    
  6623	:  0000_1100  0x0C   12    
  6624	:  0000_0000  0x00    0    
  6625	:  0000_0001  0x01    1    
  6626	:  0000_0000  0x00    0    
  6627	:  0000_0001  0x01    1    
  6628	:  0000_0000  0x00    0    
  6629	:  0000_0000  0x00    0    
  6630	:  0010_1010  0x2A   42  *  
  6631	:  0011_0000  0x30   48  0  
  6632	:  0000_0000  0x00    0    
  6633	:  0000_0100  0x04    4    
  6634	:  0010_1101  0x2D   45  -  
  6635	:  0100_0011  0x43   67  C  
  6636	:  0011_0011  0x33   51  3  
  6637	:  0000_0011  0x03    3    
  6638	:  0000_1000  0x08    8    
  6639	:  0100_0001  0x41   65  A  
  6640	:  0010_1101  0x2D   45  -  
  6641	:  0011_0101  0x35   53  5  
  6642	:  0011_0001  0x31   49  1  
  6643	:  0010_1101  0x2D   45  -  
  6644	:  0011_0000  0x30   48  0  
  6645	:  0011_0000  0x30   48  0  
  6646	:  0011_0100  0x34   52  4  
  6647	:  1100_0000  0xC0  192    
  6648	:  0000_1100  0x0C   12    
  6649	:  0000_0000  0x00    0    
  6650	:  0000_0001  0x01    1    
  6651	:  0000_0000  0x00    0    
  6652	:  0000_0001  0x01    1    
  6653	:  0000_0000  0x00    0    
  6654	:  0000_0000  0x00    0    
  6655	:  0010_1010  0x2A   42  *  
  6656	:  0011_0000  0x30   48  0  
  6657	:  0000_0000  0x00    0    
  6658	:  0000_0100  0x04    4    
  6659	:  0010_1101  0x2D   45  -  
  6660	:  0100_0011  0x43   67  C  
  6661	:  0011_0011  0x33   51  3  
  6662	:  0000_0100  0x04    4    
  6663	:  0000_1000  0x08    8    
  6664	:  0100_0001  0x41   65  A  
  6665	:  0010_1101  0x2D   45  -  
  6666	:  0011_0101  0x35   53  5  
  6667	:  0011_0001  0x31   49  1  
  6668	:  0010_1101  0x2D   45  -  
  6669	:  0011_0000  0x30   48  0  
  6670	:  0011_0000  0x30   48  0  
  6671	:  0011_0101  0x35   53  5  
  6672	:  1100_0000  0xC0  192    
  6673	:  0000_1100  0x0C   12    
  6674	:  0000_0000  0x00    0    
  6675	:  0000_0001  0x01    1    
  6676	:  0000_0000  0x00    0    
  6677	:  0000_0001  0x01    1    
  6678	:  0000_0000  0x00    0    
  6679	:  0000_0000  0x00    0    
  6680	:  0010_1010  0x2A   42  *  
  6681	:  0011_0000  0x30   48  0  
  6682	:  0000_0000  0x00    0    
  6683	:  0000_0100  0x04    4    
  6684	:  0010_1101  0x2D   45  -  
  6685	:  0100_0011  0x43   67  C  
  6686	:  0011_0011  0x33   51  3  
  6687	:  0000_0101  0x05    5    
  6688	:  0000_1000  0x08    8    
  6689	:  0100_0001  0x41   65  A  
  6690	:  0010_1101  0x2D   45  -  
  6691	:  0011_0101  0x35   53  5  
  6692	:  0011_0001  0x31   49  1  
  6693	:  0010_1101  0x2D   45  -  
  6694	:  0011_0000  0x30   48  0  
  6695	:  0011_0000  0x30   48  0  
  6696	:  0011_0110  0x36   54  6  
  6697	:  1100_0000  0xC0  192    
  6698	:  0000_1100  0x0C   12    
  6699	:  0000_0000  0x00    0    
  6700	:  0000_0001  0x01    1    
  6701	:  0000_0000  0x00    0    
  6702	:  0000_0001  0x01    1    
  6703	:  0000_0000  0x00    0    
  6704	:  0000_0000  0x00    0    
  6705	:  0010_1010  0x2A   42  *  
  6706	:  0011_0000  0x30   48  0  
  6707	:  0000_0000  0x00    0    
  6708	:  0000_0100  0x04    4    
  6709	:  0010_1101  0x2D   45  -  
  6710	:  0100_0011  0x43   67  C  
  6711	:  0011_0011  0x33   51  3  
  6712	:  0000_0110  0x06    6    
  6713	:  0000_1000  0x08    8    
  6714	:  0100_0001  0x41   65  A  
  6715	:  0010_1101  0x2D   45  -  
  6716	:  0011_0101  0x35   53  5  
  6717	:  0011_0001  0x31   49  1  
  6718	:  0010_1101  0x2D   45  -  
  6719	:  0011_0000  0x30   48  0  
  6720	:  0011_0000  0x30   48  0  
  6721	:  0011_0111  0x37   55  7  
  6722	:  1100_0000  0xC0  192    
  6723	:  0000_1100  0x0C   12    
  6724	:  0000_0000  0x00    0    
  6725	:  0000_0001  0x01    1    
  6726	:  0000_0000  0x00    0    
  6727	:  0000_0001  0x01    1    
  6728	:  0000_0000  0x00    0    
  6729	:  0000_0000  0x00    0    
  6730	:  0010_1010  0x2A   42  *  
  6731	:  0011_0000  0x30   48  0  
  6732	:  0000_0000  0x00    0    
  6733	:  0000_0100  0x04    4    
  6734	:  0010_1101  0x2D   45  -  
  6735	:  0100_0011  0x43   67  C  
  6736	:  0011_0011  0x33   51  3  
  6737	:  0000_0111  0x07    7    
  6738	:  0000_1000  0x08    8    
  6739	:  0100_0001  0x41   65  A  
  6740	:  0010_1101  0x2D   45  -  
  6741	:  0011_0101  0x35   53  5  
  6742	:  0011_0001  0x31   49  1  
  6743	:  0010_1101  0x2D   45  -  
  6744	:  0011_0000  0x30   48  0  
  6745	:  0011_0000  0x30   48  0  
  6746	:  0011_1000  0x38   56  8  
  6747	:  1100_0000  0xC0  192    
  6748	:  0000_1100  0x0C   12    
  6749	:  0000_0000  0x00    0    
  6750	:  0000_0001  0x01    1    
  6751	:  0000_0000  0x00    0    
  6752	:  0000_0001  0x01    1    
  6753	:  0000_0000  0x00    0    
  6754	:  0000_0000  0x00    0    
  6755	:  0010_1010  0x2A   42  *  
  6756	:  0011_0000  0x30   48  0  
  6757	:  0000_0000  0x00    0    
  6758	:  0000_0100  0x04    4    
  6759	:  0010_1101  0x2D   45  -  
  6760	:  0100_0011  0x43   67  C  
  6761	:  0011_0011  0x33   51  3  
  6762	:  0000_1000  0x08    8    
  6763	:  0000_1000  0x08    8    
  6764	:  0100_0001  0x41   65  A  
  6765	:  0010_1101  0x2D   45  -  
  6766	:  0011_0101  0x35   53  5  
  6767	:  0011_0001  0x31   49  1  
  6768	:  0010_1101  0x2D   45  -  
  6769	:  0011_0000  0x30   48  0  
  6770	:  0011_0000  0x30   48  0  
  6771	:  0011_1001  0x39   57  9  
  6772	:  1100_0000  0xC0  192    
  6773	:  0000_1100  0x0C   12    
  6774	:  0000_0000  0x00    0    
  6775	:  0000_0001  0x01    1    
  6776	:  0000_0000  0x00    0    
  6777	:  0000_0001  0x01    1    
  6778	:  0000_0000  0x00    0    
  6779	:  0000_0000  0x00    0    
  6780	:  0010_1010  0x2A   42  *  
  6781	:  0011_0000  0x30   48  0  
  6782	:  0000_0000  0x00    0    
  6783	:  0000_0100  0x04    4    
  6784	:  0010_1101  0x2D   45  -  
  6785	:  0100_0011  0x43   67  C  
  6786	:  0011_0011  0x33   51  3  
  6787	:  0000_1001  0x09    9    
  6788	:  0000_1000  0x08    8    
  6789	:  0100_0001  0x41   65  A  
  6790	:  0010_1101  0x2D   45  -  
  6791	:  0011_0101  0x35   53  5  
  6792	:  0011_0001  0x31   49  1  
  6793	:  0010_1101  0x2D   45  -  
  6794	:  0011_0000  0x30   48  0  
  6795	:  0011_0001  0x31   49  1  
  6796	:  0011_0000  0x30   48  0  
  6797	:  1100_0000  0xC0  192    
  6798	:  0000_1100  0x0C   12    
  6799	:  0000_0000  0x00    0    
  6800	:  0000_0001  0x01    1    
  6801	:  0000_0000  0x00    0    
  6802	:  0000_0001  0x01    1    
  6803	:  0000_0000  0x00    0    
  6804	:  0000_0000  0x00    0    
  6805	:  0010_1010  0x2A   42  *  
  6806	:  0011_0000  0x30   48  0  
  6807	:  0000_0000  0x00    0    
  6808	:  0000_0100  0x04    4    
  6809	:  0010_1101  0x2D   45  -  
  6810	:  0100_0011  0x43   67  C  
  6811	:  0011_0011  0x33   51  3  
  6812	:  0000_1010  0x0A   10    
  6813	:  0000_1000  0x08    8    
  6814	:  0100_0001  0x41   65  A  
  6815	:  0010_1101  0x2D   45  -  
  6816	:  0011_0101  0x35   53  5  
  6817	:  0011_0001  0x31   49  1  
  6818	:  0010_1101  0x2D   45  -  
  6819	:  0011_0000  0x30   48  0  
  6820	:  0011_0001  0x31   49  1  
  6821	:  0011_0001  0x31   49  1  
  6822	:  1100_0000  0xC0  192    
  6823	:  0000_1100  0x0C   12    
  6824	:  0000_0000  0x00    0    
  6825	:  0000_0001  0x01    1    
  6826	:  0000_0000  0x00    0    
  6827	:  0000_0001  0x01    1    
  6828	:  0000_0000  0x00    0    
  6829	:  0000_0000  0x00    0    
  6830	:  0010_1010  0x2A   42  *  
  6831	:  0011_0000  0x30   48  0  
  6832	:  0000_0000  0x00    0    
  6833	:  0000_0100  0x04    4    
  6834	:  0010_1101  0x2D   45  -  
  6835	:  0100_0011  0x43   67  C  
  6836	:  0011_0011  0x33   51  3  
  6837	:  0000_1011  0x0B   11    
  6838	:  0000_1000  0x08    8    
  6839	:  0100_0001  0x41   65  A  
  6840	:  0010_1101  0x2D   45  -  
  6841	:  0011_0101  0x35   53  5  
  6842	:  0011_0001  0x31   49  1  
  6843	:  0010_1101  0x2D   45  -  
  6844	:  0011_0000  0x30   48  0  
  6845	:  0011_0001  0x31   49  1  
  6846	:  0011_0010  0x32   50  2  
  6847	:  1100_0000  0xC0  192    
  6848	:  0000_1100  0x0C   12    
  6849	:  0000_0000  0x00    0    
  6850	:  0000_0001  0x01    1    
  6851	:  0000_0000  0x00    0    
  6852	:  0000_0001  0x01    1    
  6853	:  0000_0000  0x00    0    
  6854	:  0000_0000  0x00    0    
  6855	:  0010_1010  0x2A   42  *  
  6856	:  0011_0000  0x30   48  0  
  6857	:  0000_0000  0x00    0    
  6858	:  0000_0100  0x04    4    
  6859	:  0010_1101  0x2D   45  -  
  6860	:  0100_0011  0x43   67  C  
  6861	:  0011_0011  0x33   51  3  
  6862	:  0000_1100  0x0C   12    
  6863	:  0000_1000  0x08    8    
  6864	:  0100_0001  0x41   65  A  
  6865	:  0010_1101  0x2D   45  -  
  6866	:  0011_0101  0x35   53  5  
  6867	:  0011_0001  0x31   49  1  
  6868	:  0010_1101  0x2D   45  -  
  6869	:  0011_0000  0x30   48  0  
  6870	:  0011_0001  0x31   49  1  
  6871	:  0011_0011  0x33   51  3  
  6872	:  1100_0000  0xC0  192    
  6873	:  0000_1100  0x0C   12    
  6874	:  0000_0000  0x00    0    
  6875	:  0000_0001  0x01    1    
  6876	:  0000_0000  0x00    0    
  6877	:  0000_0001  0x01    1    
  6878	:  0000_0000  0x00    0    
  6879	:  0000_0000  0x00    0    
  6880	:  0010_1010  0x2A   42  *  
  6881	:  0011_0000  0x30   48  0  
  6882	:  0000_0000  0x00    0    
  6883	:  0000_0100  0x04    4    
  6884	:  0010_1101  0x2D   45  -  
  6885	:  0100_0011  0x43   67  C  
  6886	:  0011_0011  0x33   51  3  
  6887	:  0000_1101  0x0D   13    
  6888	:  0000_1000  0x08    8    
  6889	:  0100_0001  0x41   65  A  
  6890	:  0010_1101  0x2D   45  -  
  6891	:  0011_0101  0x35   53  5  
  6892	:  0011_0001  0x31   49  1  
  6893	:  0010_1101  0x2D   45  -  
  6894	:  0011_0000  0x30   48  0  
  6895	:  0011_0001  0x31   49  1  
  6896	:  0011_0100  0x34   52  4  
  6897	:  1100_0000  0xC0  192    
  6898	:  0000_1100  0x0C   12    
  6899	:  0000_0000  0x00    0    
  6900	:  0000_0001  0x01    1    
  6901	:  0000_0000  0x00    0    
  6902	:  0000_0001  0x01    1    
  6903	:  0000_0000  0x00    0    
  6904	:  0000_0000  0x00    0    
  6905	:  0010_1010  0x2A   42  *  
  6906	:  0011_0000  0x30   48  0  
  6907	:  0000_0000  0x00    0    
  6908	:  0000_0100  0x04    4    
  6909	:  0010_1101  0x2D   45  -  
  6910	:  0100_0011  0x43   67  C  
  6911	:  0011_0011  0x33   51  3  
  6912	:  0000_1110  0x0E   14    
  6913	:  0000_1000  0x08    8    
  6914	:  0100_0001  0x41   65  A  
  6915	:  0010_1101  0x2D   45  -  
  6916	:  0011_0101  0x35   53  5  
  6917	:  0011_0001  0x31   49  1  
  6918	:  0010_1101  0x2D   45  -  
  6919	:  0011_0000  0x30   48  0  
  6920	:  0011_0001  0x31   49  1  
  6921	:  0011_0101  0x35   53  5  
  6922	:  1100_0000  0xC0  192    
  6923	:  0000_1100  0x0C   12    
  6924	:  0000_0000  0x00    0    
  6925	:  0000_0001  0x01    1    
  6926	:  0000_0000  0x00    0    
  6927	:  0000_0001  0x01    1    
  6928	:  0000_0000  0x00    0    
  6929	:  0000_0000  0x00    0    
  6930	:  0010_1010  0x2A   42  *  
  6931	:  0011_0000  0x30   48  0  
  6932	:  0000_0000  0x00    0    
  6933	:  0000_0100  0x04    4    
  6934	:  0010_1101  0x2D   45  -  
  6935	:  0100_0011  0x43   67  C  
  6936	:  0011_0011  0x33   51  3  
  6937	:  0000_1111  0x0F   15    
  6938	:  0000_1000  0x08    8    
  6939	:  0100_0001  0x41   65  A  
  6940	:  0010_1101  0x2D   45  -  
  6941	:  0011_0101  0x35   53  5  
  6942	:  0011_0001  0x31   49  1  
  6943	:  0010_1101  0x2D   45  -  
  6944	:  0011_0000  0x30   48  0  
  6945	:  0011_0001  0x31   49  1  
  6946	:  0011_0110  0x36   54  6  
  6947	:  1100_0000  0xC0  192    
  6948	:  0000_1100  0x0C   12    
  6949	:  0000_0000  0x00    0    
  6950	:  0000_0001  0x01    1    
  6951	:  0000_0000  0x00    0    
  6952	:  0000_0001  0x01    1    
  6953	:  0000_0000  0x00    0    
  6954	:  0000_0000  0x00    0    
  6955	:  0010_1010  0x2A   42  *  
  6956	:  0011_0000  0x30   48  0  
  6957	:  0000_0000  0x00    0    
  6958	:  0000_0100  0x04    4    
  6959	:  0010_1101  0x2D   45  -  
  6960	:  0100_0011  0x43   67  C  
  6961	:  0011_0011  0x33   51  3  
  6962	:  0001_0000  0x10   16    
  6963	:  0000_1000  0x08    8    
  6964	:  0100_0001  0x41   65  A  
  6965	:  0010_1101  0x2D   45  -  
  6966	:  0011_0101  0x35   53  5  
  6967	:  0011_0001  0x31   49  1  
  6968	:  0010_1101  0x2D   45  -  
  6969	:  0011_0000  0x30   48  0  
  6970	:  0011_0001  0x31   49  1  
  6971	:  0011_0111  0x37   55  7  
  6972	:  1100_0000  0xC0  192    
  6973	:  0000_1100  0x0C   12    
  6974	:  0000_0000  0x00    0    
  6975	:  0000_0001  0x01    1    
  6976	:  0000_0000  0x00    0    
  6977	:  0000_0001  0x01    1    
  6978	:  0000_0000  0x00    0    
  6979	:  0000_0000  0x00    0    
  6980	:  0010_1010  0x2A   42  *  
  6981	:  0011_0000  0x30   48  0  
  6982	:  0000_0000  0x00    0    
  6983	:  0000_0100  0x04    4    
  6984	:  0010_1101  0x2D   45  -  
  6985	:  0100_0011  0x43   67  C  
  6986	:  0011_0011  0x33   51  3  
  6987	:  0001_0001  0x11   17    
  6988	:  0000_1000  0x08    8    
  6989	:  0100_0001  0x41   65  A  
  6990	:  0010_1101  0x2D   45  -  
  6991	:  0011_0101  0x35   53  5  
  6992	:  0011_0001  0x31   49  1  
  6993	:  0010_1101  0x2D   45  -  
  6994	:  0011_0000  0x30   48  0  
  6995	:  0011_0001  0x31   49  1  
  6996	:  0011_1000  0x38   56  8  
  6997	:  1100_0000  0xC0  192    
  6998	:  0000_1100  0x0C   12    
  6999	:  0000_0000  0x00    0    
  7000	:  0000_0001  0x01    1    
  7001	:  0000_0000  0x00    0    
  7002	:  0000_0001  0x01    1    
  7003	:  0000_0000  0x00    0    
  7004	:  0000_0000  0x00    0    
  7005	:  0010_1010  0x2A   42  *  
  7006	:  0011_0000  0x30   48  0  
  7007	:  0000_0000  0x00    0    
  7008	:  0000_0100  0x04    4    
  7009	:  0010_1101  0x2D   45  -  
  7010	:  0100_0011  0x43   67  C  
  7011	:  0011_0011  0x33   51  3  
  7012	:  0001_0010  0x12   18    
  7013	:  0000_1000  0x08    8    
  7014	:  0100_0001  0x41   65  A  
  7015	:  0010_1101  0x2D   45  -  
  7016	:  0011_0101  0x35   53  5  
  7017	:  0011_0001  0x31   49  1  
  7018	:  0010_1101  0x2D   45  -  
  7019	:  0011_0000  0x30   48  0  
  7020	:  0011_0001  0x31   49  1  
  7021	:  0011_1001  0x39   57  9  
  7022	:  1100_0000  0xC0  192    
  7023	:  0000_1100  0x0C   12    
  7024	:  0000_0000  0x00    0    
  7025	:  0000_0001  0x01    1    
  7026	:  0000_0000  0x00    0    
  7027	:  0000_0001  0x01    1    
  7028	:  0000_0000  0x00    0    
  7029	:  0000_0000  0x00    0    
  7030	:  0010_1010  0x2A   42  *  
  7031	:  0011_0000  0x30   48  0  
  7032	:  0000_0000  0x00    0    
  7033	:  0000_0100  0x04    4    
  7034	:  0010_1101  0x2D   45  -  
  7035	:  0100_0011  0x43   67  C  
  7036	:  0011_0011  0x33   51  3  
  7037	:  0001_0011  0x13   19    
  7038	:  0000_1000  0x08    8    
  7039	:  0100_0001  0x41   65  A  
  7040	:  0010_1101  0x2D   45  -  
  7041	:  0011_0101  0x35   53  5  
  7042	:  0011_0001  0x31   49  1  
  7043	:  0010_1101  0x2D   45  -  
  7044	:  0011_0000  0x30   48  0  
  7045	:  0011_0010  0x32   50  2  
  7046	:  0011_0000  0x30   48  0  
  7047	:  1100_0000  0xC0  192    
  7048	:  0000_1100  0x0C   12    
  7049	:  0000_0000  0x00    0    
  7050	:  0000_0001  0x01    1    
  7051	:  0000_0000  0x00    0    
  7052	:  0000_0001  0x01    1    
  7053	:  0000_0000  0x00    0    
  7054	:  0000_0000  0x00    0    
  7055	:  0010_1010  0x2A   42  *  
  7056	:  0011_0000  0x30   48  0  
  7057	:  0000_0000  0x00    0    
  7058	:  0000_0100  0x04    4    
  7059	:  0010_1101  0x2D   45  -  
  7060	:  0100_0011  0x43   67  C  
  7061	:  0011_0011  0x33   51  3  
  7062	:  0001_0100  0x14   20    
  7063	:  0000_1000  0x08    8    
  7064	:  0100_0001  0x41   65  A  
  7065	:  0010_1101  0x2D   45  -  
  7066	:  0011_0101  0x35   53  5  
  7067	:  0011_0001  0x31   49  1  
  7068	:  0010_1101  0x2D   45  -  
  7069	:  0011_0000  0x30   48  0  
  7070	:  0011_0010  0x32   50  2  
  7071	:  0011_0001  0x31   49  1  
  7072	:  1100_0000  0xC0  192    
  7073	:  0000_1100  0x0C   12    
  7074	:  0000_0000  0x00    0    
  7075	:  0000_0001  0x01    1    
  7076	:  0000_0000  0x00    0    
  7077	:  0000_0001  0x01    1    
  7078	:  0000_0000  0x00    0    
  7079	:  0000_0000  0x00    0    
  7080	:  0010_1010  0x2A   42  *  
  7081	:  0011_0000  0x30   48  0  
  7082	:  0000_0000  0x00    0    
  7083	:  0000_0100  0x04    4    
  7084	:  0010_1101  0x2D   45  -  
  7085	:  0100_0011  0x43   67  C  
  7086	:  0011_0011  0x33   51  3  
  7087	:  0001_0101  0x15   21    
  7088	:  0000_1000  0x08    8    
  7089	:  0100_0001  0x41   65  A  
  7090	:  0010_1101  0x2D   45  -  
  7091	:  0011_0101  0x35   53  5  
  7092	:  0011_0001  0x31   49  1  
  7093	:  0010_1101  0x2D   45  -  
  7094	:  0011_0000  0x30   48  0  
  7095	:  0011_0010  0x32   50  2  
  7096	:  0011_0010  0x32   50  2  
  7097	:  1100_0000  0xC0  192    
  7098	:  0000_1100  0x0C   12    
  7099	:  0000_0000  0x00    0    
  7100	:  0000_0001  0x01    1    
  7101	:  0000_0000  0x00    0    
  7102	:  0000_0001  0x01    1    
  7103	:  0000_0000  0x00    0    
  7104	:  0000_0000  0x00    0    
  7105	:  0010_1010  0x2A   42  *  
  7106	:  0011_0000  0x30   48  0  
  7107	:  0000_0000  0x00    0    
  7108	:  0000_0100  0x04    4    
  7109	:  0010_1101  0x2D   45  -  
  7110	:  0100_0011  0x43   67  C  
  7111	:  0011_0011  0x33   51  3  
  7112	:  0001_0110  0x16   22    
  7113	:  0000_1000  0x08    8    
  7114	:  0100_0001  0x41   65  A  
  7115	:  0010_1101  0x2D   45  -  
  7116	:  0011_0101  0x35   53  5  
  7117	:  0011_0001  0x31   49  1  
  7118	:  0010_1101  0x2D   45  -  
  7119	:  0011_0000  0x30   48  0  
  7120	:  0011_0010  0x32   50  2  
  7121	:  0011_0011  0x33   51  3  
  7122	:  1100_0000  0xC0  192    
  7123	:  0000_1100  0x0C   12    
  7124	:  0000_0000  0x00    0    
  7125	:  0000_0001  0x01    1    
  7126	:  0000_0000  0x00    0    
  7127	:  0000_0001  0x01    1    
  7128	:  0000_0000  0x00    0    
  7129	:  0000_0000  0x00    0    
  7130	:  0010_1010  0x2A   42  *  
  7131	:  0011_0000  0x30   48  0  
  7132	:  0000_0000  0x00    0    
  7133	:  0000_0100  0x04    4    
  7134	:  0010_1101  0x2D   45  -  
  7135	:  0100_0011  0x43   67  C  
  7136	:  0011_0011  0x33   51  3  
  7137	:  0001_0111  0x17   23    
  7138	:  0000_1000  0x08    8    
  7139	:  0100_0001  0x41   65  A  
  7140	:  0010_1101  0x2D   45  -  
  7141	:  0011_0101  0x35   53  5  
  7142	:  0011_0001  0x31   49  1  
  7143	:  0010_1101  0x2D   45  -  
  7144	:  0011_0000  0x30   48  0  
  7145	:  0011_0010  0x32   50  2  
  7146	:  0011_0100  0x34   52  4  
  7147	:  1100_0000  0xC0  192    
  7148	:  0000_1100  0x0C   12    
  7149	:  0000_0000  0x00    0    
  7150	:  0000_0001  0x01    1    
  7151	:  0000_0000  0x00    0    
  7152	:  0000_0001  0x01    1    
  7153	:  0000_0000  0x00    0    
  7154	:  0000_0000  0x00    0    
  7155	:  0010_1010  0x2A   42  *  
  7156	:  0011_0000  0x30   48  0  
  7157	:  0000_0000  0x00    0    
  7158	:  0000_0100  0x04    4    
  7159	:  0010_1101  0x2D   45  -  
  7160	:  0100_0011  0x43   67  C  
  7161	:  0011_0011  0x33   51  3  
  7162	:  0001_1000  0x18   24    
  7163	:  0000_1000  0x08    8    
  7164	:  0100_0001  0x41   65  A  
  7165	:  0010_1101  0x2D   45  -  
  7166	:  0011_0101  0x35   53  5  
  7167	:  0011_0001  0x31   49  1  
  7168	:  0010_1101  0x2D   45  -  
  7169	:  0011_0000  0x30   48  0  
  7170	:  0011_0010  0x32   50  2  
  7171	:  0011_0101  0x35   53  5  
  7172	:  1100_0000  0xC0  192    
  7173	:  0000_1100  0x0C   12    
  7174	:  0000_0000  0x00    0    
  7175	:  0000_0001  0x01    1    
  7176	:  0000_0000  0x00    0    
  7177	:  0000_0001  0x01    1    
  7178	:  0000_0000  0x00    0    
  7179	:  0000_0000  0x00    0    
  7180	:  0010_1010  0x2A   42  *  
  7181	:  0011_0000  0x30   48  0  
  7182	:  0000_0000  0x00    0    
  7183	:  0000_0100  0x04    4    
  7184	:  0010_1101  0x2D   45  -  
  7185	:  0100_0011  0x43   67  C  
  7186	:  0011_0011  0x33   51  3  
  7187	:  0001_1001  0x19   25    
  7188	:  0000_1000  0x08    8    
  7189	:  0100_0001  0x41   65  A  
  7190	:  0010_1101  0x2D   45  -  
  7191	:  0011_0101  0x35   53  5  
  7192	:  0011_0001  0x31   49  1  
  7193	:  0010_1101  0x2D   45  -  
  7194	:  0011_0000  0x30   48  0  
  7195	:  0011_0010  0x32   50  2  
  7196	:  0011_0110  0x36   54  6  
  7197	:  1100_0000  0xC0  192    
  7198	:  0000_1100  0x0C   12    
  7199	:  0000_0000  0x00    0    
  7200	:  0000_0001  0x01    1    
  7201	:  0000_0000  0x00    0    
  7202	:  0000_0001  0x01    1    
  7203	:  0000_0000  0x00    0    
  7204	:  0000_0000  0x00    0    
  7205	:  0010_1010  0x2A   42  *  
  7206	:  0011_0000  0x30   48  0  
  7207	:  0000_0000  0x00    0    
  7208	:  0000_0100  0x04    4    
  7209	:  0010_1101  0x2D   45  -  
  7210	:  0100_0011  0x43   67  C  
  7211	:  0011_0011  0x33   51  3  
  7212	:  0001_1010  0x1A   26    
  7213	:  0000_1000  0x08    8    
  7214	:  0100_0001  0x41   65  A  
  7215	:  0010_1101  0x2D   45  -  
  7216	:  0011_0101  0x35   53  5  
  7217	:  0011_0001  0x31   49  1  
  7218	:  0010_1101  0x2D   45  -  
  7219	:  0011_0000  0x30   48  0  
  7220	:  0011_0010  0x32   50  2  
  7221	:  0011_0111  0x37   55  7  
  7222	:  1100_0000  0xC0  192    
  7223	:  0000_1100  0x0C   12    
  7224	:  0000_0000  0x00    0    
  7225	:  0000_0001  0x01    1    
  7226	:  0000_0000  0x00    0    
  7227	:  0000_0001  0x01    1    
  7228	:  0000_0000  0x00    0    
  7229	:  0000_0000  0x00    0    
  7230	:  0010_1010  0x2A   42  *  
  7231	:  0011_0000  0x30   48  0  
  7232	:  0000_0000  0x00    0    
  7233	:  0000_0100  0x04    4    
  7234	:  0010_1101  0x2D   45  -  
  7235	:  0100_0011  0x43   67  C  
  7236	:  0011_0011  0x33   51  3  
  7237	:  0001_1011  0x1B   27    
  7238	:  0000_1000  0x08    8    
  7239	:  0100_0001  0x41   65  A  
  7240	:  0010_1101  0x2D   45  -  
  7241	:  0011_0101  0x35   53  5  
  7242	:  0011_0001  0x31   49  1  
  7243	:  0010_1101  0x2D   45  -  
  7244	:  0011_0000  0x30   48  0  
  7245	:  0011_0010  0x32   50  2  
  7246	:  0011_1000  0x38   56  8  
  7247	:  1100_0000  0xC0  192    
  7248	:  0000_1100  0x0C   12    
  7249	:  0000_0000  0x00    0    
  7250	:  0000_0001  0x01    1    
  7251	:  0000_0000  0x00    0    
  7252	:  0000_0001  0x01    1    
  7253	:  0000_0000  0x00    0    
  7254	:  0000_0000  0x00    0    
  7255	:  0010_1010  0x2A   42  *  
  7256	:  0011_0000  0x30   48  0  
  7257	:  0000_0000  0x00    0    
  7258	:  0000_0100  0x04    4    
  7259	:  0010_1101  0x2D   45  -  
  7260	:  0100_0011  0x43   67  C  
  7261	:  0011_0011  0x33   51  3  
  7262	:  0001_1100  0x1C   28    
  7263	:  0000_1000  0x08    8    
  7264	:  0100_0001  0x41   65  A  
  7265	:  0010_1101  0x2D   45  -  
  7266	:  0011_0101  0x35   53  5  
  7267	:  0011_0001  0x31   49  1  
  7268	:  0010_1101  0x2D   45  -  
  7269	:  0011_0000  0x30   48  0  
  7270	:  0011_0010  0x32   50  2  
  7271	:  0011_1001  0x39   57  9  
  7272	:  1100_0000  0xC0  192    
  7273	:  0000_1100  0x0C   12    
  7274	:  0000_0000  0x00    0    
  7275	:  0000_0001  0x01    1    
  7276	:  0000_0000  0x00    0    
  7277	:  0000_0001  0x01    1    
  7278	:  0000_0000  0x00    0    
  7279	:  0000_0000  0x00    0    
  7280	:  0010_1010  0x2A   42  *  
  7281	:  0011_0000  0x30   48  0  
  7282	:  0000_0000  0x00    0    
  7283	:  0000_0100  0x04    4    
  7284	:  0010_1101  0x2D   45  -  
  7285	:  0100_0011  0x43   67  C  
  7286	:  0011_0011  0x33   51  3  
  7287	:  0001_1101  0x1D   29    
  7288	:  0000_1000  0x08    8    
  7289	:  0100_0001  0x41   65  A  
  7290	:  0010_1101  0x2D   45  -  
  7291	:  0011_0101  0x35   53  5  
  7292	:  0011_0001  0x31   49  1  
  7293	:  0010_1101  0x2D   45  -  
  7294	:  0011_0000  0x30   48  0  
  7295	:  0011_0011  0x33   51  3  
  7296	:  0011_0000  0x30   48  0  
  7297	:  1100_0000  0xC0  192    
  7298	:  0000_1100  0x0C   12    
  7299	:  0000_0000  0x00    0    
  7300	:  0000_0001  0x01    1    
  7301	:  0000_0000  0x00    0    
  7302	:  0000_0001  0x01    1    
  7303	:  0000_0000  0x00    0    
  7304	:  0000_0000  0x00    0    
  7305	:  0010_1010  0x2A   42  *  
  7306	:  0011_0000  0x30   48  0  
  7307	:  0000_0000  0x00    0    
  7308	:  0000_0100  0x04    4    
  7309	:  0010_1101  0x2D   45  -  
  7310	:  0100_0011  0x43   67  C  
  7311	:  0011_0011  0x33   51  3  
  7312	:  0001_1110  0x1E   30    
  7313	:  0000_1000  0x08    8    
  7314	:  0100_0001  0x41   65  A  
  7315	:  0010_1101  0x2D   45  -  
  7316	:  0011_0101  0x35   53  5  
  7317	:  0011_0001  0x31   49  1  
  7318	:  0010_1101  0x2D   45  -  
  7319	:  0011_0000  0x30   48  0  
  7320	:  0011_0011  0x33   51  3  
  7321	:  0011_0001  0x31   49  1  
  7322	:  1100_0000  0xC0  192    
  7323	:  0000_1100  0x0C   12    
  7324	:  0000_0000  0x00    0    
  7325	:  0000_0001  0x01    1    
  7326	:  0000_0000  0x00    0    
  7327	:  0000_0001  0x01    1    
  7328	:  0000_0000  0x00    0    
  7329	:  0000_0000  0x00    0    
  7330	:  0010_1010  0x2A   42  *  
  7331	:  0011_0000  0x30   48  0  
  7332	:  0000_0000  0x00    0    
  7333	:  0000_0100  0x04    4    
  7334	:  0010_1101  0x2D   45  -  
  7335	:  0100_0011  0x43   67  C  
  7336	:  0011_0011  0x33   51  3  
  7337	:  0001_1111  0x1F   31    
  7338	:  0000_1000  0x08    8    
  7339	:  0100_0001  0x41   65  A  
  7340	:  0010_1101  0x2D   45  -  
  7341	:  0011_0101  0x35   53  5  
  7342	:  0011_0001  0x31   49  1  
  7343	:  0010_1101  0x2D   45  -  
  7344	:  0011_0000  0x30   48  0  
  7345	:  0011_0011  0x33   51  3  
  7346	:  0011_0010  0x32   50  2  
  7347	:  1100_0000  0xC0  192    
  7348	:  0000_1100  0x0C   12    
  7349	:  0000_0000  0x00    0    
  7350	:  0000_0001  0x01    1    
  7351	:  0000_0000  0x00    0    
  7352	:  0000_0001  0x01    1    
  7353	:  0000_0000  0x00    0    
  7354	:  0000_0000  0x00    0    
  7355	:  0010_1010  0x2A   42  *  
  7356	:  0011_0000  0x30   48  0  
  7357	:  0000_0000  0x00    0    
  7358	:  0000_0100  0x04    4    
  7359	:  0010_1101  0x2D   45  -  
  7360	:  0100_0011  0x43   67  C  
  7361	:  0011_0011  0x33   51  3  
  7362	:  0010_0000  0x20   32     
  7363	:  0000_1000  0x08    8    
  7364	:  0100_0001  0x41   65  A  
  7365	:  0010_1101  0x2D   45  -  
  7366	:  0011_0101  0x35   53  5  
  7367	:  0011_0001  0x31   49  1  
  7368	:  0010_1101  0x2D   45  -  
  7369	:  0011_0000  0x30   48  0  
  7370	:  0011_0011  0x33   51  3  
  7371	:  0011_0011  0x33   51  3  
  7372	:  1100_0000  0xC0  192    
  7373	:  0000_1100  0x0C   12    
  7374	:  0000_0000  0x00    0    
  7375	:  0000_0001  0x01    1    
  7376	:  0000_0000  0x00    0    
  7377	:  0000_0001  0x01    1    
  7378	:  0000_0000  0x00    0    
  7379	:  0000_0000  0x00    0    
  7380	:  0010_1010  0x2A   42  *  
  7381	:  0011_0000  0x30   48  0  
  7382	:  0000_0000  0x00    0    
  7383	:  0000_0100  0x04    4    
  7384	:  0010_1101  0x2D   45  -  
  7385	:  0100_0011  0x43   67  C  
  7386	:  0011_0011  0x33   51  3  
  7387	:  0010_0001  0x21   33  !  
  7388	:  0000_1000  0x08    8    
  7389	:  0100_0001  0x41   65  A  
  7390	:  0010_1101  0x2D   45  -  
  7391	:  0011_0101  0x35   53  5  
  7392	:  0011_0001  0x31   49  1  
  7393	:  0010_1101  0x2D   45  -  
  7394	:  0011_0000  0x30   48  0  
  7395	:  0011_0011  0x33   51  3  
  7396	:  0011_0100  0x34   52  4  
  7397	:  1100_0000  0xC0  192    
  7398	:  0000_1100  0x0C   12    
  7399	:  0000_0000  0x00    0    
  7400	:  0000_0001  0x01    1    
  7401	:  0000_0000  0x00    0    
  7402	:  0000_0001  0x01    1    
  7403	:  0000_0000  0x00    0    
  7404	:  0000_0000  0x00    0    
  7405	:  0010_1010  0x2A   42  *  
  7406	:  0011_0000  0x30   48  0  
  7407	:  0000_0000  0x00    0    
  7408	:  0000_0100  0x04    4    
  7409	:  0010_1101  0x2D   45  -  
  7410	:  0100_0011  0x43   67  C  
  7411	:  0011_0011  0x33   51  3  
  7412	:  0010_0010  0x22   34  "  
  7413	:  0000_1000  0x08    8    
  7414	:  0100_0001  0x41   65  A  
  7415	:  0010_1101  0x2D   45  -  
  7416	:  0011_0101  0x35   53  5  
  7417	:  0011_0001  0x31   49  1  
  7418	:  0010_1101  0x2D   45  -  
  7419	:  0011_0000  0x30   48  0  
  7420	:  0011_0011  0x33   51  3  
  7421	:  0011_0101  0x35   53  5  
  7422	:  1100_0000  0xC0  192    
  7423	:  0000_1100  0x0C   12    
  7424	:  0000_0000  0x00    0    
  7425	:  0000_0001  0x01    1    
  7426	:  0000_0000  0x00    0    
  7427	:  0000_0001  0x01    1    
  7428	:  0000_0000  0x00    0    
  7429	:  0000_0000  0x00    0    
  7430	:  0010_1010  0x2A   42  *  
  7431	:  0011_0000  0x30   48  0  
  7432	:  0000_0000  0x00    0    
  7433	:  0000_0100  0x04    4    
  7434	:  0010_1101  0x2D   45  -  
  7435	:  0100_0011  0x43   67  C  
  7436	:  0011_0011  0x33   51  3  
  7437	:  0010_0011  0x23   35  #  
  7438	:  0000_1000  0x08    8    
  7439	:  0100_0001  0x41   65  A  
  7440	:  0010_1101  0x2D   45  -  
  7441	:  0011_0101  0x35   53  5  
  7442	:  0011_0001  0x31   49  1  
  7443	:  0010_1101  0x2D   45  -  
  7444	:  0011_0000  0x30   48  0  
  7445	:  0011_0011  0x33   51  3  
  7446	:  0011_0110  0x36   54  6  
  7447	:  1100_0000  0xC0  192    
  7448	:  0000_1100  0x0C   12    
  7449	:  0000_0000  0x00    0    
  7450	:  0000_0001  0x01    1    
  7451	:  0000_0000  0x00    0    
  7452	:  0000_0001  0x01    1    
  7453	:  0000_0000  0x00    0    
  7454	:  0000_0000  0x00    0    
  7455	:  0010_1010  0x2A   42  *  
  7456	:  0011_0000  0x30   48  0  
  7457	:  0000_0000  0x00    0    
  7458	:  0000_0100  0x04    4    
  7459	:  0010_1101  0x2D   45  -  
  7460	:  0100_0011  0x43   67  C  
  7461	:  0011_0011  0x33   51  3  
  7462	:  0010_0100  0x24   36  $  
  7463	:  0000_1000  0x08    8    
  7464	:  0100_0001  0x41   65  A  
  7465	:  0010_1101  0x2D   45  -  
  7466	:  0011_0101  0x35   53  5  
  7467	:  0011_0001  0x31   49  1  
  7468	:  0010_1101  0x2D   45  -  
  7469	:  0011_0000  0x30   48  0  
  7470	:  0011_0011  0x33   51  3  
  7471	:  0011_0111  0x37   55  7  
  7472	:  1100_0000  0xC0  192    
  7473	:  0000_1100  0x0C   12    
  7474	:  0000_0000  0x00    0    
  7475	:  0000_0001  0x01    1    
  7476	:  0000_0000  0x00    0    
  7477	:  0000_0001  0x01    1    
  7478	:  0000_0000  0x00    0    
  7479	:  0000_0000  0x00    0    
  7480	:  0010_1010  0x2A   42  *  
  7481	:  0011_0000  0x30   48  0  
  7482	:  0000_0000  0x00    0    
  7483	:  0000_0100  0x04    4    
  7484	:  0010_1101  0x2D   45  -  
  7485	:  0100_0011  0x43   67  C  
  7486	:  0011_0011  0x33   51  3  
  7487	:  0010_0101  0x25   37  %  
  7488	:  0000_1000  0x08    8    
  7489	:  0100_0001  0x41   65  A  
  7490	:  0010_1101  0x2D   45  -  
  7491	:  0011_0101  0x35   53  5  
  7492	:  0011_0001  0x31   49  1  
  7493	:  0010_1101  0x2D   45  -  
  7494	:  0011_0000  0x30   48  0  
  7495	:  0011_0011  0x33   51  3  
  7496	:  0011_1000  0x38   56  8  
  7497	:  1100_0000  0xC0  192    
  7498	:  0000_1100  0x0C   12    
  7499	:  0000_0000  0x00    0    
  7500	:  0000_0001  0x01    1    
  7501	:  0000_0000  0x00    0    
  7502	:  0000_0001  0x01    1    
  7503	:  0000_0000  0x00    0    
  7504	:  0000_0000  0x00    0    
  7505	:  0010_1010  0x2A   42  *  
  7506	:  0011_0000  0x30   48  0  
  7507	:  0000_0000  0x00    0    
  7508	:  0000_0100  0x04    4    
  7509	:  0010_1101  0x2D   45  -  
  7510	:  0100_0011  0x43   67  C  
  7511	:  0011_0011  0x33   51  3  
  7512	:  0010_0110  0x26   38  &  
  7513	:  0000_1000  0x08    8    
  7514	:  0100_0001  0x41   65  A  
  7515	:  0010_1101  0x2D   45  -  
  7516	:  0011_0101  0x35   53  5  
  7517	:  0011_0001  0x31   49  1  
  7518	:  0010_1101  0x2D   45  -  
  7519	:  0011_0000  0x30   48  0  
  7520	:  0011_0011  0x33   51  3  
  7521	:  0011_1001  0x39   57  9  
  7522	:  1100_0000  0xC0  192    
  7523	:  0000_1100  0x0C   12    
  7524	:  0000_0000  0x00    0    
  7525	:  0000_0001  0x01    1    
  7526	:  0000_0000  0x00    0    
  7527	:  0000_0001  0x01    1    
  7528	:  0000_0000  0x00    0    
  7529	:  0000_0000  0x00    0    
  7530	:  0010_1010  0x2A   42  *  
  7531	:  0011_0000  0x30   48  0  
  7532	:  0000_0000  0x00    0    
  7533	:  0000_0100  0x04    4    
  7534	:  0010_1101  0x2D   45  -  
  7535	:  0100_0011  0x43   67  C  
  7536	:  0011_0011  0x33   51  3  
  7537	:  0010_0111  0x27   39  '  
  7538	:  0000_1000  0x08    8    
  7539	:  0100_0001  0x41   65  A  
  7540	:  0010_1101  0x2D   45  -  
  7541	:  0011_0101  0x35   53  5  
  7542	:  0011_0001  0x31   49  1  
  7543	:  0010_1101  0x2D   45  -  
  7544	:  0011_0000  0x30   48  0  
  7545	:  0011_0100  0x34   52  4  
  7546	:  0011_0000  0x30   48  0  
  7547	:  1100_0000  0xC0  192    
  7548	:  0000_1100  0x0C   12    
  7549	:  0000_0000  0x00    0    
  7550	:  0000_0001  0x01    1    
  7551	:  0000_0000  0x00    0    
  7552	:  0000_0001  0x01    1    
  7553	:  0000_0000  0x00    0    
  7554	:  0000_0000  0x00    0    
  7555	:  0010_1010  0x2A   42  *  
  7556	:  0011_0000  0x30   48  0  
  7557	:  0000_0000  0x00    0    
  7558	:  0000_0100  0x04    4    
  7559	:  0010_1101  0x2D   45  -  
  7560	:  0100_0011  0x43   67  C  
  7561	:  0011_0011  0x33   51  3  
  7562	:  0010_1000  0x28   40  (  
  7563	:  0000_1000  0x08    8    
  7564	:  0100_0001  0x41   65  A  
  7565	:  0010_1101  0x2D   45  -  
  7566	:  0011_0101  0x35   53  5  
  7567	:  0011_0001  0x31   49  1  
  7568	:  0010_1101  0x2D   45  -  
  7569	:  0011_0000  0x30   48  0  
  7570	:  0011_0100  0x34   52  4  
  7571	:  0011_0001  0x31   49  1  
  7572	:  1100_0000  0xC0  192    
  7573	:  0000_1100  0x0C   12    
  7574	:  0000_0000  0x00    0    
  7575	:  0000_0001  0x01    1    
  7576	:  0000_0000  0x00    0    
  7577	:  0000_0001  0x01    1    
  7578	:  0000_0000  0x00    0    
  7579	:  0000_0000  0x00    0    
  7580	:  0010_1010  0x2A   42  *  
  7581	:  0011_0000  0x30   48  0  
  7582	:  0000_0000  0x00    0    
  7583	:  0000_0100  0x04    4    
  7584	:  0010_1101  0x2D   45  -  
  7585	:  0100_0011  0x43   67  C  
  7586	:  0011_0011  0x33   51  3  
  7587	:  0010_1001  0x29   41  )  
  7588	:  0000_1000  0x08    8    
  7589	:  0100_0001  0x41   65  A  
  7590	:  0010_1101  0x2D   45  -  
  7591	:  0011_0101  0x35   53  5  
  7592	:  0011_0001  0x31   49  1  
  7593	:  0010_1101  0x2D   45  -  
  7594	:  0011_0000  0x30   48  0  
  7595	:  0011_0100  0x34   52  4  
  7596	:  0011_0010  0x32   50  2  
  7597	:  1100_0000  0xC0  192    
  7598	:  0000_1100  0x0C   12    
  7599	:  0000_0000  0x00    0    
  7600	:  0000_0001  0x01    1    
  7601	:  0000_0000  0x00    0    
  7602	:  0000_0001  0x01    1    
  7603	:  0000_0000  0x00    0    
  7604	:  0000_0000  0x00    0    
  7605	:  0010_1010  0x2A   42  *  
  7606	:  0011_0000  0x30   48  0  
  7607	:  0000_0000  0x00    0    
  7608	:  0000_0100  0x04    4    
  7609	:  0010_1101  0x2D   45  -  
  7610	:  0100_0011  0x43   67  C  
  7611	:  0011_0011  0x33   51  3  
  7612	:  0010_1010  0x2A   42  *  
  7613	:  0000_1000  0x08    8    
  7614	:  0100_0001  0x41   65  A  
  7615	:  0010_1101  0x2D   45  -  
  7616	:  0011_0101  0x35   53  5  
  7617	:  0011_0001  0x31   49  1  
  7618	:  0010_1101  0x2D   45  -  
  7619	:  0011_0000  0x30   48  0  
  7620	:  0011_0100  0x34   52  4  
  7621	:  0011_0011  0x33   51  3  
  7622	:  1100_0000  0xC0  192    
  7623	:  0000_1100  0x0C   12    
  7624	:  0000_0000  0x00    0    
  7625	:  0000_0001  0x01    1    
  7626	:  0000_0000  0x00    0    
  7627	:  0000_0001  0x01    1    
  7628	:  0000_0000  0x00    0    
  7629	:  0000_0000  0x00    0    
  7630	:  0010_1010  0x2A   42  *  
  7631	:  0011_0000  0x30   48  0  
  7632	:  0000_0000  0x00    0    
  7633	:  0000_0100  0x04    4    
  7634	:  0010_1101  0x2D   45  -  
  7635	:  0100_0011  0x43   67  C  
  7636	:  0011_0011  0x33   51  3  
  7637	:  0010_1011  0x2B   43  +  
  7638	:  0000_1000  0x08    8    
  7639	:  0100_0001  0x41   65  A  
  7640	:  0010_1101  0x2D   45  -  
  7641	:  0011_0101  0x35   53  5  
  7642	:  0011_0001  0x31   49  1  
  7643	:  0010_1101  0x2D   45  -  
  7644	:  0011_0000  0x30   48  0  
  7645	:  0011_0100  0x34   52  4  
  7646	:  0011_0100  0x34   52  4  
  7647	:  1100_0000  0xC0  192    
  7648	:  0000_1100  0x0C   12    
  7649	:  0000_0000  0x00    0    
  7650	:  0000_0001  0x01    1    
  7651	:  0000_0000  0x00    0    
  7652	:  0000_0001  0x01    1    
  7653	:  0000_0000  0x00    0    
  7654	:  0000_0000  0x00    0    
  7655	:  0010_1010  0x2A   42  *  
  7656	:  0011_0000  0x30   48  0  
  7657	:  0000_0000  0x00    0    
  7658	:  0000_0100  0x04    4    
  7659	:  0010_1101  0x2D   45  -  
  7660	:  0100_0011  0x43   67  C  
  7661	:  0011_0011  0x33   51  3  
  7662	:  0010_1100  0x2C   44  ,  
  7663	:  0000_1000  0x08    8    
  7664	:  0100_0001  0x41   65  A  
  7665	:  0010_1101  0x2D   45  -  
  7666	:  0011_0101  0x35   53  5  
  7667	:  0011_0001  0x31   49  1  
  7668	:  0010_1101  0x2D   45  -  
  7669	:  0011_0000  0x30   48  0  
  7670	:  0011_0100  0x34   52  4  
  7671	:  0011_0101  0x35   53  5  
  7672	:  1100_0000  0xC0  192    
  7673	:  0000_1100  0x0C   12    
  7674	:  0000_0000  0x00    0    
  7675	:  0000_0001  0x01    1    
  7676	:  0000_0000  0x00    0    
  7677	:  0000_0001  0x01    1    
  7678	:  0000_0000  0x00    0    
  7679	:  0000_0000  0x00    0    
  7680	:  0010_1010  0x2A   42  *  
  7681	:  0011_0000  0x30   48  0  
  7682	:  0000_0000  0x00    0    
  7683	:  0000_0100  0x04    4    
  7684	:  0010_1101  0x2D   45  -  
  7685	:  0100_0011  0x43   67  C  
  7686	:  0011_0011  0x33   51  3  
  7687	:  0010_1101  0x2D   45  -  
  7688	:  0000_1000  0x08    8    
  7689	:  0100_0001  0x41   65  A  
  7690	:  0010_1101  0x2D   45  -  
  7691	:  0011_0101  0x35   53  5  
  7692	:  0011_0001  0x31   49  1  
  7693	:  0010_1101  0x2D   45  -  
  7694	:  0011_0000  0x30   48  0  
  7695	:  0011_0100  0x34   52  4  
  7696	:  0011_0110  0x36   54  6  
  7697	:  1100_0000  0xC0  192    
  7698	:  0000_1100  0x0C   12    
  7699	:  0000_0000  0x00    0    
  7700	:  0000_0001  0x01    1    
  7701	:  0000_0000  0x00    0    
  7702	:  0000_0001  0x01    1    
  7703	:  0000_0000  0x00    0    
  7704	:  0000_0000  0x00    0    
  7705	:  0010_1010  0x2A   42  *  
  7706	:  0011_0000  0x30   48  0  
  7707	:  0000_0000  0x00    0    
  7708	:  0000_0100  0x04    4    
  7709	:  0010_1101  0x2D   45  -  
  7710	:  0100_0011  0x43   67  C  
  7711	:  0011_0011  0x33   51  3  
  7712	:  0010_1110  0x2E   46  .  
  7713	:  0000_1000  0x08    8    
  7714	:  0100_0001  0x41   65  A  
  7715	:  0010_1101  0x2D   45  -  
  7716	:  0011_0101  0x35   53  5  
  7717	:  0011_0001  0x31   49  1  
  7718	:  0010_1101  0x2D   45  -  
  7719	:  0011_0000  0x30   48  0  
  7720	:  0011_0100  0x34   52  4  
  7721	:  0011_0111  0x37   55  7  
  7722	:  1100_0000  0xC0  192    
  7723	:  0000_1100  0x0C   12    
  7724	:  0000_0000  0x00    0    
  7725	:  0000_0001  0x01    1    
  7726	:  0000_0000  0x00    0    
  7727	:  0000_0001  0x01    1    
  7728	:  0000_0000  0x00    0    
  7729	:  0000_0000  0x00    0    
  7730	:  0010_1010  0x2A   42  *  
  7731	:  0011_0000  0x30   48  0  
  7732	:  0000_0000  0x00    0    
  7733	:  0000_0100  0x04    4    
  7734	:  0010_1101  0x2D   45  -  
  7735	:  0100_0011  0x43   67  C  
  7736	:  0011_0011  0x33   51  3  
  7737	:  0010_1111  0x2F   47  /  
  7738	:  0000_1000  0x08    8    
  7739	:  0100_0001  0x41   65  A  
  7740	:  0010_1101  0x2D   45  -  
  7741	:  0011_0101  0x35   53  5  
  7742	:  0011_0001  0x31   49  1  
  7743	:  0010_1101  0x2D   45  -  
  7744	:  0011_0000  0x30   48  0  
  7745	:  0011_0100  0x34   52  4  
  7746	:  0011_1000  0x38   56  8  
  7747	:  1100_0000  0xC0  192    
  7748	:  0000_1100  0x0C   12    
  7749	:  0000_0000  0x00    0    
  7750	:  0000_0001  0x01    1    
  7751	:  0000_0000  0x00    0    
  7752	:  0000_0001  0x01    1    
  7753	:  0000_0000  0x00    0    
  7754	:  0000_0000  0x00    0    
  7755	:  0010_1010  0x2A   42  *  
  7756	:  0011_0000  0x30   48  0  
  7757	:  0000_0000  0x00    0    
  7758	:  0000_0100  0x04    4    
  7759	:  0010_1101  0x2D   45  -  
  7760	:  0100_0011  0x43   67  C  
  7761	:  0011_0011  0x33   51  3  
  7762	:  0011_0000  0x30   48  0  
  7763	:  0000_1000  0x08    8    
  7764	:  0100_0001  0x41   65  A  
  7765	:  0010_1101  0x2D   45  -  
  7766	:  0011_0101  0x35   53  5  
  7767	:  0011_0001  0x31   49  1  
  7768	:  0010_1101  0x2D   45  -  
  7769	:  0011_0000  0x30   48  0  
  7770	:  0011_0100  0x34   52  4  
  7771	:  0011_1001  0x39   57  9  
  7772	:  1100_0000  0xC0  192    
  7773	:  0000_1100  0x0C   12    
  7774	:  0000_0000  0x00    0    
  7775	:  0000_0001  0x01    1    
  7776	:  0000_0000  0x00    0    
  7777	:  0000_0001  0x01    1    
  7778	:  0000_0000  0x00    0    
  7779	:  0000_0000  0x00    0    
  7780	:  0010_1010  0x2A   42  *  
  7781	:  0011_0000  0x30   48  0  
  7782	:  0000_0000  0x00    0    
  7783	:  0000_0100  0x04    4    
  7784	:  0010_1101  0x2D   45  -  
  7785	:  0100_0011  0x43   67  C  
  7786	:  0011_0011  0x33   51  3  
  7787	:  0011_0001  0x31   49  1  
  7788	:  0000_1000  0x08    8    
  7789	:  0100_0001  0x41   65  A  
  7790	:  0010_1101  0x2D   45  -  
  7791	:  0011_0101  0x35   53  5  
  7792	:  0011_0001  0x31   49  1  
  7793	:  0010_1101  0x2D   45  -  
  7794	:  0011_0000  0x30   48  0  
  7795	:  0011_0101  0x35   53  5  
  7796	:  0011_0000  0x30   48  0  
  7797	:  1100_0000  0xC0  192    
  7798	:  0000_1100  0x0C   12    
  7799	:  0000_0000  0x00    0    
  7800	:  0000_0001  0x01    1    
  7801	:  0000_0000  0x00    0    
  7802	:  0000_0001  0x01    1    
  7803	:  0000_0000  0x00    0    
  7804	:  0000_0000  0x00    0    
  7805	:  0010_1010  0x2A   42  *  
  7806	:  0011_0000  0x30   48  0  
  7807	:  0000_0000  0x00    0    
  7808	:  0000_0100  0x04    4    
  7809	:  0010_1101  0x2D   45  -  
  7810	:  0100_0011  0x43   67  C  
  7811	:  0011_0011  0x33   51  3  
  7812	:  0011_0010  0x32   50  2  
  7813	:  0000_1000  0x08    8    
  7814	:  0100_0001  0x41   65  A  
  7815	:  0010_1101  0x2D   45  -  
  7816	:  0011_0101  0x35   53  5  
  7817	:  0011_0001  0x31   49  1  
  7818	:  0010_1101  0x2D   45  -  
  7819	:  0011_0000  0x30   48  0  
  7820	:  0011_0101  0x35   53  5  
  7821	:  0011_0001  0x31   49  1  
  7822	:  1100_0000  0xC0  192    
  7823	:  0000_1100  0x0C   12    
  7824	:  0000_0000  0x00    0    
  7825	:  0000_0001  0x01    1    
  7826	:  0000_0000  0x00    0    
  7827	:  0000_0001  0x01    1    
  7828	:  0000_0000  0x00    0    
  7829	:  0000_0000  0x00    0    
  7830	:  0010_1010  0x2A   42  *  
  7831	:  0011_0000  0x30   48  0  
  7832	:  0000_0000  0x00    0    
  7833	:  0000_0100  0x04    4    
  7834	:  0010_1101  0x2D   45  -  
  7835	:  0100_0011  0x43   67  C  
  7836	:  0011_0011  0x33   51  3  
  7837	:  0011_0011  0x33   51  3  
  7838	:  0000_1000  0x08    8    
  7839	:  0100_0001  0x41   65  A  
  7840	:  0010_1101  0x2D   45  -  
  7841	:  0011_0101  0x35   53  5  
  7842	:  0011_0001  0x31   49  1  
  7843	:  0010_1101  0x2D   45  -  
  7844	:  0011_0000  0x30   48  0  
  7845	:  0011_0101  0x35   53  5  
  7846	:  0011_0010  0x32   50  2  
  7847	:  1100_0000  0xC0  192    
  7848	:  0000_1100  0x0C   12    
  7849	:  0000_0000  0x00    0    
  7850	:  0000_0001  0x01    1    
  7851	:  0000_0000  0x00    0    
  7852	:  0000_0001  0x01    1    
  7853	:  0000_0000  0x00    0    
  7854	:  0000_0000  0x00    0    
  7855	:  0010_1010  0x2A   42  *  
  7856	:  0011_0000  0x30   48  0  
  7857	:  0000_0000  0x00    0    
  7858	:  0000_0100  0x04    4    
  7859	:  0010_1101  0x2D   45  -  
  7860	:  0100_0011  0x43   67  C  
  7861	:  0011_0011  0x33   51  3  
  7862	:  0011_0100  0x34   52  4  
  7863	:  0000_1000  0x08    8    
  7864	:  0100_0001  0x41   65  A  
  7865	:  0010_1101  0x2D   45  -  
  7866	:  0011_0101  0x35   53  5  
  7867	:  0011_0001  0x31   49  1  
  7868	:  0010_1101  0x2D   45  -  
  7869	:  0011_0000  0x30   48  0  
  7870	:  0011_0101  0x35   53  5  
  7871	:  0011_0011  0x33   51  3  
  7872	:  1100_0000  0xC0  192    
  7873	:  0000_1100  0x0C   12    
  7874	:  0000_0000  0x00    0    
  7875	:  0000_0001  0x01    1    
  7876	:  0000_0000  0x00    0    
  7877	:  0000_0001  0x01    1    
  7878	:  0000_0000  0x00    0    
  7879	:  0000_0000  0x00    0    
  7880	:  0010_1010  0x2A   42  *  
  7881	:  0011_0000  0x30   48  0  
  7882	:  0000_0000  0x00    0    
  7883	:  0000_0100  0x04    4    
  7884	:  0010_1101  0x2D   45  -  
  7885	:  0100_0011  0x43   67  C  
  7886	:  0011_0011  0x33   51  3  
  7887	:  0011_0101  0x35   53  5  
  7888	:  0000_1000  0x08    8    
  7889	:  0100_0001  0x41   65  A  
  7890	:  0010_1101  0x2D   45  -  
  7891	:  0011_0101  0x35   53  5  
  7892	:  0011_0001  0x31   49  1  
  7893	:  0010_1101  0x2D   45  -  
  7894	:  0011_0000  0x30   48  0  
  7895	:  0011_0101  0x35   53  5  
  7896	:  0011_0100  0x34   52  4  
  7897	:  1100_0000  0xC0  192    
  7898	:  0000_1100  0x0C   12    
  7899	:  0000_0000  0x00    0    
  7900	:  0000_0001  0x01    1    
  7901	:  0000_0000  0x00    0    
  7902	:  0000_0001  0x01    1    
  7903	:  0000_0000  0x00    0    
  7904	:  0000_0000  0x00    0    
  7905	:  0010_1010  0x2A   42  *  
  7906	:  0011_0000  0x30   48  0  
  7907	:  0000_0000  0x00    0    
  7908	:  0000_0100  0x04    4    
  7909	:  0010_1101  0x2D   45  -  
  7910	:  0100_0011  0x43   67  C  
  7911	:  0011_0011  0x33   51  3  
  7912	:  0011_0110  0x36   54  6  
  7913	:  0000_1000  0x08    8    
  7914	:  0100_0001  0x41   65  A  
  7915	:  0010_1101  0x2D   45  -  
  7916	:  0011_0101  0x35   53  5  
  7917	:  0011_0001  0x31   49  1  
  7918	:  0010_1101  0x2D   45  -  
  7919	:  0011_0000  0x30   48  0  
  7920	:  0011_0101  0x35   53  5  
  7921	:  0011_0101  0x35   53  5  
  7922	:  1100_0000  0xC0  192    
  7923	:  0000_1100  0x0C   12    
  7924	:  0000_0000  0x00    0    
  7925	:  0000_0001  0x01    1    
  7926	:  0000_0000  0x00    0    
  7927	:  0000_0001  0x01    1    
  7928	:  0000_0000  0x00    0    
  7929	:  0000_0000  0x00    0    
  7930	:  0010_1010  0x2A   42  *  
  7931	:  0011_0000  0x30   48  0  
  7932	:  0000_0000  0x00    0    
  7933	:  0000_0100  0x04    4    
  7934	:  0010_1101  0x2D   45  -  
  7935	:  0100_0011  0x43   67  C  
  7936	:  0011_0011  0x33   51  3  
  7937	:  0011_0111  0x37   55  7  
  7938	:  0000_1000  0x08    8    
  7939	:  0100_0001  0x41   65  A  
  7940	:  0010_1101  0x2D   45  -  
  7941	:  0011_0101  0x35   53  5  
  7942	:  0011_0001  0x31   49  1  
  7943	:  0010_1101  0x2D   45  -  
  7944	:  0011_0000  0x30   48  0  
  7945	:  0011_0101  0x35   53  5  
  7946	:  0011_0110  0x36   54  6  
  7947	:  1100_0000  0xC0  192    
  7948	:  0000_1100  0x0C   12    
  7949	:  0000_0000  0x00    0    
  7950	:  0000_0001  0x01    1    
  7951	:  0000_0000  0x00    0    
  7952	:  0000_0001  0x01    1    
  7953	:  0000_0000  0x00    0    
  7954	:  0000_0000  0x00    0    
  7955	:  0010_1010  0x2A   42  *  
  7956	:  0011_0000  0x30   48  0  
  7957	:  0000_0000  0x00    0    
  7958	:  0000_0100  0x04    4    
  7959	:  0010_1101  0x2D   45  -  
  7960	:  0100_0011  0x43   67  C  
  7961	:  0011_0011  0x33   51  3  
  7962	:  0011_1000  0x38   56  8  
  7963	:  0000_1000  0x08    8    
  7964	:  0100_0001  0x41   65  A  
  7965	:  0010_1101  0x2D   45  -  
  7966	:  0011_0101  0x35   53  5  
  7967	:  0011_0001  0x31   49  1  
  7968	:  0010_1101  0x2D   45  -  
  7969	:  0011_0000  0x30   48  0  
  7970	:  0011_0101  0x35   53  5  
  7971	:  0011_0111  0x37   55  7  
  7972	:  1100_0000  0xC0  192    
  7973	:  0000_1100  0x0C   12    
  7974	:  0000_0000  0x00    0    
  7975	:  0000_0001  0x01    1    
  7976	:  0000_0000  0x00    0    
  7977	:  0000_0001  0x01    1    
  7978	:  0000_0000  0x00    0    
  7979	:  0000_0000  0x00    0    
  7980	:  0010_1010  0x2A   42  *  
  7981	:  0011_0000  0x30   48  0  
  7982	:  0000_0000  0x00    0    
  7983	:  0000_0100  0x04    4    
  7984	:  0010_1101  0x2D   45  -  
  7985	:  0100_0011  0x43   67  C  
  7986	:  0011_0011  0x33   51  3  
  7987	:  0011_1001  0x39   57  9  
  7988	:  0000_1000  0x08    8    
  7989	:  0100_0001  0x41   65  A  
  7990	:  0010_1101  0x2D   45  -  
  7991	:  0011_0101  0x35   53  5  
  7992	:  0011_0001  0x31   49  1  
  7993	:  0010_1101  0x2D   45  -  
  7994	:  0011_0000  0x30   48  0  
  7995	:  0011_0101  0x35   53  5  
  7996	:  0011_1000  0x38   56  8  
  7997	:  1100_0000  0xC0  192    
  7998	:  0000_1100  0x0C   12    
  7999	:  0000_0000  0x00    0    
  8000	:  0000_0001  0x01    1    
  8001	:  0000_0000  0x00    0    
  8002	:  0000_0001  0x01    1    
  8003	:  0000_0000  0x00    0    
  8004	:  0000_0000  0x00    0    
  8005	:  0010_1010  0x2A   42  *  
  8006	:  0011_0000  0x30   48  0  
  8007	:  0000_0000  0x00    0    
  8008	:  0000_0100  0x04    4    
  8009	:  0010_1101  0x2D   45  -  
  8010	:  0100_0011  0x43   67  C  
  8011	:  0011_0011  0x33   51  3  
  8012	:  0011_1010  0x3A   58  :  
  8013	:  0000_1000  0x08    8    
  8014	:  0100_0001  0x41   65  A  
  8015	:  0010_1101  0x2D   45  -  
  8016	:  0011_0101  0x35   53  5  
  8017	:  0011_0001  0x31   49  1  
  8018	:  0010_1101  0x2D   45  -  
  8019	:  0011_0000  0x30   48  0  
  8020	:  0011_0101  0x35   53  5  
  8021	:  0011_1001  0x39   57  9  
  8022	:  1100_0000  0xC0  192    
  8023	:  0000_1100  0x0C   12    
  8024	:  0000_0000  0x00    0    
  8025	:  0000_0001  0x01    1    
  8026	:  0000_0000  0x00    0    
  8027	:  0000_0001  0x01    1    
  8028	:  0000_0000  0x00    0    
  8029	:  0000_0000  0x00    0    
  8030	:  0010_1010  0x2A   42  *  
  8031	:  0011_0000  0x30   48  0  
  8032	:  0000_0000  0x00    0    
  8033	:  0000_0100  0x04    4    
  8034	:  0010_1101  0x2D   45  -  
  8035	:  0100_0011  0x43   67  C  
  8036	:  0011_0011  0x33   51  3  
  8037	:  0011_1011  0x3B   59  ;  
  8038	:  0000_1000  0x08    8    
  8039	:  0100_0001  0x41   65  A  
  8040	:  0010_1101  0x2D   45  -  
  8041	:  0011_0101  0x35   53  5  
  8042	:  0011_0001  0x31   49  1  
  8043	:  0010_1101  0x2D   45  -  
  8044	:  0011_0000  0x30   48  0  
  8045	:  0011_0110  0x36   54  6  
  8046	:  0011_0000  0x30   48  0  
  8047	:  1100_0000  0xC0  192    
  8048	:  0000_1100  0x0C   12    
  8049	:  0000_0000  0x00    0    
  8050	:  0000_0001  0x01    1    
  8051	:  0000_0000  0x00    0    
  8052	:  0000_0001  0x01    1    
  8053	:  0000_0000  0x00    0    
  8054	:  0000_0000  0x00    0    
  8055	:  0010_1010  0x2A   42  *  
  8056	:  0011_0000  0x30   48  0  
  8057	:  0000_0000  0x00    0    
  8058	:  0000_0100  0x04    4    
  8059	:  0010_1101  0x2D   45  -  
  8060	:  0100_0011  0x43   67  C  
  8061	:  0011_0011  0x33   51  3  
  8062	:  0011_1100  0x3C   60  <  
  8063	:  0000_1000  0x08    8    
  8064	:  0100_0001  0x41   65  A  
  8065	:  0010_1101  0x2D   45  -  
  8066	:  0011_0101  0x35   53  5  
  8067	:  0011_0001  0x31   49  1  
  8068	:  0010_1101  0x2D   45  -  
  8069	:  0011_0000  0x30   48  0  
  8070	:  0011_0110  0x36   54  6  
  8071	:  0011_0001  0x31   49  1  
  8072	:  1100_0000  0xC0  192    
  8073	:  0000_1100  0x0C   12    
  8074	:  0000_0000  0x00    0    
  8075	:  0000_0001  0x01    1    
  8076	:  0000_0000  0x00    0    
  8077	:  0000_0001  0x01    1    
  8078	:  0000_0000  0x00    0    
  8079	:  0000_0000  0x00    0    
  8080	:  0010_1010  0x2A   42  *  
  8081	:  0011_0000  0x30   48  0  
  8082	:  0000_0000  0x00    0    
  8083	:  0000_0100  0x04    4    
  8084	:  0010_1101  0x2D   45  -  
  8085	:  0100_0011  0x43   67  C  
  8086	:  0011_0011  0x33   51  3  
  8087	:  0011_1101  0x3D   61  =  
  8088	:  0000_1000  0x08    8    
  8089	:  0100_0001  0x41   65  A  
  8090	:  0010_1101  0x2D   45  -  
  8091	:  0011_0101  0x35   53  5  
  8092	:  0011_0001  0x31   49  1  
  8093	:  0010_1101  0x2D   45  -  
  8094	:  0011_0000  0x30   48  0  
  8095	:  0011_0110  0x36   54  6  
  8096	:  0011_0010  0x32   50  2  
  8097	:  1100_0000  0xC0  192    
  8098	:  0000_1100  0x0C   12    
  8099	:  0000_0000  0x00    0    
  8100	:  0000_0001  0x01    1    
  8101	:  0000_0000  0x00    0    
  8102	:  0000_0001  0x01    1    
  8103	:  0000_0000  0x00    0    
  8104	:  0000_0000  0x00    0    
  8105	:  0010_1010  0x2A   42  *  
  8106	:  0011_0000  0x30   48  0  
  8107	:  0000_0000  0x00    0    
  8108	:  0000_0100  0x04    4    
  8109	:  0010_1101  0x2D   45  -  
  8110	:  0100_0011  0x43   67  C  
  8111	:  0011_0011  0x33   51  3  
  8112	:  0011_1110  0x3E   62  >  
  8113	:  0000_1000  0x08    8    
  8114	:  0100_0001  0x41   65  A  
  8115	:  0010_1101  0x2D   45  -  
  8116	:  0011_0101  0x35   53  5  
  8117	:  0011_0001  0x31   49  1  
  8118	:  0010_1101  0x2D   45  -  
  8119	:  0011_0000  0x30   48  0  
  8120	:  0011_0110  0x36   54  6  
  8121	:  0011_0011  0x33   51  3  
  8122	:  1100_0000  0xC0  192    
  8123	:  0000_1100  0x0C   12    
  8124	:  0000_0000  0x00    0    
  8125	:  0000_0001  0x01    1    
  8126	:  0000_0000  0x00    0    
  8127	:  0000_0001  0x01    1    
  8128	:  0000_0000  0x00    0    
  8129	:  0000_0000  0x00    0    
  8130	:  0010_1010  0x2A   42  *  
  8131	:  0011_0000  0x30   48  0  
  8132	:  0000_0000  0x00    0    
  8133	:  0000_0100  0x04    4    
  8134	:  0010_1101  0x2D   45  -  
  8135	:  0100_0011  0x43   67  C  
  8136	:  0011_0011  0x33   51  3  
  8137	:  0011_1111  0x3F   63  ?  
  8138	:  0000_1000  0x08    8    
  8139	:  0100_0001  0x41   65  A  
  8140	:  0010_1101  0x2D   45  -  
  8141	:  0011_0101  0x35   53  5  
  8142	:  0011_0001  0x31   49  1  
  8143	:  0010_1101  0x2D   45  -  
  8144	:  0011_0000  0x30   48  0  
  8145	:  0011_0110  0x36   54  6  
  8146	:  0011_0100  0x34   52  4  
  8147	:  1100_0000  0xC0  192    
  8148	:  0000_1100  0x0C   12    
  8149	:  0000_0000  0x00    0    
  8150	:  0000_0001  0x01    1    
  8151	:  0000_0000  0x00    0    
  8152	:  0000_0001  0x01    1    
  8153	:  0000_0000  0x00    0    
  8154	:  0000_0000  0x00    0    
  8155	:  0010_1010  0x2A   42  *  
  8156	:  0011_0000  0x30   48  0  
  8157	:  0000_0000  0x00    0    
  8158	:  0000_0100  0x04    4    
  8159	:  0010_1101  0x2D   45  -  
  8160	:  0100_0011  0x43   67  C  
  8161	:  0011_0011  0x33   51  3  
  8162	:  0100_0000  0x40   64  @  
  8163	:  0000_1000  0x08    8    
  8164	:  0100_0001  0x41   65  A  
  8165	:  0010_1101  0x2D   45  -  
  8166	:  0011_0101  0x35   53  5  
  8167	:  0011_0001  0x31   49  1  
  8168	:  0010_1101  0x2D   45  -  
  8169	:  0011_0000  0x30   48  0  
  8170	:  0011_0110  0x36   54  6  
  8171	:  0011_0101  0x35   53  5  
  8172	:  1100_0000  0xC0  192    
  8173	:  0000_1100  0x0C   12    
  8174	:  0000_0000  0x00    0    
  8175	:  0000_0001  0x01    1    
  8176	:  0000_0000  0x00    0    
  8177	:  0000_0001  0x01    1    
  8178	:  0000_0000  0x00    0    
  8179	:  0000_0000  0x00    0    
  8180	:  0010_1010  0x2A   42  *  
  8181	:  0011_0000  0x30   48  0  
  8182	:  0000_0000  0x00    0    
  8183	:  0000_0100  0x04    4    
  8184	:  0010_1101  0x2D   45  -  
  8185	:  0100_0011  0x43   67  C  
  8186	:  0011_0011  0x33   51  3  
  8187	:  0100_0001  0x41   65  A  
  8188	:  0000_1000  0x08    8    
  8189	:  0100_0001  0x41   65  A  
  8190	:  0010_1101  0x2D   45  -  
  8191	:  0011_0101  0x35   53  5  
  8192	:  0011_0001  0x31   49  1  
  8193	:  0010_1101  0x2D   45  -  
  8194	:  0011_0000  0x30   48  0  
  8195	:  0011_0110  0x36   54  6  
  8196	:  0011_0110  0x36   54  6  
  8197	:  1100_0000  0xC0  192    
  8198	:  0000_1100  0x0C   12    
  8199	:  0000_0000  0x00    0    
  8200	:  0000_0001  0x01    1    
  8201	:  0000_0000  0x00    0    
  8202	:  0000_0001  0x01    1    
  8203	:  0000_0000  0x00    0    
  8204	:  0000_0000  0x00    0    
  8205	:  0010_1010  0x2A   42  *  
  8206	:  0011_0000  0x30   48  0  
  8207	:  0000_0000  0x00    0    
  8208	:  0000_0100  0x04    4    
  8209	:  0010_1101  0x2D   45  -  
  8210	:  0100_0011  0x43   67  C  
  8211	:  0011_0011  0x33   51  3  
  8212	:  0100_0010  0x42   66  B  
  8213	:  0000_1000  0x08    8    
  8214	:  0100_0001  0x41   65  A  
  8215	:  0010_1101  0x2D   45  -  
  8216	:  0011_0101  0x35   53  5  
  8217	:  0011_0001  0x31   49  1  
  8218	:  0010_1101  0x2D   45  -  
  8219	:  0011_0000  0x30   48  0  
  8220	:  0011_0110  0x36   54  6  
  8221	:  0011_0111  0x37   55  7  
  8222	:  1100_0000  0xC0  192    
  8223	:  0000_1100  0x0C   12    
  8224	:  0000_0000  0x00    0    
  8225	:  0000_0001  0x01    1    
  8226	:  0000_0000  0x00    0    
  8227	:  0000_0001  0x01    1    
  8228	:  0000_0000  0x00    0    
  8229	:  0000_0000  0x00    0    
  8230	:  0010_1010  0x2A   42  *  
  8231	:  0011_0000  0x30   48  0  
  8232	:  0000_0000  0x00    0    
  8233	:  0000_0100  0x04    4    
  8234	:  0010_1101  0x2D   45  -  
  8235	:  0100_0011  0x43   67  C  
  8236	:  0011_0011  0x33   51  3  
  8237	:  0100_0011  0x43   67  C  
  8238	:  0000_1000  0x08    8    
  8239	:  0100_0001  0x41   65  A  
  8240	:  0010_1101  0x2D   45  -  
  8241	:  0011_0101  0x35   53  5  
  8242	:  0011_0001  0x31   49  1  
  8243	:  0010_1101  0x2D   45  -  
  8244	:  0011_0000  0x30   48  0  
  8245	:  0011_0110  0x36   54  6  
  8246	:  0011_1000  0x38   56  8  
  8247	:  1100_0000  0xC0  192    
  8248	:  0000_1100  0x0C   12    
  8249	:  0000_0000  0x00    0    
  8250	:  0000_0001  0x01    1    
  8251	:  0000_0000  0x00    0    
  8252	:  0000_0001  0x01    1    
  8253	:  0000_0000  0x00    0    
  8254	:  0000_0000  0x00    0    
  8255	:  0010_1010  0x2A   42  *  
  8256	:  0011_0000  0x30   48  0  
  8257	:  0000_0000  0x00    0    
  8258	:  0000_0100  0x04    4    
  8259	:  0010_1101  0x2D   45  -  
  8260	:  0100_0011  0x43   67  C  
  8261	:  0011_0011  0x33   51  3  
  8262	:  0100_0100  0x44   68  D  
  8263	:  0000_1000  0x08    8    
  8264	:  0100_0001  0x41   65  A  
  8265	:  0010_1101  0x2D   45  -  
  8266	:  0011_0101  0x35   53  5  
  8267	:  0011_0001  0x31   49  1  
  8268	:  0010_1101  0x2D   45  -  
  8269	:  0011_0000  0x30   48  0  
  8270	:  0011_0110  0x36   54  6  
  8271	:  0011_1001  0x39   57  9  
  8272	:  1100_0000  0xC0  192    
  8273	:  0000_1100  0x0C   12    
  8274	:  0000_0000  0x00    0    
  8275	:  0000_0001  0x01    1    
  8276	:  0000_0000  0x00    0    
  8277	:  0000_0001  0x01    1    
  8278	:  0000_0000  0x00    0    
  8279	:  0000_0000  0x00    0    
  8280	:  0010_1010  0x2A   42  *  
  8281	:  0011_0000  0x30   48  0  
  8282	:  0000_0000  0x00    0    
  8283	:  0000_0100  0x04    4    
  8284	:  0010_1101  0x2D   45  -  
  8285	:  0100_0011  0x43   67  C  
  8286	:  0011_0011  0x33   51  3  
  8287	:  0100_0101  0x45   69  E  
  8288	:  0000_1000  0x08    8    
  8289	:  0100_0001  0x41   65  A  
  8290	:  0010_1101  0x2D   45  -  
  8291	:  0011_0101  0x35   53  5  
  8292	:  0011_0001  0x31   49  1  
  8293	:  0010_1101  0x2D   45  -  
  8294	:  0011_0000  0x30   48  0  
  8295	:  0011_0111  0x37   55  7  
  8296	:  0011_0000  0x30   48  0  
  8297	:  1100_0000  0xC0  192    
  8298	:  0000_1100  0x0C   12    
  8299	:  0000_0000  0x00    0    
  8300	:  0000_0001  0x01    1    
  8301	:  0000_0000  0x00    0    
  8302	:  0000_0001  0x01    1    
  8303	:  0000_0000  0x00    0    
  8304	:  0000_0000  0x00    0    
  8305	:  0010_1010  0x2A   42  *  
  8306	:  0011_0000  0x30   48  0  
  8307	:  0000_0000  0x00    0    
  8308	:  0000_0100  0x04    4    
  8309	:  0010_1101  0x2D   45  -  
  8310	:  0100_0011  0x43   67  C  
  8311	:  0011_0011  0x33   51  3  
  8312	:  0100_0110  0x46   70  F  
  8313	:  0000_1000  0x08    8    
  8314	:  0100_0001  0x41   65  A  
  8315	:  0010_1101  0x2D   45  -  
  8316	:  0011_0101  0x35   53  5  
  8317	:  0011_0001  0x31   49  1  
  8318	:  0010_1101  0x2D   45  -  
  8319	:  0011_0000  0x30   48  0  
  8320	:  0011_0111  0x37   55  7  
  8321	:  0011_0001  0x31   49  1  
  8322	:  1100_0000  0xC0  192    
  8323	:  0000_1100  0x0C   12    
  8324	:  0000_0000  0x00    0    
  8325	:  0000_0001  0x01    1    
  8326	:  0000_0000  0x00    0    
  8327	:  0000_0001  0x01    1    
  8328	:  0000_0000  0x00    0    
  8329	:  0000_0000  0x00    0    
  8330	:  0010_1010  0x2A   42  *  
  8331	:  0011_0000  0x30   48  0  
  8332	:  0000_0000  0x00    0    
  8333	:  0000_0100  0x04    4    
  8334	:  0010_1101  0x2D   45  -  
  8335	:  0100_0011  0x43   67  C  
  8336	:  0011_0011  0x33   51  3  
  8337	:  0100_0111  0x47   71  G  
  8338	:  0000_1000  0x08    8    
  8339	:  0100_0001  0x41   65  A  
  8340	:  0010_1101  0x2D   45  -  
  8341	:  0011_0101  0x35   53  5  
  8342	:  0011_0001  0x31   49  1  
  8343	:  0010_1101  0x2D   45  -  
  8344	:  0011_0000  0x30   48  0  
  8345	:  0011_0111  0x37   55  7  
  8346	:  0011_0010  0x32   50  2  
  8347	:  1100_0000  0xC0  192    
  8348	:  0000_1100  0x0C   12    
  8349	:  0000_0000  0x00    0    
  8350	:  0000_0001  0x01    1    
  8351	:  0000_0000  0x00    0    
  8352	:  0000_0001  0x01    1    
  8353	:  0000_0000  0x00    0    
  8354	:  0000_0000  0x00    0    
  8355	:  0010_1010  0x2A   42  *  
  8356	:  0011_0000  0x30   48  0  
  8357	:  0000_0000  0x00    0    
  8358	:  0000_0100  0x04    4    
  8359	:  0010_1101  0x2D   45  -  
  8360	:  0100_0011  0x43   67  C  
  8361	:  0011_0011  0x33   51  3  
  8362	:  0100_1000  0x48   72  H  
  8363	:  0000_1000  0x08    8    
  8364	:  0100_0001  0x41   65  A  
  8365	:  0010_1101  0x2D   45  -  
  8366	:  0011_0101  0x35   53  5  
  8367	:  0011_0001  0x31   49  1  
  8368	:  0010_1101  0x2D   45  -  
  8369	:  0011_0000  0x30   48  0  
  8370	:  0011_0111  0x37   55  7  
  8371	:  0011_0011  0x33   51  3  
  8372	:  1100_0000  0xC0  192    
  8373	:  0000_1100  0x0C   12    
  8374	:  0000_0000  0x00    0    
  8375	:  0000_0001  0x01    1    
  8376	:  0000_0000  0x00    0    
  8377	:  0000_0001  0x01    1    
  8378	:  0000_0000  0x00    0    
  8379	:  0000_0000  0x00    0    
  8380	:  0010_1010  0x2A   42  *  
  8381	:  0011_0000  0x30   48  0  
  8382	:  0000_0000  0x00    0    
  8383	:  0000_0100  0x04    4    
  8384	:  0010_1101  0x2D   45  -  
  8385	:  0100_0011  0x43   67  C  
  8386	:  0011_0011  0x33   51  3  
  8387	:  0100_1001  0x49   73  I  
  8388	:  0000_1000  0x08    8    
  8389	:  0100_0001  0x41   65  A  
  8390	:  0010_1101  0x2D   45  -  
  8391	:  0011_0101  0x35   53  5  
  8392	:  0011_0001  0x31   49  1  
  8393	:  0010_1101  0x2D   45  -  
  8394	:  0011_0000  0x30   48  0  
  8395	:  0011_0111  0x37   55  7  
  8396	:  0011_0100  0x34   52  4  
  8397	:  1100_0000  0xC0  192    
  8398	:  0000_1100  0x0C   12    
  8399	:  0000_0000  0x00    0    
  8400	:  0000_0001  0x01    1    
  8401	:  0000_0000  0x00    0    
  8402	:  0000_0001  0x01    1    
  8403	:  0000_0000  0x00    0    
  8404	:  0000_0000  0x00    0    
  8405	:  0010_1010  0x2A   42  *  
  8406	:  0011_0000  0x30   48  0  
  8407	:  0000_0000  0x00    0    
  8408	:  0000_0100  0x04    4    
  8409	:  0010_1101  0x2D   45  -  
  8410	:  0100_0011  0x43   67  C  
  8411	:  0011_0011  0x33   51  3  
  8412	:  0100_1010  0x4A   74  J  
  8413	:  0000_1000  0x08    8    
  8414	:  0100_0001  0x41   65  A  
  8415	:  0010_1101  0x2D   45  -  
  8416	:  0011_0101  0x35   53  5  
  8417	:  0011_0001  0x31   49  1  
  8418	:  0010_1101  0x2D   45  -  
  8419	:  0011_0000  0x30   48  0  
  8420	:  0011_0111  0x37   55  7  
  8421	:  0011_0101  0x35   53  5  
  8422	:  1100_0000  0xC0  192    
  8423	:  0000_1100  0x0C   12    
  8424	:  0000_0000  0x00    0    
  8425	:  0000_0001  0x01    1    
  8426	:  0000_0000  0x00    0    
  8427	:  0000_0001  0x01    1    
  8428	:  0000_0000  0x00    0    
  8429	:  0000_0000  0x00    0    
  8430	:  0010_1010  0x2A   42  *  
  8431	:  0011_0000  0x30   48  0  
  8432	:  0000_0000  0x00    0    
  8433	:  0000_0100  0x04    4    
  8434	:  0010_1101  0x2D   45  -  
  8435	:  0100_0011  0x43   67  C  
  8436	:  0011_0011  0x33   51  3  
  8437	:  0100_1011  0x4B   75  K  
  8438	:  0000_1000  0x08    8    
  8439	:  0100_0001  0x41   65  A  
  8440	:  0010_1101  0x2D   45  -  
  8441	:  0011_0101  0x35   53  5  
  8442	:  0011_0001  0x31   49  1  
  8443	:  0010_1101  0x2D   45  -  
  8444	:  0011_0000  0x30   48  0  
  8445	:  0011_0111  0x37   55  7  
  8446	:  0011_0110  0x36   54  6  
  8447	:  1100_0000  0xC0  192    
  8448	:  0000_1100  0x0C   12    
  8449	:  0000_0000  0x00    0    
  8450	:  0000_0001  0x01    1    
  8451	:  0000_0000  0x00    0    
  8452	:  0000_0001  0x01    1    
  8453	:  0000_0000  0x00    0    
  8454	:  0000_0000  0x00    0    
  8455	:  0010_1010  0x2A   42  *  
  8456	:  0011_0000  0x30   48  0  
  8457	:  0000_0000  0x00    0    
  8458	:  0000_0100  0x04    4    
  8459	:  0010_1101  0x2D   45  -  
  8460	:  0100_0011  0x43   67  C  
  8461	:  0011_0011  0x33   51  3  
  8462	:  0100_1100  0x4C   76  L  
  8463	:  0000_1000  0x08    8    
  8464	:  0100_0001  0x41   65  A  
  8465	:  0010_1101  0x2D   45  -  
  8466	:  0011_0101  0x35   53  5  
  8467	:  0011_0001  0x31   49  1  
  8468	:  0010_1101  0x2D   45  -  
  8469	:  0011_0000  0x30   48  0  
  8470	:  0011_0111  0x37   55  7  
  8471	:  0011_0111  0x37   55  7  
  8472	:  1100_0000  0xC0  192    
  8473	:  0000_1100  0x0C   12    
  8474	:  0000_0000  0x00    0    
  8475	:  0000_0001  0x01    1    
  8476	:  0000_0000  0x00    0    
  8477	:  0000_0001  0x01    1    
  8478	:  0000_0000  0x00    0    
  8479	:  0000_0000  0x00    0    
  8480	:  0010_1010  0x2A   42  *  
  8481	:  0011_0000  0x30   48  0  
  8482	:  0000_0000  0x00    0    
  8483	:  0000_0100  0x04    4    
  8484	:  0010_1101  0x2D   45  -  
  8485	:  0100_0011  0x43   67  C  
  8486	:  0011_0011  0x33   51  3  
  8487	:  0100_1101  0x4D   77  M  
  8488	:  0000_1000  0x08    8    
  8489	:  0100_0001  0x41   65  A  
  8490	:  0010_1101  0x2D   45  -  
  8491	:  0011_0101  0x35   53  5  
  8492	:  0011_0001  0x31   49  1  
  8493	:  0010_1101  0x2D   45  -  
  8494	:  0011_0000  0x30   48  0  
  8495	:  0011_0111  0x37   55  7  
  8496	:  0011_1000  0x38   56  8  
  8497	:  1100_0000  0xC0  192    
  8498	:  0000_1100  0x0C   12    
  8499	:  0000_0000  0x00    0    
  8500	:  0000_0001  0x01    1    
  8501	:  0000_0000  0x00    0    
  8502	:  0000_0001  0x01    1    
  8503	:  0000_0000  0x00    0    
  8504	:  0000_0000  0x00    0    
  8505	:  0010_1010  0x2A   42  *  
  8506	:  0011_0000  0x30   48  0  
  8507	:  0000_0000  0x00    0    
  8508	:  0000_0100  0x04    4    
  8509	:  0010_1101  0x2D   45  -  
  8510	:  0100_0011  0x43   67  C  
  8511	:  0011_0011  0x33   51  3  
  8512	:  0100_1110  0x4E   78  N  
  8513	:  0000_1000  0x08    8    
  8514	:  0100_0001  0x41   65  A  
  8515	:  0010_1101  0x2D   45  -  
  8516	:  0011_0101  0x35   53  5  
  8517	:  0011_0001  0x31   49  1  
  8518	:  0010_1101  0x2D   45  -  
  8519	:  0011_0000  0x30   48  0  
  8520	:  0011_0111  0x37   55  7  
  8521	:  0011_1001  0x39   57  9  
  8522	:  1100_0000  0xC0  192    
  8523	:  0000_1100  0x0C   12    
  8524	:  0000_0000  0x00    0    
  8525	:  0000_0001  0x01    1    
  8526	:  0000_0000  0x00    0    
  8527	:  0000_0001  0x01    1    
  8528	:  0000_0000  0x00    0    
  8529	:  0000_0000  0x00    0    
  8530	:  0010_1010  0x2A   42  *  
  8531	:  0011_0000  0x30   48  0  
  8532	:  0000_0000  0x00    0    
  8533	:  0000_0100  0x04    4    
  8534	:  0010_1101  0x2D   45  -  
  8535	:  0100_0011  0x43   67  C  
  8536	:  0011_0011  0x33   51  3  
  8537	:  0100_1111  0x4F   79  O  
  8538	:  0000_1000  0x08    8    
  8539	:  0100_0001  0x41   65  A  
  8540	:  0010_1101  0x2D   45  -  
  8541	:  0011_0101  0x35   53  5  
  8542	:  0011_0001  0x31   49  1  
  8543	:  0010_1101  0x2D   45  -  
  8544	:  0011_0000  0x30   48  0  
  8545	:  0011_1000  0x38   56  8  
  8546	:  0011_0000  0x30   48  0  
  8547	:  1100_0000  0xC0  192    
  8548	:  0000_1100  0x0C   12    
  8549	:  0000_0000  0x00    0    
  8550	:  0000_0001  0x01    1    
  8551	:  0000_0000  0x00    0    
  8552	:  0000_0001  0x01    1    
  8553	:  0000_0000  0x00    0    
  8554	:  0000_0000  0x00    0    
  8555	:  0010_1010  0x2A   42  *  
  8556	:  0011_0000  0x30   48  0  
  8557	:  0000_0000  0x00    0    
  8558	:  0000_0100  0x04    4    
  8559	:  0010_1101  0x2D   45  -  
  8560	:  0100_0011  0x43   67  C  
  8561	:  0011_0011  0x33   51  3  
  8562	:  0101_0000  0x50   80  P  
  8563	:  0000_1000  0x08    8    
  8564	:  0100_0001  0x41   65  A  
  8565	:  0010_1101  0x2D   45  -  
  8566	:  0011_0101  0x35   53  5  
  8567	:  0011_0001  0x31   49  1  
  8568	:  0010_1101  0x2D   45  -  
  8569	:  0011_0000  0x30   48  0  
  8570	:  0011_1000  0x38   56  8  
  8571	:  0011_0001  0x31   49  1  
  8572	:  1100_0000  0xC0  192    
  8573	:  0000_1100  0x0C   12    
  8574	:  0000_0000  0x00    0    
  8575	:  0000_0001  0x01    1    
  8576	:  0000_0000  0x00    0    
  8577	:  0000_0001  0x01    1    
  8578	:  0000_0000  0x00    0    
  8579	:  0000_0000  0x00    0    
  8580	:  0010_1010  0x2A   42  *  
  8581	:  0011_0000  0x30   48  0  
  8582	:  0000_0000  0x00    0    
  8583	:  0000_0100  0x04    4    
  8584	:  0010_1101  0x2D   45  -  
  8585	:  0100_0011  0x43   67  C  
  8586	:  0011_0011  0x33   51  3  
  8587	:  0101_0001  0x51   81  Q  
  8588	:  0000_1000  0x08    8    
  8589	:  0100_0001  0x41   65  A  
  8590	:  0010_1101  0x2D   45  -  
  8591	:  0011_0101  0x35   53  5  
  8592	:  0011_0001  0x31   49  1  
  8593	:  0010_1101  0x2D   45  -  
  8594	:  0011_0000  0x30   48  0  
  8595	:  0011_1000  0x38   56  8  
  8596	:  0011_0010  0x32   50  2  
  8597	:  1100_0000  0xC0  192    
  8598	:  0000_1100  0x0C   12    
  8599	:  0000_0000  0x00    0    
  8600	:  0000_0001  0x01    1    
  8601	:  0000_0000  0x00    0    
  8602	:  0000_0001  0x01    1    
  8603	:  0000_0000  0x00    0    
  8604	:  0000_0000  0x00    0    
  8605	:  0010_1010  0x2A   42  *  
  8606	:  0011_0000  0x30   48  0  
  8607	:  0000_0000  0x00    0    
  8608	:  0000_0100  0x04    4    
  8609	:  0010_1101  0x2D   45  -  
  8610	:  0100_0011  0x43   67  C  
  8611	:  0011_0011  0x33   51  3  
  8612	:  0101_0010  0x52   82  R  
  8613	:  0000_1000  0x08    8    
  8614	:  0100_0001  0x41   65  A  
  8615	:  0010_1101  0x2D   45  -  
  8616	:  0011_0101  0x35   53  5  
  8617	:  0011_0001  0x31   49  1  
  8618	:  0010_1101  0x2D   45  -  
  8619	:  0011_0000  0x30   48  0  
  8620	:  0011_1000  0x38   56  8  
  8621	:  0011_0011  0x33   51  3  
  8622	:  1100_0000  0xC0  192    
  8623	:  0000_1100  0x0C   12    
  8624	:  0000_0000  0x00    0    
  8625	:  0000_0001  0x01    1    
  8626	:  0000_0000  0x00    0    
  8627	:  0000_0001  0x01    1    
  8628	:  0000_0000  0x00    0    
  8629	:  0000_0000  0x00    0    
  8630	:  0010_1010  0x2A   42  *  
  8631	:  0011_0000  0x30   48  0  
  8632	:  0000_0000  0x00    0    
  8633	:  0000_0100  0x04    4    
  8634	:  0010_1101  0x2D   45  -  
  8635	:  0100_0011  0x43   67  C  
  8636	:  0011_0011  0x33   51  3  
  8637	:  0101_0011  0x53   83  S  
  8638	:  0000_1000  0x08    8    
  8639	:  0100_0001  0x41   65  A  
  8640	:  0010_1101  0x2D   45  -  
  8641	:  0011_0101  0x35   53  5  
  8642	:  0011_0001  0x31   49  1  
  8643	:  0010_1101  0x2D   45  -  
  8644	:  0011_0000  0x30   48  0  
  8645	:  0011_1000  0x38   56  8  
  8646	:  0011_0100  0x34   52  4  
  8647	:  1100_0000  0xC0  192    
  8648	:  0000_1100  0x0C   12    
  8649	:  0000_0000  0x00    0    
  8650	:  0000_0001  0x01    1    
  8651	:  0000_0000  0x00    0    
  8652	:  0000_0001  0x01    1    
  8653	:  0000_0000  0x00    0    
  8654	:  0000_0000  0x00    0    
  8655	:  0010_1010  0x2A   42  *  
  8656	:  0011_0000  0x30   48  0  
  8657	:  0000_0000  0x00    0    
  8658	:  0000_0100  0x04    4    
  8659	:  0010_1101  0x2D   45  -  
  8660	:  0100_0011  0x43   67  C  
  8661	:  0011_0011  0x33   51  3  
  8662	:  0101_0100  0x54   84  T  
  8663	:  0000_1000  0x08    8    
  8664	:  0100_0001  0x41   65  A  
  8665	:  0010_1101  0x2D   45  -  
  8666	:  0011_0101  0x35   53  5  
  8667	:  0011_0001  0x31   49  1  
  8668	:  0010_1101  0x2D   45  -  
  8669	:  0011_0000  0x30   48  0  
  8670	:  0011_1000  0x38   56  8  
  8671	:  0011_0101  0x35   53  5  
  8672	:  1100_0000  0xC0  192    
  8673	:  0000_1100  0x0C   12    
  8674	:  0000_0000  0x00    0    
  8675	:  0000_0001  0x01    1    
  8676	:  0000_0000  0x00    0    
  8677	:  0000_0001  0x01    1    
  8678	:  0000_0000  0x00    0    
  8679	:  0000_0000  0x00    0    
  8680	:  0010_1010  0x2A   42  *  
  8681	:  0011_0000  0x30   48  0  
  8682	:  0000_0000  0x00    0    
  8683	:  0000_0100  0x04    4    
  8684	:  0010_1101  0x2D   45  -  
  8685	:  0100_0011  0x43   67  C  
  8686	:  0011_0011  0x33   51  3  
  8687	:  0101_0101  0x55   85  U  
  8688	:  0000_1000  0x08    8    
  8689	:  0100_0001  0x41   65  A  
  8690	:  0010_1101  0x2D   45  -  
  8691	:  0011_0101  0x35   53  5  
  8692	:  0011_0001  0x31   49  1  
  8693	:  0010_1101  0x2D   45  -  
  8694	:  0011_0000  0x30   48  0  
  8695	:  0011_1000  0x38   56  8  
  8696	:  0011_0110  0x36   54  6  
  8697	:  1100_0000  0xC0  192    
  8698	:  0000_1100  0x0C   12    
  8699	:  0000_0000  0x00    0    
  8700	:  0000_0001  0x01    1    
  8701	:  0000_0000  0x00    0    
  8702	:  0000_0001  0x01    1    
  8703	:  0000_0000  0x00    0    
  8704	:  0000_0000  0x00    0    
  8705	:  0010_1010  0x2A   42  *  
  8706	:  0011_0000  0x30   48  0  
  8707	:  0000_0000  0x00    0    
  8708	:  0000_0100  0x04    4    
  8709	:  0010_1101  0x2D   45  -  
  8710	:  0100_0011  0x43   67  C  
  8711	:  0011_0011  0x33   51  3  
  8712	:  0101_0110  0x56   86  V  
  8713	:  0000_1000  0x08    8    
  8714	:  0100_0001  0x41   65  A  
  8715	:  0010_1101  0x2D   45  -  
  8716	:  0011_0101  0x35   53  5  
  8717	:  0011_0001  0x31   49  1  
  8718	:  0010_1101  0x2D   45  -  
  8719	:  0011_0000  0x30   48  0  
  8720	:  0011_1000  0x38   56  8  
  8721	:  0011_0111  0x37   55  7  
  8722	:  1100_0000  0xC0  192    
  8723	:  0000_1100  0x0C   12    
  8724	:  0000_0000  0x00    0    
  8725	:  0000_0001  0x01    1    
  8726	:  0000_0000  0x00    0    
  8727	:  0000_0001  0x01    1    
  8728	:  0000_0000  0x00    0    
  8729	:  0000_0000  0x00    0    
  8730	:  0010_1010  0x2A   42  *  
  8731	:  0011_0000  0x30   48  0  
  8732	:  0000_0000  0x00    0    
  8733	:  0000_0100  0x04    4    
  8734	:  0010_1101  0x2D   45  -  
  8735	:  0100_0011  0x43   67  C  
  8736	:  0011_0011  0x33   51  3  
  8737	:  0101_0111  0x57   87  W  
  8738	:  0000_1000  0x08    8    
  8739	:  0100_0001  0x41   65  A  
  8740	:  0010_1101  0x2D   45  -  
  8741	:  0011_0101  0x35   53  5  
  8742	:  0011_0001  0x31   49  1  
  8743	:  0010_1101  0x2D   45  -  
  8744	:  0011_0000  0x30   48  0  
  8745	:  0011_1000  0x38   56  8  
  8746	:  0011_1000  0x38   56  8  
  8747	:  1100_0000  0xC0  192    
  8748	:  0000_1100  0x0C   12    
  8749	:  0000_0000  0x00    0    
  8750	:  0000_0001  0x01    1    
  8751	:  0000_0000  0x00    0    
  8752	:  0000_0001  0x01    1    
  8753	:  0000_0000  0x00    0    
  8754	:  0000_0000  0x00    0    
  8755	:  0010_1010  0x2A   42  *  
  8756	:  0011_0000  0x30   48  0  
  8757	:  0000_0000  0x00    0    
  8758	:  0000_0100  0x04    4    
  8759	:  0010_1101  0x2D   45  -  
  8760	:  0100_0011  0x43   67  C  
  8761	:  0011_0011  0x33   51  3  
  8762	:  0101_1000  0x58   88  X  
  8763	:  0000_1000  0x08    8    
  8764	:  0100_0001  0x41   65  A  
  8765	:  0010_1101  0x2D   45  -  
  8766	:  0011_0101  0x35   53  5  
  8767	:  0011_0001  0x31   49  1  
  8768	:  0010_1101  0x2D   45  -  
  8769	:  0011_0000  0x30   48  0  
  8770	:  0011_1000  0x38   56  8  
  8771	:  0011_1001  0x39   57  9  
  8772	:  1100_0000  0xC0  192    
  8773	:  0000_1100  0x0C   12    
  8774	:  0000_0000  0x00    0    
  8775	:  0000_0001  0x01    1    
  8776	:  0000_0000  0x00    0    
  8777	:  0000_0001  0x01    1    
  8778	:  0000_0000  0x00    0    
  8779	:  0000_0000  0x00    0    
  8780	:  0010_1010  0x2A   42  *  
  8781	:  0011_0000  0x30   48  0  
  8782	:  0000_0000  0x00    0    
  8783	:  0000_0100  0x04    4    
  8784	:  0010_1101  0x2D   45  -  
  8785	:  0100_0011  0x43   67  C  
  8786	:  0011_0011  0x33   51  3  
  8787	:  0101_1001  0x59   89  Y  
  8788	:  0000_1000  0x08    8    
  8789	:  0100_0001  0x41   65  A  
  8790	:  0010_1101  0x2D   45  -  
  8791	:  0011_0101  0x35   53  5  
  8792	:  0011_0001  0x31   49  1  
  8793	:  0010_1101  0x2D   45  -  
  8794	:  0011_0000  0x30   48  0  
  8795	:  0011_1001  0x39   57  9  
  8796	:  0011_0000  0x30   48  0  
  8797	:  1100_0000  0xC0  192    
  8798	:  0000_1100  0x0C   12    
  8799	:  0000_0000  0x00    0    
  8800	:  0000_0001  0x01    1    
  8801	:  0000_0000  0x00    0    
  8802	:  0000_0001  0x01    1    
  8803	:  0000_0000  0x00    0    
  8804	:  0000_0000  0x00    0    
  8805	:  0010_1010  0x2A   42  *  
  8806	:  0011_0000  0x30   48  0  
  8807	:  0000_0000  0x00    0    
  8808	:  0000_0100  0x04    4    
  8809	:  0010_1101  0x2D   45  -  
  8810	:  0100_0011  0x43   67  C  
  8811	:  0011_0011  0x33   51  3  
  8812	:  0101_1010  0x5A   90  Z  
  8813	:  0000_1000  0x08    8    
  8814	:  0100_0001  0x41   65  A  
  8815	:  0010_1101  0x2D   45  -  
  8816	:  0011_0101  0x35   53  5  
  8817	:  0011_0001  0x31   49  1  
  8818	:  0010_1101  0x2D   45  -  
  8819	:  0011_0000  0x30   48  0  
  8820	:  0011_1001  0x39   57  9  
  8821	:  0011_0001  0x31   49  1  
  8822	:  1100_0000  0xC0  192    
  8823	:  0000_1100  0x0C   12    
  8824	:  0000_0000  0x00    0    
  8825	:  0000_0001  0x01    1    
  8826	:  0000_0000  0x00    0    
  8827	:  0000_0001  0x01    1    
  8828	:  0000_0000  0x00    0    
  8829	:  0000_0000  0x00    0    
  8830	:  0010_1010  0x2A   42  *  
  8831	:  0011_0000  0x30   48  0  
  8832	:  0000_0000  0x00    0    
  8833	:  0000_0100  0x04    4    
  8834	:  0010_1101  0x2D   45  -  
  8835	:  0100_0011  0x43   67  C  
  8836	:  0011_0011  0x33   51  3  
  8837	:  0101_1011  0x5B   91  [  
  8838	:  0000_1000  0x08    8    
  8839	:  0100_0001  0x41   65  A  
  8840	:  0010_1101  0x2D   45  -  
  8841	:  0011_0101  0x35   53  5  
  8842	:  0011_0001  0x31   49  1  
  8843	:  0010_1101  0x2D   45  -  
  8844	:  0011_0000  0x30   48  0  
  8845	:  0011_1001  0x39   57  9  
  8846	:  0011_0010  0x32   50  2  
  8847	:  1100_0000  0xC0  192    
  8848	:  0000_1100  0x0C   12    
  8849	:  0000_0000  0x00    0    
  8850	:  0000_0001  0x01    1    
  8851	:  0000_0000  0x00    0    
  8852	:  0000_0001  0x01    1    
  8853	:  0000_0000  0x00    0    
  8854	:  0000_0000  0x00    0    
  8855	:  0010_1010  0x2A   42  *  
  8856	:  0011_0000  0x30   48  0  
  8857	:  0000_0000  0x00    0    
  8858	:  0000_0100  0x04    4    
  8859	:  0010_1101  0x2D   45  -  
  8860	:  0100_0011  0x43   67  C  
  8861	:  0011_0011  0x33   51  3  
  8862	:  0101_1100  0x5C   92  \  
  8863	:  0000_1000  0x08    8    
  8864	:  0100_0001  0x41   65  A  
  8865	:  0010_1101  0x2D   45  -  
  8866	:  0011_0101  0x35   53  5  
  8867	:  0011_0001  0x31   49  1  
  8868	:  0010_1101  0x2D   45  -  
  8869	:  0011_0000  0x30   48  0  
  8870	:  0011_1001  0x39   57  9  
  8871	:  0011_0011  0x33   51  3  
  8872	:  1100_0000  0xC0  192    
  8873	:  0000_1100  0x0C   12    
  8874	:  0000_0000  0x00    0    
  8875	:  0000_0001  0x01    1    
  8876	:  0000_0000  0x00    0    
  8877	:  0000_0001  0x01    1    
  8878	:  0000_0000  0x00    0    
  8879	:  0000_0000  0x00    0    
  8880	:  0010_1010  0x2A   42  *  
  8881	:  0011_0000  0x30   48  0  
  8882	:  0000_0000  0x00    0    
  8883	:  0000_0100  0x04    4    
  8884	:  0010_1101  0x2D   45  -  
  8885	:  0100_0011  0x43   67  C  
  8886	:  0011_0011  0x33   51  3  
  8887	:  0101_1101  0x5D   93  ]  
  8888	:  0000_1000  0x08    8    
  8889	:  0100_0001  0x41   65  A  
  8890	:  0010_1101  0x2D   45  -  
  8891	:  0011_0101  0x35   53  5  
  8892	:  0011_0001  0x31   49  1  
  8893	:  0010_1101  0x2D   45  -  
  8894	:  0011_0000  0x30   48  0  
  8895	:  0011_1001  0x39   57  9  
  8896	:  0011_0100  0x34   52  4  
  8897	:  1100_0000  0xC0  192    
  8898	:  0000_1100  0x0C   12    
  8899	:  0000_0000  0x00    0    
  8900	:  0000_0001  0x01    1    
  8901	:  0000_0000  0x00    0    
  8902	:  0000_0001  0x01    1    
  8903	:  0000_0000  0x00    0    
  8904	:  0000_0000  0x00    0    
  8905	:  0010_1010  0x2A   42  *  
  8906	:  0011_0000  0x30   48  0  
  8907	:  0000_0000  0x00    0    
  8908	:  0000_0100  0x04    4    
  8909	:  0010_1101  0x2D   45  -  
  8910	:  0100_0011  0x43   67  C  
  8911	:  0011_0011  0x33   51  3  
  8912	:  0101_1110  0x5E   94  ^  
  8913	:  0000_1000  0x08    8    
  8914	:  0100_0001  0x41   65  A  
  8915	:  0010_1101  0x2D   45  -  
  8916	:  0011_0101  0x35   53  5  
  8917	:  0011_0001  0x31   49  1  
  8918	:  0010_1101  0x2D   45  -  
  8919	:  0011_0000  0x30   48  0  
  8920	:  0011_1001  0x39   57  9  
  8921	:  0011_0101  0x35   53  5  
  8922	:  1100_0000  0xC0  192    
  8923	:  0000_1100  0x0C   12    
  8924	:  0000_0000  0x00    0    
  8925	:  0000_0001  0x01    1    
  8926	:  0000_0000  0x00    0    
  8927	:  0000_0001  0x01    1    
  8928	:  0000_0000  0x00    0    
  8929	:  0000_0000  0x00    0    
  8930	:  0010_1010  0x2A   42  *  
  8931	:  0011_0000  0x30   48  0  
  8932	:  0000_0000  0x00    0    
  8933	:  0000_0100  0x04    4    
  8934	:  0010_1101  0x2D   45  -  
  8935	:  0100_0011  0x43   67  C  
  8936	:  0011_0011  0x33   51  3  
  8937	:  0101_1111  0x5F   95  _  
  8938	:  0000_1000  0x08    8    
  8939	:  0100_0001  0x41   65  A  
  8940	:  0010_1101  0x2D   45  -  
  8941	:  0011_0101  0x35   53  5  
  8942	:  0011_0001  0x31   49  1  
  8943	:  0010_1101  0x2D   45  -  
  8944	:  0011_0000  0x30   48  0  
  8945	:  0011_1001  0x39   57  9  
  8946	:  0011_0110  0x36   54  6  
  8947	:  1100_0000  0xC0  192    
  8948	:  0000_1100  0x0C   12    
  8949	:  0000_0000  0x00    0    
  8950	:  0000_0001  0x01    1    
  8951	:  0000_0000  0x00    0    
  8952	:  0000_0001  0x01    1    
  8953	:  0000_0000  0x00    0    
  8954	:  0000_0000  0x00    0    
  8955	:  0010_1010  0x2A   42  *  
  8956	:  0011_0000  0x30   48  0  
  8957	:  0000_0000  0x00    0    
  8958	:  0000_0100  0x04    4    
  8959	:  0010_1101  0x2D   45  -  
  8960	:  0100_0011  0x43   67  C  
  8961	:  0011_0011  0x33   51  3  
  8962	:  0110_0000  0x60   96  `  
  8963	:  0000_1000  0x08    8    
  8964	:  0100_0001  0x41   65  A  
  8965	:  0010_1101  0x2D   45  -  
  8966	:  0011_0101  0x35   53  5  
  8967	:  0011_0001  0x31   49  1  
  8968	:  0010_1101  0x2D   45  -  
  8969	:  0011_0000  0x30   48  0  
  8970	:  0011_1001  0x39   57  9  
  8971	:  0011_0111  0x37   55  7  
  8972	:  1100_0000  0xC0  192    
  8973	:  0000_1100  0x0C   12    
  8974	:  0000_0000  0x00    0    
  8975	:  0000_0001  0x01    1    
  8976	:  0000_0000  0x00    0    
  8977	:  0000_0001  0x01    1    
  8978	:  0000_0000  0x00    0    
  8979	:  0000_0000  0x00    0    
  8980	:  0010_1010  0x2A   42  *  
  8981	:  0011_0000  0x30   48  0  
  8982	:  0000_0000  0x00    0    
  8983	:  0000_0100  0x04    4    
  8984	:  0010_1101  0x2D   45  -  
  8985	:  0100_0011  0x43   67  C  
  8986	:  0011_0011  0x33   51  3  
  8987	:  0110_0001  0x61   97  a  
  8988	:  0000_1000  0x08    8    
  8989	:  0100_0001  0x41   65  A  
  8990	:  0010_1101  0x2D   45  -  
  8991	:  0011_0101  0x35   53  5  
  8992	:  0011_0001  0x31   49  1  
  8993	:  0010_1101  0x2D   45  -  
  8994	:  0011_0000  0x30   48  0  
  8995	:  0011_1001  0x39   57  9  
  8996	:  0011_1000  0x38   56  8  
  8997	:  1100_0000  0xC0  192    
  8998	:  0000_1100  0x0C   12    
  8999	:  0000_0000  0x00    0    
  9000	:  0000_0001  0x01    1    
  9001	:  0000_0000  0x00    0    
  9002	:  0000_0001  0x01    1    
  9003	:  0000_0000  0x00    0    
  9004	:  0000_0000  0x00    0    
  9005	:  0010_1010  0x2A   42  *  
  9006	:  0011_0000  0x30   48  0  
  9007	:  0000_0000  0x00    0    
  9008	:  0000_0100  0x04    4    
  9009	:  0010_1101  0x2D   45  -  
  9010	:  0100_0011  0x43   67  C  
  9011	:  0011_0011  0x33   51  3  
  9012	:  0110_0010  0x62   98  b  
  9013	:  0000_1000  0x08    8    
  9014	:  0100_0001  0x41   65  A  
  9015	:  0010_1101  0x2D   45  -  
  9016	:  0011_0101  0x35   53  5  
  9017	:  0011_0001  0x31   49  1  
  9018	:  0010_1101  0x2D   45  -  
  9019	:  0011_0000  0x30   48  0  
  9020	:  0011_1001  0x39   57  9  
  9021	:  0011_1001  0x39   57  9  
  9022	:  1100_0000  0xC0  192    
  9023	:  0000_1100  0x0C   12    
  9024	:  0000_0000  0x00    0    
  9025	:  0000_0001  0x01    1    
  9026	:  0000_0000  0x00    0    
  9027	:  0000_0001  0x01    1    
  9028	:  0000_0000  0x00    0    
  9029	:  0000_0000  0x00    0    
  9030	:  0010_1010  0x2A   42  *  
  9031	:  0011_0000  0x30   48  0  
  9032	:  0000_0000  0x00    0    
  9033	:  0000_0100  0x04    4    
  9034	:  0010_1101  0x2D   45  -  
  9035	:  0100_0011  0x43   67  C  
  9036	:  0011_0011  0x33   51  3  
  9037	:  0110_0011  0x63   99  c  
  9038	:  0000_1000  0x08    8    
  9039	:  0100_0001  0x41   65  A  
  9040	:  0010_1101  0x2D   45  -  
  9041	:  0011_0101  0x35   53  5  
  9042	:  0011_0001  0x31   49  1  
  9043	:  0010_1101  0x2D   45  -  
  9044	:  0011_0001  0x31   49  1  
  9045	:  0011_0000  0x30   48  0  
  9046	:  0011_0000  0x30   48  0  
  9047	:  1100_0000  0xC0  192    
  9048	:  0000_1100  0x0C   12    
  9049	:  0000_0000  0x00    0    
  9050	:  0000_0001  0x01    1    
  9051	:  0000_0000  0x00    0    
  9052	:  0000_0001  0x01    1    
  9053	:  0000_0000  0x00    0    
  9054	:  0000_0000  0x00    0    
  9055	:  0010_1010  0x2A   42  *  
  9056	:  0011_0000  0x30   48  0  
  9057	:  0000_0000  0x00    0    
  9058	:  0000_0100  0x04    4    
  9059	:  0010_1101  0x2D   45  -  
  9060	:  0100_0011  0x43   67  C  
  9061	:  0011_0011  0x33   51  3  
  9062	:  0110_0100  0x64  100  d  
  9063	:  0000_1000  0x08    8    
  9064	:  0100_0001  0x41   65  A  
  9065	:  0010_1101  0x2D   45  -  
  9066	:  0011_0101  0x35   53  5  
  9067	:  0011_0001  0x31   49  1  
  9068	:  0010_1101  0x2D   45  -  
  9069	:  0011_0001  0x31   49  1  
  9070	:  0011_0000  0x30   48  0  
  9071	:  0011_0001  0x31   49  1  
  9072	:  1100_0000  0xC0  192    
  9073	:  0000_1100  0x0C   12    
  9074	:  0000_0000  0x00    0    
  9075	:  0000_0001  0x01    1    
  9076	:  0000_0000  0x00    0    
  9077	:  0000_0001  0x01    1    
  9078	:  0000_0000  0x00    0    
  9079	:  0000_0000  0x00    0    
  9080	:  0010_1010  0x2A   42  *  
  9081	:  0011_0000  0x30   48  0  
  9082	:  0000_0000  0x00    0    
  9083	:  0000_0100  0x04    4    
  9084	:  0010_1101  0x2D   45  -  
  9085	:  0100_0011  0x43   67  C  
  9086	:  0011_0011  0x33   51  3  
  9087	:  0110_0101  0x65  101  e  
  9088	:  0000_1000  0x08    8    
  9089	:  0100_0001  0x41   65  A  
  9090	:  0010_1101  0x2D   45  -  
  9091	:  0011_0101  0x35   53  5  
  9092	:  0011_0001  0x31   49  1  
  9093	:  0010_1101  0x2D   45  -  
  9094	:  0011_0001  0x31   49  1  
  9095	:  0011_0000  0x30   48  0  
  9096	:  0011_0010  0x32   50  2  
  9097	:  1100_0000  0xC0  192    
  9098	:  0000_1100  0x0C   12    
  9099	:  0000_0000  0x00    0    
  9100	:  0000_0001  0x01    1    
  9101	:  0000_0000  0x00    0    
  9102	:  0000_0001  0x01    1    
  9103	:  0000_0000  0x00    0    
  9104	:  0000_0000  0x00    0    
  9105	:  0010_1010  0x2A   42  *  
  9106	:  0011_0000  0x30   48  0  
  9107	:  0000_0000  0x00    0    
  9108	:  0000_0100  0x04    4    
  9109	:  0010_1101  0x2D   45  -  
  9110	:  0100_0011  0x43   67  C  
  9111	:  0011_0011  0x33   51  3  
  9112	:  0110_0110  0x66  102  f  
  9113	:  0000_1000  0x08    8    
  9114	:  0100_0001  0x41   65  A  
  9115	:  0010_1101  0x2D   45  -  
  9116	:  0011_0101  0x35   53  5  
  9117	:  0011_0001  0x31   49  1  
  9118	:  0010_1101  0x2D   45  -  
  9119	:  0011_0001  0x31   49  1  
  9120	:  0011_0000  0x30   48  0  
  9121	:  0011_0011  0x33   51  3  
  9122	:  1100_0000  0xC0  192    
  9123	:  0000_1100  0x0C   12    
  9124	:  0000_0000  0x00    0    
  9125	:  0000_0001  0x01    1    
  9126	:  0000_0000  0x00    0    
  9127	:  0000_0001  0x01    1    
  9128	:  0000_0000  0x00    0    
  9129	:  0000_0000  0x00    0    
  9130	:  0010_1010  0x2A   42  *  
  9131	:  0011_0000  0x30   48  0  
  9132	:  0000_0000  0x00    0    
  9133	:  0000_0100  0x04    4    
  9134	:  0010_1101  0x2D   45  -  
  9135	:  0100_0011  0x43   67  C  
  9136	:  0011_0011  0x33   51  3  
  9137	:  0110_0111  0x67  103  g  
  9138	:  0000_1000  0x08    8    
  9139	:  0100_0001  0x41   65  A  
  9140	:  0010_1101  0x2D   45  -  
  9141	:  0011_0101  0x35   53  5  
  9142	:  0011_0001  0x31   49  1  
  9143	:  0010_1101  0x2D   45  -  
  9144	:  0011_0001  0x31   49  1  
  9145	:  0011_0000  0x30   48  0  
  9146	:  0011_0100  0x34   52  4  
  9147	:  1100_0000  0xC0  192    
  9148	:  0000_1100  0x0C   12    
  9149	:  0000_0000  0x00    0    
  9150	:  0000_0001  0x01    1    
  9151	:  0000_0000  0x00    0    
  9152	:  0000_0001  0x01    1    
  9153	:  0000_0000  0x00    0    
  9154	:  0000_0000  0x00    0    
  9155	:  0010_1010  0x2A   42  *  
  9156	:  0011_0000  0x30   48  0  
  9157	:  0000_0000  0x00    0    
  9158	:  0000_0100  0x04    4    
  9159	:  0010_1101  0x2D   45  -  
  9160	:  0100_0011  0x43   67  C  
  9161	:  0011_0011  0x33   51  3  
  9162	:  0110_1000  0x68  104  h  
  9163	:  0000_1000  0x08    8    
  9164	:  0100_0001  0x41   65  A  
  9165	:  0010_1101  0x2D   45  -  
  9166	:  0011_0101  0x35   53  5  
  9167	:  0011_0001  0x31   49  1  
  9168	:  0010_1101  0x2D   45  -  
  9169	:  0011_0001  0x31   49  1  
  9170	:  0011_0000  0x30   48  0  
  9171	:  0011_0101  0x35   53  5  
  9172	:  1100_0000  0xC0  192    
  9173	:  0000_1100  0x0C   12    
  9174	:  0000_0000  0x00    0    
  9175	:  0000_0001  0x01    1    
  9176	:  0000_0000  0x00    0    
  9177	:  0000_0001  0x01    1    
  9178	:  0000_0000  0x00    0    
  9179	:  0000_0000  0x00    0    
  9180	:  0010_1010  0x2A   42  *  
  9181	:  0011_0000  0x30   48  0  
  9182	:  0000_0000  0x00    0    
  9183	:  0000_0100  0x04    4    
  9184	:  0010_1101  0x2D   45  -  
  9185	:  0100_0011  0x43   67  C  
  9186	:  0011_0011  0x33   51  3  
  9187	:  0110_1001  0x69  105  i  
  9188	:  0000_1000  0x08    8    
  9189	:  0100_0001  0x41   65  A  
  9190	:  0010_1101  0x2D   45  -  
  9191	:  0011_0101  0x35   53  5  
  9192	:  0011_0001  0x31   49  1  
  9193	:  0010_1101  0x2D   45  -  
  9194	:  0011_0001  0x31   49  1  
  9195	:  0011_0000  0x30   48  0  
  9196	:  0011_0110  0x36   54  6  
  9197	:  1100_0000  0xC0  192    
  9198	:  0000_1100  0x0C   12    
  9199	:  0000_0000  0x00    0    
  9200	:  0000_0001  0x01    1    
  9201	:  0000_0000  0x00    0    
  9202	:  0000_0001  0x01    1    
  9203	:  0000_0000  0x00    0    
  9204	:  0000_0000  0x00    0    
  9205	:  0010_1010  0x2A   42  *  
  9206	:  0011_0000  0x30   48  0  
  9207	:  0000_0000  0x00    0    
  9208	:  0000_0100  0x04    4    
  9209	:  0010_1101  0x2D   45  -  
  9210	:  0100_0011  0x43   67  C  
  9211	:  0011_0011  0x33   51  3  
  9212	:  0110_1010  0x6A  106  j  
  9213	:  0000_1000  0x08    8    
  9214	:  0100_0001  0x41   65  A  
  9215	:  0010_1101  0x2D   45  -  
  9216	:  0011_0101  0x35   53  5  
  9217	:  0011_0001  0x31   49  1  
  9218	:  0010_1101  0x2D   45  -  
  9219	:  0011_0001  0x31   49  1  
  9220	:  0011_0000  0x30   48  0  
  9221	:  0011_0111  0x37   55  7  
  9222	:  1100_0000  0xC0  192    
  9223	:  0000_1100  0x0C   12    
  9224	:  0000_0000  0x00    0    
  9225	:  0000_0001  0x01    1    
  9226	:  0000_0000  0x00    0    
  9227	:  0000_0001  0x01    1    
  9228	:  0000_0000  0x00    0    
  9229	:  0000_0000  0x00    0    
  9230	:  0010_1010  0x2A   42  *  
  9231	:  0011_0000  0x30   48  0  
  9232	:  0000_0000  0x00    0    
  9233	:  0000_0100  0x04    4    
  9234	:  0010_1101  0x2D   45  -  
  9235	:  0100_0011  0x43   67  C  
  9236	:  0011_0011  0x33   51  3  
  9237	:  0110_1011  0x6B  107  k  
  9238	:  0000_1000  0x08    8    
  9239	:  0100_0001  0x41   65  A  
  9240	:  0010_1101  0x2D   45  -  
  9241	:  0011_0101  0x35   53  5  
  9242	:  0011_0001  0x31   49  1  
  9243	:  0010_1101  0x2D   45  -  
  9244	:  0011_0001  0x31   49  1  
  9245	:  0011_0000  0x30   48  0  
  9246	:  0011_1000  0x38   56  8  
  9247	:  1100_0000  0xC0  192    
  9248	:  0000_1100  0x0C   12    
  9249	:  0000_0000  0x00    0    
  9250	:  0000_0001  0x01    1    
  9251	:  0000_0000  0x00    0    
  9252	:  0000_0001  0x01    1    
  9253	:  0000_0000  0x00    0    
  9254	:  0000_0000  0x00    0    
  9255	:  0010_1010  0x2A   42  *  
  9256	:  0011_0000  0x30   48  0  
  9257	:  0000_0000  0x00    0    
  9258	:  0000_0100  0x04    4    
  9259	:  0010_1101  0x2D   45  -  
  9260	:  0100_0011  0x43   67  C  
  9261	:  0011_0011  0x33   51  3  
  9262	:  0110_1100  0x6C  108  l  
  9263	:  0000_1000  0x08    8    
  9264	:  0100_0001  0x41   65  A  
  9265	:  0010_1101  0x2D   45  -  
  9266	:  0011_0101  0x35   53  5  
  9267	:  0011_0001  0x31   49  1  
  9268	:  0010_1101  0x2D   45  -  
  9269	:  0011_0001  0x31   49  1  
  9270	:  0011_0000  0x30   48  0  
  9271	:  0011_1001  0x39   57  9  
  9272	:  1100_0000  0xC0  192    
  9273	:  0000_1100  0x0C   12    
  9274	:  0000_0000  0x00    0    
  9275	:  0000_0001  0x01    1    
  9276	:  0000_0000  0x00    0    
  9277	:  0000_0001  0x01    1    
  9278	:  0000_0000  0x00    0    
  9279	:  0000_0000  0x00    0    
  9280	:  0010_1010  0x2A   42  *  
  9281	:  0011_0000  0x30   48  0  
  9282	:  0000_0000  0x00    0    
  9283	:  0000_0100  0x04    4    
  9284	:  0010_1101  0x2D   45  -  
  9285	:  0100_0011  0x43   67  C  
  9286	:  0011_0011  0x33   51  3  
  9287	:  0110_1101  0x6D  109  m  
  9288	:  0000_1000  0x08    8    
  9289	:  0100_0001  0x41   65  A  
  9290	:  0010_1101  0x2D   45  -  
  9291	:  0011_0101  0x35   53  5  
  9292	:  0011_0001  0x31   49  1  
  9293	:  0010_1101  0x2D   45  -  
  9294	:  0011_0001  0x31   49  1  
  9295	:  0011_0001  0x31   49  1  
  9296	:  0011_0000  0x30   48  0  
  9297	:  1100_0000  0xC0  192    
  9298	:  0000_1100  0x0C   12    
  9299	:  0000_0000  0x00    0    
  9300	:  0000_0001  0x01    1    
  9301	:  0000_0000  0x00    0    
  9302	:  0000_0001  0x01    1    
  9303	:  0000_0000  0x00    0    
  9304	:  0000_0000  0x00    0    
  9305	:  0010_1010  0x2A   42  *  
  9306	:  0011_0000  0x30   48  0  
  9307	:  0000_0000  0x00    0    
  9308	:  0000_0100  0x04    4    
  9309	:  0010_1101  0x2D   45  -  
  9310	:  0100_0011  0x43   67  C  
  9311	:  0011_0011  0x33   51  3  
  9312	:  0110_1110  0x6E  110  n  
  9313	:  0000_1000  0x08    8    
  9314	:  0100_0001  0x41   65  A  
  9315	:  0010_1101  0x2D   45  -  
  9316	:  0011_0101  0x35   53  5  
  9317	:  0011_0001  0x31   49  1  
  9318	:  0010_1101  0x2D   45  -  
  9319	:  0011_0001  0x31   49  1  
  9320	:  0011_0001  0x31   49  1  
  9321	:  0011_0001  0x31   49  1  
  9322	:  1100_0000  0xC0  192    
  9323	:  0000_1100  0x0C   12    
  9324	:  0000_0000  0x00    0    
  9325	:  0000_0001  0x01    1    
  9326	:  0000_0000  0x00    0    
  9327	:  0000_0001  0x01    1    
  9328	:  0000_0000  0x00    0    
  9329	:  0000_0000  0x00    0    
  9330	:  0010_1010  0x2A   42  *  
  9331	:  0011_0000  0x30   48  0  
  9332	:  0000_0000  0x00    0    
  9333	:  0000_0100  0x04    4    
  9334	:  0010_1101  0x2D   45  -  
  9335	:  0100_0011  0x43   67  C  
  9336	:  0011_0011  0x33   51  3  
  9337	:  0110_1111  0x6F  111  o  
  9338	:  0000_1000  0x08    8    
  9339	:  0100_0001  0x41   65  A  
  9340	:  0010_1101  0x2D   45  -  
  9341	:  0011_0101  0x35   53  5  
  9342	:  0011_0001  0x31   49  1  
  9343	:  0010_1101  0x2D   45  -  
  9344	:  0011_0001  0x31   49  1  
  9345	:  0011_0001  0x31   49  1  
  9346	:  0011_0010  0x32   50  2  
  9347	:  1100_0000  0xC0  192    
  9348	:  0000_1100  0x0C   12    
  9349	:  0000_0000  0x00    0    
  9350	:  0000_0001  0x01    1    
  9351	:  0000_0000  0x00    0    
  9352	:  0000_0001  0x01    1    
  9353	:  0000_0000  0x00    0    
  9354	:  0000_0000  0x00    0    
  9355	:  0010_1010  0x2A   42  *  
  9356	:  0011_0000  0x30   48  0  
  9357	:  0000_0000  0x00    0    
  9358	:  0000_0100  0x04    4    
  9359	:  0010_1101  0x2D   45  -  
  9360	:  0100_0011  0x43   67  C  
  9361	:  0011_0011  0x33   51  3  
  9362	:  0111_0000  0x70  112  p  
  9363	:  0000_1000  0x08    8    
  9364	:  0100_0001  0x41   65  A  
  9365	:  0010_1101  0x2D   45  -  
  9366	:  0011_0101  0x35   53  5  
  9367	:  0011_0001  0x31   49  1  
  9368	:  0010_1101  0x2D   45  -  
  9369	:  0011_0001  0x31   49  1  
  9370	:  0011_0001  0x31   49  1  
  9371	:  0011_0011  0x33   51  3  
  9372	:  1100_0000  0xC0  192    
  9373	:  0000_1100  0x0C   12    
  9374	:  0000_0000  0x00    0    
  9375	:  0000_0001  0x01    1    
  9376	:  0000_0000  0x00    0    
  9377	:  0000_0001  0x01    1    
  9378	:  0000_0000  0x00    0    
  9379	:  0000_0000  0x00    0    
  9380	:  0010_1010  0x2A   42  *  
  9381	:  0011_0000  0x30   48  0  
  9382	:  0000_0000  0x00    0    
  9383	:  0000_0100  0x04    4    
  9384	:  0010_1101  0x2D   45  -  
  9385	:  0100_0011  0x43   67  C  
  9386	:  0011_0011  0x33   51  3  
  9387	:  0111_0001  0x71  113  q  
  9388	:  0000_1000  0x08    8    
  9389	:  0100_0001  0x41   65  A  
  9390	:  0010_1101  0x2D   45  -  
  9391	:  0011_0101  0x35   53  5  
  9392	:  0011_0001  0x31   49  1  
  9393	:  0010_1101  0x2D   45  -  
  9394	:  0011_0001  0x31   49  1  
  9395	:  0011_0001  0x31   49  1  
  9396	:  0011_0100  0x34   52  4  
  9397	:  1100_0000  0xC0  192    
  9398	:  0000_1100  0x0C   12    
  9399	:  0000_0000  0x00    0    
  9400	:  0000_0001  0x01    1    
  9401	:  0000_0000  0x00    0    
  9402	:  0000_0001  0x01    1    
  9403	:  0000_0000  0x00    0    
  9404	:  0000_0000  0x00    0    
  9405	:  0010_1010  0x2A   42  *  
  9406	:  0011_0000  0x30   48  0  
  9407	:  0000_0000  0x00    0    
  9408	:  0000_0100  0x04    4    
  9409	:  0010_1101  0x2D   45  -  
  9410	:  0100_0011  0x43   67  C  
  9411	:  0011_0011  0x33   51  3  
  9412	:  0111_0010  0x72  114  r  
  9413	:  0000_1000  0x08    8    
  9414	:  0100_0001  0x41   65  A  
  9415	:  0010_1101  0x2D   45  -  
  9416	:  0011_0101  0x35   53  5  
  9417	:  0011_0001  0x31   49  1  
  9418	:  0010_1101  0x2D   45  -  
  9419	:  0011_0001  0x31   49  1  
  9420	:  0011_0001  0x31   49  1  
  9421	:  0011_0101  0x35   53  5  
  9422	:  1100_0000  0xC0  192    
  9423	:  0000_1100  0x0C   12    
  9424	:  0000_0000  0x00    0    
  9425	:  0000_0001  0x01    1    
  9426	:  0000_0000  0x00    0    
  9427	:  0000_0001  0x01    1    
  9428	:  0000_0000  0x00    0    
  9429	:  0000_0000  0x00    0    
  9430	:  0010_1010  0x2A   42  *  
  9431	:  0011_0000  0x30   48  0  
  9432	:  0000_0000  0x00    0    
  9433	:  0000_0100  0x04    4    
  9434	:  0010_1101  0x2D   45  -  
  9435	:  0100_0011  0x43   67  C  
  9436	:  0011_0011  0x33   51  3  
  9437	:  0111_0011  0x73  115  s  
  9438	:  0000_1000  0x08    8    
  9439	:  0100_0001  0x41   65  A  
  9440	:  0010_1101  0x2D   45  -  
  9441	:  0011_0101  0x35   53  5  
  9442	:  0011_0001  0x31   49  1  
  9443	:  0010_1101  0x2D   45  -  
  9444	:  0011_0001  0x31   49  1  
  9445	:  0011_0001  0x31   49  1  
  9446	:  0011_0110  0x36   54  6  
  9447	:  1100_0000  0xC0  192    
  9448	:  0000_1100  0x0C   12    
  9449	:  0000_0000  0x00    0    
  9450	:  0000_0001  0x01    1    
  9451	:  0000_0000  0x00    0    
  9452	:  0000_0001  0x01    1    
  9453	:  0000_0000  0x00    0    
  9454	:  0000_0000  0x00    0    
  9455	:  0010_1010  0x2A   42  *  
  9456	:  0011_0000  0x30   48  0  
  9457	:  0000_0000  0x00    0    
  9458	:  0000_0100  0x04    4    
  9459	:  0010_1101  0x2D   45  -  
  9460	:  0100_0011  0x43   67  C  
  9461	:  0011_0011  0x33   51  3  
  9462	:  0111_0100  0x74  116  t  
  9463	:  0000_1000  0x08    8    
  9464	:  0100_0001  0x41   65  A  
  9465	:  0010_1101  0x2D   45  -  
  9466	:  0011_0101  0x35   53  5  
  9467	:  0011_0001  0x31   49  1  
  9468	:  0010_1101  0x2D   45  -  
  9469	:  0011_0001  0x31   49  1  
  9470	:  0011_0001  0x31   49  1  
  9471	:  0011_0111  0x37   55  7  
  9472	:  1100_0000  0xC0  192    
  9473	:  0000_1100  0x0C   12    
  9474	:  0000_0000  0x00    0    
  9475	:  0000_0001  0x01    1    
  9476	:  0000_0000  0x00    0    
  9477	:  0000_0001  0x01    1    
  9478	:  0000_0000  0x00    0    
  9479	:  0000_0000  0x00    0    
  9480	:  0010_1010  0x2A   42  *  
  9481	:  0011_0000  0x30   48  0  
  9482	:  0000_0000  0x00    0    
  9483	:  0000_0100  0x04    4    
  9484	:  0010_1101  0x2D   45  -  
  9485	:  0100_0011  0x43   67  C  
  9486	:  0011_0011  0x33   51  3  
  9487	:  0111_0101  0x75  117  u  
  9488	:  0000_1000  0x08    8    
  9489	:  0100_0001  0x41   65  A  
  9490	:  0010_1101  0x2D   45  -  
  9491	:  0011_0101  0x35   53  5  
  9492	:  0011_0001  0x31   49  1  
  9493	:  0010_1101  0x2D   45  -  
  9494	:  0011_0001  0x31   49  1  
  9495	:  0011_0001  0x31   49  1  
  9496	:  0011_1000  0x38   56  8  
  9497	:  1100_0000  0xC0  192    
  9498	:  0000_1100  0x0C   12    
  9499	:  0000_0000  0x00    0    
  9500	:  0000_0001  0x01    1    
  9501	:  0000_0000  0x00    0    
  9502	:  0000_0001  0x01    1    
  9503	:  0000_0000  0x00    0    
  9504	:  0000_0000  0x00    0    
  9505	:  0010_1010  0x2A   42  *  
  9506	:  0011_0000  0x30   48  0  
  9507	:  0000_0000  0x00    0    
  9508	:  0000_0100  0x04    4    
  9509	:  0010_1101  0x2D   45  -  
  9510	:  0100_0011  0x43   67  C  
  9511	:  0011_0011  0x33   51  3  
  9512	:  0111_0110  0x76  118  v  
  9513	:  0000_1000  0x08    8    
  9514	:  0100_0001  0x41   65  A  
  9515	:  0010_1101  0x2D   45  -  
  9516	:  0011_0101  0x35   53  5  
  9517	:  0011_0001  0x31   49  1  
  9518	:  0010_1101  0x2D   45  -  
  9519	:  0011_0001  0x31   49  1  
  9520	:  0011_0001  0x31   49  1  
  9521	:  0011_1001  0x39   57  9  
  9522	:  1100_0000  0xC0  192    
  9523	:  0000_1100  0x0C   12    
  9524	:  0000_0000  0x00    0    
  9525	:  0000_0001  0x01    1    
  9526	:  0000_0000  0x00    0    
  9527	:  0000_0001  0x01    1    
  9528	:  0000_0000  0x00    0    
  9529	:  0000_0000  0x00    0    
  9530	:  0010_1010  0x2A   42  *  
  9531	:  0011_0000  0x30   48  0  
  9532	:  0000_0000  0x00    0    
  9533	:  0000_0100  0x04    4    
  9534	:  0010_1101  0x2D   45  -  
  9535	:  0100_0011  0x43   67  C  
  9536	:  0011_0011  0x33   51  3  
  9537	:  0111_0111  0x77  119  w  
  9538	:  0000_1000  0x08    8    
  9539	:  0100_0001  0x41   65  A  
  9540	:  0010_1101  0x2D   45  -  
  9541	:  0011_0101  0x35   53  5  
  9542	:  0011_0001  0x31   49  1  
  9543	:  0010_1101  0x2D   45  -  
  9544	:  0011_0001  0x31   49  1  
  9545	:  0011_0010  0x32   50  2  
  9546	:  0011_0000  0x30   48  0  
  9547	:  1100_0000  0xC0  192    
  9548	:  0000_1100  0x0C   12    
  9549	:  0000_0000  0x00    0    
  9550	:  0000_0001  0x01    1    
  9551	:  0000_0000  0x00    0    
  9552	:  0000_0001  0x01    1    
  9553	:  0000_0000  0x00    0    
  9554	:  0000_0000  0x00    0    
  9555	:  0010_1010  0x2A   42  *  
  9556	:  0011_0000  0x30   48  0  
  9557	:  0000_0000  0x00    0    
  9558	:  0000_0100  0x04    4    
  9559	:  0010_1101  0x2D   45  -  
  9560	:  0100_0011  0x43   67  C  
  9561	:  0011_0011  0x33   51  3  
  9562	:  0111_1000  0x78  120  x  
  9563	:  0000_1000  0x08    8    
  9564	:  0100_0001  0x41   65  A  
  9565	:  0010_1101  0x2D   45  -  
  9566	:  0011_0101  0x35   53  5  
  9567	:  0011_0001  0x31   49  1  
  9568	:  0010_1101  0x2D   45  -  
  9569	:  0011_0001  0x31   49  1  
  9570	:  0011_0010  0x32   50  2  
  9571	:  0011_0001  0x31   49  1  
  9572	:  1100_0000  0xC0  192    
  9573	:  0000_1100  0x0C   12    
  9574	:  0000_0000  0x00    0    
  9575	:  0000_0001  0x01    1    
  9576	:  0000_0000  0x00    0    
  9577	:  0000_0001  0x01    1    
  9578	:  0000_0000  0x00    0    
  9579	:  0000_0000  0x00    0    
  9580	:  0010_1010  0x2A   42  *  
  9581	:  0011_0000  0x30   48  0  
  9582	:  0000_0000  0x00    0    
  9583	:  0000_0100  0x04    4    
  9584	:  0010_1101  0x2D   45  -  
  9585	:  0100_0011  0x43   67  C  
  9586	:  0011_0011  0x33   51  3  
  9587	:  0111_1001  0x79  121  y  
  9588	:  0000_1000  0x08    8    
  9589	:  0100_0001  0x41   65  A  
  9590	:  0010_1101  0x2D   45  -  
  9591	:  0011_0101  0x35   53  5  
  9592	:  0011_0001  0x31   49  1  
  9593	:  0010_1101  0x2D   45  -  
  9594	:  0011_0001  0x31   49  1  
  9595	:  0011_0010  0x32   50  2  
  9596	:  0011_0010  0x32   50  2  
  9597	:  1100_0000  0xC0  192    
  9598	:  0000_1100  0x0C   12    
  9599	:  0000_0000  0x00    0    
  9600	:  0000_0001  0x01    1    
  9601	:  0000_0000  0x00    0    
  9602	:  0000_0001  0x01    1    
  9603	:  0000_0000  0x00    0    
  9604	:  0000_0000  0x00    0    
  9605	:  0010_1010  0x2A   42  *  
  9606	:  0011_0000  0x30   48  0  
  9607	:  0000_0000  0x00    0    
  9608	:  0000_0100  0x04    4    
  9609	:  0010_1101  0x2D   45  -  
  9610	:  0100_0011  0x43   67  C  
  9611	:  0011_0011  0x33   51  3  
  9612	:  0111_1010  0x7A  122  z  
  9613	:  0000_1000  0x08    8    
  9614	:  0100_0001  0x41   65  A  
  9615	:  0010_1101  0x2D   45  -  
  9616	:  0011_0101  0x35   53  5  
  9617	:  0011_0001  0x31   49  1  
  9618	:  0010_1101  0x2D   45  -  
  9619	:  0011_0001  0x31   49  1  
  9620	:  0011_0010  0x32   50  2  
  9621	:  0011_0011  0x33   51  3  
  9622	:  1100_0000  0xC0  192    
  9623	:  0000_1100  0x0C   12    
  9624	:  0000_0000  0x00    0    
  9625	:  0000_0001  0x01    1    
  9626	:  0000_0000  0x00    0    
  9627	:  0000_0001  0x01    1    
  9628	:  0000_0000  0x00    0    
  9629	:  0000_0000  0x00    0    
  9630	:  0010_1010  0x2A   42  *  
  9631	:  0011_0000  0x30   48  0  
  9632	:  0000_0000  0x00    0    
  9633	:  0000_0100  0x04    4    
  9634	:  0010_1101  0x2D   45  -  
  9635	:  0100_0011  0x43   67  C  
  9636	:  0011_0011  0x33   51  3  
  9637	:  0111_1011  0x7B  123  {  
  9638	:  0000_1000  0x08    8    
  9639	:  0100_0001  0x41   65  A  
  9640	:  0010_1101  0x2D   45  -  
  9641	:  0011_0101  0x35   53  5  
  9642	:  0011_0001  0x31   49  1  
  9643	:  0010_1101  0x2D   45  -  
  9644	:  0011_0001  0x31   49  1  
  9645	:  0011_0010  0x32   50  2  
  9646	:  0011_0100  0x34   52  4  
  9647	:  1100_0000  0xC0  192    
  9648	:  0000_1100  0x0C   12    
  9649	:  0000_0000  0x00    0    
  9650	:  0000_0001  0x01    1    
  9651	:  0000_0000  0x00    0    
  9652	:  0000_0001  0x01    1    
  9653	:  0000_0000  0x00    0    
  9654	:  0000_0000  0x00    0    
  9655	:  0010_1010  0x2A   42  *  
  9656	:  0011_0000  0x30   48  0  
  9657	:  0000_0000  0x00    0    
  9658	:  0000_0100  0x04    4    
  9659	:  0010_1101  0x2D   45  -  
  9660	:  0100_0011  0x43   67  C  
  9661	:  0011_0011  0x33   51  3  
  9662	:  0111_1100  0x7C  124  |.'|'.q|  
  9663	:  0000_1000  0x08    8    
  9664	:  0100_0001  0x41   65  A  
  9665	:  0010_1101  0x2D   45  -  
  9666	:  0011_0101  0x35   53  5  
  9667	:  0011_0001  0x31   49  1  
  9668	:  0010_1101  0x2D   45  -  
  9669	:  0011_0001  0x31   49  1  
  9670	:  0011_0010  0x32   50  2  
  9671	:  0011_0101  0x35   53  5  
  9672	:  1100_0000  0xC0  192    
  9673	:  0000_1100  0x0C   12    
  9674	:  0000_0000  0x00    0    
  9675	:  0000_0001  0x01    1    
  9676	:  0000_0000  0x00    0    
  9677	:  0000_0001  0x01    1    
  9678	:  0000_0000  0x00    0    
  9679	:  0000_0000  0x00    0    
  9680	:  0010_1010  0x2A   42  *  
  9681	:  0011_0000  0x30   48  0  
  9682	:  0000_0000  0x00    0    
  9683	:  0000_0100  0x04    4    
  9684	:  0010_1101  0x2D   45  -  
  9685	:  0100_0011  0x43   67  C  
  9686	:  0011_0011  0x33   51  3  
  9687	:  0111_1101  0x7D  125  }  
  9688	:  0000_1000  0x08    8    
  9689	:  0100_0001  0x41   65  A  
  9690	:  0010_1101  0x2D   45  -  
  9691	:  0011_0101  0x35   53  5  
  9692	:  0011_0001  0x31   49  1  
  9693	:  0010_1101  0x2D   45  -  
  9694	:  0011_0001  0x31   49  1  
  9695	:  0011_0010  0x32   50  2  
  9696	:  0011_0110  0x36   54  6  
  9697	:  1100_0000  0xC0  192    
  9698	:  0000_1100  0x0C   12    
  9699	:  0000_0000  0x00    0    
  9700	:  0000_0001  0x01    1    
  9701	:  0000_0000  0x00    0    
  9702	:  0000_0001  0x01    1    
  9703	:  0000_0000  0x00    0    
  9704	:  0000_0000  0x00    0    
  9705	:  0010_1010  0x2A   42  *  
  9706	:  0011_0000  0x30   48  0  
  9707	:  0000_0000  0x00    0    
  9708	:  0000_0100  0x04    4    
  9709	:  0010_1101  0x2D   45  -  
  9710	:  0100_0011  0x43   67  C  
  9711	:  0011_0011  0x33   51  3  
  9712	:  0111_1110  0x7E  126  ~  
  9713	:  0000_1000  0x08    8    
  9714	:  0100_0001  0x41   65  A  
  9715	:  0010_1101  0x2D   45  -  
  9716	:  0011_0101  0x35   53  5  
  9717	:  0011_0001  0x31   49  1  
  9718	:  0010_1101  0x2D   45  -  
  9719	:  0011_0001  0x31   49  1  
  9720	:  0011_0010  0x32   50  2  
  9721	:  0011_0111  0x37   55  7  
  9722	:  1100_0000  0xC0  192    
  9723	:  0000_1100  0x0C   12    
  9724	:  0000_0000  0x00    0    
  9725	:  0000_0001  0x01    1    
  9726	:  0000_0000  0x00    0    
  9727	:  0000_0001  0x01    1    
  9728	:  0000_0000  0x00    0    
  9729	:  0000_0000  0x00    0    
  9730	:  0010_1010  0x2A   42  *  
  9731	:  0011_0000  0x30   48  0  
  9732	:  0000_0000  0x00    0    
  9733	:  0000_0100  0x04    4    
  9734	:  0010_1101  0x2D   45  -  
  9735	:  0100_0011  0x43   67  C  
  9736	:  0011_0011  0x33   51  3  
  9737	:  0111_1111  0x7F  127    
  9738	:  0000_1000  0x08    8    
  9739	:  0100_0001  0x41   65  A  
  9740	:  0010_1101  0x2D   45  -  
  9741	:  0011_0101  0x35   53  5  
  9742	:  0011_0001  0x31   49  1  
  9743	:  0010_1101  0x2D   45  -  
  9744	:  0011_0001  0x31   49  1  
  9745	:  0011_0010  0x32   50  2  
  9746	:  0011_1000  0x38   56  8  
  9747	:  1100_0000  0xC0  192    
  9748	:  0000_1100  0x0C   12    
  9749	:  0000_0000  0x00    0    
  9750	:  0000_0001  0x01    1    
  9751	:  0000_0000  0x00    0    
  9752	:  0000_0001  0x01    1    
  9753	:  0000_0000  0x00    0    
  9754	:  0000_0000  0x00    0    
  9755	:  0010_1010  0x2A   42  *  
  9756	:  0011_0000  0x30   48  0  
  9757	:  0000_0000  0x00    0    
  9758	:  0000_0100  0x04    4    
  9759	:  0010_1101  0x2D   45  -  
  9760	:  0100_0011  0x43   67  C  
  9761	:  0011_0011  0x33   51  3  
  9762	:  1000_0000  0x80  128    
  9763	:  0000_1000  0x08    8    
  9764	:  0100_0001  0x41   65  A  
  9765	:  0010_1101  0x2D   45  -  
  9766	:  0011_0101  0x35   53  5  
  9767	:  0011_0001  0x31   49  1  
  9768	:  0010_1101  0x2D   45  -  
  9769	:  0011_0001  0x31   49  1  
  9770	:  0011_0010  0x32   50  2  
  9771	:  0011_1001  0x39   57  9  
  9772	:  1100_0000  0xC0  192    
  9773	:  0000_1100  0x0C   12    
  9774	:  0000_0000  0x00    0    
  9775	:  0000_0001  0x01    1    
  9776	:  0000_0000  0x00    0    
  9777	:  0000_0001  0x01    1    
  9778	:  0000_0000  0x00    0    
  9779	:  0000_0000  0x00    0    
  9780	:  0010_1010  0x2A   42  *  
  9781	:  0011_0000  0x30   48  0  
  9782	:  0000_0000  0x00    0    
  9783	:  0000_0100  0x04    4    
  9784	:  0010_1101  0x2D   45  -  
  9785	:  0100_0011  0x43   67  C  
  9786	:  0011_0011  0x33   51  3  
  9787	:  1000_0001  0x81  129    
  9788	:  0000_1000  0x08    8    
  9789	:  0100_0001  0x41   65  A  
  9790	:  0010_1101  0x2D   45  -  
  9791	:  0011_0101  0x35   53  5  
  9792	:  0011_0001  0x31   49  1  
  9793	:  0010_1101  0x2D   45  -  
  9794	:  0011_0001  0x31   49  1  
  9795	:  0011_0011  0x33   51  3  
  9796	:  0011_0000  0x30   48  0  
  9797	:  1100_0000  0xC0  192    
  9798	:  0000_1100  0x0C   12    
  9799	:  0000_0000  0x00    0    
  9800	:  0000_0001  0x01    1    
  9801	:  0000_0000  0x00    0    
  9802	:  0000_0001  0x01    1    
  9803	:  0000_0000  0x00    0    
  9804	:  0000_0000  0x00    0    
  9805	:  0010_1010  0x2A   42  *  
  9806	:  0011_0000  0x30   48  0  
  9807	:  0000_0000  0x00    0    
  9808	:  0000_0100  0x04    4    
  9809	:  0010_1101  0x2D   45  -  
  9810	:  0100_0011  0x43   67  C  
  9811	:  0011_0011  0x33   51  3  
  9812	:  1000_0010  0x82  130    
  9813	:  0000_1000  0x08    8    
  9814	:  0100_0001  0x41   65  A  
  9815	:  0010_1101  0x2D   45  -  
  9816	:  0011_0101  0x35   53  5  
  9817	:  0011_0001  0x31   49  1  
  9818	:  0010_1101  0x2D   45  -  
  9819	:  0011_0001  0x31   49  1  
  9820	:  0011_0011  0x33   51  3  
  9821	:  0011_0001  0x31   49  1  
  9822	:  1100_0000  0xC0  192    
  9823	:  0000_1100  0x0C   12    
  9824	:  0000_0000  0x00    0    
  9825	:  0000_0001  0x01    1    
  9826	:  0000_0000  0x00    0    
  9827	:  0000_0001  0x01    1    
  9828	:  0000_0000  0x00    0    
  9829	:  0000_0000  0x00    0    
  9830	:  0010_1010  0x2A   42  *  
  9831	:  0011_0000  0x30   48  0  
  9832	:  0000_0000  0x00    0    
  9833	:  0000_0100  0x04    4    
  9834	:  0010_1101  0x2D   45  -  
  9835	:  0100_0011  0x43   67  C  
  9836	:  0011_0011  0x33   51  3  
  9837	:  1000_0011  0x83  131    
  9838	:  0000_1000  0x08    8    
  9839	:  0100_0001  0x41   65  A  
  9840	:  0010_1101  0x2D   45  -  
  9841	:  0011_0101  0x35   53  5  
  9842	:  0011_0001  0x31   49  1  
  9843	:  0010_1101  0x2D   45  -  
  9844	:  0011_0001  0x31   49  1  
  9845	:  0011_0011  0x33   51  3  
  9846	:  0011_0010  0x32   50  2  
  9847	:  1100_0000  0xC0  192    
  9848	:  0000_1100  0x0C   12    
  9849	:  0000_0000  0x00    0    
  9850	:  0000_0001  0x01    1    
  9851	:  0000_0000  0x00    0    
  9852	:  0000_0001  0x01    1    
  9853	:  0000_0000  0x00    0    
  9854	:  0000_0000  0x00    0    
  9855	:  0010_1010  0x2A   42  *  
  9856	:  0011_0000  0x30   48  0  
  9857	:  0000_0000  0x00    0    
  9858	:  0000_0100  0x04    4    
  9859	:  0010_1101  0x2D   45  -  
  9860	:  0100_0011  0x43   67  C  
  9861	:  0011_0011  0x33   51  3  
  9862	:  1000_0100  0x84  132    
  9863	:  0000_1000  0x08    8    
  9864	:  0100_0001  0x41   65  A  
  9865	:  0010_1101  0x2D   45  -  
  9866	:  0011_0101  0x35   53  5  
  9867	:  0011_0001  0x31   49  1  
  9868	:  0010_1101  0x2D   45  -  
  9869	:  0011_0001  0x31   49  1  
  9870	:  0011_0011  0x33   51  3  
  9871	:  0011_0011  0x33   51  3  
  9872	:  1100_0000  0xC0  192    
  9873	:  0000_1100  0x0C   12    
  9874	:  0000_0000  0x00    0    
  9875	:  0000_0001  0x01    1    
  9876	:  0000_0000  0x00    0    
  9877	:  0000_0001  0x01    1    
  9878	:  0000_0000  0x00    0    
  9879	:  0000_0000  0x00    0    
  9880	:  0010_1010  0x2A   42  *  
  9881	:  0011_0000  0x30   48  0  
  9882	:  0000_0000  0x00    0    
  9883	:  0000_0100  0x04    4    
  9884	:  0010_1101  0x2D   45  -  
  9885	:  0100_0011  0x43   67  C  
  9886	:  0011_0011  0x33   51  3  
  9887	:  1000_0101  0x85  133    
  9888	:  0000_1000  0x08    8    
  9889	:  0100_0001  0x41   65  A  
  9890	:  0010_1101  0x2D   45  -  
  9891	:  0011_0101  0x35   53  5  
  9892	:  0011_0001  0x31   49  1  
  9893	:  0010_1101  0x2D   45  -  
  9894	:  0011_0001  0x31   49  1  
  9895	:  0011_0011  0x33   51  3  
  9896	:  0011_0100  0x34   52  4  
  9897	:  1100_0000  0xC0  192    
  9898	:  0000_1100  0x0C   12    
  9899	:  0000_0000  0x00    0    
  9900	:  0000_0001  0x01    1    
  9901	:  0000_0000  0x00    0    
  9902	:  0000_0001  0x01    1    
  9903	:  0000_0000  0x00    0    
  9904	:  0000_0000  0x00    0    
  9905	:  0010_1010  0x2A   42  *  
  9906	:  0011_0000  0x30   48  0  
  9907	:  0000_0000  0x00    0    
  9908	:  0000_0100  0x04    4    
  9909	:  0010_1101  0x2D   45  -  
  9910	:  0100_0011  0x43   67  C  
  9911	:  0011_0011  0x33   51  3  
  9912	:  1000_0110  0x86  134    
  9913	:  0000_1000  0x08    8    
  9914	:  0100_0001  0x41   65  A  
  9915	:  0010_1101  0x2D   45  -  
  9916	:  0011_0101  0x35   53  5  
  9917	:  0011_0001  0x31   49  1  
  9918	:  0010_1101  0x2D   45  -  
  9919	:  0011_0001  0x31   49  1  
  9920	:  0011_0011  0x33   51  3  
  9921	:  0011_0101  0x35   53  5  
  9922	:  1100_0000  0xC0  192    
  9923	:  0000_1100  0x0C   12    
  9924	:  0000_0000  0x00    0    
  9925	:  0000_0001  0x01    1    
  9926	:  0000_0000  0x00    0    
  9927	:  0000_0001  0x01    1    
  9928	:  0000_0000  0x00    0    
  9929	:  0000_0000  0x00    0    
  9930	:  0010_1010  0x2A   42  *  
  9931	:  0011_0000  0x30   48  0  
  9932	:  0000_0000  0x00    0    
  9933	:  0000_0100  0x04    4    
  9934	:  0010_1101  0x2D   45  -  
  9935	:  0100_0011  0x43   67  C  
  9936	:  0011_0011  0x33   51  3  
  9937	:  1000_0111  0x87  135    
  9938	:  0000_1000  0x08    8    
  9939	:  0100_0001  0x41   65  A  
  9940	:  0010_1101  0x2D   45  -  
  9941	:  0011_0101  0x35   53  5  
  9942	:  0011_0001  0x31   49  1  
  9943	:  0010_1101  0x2D   45  -  
  9944	:  0011_0001  0x31   49  1  
  9945	:  0011_0011  0x33   51  3  
  9946	:  0011_0110  0x36   54  6  
  9947	:  1100_0000  0xC0  192    
  9948	:  0000_1100  0x0C   12    
  9949	:  0000_0000  0x00    0    
  9950	:  0000_0001  0x01    1    
  9951	:  0000_0000  0x00    0    
  9952	:  0000_0001  0x01    1    
  9953	:  0000_0000  0x00    0    
  9954	:  0000_0000  0x00    0    
  9955	:  0010_1010  0x2A   42  *  
  9956	:  0011_0000  0x30   48  0  
  9957	:  0000_0000  0x00    0    
  9958	:  0000_0100  0x04    4    
  9959	:  0010_1101  0x2D   45  -  
  9960	:  0100_0011  0x43   67  C  
  9961	:  0011_0011  0x33   51  3  
  9962	:  1000_1000  0x88  136    
  9963	:  0000_1000  0x08    8    
  9964	:  0100_0001  0x41   65  A  
  9965	:  0010_1101  0x2D   45  -  
  9966	:  0011_0101  0x35   53  5  
  9967	:  0011_0001  0x31   49  1  
  9968	:  0010_1101  0x2D   45  -  
  9969	:  0011_0001  0x31   49  1  
  9970	:  0011_0011  0x33   51  3  
  9971	:  0011_0111  0x37   55  7  
  9972	:  1100_0000  0xC0  192    
  9973	:  0000_1100  0x0C   12    
  9974	:  0000_0000  0x00    0    
  9975	:  0000_0001  0x01    1    
  9976	:  0000_0000  0x00    0    
  9977	:  0000_0001  0x01    1    
  9978	:  0000_0000  0x00    0    
  9979	:  0000_0000  0x00    0    
  9980	:  0010_1010  0x2A   42  *  
  9981	:  0011_0000  0x30   48  0  
  9982	:  0000_0000  0x00    0    
  9983	:  0000_0100  0x04    4    
  9984	:  0010_1101  0x2D   45  -  
  9985	:  0100_0011  0x43   67  C  
  9986	:  0011_0011  0x33   51  3  
  9987	:  1000_1001  0x89  137    
  9988	:  0000_1000  0x08    8    
  9989	:  0100_0001  0x41   65  A  
  9990	:  0010_1101  0x2D   45  -  
  9991	:  0011_0101  0x35   53  5  
  9992	:  0011_0001  0x31   49  1  
  9993	:  0010_1101  0x2D   45  -  
  9994	:  0011_0001  0x31   49  1  
  9995	:  0011_0011  0x33   51  3  
  9996	:  0011_1000  0x38   56  8  
  9997	:  1100_0000  0xC0  192    
  9998	:  0000_1100  0x0C   12    
  9999	:  0000_0000  0x00    0    
  10000	:  0000_0001  0x01    1    
  10001	:  0000_0000  0x00    0    
  10002	:  0000_0001  0x01    1    
  10003	:  0000_0000  0x00    0    
  10004	:  0000_0000  0x00    0    
  10005	:  0010_1010  0x2A   42  *  
  10006	:  0011_0000  0x30   48  0  
  10007	:  0000_0000  0x00    0    
  10008	:  0000_0100  0x04    4    
  10009	:  0010_1101  0x2D   45  -  
  10010	:  0100_0011  0x43   67  C  
  10011	:  0011_0011  0x33   51  3  
  10012	:  1000_1010  0x8A  138    
  10013	:  0000_1000  0x08    8    
  10014	:  0100_0001  0x41   65  A  
  10015	:  0010_1101  0x2D   45  -  
  10016	:  0011_0101  0x35   53  5  
  10017	:  0011_0001  0x31   49  1  
  10018	:  0010_1101  0x2D   45  -  
  10019	:  0011_0001  0x31   49  1  
  10020	:  0011_0011  0x33   51  3  
  10021	:  0011_1001  0x39   57  9  
  10022	:  1100_0000  0xC0  192    
  10023	:  0000_1100  0x0C   12    
  10024	:  0000_0000  0x00    0    
  10025	:  0000_0001  0x01    1    
  10026	:  0000_0000  0x00    0    
  10027	:  0000_0001  0x01    1    
  10028	:  0000_0000  0x00    0    
  10029	:  0000_0000  0x00    0    
  10030	:  0010_1010  0x2A   42  *  
  10031	:  0011_0000  0x30   48  0  
  10032	:  0000_0000  0x00    0    
  10033	:  0000_0100  0x04    4    
  10034	:  0010_1101  0x2D   45  -  
  10035	:  0100_0011  0x43   67  C  
  10036	:  0011_0011  0x33   51  3  
  10037	:  1000_1011  0x8B  139    
  10038	:  0000_1000  0x08    8    
  10039	:  0100_0001  0x41   65  A  
  10040	:  0010_1101  0x2D   45  -  
  10041	:  0011_0101  0x35   53  5  
  10042	:  0011_0001  0x31   49  1  
  10043	:  0010_1101  0x2D   45  -  
  10044	:  0011_0001  0x31   49  1  
  10045	:  0011_0100  0x34   52  4  
  10046	:  0011_0000  0x30   48  0  
  10047	:  1100_0000  0xC0  192    
  10048	:  0000_1100  0x0C   12    
  10049	:  0000_0000  0x00    0    
  10050	:  0000_0001  0x01    1    
  10051	:  0000_0000  0x00    0    
  10052	:  0000_0001  0x01    1    
  10053	:  0000_0000  0x00    0    
  10054	:  0000_0000  0x00    0    
  10055	:  0010_1010  0x2A   42  *  
  10056	:  0011_0000  0x30   48  0  
  10057	:  0000_0000  0x00    0    
  10058	:  0000_0100  0x04    4    
  10059	:  0010_1101  0x2D   45  -  
  10060	:  0100_0011  0x43   67  C  
  10061	:  0011_0011  0x33   51  3  
  10062	:  1000_1100  0x8C  140    
  10063	:  0000_1000  0x08    8    
  10064	:  0100_0001  0x41   65  A  
  10065	:  0010_1101  0x2D   45  -  
  10066	:  0011_0101  0x35   53  5  
  10067	:  0011_0001  0x31   49  1  
  10068	:  0010_1101  0x2D   45  -  
  10069	:  0011_0001  0x31   49  1  
  10070	:  0011_0100  0x34   52  4  
  10071	:  0011_0001  0x31   49  1  
  10072	:  1100_0000  0xC0  192    
  10073	:  0000_1100  0x0C   12    
  10074	:  0000_0000  0x00    0    
  10075	:  0000_0001  0x01    1    
  10076	:  0000_0000  0x00    0    
  10077	:  0000_0001  0x01    1    
  10078	:  0000_0000  0x00    0    
  10079	:  0000_0000  0x00    0    
  10080	:  0010_1010  0x2A   42  *  
  10081	:  0011_0000  0x30   48  0  
  10082	:  0000_0000  0x00    0    
  10083	:  0000_0100  0x04    4    
  10084	:  0010_1101  0x2D   45  -  
  10085	:  0100_0011  0x43   67  C  
  10086	:  0011_0011  0x33   51  3  
  10087	:  1000_1101  0x8D  141    
  10088	:  0000_1000  0x08    8    
  10089	:  0100_0001  0x41   65  A  
  10090	:  0010_1101  0x2D   45  -  
  10091	:  0011_0101  0x35   53  5  
  10092	:  0011_0001  0x31   49  1  
  10093	:  0010_1101  0x2D   45  -  
  10094	:  0011_0001  0x31   49  1  
  10095	:  0011_0100  0x34   52  4  
  10096	:  0011_0010  0x32   50  2  
  10097	:  1100_0000  0xC0  192    
  10098	:  0000_1100  0x0C   12    
  10099	:  0000_0000  0x00    0    
  10100	:  0000_0001  0x01    1    
  10101	:  0000_0000  0x00    0    
  10102	:  0000_0001  0x01    1    
  10103	:  0000_0000  0x00    0    
  10104	:  0000_0000  0x00    0    
  10105	:  0010_1010  0x2A   42  *  
  10106	:  0011_0000  0x30   48  0  
  10107	:  0000_0000  0x00    0    
  10108	:  0000_0100  0x04    4    
  10109	:  0010_1101  0x2D   45  -  
  10110	:  0100_0011  0x43   67  C  
  10111	:  0011_0011  0x33   51  3  
  10112	:  1000_1110  0x8E  142    
  10113	:  0000_1000  0x08    8    
  10114	:  0100_0001  0x41   65  A  
  10115	:  0010_1101  0x2D   45  -  
  10116	:  0011_0101  0x35   53  5  
  10117	:  0011_0001  0x31   49  1  
  10118	:  0010_1101  0x2D   45  -  
  10119	:  0011_0001  0x31   49  1  
  10120	:  0011_0100  0x34   52  4  
  10121	:  0011_0011  0x33   51  3  
  10122	:  1100_0000  0xC0  192    
  10123	:  0000_1100  0x0C   12    
  10124	:  0000_0000  0x00    0    
  10125	:  0000_0001  0x01    1    
  10126	:  0000_0000  0x00    0    
  10127	:  0000_0001  0x01    1    
  10128	:  0000_0000  0x00    0    
  10129	:  0000_0000  0x00    0    
  10130	:  0010_1010  0x2A   42  *  
  10131	:  0011_0000  0x30   48  0  
  10132	:  0000_0000  0x00    0    
  10133	:  0000_0100  0x04    4    
  10134	:  0010_1101  0x2D   45  -  
  10135	:  0100_0011  0x43   67  C  
  10136	:  0011_0011  0x33   51  3  
  10137	:  1000_1111  0x8F  143    
  10138	:  0000_1000  0x08    8    
  10139	:  0100_0001  0x41   65  A  
  10140	:  0010_1101  0x2D   45  -  
  10141	:  0011_0101  0x35   53  5  
  10142	:  0011_0001  0x31   49  1  
  10143	:  0010_1101  0x2D   45  -  
  10144	:  0011_0001  0x31   49  1  
  10145	:  0011_0100  0x34   52  4  
  10146	:  0011_0100  0x34   52  4  
  10147	:  1100_0000  0xC0  192    
  10148	:  0000_1100  0x0C   12    
  10149	:  0000_0000  0x00    0    
  10150	:  0000_0001  0x01    1    
  10151	:  0000_0000  0x00    0    
  10152	:  0000_0001  0x01    1    
  10153	:  0000_0000  0x00    0    
  10154	:  0000_0000  0x00    0    
  10155	:  0010_1010  0x2A   42  *  
  10156	:  0011_0000  0x30   48  0  
  10157	:  0000_0000  0x00    0    
  10158	:  0000_0100  0x04    4    
  10159	:  0010_1101  0x2D   45  -  
  10160	:  0100_0011  0x43   67  C  
  10161	:  0011_0011  0x33   51  3  
  10162	:  1001_0000  0x90  144    
  10163	:  0000_1000  0x08    8    
  10164	:  0100_0001  0x41   65  A  
  10165	:  0010_1101  0x2D   45  -  
  10166	:  0011_0101  0x35   53  5  
  10167	:  0011_0001  0x31   49  1  
  10168	:  0010_1101  0x2D   45  -  
  10169	:  0011_0001  0x31   49  1  
  10170	:  0011_0100  0x34   52  4  
  10171	:  0011_0101  0x35   53  5  
  10172	:  1100_0000  0xC0  192    
  10173	:  0000_1100  0x0C   12    
  10174	:  0000_0000  0x00    0    
  10175	:  0000_0001  0x01    1    
  10176	:  0000_0000  0x00    0    
  10177	:  0000_0001  0x01    1    
  10178	:  0000_0000  0x00    0    
  10179	:  0000_0000  0x00    0    
  10180	:  0010_1010  0x2A   42  *  
  10181	:  0011_0000  0x30   48  0  
  10182	:  0000_0000  0x00    0    
  10183	:  0000_0100  0x04    4    
  10184	:  0010_1101  0x2D   45  -  
  10185	:  0100_0011  0x43   67  C  
  10186	:  0011_0011  0x33   51  3  
  10187	:  1001_0001  0x91  145    
  10188	:  0000_1000  0x08    8    
  10189	:  0100_0001  0x41   65  A  
  10190	:  0010_1101  0x2D   45  -  
  10191	:  0011_0101  0x35   53  5  
  10192	:  0011_0001  0x31   49  1  
  10193	:  0010_1101  0x2D   45  -  
  10194	:  0011_0001  0x31   49  1  
  10195	:  0011_0100  0x34   52  4  
  10196	:  0011_0110  0x36   54  6  
  10197	:  1100_0000  0xC0  192    
  10198	:  0000_1100  0x0C   12    
  10199	:  0000_0000  0x00    0    
  10200	:  0000_0001  0x01    1    
  10201	:  0000_0000  0x00    0    
  10202	:  0000_0001  0x01    1    
  10203	:  0000_0000  0x00    0    
  10204	:  0000_0000  0x00    0    
  10205	:  0010_1010  0x2A   42  *  
  10206	:  0011_0000  0x30   48  0  
  10207	:  0000_0000  0x00    0    
  10208	:  0000_0100  0x04    4    
  10209	:  0010_1101  0x2D   45  -  
  10210	:  0100_0011  0x43   67  C  
  10211	:  0011_0011  0x33   51  3  
  10212	:  1001_0010  0x92  146    
  10213	:  0000_1000  0x08    8    
  10214	:  0100_0001  0x41   65  A  
  10215	:  0010_1101  0x2D   45  -  
  10216	:  0011_0101  0x35   53  5  
  10217	:  0011_0001  0x31   49  1  
  10218	:  0010_1101  0x2D   45  -  
  10219	:  0011_0001  0x31   49  1  
  10220	:  0011_0100  0x34   52  4  
  10221	:  0011_0111  0x37   55  7  
  10222	:  1100_0000  0xC0  192    
  10223	:  0000_1100  0x0C   12    
  10224	:  0000_0000  0x00    0    
  10225	:  0000_0001  0x01    1    
  10226	:  0000_0000  0x00    0    
  10227	:  0000_0001  0x01    1    
  10228	:  0000_0000  0x00    0    
  10229	:  0000_0000  0x00    0    
  10230	:  0010_1010  0x2A   42  *  
  10231	:  0011_0000  0x30   48  0  
  10232	:  0000_0000  0x00    0    
  10233	:  0000_0100  0x04    4    
  10234	:  0010_1101  0x2D   45  -  
  10235	:  0100_0011  0x43   67  C  
  10236	:  0011_0011  0x33   51  3  
  10237	:  1001_0011  0x93  147    
  10238	:  0000_1000  0x08    8    
  10239	:  0100_0001  0x41   65  A  
  10240	:  0010_1101  0x2D   45  -  
  10241	:  0011_0101  0x35   53  5  
  10242	:  0011_0001  0x31   49  1  
  10243	:  0010_1101  0x2D   45  -  
  10244	:  0011_0001  0x31   49  1  
  10245	:  0011_0100  0x34   52  4  
  10246	:  0011_1000  0x38   56  8  
  10247	:  1100_0000  0xC0  192    
  10248	:  0000_1100  0x0C   12    
  10249	:  0000_0000  0x00    0    
  10250	:  0000_0001  0x01    1    
  10251	:  0000_0000  0x00    0    
  10252	:  0000_0001  0x01    1    
  10253	:  0000_0000  0x00    0    
  10254	:  0000_0000  0x00    0    
  10255	:  0010_1010  0x2A   42  *  
  10256	:  0011_0000  0x30   48  0  
  10257	:  0000_0000  0x00    0    
  10258	:  0000_0100  0x04    4    
  10259	:  0010_1101  0x2D   45  -  
  10260	:  0100_0011  0x43   67  C  
  10261	:  0011_0011  0x33   51  3  
  10262	:  1001_0100  0x94  148    
  10263	:  0000_1000  0x08    8    
  10264	:  0100_0001  0x41   65  A  
  10265	:  0010_1101  0x2D   45  -  
  10266	:  0011_0101  0x35   53  5  
  10267	:  0011_0001  0x31   49  1  
  10268	:  0010_1101  0x2D   45  -  
  10269	:  0011_0001  0x31   49  1  
  10270	:  0011_0100  0x34   52  4  
  10271	:  0011_1001  0x39   57  9  
  10272	:  1100_0000  0xC0  192    
  10273	:  0000_1100  0x0C   12    
  10274	:  0000_0000  0x00    0    
  10275	:  0000_0001  0x01    1    
  10276	:  0000_0000  0x00    0    
  10277	:  0000_0001  0x01    1    
  10278	:  0000_0000  0x00    0    
  10279	:  0000_0000  0x00    0    
  10280	:  0010_1010  0x2A   42  *  
  10281	:  0011_0000  0x30   48  0  
  10282	:  0000_0000  0x00    0    
  10283	:  0000_0100  0x04    4    
  10284	:  0010_1101  0x2D   45  -  
  10285	:  0100_0011  0x43   67  C  
  10286	:  0011_0011  0x33   51  3  
  10287	:  1001_0101  0x95  149    
  10288	:  0000_1000  0x08    8    
  10289	:  0100_0001  0x41   65  A  
  10290	:  0010_1101  0x2D   45  -  
  10291	:  0011_0101  0x35   53  5  
  10292	:  0011_0001  0x31   49  1  
  10293	:  0010_1101  0x2D   45  -  
  10294	:  0011_0001  0x31   49  1  
  10295	:  0011_0101  0x35   53  5  
  10296	:  0011_0000  0x30   48  0  
  10297	:  1100_0000  0xC0  192    
  10298	:  0000_1100  0x0C   12    
  10299	:  0000_0000  0x00    0    
  10300	:  0000_0001  0x01    1    
  10301	:  0000_0000  0x00    0    
  10302	:  0000_0001  0x01    1    
  10303	:  0000_0000  0x00    0    
  10304	:  0000_0000  0x00    0    
  10305	:  0010_1010  0x2A   42  *  
  10306	:  0011_0000  0x30   48  0  
  10307	:  0000_0000  0x00    0    
  10308	:  0000_0100  0x04    4    
  10309	:  0010_1101  0x2D   45  -  
  10310	:  0100_0011  0x43   67  C  
  10311	:  0011_0011  0x33   51  3  
  10312	:  1001_0110  0x96  150    
  10313	:  0000_1000  0x08    8    
  10314	:  0100_0001  0x41   65  A  
  10315	:  0010_1101  0x2D   45  -  
  10316	:  0011_0101  0x35   53  5  
  10317	:  0011_0001  0x31   49  1  
  10318	:  0010_1101  0x2D   45  -  
  10319	:  0011_0001  0x31   49  1  
  10320	:  0011_0101  0x35   53  5  
  10321	:  0011_0001  0x31   49  1  
  10322	:  1100_0000  0xC0  192    
  10323	:  0000_1100  0x0C   12    
  10324	:  0000_0000  0x00    0    
  10325	:  0000_0001  0x01    1    
  10326	:  0000_0000  0x00    0    
  10327	:  0000_0001  0x01    1    
  10328	:  0000_0000  0x00    0    
  10329	:  0000_0000  0x00    0    
  10330	:  0010_1010  0x2A   42  *  
  10331	:  0011_0000  0x30   48  0  
  10332	:  0000_0000  0x00    0    
  10333	:  0000_0100  0x04    4    
  10334	:  0010_1101  0x2D   45  -  
  10335	:  0100_0011  0x43   67  C  
  10336	:  0011_0011  0x33   51  3  
  10337	:  1001_0111  0x97  151    
  10338	:  0000_1000  0x08    8    
  10339	:  0100_0001  0x41   65  A  
  10340	:  0010_1101  0x2D   45  -  
  10341	:  0011_0101  0x35   53  5  
  10342	:  0011_0001  0x31   49  1  
  10343	:  0010_1101  0x2D   45  -  
  10344	:  0011_0001  0x31   49  1  
  10345	:  0011_0101  0x35   53  5  
  10346	:  0011_0010  0x32   50  2  
  10347	:  1100_0000  0xC0  192    
  10348	:  0000_1100  0x0C   12    
  10349	:  0000_0000  0x00    0    
  10350	:  0000_0001  0x01    1    
  10351	:  0000_0000  0x00    0    
  10352	:  0000_0001  0x01    1    
  10353	:  0000_0000  0x00    0    
  10354	:  0000_0000  0x00    0    
  10355	:  0010_1010  0x2A   42  *  
  10356	:  0011_0000  0x30   48  0  
  10357	:  0000_0000  0x00    0    
  10358	:  0000_0100  0x04    4    
  10359	:  0010_1101  0x2D   45  -  
  10360	:  0100_0011  0x43   67  C  
  10361	:  0011_0011  0x33   51  3  
  10362	:  1001_1000  0x98  152    
  10363	:  0000_1000  0x08    8    
  10364	:  0100_0001  0x41   65  A  
  10365	:  0010_1101  0x2D   45  -  
  10366	:  0011_0101  0x35   53  5  
  10367	:  0011_0001  0x31   49  1  
  10368	:  0010_1101  0x2D   45  -  
  10369	:  0011_0001  0x31   49  1  
  10370	:  0011_0101  0x35   53  5  
  10371	:  0011_0011  0x33   51  3  
  10372	:  1100_0000  0xC0  192    
  10373	:  0000_1100  0x0C   12    
  10374	:  0000_0000  0x00    0    
  10375	:  0000_0001  0x01    1    
  10376	:  0000_0000  0x00    0    
  10377	:  0000_0001  0x01    1    
  10378	:  0000_0000  0x00    0    
  10379	:  0000_0000  0x00    0    
  10380	:  0010_1010  0x2A   42  *  
  10381	:  0011_0000  0x30   48  0  
  10382	:  0000_0000  0x00    0    
  10383	:  0000_0100  0x04    4    
  10384	:  0010_1101  0x2D   45  -  
  10385	:  0100_0011  0x43   67  C  
  10386	:  0011_0011  0x33   51  3  
  10387	:  1001_1001  0x99  153    
  10388	:  0000_1000  0x08    8    
  10389	:  0100_0001  0x41   65  A  
  10390	:  0010_1101  0x2D   45  -  
  10391	:  0011_0101  0x35   53  5  
  10392	:  0011_0001  0x31   49  1  
  10393	:  0010_1101  0x2D   45  -  
  10394	:  0011_0001  0x31   49  1  
  10395	:  0011_0101  0x35   53  5  
  10396	:  0011_0100  0x34   52  4  
  10397	:  1100_0000  0xC0  192    
  10398	:  0000_1100  0x0C   12    
  10399	:  0000_0000  0x00    0    
  10400	:  0000_0001  0x01    1    
  10401	:  0000_0000  0x00    0    
  10402	:  0000_0001  0x01    1    
  10403	:  0000_0000  0x00    0    
  10404	:  0000_0000  0x00    0    
  10405	:  0010_1010  0x2A   42  *  
  10406	:  0011_0000  0x30   48  0  
  10407	:  0000_0000  0x00    0    
  10408	:  0000_0100  0x04    4    
  10409	:  0010_1101  0x2D   45  -  
  10410	:  0100_0011  0x43   67  C  
  10411	:  0011_0011  0x33   51  3  
  10412	:  1001_1010  0x9A  154    
  10413	:  0000_1000  0x08    8    
  10414	:  0100_0001  0x41   65  A  
  10415	:  0010_1101  0x2D   45  -  
  10416	:  0011_0101  0x35   53  5  
  10417	:  0011_0001  0x31   49  1  
  10418	:  0010_1101  0x2D   45  -  
  10419	:  0011_0001  0x31   49  1  
  10420	:  0011_0101  0x35   53  5  
  10421	:  0011_0101  0x35   53  5  
  10422	:  1100_0000  0xC0  192    
  10423	:  0000_1100  0x0C   12    
  10424	:  0000_0000  0x00    0    
  10425	:  0000_0001  0x01    1    
  10426	:  0000_0000  0x00    0    
  10427	:  0000_0001  0x01    1    
  10428	:  0000_0000  0x00    0    
  10429	:  0000_0000  0x00    0    
  10430	:  0010_1010  0x2A   42  *  
  10431	:  0011_0000  0x30   48  0  
  10432	:  0000_0000  0x00    0    
  10433	:  0000_0100  0x04    4    
  10434	:  0010_1101  0x2D   45  -  
  10435	:  0100_0011  0x43   67  C  
  10436	:  0011_0011  0x33   51  3  
  10437	:  1001_1011  0x9B  155    
  10438	:  0000_1000  0x08    8    
  10439	:  0100_0001  0x41   65  A  
  10440	:  0010_1101  0x2D   45  -  
  10441	:  0011_0101  0x35   53  5  
  10442	:  0011_0001  0x31   49  1  
  10443	:  0010_1101  0x2D   45  -  
  10444	:  0011_0001  0x31   49  1  
  10445	:  0011_0101  0x35   53  5  
  10446	:  0011_0110  0x36   54  6  
  10447	:  1100_0000  0xC0  192    
  10448	:  0000_1100  0x0C   12    
  10449	:  0000_0000  0x00    0    
  10450	:  0000_0001  0x01    1    
  10451	:  0000_0000  0x00    0    
  10452	:  0000_0001  0x01    1    
  10453	:  0000_0000  0x00    0    
  10454	:  0000_0000  0x00    0    
  10455	:  0010_1010  0x2A   42  *  
  10456	:  0011_0000  0x30   48  0  
  10457	:  0000_0000  0x00    0    
  10458	:  0000_0100  0x04    4    
  10459	:  0010_1101  0x2D   45  -  
  10460	:  0100_0011  0x43   67  C  
  10461	:  0011_0011  0x33   51  3  
  10462	:  1001_1100  0x9C  156    
  10463	:  0000_1000  0x08    8    
  10464	:  0100_0001  0x41   65  A  
  10465	:  0010_1101  0x2D   45  -  
  10466	:  0011_0101  0x35   53  5  
  10467	:  0011_0001  0x31   49  1  
  10468	:  0010_1101  0x2D   45  -  
  10469	:  0011_0001  0x31   49  1  
  10470	:  0011_0101  0x35   53  5  
  10471	:  0011_0111  0x37   55  7  
  10472	:  1100_0000  0xC0  192    
  10473	:  0000_1100  0x0C   12    
  10474	:  0000_0000  0x00    0    
  10475	:  0000_0001  0x01    1    
  10476	:  0000_0000  0x00    0    
  10477	:  0000_0001  0x01    1    
  10478	:  0000_0000  0x00    0    
  10479	:  0000_0000  0x00    0    
  10480	:  0010_1010  0x2A   42  *  
  10481	:  0011_0000  0x30   48  0  
  10482	:  0000_0000  0x00    0    
  10483	:  0000_0100  0x04    4    
  10484	:  0010_1101  0x2D   45  -  
  10485	:  0100_0011  0x43   67  C  
  10486	:  0011_0011  0x33   51  3  
  10487	:  1001_1101  0x9D  157    
  10488	:  0000_1000  0x08    8    
  10489	:  0100_0001  0x41   65  A  
  10490	:  0010_1101  0x2D   45  -  
  10491	:  0011_0101  0x35   53  5  
  10492	:  0011_0001  0x31   49  1  
  10493	:  0010_1101  0x2D   45  -  
  10494	:  0011_0001  0x31   49  1  
  10495	:  0011_0101  0x35   53  5  
  10496	:  0011_1000  0x38   56  8  
  10497	:  1100_0000  0xC0  192    
  10498	:  0000_1100  0x0C   12    
  10499	:  0000_0000  0x00    0    
  10500	:  0000_0001  0x01    1    
  10501	:  0000_0000  0x00    0    
  10502	:  0000_0001  0x01    1    
  10503	:  0000_0000  0x00    0    
  10504	:  0000_0000  0x00    0    
  10505	:  0010_1010  0x2A   42  *  
  10506	:  0011_0000  0x30   48  0  
  10507	:  0000_0000  0x00    0    
  10508	:  0000_0100  0x04    4    
  10509	:  0010_1101  0x2D   45  -  
  10510	:  0100_0011  0x43   67  C  
  10511	:  0011_0011  0x33   51  3  
  10512	:  1001_1110  0x9E  158    
  10513	:  0000_1000  0x08    8    
  10514	:  0100_0001  0x41   65  A  
  10515	:  0010_1101  0x2D   45  -  
  10516	:  0011_0101  0x35   53  5  
  10517	:  0011_0001  0x31   49  1  
  10518	:  0010_1101  0x2D   45  -  
  10519	:  0011_0001  0x31   49  1  
  10520	:  0011_0101  0x35   53  5  
  10521	:  0011_1001  0x39   57  9  
  10522	:  1100_0000  0xC0  192    
  10523	:  0000_1100  0x0C   12    
  10524	:  0000_0000  0x00    0    
  10525	:  0000_0001  0x01    1    
  10526	:  0000_0000  0x00    0    
  10527	:  0000_0001  0x01    1    
  10528	:  0000_0000  0x00    0    
  10529	:  0000_0000  0x00    0    
  10530	:  0010_1010  0x2A   42  *  
  10531	:  0011_0000  0x30   48  0  
  10532	:  0000_0000  0x00    0    
  10533	:  0000_0100  0x04    4    
  10534	:  0010_1101  0x2D   45  -  
  10535	:  0100_0011  0x43   67  C  
  10536	:  0011_0011  0x33   51  3  
  10537	:  1001_1111  0x9F  159    
  10538	:  0000_1000  0x08    8    
  10539	:  0100_0001  0x41   65  A  
  10540	:  0010_1101  0x2D   45  -  
  10541	:  0011_0101  0x35   53  5  
  10542	:  0011_0001  0x31   49  1  
  10543	:  0010_1101  0x2D   45  -  
  10544	:  0011_0001  0x31   49  1  
  10545	:  0011_0110  0x36   54  6  
  10546	:  0011_0000  0x30   48  0  
  10547	:  1100_0000  0xC0  192    
  10548	:  0000_1100  0x0C   12    
  10549	:  0000_0000  0x00    0    
  10550	:  0000_0001  0x01    1    
  10551	:  0000_0000  0x00    0    
  10552	:  0000_0001  0x01    1    
  10553	:  0000_0000  0x00    0    
  10554	:  0000_0000  0x00    0    
  10555	:  0010_1010  0x2A   42  *  
  10556	:  0011_0000  0x30   48  0  
  10557	:  0000_0000  0x00    0    
  10558	:  0000_0100  0x04    4    
  10559	:  0010_1101  0x2D   45  -  
  10560	:  0100_0011  0x43   67  C  
  10561	:  0011_0011  0x33   51  3  
  10562	:  1010_0000  0xA0  160    
  10563	:  0000_1000  0x08    8    
  10564	:  0100_0001  0x41   65  A  
  10565	:  0010_1101  0x2D   45  -  
  10566	:  0011_0101  0x35   53  5  
  10567	:  0011_0001  0x31   49  1  
  10568	:  0010_1101  0x2D   45  -  
  10569	:  0011_0001  0x31   49  1  
  10570	:  0011_0110  0x36   54  6  
  10571	:  0011_0001  0x31   49  1  
  10572	:  1100_0000  0xC0  192    
  10573	:  0000_1100  0x0C   12    
  10574	:  0000_0000  0x00    0    
  10575	:  0000_0001  0x01    1    
  10576	:  0000_0000  0x00    0    
  10577	:  0000_0001  0x01    1    
  10578	:  0000_0000  0x00    0    
  10579	:  0000_0000  0x00    0    
  10580	:  0010_1010  0x2A   42  *  
  10581	:  0011_0000  0x30   48  0  
  10582	:  0000_0000  0x00    0    
  10583	:  0000_0100  0x04    4    
  10584	:  0010_1101  0x2D   45  -  
  10585	:  0100_0011  0x43   67  C  
  10586	:  0011_0011  0x33   51  3  
  10587	:  1010_0001  0xA1  161    
  10588	:  0000_1000  0x08    8    
  10589	:  0100_0001  0x41   65  A  
  10590	:  0010_1101  0x2D   45  -  
  10591	:  0011_0101  0x35   53  5  
  10592	:  0011_0001  0x31   49  1  
  10593	:  0010_1101  0x2D   45  -  
  10594	:  0011_0001  0x31   49  1  
  10595	:  0011_0110  0x36   54  6  
  10596	:  0011_0010  0x32   50  2  
  10597	:  1100_0000  0xC0  192    
  10598	:  0000_1100  0x0C   12    
  10599	:  0000_0000  0x00    0    
  10600	:  0000_0001  0x01    1    
  10601	:  0000_0000  0x00    0    
  10602	:  0000_0001  0x01    1    
  10603	:  0000_0000  0x00    0    
  10604	:  0000_0000  0x00    0    
  10605	:  0010_1010  0x2A   42  *  
  10606	:  0011_0000  0x30   48  0  
  10607	:  0000_0000  0x00    0    
  10608	:  0000_0100  0x04    4    
  10609	:  0010_1101  0x2D   45  -  
  10610	:  0100_0011  0x43   67  C  
  10611	:  0011_0011  0x33   51  3  
  10612	:  1010_0010  0xA2  162    
  10613	:  0000_1000  0x08    8    
  10614	:  0100_0001  0x41   65  A  
  10615	:  0010_1101  0x2D   45  -  
  10616	:  0011_0101  0x35   53  5  
  10617	:  0011_0001  0x31   49  1  
  10618	:  0010_1101  0x2D   45  -  
  10619	:  0011_0001  0x31   49  1  
  10620	:  0011_0110  0x36   54  6  
  10621	:  0011_0011  0x33   51  3  
  10622	:  1100_0000  0xC0  192    
  10623	:  0000_1100  0x0C   12    
  10624	:  0000_0000  0x00    0    
  10625	:  0000_0001  0x01    1    
  10626	:  0000_0000  0x00    0    
  10627	:  0000_0001  0x01    1    
  10628	:  0000_0000  0x00    0    
  10629	:  0000_0000  0x00    0    
  10630	:  0010_1010  0x2A   42  *  
  10631	:  0011_0000  0x30   48  0  
  10632	:  0000_0000  0x00    0    
  10633	:  0000_0100  0x04    4    
  10634	:  0010_1101  0x2D   45  -  
  10635	:  0100_0011  0x43   67  C  
  10636	:  0011_0011  0x33   51  3  
  10637	:  1010_0011  0xA3  163    
  10638	:  0000_1000  0x08    8    
  10639	:  0100_0001  0x41   65  A  
  10640	:  0010_1101  0x2D   45  -  
  10641	:  0011_0101  0x35   53  5  
  10642	:  0011_0001  0x31   49  1  
  10643	:  0010_1101  0x2D   45  -  
  10644	:  0011_0001  0x31   49  1  
  10645	:  0011_0110  0x36   54  6  
  10646	:  0011_0100  0x34   52  4  
  10647	:  1100_0000  0xC0  192    
  10648	:  0000_1100  0x0C   12    
  10649	:  0000_0000  0x00    0    
  10650	:  0000_0001  0x01    1    
  10651	:  0000_0000  0x00    0    
  10652	:  0000_0001  0x01    1    
  10653	:  0000_0000  0x00    0    
  10654	:  0000_0000  0x00    0    
  10655	:  0010_1010  0x2A   42  *  
  10656	:  0011_0000  0x30   48  0  
  10657	:  0000_0000  0x00    0    
  10658	:  0000_0100  0x04    4    
  10659	:  0010_1101  0x2D   45  -  
  10660	:  0100_0011  0x43   67  C  
  10661	:  0011_0011  0x33   51  3  
  10662	:  1010_0100  0xA4  164    
  10663	:  0000_1000  0x08    8    
  10664	:  0100_0001  0x41   65  A  
  10665	:  0010_1101  0x2D   45  -  
  10666	:  0011_0101  0x35   53  5  
  10667	:  0011_0001  0x31   49  1  
  10668	:  0010_1101  0x2D   45  -  
  10669	:  0011_0001  0x31   49  1  
  10670	:  0011_0110  0x36   54  6  
  10671	:  0011_0101  0x35   53  5  
  10672	:  1100_0000  0xC0  192    
  10673	:  0000_1100  0x0C   12    
  10674	:  0000_0000  0x00    0    
  10675	:  0000_0001  0x01    1    
  10676	:  0000_0000  0x00    0    
  10677	:  0000_0001  0x01    1    
  10678	:  0000_0000  0x00    0    
  10679	:  0000_0000  0x00    0    
  10680	:  0010_1010  0x2A   42  *  
  10681	:  0011_0000  0x30   48  0  
  10682	:  0000_0000  0x00    0    
  10683	:  0000_0100  0x04    4    
  10684	:  0010_1101  0x2D   45  -  
  10685	:  0100_0011  0x43   67  C  
  10686	:  0011_0011  0x33   51  3  
  10687	:  1010_0101  0xA5  165    
  10688	:  0000_1000  0x08    8    
  10689	:  0100_0001  0x41   65  A  
  10690	:  0010_1101  0x2D   45  -  
  10691	:  0011_0101  0x35   53  5  
  10692	:  0011_0001  0x31   49  1  
  10693	:  0010_1101  0x2D   45  -  
  10694	:  0011_0001  0x31   49  1  
  10695	:  0011_0110  0x36   54  6  
  10696	:  0011_0110  0x36   54  6  
  10697	:  1100_0000  0xC0  192    
  10698	:  0000_1100  0x0C   12    
  10699	:  0000_0000  0x00    0    
  10700	:  0000_0001  0x01    1    
  10701	:  0000_0000  0x00    0    
  10702	:  0000_0001  0x01    1    
  10703	:  0000_0000  0x00    0    
  10704	:  0000_0000  0x00    0    
  10705	:  0010_1010  0x2A   42  *  
  10706	:  0011_0000  0x30   48  0  
  10707	:  0000_0000  0x00    0    
  10708	:  0000_0100  0x04    4    
  10709	:  0010_1101  0x2D   45  -  
  10710	:  0100_0011  0x43   67  C  
  10711	:  0011_0011  0x33   51  3  
  10712	:  1010_0110  0xA6  166    
  10713	:  0000_1000  0x08    8    
  10714	:  0100_0001  0x41   65  A  
  10715	:  0010_1101  0x2D   45  -  
  10716	:  0011_0101  0x35   53  5  
  10717	:  0011_0001  0x31   49  1  
  10718	:  0010_1101  0x2D   45  -  
  10719	:  0011_0001  0x31   49  1  
  10720	:  0011_0110  0x36   54  6  
  10721	:  0011_0111  0x37   55  7  
  10722	:  1100_0000  0xC0  192    
  10723	:  0000_1100  0x0C   12    
  10724	:  0000_0000  0x00    0    
  10725	:  0000_0001  0x01    1    
  10726	:  0000_0000  0x00    0    
  10727	:  0000_0001  0x01    1    
  10728	:  0000_0000  0x00    0    
  10729	:  0000_0000  0x00    0    
  10730	:  0010_1010  0x2A   42  *  
  10731	:  0011_0000  0x30   48  0  
  10732	:  0000_0000  0x00    0    
  10733	:  0000_0100  0x04    4    
  10734	:  0010_1101  0x2D   45  -  
  10735	:  0100_0011  0x43   67  C  
  10736	:  0011_0011  0x33   51  3  
  10737	:  1010_0111  0xA7  167    
  10738	:  0000_1000  0x08    8    
  10739	:  0100_0001  0x41   65  A  
  10740	:  0010_1101  0x2D   45  -  
  10741	:  0011_0101  0x35   53  5  
  10742	:  0011_0001  0x31   49  1  
  10743	:  0010_1101  0x2D   45  -  
  10744	:  0011_0001  0x31   49  1  
  10745	:  0011_0110  0x36   54  6  
  10746	:  0011_1000  0x38   56  8  
  10747	:  1100_0000  0xC0  192    
  10748	:  0000_1100  0x0C   12    
  10749	:  0000_0000  0x00    0    
  10750	:  0000_0001  0x01    1    
  10751	:  0000_0000  0x00    0    
  10752	:  0000_0001  0x01    1    
  10753	:  0000_0000  0x00    0    
  10754	:  0000_0000  0x00    0    
  10755	:  0010_1010  0x2A   42  *  
  10756	:  0011_0000  0x30   48  0  
  10757	:  0000_0000  0x00    0    
  10758	:  0000_0100  0x04    4    
  10759	:  0010_1101  0x2D   45  -  
  10760	:  0100_0011  0x43   67  C  
  10761	:  0011_0011  0x33   51  3  
  10762	:  1010_1000  0xA8  168    
  10763	:  0000_1000  0x08    8    
  10764	:  0100_0001  0x41   65  A  
  10765	:  0010_1101  0x2D   45  -  
  10766	:  0011_0101  0x35   53  5  
  10767	:  0011_0001  0x31   49  1  
  10768	:  0010_1101  0x2D   45  -  
  10769	:  0011_0001  0x31   49  1  
  10770	:  0011_0110  0x36   54  6  
  10771	:  0011_1001  0x39   57  9  
  10772	:  1100_0000  0xC0  192    
  10773	:  0000_1100  0x0C   12    
  10774	:  0000_0000  0x00    0    
  10775	:  0000_0001  0x01    1    
  10776	:  0000_0000  0x00    0    
  10777	:  0000_0001  0x01    1    
  10778	:  0000_0000  0x00    0    
  10779	:  0000_0000  0x00    0    
  10780	:  0010_1010  0x2A   42  *  
  10781	:  0011_0000  0x30   48  0  
  10782	:  0000_0000  0x00    0    
  10783	:  0000_0100  0x04    4    
  10784	:  0010_1101  0x2D   45  -  
  10785	:  0100_0011  0x43   67  C  
  10786	:  0011_0011  0x33   51  3  
  10787	:  1010_1001  0xA9  169    
  10788	:  0000_1000  0x08    8    
  10789	:  0100_0001  0x41   65  A  
  10790	:  0010_1101  0x2D   45  -  
  10791	:  0011_0101  0x35   53  5  
  10792	:  0011_0001  0x31   49  1  
  10793	:  0010_1101  0x2D   45  -  
  10794	:  0011_0001  0x31   49  1  
  10795	:  0011_0111  0x37   55  7  
  10796	:  0011_0000  0x30   48  0  
  10797	:  1100_0000  0xC0  192    
  10798	:  0000_1100  0x0C   12    
  10799	:  0000_0000  0x00    0    
  10800	:  0000_0001  0x01    1    
  10801	:  0000_0000  0x00    0    
  10802	:  0000_0001  0x01    1    
  10803	:  0000_0000  0x00    0    
  10804	:  0000_0000  0x00    0    
  10805	:  0010_1010  0x2A   42  *  
  10806	:  0011_0000  0x30   48  0  
  10807	:  0000_0000  0x00    0    
  10808	:  0000_0100  0x04    4    
  10809	:  0010_1101  0x2D   45  -  
  10810	:  0100_0011  0x43   67  C  
  10811	:  0011_0011  0x33   51  3  
  10812	:  1010_1010  0xAA  170    
  10813	:  0000_1000  0x08    8    
  10814	:  0100_0001  0x41   65  A  
  10815	:  0010_1101  0x2D   45  -  
  10816	:  0011_0101  0x35   53  5  
  10817	:  0011_0001  0x31   49  1  
  10818	:  0010_1101  0x2D   45  -  
  10819	:  0011_0001  0x31   49  1  
  10820	:  0011_0111  0x37   55  7  
  10821	:  0011_0001  0x31   49  1  
  10822	:  1100_0000  0xC0  192    
  10823	:  0000_1100  0x0C   12    
  10824	:  0000_0000  0x00    0    
  10825	:  0000_0001  0x01    1    
  10826	:  0000_0000  0x00    0    
  10827	:  0000_0001  0x01    1    
  10828	:  0000_0000  0x00    0    
  10829	:  0000_0000  0x00    0    
  10830	:  0010_1010  0x2A   42  *  
  10831	:  0011_0000  0x30   48  0  
  10832	:  0000_0000  0x00    0    
  10833	:  0000_0100  0x04    4    
  10834	:  0010_1101  0x2D   45  -  
  10835	:  0100_0011  0x43   67  C  
  10836	:  0011_0011  0x33   51  3  
  10837	:  1010_1011  0xAB  171    
  10838	:  0000_1000  0x08    8    
  10839	:  0100_0001  0x41   65  A  
  10840	:  0010_1101  0x2D   45  -  
  10841	:  0011_0101  0x35   53  5  
  10842	:  0011_0001  0x31   49  1  
  10843	:  0010_1101  0x2D   45  -  
  10844	:  0011_0001  0x31   49  1  
  10845	:  0011_0111  0x37   55  7  
  10846	:  0011_0010  0x32   50  2  
  10847	:  1100_0000  0xC0  192    
  10848	:  0000_1100  0x0C   12    
  10849	:  0000_0000  0x00    0    
  10850	:  0000_0001  0x01    1    
  10851	:  0000_0000  0x00    0    
  10852	:  0000_0001  0x01    1    
  10853	:  0000_0000  0x00    0    
  10854	:  0000_0000  0x00    0    
  10855	:  0010_1010  0x2A   42  *  
  10856	:  0011_0000  0x30   48  0  
  10857	:  0000_0000  0x00    0    
  10858	:  0000_0100  0x04    4    
  10859	:  0010_1101  0x2D   45  -  
  10860	:  0100_0011  0x43   67  C  
  10861	:  0011_0011  0x33   51  3  
  10862	:  1010_1100  0xAC  172    
  10863	:  0000_1000  0x08    8    
  10864	:  0100_0001  0x41   65  A  
  10865	:  0010_1101  0x2D   45  -  
  10866	:  0011_0101  0x35   53  5  
  10867	:  0011_0001  0x31   49  1  
  10868	:  0010_1101  0x2D   45  -  
  10869	:  0011_0001  0x31   49  1  
  10870	:  0011_0111  0x37   55  7  
  10871	:  0011_0011  0x33   51  3  
  10872	:  1100_0000  0xC0  192    
  10873	:  0000_1100  0x0C   12    
  10874	:  0000_0000  0x00    0    
  10875	:  0000_0001  0x01    1    
  10876	:  0000_0000  0x00    0    
  10877	:  0000_0001  0x01    1    
  10878	:  0000_0000  0x00    0    
  10879	:  0000_0000  0x00    0    
  10880	:  0010_1010  0x2A   42  *  
  10881	:  0011_0000  0x30   48  0  
  10882	:  0000_0000  0x00    0    
  10883	:  0000_0100  0x04    4    
  10884	:  0010_1101  0x2D   45  -  
  10885	:  0100_0011  0x43   67  C  
  10886	:  0011_0011  0x33   51  3  
  10887	:  1010_1101  0xAD  173    
  10888	:  0000_1000  0x08    8    
  10889	:  0100_0001  0x41   65  A  
  10890	:  0010_1101  0x2D   45  -  
  10891	:  0011_0101  0x35   53  5  
  10892	:  0011_0001  0x31   49  1  
  10893	:  0010_1101  0x2D   45  -  
  10894	:  0011_0001  0x31   49  1  
  10895	:  0011_0111  0x37   55  7  
  10896	:  0011_0100  0x34   52  4  
  10897	:  1100_0000  0xC0  192    
  10898	:  0000_1100  0x0C   12    
  10899	:  0000_0000  0x00    0    
  10900	:  0000_0001  0x01    1    
  10901	:  0000_0000  0x00    0    
  10902	:  0000_0001  0x01    1    
  10903	:  0000_0000  0x00    0    
  10904	:  0000_0000  0x00    0    
  10905	:  0010_1010  0x2A   42  *  
  10906	:  0011_0000  0x30   48  0  
  10907	:  0000_0000  0x00    0    
  10908	:  0000_0100  0x04    4    
  10909	:  0010_1101  0x2D   45  -  
  10910	:  0100_0011  0x43   67  C  
  10911	:  0011_0011  0x33   51  3  
  10912	:  1010_1110  0xAE  174    
  10913	:  0000_1000  0x08    8    
  10914	:  0100_0001  0x41   65  A  
  10915	:  0010_1101  0x2D   45  -  
  10916	:  0011_0101  0x35   53  5  
  10917	:  0011_0001  0x31   49  1  
  10918	:  0010_1101  0x2D   45  -  
  10919	:  0011_0001  0x31   49  1  
  10920	:  0011_0111  0x37   55  7  
  10921	:  0011_0101  0x35   53  5  
  10922	:  1100_0000  0xC0  192    
  10923	:  0000_1100  0x0C   12    
  10924	:  0000_0000  0x00    0    
  10925	:  0000_0001  0x01    1    
  10926	:  0000_0000  0x00    0    
  10927	:  0000_0001  0x01    1    
  10928	:  0000_0000  0x00    0    
  10929	:  0000_0000  0x00    0    
  10930	:  0010_1010  0x2A   42  *  
  10931	:  0011_0000  0x30   48  0  
  10932	:  0000_0000  0x00    0    
  10933	:  0000_0100  0x04    4    
  10934	:  0010_1101  0x2D   45  -  
  10935	:  0100_0011  0x43   67  C  
  10936	:  0011_0011  0x33   51  3  
  10937	:  1010_1111  0xAF  175    
  10938	:  0000_1000  0x08    8    
  10939	:  0100_0001  0x41   65  A  
  10940	:  0010_1101  0x2D   45  -  
  10941	:  0011_0101  0x35   53  5  
  10942	:  0011_0001  0x31   49  1  
  10943	:  0010_1101  0x2D   45  -  
  10944	:  0011_0001  0x31   49  1  
  10945	:  0011_0111  0x37   55  7  
  10946	:  0011_0110  0x36   54  6  
  10947	:  1100_0000  0xC0  192    
  10948	:  0000_1100  0x0C   12    
  10949	:  0000_0000  0x00    0    
  10950	:  0000_0001  0x01    1    
  10951	:  0000_0000  0x00    0    
  10952	:  0000_0001  0x01    1    
  10953	:  0000_0000  0x00    0    
  10954	:  0000_0000  0x00    0    
  10955	:  0010_1010  0x2A   42  *  
  10956	:  0011_0000  0x30   48  0  
  10957	:  0000_0000  0x00    0    
  10958	:  0000_0100  0x04    4    
  10959	:  0010_1101  0x2D   45  -  
  10960	:  0100_0011  0x43   67  C  
  10961	:  0011_0011  0x33   51  3  
  10962	:  1011_0000  0xB0  176    
  10963	:  0000_1000  0x08    8    
  10964	:  0100_0001  0x41   65  A  
  10965	:  0010_1101  0x2D   45  -  
  10966	:  0011_0101  0x35   53  5  
  10967	:  0011_0001  0x31   49  1  
  10968	:  0010_1101  0x2D   45  -  
  10969	:  0011_0001  0x31   49  1  
  10970	:  0011_0111  0x37   55  7  
  10971	:  0011_0111  0x37   55  7  
  10972	:  1100_0000  0xC0  192    
  10973	:  0000_1100  0x0C   12    
  10974	:  0000_0000  0x00    0    
  10975	:  0000_0001  0x01    1    
  10976	:  0000_0000  0x00    0    
  10977	:  0000_0001  0x01    1    
  10978	:  0000_0000  0x00    0    
  10979	:  0000_0000  0x00    0    
  10980	:  0010_1010  0x2A   42  *  
  10981	:  0011_0000  0x30   48  0  
  10982	:  0000_0000  0x00    0    
  10983	:  0000_0100  0x04    4    
  10984	:  0010_1101  0x2D   45  -  
  10985	:  0100_0011  0x43   67  C  
  10986	:  0011_0011  0x33   51  3  
  10987	:  1011_0001  0xB1  177    
  10988	:  0000_1000  0x08    8    
  10989	:  0100_0001  0x41   65  A  
  10990	:  0010_1101  0x2D   45  -  
  10991	:  0011_0101  0x35   53  5  
  10992	:  0011_0001  0x31   49  1  
  10993	:  0010_1101  0x2D   45  -  
  10994	:  0011_0001  0x31   49  1  
  10995	:  0011_0111  0x37   55  7  
  10996	:  0011_1000  0x38   56  8  
  10997	:  1100_0000  0xC0  192    
  10998	:  0000_1100  0x0C   12    
  10999	:  0000_0000  0x00    0    
  11000	:  0000_0001  0x01    1    
  11001	:  0000_0000  0x00    0    
  11002	:  0000_0001  0x01    1    
  11003	:  0000_0000  0x00    0    
  11004	:  0000_0000  0x00    0    
  11005	:  0010_1010  0x2A   42  *  
  11006	:  0011_0000  0x30   48  0  
  11007	:  0000_0000  0x00    0    
  11008	:  0000_0100  0x04    4    
  11009	:  0010_1101  0x2D   45  -  
  11010	:  0100_0011  0x43   67  C  
  11011	:  0011_0011  0x33   51  3  
  11012	:  1011_0010  0xB2  178    
  11013	:  0000_1000  0x08    8    
  11014	:  0100_0001  0x41   65  A  
  11015	:  0010_1101  0x2D   45  -  
  11016	:  0011_0101  0x35   53  5  
  11017	:  0011_0001  0x31   49  1  
  11018	:  0010_1101  0x2D   45  -  
  11019	:  0011_0001  0x31   49  1  
  11020	:  0011_0111  0x37   55  7  
  11021	:  0011_1001  0x39   57  9  
  11022	:  1100_0000  0xC0  192    
  11023	:  0000_1100  0x0C   12    
  11024	:  0000_0000  0x00    0    
  11025	:  0000_0001  0x01    1    
  11026	:  0000_0000  0x00    0    
  11027	:  0000_0001  0x01    1    
  11028	:  0000_0000  0x00    0    
  11029	:  0000_0000  0x00    0    
  11030	:  0010_1010  0x2A   42  *  
  11031	:  0011_0000  0x30   48  0  
  11032	:  0000_0000  0x00    0    
  11033	:  0000_0100  0x04    4    
  11034	:  0010_1101  0x2D   45  -  
  11035	:  0100_0011  0x43   67  C  
  11036	:  0011_0011  0x33   51  3  
  11037	:  1011_0011  0xB3  179    
  11038	:  0000_1000  0x08    8    
  11039	:  0100_0001  0x41   65  A  
  11040	:  0010_1101  0x2D   45  -  
  11041	:  0011_0101  0x35   53  5  
  11042	:  0011_0001  0x31   49  1  
  11043	:  0010_1101  0x2D   45  -  
  11044	:  0011_0001  0x31   49  1  
  11045	:  0011_1000  0x38   56  8  
  11046	:  0011_0000  0x30   48  0  
  11047	:  1100_0000  0xC0  192    
  11048	:  0000_1100  0x0C   12    
  11049	:  0000_0000  0x00    0    
  11050	:  0000_0001  0x01    1    
  11051	:  0000_0000  0x00    0    
  11052	:  0000_0001  0x01    1    
  11053	:  0000_0000  0x00    0    
  11054	:  0000_0000  0x00    0    
  11055	:  0010_1010  0x2A   42  *  
  11056	:  0011_0000  0x30   48  0  
  11057	:  0000_0000  0x00    0    
  11058	:  0000_0100  0x04    4    
  11059	:  0010_1101  0x2D   45  -  
  11060	:  0100_0011  0x43   67  C  
  11061	:  0011_0011  0x33   51  3  
  11062	:  1011_0100  0xB4  180    
  11063	:  0000_1000  0x08    8    
  11064	:  0100_0001  0x41   65  A  
  11065	:  0010_1101  0x2D   45  -  
  11066	:  0011_0101  0x35   53  5  
  11067	:  0011_0001  0x31   49  1  
  11068	:  0010_1101  0x2D   45  -  
  11069	:  0011_0001  0x31   49  1  
  11070	:  0011_1000  0x38   56  8  
  11071	:  0011_0001  0x31   49  1  
  11072	:  1100_0000  0xC0  192    
  11073	:  0000_1100  0x0C   12    
  11074	:  0000_0000  0x00    0    
  11075	:  0000_0001  0x01    1    
  11076	:  0000_0000  0x00    0    
  11077	:  0000_0001  0x01    1    
  11078	:  0000_0000  0x00    0    
  11079	:  0000_0000  0x00    0    
  11080	:  0010_1010  0x2A   42  *  
  11081	:  0011_0000  0x30   48  0  
  11082	:  0000_0000  0x00    0    
  11083	:  0000_0100  0x04    4    
  11084	:  0010_1101  0x2D   45  -  
  11085	:  0100_0011  0x43   67  C  
  11086	:  0011_0011  0x33   51  3  
  11087	:  1011_0101  0xB5  181    
  11088	:  0000_1000  0x08    8    
  11089	:  0100_0001  0x41   65  A  
  11090	:  0010_1101  0x2D   45  -  
  11091	:  0011_0101  0x35   53  5  
  11092	:  0011_0001  0x31   49  1  
  11093	:  0010_1101  0x2D   45  -  
  11094	:  0011_0001  0x31   49  1  
  11095	:  0011_1000  0x38   56  8  
  11096	:  0011_0010  0x32   50  2  
  11097	:  1100_0000  0xC0  192    
  11098	:  0000_1100  0x0C   12    
  11099	:  0000_0000  0x00    0    
  11100	:  0000_0001  0x01    1    
  11101	:  0000_0000  0x00    0    
  11102	:  0000_0001  0x01    1    
  11103	:  0000_0000  0x00    0    
  11104	:  0000_0000  0x00    0    
  11105	:  0010_1010  0x2A   42  *  
  11106	:  0011_0000  0x30   48  0  
  11107	:  0000_0000  0x00    0    
  11108	:  0000_0100  0x04    4    
  11109	:  0010_1101  0x2D   45  -  
  11110	:  0100_0011  0x43   67  C  
  11111	:  0011_0011  0x33   51  3  
  11112	:  1011_0110  0xB6  182    
  11113	:  0000_1000  0x08    8    
  11114	:  0100_0001  0x41   65  A  
  11115	:  0010_1101  0x2D   45  -  
  11116	:  0011_0101  0x35   53  5  
  11117	:  0011_0001  0x31   49  1  
  11118	:  0010_1101  0x2D   45  -  
  11119	:  0011_0001  0x31   49  1  
  11120	:  0011_1000  0x38   56  8  
  11121	:  0011_0011  0x33   51  3  
  11122	:  1100_0000  0xC0  192    
  11123	:  0000_1100  0x0C   12    
  11124	:  0000_0000  0x00    0    
  11125	:  0000_0001  0x01    1    
  11126	:  0000_0000  0x00    0    
  11127	:  0000_0001  0x01    1    
  11128	:  0000_0000  0x00    0    
  11129	:  0000_0000  0x00    0    
  11130	:  0010_1010  0x2A   42  *  
  11131	:  0011_0000  0x30   48  0  
  11132	:  0000_0000  0x00    0    
  11133	:  0000_0100  0x04    4    
  11134	:  0010_1101  0x2D   45  -  
  11135	:  0100_0011  0x43   67  C  
  11136	:  0011_0011  0x33   51  3  
  11137	:  1011_0111  0xB7  183    
  11138	:  0000_1000  0x08    8    
  11139	:  0100_0001  0x41   65  A  
  11140	:  0010_1101  0x2D   45  -  
  11141	:  0011_0101  0x35   53  5  
  11142	:  0011_0001  0x31   49  1  
  11143	:  0010_1101  0x2D   45  -  
  11144	:  0011_0001  0x31   49  1  
  11145	:  0011_1000  0x38   56  8  
  11146	:  0011_0100  0x34   52  4  
  11147	:  1100_0000  0xC0  192    
  11148	:  0000_1100  0x0C   12    
  11149	:  0000_0000  0x00    0    
  11150	:  0000_0001  0x01    1    
  11151	:  0000_0000  0x00    0    
  11152	:  0000_0001  0x01    1    
  11153	:  0000_0000  0x00    0    
  11154	:  0000_0000  0x00    0    
  11155	:  0010_1010  0x2A   42  *  
  11156	:  0011_0000  0x30   48  0  
  11157	:  0000_0000  0x00    0    
  11158	:  0000_0100  0x04    4    
  11159	:  0010_1101  0x2D   45  -  
  11160	:  0100_0011  0x43   67  C  
  11161	:  0011_0011  0x33   51  3  
  11162	:  1011_1000  0xB8  184    
  11163	:  0000_1000  0x08    8    
  11164	:  0100_0001  0x41   65  A  
  11165	:  0010_1101  0x2D   45  -  
  11166	:  0011_0101  0x35   53  5  
  11167	:  0011_0001  0x31   49  1  
  11168	:  0010_1101  0x2D   45  -  
  11169	:  0011_0001  0x31   49  1  
  11170	:  0011_1000  0x38   56  8  
  11171	:  0011_0101  0x35   53  5  
  11172	:  1100_0000  0xC0  192    
  11173	:  0000_1100  0x0C   12    
  11174	:  0000_0000  0x00    0    
  11175	:  0000_0001  0x01    1    
  11176	:  0000_0000  0x00    0    
  11177	:  0000_0001  0x01    1    
  11178	:  0000_0000  0x00    0    
  11179	:  0000_0000  0x00    0    
  11180	:  0010_1010  0x2A   42  *  
  11181	:  0011_0000  0x30   48  0  
  11182	:  0000_0000  0x00    0    
  11183	:  0000_0100  0x04    4    
  11184	:  0010_1101  0x2D   45  -  
  11185	:  0100_0011  0x43   67  C  
  11186	:  0011_0011  0x33   51  3  
  11187	:  1011_1001  0xB9  185    
  11188	:  0000_1000  0x08    8    
  11189	:  0100_0001  0x41   65  A  
  11190	:  0010_1101  0x2D   45  -  
  11191	:  0011_0101  0x35   53  5  
  11192	:  0011_0001  0x31   49  1  
  11193	:  0010_1101  0x2D   45  -  
  11194	:  0011_0001  0x31   49  1  
  11195	:  0011_1000  0x38   56  8  
  11196	:  0011_0110  0x36   54  6  
  11197	:  1100_0000  0xC0  192    
  11198	:  0000_1100  0x0C   12    
  11199	:  0000_0000  0x00    0    
  11200	:  0000_0001  0x01    1    
  11201	:  0000_0000  0x00    0    
  11202	:  0000_0001  0x01    1    
  11203	:  0000_0000  0x00    0    
  11204	:  0000_0000  0x00    0    
  11205	:  0010_1010  0x2A   42  *  
  11206	:  0011_0000  0x30   48  0  
  11207	:  0000_0000  0x00    0    
  11208	:  0000_0100  0x04    4    
  11209	:  0010_1101  0x2D   45  -  
  11210	:  0100_0011  0x43   67  C  
  11211	:  0011_0011  0x33   51  3  
  11212	:  1011_1010  0xBA  186    
  11213	:  0000_1000  0x08    8    
  11214	:  0100_0001  0x41   65  A  
  11215	:  0010_1101  0x2D   45  -  
  11216	:  0011_0101  0x35   53  5  
  11217	:  0011_0001  0x31   49  1  
  11218	:  0010_1101  0x2D   45  -  
  11219	:  0011_0001  0x31   49  1  
  11220	:  0011_1000  0x38   56  8  
  11221	:  0011_0111  0x37   55  7  
  11222	:  1100_0000  0xC0  192    
  11223	:  0000_1100  0x0C   12    
  11224	:  0000_0000  0x00    0    
  11225	:  0000_0001  0x01    1    
  11226	:  0000_0000  0x00    0    
  11227	:  0000_0001  0x01    1    
  11228	:  0000_0000  0x00    0    
  11229	:  0000_0000  0x00    0    
  11230	:  0010_1010  0x2A   42  *  
  11231	:  0011_0000  0x30   48  0  
  11232	:  0000_0000  0x00    0    
  11233	:  0000_0100  0x04    4    
  11234	:  0010_1101  0x2D   45  -  
  11235	:  0100_0011  0x43   67  C  
  11236	:  0011_0011  0x33   51  3  
  11237	:  1011_1011  0xBB  187    
  11238	:  0000_1000  0x08    8    
  11239	:  0100_0001  0x41   65  A  
  11240	:  0010_1101  0x2D   45  -  
  11241	:  0011_0101  0x35   53  5  
  11242	:  0011_0001  0x31   49  1  
  11243	:  0010_1101  0x2D   45  -  
  11244	:  0011_0001  0x31   49  1  
  11245	:  0011_1000  0x38   56  8  
  11246	:  0011_1000  0x38   56  8  
  11247	:  1100_0000  0xC0  192    
  11248	:  0000_1100  0x0C   12    
  11249	:  0000_0000  0x00    0    
  11250	:  0000_0001  0x01    1    
  11251	:  0000_0000  0x00    0    
  11252	:  0000_0001  0x01    1    
  11253	:  0000_0000  0x00    0    
  11254	:  0000_0000  0x00    0    
  11255	:  0010_1010  0x2A   42  *  
  11256	:  0011_0000  0x30   48  0  
  11257	:  0000_0000  0x00    0    
  11258	:  0000_0100  0x04    4    
  11259	:  0010_1101  0x2D   45  -  
  11260	:  0100_0011  0x43   67  C  
  11261	:  0011_0011  0x33   51  3  
  11262	:  1011_1100  0xBC  188    
  11263	:  0000_1000  0x08    8    
  11264	:  0100_0001  0x41   65  A  
  11265	:  0010_1101  0x2D   45  -  
  11266	:  0011_0101  0x35   53  5  
  11267	:  0011_0001  0x31   49  1  
  11268	:  0010_1101  0x2D   45  -  
  11269	:  0011_0001  0x31   49  1  
  11270	:  0011_1000  0x38   56  8  
  11271	:  0011_1001  0x39   57  9  
  11272	:  1100_0000  0xC0  192    
  11273	:  0000_1100  0x0C   12    
  11274	:  0000_0000  0x00    0    
  11275	:  0000_0001  0x01    1    
  11276	:  0000_0000  0x00    0    
  11277	:  0000_0001  0x01    1    
  11278	:  0000_0000  0x00    0    
  11279	:  0000_0000  0x00    0    
  11280	:  0010_1010  0x2A   42  *  
  11281	:  0011_0000  0x30   48  0  
  11282	:  0000_0000  0x00    0    
  11283	:  0000_0100  0x04    4    
  11284	:  0010_1101  0x2D   45  -  
  11285	:  0100_0011  0x43   67  C  
  11286	:  0011_0011  0x33   51  3  
  11287	:  1011_1101  0xBD  189    
  11288	:  0000_1000  0x08    8    
  11289	:  0100_0001  0x41   65  A  
  11290	:  0010_1101  0x2D   45  -  
  11291	:  0011_0101  0x35   53  5  
  11292	:  0011_0001  0x31   49  1  
  11293	:  0010_1101  0x2D   45  -  
  11294	:  0011_0001  0x31   49  1  
  11295	:  0011_1001  0x39   57  9  
  11296	:  0011_0000  0x30   48  0  
  11297	:  1100_0000  0xC0  192    
  11298	:  0000_1100  0x0C   12    
  11299	:  0000_0000  0x00    0    
  11300	:  0000_0001  0x01    1    
  11301	:  0000_0000  0x00    0    
  11302	:  0000_0001  0x01    1    
  11303	:  0000_0000  0x00    0    
  11304	:  0000_0000  0x00    0    
  11305	:  0010_1010  0x2A   42  *  
  11306	:  0011_0000  0x30   48  0  
  11307	:  0000_0000  0x00    0    
  11308	:  0000_0100  0x04    4    
  11309	:  0010_1101  0x2D   45  -  
  11310	:  0100_0011  0x43   67  C  
  11311	:  0011_0011  0x33   51  3  
  11312	:  1011_1110  0xBE  190    
  11313	:  0000_1000  0x08    8    
  11314	:  0100_0001  0x41   65  A  
  11315	:  0010_1101  0x2D   45  -  
  11316	:  0011_0101  0x35   53  5  
  11317	:  0011_0001  0x31   49  1  
  11318	:  0010_1101  0x2D   45  -  
  11319	:  0011_0001  0x31   49  1  
  11320	:  0011_1001  0x39   57  9  
  11321	:  0011_0001  0x31   49  1  
  11322	:  1100_0000  0xC0  192    
  11323	:  0000_1100  0x0C   12    
  11324	:  0000_0000  0x00    0    
  11325	:  0000_0001  0x01    1    
  11326	:  0000_0000  0x00    0    
  11327	:  0000_0001  0x01    1    
  11328	:  0000_0000  0x00    0    
  11329	:  0000_0000  0x00    0    
  11330	:  0010_1010  0x2A   42  *  
  11331	:  0011_0000  0x30   48  0  
  11332	:  0000_0000  0x00    0    
  11333	:  0000_0100  0x04    4    
  11334	:  0010_1101  0x2D   45  -  
  11335	:  0100_0011  0x43   67  C  
  11336	:  0011_0011  0x33   51  3  
  11337	:  1011_1111  0xBF  191    
  11338	:  0000_1000  0x08    8    
  11339	:  0100_0001  0x41   65  A  
  11340	:  0010_1101  0x2D   45  -  
  11341	:  0011_0101  0x35   53  5  
  11342	:  0011_0001  0x31   49  1  
  11343	:  0010_1101  0x2D   45  -  
  11344	:  0011_0001  0x31   49  1  
  11345	:  0011_1001  0x39   57  9  
  11346	:  0011_0010  0x32   50  2  
  11347	:  1100_0000  0xC0  192    
  11348	:  0000_1100  0x0C   12    
  11349	:  0000_0000  0x00    0    
  11350	:  0000_0001  0x01    1    
  11351	:  0000_0000  0x00    0    
  11352	:  0000_0001  0x01    1    
  11353	:  0000_0000  0x00    0    
  11354	:  0000_0000  0x00    0    
  11355	:  0010_1010  0x2A   42  *  
  11356	:  0011_0000  0x30   48  0  
  11357	:  0000_0000  0x00    0    
  11358	:  0000_0100  0x04    4    
  11359	:  0010_1101  0x2D   45  -  
  11360	:  0100_0011  0x43   67  C  
  11361	:  0011_0011  0x33   51  3  
  11362	:  1100_0000  0xC0  192    
  11363	:  0000_1000  0x08    8    
  11364	:  0100_0001  0x41   65  A  
  11365	:  0010_1101  0x2D   45  -  
  11366	:  0011_0101  0x35   53  5  
  11367	:  0011_0001  0x31   49  1  
  11368	:  0010_1101  0x2D   45  -  
  11369	:  0011_0001  0x31   49  1  
  11370	:  0011_1001  0x39   57  9  
  11371	:  0011_0011  0x33   51  3  
  11372	:  1100_0000  0xC0  192    
  11373	:  0000_1100  0x0C   12    
  11374	:  0000_0000  0x00    0    
  11375	:  0000_0001  0x01    1    
  11376	:  0000_0000  0x00    0    
  11377	:  0000_0001  0x01    1    
  11378	:  0000_0000  0x00    0    
  11379	:  0000_0000  0x00    0    
  11380	:  0010_1010  0x2A   42  *  
  11381	:  0011_0000  0x30   48  0  
  11382	:  0000_0000  0x00    0    
  11383	:  0000_0100  0x04    4    
  11384	:  0010_1101  0x2D   45  -  
  11385	:  0100_0011  0x43   67  C  
  11386	:  0011_0011  0x33   51  3  
  11387	:  1100_0001  0xC1  193    
  11388	:  0000_1000  0x08    8    
  11389	:  0100_0001  0x41   65  A  
  11390	:  0010_1101  0x2D   45  -  
  11391	:  0011_0101  0x35   53  5  
  11392	:  0011_0001  0x31   49  1  
  11393	:  0010_1101  0x2D   45  -  
  11394	:  0011_0001  0x31   49  1  
  11395	:  0011_1001  0x39   57  9  
  11396	:  0011_0100  0x34   52  4  
  11397	:  1100_0000  0xC0  192    
  11398	:  0000_1100  0x0C   12    
  11399	:  0000_0000  0x00    0    
  11400	:  0000_0001  0x01    1    
  11401	:  0000_0000  0x00    0    
  11402	:  0000_0001  0x01    1    
  11403	:  0000_0000  0x00    0    
  11404	:  0000_0000  0x00    0    
  11405	:  0010_1010  0x2A   42  *  
  11406	:  0011_0000  0x30   48  0  
  11407	:  0000_0000  0x00    0    
  11408	:  0000_0100  0x04    4    
  11409	:  0010_1101  0x2D   45  -  
  11410	:  0100_0011  0x43   67  C  
  11411	:  0011_0011  0x33   51  3  
  11412	:  1100_0010  0xC2  194    
  11413	:  0000_1000  0x08    8    
  11414	:  0100_0001  0x41   65  A  
  11415	:  0010_1101  0x2D   45  -  
  11416	:  0011_0101  0x35   53  5  
  11417	:  0011_0001  0x31   49  1  
  11418	:  0010_1101  0x2D   45  -  
  11419	:  0011_0001  0x31   49  1  
  11420	:  0011_1001  0x39   57  9  
  11421	:  0011_0101  0x35   53  5  
  11422	:  1100_0000  0xC0  192    
  11423	:  0000_1100  0x0C   12    
  11424	:  0000_0000  0x00    0    
  11425	:  0000_0001  0x01    1    
  11426	:  0000_0000  0x00    0    
  11427	:  0000_0001  0x01    1    
  11428	:  0000_0000  0x00    0    
  11429	:  0000_0000  0x00    0    
  11430	:  0010_1010  0x2A   42  *  
  11431	:  0011_0000  0x30   48  0  
  11432	:  0000_0000  0x00    0    
  11433	:  0000_0100  0x04    4    
  11434	:  0010_1101  0x2D   45  -  
  11435	:  0100_0011  0x43   67  C  
  11436	:  0011_0011  0x33   51  3  
  11437	:  1100_0011  0xC3  195    
  11438	:  0000_1000  0x08    8    
  11439	:  0100_0001  0x41   65  A  
  11440	:  0010_1101  0x2D   45  -  
  11441	:  0011_0101  0x35   53  5  
  11442	:  0011_0001  0x31   49  1  
  11443	:  0010_1101  0x2D   45  -  
  11444	:  0011_0001  0x31   49  1  
  11445	:  0011_1001  0x39   57  9  
  11446	:  0011_0110  0x36   54  6  
  11447	:  1100_0000  0xC0  192    
  11448	:  0000_1100  0x0C   12    
  11449	:  0000_0000  0x00    0    
  11450	:  0000_0001  0x01    1    
  11451	:  0000_0000  0x00    0    
  11452	:  0000_0001  0x01    1    
  11453	:  0000_0000  0x00    0    
  11454	:  0000_0000  0x00    0    
  11455	:  0010_1010  0x2A   42  *  
  11456	:  0011_0000  0x30   48  0  
  11457	:  0000_0000  0x00    0    
  11458	:  0000_0100  0x04    4    
  11459	:  0010_1101  0x2D   45  -  
  11460	:  0100_0011  0x43   67  C  
  11461	:  0011_0011  0x33   51  3  
  11462	:  1100_0100  0xC4  196    
  11463	:  0000_1000  0x08    8    
  11464	:  0100_0001  0x41   65  A  
  11465	:  0010_1101  0x2D   45  -  
  11466	:  0011_0101  0x35   53  5  
  11467	:  0011_0001  0x31   49  1  
  11468	:  0010_1101  0x2D   45  -  
  11469	:  0011_0001  0x31   49  1  
  11470	:  0011_1001  0x39   57  9  
  11471	:  0011_0111  0x37   55  7  
  11472	:  1100_0000  0xC0  192    
  11473	:  0000_1100  0x0C   12    
  11474	:  0000_0000  0x00    0    
  11475	:  0000_0001  0x01    1    
  11476	:  0000_0000  0x00    0    
  11477	:  0000_0001  0x01    1    
  11478	:  0000_0000  0x00    0    
  11479	:  0000_0000  0x00    0    
  11480	:  0010_1010  0x2A   42  *  
  11481	:  0011_0000  0x30   48  0  
  11482	:  0000_0000  0x00    0    
  11483	:  0000_0100  0x04    4    
  11484	:  0010_1101  0x2D   45  -  
  11485	:  0100_0011  0x43   67  C  
  11486	:  0011_0011  0x33   51  3  
  11487	:  1100_0101  0xC5  197    
  11488	:  0000_1000  0x08    8    
  11489	:  0100_0001  0x41   65  A  
  11490	:  0010_1101  0x2D   45  -  
  11491	:  0011_0101  0x35   53  5  
  11492	:  0011_0001  0x31   49  1  
  11493	:  0010_1101  0x2D   45  -  
  11494	:  0011_0001  0x31   49  1  
  11495	:  0011_1001  0x39   57  9  
  11496	:  0011_1000  0x38   56  8  
  11497	:  1100_0000  0xC0  192    
  11498	:  0000_1100  0x0C   12    
  11499	:  0000_0000  0x00    0    
  11500	:  0000_0001  0x01    1    
  11501	:  0000_0000  0x00    0    
  11502	:  0000_0001  0x01    1    
  11503	:  0000_0000  0x00    0    
  11504	:  0000_0000  0x00    0    
  11505	:  0010_1010  0x2A   42  *  
  11506	:  0011_0000  0x30   48  0  
  11507	:  0000_0000  0x00    0    
  11508	:  0000_0100  0x04    4    
  11509	:  0010_1101  0x2D   45  -  
  11510	:  0100_0011  0x43   67  C  
  11511	:  0011_0011  0x33   51  3  
  11512	:  1100_0110  0xC6  198    
  11513	:  0000_1000  0x08    8    
  11514	:  0100_0001  0x41   65  A  
  11515	:  0010_1101  0x2D   45  -  
  11516	:  0011_0101  0x35   53  5  
  11517	:  0011_0001  0x31   49  1  
  11518	:  0010_1101  0x2D   45  -  
  11519	:  0011_0001  0x31   49  1  
  11520	:  0011_1001  0x39   57  9  
  11521	:  0011_1001  0x39   57  9  
  11522	:  1100_0000  0xC0  192    
  11523	:  0000_1100  0x0C   12    
  11524	:  0000_0000  0x00    0    
  11525	:  0000_0001  0x01    1    
  11526	:  0000_0000  0x00    0    
  11527	:  0000_0001  0x01    1    
  11528	:  0000_0000  0x00    0    
  11529	:  0000_0000  0x00    0    
  11530	:  0010_1010  0x2A   42  *  
  11531	:  0011_0000  0x30   48  0  
  11532	:  0000_0000  0x00    0    
  11533	:  0000_0100  0x04    4    
  11534	:  0010_1101  0x2D   45  -  
  11535	:  0100_0011  0x43   67  C  
  11536	:  0011_0011  0x33   51  3  
  11537	:  1100_0111  0xC7  199    
  11538	:  0000_1000  0x08    8    
  11539	:  0100_0001  0x41   65  A  
  11540	:  0010_1101  0x2D   45  -  
  11541	:  0011_0101  0x35   53  5  
  11542	:  0011_0001  0x31   49  1  
  11543	:  0010_1101  0x2D   45  -  
  11544	:  0011_0010  0x32   50  2  
  11545	:  0011_0000  0x30   48  0  
  11546	:  0011_0000  0x30   48  0  
  11547	:  1100_0000  0xC0  192    
  11548	:  0000_1100  0x0C   12    
  11549	:  0000_0000  0x00    0    
  11550	:  0000_0001  0x01    1    
  11551	:  0000_0000  0x00    0    
  11552	:  0000_0001  0x01    1    
  11553	:  0000_0000  0x00    0    
  11554	:  0000_0000  0x00    0    
  11555	:  0010_1010  0x2A   42  *  
  11556	:  0011_0000  0x30   48  0  
  11557	:  0000_0000  0x00    0    
  11558	:  0000_0100  0x04    4    
  11559	:  0010_1101  0x2D   45  -  
  11560	:  0100_0011  0x43   67  C  
  11561	:  0011_0011  0x33   51  3  
  11562	:  1100_1000  0xC8  200    
  11563	:  0000_1000  0x08    8    
  11564	:  0100_0001  0x41   65  A  
  11565	:  0010_1101  0x2D   45  -  
  11566	:  0011_0101  0x35   53  5  
  11567	:  0011_0001  0x31   49  1  
  11568	:  0010_1101  0x2D   45  -  
  11569	:  0011_0010  0x32   50  2  
  11570	:  0011_0000  0x30   48  0  
  11571	:  0011_0001  0x31   49  1  
  11572	:  1100_0000  0xC0  192    
  11573	:  0000_1100  0x0C   12    
  11574	:  0000_0000  0x00    0    
  11575	:  0000_0001  0x01    1    
  11576	:  0000_0000  0x00    0    
  11577	:  0000_0001  0x01    1    
  11578	:  0000_0000  0x00    0    
  11579	:  0000_0000  0x00    0    
  11580	:  0010_1010  0x2A   42  *  
  11581	:  0011_0000  0x30   48  0  
  11582	:  0000_0000  0x00    0    
  11583	:  0000_0100  0x04    4    
  11584	:  0010_1101  0x2D   45  -  
  11585	:  0100_0011  0x43   67  C  
  11586	:  0011_0011  0x33   51  3  
  11587	:  1100_1001  0xC9  201    
  11588	:  0000_1000  0x08    8    
  11589	:  0100_0001  0x41   65  A  
  11590	:  0010_1101  0x2D   45  -  
  11591	:  0011_0101  0x35   53  5  
  11592	:  0011_0001  0x31   49  1  
  11593	:  0010_1101  0x2D   45  -  
  11594	:  0011_0010  0x32   50  2  
  11595	:  0011_0000  0x30   48  0  
  11596	:  0011_0010  0x32   50  2  
  11597	:  1100_0000  0xC0  192    
  11598	:  0000_1100  0x0C   12    
  11599	:  0000_0000  0x00    0    
  11600	:  0000_0001  0x01    1    
  11601	:  0000_0000  0x00    0    
  11602	:  0000_0001  0x01    1    
  11603	:  0000_0000  0x00    0    
  11604	:  0000_0000  0x00    0    
  11605	:  0010_1010  0x2A   42  *  
  11606	:  0011_0000  0x30   48  0  
  11607	:  0000_0000  0x00    0    
  11608	:  0000_0100  0x04    4    
  11609	:  0010_1101  0x2D   45  -  
  11610	:  0100_0011  0x43   67  C  
  11611	:  0011_0011  0x33   51  3  
  11612	:  1100_1010  0xCA  202    
  11613	:  0000_1000  0x08    8    
  11614	:  0100_0001  0x41   65  A  
  11615	:  0010_1101  0x2D   45  -  
  11616	:  0011_0101  0x35   53  5  
  11617	:  0011_0001  0x31   49  1  
  11618	:  0010_1101  0x2D   45  -  
  11619	:  0011_0010  0x32   50  2  
  11620	:  0011_0000  0x30   48  0  
  11621	:  0011_0011  0x33   51  3  
  11622	:  1100_0000  0xC0  192    
  11623	:  0000_1100  0x0C   12    
  11624	:  0000_0000  0x00    0    
  11625	:  0000_0001  0x01    1    
  11626	:  0000_0000  0x00    0    
  11627	:  0000_0001  0x01    1    
  11628	:  0000_0000  0x00    0    
  11629	:  0000_0000  0x00    0    
  11630	:  0010_1010  0x2A   42  *  
  11631	:  0011_0000  0x30   48  0  
  11632	:  0000_0000  0x00    0    
  11633	:  0000_0100  0x04    4    
  11634	:  0010_1101  0x2D   45  -  
  11635	:  0100_0011  0x43   67  C  
  11636	:  0011_0011  0x33   51  3  
  11637	:  1100_1011  0xCB  203    
  11638	:  0000_1000  0x08    8    
  11639	:  0100_0001  0x41   65  A  
  11640	:  0010_1101  0x2D   45  -  
  11641	:  0011_0101  0x35   53  5  
  11642	:  0011_0001  0x31   49  1  
  11643	:  0010_1101  0x2D   45  -  
  11644	:  0011_0010  0x32   50  2  
  11645	:  0011_0000  0x30   48  0  
  11646	:  0011_0100  0x34   52  4  
  11647	:  1100_0000  0xC0  192    
  11648	:  0000_1100  0x0C   12    
  11649	:  0000_0000  0x00    0    
  11650	:  0000_0001  0x01    1    
  11651	:  0000_0000  0x00    0    
  11652	:  0000_0001  0x01    1    
  11653	:  0000_0000  0x00    0    
  11654	:  0000_0000  0x00    0    
  11655	:  0010_1010  0x2A   42  *  
  11656	:  0011_0000  0x30   48  0  
  11657	:  0000_0000  0x00    0    
  11658	:  0000_0100  0x04    4    
  11659	:  0010_1101  0x2D   45  -  
  11660	:  0100_0011  0x43   67  C  
  11661	:  0011_0011  0x33   51  3  
  11662	:  1100_1100  0xCC  204    
  11663	:  0000_1000  0x08    8    
  11664	:  0100_0001  0x41   65  A  
  11665	:  0010_1101  0x2D   45  -  
  11666	:  0011_0101  0x35   53  5  
  11667	:  0011_0001  0x31   49  1  
  11668	:  0010_1101  0x2D   45  -  
  11669	:  0011_0010  0x32   50  2  
  11670	:  0011_0000  0x30   48  0  
  11671	:  0011_0101  0x35   53  5  
  11672	:  1100_0000  0xC0  192    
  11673	:  0000_1100  0x0C   12    
  11674	:  0000_0000  0x00    0    
  11675	:  0000_0001  0x01    1    
  11676	:  0000_0000  0x00    0    
  11677	:  0000_0001  0x01    1    
  11678	:  0000_0000  0x00    0    
  11679	:  0000_0000  0x00    0    
  11680	:  0010_1010  0x2A   42  *  
  11681	:  0011_0000  0x30   48  0  
  11682	:  0000_0000  0x00    0    
  11683	:  0000_0100  0x04    4    
  11684	:  0010_1101  0x2D   45  -  
  11685	:  0100_0011  0x43   67  C  
  11686	:  0011_0011  0x33   51  3  
  11687	:  1100_1101  0xCD  205    
  11688	:  0000_1000  0x08    8    
  11689	:  0100_0001  0x41   65  A  
  11690	:  0010_1101  0x2D   45  -  
  11691	:  0011_0101  0x35   53  5  
  11692	:  0011_0001  0x31   49  1  
  11693	:  0010_1101  0x2D   45  -  
  11694	:  0011_0010  0x32   50  2  
  11695	:  0011_0000  0x30   48  0  
  11696	:  0011_0110  0x36   54  6  
  11697	:  1100_0000  0xC0  192    
  11698	:  0000_1100  0x0C   12    
  11699	:  0000_0000  0x00    0    
  11700	:  0000_0001  0x01    1    
  11701	:  0000_0000  0x00    0    
  11702	:  0000_0001  0x01    1    
  11703	:  0000_0000  0x00    0    
  11704	:  0000_0000  0x00    0    
  11705	:  0010_1010  0x2A   42  *  
  11706	:  0011_0000  0x30   48  0  
  11707	:  0000_0000  0x00    0    
  11708	:  0000_0100  0x04    4    
  11709	:  0010_1101  0x2D   45  -  
  11710	:  0100_0011  0x43   67  C  
  11711	:  0011_0011  0x33   51  3  
  11712	:  1100_1110  0xCE  206    
  11713	:  0000_1000  0x08    8    
  11714	:  0100_0001  0x41   65  A  
  11715	:  0010_1101  0x2D   45  -  
  11716	:  0011_0101  0x35   53  5  
  11717	:  0011_0001  0x31   49  1  
  11718	:  0010_1101  0x2D   45  -  
  11719	:  0011_0010  0x32   50  2  
  11720	:  0011_0000  0x30   48  0  
  11721	:  0011_0111  0x37   55  7  
  11722	:  1100_0000  0xC0  192    
  11723	:  0000_1100  0x0C   12    
  11724	:  0000_0000  0x00    0    
  11725	:  0000_0001  0x01    1    
  11726	:  0000_0000  0x00    0    
  11727	:  0000_0001  0x01    1    
  11728	:  0000_0000  0x00    0    
  11729	:  0000_0000  0x00    0    
  11730	:  0010_1010  0x2A   42  *  
  11731	:  0011_0000  0x30   48  0  
  11732	:  0000_0000  0x00    0    
  11733	:  0000_0100  0x04    4    
  11734	:  0010_1101  0x2D   45  -  
  11735	:  0100_0011  0x43   67  C  
  11736	:  0011_0011  0x33   51  3  
  11737	:  1100_1111  0xCF  207    
  11738	:  0000_1000  0x08    8    
  11739	:  0100_0001  0x41   65  A  
  11740	:  0010_1101  0x2D   45  -  
  11741	:  0011_0101  0x35   53  5  
  11742	:  0011_0001  0x31   49  1  
  11743	:  0010_1101  0x2D   45  -  
  11744	:  0011_0010  0x32   50  2  
  11745	:  0011_0000  0x30   48  0  
  11746	:  0011_1000  0x38   56  8  
  11747	:  1100_0000  0xC0  192    
  11748	:  0000_1100  0x0C   12    
  11749	:  0000_0000  0x00    0    
  11750	:  0000_0001  0x01    1    
  11751	:  0000_0000  0x00    0    
  11752	:  0000_0001  0x01    1    
  11753	:  0000_0000  0x00    0    
  11754	:  0000_0000  0x00    0    
  11755	:  0010_1010  0x2A   42  *  
  11756	:  0011_0000  0x30   48  0  
  11757	:  0000_0000  0x00    0    
  11758	:  0000_0100  0x04    4    
  11759	:  0010_1101  0x2D   45  -  
  11760	:  0100_0011  0x43   67  C  
  11761	:  0011_0011  0x33   51  3  
  11762	:  1101_0000  0xD0  208    
  11763	:  0000_1000  0x08    8    
  11764	:  0100_0001  0x41   65  A  
  11765	:  0010_1101  0x2D   45  -  
  11766	:  0011_0101  0x35   53  5  
  11767	:  0011_0001  0x31   49  1  
  11768	:  0010_1101  0x2D   45  -  
  11769	:  0011_0010  0x32   50  2  
  11770	:  0011_0000  0x30   48  0  
  11771	:  0011_1001  0x39   57  9  
  11772	:  1100_0000  0xC0  192    
  11773	:  0000_1100  0x0C   12    
  11774	:  0000_0000  0x00    0    
  11775	:  0000_0001  0x01    1    
  11776	:  0000_0000  0x00    0    
  11777	:  0000_0001  0x01    1    
  11778	:  0000_0000  0x00    0    
  11779	:  0000_0000  0x00    0    
  11780	:  0010_1010  0x2A   42  *  
  11781	:  0011_0000  0x30   48  0  
  11782	:  0000_0000  0x00    0    
  11783	:  0000_0100  0x04    4    
  11784	:  0010_1101  0x2D   45  -  
  11785	:  0100_0011  0x43   67  C  
  11786	:  0011_0011  0x33   51  3  
  11787	:  1101_0001  0xD1  209    
  11788	:  0000_1000  0x08    8    
  11789	:  0100_0001  0x41   65  A  
  11790	:  0010_1101  0x2D   45  -  
  11791	:  0011_0101  0x35   53  5  
  11792	:  0011_0001  0x31   49  1  
  11793	:  0010_1101  0x2D   45  -  
  11794	:  0011_0010  0x32   50  2  
  11795	:  0011_0001  0x31   49  1  
  11796	:  0011_0000  0x30   48  0  
  11797	:  1100_0000  0xC0  192    
  11798	:  0000_1100  0x0C   12    
  11799	:  0000_0000  0x00    0    
  11800	:  0000_0001  0x01    1    
  11801	:  0000_0000  0x00    0    
  11802	:  0000_0001  0x01    1    
  11803	:  0000_0000  0x00    0    
  11804	:  0000_0000  0x00    0    
  11805	:  0010_1010  0x2A   42  *  
  11806	:  0011_0000  0x30   48  0  
  11807	:  0000_0000  0x00    0    
  11808	:  0000_0100  0x04    4    
  11809	:  0010_1101  0x2D   45  -  
  11810	:  0100_0011  0x43   67  C  
  11811	:  0011_0011  0x33   51  3  
  11812	:  1101_0010  0xD2  210    
  11813	:  0000_1000  0x08    8    
  11814	:  0100_0001  0x41   65  A  
  11815	:  0010_1101  0x2D   45  -  
  11816	:  0011_0101  0x35   53  5  
  11817	:  0011_0001  0x31   49  1  
  11818	:  0010_1101  0x2D   45  -  
  11819	:  0011_0010  0x32   50  2  
  11820	:  0011_0001  0x31   49  1  
  11821	:  0011_0001  0x31   49  1  
  11822	:  1100_0000  0xC0  192    
  11823	:  0000_1100  0x0C   12    
  11824	:  0000_0000  0x00    0    
  11825	:  0000_0001  0x01    1    
  11826	:  0000_0000  0x00    0    
  11827	:  0000_0001  0x01    1    
  11828	:  0000_0000  0x00    0    
  11829	:  0000_0000  0x00    0    
  11830	:  0010_1010  0x2A   42  *  
  11831	:  0011_0000  0x30   48  0  
  11832	:  0000_0000  0x00    0    
  11833	:  0000_0100  0x04    4    
  11834	:  0010_1101  0x2D   45  -  
  11835	:  0100_0011  0x43   67  C  
  11836	:  0011_0011  0x33   51  3  
  11837	:  1101_0011  0xD3  211    
  11838	:  0000_1000  0x08    8    
  11839	:  0100_0001  0x41   65  A  
  11840	:  0010_1101  0x2D   45  -  
  11841	:  0011_0101  0x35   53  5  
  11842	:  0011_0001  0x31   49  1  
  11843	:  0010_1101  0x2D   45  -  
  11844	:  0011_0010  0x32   50  2  
  11845	:  0011_0001  0x31   49  1  
  11846	:  0011_0010  0x32   50  2  
  11847	:  1100_0000  0xC0  192    
  11848	:  0000_1100  0x0C   12    
  11849	:  0000_0000  0x00    0    
  11850	:  0000_0001  0x01    1    
  11851	:  0000_0000  0x00    0    
  11852	:  0000_0001  0x01    1    
  11853	:  0000_0000  0x00    0    
  11854	:  0000_0000  0x00    0    
  11855	:  0010_1010  0x2A   42  *  
  11856	:  0011_0000  0x30   48  0  
  11857	:  0000_0000  0x00    0    
  11858	:  0000_0100  0x04    4    
  11859	:  0010_1101  0x2D   45  -  
  11860	:  0100_0011  0x43   67  C  
  11861	:  0011_0011  0x33   51  3  
  11862	:  1101_0100  0xD4  212    
  11863	:  0000_1000  0x08    8    
  11864	:  0100_0001  0x41   65  A  
  11865	:  0010_1101  0x2D   45  -  
  11866	:  0011_0101  0x35   53  5  
  11867	:  0011_0001  0x31   49  1  
  11868	:  0010_1101  0x2D   45  -  
  11869	:  0011_0010  0x32   50  2  
  11870	:  0011_0001  0x31   49  1  
  11871	:  0011_0011  0x33   51  3  
  11872	:  1100_0000  0xC0  192    
  11873	:  0000_1100  0x0C   12    
  11874	:  0000_0000  0x00    0    
  11875	:  0000_0001  0x01    1    
  11876	:  0000_0000  0x00    0    
  11877	:  0000_0001  0x01    1    
  11878	:  0000_0000  0x00    0    
  11879	:  0000_0000  0x00    0    
  11880	:  0010_1010  0x2A   42  *  
  11881	:  0011_0000  0x30   48  0  
  11882	:  0000_0000  0x00    0    
  11883	:  0000_0100  0x04    4    
  11884	:  0010_1101  0x2D   45  -  
  11885	:  0100_0011  0x43   67  C  
  11886	:  0011_0011  0x33   51  3  
  11887	:  1101_0101  0xD5  213    
  11888	:  0000_1000  0x08    8    
  11889	:  0100_0001  0x41   65  A  
  11890	:  0010_1101  0x2D   45  -  
  11891	:  0011_0101  0x35   53  5  
  11892	:  0011_0001  0x31   49  1  
  11893	:  0010_1101  0x2D   45  -  
  11894	:  0011_0010  0x32   50  2  
  11895	:  0011_0001  0x31   49  1  
  11896	:  0011_0100  0x34   52  4  
  11897	:  1100_0000  0xC0  192    
  11898	:  0000_1100  0x0C   12    
  11899	:  0000_0000  0x00    0    
  11900	:  0000_0001  0x01    1    
  11901	:  0000_0000  0x00    0    
  11902	:  0000_0001  0x01    1    
  11903	:  0000_0000  0x00    0    
  11904	:  0000_0000  0x00    0    
  11905	:  0010_1010  0x2A   42  *  
  11906	:  0011_0000  0x30   48  0  
  11907	:  0000_0000  0x00    0    
  11908	:  0000_0100  0x04    4    
  11909	:  0010_1101  0x2D   45  -  
  11910	:  0100_0011  0x43   67  C  
  11911	:  0011_0011  0x33   51  3  
  11912	:  1101_0110  0xD6  214    
  11913	:  0000_1000  0x08    8    
  11914	:  0100_0001  0x41   65  A  
  11915	:  0010_1101  0x2D   45  -  
  11916	:  0011_0101  0x35   53  5  
  11917	:  0011_0001  0x31   49  1  
  11918	:  0010_1101  0x2D   45  -  
  11919	:  0011_0010  0x32   50  2  
  11920	:  0011_0001  0x31   49  1  
  11921	:  0011_0101  0x35   53  5  
  11922	:  1100_0000  0xC0  192    
  11923	:  0000_1100  0x0C   12    
  11924	:  0000_0000  0x00    0    
  11925	:  0000_0001  0x01    1    
  11926	:  0000_0000  0x00    0    
  11927	:  0000_0001  0x01    1    
  11928	:  0000_0000  0x00    0    
  11929	:  0000_0000  0x00    0    
  11930	:  0010_1010  0x2A   42  *  
  11931	:  0011_0000  0x30   48  0  
  11932	:  0000_0000  0x00    0    
  11933	:  0000_0100  0x04    4    
  11934	:  0010_1101  0x2D   45  -  
  11935	:  0100_0011  0x43   67  C  
  11936	:  0011_0011  0x33   51  3  
  11937	:  1101_0111  0xD7  215    
  11938	:  0000_1000  0x08    8    
  11939	:  0100_0001  0x41   65  A  
  11940	:  0010_1101  0x2D   45  -  
  11941	:  0011_0101  0x35   53  5  
  11942	:  0011_0001  0x31   49  1  
  11943	:  0010_1101  0x2D   45  -  
  11944	:  0011_0010  0x32   50  2  
  11945	:  0011_0001  0x31   49  1  
  11946	:  0011_0110  0x36   54  6  
  11947	:  1100_0000  0xC0  192    
  11948	:  0000_1100  0x0C   12    
  11949	:  0000_0000  0x00    0    
  11950	:  0000_0001  0x01    1    
  11951	:  0000_0000  0x00    0    
  11952	:  0000_0001  0x01    1    
  11953	:  0000_0000  0x00    0    
  11954	:  0000_0000  0x00    0    
  11955	:  0010_1010  0x2A   42  *  
  11956	:  0011_0000  0x30   48  0  
  11957	:  0000_0000  0x00    0    
  11958	:  0000_0100  0x04    4    
  11959	:  0010_1101  0x2D   45  -  
  11960	:  0100_0011  0x43   67  C  
  11961	:  0011_0011  0x33   51  3  
  11962	:  1101_1000  0xD8  216    
  11963	:  0000_1000  0x08    8    
  11964	:  0100_0001  0x41   65  A  
  11965	:  0010_1101  0x2D   45  -  
  11966	:  0011_0101  0x35   53  5  
  11967	:  0011_0001  0x31   49  1  
  11968	:  0010_1101  0x2D   45  -  
  11969	:  0011_0010  0x32   50  2  
  11970	:  0011_0001  0x31   49  1  
  11971	:  0011_0111  0x37   55  7  
  11972	:  1100_0000  0xC0  192    
  11973	:  0000_1100  0x0C   12    
  11974	:  0000_0000  0x00    0    
  11975	:  0000_0001  0x01    1    
  11976	:  0000_0000  0x00    0    
  11977	:  0000_0001  0x01    1    
  11978	:  0000_0000  0x00    0    
  11979	:  0000_0000  0x00    0    
  11980	:  0010_1010  0x2A   42  *  
  11981	:  0011_0000  0x30   48  0  
  11982	:  0000_0000  0x00    0    
  11983	:  0000_0100  0x04    4    
  11984	:  0010_1101  0x2D   45  -  
  11985	:  0100_0011  0x43   67  C  
  11986	:  0011_0011  0x33   51  3  
  11987	:  1101_1001  0xD9  217    
  11988	:  0000_1000  0x08    8    
  11989	:  0100_0001  0x41   65  A  
  11990	:  0010_1101  0x2D   45  -  
  11991	:  0011_0101  0x35   53  5  
  11992	:  0011_0001  0x31   49  1  
  11993	:  0010_1101  0x2D   45  -  
  11994	:  0011_0010  0x32   50  2  
  11995	:  0011_0001  0x31   49  1  
  11996	:  0011_1000  0x38   56  8  
  11997	:  1100_0000  0xC0  192    
  11998	:  0000_1100  0x0C   12    
  11999	:  0000_0000  0x00    0    
  12000	:  0000_0001  0x01    1    
  12001	:  0000_0000  0x00    0    
  12002	:  0000_0001  0x01    1    
  12003	:  0000_0000  0x00    0    
  12004	:  0000_0000  0x00    0    
  12005	:  0010_1010  0x2A   42  *  
  12006	:  0011_0000  0x30   48  0  
  12007	:  0000_0000  0x00    0    
  12008	:  0000_0100  0x04    4    
  12009	:  0010_1101  0x2D   45  -  
  12010	:  0100_0011  0x43   67  C  
  12011	:  0011_0011  0x33   51  3  
  12012	:  1101_1010  0xDA  218    
  12013	:  0000_1000  0x08    8    
  12014	:  0100_0001  0x41   65  A  
  12015	:  0010_1101  0x2D   45  -  
  12016	:  0011_0101  0x35   53  5  
  12017	:  0011_0001  0x31   49  1  
  12018	:  0010_1101  0x2D   45  -  
  12019	:  0011_0010  0x32   50  2  
  12020	:  0011_0001  0x31   49  1  
  12021	:  0011_1001  0x39   57  9  
  12022	:  1100_0000  0xC0  192    
  12023	:  0000_1100  0x0C   12    
  12024	:  0000_0000  0x00    0    
  12025	:  0000_0001  0x01    1    
  12026	:  0000_0000  0x00    0    
  12027	:  0000_0001  0x01    1    
  12028	:  0000_0000  0x00    0    
  12029	:  0000_0000  0x00    0    
  12030	:  0010_1010  0x2A   42  *  
  12031	:  0011_0000  0x30   48  0  
  12032	:  0000_0000  0x00    0    
  12033	:  0000_0100  0x04    4    
  12034	:  0010_1101  0x2D   45  -  
  12035	:  0100_0011  0x43   67  C  
  12036	:  0011_0011  0x33   51  3  
  12037	:  1101_1011  0xDB  219    
  12038	:  0000_1000  0x08    8    
  12039	:  0100_0001  0x41   65  A  
  12040	:  0010_1101  0x2D   45  -  
  12041	:  0011_0101  0x35   53  5  
  12042	:  0011_0001  0x31   49  1  
  12043	:  0010_1101  0x2D   45  -  
  12044	:  0011_0010  0x32   50  2  
  12045	:  0011_0010  0x32   50  2  
  12046	:  0011_0000  0x30   48  0  
  12047	:  1100_0000  0xC0  192    
  12048	:  0000_1100  0x0C   12    
  12049	:  0000_0000  0x00    0    
  12050	:  0000_0001  0x01    1    
  12051	:  0000_0000  0x00    0    
  12052	:  0000_0001  0x01    1    
  12053	:  0000_0000  0x00    0    
  12054	:  0000_0000  0x00    0    
  12055	:  0010_1010  0x2A   42  *  
  12056	:  0011_0000  0x30   48  0  
  12057	:  0000_0000  0x00    0    
  12058	:  0000_0100  0x04    4    
  12059	:  0010_1101  0x2D   45  -  
  12060	:  0100_0011  0x43   67  C  
  12061	:  0011_0011  0x33   51  3  
  12062	:  1101_1100  0xDC  220    
  12063	:  0000_1000  0x08    8    
  12064	:  0100_0001  0x41   65  A  
  12065	:  0010_1101  0x2D   45  -  
  12066	:  0011_0101  0x35   53  5  
  12067	:  0011_0001  0x31   49  1  
  12068	:  0010_1101  0x2D   45  -  
  12069	:  0011_0010  0x32   50  2  
  12070	:  0011_0010  0x32   50  2  
  12071	:  0011_0001  0x31   49  1  
  12072	:  1100_0000  0xC0  192    
  12073	:  0000_1100  0x0C   12    
  12074	:  0000_0000  0x00    0    
  12075	:  0000_0001  0x01    1    
  12076	:  0000_0000  0x00    0    
  12077	:  0000_0001  0x01    1    
  12078	:  0000_0000  0x00    0    
  12079	:  0000_0000  0x00    0    
  12080	:  0010_1010  0x2A   42  *  
  12081	:  0011_0000  0x30   48  0  
  12082	:  0000_0000  0x00    0    
  12083	:  0000_0100  0x04    4    
  12084	:  0010_1101  0x2D   45  -  
  12085	:  0100_0011  0x43   67  C  
  12086	:  0011_0011  0x33   51  3  
  12087	:  1101_1101  0xDD  221    
  12088	:  0000_1000  0x08    8    
  12089	:  0100_0001  0x41   65  A  
  12090	:  0010_1101  0x2D   45  -  
  12091	:  0011_0101  0x35   53  5  
  12092	:  0011_0001  0x31   49  1  
  12093	:  0010_1101  0x2D   45  -  
  12094	:  0011_0010  0x32   50  2  
  12095	:  0011_0010  0x32   50  2  
  12096	:  0011_0010  0x32   50  2  
  12097	:  1100_0000  0xC0  192    
  12098	:  0000_1100  0x0C   12    
  12099	:  0000_0000  0x00    0    
  12100	:  0000_0001  0x01    1    
  12101	:  0000_0000  0x00    0    
  12102	:  0000_0001  0x01    1    
  12103	:  0000_0000  0x00    0    
  12104	:  0000_0000  0x00    0    
  12105	:  0010_1010  0x2A   42  *  
  12106	:  0011_0000  0x30   48  0  
  12107	:  0000_0000  0x00    0    
  12108	:  0000_0100  0x04    4    
  12109	:  0010_1101  0x2D   45  -  
  12110	:  0100_0011  0x43   67  C  
  12111	:  0011_0011  0x33   51  3  
  12112	:  1101_1110  0xDE  222    
  12113	:  0000_1000  0x08    8    
  12114	:  0100_0001  0x41   65  A  
  12115	:  0010_1101  0x2D   45  -  
  12116	:  0011_0101  0x35   53  5  
  12117	:  0011_0001  0x31   49  1  
  12118	:  0010_1101  0x2D   45  -  
  12119	:  0011_0010  0x32   50  2  
  12120	:  0011_0010  0x32   50  2  
  12121	:  0011_0011  0x33   51  3  
  12122	:  1100_0000  0xC0  192    
  12123	:  0000_1100  0x0C   12    
  12124	:  0000_0000  0x00    0    
  12125	:  0000_0001  0x01    1    
  12126	:  0000_0000  0x00    0    
  12127	:  0000_0001  0x01    1    
  12128	:  0000_0000  0x00    0    
  12129	:  0000_0000  0x00    0    
  12130	:  0010_1010  0x2A   42  *  
  12131	:  0011_0000  0x30   48  0  
  12132	:  0000_0000  0x00    0    
  12133	:  0000_0100  0x04    4    
  12134	:  0010_1101  0x2D   45  -  
  12135	:  0100_0011  0x43   67  C  
  12136	:  0011_0011  0x33   51  3  
  12137	:  1101_1111  0xDF  223    
  12138	:  0000_1000  0x08    8    
  12139	:  0100_0001  0x41   65  A  
  12140	:  0010_1101  0x2D   45  -  
  12141	:  0011_0101  0x35   53  5  
  12142	:  0011_0001  0x31   49  1  
  12143	:  0010_1101  0x2D   45  -  
  12144	:  0011_0010  0x32   50  2  
  12145	:  0011_0010  0x32   50  2  
  12146	:  0011_0100  0x34   52  4  
  12147	:  1100_0000  0xC0  192    
  12148	:  0000_1100  0x0C   12    
  12149	:  0000_0000  0x00    0    
  12150	:  0000_0001  0x01    1    
  12151	:  0000_0000  0x00    0    
  12152	:  0000_0001  0x01    1    
  12153	:  0000_0000  0x00    0    
  12154	:  0000_0000  0x00    0    
  12155	:  0010_1010  0x2A   42  *  
  12156	:  0011_0000  0x30   48  0  
  12157	:  0000_0000  0x00    0    
  12158	:  0000_0100  0x04    4    
  12159	:  0010_1101  0x2D   45  -  
  12160	:  0100_0011  0x43   67  C  
  12161	:  0011_0011  0x33   51  3  
  12162	:  1110_0000  0xE0  224    
  12163	:  0000_1000  0x08    8    
  12164	:  0100_0001  0x41   65  A  
  12165	:  0010_1101  0x2D   45  -  
  12166	:  0011_0101  0x35   53  5  
  12167	:  0011_0001  0x31   49  1  
  12168	:  0010_1101  0x2D   45  -  
  12169	:  0011_0010  0x32   50  2  
  12170	:  0011_0010  0x32   50  2  
  12171	:  0011_0101  0x35   53  5  
  12172	:  1100_0000  0xC0  192    
  12173	:  0000_1100  0x0C   12    
  12174	:  0000_0000  0x00    0    
  12175	:  0000_0001  0x01    1    
  12176	:  0000_0000  0x00    0    
  12177	:  0000_0001  0x01    1    
  12178	:  0000_0000  0x00    0    
  12179	:  0000_0000  0x00    0    
  12180	:  0010_1010  0x2A   42  *  
  12181	:  0011_0000  0x30   48  0  
  12182	:  0000_0000  0x00    0    
  12183	:  0000_0100  0x04    4    
  12184	:  0010_1101  0x2D   45  -  
  12185	:  0100_0011  0x43   67  C  
  12186	:  0011_0011  0x33   51  3  
  12187	:  1110_0001  0xE1  225    
  12188	:  0000_1000  0x08    8    
  12189	:  0100_0001  0x41   65  A  
  12190	:  0010_1101  0x2D   45  -  
  12191	:  0011_0101  0x35   53  5  
  12192	:  0011_0001  0x31   49  1  
  12193	:  0010_1101  0x2D   45  -  
  12194	:  0011_0010  0x32   50  2  
  12195	:  0011_0010  0x32   50  2  
  12196	:  0011_0110  0x36   54  6  
  12197	:  1100_0000  0xC0  192    
  12198	:  0000_1100  0x0C   12    
  12199	:  0000_0000  0x00    0    
  12200	:  0000_0001  0x01    1    
  12201	:  0000_0000  0x00    0    
  12202	:  0000_0001  0x01    1    
  12203	:  0000_0000  0x00    0    
  12204	:  0000_0000  0x00    0    
  12205	:  0010_1010  0x2A   42  *  
  12206	:  0011_0000  0x30   48  0  
  12207	:  0000_0000  0x00    0    
  12208	:  0000_0100  0x04    4    
  12209	:  0010_1101  0x2D   45  -  
  12210	:  0100_0011  0x43   67  C  
  12211	:  0011_0011  0x33   51  3  
  12212	:  1110_0010  0xE2  226    
  12213	:  0000_1000  0x08    8    
  12214	:  0100_0001  0x41   65  A  
  12215	:  0010_1101  0x2D   45  -  
  12216	:  0011_0101  0x35   53  5  
  12217	:  0011_0001  0x31   49  1  
  12218	:  0010_1101  0x2D   45  -  
  12219	:  0011_0010  0x32   50  2  
  12220	:  0011_0010  0x32   50  2  
  12221	:  0011_0111  0x37   55  7  
  12222	:  1100_0000  0xC0  192    
  12223	:  0000_1100  0x0C   12    
  12224	:  0000_0000  0x00    0    
  12225	:  0000_0001  0x01    1    
  12226	:  0000_0000  0x00    0    
  12227	:  0000_0001  0x01    1    
  12228	:  0000_0000  0x00    0    
  12229	:  0000_0000  0x00    0    
  12230	:  0010_1010  0x2A   42  *  
  12231	:  0011_0000  0x30   48  0  
  12232	:  0000_0000  0x00    0    
  12233	:  0000_0100  0x04    4    
  12234	:  0010_1101  0x2D   45  -  
  12235	:  0100_0011  0x43   67  C  
  12236	:  0011_0011  0x33   51  3  
  12237	:  1110_0011  0xE3  227    
  12238	:  0000_1000  0x08    8    
  12239	:  0100_0001  0x41   65  A  
  12240	:  0010_1101  0x2D   45  -  
  12241	:  0011_0101  0x35   53  5  
  12242	:  0011_0001  0x31   49  1  
  12243	:  0010_1101  0x2D   45  -  
  12244	:  0011_0010  0x32   50  2  
  12245	:  0011_0010  0x32   50  2  
  12246	:  0011_1000  0x38   56  8  
  12247	:  1100_0000  0xC0  192    
  12248	:  0000_1100  0x0C   12    
  12249	:  0000_0000  0x00    0    
  12250	:  0000_0001  0x01    1    
  12251	:  0000_0000  0x00    0    
  12252	:  0000_0001  0x01    1    
  12253	:  0000_0000  0x00    0    
  12254	:  0000_0000  0x00    0    
  12255	:  0010_1010  0x2A   42  *  
  12256	:  0011_0000  0x30   48  0  
  12257	:  0000_0000  0x00    0    
  12258	:  0000_0100  0x04    4    
  12259	:  0010_1101  0x2D   45  -  
  12260	:  0100_0011  0x43   67  C  
  12261	:  0011_0011  0x33   51  3  
  12262	:  1110_0100  0xE4  228    
  12263	:  0000_1000  0x08    8    
  12264	:  0100_0001  0x41   65  A  
  12265	:  0010_1101  0x2D   45  -  
  12266	:  0011_0101  0x35   53  5  
  12267	:  0011_0001  0x31   49  1  
  12268	:  0010_1101  0x2D   45  -  
  12269	:  0011_0010  0x32   50  2  
  12270	:  0011_0010  0x32   50  2  
  12271	:  0011_1001  0x39   57  9  
  12272	:  1100_0000  0xC0  192    
  12273	:  0000_1100  0x0C   12    
  12274	:  0000_0000  0x00    0    
  12275	:  0000_0001  0x01    1    
  12276	:  0000_0000  0x00    0    
  12277	:  0000_0001  0x01    1    
  12278	:  0000_0000  0x00    0    
  12279	:  0000_0000  0x00    0    
  12280	:  0010_1010  0x2A   42  *  
  12281	:  0011_0000  0x30   48  0  
  12282	:  0000_0000  0x00    0    
  12283	:  0000_0100  0x04    4    
  12284	:  0010_1101  0x2D   45  -  
  12285	:  0100_0011  0x43   67  C  
  12286	:  0011_0011  0x33   51  3  
  12287	:  1110_0101  0xE5  229    
  12288	:  0000_1000  0x08    8    
  12289	:  0100_0001  0x41   65  A  
  12290	:  0010_1101  0x2D   45  -  
  12291	:  0011_0101  0x35   53  5  
  12292	:  0011_0001  0x31   49  1  
  12293	:  0010_1101  0x2D   45  -  
  12294	:  0011_0010  0x32   50  2  
  12295	:  0011_0011  0x33   51  3  
  12296	:  0011_0000  0x30   48  0  
  12297	:  1100_0000  0xC0  192    
  12298	:  0000_1100  0x0C   12    
  12299	:  0000_0000  0x00    0    
  12300	:  0000_0001  0x01    1    
  12301	:  0000_0000  0x00    0    
  12302	:  0000_0001  0x01    1    
  12303	:  0000_0000  0x00    0    
  12304	:  0000_0000  0x00    0    
  12305	:  0010_1010  0x2A   42  *  
  12306	:  0011_0000  0x30   48  0  
  12307	:  0000_0000  0x00    0    
  12308	:  0000_0100  0x04    4    
  12309	:  0010_1101  0x2D   45  -  
  12310	:  0100_0011  0x43   67  C  
  12311	:  0011_0011  0x33   51  3  
  12312	:  1110_0110  0xE6  230    
  12313	:  0000_1000  0x08    8    
  12314	:  0100_0001  0x41   65  A  
  12315	:  0010_1101  0x2D   45  -  
  12316	:  0011_0101  0x35   53  5  
  12317	:  0011_0001  0x31   49  1  
  12318	:  0010_1101  0x2D   45  -  
  12319	:  0011_0010  0x32   50  2  
  12320	:  0011_0011  0x33   51  3  
  12321	:  0011_0001  0x31   49  1  
  12322	:  1100_0000  0xC0  192    
  12323	:  0000_1100  0x0C   12    
  12324	:  0000_0000  0x00    0    
  12325	:  0000_0001  0x01    1    
  12326	:  0000_0000  0x00    0    
  12327	:  0000_0001  0x01    1    
  12328	:  0000_0000  0x00    0    
  12329	:  0000_0000  0x00    0    
  12330	:  0010_1010  0x2A   42  *  
  12331	:  0011_0000  0x30   48  0  
  12332	:  0000_0000  0x00    0    
  12333	:  0000_0100  0x04    4    
  12334	:  0010_1101  0x2D   45  -  
  12335	:  0100_0011  0x43   67  C  
  12336	:  0011_0011  0x33   51  3  
  12337	:  1110_0111  0xE7  231    
  12338	:  0000_1000  0x08    8    
  12339	:  0100_0001  0x41   65  A  
  12340	:  0010_1101  0x2D   45  -  
  12341	:  0011_0101  0x35   53  5  
  12342	:  0011_0001  0x31   49  1  
  12343	:  0010_1101  0x2D   45  -  
  12344	:  0011_0010  0x32   50  2  
  12345	:  0011_0011  0x33   51  3  
  12346	:  0011_0010  0x32   50  2  
  12347	:  1100_0000  0xC0  192    
  12348	:  0000_1100  0x0C   12    
  12349	:  0000_0000  0x00    0    
  12350	:  0000_0001  0x01    1    
  12351	:  0000_0000  0x00    0    
  12352	:  0000_0001  0x01    1    
  12353	:  0000_0000  0x00    0    
  12354	:  0000_0000  0x00    0    
  12355	:  0010_1010  0x2A   42  *  
  12356	:  0011_0000  0x30   48  0  
  12357	:  0000_0000  0x00    0    
  12358	:  0000_0100  0x04    4    
  12359	:  0010_1101  0x2D   45  -  
  12360	:  0100_0011  0x43   67  C  
  12361	:  0011_0011  0x33   51  3  
  12362	:  1110_1000  0xE8  232    
  12363	:  0000_1000  0x08    8    
  12364	:  0100_0001  0x41   65  A  
  12365	:  0010_1101  0x2D   45  -  
  12366	:  0011_0101  0x35   53  5  
  12367	:  0011_0001  0x31   49  1  
  12368	:  0010_1101  0x2D   45  -  
  12369	:  0011_0010  0x32   50  2  
  12370	:  0011_0011  0x33   51  3  
  12371	:  0011_0011  0x33   51  3  
  12372	:  1100_0000  0xC0  192    
  12373	:  0000_1100  0x0C   12    
  12374	:  0000_0000  0x00    0    
  12375	:  0000_0001  0x01    1    
  12376	:  0000_0000  0x00    0    
  12377	:  0000_0001  0x01    1    
  12378	:  0000_0000  0x00    0    
  12379	:  0000_0000  0x00    0    
  12380	:  0010_1010  0x2A   42  *  
  12381	:  0011_0000  0x30   48  0  
  12382	:  0000_0000  0x00    0    
  12383	:  0000_0100  0x04    4    
  12384	:  0010_1101  0x2D   45  -  
  12385	:  0100_0011  0x43   67  C  
  12386	:  0011_0011  0x33   51  3  
  12387	:  1110_1001  0xE9  233    
  12388	:  0000_1000  0x08    8    
  12389	:  0100_0001  0x41   65  A  
  12390	:  0010_1101  0x2D   45  -  
  12391	:  0011_0101  0x35   53  5  
  12392	:  0011_0001  0x31   49  1  
  12393	:  0010_1101  0x2D   45  -  
  12394	:  0011_0010  0x32   50  2  
  12395	:  0011_0011  0x33   51  3  
  12396	:  0011_0100  0x34   52  4  
  12397	:  1100_0000  0xC0  192    
  12398	:  0000_1100  0x0C   12    
  12399	:  0000_0000  0x00    0    
  12400	:  0000_0001  0x01    1    
  12401	:  0000_0000  0x00    0    
  12402	:  0000_0001  0x01    1    
  12403	:  0000_0000  0x00    0    
  12404	:  0000_0000  0x00    0    
  12405	:  0010_1010  0x2A   42  *  
  12406	:  0011_0000  0x30   48  0  
  12407	:  0000_0000  0x00    0    
  12408	:  0000_0100  0x04    4    
  12409	:  0010_1101  0x2D   45  -  
  12410	:  0100_0011  0x43   67  C  
  12411	:  0011_0011  0x33   51  3  
  12412	:  1110_1010  0xEA  234    
  12413	:  0000_1000  0x08    8    
  12414	:  0100_0001  0x41   65  A  
  12415	:  0010_1101  0x2D   45  -  
  12416	:  0011_0101  0x35   53  5  
  12417	:  0011_0001  0x31   49  1  
  12418	:  0010_1101  0x2D   45  -  
  12419	:  0011_0010  0x32   50  2  
  12420	:  0011_0011  0x33   51  3  
  12421	:  0011_0101  0x35   53  5  
  12422	:  1100_0000  0xC0  192    
  12423	:  0000_1100  0x0C   12    
  12424	:  0000_0000  0x00    0    
  12425	:  0000_0001  0x01    1    
  12426	:  0000_0000  0x00    0    
  12427	:  0000_0001  0x01    1    
  12428	:  0000_0000  0x00    0    
  12429	:  0000_0000  0x00    0    
  12430	:  0010_1010  0x2A   42  *  
  12431	:  0011_0000  0x30   48  0  
  12432	:  0000_0000  0x00    0    
  12433	:  0000_0100  0x04    4    
  12434	:  0010_1101  0x2D   45  -  
  12435	:  0100_0011  0x43   67  C  
  12436	:  0011_0011  0x33   51  3  
  12437	:  1110_1011  0xEB  235    
  12438	:  0000_1000  0x08    8    
  12439	:  0100_0001  0x41   65  A  
  12440	:  0010_1101  0x2D   45  -  
  12441	:  0011_0101  0x35   53  5  
  12442	:  0011_0001  0x31   49  1  
  12443	:  0010_1101  0x2D   45  -  
  12444	:  0011_0010  0x32   50  2  
  12445	:  0011_0011  0x33   51  3  
  12446	:  0011_0110  0x36   54  6  
  12447	:  1100_0000  0xC0  192    
  12448	:  0000_1100  0x0C   12    
  12449	:  0000_0000  0x00    0    
  12450	:  0000_0001  0x01    1    
  12451	:  0000_0000  0x00    0    
  12452	:  0000_0001  0x01    1    
  12453	:  0000_0000  0x00    0    
  12454	:  0000_0000  0x00    0    
  12455	:  0010_1010  0x2A   42  *  
  12456	:  0011_0000  0x30   48  0  
  12457	:  0000_0000  0x00    0    
  12458	:  0000_0100  0x04    4    
  12459	:  0010_1101  0x2D   45  -  
  12460	:  0100_0011  0x43   67  C  
  12461	:  0011_0011  0x33   51  3  
  12462	:  1110_1100  0xEC  236    
  12463	:  0000_1000  0x08    8    
  12464	:  0100_0001  0x41   65  A  
  12465	:  0010_1101  0x2D   45  -  
  12466	:  0011_0101  0x35   53  5  
  12467	:  0011_0001  0x31   49  1  
  12468	:  0010_1101  0x2D   45  -  
  12469	:  0011_0010  0x32   50  2  
  12470	:  0011_0011  0x33   51  3  
  12471	:  0011_0111  0x37   55  7  
  12472	:  1100_0000  0xC0  192    
  12473	:  0000_1100  0x0C   12    
  12474	:  0000_0000  0x00    0    
  12475	:  0000_0001  0x01    1    
  12476	:  0000_0000  0x00    0    
  12477	:  0000_0001  0x01    1    
  12478	:  0000_0000  0x00    0    
  12479	:  0000_0000  0x00    0    
  12480	:  0010_1010  0x2A   42  *  
  12481	:  0011_0000  0x30   48  0  
  12482	:  0000_0000  0x00    0    
  12483	:  0000_0100  0x04    4    
  12484	:  0010_1101  0x2D   45  -  
  12485	:  0100_0011  0x43   67  C  
  12486	:  0011_0011  0x33   51  3  
  12487	:  1110_1101  0xED  237    
  12488	:  0000_1000  0x08    8    
  12489	:  0100_0001  0x41   65  A  
  12490	:  0010_1101  0x2D   45  -  
  12491	:  0011_0101  0x35   53  5  
  12492	:  0011_0001  0x31   49  1  
  12493	:  0010_1101  0x2D   45  -  
  12494	:  0011_0010  0x32   50  2  
  12495	:  0011_0011  0x33   51  3  
  12496	:  0011_1000  0x38   56  8  
  12497	:  1100_0000  0xC0  192    
  12498	:  0000_1100  0x0C   12    
  12499	:  0000_0000  0x00    0    
  12500	:  0000_0001  0x01    1    
  12501	:  0000_0000  0x00    0    
  12502	:  0000_0001  0x01    1    
  12503	:  0000_0000  0x00    0    
  12504	:  0000_0000  0x00    0    
  12505	:  0010_1010  0x2A   42  *  
  12506	:  0011_0000  0x30   48  0  
  12507	:  0000_0000  0x00    0    
  12508	:  0000_0100  0x04    4    
  12509	:  0010_1101  0x2D   45  -  
  12510	:  0100_0011  0x43   67  C  
  12511	:  0011_0011  0x33   51  3  
  12512	:  1110_1110  0xEE  238    
  12513	:  0000_1000  0x08    8    
  12514	:  0100_0001  0x41   65  A  
  12515	:  0010_1101  0x2D   45  -  
  12516	:  0011_0101  0x35   53  5  
  12517	:  0011_0001  0x31   49  1  
  12518	:  0010_1101  0x2D   45  -  
  12519	:  0011_0010  0x32   50  2  
  12520	:  0011_0011  0x33   51  3  
  12521	:  0011_1001  0x39   57  9  
  12522	:  1100_0000  0xC0  192    
  12523	:  0000_1100  0x0C   12    
  12524	:  0000_0000  0x00    0    
  12525	:  0000_0001  0x01    1    
  12526	:  0000_0000  0x00    0    
  12527	:  0000_0001  0x01    1    
  12528	:  0000_0000  0x00    0    
  12529	:  0000_0000  0x00    0    
  12530	:  0010_1010  0x2A   42  *  
  12531	:  0011_0000  0x30   48  0  
  12532	:  0000_0000  0x00    0    
  12533	:  0000_0100  0x04    4    
  12534	:  0010_1101  0x2D   45  -  
  12535	:  0100_0011  0x43   67  C  
  12536	:  0011_0011  0x33   51  3  
  12537	:  1110_1111  0xEF  239    
  12538	:  0000_1000  0x08    8    
  12539	:  0100_0001  0x41   65  A  
  12540	:  0010_1101  0x2D   45  -  
  12541	:  0011_0101  0x35   53  5  
  12542	:  0011_0001  0x31   49  1  
  12543	:  0010_1101  0x2D   45  -  
  12544	:  0011_0010  0x32   50  2  
  12545	:  0011_0100  0x34   52  4  
  12546	:  0011_0000  0x30   48  0  
  12547	:  1100_0000  0xC0  192    
  12548	:  0000_1100  0x0C   12    
  12549	:  0000_0000  0x00    0    
  12550	:  0000_0001  0x01    1    
  12551	:  0000_0000  0x00    0    
  12552	:  0000_0001  0x01    1    
  12553	:  0000_0000  0x00    0    
  12554	:  0000_0000  0x00    0    
  12555	:  0010_1010  0x2A   42  *  
  12556	:  0011_0000  0x30   48  0  
  12557	:  0000_0000  0x00    0    
  12558	:  0000_0100  0x04    4    
  12559	:  0010_1101  0x2D   45  -  
  12560	:  0100_0011  0x43   67  C  
  12561	:  0011_0011  0x33   51  3  
  12562	:  1111_0000  0xF0  240    
  12563	:  0000_1000  0x08    8    
  12564	:  0100_0001  0x41   65  A  
  12565	:  0010_1101  0x2D   45  -  
  12566	:  0011_0101  0x35   53  5  
  12567	:  0011_0001  0x31   49  1  
  12568	:  0010_1101  0x2D   45  -  
  12569	:  0011_0010  0x32   50  2  
  12570	:  0011_0100  0x34   52  4  
  12571	:  0011_0001  0x31   49  1  
  12572	:  1100_0000  0xC0  192    
  12573	:  0000_1100  0x0C   12    
  12574	:  0000_0000  0x00    0    
  12575	:  0000_0001  0x01    1    
  12576	:  0000_0000  0x00    0    
  12577	:  0000_0001  0x01    1    
  12578	:  0000_0000  0x00    0    
  12579	:  0000_0000  0x00    0    
  12580	:  0010_1010  0x2A   42  *  
  12581	:  0011_0000  0x30   48  0  
  12582	:  0000_0000  0x00    0    
  12583	:  0000_0100  0x04    4    
  12584	:  0010_1101  0x2D   45  -  
  12585	:  0100_0011  0x43   67  C  
  12586	:  0011_0011  0x33   51  3  
  12587	:  1111_0001  0xF1  241    
  12588	:  0000_1000  0x08    8    
  12589	:  0100_0001  0x41   65  A  
  12590	:  0010_1101  0x2D   45  -  
  12591	:  0011_0101  0x35   53  5  
  12592	:  0011_0001  0x31   49  1  
  12593	:  0010_1101  0x2D   45  -  
  12594	:  0011_0010  0x32   50  2  
  12595	:  0011_0100  0x34   52  4  
  12596	:  0011_0010  0x32   50  2  
  12597	:  1100_0000  0xC0  192    
  12598	:  0000_1100  0x0C   12    
  12599	:  0000_0000  0x00    0    
  12600	:  0000_0001  0x01    1    
  12601	:  0000_0000  0x00    0    
  12602	:  0000_0001  0x01    1    
  12603	:  0000_0000  0x00    0    
  12604	:  0000_0000  0x00    0    
  12605	:  0010_1010  0x2A   42  *  
  12606	:  0011_0000  0x30   48  0  
  12607	:  0000_0000  0x00    0    
  12608	:  0000_0100  0x04    4    
  12609	:  0010_1101  0x2D   45  -  
  12610	:  0100_0011  0x43   67  C  
  12611	:  0011_0011  0x33   51  3  
  12612	:  1111_0010  0xF2  242    
  12613	:  0000_1000  0x08    8    
  12614	:  0100_0001  0x41   65  A  
  12615	:  0010_1101  0x2D   45  -  
  12616	:  0011_0101  0x35   53  5  
  12617	:  0011_0001  0x31   49  1  
  12618	:  0010_1101  0x2D   45  -  
  12619	:  0011_0010  0x32   50  2  
  12620	:  0011_0100  0x34   52  4  
  12621	:  0011_0011  0x33   51  3  
  12622	:  1100_0000  0xC0  192    
  12623	:  0000_1100  0x0C   12    
  12624	:  0000_0000  0x00    0    
  12625	:  0000_0001  0x01    1    
  12626	:  0000_0000  0x00    0    
  12627	:  0000_0001  0x01    1    
  12628	:  0000_0000  0x00    0    
  12629	:  0000_0000  0x00    0    
  12630	:  0010_1010  0x2A   42  *  
  12631	:  0011_0000  0x30   48  0  
  12632	:  0000_0000  0x00    0    
  12633	:  0000_0100  0x04    4    
  12634	:  0010_1101  0x2D   45  -  
  12635	:  0100_0011  0x43   67  C  
  12636	:  0011_0011  0x33   51  3  
  12637	:  1111_0011  0xF3  243    
  12638	:  0000_1000  0x08    8    
  12639	:  0100_0001  0x41   65  A  
  12640	:  0010_1101  0x2D   45  -  
  12641	:  0011_0101  0x35   53  5  
  12642	:  0011_0001  0x31   49  1  
  12643	:  0010_1101  0x2D   45  -  
  12644	:  0011_0010  0x32   50  2  
  12645	:  0011_0100  0x34   52  4  
  12646	:  0011_0100  0x34   52  4  
  12647	:  1100_0000  0xC0  192    
  12648	:  0000_1100  0x0C   12    
  12649	:  0000_0000  0x00    0    
  12650	:  0000_0001  0x01    1    
  12651	:  0000_0000  0x00    0    
  12652	:  0000_0001  0x01    1    
  12653	:  0000_0000  0x00    0    
  12654	:  0000_0000  0x00    0    
  12655	:  0010_1010  0x2A   42  *  
  12656	:  0011_0000  0x30   48  0  
  12657	:  0000_0000  0x00    0    
  12658	:  0000_0100  0x04    4    
  12659	:  0010_1101  0x2D   45  -  
  12660	:  0100_0011  0x43   67  C  
  12661	:  0011_0011  0x33   51  3  
  12662	:  1111_0100  0xF4  244    
  12663	:  0000_1000  0x08    8    
  12664	:  0100_0001  0x41   65  A  
  12665	:  0010_1101  0x2D   45  -  
  12666	:  0011_0101  0x35   53  5  
  12667	:  0011_0001  0x31   49  1  
  12668	:  0010_1101  0x2D   45  -  
  12669	:  0011_0010  0x32   50  2  
  12670	:  0011_0100  0x34   52  4  
  12671	:  0011_0101  0x35   53  5  
  12672	:  1100_0000  0xC0  192    
  12673	:  0000_1100  0x0C   12    
  12674	:  0000_0000  0x00    0    
  12675	:  0000_0001  0x01    1    
  12676	:  0000_0000  0x00    0    
  12677	:  0000_0001  0x01    1    
  12678	:  0000_0000  0x00    0    
  12679	:  0000_0000  0x00    0    
  12680	:  0010_1010  0x2A   42  *  
  12681	:  0011_0000  0x30   48  0  
  12682	:  0000_0000  0x00    0    
  12683	:  0000_0100  0x04    4    
  12684	:  0010_1101  0x2D   45  -  
  12685	:  0100_0011  0x43   67  C  
  12686	:  0011_0011  0x33   51  3  
  12687	:  1111_0101  0xF5  245    
  12688	:  0000_1000  0x08    8    
  12689	:  0100_0001  0x41   65  A  
  12690	:  0010_1101  0x2D   45  -  
  12691	:  0011_0101  0x35   53  5  
  12692	:  0011_0001  0x31   49  1  
  12693	:  0010_1101  0x2D   45  -  
  12694	:  0011_0010  0x32   50  2  
  12695	:  0011_0100  0x34   52  4  
  12696	:  0011_0110  0x36   54  6  
  12697	:  1100_0000  0xC0  192    
  12698	:  0000_1100  0x0C   12    
  12699	:  0000_0000  0x00    0    
  12700	:  0000_0001  0x01    1    
  12701	:  0000_0000  0x00    0    
  12702	:  0000_0001  0x01    1    
  12703	:  0000_0000  0x00    0    
  12704	:  0000_0000  0x00    0    
  12705	:  0010_1010  0x2A   42  *  
  12706	:  0011_0000  0x30   48  0  
  12707	:  0000_0000  0x00    0    
  12708	:  0000_0100  0x04    4    
  12709	:  0010_1101  0x2D   45  -  
  12710	:  0100_0011  0x43   67  C  
  12711	:  0011_0011  0x33   51  3  
  12712	:  1111_0110  0xF6  246    
  12713	:  0000_1000  0x08    8    
  12714	:  0100_0001  0x41   65  A  
  12715	:  0010_1101  0x2D   45  -  
  12716	:  0011_0101  0x35   53  5  
  12717	:  0011_0001  0x31   49  1  
  12718	:  0010_1101  0x2D   45  -  
  12719	:  0011_0010  0x32   50  2  
  12720	:  0011_0100  0x34   52  4  
  12721	:  0011_0111  0x37   55  7  
  12722	:  1100_0000  0xC0  192    
  12723	:  0000_1100  0x0C   12    
  12724	:  0000_0000  0x00    0    
  12725	:  0000_0001  0x01    1    
  12726	:  0000_0000  0x00    0    
  12727	:  0000_0001  0x01    1    
  12728	:  0000_0000  0x00    0    
  12729	:  0000_0000  0x00    0    
  12730	:  0010_1010  0x2A   42  *  
  12731	:  0011_0000  0x30   48  0  
  12732	:  0000_0000  0x00    0    
  12733	:  0000_0100  0x04    4    
  12734	:  0010_1101  0x2D   45  -  
  12735	:  0100_0011  0x43   67  C  
  12736	:  0011_0011  0x33   51  3  
  12737	:  1111_0111  0xF7  247    
  12738	:  0000_1000  0x08    8    
  12739	:  0100_0001  0x41   65  A  
  12740	:  0010_1101  0x2D   45  -  
  12741	:  0011_0101  0x35   53  5  
  12742	:  0011_0001  0x31   49  1  
  12743	:  0010_1101  0x2D   45  -  
  12744	:  0011_0010  0x32   50  2  
  12745	:  0011_0100  0x34   52  4  
  12746	:  0011_1000  0x38   56  8  
  12747	:  1100_0000  0xC0  192    
  12748	:  0000_1100  0x0C   12    
  12749	:  0000_0000  0x00    0    
  12750	:  0000_0001  0x01    1    
  12751	:  0000_0000  0x00    0    
  12752	:  0000_0001  0x01    1    
  12753	:  0000_0000  0x00    0    
  12754	:  0000_0000  0x00    0    
  12755	:  0010_1010  0x2A   42  *  
  12756	:  0011_0000  0x30   48  0  
  12757	:  0000_0000  0x00    0    
  12758	:  0000_0100  0x04    4    
  12759	:  0010_1101  0x2D   45  -  
  12760	:  0100_0011  0x43   67  C  
  12761	:  0011_0011  0x33   51  3  
  12762	:  1111_1000  0xF8  248    
  12763	:  0000_1000  0x08    8    
  12764	:  0100_0001  0x41   65  A  
  12765	:  0010_1101  0x2D   45  -  
  12766	:  0011_0101  0x35   53  5  
  12767	:  0011_0001  0x31   49  1  
  12768	:  0010_1101  0x2D   45  -  
  12769	:  0011_0010  0x32   50  2  
  12770	:  0011_0100  0x34   52  4  
  12771	:  0011_1001  0x39   57  9  
  12772	:  1100_0000  0xC0  192    
  12773	:  0000_1100  0x0C   12    
  12774	:  0000_0000  0x00    0    
  12775	:  0000_0001  0x01    1    
  12776	:  0000_0000  0x00    0    
  12777	:  0000_0001  0x01    1    
  12778	:  0000_0000  0x00    0    
  12779	:  0000_0000  0x00    0    
  12780	:  0010_1010  0x2A   42  *  
  12781	:  0011_0000  0x30   48  0  
  12782	:  0000_0000  0x00    0    
  12783	:  0000_0100  0x04    4    
  12784	:  0010_1101  0x2D   45  -  
  12785	:  0100_0011  0x43   67  C  
  12786	:  0011_0011  0x33   51  3  
  12787	:  1111_1001  0xF9  249    
  12788	:  0000_1000  0x08    8    
  12789	:  0100_0001  0x41   65  A  
  12790	:  0010_1101  0x2D   45  -  
  12791	:  0011_0101  0x35   53  5  
  12792	:  0011_0001  0x31   49  1  
  12793	:  0010_1101  0x2D   45  -  
  12794	:  0011_0010  0x32   50  2  
  12795	:  0011_0101  0x35   53  5  
  12796	:  0011_0000  0x30   48  0  
  12797	:  1100_0000  0xC0  192    
  12798	:  0000_1100  0x0C   12    
  12799	:  0000_0000  0x00    0    
  12800	:  0000_0001  0x01    1    
  12801	:  0000_0000  0x00    0    
  12802	:  0000_0001  0x01    1    
  12803	:  0000_0000  0x00    0    
  12804	:  0000_0000  0x00    0    
  12805	:  0010_1010  0x2A   42  *  
  12806	:  0011_0000  0x30   48  0  
  12807	:  0000_0000  0x00    0    
  12808	:  0000_0100  0x04    4    
  12809	:  0010_1101  0x2D   45  -  
  12810	:  0100_0011  0x43   67  C  
  12811	:  0011_0011  0x33   51  3  
  12812	:  1111_1010  0xFA  250    
  12813	:  0000_1000  0x08    8    
  12814	:  0100_0001  0x41   65  A  
  12815	:  0010_1101  0x2D   45  -  
  12816	:  0011_0101  0x35   53  5  
  12817	:  0011_0001  0x31   49  1  
  12818	:  0010_1101  0x2D   45  -  
  12819	:  0011_0010  0x32   50  2  
  12820	:  0011_0101  0x35   53  5  
  12821	:  0011_0001  0x31   49  1  
  12822	:  1100_0000  0xC0  192    
  12823	:  0000_1100  0x0C   12    
  12824	:  0000_0000  0x00    0    
  12825	:  0000_0001  0x01    1    
  12826	:  0000_0000  0x00    0    
  12827	:  0000_0001  0x01    1    
  12828	:  0000_0000  0x00    0    
  12829	:  0000_0000  0x00    0    
  12830	:  0010_1010  0x2A   42  *  
  12831	:  0011_0000  0x30   48  0  
  12832	:  0000_0000  0x00    0    
  12833	:  0000_0100  0x04    4    
  12834	:  0010_1101  0x2D   45  -  
  12835	:  0100_0011  0x43   67  C  
  12836	:  0011_0011  0x33   51  3  
  12837	:  1111_1011  0xFB  251    
  12838	:  0000_1000  0x08    8    
  12839	:  0100_0001  0x41   65  A  
  12840	:  0010_1101  0x2D   45  -  
  12841	:  0011_0101  0x35   53  5  
  12842	:  0011_0001  0x31   49  1  
  12843	:  0010_1101  0x2D   45  -  
  12844	:  0011_0010  0x32   50  2  
  12845	:  0011_0101  0x35   53  5  
  12846	:  0011_0010  0x32   50  2  
  12847	:  1100_0000  0xC0  192    
  12848	:  0000_1100  0x0C   12    
  12849	:  0000_0000  0x00    0    
  12850	:  0000_0001  0x01    1    
  12851	:  0000_0000  0x00    0    
  12852	:  0000_0001  0x01    1    
  12853	:  0000_0000  0x00    0    
  12854	:  0000_0000  0x00    0    
  12855	:  0010_1010  0x2A   42  *  
  12856	:  0011_0000  0x30   48  0  
  12857	:  0000_0000  0x00    0    
  12858	:  0000_0100  0x04    4    
  12859	:  0010_1101  0x2D   45  -  
  12860	:  0100_0011  0x43   67  C  
  12861	:  0011_0011  0x33   51  3  
  12862	:  1111_1100  0xFC  252    
  12863	:  0000_1000  0x08    8    
  12864	:  0100_0001  0x41   65  A  
  12865	:  0010_1101  0x2D   45  -  
  12866	:  0011_0101  0x35   53  5  
  12867	:  0011_0001  0x31   49  1  
  12868	:  0010_1101  0x2D   45  -  
  12869	:  0011_0010  0x32   50  2  
  12870	:  0011_0101  0x35   53  5  
  12871	:  0011_0011  0x33   51  3  
  12872	:  1100_0000  0xC0  192    
  12873	:  0000_1100  0x0C   12    
  12874	:  0000_0000  0x00    0    
  12875	:  0000_0001  0x01    1    
  12876	:  0000_0000  0x00    0    
  12877	:  0000_0001  0x01    1    
  12878	:  0000_0000  0x00    0    
  12879	:  0000_0000  0x00    0    
  12880	:  0010_1010  0x2A   42  *  
  12881	:  0011_0000  0x30   48  0  
  12882	:  0000_0000  0x00    0    
  12883	:  0000_0100  0x04    4    
  12884	:  0010_1101  0x2D   45  -  
  12885	:  0100_0011  0x43   67  C  
  12886	:  0011_0011  0x33   51  3  
  12887	:  1111_1101  0xFD  253    
  12888	:  0000_1000  0x08    8    
  12889	:  0100_0001  0x41   65  A  
  12890	:  0010_1101  0x2D   45  -  
  12891	:  0011_0101  0x35   53  5  
  12892	:  0011_0001  0x31   49  1  
  12893	:  0010_1101  0x2D   45  -  
  12894	:  0011_0010  0x32   50  2  
  12895	:  0011_0101  0x35   53  5  
  12896	:  0011_0100  0x34   52  4  
  12897	:  1100_0000  0xC0  192    
  12898	:  0000_1100  0x0C   12    
  12899	:  0000_0000  0x00    0    
  12900	:  0000_0001  0x01    1    
  12901	:  0000_0000  0x00    0    
  12902	:  0000_0001  0x01    1    
  12903	:  0000_0000  0x00    0    
  12904	:  0000_0000  0x00    0    
  12905	:  0010_1010  0x2A   42  *  
  12906	:  0011_0000  0x30   48  0  
  12907	:  0000_0000  0x00    0    
  12908	:  0000_0100  0x04    4    
  12909	:  0010_1101  0x2D   45  -  
  12910	:  0100_0011  0x43   67  C  
  12911	:  0011_0011  0x33   51  3  
  12912	:  1111_1110  0xFE  254    
  12913	:  0000_1000  0x08    8    
  12914	:  0100_0001  0x41   65  A  
  12915	:  0010_1101  0x2D   45  -  
  12916	:  0011_0101  0x35   53  5  
  12917	:  0011_0010  0x32   50  2  
  12918	:  0010_1101  0x2D   45  -  
  12919	:  0011_0000  0x30   48  0  
  12920	:  0011_0000  0x30   48  0  
  12921	:  0011_0001  0x31   49  1  
  12922	:  1100_0000  0xC0  192    
  12923	:  0000_1100  0x0C   12    
  12924	:  0000_0000  0x00    0    
  12925	:  0000_0001  0x01    1    
  12926	:  0000_0000  0x00    0    
  12927	:  0000_0001  0x01    1    
  12928	:  0000_0000  0x00    0    
  12929	:  0000_0000  0x00    0    
  12930	:  0010_1010  0x2A   42  *  
  12931	:  0011_0000  0x30   48  0  
  12932	:  0000_0000  0x00    0    
  12933	:  0000_0100  0x04    4    
  12934	:  0010_1101  0x2D   45  -  
  12935	:  0100_0011  0x43   67  C  
  12936	:  0011_0100  0x34   52  4  
  12937	:  0000_0001  0x01    1    
  12938	:  0000_1000  0x08    8    
  12939	:  0100_0001  0x41   65  A  
  12940	:  0010_1101  0x2D   45  -  
  12941	:  0011_0101  0x35   53  5  
  12942	:  0011_0010  0x32   50  2  
  12943	:  0010_1101  0x2D   45  -  
  12944	:  0011_0000  0x30   48  0  
  12945	:  0011_0000  0x30   48  0  
  12946	:  0011_0010  0x32   50  2  
  12947	:  1100_0000  0xC0  192    
  12948	:  0000_1100  0x0C   12    
  12949	:  0000_0000  0x00    0    
  12950	:  0000_0001  0x01    1    
  12951	:  0000_0000  0x00    0    
  12952	:  0000_0001  0x01    1    
  12953	:  0000_0000  0x00    0    
  12954	:  0000_0000  0x00    0    
  12955	:  0010_1010  0x2A   42  *  
  12956	:  0011_0000  0x30   48  0  
  12957	:  0000_0000  0x00    0    
  12958	:  0000_0100  0x04    4    
  12959	:  0010_1101  0x2D   45  -  
  12960	:  0100_0011  0x43   67  C  
  12961	:  0011_0100  0x34   52  4  
  12962	:  0000_0010  0x02    2    
  12963	:  0000_1000  0x08    8    
  12964	:  0100_0001  0x41   65  A  
  12965	:  0010_1101  0x2D   45  -  
  12966	:  0011_0101  0x35   53  5  
  12967	:  0011_0010  0x32   50  2  
  12968	:  0010_1101  0x2D   45  -  
  12969	:  0011_0000  0x30   48  0  
  12970	:  0011_0000  0x30   48  0  
  12971	:  0011_0011  0x33   51  3  
  12972	:  1100_0000  0xC0  192    
  12973	:  0000_1100  0x0C   12    
  12974	:  0000_0000  0x00    0    
  12975	:  0000_0001  0x01    1    
  12976	:  0000_0000  0x00    0    
  12977	:  0000_0001  0x01    1    
  12978	:  0000_0000  0x00    0    
  12979	:  0000_0000  0x00    0    
  12980	:  0010_1010  0x2A   42  *  
  12981	:  0011_0000  0x30   48  0  
  12982	:  0000_0000  0x00    0    
  12983	:  0000_0100  0x04    4    
  12984	:  0010_1101  0x2D   45  -  
  12985	:  0100_0011  0x43   67  C  
  12986	:  0011_0100  0x34   52  4  
  12987	:  0000_0011  0x03    3    
  12988	:  0000_1000  0x08    8    
  12989	:  0100_0001  0x41   65  A  
  12990	:  0010_1101  0x2D   45  -  
  12991	:  0011_0101  0x35   53  5  
  12992	:  0011_0010  0x32   50  2  
  12993	:  0010_1101  0x2D   45  -  
  12994	:  0011_0000  0x30   48  0  
  12995	:  0011_0000  0x30   48  0  
  12996	:  0011_0100  0x34   52  4  
  12997	:  1100_0000  0xC0  192    
  12998	:  0000_1100  0x0C   12    
  12999	:  0000_0000  0x00    0    
  13000	:  0000_0001  0x01    1    
  13001	:  0000_0000  0x00    0    
  13002	:  0000_0001  0x01    1    
  13003	:  0000_0000  0x00    0    
  13004	:  0000_0000  0x00    0    
  13005	:  0010_1010  0x2A   42  *  
  13006	:  0011_0000  0x30   48  0  
  13007	:  0000_0000  0x00    0    
  13008	:  0000_0100  0x04    4    
  13009	:  0010_1101  0x2D   45  -  
  13010	:  0100_0011  0x43   67  C  
  13011	:  0011_0100  0x34   52  4  
  13012	:  0000_0100  0x04    4    
  13013	:  0000_1000  0x08    8    
  13014	:  0100_0001  0x41   65  A  
  13015	:  0010_1101  0x2D   45  -  
  13016	:  0011_0101  0x35   53  5  
  13017	:  0011_0010  0x32   50  2  
  13018	:  0010_1101  0x2D   45  -  
  13019	:  0011_0000  0x30   48  0  
  13020	:  0011_0000  0x30   48  0  
  13021	:  0011_0101  0x35   53  5  
  13022	:  1100_0000  0xC0  192    
  13023	:  0000_1100  0x0C   12    
  13024	:  0000_0000  0x00    0    
  13025	:  0000_0001  0x01    1    
  13026	:  0000_0000  0x00    0    
  13027	:  0000_0001  0x01    1    
  13028	:  0000_0000  0x00    0    
  13029	:  0000_0000  0x00    0    
  13030	:  0010_1010  0x2A   42  *  
  13031	:  0011_0000  0x30   48  0  
  13032	:  0000_0000  0x00    0    
  13033	:  0000_0100  0x04    4    
  13034	:  0010_1101  0x2D   45  -  
  13035	:  0100_0011  0x43   67  C  
  13036	:  0011_0100  0x34   52  4  
  13037	:  0000_0101  0x05    5    
  13038	:  0000_1000  0x08    8    
  13039	:  0100_0001  0x41   65  A  
  13040	:  0010_1101  0x2D   45  -  
  13041	:  0011_0101  0x35   53  5  
  13042	:  0011_0010  0x32   50  2  
  13043	:  0010_1101  0x2D   45  -  
  13044	:  0011_0000  0x30   48  0  
  13045	:  0011_0000  0x30   48  0  
  13046	:  0011_0110  0x36   54  6  
  13047	:  1100_0000  0xC0  192    
  13048	:  0000_1100  0x0C   12    
  13049	:  0000_0000  0x00    0    
  13050	:  0000_0001  0x01    1    
  13051	:  0000_0000  0x00    0    
  13052	:  0000_0001  0x01    1    
  13053	:  0000_0000  0x00    0    
  13054	:  0000_0000  0x00    0    
  13055	:  0010_1010  0x2A   42  *  
  13056	:  0011_0000  0x30   48  0  
  13057	:  0000_0000  0x00    0    
  13058	:  0000_0100  0x04    4    
  13059	:  0010_1101  0x2D   45  -  
  13060	:  0100_0011  0x43   67  C  
  13061	:  0011_0100  0x34   52  4  
  13062	:  0000_0110  0x06    6    
  13063	:  0000_1000  0x08    8    
  13064	:  0100_0001  0x41   65  A  
  13065	:  0010_1101  0x2D   45  -  
  13066	:  0011_0101  0x35   53  5  
  13067	:  0011_0010  0x32   50  2  
  13068	:  0010_1101  0x2D   45  -  
  13069	:  0011_0000  0x30   48  0  
  13070	:  0011_0000  0x30   48  0  
  13071	:  0011_0111  0x37   55  7  
  13072	:  1100_0000  0xC0  192    
  13073	:  0000_1100  0x0C   12    
  13074	:  0000_0000  0x00    0    
  13075	:  0000_0001  0x01    1    
  13076	:  0000_0000  0x00    0    
  13077	:  0000_0001  0x01    1    
  13078	:  0000_0000  0x00    0    
  13079	:  0000_0000  0x00    0    
  13080	:  0010_1010  0x2A   42  *  
  13081	:  0011_0000  0x30   48  0  
  13082	:  0000_0000  0x00    0    
  13083	:  0000_0100  0x04    4    
  13084	:  0010_1101  0x2D   45  -  
  13085	:  0100_0011  0x43   67  C  
  13086	:  0011_0100  0x34   52  4  
  13087	:  0000_0111  0x07    7    
  13088	:  0000_1000  0x08    8    
  13089	:  0100_0001  0x41   65  A  
  13090	:  0010_1101  0x2D   45  -  
  13091	:  0011_0101  0x35   53  5  
  13092	:  0011_0010  0x32   50  2  
  13093	:  0010_1101  0x2D   45  -  
  13094	:  0011_0000  0x30   48  0  
  13095	:  0011_0000  0x30   48  0  
  13096	:  0011_1000  0x38   56  8  
  13097	:  1100_0000  0xC0  192    
  13098	:  0000_1100  0x0C   12    
  13099	:  0000_0000  0x00    0    
  13100	:  0000_0001  0x01    1    
  13101	:  0000_0000  0x00    0    
  13102	:  0000_0001  0x01    1    
  13103	:  0000_0000  0x00    0    
  13104	:  0000_0000  0x00    0    
  13105	:  0010_1010  0x2A   42  *  
  13106	:  0011_0000  0x30   48  0  
  13107	:  0000_0000  0x00    0    
  13108	:  0000_0100  0x04    4    
  13109	:  0010_1101  0x2D   45  -  
  13110	:  0100_0011  0x43   67  C  
  13111	:  0011_0100  0x34   52  4  
  13112	:  0000_1000  0x08    8    
  13113	:  0000_1000  0x08    8    
  13114	:  0100_0001  0x41   65  A  
  13115	:  0010_1101  0x2D   45  -  
  13116	:  0011_0101  0x35   53  5  
  13117	:  0011_0010  0x32   50  2  
  13118	:  0010_1101  0x2D   45  -  
  13119	:  0011_0000  0x30   48  0  
  13120	:  0011_0000  0x30   48  0  
  13121	:  0011_1001  0x39   57  9  
  13122	:  1100_0000  0xC0  192    
  13123	:  0000_1100  0x0C   12    
  13124	:  0000_0000  0x00    0    
  13125	:  0000_0001  0x01    1    
  13126	:  0000_0000  0x00    0    
  13127	:  0000_0001  0x01    1    
  13128	:  0000_0000  0x00    0    
  13129	:  0000_0000  0x00    0    
  13130	:  0010_1010  0x2A   42  *  
  13131	:  0011_0000  0x30   48  0  
  13132	:  0000_0000  0x00    0    
  13133	:  0000_0100  0x04    4    
  13134	:  0010_1101  0x2D   45  -  
  13135	:  0100_0011  0x43   67  C  
  13136	:  0011_0100  0x34   52  4  
  13137	:  0000_1001  0x09    9    
  13138	:  0000_1000  0x08    8    
  13139	:  0100_0001  0x41   65  A  
  13140	:  0010_1101  0x2D   45  -  
  13141	:  0011_0101  0x35   53  5  
  13142	:  0011_0010  0x32   50  2  
  13143	:  0010_1101  0x2D   45  -  
  13144	:  0011_0000  0x30   48  0  
  13145	:  0011_0001  0x31   49  1  
  13146	:  0011_0000  0x30   48  0  
  13147	:  1100_0000  0xC0  192    
  13148	:  0000_1100  0x0C   12    
  13149	:  0000_0000  0x00    0    
  13150	:  0000_0001  0x01    1    
  13151	:  0000_0000  0x00    0    
  13152	:  0000_0001  0x01    1    
  13153	:  0000_0000  0x00    0    
  13154	:  0000_0000  0x00    0    
  13155	:  0010_1010  0x2A   42  *  
  13156	:  0011_0000  0x30   48  0  
  13157	:  0000_0000  0x00    0    
  13158	:  0000_0100  0x04    4    
  13159	:  0010_1101  0x2D   45  -  
  13160	:  0100_0011  0x43   67  C  
  13161	:  0011_0100  0x34   52  4  
  13162	:  0000_1010  0x0A   10    
  13163	:  0000_1000  0x08    8    
  13164	:  0100_0001  0x41   65  A  
  13165	:  0010_1101  0x2D   45  -  
  13166	:  0011_0101  0x35   53  5  
  13167	:  0011_0010  0x32   50  2  
  13168	:  0010_1101  0x2D   45  -  
  13169	:  0011_0000  0x30   48  0  
  13170	:  0011_0001  0x31   49  1  
  13171	:  0011_0001  0x31   49  1  
  13172	:  1100_0000  0xC0  192    
  13173	:  0000_1100  0x0C   12    
  13174	:  0000_0000  0x00    0    
  13175	:  0000_0001  0x01    1    
  13176	:  0000_0000  0x00    0    
  13177	:  0000_0001  0x01    1    
  13178	:  0000_0000  0x00    0    
  13179	:  0000_0000  0x00    0    
  13180	:  0010_1010  0x2A   42  *  
  13181	:  0011_0000  0x30   48  0  
  13182	:  0000_0000  0x00    0    
  13183	:  0000_0100  0x04    4    
  13184	:  0010_1101  0x2D   45  -  
  13185	:  0100_0011  0x43   67  C  
  13186	:  0011_0100  0x34   52  4  
  13187	:  0000_1011  0x0B   11    
  13188	:  0000_1000  0x08    8    
  13189	:  0100_0001  0x41   65  A  
  13190	:  0010_1101  0x2D   45  -  
  13191	:  0011_0101  0x35   53  5  
  13192	:  0011_0010  0x32   50  2  
  13193	:  0010_1101  0x2D   45  -  
  13194	:  0011_0000  0x30   48  0  
  13195	:  0011_0001  0x31   49  1  
  13196	:  0011_0010  0x32   50  2  
  13197	:  1100_0000  0xC0  192    
  13198	:  0000_1100  0x0C   12    
  13199	:  0000_0000  0x00    0    
  13200	:  0000_0001  0x01    1    
  13201	:  0000_0000  0x00    0    
  13202	:  0000_0001  0x01    1    
  13203	:  0000_0000  0x00    0    
  13204	:  0000_0000  0x00    0    
  13205	:  0010_1010  0x2A   42  *  
  13206	:  0011_0000  0x30   48  0  
  13207	:  0000_0000  0x00    0    
  13208	:  0000_0100  0x04    4    
  13209	:  0010_1101  0x2D   45  -  
  13210	:  0100_0011  0x43   67  C  
  13211	:  0011_0100  0x34   52  4  
  13212	:  0000_1100  0x0C   12    
  13213	:  0000_1000  0x08    8    
  13214	:  0100_0001  0x41   65  A  
  13215	:  0010_1101  0x2D   45  -  
  13216	:  0011_0101  0x35   53  5  
  13217	:  0011_0010  0x32   50  2  
  13218	:  0010_1101  0x2D   45  -  
  13219	:  0011_0000  0x30   48  0  
  13220	:  0011_0001  0x31   49  1  
  13221	:  0011_0011  0x33   51  3  
  13222	:  1100_0000  0xC0  192    
  13223	:  0000_1100  0x0C   12    
  13224	:  0000_0000  0x00    0    
  13225	:  0000_0001  0x01    1    
  13226	:  0000_0000  0x00    0    
  13227	:  0000_0001  0x01    1    
  13228	:  0000_0000  0x00    0    
  13229	:  0000_0000  0x00    0    
  13230	:  0010_1010  0x2A   42  *  
  13231	:  0011_0000  0x30   48  0  
  13232	:  0000_0000  0x00    0    
  13233	:  0000_0100  0x04    4    
  13234	:  0010_1101  0x2D   45  -  
  13235	:  0100_0011  0x43   67  C  
  13236	:  0011_0100  0x34   52  4  
  13237	:  0000_1101  0x0D   13    
  13238	:  0000_1000  0x08    8    
  13239	:  0100_0001  0x41   65  A  
  13240	:  0010_1101  0x2D   45  -  
  13241	:  0011_0101  0x35   53  5  
  13242	:  0011_0010  0x32   50  2  
  13243	:  0010_1101  0x2D   45  -  
  13244	:  0011_0000  0x30   48  0  
  13245	:  0011_0001  0x31   49  1  
  13246	:  0011_0100  0x34   52  4  
  13247	:  1100_0000  0xC0  192    
  13248	:  0000_1100  0x0C   12    
  13249	:  0000_0000  0x00    0    
  13250	:  0000_0001  0x01    1    
  13251	:  0000_0000  0x00    0    
  13252	:  0000_0001  0x01    1    
  13253	:  0000_0000  0x00    0    
  13254	:  0000_0000  0x00    0    
  13255	:  0010_1010  0x2A   42  *  
  13256	:  0011_0000  0x30   48  0  
  13257	:  0000_0000  0x00    0    
  13258	:  0000_0100  0x04    4    
  13259	:  0010_1101  0x2D   45  -  
  13260	:  0100_0011  0x43   67  C  
  13261	:  0011_0100  0x34   52  4  
  13262	:  0000_1110  0x0E   14    
  13263	:  0000_1000  0x08    8    
  13264	:  0100_0001  0x41   65  A  
  13265	:  0010_1101  0x2D   45  -  
  13266	:  0011_0101  0x35   53  5  
  13267	:  0011_0010  0x32   50  2  
  13268	:  0010_1101  0x2D   45  -  
  13269	:  0011_0000  0x30   48  0  
  13270	:  0011_0001  0x31   49  1  
  13271	:  0011_0101  0x35   53  5  
  13272	:  1100_0000  0xC0  192    
  13273	:  0000_1100  0x0C   12    
  13274	:  0000_0000  0x00    0    
  13275	:  0000_0001  0x01    1    
  13276	:  0000_0000  0x00    0    
  13277	:  0000_0001  0x01    1    
  13278	:  0000_0000  0x00    0    
  13279	:  0000_0000  0x00    0    
  13280	:  0010_1010  0x2A   42  *  
  13281	:  0011_0000  0x30   48  0  
  13282	:  0000_0000  0x00    0    
  13283	:  0000_0100  0x04    4    
  13284	:  0010_1101  0x2D   45  -  
  13285	:  0100_0011  0x43   67  C  
  13286	:  0011_0100  0x34   52  4  
  13287	:  0000_1111  0x0F   15    
  13288	:  0000_1000  0x08    8    
  13289	:  0100_0001  0x41   65  A  
  13290	:  0010_1101  0x2D   45  -  
  13291	:  0011_0101  0x35   53  5  
  13292	:  0011_0010  0x32   50  2  
  13293	:  0010_1101  0x2D   45  -  
  13294	:  0011_0000  0x30   48  0  
  13295	:  0011_0001  0x31   49  1  
  13296	:  0011_0110  0x36   54  6  
  13297	:  1100_0000  0xC0  192    
  13298	:  0000_1100  0x0C   12    
  13299	:  0000_0000  0x00    0    
  13300	:  0000_0001  0x01    1    
  13301	:  0000_0000  0x00    0    
  13302	:  0000_0001  0x01    1    
  13303	:  0000_0000  0x00    0    
  13304	:  0000_0000  0x00    0    
  13305	:  0010_1010  0x2A   42  *  
  13306	:  0011_0000  0x30   48  0  
  13307	:  0000_0000  0x00    0    
  13308	:  0000_0100  0x04    4    
  13309	:  0010_1101  0x2D   45  -  
  13310	:  0100_0011  0x43   67  C  
  13311	:  0011_0100  0x34   52  4  
  13312	:  0001_0000  0x10   16    
  13313	:  0000_1000  0x08    8    
  13314	:  0100_0001  0x41   65  A  
  13315	:  0010_1101  0x2D   45  -  
  13316	:  0011_0101  0x35   53  5  
  13317	:  0011_0010  0x32   50  2  
  13318	:  0010_1101  0x2D   45  -  
  13319	:  0011_0000  0x30   48  0  
  13320	:  0011_0001  0x31   49  1  
  13321	:  0011_0111  0x37   55  7  
  13322	:  1100_0000  0xC0  192    
  13323	:  0000_1100  0x0C   12    
  13324	:  0000_0000  0x00    0    
  13325	:  0000_0001  0x01    1    
  13326	:  0000_0000  0x00    0    
  13327	:  0000_0001  0x01    1    
  13328	:  0000_0000  0x00    0    
  13329	:  0000_0000  0x00    0    
  13330	:  0010_1010  0x2A   42  *  
  13331	:  0011_0000  0x30   48  0  
  13332	:  0000_0000  0x00    0    
  13333	:  0000_0100  0x04    4    
  13334	:  0010_1101  0x2D   45  -  
  13335	:  0100_0011  0x43   67  C  
  13336	:  0011_0100  0x34   52  4  
  13337	:  0001_0001  0x11   17    
  13338	:  0000_1000  0x08    8    
  13339	:  0100_0001  0x41   65  A  
  13340	:  0010_1101  0x2D   45  -  
  13341	:  0011_0101  0x35   53  5  
  13342	:  0011_0010  0x32   50  2  
  13343	:  0010_1101  0x2D   45  -  
  13344	:  0011_0000  0x30   48  0  
  13345	:  0011_0001  0x31   49  1  
  13346	:  0011_1000  0x38   56  8  
  13347	:  1100_0000  0xC0  192    
  13348	:  0000_1100  0x0C   12    
  13349	:  0000_0000  0x00    0    
  13350	:  0000_0001  0x01    1    
  13351	:  0000_0000  0x00    0    
  13352	:  0000_0001  0x01    1    
  13353	:  0000_0000  0x00    0    
  13354	:  0000_0000  0x00    0    
  13355	:  0010_1010  0x2A   42  *  
  13356	:  0011_0000  0x30   48  0  
  13357	:  0000_0000  0x00    0    
  13358	:  0000_0100  0x04    4    
  13359	:  0010_1101  0x2D   45  -  
  13360	:  0100_0011  0x43   67  C  
  13361	:  0011_0100  0x34   52  4  
  13362	:  0001_0010  0x12   18    
  13363	:  0000_1000  0x08    8    
  13364	:  0100_0001  0x41   65  A  
  13365	:  0010_1101  0x2D   45  -  
  13366	:  0011_0101  0x35   53  5  
  13367	:  0011_0010  0x32   50  2  
  13368	:  0010_1101  0x2D   45  -  
  13369	:  0011_0000  0x30   48  0  
  13370	:  0011_0001  0x31   49  1  
  13371	:  0011_1001  0x39   57  9  
  13372	:  1100_0000  0xC0  192    
  13373	:  0000_1100  0x0C   12    
  13374	:  0000_0000  0x00    0    
  13375	:  0000_0001  0x01    1    
  13376	:  0000_0000  0x00    0    
  13377	:  0000_0001  0x01    1    
  13378	:  0000_0000  0x00    0    
  13379	:  0000_0000  0x00    0    
  13380	:  0010_1010  0x2A   42  *  
  13381	:  0011_0000  0x30   48  0  
  13382	:  0000_0000  0x00    0    
  13383	:  0000_0100  0x04    4    
  13384	:  0010_1101  0x2D   45  -  
  13385	:  0100_0011  0x43   67  C  
  13386	:  0011_0100  0x34   52  4  
  13387	:  0001_0011  0x13   19    
  13388	:  0000_1000  0x08    8    
  13389	:  0100_0001  0x41   65  A  
  13390	:  0010_1101  0x2D   45  -  
  13391	:  0011_0101  0x35   53  5  
  13392	:  0011_0010  0x32   50  2  
  13393	:  0010_1101  0x2D   45  -  
  13394	:  0011_0000  0x30   48  0  
  13395	:  0011_0010  0x32   50  2  
  13396	:  0011_0000  0x30   48  0  
  13397	:  1100_0000  0xC0  192    
  13398	:  0000_1100  0x0C   12    
  13399	:  0000_0000  0x00    0    
  13400	:  0000_0001  0x01    1    
  13401	:  0000_0000  0x00    0    
  13402	:  0000_0001  0x01    1    
  13403	:  0000_0000  0x00    0    
  13404	:  0000_0000  0x00    0    
  13405	:  0010_1010  0x2A   42  *  
  13406	:  0011_0000  0x30   48  0  
  13407	:  0000_0000  0x00    0    
  13408	:  0000_0100  0x04    4    
  13409	:  0010_1101  0x2D   45  -  
  13410	:  0100_0011  0x43   67  C  
  13411	:  0011_0100  0x34   52  4  
  13412	:  0001_0100  0x14   20    
  13413	:  0000_1000  0x08    8    
  13414	:  0100_0001  0x41   65  A  
  13415	:  0010_1101  0x2D   45  -  
  13416	:  0011_0101  0x35   53  5  
  13417	:  0011_0010  0x32   50  2  
  13418	:  0010_1101  0x2D   45  -  
  13419	:  0011_0000  0x30   48  0  
  13420	:  0011_0010  0x32   50  2  
  13421	:  0011_0001  0x31   49  1  
  13422	:  1100_0000  0xC0  192    
  13423	:  0000_1100  0x0C   12    
  13424	:  0000_0000  0x00    0    
  13425	:  0000_0001  0x01    1    
  13426	:  0000_0000  0x00    0    
  13427	:  0000_0001  0x01    1    
  13428	:  0000_0000  0x00    0    
  13429	:  0000_0000  0x00    0    
  13430	:  0010_1010  0x2A   42  *  
  13431	:  0011_0000  0x30   48  0  
  13432	:  0000_0000  0x00    0    
  13433	:  0000_0100  0x04    4    
  13434	:  0010_1101  0x2D   45  -  
  13435	:  0100_0011  0x43   67  C  
  13436	:  0011_0100  0x34   52  4  
  13437	:  0001_0101  0x15   21    
  13438	:  0000_1000  0x08    8    
  13439	:  0100_0001  0x41   65  A  
  13440	:  0010_1101  0x2D   45  -  
  13441	:  0011_0101  0x35   53  5  
  13442	:  0011_0010  0x32   50  2  
  13443	:  0010_1101  0x2D   45  -  
  13444	:  0011_0000  0x30   48  0  
  13445	:  0011_0010  0x32   50  2  
  13446	:  0011_0010  0x32   50  2  
  13447	:  1100_0000  0xC0  192    
  13448	:  0000_1100  0x0C   12    
  13449	:  0000_0000  0x00    0    
  13450	:  0000_0001  0x01    1    
  13451	:  0000_0000  0x00    0    
  13452	:  0000_0001  0x01    1    
  13453	:  0000_0000  0x00    0    
  13454	:  0000_0000  0x00    0    
  13455	:  0010_1010  0x2A   42  *  
  13456	:  0011_0000  0x30   48  0  
  13457	:  0000_0000  0x00    0    
  13458	:  0000_0100  0x04    4    
  13459	:  0010_1101  0x2D   45  -  
  13460	:  0100_0011  0x43   67  C  
  13461	:  0011_0100  0x34   52  4  
  13462	:  0001_0110  0x16   22    
  13463	:  0000_1000  0x08    8    
  13464	:  0100_0001  0x41   65  A  
  13465	:  0010_1101  0x2D   45  -  
  13466	:  0011_0101  0x35   53  5  
  13467	:  0011_0010  0x32   50  2  
  13468	:  0010_1101  0x2D   45  -  
  13469	:  0011_0000  0x30   48  0  
  13470	:  0011_0010  0x32   50  2  
  13471	:  0011_0011  0x33   51  3  
  13472	:  1100_0000  0xC0  192    
  13473	:  0000_1100  0x0C   12    
  13474	:  0000_0000  0x00    0    
  13475	:  0000_0001  0x01    1    
  13476	:  0000_0000  0x00    0    
  13477	:  0000_0001  0x01    1    
  13478	:  0000_0000  0x00    0    
  13479	:  0000_0000  0x00    0    
  13480	:  0010_1010  0x2A   42  *  
  13481	:  0011_0000  0x30   48  0  
  13482	:  0000_0000  0x00    0    
  13483	:  0000_0100  0x04    4    
  13484	:  0010_1101  0x2D   45  -  
  13485	:  0100_0011  0x43   67  C  
  13486	:  0011_0100  0x34   52  4  
  13487	:  0001_0111  0x17   23    
  13488	:  0000_1000  0x08    8    
  13489	:  0100_0001  0x41   65  A  
  13490	:  0010_1101  0x2D   45  -  
  13491	:  0011_0101  0x35   53  5  
  13492	:  0011_0010  0x32   50  2  
  13493	:  0010_1101  0x2D   45  -  
  13494	:  0011_0000  0x30   48  0  
  13495	:  0011_0010  0x32   50  2  
  13496	:  0011_0100  0x34   52  4  
  13497	:  1100_0000  0xC0  192    
  13498	:  0000_1100  0x0C   12    
  13499	:  0000_0000  0x00    0    
  13500	:  0000_0001  0x01    1    
  13501	:  0000_0000  0x00    0    
  13502	:  0000_0001  0x01    1    
  13503	:  0000_0000  0x00    0    
  13504	:  0000_0000  0x00    0    
  13505	:  0010_1010  0x2A   42  *  
  13506	:  0011_0000  0x30   48  0  
  13507	:  0000_0000  0x00    0    
  13508	:  0000_0100  0x04    4    
  13509	:  0010_1101  0x2D   45  -  
  13510	:  0100_0011  0x43   67  C  
  13511	:  0011_0100  0x34   52  4  
  13512	:  0001_1000  0x18   24    
  13513	:  0000_1000  0x08    8    
  13514	:  0100_0001  0x41   65  A  
  13515	:  0010_1101  0x2D   45  -  
  13516	:  0011_0101  0x35   53  5  
  13517	:  0011_0010  0x32   50  2  
  13518	:  0010_1101  0x2D   45  -  
  13519	:  0011_0000  0x30   48  0  
  13520	:  0011_0010  0x32   50  2  
  13521	:  0011_0101  0x35   53  5  
  13522	:  1100_0000  0xC0  192    
  13523	:  0000_1100  0x0C   12    
  13524	:  0000_0000  0x00    0    
  13525	:  0000_0001  0x01    1    
  13526	:  0000_0000  0x00    0    
  13527	:  0000_0001  0x01    1    
  13528	:  0000_0000  0x00    0    
  13529	:  0000_0000  0x00    0    
  13530	:  0010_1010  0x2A   42  *  
  13531	:  0011_0000  0x30   48  0  
  13532	:  0000_0000  0x00    0    
  13533	:  0000_0100  0x04    4    
  13534	:  0010_1101  0x2D   45  -  
  13535	:  0100_0011  0x43   67  C  
  13536	:  0011_0100  0x34   52  4  
  13537	:  0001_1001  0x19   25    
  13538	:  0000_1000  0x08    8    
  13539	:  0100_0001  0x41   65  A  
  13540	:  0010_1101  0x2D   45  -  
  13541	:  0011_0101  0x35   53  5  
  13542	:  0011_0010  0x32   50  2  
  13543	:  0010_1101  0x2D   45  -  
  13544	:  0011_0000  0x30   48  0  
  13545	:  0011_0010  0x32   50  2  
  13546	:  0011_0110  0x36   54  6  
  13547	:  1100_0000  0xC0  192    
  13548	:  0000_1100  0x0C   12    
  13549	:  0000_0000  0x00    0    
  13550	:  0000_0001  0x01    1    
  13551	:  0000_0000  0x00    0    
  13552	:  0000_0001  0x01    1    
  13553	:  0000_0000  0x00    0    
  13554	:  0000_0000  0x00    0    
  13555	:  0010_1010  0x2A   42  *  
  13556	:  0011_0000  0x30   48  0  
  13557	:  0000_0000  0x00    0    
  13558	:  0000_0100  0x04    4    
  13559	:  0010_1101  0x2D   45  -  
  13560	:  0100_0011  0x43   67  C  
  13561	:  0011_0100  0x34   52  4  
  13562	:  0001_1010  0x1A   26    
  13563	:  0000_1000  0x08    8    
  13564	:  0100_0001  0x41   65  A  
  13565	:  0010_1101  0x2D   45  -  
  13566	:  0011_0101  0x35   53  5  
  13567	:  0011_0010  0x32   50  2  
  13568	:  0010_1101  0x2D   45  -  
  13569	:  0011_0000  0x30   48  0  
  13570	:  0011_0010  0x32   50  2  
  13571	:  0011_0111  0x37   55  7  
  13572	:  1100_0000  0xC0  192    
  13573	:  0000_1100  0x0C   12    
  13574	:  0000_0000  0x00    0    
  13575	:  0000_0001  0x01    1    
  13576	:  0000_0000  0x00    0    
  13577	:  0000_0001  0x01    1    
  13578	:  0000_0000  0x00    0    
  13579	:  0000_0000  0x00    0    
  13580	:  0010_1010  0x2A   42  *  
  13581	:  0011_0000  0x30   48  0  
  13582	:  0000_0000  0x00    0    
  13583	:  0000_0100  0x04    4    
  13584	:  0010_1101  0x2D   45  -  
  13585	:  0100_0011  0x43   67  C  
  13586	:  0011_0100  0x34   52  4  
  13587	:  0001_1011  0x1B   27    
  13588	:  0000_1000  0x08    8    
  13589	:  0100_0001  0x41   65  A  
  13590	:  0010_1101  0x2D   45  -  
  13591	:  0011_0101  0x35   53  5  
  13592	:  0011_0010  0x32   50  2  
  13593	:  0010_1101  0x2D   45  -  
  13594	:  0011_0000  0x30   48  0  
  13595	:  0011_0010  0x32   50  2  
  13596	:  0011_1000  0x38   56  8  
  13597	:  1100_0000  0xC0  192    
  13598	:  0000_1100  0x0C   12    
  13599	:  0000_0000  0x00    0    
  13600	:  0000_0001  0x01    1    
  13601	:  0000_0000  0x00    0    
  13602	:  0000_0001  0x01    1    
  13603	:  0000_0000  0x00    0    
  13604	:  0000_0000  0x00    0    
  13605	:  0010_1010  0x2A   42  *  
  13606	:  0011_0000  0x30   48  0  
  13607	:  0000_0000  0x00    0    
  13608	:  0000_0100  0x04    4    
  13609	:  0010_1101  0x2D   45  -  
  13610	:  0100_0011  0x43   67  C  
  13611	:  0011_0100  0x34   52  4  
  13612	:  0001_1100  0x1C   28    
  13613	:  0000_1000  0x08    8    
  13614	:  0100_0001  0x41   65  A  
  13615	:  0010_1101  0x2D   45  -  
  13616	:  0011_0101  0x35   53  5  
  13617	:  0011_0010  0x32   50  2  
  13618	:  0010_1101  0x2D   45  -  
  13619	:  0011_0000  0x30   48  0  
  13620	:  0011_0010  0x32   50  2  
  13621	:  0011_1001  0x39   57  9  
  13622	:  1100_0000  0xC0  192    
  13623	:  0000_1100  0x0C   12    
  13624	:  0000_0000  0x00    0    
  13625	:  0000_0001  0x01    1    
  13626	:  0000_0000  0x00    0    
  13627	:  0000_0001  0x01    1    
  13628	:  0000_0000  0x00    0    
  13629	:  0000_0000  0x00    0    
  13630	:  0010_1010  0x2A   42  *  
  13631	:  0011_0000  0x30   48  0  
  13632	:  0000_0000  0x00    0    
  13633	:  0000_0100  0x04    4    
  13634	:  0010_1101  0x2D   45  -  
  13635	:  0100_0011  0x43   67  C  
  13636	:  0011_0100  0x34   52  4  
  13637	:  0001_1101  0x1D   29    
  13638	:  0000_1000  0x08    8    
  13639	:  0100_0001  0x41   65  A  
  13640	:  0010_1101  0x2D   45  -  
  13641	:  0011_0101  0x35   53  5  
  13642	:  0011_0010  0x32   50  2  
  13643	:  0010_1101  0x2D   45  -  
  13644	:  0011_0000  0x30   48  0  
  13645	:  0011_0011  0x33   51  3  
  13646	:  0011_0000  0x30   48  0  
  13647	:  1100_0000  0xC0  192    
  13648	:  0000_1100  0x0C   12    
  13649	:  0000_0000  0x00    0    
  13650	:  0000_0001  0x01    1    
  13651	:  0000_0000  0x00    0    
  13652	:  0000_0001  0x01    1    
  13653	:  0000_0000  0x00    0    
  13654	:  0000_0000  0x00    0    
  13655	:  0010_1010  0x2A   42  *  
  13656	:  0011_0000  0x30   48  0  
  13657	:  0000_0000  0x00    0    
  13658	:  0000_0100  0x04    4    
  13659	:  0010_1101  0x2D   45  -  
  13660	:  0100_0011  0x43   67  C  
  13661	:  0011_0100  0x34   52  4  
  13662	:  0001_1110  0x1E   30    
  13663	:  0000_1000  0x08    8    
  13664	:  0100_0001  0x41   65  A  
  13665	:  0010_1101  0x2D   45  -  
  13666	:  0011_0101  0x35   53  5  
  13667	:  0011_0010  0x32   50  2  
  13668	:  0010_1101  0x2D   45  -  
  13669	:  0011_0000  0x30   48  0  
  13670	:  0011_0011  0x33   51  3  
  13671	:  0011_0001  0x31   49  1  
  13672	:  1100_0000  0xC0  192    
  13673	:  0000_1100  0x0C   12    
  13674	:  0000_0000  0x00    0    
  13675	:  0000_0001  0x01    1    
  13676	:  0000_0000  0x00    0    
  13677	:  0000_0001  0x01    1    
  13678	:  0000_0000  0x00    0    
  13679	:  0000_0000  0x00    0    
  13680	:  0010_1010  0x2A   42  *  
  13681	:  0011_0000  0x30   48  0  
  13682	:  0000_0000  0x00    0    
  13683	:  0000_0100  0x04    4    
  13684	:  0010_1101  0x2D   45  -  
  13685	:  0100_0011  0x43   67  C  
  13686	:  0011_0100  0x34   52  4  
  13687	:  0001_1111  0x1F   31    
  13688	:  0000_1000  0x08    8    
  13689	:  0100_0001  0x41   65  A  
  13690	:  0010_1101  0x2D   45  -  
  13691	:  0011_0101  0x35   53  5  
  13692	:  0011_0010  0x32   50  2  
  13693	:  0010_1101  0x2D   45  -  
  13694	:  0011_0000  0x30   48  0  
  13695	:  0011_0011  0x33   51  3  
  13696	:  0011_0010  0x32   50  2  
  13697	:  1100_0000  0xC0  192    
  13698	:  0000_1100  0x0C   12    
  13699	:  0000_0000  0x00    0    
  13700	:  0000_0001  0x01    1    
  13701	:  0000_0000  0x00    0    
  13702	:  0000_0001  0x01    1    
  13703	:  0000_0000  0x00    0    
  13704	:  0000_0000  0x00    0    
  13705	:  0010_1010  0x2A   42  *  
  13706	:  0011_0000  0x30   48  0  
  13707	:  0000_0000  0x00    0    
  13708	:  0000_0100  0x04    4    
  13709	:  0010_1101  0x2D   45  -  
  13710	:  0100_0011  0x43   67  C  
  13711	:  0011_0100  0x34   52  4  
  13712	:  0010_0000  0x20   32     
  13713	:  0000_1000  0x08    8    
  13714	:  0100_0001  0x41   65  A  
  13715	:  0010_1101  0x2D   45  -  
  13716	:  0011_0101  0x35   53  5  
  13717	:  0011_0010  0x32   50  2  
  13718	:  0010_1101  0x2D   45  -  
  13719	:  0011_0000  0x30   48  0  
  13720	:  0011_0011  0x33   51  3  
  13721	:  0011_0011  0x33   51  3  
  13722	:  1100_0000  0xC0  192    
  13723	:  0000_1100  0x0C   12    
  13724	:  0000_0000  0x00    0    
  13725	:  0000_0001  0x01    1    
  13726	:  0000_0000  0x00    0    
  13727	:  0000_0001  0x01    1    
  13728	:  0000_0000  0x00    0    
  13729	:  0000_0000  0x00    0    
  13730	:  0010_1010  0x2A   42  *  
  13731	:  0011_0000  0x30   48  0  
  13732	:  0000_0000  0x00    0    
  13733	:  0000_0100  0x04    4    
  13734	:  0010_1101  0x2D   45  -  
  13735	:  0100_0011  0x43   67  C  
  13736	:  0011_0100  0x34   52  4  
  13737	:  0010_0001  0x21   33  !  
  13738	:  0000_1000  0x08    8    
  13739	:  0100_0001  0x41   65  A  
  13740	:  0010_1101  0x2D   45  -  
  13741	:  0011_0101  0x35   53  5  
  13742	:  0011_0010  0x32   50  2  
  13743	:  0010_1101  0x2D   45  -  
  13744	:  0011_0000  0x30   48  0  
  13745	:  0011_0011  0x33   51  3  
  13746	:  0011_0100  0x34   52  4  
  13747	:  1100_0000  0xC0  192    
  13748	:  0000_1100  0x0C   12    
  13749	:  0000_0000  0x00    0    
  13750	:  0000_0001  0x01    1    
  13751	:  0000_0000  0x00    0    
  13752	:  0000_0001  0x01    1    
  13753	:  0000_0000  0x00    0    
  13754	:  0000_0000  0x00    0    
  13755	:  0010_1010  0x2A   42  *  
  13756	:  0011_0000  0x30   48  0  
  13757	:  0000_0000  0x00    0    
  13758	:  0000_0100  0x04    4    
  13759	:  0010_1101  0x2D   45  -  
  13760	:  0100_0011  0x43   67  C  
  13761	:  0011_0100  0x34   52  4  
  13762	:  0010_0010  0x22   34  "  
  13763	:  0000_1000  0x08    8    
  13764	:  0100_0001  0x41   65  A  
  13765	:  0010_1101  0x2D   45  -  
  13766	:  0011_0101  0x35   53  5  
  13767	:  0011_0010  0x32   50  2  
  13768	:  0010_1101  0x2D   45  -  
  13769	:  0011_0000  0x30   48  0  
  13770	:  0011_0011  0x33   51  3  
  13771	:  0011_0101  0x35   53  5  
  13772	:  1100_0000  0xC0  192    
  13773	:  0000_1100  0x0C   12    
  13774	:  0000_0000  0x00    0    
  13775	:  0000_0001  0x01    1    
  13776	:  0000_0000  0x00    0    
  13777	:  0000_0001  0x01    1    
  13778	:  0000_0000  0x00    0    
  13779	:  0000_0000  0x00    0    
  13780	:  0010_1010  0x2A   42  *  
  13781	:  0011_0000  0x30   48  0  
  13782	:  0000_0000  0x00    0    
  13783	:  0000_0100  0x04    4    
  13784	:  0010_1101  0x2D   45  -  
  13785	:  0100_0011  0x43   67  C  
  13786	:  0011_0100  0x34   52  4  
  13787	:  0010_0011  0x23   35  #  
  13788	:  0000_1000  0x08    8    
  13789	:  0100_0001  0x41   65  A  
  13790	:  0010_1101  0x2D   45  -  
  13791	:  0011_0101  0x35   53  5  
  13792	:  0011_0010  0x32   50  2  
  13793	:  0010_1101  0x2D   45  -  
  13794	:  0011_0000  0x30   48  0  
  13795	:  0011_0011  0x33   51  3  
  13796	:  0011_0110  0x36   54  6  
  13797	:  1100_0000  0xC0  192    
  13798	:  0000_1100  0x0C   12    
  13799	:  0000_0000  0x00    0    
  13800	:  0000_0001  0x01    1    
  13801	:  0000_0000  0x00    0    
  13802	:  0000_0001  0x01    1    
  13803	:  0000_0000  0x00    0    
  13804	:  0000_0000  0x00    0    
  13805	:  0010_1010  0x2A   42  *  
  13806	:  0011_0000  0x30   48  0  
  13807	:  0000_0000  0x00    0    
  13808	:  0000_0100  0x04    4    
  13809	:  0010_1101  0x2D   45  -  
  13810	:  0100_0011  0x43   67  C  
  13811	:  0011_0100  0x34   52  4  
  13812	:  0010_0100  0x24   36  $  
  13813	:  0000_1000  0x08    8    
  13814	:  0100_0001  0x41   65  A  
  13815	:  0010_1101  0x2D   45  -  
  13816	:  0011_0101  0x35   53  5  
  13817	:  0011_0010  0x32   50  2  
  13818	:  0010_1101  0x2D   45  -  
  13819	:  0011_0000  0x30   48  0  
  13820	:  0011_0011  0x33   51  3  
  13821	:  0011_0111  0x37   55  7  
  13822	:  1100_0000  0xC0  192    
  13823	:  0000_1100  0x0C   12    
  13824	:  0000_0000  0x00    0    
  13825	:  0000_0001  0x01    1    
  13826	:  0000_0000  0x00    0    
  13827	:  0000_0001  0x01    1    
  13828	:  0000_0000  0x00    0    
  13829	:  0000_0000  0x00    0    
  13830	:  0010_1010  0x2A   42  *  
  13831	:  0011_0000  0x30   48  0  
  13832	:  0000_0000  0x00    0    
  13833	:  0000_0100  0x04    4    
  13834	:  0010_1101  0x2D   45  -  
  13835	:  0100_0011  0x43   67  C  
  13836	:  0011_0100  0x34   52  4  
  13837	:  0010_0101  0x25   37  %  
  13838	:  0000_1000  0x08    8    
  13839	:  0100_0001  0x41   65  A  
  13840	:  0010_1101  0x2D   45  -  
  13841	:  0011_0101  0x35   53  5  
  13842	:  0011_0010  0x32   50  2  
  13843	:  0010_1101  0x2D   45  -  
  13844	:  0011_0000  0x30   48  0  
  13845	:  0011_0011  0x33   51  3  
  13846	:  0011_1000  0x38   56  8  
  13847	:  1100_0000  0xC0  192    
  13848	:  0000_1100  0x0C   12    
  13849	:  0000_0000  0x00    0    
  13850	:  0000_0001  0x01    1    
  13851	:  0000_0000  0x00    0    
  13852	:  0000_0001  0x01    1    
  13853	:  0000_0000  0x00    0    
  13854	:  0000_0000  0x00    0    
  13855	:  0010_1010  0x2A   42  *  
  13856	:  0011_0000  0x30   48  0  
  13857	:  0000_0000  0x00    0    
  13858	:  0000_0100  0x04    4    
  13859	:  0010_1101  0x2D   45  -  
  13860	:  0100_0011  0x43   67  C  
  13861	:  0011_0100  0x34   52  4  
  13862	:  0010_0110  0x26   38  &  
  13863	:  0000_1000  0x08    8    
  13864	:  0100_0001  0x41   65  A  
  13865	:  0010_1101  0x2D   45  -  
  13866	:  0011_0101  0x35   53  5  
  13867	:  0011_0010  0x32   50  2  
  13868	:  0010_1101  0x2D   45  -  
  13869	:  0011_0000  0x30   48  0  
  13870	:  0011_0011  0x33   51  3  
  13871	:  0011_1001  0x39   57  9  
  13872	:  1100_0000  0xC0  192    
  13873	:  0000_1100  0x0C   12    
  13874	:  0000_0000  0x00    0    
  13875	:  0000_0001  0x01    1    
  13876	:  0000_0000  0x00    0    
  13877	:  0000_0001  0x01    1    
  13878	:  0000_0000  0x00    0    
  13879	:  0000_0000  0x00    0    
  13880	:  0010_1010  0x2A   42  *  
  13881	:  0011_0000  0x30   48  0  
  13882	:  0000_0000  0x00    0    
  13883	:  0000_0100  0x04    4    
  13884	:  0010_1101  0x2D   45  -  
  13885	:  0100_0011  0x43   67  C  
  13886	:  0011_0100  0x34   52  4  
  13887	:  0010_0111  0x27   39  '  
  13888	:  0000_1000  0x08    8    
  13889	:  0100_0001  0x41   65  A  
  13890	:  0010_1101  0x2D   45  -  
  13891	:  0011_0101  0x35   53  5  
  13892	:  0011_0010  0x32   50  2  
  13893	:  0010_1101  0x2D   45  -  
  13894	:  0011_0000  0x30   48  0  
  13895	:  0011_0100  0x34   52  4  
  13896	:  0011_0000  0x30   48  0  
  13897	:  1100_0000  0xC0  192    
  13898	:  0000_1100  0x0C   12    
  13899	:  0000_0000  0x00    0    
  13900	:  0000_0001  0x01    1    
  13901	:  0000_0000  0x00    0    
  13902	:  0000_0001  0x01    1    
  13903	:  0000_0000  0x00    0    
  13904	:  0000_0000  0x00    0    
  13905	:  0010_1010  0x2A   42  *  
  13906	:  0011_0000  0x30   48  0  
  13907	:  0000_0000  0x00    0    
  13908	:  0000_0100  0x04    4    
  13909	:  0010_1101  0x2D   45  -  
  13910	:  0100_0011  0x43   67  C  
  13911	:  0011_0100  0x34   52  4  
  13912	:  0010_1000  0x28   40  (  
  13913	:  0000_1000  0x08    8    
  13914	:  0100_0001  0x41   65  A  
  13915	:  0010_1101  0x2D   45  -  
  13916	:  0011_0101  0x35   53  5  
  13917	:  0011_0010  0x32   50  2  
  13918	:  0010_1101  0x2D   45  -  
  13919	:  0011_0000  0x30   48  0  
  13920	:  0011_0100  0x34   52  4  
  13921	:  0011_0001  0x31   49  1  
  13922	:  1100_0000  0xC0  192    
  13923	:  0000_1100  0x0C   12    
  13924	:  0000_0000  0x00    0    
  13925	:  0000_0001  0x01    1    
  13926	:  0000_0000  0x00    0    
  13927	:  0000_0001  0x01    1    
  13928	:  0000_0000  0x00    0    
  13929	:  0000_0000  0x00    0    
  13930	:  0010_1010  0x2A   42  *  
  13931	:  0011_0000  0x30   48  0  
  13932	:  0000_0000  0x00    0    
  13933	:  0000_0100  0x04    4    
  13934	:  0010_1101  0x2D   45  -  
  13935	:  0100_0011  0x43   67  C  
  13936	:  0011_0100  0x34   52  4  
  13937	:  0010_1001  0x29   41  )  
  13938	:  0000_1000  0x08    8    
  13939	:  0100_0001  0x41   65  A  
  13940	:  0010_1101  0x2D   45  -  
  13941	:  0011_0101  0x35   53  5  
  13942	:  0011_0010  0x32   50  2  
  13943	:  0010_1101  0x2D   45  -  
  13944	:  0011_0000  0x30   48  0  
  13945	:  0011_0100  0x34   52  4  
  13946	:  0011_0010  0x32   50  2  
  13947	:  1100_0000  0xC0  192    
  13948	:  0000_1100  0x0C   12    
  13949	:  0000_0000  0x00    0    
  13950	:  0000_0001  0x01    1    
  13951	:  0000_0000  0x00    0    
  13952	:  0000_0001  0x01    1    
  13953	:  0000_0000  0x00    0    
  13954	:  0000_0000  0x00    0    
  13955	:  0010_1010  0x2A   42  *  
  13956	:  0011_0000  0x30   48  0  
  13957	:  0000_0000  0x00    0    
  13958	:  0000_0100  0x04    4    
  13959	:  0010_1101  0x2D   45  -  
  13960	:  0100_0011  0x43   67  C  
  13961	:  0011_0100  0x34   52  4  
  13962	:  0010_1010  0x2A   42  *  
  13963	:  0000_1000  0x08    8    
  13964	:  0100_0001  0x41   65  A  
  13965	:  0010_1101  0x2D   45  -  
  13966	:  0011_0101  0x35   53  5  
  13967	:  0011_0010  0x32   50  2  
  13968	:  0010_1101  0x2D   45  -  
  13969	:  0011_0000  0x30   48  0  
  13970	:  0011_0100  0x34   52  4  
  13971	:  0011_0011  0x33   51  3  
  13972	:  1100_0000  0xC0  192    
  13973	:  0000_1100  0x0C   12    
  13974	:  0000_0000  0x00    0    
  13975	:  0000_0001  0x01    1    
  13976	:  0000_0000  0x00    0    
  13977	:  0000_0001  0x01    1    
  13978	:  0000_0000  0x00    0    
  13979	:  0000_0000  0x00    0    
  13980	:  0010_1010  0x2A   42  *  
  13981	:  0011_0000  0x30   48  0  
  13982	:  0000_0000  0x00    0    
  13983	:  0000_0100  0x04    4    
  13984	:  0010_1101  0x2D   45  -  
  13985	:  0100_0011  0x43   67  C  
  13986	:  0011_0100  0x34   52  4  
  13987	:  0010_1011  0x2B   43  +  
  13988	:  0000_1000  0x08    8    
  13989	:  0100_0001  0x41   65  A  
  13990	:  0010_1101  0x2D   45  -  
  13991	:  0011_0101  0x35   53  5  
  13992	:  0011_0010  0x32   50  2  
  13993	:  0010_1101  0x2D   45  -  
  13994	:  0011_0000  0x30   48  0  
  13995	:  0011_0100  0x34   52  4  
  13996	:  0011_0100  0x34   52  4  
  13997	:  1100_0000  0xC0  192    
  13998	:  0000_1100  0x0C   12    
  13999	:  0000_0000  0x00    0    
  14000	:  0000_0001  0x01    1    
  14001	:  0000_0000  0x00    0    
  14002	:  0000_0001  0x01    1    
  14003	:  0000_0000  0x00    0    
  14004	:  0000_0000  0x00    0    
  14005	:  0010_1010  0x2A   42  *  
  14006	:  0011_0000  0x30   48  0  
  14007	:  0000_0000  0x00    0    
  14008	:  0000_0100  0x04    4    
  14009	:  0010_1101  0x2D   45  -  
  14010	:  0100_0011  0x43   67  C  
  14011	:  0011_0100  0x34   52  4  
  14012	:  0010_1100  0x2C   44  ,  
  14013	:  0000_1000  0x08    8    
  14014	:  0100_0001  0x41   65  A  
  14015	:  0010_1101  0x2D   45  -  
  14016	:  0011_0101  0x35   53  5  
  14017	:  0011_0010  0x32   50  2  
  14018	:  0010_1101  0x2D   45  -  
  14019	:  0011_0000  0x30   48  0  
  14020	:  0011_0100  0x34   52  4  
  14021	:  0011_0101  0x35   53  5  
  14022	:  1100_0000  0xC0  192    
  14023	:  0000_1100  0x0C   12    
  14024	:  0000_0000  0x00    0    
  14025	:  0000_0001  0x01    1    
  14026	:  0000_0000  0x00    0    
  14027	:  0000_0001  0x01    1    
  14028	:  0000_0000  0x00    0    
  14029	:  0000_0000  0x00    0    
  14030	:  0010_1010  0x2A   42  *  
  14031	:  0011_0000  0x30   48  0  
  14032	:  0000_0000  0x00    0    
  14033	:  0000_0100  0x04    4    
  14034	:  0010_1101  0x2D   45  -  
  14035	:  0100_0011  0x43   67  C  
  14036	:  0011_0100  0x34   52  4  
  14037	:  0010_1101  0x2D   45  -  
  14038	:  0000_1000  0x08    8    
  14039	:  0100_0001  0x41   65  A  
  14040	:  0010_1101  0x2D   45  -  
  14041	:  0011_0101  0x35   53  5  
  14042	:  0011_0010  0x32   50  2  
  14043	:  0010_1101  0x2D   45  -  
  14044	:  0011_0000  0x30   48  0  
  14045	:  0011_0100  0x34   52  4  
  14046	:  0011_0110  0x36   54  6  
  14047	:  1100_0000  0xC0  192    
  14048	:  0000_1100  0x0C   12    
  14049	:  0000_0000  0x00    0    
  14050	:  0000_0001  0x01    1    
  14051	:  0000_0000  0x00    0    
  14052	:  0000_0001  0x01    1    
  14053	:  0000_0000  0x00    0    
  14054	:  0000_0000  0x00    0    
  14055	:  0010_1010  0x2A   42  *  
  14056	:  0011_0000  0x30   48  0  
  14057	:  0000_0000  0x00    0    
  14058	:  0000_0100  0x04    4    
  14059	:  0010_1101  0x2D   45  -  
  14060	:  0100_0011  0x43   67  C  
  14061	:  0011_0100  0x34   52  4  
  14062	:  0010_1110  0x2E   46  .  
  14063	:  0000_1000  0x08    8    
  14064	:  0100_0001  0x41   65  A  
  14065	:  0010_1101  0x2D   45  -  
  14066	:  0011_0101  0x35   53  5  
  14067	:  0011_0010  0x32   50  2  
  14068	:  0010_1101  0x2D   45  -  
  14069	:  0011_0000  0x30   48  0  
  14070	:  0011_0100  0x34   52  4  
  14071	:  0011_0111  0x37   55  7  
  14072	:  1100_0000  0xC0  192    
  14073	:  0000_1100  0x0C   12    
  14074	:  0000_0000  0x00    0    
  14075	:  0000_0001  0x01    1    
  14076	:  0000_0000  0x00    0    
  14077	:  0000_0001  0x01    1    
  14078	:  0000_0000  0x00    0    
  14079	:  0000_0000  0x00    0    
  14080	:  0010_1010  0x2A   42  *  
  14081	:  0011_0000  0x30   48  0  
  14082	:  0000_0000  0x00    0    
  14083	:  0000_0100  0x04    4    
  14084	:  0010_1101  0x2D   45  -  
  14085	:  0100_0011  0x43   67  C  
  14086	:  0011_0100  0x34   52  4  
  14087	:  0010_1111  0x2F   47  /  
  14088	:  0000_1000  0x08    8    
  14089	:  0100_0001  0x41   65  A  
  14090	:  0010_1101  0x2D   45  -  
  14091	:  0011_0101  0x35   53  5  
  14092	:  0011_0010  0x32   50  2  
  14093	:  0010_1101  0x2D   45  -  
  14094	:  0011_0000  0x30   48  0  
  14095	:  0011_0100  0x34   52  4  
  14096	:  0011_1000  0x38   56  8  
  14097	:  1100_0000  0xC0  192    
  14098	:  0000_1100  0x0C   12    
  14099	:  0000_0000  0x00    0    
  14100	:  0000_0001  0x01    1    
  14101	:  0000_0000  0x00    0    
  14102	:  0000_0001  0x01    1    
  14103	:  0000_0000  0x00    0    
  14104	:  0000_0000  0x00    0    
  14105	:  0010_1010  0x2A   42  *  
  14106	:  0011_0000  0x30   48  0  
  14107	:  0000_0000  0x00    0    
  14108	:  0000_0100  0x04    4    
  14109	:  0010_1101  0x2D   45  -  
  14110	:  0100_0011  0x43   67  C  
  14111	:  0011_0100  0x34   52  4  
  14112	:  0011_0000  0x30   48  0  
  14113	:  0000_1000  0x08    8    
  14114	:  0100_0001  0x41   65  A  
  14115	:  0010_1101  0x2D   45  -  
  14116	:  0011_0101  0x35   53  5  
  14117	:  0011_0010  0x32   50  2  
  14118	:  0010_1101  0x2D   45  -  
  14119	:  0011_0000  0x30   48  0  
  14120	:  0011_0100  0x34   52  4  
  14121	:  0011_1001  0x39   57  9  
  14122	:  1100_0000  0xC0  192    
  14123	:  0000_1100  0x0C   12    
  14124	:  0000_0000  0x00    0    
  14125	:  0000_0001  0x01    1    
  14126	:  0000_0000  0x00    0    
  14127	:  0000_0001  0x01    1    
  14128	:  0000_0000  0x00    0    
  14129	:  0000_0000  0x00    0    
  14130	:  0010_1010  0x2A   42  *  
  14131	:  0011_0000  0x30   48  0  
  14132	:  0000_0000  0x00    0    
  14133	:  0000_0100  0x04    4    
  14134	:  0010_1101  0x2D   45  -  
  14135	:  0100_0011  0x43   67  C  
  14136	:  0011_0100  0x34   52  4  
  14137	:  0011_0001  0x31   49  1  
  14138	:  0000_1000  0x08    8    
  14139	:  0100_0001  0x41   65  A  
  14140	:  0010_1101  0x2D   45  -  
  14141	:  0011_0101  0x35   53  5  
  14142	:  0011_0010  0x32   50  2  
  14143	:  0010_1101  0x2D   45  -  
  14144	:  0011_0000  0x30   48  0  
  14145	:  0011_0101  0x35   53  5  
  14146	:  0011_0000  0x30   48  0  
  14147	:  1100_0000  0xC0  192    
  14148	:  0000_1100  0x0C   12    
  14149	:  0000_0000  0x00    0    
  14150	:  0000_0001  0x01    1    
  14151	:  0000_0000  0x00    0    
  14152	:  0000_0001  0x01    1    
  14153	:  0000_0000  0x00    0    
  14154	:  0000_0000  0x00    0    
  14155	:  0010_1010  0x2A   42  *  
  14156	:  0011_0000  0x30   48  0  
  14157	:  0000_0000  0x00    0    
  14158	:  0000_0100  0x04    4    
  14159	:  0010_1101  0x2D   45  -  
  14160	:  0100_0011  0x43   67  C  
  14161	:  0011_0100  0x34   52  4  
  14162	:  0011_0010  0x32   50  2  
  14163	:  0000_1000  0x08    8    
  14164	:  0100_0001  0x41   65  A  
  14165	:  0010_1101  0x2D   45  -  
  14166	:  0011_0101  0x35   53  5  
  14167	:  0011_0010  0x32   50  2  
  14168	:  0010_1101  0x2D   45  -  
  14169	:  0011_0000  0x30   48  0  
  14170	:  0011_0101  0x35   53  5  
  14171	:  0011_0001  0x31   49  1  
  14172	:  1100_0000  0xC0  192    
  14173	:  0000_1100  0x0C   12    
  14174	:  0000_0000  0x00    0    
  14175	:  0000_0001  0x01    1    
  14176	:  0000_0000  0x00    0    
  14177	:  0000_0001  0x01    1    
  14178	:  0000_0000  0x00    0    
  14179	:  0000_0000  0x00    0    
  14180	:  0010_1010  0x2A   42  *  
  14181	:  0011_0000  0x30   48  0  
  14182	:  0000_0000  0x00    0    
  14183	:  0000_0100  0x04    4    
  14184	:  0010_1101  0x2D   45  -  
  14185	:  0100_0011  0x43   67  C  
  14186	:  0011_0100  0x34   52  4  
  14187	:  0011_0011  0x33   51  3  
  14188	:  0000_1000  0x08    8    
  14189	:  0100_0001  0x41   65  A  
  14190	:  0010_1101  0x2D   45  -  
  14191	:  0011_0101  0x35   53  5  
  14192	:  0011_0010  0x32   50  2  
  14193	:  0010_1101  0x2D   45  -  
  14194	:  0011_0000  0x30   48  0  
  14195	:  0011_0101  0x35   53  5  
  14196	:  0011_0010  0x32   50  2  
  14197	:  1100_0000  0xC0  192    
  14198	:  0000_1100  0x0C   12    
  14199	:  0000_0000  0x00    0    
  14200	:  0000_0001  0x01    1    
  14201	:  0000_0000  0x00    0    
  14202	:  0000_0001  0x01    1    
  14203	:  0000_0000  0x00    0    
  14204	:  0000_0000  0x00    0    
  14205	:  0010_1010  0x2A   42  *  
  14206	:  0011_0000  0x30   48  0  
  14207	:  0000_0000  0x00    0    
  14208	:  0000_0100  0x04    4    
  14209	:  0010_1101  0x2D   45  -  
  14210	:  0100_0011  0x43   67  C  
  14211	:  0011_0100  0x34   52  4  
  14212	:  0011_0100  0x34   52  4  
  14213	:  0000_1000  0x08    8    
  14214	:  0100_0001  0x41   65  A  
  14215	:  0010_1101  0x2D   45  -  
  14216	:  0011_0101  0x35   53  5  
  14217	:  0011_0010  0x32   50  2  
  14218	:  0010_1101  0x2D   45  -  
  14219	:  0011_0000  0x30   48  0  
  14220	:  0011_0101  0x35   53  5  
  14221	:  0011_0011  0x33   51  3  
  14222	:  1100_0000  0xC0  192    
  14223	:  0000_1100  0x0C   12    
  14224	:  0000_0000  0x00    0    
  14225	:  0000_0001  0x01    1    
  14226	:  0000_0000  0x00    0    
  14227	:  0000_0001  0x01    1    
  14228	:  0000_0000  0x00    0    
  14229	:  0000_0000  0x00    0    
  14230	:  0010_1010  0x2A   42  *  
  14231	:  0011_0000  0x30   48  0  
  14232	:  0000_0000  0x00    0    
  14233	:  0000_0100  0x04    4    
  14234	:  0010_1101  0x2D   45  -  
  14235	:  0100_0011  0x43   67  C  
  14236	:  0011_0100  0x34   52  4  
  14237	:  0011_0101  0x35   53  5  
  14238	:  0000_1000  0x08    8    
  14239	:  0100_0001  0x41   65  A  
  14240	:  0010_1101  0x2D   45  -  
  14241	:  0011_0101  0x35   53  5  
  14242	:  0011_0010  0x32   50  2  
  14243	:  0010_1101  0x2D   45  -  
  14244	:  0011_0000  0x30   48  0  
  14245	:  0011_0101  0x35   53  5  
  14246	:  0011_0100  0x34   52  4  
  14247	:  1100_0000  0xC0  192    
  14248	:  0000_1100  0x0C   12    
  14249	:  0000_0000  0x00    0    
  14250	:  0000_0001  0x01    1    
  14251	:  0000_0000  0x00    0    
  14252	:  0000_0001  0x01    1    
  14253	:  0000_0000  0x00    0    
  14254	:  0000_0000  0x00    0    
  14255	:  0010_1010  0x2A   42  *  
  14256	:  0011_0000  0x30   48  0  
  14257	:  0000_0000  0x00    0    
  14258	:  0000_0100  0x04    4    
  14259	:  0010_1101  0x2D   45  -  
  14260	:  0100_0011  0x43   67  C  
  14261	:  0011_0100  0x34   52  4  
  14262	:  0011_0110  0x36   54  6  
  14263	:  0000_1000  0x08    8    
  14264	:  0100_0001  0x41   65  A  
  14265	:  0010_1101  0x2D   45  -  
  14266	:  0011_0101  0x35   53  5  
  14267	:  0011_0010  0x32   50  2  
  14268	:  0010_1101  0x2D   45  -  
  14269	:  0011_0000  0x30   48  0  
  14270	:  0011_0101  0x35   53  5  
  14271	:  0011_0101  0x35   53  5  
  14272	:  1100_0000  0xC0  192    
  14273	:  0000_1100  0x0C   12    
  14274	:  0000_0000  0x00    0    
  14275	:  0000_0001  0x01    1    
  14276	:  0000_0000  0x00    0    
  14277	:  0000_0001  0x01    1    
  14278	:  0000_0000  0x00    0    
  14279	:  0000_0000  0x00    0    
  14280	:  0010_1010  0x2A   42  *  
  14281	:  0011_0000  0x30   48  0  
  14282	:  0000_0000  0x00    0    
  14283	:  0000_0100  0x04    4    
  14284	:  0010_1101  0x2D   45  -  
  14285	:  0100_0011  0x43   67  C  
  14286	:  0011_0100  0x34   52  4  
  14287	:  0011_0111  0x37   55  7  
  14288	:  0000_1000  0x08    8    
  14289	:  0100_0001  0x41   65  A  
  14290	:  0010_1101  0x2D   45  -  
  14291	:  0011_0101  0x35   53  5  
  14292	:  0011_0010  0x32   50  2  
  14293	:  0010_1101  0x2D   45  -  
  14294	:  0011_0000  0x30   48  0  
  14295	:  0011_0101  0x35   53  5  
  14296	:  0011_0110  0x36   54  6  
  14297	:  1100_0000  0xC0  192    
  14298	:  0000_1100  0x0C   12    
  14299	:  0000_0000  0x00    0    
  14300	:  0000_0001  0x01    1    
  14301	:  0000_0000  0x00    0    
  14302	:  0000_0001  0x01    1    
  14303	:  0000_0000  0x00    0    
  14304	:  0000_0000  0x00    0    
  14305	:  0010_1010  0x2A   42  *  
  14306	:  0011_0000  0x30   48  0  
  14307	:  0000_0000  0x00    0    
  14308	:  0000_0100  0x04    4    
  14309	:  0010_1101  0x2D   45  -  
  14310	:  0100_0011  0x43   67  C  
  14311	:  0011_0100  0x34   52  4  
  14312	:  0011_1000  0x38   56  8  
  14313	:  0000_1000  0x08    8    
  14314	:  0100_0001  0x41   65  A  
  14315	:  0010_1101  0x2D   45  -  
  14316	:  0011_0101  0x35   53  5  
  14317	:  0011_0010  0x32   50  2  
  14318	:  0010_1101  0x2D   45  -  
  14319	:  0011_0000  0x30   48  0  
  14320	:  0011_0101  0x35   53  5  
  14321	:  0011_0111  0x37   55  7  
  14322	:  1100_0000  0xC0  192    
  14323	:  0000_1100  0x0C   12    
  14324	:  0000_0000  0x00    0    
  14325	:  0000_0001  0x01    1    
  14326	:  0000_0000  0x00    0    
  14327	:  0000_0001  0x01    1    
  14328	:  0000_0000  0x00    0    
  14329	:  0000_0000  0x00    0    
  14330	:  0010_1010  0x2A   42  *  
  14331	:  0011_0000  0x30   48  0  
  14332	:  0000_0000  0x00    0    
  14333	:  0000_0100  0x04    4    
  14334	:  0010_1101  0x2D   45  -  
  14335	:  0100_0011  0x43   67  C  
  14336	:  0011_0100  0x34   52  4  
  14337	:  0011_1001  0x39   57  9  
  14338	:  0000_1000  0x08    8    
  14339	:  0100_0001  0x41   65  A  
  14340	:  0010_1101  0x2D   45  -  
  14341	:  0011_0101  0x35   53  5  
  14342	:  0011_0010  0x32   50  2  
  14343	:  0010_1101  0x2D   45  -  
  14344	:  0011_0000  0x30   48  0  
  14345	:  0011_0101  0x35   53  5  
  14346	:  0011_1000  0x38   56  8  
  14347	:  1100_0000  0xC0  192    
  14348	:  0000_1100  0x0C   12    
  14349	:  0000_0000  0x00    0    
  14350	:  0000_0001  0x01    1    
  14351	:  0000_0000  0x00    0    
  14352	:  0000_0001  0x01    1    
  14353	:  0000_0000  0x00    0    
  14354	:  0000_0000  0x00    0    
  14355	:  0010_1010  0x2A   42  *  
  14356	:  0011_0000  0x30   48  0  
  14357	:  0000_0000  0x00    0    
  14358	:  0000_0100  0x04    4    
  14359	:  0010_1101  0x2D   45  -  
  14360	:  0100_0011  0x43   67  C  
  14361	:  0011_0100  0x34   52  4  
  14362	:  0011_1010  0x3A   58  :  
  14363	:  0000_1000  0x08    8    
  14364	:  0100_0001  0x41   65  A  
  14365	:  0010_1101  0x2D   45  -  
  14366	:  0011_0101  0x35   53  5  
  14367	:  0011_0010  0x32   50  2  
  14368	:  0010_1101  0x2D   45  -  
  14369	:  0011_0000  0x30   48  0  
  14370	:  0011_0101  0x35   53  5  
  14371	:  0011_1001  0x39   57  9  
  14372	:  1100_0000  0xC0  192    
  14373	:  0000_1100  0x0C   12    
  14374	:  0000_0000  0x00    0    
  14375	:  0000_0001  0x01    1    
  14376	:  0000_0000  0x00    0    
  14377	:  0000_0001  0x01    1    
  14378	:  0000_0000  0x00    0    
  14379	:  0000_0000  0x00    0    
  14380	:  0010_1010  0x2A   42  *  
  14381	:  0011_0000  0x30   48  0  
  14382	:  0000_0000  0x00    0    
  14383	:  0000_0100  0x04    4    
  14384	:  0010_1101  0x2D   45  -  
  14385	:  0100_0011  0x43   67  C  
  14386	:  0011_0100  0x34   52  4  
  14387	:  0011_1011  0x3B   59  ;  
  14388	:  0000_1000  0x08    8    
  14389	:  0100_0001  0x41   65  A  
  14390	:  0010_1101  0x2D   45  -  
  14391	:  0011_0101  0x35   53  5  
  14392	:  0011_0010  0x32   50  2  
  14393	:  0010_1101  0x2D   45  -  
  14394	:  0011_0000  0x30   48  0  
  14395	:  0011_0110  0x36   54  6  
  14396	:  0011_0000  0x30   48  0  
  14397	:  1100_0000  0xC0  192    
  14398	:  0000_1100  0x0C   12    
  14399	:  0000_0000  0x00    0    
  14400	:  0000_0001  0x01    1    
  14401	:  0000_0000  0x00    0    
  14402	:  0000_0001  0x01    1    
  14403	:  0000_0000  0x00    0    
  14404	:  0000_0000  0x00    0    
  14405	:  0010_1010  0x2A   42  *  
  14406	:  0011_0000  0x30   48  0  
  14407	:  0000_0000  0x00    0    
  14408	:  0000_0100  0x04    4    
  14409	:  0010_1101  0x2D   45  -  
  14410	:  0100_0011  0x43   67  C  
  14411	:  0011_0100  0x34   52  4  
  14412	:  0011_1100  0x3C   60  <  
  14413	:  0000_1000  0x08    8    
  14414	:  0100_0001  0x41   65  A  
  14415	:  0010_1101  0x2D   45  -  
  14416	:  0011_0101  0x35   53  5  
  14417	:  0011_0010  0x32   50  2  
  14418	:  0010_1101  0x2D   45  -  
  14419	:  0011_0000  0x30   48  0  
  14420	:  0011_0110  0x36   54  6  
  14421	:  0011_0001  0x31   49  1  
  14422	:  1100_0000  0xC0  192    
  14423	:  0000_1100  0x0C   12    
  14424	:  0000_0000  0x00    0    
  14425	:  0000_0001  0x01    1    
  14426	:  0000_0000  0x00    0    
  14427	:  0000_0001  0x01    1    
  14428	:  0000_0000  0x00    0    
  14429	:  0000_0000  0x00    0    
  14430	:  0010_1010  0x2A   42  *  
  14431	:  0011_0000  0x30   48  0  
  14432	:  0000_0000  0x00    0    
  14433	:  0000_0100  0x04    4    
  14434	:  0010_1101  0x2D   45  -  
  14435	:  0100_0011  0x43   67  C  
  14436	:  0011_0100  0x34   52  4  
  14437	:  0011_1101  0x3D   61  =  
  14438	:  0000_1000  0x08    8    
  14439	:  0100_0001  0x41   65  A  
  14440	:  0010_1101  0x2D   45  -  
  14441	:  0011_0101  0x35   53  5  
  14442	:  0011_0010  0x32   50  2  
  14443	:  0010_1101  0x2D   45  -  
  14444	:  0011_0000  0x30   48  0  
  14445	:  0011_0110  0x36   54  6  
  14446	:  0011_0010  0x32   50  2  
  14447	:  1100_0000  0xC0  192    
  14448	:  0000_1100  0x0C   12    
  14449	:  0000_0000  0x00    0    
  14450	:  0000_0001  0x01    1    
  14451	:  0000_0000  0x00    0    
  14452	:  0000_0001  0x01    1    
  14453	:  0000_0000  0x00    0    
  14454	:  0000_0000  0x00    0    
  14455	:  0010_1010  0x2A   42  *  
  14456	:  0011_0000  0x30   48  0  
  14457	:  0000_0000  0x00    0    
  14458	:  0000_0100  0x04    4    
  14459	:  0010_1101  0x2D   45  -  
  14460	:  0100_0011  0x43   67  C  
  14461	:  0011_0100  0x34   52  4  
  14462	:  0011_1110  0x3E   62  >  
  14463	:  0000_1000  0x08    8    
  14464	:  0100_0001  0x41   65  A  
  14465	:  0010_1101  0x2D   45  -  
  14466	:  0011_0101  0x35   53  5  
  14467	:  0011_0010  0x32   50  2  
  14468	:  0010_1101  0x2D   45  -  
  14469	:  0011_0000  0x30   48  0  
  14470	:  0011_0110  0x36   54  6  
  14471	:  0011_0011  0x33   51  3  
  14472	:  1100_0000  0xC0  192    
  14473	:  0000_1100  0x0C   12    
  14474	:  0000_0000  0x00    0    
  14475	:  0000_0001  0x01    1    
  14476	:  0000_0000  0x00    0    
  14477	:  0000_0001  0x01    1    
  14478	:  0000_0000  0x00    0    
  14479	:  0000_0000  0x00    0    
  14480	:  0010_1010  0x2A   42  *  
  14481	:  0011_0000  0x30   48  0  
  14482	:  0000_0000  0x00    0    
  14483	:  0000_0100  0x04    4    
  14484	:  0010_1101  0x2D   45  -  
  14485	:  0100_0011  0x43   67  C  
  14486	:  0011_0100  0x34   52  4  
  14487	:  0011_1111  0x3F   63  ?  
  14488	:  0000_1000  0x08    8    
  14489	:  0100_0001  0x41   65  A  
  14490	:  0010_1101  0x2D   45  -  
  14491	:  0011_0101  0x35   53  5  
  14492	:  0011_0010  0x32   50  2  
  14493	:  0010_1101  0x2D   45  -  
  14494	:  0011_0000  0x30   48  0  
  14495	:  0011_0110  0x36   54  6  
  14496	:  0011_0100  0x34   52  4  
  14497	:  1100_0000  0xC0  192    
  14498	:  0000_1100  0x0C   12    
  14499	:  0000_0000  0x00    0    
  14500	:  0000_0001  0x01    1    
  14501	:  0000_0000  0x00    0    
  14502	:  0000_0001  0x01    1    
  14503	:  0000_0000  0x00    0    
  14504	:  0000_0000  0x00    0    
  14505	:  0010_1010  0x2A   42  *  
  14506	:  0011_0000  0x30   48  0  
  14507	:  0000_0000  0x00    0    
  14508	:  0000_0100  0x04    4    
  14509	:  0010_1101  0x2D   45  -  
  14510	:  0100_0011  0x43   67  C  
  14511	:  0011_0100  0x34   52  4  
  14512	:  0100_0000  0x40   64  @  
  14513	:  0000_1000  0x08    8    
  14514	:  0100_0001  0x41   65  A  
  14515	:  0010_1101  0x2D   45  -  
  14516	:  0011_0101  0x35   53  5  
  14517	:  0011_0010  0x32   50  2  
  14518	:  0010_1101  0x2D   45  -  
  14519	:  0011_0000  0x30   48  0  
  14520	:  0011_0110  0x36   54  6  
  14521	:  0011_0101  0x35   53  5  
  14522	:  1100_0000  0xC0  192    
  14523	:  0000_1100  0x0C   12    
  14524	:  0000_0000  0x00    0    
  14525	:  0000_0001  0x01    1    
  14526	:  0000_0000  0x00    0    
  14527	:  0000_0001  0x01    1    
  14528	:  0000_0000  0x00    0    
  14529	:  0000_0000  0x00    0    
  14530	:  0010_1010  0x2A   42  *  
  14531	:  0011_0000  0x30   48  0  
  14532	:  0000_0000  0x00    0    
  14533	:  0000_0100  0x04    4    
  14534	:  0010_1101  0x2D   45  -  
  14535	:  0100_0011  0x43   67  C  
  14536	:  0011_0100  0x34   52  4  
  14537	:  0100_0001  0x41   65  A  
  14538	:  0000_1000  0x08    8    
  14539	:  0100_0001  0x41   65  A  
  14540	:  0010_1101  0x2D   45  -  
  14541	:  0011_0101  0x35   53  5  
  14542	:  0011_0010  0x32   50  2  
  14543	:  0010_1101  0x2D   45  -  
  14544	:  0011_0000  0x30   48  0  
  14545	:  0011_0110  0x36   54  6  
  14546	:  0011_0110  0x36   54  6  
  14547	:  1100_0000  0xC0  192    
  14548	:  0000_1100  0x0C   12    
  14549	:  0000_0000  0x00    0    
  14550	:  0000_0001  0x01    1    
  14551	:  0000_0000  0x00    0    
  14552	:  0000_0001  0x01    1    
  14553	:  0000_0000  0x00    0    
  14554	:  0000_0000  0x00    0    
  14555	:  0010_1010  0x2A   42  *  
  14556	:  0011_0000  0x30   48  0  
  14557	:  0000_0000  0x00    0    
  14558	:  0000_0100  0x04    4    
  14559	:  0010_1101  0x2D   45  -  
  14560	:  0100_0011  0x43   67  C  
  14561	:  0011_0100  0x34   52  4  
  14562	:  0100_0010  0x42   66  B  
  14563	:  0000_1000  0x08    8    
  14564	:  0100_0001  0x41   65  A  
  14565	:  0010_1101  0x2D   45  -  
  14566	:  0011_0101  0x35   53  5  
  14567	:  0011_0010  0x32   50  2  
  14568	:  0010_1101  0x2D   45  -  
  14569	:  0011_0000  0x30   48  0  
  14570	:  0011_0110  0x36   54  6  
  14571	:  0011_0111  0x37   55  7  
  14572	:  1100_0000  0xC0  192    
  14573	:  0000_1100  0x0C   12    
  14574	:  0000_0000  0x00    0    
  14575	:  0000_0001  0x01    1    
  14576	:  0000_0000  0x00    0    
  14577	:  0000_0001  0x01    1    
  14578	:  0000_0000  0x00    0    
  14579	:  0000_0000  0x00    0    
  14580	:  0010_1010  0x2A   42  *  
  14581	:  0011_0000  0x30   48  0  
  14582	:  0000_0000  0x00    0    
  14583	:  0000_0100  0x04    4    
  14584	:  0010_1101  0x2D   45  -  
  14585	:  0100_0011  0x43   67  C  
  14586	:  0011_0100  0x34   52  4  
  14587	:  0100_0011  0x43   67  C  
  14588	:  0000_1000  0x08    8    
  14589	:  0100_0001  0x41   65  A  
  14590	:  0010_1101  0x2D   45  -  
  14591	:  0011_0101  0x35   53  5  
  14592	:  0011_0010  0x32   50  2  
  14593	:  0010_1101  0x2D   45  -  
  14594	:  0011_0000  0x30   48  0  
  14595	:  0011_0110  0x36   54  6  
  14596	:  0011_1000  0x38   56  8  
  14597	:  1100_0000  0xC0  192    
  14598	:  0000_1100  0x0C   12    
  14599	:  0000_0000  0x00    0    
  14600	:  0000_0001  0x01    1    
  14601	:  0000_0000  0x00    0    
  14602	:  0000_0001  0x01    1    
  14603	:  0000_0000  0x00    0    
  14604	:  0000_0000  0x00    0    
  14605	:  0010_1010  0x2A   42  *  
  14606	:  0011_0000  0x30   48  0  
  14607	:  0000_0000  0x00    0    
  14608	:  0000_0100  0x04    4    
  14609	:  0010_1101  0x2D   45  -  
  14610	:  0100_0011  0x43   67  C  
  14611	:  0011_0100  0x34   52  4  
  14612	:  0100_0100  0x44   68  D  
  14613	:  0000_1000  0x08    8    
  14614	:  0100_0001  0x41   65  A  
  14615	:  0010_1101  0x2D   45  -  
  14616	:  0011_0101  0x35   53  5  
  14617	:  0011_0010  0x32   50  2  
  14618	:  0010_1101  0x2D   45  -  
  14619	:  0011_0000  0x30   48  0  
  14620	:  0011_0110  0x36   54  6  
  14621	:  0011_1001  0x39   57  9  
  14622	:  1100_0000  0xC0  192    
  14623	:  0000_1100  0x0C   12    
  14624	:  0000_0000  0x00    0    
  14625	:  0000_0001  0x01    1    
  14626	:  0000_0000  0x00    0    
  14627	:  0000_0001  0x01    1    
  14628	:  0000_0000  0x00    0    
  14629	:  0000_0000  0x00    0    
  14630	:  0010_1010  0x2A   42  *  
  14631	:  0011_0000  0x30   48  0  
  14632	:  0000_0000  0x00    0    
  14633	:  0000_0100  0x04    4    
  14634	:  0010_1101  0x2D   45  -  
  14635	:  0100_0011  0x43   67  C  
  14636	:  0011_0100  0x34   52  4  
  14637	:  0100_0101  0x45   69  E  
  14638	:  0000_1000  0x08    8    
  14639	:  0100_0001  0x41   65  A  
  14640	:  0010_1101  0x2D   45  -  
  14641	:  0011_0101  0x35   53  5  
  14642	:  0011_0010  0x32   50  2  
  14643	:  0010_1101  0x2D   45  -  
  14644	:  0011_0000  0x30   48  0  
  14645	:  0011_0111  0x37   55  7  
  14646	:  0011_0000  0x30   48  0  
  14647	:  1100_0000  0xC0  192    
  14648	:  0000_1100  0x0C   12    
  14649	:  0000_0000  0x00    0    
  14650	:  0000_0001  0x01    1    
  14651	:  0000_0000  0x00    0    
  14652	:  0000_0001  0x01    1    
  14653	:  0000_0000  0x00    0    
  14654	:  0000_0000  0x00    0    
  14655	:  0010_1010  0x2A   42  *  
  14656	:  0011_0000  0x30   48  0  
  14657	:  0000_0000  0x00    0    
  14658	:  0000_0100  0x04    4    
  14659	:  0010_1101  0x2D   45  -  
  14660	:  0100_0011  0x43   67  C  
  14661	:  0011_0100  0x34   52  4  
  14662	:  0100_0110  0x46   70  F  
  14663	:  0000_1000  0x08    8    
  14664	:  0100_0001  0x41   65  A  
  14665	:  0010_1101  0x2D   45  -  
  14666	:  0011_0101  0x35   53  5  
  14667	:  0011_0010  0x32   50  2  
  14668	:  0010_1101  0x2D   45  -  
  14669	:  0011_0000  0x30   48  0  
  14670	:  0011_0111  0x37   55  7  
  14671	:  0011_0001  0x31   49  1  
  14672	:  1100_0000  0xC0  192    
  14673	:  0000_1100  0x0C   12    
  14674	:  0000_0000  0x00    0    
  14675	:  0000_0001  0x01    1    
  14676	:  0000_0000  0x00    0    
  14677	:  0000_0001  0x01    1    
  14678	:  0000_0000  0x00    0    
  14679	:  0000_0000  0x00    0    
  14680	:  0010_1010  0x2A   42  *  
  14681	:  0011_0000  0x30   48  0  
  14682	:  0000_0000  0x00    0    
  14683	:  0000_0100  0x04    4    
  14684	:  0010_1101  0x2D   45  -  
  14685	:  0100_0011  0x43   67  C  
  14686	:  0011_0100  0x34   52  4  
  14687	:  0100_0111  0x47   71  G  
  14688	:  0000_1000  0x08    8    
  14689	:  0100_0001  0x41   65  A  
  14690	:  0010_1101  0x2D   45  -  
  14691	:  0011_0101  0x35   53  5  
  14692	:  0011_0010  0x32   50  2  
  14693	:  0010_1101  0x2D   45  -  
  14694	:  0011_0000  0x30   48  0  
  14695	:  0011_0111  0x37   55  7  
  14696	:  0011_0010  0x32   50  2  
  14697	:  1100_0000  0xC0  192    
  14698	:  0000_1100  0x0C   12    
  14699	:  0000_0000  0x00    0    
  14700	:  0000_0001  0x01    1    
  14701	:  0000_0000  0x00    0    
  14702	:  0000_0001  0x01    1    
  14703	:  0000_0000  0x00    0    
  14704	:  0000_0000  0x00    0    
  14705	:  0010_1010  0x2A   42  *  
  14706	:  0011_0000  0x30   48  0  
  14707	:  0000_0000  0x00    0    
  14708	:  0000_0100  0x04    4    
  14709	:  0010_1101  0x2D   45  -  
  14710	:  0100_0011  0x43   67  C  
  14711	:  0011_0100  0x34   52  4  
  14712	:  0100_1000  0x48   72  H  
  14713	:  0000_1000  0x08    8    
  14714	:  0100_0001  0x41   65  A  
  14715	:  0010_1101  0x2D   45  -  
  14716	:  0011_0101  0x35   53  5  
  14717	:  0011_0010  0x32   50  2  
  14718	:  0010_1101  0x2D   45  -  
  14719	:  0011_0000  0x30   48  0  
  14720	:  0011_0111  0x37   55  7  
  14721	:  0011_0011  0x33   51  3  
  14722	:  1100_0000  0xC0  192    
  14723	:  0000_1100  0x0C   12    
  14724	:  0000_0000  0x00    0    
  14725	:  0000_0001  0x01    1    
  14726	:  0000_0000  0x00    0    
  14727	:  0000_0001  0x01    1    
  14728	:  0000_0000  0x00    0    
  14729	:  0000_0000  0x00    0    
  14730	:  0010_1010  0x2A   42  *  
  14731	:  0011_0000  0x30   48  0  
  14732	:  0000_0000  0x00    0    
  14733	:  0000_0100  0x04    4    
  14734	:  0010_1101  0x2D   45  -  
  14735	:  0100_0011  0x43   67  C  
  14736	:  0011_0100  0x34   52  4  
  14737	:  0100_1001  0x49   73  I  
  14738	:  0000_1000  0x08    8    
  14739	:  0100_0001  0x41   65  A  
  14740	:  0010_1101  0x2D   45  -  
  14741	:  0011_0101  0x35   53  5  
  14742	:  0011_0010  0x32   50  2  
  14743	:  0010_1101  0x2D   45  -  
  14744	:  0011_0000  0x30   48  0  
  14745	:  0011_0111  0x37   55  7  
  14746	:  0011_0100  0x34   52  4  
  14747	:  1100_0000  0xC0  192    
  14748	:  0000_1100  0x0C   12    
  14749	:  0000_0000  0x00    0    
  14750	:  0000_0001  0x01    1    
  14751	:  0000_0000  0x00    0    
  14752	:  0000_0001  0x01    1    
  14753	:  0000_0000  0x00    0    
  14754	:  0000_0000  0x00    0    
  14755	:  0010_1010  0x2A   42  *  
  14756	:  0011_0000  0x30   48  0  
  14757	:  0000_0000  0x00    0    
  14758	:  0000_0100  0x04    4    
  14759	:  0010_1101  0x2D   45  -  
  14760	:  0100_0011  0x43   67  C  
  14761	:  0011_0100  0x34   52  4  
  14762	:  0100_1010  0x4A   74  J  
  14763	:  0000_1000  0x08    8    
  14764	:  0100_0001  0x41   65  A  
  14765	:  0010_1101  0x2D   45  -  
  14766	:  0011_0101  0x35   53  5  
  14767	:  0011_0010  0x32   50  2  
  14768	:  0010_1101  0x2D   45  -  
  14769	:  0011_0000  0x30   48  0  
  14770	:  0011_0111  0x37   55  7  
  14771	:  0011_0101  0x35   53  5  
  14772	:  1100_0000  0xC0  192    
  14773	:  0000_1100  0x0C   12    
  14774	:  0000_0000  0x00    0    
  14775	:  0000_0001  0x01    1    
  14776	:  0000_0000  0x00    0    
  14777	:  0000_0001  0x01    1    
  14778	:  0000_0000  0x00    0    
  14779	:  0000_0000  0x00    0    
  14780	:  0010_1010  0x2A   42  *  
  14781	:  0011_0000  0x30   48  0  
  14782	:  0000_0000  0x00    0    
  14783	:  0000_0100  0x04    4    
  14784	:  0010_1101  0x2D   45  -  
  14785	:  0100_0011  0x43   67  C  
  14786	:  0011_0100  0x34   52  4  
  14787	:  0100_1011  0x4B   75  K  
  14788	:  0000_1000  0x08    8    
  14789	:  0100_0001  0x41   65  A  
  14790	:  0010_1101  0x2D   45  -  
  14791	:  0011_0101  0x35   53  5  
  14792	:  0011_0010  0x32   50  2  
  14793	:  0010_1101  0x2D   45  -  
  14794	:  0011_0000  0x30   48  0  
  14795	:  0011_0111  0x37   55  7  
  14796	:  0011_0110  0x36   54  6  
  14797	:  1100_0000  0xC0  192    
  14798	:  0000_1100  0x0C   12    
  14799	:  0000_0000  0x00    0    
  14800	:  0000_0001  0x01    1    
  14801	:  0000_0000  0x00    0    
  14802	:  0000_0001  0x01    1    
  14803	:  0000_0000  0x00    0    
  14804	:  0000_0000  0x00    0    
  14805	:  0010_1010  0x2A   42  *  
  14806	:  0011_0000  0x30   48  0  
  14807	:  0000_0000  0x00    0    
  14808	:  0000_0100  0x04    4    
  14809	:  0010_1101  0x2D   45  -  
  14810	:  0100_0011  0x43   67  C  
  14811	:  0011_0100  0x34   52  4  
  14812	:  0100_1100  0x4C   76  L  
  14813	:  0000_1000  0x08    8    
  14814	:  0100_0001  0x41   65  A  
  14815	:  0010_1101  0x2D   45  -  
  14816	:  0011_0101  0x35   53  5  
  14817	:  0011_0010  0x32   50  2  
  14818	:  0010_1101  0x2D   45  -  
  14819	:  0011_0000  0x30   48  0  
  14820	:  0011_0111  0x37   55  7  
  14821	:  0011_0111  0x37   55  7  
  14822	:  1100_0000  0xC0  192    
  14823	:  0000_1100  0x0C   12    
  14824	:  0000_0000  0x00    0    
  14825	:  0000_0001  0x01    1    
  14826	:  0000_0000  0x00    0    
  14827	:  0000_0001  0x01    1    
  14828	:  0000_0000  0x00    0    
  14829	:  0000_0000  0x00    0    
  14830	:  0010_1010  0x2A   42  *  
  14831	:  0011_0000  0x30   48  0  
  14832	:  0000_0000  0x00    0    
  14833	:  0000_0100  0x04    4    
  14834	:  0010_1101  0x2D   45  -  
  14835	:  0100_0011  0x43   67  C  
  14836	:  0011_0100  0x34   52  4  
  14837	:  0100_1101  0x4D   77  M  
  14838	:  0000_1000  0x08    8    
  14839	:  0100_0001  0x41   65  A  
  14840	:  0010_1101  0x2D   45  -  
  14841	:  0011_0101  0x35   53  5  
  14842	:  0011_0010  0x32   50  2  
  14843	:  0010_1101  0x2D   45  -  
  14844	:  0011_0000  0x30   48  0  
  14845	:  0011_0111  0x37   55  7  
  14846	:  0011_1000  0x38   56  8  
  14847	:  1100_0000  0xC0  192    
  14848	:  0000_1100  0x0C   12    
  14849	:  0000_0000  0x00    0    
  14850	:  0000_0001  0x01    1    
  14851	:  0000_0000  0x00    0    
  14852	:  0000_0001  0x01    1    
  14853	:  0000_0000  0x00    0    
  14854	:  0000_0000  0x00    0    
  14855	:  0010_1010  0x2A   42  *  
  14856	:  0011_0000  0x30   48  0  
  14857	:  0000_0000  0x00    0    
  14858	:  0000_0100  0x04    4    
  14859	:  0010_1101  0x2D   45  -  
  14860	:  0100_0011  0x43   67  C  
  14861	:  0011_0100  0x34   52  4  
  14862	:  0100_1110  0x4E   78  N  
  14863	:  0000_1000  0x08    8    
  14864	:  0100_0001  0x41   65  A  
  14865	:  0010_1101  0x2D   45  -  
  14866	:  0011_0101  0x35   53  5  
  14867	:  0011_0010  0x32   50  2  
  14868	:  0010_1101  0x2D   45  -  
  14869	:  0011_0000  0x30   48  0  
  14870	:  0011_0111  0x37   55  7  
  14871	:  0011_1001  0x39   57  9  
  14872	:  1100_0000  0xC0  192    
  14873	:  0000_1100  0x0C   12    
  14874	:  0000_0000  0x00    0    
  14875	:  0000_0001  0x01    1    
  14876	:  0000_0000  0x00    0    
  14877	:  0000_0001  0x01    1    
  14878	:  0000_0000  0x00    0    
  14879	:  0000_0000  0x00    0    
  14880	:  0010_1010  0x2A   42  *  
  14881	:  0011_0000  0x30   48  0  
  14882	:  0000_0000  0x00    0    
  14883	:  0000_0100  0x04    4    
  14884	:  0010_1101  0x2D   45  -  
  14885	:  0100_0011  0x43   67  C  
  14886	:  0011_0100  0x34   52  4  
  14887	:  0100_1111  0x4F   79  O  
  14888	:  0000_1000  0x08    8    
  14889	:  0100_0001  0x41   65  A  
  14890	:  0010_1101  0x2D   45  -  
  14891	:  0011_0101  0x35   53  5  
  14892	:  0011_0010  0x32   50  2  
  14893	:  0010_1101  0x2D   45  -  
  14894	:  0011_0000  0x30   48  0  
  14895	:  0011_1000  0x38   56  8  
  14896	:  0011_0000  0x30   48  0  
  14897	:  1100_0000  0xC0  192    
  14898	:  0000_1100  0x0C   12    
  14899	:  0000_0000  0x00    0    
  14900	:  0000_0001  0x01    1    
  14901	:  0000_0000  0x00    0    
  14902	:  0000_0001  0x01    1    
  14903	:  0000_0000  0x00    0    
  14904	:  0000_0000  0x00    0    
  14905	:  0010_1010  0x2A   42  *  
  14906	:  0011_0000  0x30   48  0  
  14907	:  0000_0000  0x00    0    
  14908	:  0000_0100  0x04    4    
  14909	:  0010_1101  0x2D   45  -  
  14910	:  0100_0011  0x43   67  C  
  14911	:  0011_0100  0x34   52  4  
  14912	:  0101_0000  0x50   80  P  
  14913	:  0000_1000  0x08    8    
  14914	:  0100_0001  0x41   65  A  
  14915	:  0010_1101  0x2D   45  -  
  14916	:  0011_0101  0x35   53  5  
  14917	:  0011_0010  0x32   50  2  
  14918	:  0010_1101  0x2D   45  -  
  14919	:  0011_0000  0x30   48  0  
  14920	:  0011_1000  0x38   56  8  
  14921	:  0011_0001  0x31   49  1  
  14922	:  1100_0000  0xC0  192    
  14923	:  0000_1100  0x0C   12    
  14924	:  0000_0000  0x00    0    
  14925	:  0000_0001  0x01    1    
  14926	:  0000_0000  0x00    0    
  14927	:  0000_0001  0x01    1    
  14928	:  0000_0000  0x00    0    
  14929	:  0000_0000  0x00    0    
  14930	:  0010_1010  0x2A   42  *  
  14931	:  0011_0000  0x30   48  0  
  14932	:  0000_0000  0x00    0    
  14933	:  0000_0100  0x04    4    
  14934	:  0010_1101  0x2D   45  -  
  14935	:  0100_0011  0x43   67  C  
  14936	:  0011_0100  0x34   52  4  
  14937	:  0101_0001  0x51   81  Q  
  14938	:  0000_1000  0x08    8    
  14939	:  0100_0001  0x41   65  A  
  14940	:  0010_1101  0x2D   45  -  
  14941	:  0011_0101  0x35   53  5  
  14942	:  0011_0010  0x32   50  2  
  14943	:  0010_1101  0x2D   45  -  
  14944	:  0011_0000  0x30   48  0  
  14945	:  0011_1000  0x38   56  8  
  14946	:  0011_0010  0x32   50  2  
  14947	:  1100_0000  0xC0  192    
  14948	:  0000_1100  0x0C   12    
  14949	:  0000_0000  0x00    0    
  14950	:  0000_0001  0x01    1    
  14951	:  0000_0000  0x00    0    
  14952	:  0000_0001  0x01    1    
  14953	:  0000_0000  0x00    0    
  14954	:  0000_0000  0x00    0    
  14955	:  0010_1010  0x2A   42  *  
  14956	:  0011_0000  0x30   48  0  
  14957	:  0000_0000  0x00    0    
  14958	:  0000_0100  0x04    4    
  14959	:  0010_1101  0x2D   45  -  
  14960	:  0100_0011  0x43   67  C  
  14961	:  0011_0100  0x34   52  4  
  14962	:  0101_0010  0x52   82  R  
  14963	:  0000_1000  0x08    8    
  14964	:  0100_0001  0x41   65  A  
  14965	:  0010_1101  0x2D   45  -  
  14966	:  0011_0101  0x35   53  5  
  14967	:  0011_0010  0x32   50  2  
  14968	:  0010_1101  0x2D   45  -  
  14969	:  0011_0000  0x30   48  0  
  14970	:  0011_1000  0x38   56  8  
  14971	:  0011_0011  0x33   51  3  
  14972	:  1100_0000  0xC0  192    
  14973	:  0000_1100  0x0C   12    
  14974	:  0000_0000  0x00    0    
  14975	:  0000_0001  0x01    1    
  14976	:  0000_0000  0x00    0    
  14977	:  0000_0001  0x01    1    
  14978	:  0000_0000  0x00    0    
  14979	:  0000_0000  0x00    0    
  14980	:  0010_1010  0x2A   42  *  
  14981	:  0011_0000  0x30   48  0  
  14982	:  0000_0000  0x00    0    
  14983	:  0000_0100  0x04    4    
  14984	:  0010_1101  0x2D   45  -  
  14985	:  0100_0011  0x43   67  C  
  14986	:  0011_0100  0x34   52  4  
  14987	:  0101_0011  0x53   83  S  
  14988	:  0000_1000  0x08    8    
  14989	:  0100_0001  0x41   65  A  
  14990	:  0010_1101  0x2D   45  -  
  14991	:  0011_0101  0x35   53  5  
  14992	:  0011_0010  0x32   50  2  
  14993	:  0010_1101  0x2D   45  -  
  14994	:  0011_0000  0x30   48  0  
  14995	:  0011_1000  0x38   56  8  
  14996	:  0011_0100  0x34   52  4  
  14997	:  1100_0000  0xC0  192    
  14998	:  0000_1100  0x0C   12    
  14999	:  0000_0000  0x00    0    
  15000	:  0000_0001  0x01    1    
  15001	:  0000_0000  0x00    0    
  15002	:  0000_0001  0x01    1    
  15003	:  0000_0000  0x00    0    
  15004	:  0000_0000  0x00    0    
  15005	:  0010_1010  0x2A   42  *  
  15006	:  0011_0000  0x30   48  0  
  15007	:  0000_0000  0x00    0    
  15008	:  0000_0100  0x04    4    
  15009	:  0010_1101  0x2D   45  -  
  15010	:  0100_0011  0x43   67  C  
  15011	:  0011_0100  0x34   52  4  
  15012	:  0101_0100  0x54   84  T  
  15013	:  0000_1000  0x08    8    
  15014	:  0100_0001  0x41   65  A  
  15015	:  0010_1101  0x2D   45  -  
  15016	:  0011_0101  0x35   53  5  
  15017	:  0011_0010  0x32   50  2  
  15018	:  0010_1101  0x2D   45  -  
  15019	:  0011_0000  0x30   48  0  
  15020	:  0011_1000  0x38   56  8  
  15021	:  0011_0101  0x35   53  5  
  15022	:  1100_0000  0xC0  192    
  15023	:  0000_1100  0x0C   12    
  15024	:  0000_0000  0x00    0    
  15025	:  0000_0001  0x01    1    
  15026	:  0000_0000  0x00    0    
  15027	:  0000_0001  0x01    1    
  15028	:  0000_0000  0x00    0    
  15029	:  0000_0000  0x00    0    
  15030	:  0010_1010  0x2A   42  *  
  15031	:  0011_0000  0x30   48  0  
  15032	:  0000_0000  0x00    0    
  15033	:  0000_0100  0x04    4    
  15034	:  0010_1101  0x2D   45  -  
  15035	:  0100_0011  0x43   67  C  
  15036	:  0011_0100  0x34   52  4  
  15037	:  0101_0101  0x55   85  U  
  15038	:  0000_1000  0x08    8    
  15039	:  0100_0001  0x41   65  A  
  15040	:  0010_1101  0x2D   45  -  
  15041	:  0011_0101  0x35   53  5  
  15042	:  0011_0010  0x32   50  2  
  15043	:  0010_1101  0x2D   45  -  
  15044	:  0011_0000  0x30   48  0  
  15045	:  0011_1000  0x38   56  8  
  15046	:  0011_0110  0x36   54  6  
  15047	:  1100_0000  0xC0  192    
  15048	:  0000_1100  0x0C   12    
  15049	:  0000_0000  0x00    0    
  15050	:  0000_0001  0x01    1    
  15051	:  0000_0000  0x00    0    
  15052	:  0000_0001  0x01    1    
  15053	:  0000_0000  0x00    0    
  15054	:  0000_0000  0x00    0    
  15055	:  0010_1010  0x2A   42  *  
  15056	:  0011_0000  0x30   48  0  
  15057	:  0000_0000  0x00    0    
  15058	:  0000_0100  0x04    4    
  15059	:  0010_1101  0x2D   45  -  
  15060	:  0100_0011  0x43   67  C  
  15061	:  0011_0100  0x34   52  4  
  15062	:  0101_0110  0x56   86  V  
  15063	:  0000_1000  0x08    8    
  15064	:  0100_0001  0x41   65  A  
  15065	:  0010_1101  0x2D   45  -  
  15066	:  0011_0101  0x35   53  5  
  15067	:  0011_0010  0x32   50  2  
  15068	:  0010_1101  0x2D   45  -  
  15069	:  0011_0000  0x30   48  0  
  15070	:  0011_1000  0x38   56  8  
  15071	:  0011_0111  0x37   55  7  
  15072	:  1100_0000  0xC0  192    
  15073	:  0000_1100  0x0C   12    
  15074	:  0000_0000  0x00    0    
  15075	:  0000_0001  0x01    1    
  15076	:  0000_0000  0x00    0    
  15077	:  0000_0001  0x01    1    
  15078	:  0000_0000  0x00    0    
  15079	:  0000_0000  0x00    0    
  15080	:  0010_1010  0x2A   42  *  
  15081	:  0011_0000  0x30   48  0  
  15082	:  0000_0000  0x00    0    
  15083	:  0000_0100  0x04    4    
  15084	:  0010_1101  0x2D   45  -  
  15085	:  0100_0011  0x43   67  C  
  15086	:  0011_0100  0x34   52  4  
  15087	:  0101_0111  0x57   87  W  
  15088	:  0000_1000  0x08    8    
  15089	:  0100_0001  0x41   65  A  
  15090	:  0010_1101  0x2D   45  -  
  15091	:  0011_0101  0x35   53  5  
  15092	:  0011_0010  0x32   50  2  
  15093	:  0010_1101  0x2D   45  -  
  15094	:  0011_0000  0x30   48  0  
  15095	:  0011_1000  0x38   56  8  
  15096	:  0011_1000  0x38   56  8  
  15097	:  1100_0000  0xC0  192    
  15098	:  0000_1100  0x0C   12    
  15099	:  0000_0000  0x00    0    
  15100	:  0000_0001  0x01    1    
  15101	:  0000_0000  0x00    0    
  15102	:  0000_0001  0x01    1    
  15103	:  0000_0000  0x00    0    
  15104	:  0000_0000  0x00    0    
  15105	:  0010_1010  0x2A   42  *  
  15106	:  0011_0000  0x30   48  0  
  15107	:  0000_0000  0x00    0    
  15108	:  0000_0100  0x04    4    
  15109	:  0010_1101  0x2D   45  -  
  15110	:  0100_0011  0x43   67  C  
  15111	:  0011_0100  0x34   52  4  
  15112	:  0101_1000  0x58   88  X  
  15113	:  0000_1000  0x08    8    
  15114	:  0100_0001  0x41   65  A  
  15115	:  0010_1101  0x2D   45  -  
  15116	:  0011_0101  0x35   53  5  
  15117	:  0011_0010  0x32   50  2  
  15118	:  0010_1101  0x2D   45  -  
  15119	:  0011_0000  0x30   48  0  
  15120	:  0011_1000  0x38   56  8  
  15121	:  0011_1001  0x39   57  9  
  15122	:  1100_0000  0xC0  192    
  15123	:  0000_1100  0x0C   12    
  15124	:  0000_0000  0x00    0    
  15125	:  0000_0001  0x01    1    
  15126	:  0000_0000  0x00    0    
  15127	:  0000_0001  0x01    1    
  15128	:  0000_0000  0x00    0    
  15129	:  0000_0000  0x00    0    
  15130	:  0010_1010  0x2A   42  *  
  15131	:  0011_0000  0x30   48  0  
  15132	:  0000_0000  0x00    0    
  15133	:  0000_0100  0x04    4    
  15134	:  0010_1101  0x2D   45  -  
  15135	:  0100_0011  0x43   67  C  
  15136	:  0011_0100  0x34   52  4  
  15137	:  0101_1001  0x59   89  Y  
  15138	:  0000_1000  0x08    8    
  15139	:  0100_0001  0x41   65  A  
  15140	:  0010_1101  0x2D   45  -  
  15141	:  0011_0101  0x35   53  5  
  15142	:  0011_0010  0x32   50  2  
  15143	:  0010_1101  0x2D   45  -  
  15144	:  0011_0000  0x30   48  0  
  15145	:  0011_1001  0x39   57  9  
  15146	:  0011_0000  0x30   48  0  
  15147	:  1100_0000  0xC0  192    
  15148	:  0000_1100  0x0C   12    
  15149	:  0000_0000  0x00    0    
  15150	:  0000_0001  0x01    1    
  15151	:  0000_0000  0x00    0    
  15152	:  0000_0001  0x01    1    
  15153	:  0000_0000  0x00    0    
  15154	:  0000_0000  0x00    0    
  15155	:  0010_1010  0x2A   42  *  
  15156	:  0011_0000  0x30   48  0  
  15157	:  0000_0000  0x00    0    
  15158	:  0000_0100  0x04    4    
  15159	:  0010_1101  0x2D   45  -  
  15160	:  0100_0011  0x43   67  C  
  15161	:  0011_0100  0x34   52  4  
  15162	:  0101_1010  0x5A   90  Z  
  15163	:  0000_1000  0x08    8    
  15164	:  0100_0001  0x41   65  A  
  15165	:  0010_1101  0x2D   45  -  
  15166	:  0011_0101  0x35   53  5  
  15167	:  0011_0010  0x32   50  2  
  15168	:  0010_1101  0x2D   45  -  
  15169	:  0011_0000  0x30   48  0  
  15170	:  0011_1001  0x39   57  9  
  15171	:  0011_0001  0x31   49  1  
  15172	:  1100_0000  0xC0  192    
  15173	:  0000_1100  0x0C   12    
  15174	:  0000_0000  0x00    0    
  15175	:  0000_0001  0x01    1    
  15176	:  0000_0000  0x00    0    
  15177	:  0000_0001  0x01    1    
  15178	:  0000_0000  0x00    0    
  15179	:  0000_0000  0x00    0    
  15180	:  0010_1010  0x2A   42  *  
  15181	:  0011_0000  0x30   48  0  
  15182	:  0000_0000  0x00    0    
  15183	:  0000_0100  0x04    4    
  15184	:  0010_1101  0x2D   45  -  
  15185	:  0100_0011  0x43   67  C  
  15186	:  0011_0100  0x34   52  4  
  15187	:  0101_1011  0x5B   91  [  
  15188	:  0000_1000  0x08    8    
  15189	:  0100_0001  0x41   65  A  
  15190	:  0010_1101  0x2D   45  -  
  15191	:  0011_0101  0x35   53  5  
  15192	:  0011_0010  0x32   50  2  
  15193	:  0010_1101  0x2D   45  -  
  15194	:  0011_0000  0x30   48  0  
  15195	:  0011_1001  0x39   57  9  
  15196	:  0011_0010  0x32   50  2  
  15197	:  1100_0000  0xC0  192    
  15198	:  0000_1100  0x0C   12    
  15199	:  0000_0000  0x00    0    
  15200	:  0000_0001  0x01    1    
  15201	:  0000_0000  0x00    0    
  15202	:  0000_0001  0x01    1    
  15203	:  0000_0000  0x00    0    
  15204	:  0000_0000  0x00    0    
  15205	:  0010_1010  0x2A   42  *  
  15206	:  0011_0000  0x30   48  0  
  15207	:  0000_0000  0x00    0    
  15208	:  0000_0100  0x04    4    
  15209	:  0010_1101  0x2D   45  -  
  15210	:  0100_0011  0x43   67  C  
  15211	:  0011_0100  0x34   52  4  
  15212	:  0101_1100  0x5C   92  \  
  15213	:  0000_1000  0x08    8    
  15214	:  0100_0001  0x41   65  A  
  15215	:  0010_1101  0x2D   45  -  
  15216	:  0011_0101  0x35   53  5  
  15217	:  0011_0010  0x32   50  2  
  15218	:  0010_1101  0x2D   45  -  
  15219	:  0011_0000  0x30   48  0  
  15220	:  0011_1001  0x39   57  9  
  15221	:  0011_0011  0x33   51  3  
  15222	:  1100_0000  0xC0  192    
  15223	:  0000_1100  0x0C   12    
  15224	:  0000_0000  0x00    0    
  15225	:  0000_0001  0x01    1    
  15226	:  0000_0000  0x00    0    
  15227	:  0000_0001  0x01    1    
  15228	:  0000_0000  0x00    0    
  15229	:  0000_0000  0x00    0    
  15230	:  0010_1010  0x2A   42  *  
  15231	:  0011_0000  0x30   48  0  
  15232	:  0000_0000  0x00    0    
  15233	:  0000_0100  0x04    4    
  15234	:  0010_1101  0x2D   45  -  
  15235	:  0100_0011  0x43   67  C  
  15236	:  0011_0100  0x34   52  4  
  15237	:  0101_1101  0x5D   93  ]  
  15238	:  0000_1000  0x08    8    
  15239	:  0100_0001  0x41   65  A  
  15240	:  0010_1101  0x2D   45  -  
  15241	:  0011_0101  0x35   53  5  
  15242	:  0011_0010  0x32   50  2  
  15243	:  0010_1101  0x2D   45  -  
  15244	:  0011_0000  0x30   48  0  
  15245	:  0011_1001  0x39   57  9  
  15246	:  0011_0100  0x34   52  4  
  15247	:  1100_0000  0xC0  192    
  15248	:  0000_1100  0x0C   12    
  15249	:  0000_0000  0x00    0    
  15250	:  0000_0001  0x01    1    
  15251	:  0000_0000  0x00    0    
  15252	:  0000_0001  0x01    1    
  15253	:  0000_0000  0x00    0    
  15254	:  0000_0000  0x00    0    
  15255	:  0010_1010  0x2A   42  *  
  15256	:  0011_0000  0x30   48  0  
  15257	:  0000_0000  0x00    0    
  15258	:  0000_0100  0x04    4    
  15259	:  0010_1101  0x2D   45  -  
  15260	:  0100_0011  0x43   67  C  
  15261	:  0011_0100  0x34   52  4  
  15262	:  0101_1110  0x5E   94  ^  
  15263	:  0000_1000  0x08    8    
  15264	:  0100_0001  0x41   65  A  
  15265	:  0010_1101  0x2D   45  -  
  15266	:  0011_0101  0x35   53  5  
  15267	:  0011_0010  0x32   50  2  
  15268	:  0010_1101  0x2D   45  -  
  15269	:  0011_0000  0x30   48  0  
  15270	:  0011_1001  0x39   57  9  
  15271	:  0011_0101  0x35   53  5  
  15272	:  1100_0000  0xC0  192    
  15273	:  0000_1100  0x0C   12    
  15274	:  0000_0000  0x00    0    
  15275	:  0000_0001  0x01    1    
  15276	:  0000_0000  0x00    0    
  15277	:  0000_0001  0x01    1    
  15278	:  0000_0000  0x00    0    
  15279	:  0000_0000  0x00    0    
  15280	:  0010_1010  0x2A   42  *  
  15281	:  0011_0000  0x30   48  0  
  15282	:  0000_0000  0x00    0    
  15283	:  0000_0100  0x04    4    
  15284	:  0010_1101  0x2D   45  -  
  15285	:  0100_0011  0x43   67  C  
  15286	:  0011_0100  0x34   52  4  
  15287	:  0101_1111  0x5F   95  _  
  15288	:  0000_1000  0x08    8    
  15289	:  0100_0001  0x41   65  A  
  15290	:  0010_1101  0x2D   45  -  
  15291	:  0011_0101  0x35   53  5  
  15292	:  0011_0010  0x32   50  2  
  15293	:  0010_1101  0x2D   45  -  
  15294	:  0011_0000  0x30   48  0  
  15295	:  0011_1001  0x39   57  9  
  15296	:  0011_0110  0x36   54  6  
  15297	:  1100_0000  0xC0  192    
  15298	:  0000_1100  0x0C   12    
  15299	:  0000_0000  0x00    0    
  15300	:  0000_0001  0x01    1    
  15301	:  0000_0000  0x00    0    
  15302	:  0000_0001  0x01    1    
  15303	:  0000_0000  0x00    0    
  15304	:  0000_0000  0x00    0    
  15305	:  0010_1010  0x2A   42  *  
  15306	:  0011_0000  0x30   48  0  
  15307	:  0000_0000  0x00    0    
  15308	:  0000_0100  0x04    4    
  15309	:  0010_1101  0x2D   45  -  
  15310	:  0100_0011  0x43   67  C  
  15311	:  0011_0100  0x34   52  4  
  15312	:  0110_0000  0x60   96  `  
  15313	:  0000_1000  0x08    8    
  15314	:  0100_0001  0x41   65  A  
  15315	:  0010_1101  0x2D   45  -  
  15316	:  0011_0101  0x35   53  5  
  15317	:  0011_0010  0x32   50  2  
  15318	:  0010_1101  0x2D   45  -  
  15319	:  0011_0000  0x30   48  0  
  15320	:  0011_1001  0x39   57  9  
  15321	:  0011_0111  0x37   55  7  
  15322	:  1100_0000  0xC0  192    
  15323	:  0000_1100  0x0C   12    
  15324	:  0000_0000  0x00    0    
  15325	:  0000_0001  0x01    1    
  15326	:  0000_0000  0x00    0    
  15327	:  0000_0001  0x01    1    
  15328	:  0000_0000  0x00    0    
  15329	:  0000_0000  0x00    0    
  15330	:  0010_1010  0x2A   42  *  
  15331	:  0011_0000  0x30   48  0  
  15332	:  0000_0000  0x00    0    
  15333	:  0000_0100  0x04    4    
  15334	:  0010_1101  0x2D   45  -  
  15335	:  0100_0011  0x43   67  C  
  15336	:  0011_0100  0x34   52  4  
  15337	:  0110_0001  0x61   97  a  
  15338	:  0000_1000  0x08    8    
  15339	:  0100_0001  0x41   65  A  
  15340	:  0010_1101  0x2D   45  -  
  15341	:  0011_0101  0x35   53  5  
  15342	:  0011_0010  0x32   50  2  
  15343	:  0010_1101  0x2D   45  -  
  15344	:  0011_0000  0x30   48  0  
  15345	:  0011_1001  0x39   57  9  
  15346	:  0011_1000  0x38   56  8  
  15347	:  1100_0000  0xC0  192    
  15348	:  0000_1100  0x0C   12    
  15349	:  0000_0000  0x00    0    
  15350	:  0000_0001  0x01    1    
  15351	:  0000_0000  0x00    0    
  15352	:  0000_0001  0x01    1    
  15353	:  0000_0000  0x00    0    
  15354	:  0000_0000  0x00    0    
  15355	:  0010_1010  0x2A   42  *  
  15356	:  0011_0000  0x30   48  0  
  15357	:  0000_0000  0x00    0    
  15358	:  0000_0100  0x04    4    
  15359	:  0010_1101  0x2D   45  -  
  15360	:  0100_0011  0x43   67  C  
  15361	:  0011_0100  0x34   52  4  
  15362	:  0110_0010  0x62   98  b  
  15363	:  0000_1000  0x08    8    
  15364	:  0100_0001  0x41   65  A  
  15365	:  0010_1101  0x2D   45  -  
  15366	:  0011_0101  0x35   53  5  
  15367	:  0011_0010  0x32   50  2  
  15368	:  0010_1101  0x2D   45  -  
  15369	:  0011_0000  0x30   48  0  
  15370	:  0011_1001  0x39   57  9  
  15371	:  0011_1001  0x39   57  9  
  15372	:  1100_0000  0xC0  192    
  15373	:  0000_1100  0x0C   12    
  15374	:  0000_0000  0x00    0    
  15375	:  0000_0001  0x01    1    
  15376	:  0000_0000  0x00    0    
  15377	:  0000_0001  0x01    1    
  15378	:  0000_0000  0x00    0    
  15379	:  0000_0000  0x00    0    
  15380	:  0010_1010  0x2A   42  *  
  15381	:  0011_0000  0x30   48  0  
  15382	:  0000_0000  0x00    0    
  15383	:  0000_0100  0x04    4    
  15384	:  0010_1101  0x2D   45  -  
  15385	:  0100_0011  0x43   67  C  
  15386	:  0011_0100  0x34   52  4  
  15387	:  0110_0011  0x63   99  c  
  15388	:  0000_1000  0x08    8    
  15389	:  0100_0001  0x41   65  A  
  15390	:  0010_1101  0x2D   45  -  
  15391	:  0011_0101  0x35   53  5  
  15392	:  0011_0010  0x32   50  2  
  15393	:  0010_1101  0x2D   45  -  
  15394	:  0011_0001  0x31   49  1  
  15395	:  0011_0000  0x30   48  0  
  15396	:  0011_0000  0x30   48  0  
  15397	:  1100_0000  0xC0  192    
  15398	:  0000_1100  0x0C   12    
  15399	:  0000_0000  0x00    0    
  15400	:  0000_0001  0x01    1    
  15401	:  0000_0000  0x00    0    
  15402	:  0000_0001  0x01    1    
  15403	:  0000_0000  0x00    0    
  15404	:  0000_0000  0x00    0    
  15405	:  0010_1010  0x2A   42  *  
  15406	:  0011_0000  0x30   48  0  
  15407	:  0000_0000  0x00    0    
  15408	:  0000_0100  0x04    4    
  15409	:  0010_1101  0x2D   45  -  
  15410	:  0100_0011  0x43   67  C  
  15411	:  0011_0100  0x34   52  4  
  15412	:  0110_0100  0x64  100  d  
  15413	:  0000_1000  0x08    8    
  15414	:  0100_0001  0x41   65  A  
  15415	:  0010_1101  0x2D   45  -  
  15416	:  0011_0101  0x35   53  5  
  15417	:  0011_0010  0x32   50  2  
  15418	:  0010_1101  0x2D   45  -  
  15419	:  0011_0001  0x31   49  1  
  15420	:  0011_0000  0x30   48  0  
  15421	:  0011_0001  0x31   49  1  
  15422	:  1100_0000  0xC0  192    
  15423	:  0000_1100  0x0C   12    
  15424	:  0000_0000  0x00    0    
  15425	:  0000_0001  0x01    1    
  15426	:  0000_0000  0x00    0    
  15427	:  0000_0001  0x01    1    
  15428	:  0000_0000  0x00    0    
  15429	:  0000_0000  0x00    0    
  15430	:  0010_1010  0x2A   42  *  
  15431	:  0011_0000  0x30   48  0  
  15432	:  0000_0000  0x00    0    
  15433	:  0000_0100  0x04    4    
  15434	:  0010_1101  0x2D   45  -  
  15435	:  0100_0011  0x43   67  C  
  15436	:  0011_0100  0x34   52  4  
  15437	:  0110_0101  0x65  101  e  
  15438	:  0000_1000  0x08    8    
  15439	:  0100_0001  0x41   65  A  
  15440	:  0010_1101  0x2D   45  -  
  15441	:  0011_0101  0x35   53  5  
  15442	:  0011_0010  0x32   50  2  
  15443	:  0010_1101  0x2D   45  -  
  15444	:  0011_0001  0x31   49  1  
  15445	:  0011_0000  0x30   48  0  
  15446	:  0011_0010  0x32   50  2  
  15447	:  1100_0000  0xC0  192    
  15448	:  0000_1100  0x0C   12    
  15449	:  0000_0000  0x00    0    
  15450	:  0000_0001  0x01    1    
  15451	:  0000_0000  0x00    0    
  15452	:  0000_0001  0x01    1    
  15453	:  0000_0000  0x00    0    
  15454	:  0000_0000  0x00    0    
  15455	:  0010_1010  0x2A   42  *  
  15456	:  0011_0000  0x30   48  0  
  15457	:  0000_0000  0x00    0    
  15458	:  0000_0100  0x04    4    
  15459	:  0010_1101  0x2D   45  -  
  15460	:  0100_0011  0x43   67  C  
  15461	:  0011_0100  0x34   52  4  
  15462	:  0110_0110  0x66  102  f  
  15463	:  0000_1000  0x08    8    
  15464	:  0100_0001  0x41   65  A  
  15465	:  0010_1101  0x2D   45  -  
  15466	:  0011_0101  0x35   53  5  
  15467	:  0011_0010  0x32   50  2  
  15468	:  0010_1101  0x2D   45  -  
  15469	:  0011_0001  0x31   49  1  
  15470	:  0011_0000  0x30   48  0  
  15471	:  0011_0011  0x33   51  3  
  15472	:  1100_0000  0xC0  192    
  15473	:  0000_1100  0x0C   12    
  15474	:  0000_0000  0x00    0    
  15475	:  0000_0001  0x01    1    
  15476	:  0000_0000  0x00    0    
  15477	:  0000_0001  0x01    1    
  15478	:  0000_0000  0x00    0    
  15479	:  0000_0000  0x00    0    
  15480	:  0010_1010  0x2A   42  *  
  15481	:  0011_0000  0x30   48  0  
  15482	:  0000_0000  0x00    0    
  15483	:  0000_0100  0x04    4    
  15484	:  0010_1101  0x2D   45  -  
  15485	:  0100_0011  0x43   67  C  
  15486	:  0011_0100  0x34   52  4  
  15487	:  0110_0111  0x67  103  g  
  15488	:  0000_1000  0x08    8    
  15489	:  0100_0001  0x41   65  A  
  15490	:  0010_1101  0x2D   45  -  
  15491	:  0011_0101  0x35   53  5  
  15492	:  0011_0010  0x32   50  2  
  15493	:  0010_1101  0x2D   45  -  
  15494	:  0011_0001  0x31   49  1  
  15495	:  0011_0000  0x30   48  0  
  15496	:  0011_0100  0x34   52  4  
  15497	:  1100_0000  0xC0  192    
  15498	:  0000_1100  0x0C   12    
  15499	:  0000_0000  0x00    0    
  15500	:  0000_0001  0x01    1    
  15501	:  0000_0000  0x00    0    
  15502	:  0000_0001  0x01    1    
  15503	:  0000_0000  0x00    0    
  15504	:  0000_0000  0x00    0    
  15505	:  0010_1010  0x2A   42  *  
  15506	:  0011_0000  0x30   48  0  
  15507	:  0000_0000  0x00    0    
  15508	:  0000_0100  0x04    4    
  15509	:  0010_1101  0x2D   45  -  
  15510	:  0100_0011  0x43   67  C  
  15511	:  0011_0100  0x34   52  4  
  15512	:  0110_1000  0x68  104  h  
  15513	:  0000_1000  0x08    8    
  15514	:  0100_0001  0x41   65  A  
  15515	:  0010_1101  0x2D   45  -  
  15516	:  0011_0101  0x35   53  5  
  15517	:  0011_0010  0x32   50  2  
  15518	:  0010_1101  0x2D   45  -  
  15519	:  0011_0001  0x31   49  1  
  15520	:  0011_0000  0x30   48  0  
  15521	:  0011_0101  0x35   53  5  
  15522	:  1100_0000  0xC0  192    
  15523	:  0000_1100  0x0C   12    
  15524	:  0000_0000  0x00    0    
  15525	:  0000_0001  0x01    1    
  15526	:  0000_0000  0x00    0    
  15527	:  0000_0001  0x01    1    
  15528	:  0000_0000  0x00    0    
  15529	:  0000_0000  0x00    0    
  15530	:  0010_1010  0x2A   42  *  
  15531	:  0011_0000  0x30   48  0  
  15532	:  0000_0000  0x00    0    
  15533	:  0000_0100  0x04    4    
  15534	:  0010_1101  0x2D   45  -  
  15535	:  0100_0011  0x43   67  C  
  15536	:  0011_0100  0x34   52  4  
  15537	:  0110_1001  0x69  105  i  
  15538	:  0000_1000  0x08    8    
  15539	:  0100_0001  0x41   65  A  
  15540	:  0010_1101  0x2D   45  -  
  15541	:  0011_0101  0x35   53  5  
  15542	:  0011_0010  0x32   50  2  
  15543	:  0010_1101  0x2D   45  -  
  15544	:  0011_0001  0x31   49  1  
  15545	:  0011_0000  0x30   48  0  
  15546	:  0011_0110  0x36   54  6  
  15547	:  1100_0000  0xC0  192    
  15548	:  0000_1100  0x0C   12    
  15549	:  0000_0000  0x00    0    
  15550	:  0000_0001  0x01    1    
  15551	:  0000_0000  0x00    0    
  15552	:  0000_0001  0x01    1    
  15553	:  0000_0000  0x00    0    
  15554	:  0000_0000  0x00    0    
  15555	:  0010_1010  0x2A   42  *  
  15556	:  0011_0000  0x30   48  0  
  15557	:  0000_0000  0x00    0    
  15558	:  0000_0100  0x04    4    
  15559	:  0010_1101  0x2D   45  -  
  15560	:  0100_0011  0x43   67  C  
  15561	:  0011_0100  0x34   52  4  
  15562	:  0110_1010  0x6A  106  j  
  15563	:  0000_1000  0x08    8    
  15564	:  0100_0001  0x41   65  A  
  15565	:  0010_1101  0x2D   45  -  
  15566	:  0011_0101  0x35   53  5  
  15567	:  0011_0010  0x32   50  2  
  15568	:  0010_1101  0x2D   45  -  
  15569	:  0011_0001  0x31   49  1  
  15570	:  0011_0000  0x30   48  0  
  15571	:  0011_0111  0x37   55  7  
  15572	:  1100_0000  0xC0  192    
  15573	:  0000_1100  0x0C   12    
  15574	:  0000_0000  0x00    0    
  15575	:  0000_0001  0x01    1    
  15576	:  0000_0000  0x00    0    
  15577	:  0000_0001  0x01    1    
  15578	:  0000_0000  0x00    0    
  15579	:  0000_0000  0x00    0    
  15580	:  0010_1010  0x2A   42  *  
  15581	:  0011_0000  0x30   48  0  
  15582	:  0000_0000  0x00    0    
  15583	:  0000_0100  0x04    4    
  15584	:  0010_1101  0x2D   45  -  
  15585	:  0100_0011  0x43   67  C  
  15586	:  0011_0100  0x34   52  4  
  15587	:  0110_1011  0x6B  107  k  
  15588	:  0000_1000  0x08    8    
  15589	:  0100_0001  0x41   65  A  
  15590	:  0010_1101  0x2D   45  -  
  15591	:  0011_0101  0x35   53  5  
  15592	:  0011_0010  0x32   50  2  
  15593	:  0010_1101  0x2D   45  -  
  15594	:  0011_0001  0x31   49  1  
  15595	:  0011_0000  0x30   48  0  
  15596	:  0011_1000  0x38   56  8  
  15597	:  1100_0000  0xC0  192    
  15598	:  0000_1100  0x0C   12    
  15599	:  0000_0000  0x00    0    
  15600	:  0000_0001  0x01    1    
  15601	:  0000_0000  0x00    0    
  15602	:  0000_0001  0x01    1    
  15603	:  0000_0000  0x00    0    
  15604	:  0000_0000  0x00    0    
  15605	:  0010_1010  0x2A   42  *  
  15606	:  0011_0000  0x30   48  0  
  15607	:  0000_0000  0x00    0    
  15608	:  0000_0100  0x04    4    
  15609	:  0010_1101  0x2D   45  -  
  15610	:  0100_0011  0x43   67  C  
  15611	:  0011_0100  0x34   52  4  
  15612	:  0110_1100  0x6C  108  l  
  15613	:  0000_1000  0x08    8    
  15614	:  0100_0001  0x41   65  A  
  15615	:  0010_1101  0x2D   45  -  
  15616	:  0011_0101  0x35   53  5  
  15617	:  0011_0010  0x32   50  2  
  15618	:  0010_1101  0x2D   45  -  
  15619	:  0011_0001  0x31   49  1  
  15620	:  0011_0000  0x30   48  0  
  15621	:  0011_1001  0x39   57  9  
  15622	:  1100_0000  0xC0  192    
  15623	:  0000_1100  0x0C   12    
  15624	:  0000_0000  0x00    0    
  15625	:  0000_0001  0x01    1    
  15626	:  0000_0000  0x00    0    
  15627	:  0000_0001  0x01    1    
  15628	:  0000_0000  0x00    0    
  15629	:  0000_0000  0x00    0    
  15630	:  0010_1010  0x2A   42  *  
  15631	:  0011_0000  0x30   48  0  
  15632	:  0000_0000  0x00    0    
  15633	:  0000_0100  0x04    4    
  15634	:  0010_1101  0x2D   45  -  
  15635	:  0100_0011  0x43   67  C  
  15636	:  0011_0100  0x34   52  4  
  15637	:  0110_1101  0x6D  109  m  
  15638	:  0000_1000  0x08    8    
  15639	:  0100_0001  0x41   65  A  
  15640	:  0010_1101  0x2D   45  -  
  15641	:  0011_0101  0x35   53  5  
  15642	:  0011_0010  0x32   50  2  
  15643	:  0010_1101  0x2D   45  -  
  15644	:  0011_0001  0x31   49  1  
  15645	:  0011_0001  0x31   49  1  
  15646	:  0011_0000  0x30   48  0  
  15647	:  1100_0000  0xC0  192    
  15648	:  0000_1100  0x0C   12    
  15649	:  0000_0000  0x00    0    
  15650	:  0000_0001  0x01    1    
  15651	:  0000_0000  0x00    0    
  15652	:  0000_0001  0x01    1    
  15653	:  0000_0000  0x00    0    
  15654	:  0000_0000  0x00    0    
  15655	:  0010_1010  0x2A   42  *  
  15656	:  0011_0000  0x30   48  0  
  15657	:  0000_0000  0x00    0    
  15658	:  0000_0100  0x04    4    
  15659	:  0010_1101  0x2D   45  -  
  15660	:  0100_0011  0x43   67  C  
  15661	:  0011_0100  0x34   52  4  
  15662	:  0110_1110  0x6E  110  n  
  15663	:  0000_1000  0x08    8    
  15664	:  0100_0001  0x41   65  A  
  15665	:  0010_1101  0x2D   45  -  
  15666	:  0011_0101  0x35   53  5  
  15667	:  0011_0010  0x32   50  2  
  15668	:  0010_1101  0x2D   45  -  
  15669	:  0011_0001  0x31   49  1  
  15670	:  0011_0001  0x31   49  1  
  15671	:  0011_0001  0x31   49  1  
  15672	:  1100_0000  0xC0  192    
  15673	:  0000_1100  0x0C   12    
  15674	:  0000_0000  0x00    0    
  15675	:  0000_0001  0x01    1    
  15676	:  0000_0000  0x00    0    
  15677	:  0000_0001  0x01    1    
  15678	:  0000_0000  0x00    0    
  15679	:  0000_0000  0x00    0    
  15680	:  0010_1010  0x2A   42  *  
  15681	:  0011_0000  0x30   48  0  
  15682	:  0000_0000  0x00    0    
  15683	:  0000_0100  0x04    4    
  15684	:  0010_1101  0x2D   45  -  
  15685	:  0100_0011  0x43   67  C  
  15686	:  0011_0100  0x34   52  4  
  15687	:  0110_1111  0x6F  111  o  
  15688	:  0000_1000  0x08    8    
  15689	:  0100_0001  0x41   65  A  
  15690	:  0010_1101  0x2D   45  -  
  15691	:  0011_0101  0x35   53  5  
  15692	:  0011_0010  0x32   50  2  
  15693	:  0010_1101  0x2D   45  -  
  15694	:  0011_0001  0x31   49  1  
  15695	:  0011_0001  0x31   49  1  
  15696	:  0011_0010  0x32   50  2  
  15697	:  1100_0000  0xC0  192    
  15698	:  0000_1100  0x0C   12    
  15699	:  0000_0000  0x00    0    
  15700	:  0000_0001  0x01    1    
  15701	:  0000_0000  0x00    0    
  15702	:  0000_0001  0x01    1    
  15703	:  0000_0000  0x00    0    
  15704	:  0000_0000  0x00    0    
  15705	:  0010_1010  0x2A   42  *  
  15706	:  0011_0000  0x30   48  0  
  15707	:  0000_0000  0x00    0    
  15708	:  0000_0100  0x04    4    
  15709	:  0010_1101  0x2D   45  -  
  15710	:  0100_0011  0x43   67  C  
  15711	:  0011_0100  0x34   52  4  
  15712	:  0111_0000  0x70  112  p  
  15713	:  0000_1000  0x08    8    
  15714	:  0100_0001  0x41   65  A  
  15715	:  0010_1101  0x2D   45  -  
  15716	:  0011_0101  0x35   53  5  
  15717	:  0011_0010  0x32   50  2  
  15718	:  0010_1101  0x2D   45  -  
  15719	:  0011_0001  0x31   49  1  
  15720	:  0011_0001  0x31   49  1  
  15721	:  0011_0011  0x33   51  3  
  15722	:  1100_0000  0xC0  192    
  15723	:  0000_1100  0x0C   12    
  15724	:  0000_0000  0x00    0    
  15725	:  0000_0001  0x01    1    
  15726	:  0000_0000  0x00    0    
  15727	:  0000_0001  0x01    1    
  15728	:  0000_0000  0x00    0    
  15729	:  0000_0000  0x00    0    
  15730	:  0010_1010  0x2A   42  *  
  15731	:  0011_0000  0x30   48  0  
  15732	:  0000_0000  0x00    0    
  15733	:  0000_0100  0x04    4    
  15734	:  0010_1101  0x2D   45  -  
  15735	:  0100_0011  0x43   67  C  
  15736	:  0011_0100  0x34   52  4  
  15737	:  0111_0001  0x71  113  q  
  15738	:  0000_1000  0x08    8    
  15739	:  0100_0001  0x41   65  A  
  15740	:  0010_1101  0x2D   45  -  
  15741	:  0011_0101  0x35   53  5  
  15742	:  0011_0010  0x32   50  2  
  15743	:  0010_1101  0x2D   45  -  
  15744	:  0011_0001  0x31   49  1  
  15745	:  0011_0001  0x31   49  1  
  15746	:  0011_0100  0x34   52  4  
  15747	:  1100_0000  0xC0  192    
  15748	:  0000_1100  0x0C   12    
  15749	:  0000_0000  0x00    0    
  15750	:  0000_0001  0x01    1    
  15751	:  0000_0000  0x00    0    
  15752	:  0000_0001  0x01    1    
  15753	:  0000_0000  0x00    0    
  15754	:  0000_0000  0x00    0    
  15755	:  0010_1010  0x2A   42  *  
  15756	:  0011_0000  0x30   48  0  
  15757	:  0000_0000  0x00    0    
  15758	:  0000_0100  0x04    4    
  15759	:  0010_1101  0x2D   45  -  
  15760	:  0100_0011  0x43   67  C  
  15761	:  0011_0100  0x34   52  4  
  15762	:  0111_0010  0x72  114  r  
  15763	:  0000_1000  0x08    8    
  15764	:  0100_0001  0x41   65  A  
  15765	:  0010_1101  0x2D   45  -  
  15766	:  0011_0101  0x35   53  5  
  15767	:  0011_0010  0x32   50  2  
  15768	:  0010_1101  0x2D   45  -  
  15769	:  0011_0001  0x31   49  1  
  15770	:  0011_0001  0x31   49  1  
  15771	:  0011_0101  0x35   53  5  
  15772	:  1100_0000  0xC0  192    
  15773	:  0000_1100  0x0C   12    
  15774	:  0000_0000  0x00    0    
  15775	:  0000_0001  0x01    1    
  15776	:  0000_0000  0x00    0    
  15777	:  0000_0001  0x01    1    
  15778	:  0000_0000  0x00    0    
  15779	:  0000_0000  0x00    0    
  15780	:  0010_1010  0x2A   42  *  
  15781	:  0011_0000  0x30   48  0  
  15782	:  0000_0000  0x00    0    
  15783	:  0000_0100  0x04    4    
  15784	:  0010_1101  0x2D   45  -  
  15785	:  0100_0011  0x43   67  C  
  15786	:  0011_0100  0x34   52  4  
  15787	:  0111_0011  0x73  115  s  
  15788	:  0000_1000  0x08    8    
  15789	:  0100_0001  0x41   65  A  
  15790	:  0010_1101  0x2D   45  -  
  15791	:  0011_0101  0x35   53  5  
  15792	:  0011_0010  0x32   50  2  
  15793	:  0010_1101  0x2D   45  -  
  15794	:  0011_0001  0x31   49  1  
  15795	:  0011_0001  0x31   49  1  
  15796	:  0011_0110  0x36   54  6  
  15797	:  1100_0000  0xC0  192    
  15798	:  0000_1100  0x0C   12    
  15799	:  0000_0000  0x00    0    
  15800	:  0000_0001  0x01    1    
  15801	:  0000_0000  0x00    0    
  15802	:  0000_0001  0x01    1    
  15803	:  0000_0000  0x00    0    
  15804	:  0000_0000  0x00    0    
  15805	:  0010_1010  0x2A   42  *  
  15806	:  0011_0000  0x30   48  0  
  15807	:  0000_0000  0x00    0    
  15808	:  0000_0100  0x04    4    
  15809	:  0010_1101  0x2D   45  -  
  15810	:  0100_0011  0x43   67  C  
  15811	:  0011_0100  0x34   52  4  
  15812	:  0111_0100  0x74  116  t  
  15813	:  0000_1000  0x08    8    
  15814	:  0100_0001  0x41   65  A  
  15815	:  0010_1101  0x2D   45  -  
  15816	:  0011_0101  0x35   53  5  
  15817	:  0011_0010  0x32   50  2  
  15818	:  0010_1101  0x2D   45  -  
  15819	:  0011_0001  0x31   49  1  
  15820	:  0011_0001  0x31   49  1  
  15821	:  0011_0111  0x37   55  7  
  15822	:  1100_0000  0xC0  192    
  15823	:  0000_1100  0x0C   12    
  15824	:  0000_0000  0x00    0    
  15825	:  0000_0001  0x01    1    
  15826	:  0000_0000  0x00    0    
  15827	:  0000_0001  0x01    1    
  15828	:  0000_0000  0x00    0    
  15829	:  0000_0000  0x00    0    
  15830	:  0010_1010  0x2A   42  *  
  15831	:  0011_0000  0x30   48  0  
  15832	:  0000_0000  0x00    0    
  15833	:  0000_0100  0x04    4    
  15834	:  0010_1101  0x2D   45  -  
  15835	:  0100_0011  0x43   67  C  
  15836	:  0011_0100  0x34   52  4  
  15837	:  0111_0101  0x75  117  u  
  15838	:  0000_1000  0x08    8    
  15839	:  0100_0001  0x41   65  A  
  15840	:  0010_1101  0x2D   45  -  
  15841	:  0011_0101  0x35   53  5  
  15842	:  0011_0010  0x32   50  2  
  15843	:  0010_1101  0x2D   45  -  
  15844	:  0011_0001  0x31   49  1  
  15845	:  0011_0001  0x31   49  1  
  15846	:  0011_1000  0x38   56  8  
  15847	:  1100_0000  0xC0  192    
  15848	:  0000_1100  0x0C   12    
  15849	:  0000_0000  0x00    0    
  15850	:  0000_0001  0x01    1    
  15851	:  0000_0000  0x00    0    
  15852	:  0000_0001  0x01    1    
  15853	:  0000_0000  0x00    0    
  15854	:  0000_0000  0x00    0    
  15855	:  0010_1010  0x2A   42  *  
  15856	:  0011_0000  0x30   48  0  
  15857	:  0000_0000  0x00    0    
  15858	:  0000_0100  0x04    4    
  15859	:  0010_1101  0x2D   45  -  
  15860	:  0100_0011  0x43   67  C  
  15861	:  0011_0100  0x34   52  4  
  15862	:  0111_0110  0x76  118  v  
  15863	:  0000_1000  0x08    8    
  15864	:  0100_0001  0x41   65  A  
  15865	:  0010_1101  0x2D   45  -  
  15866	:  0011_0101  0x35   53  5  
  15867	:  0011_0010  0x32   50  2  
  15868	:  0010_1101  0x2D   45  -  
  15869	:  0011_0001  0x31   49  1  
  15870	:  0011_0001  0x31   49  1  
  15871	:  0011_1001  0x39   57  9  
  15872	:  1100_0000  0xC0  192    
  15873	:  0000_1100  0x0C   12    
  15874	:  0000_0000  0x00    0    
  15875	:  0000_0001  0x01    1    
  15876	:  0000_0000  0x00    0    
  15877	:  0000_0001  0x01    1    
  15878	:  0000_0000  0x00    0    
  15879	:  0000_0000  0x00    0    
  15880	:  0010_1010  0x2A   42  *  
  15881	:  0011_0000  0x30   48  0  
  15882	:  0000_0000  0x00    0    
  15883	:  0000_0100  0x04    4    
  15884	:  0010_1101  0x2D   45  -  
  15885	:  0100_0011  0x43   67  C  
  15886	:  0011_0100  0x34   52  4  
  15887	:  0111_0111  0x77  119  w  
  15888	:  0000_1000  0x08    8    
  15889	:  0100_0001  0x41   65  A  
  15890	:  0010_1101  0x2D   45  -  
  15891	:  0011_0101  0x35   53  5  
  15892	:  0011_0010  0x32   50  2  
  15893	:  0010_1101  0x2D   45  -  
  15894	:  0011_0001  0x31   49  1  
  15895	:  0011_0010  0x32   50  2  
  15896	:  0011_0000  0x30   48  0  
  15897	:  1100_0000  0xC0  192    
  15898	:  0000_1100  0x0C   12    
  15899	:  0000_0000  0x00    0    
  15900	:  0000_0001  0x01    1    
  15901	:  0000_0000  0x00    0    
  15902	:  0000_0001  0x01    1    
  15903	:  0000_0000  0x00    0    
  15904	:  0000_0000  0x00    0    
  15905	:  0010_1010  0x2A   42  *  
  15906	:  0011_0000  0x30   48  0  
  15907	:  0000_0000  0x00    0    
  15908	:  0000_0100  0x04    4    
  15909	:  0010_1101  0x2D   45  -  
  15910	:  0100_0011  0x43   67  C  
  15911	:  0011_0100  0x34   52  4  
  15912	:  0111_1000  0x78  120  x  
  15913	:  0000_1000  0x08    8    
  15914	:  0100_0001  0x41   65  A  
  15915	:  0010_1101  0x2D   45  -  
  15916	:  0011_0101  0x35   53  5  
  15917	:  0011_0010  0x32   50  2  
  15918	:  0010_1101  0x2D   45  -  
  15919	:  0011_0001  0x31   49  1  
  15920	:  0011_0010  0x32   50  2  
  15921	:  0011_0001  0x31   49  1  
  15922	:  1100_0000  0xC0  192    
  15923	:  0000_1100  0x0C   12    
  15924	:  0000_0000  0x00    0    
  15925	:  0000_0001  0x01    1    
  15926	:  0000_0000  0x00    0    
  15927	:  0000_0001  0x01    1    
  15928	:  0000_0000  0x00    0    
  15929	:  0000_0000  0x00    0    
  15930	:  0010_1010  0x2A   42  *  
  15931	:  0011_0000  0x30   48  0  
  15932	:  0000_0000  0x00    0    
  15933	:  0000_0100  0x04    4    
  15934	:  0010_1101  0x2D   45  -  
  15935	:  0100_0011  0x43   67  C  
  15936	:  0011_0100  0x34   52  4  
  15937	:  0111_1001  0x79  121  y  
  15938	:  0000_1000  0x08    8    
  15939	:  0100_0001  0x41   65  A  
  15940	:  0010_1101  0x2D   45  -  
  15941	:  0011_0101  0x35   53  5  
  15942	:  0011_0010  0x32   50  2  
  15943	:  0010_1101  0x2D   45  -  
  15944	:  0011_0001  0x31   49  1  
  15945	:  0011_0010  0x32   50  2  
  15946	:  0011_0010  0x32   50  2  
  15947	:  1100_0000  0xC0  192    
  15948	:  0000_1100  0x0C   12    
  15949	:  0000_0000  0x00    0    
  15950	:  0000_0001  0x01    1    
  15951	:  0000_0000  0x00    0    
  15952	:  0000_0001  0x01    1    
  15953	:  0000_0000  0x00    0    
  15954	:  0000_0000  0x00    0    
  15955	:  0010_1010  0x2A   42  *  
  15956	:  0011_0000  0x30   48  0  
  15957	:  0000_0000  0x00    0    
  15958	:  0000_0100  0x04    4    
  15959	:  0010_1101  0x2D   45  -  
  15960	:  0100_0011  0x43   67  C  
  15961	:  0011_0100  0x34   52  4  
  15962	:  0111_1010  0x7A  122  z  
  15963	:  0000_1000  0x08    8    
  15964	:  0100_0001  0x41   65  A  
  15965	:  0010_1101  0x2D   45  -  
  15966	:  0011_0101  0x35   53  5  
  15967	:  0011_0010  0x32   50  2  
  15968	:  0010_1101  0x2D   45  -  
  15969	:  0011_0001  0x31   49  1  
  15970	:  0011_0010  0x32   50  2  
  15971	:  0011_0011  0x33   51  3  
  15972	:  1100_0000  0xC0  192    
  15973	:  0000_1100  0x0C   12    
  15974	:  0000_0000  0x00    0    
  15975	:  0000_0001  0x01    1    
  15976	:  0000_0000  0x00    0    
  15977	:  0000_0001  0x01    1    
  15978	:  0000_0000  0x00    0    
  15979	:  0000_0000  0x00    0    
  15980	:  0010_1010  0x2A   42  *  
  15981	:  0011_0000  0x30   48  0  
  15982	:  0000_0000  0x00    0    
  15983	:  0000_0100  0x04    4    
  15984	:  0010_1101  0x2D   45  -  
  15985	:  0100_0011  0x43   67  C  
  15986	:  0011_0100  0x34   52  4  
  15987	:  0111_1011  0x7B  123  {  
  15988	:  0000_1000  0x08    8    
  15989	:  0100_0001  0x41   65  A  
  15990	:  0010_1101  0x2D   45  -  
  15991	:  0011_0101  0x35   53  5  
  15992	:  0011_0010  0x32   50  2  
  15993	:  0010_1101  0x2D   45  -  
  15994	:  0011_0001  0x31   49  1  
  15995	:  0011_0010  0x32   50  2  
  15996	:  0011_0100  0x34   52  4  
  15997	:  1100_0000  0xC0  192    
  15998	:  0000_1100  0x0C   12    
  15999	:  0000_0000  0x00    0    
  16000	:  0000_0001  0x01    1    
  16001	:  0000_0000  0x00    0    
  16002	:  0000_0001  0x01    1    
  16003	:  0000_0000  0x00    0    
  16004	:  0000_0000  0x00    0    
  16005	:  0010_1010  0x2A   42  *  
  16006	:  0011_0000  0x30   48  0  
  16007	:  0000_0000  0x00    0    
  16008	:  0000_0100  0x04    4    
  16009	:  0010_1101  0x2D   45  -  
  16010	:  0100_0011  0x43   67  C  
  16011	:  0011_0100  0x34   52  4  
  16012	:  0111_1100  0x7C  124  |.'|'.q|  
  16013	:  0000_1000  0x08    8    
  16014	:  0100_0001  0x41   65  A  
  16015	:  0010_1101  0x2D   45  -  
  16016	:  0011_0101  0x35   53  5  
  16017	:  0011_0010  0x32   50  2  
  16018	:  0010_1101  0x2D   45  -  
  16019	:  0011_0001  0x31   49  1  
  16020	:  0011_0010  0x32   50  2  
  16021	:  0011_0101  0x35   53  5  
  16022	:  1100_0000  0xC0  192    
  16023	:  0000_1100  0x0C   12    
  16024	:  0000_0000  0x00    0    
  16025	:  0000_0001  0x01    1    
  16026	:  0000_0000  0x00    0    
  16027	:  0000_0001  0x01    1    
  16028	:  0000_0000  0x00    0    
  16029	:  0000_0000  0x00    0    
  16030	:  0010_1010  0x2A   42  *  
  16031	:  0011_0000  0x30   48  0  
  16032	:  0000_0000  0x00    0    
  16033	:  0000_0100  0x04    4    
  16034	:  0010_1101  0x2D   45  -  
  16035	:  0100_0011  0x43   67  C  
  16036	:  0011_0100  0x34   52  4  
  16037	:  0111_1101  0x7D  125  }  
  16038	:  0000_1000  0x08    8    
  16039	:  0100_0001  0x41   65  A  
  16040	:  0010_1101  0x2D   45  -  
  16041	:  0011_0101  0x35   53  5  
  16042	:  0011_0010  0x32   50  2  
  16043	:  0010_1101  0x2D   45  -  
  16044	:  0011_0001  0x31   49  1  
  16045	:  0011_0010  0x32   50  2  
  16046	:  0011_0110  0x36   54  6  
  16047	:  1100_0000  0xC0  192    
  16048	:  0000_1100  0x0C   12    
  16049	:  0000_0000  0x00    0    
  16050	:  0000_0001  0x01    1    
  16051	:  0000_0000  0x00    0    
  16052	:  0000_0001  0x01    1    
  16053	:  0000_0000  0x00    0    
  16054	:  0000_0000  0x00    0    
  16055	:  0010_1010  0x2A   42  *  
  16056	:  0011_0000  0x30   48  0  
  16057	:  0000_0000  0x00    0    
  16058	:  0000_0100  0x04    4    
  16059	:  0010_1101  0x2D   45  -  
  16060	:  0100_0011  0x43   67  C  
  16061	:  0011_0100  0x34   52  4  
  16062	:  0111_1110  0x7E  126  ~  
  16063	:  0000_1000  0x08    8    
  16064	:  0100_0001  0x41   65  A  
  16065	:  0010_1101  0x2D   45  -  
  16066	:  0011_0101  0x35   53  5  
  16067	:  0011_0010  0x32   50  2  
  16068	:  0010_1101  0x2D   45  -  
  16069	:  0011_0001  0x31   49  1  
  16070	:  0011_0010  0x32   50  2  
  16071	:  0011_0111  0x37   55  7  
  16072	:  1100_0000  0xC0  192    
  16073	:  0000_1100  0x0C   12    
  16074	:  0000_0000  0x00    0    
  16075	:  0000_0001  0x01    1    
  16076	:  0000_0000  0x00    0    
  16077	:  0000_0001  0x01    1    
  16078	:  0000_0000  0x00    0    
  16079	:  0000_0000  0x00    0    
  16080	:  0010_1010  0x2A   42  *  
  16081	:  0011_0000  0x30   48  0  
  16082	:  0000_0000  0x00    0    
  16083	:  0000_0100  0x04    4    
  16084	:  0010_1101  0x2D   45  -  
  16085	:  0100_0011  0x43   67  C  
  16086	:  0011_0100  0x34   52  4  
  16087	:  0111_1111  0x7F  127    
  16088	:  0000_1000  0x08    8    
  16089	:  0100_0001  0x41   65  A  
  16090	:  0010_1101  0x2D   45  -  
  16091	:  0011_0101  0x35   53  5  
  16092	:  0011_0010  0x32   50  2  
  16093	:  0010_1101  0x2D   45  -  
  16094	:  0011_0001  0x31   49  1  
  16095	:  0011_0010  0x32   50  2  
  16096	:  0011_1000  0x38   56  8  
  16097	:  1100_0000  0xC0  192    
  16098	:  0000_1100  0x0C   12    
  16099	:  0000_0000  0x00    0    
  16100	:  0000_0001  0x01    1    
  16101	:  0000_0000  0x00    0    
  16102	:  0000_0001  0x01    1    
  16103	:  0000_0000  0x00    0    
  16104	:  0000_0000  0x00    0    
  16105	:  0010_1010  0x2A   42  *  
  16106	:  0011_0000  0x30   48  0  
  16107	:  0000_0000  0x00    0    
  16108	:  0000_0100  0x04    4    
  16109	:  0010_1101  0x2D   45  -  
  16110	:  0100_0011  0x43   67  C  
  16111	:  0011_0100  0x34   52  4  
  16112	:  1000_0000  0x80  128    
  16113	:  0000_1000  0x08    8    
  16114	:  0100_0001  0x41   65  A  
  16115	:  0010_1101  0x2D   45  -  
  16116	:  0011_0101  0x35   53  5  
  16117	:  0011_0010  0x32   50  2  
  16118	:  0010_1101  0x2D   45  -  
  16119	:  0011_0001  0x31   49  1  
  16120	:  0011_0010  0x32   50  2  
  16121	:  0011_1001  0x39   57  9  
  16122	:  1100_0000  0xC0  192    
  16123	:  0000_1100  0x0C   12    
  16124	:  0000_0000  0x00    0    
  16125	:  0000_0001  0x01    1    
  16126	:  0000_0000  0x00    0    
  16127	:  0000_0001  0x01    1    
  16128	:  0000_0000  0x00    0    
  16129	:  0000_0000  0x00    0    
  16130	:  0010_1010  0x2A   42  *  
  16131	:  0011_0000  0x30   48  0  
  16132	:  0000_0000  0x00    0    
  16133	:  0000_0100  0x04    4    
  16134	:  0010_1101  0x2D   45  -  
  16135	:  0100_0011  0x43   67  C  
  16136	:  0011_0100  0x34   52  4  
  16137	:  1000_0001  0x81  129    
  16138	:  0000_1000  0x08    8    
  16139	:  0100_0001  0x41   65  A  
  16140	:  0010_1101  0x2D   45  -  
  16141	:  0011_0101  0x35   53  5  
  16142	:  0011_0010  0x32   50  2  
  16143	:  0010_1101  0x2D   45  -  
  16144	:  0011_0001  0x31   49  1  
  16145	:  0011_0011  0x33   51  3  
  16146	:  0011_0000  0x30   48  0  
  16147	:  1100_0000  0xC0  192    
  16148	:  0000_1100  0x0C   12    
  16149	:  0000_0000  0x00    0    
  16150	:  0000_0001  0x01    1    
  16151	:  0000_0000  0x00    0    
  16152	:  0000_0001  0x01    1    
  16153	:  0000_0000  0x00    0    
  16154	:  0000_0000  0x00    0    
  16155	:  0010_1010  0x2A   42  *  
  16156	:  0011_0000  0x30   48  0  
  16157	:  0000_0000  0x00    0    
  16158	:  0000_0100  0x04    4    
  16159	:  0010_1101  0x2D   45  -  
  16160	:  0100_0011  0x43   67  C  
  16161	:  0011_0100  0x34   52  4  
  16162	:  1000_0010  0x82  130    
  16163	:  0000_1000  0x08    8    
  16164	:  0100_0001  0x41   65  A  
  16165	:  0010_1101  0x2D   45  -  
  16166	:  0011_0101  0x35   53  5  
  16167	:  0011_0010  0x32   50  2  
  16168	:  0010_1101  0x2D   45  -  
  16169	:  0011_0001  0x31   49  1  
  16170	:  0011_0011  0x33   51  3  
  16171	:  0011_0001  0x31   49  1  
  16172	:  1100_0000  0xC0  192    
  16173	:  0000_1100  0x0C   12    
  16174	:  0000_0000  0x00    0    
  16175	:  0000_0001  0x01    1    
  16176	:  0000_0000  0x00    0    
  16177	:  0000_0001  0x01    1    
  16178	:  0000_0000  0x00    0    
  16179	:  0000_0000  0x00    0    
  16180	:  0010_1010  0x2A   42  *  
  16181	:  0011_0000  0x30   48  0  
  16182	:  0000_0000  0x00    0    
  16183	:  0000_0100  0x04    4    
  16184	:  0010_1101  0x2D   45  -  
  16185	:  0100_0011  0x43   67  C  
  16186	:  0011_0100  0x34   52  4  
  16187	:  1000_0011  0x83  131    
  16188	:  0000_1000  0x08    8    
  16189	:  0100_0001  0x41   65  A  
  16190	:  0010_1101  0x2D   45  -  
  16191	:  0011_0101  0x35   53  5  
  16192	:  0011_0010  0x32   50  2  
  16193	:  0010_1101  0x2D   45  -  
  16194	:  0011_0001  0x31   49  1  
  16195	:  0011_0011  0x33   51  3  
  16196	:  0011_0010  0x32   50  2  
  16197	:  1100_0000  0xC0  192    
  16198	:  0000_1100  0x0C   12    
  16199	:  0000_0000  0x00    0    
  16200	:  0000_0001  0x01    1    
  16201	:  0000_0000  0x00    0    
  16202	:  0000_0001  0x01    1    
  16203	:  0000_0000  0x00    0    
  16204	:  0000_0000  0x00    0    
  16205	:  0010_1010  0x2A   42  *  
  16206	:  0011_0000  0x30   48  0  
  16207	:  0000_0000  0x00    0    
  16208	:  0000_0100  0x04    4    
  16209	:  0010_1101  0x2D   45  -  
  16210	:  0100_0011  0x43   67  C  
  16211	:  0011_0100  0x34   52  4  
  16212	:  1000_0100  0x84  132    
  16213	:  0000_1000  0x08    8    
  16214	:  0100_0001  0x41   65  A  
  16215	:  0010_1101  0x2D   45  -  
  16216	:  0011_0101  0x35   53  5  
  16217	:  0011_0010  0x32   50  2  
  16218	:  0010_1101  0x2D   45  -  
  16219	:  0011_0001  0x31   49  1  
  16220	:  0011_0011  0x33   51  3  
  16221	:  0011_0011  0x33   51  3  
  16222	:  1100_0000  0xC0  192    
  16223	:  0000_1100  0x0C   12    
  16224	:  0000_0000  0x00    0    
  16225	:  0000_0001  0x01    1    
  16226	:  0000_0000  0x00    0    
  16227	:  0000_0001  0x01    1    
  16228	:  0000_0000  0x00    0    
  16229	:  0000_0000  0x00    0    
  16230	:  0010_1010  0x2A   42  *  
  16231	:  0011_0000  0x30   48  0  
  16232	:  0000_0000  0x00    0    
  16233	:  0000_0100  0x04    4    
  16234	:  0010_1101  0x2D   45  -  
  16235	:  0100_0011  0x43   67  C  
  16236	:  0011_0100  0x34   52  4  
  16237	:  1000_0101  0x85  133    
  16238	:  0000_1000  0x08    8    
  16239	:  0100_0001  0x41   65  A  
  16240	:  0010_1101  0x2D   45  -  
  16241	:  0011_0101  0x35   53  5  
  16242	:  0011_0010  0x32   50  2  
  16243	:  0010_1101  0x2D   45  -  
  16244	:  0011_0001  0x31   49  1  
  16245	:  0011_0011  0x33   51  3  
  16246	:  0011_0100  0x34   52  4  
  16247	:  1100_0000  0xC0  192    
  16248	:  0000_1100  0x0C   12    
  16249	:  0000_0000  0x00    0    
  16250	:  0000_0001  0x01    1    
  16251	:  0000_0000  0x00    0    
  16252	:  0000_0001  0x01    1    
  16253	:  0000_0000  0x00    0    
  16254	:  0000_0000  0x00    0    
  16255	:  0010_1010  0x2A   42  *  
  16256	:  0011_0000  0x30   48  0  
  16257	:  0000_0000  0x00    0    
  16258	:  0000_0100  0x04    4    
  16259	:  0010_1101  0x2D   45  -  
  16260	:  0100_0011  0x43   67  C  
  16261	:  0011_0100  0x34   52  4  
  16262	:  1000_0110  0x86  134    
  16263	:  0000_1000  0x08    8    
  16264	:  0100_0001  0x41   65  A  
  16265	:  0010_1101  0x2D   45  -  
  16266	:  0011_0101  0x35   53  5  
  16267	:  0011_0010  0x32   50  2  
  16268	:  0010_1101  0x2D   45  -  
  16269	:  0011_0001  0x31   49  1  
  16270	:  0011_0011  0x33   51  3  
  16271	:  0011_0101  0x35   53  5  
  16272	:  1100_0000  0xC0  192    
  16273	:  0000_1100  0x0C   12    
  16274	:  0000_0000  0x00    0    
  16275	:  0000_0001  0x01    1    
  16276	:  0000_0000  0x00    0    
  16277	:  0000_0001  0x01    1    
  16278	:  0000_0000  0x00    0    
  16279	:  0000_0000  0x00    0    
  16280	:  0010_1010  0x2A   42  *  
  16281	:  0011_0000  0x30   48  0  
  16282	:  0000_0000  0x00    0    
  16283	:  0000_0100  0x04    4    
  16284	:  0010_1101  0x2D   45  -  
  16285	:  0100_0011  0x43   67  C  
  16286	:  0011_0100  0x34   52  4  
  16287	:  1000_0111  0x87  135    
  16288	:  0000_1000  0x08    8    
  16289	:  0100_0001  0x41   65  A  
  16290	:  0010_1101  0x2D   45  -  
  16291	:  0011_0101  0x35   53  5  
  16292	:  0011_0010  0x32   50  2  
  16293	:  0010_1101  0x2D   45  -  
  16294	:  0011_0001  0x31   49  1  
  16295	:  0011_0011  0x33   51  3  
  16296	:  0011_0110  0x36   54  6  
  16297	:  1100_0000  0xC0  192    
  16298	:  0000_1100  0x0C   12    
  16299	:  0000_0000  0x00    0    
  16300	:  0000_0001  0x01    1    
  16301	:  0000_0000  0x00    0    
  16302	:  0000_0001  0x01    1    
  16303	:  0000_0000  0x00    0    
  16304	:  0000_0000  0x00    0    
  16305	:  0010_1010  0x2A   42  *  
  16306	:  0011_0000  0x30   48  0  
  16307	:  0000_0000  0x00    0    
  16308	:  0000_0100  0x04    4    
  16309	:  0010_1101  0x2D   45  -  
  16310	:  0100_0011  0x43   67  C  
  16311	:  0011_0100  0x34   52  4  
  16312	:  1000_1000  0x88  136    
  16313	:  0000_1000  0x08    8    
  16314	:  0100_0001  0x41   65  A  
  16315	:  0010_1101  0x2D   45  -  
  16316	:  0011_0101  0x35   53  5  
  16317	:  0011_0010  0x32   50  2  
  16318	:  0010_1101  0x2D   45  -  
  16319	:  0011_0001  0x31   49  1  
  16320	:  0011_0011  0x33   51  3  
  16321	:  0011_0111  0x37   55  7  
  16322	:  1100_0000  0xC0  192    
  16323	:  0000_1100  0x0C   12    
  16324	:  0000_0000  0x00    0    
  16325	:  0000_0001  0x01    1    
  16326	:  0000_0000  0x00    0    
  16327	:  0000_0001  0x01    1    
  16328	:  0000_0000  0x00    0    
  16329	:  0000_0000  0x00    0    
  16330	:  0010_1010  0x2A   42  *  
  16331	:  0011_0000  0x30   48  0  
  16332	:  0000_0000  0x00    0    
  16333	:  0000_0100  0x04    4    
  16334	:  0010_1101  0x2D   45  -  
  16335	:  0100_0011  0x43   67  C  
  16336	:  0011_0100  0x34   52  4  
  16337	:  1000_1001  0x89  137    
  16338	:  0000_1000  0x08    8    
  16339	:  0100_0001  0x41   65  A  
  16340	:  0010_1101  0x2D   45  -  
  16341	:  0011_0101  0x35   53  5  
  16342	:  0011_0010  0x32   50  2  
  16343	:  0010_1101  0x2D   45  -  
  16344	:  0011_0001  0x31   49  1  
  16345	:  0011_0011  0x33   51  3  
  16346	:  0011_1000  0x38   56  8  
  16347	:  1100_0000  0xC0  192    
  16348	:  0000_1100  0x0C   12    
  16349	:  0000_0000  0x00    0    
  16350	:  0000_0001  0x01    1    
  16351	:  0000_0000  0x00    0    
  16352	:  0000_0001  0x01    1    
  16353	:  0000_0000  0x00    0    
  16354	:  0000_0000  0x00    0    
  16355	:  0010_1010  0x2A   42  *  
  16356	:  0011_0000  0x30   48  0  
  16357	:  0000_0000  0x00    0    
  16358	:  0000_0100  0x04    4    
  16359	:  0010_1101  0x2D   45  -  
  16360	:  0100_0011  0x43   67  C  
  16361	:  0011_0100  0x34   52  4  
  16362	:  1000_1010  0x8A  138    
  16363	:  0000_1000  0x08    8    
  16364	:  0100_0001  0x41   65  A  
  16365	:  0010_1101  0x2D   45  -  
  16366	:  0011_0101  0x35   53  5  
  16367	:  0011_0010  0x32   50  2  
  16368	:  0010_1101  0x2D   45  -  
  16369	:  0011_0001  0x31   49  1  
  16370	:  0011_0011  0x33   51  3  
  16371	:  0011_1001  0x39   57  9  
  16372	:  1100_0000  0xC0  192    
  16373	:  0000_1100  0x0C   12    
  16374	:  0000_0000  0x00    0    
  16375	:  0000_0001  0x01    1    
  16376	:  0000_0000  0x00    0    
  16377	:  0000_0001  0x01    1    
  16378	:  0000_0000  0x00    0    
  16379	:  0000_0000  0x00    0    
  16380	:  0010_1010  0x2A   42  *  
  16381	:  0011_0000  0x30   48  0  
  16382	:  0000_0000  0x00    0    
  16383	:  0000_0100  0x04    4    
  16384	:  0010_1101  0x2D   45  -  
  16385	:  0100_0011  0x43   67  C  
  16386	:  0011_0100  0x34   52  4  
  16387	:  1000_1011  0x8B  139    
  16388	:  0000_1000  0x08    8    
  16389	:  0100_0001  0x41   65  A  
  16390	:  0010_1101  0x2D   45  -  
  16391	:  0011_0101  0x35   53  5  
  16392	:  0011_0010  0x32   50  2  
  16393	:  0010_1101  0x2D   45  -  
  16394	:  0011_0001  0x31   49  1  
  16395	:  0011_0100  0x34   52  4  
  16396	:  0011_0000  0x30   48  0  
  16397	:  1100_0000  0xC0  192    
  16398	:  0000_1100  0x0C   12    
  16399	:  0000_0000  0x00    0    
  16400	:  0000_0001  0x01    1    
  16401	:  0000_0000  0x00    0    
  16402	:  0000_0001  0x01    1    
  16403	:  0000_0000  0x00    0    
  16404	:  0000_0000  0x00    0    
  16405	:  0010_1010  0x2A   42  *  
  16406	:  0011_0000  0x30   48  0  
  16407	:  0000_0000  0x00    0    
  16408	:  0000_0100  0x04    4    
  16409	:  0010_1101  0x2D   45  -  
  16410	:  0100_0011  0x43   67  C  
  16411	:  0011_0100  0x34   52  4  
  16412	:  1000_1100  0x8C  140    
  16413	:  0000_1000  0x08    8    
  16414	:  0100_0001  0x41   65  A  
  16415	:  0010_1101  0x2D   45  -  
  16416	:  0011_0101  0x35   53  5  
  16417	:  0011_0010  0x32   50  2  
  16418	:  0010_1101  0x2D   45  -  
  16419	:  0011_0001  0x31   49  1  
  16420	:  0011_0100  0x34   52  4  
  16421	:  0011_0001  0x31   49  1  
  16422	:  1100_0000  0xC0  192    
  16423	:  0000_1100  0x0C   12    
  16424	:  0000_0000  0x00    0    
  16425	:  0000_0001  0x01    1    
  16426	:  0000_0000  0x00    0    
  16427	:  0000_0001  0x01    1    
  16428	:  0000_0000  0x00    0    
  16429	:  0000_0000  0x00    0    
  16430	:  0010_1010  0x2A   42  *  
  16431	:  0011_0000  0x30   48  0  
  16432	:  0000_0000  0x00    0    
  16433	:  0000_0100  0x04    4    
  16434	:  0010_1101  0x2D   45  -  
  16435	:  0100_0011  0x43   67  C  
  16436	:  0011_0100  0x34   52  4  
  16437	:  1000_1101  0x8D  141    
  16438	:  0000_1000  0x08    8    
  16439	:  0100_0001  0x41   65  A  
  16440	:  0010_1101  0x2D   45  -  
  16441	:  0011_0101  0x35   53  5  
  16442	:  0011_0010  0x32   50  2  
  16443	:  0010_1101  0x2D   45  -  
  16444	:  0011_0001  0x31   49  1  
  16445	:  0011_0100  0x34   52  4  
  16446	:  0011_0010  0x32   50  2  
  16447	:  1100_0000  0xC0  192    
  16448	:  0000_1100  0x0C   12    
  16449	:  0000_0000  0x00    0    
  16450	:  0000_0001  0x01    1    
  16451	:  0000_0000  0x00    0    
  16452	:  0000_0001  0x01    1    
  16453	:  0000_0000  0x00    0    
  16454	:  0000_0000  0x00    0    
  16455	:  0010_1010  0x2A   42  *  
  16456	:  0011_0000  0x30   48  0  
  16457	:  0000_0000  0x00    0    
  16458	:  0000_0100  0x04    4    
  16459	:  0010_1101  0x2D   45  -  
  16460	:  0100_0011  0x43   67  C  
  16461	:  0011_0100  0x34   52  4  
  16462	:  1000_1110  0x8E  142    
  16463	:  0000_1000  0x08    8    
  16464	:  0100_0001  0x41   65  A  
  16465	:  0010_1101  0x2D   45  -  
  16466	:  0011_0101  0x35   53  5  
  16467	:  0011_0010  0x32   50  2  
  16468	:  0010_1101  0x2D   45  -  
  16469	:  0011_0001  0x31   49  1  
  16470	:  0011_0100  0x34   52  4  
  16471	:  0011_0011  0x33   51  3  
  16472	:  1100_0000  0xC0  192    
  16473	:  0000_1100  0x0C   12    
  16474	:  0000_0000  0x00    0    
  16475	:  0000_0001  0x01    1    
  16476	:  0000_0000  0x00    0    
  16477	:  0000_0001  0x01    1    
  16478	:  0000_0000  0x00    0    
  16479	:  0000_0000  0x00    0    
  16480	:  0010_1010  0x2A   42  *  
  16481	:  0011_0000  0x30   48  0  
  16482	:  0000_0000  0x00    0    
  16483	:  0000_0100  0x04    4    
  16484	:  0010_1101  0x2D   45  -  
  16485	:  0100_0011  0x43   67  C  
  16486	:  0011_0100  0x34   52  4  
  16487	:  1000_1111  0x8F  143    
  16488	:  0000_1000  0x08    8    
  16489	:  0100_0001  0x41   65  A  
  16490	:  0010_1101  0x2D   45  -  
  16491	:  0011_0101  0x35   53  5  
  16492	:  0011_0010  0x32   50  2  
  16493	:  0010_1101  0x2D   45  -  
  16494	:  0011_0001  0x31   49  1  
  16495	:  0011_0100  0x34   52  4  
  16496	:  0011_0100  0x34   52  4  
  16497	:  1100_0000  0xC0  192    
  16498	:  0000_1100  0x0C   12    
  16499	:  0000_0000  0x00    0    
  16500	:  0000_0001  0x01    1    
  16501	:  0000_0000  0x00    0    
  16502	:  0000_0001  0x01    1    
  16503	:  0000_0000  0x00    0    
  16504	:  0000_0000  0x00    0    
  16505	:  0010_1010  0x2A   42  *  
  16506	:  0011_0000  0x30   48  0  
  16507	:  0000_0000  0x00    0    
  16508	:  0000_0100  0x04    4    
  16509	:  0010_1101  0x2D   45  -  
  16510	:  0100_0011  0x43   67  C  
  16511	:  0011_0100  0x34   52  4  
  16512	:  1001_0000  0x90  144    
  16513	:  0000_1000  0x08    8    
  16514	:  0100_0001  0x41   65  A  
  16515	:  0010_1101  0x2D   45  -  
  16516	:  0011_0101  0x35   53  5  
  16517	:  0011_0010  0x32   50  2  
  16518	:  0010_1101  0x2D   45  -  
  16519	:  0011_0001  0x31   49  1  
  16520	:  0011_0100  0x34   52  4  
  16521	:  0011_0101  0x35   53  5  
  16522	:  1100_0000  0xC0  192    
  16523	:  0000_1100  0x0C   12    
  16524	:  0000_0000  0x00    0    
  16525	:  0000_0001  0x01    1    
  16526	:  0000_0000  0x00    0    
  16527	:  0000_0001  0x01    1    
  16528	:  0000_0000  0x00    0    
  16529	:  0000_0000  0x00    0    
  16530	:  0010_1010  0x2A   42  *  
  16531	:  0011_0000  0x30   48  0  
  16532	:  0000_0000  0x00    0    
  16533	:  0000_0100  0x04    4    
  16534	:  0010_1101  0x2D   45  -  
  16535	:  0100_0011  0x43   67  C  
  16536	:  0011_0100  0x34   52  4  
  16537	:  1001_0001  0x91  145    
  16538	:  0000_1000  0x08    8    
  16539	:  0100_0001  0x41   65  A  
  16540	:  0010_1101  0x2D   45  -  
  16541	:  0011_0101  0x35   53  5  
  16542	:  0011_0010  0x32   50  2  
  16543	:  0010_1101  0x2D   45  -  
  16544	:  0011_0001  0x31   49  1  
  16545	:  0011_0100  0x34   52  4  
  16546	:  0011_0110  0x36   54  6  
  16547	:  1100_0000  0xC0  192    
  16548	:  0000_1100  0x0C   12    
  16549	:  0000_0000  0x00    0    
  16550	:  0000_0001  0x01    1    
  16551	:  0000_0000  0x00    0    
  16552	:  0000_0001  0x01    1    
  16553	:  0000_0000  0x00    0    
  16554	:  0000_0000  0x00    0    
  16555	:  0010_1010  0x2A   42  *  
  16556	:  0011_0000  0x30   48  0  
  16557	:  0000_0000  0x00    0    
  16558	:  0000_0100  0x04    4    
  16559	:  0010_1101  0x2D   45  -  
  16560	:  0100_0011  0x43   67  C  
  16561	:  0011_0100  0x34   52  4  
  16562	:  1001_0010  0x92  146    
  16563	:  0000_1000  0x08    8    
  16564	:  0100_0001  0x41   65  A  
  16565	:  0010_1101  0x2D   45  -  
  16566	:  0011_0101  0x35   53  5  
  16567	:  0011_0010  0x32   50  2  
  16568	:  0010_1101  0x2D   45  -  
  16569	:  0011_0001  0x31   49  1  
  16570	:  0011_0100  0x34   52  4  
  16571	:  0011_0111  0x37   55  7  
  16572	:  1100_0000  0xC0  192    
  16573	:  0000_1100  0x0C   12    
  16574	:  0000_0000  0x00    0    
  16575	:  0000_0001  0x01    1    
  16576	:  0000_0000  0x00    0    
  16577	:  0000_0001  0x01    1    
  16578	:  0000_0000  0x00    0    
  16579	:  0000_0000  0x00    0    
  16580	:  0010_1010  0x2A   42  *  
  16581	:  0011_0000  0x30   48  0  
  16582	:  0000_0000  0x00    0    
  16583	:  0000_0100  0x04    4    
  16584	:  0010_1101  0x2D   45  -  
  16585	:  0100_0011  0x43   67  C  
  16586	:  0011_0100  0x34   52  4  
  16587	:  1001_0011  0x93  147    
  16588	:  0000_1000  0x08    8    
  16589	:  0100_0001  0x41   65  A  
  16590	:  0010_1101  0x2D   45  -  
  16591	:  0011_0101  0x35   53  5  
  16592	:  0011_0010  0x32   50  2  
  16593	:  0010_1101  0x2D   45  -  
  16594	:  0011_0001  0x31   49  1  
  16595	:  0011_0100  0x34   52  4  
  16596	:  0011_1000  0x38   56  8  
  16597	:  1100_0000  0xC0  192    
  16598	:  0000_1100  0x0C   12    
  16599	:  0000_0000  0x00    0    
  16600	:  0000_0001  0x01    1    
  16601	:  0000_0000  0x00    0    
  16602	:  0000_0001  0x01    1    
  16603	:  0000_0000  0x00    0    
  16604	:  0000_0000  0x00    0    
  16605	:  0010_1010  0x2A   42  *  
  16606	:  0011_0000  0x30   48  0  
  16607	:  0000_0000  0x00    0    
  16608	:  0000_0100  0x04    4    
  16609	:  0010_1101  0x2D   45  -  
  16610	:  0100_0011  0x43   67  C  
  16611	:  0011_0100  0x34   52  4  
  16612	:  1001_0100  0x94  148    
  16613	:  0000_1000  0x08    8    
  16614	:  0100_0001  0x41   65  A  
  16615	:  0010_1101  0x2D   45  -  
  16616	:  0011_0101  0x35   53  5  
  16617	:  0011_0010  0x32   50  2  
  16618	:  0010_1101  0x2D   45  -  
  16619	:  0011_0001  0x31   49  1  
  16620	:  0011_0100  0x34   52  4  
  16621	:  0011_1001  0x39   57  9  
  16622	:  1100_0000  0xC0  192    
  16623	:  0000_1100  0x0C   12    
  16624	:  0000_0000  0x00    0    
  16625	:  0000_0001  0x01    1    
  16626	:  0000_0000  0x00    0    
  16627	:  0000_0001  0x01    1    
  16628	:  0000_0000  0x00    0    
  16629	:  0000_0000  0x00    0    
  16630	:  0010_1010  0x2A   42  *  
  16631	:  0011_0000  0x30   48  0  
  16632	:  0000_0000  0x00    0    
  16633	:  0000_0100  0x04    4    
  16634	:  0010_1101  0x2D   45  -  
  16635	:  0100_0011  0x43   67  C  
  16636	:  0011_0100  0x34   52  4  
  16637	:  1001_0101  0x95  149    
  16638	:  0000_1000  0x08    8    
  16639	:  0100_0001  0x41   65  A  
  16640	:  0010_1101  0x2D   45  -  
  16641	:  0011_0101  0x35   53  5  
  16642	:  0011_0010  0x32   50  2  
  16643	:  0010_1101  0x2D   45  -  
  16644	:  0011_0001  0x31   49  1  
  16645	:  0011_0101  0x35   53  5  
  16646	:  0011_0000  0x30   48  0  
  16647	:  1100_0000  0xC0  192    
  16648	:  0000_1100  0x0C   12    
  16649	:  0000_0000  0x00    0    
  16650	:  0000_0001  0x01    1    
  16651	:  0000_0000  0x00    0    
  16652	:  0000_0001  0x01    1    
  16653	:  0000_0000  0x00    0    
  16654	:  0000_0000  0x00    0    
  16655	:  0010_1010  0x2A   42  *  
  16656	:  0011_0000  0x30   48  0  
  16657	:  0000_0000  0x00    0    
  16658	:  0000_0100  0x04    4    
  16659	:  0010_1101  0x2D   45  -  
  16660	:  0100_0011  0x43   67  C  
  16661	:  0011_0100  0x34   52  4  
  16662	:  1001_0110  0x96  150    
  16663	:  0000_1000  0x08    8    
  16664	:  0100_0001  0x41   65  A  
  16665	:  0010_1101  0x2D   45  -  
  16666	:  0011_0101  0x35   53  5  
  16667	:  0011_0010  0x32   50  2  
  16668	:  0010_1101  0x2D   45  -  
  16669	:  0011_0001  0x31   49  1  
  16670	:  0011_0101  0x35   53  5  
  16671	:  0011_0001  0x31   49  1  
  16672	:  1100_0000  0xC0  192    
  16673	:  0000_1100  0x0C   12    
  16674	:  0000_0000  0x00    0    
  16675	:  0000_0001  0x01    1    
  16676	:  0000_0000  0x00    0    
  16677	:  0000_0001  0x01    1    
  16678	:  0000_0000  0x00    0    
  16679	:  0000_0000  0x00    0    
  16680	:  0010_1010  0x2A   42  *  
  16681	:  0011_0000  0x30   48  0  
  16682	:  0000_0000  0x00    0    
  16683	:  0000_0100  0x04    4    
  16684	:  0010_1101  0x2D   45  -  
  16685	:  0100_0011  0x43   67  C  
  16686	:  0011_0100  0x34   52  4  
  16687	:  1001_0111  0x97  151    
  16688	:  0000_1000  0x08    8    
  16689	:  0100_0001  0x41   65  A  
  16690	:  0010_1101  0x2D   45  -  
  16691	:  0011_0101  0x35   53  5  
  16692	:  0011_0010  0x32   50  2  
  16693	:  0010_1101  0x2D   45  -  
  16694	:  0011_0001  0x31   49  1  
  16695	:  0011_0101  0x35   53  5  
  16696	:  0011_0010  0x32   50  2  
  16697	:  1100_0000  0xC0  192    
  16698	:  0000_1100  0x0C   12    
  16699	:  0000_0000  0x00    0    
  16700	:  0000_0001  0x01    1    
  16701	:  0000_0000  0x00    0    
  16702	:  0000_0001  0x01    1    
  16703	:  0000_0000  0x00    0    
  16704	:  0000_0000  0x00    0    
  16705	:  0010_1010  0x2A   42  *  
  16706	:  0011_0000  0x30   48  0  
  16707	:  0000_0000  0x00    0    
  16708	:  0000_0100  0x04    4    
  16709	:  0010_1101  0x2D   45  -  
  16710	:  0100_0011  0x43   67  C  
  16711	:  0011_0100  0x34   52  4  
  16712	:  1001_1000  0x98  152    
  16713	:  0000_1000  0x08    8    
  16714	:  0100_0001  0x41   65  A  
  16715	:  0010_1101  0x2D   45  -  
  16716	:  0011_0101  0x35   53  5  
  16717	:  0011_0010  0x32   50  2  
  16718	:  0010_1101  0x2D   45  -  
  16719	:  0011_0001  0x31   49  1  
  16720	:  0011_0101  0x35   53  5  
  16721	:  0011_0011  0x33   51  3  
  16722	:  1100_0000  0xC0  192    
  16723	:  0000_1100  0x0C   12    
  16724	:  0000_0000  0x00    0    
  16725	:  0000_0001  0x01    1    
  16726	:  0000_0000  0x00    0    
  16727	:  0000_0001  0x01    1    
  16728	:  0000_0000  0x00    0    
  16729	:  0000_0000  0x00    0    
  16730	:  0010_1010  0x2A   42  *  
  16731	:  0011_0000  0x30   48  0  
  16732	:  0000_0000  0x00    0    
  16733	:  0000_0100  0x04    4    
  16734	:  0010_1101  0x2D   45  -  
  16735	:  0100_0011  0x43   67  C  
  16736	:  0011_0100  0x34   52  4  
  16737	:  1001_1001  0x99  153    
  16738	:  0000_1000  0x08    8    
  16739	:  0100_0001  0x41   65  A  
  16740	:  0010_1101  0x2D   45  -  
  16741	:  0011_0101  0x35   53  5  
  16742	:  0011_0010  0x32   50  2  
  16743	:  0010_1101  0x2D   45  -  
  16744	:  0011_0001  0x31   49  1  
  16745	:  0011_0101  0x35   53  5  
  16746	:  0011_0100  0x34   52  4  
  16747	:  1100_0000  0xC0  192    
  16748	:  0000_1100  0x0C   12    
  16749	:  0000_0000  0x00    0    
  16750	:  0000_0001  0x01    1    
  16751	:  0000_0000  0x00    0    
  16752	:  0000_0001  0x01    1    
  16753	:  0000_0000  0x00    0    
  16754	:  0000_0000  0x00    0    
  16755	:  0010_1010  0x2A   42  *  
  16756	:  0011_0000  0x30   48  0  
  16757	:  0000_0000  0x00    0    
  16758	:  0000_0100  0x04    4    
  16759	:  0010_1101  0x2D   45  -  
  16760	:  0100_0011  0x43   67  C  
  16761	:  0011_0100  0x34   52  4  
  16762	:  1001_1010  0x9A  154    
  16763	:  0000_1000  0x08    8    
  16764	:  0100_0001  0x41   65  A  
  16765	:  0010_1101  0x2D   45  -  
  16766	:  0011_0101  0x35   53  5  
  16767	:  0011_0010  0x32   50  2  
  16768	:  0010_1101  0x2D   45  -  
  16769	:  0011_0001  0x31   49  1  
  16770	:  0011_0101  0x35   53  5  
  16771	:  0011_0101  0x35   53  5  
  16772	:  1100_0000  0xC0  192    
  16773	:  0000_1100  0x0C   12    
  16774	:  0000_0000  0x00    0    
  16775	:  0000_0001  0x01    1    
  16776	:  0000_0000  0x00    0    
  16777	:  0000_0001  0x01    1    
  16778	:  0000_0000  0x00    0    
  16779	:  0000_0000  0x00    0    
  16780	:  0010_1010  0x2A   42  *  
  16781	:  0011_0000  0x30   48  0  
  16782	:  0000_0000  0x00    0    
  16783	:  0000_0100  0x04    4    
  16784	:  0010_1101  0x2D   45  -  
  16785	:  0100_0011  0x43   67  C  
  16786	:  0011_0100  0x34   52  4  
  16787	:  1001_1011  0x9B  155    
  16788	:  0000_1000  0x08    8    
  16789	:  0100_0001  0x41   65  A  
  16790	:  0010_1101  0x2D   45  -  
  16791	:  0011_0101  0x35   53  5  
  16792	:  0011_0010  0x32   50  2  
  16793	:  0010_1101  0x2D   45  -  
  16794	:  0011_0001  0x31   49  1  
  16795	:  0011_0101  0x35   53  5  
  16796	:  0011_0110  0x36   54  6  
  16797	:  1100_0000  0xC0  192    
  16798	:  0000_1100  0x0C   12    
  16799	:  0000_0000  0x00    0    
  16800	:  0000_0001  0x01    1    
  16801	:  0000_0000  0x00    0    
  16802	:  0000_0001  0x01    1    
  16803	:  0000_0000  0x00    0    
  16804	:  0000_0000  0x00    0    
  16805	:  0010_1010  0x2A   42  *  
  16806	:  0011_0000  0x30   48  0  
  16807	:  0000_0000  0x00    0    
  16808	:  0000_0100  0x04    4    
  16809	:  0010_1101  0x2D   45  -  
  16810	:  0100_0011  0x43   67  C  
  16811	:  0011_0100  0x34   52  4  
  16812	:  1001_1100  0x9C  156    
  16813	:  0000_1000  0x08    8    
  16814	:  0100_0001  0x41   65  A  
  16815	:  0010_1101  0x2D   45  -  
  16816	:  0011_0101  0x35   53  5  
  16817	:  0011_0010  0x32   50  2  
  16818	:  0010_1101  0x2D   45  -  
  16819	:  0011_0001  0x31   49  1  
  16820	:  0011_0101  0x35   53  5  
  16821	:  0011_0111  0x37   55  7  
  16822	:  1100_0000  0xC0  192    
  16823	:  0000_1100  0x0C   12    
  16824	:  0000_0000  0x00    0    
  16825	:  0000_0001  0x01    1    
  16826	:  0000_0000  0x00    0    
  16827	:  0000_0001  0x01    1    
  16828	:  0000_0000  0x00    0    
  16829	:  0000_0000  0x00    0    
  16830	:  0010_1010  0x2A   42  *  
  16831	:  0011_0000  0x30   48  0  
  16832	:  0000_0000  0x00    0    
  16833	:  0000_0100  0x04    4    
  16834	:  0010_1101  0x2D   45  -  
  16835	:  0100_0011  0x43   67  C  
  16836	:  0011_0100  0x34   52  4  
  16837	:  1001_1101  0x9D  157    
  16838	:  0000_1000  0x08    8    
  16839	:  0100_0001  0x41   65  A  
  16840	:  0010_1101  0x2D   45  -  
  16841	:  0011_0101  0x35   53  5  
  16842	:  0011_0010  0x32   50  2  
  16843	:  0010_1101  0x2D   45  -  
  16844	:  0011_0001  0x31   49  1  
  16845	:  0011_0101  0x35   53  5  
  16846	:  0011_1000  0x38   56  8  
  16847	:  1100_0000  0xC0  192    
  16848	:  0000_1100  0x0C   12    
  16849	:  0000_0000  0x00    0    
  16850	:  0000_0001  0x01    1    
  16851	:  0000_0000  0x00    0    
  16852	:  0000_0001  0x01    1    
  16853	:  0000_0000  0x00    0    
  16854	:  0000_0000  0x00    0    
  16855	:  0010_1010  0x2A   42  *  
  16856	:  0011_0000  0x30   48  0  
  16857	:  0000_0000  0x00    0    
  16858	:  0000_0100  0x04    4    
  16859	:  0010_1101  0x2D   45  -  
  16860	:  0100_0011  0x43   67  C  
  16861	:  0011_0100  0x34   52  4  
  16862	:  1001_1110  0x9E  158    
  16863	:  0000_1000  0x08    8    
  16864	:  0100_0001  0x41   65  A  
  16865	:  0010_1101  0x2D   45  -  
  16866	:  0011_0101  0x35   53  5  
  16867	:  0011_0010  0x32   50  2  
  16868	:  0010_1101  0x2D   45  -  
  16869	:  0011_0001  0x31   49  1  
  16870	:  0011_0101  0x35   53  5  
  16871	:  0011_1001  0x39   57  9  
  16872	:  1100_0000  0xC0  192    
  16873	:  0000_1100  0x0C   12    
  16874	:  0000_0000  0x00    0    
  16875	:  0000_0001  0x01    1    
  16876	:  0000_0000  0x00    0    
  16877	:  0000_0001  0x01    1    
  16878	:  0000_0000  0x00    0    
  16879	:  0000_0000  0x00    0    
  16880	:  0010_1010  0x2A   42  *  
  16881	:  0011_0000  0x30   48  0  
  16882	:  0000_0000  0x00    0    
  16883	:  0000_0100  0x04    4    
  16884	:  0010_1101  0x2D   45  -  
  16885	:  0100_0011  0x43   67  C  
  16886	:  0011_0100  0x34   52  4  
  16887	:  1001_1111  0x9F  159    
  16888	:  0000_1000  0x08    8    
  16889	:  0100_0001  0x41   65  A  
  16890	:  0010_1101  0x2D   45  -  
  16891	:  0011_0101  0x35   53  5  
  16892	:  0011_0010  0x32   50  2  
  16893	:  0010_1101  0x2D   45  -  
  16894	:  0011_0001  0x31   49  1  
  16895	:  0011_0110  0x36   54  6  
  16896	:  0011_0000  0x30   48  0  
  16897	:  1100_0000  0xC0  192    
  16898	:  0000_1100  0x0C   12    
  16899	:  0000_0000  0x00    0    
  16900	:  0000_0001  0x01    1    
  16901	:  0000_0000  0x00    0    
  16902	:  0000_0001  0x01    1    
  16903	:  0000_0000  0x00    0    
  16904	:  0000_0000  0x00    0    
  16905	:  0010_1010  0x2A   42  *  
  16906	:  0011_0000  0x30   48  0  
  16907	:  0000_0000  0x00    0    
  16908	:  0000_0100  0x04    4    
  16909	:  0010_1101  0x2D   45  -  
  16910	:  0100_0011  0x43   67  C  
  16911	:  0011_0100  0x34   52  4  
  16912	:  1010_0000  0xA0  160    
  16913	:  0000_1000  0x08    8    
  16914	:  0100_0001  0x41   65  A  
  16915	:  0010_1101  0x2D   45  -  
  16916	:  0011_0101  0x35   53  5  
  16917	:  0011_0010  0x32   50  2  
  16918	:  0010_1101  0x2D   45  -  
  16919	:  0011_0001  0x31   49  1  
  16920	:  0011_0110  0x36   54  6  
  16921	:  0011_0001  0x31   49  1  
  16922	:  1100_0000  0xC0  192    
  16923	:  0000_1100  0x0C   12    
  16924	:  0000_0000  0x00    0    
  16925	:  0000_0001  0x01    1    
  16926	:  0000_0000  0x00    0    
  16927	:  0000_0001  0x01    1    
  16928	:  0000_0000  0x00    0    
  16929	:  0000_0000  0x00    0    
  16930	:  0010_1010  0x2A   42  *  
  16931	:  0011_0000  0x30   48  0  
  16932	:  0000_0000  0x00    0    
  16933	:  0000_0100  0x04    4    
  16934	:  0010_1101  0x2D   45  -  
  16935	:  0100_0011  0x43   67  C  
  16936	:  0011_0100  0x34   52  4  
  16937	:  1010_0001  0xA1  161    
  16938	:  0000_1000  0x08    8    
  16939	:  0100_0001  0x41   65  A  
  16940	:  0010_1101  0x2D   45  -  
  16941	:  0011_0101  0x35   53  5  
  16942	:  0011_0010  0x32   50  2  
  16943	:  0010_1101  0x2D   45  -  
  16944	:  0011_0001  0x31   49  1  
  16945	:  0011_0110  0x36   54  6  
  16946	:  0011_0010  0x32   50  2  
  16947	:  1100_0000  0xC0  192    
  16948	:  0000_1100  0x0C   12    
  16949	:  0000_0000  0x00    0    
  16950	:  0000_0001  0x01    1    
  16951	:  0000_0000  0x00    0    
  16952	:  0000_0001  0x01    1    
  16953	:  0000_0000  0x00    0    
  16954	:  0000_0000  0x00    0    
  16955	:  0010_1010  0x2A   42  *  
  16956	:  0011_0000  0x30   48  0  
  16957	:  0000_0000  0x00    0    
  16958	:  0000_0100  0x04    4    
  16959	:  0010_1101  0x2D   45  -  
  16960	:  0100_0011  0x43   67  C  
  16961	:  0011_0100  0x34   52  4  
  16962	:  1010_0010  0xA2  162    
  16963	:  0000_1000  0x08    8    
  16964	:  0100_0001  0x41   65  A  
  16965	:  0010_1101  0x2D   45  -  
  16966	:  0011_0101  0x35   53  5  
  16967	:  0011_0010  0x32   50  2  
  16968	:  0010_1101  0x2D   45  -  
  16969	:  0011_0001  0x31   49  1  
  16970	:  0011_0110  0x36   54  6  
  16971	:  0011_0011  0x33   51  3  
  16972	:  1100_0000  0xC0  192    
  16973	:  0000_1100  0x0C   12    
  16974	:  0000_0000  0x00    0    
  16975	:  0000_0001  0x01    1    
  16976	:  0000_0000  0x00    0    
  16977	:  0000_0001  0x01    1    
  16978	:  0000_0000  0x00    0    
  16979	:  0000_0000  0x00    0    
  16980	:  0010_1010  0x2A   42  *  
  16981	:  0011_0000  0x30   48  0  
  16982	:  0000_0000  0x00    0    
  16983	:  0000_0100  0x04    4    
  16984	:  0010_1101  0x2D   45  -  
  16985	:  0100_0011  0x43   67  C  
  16986	:  0011_0100  0x34   52  4  
  16987	:  1010_0011  0xA3  163    
  16988	:  0000_1000  0x08    8    
  16989	:  0100_0001  0x41   65  A  
  16990	:  0010_1101  0x2D   45  -  
  16991	:  0011_0101  0x35   53  5  
  16992	:  0011_0010  0x32   50  2  
  16993	:  0010_1101  0x2D   45  -  
  16994	:  0011_0001  0x31   49  1  
  16995	:  0011_0110  0x36   54  6  
  16996	:  0011_0100  0x34   52  4  
  16997	:  1100_0000  0xC0  192    
  16998	:  0000_1100  0x0C   12    
  16999	:  0000_0000  0x00    0    
  17000	:  0000_0001  0x01    1    
  17001	:  0000_0000  0x00    0    
  17002	:  0000_0001  0x01    1    
  17003	:  0000_0000  0x00    0    
  17004	:  0000_0000  0x00    0    
  17005	:  0010_1010  0x2A   42  *  
  17006	:  0011_0000  0x30   48  0  
  17007	:  0000_0000  0x00    0    
  17008	:  0000_0100  0x04    4    
  17009	:  0010_1101  0x2D   45  -  
  17010	:  0100_0011  0x43   67  C  
  17011	:  0011_0100  0x34   52  4  
  17012	:  1010_0100  0xA4  164    
  17013	:  0000_1000  0x08    8    
  17014	:  0100_0001  0x41   65  A  
  17015	:  0010_1101  0x2D   45  -  
  17016	:  0011_0101  0x35   53  5  
  17017	:  0011_0010  0x32   50  2  
  17018	:  0010_1101  0x2D   45  -  
  17019	:  0011_0001  0x31   49  1  
  17020	:  0011_0110  0x36   54  6  
  17021	:  0011_0101  0x35   53  5  
  17022	:  1100_0000  0xC0  192    
  17023	:  0000_1100  0x0C   12    
  17024	:  0000_0000  0x00    0    
  17025	:  0000_0001  0x01    1    
  17026	:  0000_0000  0x00    0    
  17027	:  0000_0001  0x01    1    
  17028	:  0000_0000  0x00    0    
  17029	:  0000_0000  0x00    0    
  17030	:  0010_1010  0x2A   42  *  
  17031	:  0011_0000  0x30   48  0  
  17032	:  0000_0000  0x00    0    
  17033	:  0000_0100  0x04    4    
  17034	:  0010_1101  0x2D   45  -  
  17035	:  0100_0011  0x43   67  C  
  17036	:  0011_0100  0x34   52  4  
  17037	:  1010_0101  0xA5  165    
  17038	:  0000_1000  0x08    8    
  17039	:  0100_0001  0x41   65  A  
  17040	:  0010_1101  0x2D   45  -  
  17041	:  0011_0101  0x35   53  5  
  17042	:  0011_0010  0x32   50  2  
  17043	:  0010_1101  0x2D   45  -  
  17044	:  0011_0001  0x31   49  1  
  17045	:  0011_0110  0x36   54  6  
  17046	:  0011_0110  0x36   54  6  
  17047	:  1100_0000  0xC0  192    
  17048	:  0000_1100  0x0C   12    
  17049	:  0000_0000  0x00    0    
  17050	:  0000_0001  0x01    1    
  17051	:  0000_0000  0x00    0    
  17052	:  0000_0001  0x01    1    
  17053	:  0000_0000  0x00    0    
  17054	:  0000_0000  0x00    0    
  17055	:  0010_1010  0x2A   42  *  
  17056	:  0011_0000  0x30   48  0  
  17057	:  0000_0000  0x00    0    
  17058	:  0000_0100  0x04    4    
  17059	:  0010_1101  0x2D   45  -  
  17060	:  0100_0011  0x43   67  C  
  17061	:  0011_0100  0x34   52  4  
  17062	:  1010_0110  0xA6  166    
  17063	:  0000_1000  0x08    8    
  17064	:  0100_0001  0x41   65  A  
  17065	:  0010_1101  0x2D   45  -  
  17066	:  0011_0101  0x35   53  5  
  17067	:  0011_0010  0x32   50  2  
  17068	:  0010_1101  0x2D   45  -  
  17069	:  0011_0001  0x31   49  1  
  17070	:  0011_0110  0x36   54  6  
  17071	:  0011_0111  0x37   55  7  
  17072	:  1100_0000  0xC0  192    
  17073	:  0000_1100  0x0C   12    
  17074	:  0000_0000  0x00    0    
  17075	:  0000_0001  0x01    1    
  17076	:  0000_0000  0x00    0    
  17077	:  0000_0001  0x01    1    
  17078	:  0000_0000  0x00    0    
  17079	:  0000_0000  0x00    0    
  17080	:  0010_1010  0x2A   42  *  
  17081	:  0011_0000  0x30   48  0  
  17082	:  0000_0000  0x00    0    
  17083	:  0000_0100  0x04    4    
  17084	:  0010_1101  0x2D   45  -  
  17085	:  0100_0011  0x43   67  C  
  17086	:  0011_0100  0x34   52  4  
  17087	:  1010_0111  0xA7  167    
  17088	:  0000_1000  0x08    8    
  17089	:  0100_0001  0x41   65  A  
  17090	:  0010_1101  0x2D   45  -  
  17091	:  0011_0101  0x35   53  5  
  17092	:  0011_0010  0x32   50  2  
  17093	:  0010_1101  0x2D   45  -  
  17094	:  0011_0001  0x31   49  1  
  17095	:  0011_0110  0x36   54  6  
  17096	:  0011_1000  0x38   56  8  
  17097	:  1100_0000  0xC0  192    
  17098	:  0000_1100  0x0C   12    
  17099	:  0000_0000  0x00    0    
  17100	:  0000_0001  0x01    1    
  17101	:  0000_0000  0x00    0    
  17102	:  0000_0001  0x01    1    
  17103	:  0000_0000  0x00    0    
  17104	:  0000_0000  0x00    0    
  17105	:  0010_1010  0x2A   42  *  
  17106	:  0011_0000  0x30   48  0  
  17107	:  0000_0000  0x00    0    
  17108	:  0000_0100  0x04    4    
  17109	:  0010_1101  0x2D   45  -  
  17110	:  0100_0011  0x43   67  C  
  17111	:  0011_0100  0x34   52  4  
  17112	:  1010_1000  0xA8  168    
  17113	:  0000_1000  0x08    8    
  17114	:  0100_0001  0x41   65  A  
  17115	:  0010_1101  0x2D   45  -  
  17116	:  0011_0101  0x35   53  5  
  17117	:  0011_0010  0x32   50  2  
  17118	:  0010_1101  0x2D   45  -  
  17119	:  0011_0001  0x31   49  1  
  17120	:  0011_0110  0x36   54  6  
  17121	:  0011_1001  0x39   57  9  
  17122	:  1100_0000  0xC0  192    
  17123	:  0000_1100  0x0C   12    
  17124	:  0000_0000  0x00    0    
  17125	:  0000_0001  0x01    1    
  17126	:  0000_0000  0x00    0    
  17127	:  0000_0001  0x01    1    
  17128	:  0000_0000  0x00    0    
  17129	:  0000_0000  0x00    0    
  17130	:  0010_1010  0x2A   42  *  
  17131	:  0011_0000  0x30   48  0  
  17132	:  0000_0000  0x00    0    
  17133	:  0000_0100  0x04    4    
  17134	:  0010_1101  0x2D   45  -  
  17135	:  0100_0011  0x43   67  C  
  17136	:  0011_0100  0x34   52  4  
  17137	:  1010_1001  0xA9  169    
  17138	:  0000_1000  0x08    8    
  17139	:  0100_0001  0x41   65  A  
  17140	:  0010_1101  0x2D   45  -  
  17141	:  0011_0101  0x35   53  5  
  17142	:  0011_0010  0x32   50  2  
  17143	:  0010_1101  0x2D   45  -  
  17144	:  0011_0001  0x31   49  1  
  17145	:  0011_0111  0x37   55  7  
  17146	:  0011_0000  0x30   48  0  
  17147	:  1100_0000  0xC0  192    
  17148	:  0000_1100  0x0C   12    
  17149	:  0000_0000  0x00    0    
  17150	:  0000_0001  0x01    1    
  17151	:  0000_0000  0x00    0    
  17152	:  0000_0001  0x01    1    
  17153	:  0000_0000  0x00    0    
  17154	:  0000_0000  0x00    0    
  17155	:  0010_1010  0x2A   42  *  
  17156	:  0011_0000  0x30   48  0  
  17157	:  0000_0000  0x00    0    
  17158	:  0000_0100  0x04    4    
  17159	:  0010_1101  0x2D   45  -  
  17160	:  0100_0011  0x43   67  C  
  17161	:  0011_0100  0x34   52  4  
  17162	:  1010_1010  0xAA  170    
  17163	:  0000_1000  0x08    8    
  17164	:  0100_0001  0x41   65  A  
  17165	:  0010_1101  0x2D   45  -  
  17166	:  0011_0101  0x35   53  5  
  17167	:  0011_0010  0x32   50  2  
  17168	:  0010_1101  0x2D   45  -  
  17169	:  0011_0001  0x31   49  1  
  17170	:  0011_0111  0x37   55  7  
  17171	:  0011_0001  0x31   49  1  
  17172	:  1100_0000  0xC0  192    
  17173	:  0000_1100  0x0C   12    
  17174	:  0000_0000  0x00    0    
  17175	:  0000_0001  0x01    1    
  17176	:  0000_0000  0x00    0    
  17177	:  0000_0001  0x01    1    
  17178	:  0000_0000  0x00    0    
  17179	:  0000_0000  0x00    0    
  17180	:  0010_1010  0x2A   42  *  
  17181	:  0011_0000  0x30   48  0  
  17182	:  0000_0000  0x00    0    
  17183	:  0000_0100  0x04    4    
  17184	:  0010_1101  0x2D   45  -  
  17185	:  0100_0011  0x43   67  C  
  17186	:  0011_0100  0x34   52  4  
  17187	:  1010_1011  0xAB  171    
  17188	:  0000_1000  0x08    8    
  17189	:  0100_0001  0x41   65  A  
  17190	:  0010_1101  0x2D   45  -  
  17191	:  0011_0101  0x35   53  5  
  17192	:  0011_0010  0x32   50  2  
  17193	:  0010_1101  0x2D   45  -  
  17194	:  0011_0001  0x31   49  1  
  17195	:  0011_0111  0x37   55  7  
  17196	:  0011_0010  0x32   50  2  
  17197	:  1100_0000  0xC0  192    
  17198	:  0000_1100  0x0C   12    
  17199	:  0000_0000  0x00    0    
  17200	:  0000_0001  0x01    1    
  17201	:  0000_0000  0x00    0    
  17202	:  0000_0001  0x01    1    
  17203	:  0000_0000  0x00    0    
  17204	:  0000_0000  0x00    0    
  17205	:  0010_1010  0x2A   42  *  
  17206	:  0011_0000  0x30   48  0  
  17207	:  0000_0000  0x00    0    
  17208	:  0000_0100  0x04    4    
  17209	:  0010_1101  0x2D   45  -  
  17210	:  0100_0011  0x43   67  C  
  17211	:  0011_0100  0x34   52  4  
  17212	:  1010_1100  0xAC  172    
  17213	:  0000_1000  0x08    8    
  17214	:  0100_0001  0x41   65  A  
  17215	:  0010_1101  0x2D   45  -  
  17216	:  0011_0101  0x35   53  5  
  17217	:  0011_0010  0x32   50  2  
  17218	:  0010_1101  0x2D   45  -  
  17219	:  0011_0001  0x31   49  1  
  17220	:  0011_0111  0x37   55  7  
  17221	:  0011_0011  0x33   51  3  
  17222	:  1100_0000  0xC0  192    
  17223	:  0000_1100  0x0C   12    
  17224	:  0000_0000  0x00    0    
  17225	:  0000_0001  0x01    1    
  17226	:  0000_0000  0x00    0    
  17227	:  0000_0001  0x01    1    
  17228	:  0000_0000  0x00    0    
  17229	:  0000_0000  0x00    0    
  17230	:  0010_1010  0x2A   42  *  
  17231	:  0011_0000  0x30   48  0  
  17232	:  0000_0000  0x00    0    
  17233	:  0000_0100  0x04    4    
  17234	:  0010_1101  0x2D   45  -  
  17235	:  0100_0011  0x43   67  C  
  17236	:  0011_0100  0x34   52  4  
  17237	:  1010_1101  0xAD  173    
  17238	:  0000_1000  0x08    8    
  17239	:  0100_0001  0x41   65  A  
  17240	:  0010_1101  0x2D   45  -  
  17241	:  0011_0101  0x35   53  5  
  17242	:  0011_0010  0x32   50  2  
  17243	:  0010_1101  0x2D   45  -  
  17244	:  0011_0001  0x31   49  1  
  17245	:  0011_0111  0x37   55  7  
  17246	:  0011_0100  0x34   52  4  
  17247	:  1100_0000  0xC0  192    
  17248	:  0000_1100  0x0C   12    
  17249	:  0000_0000  0x00    0    
  17250	:  0000_0001  0x01    1    
  17251	:  0000_0000  0x00    0    
  17252	:  0000_0001  0x01    1    
  17253	:  0000_0000  0x00    0    
  17254	:  0000_0000  0x00    0    
  17255	:  0010_1010  0x2A   42  *  
  17256	:  0011_0000  0x30   48  0  
  17257	:  0000_0000  0x00    0    
  17258	:  0000_0100  0x04    4    
  17259	:  0010_1101  0x2D   45  -  
  17260	:  0100_0011  0x43   67  C  
  17261	:  0011_0100  0x34   52  4  
  17262	:  1010_1110  0xAE  174    
  17263	:  0000_1000  0x08    8    
  17264	:  0100_0001  0x41   65  A  
  17265	:  0010_1101  0x2D   45  -  
  17266	:  0011_0101  0x35   53  5  
  17267	:  0011_0010  0x32   50  2  
  17268	:  0010_1101  0x2D   45  -  
  17269	:  0011_0001  0x31   49  1  
  17270	:  0011_0111  0x37   55  7  
  17271	:  0011_0101  0x35   53  5  
  17272	:  1100_0000  0xC0  192    
  17273	:  0000_1100  0x0C   12    
  17274	:  0000_0000  0x00    0    
  17275	:  0000_0001  0x01    1    
  17276	:  0000_0000  0x00    0    
  17277	:  0000_0001  0x01    1    
  17278	:  0000_0000  0x00    0    
  17279	:  0000_0000  0x00    0    
  17280	:  0010_1010  0x2A   42  *  
  17281	:  0011_0000  0x30   48  0  
  17282	:  0000_0000  0x00    0    
  17283	:  0000_0100  0x04    4    
  17284	:  0010_1101  0x2D   45  -  
  17285	:  0100_0011  0x43   67  C  
  17286	:  0011_0100  0x34   52  4  
  17287	:  1010_1111  0xAF  175    
  17288	:  0000_1000  0x08    8    
  17289	:  0100_0001  0x41   65  A  
  17290	:  0010_1101  0x2D   45  -  
  17291	:  0011_0101  0x35   53  5  
  17292	:  0011_0010  0x32   50  2  
  17293	:  0010_1101  0x2D   45  -  
  17294	:  0011_0001  0x31   49  1  
  17295	:  0011_0111  0x37   55  7  
  17296	:  0011_0110  0x36   54  6  
  17297	:  1100_0000  0xC0  192    
  17298	:  0000_1100  0x0C   12    
  17299	:  0000_0000  0x00    0    
  17300	:  0000_0001  0x01    1    
  17301	:  0000_0000  0x00    0    
  17302	:  0000_0001  0x01    1    
  17303	:  0000_0000  0x00    0    
  17304	:  0000_0000  0x00    0    
  17305	:  0010_1010  0x2A   42  *  
  17306	:  0011_0000  0x30   48  0  
  17307	:  0000_0000  0x00    0    
  17308	:  0000_0100  0x04    4    
  17309	:  0010_1101  0x2D   45  -  
  17310	:  0100_0011  0x43   67  C  
  17311	:  0011_0100  0x34   52  4  
  17312	:  1011_0000  0xB0  176    
  17313	:  0000_1000  0x08    8    
  17314	:  0100_0001  0x41   65  A  
  17315	:  0010_1101  0x2D   45  -  
  17316	:  0011_0101  0x35   53  5  
  17317	:  0011_0010  0x32   50  2  
  17318	:  0010_1101  0x2D   45  -  
  17319	:  0011_0001  0x31   49  1  
  17320	:  0011_0111  0x37   55  7  
  17321	:  0011_0111  0x37   55  7  
  17322	:  1100_0000  0xC0  192    
  17323	:  0000_1100  0x0C   12    
  17324	:  0000_0000  0x00    0    
  17325	:  0000_0001  0x01    1    
  17326	:  0000_0000  0x00    0    
  17327	:  0000_0001  0x01    1    
  17328	:  0000_0000  0x00    0    
  17329	:  0000_0000  0x00    0    
  17330	:  0010_1010  0x2A   42  *  
  17331	:  0011_0000  0x30   48  0  
  17332	:  0000_0000  0x00    0    
  17333	:  0000_0100  0x04    4    
  17334	:  0010_1101  0x2D   45  -  
  17335	:  0100_0011  0x43   67  C  
  17336	:  0011_0100  0x34   52  4  
  17337	:  1011_0001  0xB1  177    
  17338	:  0000_1000  0x08    8    
  17339	:  0100_0001  0x41   65  A  
  17340	:  0010_1101  0x2D   45  -  
  17341	:  0011_0101  0x35   53  5  
  17342	:  0011_0010  0x32   50  2  
  17343	:  0010_1101  0x2D   45  -  
  17344	:  0011_0001  0x31   49  1  
  17345	:  0011_0111  0x37   55  7  
  17346	:  0011_1000  0x38   56  8  
  17347	:  1100_0000  0xC0  192    
  17348	:  0000_1100  0x0C   12    
  17349	:  0000_0000  0x00    0    
  17350	:  0000_0001  0x01    1    
  17351	:  0000_0000  0x00    0    
  17352	:  0000_0001  0x01    1    
  17353	:  0000_0000  0x00    0    
  17354	:  0000_0000  0x00    0    
  17355	:  0010_1010  0x2A   42  *  
  17356	:  0011_0000  0x30   48  0  
  17357	:  0000_0000  0x00    0    
  17358	:  0000_0100  0x04    4    
  17359	:  0010_1101  0x2D   45  -  
  17360	:  0100_0011  0x43   67  C  
  17361	:  0011_0100  0x34   52  4  
  17362	:  1011_0010  0xB2  178    
  17363	:  0000_1000  0x08    8    
  17364	:  0100_0001  0x41   65  A  
  17365	:  0010_1101  0x2D   45  -  
  17366	:  0011_0101  0x35   53  5  
  17367	:  0011_0010  0x32   50  2  
  17368	:  0010_1101  0x2D   45  -  
  17369	:  0011_0001  0x31   49  1  
  17370	:  0011_0111  0x37   55  7  
  17371	:  0011_1001  0x39   57  9  
  17372	:  1100_0000  0xC0  192    
  17373	:  0000_1100  0x0C   12    
  17374	:  0000_0000  0x00    0    
  17375	:  0000_0001  0x01    1    
  17376	:  0000_0000  0x00    0    
  17377	:  0000_0001  0x01    1    
  17378	:  0000_0000  0x00    0    
  17379	:  0000_0000  0x00    0    
  17380	:  0010_1010  0x2A   42  *  
  17381	:  0011_0000  0x30   48  0  
  17382	:  0000_0000  0x00    0    
  17383	:  0000_0100  0x04    4    
  17384	:  0010_1101  0x2D   45  -  
  17385	:  0100_0011  0x43   67  C  
  17386	:  0011_0100  0x34   52  4  
  17387	:  1011_0011  0xB3  179    
  17388	:  0000_1000  0x08    8    
  17389	:  0100_0001  0x41   65  A  
  17390	:  0010_1101  0x2D   45  -  
  17391	:  0011_0101  0x35   53  5  
  17392	:  0011_0010  0x32   50  2  
  17393	:  0010_1101  0x2D   45  -  
  17394	:  0011_0001  0x31   49  1  
  17395	:  0011_1000  0x38   56  8  
  17396	:  0011_0000  0x30   48  0  
  17397	:  1100_0000  0xC0  192    
  17398	:  0000_1100  0x0C   12    
  17399	:  0000_0000  0x00    0    
  17400	:  0000_0001  0x01    1    
  17401	:  0000_0000  0x00    0    
  17402	:  0000_0001  0x01    1    
  17403	:  0000_0000  0x00    0    
  17404	:  0000_0000  0x00    0    
  17405	:  0010_1010  0x2A   42  *  
  17406	:  0011_0000  0x30   48  0  
  17407	:  0000_0000  0x00    0    
  17408	:  0000_0100  0x04    4    
  17409	:  0010_1101  0x2D   45  -  
  17410	:  0100_0011  0x43   67  C  
  17411	:  0011_0100  0x34   52  4  
  17412	:  1011_0100  0xB4  180    
  17413	:  0000_1000  0x08    8    
  17414	:  0100_0001  0x41   65  A  
  17415	:  0010_1101  0x2D   45  -  
  17416	:  0011_0101  0x35   53  5  
  17417	:  0011_0010  0x32   50  2  
  17418	:  0010_1101  0x2D   45  -  
  17419	:  0011_0001  0x31   49  1  
  17420	:  0011_1000  0x38   56  8  
  17421	:  0011_0001  0x31   49  1  
  17422	:  1100_0000  0xC0  192    
  17423	:  0000_1100  0x0C   12    
  17424	:  0000_0000  0x00    0    
  17425	:  0000_0001  0x01    1    
  17426	:  0000_0000  0x00    0    
  17427	:  0000_0001  0x01    1    
  17428	:  0000_0000  0x00    0    
  17429	:  0000_0000  0x00    0    
  17430	:  0010_1010  0x2A   42  *  
  17431	:  0011_0000  0x30   48  0  
  17432	:  0000_0000  0x00    0    
  17433	:  0000_0100  0x04    4    
  17434	:  0010_1101  0x2D   45  -  
  17435	:  0100_0011  0x43   67  C  
  17436	:  0011_0100  0x34   52  4  
  17437	:  1011_0101  0xB5  181    
  17438	:  0000_1000  0x08    8    
  17439	:  0100_0001  0x41   65  A  
  17440	:  0010_1101  0x2D   45  -  
  17441	:  0011_0101  0x35   53  5  
  17442	:  0011_0010  0x32   50  2  
  17443	:  0010_1101  0x2D   45  -  
  17444	:  0011_0001  0x31   49  1  
  17445	:  0011_1000  0x38   56  8  
  17446	:  0011_0010  0x32   50  2  
  17447	:  1100_0000  0xC0  192    
  17448	:  0000_1100  0x0C   12    
  17449	:  0000_0000  0x00    0    
  17450	:  0000_0001  0x01    1    
  17451	:  0000_0000  0x00    0    
  17452	:  0000_0001  0x01    1    
  17453	:  0000_0000  0x00    0    
  17454	:  0000_0000  0x00    0    
  17455	:  0010_1010  0x2A   42  *  
  17456	:  0011_0000  0x30   48  0  
  17457	:  0000_0000  0x00    0    
  17458	:  0000_0100  0x04    4    
  17459	:  0010_1101  0x2D   45  -  
  17460	:  0100_0011  0x43   67  C  
  17461	:  0011_0100  0x34   52  4  
  17462	:  1011_0110  0xB6  182    
  17463	:  0000_1000  0x08    8    
  17464	:  0100_0001  0x41   65  A  
  17465	:  0010_1101  0x2D   45  -  
  17466	:  0011_0101  0x35   53  5  
  17467	:  0011_0010  0x32   50  2  
  17468	:  0010_1101  0x2D   45  -  
  17469	:  0011_0001  0x31   49  1  
  17470	:  0011_1000  0x38   56  8  
  17471	:  0011_0011  0x33   51  3  
  17472	:  1100_0000  0xC0  192    
  17473	:  0000_1100  0x0C   12    
  17474	:  0000_0000  0x00    0    
  17475	:  0000_0001  0x01    1    
  17476	:  0000_0000  0x00    0    
  17477	:  0000_0001  0x01    1    
  17478	:  0000_0000  0x00    0    
  17479	:  0000_0000  0x00    0    
  17480	:  0010_1010  0x2A   42  *  
  17481	:  0011_0000  0x30   48  0  
  17482	:  0000_0000  0x00    0    
  17483	:  0000_0100  0x04    4    
  17484	:  0010_1101  0x2D   45  -  
  17485	:  0100_0011  0x43   67  C  
  17486	:  0011_0100  0x34   52  4  
  17487	:  1011_0111  0xB7  183    
  17488	:  0000_1000  0x08    8    
  17489	:  0100_0001  0x41   65  A  
  17490	:  0010_1101  0x2D   45  -  
  17491	:  0011_0101  0x35   53  5  
  17492	:  0011_0010  0x32   50  2  
  17493	:  0010_1101  0x2D   45  -  
  17494	:  0011_0001  0x31   49  1  
  17495	:  0011_1000  0x38   56  8  
  17496	:  0011_0100  0x34   52  4  
  17497	:  1100_0000  0xC0  192    
  17498	:  0000_1100  0x0C   12    
  17499	:  0000_0000  0x00    0    
  17500	:  0000_0001  0x01    1    
  17501	:  0000_0000  0x00    0    
  17502	:  0000_0001  0x01    1    
  17503	:  0000_0000  0x00    0    
  17504	:  0000_0000  0x00    0    
  17505	:  0010_1010  0x2A   42  *  
  17506	:  0011_0000  0x30   48  0  
  17507	:  0000_0000  0x00    0    
  17508	:  0000_0100  0x04    4    
  17509	:  0010_1101  0x2D   45  -  
  17510	:  0100_0011  0x43   67  C  
  17511	:  0011_0100  0x34   52  4  
  17512	:  1011_1000  0xB8  184    
  17513	:  0000_1000  0x08    8    
  17514	:  0100_0001  0x41   65  A  
  17515	:  0010_1101  0x2D   45  -  
  17516	:  0011_0101  0x35   53  5  
  17517	:  0011_0010  0x32   50  2  
  17518	:  0010_1101  0x2D   45  -  
  17519	:  0011_0001  0x31   49  1  
  17520	:  0011_1000  0x38   56  8  
  17521	:  0011_0101  0x35   53  5  
  17522	:  1100_0000  0xC0  192    
  17523	:  0000_1100  0x0C   12    
  17524	:  0000_0000  0x00    0    
  17525	:  0000_0001  0x01    1    
  17526	:  0000_0000  0x00    0    
  17527	:  0000_0001  0x01    1    
  17528	:  0000_0000  0x00    0    
  17529	:  0000_0000  0x00    0    
  17530	:  0010_1010  0x2A   42  *  
  17531	:  0011_0000  0x30   48  0  
  17532	:  0000_0000  0x00    0    
  17533	:  0000_0100  0x04    4    
  17534	:  0010_1101  0x2D   45  -  
  17535	:  0100_0011  0x43   67  C  
  17536	:  0011_0100  0x34   52  4  
  17537	:  1011_1001  0xB9  185    
  17538	:  0000_1000  0x08    8    
  17539	:  0100_0001  0x41   65  A  
  17540	:  0010_1101  0x2D   45  -  
  17541	:  0011_0101  0x35   53  5  
  17542	:  0011_0010  0x32   50  2  
  17543	:  0010_1101  0x2D   45  -  
  17544	:  0011_0001  0x31   49  1  
  17545	:  0011_1000  0x38   56  8  
  17546	:  0011_0110  0x36   54  6  
  17547	:  1100_0000  0xC0  192    
  17548	:  0000_1100  0x0C   12    
  17549	:  0000_0000  0x00    0    
  17550	:  0000_0001  0x01    1    
  17551	:  0000_0000  0x00    0    
  17552	:  0000_0001  0x01    1    
  17553	:  0000_0000  0x00    0    
  17554	:  0000_0000  0x00    0    
  17555	:  0010_1010  0x2A   42  *  
  17556	:  0011_0000  0x30   48  0  
  17557	:  0000_0000  0x00    0    
  17558	:  0000_0100  0x04    4    
  17559	:  0010_1101  0x2D   45  -  
  17560	:  0100_0011  0x43   67  C  
  17561	:  0011_0100  0x34   52  4  
  17562	:  1011_1010  0xBA  186    
  17563	:  0000_1000  0x08    8    
  17564	:  0100_0001  0x41   65  A  
  17565	:  0010_1101  0x2D   45  -  
  17566	:  0011_0101  0x35   53  5  
  17567	:  0011_0010  0x32   50  2  
  17568	:  0010_1101  0x2D   45  -  
  17569	:  0011_0001  0x31   49  1  
  17570	:  0011_1000  0x38   56  8  
  17571	:  0011_0111  0x37   55  7  
  17572	:  1100_0000  0xC0  192    
  17573	:  0000_1100  0x0C   12    
  17574	:  0000_0000  0x00    0    
  17575	:  0000_0001  0x01    1    
  17576	:  0000_0000  0x00    0    
  17577	:  0000_0001  0x01    1    
  17578	:  0000_0000  0x00    0    
  17579	:  0000_0000  0x00    0    
  17580	:  0010_1010  0x2A   42  *  
  17581	:  0011_0000  0x30   48  0  
  17582	:  0000_0000  0x00    0    
  17583	:  0000_0100  0x04    4    
  17584	:  0010_1101  0x2D   45  -  
  17585	:  0100_0011  0x43   67  C  
  17586	:  0011_0100  0x34   52  4  
  17587	:  1011_1011  0xBB  187    
  17588	:  0000_1000  0x08    8    
  17589	:  0100_0001  0x41   65  A  
  17590	:  0010_1101  0x2D   45  -  
  17591	:  0011_0101  0x35   53  5  
  17592	:  0011_0010  0x32   50  2  
  17593	:  0010_1101  0x2D   45  -  
  17594	:  0011_0001  0x31   49  1  
  17595	:  0011_1000  0x38   56  8  
  17596	:  0011_1000  0x38   56  8  
  17597	:  1100_0000  0xC0  192    
  17598	:  0000_1100  0x0C   12    
  17599	:  0000_0000  0x00    0    
  17600	:  0000_0001  0x01    1    
  17601	:  0000_0000  0x00    0    
  17602	:  0000_0001  0x01    1    
  17603	:  0000_0000  0x00    0    
  17604	:  0000_0000  0x00    0    
  17605	:  0010_1010  0x2A   42  *  
  17606	:  0011_0000  0x30   48  0  
  17607	:  0000_0000  0x00    0    
  17608	:  0000_0100  0x04    4    
  17609	:  0010_1101  0x2D   45  -  
  17610	:  0100_0011  0x43   67  C  
  17611	:  0011_0100  0x34   52  4  
  17612	:  1011_1100  0xBC  188    
  17613	:  0000_1000  0x08    8    
  17614	:  0100_0001  0x41   65  A  
  17615	:  0010_1101  0x2D   45  -  
  17616	:  0011_0101  0x35   53  5  
  17617	:  0011_0010  0x32   50  2  
  17618	:  0010_1101  0x2D   45  -  
  17619	:  0011_0001  0x31   49  1  
  17620	:  0011_1000  0x38   56  8  
  17621	:  0011_1001  0x39   57  9  
  17622	:  1100_0000  0xC0  192    
  17623	:  0000_1100  0x0C   12    
  17624	:  0000_0000  0x00    0    
  17625	:  0000_0001  0x01    1    
  17626	:  0000_0000  0x00    0    
  17627	:  0000_0001  0x01    1    
  17628	:  0000_0000  0x00    0    
  17629	:  0000_0000  0x00    0    
  17630	:  0010_1010  0x2A   42  *  
  17631	:  0011_0000  0x30   48  0  
  17632	:  0000_0000  0x00    0    
  17633	:  0000_0100  0x04    4    
  17634	:  0010_1101  0x2D   45  -  
  17635	:  0100_0011  0x43   67  C  
  17636	:  0011_0100  0x34   52  4  
  17637	:  1011_1101  0xBD  189    
  17638	:  0000_1000  0x08    8    
  17639	:  0100_0001  0x41   65  A  
  17640	:  0010_1101  0x2D   45  -  
  17641	:  0011_0101  0x35   53  5  
  17642	:  0011_0010  0x32   50  2  
  17643	:  0010_1101  0x2D   45  -  
  17644	:  0011_0001  0x31   49  1  
  17645	:  0011_1001  0x39   57  9  
  17646	:  0011_0000  0x30   48  0  
  17647	:  1100_0000  0xC0  192    
  17648	:  0000_1100  0x0C   12    
  17649	:  0000_0000  0x00    0    
  17650	:  0000_0001  0x01    1    
  17651	:  0000_0000  0x00    0    
  17652	:  0000_0001  0x01    1    
  17653	:  0000_0000  0x00    0    
  17654	:  0000_0000  0x00    0    
  17655	:  0010_1010  0x2A   42  *  
  17656	:  0011_0000  0x30   48  0  
  17657	:  0000_0000  0x00    0    
  17658	:  0000_0100  0x04    4    
  17659	:  0010_1101  0x2D   45  -  
  17660	:  0100_0011  0x43   67  C  
  17661	:  0011_0100  0x34   52  4  
  17662	:  1011_1110  0xBE  190    
  17663	:  0000_1000  0x08    8    
  17664	:  0100_0001  0x41   65  A  
  17665	:  0010_1101  0x2D   45  -  
  17666	:  0011_0101  0x35   53  5  
  17667	:  0011_0010  0x32   50  2  
  17668	:  0010_1101  0x2D   45  -  
  17669	:  0011_0001  0x31   49  1  
  17670	:  0011_1001  0x39   57  9  
  17671	:  0011_0001  0x31   49  1  
  17672	:  1100_0000  0xC0  192    
  17673	:  0000_1100  0x0C   12    
  17674	:  0000_0000  0x00    0    
  17675	:  0000_0001  0x01    1    
  17676	:  0000_0000  0x00    0    
  17677	:  0000_0001  0x01    1    
  17678	:  0000_0000  0x00    0    
  17679	:  0000_0000  0x00    0    
  17680	:  0010_1010  0x2A   42  *  
  17681	:  0011_0000  0x30   48  0  
  17682	:  0000_0000  0x00    0    
  17683	:  0000_0100  0x04    4    
  17684	:  0010_1101  0x2D   45  -  
  17685	:  0100_0011  0x43   67  C  
  17686	:  0011_0100  0x34   52  4  
  17687	:  1011_1111  0xBF  191    
  17688	:  0000_1000  0x08    8    
  17689	:  0100_0001  0x41   65  A  
  17690	:  0010_1101  0x2D   45  -  
  17691	:  0011_0101  0x35   53  5  
  17692	:  0011_0010  0x32   50  2  
  17693	:  0010_1101  0x2D   45  -  
  17694	:  0011_0001  0x31   49  1  
  17695	:  0011_1001  0x39   57  9  
  17696	:  0011_0010  0x32   50  2  
  17697	:  1100_0000  0xC0  192    
  17698	:  0000_1100  0x0C   12    
  17699	:  0000_0000  0x00    0    
  17700	:  0000_0001  0x01    1    
  17701	:  0000_0000  0x00    0    
  17702	:  0000_0001  0x01    1    
  17703	:  0000_0000  0x00    0    
  17704	:  0000_0000  0x00    0    
  17705	:  0010_1010  0x2A   42  *  
  17706	:  0011_0000  0x30   48  0  
  17707	:  0000_0000  0x00    0    
  17708	:  0000_0100  0x04    4    
  17709	:  0010_1101  0x2D   45  -  
  17710	:  0100_0011  0x43   67  C  
  17711	:  0011_0100  0x34   52  4  
  17712	:  1100_0000  0xC0  192    
  17713	:  0000_1000  0x08    8    
  17714	:  0100_0001  0x41   65  A  
  17715	:  0010_1101  0x2D   45  -  
  17716	:  0011_0101  0x35   53  5  
  17717	:  0011_0010  0x32   50  2  
  17718	:  0010_1101  0x2D   45  -  
  17719	:  0011_0001  0x31   49  1  
  17720	:  0011_1001  0x39   57  9  
  17721	:  0011_0011  0x33   51  3  
  17722	:  1100_0000  0xC0  192    
  17723	:  0000_1100  0x0C   12    
  17724	:  0000_0000  0x00    0    
  17725	:  0000_0001  0x01    1    
  17726	:  0000_0000  0x00    0    
  17727	:  0000_0001  0x01    1    
  17728	:  0000_0000  0x00    0    
  17729	:  0000_0000  0x00    0    
  17730	:  0010_1010  0x2A   42  *  
  17731	:  0011_0000  0x30   48  0  
  17732	:  0000_0000  0x00    0    
  17733	:  0000_0100  0x04    4    
  17734	:  0010_1101  0x2D   45  -  
  17735	:  0100_0011  0x43   67  C  
  17736	:  0011_0100  0x34   52  4  
  17737	:  1100_0001  0xC1  193    
  17738	:  0000_1000  0x08    8    
  17739	:  0100_0001  0x41   65  A  
  17740	:  0010_1101  0x2D   45  -  
  17741	:  0011_0101  0x35   53  5  
  17742	:  0011_0010  0x32   50  2  
  17743	:  0010_1101  0x2D   45  -  
  17744	:  0011_0001  0x31   49  1  
  17745	:  0011_1001  0x39   57  9  
  17746	:  0011_0100  0x34   52  4  
  17747	:  1100_0000  0xC0  192    
  17748	:  0000_1100  0x0C   12    
  17749	:  0000_0000  0x00    0    
  17750	:  0000_0001  0x01    1    
  17751	:  0000_0000  0x00    0    
  17752	:  0000_0001  0x01    1    
  17753	:  0000_0000  0x00    0    
  17754	:  0000_0000  0x00    0    
  17755	:  0010_1010  0x2A   42  *  
  17756	:  0011_0000  0x30   48  0  
  17757	:  0000_0000  0x00    0    
  17758	:  0000_0100  0x04    4    
  17759	:  0010_1101  0x2D   45  -  
  17760	:  0100_0011  0x43   67  C  
  17761	:  0011_0100  0x34   52  4  
  17762	:  1100_0010  0xC2  194    
  17763	:  0000_1000  0x08    8    
  17764	:  0100_0001  0x41   65  A  
  17765	:  0010_1101  0x2D   45  -  
  17766	:  0011_0101  0x35   53  5  
  17767	:  0011_0010  0x32   50  2  
  17768	:  0010_1101  0x2D   45  -  
  17769	:  0011_0001  0x31   49  1  
  17770	:  0011_1001  0x39   57  9  
  17771	:  0011_0101  0x35   53  5  
  17772	:  1100_0000  0xC0  192    
  17773	:  0000_1100  0x0C   12    
  17774	:  0000_0000  0x00    0    
  17775	:  0000_0001  0x01    1    
  17776	:  0000_0000  0x00    0    
  17777	:  0000_0001  0x01    1    
  17778	:  0000_0000  0x00    0    
  17779	:  0000_0000  0x00    0    
  17780	:  0010_1010  0x2A   42  *  
  17781	:  0011_0000  0x30   48  0  
  17782	:  0000_0000  0x00    0    
  17783	:  0000_0100  0x04    4    
  17784	:  0010_1101  0x2D   45  -  
  17785	:  0100_0011  0x43   67  C  
  17786	:  0011_0100  0x34   52  4  
  17787	:  1100_0011  0xC3  195    
  17788	:  0000_1000  0x08    8    
  17789	:  0100_0001  0x41   65  A  
  17790	:  0010_1101  0x2D   45  -  
  17791	:  0011_0101  0x35   53  5  
  17792	:  0011_0010  0x32   50  2  
  17793	:  0010_1101  0x2D   45  -  
  17794	:  0011_0001  0x31   49  1  
  17795	:  0011_1001  0x39   57  9  
  17796	:  0011_0110  0x36   54  6  
  17797	:  1100_0000  0xC0  192    
  17798	:  0000_1100  0x0C   12    
  17799	:  0000_0000  0x00    0    
  17800	:  0000_0001  0x01    1    
  17801	:  0000_0000  0x00    0    
  17802	:  0000_0001  0x01    1    
  17803	:  0000_0000  0x00    0    
  17804	:  0000_0000  0x00    0    
  17805	:  0010_1010  0x2A   42  *  
  17806	:  0011_0000  0x30   48  0  
  17807	:  0000_0000  0x00    0    
  17808	:  0000_0100  0x04    4    
  17809	:  0010_1101  0x2D   45  -  
  17810	:  0100_0011  0x43   67  C  
  17811	:  0011_0100  0x34   52  4  
  17812	:  1100_0100  0xC4  196    
  17813	:  0000_1000  0x08    8    
  17814	:  0100_0001  0x41   65  A  
  17815	:  0010_1101  0x2D   45  -  
  17816	:  0011_0101  0x35   53  5  
  17817	:  0011_0010  0x32   50  2  
  17818	:  0010_1101  0x2D   45  -  
  17819	:  0011_0001  0x31   49  1  
  17820	:  0011_1001  0x39   57  9  
  17821	:  0011_0111  0x37   55  7  
  17822	:  1100_0000  0xC0  192    
  17823	:  0000_1100  0x0C   12    
  17824	:  0000_0000  0x00    0    
  17825	:  0000_0001  0x01    1    
  17826	:  0000_0000  0x00    0    
  17827	:  0000_0001  0x01    1    
  17828	:  0000_0000  0x00    0    
  17829	:  0000_0000  0x00    0    
  17830	:  0010_1010  0x2A   42  *  
  17831	:  0011_0000  0x30   48  0  
  17832	:  0000_0000  0x00    0    
  17833	:  0000_0100  0x04    4    
  17834	:  0010_1101  0x2D   45  -  
  17835	:  0100_0011  0x43   67  C  
  17836	:  0011_0100  0x34   52  4  
  17837	:  1100_0101  0xC5  197    
  17838	:  0000_1000  0x08    8    
  17839	:  0100_0001  0x41   65  A  
  17840	:  0010_1101  0x2D   45  -  
  17841	:  0011_0101  0x35   53  5  
  17842	:  0011_0010  0x32   50  2  
  17843	:  0010_1101  0x2D   45  -  
  17844	:  0011_0001  0x31   49  1  
  17845	:  0011_1001  0x39   57  9  
  17846	:  0011_1000  0x38   56  8  
  17847	:  1100_0000  0xC0  192    
  17848	:  0000_1100  0x0C   12    
  17849	:  0000_0000  0x00    0    
  17850	:  0000_0001  0x01    1    
  17851	:  0000_0000  0x00    0    
  17852	:  0000_0001  0x01    1    
  17853	:  0000_0000  0x00    0    
  17854	:  0000_0000  0x00    0    
  17855	:  0010_1010  0x2A   42  *  
  17856	:  0011_0000  0x30   48  0  
  17857	:  0000_0000  0x00    0    
  17858	:  0000_0100  0x04    4    
  17859	:  0010_1101  0x2D   45  -  
  17860	:  0100_0011  0x43   67  C  
  17861	:  0011_0100  0x34   52  4  
  17862	:  1100_0110  0xC6  198    
  17863	:  0000_1000  0x08    8    
  17864	:  0100_0001  0x41   65  A  
  17865	:  0010_1101  0x2D   45  -  
  17866	:  0011_0101  0x35   53  5  
  17867	:  0011_0010  0x32   50  2  
  17868	:  0010_1101  0x2D   45  -  
  17869	:  0011_0001  0x31   49  1  
  17870	:  0011_1001  0x39   57  9  
  17871	:  0011_1001  0x39   57  9  
  17872	:  1100_0000  0xC0  192    
  17873	:  0000_1100  0x0C   12    
  17874	:  0000_0000  0x00    0    
  17875	:  0000_0001  0x01    1    
  17876	:  0000_0000  0x00    0    
  17877	:  0000_0001  0x01    1    
  17878	:  0000_0000  0x00    0    
  17879	:  0000_0000  0x00    0    
  17880	:  0010_1010  0x2A   42  *  
  17881	:  0011_0000  0x30   48  0  
  17882	:  0000_0000  0x00    0    
  17883	:  0000_0100  0x04    4    
  17884	:  0010_1101  0x2D   45  -  
  17885	:  0100_0011  0x43   67  C  
  17886	:  0011_0100  0x34   52  4  
  17887	:  1100_0111  0xC7  199    
  17888	:  0000_1000  0x08    8    
  17889	:  0100_0001  0x41   65  A  
  17890	:  0010_1101  0x2D   45  -  
  17891	:  0011_0101  0x35   53  5  
  17892	:  0011_0010  0x32   50  2  
  17893	:  0010_1101  0x2D   45  -  
  17894	:  0011_0010  0x32   50  2  
  17895	:  0011_0000  0x30   48  0  
  17896	:  0011_0000  0x30   48  0  
  17897	:  1100_0000  0xC0  192    
  17898	:  0000_1100  0x0C   12    
  17899	:  0000_0000  0x00    0    
  17900	:  0000_0001  0x01    1    
  17901	:  0000_0000  0x00    0    
  17902	:  0000_0001  0x01    1    
  17903	:  0000_0000  0x00    0    
  17904	:  0000_0000  0x00    0    
  17905	:  0010_1010  0x2A   42  *  
  17906	:  0011_0000  0x30   48  0  
  17907	:  0000_0000  0x00    0    
  17908	:  0000_0100  0x04    4    
  17909	:  0010_1101  0x2D   45  -  
  17910	:  0100_0011  0x43   67  C  
  17911	:  0011_0100  0x34   52  4  
  17912	:  1100_1000  0xC8  200    
  17913	:  0000_1000  0x08    8    
  17914	:  0100_0001  0x41   65  A  
  17915	:  0010_1101  0x2D   45  -  
  17916	:  0011_0101  0x35   53  5  
  17917	:  0011_0010  0x32   50  2  
  17918	:  0010_1101  0x2D   45  -  
  17919	:  0011_0010  0x32   50  2  
  17920	:  0011_0000  0x30   48  0  
  17921	:  0011_0001  0x31   49  1  
  17922	:  1100_0000  0xC0  192    
  17923	:  0000_1100  0x0C   12    
  17924	:  0000_0000  0x00    0    
  17925	:  0000_0001  0x01    1    
  17926	:  0000_0000  0x00    0    
  17927	:  0000_0001  0x01    1    
  17928	:  0000_0000  0x00    0    
  17929	:  0000_0000  0x00    0    
  17930	:  0010_1010  0x2A   42  *  
  17931	:  0011_0000  0x30   48  0  
  17932	:  0000_0000  0x00    0    
  17933	:  0000_0100  0x04    4    
  17934	:  0010_1101  0x2D   45  -  
  17935	:  0100_0011  0x43   67  C  
  17936	:  0011_0100  0x34   52  4  
  17937	:  1100_1001  0xC9  201    
  17938	:  0000_1000  0x08    8    
  17939	:  0100_0001  0x41   65  A  
  17940	:  0010_1101  0x2D   45  -  
  17941	:  0011_0101  0x35   53  5  
  17942	:  0011_0010  0x32   50  2  
  17943	:  0010_1101  0x2D   45  -  
  17944	:  0011_0010  0x32   50  2  
  17945	:  0011_0000  0x30   48  0  
  17946	:  0011_0010  0x32   50  2  
  17947	:  1100_0000  0xC0  192    
  17948	:  0000_1100  0x0C   12    
  17949	:  0000_0000  0x00    0    
  17950	:  0000_0001  0x01    1    
  17951	:  0000_0000  0x00    0    
  17952	:  0000_0001  0x01    1    
  17953	:  0000_0000  0x00    0    
  17954	:  0000_0000  0x00    0    
  17955	:  0010_1010  0x2A   42  *  
  17956	:  0011_0000  0x30   48  0  
  17957	:  0000_0000  0x00    0    
  17958	:  0000_0100  0x04    4    
  17959	:  0010_1101  0x2D   45  -  
  17960	:  0100_0011  0x43   67  C  
  17961	:  0011_0100  0x34   52  4  
  17962	:  1100_1010  0xCA  202    
  17963	:  0000_1000  0x08    8    
  17964	:  0100_0001  0x41   65  A  
  17965	:  0010_1101  0x2D   45  -  
  17966	:  0011_0101  0x35   53  5  
  17967	:  0011_0010  0x32   50  2  
  17968	:  0010_1101  0x2D   45  -  
  17969	:  0011_0010  0x32   50  2  
  17970	:  0011_0000  0x30   48  0  
  17971	:  0011_0011  0x33   51  3  
  17972	:  1100_0000  0xC0  192    
  17973	:  0000_1100  0x0C   12    
  17974	:  0000_0000  0x00    0    
  17975	:  0000_0001  0x01    1    
  17976	:  0000_0000  0x00    0    
  17977	:  0000_0001  0x01    1    
  17978	:  0000_0000  0x00    0    
  17979	:  0000_0000  0x00    0    
  17980	:  0010_1010  0x2A   42  *  
  17981	:  0011_0000  0x30   48  0  
  17982	:  0000_0000  0x00    0    
  17983	:  0000_0100  0x04    4    
  17984	:  0010_1101  0x2D   45  -  
  17985	:  0100_0011  0x43   67  C  
  17986	:  0011_0100  0x34   52  4  
  17987	:  1100_1011  0xCB  203    
  17988	:  0000_1000  0x08    8    
  17989	:  0100_0001  0x41   65  A  
  17990	:  0010_1101  0x2D   45  -  
  17991	:  0011_0101  0x35   53  5  
  17992	:  0011_0010  0x32   50  2  
  17993	:  0010_1101  0x2D   45  -  
  17994	:  0011_0010  0x32   50  2  
  17995	:  0011_0000  0x30   48  0  
  17996	:  0011_0100  0x34   52  4  
  17997	:  1100_0000  0xC0  192    
  17998	:  0000_1100  0x0C   12    
  17999	:  0000_0000  0x00    0    
  18000	:  0000_0001  0x01    1    
  18001	:  0000_0000  0x00    0    
  18002	:  0000_0001  0x01    1    
  18003	:  0000_0000  0x00    0    
  18004	:  0000_0000  0x00    0    
  18005	:  0010_1010  0x2A   42  *  
  18006	:  0011_0000  0x30   48  0  
  18007	:  0000_0000  0x00    0    
  18008	:  0000_0100  0x04    4    
  18009	:  0010_1101  0x2D   45  -  
  18010	:  0100_0011  0x43   67  C  
  18011	:  0011_0100  0x34   52  4  
  18012	:  1100_1100  0xCC  204    
  18013	:  0000_1000  0x08    8    
  18014	:  0100_0001  0x41   65  A  
  18015	:  0010_1101  0x2D   45  -  
  18016	:  0011_0101  0x35   53  5  
  18017	:  0011_0010  0x32   50  2  
  18018	:  0010_1101  0x2D   45  -  
  18019	:  0011_0010  0x32   50  2  
  18020	:  0011_0000  0x30   48  0  
  18021	:  0011_0101  0x35   53  5  
  18022	:  1100_0000  0xC0  192    
  18023	:  0000_1100  0x0C   12    
  18024	:  0000_0000  0x00    0    
  18025	:  0000_0001  0x01    1    
  18026	:  0000_0000  0x00    0    
  18027	:  0000_0001  0x01    1    
  18028	:  0000_0000  0x00    0    
  18029	:  0000_0000  0x00    0    
  18030	:  0010_1010  0x2A   42  *  
  18031	:  0011_0000  0x30   48  0  
  18032	:  0000_0000  0x00    0    
  18033	:  0000_0100  0x04    4    
  18034	:  0010_1101  0x2D   45  -  
  18035	:  0100_0011  0x43   67  C  
  18036	:  0011_0100  0x34   52  4  
  18037	:  1100_1101  0xCD  205    
  18038	:  0000_1000  0x08    8    
  18039	:  0100_0001  0x41   65  A  
  18040	:  0010_1101  0x2D   45  -  
  18041	:  0011_0101  0x35   53  5  
  18042	:  0011_0010  0x32   50  2  
  18043	:  0010_1101  0x2D   45  -  
  18044	:  0011_0010  0x32   50  2  
  18045	:  0011_0000  0x30   48  0  
  18046	:  0011_0110  0x36   54  6  
  18047	:  1100_0000  0xC0  192    
  18048	:  0000_1100  0x0C   12    
  18049	:  0000_0000  0x00    0    
  18050	:  0000_0001  0x01    1    
  18051	:  0000_0000  0x00    0    
  18052	:  0000_0001  0x01    1    
  18053	:  0000_0000  0x00    0    
  18054	:  0000_0000  0x00    0    
  18055	:  0010_1010  0x2A   42  *  
  18056	:  0011_0000  0x30   48  0  
  18057	:  0000_0000  0x00    0    
  18058	:  0000_0100  0x04    4    
  18059	:  0010_1101  0x2D   45  -  
  18060	:  0100_0011  0x43   67  C  
  18061	:  0011_0100  0x34   52  4  
  18062	:  1100_1110  0xCE  206    
  18063	:  0000_1000  0x08    8    
  18064	:  0100_0001  0x41   65  A  
  18065	:  0010_1101  0x2D   45  -  
  18066	:  0011_0101  0x35   53  5  
  18067	:  0011_0010  0x32   50  2  
  18068	:  0010_1101  0x2D   45  -  
  18069	:  0011_0010  0x32   50  2  
  18070	:  0011_0000  0x30   48  0  
  18071	:  0011_0111  0x37   55  7  
  18072	:  1100_0000  0xC0  192    
  18073	:  0000_1100  0x0C   12    
  18074	:  0000_0000  0x00    0    
  18075	:  0000_0001  0x01    1    
  18076	:  0000_0000  0x00    0    
  18077	:  0000_0001  0x01    1    
  18078	:  0000_0000  0x00    0    
  18079	:  0000_0000  0x00    0    
  18080	:  0010_1010  0x2A   42  *  
  18081	:  0011_0000  0x30   48  0  
  18082	:  0000_0000  0x00    0    
  18083	:  0000_0100  0x04    4    
  18084	:  0010_1101  0x2D   45  -  
  18085	:  0100_0011  0x43   67  C  
  18086	:  0011_0100  0x34   52  4  
  18087	:  1100_1111  0xCF  207    
  18088	:  0000_1000  0x08    8    
  18089	:  0100_0001  0x41   65  A  
  18090	:  0010_1101  0x2D   45  -  
  18091	:  0011_0101  0x35   53  5  
  18092	:  0011_0010  0x32   50  2  
  18093	:  0010_1101  0x2D   45  -  
  18094	:  0011_0010  0x32   50  2  
  18095	:  0011_0000  0x30   48  0  
  18096	:  0011_1000  0x38   56  8  
  18097	:  1100_0000  0xC0  192    
  18098	:  0000_1100  0x0C   12    
  18099	:  0000_0000  0x00    0    
  18100	:  0000_0001  0x01    1    
  18101	:  0000_0000  0x00    0    
  18102	:  0000_0001  0x01    1    
  18103	:  0000_0000  0x00    0    
  18104	:  0000_0000  0x00    0    
  18105	:  0010_1010  0x2A   42  *  
  18106	:  0011_0000  0x30   48  0  
  18107	:  0000_0000  0x00    0    
  18108	:  0000_0100  0x04    4    
  18109	:  0010_1101  0x2D   45  -  
  18110	:  0100_0011  0x43   67  C  
  18111	:  0011_0100  0x34   52  4  
  18112	:  1101_0000  0xD0  208    
  18113	:  0000_1000  0x08    8    
  18114	:  0100_0001  0x41   65  A  
  18115	:  0010_1101  0x2D   45  -  
  18116	:  0011_0101  0x35   53  5  
  18117	:  0011_0010  0x32   50  2  
  18118	:  0010_1101  0x2D   45  -  
  18119	:  0011_0010  0x32   50  2  
  18120	:  0011_0000  0x30   48  0  
  18121	:  0011_1001  0x39   57  9  
  18122	:  1100_0000  0xC0  192    
  18123	:  0000_1100  0x0C   12    
  18124	:  0000_0000  0x00    0    
  18125	:  0000_0001  0x01    1    
  18126	:  0000_0000  0x00    0    
  18127	:  0000_0001  0x01    1    
  18128	:  0000_0000  0x00    0    
  18129	:  0000_0000  0x00    0    
  18130	:  0010_1010  0x2A   42  *  
  18131	:  0011_0000  0x30   48  0  
  18132	:  0000_0000  0x00    0    
  18133	:  0000_0100  0x04    4    
  18134	:  0010_1101  0x2D   45  -  
  18135	:  0100_0011  0x43   67  C  
  18136	:  0011_0100  0x34   52  4  
  18137	:  1101_0001  0xD1  209    
  18138	:  0000_1000  0x08    8    
  18139	:  0100_0001  0x41   65  A  
  18140	:  0010_1101  0x2D   45  -  
  18141	:  0011_0101  0x35   53  5  
  18142	:  0011_0010  0x32   50  2  
  18143	:  0010_1101  0x2D   45  -  
  18144	:  0011_0010  0x32   50  2  
  18145	:  0011_0001  0x31   49  1  
  18146	:  0011_0000  0x30   48  0  
  18147	:  1100_0000  0xC0  192    
  18148	:  0000_1100  0x0C   12    
  18149	:  0000_0000  0x00    0    
  18150	:  0000_0001  0x01    1    
  18151	:  0000_0000  0x00    0    
  18152	:  0000_0001  0x01    1    
  18153	:  0000_0000  0x00    0    
  18154	:  0000_0000  0x00    0    
  18155	:  0010_1010  0x2A   42  *  
  18156	:  0011_0000  0x30   48  0  
  18157	:  0000_0000  0x00    0    
  18158	:  0000_0100  0x04    4    
  18159	:  0010_1101  0x2D   45  -  
  18160	:  0100_0011  0x43   67  C  
  18161	:  0011_0100  0x34   52  4  
  18162	:  1101_0010  0xD2  210    
  18163	:  0000_1000  0x08    8    
  18164	:  0100_0001  0x41   65  A  
  18165	:  0010_1101  0x2D   45  -  
  18166	:  0011_0101  0x35   53  5  
  18167	:  0011_0010  0x32   50  2  
  18168	:  0010_1101  0x2D   45  -  
  18169	:  0011_0010  0x32   50  2  
  18170	:  0011_0001  0x31   49  1  
  18171	:  0011_0001  0x31   49  1  
  18172	:  1100_0000  0xC0  192    
  18173	:  0000_1100  0x0C   12    
  18174	:  0000_0000  0x00    0    
  18175	:  0000_0001  0x01    1    
  18176	:  0000_0000  0x00    0    
  18177	:  0000_0001  0x01    1    
  18178	:  0000_0000  0x00    0    
  18179	:  0000_0000  0x00    0    
  18180	:  0010_1010  0x2A   42  *  
  18181	:  0011_0000  0x30   48  0  
  18182	:  0000_0000  0x00    0    
  18183	:  0000_0100  0x04    4    
  18184	:  0010_1101  0x2D   45  -  
  18185	:  0100_0011  0x43   67  C  
  18186	:  0011_0100  0x34   52  4  
  18187	:  1101_0011  0xD3  211    
  18188	:  0000_1000  0x08    8    
  18189	:  0100_0001  0x41   65  A  
  18190	:  0010_1101  0x2D   45  -  
  18191	:  0011_0101  0x35   53  5  
  18192	:  0011_0010  0x32   50  2  
  18193	:  0010_1101  0x2D   45  -  
  18194	:  0011_0010  0x32   50  2  
  18195	:  0011_0001  0x31   49  1  
  18196	:  0011_0010  0x32   50  2  
  18197	:  1100_0000  0xC0  192    
  18198	:  0000_1100  0x0C   12    
  18199	:  0000_0000  0x00    0    
  18200	:  0000_0001  0x01    1    
  18201	:  0000_0000  0x00    0    
  18202	:  0000_0001  0x01    1    
  18203	:  0000_0000  0x00    0    
  18204	:  0000_0000  0x00    0    
  18205	:  0010_1010  0x2A   42  *  
  18206	:  0011_0000  0x30   48  0  
  18207	:  0000_0000  0x00    0    
  18208	:  0000_0100  0x04    4    
  18209	:  0010_1101  0x2D   45  -  
  18210	:  0100_0011  0x43   67  C  
  18211	:  0011_0100  0x34   52  4  
  18212	:  1101_0100  0xD4  212    
  18213	:  0000_1000  0x08    8    
  18214	:  0100_0001  0x41   65  A  
  18215	:  0010_1101  0x2D   45  -  
  18216	:  0011_0101  0x35   53  5  
  18217	:  0011_0010  0x32   50  2  
  18218	:  0010_1101  0x2D   45  -  
  18219	:  0011_0010  0x32   50  2  
  18220	:  0011_0001  0x31   49  1  
  18221	:  0011_0011  0x33   51  3  
  18222	:  1100_0000  0xC0  192    
  18223	:  0000_1100  0x0C   12    
  18224	:  0000_0000  0x00    0    
  18225	:  0000_0001  0x01    1    
  18226	:  0000_0000  0x00    0    
  18227	:  0000_0001  0x01    1    
  18228	:  0000_0000  0x00    0    
  18229	:  0000_0000  0x00    0    
  18230	:  0010_1010  0x2A   42  *  
  18231	:  0011_0000  0x30   48  0  
  18232	:  0000_0000  0x00    0    
  18233	:  0000_0100  0x04    4    
  18234	:  0010_1101  0x2D   45  -  
  18235	:  0100_0011  0x43   67  C  
  18236	:  0011_0100  0x34   52  4  
  18237	:  1101_0101  0xD5  213    
  18238	:  0000_1000  0x08    8    
  18239	:  0100_0001  0x41   65  A  
  18240	:  0010_1101  0x2D   45  -  
  18241	:  0011_0101  0x35   53  5  
  18242	:  0011_0010  0x32   50  2  
  18243	:  0010_1101  0x2D   45  -  
  18244	:  0011_0010  0x32   50  2  
  18245	:  0011_0001  0x31   49  1  
  18246	:  0011_0100  0x34   52  4  
  18247	:  1100_0000  0xC0  192    
  18248	:  0000_1100  0x0C   12    
  18249	:  0000_0000  0x00    0    
  18250	:  0000_0001  0x01    1    
  18251	:  0000_0000  0x00    0    
  18252	:  0000_0001  0x01    1    
  18253	:  0000_0000  0x00    0    
  18254	:  0000_0000  0x00    0    
  18255	:  0010_1010  0x2A   42  *  
  18256	:  0011_0000  0x30   48  0  
  18257	:  0000_0000  0x00    0    
  18258	:  0000_0100  0x04    4    
  18259	:  0010_1101  0x2D   45  -  
  18260	:  0100_0011  0x43   67  C  
  18261	:  0011_0100  0x34   52  4  
  18262	:  1101_0110  0xD6  214    
  18263	:  0000_1000  0x08    8    
  18264	:  0100_0001  0x41   65  A  
  18265	:  0010_1101  0x2D   45  -  
  18266	:  0011_0101  0x35   53  5  
  18267	:  0011_0010  0x32   50  2  
  18268	:  0010_1101  0x2D   45  -  
  18269	:  0011_0010  0x32   50  2  
  18270	:  0011_0001  0x31   49  1  
  18271	:  0011_0101  0x35   53  5  
  18272	:  1100_0000  0xC0  192    
  18273	:  0000_1100  0x0C   12    
  18274	:  0000_0000  0x00    0    
  18275	:  0000_0001  0x01    1    
  18276	:  0000_0000  0x00    0    
  18277	:  0000_0001  0x01    1    
  18278	:  0000_0000  0x00    0    
  18279	:  0000_0000  0x00    0    
  18280	:  0010_1010  0x2A   42  *  
  18281	:  0011_0000  0x30   48  0  
  18282	:  0000_0000  0x00    0    
  18283	:  0000_0100  0x04    4    
  18284	:  0010_1101  0x2D   45  -  
  18285	:  0100_0011  0x43   67  C  
  18286	:  0011_0100  0x34   52  4  
  18287	:  1101_0111  0xD7  215    
  18288	:  0000_1000  0x08    8    
  18289	:  0100_0001  0x41   65  A  
  18290	:  0010_1101  0x2D   45  -  
  18291	:  0011_0101  0x35   53  5  
  18292	:  0011_0010  0x32   50  2  
  18293	:  0010_1101  0x2D   45  -  
  18294	:  0011_0010  0x32   50  2  
  18295	:  0011_0001  0x31   49  1  
  18296	:  0011_0110  0x36   54  6  
  18297	:  1100_0000  0xC0  192    
  18298	:  0000_1100  0x0C   12    
  18299	:  0000_0000  0x00    0    
  18300	:  0000_0001  0x01    1    
  18301	:  0000_0000  0x00    0    
  18302	:  0000_0001  0x01    1    
  18303	:  0000_0000  0x00    0    
  18304	:  0000_0000  0x00    0    
  18305	:  0010_1010  0x2A   42  *  
  18306	:  0011_0000  0x30   48  0  
  18307	:  0000_0000  0x00    0    
  18308	:  0000_0100  0x04    4    
  18309	:  0010_1101  0x2D   45  -  
  18310	:  0100_0011  0x43   67  C  
  18311	:  0011_0100  0x34   52  4  
  18312	:  1101_1000  0xD8  216    
  18313	:  0000_1000  0x08    8    
  18314	:  0100_0001  0x41   65  A  
  18315	:  0010_1101  0x2D   45  -  
  18316	:  0011_0101  0x35   53  5  
  18317	:  0011_0010  0x32   50  2  
  18318	:  0010_1101  0x2D   45  -  
  18319	:  0011_0010  0x32   50  2  
  18320	:  0011_0001  0x31   49  1  
  18321	:  0011_0111  0x37   55  7  
  18322	:  1100_0000  0xC0  192    
  18323	:  0000_1100  0x0C   12    
  18324	:  0000_0000  0x00    0    
  18325	:  0000_0001  0x01    1    
  18326	:  0000_0000  0x00    0    
  18327	:  0000_0001  0x01    1    
  18328	:  0000_0000  0x00    0    
  18329	:  0000_0000  0x00    0    
  18330	:  0010_1010  0x2A   42  *  
  18331	:  0011_0000  0x30   48  0  
  18332	:  0000_0000  0x00    0    
  18333	:  0000_0100  0x04    4    
  18334	:  0010_1101  0x2D   45  -  
  18335	:  0100_0011  0x43   67  C  
  18336	:  0011_0100  0x34   52  4  
  18337	:  1101_1001  0xD9  217    
  18338	:  0000_1000  0x08    8    
  18339	:  0100_0001  0x41   65  A  
  18340	:  0010_1101  0x2D   45  -  
  18341	:  0011_0101  0x35   53  5  
  18342	:  0011_0010  0x32   50  2  
  18343	:  0010_1101  0x2D   45  -  
  18344	:  0011_0010  0x32   50  2  
  18345	:  0011_0001  0x31   49  1  
  18346	:  0011_1000  0x38   56  8  
  18347	:  1100_0000  0xC0  192    
  18348	:  0000_1100  0x0C   12    
  18349	:  0000_0000  0x00    0    
  18350	:  0000_0001  0x01    1    
  18351	:  0000_0000  0x00    0    
  18352	:  0000_0001  0x01    1    
  18353	:  0000_0000  0x00    0    
  18354	:  0000_0000  0x00    0    
  18355	:  0010_1010  0x2A   42  *  
  18356	:  0011_0000  0x30   48  0  
  18357	:  0000_0000  0x00    0    
  18358	:  0000_0100  0x04    4    
  18359	:  0010_1101  0x2D   45  -  
  18360	:  0100_0011  0x43   67  C  
  18361	:  0011_0100  0x34   52  4  
  18362	:  1101_1010  0xDA  218    
  18363	:  0000_1000  0x08    8    
  18364	:  0100_0001  0x41   65  A  
  18365	:  0010_1101  0x2D   45  -  
  18366	:  0011_0101  0x35   53  5  
  18367	:  0011_0010  0x32   50  2  
  18368	:  0010_1101  0x2D   45  -  
  18369	:  0011_0010  0x32   50  2  
  18370	:  0011_0001  0x31   49  1  
  18371	:  0011_1001  0x39   57  9  
  18372	:  1100_0000  0xC0  192    
  18373	:  0000_1100  0x0C   12    
  18374	:  0000_0000  0x00    0    
  18375	:  0000_0001  0x01    1    
  18376	:  0000_0000  0x00    0    
  18377	:  0000_0001  0x01    1    
  18378	:  0000_0000  0x00    0    
  18379	:  0000_0000  0x00    0    
  18380	:  0010_1010  0x2A   42  *  
  18381	:  0011_0000  0x30   48  0  
  18382	:  0000_0000  0x00    0    
  18383	:  0000_0100  0x04    4    
  18384	:  0010_1101  0x2D   45  -  
  18385	:  0100_0011  0x43   67  C  
  18386	:  0011_0100  0x34   52  4  
  18387	:  1101_1011  0xDB  219    
  18388	:  0000_1000  0x08    8    
  18389	:  0100_0001  0x41   65  A  
  18390	:  0010_1101  0x2D   45  -  
  18391	:  0011_0101  0x35   53  5  
  18392	:  0011_0010  0x32   50  2  
  18393	:  0010_1101  0x2D   45  -  
  18394	:  0011_0010  0x32   50  2  
  18395	:  0011_0010  0x32   50  2  
  18396	:  0011_0000  0x30   48  0  
  18397	:  1100_0000  0xC0  192    
  18398	:  0000_1100  0x0C   12    
  18399	:  0000_0000  0x00    0    
  18400	:  0000_0001  0x01    1    
  18401	:  0000_0000  0x00    0    
  18402	:  0000_0001  0x01    1    
  18403	:  0000_0000  0x00    0    
  18404	:  0000_0000  0x00    0    
  18405	:  0010_1010  0x2A   42  *  
  18406	:  0011_0000  0x30   48  0  
  18407	:  0000_0000  0x00    0    
  18408	:  0000_0100  0x04    4    
  18409	:  0010_1101  0x2D   45  -  
  18410	:  0100_0011  0x43   67  C  
  18411	:  0011_0100  0x34   52  4  
  18412	:  1101_1100  0xDC  220    
  18413	:  0000_1000  0x08    8    
  18414	:  0100_0001  0x41   65  A  
  18415	:  0010_1101  0x2D   45  -  
  18416	:  0011_0101  0x35   53  5  
  18417	:  0011_0010  0x32   50  2  
  18418	:  0010_1101  0x2D   45  -  
  18419	:  0011_0010  0x32   50  2  
  18420	:  0011_0010  0x32   50  2  
  18421	:  0011_0001  0x31   49  1  
  18422	:  1100_0000  0xC0  192    
  18423	:  0000_1100  0x0C   12    
  18424	:  0000_0000  0x00    0    
  18425	:  0000_0001  0x01    1    
  18426	:  0000_0000  0x00    0    
  18427	:  0000_0001  0x01    1    
  18428	:  0000_0000  0x00    0    
  18429	:  0000_0000  0x00    0    
  18430	:  0010_1010  0x2A   42  *  
  18431	:  0011_0000  0x30   48  0  
  18432	:  0000_0000  0x00    0    
  18433	:  0000_0100  0x04    4    
  18434	:  0010_1101  0x2D   45  -  
  18435	:  0100_0011  0x43   67  C  
  18436	:  0011_0100  0x34   52  4  
  18437	:  1101_1101  0xDD  221    
  18438	:  0000_1000  0x08    8    
  18439	:  0100_0001  0x41   65  A  
  18440	:  0010_1101  0x2D   45  -  
  18441	:  0011_0101  0x35   53  5  
  18442	:  0011_0010  0x32   50  2  
  18443	:  0010_1101  0x2D   45  -  
  18444	:  0011_0010  0x32   50  2  
  18445	:  0011_0010  0x32   50  2  
  18446	:  0011_0010  0x32   50  2  
  18447	:  1100_0000  0xC0  192    
  18448	:  0000_1100  0x0C   12    
  18449	:  0000_0000  0x00    0    
  18450	:  0000_0001  0x01    1    
  18451	:  0000_0000  0x00    0    
  18452	:  0000_0001  0x01    1    
  18453	:  0000_0000  0x00    0    
  18454	:  0000_0000  0x00    0    
  18455	:  0010_1010  0x2A   42  *  
  18456	:  0011_0000  0x30   48  0  
  18457	:  0000_0000  0x00    0    
  18458	:  0000_0100  0x04    4    
  18459	:  0010_1101  0x2D   45  -  
  18460	:  0100_0011  0x43   67  C  
  18461	:  0011_0100  0x34   52  4  
  18462	:  1101_1110  0xDE  222    
  18463	:  0000_1000  0x08    8    
  18464	:  0100_0001  0x41   65  A  
  18465	:  0010_1101  0x2D   45  -  
  18466	:  0011_0101  0x35   53  5  
  18467	:  0011_0010  0x32   50  2  
  18468	:  0010_1101  0x2D   45  -  
  18469	:  0011_0010  0x32   50  2  
  18470	:  0011_0010  0x32   50  2  
  18471	:  0011_0011  0x33   51  3  
  18472	:  1100_0000  0xC0  192    
  18473	:  0000_1100  0x0C   12    
  18474	:  0000_0000  0x00    0    
  18475	:  0000_0001  0x01    1    
  18476	:  0000_0000  0x00    0    
  18477	:  0000_0001  0x01    1    
  18478	:  0000_0000  0x00    0    
  18479	:  0000_0000  0x00    0    
  18480	:  0010_1010  0x2A   42  *  
  18481	:  0011_0000  0x30   48  0  
  18482	:  0000_0000  0x00    0    
  18483	:  0000_0100  0x04    4    
  18484	:  0010_1101  0x2D   45  -  
  18485	:  0100_0011  0x43   67  C  
  18486	:  0011_0100  0x34   52  4  
  18487	:  1101_1111  0xDF  223    
  18488	:  0000_1000  0x08    8    
  18489	:  0100_0001  0x41   65  A  
  18490	:  0010_1101  0x2D   45  -  
  18491	:  0011_0101  0x35   53  5  
  18492	:  0011_0010  0x32   50  2  
  18493	:  0010_1101  0x2D   45  -  
  18494	:  0011_0010  0x32   50  2  
  18495	:  0011_0010  0x32   50  2  
  18496	:  0011_0100  0x34   52  4  
  18497	:  1100_0000  0xC0  192    
  18498	:  0000_1100  0x0C   12    
  18499	:  0000_0000  0x00    0    
  18500	:  0000_0001  0x01    1    
  18501	:  0000_0000  0x00    0    
  18502	:  0000_0001  0x01    1    
  18503	:  0000_0000  0x00    0    
  18504	:  0000_0000  0x00    0    
  18505	:  0010_1010  0x2A   42  *  
  18506	:  0011_0000  0x30   48  0  
  18507	:  0000_0000  0x00    0    
  18508	:  0000_0100  0x04    4    
  18509	:  0010_1101  0x2D   45  -  
  18510	:  0100_0011  0x43   67  C  
  18511	:  0011_0100  0x34   52  4  
  18512	:  1110_0000  0xE0  224    
  18513	:  0000_1000  0x08    8    
  18514	:  0100_0001  0x41   65  A  
  18515	:  0010_1101  0x2D   45  -  
  18516	:  0011_0101  0x35   53  5  
  18517	:  0011_0010  0x32   50  2  
  18518	:  0010_1101  0x2D   45  -  
  18519	:  0011_0010  0x32   50  2  
  18520	:  0011_0010  0x32   50  2  
  18521	:  0011_0101  0x35   53  5  
  18522	:  1100_0000  0xC0  192    
  18523	:  0000_1100  0x0C   12    
  18524	:  0000_0000  0x00    0    
  18525	:  0000_0001  0x01    1    
  18526	:  0000_0000  0x00    0    
  18527	:  0000_0001  0x01    1    
  18528	:  0000_0000  0x00    0    
  18529	:  0000_0000  0x00    0    
  18530	:  0010_1010  0x2A   42  *  
  18531	:  0011_0000  0x30   48  0  
  18532	:  0000_0000  0x00    0    
  18533	:  0000_0100  0x04    4    
  18534	:  0010_1101  0x2D   45  -  
  18535	:  0100_0011  0x43   67  C  
  18536	:  0011_0100  0x34   52  4  
  18537	:  1110_0001  0xE1  225    
  18538	:  0000_1000  0x08    8    
  18539	:  0100_0001  0x41   65  A  
  18540	:  0010_1101  0x2D   45  -  
  18541	:  0011_0101  0x35   53  5  
  18542	:  0011_0010  0x32   50  2  
  18543	:  0010_1101  0x2D   45  -  
  18544	:  0011_0010  0x32   50  2  
  18545	:  0011_0010  0x32   50  2  
  18546	:  0011_0110  0x36   54  6  
  18547	:  1100_0000  0xC0  192    
  18548	:  0000_1100  0x0C   12    
  18549	:  0000_0000  0x00    0    
  18550	:  0000_0001  0x01    1    
  18551	:  0000_0000  0x00    0    
  18552	:  0000_0001  0x01    1    
  18553	:  0000_0000  0x00    0    
  18554	:  0000_0000  0x00    0    
  18555	:  0010_1010  0x2A   42  *  
  18556	:  0011_0000  0x30   48  0  
  18557	:  0000_0000  0x00    0    
  18558	:  0000_0100  0x04    4    
  18559	:  0010_1101  0x2D   45  -  
  18560	:  0100_0011  0x43   67  C  
  18561	:  0011_0100  0x34   52  4  
  18562	:  1110_0010  0xE2  226    
  18563	:  0000_1000  0x08    8    
  18564	:  0100_0001  0x41   65  A  
  18565	:  0010_1101  0x2D   45  -  
  18566	:  0011_0101  0x35   53  5  
  18567	:  0011_0010  0x32   50  2  
  18568	:  0010_1101  0x2D   45  -  
  18569	:  0011_0010  0x32   50  2  
  18570	:  0011_0010  0x32   50  2  
  18571	:  0011_0111  0x37   55  7  
  18572	:  1100_0000  0xC0  192    
  18573	:  0000_1100  0x0C   12    
  18574	:  0000_0000  0x00    0    
  18575	:  0000_0001  0x01    1    
  18576	:  0000_0000  0x00    0    
  18577	:  0000_0001  0x01    1    
  18578	:  0000_0000  0x00    0    
  18579	:  0000_0000  0x00    0    
  18580	:  0010_1010  0x2A   42  *  
  18581	:  0011_0000  0x30   48  0  
  18582	:  0000_0000  0x00    0    
  18583	:  0000_0100  0x04    4    
  18584	:  0010_1101  0x2D   45  -  
  18585	:  0100_0011  0x43   67  C  
  18586	:  0011_0100  0x34   52  4  
  18587	:  1110_0011  0xE3  227    
  18588	:  0000_1000  0x08    8    
  18589	:  0100_0001  0x41   65  A  
  18590	:  0010_1101  0x2D   45  -  
  18591	:  0011_0101  0x35   53  5  
  18592	:  0011_0010  0x32   50  2  
  18593	:  0010_1101  0x2D   45  -  
  18594	:  0011_0010  0x32   50  2  
  18595	:  0011_0010  0x32   50  2  
  18596	:  0011_1000  0x38   56  8  
  18597	:  1100_0000  0xC0  192    
  18598	:  0000_1100  0x0C   12    
  18599	:  0000_0000  0x00    0    
  18600	:  0000_0001  0x01    1    
  18601	:  0000_0000  0x00    0    
  18602	:  0000_0001  0x01    1    
  18603	:  0000_0000  0x00    0    
  18604	:  0000_0000  0x00    0    
  18605	:  0010_1010  0x2A   42  *  
  18606	:  0011_0000  0x30   48  0  
  18607	:  0000_0000  0x00    0    
  18608	:  0000_0100  0x04    4    
  18609	:  0010_1101  0x2D   45  -  
  18610	:  0100_0011  0x43   67  C  
  18611	:  0011_0100  0x34   52  4  
  18612	:  1110_0100  0xE4  228    
  18613	:  0000_1000  0x08    8    
  18614	:  0100_0001  0x41   65  A  
  18615	:  0010_1101  0x2D   45  -  
  18616	:  0011_0101  0x35   53  5  
  18617	:  0011_0010  0x32   50  2  
  18618	:  0010_1101  0x2D   45  -  
  18619	:  0011_0010  0x32   50  2  
  18620	:  0011_0010  0x32   50  2  
  18621	:  0011_1001  0x39   57  9  
  18622	:  1100_0000  0xC0  192    
  18623	:  0000_1100  0x0C   12    
  18624	:  0000_0000  0x00    0    
  18625	:  0000_0001  0x01    1    
  18626	:  0000_0000  0x00    0    
  18627	:  0000_0001  0x01    1    
  18628	:  0000_0000  0x00    0    
  18629	:  0000_0000  0x00    0    
  18630	:  0010_1010  0x2A   42  *  
  18631	:  0011_0000  0x30   48  0  
  18632	:  0000_0000  0x00    0    
  18633	:  0000_0100  0x04    4    
  18634	:  0010_1101  0x2D   45  -  
  18635	:  0100_0011  0x43   67  C  
  18636	:  0011_0100  0x34   52  4  
  18637	:  1110_0101  0xE5  229    
  18638	:  0000_1000  0x08    8    
  18639	:  0100_0001  0x41   65  A  
  18640	:  0010_1101  0x2D   45  -  
  18641	:  0011_0101  0x35   53  5  
  18642	:  0011_0010  0x32   50  2  
  18643	:  0010_1101  0x2D   45  -  
  18644	:  0011_0010  0x32   50  2  
  18645	:  0011_0011  0x33   51  3  
  18646	:  0011_0000  0x30   48  0  
  18647	:  1100_0000  0xC0  192    
  18648	:  0000_1100  0x0C   12    
  18649	:  0000_0000  0x00    0    
  18650	:  0000_0001  0x01    1    
  18651	:  0000_0000  0x00    0    
  18652	:  0000_0001  0x01    1    
  18653	:  0000_0000  0x00    0    
  18654	:  0000_0000  0x00    0    
  18655	:  0010_1010  0x2A   42  *  
  18656	:  0011_0000  0x30   48  0  
  18657	:  0000_0000  0x00    0    
  18658	:  0000_0100  0x04    4    
  18659	:  0010_1101  0x2D   45  -  
  18660	:  0100_0011  0x43   67  C  
  18661	:  0011_0100  0x34   52  4  
  18662	:  1110_0110  0xE6  230    
  18663	:  0000_1000  0x08    8    
  18664	:  0100_0001  0x41   65  A  
  18665	:  0010_1101  0x2D   45  -  
  18666	:  0011_0101  0x35   53  5  
  18667	:  0011_0010  0x32   50  2  
  18668	:  0010_1101  0x2D   45  -  
  18669	:  0011_0010  0x32   50  2  
  18670	:  0011_0011  0x33   51  3  
  18671	:  0011_0001  0x31   49  1  
  18672	:  1100_0000  0xC0  192    
  18673	:  0000_1100  0x0C   12    
  18674	:  0000_0000  0x00    0    
  18675	:  0000_0001  0x01    1    
  18676	:  0000_0000  0x00    0    
  18677	:  0000_0001  0x01    1    
  18678	:  0000_0000  0x00    0    
  18679	:  0000_0000  0x00    0    
  18680	:  0010_1010  0x2A   42  *  
  18681	:  0011_0000  0x30   48  0  
  18682	:  0000_0000  0x00    0    
  18683	:  0000_0100  0x04    4    
  18684	:  0010_1101  0x2D   45  -  
  18685	:  0100_0011  0x43   67  C  
  18686	:  0011_0100  0x34   52  4  
  18687	:  1110_0111  0xE7  231    
  18688	:  0000_1000  0x08    8    
  18689	:  0100_0001  0x41   65  A  
  18690	:  0010_1101  0x2D   45  -  
  18691	:  0011_0101  0x35   53  5  
  18692	:  0011_0010  0x32   50  2  
  18693	:  0010_1101  0x2D   45  -  
  18694	:  0011_0010  0x32   50  2  
  18695	:  0011_0011  0x33   51  3  
  18696	:  0011_0010  0x32   50  2  
  18697	:  1100_0000  0xC0  192    
  18698	:  0000_1100  0x0C   12    
  18699	:  0000_0000  0x00    0    
  18700	:  0000_0001  0x01    1    
  18701	:  0000_0000  0x00    0    
  18702	:  0000_0001  0x01    1    
  18703	:  0000_0000  0x00    0    
  18704	:  0000_0000  0x00    0    
  18705	:  0010_1010  0x2A   42  *  
  18706	:  0011_0000  0x30   48  0  
  18707	:  0000_0000  0x00    0    
  18708	:  0000_0100  0x04    4    
  18709	:  0010_1101  0x2D   45  -  
  18710	:  0100_0011  0x43   67  C  
  18711	:  0011_0100  0x34   52  4  
  18712	:  1110_1000  0xE8  232    
  18713	:  0000_1000  0x08    8    
  18714	:  0100_0001  0x41   65  A  
  18715	:  0010_1101  0x2D   45  -  
  18716	:  0011_0101  0x35   53  5  
  18717	:  0011_0010  0x32   50  2  
  18718	:  0010_1101  0x2D   45  -  
  18719	:  0011_0010  0x32   50  2  
  18720	:  0011_0011  0x33   51  3  
  18721	:  0011_0011  0x33   51  3  
  18722	:  1100_0000  0xC0  192    
  18723	:  0000_1100  0x0C   12    
  18724	:  0000_0000  0x00    0    
  18725	:  0000_0001  0x01    1    
  18726	:  0000_0000  0x00    0    
  18727	:  0000_0001  0x01    1    
  18728	:  0000_0000  0x00    0    
  18729	:  0000_0000  0x00    0    
  18730	:  0010_1010  0x2A   42  *  
  18731	:  0011_0000  0x30   48  0  
  18732	:  0000_0000  0x00    0    
  18733	:  0000_0100  0x04    4    
  18734	:  0010_1101  0x2D   45  -  
  18735	:  0100_0011  0x43   67  C  
  18736	:  0011_0100  0x34   52  4  
  18737	:  1110_1001  0xE9  233    
  18738	:  0000_1000  0x08    8    
  18739	:  0100_0001  0x41   65  A  
  18740	:  0010_1101  0x2D   45  -  
  18741	:  0011_0101  0x35   53  5  
  18742	:  0011_0010  0x32   50  2  
  18743	:  0010_1101  0x2D   45  -  
  18744	:  0011_0010  0x32   50  2  
  18745	:  0011_0011  0x33   51  3  
  18746	:  0011_0100  0x34   52  4  
  18747	:  1100_0000  0xC0  192    
  18748	:  0000_1100  0x0C   12    
  18749	:  0000_0000  0x00    0    
  18750	:  0000_0001  0x01    1    
  18751	:  0000_0000  0x00    0    
  18752	:  0000_0001  0x01    1    
  18753	:  0000_0000  0x00    0    
  18754	:  0000_0000  0x00    0    
  18755	:  0010_1010  0x2A   42  *  
  18756	:  0011_0000  0x30   48  0  
  18757	:  0000_0000  0x00    0    
  18758	:  0000_0100  0x04    4    
  18759	:  0010_1101  0x2D   45  -  
  18760	:  0100_0011  0x43   67  C  
  18761	:  0011_0100  0x34   52  4  
  18762	:  1110_1010  0xEA  234    
  18763	:  0000_1000  0x08    8    
  18764	:  0100_0001  0x41   65  A  
  18765	:  0010_1101  0x2D   45  -  
  18766	:  0011_0101  0x35   53  5  
  18767	:  0011_0010  0x32   50  2  
  18768	:  0010_1101  0x2D   45  -  
  18769	:  0011_0010  0x32   50  2  
  18770	:  0011_0011  0x33   51  3  
  18771	:  0011_0101  0x35   53  5  
  18772	:  1100_0000  0xC0  192    
  18773	:  0000_1100  0x0C   12    
  18774	:  0000_0000  0x00    0    
  18775	:  0000_0001  0x01    1    
  18776	:  0000_0000  0x00    0    
  18777	:  0000_0001  0x01    1    
  18778	:  0000_0000  0x00    0    
  18779	:  0000_0000  0x00    0    
  18780	:  0010_1010  0x2A   42  *  
  18781	:  0011_0000  0x30   48  0  
  18782	:  0000_0000  0x00    0    
  18783	:  0000_0100  0x04    4    
  18784	:  0010_1101  0x2D   45  -  
  18785	:  0100_0011  0x43   67  C  
  18786	:  0011_0100  0x34   52  4  
  18787	:  1110_1011  0xEB  235    
  18788	:  0000_1000  0x08    8    
  18789	:  0100_0001  0x41   65  A  
  18790	:  0010_1101  0x2D   45  -  
  18791	:  0011_0101  0x35   53  5  
  18792	:  0011_0010  0x32   50  2  
  18793	:  0010_1101  0x2D   45  -  
  18794	:  0011_0010  0x32   50  2  
  18795	:  0011_0011  0x33   51  3  
  18796	:  0011_0110  0x36   54  6  
  18797	:  1100_0000  0xC0  192    
  18798	:  0000_1100  0x0C   12    
  18799	:  0000_0000  0x00    0    
  18800	:  0000_0001  0x01    1    
  18801	:  0000_0000  0x00    0    
  18802	:  0000_0001  0x01    1    
  18803	:  0000_0000  0x00    0    
  18804	:  0000_0000  0x00    0    
  18805	:  0010_1010  0x2A   42  *  
  18806	:  0011_0000  0x30   48  0  
  18807	:  0000_0000  0x00    0    
  18808	:  0000_0100  0x04    4    
  18809	:  0010_1101  0x2D   45  -  
  18810	:  0100_0011  0x43   67  C  
  18811	:  0011_0100  0x34   52  4  
  18812	:  1110_1100  0xEC  236    
  18813	:  0000_1000  0x08    8    
  18814	:  0100_0001  0x41   65  A  
  18815	:  0010_1101  0x2D   45  -  
  18816	:  0011_0101  0x35   53  5  
  18817	:  0011_0010  0x32   50  2  
  18818	:  0010_1101  0x2D   45  -  
  18819	:  0011_0010  0x32   50  2  
  18820	:  0011_0011  0x33   51  3  
  18821	:  0011_0111  0x37   55  7  
  18822	:  1100_0000  0xC0  192    
  18823	:  0000_1100  0x0C   12    
  18824	:  0000_0000  0x00    0    
  18825	:  0000_0001  0x01    1    
  18826	:  0000_0000  0x00    0    
  18827	:  0000_0001  0x01    1    
  18828	:  0000_0000  0x00    0    
  18829	:  0000_0000  0x00    0    
  18830	:  0010_1010  0x2A   42  *  
  18831	:  0011_0000  0x30   48  0  
  18832	:  0000_0000  0x00    0    
  18833	:  0000_0100  0x04    4    
  18834	:  0010_1101  0x2D   45  -  
  18835	:  0100_0011  0x43   67  C  
  18836	:  0011_0100  0x34   52  4  
  18837	:  1110_1101  0xED  237    
  18838	:  0000_1000  0x08    8    
  18839	:  0100_0001  0x41   65  A  
  18840	:  0010_1101  0x2D   45  -  
  18841	:  0011_0101  0x35   53  5  
  18842	:  0011_0010  0x32   50  2  
  18843	:  0010_1101  0x2D   45  -  
  18844	:  0011_0010  0x32   50  2  
  18845	:  0011_0011  0x33   51  3  
  18846	:  0011_1000  0x38   56  8  
  18847	:  1100_0000  0xC0  192    
  18848	:  0000_1100  0x0C   12    
  18849	:  0000_0000  0x00    0    
  18850	:  0000_0001  0x01    1    
  18851	:  0000_0000  0x00    0    
  18852	:  0000_0001  0x01    1    
  18853	:  0000_0000  0x00    0    
  18854	:  0000_0000  0x00    0    
  18855	:  0010_1010  0x2A   42  *  
  18856	:  0011_0000  0x30   48  0  
  18857	:  0000_0000  0x00    0    
  18858	:  0000_0100  0x04    4    
  18859	:  0010_1101  0x2D   45  -  
  18860	:  0100_0011  0x43   67  C  
  18861	:  0011_0100  0x34   52  4  
  18862	:  1110_1110  0xEE  238    
  18863	:  0000_1000  0x08    8    
  18864	:  0100_0001  0x41   65  A  
  18865	:  0010_1101  0x2D   45  -  
  18866	:  0011_0101  0x35   53  5  
  18867	:  0011_0010  0x32   50  2  
  18868	:  0010_1101  0x2D   45  -  
  18869	:  0011_0010  0x32   50  2  
  18870	:  0011_0011  0x33   51  3  
  18871	:  0011_1001  0x39   57  9  
  18872	:  1100_0000  0xC0  192    
  18873	:  0000_1100  0x0C   12    
  18874	:  0000_0000  0x00    0    
  18875	:  0000_0001  0x01    1    
  18876	:  0000_0000  0x00    0    
  18877	:  0000_0001  0x01    1    
  18878	:  0000_0000  0x00    0    
  18879	:  0000_0000  0x00    0    
  18880	:  0010_1010  0x2A   42  *  
  18881	:  0011_0000  0x30   48  0  
  18882	:  0000_0000  0x00    0    
  18883	:  0000_0100  0x04    4    
  18884	:  0010_1101  0x2D   45  -  
  18885	:  0100_0011  0x43   67  C  
  18886	:  0011_0100  0x34   52  4  
  18887	:  1110_1111  0xEF  239    
  18888	:  0000_1000  0x08    8    
  18889	:  0100_0001  0x41   65  A  
  18890	:  0010_1101  0x2D   45  -  
  18891	:  0011_0101  0x35   53  5  
  18892	:  0011_0010  0x32   50  2  
  18893	:  0010_1101  0x2D   45  -  
  18894	:  0011_0010  0x32   50  2  
  18895	:  0011_0100  0x34   52  4  
  18896	:  0011_0000  0x30   48  0  
  18897	:  1100_0000  0xC0  192    
  18898	:  0000_1100  0x0C   12    
  18899	:  0000_0000  0x00    0    
  18900	:  0000_0001  0x01    1    
  18901	:  0000_0000  0x00    0    
  18902	:  0000_0001  0x01    1    
  18903	:  0000_0000  0x00    0    
  18904	:  0000_0000  0x00    0    
  18905	:  0010_1010  0x2A   42  *  
  18906	:  0011_0000  0x30   48  0  
  18907	:  0000_0000  0x00    0    
  18908	:  0000_0100  0x04    4    
  18909	:  0010_1101  0x2D   45  -  
  18910	:  0100_0011  0x43   67  C  
  18911	:  0011_0100  0x34   52  4  
  18912	:  1111_0000  0xF0  240    
  18913	:  0000_1000  0x08    8    
  18914	:  0100_0001  0x41   65  A  
  18915	:  0010_1101  0x2D   45  -  
  18916	:  0011_0101  0x35   53  5  
  18917	:  0011_0010  0x32   50  2  
  18918	:  0010_1101  0x2D   45  -  
  18919	:  0011_0010  0x32   50  2  
  18920	:  0011_0100  0x34   52  4  
  18921	:  0011_0001  0x31   49  1  
  18922	:  1100_0000  0xC0  192    
  18923	:  0000_1100  0x0C   12    
  18924	:  0000_0000  0x00    0    
  18925	:  0000_0001  0x01    1    
  18926	:  0000_0000  0x00    0    
  18927	:  0000_0001  0x01    1    
  18928	:  0000_0000  0x00    0    
  18929	:  0000_0000  0x00    0    
  18930	:  0010_1010  0x2A   42  *  
  18931	:  0011_0000  0x30   48  0  
  18932	:  0000_0000  0x00    0    
  18933	:  0000_0100  0x04    4    
  18934	:  0010_1101  0x2D   45  -  
  18935	:  0100_0011  0x43   67  C  
  18936	:  0011_0100  0x34   52  4  
  18937	:  1111_0001  0xF1  241    
  18938	:  0000_1000  0x08    8    
  18939	:  0100_0001  0x41   65  A  
  18940	:  0010_1101  0x2D   45  -  
  18941	:  0011_0101  0x35   53  5  
  18942	:  0011_0010  0x32   50  2  
  18943	:  0010_1101  0x2D   45  -  
  18944	:  0011_0010  0x32   50  2  
  18945	:  0011_0100  0x34   52  4  
  18946	:  0011_0010  0x32   50  2  
  18947	:  1100_0000  0xC0  192    
  18948	:  0000_1100  0x0C   12    
  18949	:  0000_0000  0x00    0    
  18950	:  0000_0001  0x01    1    
  18951	:  0000_0000  0x00    0    
  18952	:  0000_0001  0x01    1    
  18953	:  0000_0000  0x00    0    
  18954	:  0000_0000  0x00    0    
  18955	:  0010_1010  0x2A   42  *  
  18956	:  0011_0000  0x30   48  0  
  18957	:  0000_0000  0x00    0    
  18958	:  0000_0100  0x04    4    
  18959	:  0010_1101  0x2D   45  -  
  18960	:  0100_0011  0x43   67  C  
  18961	:  0011_0100  0x34   52  4  
  18962	:  1111_0010  0xF2  242    
  18963	:  0000_1000  0x08    8    
  18964	:  0100_0001  0x41   65  A  
  18965	:  0010_1101  0x2D   45  -  
  18966	:  0011_0101  0x35   53  5  
  18967	:  0011_0010  0x32   50  2  
  18968	:  0010_1101  0x2D   45  -  
  18969	:  0011_0010  0x32   50  2  
  18970	:  0011_0100  0x34   52  4  
  18971	:  0011_0011  0x33   51  3  
  18972	:  1100_0000  0xC0  192    
  18973	:  0000_1100  0x0C   12    
  18974	:  0000_0000  0x00    0    
  18975	:  0000_0001  0x01    1    
  18976	:  0000_0000  0x00    0    
  18977	:  0000_0001  0x01    1    
  18978	:  0000_0000  0x00    0    
  18979	:  0000_0000  0x00    0    
  18980	:  0010_1010  0x2A   42  *  
  18981	:  0011_0000  0x30   48  0  
  18982	:  0000_0000  0x00    0    
  18983	:  0000_0100  0x04    4    
  18984	:  0010_1101  0x2D   45  -  
  18985	:  0100_0011  0x43   67  C  
  18986	:  0011_0100  0x34   52  4  
  18987	:  1111_0011  0xF3  243    
  18988	:  0000_1000  0x08    8    
  18989	:  0100_0001  0x41   65  A  
  18990	:  0010_1101  0x2D   45  -  
  18991	:  0011_0101  0x35   53  5  
  18992	:  0011_0010  0x32   50  2  
  18993	:  0010_1101  0x2D   45  -  
  18994	:  0011_0010  0x32   50  2  
  18995	:  0011_0100  0x34   52  4  
  18996	:  0011_0100  0x34   52  4  
  18997	:  1100_0000  0xC0  192    
  18998	:  0000_1100  0x0C   12    
  18999	:  0000_0000  0x00    0    
  19000	:  0000_0001  0x01    1    
  19001	:  0000_0000  0x00    0    
  19002	:  0000_0001  0x01    1    
  19003	:  0000_0000  0x00    0    
  19004	:  0000_0000  0x00    0    
  19005	:  0010_1010  0x2A   42  *  
  19006	:  0011_0000  0x30   48  0  
  19007	:  0000_0000  0x00    0    
  19008	:  0000_0100  0x04    4    
  19009	:  0010_1101  0x2D   45  -  
  19010	:  0100_0011  0x43   67  C  
  19011	:  0011_0100  0x34   52  4  
  19012	:  1111_0100  0xF4  244    
  19013	:  0000_1000  0x08    8    
  19014	:  0100_0001  0x41   65  A  
  19015	:  0010_1101  0x2D   45  -  
  19016	:  0011_0101  0x35   53  5  
  19017	:  0011_0010  0x32   50  2  
  19018	:  0010_1101  0x2D   45  -  
  19019	:  0011_0010  0x32   50  2  
  19020	:  0011_0100  0x34   52  4  
  19021	:  0011_0101  0x35   53  5  
  19022	:  1100_0000  0xC0  192    
  19023	:  0000_1100  0x0C   12    
  19024	:  0000_0000  0x00    0    
  19025	:  0000_0001  0x01    1    
  19026	:  0000_0000  0x00    0    
  19027	:  0000_0001  0x01    1    
  19028	:  0000_0000  0x00    0    
  19029	:  0000_0000  0x00    0    
  19030	:  0010_1010  0x2A   42  *  
  19031	:  0011_0000  0x30   48  0  
  19032	:  0000_0000  0x00    0    
  19033	:  0000_0100  0x04    4    
  19034	:  0010_1101  0x2D   45  -  
  19035	:  0100_0011  0x43   67  C  
  19036	:  0011_0100  0x34   52  4  
  19037	:  1111_0101  0xF5  245    
  19038	:  0000_1000  0x08    8    
  19039	:  0100_0001  0x41   65  A  
  19040	:  0010_1101  0x2D   45  -  
  19041	:  0011_0101  0x35   53  5  
  19042	:  0011_0010  0x32   50  2  
  19043	:  0010_1101  0x2D   45  -  
  19044	:  0011_0010  0x32   50  2  
  19045	:  0011_0100  0x34   52  4  
  19046	:  0011_0110  0x36   54  6  
  19047	:  1100_0000  0xC0  192    
  19048	:  0000_1100  0x0C   12    
  19049	:  0000_0000  0x00    0    
  19050	:  0000_0001  0x01    1    
  19051	:  0000_0000  0x00    0    
  19052	:  0000_0001  0x01    1    
  19053	:  0000_0000  0x00    0    
  19054	:  0000_0000  0x00    0    
  19055	:  0010_1010  0x2A   42  *  
  19056	:  0011_0000  0x30   48  0  
  19057	:  0000_0000  0x00    0    
  19058	:  0000_0100  0x04    4    
  19059	:  0010_1101  0x2D   45  -  
  19060	:  0100_0011  0x43   67  C  
  19061	:  0011_0100  0x34   52  4  
  19062	:  1111_0110  0xF6  246    
  19063	:  0000_1000  0x08    8    
  19064	:  0100_0001  0x41   65  A  
  19065	:  0010_1101  0x2D   45  -  
  19066	:  0011_0101  0x35   53  5  
  19067	:  0011_0010  0x32   50  2  
  19068	:  0010_1101  0x2D   45  -  
  19069	:  0011_0010  0x32   50  2  
  19070	:  0011_0100  0x34   52  4  
  19071	:  0011_0111  0x37   55  7  
  19072	:  1100_0000  0xC0  192    
  19073	:  0000_1100  0x0C   12    
  19074	:  0000_0000  0x00    0    
  19075	:  0000_0001  0x01    1    
  19076	:  0000_0000  0x00    0    
  19077	:  0000_0001  0x01    1    
  19078	:  0000_0000  0x00    0    
  19079	:  0000_0000  0x00    0    
  19080	:  0010_1010  0x2A   42  *  
  19081	:  0011_0000  0x30   48  0  
  19082	:  0000_0000  0x00    0    
  19083	:  0000_0100  0x04    4    
  19084	:  0010_1101  0x2D   45  -  
  19085	:  0100_0011  0x43   67  C  
  19086	:  0011_0100  0x34   52  4  
  19087	:  1111_0111  0xF7  247    
  19088	:  0000_1000  0x08    8    
  19089	:  0100_0001  0x41   65  A  
  19090	:  0010_1101  0x2D   45  -  
  19091	:  0011_0101  0x35   53  5  
  19092	:  0011_0010  0x32   50  2  
  19093	:  0010_1101  0x2D   45  -  
  19094	:  0011_0010  0x32   50  2  
  19095	:  0011_0100  0x34   52  4  
  19096	:  0011_1000  0x38   56  8  
  19097	:  1100_0000  0xC0  192    
  19098	:  0000_1100  0x0C   12    
  19099	:  0000_0000  0x00    0    
  19100	:  0000_0001  0x01    1    
  19101	:  0000_0000  0x00    0    
  19102	:  0000_0001  0x01    1    
  19103	:  0000_0000  0x00    0    
  19104	:  0000_0000  0x00    0    
  19105	:  0010_1010  0x2A   42  *  
  19106	:  0011_0000  0x30   48  0  
  19107	:  0000_0000  0x00    0    
  19108	:  0000_0100  0x04    4    
  19109	:  0010_1101  0x2D   45  -  
  19110	:  0100_0011  0x43   67  C  
  19111	:  0011_0100  0x34   52  4  
  19112	:  1111_1000  0xF8  248    
  19113	:  0000_1000  0x08    8    
  19114	:  0100_0001  0x41   65  A  
  19115	:  0010_1101  0x2D   45  -  
  19116	:  0011_0101  0x35   53  5  
  19117	:  0011_0010  0x32   50  2  
  19118	:  0010_1101  0x2D   45  -  
  19119	:  0011_0010  0x32   50  2  
  19120	:  0011_0100  0x34   52  4  
  19121	:  0011_1001  0x39   57  9  
  19122	:  1100_0000  0xC0  192    
  19123	:  0000_1100  0x0C   12    
  19124	:  0000_0000  0x00    0    
  19125	:  0000_0001  0x01    1    
  19126	:  0000_0000  0x00    0    
  19127	:  0000_0001  0x01    1    
  19128	:  0000_0000  0x00    0    
  19129	:  0000_0000  0x00    0    
  19130	:  0010_1010  0x2A   42  *  
  19131	:  0011_0000  0x30   48  0  
  19132	:  0000_0000  0x00    0    
  19133	:  0000_0100  0x04    4    
  19134	:  0010_1101  0x2D   45  -  
  19135	:  0100_0011  0x43   67  C  
  19136	:  0011_0100  0x34   52  4  
  19137	:  1111_1001  0xF9  249    
  19138	:  0000_1000  0x08    8    
  19139	:  0100_0001  0x41   65  A  
  19140	:  0010_1101  0x2D   45  -  
  19141	:  0011_0101  0x35   53  5  
  19142	:  0011_0010  0x32   50  2  
  19143	:  0010_1101  0x2D   45  -  
  19144	:  0011_0010  0x32   50  2  
  19145	:  0011_0101  0x35   53  5  
  19146	:  0011_0000  0x30   48  0  
  19147	:  1100_0000  0xC0  192    
  19148	:  0000_1100  0x0C   12    
  19149	:  0000_0000  0x00    0    
  19150	:  0000_0001  0x01    1    
  19151	:  0000_0000  0x00    0    
  19152	:  0000_0001  0x01    1    
  19153	:  0000_0000  0x00    0    
  19154	:  0000_0000  0x00    0    
  19155	:  0010_1010  0x2A   42  *  
  19156	:  0011_0000  0x30   48  0  
  19157	:  0000_0000  0x00    0    
  19158	:  0000_0100  0x04    4    
  19159	:  0010_1101  0x2D   45  -  
  19160	:  0100_0011  0x43   67  C  
  19161	:  0011_0100  0x34   52  4  
  19162	:  1111_1010  0xFA  250    
  19163	:  0000_1000  0x08    8    
  19164	:  0100_0001  0x41   65  A  
  19165	:  0010_1101  0x2D   45  -  
  19166	:  0011_0101  0x35   53  5  
  19167	:  0011_0010  0x32   50  2  
  19168	:  0010_1101  0x2D   45  -  
  19169	:  0011_0010  0x32   50  2  
  19170	:  0011_0101  0x35   53  5  
  19171	:  0011_0001  0x31   49  1  
  19172	:  1100_0000  0xC0  192    
  19173	:  0000_1100  0x0C   12    
  19174	:  0000_0000  0x00    0    
  19175	:  0000_0001  0x01    1    
  19176	:  0000_0000  0x00    0    
  19177	:  0000_0001  0x01    1    
  19178	:  0000_0000  0x00    0    
  19179	:  0000_0000  0x00    0    
  19180	:  0010_1010  0x2A   42  *  
  19181	:  0011_0000  0x30   48  0  
  19182	:  0000_0000  0x00    0    
  19183	:  0000_0100  0x04    4    
  19184	:  0010_1101  0x2D   45  -  
  19185	:  0100_0011  0x43   67  C  
  19186	:  0011_0100  0x34   52  4  
  19187	:  1111_1011  0xFB  251    
  19188	:  0000_1000  0x08    8    
  19189	:  0100_0001  0x41   65  A  
  19190	:  0010_1101  0x2D   45  -  
  19191	:  0011_0101  0x35   53  5  
  19192	:  0011_0010  0x32   50  2  
  19193	:  0010_1101  0x2D   45  -  
  19194	:  0011_0010  0x32   50  2  
  19195	:  0011_0101  0x35   53  5  
  19196	:  0011_0010  0x32   50  2  
  19197	:  1100_0000  0xC0  192    
  19198	:  0000_1100  0x0C   12    
  19199	:  0000_0000  0x00    0    
  19200	:  0000_0001  0x01    1    
  19201	:  0000_0000  0x00    0    
  19202	:  0000_0001  0x01    1    
  19203	:  0000_0000  0x00    0    
  19204	:  0000_0000  0x00    0    
  19205	:  0010_1010  0x2A   42  *  
  19206	:  0011_0000  0x30   48  0  
  19207	:  0000_0000  0x00    0    
  19208	:  0000_0100  0x04    4    
  19209	:  0010_1101  0x2D   45  -  
  19210	:  0100_0011  0x43   67  C  
  19211	:  0011_0100  0x34   52  4  
  19212	:  1111_1100  0xFC  252    
  19213	:  0000_1000  0x08    8    
  19214	:  0100_0001  0x41   65  A  
  19215	:  0010_1101  0x2D   45  -  
  19216	:  0011_0101  0x35   53  5  
  19217	:  0011_0010  0x32   50  2  
  19218	:  0010_1101  0x2D   45  -  
  19219	:  0011_0010  0x32   50  2  
  19220	:  0011_0101  0x35   53  5  
  19221	:  0011_0011  0x33   51  3  
  19222	:  1100_0000  0xC0  192    
  19223	:  0000_1100  0x0C   12    
  19224	:  0000_0000  0x00    0    
  19225	:  0000_0001  0x01    1    
  19226	:  0000_0000  0x00    0    
  19227	:  0000_0001  0x01    1    
  19228	:  0000_0000  0x00    0    
  19229	:  0000_0000  0x00    0    
  19230	:  0010_1010  0x2A   42  *  
  19231	:  0011_0000  0x30   48  0  
  19232	:  0000_0000  0x00    0    
  19233	:  0000_0100  0x04    4    
  19234	:  0010_1101  0x2D   45  -  
  19235	:  0100_0011  0x43   67  C  
  19236	:  0011_0100  0x34   52  4  
  19237	:  1111_1101  0xFD  253    
  19238	:  0000_1000  0x08    8    
  19239	:  0100_0001  0x41   65  A  
  19240	:  0010_1101  0x2D   45  -  
  19241	:  0011_0101  0x35   53  5  
  19242	:  0011_0010  0x32   50  2  
  19243	:  0010_1101  0x2D   45  -  
  19244	:  0011_0010  0x32   50  2  
  19245	:  0011_0101  0x35   53  5  
  19246	:  0011_0100  0x34   52  4  
  19247	:  1100_0000  0xC0  192    
  19248	:  0000_1100  0x0C   12    
  19249	:  0000_0000  0x00    0    
  19250	:  0000_0001  0x01    1    
  19251	:  0000_0000  0x00    0    
  19252	:  0000_0001  0x01    1    
  19253	:  0000_0000  0x00    0    
  19254	:  0000_0000  0x00    0    
  19255	:  0010_1010  0x2A   42  *  
  19256	:  0011_0000  0x30   48  0  
  19257	:  0000_0000  0x00    0    
  19258	:  0000_0100  0x04    4    
  19259	:  0010_1101  0x2D   45  -  
  19260	:  0100_0011  0x43   67  C  
  19261	:  0011_0100  0x34   52  4  
  19262	:  1111_1110  0xFE  254    
  19263	:  0000_1000  0x08    8    
  19264	:  0100_0001  0x41   65  A  
  19265	:  0010_1101  0x2D   45  -  
  19266	:  0011_0101  0x35   53  5  
  19267	:  0011_0011  0x33   51  3  
  19268	:  0010_1101  0x2D   45  -  
  19269	:  0011_0000  0x30   48  0  
  19270	:  0011_0000  0x30   48  0  
  19271	:  0011_0001  0x31   49  1  
  19272	:  1100_0000  0xC0  192    
  19273	:  0000_1100  0x0C   12    
  19274	:  0000_0000  0x00    0    
  19275	:  0000_0001  0x01    1    
  19276	:  0000_0000  0x00    0    
  19277	:  0000_0001  0x01    1    
  19278	:  0000_0000  0x00    0    
  19279	:  0000_0000  0x00    0    
  19280	:  0010_1010  0x2A   42  *  
  19281	:  0011_0000  0x30   48  0  
  19282	:  0000_0000  0x00    0    
  19283	:  0000_0100  0x04    4    
  19284	:  0010_1101  0x2D   45  -  
  19285	:  0100_0011  0x43   67  C  
  19286	:  0011_0101  0x35   53  5  
  19287	:  0000_0001  0x01    1    
  19288	:  0000_1000  0x08    8    
  19289	:  0100_0001  0x41   65  A  
  19290	:  0010_1101  0x2D   45  -  
  19291	:  0011_0101  0x35   53  5  
  19292	:  0011_0011  0x33   51  3  
  19293	:  0010_1101  0x2D   45  -  
  19294	:  0011_0000  0x30   48  0  
  19295	:  0011_0000  0x30   48  0  
  19296	:  0011_0010  0x32   50  2  
  19297	:  1100_0000  0xC0  192    
  19298	:  0000_1100  0x0C   12    
  19299	:  0000_0000  0x00    0    
  19300	:  0000_0001  0x01    1    
  19301	:  0000_0000  0x00    0    
  19302	:  0000_0001  0x01    1    
  19303	:  0000_0000  0x00    0    
  19304	:  0000_0000  0x00    0    
  19305	:  0010_1010  0x2A   42  *  
  19306	:  0011_0000  0x30   48  0  
  19307	:  0000_0000  0x00    0    
  19308	:  0000_0100  0x04    4    
  19309	:  0010_1101  0x2D   45  -  
  19310	:  0100_0011  0x43   67  C  
  19311	:  0011_0101  0x35   53  5  
  19312	:  0000_0010  0x02    2    
  19313	:  0000_1000  0x08    8    
  19314	:  0100_0001  0x41   65  A  
  19315	:  0010_1101  0x2D   45  -  
  19316	:  0011_0101  0x35   53  5  
  19317	:  0011_0011  0x33   51  3  
  19318	:  0010_1101  0x2D   45  -  
  19319	:  0011_0000  0x30   48  0  
  19320	:  0011_0000  0x30   48  0  
  19321	:  0011_0011  0x33   51  3  
  19322	:  1100_0000  0xC0  192    
  19323	:  0000_1100  0x0C   12    
  19324	:  0000_0000  0x00    0    
  19325	:  0000_0001  0x01    1    
  19326	:  0000_0000  0x00    0    
  19327	:  0000_0001  0x01    1    
  19328	:  0000_0000  0x00    0    
  19329	:  0000_0000  0x00    0    
  19330	:  0010_1010  0x2A   42  *  
  19331	:  0011_0000  0x30   48  0  
  19332	:  0000_0000  0x00    0    
  19333	:  0000_0100  0x04    4    
  19334	:  0010_1101  0x2D   45  -  
  19335	:  0100_0011  0x43   67  C  
  19336	:  0011_0101  0x35   53  5  
  19337	:  0000_0011  0x03    3    
  19338	:  0000_1000  0x08    8    
  19339	:  0100_0001  0x41   65  A  
  19340	:  0010_1101  0x2D   45  -  
  19341	:  0011_0101  0x35   53  5  
  19342	:  0011_0011  0x33   51  3  
  19343	:  0010_1101  0x2D   45  -  
  19344	:  0011_0000  0x30   48  0  
  19345	:  0011_0000  0x30   48  0  
  19346	:  0011_0100  0x34   52  4  
  19347	:  1100_0000  0xC0  192    
  19348	:  0000_1100  0x0C   12    
  19349	:  0000_0000  0x00    0    
  19350	:  0000_0001  0x01    1    
  19351	:  0000_0000  0x00    0    
  19352	:  0000_0001  0x01    1    
  19353	:  0000_0000  0x00    0    
  19354	:  0000_0000  0x00    0    
  19355	:  0010_1010  0x2A   42  *  
  19356	:  0011_0000  0x30   48  0  
  19357	:  0000_0000  0x00    0    
  19358	:  0000_0100  0x04    4    
  19359	:  0010_1101  0x2D   45  -  
  19360	:  0100_0011  0x43   67  C  
  19361	:  0011_0101  0x35   53  5  
  19362	:  0000_0100  0x04    4    
  19363	:  0000_1000  0x08    8    
  19364	:  0100_0001  0x41   65  A  
  19365	:  0010_1101  0x2D   45  -  
  19366	:  0011_0101  0x35   53  5  
  19367	:  0011_0011  0x33   51  3  
  19368	:  0010_1101  0x2D   45  -  
  19369	:  0011_0000  0x30   48  0  
  19370	:  0011_0000  0x30   48  0  
  19371	:  0011_0101  0x35   53  5  
  19372	:  1100_0000  0xC0  192    
  19373	:  0000_1100  0x0C   12    
  19374	:  0000_0000  0x00    0    
  19375	:  0000_0001  0x01    1    
  19376	:  0000_0000  0x00    0    
  19377	:  0000_0001  0x01    1    
  19378	:  0000_0000  0x00    0    
  19379	:  0000_0000  0x00    0    
  19380	:  0010_1010  0x2A   42  *  
  19381	:  0011_0000  0x30   48  0  
  19382	:  0000_0000  0x00    0    
  19383	:  0000_0100  0x04    4    
  19384	:  0010_1101  0x2D   45  -  
  19385	:  0100_0011  0x43   67  C  
  19386	:  0011_0101  0x35   53  5  
  19387	:  0000_0101  0x05    5    
  19388	:  0000_1000  0x08    8    
  19389	:  0100_0001  0x41   65  A  
  19390	:  0010_1101  0x2D   45  -  
  19391	:  0011_0101  0x35   53  5  
  19392	:  0011_0011  0x33   51  3  
  19393	:  0010_1101  0x2D   45  -  
  19394	:  0011_0000  0x30   48  0  
  19395	:  0011_0000  0x30   48  0  
  19396	:  0011_0110  0x36   54  6  
  19397	:  1100_0000  0xC0  192    
  19398	:  0000_1100  0x0C   12    
  19399	:  0000_0000  0x00    0    
  19400	:  0000_0001  0x01    1    
  19401	:  0000_0000  0x00    0    
  19402	:  0000_0001  0x01    1    
  19403	:  0000_0000  0x00    0    
  19404	:  0000_0000  0x00    0    
  19405	:  0010_1010  0x2A   42  *  
  19406	:  0011_0000  0x30   48  0  
  19407	:  0000_0000  0x00    0    
  19408	:  0000_0100  0x04    4    
  19409	:  0010_1101  0x2D   45  -  
  19410	:  0100_0011  0x43   67  C  
  19411	:  0011_0101  0x35   53  5  
  19412	:  0000_0110  0x06    6    
  19413	:  0000_1000  0x08    8    
  19414	:  0100_0001  0x41   65  A  
  19415	:  0010_1101  0x2D   45  -  
  19416	:  0011_0101  0x35   53  5  
  19417	:  0011_0011  0x33   51  3  
  19418	:  0010_1101  0x2D   45  -  
  19419	:  0011_0000  0x30   48  0  
  19420	:  0011_0000  0x30   48  0  
  19421	:  0011_0111  0x37   55  7  
  19422	:  1100_0000  0xC0  192    
  19423	:  0000_1100  0x0C   12    
  19424	:  0000_0000  0x00    0    
  19425	:  0000_0001  0x01    1    
  19426	:  0000_0000  0x00    0    
  19427	:  0000_0001  0x01    1    
  19428	:  0000_0000  0x00    0    
  19429	:  0000_0000  0x00    0    
  19430	:  0010_1010  0x2A   42  *  
  19431	:  0011_0000  0x30   48  0  
  19432	:  0000_0000  0x00    0    
  19433	:  0000_0100  0x04    4    
  19434	:  0010_1101  0x2D   45  -  
  19435	:  0100_0011  0x43   67  C  
  19436	:  0011_0101  0x35   53  5  
  19437	:  0000_0111  0x07    7    
  19438	:  0000_1000  0x08    8    
  19439	:  0100_0001  0x41   65  A  
  19440	:  0010_1101  0x2D   45  -  
  19441	:  0011_0101  0x35   53  5  
  19442	:  0011_0011  0x33   51  3  
  19443	:  0010_1101  0x2D   45  -  
  19444	:  0011_0000  0x30   48  0  
  19445	:  0011_0000  0x30   48  0  
  19446	:  0011_1000  0x38   56  8  
  19447	:  1100_0000  0xC0  192    
  19448	:  0000_1100  0x0C   12    
  19449	:  0000_0000  0x00    0    
  19450	:  0000_0001  0x01    1    
  19451	:  0000_0000  0x00    0    
  19452	:  0000_0001  0x01    1    
  19453	:  0000_0000  0x00    0    
  19454	:  0000_0000  0x00    0    
  19455	:  0010_1010  0x2A   42  *  
  19456	:  0011_0000  0x30   48  0  
  19457	:  0000_0000  0x00    0    
  19458	:  0000_0100  0x04    4    
  19459	:  0010_1101  0x2D   45  -  
  19460	:  0100_0011  0x43   67  C  
  19461	:  0011_0101  0x35   53  5  
  19462	:  0000_1000  0x08    8    
  19463	:  0000_1000  0x08    8    
  19464	:  0100_0001  0x41   65  A  
  19465	:  0010_1101  0x2D   45  -  
  19466	:  0011_0101  0x35   53  5  
  19467	:  0011_0011  0x33   51  3  
  19468	:  0010_1101  0x2D   45  -  
  19469	:  0011_0000  0x30   48  0  
  19470	:  0011_0000  0x30   48  0  
  19471	:  0011_1001  0x39   57  9  
  19472	:  1100_0000  0xC0  192    
  19473	:  0000_1100  0x0C   12    
  19474	:  0000_0000  0x00    0    
  19475	:  0000_0001  0x01    1    
  19476	:  0000_0000  0x00    0    
  19477	:  0000_0001  0x01    1    
  19478	:  0000_0000  0x00    0    
  19479	:  0000_0000  0x00    0    
  19480	:  0010_1010  0x2A   42  *  
  19481	:  0011_0000  0x30   48  0  
  19482	:  0000_0000  0x00    0    
  19483	:  0000_0100  0x04    4    
  19484	:  0010_1101  0x2D   45  -  
  19485	:  0100_0011  0x43   67  C  
  19486	:  0011_0101  0x35   53  5  
  19487	:  0000_1001  0x09    9    
  19488	:  0000_1000  0x08    8    
  19489	:  0100_0001  0x41   65  A  
  19490	:  0010_1101  0x2D   45  -  
  19491	:  0011_0101  0x35   53  5  
  19492	:  0011_0011  0x33   51  3  
  19493	:  0010_1101  0x2D   45  -  
  19494	:  0011_0000  0x30   48  0  
  19495	:  0011_0001  0x31   49  1  
  19496	:  0011_0000  0x30   48  0  
  19497	:  1100_0000  0xC0  192    
  19498	:  0000_1100  0x0C   12    
  19499	:  0000_0000  0x00    0    
  19500	:  0000_0001  0x01    1    
  19501	:  0000_0000  0x00    0    
  19502	:  0000_0001  0x01    1    
  19503	:  0000_0000  0x00    0    
  19504	:  0000_0000  0x00    0    
  19505	:  0010_1010  0x2A   42  *  
  19506	:  0011_0000  0x30   48  0  
  19507	:  0000_0000  0x00    0    
  19508	:  0000_0100  0x04    4    
  19509	:  0010_1101  0x2D   45  -  
  19510	:  0100_0011  0x43   67  C  
  19511	:  0011_0101  0x35   53  5  
  19512	:  0000_1010  0x0A   10    
  19513	:  0000_1000  0x08    8    
  19514	:  0100_0001  0x41   65  A  
  19515	:  0010_1101  0x2D   45  -  
  19516	:  0011_0101  0x35   53  5  
  19517	:  0011_0011  0x33   51  3  
  19518	:  0010_1101  0x2D   45  -  
  19519	:  0011_0000  0x30   48  0  
  19520	:  0011_0001  0x31   49  1  
  19521	:  0011_0001  0x31   49  1  
  19522	:  1100_0000  0xC0  192    
  19523	:  0000_1100  0x0C   12    
  19524	:  0000_0000  0x00    0    
  19525	:  0000_0001  0x01    1    
  19526	:  0000_0000  0x00    0    
  19527	:  0000_0001  0x01    1    
  19528	:  0000_0000  0x00    0    
  19529	:  0000_0000  0x00    0    
  19530	:  0010_1010  0x2A   42  *  
  19531	:  0011_0000  0x30   48  0  
  19532	:  0000_0000  0x00    0    
  19533	:  0000_0100  0x04    4    
  19534	:  0010_1101  0x2D   45  -  
  19535	:  0100_0011  0x43   67  C  
  19536	:  0011_0101  0x35   53  5  
  19537	:  0000_1011  0x0B   11    
  19538	:  0000_1000  0x08    8    
  19539	:  0100_0001  0x41   65  A  
  19540	:  0010_1101  0x2D   45  -  
  19541	:  0011_0101  0x35   53  5  
  19542	:  0011_0011  0x33   51  3  
  19543	:  0010_1101  0x2D   45  -  
  19544	:  0011_0000  0x30   48  0  
  19545	:  0011_0001  0x31   49  1  
  19546	:  0011_0010  0x32   50  2  
  19547	:  1100_0000  0xC0  192    
  19548	:  0000_1100  0x0C   12    
  19549	:  0000_0000  0x00    0    
  19550	:  0000_0001  0x01    1    
  19551	:  0000_0000  0x00    0    
  19552	:  0000_0001  0x01    1    
  19553	:  0000_0000  0x00    0    
  19554	:  0000_0000  0x00    0    
  19555	:  0010_1010  0x2A   42  *  
  19556	:  0011_0000  0x30   48  0  
  19557	:  0000_0000  0x00    0    
  19558	:  0000_0100  0x04    4    
  19559	:  0010_1101  0x2D   45  -  
  19560	:  0100_0011  0x43   67  C  
  19561	:  0011_0101  0x35   53  5  
  19562	:  0000_1100  0x0C   12    
  19563	:  0000_1000  0x08    8    
  19564	:  0100_0001  0x41   65  A  
  19565	:  0010_1101  0x2D   45  -  
  19566	:  0011_0101  0x35   53  5  
  19567	:  0011_0011  0x33   51  3  
  19568	:  0010_1101  0x2D   45  -  
  19569	:  0011_0000  0x30   48  0  
  19570	:  0011_0001  0x31   49  1  
  19571	:  0011_0011  0x33   51  3  
  19572	:  1100_0000  0xC0  192    
  19573	:  0000_1100  0x0C   12    
  19574	:  0000_0000  0x00    0    
  19575	:  0000_0001  0x01    1    
  19576	:  0000_0000  0x00    0    
  19577	:  0000_0001  0x01    1    
  19578	:  0000_0000  0x00    0    
  19579	:  0000_0000  0x00    0    
  19580	:  0010_1010  0x2A   42  *  
  19581	:  0011_0000  0x30   48  0  
  19582	:  0000_0000  0x00    0    
  19583	:  0000_0100  0x04    4    
  19584	:  0010_1101  0x2D   45  -  
  19585	:  0100_0011  0x43   67  C  
  19586	:  0011_0101  0x35   53  5  
  19587	:  0000_1101  0x0D   13    
  19588	:  0000_1000  0x08    8    
  19589	:  0100_0001  0x41   65  A  
  19590	:  0010_1101  0x2D   45  -  
  19591	:  0011_0101  0x35   53  5  
  19592	:  0011_0011  0x33   51  3  
  19593	:  0010_1101  0x2D   45  -  
  19594	:  0011_0000  0x30   48  0  
  19595	:  0011_0001  0x31   49  1  
  19596	:  0011_0100  0x34   52  4  
  19597	:  1100_0000  0xC0  192    
  19598	:  0000_1100  0x0C   12    
  19599	:  0000_0000  0x00    0    
  19600	:  0000_0001  0x01    1    
  19601	:  0000_0000  0x00    0    
  19602	:  0000_0001  0x01    1    
  19603	:  0000_0000  0x00    0    
  19604	:  0000_0000  0x00    0    
  19605	:  0010_1010  0x2A   42  *  
  19606	:  0011_0000  0x30   48  0  
  19607	:  0000_0000  0x00    0    
  19608	:  0000_0100  0x04    4    
  19609	:  0010_1101  0x2D   45  -  
  19610	:  0100_0011  0x43   67  C  
  19611	:  0011_0101  0x35   53  5  
  19612	:  0000_1110  0x0E   14    
  19613	:  0000_1000  0x08    8    
  19614	:  0100_0001  0x41   65  A  
  19615	:  0010_1101  0x2D   45  -  
  19616	:  0011_0101  0x35   53  5  
  19617	:  0011_0011  0x33   51  3  
  19618	:  0010_1101  0x2D   45  -  
  19619	:  0011_0000  0x30   48  0  
  19620	:  0011_0001  0x31   49  1  
  19621	:  0011_0101  0x35   53  5  
  19622	:  1100_0000  0xC0  192    
  19623	:  0000_1100  0x0C   12    
  19624	:  0000_0000  0x00    0    
  19625	:  0000_0001  0x01    1    
  19626	:  0000_0000  0x00    0    
  19627	:  0000_0001  0x01    1    
  19628	:  0000_0000  0x00    0    
  19629	:  0000_0000  0x00    0    
  19630	:  0010_1010  0x2A   42  *  
  19631	:  0011_0000  0x30   48  0  
  19632	:  0000_0000  0x00    0    
  19633	:  0000_0100  0x04    4    
  19634	:  0010_1101  0x2D   45  -  
  19635	:  0100_0011  0x43   67  C  
  19636	:  0011_0101  0x35   53  5  
  19637	:  0000_1111  0x0F   15    
  19638	:  0000_1000  0x08    8    
  19639	:  0100_0001  0x41   65  A  
  19640	:  0010_1101  0x2D   45  -  
  19641	:  0011_0101  0x35   53  5  
  19642	:  0011_0011  0x33   51  3  
  19643	:  0010_1101  0x2D   45  -  
  19644	:  0011_0000  0x30   48  0  
  19645	:  0011_0001  0x31   49  1  
  19646	:  0011_0110  0x36   54  6  
  19647	:  1100_0000  0xC0  192    
  19648	:  0000_1100  0x0C   12    
  19649	:  0000_0000  0x00    0    
  19650	:  0000_0001  0x01    1    
  19651	:  0000_0000  0x00    0    
  19652	:  0000_0001  0x01    1    
  19653	:  0000_0000  0x00    0    
  19654	:  0000_0000  0x00    0    
  19655	:  0010_1010  0x2A   42  *  
  19656	:  0011_0000  0x30   48  0  
  19657	:  0000_0000  0x00    0    
  19658	:  0000_0100  0x04    4    
  19659	:  0010_1101  0x2D   45  -  
  19660	:  0100_0011  0x43   67  C  
  19661	:  0011_0101  0x35   53  5  
  19662	:  0001_0000  0x10   16    
  19663	:  0000_1000  0x08    8    
  19664	:  0100_0001  0x41   65  A  
  19665	:  0010_1101  0x2D   45  -  
  19666	:  0011_0101  0x35   53  5  
  19667	:  0011_0011  0x33   51  3  
  19668	:  0010_1101  0x2D   45  -  
  19669	:  0011_0000  0x30   48  0  
  19670	:  0011_0001  0x31   49  1  
  19671	:  0011_0111  0x37   55  7  
  19672	:  1100_0000  0xC0  192    
  19673	:  0000_1100  0x0C   12    
  19674	:  0000_0000  0x00    0    
  19675	:  0000_0001  0x01    1    
  19676	:  0000_0000  0x00    0    
  19677	:  0000_0001  0x01    1    
  19678	:  0000_0000  0x00    0    
  19679	:  0000_0000  0x00    0    
  19680	:  0010_1010  0x2A   42  *  
  19681	:  0011_0000  0x30   48  0  
  19682	:  0000_0000  0x00    0    
  19683	:  0000_0100  0x04    4    
  19684	:  0010_1101  0x2D   45  -  
  19685	:  0100_0011  0x43   67  C  
  19686	:  0011_0101  0x35   53  5  
  19687	:  0001_0001  0x11   17    
  19688	:  0000_1000  0x08    8    
  19689	:  0100_0001  0x41   65  A  
  19690	:  0010_1101  0x2D   45  -  
  19691	:  0011_0101  0x35   53  5  
  19692	:  0011_0011  0x33   51  3  
  19693	:  0010_1101  0x2D   45  -  
  19694	:  0011_0000  0x30   48  0  
  19695	:  0011_0001  0x31   49  1  
  19696	:  0011_1000  0x38   56  8  
  19697	:  1100_0000  0xC0  192    
  19698	:  0000_1100  0x0C   12    
  19699	:  0000_0000  0x00    0    
  19700	:  0000_0001  0x01    1    
  19701	:  0000_0000  0x00    0    
  19702	:  0000_0001  0x01    1    
  19703	:  0000_0000  0x00    0    
  19704	:  0000_0000  0x00    0    
  19705	:  0010_1010  0x2A   42  *  
  19706	:  0011_0000  0x30   48  0  
  19707	:  0000_0000  0x00    0    
  19708	:  0000_0100  0x04    4    
  19709	:  0010_1101  0x2D   45  -  
  19710	:  0100_0011  0x43   67  C  
  19711	:  0011_0101  0x35   53  5  
  19712	:  0001_0010  0x12   18    
  19713	:  0000_1000  0x08    8    
  19714	:  0100_0001  0x41   65  A  
  19715	:  0010_1101  0x2D   45  -  
  19716	:  0011_0101  0x35   53  5  
  19717	:  0011_0011  0x33   51  3  
  19718	:  0010_1101  0x2D   45  -  
  19719	:  0011_0000  0x30   48  0  
  19720	:  0011_0001  0x31   49  1  
  19721	:  0011_1001  0x39   57  9  
  19722	:  1100_0000  0xC0  192    
  19723	:  0000_1100  0x0C   12    
  19724	:  0000_0000  0x00    0    
  19725	:  0000_0001  0x01    1    
  19726	:  0000_0000  0x00    0    
  19727	:  0000_0001  0x01    1    
  19728	:  0000_0000  0x00    0    
  19729	:  0000_0000  0x00    0    
  19730	:  0010_1010  0x2A   42  *  
  19731	:  0011_0000  0x30   48  0  
  19732	:  0000_0000  0x00    0    
  19733	:  0000_0100  0x04    4    
  19734	:  0010_1101  0x2D   45  -  
  19735	:  0100_0011  0x43   67  C  
  19736	:  0011_0101  0x35   53  5  
  19737	:  0001_0011  0x13   19    
  19738	:  0000_1000  0x08    8    
  19739	:  0100_0001  0x41   65  A  
  19740	:  0010_1101  0x2D   45  -  
  19741	:  0011_0101  0x35   53  5  
  19742	:  0011_0011  0x33   51  3  
  19743	:  0010_1101  0x2D   45  -  
  19744	:  0011_0000  0x30   48  0  
  19745	:  0011_0010  0x32   50  2  
  19746	:  0011_0000  0x30   48  0  
  19747	:  1100_0000  0xC0  192    
  19748	:  0000_1100  0x0C   12    
  19749	:  0000_0000  0x00    0    
  19750	:  0000_0001  0x01    1    
  19751	:  0000_0000  0x00    0    
  19752	:  0000_0001  0x01    1    
  19753	:  0000_0000  0x00    0    
  19754	:  0000_0000  0x00    0    
  19755	:  0010_1010  0x2A   42  *  
  19756	:  0011_0000  0x30   48  0  
  19757	:  0000_0000  0x00    0    
  19758	:  0000_0100  0x04    4    
  19759	:  0010_1101  0x2D   45  -  
  19760	:  0100_0011  0x43   67  C  
  19761	:  0011_0101  0x35   53  5  
  19762	:  0001_0100  0x14   20    
  19763	:  0000_1000  0x08    8    
  19764	:  0100_0001  0x41   65  A  
  19765	:  0010_1101  0x2D   45  -  
  19766	:  0011_0101  0x35   53  5  
  19767	:  0011_0011  0x33   51  3  
  19768	:  0010_1101  0x2D   45  -  
  19769	:  0011_0000  0x30   48  0  
  19770	:  0011_0010  0x32   50  2  
  19771	:  0011_0001  0x31   49  1  
  19772	:  1100_0000  0xC0  192    
  19773	:  0000_1100  0x0C   12    
  19774	:  0000_0000  0x00    0    
  19775	:  0000_0001  0x01    1    
  19776	:  0000_0000  0x00    0    
  19777	:  0000_0001  0x01    1    
  19778	:  0000_0000  0x00    0    
  19779	:  0000_0000  0x00    0    
  19780	:  0010_1010  0x2A   42  *  
  19781	:  0011_0000  0x30   48  0  
  19782	:  0000_0000  0x00    0    
  19783	:  0000_0100  0x04    4    
  19784	:  0010_1101  0x2D   45  -  
  19785	:  0100_0011  0x43   67  C  
  19786	:  0011_0101  0x35   53  5  
  19787	:  0001_0101  0x15   21    
  19788	:  0000_1000  0x08    8    
  19789	:  0100_0001  0x41   65  A  
  19790	:  0010_1101  0x2D   45  -  
  19791	:  0011_0101  0x35   53  5  
  19792	:  0011_0011  0x33   51  3  
  19793	:  0010_1101  0x2D   45  -  
  19794	:  0011_0000  0x30   48  0  
  19795	:  0011_0010  0x32   50  2  
  19796	:  0011_0010  0x32   50  2  
  19797	:  1100_0000  0xC0  192    
  19798	:  0000_1100  0x0C   12    
  19799	:  0000_0000  0x00    0    
  19800	:  0000_0001  0x01    1    
  19801	:  0000_0000  0x00    0    
  19802	:  0000_0001  0x01    1    
  19803	:  0000_0000  0x00    0    
  19804	:  0000_0000  0x00    0    
  19805	:  0010_1010  0x2A   42  *  
  19806	:  0011_0000  0x30   48  0  
  19807	:  0000_0000  0x00    0    
  19808	:  0000_0100  0x04    4    
  19809	:  0010_1101  0x2D   45  -  
  19810	:  0100_0011  0x43   67  C  
  19811	:  0011_0101  0x35   53  5  
  19812	:  0001_0110  0x16   22    
  19813	:  0000_1000  0x08    8    
  19814	:  0100_0001  0x41   65  A  
  19815	:  0010_1101  0x2D   45  -  
  19816	:  0011_0101  0x35   53  5  
  19817	:  0011_0011  0x33   51  3  
  19818	:  0010_1101  0x2D   45  -  
  19819	:  0011_0000  0x30   48  0  
  19820	:  0011_0010  0x32   50  2  
  19821	:  0011_0011  0x33   51  3  
  19822	:  1100_0000  0xC0  192    
  19823	:  0000_1100  0x0C   12    
  19824	:  0000_0000  0x00    0    
  19825	:  0000_0001  0x01    1    
  19826	:  0000_0000  0x00    0    
  19827	:  0000_0001  0x01    1    
  19828	:  0000_0000  0x00    0    
  19829	:  0000_0000  0x00    0    
  19830	:  0010_1010  0x2A   42  *  
  19831	:  0011_0000  0x30   48  0  
  19832	:  0000_0000  0x00    0    
  19833	:  0000_0100  0x04    4    
  19834	:  0010_1101  0x2D   45  -  
  19835	:  0100_0011  0x43   67  C  
  19836	:  0011_0101  0x35   53  5  
  19837	:  0001_0111  0x17   23    
  19838	:  0000_1000  0x08    8    
  19839	:  0100_0001  0x41   65  A  
  19840	:  0010_1101  0x2D   45  -  
  19841	:  0011_0101  0x35   53  5  
  19842	:  0011_0011  0x33   51  3  
  19843	:  0010_1101  0x2D   45  -  
  19844	:  0011_0000  0x30   48  0  
  19845	:  0011_0010  0x32   50  2  
  19846	:  0011_0100  0x34   52  4  
  19847	:  1100_0000  0xC0  192    
  19848	:  0000_1100  0x0C   12    
  19849	:  0000_0000  0x00    0    
  19850	:  0000_0001  0x01    1    
  19851	:  0000_0000  0x00    0    
  19852	:  0000_0001  0x01    1    
  19853	:  0000_0000  0x00    0    
  19854	:  0000_0000  0x00    0    
  19855	:  0010_1010  0x2A   42  *  
  19856	:  0011_0000  0x30   48  0  
  19857	:  0000_0000  0x00    0    
  19858	:  0000_0100  0x04    4    
  19859	:  0010_1101  0x2D   45  -  
  19860	:  0100_0011  0x43   67  C  
  19861	:  0011_0101  0x35   53  5  
  19862	:  0001_1000  0x18   24    
  19863	:  0000_1000  0x08    8    
  19864	:  0100_0001  0x41   65  A  
  19865	:  0010_1101  0x2D   45  -  
  19866	:  0011_0101  0x35   53  5  
  19867	:  0011_0011  0x33   51  3  
  19868	:  0010_1101  0x2D   45  -  
  19869	:  0011_0000  0x30   48  0  
  19870	:  0011_0010  0x32   50  2  
  19871	:  0011_0101  0x35   53  5  
  19872	:  1100_0000  0xC0  192    
  19873	:  0000_1100  0x0C   12    
  19874	:  0000_0000  0x00    0    
  19875	:  0000_0001  0x01    1    
  19876	:  0000_0000  0x00    0    
  19877	:  0000_0001  0x01    1    
  19878	:  0000_0000  0x00    0    
  19879	:  0000_0000  0x00    0    
  19880	:  0010_1010  0x2A   42  *  
  19881	:  0011_0000  0x30   48  0  
  19882	:  0000_0000  0x00    0    
  19883	:  0000_0100  0x04    4    
  19884	:  0010_1101  0x2D   45  -  
  19885	:  0100_0011  0x43   67  C  
  19886	:  0011_0101  0x35   53  5  
  19887	:  0001_1001  0x19   25    
  19888	:  0000_1000  0x08    8    
  19889	:  0100_0001  0x41   65  A  
  19890	:  0010_1101  0x2D   45  -  
  19891	:  0011_0101  0x35   53  5  
  19892	:  0011_0011  0x33   51  3  
  19893	:  0010_1101  0x2D   45  -  
  19894	:  0011_0000  0x30   48  0  
  19895	:  0011_0010  0x32   50  2  
  19896	:  0011_0110  0x36   54  6  
  19897	:  1100_0000  0xC0  192    
  19898	:  0000_1100  0x0C   12    
  19899	:  0000_0000  0x00    0    
  19900	:  0000_0001  0x01    1    
  19901	:  0000_0000  0x00    0    
  19902	:  0000_0001  0x01    1    
  19903	:  0000_0000  0x00    0    
  19904	:  0000_0000  0x00    0    
  19905	:  0010_1010  0x2A   42  *  
  19906	:  0011_0000  0x30   48  0  
  19907	:  0000_0000  0x00    0    
  19908	:  0000_0100  0x04    4    
  19909	:  0010_1101  0x2D   45  -  
  19910	:  0100_0011  0x43   67  C  
  19911	:  0011_0101  0x35   53  5  
  19912	:  0001_1010  0x1A   26    
  19913	:  0000_1000  0x08    8    
  19914	:  0100_0001  0x41   65  A  
  19915	:  0010_1101  0x2D   45  -  
  19916	:  0011_0101  0x35   53  5  
  19917	:  0011_0011  0x33   51  3  
  19918	:  0010_1101  0x2D   45  -  
  19919	:  0011_0000  0x30   48  0  
  19920	:  0011_0010  0x32   50  2  
  19921	:  0011_0111  0x37   55  7  
  19922	:  1100_0000  0xC0  192    
  19923	:  0000_1100  0x0C   12    
  19924	:  0000_0000  0x00    0    
  19925	:  0000_0001  0x01    1    
  19926	:  0000_0000  0x00    0    
  19927	:  0000_0001  0x01    1    
  19928	:  0000_0000  0x00    0    
  19929	:  0000_0000  0x00    0    
  19930	:  0010_1010  0x2A   42  *  
  19931	:  0011_0000  0x30   48  0  
  19932	:  0000_0000  0x00    0    
  19933	:  0000_0100  0x04    4    
  19934	:  0010_1101  0x2D   45  -  
  19935	:  0100_0011  0x43   67  C  
  19936	:  0011_0101  0x35   53  5  
  19937	:  0001_1011  0x1B   27    
  19938	:  0000_1000  0x08    8    
  19939	:  0100_0001  0x41   65  A  
  19940	:  0010_1101  0x2D   45  -  
  19941	:  0011_0101  0x35   53  5  
  19942	:  0011_0011  0x33   51  3  
  19943	:  0010_1101  0x2D   45  -  
  19944	:  0011_0000  0x30   48  0  
  19945	:  0011_0010  0x32   50  2  
  19946	:  0011_1000  0x38   56  8  
  19947	:  1100_0000  0xC0  192    
  19948	:  0000_1100  0x0C   12    
  19949	:  0000_0000  0x00    0    
  19950	:  0000_0001  0x01    1    
  19951	:  0000_0000  0x00    0    
  19952	:  0000_0001  0x01    1    
  19953	:  0000_0000  0x00    0    
  19954	:  0000_0000  0x00    0    
  19955	:  0010_1010  0x2A   42  *  
  19956	:  0011_0000  0x30   48  0  
  19957	:  0000_0000  0x00    0    
  19958	:  0000_0100  0x04    4    
  19959	:  0010_1101  0x2D   45  -  
  19960	:  0100_0011  0x43   67  C  
  19961	:  0011_0101  0x35   53  5  
  19962	:  0001_1100  0x1C   28    
  19963	:  0000_1000  0x08    8    
  19964	:  0100_0001  0x41   65  A  
  19965	:  0010_1101  0x2D   45  -  
  19966	:  0011_0101  0x35   53  5  
  19967	:  0011_0011  0x33   51  3  
  19968	:  0010_1101  0x2D   45  -  
  19969	:  0011_0000  0x30   48  0  
  19970	:  0011_0010  0x32   50  2  
  19971	:  0011_1001  0x39   57  9  
  19972	:  1100_0000  0xC0  192    
  19973	:  0000_1100  0x0C   12    
  19974	:  0000_0000  0x00    0    
  19975	:  0000_0001  0x01    1    
  19976	:  0000_0000  0x00    0    
  19977	:  0000_0001  0x01    1    
  19978	:  0000_0000  0x00    0    
  19979	:  0000_0000  0x00    0    
  19980	:  0010_1010  0x2A   42  *  
  19981	:  0011_0000  0x30   48  0  
  19982	:  0000_0000  0x00    0    
  19983	:  0000_0100  0x04    4    
  19984	:  0010_1101  0x2D   45  -  
  19985	:  0100_0011  0x43   67  C  
  19986	:  0011_0101  0x35   53  5  
  19987	:  0001_1101  0x1D   29    
  19988	:  0000_1000  0x08    8    
  19989	:  0100_0001  0x41   65  A  
  19990	:  0010_1101  0x2D   45  -  
  19991	:  0011_0101  0x35   53  5  
  19992	:  0011_0011  0x33   51  3  
  19993	:  0010_1101  0x2D   45  -  
  19994	:  0011_0000  0x30   48  0  
  19995	:  0011_0011  0x33   51  3  
  19996	:  0011_0000  0x30   48  0  
  19997	:  1100_0000  0xC0  192    
  19998	:  0000_1100  0x0C   12    
  19999	:  0000_0000  0x00    0    
  20000	:  0000_0001  0x01    1    
  20001	:  0000_0000  0x00    0    
  20002	:  0000_0001  0x01    1    
  20003	:  0000_0000  0x00    0    
  20004	:  0000_0000  0x00    0    
  20005	:  0010_1010  0x2A   42  *  
  20006	:  0011_0000  0x30   48  0  
  20007	:  0000_0000  0x00    0    
  20008	:  0000_0100  0x04    4    
  20009	:  0010_1101  0x2D   45  -  
  20010	:  0100_0011  0x43   67  C  
  20011	:  0011_0101  0x35   53  5  
  20012	:  0001_1110  0x1E   30    
  20013	:  0000_1000  0x08    8    
  20014	:  0100_0001  0x41   65  A  
  20015	:  0010_1101  0x2D   45  -  
  20016	:  0011_0101  0x35   53  5  
  20017	:  0011_0011  0x33   51  3  
  20018	:  0010_1101  0x2D   45  -  
  20019	:  0011_0000  0x30   48  0  
  20020	:  0011_0011  0x33   51  3  
  20021	:  0011_0001  0x31   49  1  
  20022	:  1100_0000  0xC0  192    
  20023	:  0000_1100  0x0C   12    
  20024	:  0000_0000  0x00    0    
  20025	:  0000_0001  0x01    1    
  20026	:  0000_0000  0x00    0    
  20027	:  0000_0001  0x01    1    
  20028	:  0000_0000  0x00    0    
  20029	:  0000_0000  0x00    0    
  20030	:  0010_1010  0x2A   42  *  
  20031	:  0011_0000  0x30   48  0  
  20032	:  0000_0000  0x00    0    
  20033	:  0000_0100  0x04    4    
  20034	:  0010_1101  0x2D   45  -  
  20035	:  0100_0011  0x43   67  C  
  20036	:  0011_0101  0x35   53  5  
  20037	:  0001_1111  0x1F   31    
  20038	:  0000_1000  0x08    8    
  20039	:  0100_0001  0x41   65  A  
  20040	:  0010_1101  0x2D   45  -  
  20041	:  0011_0101  0x35   53  5  
  20042	:  0011_0011  0x33   51  3  
  20043	:  0010_1101  0x2D   45  -  
  20044	:  0011_0000  0x30   48  0  
  20045	:  0011_0011  0x33   51  3  
  20046	:  0011_0010  0x32   50  2  
  20047	:  1100_0000  0xC0  192    
  20048	:  0000_1100  0x0C   12    
  20049	:  0000_0000  0x00    0    
  20050	:  0000_0001  0x01    1    
  20051	:  0000_0000  0x00    0    
  20052	:  0000_0001  0x01    1    
  20053	:  0000_0000  0x00    0    
  20054	:  0000_0000  0x00    0    
  20055	:  0010_1010  0x2A   42  *  
  20056	:  0011_0000  0x30   48  0  
  20057	:  0000_0000  0x00    0    
  20058	:  0000_0100  0x04    4    
  20059	:  0010_1101  0x2D   45  -  
  20060	:  0100_0011  0x43   67  C  
  20061	:  0011_0101  0x35   53  5  
  20062	:  0010_0000  0x20   32     
  20063	:  0000_1000  0x08    8    
  20064	:  0100_0001  0x41   65  A  
  20065	:  0010_1101  0x2D   45  -  
  20066	:  0011_0101  0x35   53  5  
  20067	:  0011_0011  0x33   51  3  
  20068	:  0010_1101  0x2D   45  -  
  20069	:  0011_0000  0x30   48  0  
  20070	:  0011_0011  0x33   51  3  
  20071	:  0011_0011  0x33   51  3  
  20072	:  1100_0000  0xC0  192    
  20073	:  0000_1100  0x0C   12    
  20074	:  0000_0000  0x00    0    
  20075	:  0000_0001  0x01    1    
  20076	:  0000_0000  0x00    0    
  20077	:  0000_0001  0x01    1    
  20078	:  0000_0000  0x00    0    
  20079	:  0000_0000  0x00    0    
  20080	:  0010_1010  0x2A   42  *  
  20081	:  0011_0000  0x30   48  0  
  20082	:  0000_0000  0x00    0    
  20083	:  0000_0100  0x04    4    
  20084	:  0010_1101  0x2D   45  -  
  20085	:  0100_0011  0x43   67  C  
  20086	:  0011_0101  0x35   53  5  
  20087	:  0010_0001  0x21   33  !  
  20088	:  0000_1000  0x08    8    
  20089	:  0100_0001  0x41   65  A  
  20090	:  0010_1101  0x2D   45  -  
  20091	:  0011_0101  0x35   53  5  
  20092	:  0011_0011  0x33   51  3  
  20093	:  0010_1101  0x2D   45  -  
  20094	:  0011_0000  0x30   48  0  
  20095	:  0011_0011  0x33   51  3  
  20096	:  0011_0100  0x34   52  4  
  20097	:  1100_0000  0xC0  192    
  20098	:  0000_1100  0x0C   12    
  20099	:  0000_0000  0x00    0    
  20100	:  0000_0001  0x01    1    
  20101	:  0000_0000  0x00    0    
  20102	:  0000_0001  0x01    1    
  20103	:  0000_0000  0x00    0    
  20104	:  0000_0000  0x00    0    
  20105	:  0010_1010  0x2A   42  *  
  20106	:  0011_0000  0x30   48  0  
  20107	:  0000_0000  0x00    0    
  20108	:  0000_0100  0x04    4    
  20109	:  0010_1101  0x2D   45  -  
  20110	:  0100_0011  0x43   67  C  
  20111	:  0011_0101  0x35   53  5  
  20112	:  0010_0010  0x22   34  "  
  20113	:  0000_1000  0x08    8    
  20114	:  0100_0001  0x41   65  A  
  20115	:  0010_1101  0x2D   45  -  
  20116	:  0011_0101  0x35   53  5  
  20117	:  0011_0011  0x33   51  3  
  20118	:  0010_1101  0x2D   45  -  
  20119	:  0011_0000  0x30   48  0  
  20120	:  0011_0011  0x33   51  3  
  20121	:  0011_0101  0x35   53  5  
  20122	:  1100_0000  0xC0  192    
  20123	:  0000_1100  0x0C   12    
  20124	:  0000_0000  0x00    0    
  20125	:  0000_0001  0x01    1    
  20126	:  0000_0000  0x00    0    
  20127	:  0000_0001  0x01    1    
  20128	:  0000_0000  0x00    0    
  20129	:  0000_0000  0x00    0    
  20130	:  0010_1010  0x2A   42  *  
  20131	:  0011_0000  0x30   48  0  
  20132	:  0000_0000  0x00    0    
  20133	:  0000_0100  0x04    4    
  20134	:  0010_1101  0x2D   45  -  
  20135	:  0100_0011  0x43   67  C  
  20136	:  0011_0101  0x35   53  5  
  20137	:  0010_0011  0x23   35  #  
  20138	:  0000_1000  0x08    8    
  20139	:  0100_0001  0x41   65  A  
  20140	:  0010_1101  0x2D   45  -  
  20141	:  0011_0101  0x35   53  5  
  20142	:  0011_0011  0x33   51  3  
  20143	:  0010_1101  0x2D   45  -  
  20144	:  0011_0000  0x30   48  0  
  20145	:  0011_0011  0x33   51  3  
  20146	:  0011_0110  0x36   54  6  
  20147	:  1100_0000  0xC0  192    
  20148	:  0000_1100  0x0C   12    
  20149	:  0000_0000  0x00    0    
  20150	:  0000_0001  0x01    1    
  20151	:  0000_0000  0x00    0    
  20152	:  0000_0001  0x01    1    
  20153	:  0000_0000  0x00    0    
  20154	:  0000_0000  0x00    0    
  20155	:  0010_1010  0x2A   42  *  
  20156	:  0011_0000  0x30   48  0  
  20157	:  0000_0000  0x00    0    
  20158	:  0000_0100  0x04    4    
  20159	:  0010_1101  0x2D   45  -  
  20160	:  0100_0011  0x43   67  C  
  20161	:  0011_0101  0x35   53  5  
  20162	:  0010_0100  0x24   36  $  
  20163	:  0000_1000  0x08    8    
  20164	:  0100_0001  0x41   65  A  
  20165	:  0010_1101  0x2D   45  -  
  20166	:  0011_0101  0x35   53  5  
  20167	:  0011_0011  0x33   51  3  
  20168	:  0010_1101  0x2D   45  -  
  20169	:  0011_0000  0x30   48  0  
  20170	:  0011_0011  0x33   51  3  
  20171	:  0011_0111  0x37   55  7  
  20172	:  1100_0000  0xC0  192    
  20173	:  0000_1100  0x0C   12    
  20174	:  0000_0000  0x00    0    
  20175	:  0000_0001  0x01    1    
  20176	:  0000_0000  0x00    0    
  20177	:  0000_0001  0x01    1    
  20178	:  0000_0000  0x00    0    
  20179	:  0000_0000  0x00    0    
  20180	:  0010_1010  0x2A   42  *  
  20181	:  0011_0000  0x30   48  0  
  20182	:  0000_0000  0x00    0    
  20183	:  0000_0100  0x04    4    
  20184	:  0010_1101  0x2D   45  -  
  20185	:  0100_0011  0x43   67  C  
  20186	:  0011_0101  0x35   53  5  
  20187	:  0010_0101  0x25   37  %  
  20188	:  0000_1000  0x08    8    
  20189	:  0100_0001  0x41   65  A  
  20190	:  0010_1101  0x2D   45  -  
  20191	:  0011_0101  0x35   53  5  
  20192	:  0011_0011  0x33   51  3  
  20193	:  0010_1101  0x2D   45  -  
  20194	:  0011_0000  0x30   48  0  
  20195	:  0011_0011  0x33   51  3  
  20196	:  0011_1000  0x38   56  8  
  20197	:  1100_0000  0xC0  192    
  20198	:  0000_1100  0x0C   12    
  20199	:  0000_0000  0x00    0    
  20200	:  0000_0001  0x01    1    
  20201	:  0000_0000  0x00    0    
  20202	:  0000_0001  0x01    1    
  20203	:  0000_0000  0x00    0    
  20204	:  0000_0000  0x00    0    
  20205	:  0010_1010  0x2A   42  *  
  20206	:  0011_0000  0x30   48  0  
  20207	:  0000_0000  0x00    0    
  20208	:  0000_0100  0x04    4    
  20209	:  0010_1101  0x2D   45  -  
  20210	:  0100_0011  0x43   67  C  
  20211	:  0011_0101  0x35   53  5  
  20212	:  0010_0110  0x26   38  &  
  20213	:  0000_1000  0x08    8    
  20214	:  0100_0001  0x41   65  A  
  20215	:  0010_1101  0x2D   45  -  
  20216	:  0011_0101  0x35   53  5  
  20217	:  0011_0011  0x33   51  3  
  20218	:  0010_1101  0x2D   45  -  
  20219	:  0011_0000  0x30   48  0  
  20220	:  0011_0011  0x33   51  3  
  20221	:  0011_1001  0x39   57  9  
  20222	:  1100_0000  0xC0  192    
  20223	:  0000_1100  0x0C   12    
  20224	:  0000_0000  0x00    0    
  20225	:  0000_0001  0x01    1    
  20226	:  0000_0000  0x00    0    
  20227	:  0000_0001  0x01    1    
  20228	:  0000_0000  0x00    0    
  20229	:  0000_0000  0x00    0    
  20230	:  0010_1010  0x2A   42  *  
  20231	:  0011_0000  0x30   48  0  
  20232	:  0000_0000  0x00    0    
  20233	:  0000_0100  0x04    4    
  20234	:  0010_1101  0x2D   45  -  
  20235	:  0100_0011  0x43   67  C  
  20236	:  0011_0101  0x35   53  5  
  20237	:  0010_0111  0x27   39  '  
  20238	:  0000_1000  0x08    8    
  20239	:  0100_0001  0x41   65  A  
  20240	:  0010_1101  0x2D   45  -  
  20241	:  0011_0101  0x35   53  5  
  20242	:  0011_0011  0x33   51  3  
  20243	:  0010_1101  0x2D   45  -  
  20244	:  0011_0000  0x30   48  0  
  20245	:  0011_0100  0x34   52  4  
  20246	:  0011_0000  0x30   48  0  
  20247	:  1100_0000  0xC0  192    
  20248	:  0000_1100  0x0C   12    
  20249	:  0000_0000  0x00    0    
  20250	:  0000_0001  0x01    1    
  20251	:  0000_0000  0x00    0    
  20252	:  0000_0001  0x01    1    
  20253	:  0000_0000  0x00    0    
  20254	:  0000_0000  0x00    0    
  20255	:  0010_1010  0x2A   42  *  
  20256	:  0011_0000  0x30   48  0  
  20257	:  0000_0000  0x00    0    
  20258	:  0000_0100  0x04    4    
  20259	:  0010_1101  0x2D   45  -  
  20260	:  0100_0011  0x43   67  C  
  20261	:  0011_0101  0x35   53  5  
  20262	:  0010_1000  0x28   40  (  
  20263	:  0000_1000  0x08    8    
  20264	:  0100_0001  0x41   65  A  
  20265	:  0010_1101  0x2D   45  -  
  20266	:  0011_0101  0x35   53  5  
  20267	:  0011_0011  0x33   51  3  
  20268	:  0010_1101  0x2D   45  -  
  20269	:  0011_0000  0x30   48  0  
  20270	:  0011_0100  0x34   52  4  
  20271	:  0011_0001  0x31   49  1  
  20272	:  1100_0000  0xC0  192    
  20273	:  0000_1100  0x0C   12    
  20274	:  0000_0000  0x00    0    
  20275	:  0000_0001  0x01    1    
  20276	:  0000_0000  0x00    0    
  20277	:  0000_0001  0x01    1    
  20278	:  0000_0000  0x00    0    
  20279	:  0000_0000  0x00    0    
  20280	:  0010_1010  0x2A   42  *  
  20281	:  0011_0000  0x30   48  0  
  20282	:  0000_0000  0x00    0    
  20283	:  0000_0100  0x04    4    
  20284	:  0010_1101  0x2D   45  -  
  20285	:  0100_0011  0x43   67  C  
  20286	:  0011_0101  0x35   53  5  
  20287	:  0010_1001  0x29   41  )  
  20288	:  0000_1000  0x08    8    
  20289	:  0100_0001  0x41   65  A  
  20290	:  0010_1101  0x2D   45  -  
  20291	:  0011_0101  0x35   53  5  
  20292	:  0011_0011  0x33   51  3  
  20293	:  0010_1101  0x2D   45  -  
  20294	:  0011_0000  0x30   48  0  
  20295	:  0011_0100  0x34   52  4  
  20296	:  0011_0010  0x32   50  2  
  20297	:  1100_0000  0xC0  192    
  20298	:  0000_1100  0x0C   12    
  20299	:  0000_0000  0x00    0    
  20300	:  0000_0001  0x01    1    
  20301	:  0000_0000  0x00    0    
  20302	:  0000_0001  0x01    1    
  20303	:  0000_0000  0x00    0    
  20304	:  0000_0000  0x00    0    
  20305	:  0010_1010  0x2A   42  *  
  20306	:  0011_0000  0x30   48  0  
  20307	:  0000_0000  0x00    0    
  20308	:  0000_0100  0x04    4    
  20309	:  0010_1101  0x2D   45  -  
  20310	:  0100_0011  0x43   67  C  
  20311	:  0011_0101  0x35   53  5  
  20312	:  0010_1010  0x2A   42  *  
  20313	:  0000_1000  0x08    8    
  20314	:  0100_0001  0x41   65  A  
  20315	:  0010_1101  0x2D   45  -  
  20316	:  0011_0101  0x35   53  5  
  20317	:  0011_0011  0x33   51  3  
  20318	:  0010_1101  0x2D   45  -  
  20319	:  0011_0000  0x30   48  0  
  20320	:  0011_0100  0x34   52  4  
  20321	:  0011_0011  0x33   51  3  
  20322	:  1100_0000  0xC0  192    
  20323	:  0000_1100  0x0C   12    
  20324	:  0000_0000  0x00    0    
  20325	:  0000_0001  0x01    1    
  20326	:  0000_0000  0x00    0    
  20327	:  0000_0001  0x01    1    
  20328	:  0000_0000  0x00    0    
  20329	:  0000_0000  0x00    0    
  20330	:  0010_1010  0x2A   42  *  
  20331	:  0011_0000  0x30   48  0  
  20332	:  0000_0000  0x00    0    
  20333	:  0000_0100  0x04    4    
  20334	:  0010_1101  0x2D   45  -  
  20335	:  0100_0011  0x43   67  C  
  20336	:  0011_0101  0x35   53  5  
  20337	:  0010_1011  0x2B   43  +  
  20338	:  0000_1000  0x08    8    
  20339	:  0100_0001  0x41   65  A  
  20340	:  0010_1101  0x2D   45  -  
  20341	:  0011_0101  0x35   53  5  
  20342	:  0011_0011  0x33   51  3  
  20343	:  0010_1101  0x2D   45  -  
  20344	:  0011_0000  0x30   48  0  
  20345	:  0011_0100  0x34   52  4  
  20346	:  0011_0100  0x34   52  4  
  20347	:  1100_0000  0xC0  192    
  20348	:  0000_1100  0x0C   12    
  20349	:  0000_0000  0x00    0    
  20350	:  0000_0001  0x01    1    
  20351	:  0000_0000  0x00    0    
  20352	:  0000_0001  0x01    1    
  20353	:  0000_0000  0x00    0    
  20354	:  0000_0000  0x00    0    
  20355	:  0010_1010  0x2A   42  *  
  20356	:  0011_0000  0x30   48  0  
  20357	:  0000_0000  0x00    0    
  20358	:  0000_0100  0x04    4    
  20359	:  0010_1101  0x2D   45  -  
  20360	:  0100_0011  0x43   67  C  
  20361	:  0011_0101  0x35   53  5  
  20362	:  0010_1100  0x2C   44  ,  
  20363	:  0000_1000  0x08    8    
  20364	:  0100_0001  0x41   65  A  
  20365	:  0010_1101  0x2D   45  -  
  20366	:  0011_0101  0x35   53  5  
  20367	:  0011_0011  0x33   51  3  
  20368	:  0010_1101  0x2D   45  -  
  20369	:  0011_0000  0x30   48  0  
  20370	:  0011_0100  0x34   52  4  
  20371	:  0011_0101  0x35   53  5  
  20372	:  1100_0000  0xC0  192    
  20373	:  0000_1100  0x0C   12    
  20374	:  0000_0000  0x00    0    
  20375	:  0000_0001  0x01    1    
  20376	:  0000_0000  0x00    0    
  20377	:  0000_0001  0x01    1    
  20378	:  0000_0000  0x00    0    
  20379	:  0000_0000  0x00    0    
  20380	:  0010_1010  0x2A   42  *  
  20381	:  0011_0000  0x30   48  0  
  20382	:  0000_0000  0x00    0    
  20383	:  0000_0100  0x04    4    
  20384	:  0010_1101  0x2D   45  -  
  20385	:  0100_0011  0x43   67  C  
  20386	:  0011_0101  0x35   53  5  
  20387	:  0010_1101  0x2D   45  -  
  20388	:  0000_1000  0x08    8    
  20389	:  0100_0001  0x41   65  A  
  20390	:  0010_1101  0x2D   45  -  
  20391	:  0011_0101  0x35   53  5  
  20392	:  0011_0011  0x33   51  3  
  20393	:  0010_1101  0x2D   45  -  
  20394	:  0011_0000  0x30   48  0  
  20395	:  0011_0100  0x34   52  4  
  20396	:  0011_0110  0x36   54  6  
  20397	:  1100_0000  0xC0  192    
  20398	:  0000_1100  0x0C   12    
  20399	:  0000_0000  0x00    0    
  20400	:  0000_0001  0x01    1    
  20401	:  0000_0000  0x00    0    
  20402	:  0000_0001  0x01    1    
  20403	:  0000_0000  0x00    0    
  20404	:  0000_0000  0x00    0    
  20405	:  0010_1010  0x2A   42  *  
  20406	:  0011_0000  0x30   48  0  
  20407	:  0000_0000  0x00    0    
  20408	:  0000_0100  0x04    4    
  20409	:  0010_1101  0x2D   45  -  
  20410	:  0100_0011  0x43   67  C  
  20411	:  0011_0101  0x35   53  5  
  20412	:  0010_1110  0x2E   46  .  
  20413	:  0000_1000  0x08    8    
  20414	:  0100_0001  0x41   65  A  
  20415	:  0010_1101  0x2D   45  -  
  20416	:  0011_0101  0x35   53  5  
  20417	:  0011_0011  0x33   51  3  
  20418	:  0010_1101  0x2D   45  -  
  20419	:  0011_0000  0x30   48  0  
  20420	:  0011_0100  0x34   52  4  
  20421	:  0011_0111  0x37   55  7  
  20422	:  1100_0000  0xC0  192    
  20423	:  0000_1100  0x0C   12    
  20424	:  0000_0000  0x00    0    
  20425	:  0000_0001  0x01    1    
  20426	:  0000_0000  0x00    0    
  20427	:  0000_0001  0x01    1    
  20428	:  0000_0000  0x00    0    
  20429	:  0000_0000  0x00    0    
  20430	:  0010_1010  0x2A   42  *  
  20431	:  0011_0000  0x30   48  0  
  20432	:  0000_0000  0x00    0    
  20433	:  0000_0100  0x04    4    
  20434	:  0010_1101  0x2D   45  -  
  20435	:  0100_0011  0x43   67  C  
  20436	:  0011_0101  0x35   53  5  
  20437	:  0010_1111  0x2F   47  /  
  20438	:  0000_1000  0x08    8    
  20439	:  0100_0001  0x41   65  A  
  20440	:  0010_1101  0x2D   45  -  
  20441	:  0011_0101  0x35   53  5  
  20442	:  0011_0011  0x33   51  3  
  20443	:  0010_1101  0x2D   45  -  
  20444	:  0011_0000  0x30   48  0  
  20445	:  0011_0100  0x34   52  4  
  20446	:  0011_1000  0x38   56  8  
  20447	:  1100_0000  0xC0  192    
  20448	:  0000_1100  0x0C   12    
  20449	:  0000_0000  0x00    0    
  20450	:  0000_0001  0x01    1    
  20451	:  0000_0000  0x00    0    
  20452	:  0000_0001  0x01    1    
  20453	:  0000_0000  0x00    0    
  20454	:  0000_0000  0x00    0    
  20455	:  0010_1010  0x2A   42  *  
  20456	:  0011_0000  0x30   48  0  
  20457	:  0000_0000  0x00    0    
  20458	:  0000_0100  0x04    4    
  20459	:  0010_1101  0x2D   45  -  
  20460	:  0100_0011  0x43   67  C  
  20461	:  0011_0101  0x35   53  5  
  20462	:  0011_0000  0x30   48  0  
  20463	:  0000_1000  0x08    8    
  20464	:  0100_0001  0x41   65  A  
  20465	:  0010_1101  0x2D   45  -  
  20466	:  0011_0101  0x35   53  5  
  20467	:  0011_0011  0x33   51  3  
  20468	:  0010_1101  0x2D   45  -  
  20469	:  0011_0000  0x30   48  0  
  20470	:  0011_0100  0x34   52  4  
  20471	:  0011_1001  0x39   57  9  
  20472	:  1100_0000  0xC0  192    
  20473	:  0000_1100  0x0C   12    
  20474	:  0000_0000  0x00    0    
  20475	:  0000_0001  0x01    1    
  20476	:  0000_0000  0x00    0    
  20477	:  0000_0001  0x01    1    
  20478	:  0000_0000  0x00    0    
  20479	:  0000_0000  0x00    0    
  20480	:  0010_1010  0x2A   42  *  
  20481	:  0011_0000  0x30   48  0  
  20482	:  0000_0000  0x00    0    
  20483	:  0000_0100  0x04    4    
  20484	:  0010_1101  0x2D   45  -  
  20485	:  0100_0011  0x43   67  C  
  20486	:  0011_0101  0x35   53  5  
  20487	:  0011_0001  0x31   49  1  
  20488	:  0000_1000  0x08    8    
  20489	:  0100_0001  0x41   65  A  
  20490	:  0010_1101  0x2D   45  -  
  20491	:  0011_0101  0x35   53  5  
  20492	:  0011_0011  0x33   51  3  
  20493	:  0010_1101  0x2D   45  -  
  20494	:  0011_0000  0x30   48  0  
  20495	:  0011_0101  0x35   53  5  
  20496	:  0011_0000  0x30   48  0  
  20497	:  1100_0000  0xC0  192    
  20498	:  0000_1100  0x0C   12    
  20499	:  0000_0000  0x00    0    
  20500	:  0000_0001  0x01    1    
  20501	:  0000_0000  0x00    0    
  20502	:  0000_0001  0x01    1    
  20503	:  0000_0000  0x00    0    
  20504	:  0000_0000  0x00    0    
  20505	:  0010_1010  0x2A   42  *  
  20506	:  0011_0000  0x30   48  0  
  20507	:  0000_0000  0x00    0    
  20508	:  0000_0100  0x04    4    
  20509	:  0010_1101  0x2D   45  -  
  20510	:  0100_0011  0x43   67  C  
  20511	:  0011_0101  0x35   53  5  
  20512	:  0011_0010  0x32   50  2  
  20513	:  0000_1000  0x08    8    
  20514	:  0100_0001  0x41   65  A  
  20515	:  0010_1101  0x2D   45  -  
  20516	:  0011_0101  0x35   53  5  
  20517	:  0011_0011  0x33   51  3  
  20518	:  0010_1101  0x2D   45  -  
  20519	:  0011_0000  0x30   48  0  
  20520	:  0011_0101  0x35   53  5  
  20521	:  0011_0001  0x31   49  1  
  20522	:  1100_0000  0xC0  192    
  20523	:  0000_1100  0x0C   12    
  20524	:  0000_0000  0x00    0    
  20525	:  0000_0001  0x01    1    
  20526	:  0000_0000  0x00    0    
  20527	:  0000_0001  0x01    1    
  20528	:  0000_0000  0x00    0    
  20529	:  0000_0000  0x00    0    
  20530	:  0010_1010  0x2A   42  *  
  20531	:  0011_0000  0x30   48  0  
  20532	:  0000_0000  0x00    0    
  20533	:  0000_0100  0x04    4    
  20534	:  0010_1101  0x2D   45  -  
  20535	:  0100_0011  0x43   67  C  
  20536	:  0011_0101  0x35   53  5  
  20537	:  0011_0011  0x33   51  3  
  20538	:  0000_1000  0x08    8    
  20539	:  0100_0001  0x41   65  A  
  20540	:  0010_1101  0x2D   45  -  
  20541	:  0011_0101  0x35   53  5  
  20542	:  0011_0011  0x33   51  3  
  20543	:  0010_1101  0x2D   45  -  
  20544	:  0011_0000  0x30   48  0  
  20545	:  0011_0101  0x35   53  5  
  20546	:  0011_0010  0x32   50  2  
  20547	:  1100_0000  0xC0  192    
  20548	:  0000_1100  0x0C   12    
  20549	:  0000_0000  0x00    0    
  20550	:  0000_0001  0x01    1    
  20551	:  0000_0000  0x00    0    
  20552	:  0000_0001  0x01    1    
  20553	:  0000_0000  0x00    0    
  20554	:  0000_0000  0x00    0    
  20555	:  0010_1010  0x2A   42  *  
  20556	:  0011_0000  0x30   48  0  
  20557	:  0000_0000  0x00    0    
  20558	:  0000_0100  0x04    4    
  20559	:  0010_1101  0x2D   45  -  
  20560	:  0100_0011  0x43   67  C  
  20561	:  0011_0101  0x35   53  5  
  20562	:  0011_0100  0x34   52  4  
  20563	:  0000_1000  0x08    8    
  20564	:  0100_0001  0x41   65  A  
  20565	:  0010_1101  0x2D   45  -  
  20566	:  0011_0101  0x35   53  5  
  20567	:  0011_0011  0x33   51  3  
  20568	:  0010_1101  0x2D   45  -  
  20569	:  0011_0000  0x30   48  0  
  20570	:  0011_0101  0x35   53  5  
  20571	:  0011_0011  0x33   51  3  
  20572	:  1100_0000  0xC0  192    
  20573	:  0000_1100  0x0C   12    
  20574	:  0000_0000  0x00    0    
  20575	:  0000_0001  0x01    1    
  20576	:  0000_0000  0x00    0    
  20577	:  0000_0001  0x01    1    
  20578	:  0000_0000  0x00    0    
  20579	:  0000_0000  0x00    0    
  20580	:  0010_1010  0x2A   42  *  
  20581	:  0011_0000  0x30   48  0  
  20582	:  0000_0000  0x00    0    
  20583	:  0000_0100  0x04    4    
  20584	:  0010_1101  0x2D   45  -  
  20585	:  0100_0011  0x43   67  C  
  20586	:  0011_0101  0x35   53  5  
  20587	:  0011_0101  0x35   53  5  
  20588	:  0000_1000  0x08    8    
  20589	:  0100_0001  0x41   65  A  
  20590	:  0010_1101  0x2D   45  -  
  20591	:  0011_0101  0x35   53  5  
  20592	:  0011_0011  0x33   51  3  
  20593	:  0010_1101  0x2D   45  -  
  20594	:  0011_0000  0x30   48  0  
  20595	:  0011_0101  0x35   53  5  
  20596	:  0011_0100  0x34   52  4  
  20597	:  1100_0000  0xC0  192    
  20598	:  0000_1100  0x0C   12    
  20599	:  0000_0000  0x00    0    
  20600	:  0000_0001  0x01    1    
  20601	:  0000_0000  0x00    0    
  20602	:  0000_0001  0x01    1    
  20603	:  0000_0000  0x00    0    
  20604	:  0000_0000  0x00    0    
  20605	:  0010_1010  0x2A   42  *  
  20606	:  0011_0000  0x30   48  0  
  20607	:  0000_0000  0x00    0    
  20608	:  0000_0100  0x04    4    
  20609	:  0010_1101  0x2D   45  -  
  20610	:  0100_0011  0x43   67  C  
  20611	:  0011_0101  0x35   53  5  
  20612	:  0011_0110  0x36   54  6  
  20613	:  0000_1000  0x08    8    
  20614	:  0100_0001  0x41   65  A  
  20615	:  0010_1101  0x2D   45  -  
  20616	:  0011_0101  0x35   53  5  
  20617	:  0011_0011  0x33   51  3  
  20618	:  0010_1101  0x2D   45  -  
  20619	:  0011_0000  0x30   48  0  
  20620	:  0011_0101  0x35   53  5  
  20621	:  0011_0101  0x35   53  5  
  20622	:  1100_0000  0xC0  192    
  20623	:  0000_1100  0x0C   12    
  20624	:  0000_0000  0x00    0    
  20625	:  0000_0001  0x01    1    
  20626	:  0000_0000  0x00    0    
  20627	:  0000_0001  0x01    1    
  20628	:  0000_0000  0x00    0    
  20629	:  0000_0000  0x00    0    
  20630	:  0010_1010  0x2A   42  *  
  20631	:  0011_0000  0x30   48  0  
  20632	:  0000_0000  0x00    0    
  20633	:  0000_0100  0x04    4    
  20634	:  0010_1101  0x2D   45  -  
  20635	:  0100_0011  0x43   67  C  
  20636	:  0011_0101  0x35   53  5  
  20637	:  0011_0111  0x37   55  7  
  20638	:  0000_1000  0x08    8    
  20639	:  0100_0001  0x41   65  A  
  20640	:  0010_1101  0x2D   45  -  
  20641	:  0011_0101  0x35   53  5  
  20642	:  0011_0011  0x33   51  3  
  20643	:  0010_1101  0x2D   45  -  
  20644	:  0011_0000  0x30   48  0  
  20645	:  0011_0101  0x35   53  5  
  20646	:  0011_0110  0x36   54  6  
  20647	:  1100_0000  0xC0  192    
  20648	:  0000_1100  0x0C   12    
  20649	:  0000_0000  0x00    0    
  20650	:  0000_0001  0x01    1    
  20651	:  0000_0000  0x00    0    
  20652	:  0000_0001  0x01    1    
  20653	:  0000_0000  0x00    0    
  20654	:  0000_0000  0x00    0    
  20655	:  0010_1010  0x2A   42  *  
  20656	:  0011_0000  0x30   48  0  
  20657	:  0000_0000  0x00    0    
  20658	:  0000_0100  0x04    4    
  20659	:  0010_1101  0x2D   45  -  
  20660	:  0100_0011  0x43   67  C  
  20661	:  0011_0101  0x35   53  5  
  20662	:  0011_1000  0x38   56  8  
  20663	:  0000_1000  0x08    8    
  20664	:  0100_0001  0x41   65  A  
  20665	:  0010_1101  0x2D   45  -  
  20666	:  0011_0101  0x35   53  5  
  20667	:  0011_0011  0x33   51  3  
  20668	:  0010_1101  0x2D   45  -  
  20669	:  0011_0000  0x30   48  0  
  20670	:  0011_0101  0x35   53  5  
  20671	:  0011_0111  0x37   55  7  
  20672	:  1100_0000  0xC0  192    
  20673	:  0000_1100  0x0C   12    
  20674	:  0000_0000  0x00    0    
  20675	:  0000_0001  0x01    1    
  20676	:  0000_0000  0x00    0    
  20677	:  0000_0001  0x01    1    
  20678	:  0000_0000  0x00    0    
  20679	:  0000_0000  0x00    0    
  20680	:  0010_1010  0x2A   42  *  
  20681	:  0011_0000  0x30   48  0  
  20682	:  0000_0000  0x00    0    
  20683	:  0000_0100  0x04    4    
  20684	:  0010_1101  0x2D   45  -  
  20685	:  0100_0011  0x43   67  C  
  20686	:  0011_0101  0x35   53  5  
  20687	:  0011_1001  0x39   57  9  
  20688	:  0000_1000  0x08    8    
  20689	:  0100_0001  0x41   65  A  
  20690	:  0010_1101  0x2D   45  -  
  20691	:  0011_0101  0x35   53  5  
  20692	:  0011_0011  0x33   51  3  
  20693	:  0010_1101  0x2D   45  -  
  20694	:  0011_0000  0x30   48  0  
  20695	:  0011_0101  0x35   53  5  
  20696	:  0011_1000  0x38   56  8  
  20697	:  1100_0000  0xC0  192    
  20698	:  0000_1100  0x0C   12    
  20699	:  0000_0000  0x00    0    
  20700	:  0000_0001  0x01    1    
  20701	:  0000_0000  0x00    0    
  20702	:  0000_0001  0x01    1    
  20703	:  0000_0000  0x00    0    
  20704	:  0000_0000  0x00    0    
  20705	:  0010_1010  0x2A   42  *  
  20706	:  0011_0000  0x30   48  0  
  20707	:  0000_0000  0x00    0    
  20708	:  0000_0100  0x04    4    
  20709	:  0010_1101  0x2D   45  -  
  20710	:  0100_0011  0x43   67  C  
  20711	:  0011_0101  0x35   53  5  
  20712	:  0011_1010  0x3A   58  :  
  20713	:  0000_1000  0x08    8    
  20714	:  0100_0001  0x41   65  A  
  20715	:  0010_1101  0x2D   45  -  
  20716	:  0011_0101  0x35   53  5  
  20717	:  0011_0011  0x33   51  3  
  20718	:  0010_1101  0x2D   45  -  
  20719	:  0011_0000  0x30   48  0  
  20720	:  0011_0101  0x35   53  5  
  20721	:  0011_1001  0x39   57  9  
  20722	:  1100_0000  0xC0  192    
  20723	:  0000_1100  0x0C   12    
  20724	:  0000_0000  0x00    0    
  20725	:  0000_0001  0x01    1    
  20726	:  0000_0000  0x00    0    
  20727	:  0000_0001  0x01    1    
  20728	:  0000_0000  0x00    0    
  20729	:  0000_0000  0x00    0    
  20730	:  0010_1010  0x2A   42  *  
  20731	:  0011_0000  0x30   48  0  
  20732	:  0000_0000  0x00    0    
  20733	:  0000_0100  0x04    4    
  20734	:  0010_1101  0x2D   45  -  
  20735	:  0100_0011  0x43   67  C  
  20736	:  0011_0101  0x35   53  5  
  20737	:  0011_1011  0x3B   59  ;  
  20738	:  0000_1000  0x08    8    
  20739	:  0100_0001  0x41   65  A  
  20740	:  0010_1101  0x2D   45  -  
  20741	:  0011_0101  0x35   53  5  
  20742	:  0011_0011  0x33   51  3  
  20743	:  0010_1101  0x2D   45  -  
  20744	:  0011_0000  0x30   48  0  
  20745	:  0011_0110  0x36   54  6  
  20746	:  0011_0000  0x30   48  0  
  20747	:  1100_0000  0xC0  192    
  20748	:  0000_1100  0x0C   12    
  20749	:  0000_0000  0x00    0    
  20750	:  0000_0001  0x01    1    
  20751	:  0000_0000  0x00    0    
  20752	:  0000_0001  0x01    1    
  20753	:  0000_0000  0x00    0    
  20754	:  0000_0000  0x00    0    
  20755	:  0010_1010  0x2A   42  *  
  20756	:  0011_0000  0x30   48  0  
  20757	:  0000_0000  0x00    0    
  20758	:  0000_0100  0x04    4    
  20759	:  0010_1101  0x2D   45  -  
  20760	:  0100_0011  0x43   67  C  
  20761	:  0011_0101  0x35   53  5  
  20762	:  0011_1100  0x3C   60  <  
  20763	:  0000_1000  0x08    8    
  20764	:  0100_0001  0x41   65  A  
  20765	:  0010_1101  0x2D   45  -  
  20766	:  0011_0101  0x35   53  5  
  20767	:  0011_0011  0x33   51  3  
  20768	:  0010_1101  0x2D   45  -  
  20769	:  0011_0000  0x30   48  0  
  20770	:  0011_0110  0x36   54  6  
  20771	:  0011_0001  0x31   49  1  
  20772	:  1100_0000  0xC0  192    
  20773	:  0000_1100  0x0C   12    
  20774	:  0000_0000  0x00    0    
  20775	:  0000_0001  0x01    1    
  20776	:  0000_0000  0x00    0    
  20777	:  0000_0001  0x01    1    
  20778	:  0000_0000  0x00    0    
  20779	:  0000_0000  0x00    0    
  20780	:  0010_1010  0x2A   42  *  
  20781	:  0011_0000  0x30   48  0  
  20782	:  0000_0000  0x00    0    
  20783	:  0000_0100  0x04    4    
  20784	:  0010_1101  0x2D   45  -  
  20785	:  0100_0011  0x43   67  C  
  20786	:  0011_0101  0x35   53  5  
  20787	:  0011_1101  0x3D   61  =  
  20788	:  0000_1000  0x08    8    
  20789	:  0100_0001  0x41   65  A  
  20790	:  0010_1101  0x2D   45  -  
  20791	:  0011_0101  0x35   53  5  
  20792	:  0011_0011  0x33   51  3  
  20793	:  0010_1101  0x2D   45  -  
  20794	:  0011_0000  0x30   48  0  
  20795	:  0011_0110  0x36   54  6  
  20796	:  0011_0010  0x32   50  2  
  20797	:  1100_0000  0xC0  192    
  20798	:  0000_1100  0x0C   12    
  20799	:  0000_0000  0x00    0    
  20800	:  0000_0001  0x01    1    
  20801	:  0000_0000  0x00    0    
  20802	:  0000_0001  0x01    1    
  20803	:  0000_0000  0x00    0    
  20804	:  0000_0000  0x00    0    
  20805	:  0010_1010  0x2A   42  *  
  20806	:  0011_0000  0x30   48  0  
  20807	:  0000_0000  0x00    0    
  20808	:  0000_0100  0x04    4    
  20809	:  0010_1101  0x2D   45  -  
  20810	:  0100_0011  0x43   67  C  
  20811	:  0011_0101  0x35   53  5  
  20812	:  0011_1110  0x3E   62  >  
  20813	:  0000_1000  0x08    8    
  20814	:  0100_0001  0x41   65  A  
  20815	:  0010_1101  0x2D   45  -  
  20816	:  0011_0101  0x35   53  5  
  20817	:  0011_0011  0x33   51  3  
  20818	:  0010_1101  0x2D   45  -  
  20819	:  0011_0000  0x30   48  0  
  20820	:  0011_0110  0x36   54  6  
  20821	:  0011_0011  0x33   51  3  
  20822	:  1100_0000  0xC0  192    
  20823	:  0000_1100  0x0C   12    
  20824	:  0000_0000  0x00    0    
  20825	:  0000_0001  0x01    1    
  20826	:  0000_0000  0x00    0    
  20827	:  0000_0001  0x01    1    
  20828	:  0000_0000  0x00    0    
  20829	:  0000_0000  0x00    0    
  20830	:  0010_1010  0x2A   42  *  
  20831	:  0011_0000  0x30   48  0  
  20832	:  0000_0000  0x00    0    
  20833	:  0000_0100  0x04    4    
  20834	:  0010_1101  0x2D   45  -  
  20835	:  0100_0011  0x43   67  C  
  20836	:  0011_0101  0x35   53  5  
  20837	:  0011_1111  0x3F   63  ?  
  20838	:  0000_1000  0x08    8    
  20839	:  0100_0001  0x41   65  A  
  20840	:  0010_1101  0x2D   45  -  
  20841	:  0011_0101  0x35   53  5  
  20842	:  0011_0011  0x33   51  3  
  20843	:  0010_1101  0x2D   45  -  
  20844	:  0011_0000  0x30   48  0  
  20845	:  0011_0110  0x36   54  6  
  20846	:  0011_0100  0x34   52  4  
  20847	:  1100_0000  0xC0  192    
  20848	:  0000_1100  0x0C   12    
  20849	:  0000_0000  0x00    0    
  20850	:  0000_0001  0x01    1    
  20851	:  0000_0000  0x00    0    
  20852	:  0000_0001  0x01    1    
  20853	:  0000_0000  0x00    0    
  20854	:  0000_0000  0x00    0    
  20855	:  0010_1010  0x2A   42  *  
  20856	:  0011_0000  0x30   48  0  
  20857	:  0000_0000  0x00    0    
  20858	:  0000_0100  0x04    4    
  20859	:  0010_1101  0x2D   45  -  
  20860	:  0100_0011  0x43   67  C  
  20861	:  0011_0101  0x35   53  5  
  20862	:  0100_0000  0x40   64  @  
  20863	:  0000_1000  0x08    8    
  20864	:  0100_0001  0x41   65  A  
  20865	:  0010_1101  0x2D   45  -  
  20866	:  0011_0101  0x35   53  5  
  20867	:  0011_0011  0x33   51  3  
  20868	:  0010_1101  0x2D   45  -  
  20869	:  0011_0000  0x30   48  0  
  20870	:  0011_0110  0x36   54  6  
  20871	:  0011_0101  0x35   53  5  
  20872	:  1100_0000  0xC0  192    
  20873	:  0000_1100  0x0C   12    
  20874	:  0000_0000  0x00    0    
  20875	:  0000_0001  0x01    1    
  20876	:  0000_0000  0x00    0    
  20877	:  0000_0001  0x01    1    
  20878	:  0000_0000  0x00    0    
  20879	:  0000_0000  0x00    0    
  20880	:  0010_1010  0x2A   42  *  
  20881	:  0011_0000  0x30   48  0  
  20882	:  0000_0000  0x00    0    
  20883	:  0000_0100  0x04    4    
  20884	:  0010_1101  0x2D   45  -  
  20885	:  0100_0011  0x43   67  C  
  20886	:  0011_0101  0x35   53  5  
  20887	:  0100_0001  0x41   65  A  
  20888	:  0000_1000  0x08    8    
  20889	:  0100_0001  0x41   65  A  
  20890	:  0010_1101  0x2D   45  -  
  20891	:  0011_0101  0x35   53  5  
  20892	:  0011_0011  0x33   51  3  
  20893	:  0010_1101  0x2D   45  -  
  20894	:  0011_0000  0x30   48  0  
  20895	:  0011_0110  0x36   54  6  
  20896	:  0011_0110  0x36   54  6  
  20897	:  1100_0000  0xC0  192    
  20898	:  0000_1100  0x0C   12    
  20899	:  0000_0000  0x00    0    
  20900	:  0000_0001  0x01    1    
  20901	:  0000_0000  0x00    0    
  20902	:  0000_0001  0x01    1    
  20903	:  0000_0000  0x00    0    
  20904	:  0000_0000  0x00    0    
  20905	:  0010_1010  0x2A   42  *  
  20906	:  0011_0000  0x30   48  0  
  20907	:  0000_0000  0x00    0    
  20908	:  0000_0100  0x04    4    
  20909	:  0010_1101  0x2D   45  -  
  20910	:  0100_0011  0x43   67  C  
  20911	:  0011_0101  0x35   53  5  
  20912	:  0100_0010  0x42   66  B  
  20913	:  0000_1000  0x08    8    
  20914	:  0100_0001  0x41   65  A  
  20915	:  0010_1101  0x2D   45  -  
  20916	:  0011_0101  0x35   53  5  
  20917	:  0011_0011  0x33   51  3  
  20918	:  0010_1101  0x2D   45  -  
  20919	:  0011_0000  0x30   48  0  
  20920	:  0011_0110  0x36   54  6  
  20921	:  0011_0111  0x37   55  7  
  20922	:  1100_0000  0xC0  192    
  20923	:  0000_1100  0x0C   12    
  20924	:  0000_0000  0x00    0    
  20925	:  0000_0001  0x01    1    
  20926	:  0000_0000  0x00    0    
  20927	:  0000_0001  0x01    1    
  20928	:  0000_0000  0x00    0    
  20929	:  0000_0000  0x00    0    
  20930	:  0010_1010  0x2A   42  *  
  20931	:  0011_0000  0x30   48  0  
  20932	:  0000_0000  0x00    0    
  20933	:  0000_0100  0x04    4    
  20934	:  0010_1101  0x2D   45  -  
  20935	:  0100_0011  0x43   67  C  
  20936	:  0011_0101  0x35   53  5  
  20937	:  0100_0011  0x43   67  C  
  20938	:  0000_1000  0x08    8    
  20939	:  0100_0001  0x41   65  A  
  20940	:  0010_1101  0x2D   45  -  
  20941	:  0011_0101  0x35   53  5  
  20942	:  0011_0011  0x33   51  3  
  20943	:  0010_1101  0x2D   45  -  
  20944	:  0011_0000  0x30   48  0  
  20945	:  0011_0110  0x36   54  6  
  20946	:  0011_1000  0x38   56  8  
  20947	:  1100_0000  0xC0  192    
  20948	:  0000_1100  0x0C   12    
  20949	:  0000_0000  0x00    0    
  20950	:  0000_0001  0x01    1    
  20951	:  0000_0000  0x00    0    
  20952	:  0000_0001  0x01    1    
  20953	:  0000_0000  0x00    0    
  20954	:  0000_0000  0x00    0    
  20955	:  0010_1010  0x2A   42  *  
  20956	:  0011_0000  0x30   48  0  
  20957	:  0000_0000  0x00    0    
  20958	:  0000_0100  0x04    4    
  20959	:  0010_1101  0x2D   45  -  
  20960	:  0100_0011  0x43   67  C  
  20961	:  0011_0101  0x35   53  5  
  20962	:  0100_0100  0x44   68  D  
  20963	:  0000_1000  0x08    8    
  20964	:  0100_0001  0x41   65  A  
  20965	:  0010_1101  0x2D   45  -  
  20966	:  0011_0101  0x35   53  5  
  20967	:  0011_0011  0x33   51  3  
  20968	:  0010_1101  0x2D   45  -  
  20969	:  0011_0000  0x30   48  0  
  20970	:  0011_0110  0x36   54  6  
  20971	:  0011_1001  0x39   57  9  
  20972	:  1100_0000  0xC0  192    
  20973	:  0000_1100  0x0C   12    
  20974	:  0000_0000  0x00    0    
  20975	:  0000_0001  0x01    1    
  20976	:  0000_0000  0x00    0    
  20977	:  0000_0001  0x01    1    
  20978	:  0000_0000  0x00    0    
  20979	:  0000_0000  0x00    0    
  20980	:  0010_1010  0x2A   42  *  
  20981	:  0011_0000  0x30   48  0  
  20982	:  0000_0000  0x00    0    
  20983	:  0000_0100  0x04    4    
  20984	:  0010_1101  0x2D   45  -  
  20985	:  0100_0011  0x43   67  C  
  20986	:  0011_0101  0x35   53  5  
  20987	:  0100_0101  0x45   69  E  
  20988	:  0000_1000  0x08    8    
  20989	:  0100_0001  0x41   65  A  
  20990	:  0010_1101  0x2D   45  -  
  20991	:  0011_0101  0x35   53  5  
  20992	:  0011_0011  0x33   51  3  
  20993	:  0010_1101  0x2D   45  -  
  20994	:  0011_0000  0x30   48  0  
  20995	:  0011_0111  0x37   55  7  
  20996	:  0011_0000  0x30   48  0  
  20997	:  1100_0000  0xC0  192    
  20998	:  0000_1100  0x0C   12    
  20999	:  0000_0000  0x00    0    
  21000	:  0000_0001  0x01    1    
  21001	:  0000_0000  0x00    0    
  21002	:  0000_0001  0x01    1    
  21003	:  0000_0000  0x00    0    
  21004	:  0000_0000  0x00    0    
  21005	:  0010_1010  0x2A   42  *  
  21006	:  0011_0000  0x30   48  0  
  21007	:  0000_0000  0x00    0    
  21008	:  0000_0100  0x04    4    
  21009	:  0010_1101  0x2D   45  -  
  21010	:  0100_0011  0x43   67  C  
  21011	:  0011_0101  0x35   53  5  
  21012	:  0100_0110  0x46   70  F  
  21013	:  0000_1000  0x08    8    
  21014	:  0100_0001  0x41   65  A  
  21015	:  0010_1101  0x2D   45  -  
  21016	:  0011_0101  0x35   53  5  
  21017	:  0011_0011  0x33   51  3  
  21018	:  0010_1101  0x2D   45  -  
  21019	:  0011_0000  0x30   48  0  
  21020	:  0011_0111  0x37   55  7  
  21021	:  0011_0001  0x31   49  1  
  21022	:  1100_0000  0xC0  192    
  21023	:  0000_1100  0x0C   12    
  21024	:  0000_0000  0x00    0    
  21025	:  0000_0001  0x01    1    
  21026	:  0000_0000  0x00    0    
  21027	:  0000_0001  0x01    1    
  21028	:  0000_0000  0x00    0    
  21029	:  0000_0000  0x00    0    
  21030	:  0010_1010  0x2A   42  *  
  21031	:  0011_0000  0x30   48  0  
  21032	:  0000_0000  0x00    0    
  21033	:  0000_0100  0x04    4    
  21034	:  0010_1101  0x2D   45  -  
  21035	:  0100_0011  0x43   67  C  
  21036	:  0011_0101  0x35   53  5  
  21037	:  0100_0111  0x47   71  G  
  21038	:  0000_1000  0x08    8    
  21039	:  0100_0001  0x41   65  A  
  21040	:  0010_1101  0x2D   45  -  
  21041	:  0011_0101  0x35   53  5  
  21042	:  0011_0011  0x33   51  3  
  21043	:  0010_1101  0x2D   45  -  
  21044	:  0011_0000  0x30   48  0  
  21045	:  0011_0111  0x37   55  7  
  21046	:  0011_0010  0x32   50  2  
  21047	:  1100_0000  0xC0  192    
  21048	:  0000_1100  0x0C   12    
  21049	:  0000_0000  0x00    0    
  21050	:  0000_0001  0x01    1    
  21051	:  0000_0000  0x00    0    
  21052	:  0000_0001  0x01    1    
  21053	:  0000_0000  0x00    0    
  21054	:  0000_0000  0x00    0    
  21055	:  0010_1010  0x2A   42  *  
  21056	:  0011_0000  0x30   48  0  
  21057	:  0000_0000  0x00    0    
  21058	:  0000_0100  0x04    4    
  21059	:  0010_1101  0x2D   45  -  
  21060	:  0100_0011  0x43   67  C  
  21061	:  0011_0101  0x35   53  5  
  21062	:  0100_1000  0x48   72  H  
  21063	:  0000_1000  0x08    8    
  21064	:  0100_0001  0x41   65  A  
  21065	:  0010_1101  0x2D   45  -  
  21066	:  0011_0101  0x35   53  5  
  21067	:  0011_0011  0x33   51  3  
  21068	:  0010_1101  0x2D   45  -  
  21069	:  0011_0000  0x30   48  0  
  21070	:  0011_0111  0x37   55  7  
  21071	:  0011_0011  0x33   51  3  
  21072	:  1100_0000  0xC0  192    
  21073	:  0000_1100  0x0C   12    
  21074	:  0000_0000  0x00    0    
  21075	:  0000_0001  0x01    1    
  21076	:  0000_0000  0x00    0    
  21077	:  0000_0001  0x01    1    
  21078	:  0000_0000  0x00    0    
  21079	:  0000_0000  0x00    0    
  21080	:  0010_1010  0x2A   42  *  
  21081	:  0011_0000  0x30   48  0  
  21082	:  0000_0000  0x00    0    
  21083	:  0000_0100  0x04    4    
  21084	:  0010_1101  0x2D   45  -  
  21085	:  0100_0011  0x43   67  C  
  21086	:  0011_0101  0x35   53  5  
  21087	:  0100_1001  0x49   73  I  
  21088	:  0000_1000  0x08    8    
  21089	:  0100_0001  0x41   65  A  
  21090	:  0010_1101  0x2D   45  -  
  21091	:  0011_0101  0x35   53  5  
  21092	:  0011_0011  0x33   51  3  
  21093	:  0010_1101  0x2D   45  -  
  21094	:  0011_0000  0x30   48  0  
  21095	:  0011_0111  0x37   55  7  
  21096	:  0011_0100  0x34   52  4  
  21097	:  1100_0000  0xC0  192    
  21098	:  0000_1100  0x0C   12    
  21099	:  0000_0000  0x00    0    
  21100	:  0000_0001  0x01    1    
  21101	:  0000_0000  0x00    0    
  21102	:  0000_0001  0x01    1    
  21103	:  0000_0000  0x00    0    
  21104	:  0000_0000  0x00    0    
  21105	:  0010_1010  0x2A   42  *  
  21106	:  0011_0000  0x30   48  0  
  21107	:  0000_0000  0x00    0    
  21108	:  0000_0100  0x04    4    
  21109	:  0010_1101  0x2D   45  -  
  21110	:  0100_0011  0x43   67  C  
  21111	:  0011_0101  0x35   53  5  
  21112	:  0100_1010  0x4A   74  J  
  21113	:  0000_1000  0x08    8    
  21114	:  0100_0001  0x41   65  A  
  21115	:  0010_1101  0x2D   45  -  
  21116	:  0011_0101  0x35   53  5  
  21117	:  0011_0011  0x33   51  3  
  21118	:  0010_1101  0x2D   45  -  
  21119	:  0011_0000  0x30   48  0  
  21120	:  0011_0111  0x37   55  7  
  21121	:  0011_0101  0x35   53  5  
  21122	:  1100_0000  0xC0  192    
  21123	:  0000_1100  0x0C   12    
  21124	:  0000_0000  0x00    0    
  21125	:  0000_0001  0x01    1    
  21126	:  0000_0000  0x00    0    
  21127	:  0000_0001  0x01    1    
  21128	:  0000_0000  0x00    0    
  21129	:  0000_0000  0x00    0    
  21130	:  0010_1010  0x2A   42  *  
  21131	:  0011_0000  0x30   48  0  
  21132	:  0000_0000  0x00    0    
  21133	:  0000_0100  0x04    4    
  21134	:  0010_1101  0x2D   45  -  
  21135	:  0100_0011  0x43   67  C  
  21136	:  0011_0101  0x35   53  5  
  21137	:  0100_1011  0x4B   75  K  
  21138	:  0000_1000  0x08    8    
  21139	:  0100_0001  0x41   65  A  
  21140	:  0010_1101  0x2D   45  -  
  21141	:  0011_0101  0x35   53  5  
  21142	:  0011_0011  0x33   51  3  
  21143	:  0010_1101  0x2D   45  -  
  21144	:  0011_0000  0x30   48  0  
  21145	:  0011_0111  0x37   55  7  
  21146	:  0011_0110  0x36   54  6  
  21147	:  1100_0000  0xC0  192    
  21148	:  0000_1100  0x0C   12    
  21149	:  0000_0000  0x00    0    
  21150	:  0000_0001  0x01    1    
  21151	:  0000_0000  0x00    0    
  21152	:  0000_0001  0x01    1    
  21153	:  0000_0000  0x00    0    
  21154	:  0000_0000  0x00    0    
  21155	:  0010_1010  0x2A   42  *  
  21156	:  0011_0000  0x30   48  0  
  21157	:  0000_0000  0x00    0    
  21158	:  0000_0100  0x04    4    
  21159	:  0010_1101  0x2D   45  -  
  21160	:  0100_0011  0x43   67  C  
  21161	:  0011_0101  0x35   53  5  
  21162	:  0100_1100  0x4C   76  L  
  21163	:  0000_1000  0x08    8    
  21164	:  0100_0001  0x41   65  A  
  21165	:  0010_1101  0x2D   45  -  
  21166	:  0011_0101  0x35   53  5  
  21167	:  0011_0011  0x33   51  3  
  21168	:  0010_1101  0x2D   45  -  
  21169	:  0011_0000  0x30   48  0  
  21170	:  0011_0111  0x37   55  7  
  21171	:  0011_0111  0x37   55  7  
  21172	:  1100_0000  0xC0  192    
  21173	:  0000_1100  0x0C   12    
  21174	:  0000_0000  0x00    0    
  21175	:  0000_0001  0x01    1    
  21176	:  0000_0000  0x00    0    
  21177	:  0000_0001  0x01    1    
  21178	:  0000_0000  0x00    0    
  21179	:  0000_0000  0x00    0    
  21180	:  0010_1010  0x2A   42  *  
  21181	:  0011_0000  0x30   48  0  
  21182	:  0000_0000  0x00    0    
  21183	:  0000_0100  0x04    4    
  21184	:  0010_1101  0x2D   45  -  
  21185	:  0100_0011  0x43   67  C  
  21186	:  0011_0101  0x35   53  5  
  21187	:  0100_1101  0x4D   77  M  
  21188	:  0000_1000  0x08    8    
  21189	:  0100_0001  0x41   65  A  
  21190	:  0010_1101  0x2D   45  -  
  21191	:  0011_0101  0x35   53  5  
  21192	:  0011_0011  0x33   51  3  
  21193	:  0010_1101  0x2D   45  -  
  21194	:  0011_0000  0x30   48  0  
  21195	:  0011_0111  0x37   55  7  
  21196	:  0011_1000  0x38   56  8  
  21197	:  1100_0000  0xC0  192    
  21198	:  0000_1100  0x0C   12    
  21199	:  0000_0000  0x00    0    
  21200	:  0000_0001  0x01    1    
  21201	:  0000_0000  0x00    0    
  21202	:  0000_0001  0x01    1    
  21203	:  0000_0000  0x00    0    
  21204	:  0000_0000  0x00    0    
  21205	:  0010_1010  0x2A   42  *  
  21206	:  0011_0000  0x30   48  0  
  21207	:  0000_0000  0x00    0    
  21208	:  0000_0100  0x04    4    
  21209	:  0010_1101  0x2D   45  -  
  21210	:  0100_0011  0x43   67  C  
  21211	:  0011_0101  0x35   53  5  
  21212	:  0100_1110  0x4E   78  N  
  21213	:  0000_1000  0x08    8    
  21214	:  0100_0001  0x41   65  A  
  21215	:  0010_1101  0x2D   45  -  
  21216	:  0011_0101  0x35   53  5  
  21217	:  0011_0011  0x33   51  3  
  21218	:  0010_1101  0x2D   45  -  
  21219	:  0011_0000  0x30   48  0  
  21220	:  0011_0111  0x37   55  7  
  21221	:  0011_1001  0x39   57  9  
  21222	:  1100_0000  0xC0  192    
  21223	:  0000_1100  0x0C   12    
  21224	:  0000_0000  0x00    0    
  21225	:  0000_0001  0x01    1    
  21226	:  0000_0000  0x00    0    
  21227	:  0000_0001  0x01    1    
  21228	:  0000_0000  0x00    0    
  21229	:  0000_0000  0x00    0    
  21230	:  0010_1010  0x2A   42  *  
  21231	:  0011_0000  0x30   48  0  
  21232	:  0000_0000  0x00    0    
  21233	:  0000_0100  0x04    4    
  21234	:  0010_1101  0x2D   45  -  
  21235	:  0100_0011  0x43   67  C  
  21236	:  0011_0101  0x35   53  5  
  21237	:  0100_1111  0x4F   79  O  
  21238	:  0000_1000  0x08    8    
  21239	:  0100_0001  0x41   65  A  
  21240	:  0010_1101  0x2D   45  -  
  21241	:  0011_0101  0x35   53  5  
  21242	:  0011_0011  0x33   51  3  
  21243	:  0010_1101  0x2D   45  -  
  21244	:  0011_0000  0x30   48  0  
  21245	:  0011_1000  0x38   56  8  
  21246	:  0011_0000  0x30   48  0  
  21247	:  1100_0000  0xC0  192    
  21248	:  0000_1100  0x0C   12    
  21249	:  0000_0000  0x00    0    
  21250	:  0000_0001  0x01    1    
  21251	:  0000_0000  0x00    0    
  21252	:  0000_0001  0x01    1    
  21253	:  0000_0000  0x00    0    
  21254	:  0000_0000  0x00    0    
  21255	:  0010_1010  0x2A   42  *  
  21256	:  0011_0000  0x30   48  0  
  21257	:  0000_0000  0x00    0    
  21258	:  0000_0100  0x04    4    
  21259	:  0010_1101  0x2D   45  -  
  21260	:  0100_0011  0x43   67  C  
  21261	:  0011_0101  0x35   53  5  
  21262	:  0101_0000  0x50   80  P  
  21263	:  0000_1000  0x08    8    
  21264	:  0100_0001  0x41   65  A  
  21265	:  0010_1101  0x2D   45  -  
  21266	:  0011_0101  0x35   53  5  
  21267	:  0011_0011  0x33   51  3  
  21268	:  0010_1101  0x2D   45  -  
  21269	:  0011_0000  0x30   48  0  
  21270	:  0011_1000  0x38   56  8  
  21271	:  0011_0001  0x31   49  1  
  21272	:  1100_0000  0xC0  192    
  21273	:  0000_1100  0x0C   12    
  21274	:  0000_0000  0x00    0    
  21275	:  0000_0001  0x01    1    
  21276	:  0000_0000  0x00    0    
  21277	:  0000_0001  0x01    1    
  21278	:  0000_0000  0x00    0    
  21279	:  0000_0000  0x00    0    
  21280	:  0010_1010  0x2A   42  *  
  21281	:  0011_0000  0x30   48  0  
  21282	:  0000_0000  0x00    0    
  21283	:  0000_0100  0x04    4    
  21284	:  0010_1101  0x2D   45  -  
  21285	:  0100_0011  0x43   67  C  
  21286	:  0011_0101  0x35   53  5  
  21287	:  0101_0001  0x51   81  Q  
  21288	:  0000_1000  0x08    8    
  21289	:  0100_0001  0x41   65  A  
  21290	:  0010_1101  0x2D   45  -  
  21291	:  0011_0101  0x35   53  5  
  21292	:  0011_0011  0x33   51  3  
  21293	:  0010_1101  0x2D   45  -  
  21294	:  0011_0000  0x30   48  0  
  21295	:  0011_1000  0x38   56  8  
  21296	:  0011_0010  0x32   50  2  
  21297	:  1100_0000  0xC0  192    
  21298	:  0000_1100  0x0C   12    
  21299	:  0000_0000  0x00    0    
  21300	:  0000_0001  0x01    1    
  21301	:  0000_0000  0x00    0    
  21302	:  0000_0001  0x01    1    
  21303	:  0000_0000  0x00    0    
  21304	:  0000_0000  0x00    0    
  21305	:  0010_1010  0x2A   42  *  
  21306	:  0011_0000  0x30   48  0  
  21307	:  0000_0000  0x00    0    
  21308	:  0000_0100  0x04    4    
  21309	:  0010_1101  0x2D   45  -  
  21310	:  0100_0011  0x43   67  C  
  21311	:  0011_0101  0x35   53  5  
  21312	:  0101_0010  0x52   82  R  
  21313	:  0000_1000  0x08    8    
  21314	:  0100_0001  0x41   65  A  
  21315	:  0010_1101  0x2D   45  -  
  21316	:  0011_0101  0x35   53  5  
  21317	:  0011_0011  0x33   51  3  
  21318	:  0010_1101  0x2D   45  -  
  21319	:  0011_0000  0x30   48  0  
  21320	:  0011_1000  0x38   56  8  
  21321	:  0011_0011  0x33   51  3  
  21322	:  1100_0000  0xC0  192    
  21323	:  0000_1100  0x0C   12    
  21324	:  0000_0000  0x00    0    
  21325	:  0000_0001  0x01    1    
  21326	:  0000_0000  0x00    0    
  21327	:  0000_0001  0x01    1    
  21328	:  0000_0000  0x00    0    
  21329	:  0000_0000  0x00    0    
  21330	:  0010_1010  0x2A   42  *  
  21331	:  0011_0000  0x30   48  0  
  21332	:  0000_0000  0x00    0    
  21333	:  0000_0100  0x04    4    
  21334	:  0010_1101  0x2D   45  -  
  21335	:  0100_0011  0x43   67  C  
  21336	:  0011_0101  0x35   53  5  
  21337	:  0101_0011  0x53   83  S  
  21338	:  0000_1000  0x08    8    
  21339	:  0100_0001  0x41   65  A  
  21340	:  0010_1101  0x2D   45  -  
  21341	:  0011_0101  0x35   53  5  
  21342	:  0011_0011  0x33   51  3  
  21343	:  0010_1101  0x2D   45  -  
  21344	:  0011_0000  0x30   48  0  
  21345	:  0011_1000  0x38   56  8  
  21346	:  0011_0100  0x34   52  4  
  21347	:  1100_0000  0xC0  192    
  21348	:  0000_1100  0x0C   12    
  21349	:  0000_0000  0x00    0    
  21350	:  0000_0001  0x01    1    
  21351	:  0000_0000  0x00    0    
  21352	:  0000_0001  0x01    1    
  21353	:  0000_0000  0x00    0    
  21354	:  0000_0000  0x00    0    
  21355	:  0010_1010  0x2A   42  *  
  21356	:  0011_0000  0x30   48  0  
  21357	:  0000_0000  0x00    0    
  21358	:  0000_0100  0x04    4    
  21359	:  0010_1101  0x2D   45  -  
  21360	:  0100_0011  0x43   67  C  
  21361	:  0011_0101  0x35   53  5  
  21362	:  0101_0100  0x54   84  T  
  21363	:  0000_1000  0x08    8    
  21364	:  0100_0001  0x41   65  A  
  21365	:  0010_1101  0x2D   45  -  
  21366	:  0011_0101  0x35   53  5  
  21367	:  0011_0011  0x33   51  3  
  21368	:  0010_1101  0x2D   45  -  
  21369	:  0011_0000  0x30   48  0  
  21370	:  0011_1000  0x38   56  8  
  21371	:  0011_0101  0x35   53  5  
  21372	:  1100_0000  0xC0  192    
  21373	:  0000_1100  0x0C   12    
  21374	:  0000_0000  0x00    0    
  21375	:  0000_0001  0x01    1    
  21376	:  0000_0000  0x00    0    
  21377	:  0000_0001  0x01    1    
  21378	:  0000_0000  0x00    0    
  21379	:  0000_0000  0x00    0    
  21380	:  0010_1010  0x2A   42  *  
  21381	:  0011_0000  0x30   48  0  
  21382	:  0000_0000  0x00    0    
  21383	:  0000_0100  0x04    4    
  21384	:  0010_1101  0x2D   45  -  
  21385	:  0100_0011  0x43   67  C  
  21386	:  0011_0101  0x35   53  5  
  21387	:  0101_0101  0x55   85  U  
  21388	:  0000_1000  0x08    8    
  21389	:  0100_0001  0x41   65  A  
  21390	:  0010_1101  0x2D   45  -  
  21391	:  0011_0101  0x35   53  5  
  21392	:  0011_0011  0x33   51  3  
  21393	:  0010_1101  0x2D   45  -  
  21394	:  0011_0000  0x30   48  0  
  21395	:  0011_1000  0x38   56  8  
  21396	:  0011_0110  0x36   54  6  
  21397	:  1100_0000  0xC0  192    
  21398	:  0000_1100  0x0C   12    
  21399	:  0000_0000  0x00    0    
  21400	:  0000_0001  0x01    1    
  21401	:  0000_0000  0x00    0    
  21402	:  0000_0001  0x01    1    
  21403	:  0000_0000  0x00    0    
  21404	:  0000_0000  0x00    0    
  21405	:  0010_1010  0x2A   42  *  
  21406	:  0011_0000  0x30   48  0  
  21407	:  0000_0000  0x00    0    
  21408	:  0000_0100  0x04    4    
  21409	:  0010_1101  0x2D   45  -  
  21410	:  0100_0011  0x43   67  C  
  21411	:  0011_0101  0x35   53  5  
  21412	:  0101_0110  0x56   86  V  
  21413	:  0000_1000  0x08    8    
  21414	:  0100_0001  0x41   65  A  
  21415	:  0010_1101  0x2D   45  -  
  21416	:  0011_0101  0x35   53  5  
  21417	:  0011_0011  0x33   51  3  
  21418	:  0010_1101  0x2D   45  -  
  21419	:  0011_0000  0x30   48  0  
  21420	:  0011_1000  0x38   56  8  
  21421	:  0011_0111  0x37   55  7  
  21422	:  1100_0000  0xC0  192    
  21423	:  0000_1100  0x0C   12    
  21424	:  0000_0000  0x00    0    
  21425	:  0000_0001  0x01    1    
  21426	:  0000_0000  0x00    0    
  21427	:  0000_0001  0x01    1    
  21428	:  0000_0000  0x00    0    
  21429	:  0000_0000  0x00    0    
  21430	:  0010_1010  0x2A   42  *  
  21431	:  0011_0000  0x30   48  0  
  21432	:  0000_0000  0x00    0    
  21433	:  0000_0100  0x04    4    
  21434	:  0010_1101  0x2D   45  -  
  21435	:  0100_0011  0x43   67  C  
  21436	:  0011_0101  0x35   53  5  
  21437	:  0101_0111  0x57   87  W  
  21438	:  0000_1000  0x08    8    
  21439	:  0100_0001  0x41   65  A  
  21440	:  0010_1101  0x2D   45  -  
  21441	:  0011_0101  0x35   53  5  
  21442	:  0011_0011  0x33   51  3  
  21443	:  0010_1101  0x2D   45  -  
  21444	:  0011_0000  0x30   48  0  
  21445	:  0011_1000  0x38   56  8  
  21446	:  0011_1000  0x38   56  8  
  21447	:  1100_0000  0xC0  192    
  21448	:  0000_1100  0x0C   12    
  21449	:  0000_0000  0x00    0    
  21450	:  0000_0001  0x01    1    
  21451	:  0000_0000  0x00    0    
  21452	:  0000_0001  0x01    1    
  21453	:  0000_0000  0x00    0    
  21454	:  0000_0000  0x00    0    
  21455	:  0010_1010  0x2A   42  *  
  21456	:  0011_0000  0x30   48  0  
  21457	:  0000_0000  0x00    0    
  21458	:  0000_0100  0x04    4    
  21459	:  0010_1101  0x2D   45  -  
  21460	:  0100_0011  0x43   67  C  
  21461	:  0011_0101  0x35   53  5  
  21462	:  0101_1000  0x58   88  X  
  21463	:  0000_1000  0x08    8    
  21464	:  0100_0001  0x41   65  A  
  21465	:  0010_1101  0x2D   45  -  
  21466	:  0011_0101  0x35   53  5  
  21467	:  0011_0011  0x33   51  3  
  21468	:  0010_1101  0x2D   45  -  
  21469	:  0011_0000  0x30   48  0  
  21470	:  0011_1000  0x38   56  8  
  21471	:  0011_1001  0x39   57  9  
  21472	:  1100_0000  0xC0  192    
  21473	:  0000_1100  0x0C   12    
  21474	:  0000_0000  0x00    0    
  21475	:  0000_0001  0x01    1    
  21476	:  0000_0000  0x00    0    
  21477	:  0000_0001  0x01    1    
  21478	:  0000_0000  0x00    0    
  21479	:  0000_0000  0x00    0    
  21480	:  0010_1010  0x2A   42  *  
  21481	:  0011_0000  0x30   48  0  
  21482	:  0000_0000  0x00    0    
  21483	:  0000_0100  0x04    4    
  21484	:  0010_1101  0x2D   45  -  
  21485	:  0100_0011  0x43   67  C  
  21486	:  0011_0101  0x35   53  5  
  21487	:  0101_1001  0x59   89  Y  
  21488	:  0000_1000  0x08    8    
  21489	:  0100_0001  0x41   65  A  
  21490	:  0010_1101  0x2D   45  -  
  21491	:  0011_0101  0x35   53  5  
  21492	:  0011_0011  0x33   51  3  
  21493	:  0010_1101  0x2D   45  -  
  21494	:  0011_0000  0x30   48  0  
  21495	:  0011_1001  0x39   57  9  
  21496	:  0011_0000  0x30   48  0  
  21497	:  1100_0000  0xC0  192    
  21498	:  0000_1100  0x0C   12    
  21499	:  0000_0000  0x00    0    
  21500	:  0000_0001  0x01    1    
  21501	:  0000_0000  0x00    0    
  21502	:  0000_0001  0x01    1    
  21503	:  0000_0000  0x00    0    
  21504	:  0000_0000  0x00    0    
  21505	:  0010_1010  0x2A   42  *  
  21506	:  0011_0000  0x30   48  0  
  21507	:  0000_0000  0x00    0    
  21508	:  0000_0100  0x04    4    
  21509	:  0010_1101  0x2D   45  -  
  21510	:  0100_0011  0x43   67  C  
  21511	:  0011_0101  0x35   53  5  
  21512	:  0101_1010  0x5A   90  Z  
  21513	:  0000_1000  0x08    8    
  21514	:  0100_0001  0x41   65  A  
  21515	:  0010_1101  0x2D   45  -  
  21516	:  0011_0101  0x35   53  5  
  21517	:  0011_0011  0x33   51  3  
  21518	:  0010_1101  0x2D   45  -  
  21519	:  0011_0000  0x30   48  0  
  21520	:  0011_1001  0x39   57  9  
  21521	:  0011_0001  0x31   49  1  
  21522	:  1100_0000  0xC0  192    
  21523	:  0000_1100  0x0C   12    
  21524	:  0000_0000  0x00    0    
  21525	:  0000_0001  0x01    1    
  21526	:  0000_0000  0x00    0    
  21527	:  0000_0001  0x01    1    
  21528	:  0000_0000  0x00    0    
  21529	:  0000_0000  0x00    0    
  21530	:  0010_1010  0x2A   42  *  
  21531	:  0011_0000  0x30   48  0  
  21532	:  0000_0000  0x00    0    
  21533	:  0000_0100  0x04    4    
  21534	:  0010_1101  0x2D   45  -  
  21535	:  0100_0011  0x43   67  C  
  21536	:  0011_0101  0x35   53  5  
  21537	:  0101_1011  0x5B   91  [  
  21538	:  0000_1000  0x08    8    
  21539	:  0100_0001  0x41   65  A  
  21540	:  0010_1101  0x2D   45  -  
  21541	:  0011_0101  0x35   53  5  
  21542	:  0011_0011  0x33   51  3  
  21543	:  0010_1101  0x2D   45  -  
  21544	:  0011_0000  0x30   48  0  
  21545	:  0011_1001  0x39   57  9  
  21546	:  0011_0010  0x32   50  2  
  21547	:  1100_0000  0xC0  192    
  21548	:  0000_1100  0x0C   12    
  21549	:  0000_0000  0x00    0    
  21550	:  0000_0001  0x01    1    
  21551	:  0000_0000  0x00    0    
  21552	:  0000_0001  0x01    1    
  21553	:  0000_0000  0x00    0    
  21554	:  0000_0000  0x00    0    
  21555	:  0010_1010  0x2A   42  *  
  21556	:  0011_0000  0x30   48  0  
  21557	:  0000_0000  0x00    0    
  21558	:  0000_0100  0x04    4    
  21559	:  0010_1101  0x2D   45  -  
  21560	:  0100_0011  0x43   67  C  
  21561	:  0011_0101  0x35   53  5  
  21562	:  0101_1100  0x5C   92  \  
  21563	:  0000_1000  0x08    8    
  21564	:  0100_0001  0x41   65  A  
  21565	:  0010_1101  0x2D   45  -  
  21566	:  0011_0101  0x35   53  5  
  21567	:  0011_0011  0x33   51  3  
  21568	:  0010_1101  0x2D   45  -  
  21569	:  0011_0000  0x30   48  0  
  21570	:  0011_1001  0x39   57  9  
  21571	:  0011_0011  0x33   51  3  
  21572	:  1100_0000  0xC0  192    
  21573	:  0000_1100  0x0C   12    
  21574	:  0000_0000  0x00    0    
  21575	:  0000_0001  0x01    1    
  21576	:  0000_0000  0x00    0    
  21577	:  0000_0001  0x01    1    
  21578	:  0000_0000  0x00    0    
  21579	:  0000_0000  0x00    0    
  21580	:  0010_1010  0x2A   42  *  
  21581	:  0011_0000  0x30   48  0  
  21582	:  0000_0000  0x00    0    
  21583	:  0000_0100  0x04    4    
  21584	:  0010_1101  0x2D   45  -  
  21585	:  0100_0011  0x43   67  C  
  21586	:  0011_0101  0x35   53  5  
  21587	:  0101_1101  0x5D   93  ]  
  21588	:  0000_1000  0x08    8    
  21589	:  0100_0001  0x41   65  A  
  21590	:  0010_1101  0x2D   45  -  
  21591	:  0011_0101  0x35   53  5  
  21592	:  0011_0011  0x33   51  3  
  21593	:  0010_1101  0x2D   45  -  
  21594	:  0011_0000  0x30   48  0  
  21595	:  0011_1001  0x39   57  9  
  21596	:  0011_0100  0x34   52  4  
  21597	:  1100_0000  0xC0  192    
  21598	:  0000_1100  0x0C   12    
  21599	:  0000_0000  0x00    0    
  21600	:  0000_0001  0x01    1    
  21601	:  0000_0000  0x00    0    
  21602	:  0000_0001  0x01    1    
  21603	:  0000_0000  0x00    0    
  21604	:  0000_0000  0x00    0    
  21605	:  0010_1010  0x2A   42  *  
  21606	:  0011_0000  0x30   48  0  
  21607	:  0000_0000  0x00    0    
  21608	:  0000_0100  0x04    4    
  21609	:  0010_1101  0x2D   45  -  
  21610	:  0100_0011  0x43   67  C  
  21611	:  0011_0101  0x35   53  5  
  21612	:  0101_1110  0x5E   94  ^  
  21613	:  0000_1000  0x08    8    
  21614	:  0100_0001  0x41   65  A  
  21615	:  0010_1101  0x2D   45  -  
  21616	:  0011_0101  0x35   53  5  
  21617	:  0011_0011  0x33   51  3  
  21618	:  0010_1101  0x2D   45  -  
  21619	:  0011_0000  0x30   48  0  
  21620	:  0011_1001  0x39   57  9  
  21621	:  0011_0101  0x35   53  5  
  21622	:  1100_0000  0xC0  192    
  21623	:  0000_1100  0x0C   12    
  21624	:  0000_0000  0x00    0    
  21625	:  0000_0001  0x01    1    
  21626	:  0000_0000  0x00    0    
  21627	:  0000_0001  0x01    1    
  21628	:  0000_0000  0x00    0    
  21629	:  0000_0000  0x00    0    
  21630	:  0010_1010  0x2A   42  *  
  21631	:  0011_0000  0x30   48  0  
  21632	:  0000_0000  0x00    0    
  21633	:  0000_0100  0x04    4    
  21634	:  0010_1101  0x2D   45  -  
  21635	:  0100_0011  0x43   67  C  
  21636	:  0011_0101  0x35   53  5  
  21637	:  0101_1111  0x5F   95  _  
  21638	:  0000_1000  0x08    8    
  21639	:  0100_0001  0x41   65  A  
  21640	:  0010_1101  0x2D   45  -  
  21641	:  0011_0101  0x35   53  5  
  21642	:  0011_0011  0x33   51  3  
  21643	:  0010_1101  0x2D   45  -  
  21644	:  0011_0000  0x30   48  0  
  21645	:  0011_1001  0x39   57  9  
  21646	:  0011_0110  0x36   54  6  
  21647	:  1100_0000  0xC0  192    
  21648	:  0000_1100  0x0C   12    
  21649	:  0000_0000  0x00    0    
  21650	:  0000_0001  0x01    1    
  21651	:  0000_0000  0x00    0    
  21652	:  0000_0001  0x01    1    
  21653	:  0000_0000  0x00    0    
  21654	:  0000_0000  0x00    0    
  21655	:  0010_1010  0x2A   42  *  
  21656	:  0011_0000  0x30   48  0  
  21657	:  0000_0000  0x00    0    
  21658	:  0000_0100  0x04    4    
  21659	:  0010_1101  0x2D   45  -  
  21660	:  0100_0011  0x43   67  C  
  21661	:  0011_0101  0x35   53  5  
  21662	:  0110_0000  0x60   96  `  
  21663	:  0000_1000  0x08    8    
  21664	:  0100_0001  0x41   65  A  
  21665	:  0010_1101  0x2D   45  -  
  21666	:  0011_0101  0x35   53  5  
  21667	:  0011_0011  0x33   51  3  
  21668	:  0010_1101  0x2D   45  -  
  21669	:  0011_0000  0x30   48  0  
  21670	:  0011_1001  0x39   57  9  
  21671	:  0011_0111  0x37   55  7  
  21672	:  1100_0000  0xC0  192    
  21673	:  0000_1100  0x0C   12    
  21674	:  0000_0000  0x00    0    
  21675	:  0000_0001  0x01    1    
  21676	:  0000_0000  0x00    0    
  21677	:  0000_0001  0x01    1    
  21678	:  0000_0000  0x00    0    
  21679	:  0000_0000  0x00    0    
  21680	:  0010_1010  0x2A   42  *  
  21681	:  0011_0000  0x30   48  0  
  21682	:  0000_0000  0x00    0    
  21683	:  0000_0100  0x04    4    
  21684	:  0010_1101  0x2D   45  -  
  21685	:  0100_0011  0x43   67  C  
  21686	:  0011_0101  0x35   53  5  
  21687	:  0110_0001  0x61   97  a  
  21688	:  0000_1000  0x08    8    
  21689	:  0100_0001  0x41   65  A  
  21690	:  0010_1101  0x2D   45  -  
  21691	:  0011_0101  0x35   53  5  
  21692	:  0011_0011  0x33   51  3  
  21693	:  0010_1101  0x2D   45  -  
  21694	:  0011_0000  0x30   48  0  
  21695	:  0011_1001  0x39   57  9  
  21696	:  0011_1000  0x38   56  8  
  21697	:  1100_0000  0xC0  192    
  21698	:  0000_1100  0x0C   12    
  21699	:  0000_0000  0x00    0    
  21700	:  0000_0001  0x01    1    
  21701	:  0000_0000  0x00    0    
  21702	:  0000_0001  0x01    1    
  21703	:  0000_0000  0x00    0    
  21704	:  0000_0000  0x00    0    
  21705	:  0010_1010  0x2A   42  *  
  21706	:  0011_0000  0x30   48  0  
  21707	:  0000_0000  0x00    0    
  21708	:  0000_0100  0x04    4    
  21709	:  0010_1101  0x2D   45  -  
  21710	:  0100_0011  0x43   67  C  
  21711	:  0011_0101  0x35   53  5  
  21712	:  0110_0010  0x62   98  b  
  21713	:  0000_1000  0x08    8    
  21714	:  0100_0001  0x41   65  A  
  21715	:  0010_1101  0x2D   45  -  
  21716	:  0011_0101  0x35   53  5  
  21717	:  0011_0011  0x33   51  3  
  21718	:  0010_1101  0x2D   45  -  
  21719	:  0011_0000  0x30   48  0  
  21720	:  0011_1001  0x39   57  9  
  21721	:  0011_1001  0x39   57  9  
  21722	:  1100_0000  0xC0  192    
  21723	:  0000_1100  0x0C   12    
  21724	:  0000_0000  0x00    0    
  21725	:  0000_0001  0x01    1    
  21726	:  0000_0000  0x00    0    
  21727	:  0000_0001  0x01    1    
  21728	:  0000_0000  0x00    0    
  21729	:  0000_0000  0x00    0    
  21730	:  0010_1010  0x2A   42  *  
  21731	:  0011_0000  0x30   48  0  
  21732	:  0000_0000  0x00    0    
  21733	:  0000_0100  0x04    4    
  21734	:  0010_1101  0x2D   45  -  
  21735	:  0100_0011  0x43   67  C  
  21736	:  0011_0101  0x35   53  5  
  21737	:  0110_0011  0x63   99  c  
  21738	:  0000_1000  0x08    8    
  21739	:  0100_0001  0x41   65  A  
  21740	:  0010_1101  0x2D   45  -  
  21741	:  0011_0101  0x35   53  5  
  21742	:  0011_0011  0x33   51  3  
  21743	:  0010_1101  0x2D   45  -  
  21744	:  0011_0001  0x31   49  1  
  21745	:  0011_0000  0x30   48  0  
  21746	:  0011_0000  0x30   48  0  
  21747	:  1100_0000  0xC0  192    
  21748	:  0000_1100  0x0C   12    
  21749	:  0000_0000  0x00    0    
  21750	:  0000_0001  0x01    1    
  21751	:  0000_0000  0x00    0    
  21752	:  0000_0001  0x01    1    
  21753	:  0000_0000  0x00    0    
  21754	:  0000_0000  0x00    0    
  21755	:  0010_1010  0x2A   42  *  
  21756	:  0011_0000  0x30   48  0  
  21757	:  0000_0000  0x00    0    
  21758	:  0000_0100  0x04    4    
  21759	:  0010_1101  0x2D   45  -  
  21760	:  0100_0011  0x43   67  C  
  21761	:  0011_0101  0x35   53  5  
  21762	:  0110_0100  0x64  100  d  
  21763	:  0000_1000  0x08    8    
  21764	:  0100_0001  0x41   65  A  
  21765	:  0010_1101  0x2D   45  -  
  21766	:  0011_0101  0x35   53  5  
  21767	:  0011_0011  0x33   51  3  
  21768	:  0010_1101  0x2D   45  -  
  21769	:  0011_0001  0x31   49  1  
  21770	:  0011_0000  0x30   48  0  
  21771	:  0011_0001  0x31   49  1  
  21772	:  1100_0000  0xC0  192    
  21773	:  0000_1100  0x0C   12    
  21774	:  0000_0000  0x00    0    
  21775	:  0000_0001  0x01    1    
  21776	:  0000_0000  0x00    0    
  21777	:  0000_0001  0x01    1    
  21778	:  0000_0000  0x00    0    
  21779	:  0000_0000  0x00    0    
  21780	:  0010_1010  0x2A   42  *  
  21781	:  0011_0000  0x30   48  0  
  21782	:  0000_0000  0x00    0    
  21783	:  0000_0100  0x04    4    
  21784	:  0010_1101  0x2D   45  -  
  21785	:  0100_0011  0x43   67  C  
  21786	:  0011_0101  0x35   53  5  
  21787	:  0110_0101  0x65  101  e  
  21788	:  0000_1000  0x08    8    
  21789	:  0100_0001  0x41   65  A  
  21790	:  0010_1101  0x2D   45  -  
  21791	:  0011_0101  0x35   53  5  
  21792	:  0011_0011  0x33   51  3  
  21793	:  0010_1101  0x2D   45  -  
  21794	:  0011_0001  0x31   49  1  
  21795	:  0011_0000  0x30   48  0  
  21796	:  0011_0010  0x32   50  2  
  21797	:  1100_0000  0xC0  192    
  21798	:  0000_1100  0x0C   12    
  21799	:  0000_0000  0x00    0    
  21800	:  0000_0001  0x01    1    
  21801	:  0000_0000  0x00    0    
  21802	:  0000_0001  0x01    1    
  21803	:  0000_0000  0x00    0    
  21804	:  0000_0000  0x00    0    
  21805	:  0010_1010  0x2A   42  *  
  21806	:  0011_0000  0x30   48  0  
  21807	:  0000_0000  0x00    0    
  21808	:  0000_0100  0x04    4    
  21809	:  0010_1101  0x2D   45  -  
  21810	:  0100_0011  0x43   67  C  
  21811	:  0011_0101  0x35   53  5  
  21812	:  0110_0110  0x66  102  f  
  21813	:  0000_1000  0x08    8    
  21814	:  0100_0001  0x41   65  A  
  21815	:  0010_1101  0x2D   45  -  
  21816	:  0011_0101  0x35   53  5  
  21817	:  0011_0011  0x33   51  3  
  21818	:  0010_1101  0x2D   45  -  
  21819	:  0011_0001  0x31   49  1  
  21820	:  0011_0000  0x30   48  0  
  21821	:  0011_0011  0x33   51  3  
  21822	:  1100_0000  0xC0  192    
  21823	:  0000_1100  0x0C   12    
  21824	:  0000_0000  0x00    0    
  21825	:  0000_0001  0x01    1    
  21826	:  0000_0000  0x00    0    
  21827	:  0000_0001  0x01    1    
  21828	:  0000_0000  0x00    0    
  21829	:  0000_0000  0x00    0    
  21830	:  0010_1010  0x2A   42  *  
  21831	:  0011_0000  0x30   48  0  
  21832	:  0000_0000  0x00    0    
  21833	:  0000_0100  0x04    4    
  21834	:  0010_1101  0x2D   45  -  
  21835	:  0100_0011  0x43   67  C  
  21836	:  0011_0101  0x35   53  5  
  21837	:  0110_0111  0x67  103  g  
  21838	:  0000_1000  0x08    8    
  21839	:  0100_0001  0x41   65  A  
  21840	:  0010_1101  0x2D   45  -  
  21841	:  0011_0101  0x35   53  5  
  21842	:  0011_0011  0x33   51  3  
  21843	:  0010_1101  0x2D   45  -  
  21844	:  0011_0001  0x31   49  1  
  21845	:  0011_0000  0x30   48  0  
  21846	:  0011_0100  0x34   52  4  
  21847	:  1100_0000  0xC0  192    
  21848	:  0000_1100  0x0C   12    
  21849	:  0000_0000  0x00    0    
  21850	:  0000_0001  0x01    1    
  21851	:  0000_0000  0x00    0    
  21852	:  0000_0001  0x01    1    
  21853	:  0000_0000  0x00    0    
  21854	:  0000_0000  0x00    0    
  21855	:  0010_1010  0x2A   42  *  
  21856	:  0011_0000  0x30   48  0  
  21857	:  0000_0000  0x00    0    
  21858	:  0000_0100  0x04    4    
  21859	:  0010_1101  0x2D   45  -  
  21860	:  0100_0011  0x43   67  C  
  21861	:  0011_0101  0x35   53  5  
  21862	:  0110_1000  0x68  104  h  
  21863	:  0000_1000  0x08    8    
  21864	:  0100_0001  0x41   65  A  
  21865	:  0010_1101  0x2D   45  -  
  21866	:  0011_0101  0x35   53  5  
  21867	:  0011_0011  0x33   51  3  
  21868	:  0010_1101  0x2D   45  -  
  21869	:  0011_0001  0x31   49  1  
  21870	:  0011_0000  0x30   48  0  
  21871	:  0011_0101  0x35   53  5  
  21872	:  1100_0000  0xC0  192    
  21873	:  0000_1100  0x0C   12    
  21874	:  0000_0000  0x00    0    
  21875	:  0000_0001  0x01    1    
  21876	:  0000_0000  0x00    0    
  21877	:  0000_0001  0x01    1    
  21878	:  0000_0000  0x00    0    
  21879	:  0000_0000  0x00    0    
  21880	:  0010_1010  0x2A   42  *  
  21881	:  0011_0000  0x30   48  0  
  21882	:  0000_0000  0x00    0    
  21883	:  0000_0100  0x04    4    
  21884	:  0010_1101  0x2D   45  -  
  21885	:  0100_0011  0x43   67  C  
  21886	:  0011_0101  0x35   53  5  
  21887	:  0110_1001  0x69  105  i  
  21888	:  0000_1000  0x08    8    
  21889	:  0100_0001  0x41   65  A  
  21890	:  0010_1101  0x2D   45  -  
  21891	:  0011_0101  0x35   53  5  
  21892	:  0011_0011  0x33   51  3  
  21893	:  0010_1101  0x2D   45  -  
  21894	:  0011_0001  0x31   49  1  
  21895	:  0011_0000  0x30   48  0  
  21896	:  0011_0110  0x36   54  6  
  21897	:  1100_0000  0xC0  192    
  21898	:  0000_1100  0x0C   12    
  21899	:  0000_0000  0x00    0    
  21900	:  0000_0001  0x01    1    
  21901	:  0000_0000  0x00    0    
  21902	:  0000_0001  0x01    1    
  21903	:  0000_0000  0x00    0    
  21904	:  0000_0000  0x00    0    
  21905	:  0010_1010  0x2A   42  *  
  21906	:  0011_0000  0x30   48  0  
  21907	:  0000_0000  0x00    0    
  21908	:  0000_0100  0x04    4    
  21909	:  0010_1101  0x2D   45  -  
  21910	:  0100_0011  0x43   67  C  
  21911	:  0011_0101  0x35   53  5  
  21912	:  0110_1010  0x6A  106  j  
  21913	:  0000_1000  0x08    8    
  21914	:  0100_0001  0x41   65  A  
  21915	:  0010_1101  0x2D   45  -  
  21916	:  0011_0101  0x35   53  5  
  21917	:  0011_0011  0x33   51  3  
  21918	:  0010_1101  0x2D   45  -  
  21919	:  0011_0001  0x31   49  1  
  21920	:  0011_0000  0x30   48  0  
  21921	:  0011_0111  0x37   55  7  
  21922	:  1100_0000  0xC0  192    
  21923	:  0000_1100  0x0C   12    
  21924	:  0000_0000  0x00    0    
  21925	:  0000_0001  0x01    1    
  21926	:  0000_0000  0x00    0    
  21927	:  0000_0001  0x01    1    
  21928	:  0000_0000  0x00    0    
  21929	:  0000_0000  0x00    0    
  21930	:  0010_1010  0x2A   42  *  
  21931	:  0011_0000  0x30   48  0  
  21932	:  0000_0000  0x00    0    
  21933	:  0000_0100  0x04    4    
  21934	:  0010_1101  0x2D   45  -  
  21935	:  0100_0011  0x43   67  C  
  21936	:  0011_0101  0x35   53  5  
  21937	:  0110_1011  0x6B  107  k  
  21938	:  0000_1000  0x08    8    
  21939	:  0100_0001  0x41   65  A  
  21940	:  0010_1101  0x2D   45  -  
  21941	:  0011_0101  0x35   53  5  
  21942	:  0011_0011  0x33   51  3  
  21943	:  0010_1101  0x2D   45  -  
  21944	:  0011_0001  0x31   49  1  
  21945	:  0011_0000  0x30   48  0  
  21946	:  0011_1000  0x38   56  8  
  21947	:  1100_0000  0xC0  192    
  21948	:  0000_1100  0x0C   12    
  21949	:  0000_0000  0x00    0    
  21950	:  0000_0001  0x01    1    
  21951	:  0000_0000  0x00    0    
  21952	:  0000_0001  0x01    1    
  21953	:  0000_0000  0x00    0    
  21954	:  0000_0000  0x00    0    
  21955	:  0010_1010  0x2A   42  *  
  21956	:  0011_0000  0x30   48  0  
  21957	:  0000_0000  0x00    0    
  21958	:  0000_0100  0x04    4    
  21959	:  0010_1101  0x2D   45  -  
  21960	:  0100_0011  0x43   67  C  
  21961	:  0011_0101  0x35   53  5  
  21962	:  0110_1100  0x6C  108  l  
  21963	:  0000_1000  0x08    8    
  21964	:  0100_0001  0x41   65  A  
  21965	:  0010_1101  0x2D   45  -  
  21966	:  0011_0101  0x35   53  5  
  21967	:  0011_0011  0x33   51  3  
  21968	:  0010_1101  0x2D   45  -  
  21969	:  0011_0001  0x31   49  1  
  21970	:  0011_0000  0x30   48  0  
  21971	:  0011_1001  0x39   57  9  
  21972	:  1100_0000  0xC0  192    
  21973	:  0000_1100  0x0C   12    
  21974	:  0000_0000  0x00    0    
  21975	:  0000_0001  0x01    1    
  21976	:  0000_0000  0x00    0    
  21977	:  0000_0001  0x01    1    
  21978	:  0000_0000  0x00    0    
  21979	:  0000_0000  0x00    0    
  21980	:  0010_1010  0x2A   42  *  
  21981	:  0011_0000  0x30   48  0  
  21982	:  0000_0000  0x00    0    
  21983	:  0000_0100  0x04    4    
  21984	:  0010_1101  0x2D   45  -  
  21985	:  0100_0011  0x43   67  C  
  21986	:  0011_0101  0x35   53  5  
  21987	:  0110_1101  0x6D  109  m  
  21988	:  0000_1000  0x08    8    
  21989	:  0100_0001  0x41   65  A  
  21990	:  0010_1101  0x2D   45  -  
  21991	:  0011_0101  0x35   53  5  
  21992	:  0011_0011  0x33   51  3  
  21993	:  0010_1101  0x2D   45  -  
  21994	:  0011_0001  0x31   49  1  
  21995	:  0011_0001  0x31   49  1  
  21996	:  0011_0000  0x30   48  0  
  21997	:  1100_0000  0xC0  192    
  21998	:  0000_1100  0x0C   12    
  21999	:  0000_0000  0x00    0    
  22000	:  0000_0001  0x01    1    
  22001	:  0000_0000  0x00    0    
  22002	:  0000_0001  0x01    1    
  22003	:  0000_0000  0x00    0    
  22004	:  0000_0000  0x00    0    
  22005	:  0010_1010  0x2A   42  *  
  22006	:  0011_0000  0x30   48  0  
  22007	:  0000_0000  0x00    0    
  22008	:  0000_0100  0x04    4    
  22009	:  0010_1101  0x2D   45  -  
  22010	:  0100_0011  0x43   67  C  
  22011	:  0011_0101  0x35   53  5  
  22012	:  0110_1110  0x6E  110  n  
  22013	:  0000_1000  0x08    8    
  22014	:  0100_0001  0x41   65  A  
  22015	:  0010_1101  0x2D   45  -  
  22016	:  0011_0101  0x35   53  5  
  22017	:  0011_0011  0x33   51  3  
  22018	:  0010_1101  0x2D   45  -  
  22019	:  0011_0001  0x31   49  1  
  22020	:  0011_0001  0x31   49  1  
  22021	:  0011_0001  0x31   49  1  
  22022	:  1100_0000  0xC0  192    
  22023	:  0000_1100  0x0C   12    
  22024	:  0000_0000  0x00    0    
  22025	:  0000_0001  0x01    1    
  22026	:  0000_0000  0x00    0    
  22027	:  0000_0001  0x01    1    
  22028	:  0000_0000  0x00    0    
  22029	:  0000_0000  0x00    0    
  22030	:  0010_1010  0x2A   42  *  
  22031	:  0011_0000  0x30   48  0  
  22032	:  0000_0000  0x00    0    
  22033	:  0000_0100  0x04    4    
  22034	:  0010_1101  0x2D   45  -  
  22035	:  0100_0011  0x43   67  C  
  22036	:  0011_0101  0x35   53  5  
  22037	:  0110_1111  0x6F  111  o  
  22038	:  0000_1000  0x08    8    
  22039	:  0100_0001  0x41   65  A  
  22040	:  0010_1101  0x2D   45  -  
  22041	:  0011_0101  0x35   53  5  
  22042	:  0011_0011  0x33   51  3  
  22043	:  0010_1101  0x2D   45  -  
  22044	:  0011_0001  0x31   49  1  
  22045	:  0011_0001  0x31   49  1  
  22046	:  0011_0010  0x32   50  2  
  22047	:  1100_0000  0xC0  192    
  22048	:  0000_1100  0x0C   12    
  22049	:  0000_0000  0x00    0    
  22050	:  0000_0001  0x01    1    
  22051	:  0000_0000  0x00    0    
  22052	:  0000_0001  0x01    1    
  22053	:  0000_0000  0x00    0    
  22054	:  0000_0000  0x00    0    
  22055	:  0010_1010  0x2A   42  *  
  22056	:  0011_0000  0x30   48  0  
  22057	:  0000_0000  0x00    0    
  22058	:  0000_0100  0x04    4    
  22059	:  0010_1101  0x2D   45  -  
  22060	:  0100_0011  0x43   67  C  
  22061	:  0011_0101  0x35   53  5  
  22062	:  0111_0000  0x70  112  p  
  22063	:  0000_1000  0x08    8    
  22064	:  0100_0001  0x41   65  A  
  22065	:  0010_1101  0x2D   45  -  
  22066	:  0011_0101  0x35   53  5  
  22067	:  0011_0011  0x33   51  3  
  22068	:  0010_1101  0x2D   45  -  
  22069	:  0011_0001  0x31   49  1  
  22070	:  0011_0001  0x31   49  1  
  22071	:  0011_0011  0x33   51  3  
  22072	:  1100_0000  0xC0  192    
  22073	:  0000_1100  0x0C   12    
  22074	:  0000_0000  0x00    0    
  22075	:  0000_0001  0x01    1    
  22076	:  0000_0000  0x00    0    
  22077	:  0000_0001  0x01    1    
  22078	:  0000_0000  0x00    0    
  22079	:  0000_0000  0x00    0    
  22080	:  0010_1010  0x2A   42  *  
  22081	:  0011_0000  0x30   48  0  
  22082	:  0000_0000  0x00    0    
  22083	:  0000_0100  0x04    4    
  22084	:  0010_1101  0x2D   45  -  
  22085	:  0100_0011  0x43   67  C  
  22086	:  0011_0101  0x35   53  5  
  22087	:  0111_0001  0x71  113  q  
  22088	:  0000_1000  0x08    8    
  22089	:  0100_0001  0x41   65  A  
  22090	:  0010_1101  0x2D   45  -  
  22091	:  0011_0101  0x35   53  5  
  22092	:  0011_0011  0x33   51  3  
  22093	:  0010_1101  0x2D   45  -  
  22094	:  0011_0001  0x31   49  1  
  22095	:  0011_0001  0x31   49  1  
  22096	:  0011_0100  0x34   52  4  
  22097	:  1100_0000  0xC0  192    
  22098	:  0000_1100  0x0C   12    
  22099	:  0000_0000  0x00    0    
  22100	:  0000_0001  0x01    1    
  22101	:  0000_0000  0x00    0    
  22102	:  0000_0001  0x01    1    
  22103	:  0000_0000  0x00    0    
  22104	:  0000_0000  0x00    0    
  22105	:  0010_1010  0x2A   42  *  
  22106	:  0011_0000  0x30   48  0  
  22107	:  0000_0000  0x00    0    
  22108	:  0000_0100  0x04    4    
  22109	:  0010_1101  0x2D   45  -  
  22110	:  0100_0011  0x43   67  C  
  22111	:  0011_0101  0x35   53  5  
  22112	:  0111_0010  0x72  114  r  
  22113	:  0000_1000  0x08    8    
  22114	:  0100_0001  0x41   65  A  
  22115	:  0010_1101  0x2D   45  -  
  22116	:  0011_0101  0x35   53  5  
  22117	:  0011_0011  0x33   51  3  
  22118	:  0010_1101  0x2D   45  -  
  22119	:  0011_0001  0x31   49  1  
  22120	:  0011_0001  0x31   49  1  
  22121	:  0011_0101  0x35   53  5  
  22122	:  1100_0000  0xC0  192    
  22123	:  0000_1100  0x0C   12    
  22124	:  0000_0000  0x00    0    
  22125	:  0000_0001  0x01    1    
  22126	:  0000_0000  0x00    0    
  22127	:  0000_0001  0x01    1    
  22128	:  0000_0000  0x00    0    
  22129	:  0000_0000  0x00    0    
  22130	:  0010_1010  0x2A   42  *  
  22131	:  0011_0000  0x30   48  0  
  22132	:  0000_0000  0x00    0    
  22133	:  0000_0100  0x04    4    
  22134	:  0010_1101  0x2D   45  -  
  22135	:  0100_0011  0x43   67  C  
  22136	:  0011_0101  0x35   53  5  
  22137	:  0111_0011  0x73  115  s  
  22138	:  0000_1000  0x08    8    
  22139	:  0100_0001  0x41   65  A  
  22140	:  0010_1101  0x2D   45  -  
  22141	:  0011_0101  0x35   53  5  
  22142	:  0011_0011  0x33   51  3  
  22143	:  0010_1101  0x2D   45  -  
  22144	:  0011_0001  0x31   49  1  
  22145	:  0011_0001  0x31   49  1  
  22146	:  0011_0110  0x36   54  6  
  22147	:  1100_0000  0xC0  192    
  22148	:  0000_1100  0x0C   12    
  22149	:  0000_0000  0x00    0    
  22150	:  0000_0001  0x01    1    
  22151	:  0000_0000  0x00    0    
  22152	:  0000_0001  0x01    1    
  22153	:  0000_0000  0x00    0    
  22154	:  0000_0000  0x00    0    
  22155	:  0010_1010  0x2A   42  *  
  22156	:  0011_0000  0x30   48  0  
  22157	:  0000_0000  0x00    0    
  22158	:  0000_0100  0x04    4    
  22159	:  0010_1101  0x2D   45  -  
  22160	:  0100_0011  0x43   67  C  
  22161	:  0011_0101  0x35   53  5  
  22162	:  0111_0100  0x74  116  t  
  22163	:  0000_1000  0x08    8    
  22164	:  0100_0001  0x41   65  A  
  22165	:  0010_1101  0x2D   45  -  
  22166	:  0011_0101  0x35   53  5  
  22167	:  0011_0011  0x33   51  3  
  22168	:  0010_1101  0x2D   45  -  
  22169	:  0011_0001  0x31   49  1  
  22170	:  0011_0001  0x31   49  1  
  22171	:  0011_0111  0x37   55  7  
  22172	:  1100_0000  0xC0  192    
  22173	:  0000_1100  0x0C   12    
  22174	:  0000_0000  0x00    0    
  22175	:  0000_0001  0x01    1    
  22176	:  0000_0000  0x00    0    
  22177	:  0000_0001  0x01    1    
  22178	:  0000_0000  0x00    0    
  22179	:  0000_0000  0x00    0    
  22180	:  0010_1010  0x2A   42  *  
  22181	:  0011_0000  0x30   48  0  
  22182	:  0000_0000  0x00    0    
  22183	:  0000_0100  0x04    4    
  22184	:  0010_1101  0x2D   45  -  
  22185	:  0100_0011  0x43   67  C  
  22186	:  0011_0101  0x35   53  5  
  22187	:  0111_0101  0x75  117  u  
  22188	:  0000_1000  0x08    8    
  22189	:  0100_0001  0x41   65  A  
  22190	:  0010_1101  0x2D   45  -  
  22191	:  0011_0101  0x35   53  5  
  22192	:  0011_0011  0x33   51  3  
  22193	:  0010_1101  0x2D   45  -  
  22194	:  0011_0001  0x31   49  1  
  22195	:  0011_0001  0x31   49  1  
  22196	:  0011_1000  0x38   56  8  
  22197	:  1100_0000  0xC0  192    
  22198	:  0000_1100  0x0C   12    
  22199	:  0000_0000  0x00    0    
  22200	:  0000_0001  0x01    1    
  22201	:  0000_0000  0x00    0    
  22202	:  0000_0001  0x01    1    
  22203	:  0000_0000  0x00    0    
  22204	:  0000_0000  0x00    0    
  22205	:  0010_1010  0x2A   42  *  
  22206	:  0011_0000  0x30   48  0  
  22207	:  0000_0000  0x00    0    
  22208	:  0000_0100  0x04    4    
  22209	:  0010_1101  0x2D   45  -  
  22210	:  0100_0011  0x43   67  C  
  22211	:  0011_0101  0x35   53  5  
  22212	:  0111_0110  0x76  118  v  
  22213	:  0000_1000  0x08    8    
  22214	:  0100_0001  0x41   65  A  
  22215	:  0010_1101  0x2D   45  -  
  22216	:  0011_0101  0x35   53  5  
  22217	:  0011_0011  0x33   51  3  
  22218	:  0010_1101  0x2D   45  -  
  22219	:  0011_0001  0x31   49  1  
  22220	:  0011_0001  0x31   49  1  
  22221	:  0011_1001  0x39   57  9  
  22222	:  1100_0000  0xC0  192    
  22223	:  0000_1100  0x0C   12    
  22224	:  0000_0000  0x00    0    
  22225	:  0000_0001  0x01    1    
  22226	:  0000_0000  0x00    0    
  22227	:  0000_0001  0x01    1    
  22228	:  0000_0000  0x00    0    
  22229	:  0000_0000  0x00    0    
  22230	:  0010_1010  0x2A   42  *  
  22231	:  0011_0000  0x30   48  0  
  22232	:  0000_0000  0x00    0    
  22233	:  0000_0100  0x04    4    
  22234	:  0010_1101  0x2D   45  -  
  22235	:  0100_0011  0x43   67  C  
  22236	:  0011_0101  0x35   53  5  
  22237	:  0111_0111  0x77  119  w  
  22238	:  0000_1000  0x08    8    
  22239	:  0100_0001  0x41   65  A  
  22240	:  0010_1101  0x2D   45  -  
  22241	:  0011_0101  0x35   53  5  
  22242	:  0011_0011  0x33   51  3  
  22243	:  0010_1101  0x2D   45  -  
  22244	:  0011_0001  0x31   49  1  
  22245	:  0011_0010  0x32   50  2  
  22246	:  0011_0000  0x30   48  0  
  22247	:  1100_0000  0xC0  192    
  22248	:  0000_1100  0x0C   12    
  22249	:  0000_0000  0x00    0    
  22250	:  0000_0001  0x01    1    
  22251	:  0000_0000  0x00    0    
  22252	:  0000_0001  0x01    1    
  22253	:  0000_0000  0x00    0    
  22254	:  0000_0000  0x00    0    
  22255	:  0010_1010  0x2A   42  *  
  22256	:  0011_0000  0x30   48  0  
  22257	:  0000_0000  0x00    0    
  22258	:  0000_0100  0x04    4    
  22259	:  0010_1101  0x2D   45  -  
  22260	:  0100_0011  0x43   67  C  
  22261	:  0011_0101  0x35   53  5  
  22262	:  0111_1000  0x78  120  x  
  22263	:  0000_1000  0x08    8    
  22264	:  0100_0001  0x41   65  A  
  22265	:  0010_1101  0x2D   45  -  
  22266	:  0011_0101  0x35   53  5  
  22267	:  0011_0011  0x33   51  3  
  22268	:  0010_1101  0x2D   45  -  
  22269	:  0011_0001  0x31   49  1  
  22270	:  0011_0010  0x32   50  2  
  22271	:  0011_0001  0x31   49  1  
  22272	:  1100_0000  0xC0  192    
  22273	:  0000_1100  0x0C   12    
  22274	:  0000_0000  0x00    0    
  22275	:  0000_0001  0x01    1    
  22276	:  0000_0000  0x00    0    
  22277	:  0000_0001  0x01    1    
  22278	:  0000_0000  0x00    0    
  22279	:  0000_0000  0x00    0    
  22280	:  0010_1010  0x2A   42  *  
  22281	:  0011_0000  0x30   48  0  
  22282	:  0000_0000  0x00    0    
  22283	:  0000_0100  0x04    4    
  22284	:  0010_1101  0x2D   45  -  
  22285	:  0100_0011  0x43   67  C  
  22286	:  0011_0101  0x35   53  5  
  22287	:  0111_1001  0x79  121  y  
  22288	:  0000_1000  0x08    8    
  22289	:  0100_0001  0x41   65  A  
  22290	:  0010_1101  0x2D   45  -  
  22291	:  0011_0101  0x35   53  5  
  22292	:  0011_0011  0x33   51  3  
  22293	:  0010_1101  0x2D   45  -  
  22294	:  0011_0001  0x31   49  1  
  22295	:  0011_0010  0x32   50  2  
  22296	:  0011_0010  0x32   50  2  
  22297	:  1100_0000  0xC0  192    
  22298	:  0000_1100  0x0C   12    
  22299	:  0000_0000  0x00    0    
  22300	:  0000_0001  0x01    1    
  22301	:  0000_0000  0x00    0    
  22302	:  0000_0001  0x01    1    
  22303	:  0000_0000  0x00    0    
  22304	:  0000_0000  0x00    0    
  22305	:  0010_1010  0x2A   42  *  
  22306	:  0011_0000  0x30   48  0  
  22307	:  0000_0000  0x00    0    
  22308	:  0000_0100  0x04    4    
  22309	:  0010_1101  0x2D   45  -  
  22310	:  0100_0011  0x43   67  C  
  22311	:  0011_0101  0x35   53  5  
  22312	:  0111_1010  0x7A  122  z  
  22313	:  0000_1000  0x08    8    
  22314	:  0100_0001  0x41   65  A  
  22315	:  0010_1101  0x2D   45  -  
  22316	:  0011_0101  0x35   53  5  
  22317	:  0011_0011  0x33   51  3  
  22318	:  0010_1101  0x2D   45  -  
  22319	:  0011_0001  0x31   49  1  
  22320	:  0011_0010  0x32   50  2  
  22321	:  0011_0011  0x33   51  3  
  22322	:  1100_0000  0xC0  192    
  22323	:  0000_1100  0x0C   12    
  22324	:  0000_0000  0x00    0    
  22325	:  0000_0001  0x01    1    
  22326	:  0000_0000  0x00    0    
  22327	:  0000_0001  0x01    1    
  22328	:  0000_0000  0x00    0    
  22329	:  0000_0000  0x00    0    
  22330	:  0010_1010  0x2A   42  *  
  22331	:  0011_0000  0x30   48  0  
  22332	:  0000_0000  0x00    0    
  22333	:  0000_0100  0x04    4    
  22334	:  0010_1101  0x2D   45  -  
  22335	:  0100_0011  0x43   67  C  
  22336	:  0011_0101  0x35   53  5  
  22337	:  0111_1011  0x7B  123  {  
  22338	:  0000_1000  0x08    8    
  22339	:  0100_0001  0x41   65  A  
  22340	:  0010_1101  0x2D   45  -  
  22341	:  0011_0101  0x35   53  5  
  22342	:  0011_0011  0x33   51  3  
  22343	:  0010_1101  0x2D   45  -  
  22344	:  0011_0001  0x31   49  1  
  22345	:  0011_0010  0x32   50  2  
  22346	:  0011_0100  0x34   52  4  
  22347	:  1100_0000  0xC0  192    
  22348	:  0000_1100  0x0C   12    
  22349	:  0000_0000  0x00    0    
  22350	:  0000_0001  0x01    1    
  22351	:  0000_0000  0x00    0    
  22352	:  0000_0001  0x01    1    
  22353	:  0000_0000  0x00    0    
  22354	:  0000_0000  0x00    0    
  22355	:  0010_1010  0x2A   42  *  
  22356	:  0011_0000  0x30   48  0  
  22357	:  0000_0000  0x00    0    
  22358	:  0000_0100  0x04    4    
  22359	:  0010_1101  0x2D   45  -  
  22360	:  0100_0011  0x43   67  C  
  22361	:  0011_0101  0x35   53  5  
  22362	:  0111_1100  0x7C  124  |.'|'.q|  
  22363	:  0000_1000  0x08    8    
  22364	:  0100_0001  0x41   65  A  
  22365	:  0010_1101  0x2D   45  -  
  22366	:  0011_0101  0x35   53  5  
  22367	:  0011_0011  0x33   51  3  
  22368	:  0010_1101  0x2D   45  -  
  22369	:  0011_0001  0x31   49  1  
  22370	:  0011_0010  0x32   50  2  
  22371	:  0011_0101  0x35   53  5  
  22372	:  1100_0000  0xC0  192    
  22373	:  0000_1100  0x0C   12    
  22374	:  0000_0000  0x00    0    
  22375	:  0000_0001  0x01    1    
  22376	:  0000_0000  0x00    0    
  22377	:  0000_0001  0x01    1    
  22378	:  0000_0000  0x00    0    
  22379	:  0000_0000  0x00    0    
  22380	:  0010_1010  0x2A   42  *  
  22381	:  0011_0000  0x30   48  0  
  22382	:  0000_0000  0x00    0    
  22383	:  0000_0100  0x04    4    
  22384	:  0010_1101  0x2D   45  -  
  22385	:  0100_0011  0x43   67  C  
  22386	:  0011_0101  0x35   53  5  
  22387	:  0111_1101  0x7D  125  }  
  22388	:  0000_1000  0x08    8    
  22389	:  0100_0001  0x41   65  A  
  22390	:  0010_1101  0x2D   45  -  
  22391	:  0011_0101  0x35   53  5  
  22392	:  0011_0011  0x33   51  3  
  22393	:  0010_1101  0x2D   45  -  
  22394	:  0011_0001  0x31   49  1  
  22395	:  0011_0010  0x32   50  2  
  22396	:  0011_0110  0x36   54  6  
  22397	:  1100_0000  0xC0  192    
  22398	:  0000_1100  0x0C   12    
  22399	:  0000_0000  0x00    0    
  22400	:  0000_0001  0x01    1    
  22401	:  0000_0000  0x00    0    
  22402	:  0000_0001  0x01    1    
  22403	:  0000_0000  0x00    0    
  22404	:  0000_0000  0x00    0    
  22405	:  0010_1010  0x2A   42  *  
  22406	:  0011_0000  0x30   48  0  
  22407	:  0000_0000  0x00    0    
  22408	:  0000_0100  0x04    4    
  22409	:  0010_1101  0x2D   45  -  
  22410	:  0100_0011  0x43   67  C  
  22411	:  0011_0101  0x35   53  5  
  22412	:  0111_1110  0x7E  126  ~  
  22413	:  0000_1000  0x08    8    
  22414	:  0100_0001  0x41   65  A  
  22415	:  0010_1101  0x2D   45  -  
  22416	:  0011_0101  0x35   53  5  
  22417	:  0011_0011  0x33   51  3  
  22418	:  0010_1101  0x2D   45  -  
  22419	:  0011_0001  0x31   49  1  
  22420	:  0011_0010  0x32   50  2  
  22421	:  0011_0111  0x37   55  7  
  22422	:  1100_0000  0xC0  192    
  22423	:  0000_1100  0x0C   12    
  22424	:  0000_0000  0x00    0    
  22425	:  0000_0001  0x01    1    
  22426	:  0000_0000  0x00    0    
  22427	:  0000_0001  0x01    1    
  22428	:  0000_0000  0x00    0    
  22429	:  0000_0000  0x00    0    
  22430	:  0010_1010  0x2A   42  *  
  22431	:  0011_0000  0x30   48  0  
  22432	:  0000_0000  0x00    0    
  22433	:  0000_0100  0x04    4    
  22434	:  0010_1101  0x2D   45  -  
  22435	:  0100_0011  0x43   67  C  
  22436	:  0011_0101  0x35   53  5  
  22437	:  0111_1111  0x7F  127    
  22438	:  0000_1000  0x08    8    
  22439	:  0100_0001  0x41   65  A  
  22440	:  0010_1101  0x2D   45  -  
  22441	:  0011_0101  0x35   53  5  
  22442	:  0011_0011  0x33   51  3  
  22443	:  0010_1101  0x2D   45  -  
  22444	:  0011_0001  0x31   49  1  
  22445	:  0011_0010  0x32   50  2  
  22446	:  0011_1000  0x38   56  8  
  22447	:  1100_0000  0xC0  192    
  22448	:  0000_1100  0x0C   12    
  22449	:  0000_0000  0x00    0    
  22450	:  0000_0001  0x01    1    
  22451	:  0000_0000  0x00    0    
  22452	:  0000_0001  0x01    1    
  22453	:  0000_0000  0x00    0    
  22454	:  0000_0000  0x00    0    
  22455	:  0010_1010  0x2A   42  *  
  22456	:  0011_0000  0x30   48  0  
  22457	:  0000_0000  0x00    0    
  22458	:  0000_0100  0x04    4    
  22459	:  0010_1101  0x2D   45  -  
  22460	:  0100_0011  0x43   67  C  
  22461	:  0011_0101  0x35   53  5  
  22462	:  1000_0000  0x80  128    
  22463	:  0000_1000  0x08    8    
  22464	:  0100_0001  0x41   65  A  
  22465	:  0010_1101  0x2D   45  -  
  22466	:  0011_0101  0x35   53  5  
  22467	:  0011_0011  0x33   51  3  
  22468	:  0010_1101  0x2D   45  -  
  22469	:  0011_0001  0x31   49  1  
  22470	:  0011_0010  0x32   50  2  
  22471	:  0011_1001  0x39   57  9  
  22472	:  1100_0000  0xC0  192    
  22473	:  0000_1100  0x0C   12    
  22474	:  0000_0000  0x00    0    
  22475	:  0000_0001  0x01    1    
  22476	:  0000_0000  0x00    0    
  22477	:  0000_0001  0x01    1    
  22478	:  0000_0000  0x00    0    
  22479	:  0000_0000  0x00    0    
  22480	:  0010_1010  0x2A   42  *  
  22481	:  0011_0000  0x30   48  0  
  22482	:  0000_0000  0x00    0    
  22483	:  0000_0100  0x04    4    
  22484	:  0010_1101  0x2D   45  -  
  22485	:  0100_0011  0x43   67  C  
  22486	:  0011_0101  0x35   53  5  
  22487	:  1000_0001  0x81  129    
  22488	:  0000_1000  0x08    8    
  22489	:  0100_0001  0x41   65  A  
  22490	:  0010_1101  0x2D   45  -  
  22491	:  0011_0101  0x35   53  5  
  22492	:  0011_0011  0x33   51  3  
  22493	:  0010_1101  0x2D   45  -  
  22494	:  0011_0001  0x31   49  1  
  22495	:  0011_0011  0x33   51  3  
  22496	:  0011_0000  0x30   48  0  
  22497	:  1100_0000  0xC0  192    
  22498	:  0000_1100  0x0C   12    
  22499	:  0000_0000  0x00    0    
  22500	:  0000_0001  0x01    1    
  22501	:  0000_0000  0x00    0    
  22502	:  0000_0001  0x01    1    
  22503	:  0000_0000  0x00    0    
  22504	:  0000_0000  0x00    0    
  22505	:  0010_1010  0x2A   42  *  
  22506	:  0011_0000  0x30   48  0  
  22507	:  0000_0000  0x00    0    
  22508	:  0000_0100  0x04    4    
  22509	:  0010_1101  0x2D   45  -  
  22510	:  0100_0011  0x43   67  C  
  22511	:  0011_0101  0x35   53  5  
  22512	:  1000_0010  0x82  130    
  22513	:  0000_1000  0x08    8    
  22514	:  0100_0001  0x41   65  A  
  22515	:  0010_1101  0x2D   45  -  
  22516	:  0011_0101  0x35   53  5  
  22517	:  0011_0011  0x33   51  3  
  22518	:  0010_1101  0x2D   45  -  
  22519	:  0011_0001  0x31   49  1  
  22520	:  0011_0011  0x33   51  3  
  22521	:  0011_0001  0x31   49  1  
  22522	:  1100_0000  0xC0  192    
  22523	:  0000_1100  0x0C   12    
  22524	:  0000_0000  0x00    0    
  22525	:  0000_0001  0x01    1    
  22526	:  0000_0000  0x00    0    
  22527	:  0000_0001  0x01    1    
  22528	:  0000_0000  0x00    0    
  22529	:  0000_0000  0x00    0    
  22530	:  0010_1010  0x2A   42  *  
  22531	:  0011_0000  0x30   48  0  
  22532	:  0000_0000  0x00    0    
  22533	:  0000_0100  0x04    4    
  22534	:  0010_1101  0x2D   45  -  
  22535	:  0100_0011  0x43   67  C  
  22536	:  0011_0101  0x35   53  5  
  22537	:  1000_0011  0x83  131    
  22538	:  0000_1000  0x08    8    
  22539	:  0100_0001  0x41   65  A  
  22540	:  0010_1101  0x2D   45  -  
  22541	:  0011_0101  0x35   53  5  
  22542	:  0011_0011  0x33   51  3  
  22543	:  0010_1101  0x2D   45  -  
  22544	:  0011_0001  0x31   49  1  
  22545	:  0011_0011  0x33   51  3  
  22546	:  0011_0010  0x32   50  2  
  22547	:  1100_0000  0xC0  192    
  22548	:  0000_1100  0x0C   12    
  22549	:  0000_0000  0x00    0    
  22550	:  0000_0001  0x01    1    
  22551	:  0000_0000  0x00    0    
  22552	:  0000_0001  0x01    1    
  22553	:  0000_0000  0x00    0    
  22554	:  0000_0000  0x00    0    
  22555	:  0010_1010  0x2A   42  *  
  22556	:  0011_0000  0x30   48  0  
  22557	:  0000_0000  0x00    0    
  22558	:  0000_0100  0x04    4    
  22559	:  0010_1101  0x2D   45  -  
  22560	:  0100_0011  0x43   67  C  
  22561	:  0011_0101  0x35   53  5  
  22562	:  1000_0100  0x84  132    
  22563	:  0000_1000  0x08    8    
  22564	:  0100_0001  0x41   65  A  
  22565	:  0010_1101  0x2D   45  -  
  22566	:  0011_0101  0x35   53  5  
  22567	:  0011_0011  0x33   51  3  
  22568	:  0010_1101  0x2D   45  -  
  22569	:  0011_0001  0x31   49  1  
  22570	:  0011_0011  0x33   51  3  
  22571	:  0011_0011  0x33   51  3  
  22572	:  1100_0000  0xC0  192    
  22573	:  0000_1100  0x0C   12    
  22574	:  0000_0000  0x00    0    
  22575	:  0000_0001  0x01    1    
  22576	:  0000_0000  0x00    0    
  22577	:  0000_0001  0x01    1    
  22578	:  0000_0000  0x00    0    
  22579	:  0000_0000  0x00    0    
  22580	:  0010_1010  0x2A   42  *  
  22581	:  0011_0000  0x30   48  0  
  22582	:  0000_0000  0x00    0    
  22583	:  0000_0100  0x04    4    
  22584	:  0010_1101  0x2D   45  -  
  22585	:  0100_0011  0x43   67  C  
  22586	:  0011_0101  0x35   53  5  
  22587	:  1000_0101  0x85  133    
  22588	:  0000_1000  0x08    8    
  22589	:  0100_0001  0x41   65  A  
  22590	:  0010_1101  0x2D   45  -  
  22591	:  0011_0101  0x35   53  5  
  22592	:  0011_0011  0x33   51  3  
  22593	:  0010_1101  0x2D   45  -  
  22594	:  0011_0001  0x31   49  1  
  22595	:  0011_0011  0x33   51  3  
  22596	:  0011_0100  0x34   52  4  
  22597	:  1100_0000  0xC0  192    
  22598	:  0000_1100  0x0C   12    
  22599	:  0000_0000  0x00    0    
  22600	:  0000_0001  0x01    1    
  22601	:  0000_0000  0x00    0    
  22602	:  0000_0001  0x01    1    
  22603	:  0000_0000  0x00    0    
  22604	:  0000_0000  0x00    0    
  22605	:  0010_1010  0x2A   42  *  
  22606	:  0011_0000  0x30   48  0  
  22607	:  0000_0000  0x00    0    
  22608	:  0000_0100  0x04    4    
  22609	:  0010_1101  0x2D   45  -  
  22610	:  0100_0011  0x43   67  C  
  22611	:  0011_0101  0x35   53  5  
  22612	:  1000_0110  0x86  134    
  22613	:  0000_1000  0x08    8    
  22614	:  0100_0001  0x41   65  A  
  22615	:  0010_1101  0x2D   45  -  
  22616	:  0011_0101  0x35   53  5  
  22617	:  0011_0011  0x33   51  3  
  22618	:  0010_1101  0x2D   45  -  
  22619	:  0011_0001  0x31   49  1  
  22620	:  0011_0011  0x33   51  3  
  22621	:  0011_0101  0x35   53  5  
  22622	:  1100_0000  0xC0  192    
  22623	:  0000_1100  0x0C   12    
  22624	:  0000_0000  0x00    0    
  22625	:  0000_0001  0x01    1    
  22626	:  0000_0000  0x00    0    
  22627	:  0000_0001  0x01    1    
  22628	:  0000_0000  0x00    0    
  22629	:  0000_0000  0x00    0    
  22630	:  0010_1010  0x2A   42  *  
  22631	:  0011_0000  0x30   48  0  
  22632	:  0000_0000  0x00    0    
  22633	:  0000_0100  0x04    4    
  22634	:  0010_1101  0x2D   45  -  
  22635	:  0100_0011  0x43   67  C  
  22636	:  0011_0101  0x35   53  5  
  22637	:  1000_0111  0x87  135    
  22638	:  0000_1000  0x08    8    
  22639	:  0100_0001  0x41   65  A  
  22640	:  0010_1101  0x2D   45  -  
  22641	:  0011_0101  0x35   53  5  
  22642	:  0011_0011  0x33   51  3  
  22643	:  0010_1101  0x2D   45  -  
  22644	:  0011_0001  0x31   49  1  
  22645	:  0011_0011  0x33   51  3  
  22646	:  0011_0110  0x36   54  6  
  22647	:  1100_0000  0xC0  192    
  22648	:  0000_1100  0x0C   12    
  22649	:  0000_0000  0x00    0    
  22650	:  0000_0001  0x01    1    
  22651	:  0000_0000  0x00    0    
  22652	:  0000_0001  0x01    1    
  22653	:  0000_0000  0x00    0    
  22654	:  0000_0000  0x00    0    
  22655	:  0010_1010  0x2A   42  *  
  22656	:  0011_0000  0x30   48  0  
  22657	:  0000_0000  0x00    0    
  22658	:  0000_0100  0x04    4    
  22659	:  0010_1101  0x2D   45  -  
  22660	:  0100_0011  0x43   67  C  
  22661	:  0011_0101  0x35   53  5  
  22662	:  1000_1000  0x88  136    
  22663	:  0000_1000  0x08    8    
  22664	:  0100_0001  0x41   65  A  
  22665	:  0010_1101  0x2D   45  -  
  22666	:  0011_0101  0x35   53  5  
  22667	:  0011_0011  0x33   51  3  
  22668	:  0010_1101  0x2D   45  -  
  22669	:  0011_0001  0x31   49  1  
  22670	:  0011_0011  0x33   51  3  
  22671	:  0011_0111  0x37   55  7  
  22672	:  1100_0000  0xC0  192    
  22673	:  0000_1100  0x0C   12    
  22674	:  0000_0000  0x00    0    
  22675	:  0000_0001  0x01    1    
  22676	:  0000_0000  0x00    0    
  22677	:  0000_0001  0x01    1    
  22678	:  0000_0000  0x00    0    
  22679	:  0000_0000  0x00    0    
  22680	:  0010_1010  0x2A   42  *  
  22681	:  0011_0000  0x30   48  0  
  22682	:  0000_0000  0x00    0    
  22683	:  0000_0100  0x04    4    
  22684	:  0010_1101  0x2D   45  -  
  22685	:  0100_0011  0x43   67  C  
  22686	:  0011_0101  0x35   53  5  
  22687	:  1000_1001  0x89  137    
  22688	:  0000_1000  0x08    8    
  22689	:  0100_0001  0x41   65  A  
  22690	:  0010_1101  0x2D   45  -  
  22691	:  0011_0101  0x35   53  5  
  22692	:  0011_0011  0x33   51  3  
  22693	:  0010_1101  0x2D   45  -  
  22694	:  0011_0001  0x31   49  1  
  22695	:  0011_0011  0x33   51  3  
  22696	:  0011_1000  0x38   56  8  
  22697	:  1100_0000  0xC0  192    
  22698	:  0000_1100  0x0C   12    
  22699	:  0000_0000  0x00    0    
  22700	:  0000_0001  0x01    1    
  22701	:  0000_0000  0x00    0    
  22702	:  0000_0001  0x01    1    
  22703	:  0000_0000  0x00    0    
  22704	:  0000_0000  0x00    0    
  22705	:  0010_1010  0x2A   42  *  
  22706	:  0011_0000  0x30   48  0  
  22707	:  0000_0000  0x00    0    
  22708	:  0000_0100  0x04    4    
  22709	:  0010_1101  0x2D   45  -  
  22710	:  0100_0011  0x43   67  C  
  22711	:  0011_0101  0x35   53  5  
  22712	:  1000_1010  0x8A  138    
  22713	:  0000_1000  0x08    8    
  22714	:  0100_0001  0x41   65  A  
  22715	:  0010_1101  0x2D   45  -  
  22716	:  0011_0101  0x35   53  5  
  22717	:  0011_0011  0x33   51  3  
  22718	:  0010_1101  0x2D   45  -  
  22719	:  0011_0001  0x31   49  1  
  22720	:  0011_0011  0x33   51  3  
  22721	:  0011_1001  0x39   57  9  
  22722	:  1100_0000  0xC0  192    
  22723	:  0000_1100  0x0C   12    
  22724	:  0000_0000  0x00    0    
  22725	:  0000_0001  0x01    1    
  22726	:  0000_0000  0x00    0    
  22727	:  0000_0001  0x01    1    
  22728	:  0000_0000  0x00    0    
  22729	:  0000_0000  0x00    0    
  22730	:  0010_1010  0x2A   42  *  
  22731	:  0011_0000  0x30   48  0  
  22732	:  0000_0000  0x00    0    
  22733	:  0000_0100  0x04    4    
  22734	:  0010_1101  0x2D   45  -  
  22735	:  0100_0011  0x43   67  C  
  22736	:  0011_0101  0x35   53  5  
  22737	:  1000_1011  0x8B  139    
  22738	:  0000_1000  0x08    8    
  22739	:  0100_0001  0x41   65  A  
  22740	:  0010_1101  0x2D   45  -  
  22741	:  0011_0101  0x35   53  5  
  22742	:  0011_0011  0x33   51  3  
  22743	:  0010_1101  0x2D   45  -  
  22744	:  0011_0001  0x31   49  1  
  22745	:  0011_0100  0x34   52  4  
  22746	:  0011_0000  0x30   48  0  
  22747	:  1100_0000  0xC0  192    
  22748	:  0000_1100  0x0C   12    
  22749	:  0000_0000  0x00    0    
  22750	:  0000_0001  0x01    1    
  22751	:  0000_0000  0x00    0    
  22752	:  0000_0001  0x01    1    
  22753	:  0000_0000  0x00    0    
  22754	:  0000_0000  0x00    0    
  22755	:  0010_1010  0x2A   42  *  
  22756	:  0011_0000  0x30   48  0  
  22757	:  0000_0000  0x00    0    
  22758	:  0000_0100  0x04    4    
  22759	:  0010_1101  0x2D   45  -  
  22760	:  0100_0011  0x43   67  C  
  22761	:  0011_0101  0x35   53  5  
  22762	:  1000_1100  0x8C  140    
  22763	:  0000_1000  0x08    8    
  22764	:  0100_0001  0x41   65  A  
  22765	:  0010_1101  0x2D   45  -  
  22766	:  0011_0101  0x35   53  5  
  22767	:  0011_0011  0x33   51  3  
  22768	:  0010_1101  0x2D   45  -  
  22769	:  0011_0001  0x31   49  1  
  22770	:  0011_0100  0x34   52  4  
  22771	:  0011_0001  0x31   49  1  
  22772	:  1100_0000  0xC0  192    
  22773	:  0000_1100  0x0C   12    
  22774	:  0000_0000  0x00    0    
  22775	:  0000_0001  0x01    1    
  22776	:  0000_0000  0x00    0    
  22777	:  0000_0001  0x01    1    
  22778	:  0000_0000  0x00    0    
  22779	:  0000_0000  0x00    0    
  22780	:  0010_1010  0x2A   42  *  
  22781	:  0011_0000  0x30   48  0  
  22782	:  0000_0000  0x00    0    
  22783	:  0000_0100  0x04    4    
  22784	:  0010_1101  0x2D   45  -  
  22785	:  0100_0011  0x43   67  C  
  22786	:  0011_0101  0x35   53  5  
  22787	:  1000_1101  0x8D  141    
  22788	:  0000_1000  0x08    8    
  22789	:  0100_0001  0x41   65  A  
  22790	:  0010_1101  0x2D   45  -  
  22791	:  0011_0101  0x35   53  5  
  22792	:  0011_0011  0x33   51  3  
  22793	:  0010_1101  0x2D   45  -  
  22794	:  0011_0001  0x31   49  1  
  22795	:  0011_0100  0x34   52  4  
  22796	:  0011_0010  0x32   50  2  
  22797	:  1100_0000  0xC0  192    
  22798	:  0000_1100  0x0C   12    
  22799	:  0000_0000  0x00    0    
  22800	:  0000_0001  0x01    1    
  22801	:  0000_0000  0x00    0    
  22802	:  0000_0001  0x01    1    
  22803	:  0000_0000  0x00    0    
  22804	:  0000_0000  0x00    0    
  22805	:  0010_1010  0x2A   42  *  
  22806	:  0011_0000  0x30   48  0  
  22807	:  0000_0000  0x00    0    
  22808	:  0000_0100  0x04    4    
  22809	:  0010_1101  0x2D   45  -  
  22810	:  0100_0011  0x43   67  C  
  22811	:  0011_0101  0x35   53  5  
  22812	:  1000_1110  0x8E  142    
  22813	:  0000_1000  0x08    8    
  22814	:  0100_0001  0x41   65  A  
  22815	:  0010_1101  0x2D   45  -  
  22816	:  0011_0101  0x35   53  5  
  22817	:  0011_0011  0x33   51  3  
  22818	:  0010_1101  0x2D   45  -  
  22819	:  0011_0001  0x31   49  1  
  22820	:  0011_0100  0x34   52  4  
  22821	:  0011_0011  0x33   51  3  
  22822	:  1100_0000  0xC0  192    
  22823	:  0000_1100  0x0C   12    
  22824	:  0000_0000  0x00    0    
  22825	:  0000_0001  0x01    1    
  22826	:  0000_0000  0x00    0    
  22827	:  0000_0001  0x01    1    
  22828	:  0000_0000  0x00    0    
  22829	:  0000_0000  0x00    0    
  22830	:  0010_1010  0x2A   42  *  
  22831	:  0011_0000  0x30   48  0  
  22832	:  0000_0000  0x00    0    
  22833	:  0000_0100  0x04    4    
  22834	:  0010_1101  0x2D   45  -  
  22835	:  0100_0011  0x43   67  C  
  22836	:  0011_0101  0x35   53  5  
  22837	:  1000_1111  0x8F  143    
  22838	:  0000_1000  0x08    8    
  22839	:  0100_0001  0x41   65  A  
  22840	:  0010_1101  0x2D   45  -  
  22841	:  0011_0101  0x35   53  5  
  22842	:  0011_0011  0x33   51  3  
  22843	:  0010_1101  0x2D   45  -  
  22844	:  0011_0001  0x31   49  1  
  22845	:  0011_0100  0x34   52  4  
  22846	:  0011_0100  0x34   52  4  
  22847	:  1100_0000  0xC0  192    
  22848	:  0000_1100  0x0C   12    
  22849	:  0000_0000  0x00    0    
  22850	:  0000_0001  0x01    1    
  22851	:  0000_0000  0x00    0    
  22852	:  0000_0001  0x01    1    
  22853	:  0000_0000  0x00    0    
  22854	:  0000_0000  0x00    0    
  22855	:  0010_1010  0x2A   42  *  
  22856	:  0011_0000  0x30   48  0  
  22857	:  0000_0000  0x00    0    
  22858	:  0000_0100  0x04    4    
  22859	:  0010_1101  0x2D   45  -  
  22860	:  0100_0011  0x43   67  C  
  22861	:  0011_0101  0x35   53  5  
  22862	:  1001_0000  0x90  144    
  22863	:  0000_1000  0x08    8    
  22864	:  0100_0001  0x41   65  A  
  22865	:  0010_1101  0x2D   45  -  
  22866	:  0011_0101  0x35   53  5  
  22867	:  0011_0011  0x33   51  3  
  22868	:  0010_1101  0x2D   45  -  
  22869	:  0011_0001  0x31   49  1  
  22870	:  0011_0100  0x34   52  4  
  22871	:  0011_0101  0x35   53  5  
  22872	:  1100_0000  0xC0  192    
  22873	:  0000_1100  0x0C   12    
  22874	:  0000_0000  0x00    0    
  22875	:  0000_0001  0x01    1    
  22876	:  0000_0000  0x00    0    
  22877	:  0000_0001  0x01    1    
  22878	:  0000_0000  0x00    0    
  22879	:  0000_0000  0x00    0    
  22880	:  0010_1010  0x2A   42  *  
  22881	:  0011_0000  0x30   48  0  
  22882	:  0000_0000  0x00    0    
  22883	:  0000_0100  0x04    4    
  22884	:  0010_1101  0x2D   45  -  
  22885	:  0100_0011  0x43   67  C  
  22886	:  0011_0101  0x35   53  5  
  22887	:  1001_0001  0x91  145    
  22888	:  0000_1000  0x08    8    
  22889	:  0100_0001  0x41   65  A  
  22890	:  0010_1101  0x2D   45  -  
  22891	:  0011_0101  0x35   53  5  
  22892	:  0011_0011  0x33   51  3  
  22893	:  0010_1101  0x2D   45  -  
  22894	:  0011_0001  0x31   49  1  
  22895	:  0011_0100  0x34   52  4  
  22896	:  0011_0110  0x36   54  6  
  22897	:  1100_0000  0xC0  192    
  22898	:  0000_1100  0x0C   12    
  22899	:  0000_0000  0x00    0    
  22900	:  0000_0001  0x01    1    
  22901	:  0000_0000  0x00    0    
  22902	:  0000_0001  0x01    1    
  22903	:  0000_0000  0x00    0    
  22904	:  0000_0000  0x00    0    
  22905	:  0010_1010  0x2A   42  *  
  22906	:  0011_0000  0x30   48  0  
  22907	:  0000_0000  0x00    0    
  22908	:  0000_0100  0x04    4    
  22909	:  0010_1101  0x2D   45  -  
  22910	:  0100_0011  0x43   67  C  
  22911	:  0011_0101  0x35   53  5  
  22912	:  1001_0010  0x92  146    
  22913	:  0000_1000  0x08    8    
  22914	:  0100_0001  0x41   65  A  
  22915	:  0010_1101  0x2D   45  -  
  22916	:  0011_0101  0x35   53  5  
  22917	:  0011_0011  0x33   51  3  
  22918	:  0010_1101  0x2D   45  -  
  22919	:  0011_0001  0x31   49  1  
  22920	:  0011_0100  0x34   52  4  
  22921	:  0011_0111  0x37   55  7  
  22922	:  1100_0000  0xC0  192    
  22923	:  0000_1100  0x0C   12    
  22924	:  0000_0000  0x00    0    
  22925	:  0000_0001  0x01    1    
  22926	:  0000_0000  0x00    0    
  22927	:  0000_0001  0x01    1    
  22928	:  0000_0000  0x00    0    
  22929	:  0000_0000  0x00    0    
  22930	:  0010_1010  0x2A   42  *  
  22931	:  0011_0000  0x30   48  0  
  22932	:  0000_0000  0x00    0    
  22933	:  0000_0100  0x04    4    
  22934	:  0010_1101  0x2D   45  -  
  22935	:  0100_0011  0x43   67  C  
  22936	:  0011_0101  0x35   53  5  
  22937	:  1001_0011  0x93  147    
  22938	:  0000_1000  0x08    8    
  22939	:  0100_0001  0x41   65  A  
  22940	:  0010_1101  0x2D   45  -  
  22941	:  0011_0101  0x35   53  5  
  22942	:  0011_0011  0x33   51  3  
  22943	:  0010_1101  0x2D   45  -  
  22944	:  0011_0001  0x31   49  1  
  22945	:  0011_0100  0x34   52  4  
  22946	:  0011_1000  0x38   56  8  
  22947	:  1100_0000  0xC0  192    
  22948	:  0000_1100  0x0C   12    
  22949	:  0000_0000  0x00    0    
  22950	:  0000_0001  0x01    1    
  22951	:  0000_0000  0x00    0    
  22952	:  0000_0001  0x01    1    
  22953	:  0000_0000  0x00    0    
  22954	:  0000_0000  0x00    0    
  22955	:  0010_1010  0x2A   42  *  
  22956	:  0011_0000  0x30   48  0  
  22957	:  0000_0000  0x00    0    
  22958	:  0000_0100  0x04    4    
  22959	:  0010_1101  0x2D   45  -  
  22960	:  0100_0011  0x43   67  C  
  22961	:  0011_0101  0x35   53  5  
  22962	:  1001_0100  0x94  148    
  22963	:  0000_1000  0x08    8    
  22964	:  0100_0001  0x41   65  A  
  22965	:  0010_1101  0x2D   45  -  
  22966	:  0011_0101  0x35   53  5  
  22967	:  0011_0011  0x33   51  3  
  22968	:  0010_1101  0x2D   45  -  
  22969	:  0011_0001  0x31   49  1  
  22970	:  0011_0100  0x34   52  4  
  22971	:  0011_1001  0x39   57  9  
  22972	:  1100_0000  0xC0  192    
  22973	:  0000_1100  0x0C   12    
  22974	:  0000_0000  0x00    0    
  22975	:  0000_0001  0x01    1    
  22976	:  0000_0000  0x00    0    
  22977	:  0000_0001  0x01    1    
  22978	:  0000_0000  0x00    0    
  22979	:  0000_0000  0x00    0    
  22980	:  0010_1010  0x2A   42  *  
  22981	:  0011_0000  0x30   48  0  
  22982	:  0000_0000  0x00    0    
  22983	:  0000_0100  0x04    4    
  22984	:  0010_1101  0x2D   45  -  
  22985	:  0100_0011  0x43   67  C  
  22986	:  0011_0101  0x35   53  5  
  22987	:  1001_0101  0x95  149    
  22988	:  0000_1000  0x08    8    
  22989	:  0100_0001  0x41   65  A  
  22990	:  0010_1101  0x2D   45  -  
  22991	:  0011_0101  0x35   53  5  
  22992	:  0011_0011  0x33   51  3  
  22993	:  0010_1101  0x2D   45  -  
  22994	:  0011_0001  0x31   49  1  
  22995	:  0011_0101  0x35   53  5  
  22996	:  0011_0000  0x30   48  0  
  22997	:  1100_0000  0xC0  192    
  22998	:  0000_1100  0x0C   12    
  22999	:  0000_0000  0x00    0    
  23000	:  0000_0001  0x01    1    
  23001	:  0000_0000  0x00    0    
  23002	:  0000_0001  0x01    1    
  23003	:  0000_0000  0x00    0    
  23004	:  0000_0000  0x00    0    
  23005	:  0010_1010  0x2A   42  *  
  23006	:  0011_0000  0x30   48  0  
  23007	:  0000_0000  0x00    0    
  23008	:  0000_0100  0x04    4    
  23009	:  0010_1101  0x2D   45  -  
  23010	:  0100_0011  0x43   67  C  
  23011	:  0011_0101  0x35   53  5  
  23012	:  1001_0110  0x96  150    
  23013	:  0000_1000  0x08    8    
  23014	:  0100_0001  0x41   65  A  
  23015	:  0010_1101  0x2D   45  -  
  23016	:  0011_0101  0x35   53  5  
  23017	:  0011_0011  0x33   51  3  
  23018	:  0010_1101  0x2D   45  -  
  23019	:  0011_0001  0x31   49  1  
  23020	:  0011_0101  0x35   53  5  
  23021	:  0011_0001  0x31   49  1  
  23022	:  1100_0000  0xC0  192    
  23023	:  0000_1100  0x0C   12    
  23024	:  0000_0000  0x00    0    
  23025	:  0000_0001  0x01    1    
  23026	:  0000_0000  0x00    0    
  23027	:  0000_0001  0x01    1    
  23028	:  0000_0000  0x00    0    
  23029	:  0000_0000  0x00    0    
  23030	:  0010_1010  0x2A   42  *  
  23031	:  0011_0000  0x30   48  0  
  23032	:  0000_0000  0x00    0    
  23033	:  0000_0100  0x04    4    
  23034	:  0010_1101  0x2D   45  -  
  23035	:  0100_0011  0x43   67  C  
  23036	:  0011_0101  0x35   53  5  
  23037	:  1001_0111  0x97  151    
  23038	:  0000_1000  0x08    8    
  23039	:  0100_0001  0x41   65  A  
  23040	:  0010_1101  0x2D   45  -  
  23041	:  0011_0101  0x35   53  5  
  23042	:  0011_0011  0x33   51  3  
  23043	:  0010_1101  0x2D   45  -  
  23044	:  0011_0001  0x31   49  1  
  23045	:  0011_0101  0x35   53  5  
  23046	:  0011_0010  0x32   50  2  
  23047	:  1100_0000  0xC0  192    
  23048	:  0000_1100  0x0C   12    
  23049	:  0000_0000  0x00    0    
  23050	:  0000_0001  0x01    1    
  23051	:  0000_0000  0x00    0    
  23052	:  0000_0001  0x01    1    
  23053	:  0000_0000  0x00    0    
  23054	:  0000_0000  0x00    0    
  23055	:  0010_1010  0x2A   42  *  
  23056	:  0011_0000  0x30   48  0  
  23057	:  0000_0000  0x00    0    
  23058	:  0000_0100  0x04    4    
  23059	:  0010_1101  0x2D   45  -  
  23060	:  0100_0011  0x43   67  C  
  23061	:  0011_0101  0x35   53  5  
  23062	:  1001_1000  0x98  152    
  23063	:  0000_1000  0x08    8    
  23064	:  0100_0001  0x41   65  A  
  23065	:  0010_1101  0x2D   45  -  
  23066	:  0011_0101  0x35   53  5  
  23067	:  0011_0011  0x33   51  3  
  23068	:  0010_1101  0x2D   45  -  
  23069	:  0011_0001  0x31   49  1  
  23070	:  0011_0101  0x35   53  5  
  23071	:  0011_0011  0x33   51  3  
  23072	:  1100_0000  0xC0  192    
  23073	:  0000_1100  0x0C   12    
  23074	:  0000_0000  0x00    0    
  23075	:  0000_0001  0x01    1    
  23076	:  0000_0000  0x00    0    
  23077	:  0000_0001  0x01    1    
  23078	:  0000_0000  0x00    0    
  23079	:  0000_0000  0x00    0    
  23080	:  0010_1010  0x2A   42  *  
  23081	:  0011_0000  0x30   48  0  
  23082	:  0000_0000  0x00    0    
  23083	:  0000_0100  0x04    4    
  23084	:  0010_1101  0x2D   45  -  
  23085	:  0100_0011  0x43   67  C  
  23086	:  0011_0101  0x35   53  5  
  23087	:  1001_1001  0x99  153    
  23088	:  0000_1000  0x08    8    
  23089	:  0100_0001  0x41   65  A  
  23090	:  0010_1101  0x2D   45  -  
  23091	:  0011_0101  0x35   53  5  
  23092	:  0011_0011  0x33   51  3  
  23093	:  0010_1101  0x2D   45  -  
  23094	:  0011_0001  0x31   49  1  
  23095	:  0011_0101  0x35   53  5  
  23096	:  0011_0100  0x34   52  4  
  23097	:  1100_0000  0xC0  192    
  23098	:  0000_1100  0x0C   12    
  23099	:  0000_0000  0x00    0    
  23100	:  0000_0001  0x01    1    
  23101	:  0000_0000  0x00    0    
  23102	:  0000_0001  0x01    1    
  23103	:  0000_0000  0x00    0    
  23104	:  0000_0000  0x00    0    
  23105	:  0010_1010  0x2A   42  *  
  23106	:  0011_0000  0x30   48  0  
  23107	:  0000_0000  0x00    0    
  23108	:  0000_0100  0x04    4    
  23109	:  0010_1101  0x2D   45  -  
  23110	:  0100_0011  0x43   67  C  
  23111	:  0011_0101  0x35   53  5  
  23112	:  1001_1010  0x9A  154    
  23113	:  0000_1000  0x08    8    
  23114	:  0100_0001  0x41   65  A  
  23115	:  0010_1101  0x2D   45  -  
  23116	:  0011_0101  0x35   53  5  
  23117	:  0011_0011  0x33   51  3  
  23118	:  0010_1101  0x2D   45  -  
  23119	:  0011_0001  0x31   49  1  
  23120	:  0011_0101  0x35   53  5  
  23121	:  0011_0101  0x35   53  5  
  23122	:  1100_0000  0xC0  192    
  23123	:  0000_1100  0x0C   12    
  23124	:  0000_0000  0x00    0    
  23125	:  0000_0001  0x01    1    
  23126	:  0000_0000  0x00    0    
  23127	:  0000_0001  0x01    1    
  23128	:  0000_0000  0x00    0    
  23129	:  0000_0000  0x00    0    
  23130	:  0010_1010  0x2A   42  *  
  23131	:  0011_0000  0x30   48  0  
  23132	:  0000_0000  0x00    0    
  23133	:  0000_0100  0x04    4    
  23134	:  0010_1101  0x2D   45  -  
  23135	:  0100_0011  0x43   67  C  
  23136	:  0011_0101  0x35   53  5  
  23137	:  1001_1011  0x9B  155    
  23138	:  0000_1000  0x08    8    
  23139	:  0100_0001  0x41   65  A  
  23140	:  0010_1101  0x2D   45  -  
  23141	:  0011_0101  0x35   53  5  
  23142	:  0011_0011  0x33   51  3  
  23143	:  0010_1101  0x2D   45  -  
  23144	:  0011_0001  0x31   49  1  
  23145	:  0011_0101  0x35   53  5  
  23146	:  0011_0110  0x36   54  6  
  23147	:  1100_0000  0xC0  192    
  23148	:  0000_1100  0x0C   12    
  23149	:  0000_0000  0x00    0    
  23150	:  0000_0001  0x01    1    
  23151	:  0000_0000  0x00    0    
  23152	:  0000_0001  0x01    1    
  23153	:  0000_0000  0x00    0    
  23154	:  0000_0000  0x00    0    
  23155	:  0010_1010  0x2A   42  *  
  23156	:  0011_0000  0x30   48  0  
  23157	:  0000_0000  0x00    0    
  23158	:  0000_0100  0x04    4    
  23159	:  0010_1101  0x2D   45  -  
  23160	:  0100_0011  0x43   67  C  
  23161	:  0011_0101  0x35   53  5  
  23162	:  1001_1100  0x9C  156    
  23163	:  0000_1000  0x08    8    
  23164	:  0100_0001  0x41   65  A  
  23165	:  0010_1101  0x2D   45  -  
  23166	:  0011_0101  0x35   53  5  
  23167	:  0011_0011  0x33   51  3  
  23168	:  0010_1101  0x2D   45  -  
  23169	:  0011_0001  0x31   49  1  
  23170	:  0011_0101  0x35   53  5  
  23171	:  0011_0111  0x37   55  7  
  23172	:  1100_0000  0xC0  192    
  23173	:  0000_1100  0x0C   12    
  23174	:  0000_0000  0x00    0    
  23175	:  0000_0001  0x01    1    
  23176	:  0000_0000  0x00    0    
  23177	:  0000_0001  0x01    1    
  23178	:  0000_0000  0x00    0    
  23179	:  0000_0000  0x00    0    
  23180	:  0010_1010  0x2A   42  *  
  23181	:  0011_0000  0x30   48  0  
  23182	:  0000_0000  0x00    0    
  23183	:  0000_0100  0x04    4    
  23184	:  0010_1101  0x2D   45  -  
  23185	:  0100_0011  0x43   67  C  
  23186	:  0011_0101  0x35   53  5  
  23187	:  1001_1101  0x9D  157    
  23188	:  0000_1000  0x08    8    
  23189	:  0100_0001  0x41   65  A  
  23190	:  0010_1101  0x2D   45  -  
  23191	:  0011_0101  0x35   53  5  
  23192	:  0011_0011  0x33   51  3  
  23193	:  0010_1101  0x2D   45  -  
  23194	:  0011_0001  0x31   49  1  
  23195	:  0011_0101  0x35   53  5  
  23196	:  0011_1000  0x38   56  8  
  23197	:  1100_0000  0xC0  192    
  23198	:  0000_1100  0x0C   12    
  23199	:  0000_0000  0x00    0    
  23200	:  0000_0001  0x01    1    
  23201	:  0000_0000  0x00    0    
  23202	:  0000_0001  0x01    1    
  23203	:  0000_0000  0x00    0    
  23204	:  0000_0000  0x00    0    
  23205	:  0010_1010  0x2A   42  *  
  23206	:  0011_0000  0x30   48  0  
  23207	:  0000_0000  0x00    0    
  23208	:  0000_0100  0x04    4    
  23209	:  0010_1101  0x2D   45  -  
  23210	:  0100_0011  0x43   67  C  
  23211	:  0011_0101  0x35   53  5  
  23212	:  1001_1110  0x9E  158    
  23213	:  0000_1000  0x08    8    
  23214	:  0100_0001  0x41   65  A  
  23215	:  0010_1101  0x2D   45  -  
  23216	:  0011_0101  0x35   53  5  
  23217	:  0011_0011  0x33   51  3  
  23218	:  0010_1101  0x2D   45  -  
  23219	:  0011_0001  0x31   49  1  
  23220	:  0011_0101  0x35   53  5  
  23221	:  0011_1001  0x39   57  9  
  23222	:  1100_0000  0xC0  192    
  23223	:  0000_1100  0x0C   12    
  23224	:  0000_0000  0x00    0    
  23225	:  0000_0001  0x01    1    
  23226	:  0000_0000  0x00    0    
  23227	:  0000_0001  0x01    1    
  23228	:  0000_0000  0x00    0    
  23229	:  0000_0000  0x00    0    
  23230	:  0010_1010  0x2A   42  *  
  23231	:  0011_0000  0x30   48  0  
  23232	:  0000_0000  0x00    0    
  23233	:  0000_0100  0x04    4    
  23234	:  0010_1101  0x2D   45  -  
  23235	:  0100_0011  0x43   67  C  
  23236	:  0011_0101  0x35   53  5  
  23237	:  1001_1111  0x9F  159    
  23238	:  0000_1000  0x08    8    
  23239	:  0100_0001  0x41   65  A  
  23240	:  0010_1101  0x2D   45  -  
  23241	:  0011_0101  0x35   53  5  
  23242	:  0011_0011  0x33   51  3  
  23243	:  0010_1101  0x2D   45  -  
  23244	:  0011_0001  0x31   49  1  
  23245	:  0011_0110  0x36   54  6  
  23246	:  0011_0000  0x30   48  0  
  23247	:  1100_0000  0xC0  192    
  23248	:  0000_1100  0x0C   12    
  23249	:  0000_0000  0x00    0    
  23250	:  0000_0001  0x01    1    
  23251	:  0000_0000  0x00    0    
  23252	:  0000_0001  0x01    1    
  23253	:  0000_0000  0x00    0    
  23254	:  0000_0000  0x00    0    
  23255	:  0010_1010  0x2A   42  *  
  23256	:  0011_0000  0x30   48  0  
  23257	:  0000_0000  0x00    0    
  23258	:  0000_0100  0x04    4    
  23259	:  0010_1101  0x2D   45  -  
  23260	:  0100_0011  0x43   67  C  
  23261	:  0011_0101  0x35   53  5  
  23262	:  1010_0000  0xA0  160    
  23263	:  0000_1000  0x08    8    
  23264	:  0100_0001  0x41   65  A  
  23265	:  0010_1101  0x2D   45  -  
  23266	:  0011_0101  0x35   53  5  
  23267	:  0011_0011  0x33   51  3  
  23268	:  0010_1101  0x2D   45  -  
  23269	:  0011_0001  0x31   49  1  
  23270	:  0011_0110  0x36   54  6  
  23271	:  0011_0001  0x31   49  1  
  23272	:  1100_0000  0xC0  192    
  23273	:  0000_1100  0x0C   12    
  23274	:  0000_0000  0x00    0    
  23275	:  0000_0001  0x01    1    
  23276	:  0000_0000  0x00    0    
  23277	:  0000_0001  0x01    1    
  23278	:  0000_0000  0x00    0    
  23279	:  0000_0000  0x00    0    
  23280	:  0010_1010  0x2A   42  *  
  23281	:  0011_0000  0x30   48  0  
  23282	:  0000_0000  0x00    0    
  23283	:  0000_0100  0x04    4    
  23284	:  0010_1101  0x2D   45  -  
  23285	:  0100_0011  0x43   67  C  
  23286	:  0011_0101  0x35   53  5  
  23287	:  1010_0001  0xA1  161    
  23288	:  0000_1000  0x08    8    
  23289	:  0100_0001  0x41   65  A  
  23290	:  0010_1101  0x2D   45  -  
  23291	:  0011_0101  0x35   53  5  
  23292	:  0011_0011  0x33   51  3  
  23293	:  0010_1101  0x2D   45  -  
  23294	:  0011_0001  0x31   49  1  
  23295	:  0011_0110  0x36   54  6  
  23296	:  0011_0010  0x32   50  2  
  23297	:  1100_0000  0xC0  192    
  23298	:  0000_1100  0x0C   12    
  23299	:  0000_0000  0x00    0    
  23300	:  0000_0001  0x01    1    
  23301	:  0000_0000  0x00    0    
  23302	:  0000_0001  0x01    1    
  23303	:  0000_0000  0x00    0    
  23304	:  0000_0000  0x00    0    
  23305	:  0010_1010  0x2A   42  *  
  23306	:  0011_0000  0x30   48  0  
  23307	:  0000_0000  0x00    0    
  23308	:  0000_0100  0x04    4    
  23309	:  0010_1101  0x2D   45  -  
  23310	:  0100_0011  0x43   67  C  
  23311	:  0011_0101  0x35   53  5  
  23312	:  1010_0010  0xA2  162    
  23313	:  0000_1000  0x08    8    
  23314	:  0100_0001  0x41   65  A  
  23315	:  0010_1101  0x2D   45  -  
  23316	:  0011_0101  0x35   53  5  
  23317	:  0011_0011  0x33   51  3  
  23318	:  0010_1101  0x2D   45  -  
  23319	:  0011_0001  0x31   49  1  
  23320	:  0011_0110  0x36   54  6  
  23321	:  0011_0011  0x33   51  3  
  23322	:  1100_0000  0xC0  192    
  23323	:  0000_1100  0x0C   12    
  23324	:  0000_0000  0x00    0    
  23325	:  0000_0001  0x01    1    
  23326	:  0000_0000  0x00    0    
  23327	:  0000_0001  0x01    1    
  23328	:  0000_0000  0x00    0    
  23329	:  0000_0000  0x00    0    
  23330	:  0010_1010  0x2A   42  *  
  23331	:  0011_0000  0x30   48  0  
  23332	:  0000_0000  0x00    0    
  23333	:  0000_0100  0x04    4    
  23334	:  0010_1101  0x2D   45  -  
  23335	:  0100_0011  0x43   67  C  
  23336	:  0011_0101  0x35   53  5  
  23337	:  1010_0011  0xA3  163    
  23338	:  0000_1000  0x08    8    
  23339	:  0100_0001  0x41   65  A  
  23340	:  0010_1101  0x2D   45  -  
  23341	:  0011_0101  0x35   53  5  
  23342	:  0011_0011  0x33   51  3  
  23343	:  0010_1101  0x2D   45  -  
  23344	:  0011_0001  0x31   49  1  
  23345	:  0011_0110  0x36   54  6  
  23346	:  0011_0100  0x34   52  4  
  23347	:  1100_0000  0xC0  192    
  23348	:  0000_1100  0x0C   12    
  23349	:  0000_0000  0x00    0    
  23350	:  0000_0001  0x01    1    
  23351	:  0000_0000  0x00    0    
  23352	:  0000_0001  0x01    1    
  23353	:  0000_0000  0x00    0    
  23354	:  0000_0000  0x00    0    
  23355	:  0010_1010  0x2A   42  *  
  23356	:  0011_0000  0x30   48  0  
  23357	:  0000_0000  0x00    0    
  23358	:  0000_0100  0x04    4    
  23359	:  0010_1101  0x2D   45  -  
  23360	:  0100_0011  0x43   67  C  
  23361	:  0011_0101  0x35   53  5  
  23362	:  1010_0100  0xA4  164    
  23363	:  0000_1000  0x08    8    
  23364	:  0100_0001  0x41   65  A  
  23365	:  0010_1101  0x2D   45  -  
  23366	:  0011_0101  0x35   53  5  
  23367	:  0011_0011  0x33   51  3  
  23368	:  0010_1101  0x2D   45  -  
  23369	:  0011_0001  0x31   49  1  
  23370	:  0011_0110  0x36   54  6  
  23371	:  0011_0101  0x35   53  5  
  23372	:  1100_0000  0xC0  192    
  23373	:  0000_1100  0x0C   12    
  23374	:  0000_0000  0x00    0    
  23375	:  0000_0001  0x01    1    
  23376	:  0000_0000  0x00    0    
  23377	:  0000_0001  0x01    1    
  23378	:  0000_0000  0x00    0    
  23379	:  0000_0000  0x00    0    
  23380	:  0010_1010  0x2A   42  *  
  23381	:  0011_0000  0x30   48  0  
  23382	:  0000_0000  0x00    0    
  23383	:  0000_0100  0x04    4    
  23384	:  0010_1101  0x2D   45  -  
  23385	:  0100_0011  0x43   67  C  
  23386	:  0011_0101  0x35   53  5  
  23387	:  1010_0101  0xA5  165    
  23388	:  0000_1000  0x08    8    
  23389	:  0100_0001  0x41   65  A  
  23390	:  0010_1101  0x2D   45  -  
  23391	:  0011_0101  0x35   53  5  
  23392	:  0011_0011  0x33   51  3  
  23393	:  0010_1101  0x2D   45  -  
  23394	:  0011_0001  0x31   49  1  
  23395	:  0011_0110  0x36   54  6  
  23396	:  0011_0110  0x36   54  6  
  23397	:  1100_0000  0xC0  192    
  23398	:  0000_1100  0x0C   12    
  23399	:  0000_0000  0x00    0    
  23400	:  0000_0001  0x01    1    
  23401	:  0000_0000  0x00    0    
  23402	:  0000_0001  0x01    1    
  23403	:  0000_0000  0x00    0    
  23404	:  0000_0000  0x00    0    
  23405	:  0010_1010  0x2A   42  *  
  23406	:  0011_0000  0x30   48  0  
  23407	:  0000_0000  0x00    0    
  23408	:  0000_0100  0x04    4    
  23409	:  0010_1101  0x2D   45  -  
  23410	:  0100_0011  0x43   67  C  
  23411	:  0011_0101  0x35   53  5  
  23412	:  1010_0110  0xA6  166    
  23413	:  0000_1000  0x08    8    
  23414	:  0100_0001  0x41   65  A  
  23415	:  0010_1101  0x2D   45  -  
  23416	:  0011_0101  0x35   53  5  
  23417	:  0011_0011  0x33   51  3  
  23418	:  0010_1101  0x2D   45  -  
  23419	:  0011_0001  0x31   49  1  
  23420	:  0011_0110  0x36   54  6  
  23421	:  0011_0111  0x37   55  7  
  23422	:  1100_0000  0xC0  192    
  23423	:  0000_1100  0x0C   12    
  23424	:  0000_0000  0x00    0    
  23425	:  0000_0001  0x01    1    
  23426	:  0000_0000  0x00    0    
  23427	:  0000_0001  0x01    1    
  23428	:  0000_0000  0x00    0    
  23429	:  0000_0000  0x00    0    
  23430	:  0010_1010  0x2A   42  *  
  23431	:  0011_0000  0x30   48  0  
  23432	:  0000_0000  0x00    0    
  23433	:  0000_0100  0x04    4    
  23434	:  0010_1101  0x2D   45  -  
  23435	:  0100_0011  0x43   67  C  
  23436	:  0011_0101  0x35   53  5  
  23437	:  1010_0111  0xA7  167    
  23438	:  0000_1000  0x08    8    
  23439	:  0100_0001  0x41   65  A  
  23440	:  0010_1101  0x2D   45  -  
  23441	:  0011_0101  0x35   53  5  
  23442	:  0011_0011  0x33   51  3  
  23443	:  0010_1101  0x2D   45  -  
  23444	:  0011_0001  0x31   49  1  
  23445	:  0011_0110  0x36   54  6  
  23446	:  0011_1000  0x38   56  8  
  23447	:  1100_0000  0xC0  192    
  23448	:  0000_1100  0x0C   12    
  23449	:  0000_0000  0x00    0    
  23450	:  0000_0001  0x01    1    
  23451	:  0000_0000  0x00    0    
  23452	:  0000_0001  0x01    1    
  23453	:  0000_0000  0x00    0    
  23454	:  0000_0000  0x00    0    
  23455	:  0010_1010  0x2A   42  *  
  23456	:  0011_0000  0x30   48  0  
  23457	:  0000_0000  0x00    0    
  23458	:  0000_0100  0x04    4    
  23459	:  0010_1101  0x2D   45  -  
  23460	:  0100_0011  0x43   67  C  
  23461	:  0011_0101  0x35   53  5  
  23462	:  1010_1000  0xA8  168    
  23463	:  0000_1000  0x08    8    
  23464	:  0100_0001  0x41   65  A  
  23465	:  0010_1101  0x2D   45  -  
  23466	:  0011_0101  0x35   53  5  
  23467	:  0011_0011  0x33   51  3  
  23468	:  0010_1101  0x2D   45  -  
  23469	:  0011_0001  0x31   49  1  
  23470	:  0011_0110  0x36   54  6  
  23471	:  0011_1001  0x39   57  9  
  23472	:  1100_0000  0xC0  192    
  23473	:  0000_1100  0x0C   12    
  23474	:  0000_0000  0x00    0    
  23475	:  0000_0001  0x01    1    
  23476	:  0000_0000  0x00    0    
  23477	:  0000_0001  0x01    1    
  23478	:  0000_0000  0x00    0    
  23479	:  0000_0000  0x00    0    
  23480	:  0010_1010  0x2A   42  *  
  23481	:  0011_0000  0x30   48  0  
  23482	:  0000_0000  0x00    0    
  23483	:  0000_0100  0x04    4    
  23484	:  0010_1101  0x2D   45  -  
  23485	:  0100_0011  0x43   67  C  
  23486	:  0011_0101  0x35   53  5  
  23487	:  1010_1001  0xA9  169    
  23488	:  0000_1000  0x08    8    
  23489	:  0100_0001  0x41   65  A  
  23490	:  0010_1101  0x2D   45  -  
  23491	:  0011_0101  0x35   53  5  
  23492	:  0011_0011  0x33   51  3  
  23493	:  0010_1101  0x2D   45  -  
  23494	:  0011_0001  0x31   49  1  
  23495	:  0011_0111  0x37   55  7  
  23496	:  0011_0000  0x30   48  0  
  23497	:  1100_0000  0xC0  192    
  23498	:  0000_1100  0x0C   12    
  23499	:  0000_0000  0x00    0    
  23500	:  0000_0001  0x01    1    
  23501	:  0000_0000  0x00    0    
  23502	:  0000_0001  0x01    1    
  23503	:  0000_0000  0x00    0    
  23504	:  0000_0000  0x00    0    
  23505	:  0010_1010  0x2A   42  *  
  23506	:  0011_0000  0x30   48  0  
  23507	:  0000_0000  0x00    0    
  23508	:  0000_0100  0x04    4    
  23509	:  0010_1101  0x2D   45  -  
  23510	:  0100_0011  0x43   67  C  
  23511	:  0011_0101  0x35   53  5  
  23512	:  1010_1010  0xAA  170    
  23513	:  0000_1000  0x08    8    
  23514	:  0100_0001  0x41   65  A  
  23515	:  0010_1101  0x2D   45  -  
  23516	:  0011_0101  0x35   53  5  
  23517	:  0011_0011  0x33   51  3  
  23518	:  0010_1101  0x2D   45  -  
  23519	:  0011_0001  0x31   49  1  
  23520	:  0011_0111  0x37   55  7  
  23521	:  0011_0001  0x31   49  1  
  23522	:  1100_0000  0xC0  192    
  23523	:  0000_1100  0x0C   12    
  23524	:  0000_0000  0x00    0    
  23525	:  0000_0001  0x01    1    
  23526	:  0000_0000  0x00    0    
  23527	:  0000_0001  0x01    1    
  23528	:  0000_0000  0x00    0    
  23529	:  0000_0000  0x00    0    
  23530	:  0010_1010  0x2A   42  *  
  23531	:  0011_0000  0x30   48  0  
  23532	:  0000_0000  0x00    0    
  23533	:  0000_0100  0x04    4    
  23534	:  0010_1101  0x2D   45  -  
  23535	:  0100_0011  0x43   67  C  
  23536	:  0011_0101  0x35   53  5  
  23537	:  1010_1011  0xAB  171    
  23538	:  0000_1000  0x08    8    
  23539	:  0100_0001  0x41   65  A  
  23540	:  0010_1101  0x2D   45  -  
  23541	:  0011_0101  0x35   53  5  
  23542	:  0011_0011  0x33   51  3  
  23543	:  0010_1101  0x2D   45  -  
  23544	:  0011_0001  0x31   49  1  
  23545	:  0011_0111  0x37   55  7  
  23546	:  0011_0010  0x32   50  2  
  23547	:  1100_0000  0xC0  192    
  23548	:  0000_1100  0x0C   12    
  23549	:  0000_0000  0x00    0    
  23550	:  0000_0001  0x01    1    
  23551	:  0000_0000  0x00    0    
  23552	:  0000_0001  0x01    1    
  23553	:  0000_0000  0x00    0    
  23554	:  0000_0000  0x00    0    
  23555	:  0010_1010  0x2A   42  *  
  23556	:  0011_0000  0x30   48  0  
  23557	:  0000_0000  0x00    0    
  23558	:  0000_0100  0x04    4    
  23559	:  0010_1101  0x2D   45  -  
  23560	:  0100_0011  0x43   67  C  
  23561	:  0011_0101  0x35   53  5  
  23562	:  1010_1100  0xAC  172    
  23563	:  0000_1000  0x08    8    
  23564	:  0100_0001  0x41   65  A  
  23565	:  0010_1101  0x2D   45  -  
  23566	:  0011_0101  0x35   53  5  
  23567	:  0011_0011  0x33   51  3  
  23568	:  0010_1101  0x2D   45  -  
  23569	:  0011_0001  0x31   49  1  
  23570	:  0011_0111  0x37   55  7  
  23571	:  0011_0011  0x33   51  3  
  23572	:  1100_0000  0xC0  192    
  23573	:  0000_1100  0x0C   12    
  23574	:  0000_0000  0x00    0    
  23575	:  0000_0001  0x01    1    
  23576	:  0000_0000  0x00    0    
  23577	:  0000_0001  0x01    1    
  23578	:  0000_0000  0x00    0    
  23579	:  0000_0000  0x00    0    
  23580	:  0010_1010  0x2A   42  *  
  23581	:  0011_0000  0x30   48  0  
  23582	:  0000_0000  0x00    0    
  23583	:  0000_0100  0x04    4    
  23584	:  0010_1101  0x2D   45  -  
  23585	:  0100_0011  0x43   67  C  
  23586	:  0011_0101  0x35   53  5  
  23587	:  1010_1101  0xAD  173    
  23588	:  0000_1000  0x08    8    
  23589	:  0100_0001  0x41   65  A  
  23590	:  0010_1101  0x2D   45  -  
  23591	:  0011_0101  0x35   53  5  
  23592	:  0011_0011  0x33   51  3  
  23593	:  0010_1101  0x2D   45  -  
  23594	:  0011_0001  0x31   49  1  
  23595	:  0011_0111  0x37   55  7  
  23596	:  0011_0100  0x34   52  4  
  23597	:  1100_0000  0xC0  192    
  23598	:  0000_1100  0x0C   12    
  23599	:  0000_0000  0x00    0    
  23600	:  0000_0001  0x01    1    
  23601	:  0000_0000  0x00    0    
  23602	:  0000_0001  0x01    1    
  23603	:  0000_0000  0x00    0    
  23604	:  0000_0000  0x00    0    
  23605	:  0010_1010  0x2A   42  *  
  23606	:  0011_0000  0x30   48  0  
  23607	:  0000_0000  0x00    0    
  23608	:  0000_0100  0x04    4    
  23609	:  0010_1101  0x2D   45  -  
  23610	:  0100_0011  0x43   67  C  
  23611	:  0011_0101  0x35   53  5  
  23612	:  1010_1110  0xAE  174    
  23613	:  0000_1000  0x08    8    
  23614	:  0100_0001  0x41   65  A  
  23615	:  0010_1101  0x2D   45  -  
  23616	:  0011_0101  0x35   53  5  
  23617	:  0011_0011  0x33   51  3  
  23618	:  0010_1101  0x2D   45  -  
  23619	:  0011_0001  0x31   49  1  
  23620	:  0011_0111  0x37   55  7  
  23621	:  0011_0101  0x35   53  5  
  23622	:  1100_0000  0xC0  192    
  23623	:  0000_1100  0x0C   12    
  23624	:  0000_0000  0x00    0    
  23625	:  0000_0001  0x01    1    
  23626	:  0000_0000  0x00    0    
  23627	:  0000_0001  0x01    1    
  23628	:  0000_0000  0x00    0    
  23629	:  0000_0000  0x00    0    
  23630	:  0010_1010  0x2A   42  *  
  23631	:  0011_0000  0x30   48  0  
  23632	:  0000_0000  0x00    0    
  23633	:  0000_0100  0x04    4    
  23634	:  0010_1101  0x2D   45  -  
  23635	:  0100_0011  0x43   67  C  
  23636	:  0011_0101  0x35   53  5  
  23637	:  1010_1111  0xAF  175    
  23638	:  0000_1000  0x08    8    
  23639	:  0100_0001  0x41   65  A  
  23640	:  0010_1101  0x2D   45  -  
  23641	:  0011_0101  0x35   53  5  
  23642	:  0011_0011  0x33   51  3  
  23643	:  0010_1101  0x2D   45  -  
  23644	:  0011_0001  0x31   49  1  
  23645	:  0011_0111  0x37   55  7  
  23646	:  0011_0110  0x36   54  6  
  23647	:  1100_0000  0xC0  192    
  23648	:  0000_1100  0x0C   12    
  23649	:  0000_0000  0x00    0    
  23650	:  0000_0001  0x01    1    
  23651	:  0000_0000  0x00    0    
  23652	:  0000_0001  0x01    1    
  23653	:  0000_0000  0x00    0    
  23654	:  0000_0000  0x00    0    
  23655	:  0010_1010  0x2A   42  *  
  23656	:  0011_0000  0x30   48  0  
  23657	:  0000_0000  0x00    0    
  23658	:  0000_0100  0x04    4    
  23659	:  0010_1101  0x2D   45  -  
  23660	:  0100_0011  0x43   67  C  
  23661	:  0011_0101  0x35   53  5  
  23662	:  1011_0000  0xB0  176    
  23663	:  0000_1000  0x08    8    
  23664	:  0100_0001  0x41   65  A  
  23665	:  0010_1101  0x2D   45  -  
  23666	:  0011_0101  0x35   53  5  
  23667	:  0011_0011  0x33   51  3  
  23668	:  0010_1101  0x2D   45  -  
  23669	:  0011_0001  0x31   49  1  
  23670	:  0011_0111  0x37   55  7  
  23671	:  0011_0111  0x37   55  7  
  23672	:  1100_0000  0xC0  192    
  23673	:  0000_1100  0x0C   12    
  23674	:  0000_0000  0x00    0    
  23675	:  0000_0001  0x01    1    
  23676	:  0000_0000  0x00    0    
  23677	:  0000_0001  0x01    1    
  23678	:  0000_0000  0x00    0    
  23679	:  0000_0000  0x00    0    
  23680	:  0010_1010  0x2A   42  *  
  23681	:  0011_0000  0x30   48  0  
  23682	:  0000_0000  0x00    0    
  23683	:  0000_0100  0x04    4    
  23684	:  0010_1101  0x2D   45  -  
  23685	:  0100_0011  0x43   67  C  
  23686	:  0011_0101  0x35   53  5  
  23687	:  1011_0001  0xB1  177    
  23688	:  0000_1000  0x08    8    
  23689	:  0100_0001  0x41   65  A  
  23690	:  0010_1101  0x2D   45  -  
  23691	:  0011_0101  0x35   53  5  
  23692	:  0011_0011  0x33   51  3  
  23693	:  0010_1101  0x2D   45  -  
  23694	:  0011_0001  0x31   49  1  
  23695	:  0011_0111  0x37   55  7  
  23696	:  0011_1000  0x38   56  8  
  23697	:  1100_0000  0xC0  192    
  23698	:  0000_1100  0x0C   12    
  23699	:  0000_0000  0x00    0    
  23700	:  0000_0001  0x01    1    
  23701	:  0000_0000  0x00    0    
  23702	:  0000_0001  0x01    1    
  23703	:  0000_0000  0x00    0    
  23704	:  0000_0000  0x00    0    
  23705	:  0010_1010  0x2A   42  *  
  23706	:  0011_0000  0x30   48  0  
  23707	:  0000_0000  0x00    0    
  23708	:  0000_0100  0x04    4    
  23709	:  0010_1101  0x2D   45  -  
  23710	:  0100_0011  0x43   67  C  
  23711	:  0011_0101  0x35   53  5  
  23712	:  1011_0010  0xB2  178    
  23713	:  0000_1000  0x08    8    
  23714	:  0100_0001  0x41   65  A  
  23715	:  0010_1101  0x2D   45  -  
  23716	:  0011_0101  0x35   53  5  
  23717	:  0011_0011  0x33   51  3  
  23718	:  0010_1101  0x2D   45  -  
  23719	:  0011_0001  0x31   49  1  
  23720	:  0011_0111  0x37   55  7  
  23721	:  0011_1001  0x39   57  9  
  23722	:  1100_0000  0xC0  192    
  23723	:  0000_1100  0x0C   12    
  23724	:  0000_0000  0x00    0    
  23725	:  0000_0001  0x01    1    
  23726	:  0000_0000  0x00    0    
  23727	:  0000_0001  0x01    1    
  23728	:  0000_0000  0x00    0    
  23729	:  0000_0000  0x00    0    
  23730	:  0010_1010  0x2A   42  *  
  23731	:  0011_0000  0x30   48  0  
  23732	:  0000_0000  0x00    0    
  23733	:  0000_0100  0x04    4    
  23734	:  0010_1101  0x2D   45  -  
  23735	:  0100_0011  0x43   67  C  
  23736	:  0011_0101  0x35   53  5  
  23737	:  1011_0011  0xB3  179    
  23738	:  0000_1000  0x08    8    
  23739	:  0100_0001  0x41   65  A  
  23740	:  0010_1101  0x2D   45  -  
  23741	:  0011_0101  0x35   53  5  
  23742	:  0011_0011  0x33   51  3  
  23743	:  0010_1101  0x2D   45  -  
  23744	:  0011_0001  0x31   49  1  
  23745	:  0011_1000  0x38   56  8  
  23746	:  0011_0000  0x30   48  0  
  23747	:  1100_0000  0xC0  192    
  23748	:  0000_1100  0x0C   12    
  23749	:  0000_0000  0x00    0    
  23750	:  0000_0001  0x01    1    
  23751	:  0000_0000  0x00    0    
  23752	:  0000_0001  0x01    1    
  23753	:  0000_0000  0x00    0    
  23754	:  0000_0000  0x00    0    
  23755	:  0010_1010  0x2A   42  *  
  23756	:  0011_0000  0x30   48  0  
  23757	:  0000_0000  0x00    0    
  23758	:  0000_0100  0x04    4    
  23759	:  0010_1101  0x2D   45  -  
  23760	:  0100_0011  0x43   67  C  
  23761	:  0011_0101  0x35   53  5  
  23762	:  1011_0100  0xB4  180    
  23763	:  0000_1000  0x08    8    
  23764	:  0100_0001  0x41   65  A  
  23765	:  0010_1101  0x2D   45  -  
  23766	:  0011_0101  0x35   53  5  
  23767	:  0011_0011  0x33   51  3  
  23768	:  0010_1101  0x2D   45  -  
  23769	:  0011_0001  0x31   49  1  
  23770	:  0011_1000  0x38   56  8  
  23771	:  0011_0001  0x31   49  1  
  23772	:  1100_0000  0xC0  192    
  23773	:  0000_1100  0x0C   12    
  23774	:  0000_0000  0x00    0    
  23775	:  0000_0001  0x01    1    
  23776	:  0000_0000  0x00    0    
  23777	:  0000_0001  0x01    1    
  23778	:  0000_0000  0x00    0    
  23779	:  0000_0000  0x00    0    
  23780	:  0010_1010  0x2A   42  *  
  23781	:  0011_0000  0x30   48  0  
  23782	:  0000_0000  0x00    0    
  23783	:  0000_0100  0x04    4    
  23784	:  0010_1101  0x2D   45  -  
  23785	:  0100_0011  0x43   67  C  
  23786	:  0011_0101  0x35   53  5  
  23787	:  1011_0101  0xB5  181    
  23788	:  0000_1000  0x08    8    
  23789	:  0100_0001  0x41   65  A  
  23790	:  0010_1101  0x2D   45  -  
  23791	:  0011_0101  0x35   53  5  
  23792	:  0011_0011  0x33   51  3  
  23793	:  0010_1101  0x2D   45  -  
  23794	:  0011_0001  0x31   49  1  
  23795	:  0011_1000  0x38   56  8  
  23796	:  0011_0010  0x32   50  2  
  23797	:  1100_0000  0xC0  192    
  23798	:  0000_1100  0x0C   12    
  23799	:  0000_0000  0x00    0    
  23800	:  0000_0001  0x01    1    
  23801	:  0000_0000  0x00    0    
  23802	:  0000_0001  0x01    1    
  23803	:  0000_0000  0x00    0    
  23804	:  0000_0000  0x00    0    
  23805	:  0010_1010  0x2A   42  *  
  23806	:  0011_0000  0x30   48  0  
  23807	:  0000_0000  0x00    0    
  23808	:  0000_0100  0x04    4    
  23809	:  0010_1101  0x2D   45  -  
  23810	:  0100_0011  0x43   67  C  
  23811	:  0011_0101  0x35   53  5  
  23812	:  1011_0110  0xB6  182    
  23813	:  0000_1000  0x08    8    
  23814	:  0100_0001  0x41   65  A  
  23815	:  0010_1101  0x2D   45  -  
  23816	:  0011_0101  0x35   53  5  
  23817	:  0011_0011  0x33   51  3  
  23818	:  0010_1101  0x2D   45  -  
  23819	:  0011_0001  0x31   49  1  
  23820	:  0011_1000  0x38   56  8  
  23821	:  0011_0011  0x33   51  3  
  23822	:  1100_0000  0xC0  192    
  23823	:  0000_1100  0x0C   12    
  23824	:  0000_0000  0x00    0    
  23825	:  0000_0001  0x01    1    
  23826	:  0000_0000  0x00    0    
  23827	:  0000_0001  0x01    1    
  23828	:  0000_0000  0x00    0    
  23829	:  0000_0000  0x00    0    
  23830	:  0010_1010  0x2A   42  *  
  23831	:  0011_0000  0x30   48  0  
  23832	:  0000_0000  0x00    0    
  23833	:  0000_0100  0x04    4    
  23834	:  0010_1101  0x2D   45  -  
  23835	:  0100_0011  0x43   67  C  
  23836	:  0011_0101  0x35   53  5  
  23837	:  1011_0111  0xB7  183    
  23838	:  0000_1000  0x08    8    
  23839	:  0100_0001  0x41   65  A  
  23840	:  0010_1101  0x2D   45  -  
  23841	:  0011_0101  0x35   53  5  
  23842	:  0011_0011  0x33   51  3  
  23843	:  0010_1101  0x2D   45  -  
  23844	:  0011_0001  0x31   49  1  
  23845	:  0011_1000  0x38   56  8  
  23846	:  0011_0100  0x34   52  4  
  23847	:  1100_0000  0xC0  192    
  23848	:  0000_1100  0x0C   12    
  23849	:  0000_0000  0x00    0    
  23850	:  0000_0001  0x01    1    
  23851	:  0000_0000  0x00    0    
  23852	:  0000_0001  0x01    1    
  23853	:  0000_0000  0x00    0    
  23854	:  0000_0000  0x00    0    
  23855	:  0010_1010  0x2A   42  *  
  23856	:  0011_0000  0x30   48  0  
  23857	:  0000_0000  0x00    0    
  23858	:  0000_0100  0x04    4    
  23859	:  0010_1101  0x2D   45  -  
  23860	:  0100_0011  0x43   67  C  
  23861	:  0011_0101  0x35   53  5  
  23862	:  1011_1000  0xB8  184    
  23863	:  0000_1000  0x08    8    
  23864	:  0100_0001  0x41   65  A  
  23865	:  0010_1101  0x2D   45  -  
  23866	:  0011_0101  0x35   53  5  
  23867	:  0011_0011  0x33   51  3  
  23868	:  0010_1101  0x2D   45  -  
  23869	:  0011_0001  0x31   49  1  
  23870	:  0011_1000  0x38   56  8  
  23871	:  0011_0101  0x35   53  5  
  23872	:  1100_0000  0xC0  192    
  23873	:  0000_1100  0x0C   12    
  23874	:  0000_0000  0x00    0    
  23875	:  0000_0001  0x01    1    
  23876	:  0000_0000  0x00    0    
  23877	:  0000_0001  0x01    1    
  23878	:  0000_0000  0x00    0    
  23879	:  0000_0000  0x00    0    
  23880	:  0010_1010  0x2A   42  *  
  23881	:  0011_0000  0x30   48  0  
  23882	:  0000_0000  0x00    0    
  23883	:  0000_0100  0x04    4    
  23884	:  0010_1101  0x2D   45  -  
  23885	:  0100_0011  0x43   67  C  
  23886	:  0011_0101  0x35   53  5  
  23887	:  1011_1001  0xB9  185    
  23888	:  0000_1000  0x08    8    
  23889	:  0100_0001  0x41   65  A  
  23890	:  0010_1101  0x2D   45  -  
  23891	:  0011_0101  0x35   53  5  
  23892	:  0011_0011  0x33   51  3  
  23893	:  0010_1101  0x2D   45  -  
  23894	:  0011_0001  0x31   49  1  
  23895	:  0011_1000  0x38   56  8  
  23896	:  0011_0110  0x36   54  6  
  23897	:  1100_0000  0xC0  192    
  23898	:  0000_1100  0x0C   12    
  23899	:  0000_0000  0x00    0    
  23900	:  0000_0001  0x01    1    
  23901	:  0000_0000  0x00    0    
  23902	:  0000_0001  0x01    1    
  23903	:  0000_0000  0x00    0    
  23904	:  0000_0000  0x00    0    
  23905	:  0010_1010  0x2A   42  *  
  23906	:  0011_0000  0x30   48  0  
  23907	:  0000_0000  0x00    0    
  23908	:  0000_0100  0x04    4    
  23909	:  0010_1101  0x2D   45  -  
  23910	:  0100_0011  0x43   67  C  
  23911	:  0011_0101  0x35   53  5  
  23912	:  1011_1010  0xBA  186    
  23913	:  0000_1000  0x08    8    
  23914	:  0100_0001  0x41   65  A  
  23915	:  0010_1101  0x2D   45  -  
  23916	:  0011_0101  0x35   53  5  
  23917	:  0011_0011  0x33   51  3  
  23918	:  0010_1101  0x2D   45  -  
  23919	:  0011_0001  0x31   49  1  
  23920	:  0011_1000  0x38   56  8  
  23921	:  0011_0111  0x37   55  7  
  23922	:  1100_0000  0xC0  192    
  23923	:  0000_1100  0x0C   12    
  23924	:  0000_0000  0x00    0    
  23925	:  0000_0001  0x01    1    
  23926	:  0000_0000  0x00    0    
  23927	:  0000_0001  0x01    1    
  23928	:  0000_0000  0x00    0    
  23929	:  0000_0000  0x00    0    
  23930	:  0010_1010  0x2A   42  *  
  23931	:  0011_0000  0x30   48  0  
  23932	:  0000_0000  0x00    0    
  23933	:  0000_0100  0x04    4    
  23934	:  0010_1101  0x2D   45  -  
  23935	:  0100_0011  0x43   67  C  
  23936	:  0011_0101  0x35   53  5  
  23937	:  1011_1011  0xBB  187    
  23938	:  0000_1000  0x08    8    
  23939	:  0100_0001  0x41   65  A  
  23940	:  0010_1101  0x2D   45  -  
  23941	:  0011_0101  0x35   53  5  
  23942	:  0011_0011  0x33   51  3  
  23943	:  0010_1101  0x2D   45  -  
  23944	:  0011_0001  0x31   49  1  
  23945	:  0011_1000  0x38   56  8  
  23946	:  0011_1000  0x38   56  8  
  23947	:  1100_0000  0xC0  192    
  23948	:  0000_1100  0x0C   12    
  23949	:  0000_0000  0x00    0    
  23950	:  0000_0001  0x01    1    
  23951	:  0000_0000  0x00    0    
  23952	:  0000_0001  0x01    1    
  23953	:  0000_0000  0x00    0    
  23954	:  0000_0000  0x00    0    
  23955	:  0010_1010  0x2A   42  *  
  23956	:  0011_0000  0x30   48  0  
  23957	:  0000_0000  0x00    0    
  23958	:  0000_0100  0x04    4    
  23959	:  0010_1101  0x2D   45  -  
  23960	:  0100_0011  0x43   67  C  
  23961	:  0011_0101  0x35   53  5  
  23962	:  1011_1100  0xBC  188    
  23963	:  0000_1000  0x08    8    
  23964	:  0100_0001  0x41   65  A  
  23965	:  0010_1101  0x2D   45  -  
  23966	:  0011_0101  0x35   53  5  
  23967	:  0011_0011  0x33   51  3  
  23968	:  0010_1101  0x2D   45  -  
  23969	:  0011_0001  0x31   49  1  
  23970	:  0011_1000  0x38   56  8  
  23971	:  0011_1001  0x39   57  9  
  23972	:  1100_0000  0xC0  192    
  23973	:  0000_1100  0x0C   12    
  23974	:  0000_0000  0x00    0    
  23975	:  0000_0001  0x01    1    
  23976	:  0000_0000  0x00    0    
  23977	:  0000_0001  0x01    1    
  23978	:  0000_0000  0x00    0    
  23979	:  0000_0000  0x00    0    
  23980	:  0010_1010  0x2A   42  *  
  23981	:  0011_0000  0x30   48  0  
  23982	:  0000_0000  0x00    0    
  23983	:  0000_0100  0x04    4    
  23984	:  0010_1101  0x2D   45  -  
  23985	:  0100_0011  0x43   67  C  
  23986	:  0011_0101  0x35   53  5  
  23987	:  1011_1101  0xBD  189    
  23988	:  0000_1000  0x08    8    
  23989	:  0100_0001  0x41   65  A  
  23990	:  0010_1101  0x2D   45  -  
  23991	:  0011_0101  0x35   53  5  
  23992	:  0011_0011  0x33   51  3  
  23993	:  0010_1101  0x2D   45  -  
  23994	:  0011_0001  0x31   49  1  
  23995	:  0011_1001  0x39   57  9  
  23996	:  0011_0000  0x30   48  0  
  23997	:  1100_0000  0xC0  192    
  23998	:  0000_1100  0x0C   12    
  23999	:  0000_0000  0x00    0    
  24000	:  0000_0001  0x01    1    
  24001	:  0000_0000  0x00    0    
  24002	:  0000_0001  0x01    1    
  24003	:  0000_0000  0x00    0    
  24004	:  0000_0000  0x00    0    
  24005	:  0010_1010  0x2A   42  *  
  24006	:  0011_0000  0x30   48  0  
  24007	:  0000_0000  0x00    0    
  24008	:  0000_0100  0x04    4    
  24009	:  0010_1101  0x2D   45  -  
  24010	:  0100_0011  0x43   67  C  
  24011	:  0011_0101  0x35   53  5  
  24012	:  1011_1110  0xBE  190    
  24013	:  0000_1000  0x08    8    
  24014	:  0100_0001  0x41   65  A  
  24015	:  0010_1101  0x2D   45  -  
  24016	:  0011_0101  0x35   53  5  
  24017	:  0011_0011  0x33   51  3  
  24018	:  0010_1101  0x2D   45  -  
  24019	:  0011_0001  0x31   49  1  
  24020	:  0011_1001  0x39   57  9  
  24021	:  0011_0001  0x31   49  1  
  24022	:  1100_0000  0xC0  192    
  24023	:  0000_1100  0x0C   12    
  24024	:  0000_0000  0x00    0    
  24025	:  0000_0001  0x01    1    
  24026	:  0000_0000  0x00    0    
  24027	:  0000_0001  0x01    1    
  24028	:  0000_0000  0x00    0    
  24029	:  0000_0000  0x00    0    
  24030	:  0010_1010  0x2A   42  *  
  24031	:  0011_0000  0x30   48  0  
  24032	:  0000_0000  0x00    0    
  24033	:  0000_0100  0x04    4    
  24034	:  0010_1101  0x2D   45  -  
  24035	:  0100_0011  0x43   67  C  
  24036	:  0011_0101  0x35   53  5  
  24037	:  1011_1111  0xBF  191    
  24038	:  0000_1000  0x08    8    
  24039	:  0100_0001  0x41   65  A  
  24040	:  0010_1101  0x2D   45  -  
  24041	:  0011_0101  0x35   53  5  
  24042	:  0011_0011  0x33   51  3  
  24043	:  0010_1101  0x2D   45  -  
  24044	:  0011_0001  0x31   49  1  
  24045	:  0011_1001  0x39   57  9  
  24046	:  0011_0010  0x32   50  2  
  24047	:  1100_0000  0xC0  192    
  24048	:  0000_1100  0x0C   12    
  24049	:  0000_0000  0x00    0    
  24050	:  0000_0001  0x01    1    
  24051	:  0000_0000  0x00    0    
  24052	:  0000_0001  0x01    1    
  24053	:  0000_0000  0x00    0    
  24054	:  0000_0000  0x00    0    
  24055	:  0010_1010  0x2A   42  *  
  24056	:  0011_0000  0x30   48  0  
  24057	:  0000_0000  0x00    0    
  24058	:  0000_0100  0x04    4    
  24059	:  0010_1101  0x2D   45  -  
  24060	:  0100_0011  0x43   67  C  
  24061	:  0011_0101  0x35   53  5  
  24062	:  1100_0000  0xC0  192    
  24063	:  0000_1000  0x08    8    
  24064	:  0100_0001  0x41   65  A  
  24065	:  0010_1101  0x2D   45  -  
  24066	:  0011_0101  0x35   53  5  
  24067	:  0011_0011  0x33   51  3  
  24068	:  0010_1101  0x2D   45  -  
  24069	:  0011_0001  0x31   49  1  
  24070	:  0011_1001  0x39   57  9  
  24071	:  0011_0011  0x33   51  3  
  24072	:  1100_0000  0xC0  192    
  24073	:  0000_1100  0x0C   12    
  24074	:  0000_0000  0x00    0    
  24075	:  0000_0001  0x01    1    
  24076	:  0000_0000  0x00    0    
  24077	:  0000_0001  0x01    1    
  24078	:  0000_0000  0x00    0    
  24079	:  0000_0000  0x00    0    
  24080	:  0010_1010  0x2A   42  *  
  24081	:  0011_0000  0x30   48  0  
  24082	:  0000_0000  0x00    0    
  24083	:  0000_0100  0x04    4    
  24084	:  0010_1101  0x2D   45  -  
  24085	:  0100_0011  0x43   67  C  
  24086	:  0011_0101  0x35   53  5  
  24087	:  1100_0001  0xC1  193    
  24088	:  0000_1000  0x08    8    
  24089	:  0100_0001  0x41   65  A  
  24090	:  0010_1101  0x2D   45  -  
  24091	:  0011_0101  0x35   53  5  
  24092	:  0011_0011  0x33   51  3  
  24093	:  0010_1101  0x2D   45  -  
  24094	:  0011_0001  0x31   49  1  
  24095	:  0011_1001  0x39   57  9  
  24096	:  0011_0100  0x34   52  4  
  24097	:  1100_0000  0xC0  192    
  24098	:  0000_1100  0x0C   12    
  24099	:  0000_0000  0x00    0    
  24100	:  0000_0001  0x01    1    
  24101	:  0000_0000  0x00    0    
  24102	:  0000_0001  0x01    1    
  24103	:  0000_0000  0x00    0    
  24104	:  0000_0000  0x00    0    
  24105	:  0010_1010  0x2A   42  *  
  24106	:  0011_0000  0x30   48  0  
  24107	:  0000_0000  0x00    0    
  24108	:  0000_0100  0x04    4    
  24109	:  0010_1101  0x2D   45  -  
  24110	:  0100_0011  0x43   67  C  
  24111	:  0011_0101  0x35   53  5  
  24112	:  1100_0010  0xC2  194    
  24113	:  0000_1000  0x08    8    
  24114	:  0100_0001  0x41   65  A  
  24115	:  0010_1101  0x2D   45  -  
  24116	:  0011_0101  0x35   53  5  
  24117	:  0011_0011  0x33   51  3  
  24118	:  0010_1101  0x2D   45  -  
  24119	:  0011_0001  0x31   49  1  
  24120	:  0011_1001  0x39   57  9  
  24121	:  0011_0101  0x35   53  5  
  24122	:  1100_0000  0xC0  192    
  24123	:  0000_1100  0x0C   12    
  24124	:  0000_0000  0x00    0    
  24125	:  0000_0001  0x01    1    
  24126	:  0000_0000  0x00    0    
  24127	:  0000_0001  0x01    1    
  24128	:  0000_0000  0x00    0    
  24129	:  0000_0000  0x00    0    
  24130	:  0010_1010  0x2A   42  *  
  24131	:  0011_0000  0x30   48  0  
  24132	:  0000_0000  0x00    0    
  24133	:  0000_0100  0x04    4    
  24134	:  0010_1101  0x2D   45  -  
  24135	:  0100_0011  0x43   67  C  
  24136	:  0011_0101  0x35   53  5  
  24137	:  1100_0011  0xC3  195    
  24138	:  0000_1000  0x08    8    
  24139	:  0100_0001  0x41   65  A  
  24140	:  0010_1101  0x2D   45  -  
  24141	:  0011_0101  0x35   53  5  
  24142	:  0011_0011  0x33   51  3  
  24143	:  0010_1101  0x2D   45  -  
  24144	:  0011_0001  0x31   49  1  
  24145	:  0011_1001  0x39   57  9  
  24146	:  0011_0110  0x36   54  6  
  24147	:  1100_0000  0xC0  192    
  24148	:  0000_1100  0x0C   12    
  24149	:  0000_0000  0x00    0    
  24150	:  0000_0001  0x01    1    
  24151	:  0000_0000  0x00    0    
  24152	:  0000_0001  0x01    1    
  24153	:  0000_0000  0x00    0    
  24154	:  0000_0000  0x00    0    
  24155	:  0010_1010  0x2A   42  *  
  24156	:  0011_0000  0x30   48  0  
  24157	:  0000_0000  0x00    0    
  24158	:  0000_0100  0x04    4    
  24159	:  0010_1101  0x2D   45  -  
  24160	:  0100_0011  0x43   67  C  
  24161	:  0011_0101  0x35   53  5  
  24162	:  1100_0100  0xC4  196    
  24163	:  0000_1000  0x08    8    
  24164	:  0100_0001  0x41   65  A  
  24165	:  0010_1101  0x2D   45  -  
  24166	:  0011_0101  0x35   53  5  
  24167	:  0011_0011  0x33   51  3  
  24168	:  0010_1101  0x2D   45  -  
  24169	:  0011_0001  0x31   49  1  
  24170	:  0011_1001  0x39   57  9  
  24171	:  0011_0111  0x37   55  7  
  24172	:  1100_0000  0xC0  192    
  24173	:  0000_1100  0x0C   12    
  24174	:  0000_0000  0x00    0    
  24175	:  0000_0001  0x01    1    
  24176	:  0000_0000  0x00    0    
  24177	:  0000_0001  0x01    1    
  24178	:  0000_0000  0x00    0    
  24179	:  0000_0000  0x00    0    
  24180	:  0010_1010  0x2A   42  *  
  24181	:  0011_0000  0x30   48  0  
  24182	:  0000_0000  0x00    0    
  24183	:  0000_0100  0x04    4    
  24184	:  0010_1101  0x2D   45  -  
  24185	:  0100_0011  0x43   67  C  
  24186	:  0011_0101  0x35   53  5  
  24187	:  1100_0101  0xC5  197    
  24188	:  0000_1000  0x08    8    
  24189	:  0100_0001  0x41   65  A  
  24190	:  0010_1101  0x2D   45  -  
  24191	:  0011_0101  0x35   53  5  
  24192	:  0011_0011  0x33   51  3  
  24193	:  0010_1101  0x2D   45  -  
  24194	:  0011_0001  0x31   49  1  
  24195	:  0011_1001  0x39   57  9  
  24196	:  0011_1000  0x38   56  8  
  24197	:  1100_0000  0xC0  192    
  24198	:  0000_1100  0x0C   12    
  24199	:  0000_0000  0x00    0    
  24200	:  0000_0001  0x01    1    
  24201	:  0000_0000  0x00    0    
  24202	:  0000_0001  0x01    1    
  24203	:  0000_0000  0x00    0    
  24204	:  0000_0000  0x00    0    
  24205	:  0010_1010  0x2A   42  *  
  24206	:  0011_0000  0x30   48  0  
  24207	:  0000_0000  0x00    0    
  24208	:  0000_0100  0x04    4    
  24209	:  0010_1101  0x2D   45  -  
  24210	:  0100_0011  0x43   67  C  
  24211	:  0011_0101  0x35   53  5  
  24212	:  1100_0110  0xC6  198    
  24213	:  0000_1000  0x08    8    
  24214	:  0100_0001  0x41   65  A  
  24215	:  0010_1101  0x2D   45  -  
  24216	:  0011_0101  0x35   53  5  
  24217	:  0011_0011  0x33   51  3  
  24218	:  0010_1101  0x2D   45  -  
  24219	:  0011_0001  0x31   49  1  
  24220	:  0011_1001  0x39   57  9  
  24221	:  0011_1001  0x39   57  9  
  24222	:  1100_0000  0xC0  192    
  24223	:  0000_1100  0x0C   12    
  24224	:  0000_0000  0x00    0    
  24225	:  0000_0001  0x01    1    
  24226	:  0000_0000  0x00    0    
  24227	:  0000_0001  0x01    1    
  24228	:  0000_0000  0x00    0    
  24229	:  0000_0000  0x00    0    
  24230	:  0010_1010  0x2A   42  *  
  24231	:  0011_0000  0x30   48  0  
  24232	:  0000_0000  0x00    0    
  24233	:  0000_0100  0x04    4    
  24234	:  0010_1101  0x2D   45  -  
  24235	:  0100_0011  0x43   67  C  
  24236	:  0011_0101  0x35   53  5  
  24237	:  1100_0111  0xC7  199    
  24238	:  0000_1000  0x08    8    
  24239	:  0100_0001  0x41   65  A  
  24240	:  0010_1101  0x2D   45  -  
  24241	:  0011_0101  0x35   53  5  
  24242	:  0011_0011  0x33   51  3  
  24243	:  0010_1101  0x2D   45  -  
  24244	:  0011_0010  0x32   50  2  
  24245	:  0011_0000  0x30   48  0  
  24246	:  0011_0000  0x30   48  0  
  24247	:  1100_0000  0xC0  192    
  24248	:  0000_1100  0x0C   12    
  24249	:  0000_0000  0x00    0    
  24250	:  0000_0001  0x01    1    
  24251	:  0000_0000  0x00    0    
  24252	:  0000_0001  0x01    1    
  24253	:  0000_0000  0x00    0    
  24254	:  0000_0000  0x00    0    
  24255	:  0010_1010  0x2A   42  *  
  24256	:  0011_0000  0x30   48  0  
  24257	:  0000_0000  0x00    0    
  24258	:  0000_0100  0x04    4    
  24259	:  0010_1101  0x2D   45  -  
  24260	:  0100_0011  0x43   67  C  
  24261	:  0011_0101  0x35   53  5  
  24262	:  1100_1000  0xC8  200    
  24263	:  0000_1000  0x08    8    
  24264	:  0100_0001  0x41   65  A  
  24265	:  0010_1101  0x2D   45  -  
  24266	:  0011_0101  0x35   53  5  
  24267	:  0011_0011  0x33   51  3  
  24268	:  0010_1101  0x2D   45  -  
  24269	:  0011_0010  0x32   50  2  
  24270	:  0011_0000  0x30   48  0  
  24271	:  0011_0001  0x31   49  1  
  24272	:  1100_0000  0xC0  192    
  24273	:  0000_1100  0x0C   12    
  24274	:  0000_0000  0x00    0    
  24275	:  0000_0001  0x01    1    
  24276	:  0000_0000  0x00    0    
  24277	:  0000_0001  0x01    1    
  24278	:  0000_0000  0x00    0    
  24279	:  0000_0000  0x00    0    
  24280	:  0010_1010  0x2A   42  *  
  24281	:  0011_0000  0x30   48  0  
  24282	:  0000_0000  0x00    0    
  24283	:  0000_0100  0x04    4    
  24284	:  0010_1101  0x2D   45  -  
  24285	:  0100_0011  0x43   67  C  
  24286	:  0011_0101  0x35   53  5  
  24287	:  1100_1001  0xC9  201    
  24288	:  0000_1000  0x08    8    
  24289	:  0100_0001  0x41   65  A  
  24290	:  0010_1101  0x2D   45  -  
  24291	:  0011_0101  0x35   53  5  
  24292	:  0011_0011  0x33   51  3  
  24293	:  0010_1101  0x2D   45  -  
  24294	:  0011_0010  0x32   50  2  
  24295	:  0011_0000  0x30   48  0  
  24296	:  0011_0010  0x32   50  2  
  24297	:  1100_0000  0xC0  192    
  24298	:  0000_1100  0x0C   12    
  24299	:  0000_0000  0x00    0    
  24300	:  0000_0001  0x01    1    
  24301	:  0000_0000  0x00    0    
  24302	:  0000_0001  0x01    1    
  24303	:  0000_0000  0x00    0    
  24304	:  0000_0000  0x00    0    
  24305	:  0010_1010  0x2A   42  *  
  24306	:  0011_0000  0x30   48  0  
  24307	:  0000_0000  0x00    0    
  24308	:  0000_0100  0x04    4    
  24309	:  0010_1101  0x2D   45  -  
  24310	:  0100_0011  0x43   67  C  
  24311	:  0011_0101  0x35   53  5  
  24312	:  1100_1010  0xCA  202    
  24313	:  0000_1000  0x08    8    
  24314	:  0100_0001  0x41   65  A  
  24315	:  0010_1101  0x2D   45  -  
  24316	:  0011_0101  0x35   53  5  
  24317	:  0011_0011  0x33   51  3  
  24318	:  0010_1101  0x2D   45  -  
  24319	:  0011_0010  0x32   50  2  
  24320	:  0011_0000  0x30   48  0  
  24321	:  0011_0011  0x33   51  3  
  24322	:  1100_0000  0xC0  192    
  24323	:  0000_1100  0x0C   12    
  24324	:  0000_0000  0x00    0    
  24325	:  0000_0001  0x01    1    
  24326	:  0000_0000  0x00    0    
  24327	:  0000_0001  0x01    1    
  24328	:  0000_0000  0x00    0    
  24329	:  0000_0000  0x00    0    
  24330	:  0010_1010  0x2A   42  *  
  24331	:  0011_0000  0x30   48  0  
  24332	:  0000_0000  0x00    0    
  24333	:  0000_0100  0x04    4    
  24334	:  0010_1101  0x2D   45  -  
  24335	:  0100_0011  0x43   67  C  
  24336	:  0011_0101  0x35   53  5  
  24337	:  1100_1011  0xCB  203    
  24338	:  0000_1000  0x08    8    
  24339	:  0100_0001  0x41   65  A  
  24340	:  0010_1101  0x2D   45  -  
  24341	:  0011_0101  0x35   53  5  
  24342	:  0011_0011  0x33   51  3  
  24343	:  0010_1101  0x2D   45  -  
  24344	:  0011_0010  0x32   50  2  
  24345	:  0011_0000  0x30   48  0  
  24346	:  0011_0100  0x34   52  4  
  24347	:  1100_0000  0xC0  192    
  24348	:  0000_1100  0x0C   12    
  24349	:  0000_0000  0x00    0    
  24350	:  0000_0001  0x01    1    
  24351	:  0000_0000  0x00    0    
  24352	:  0000_0001  0x01    1    
  24353	:  0000_0000  0x00    0    
  24354	:  0000_0000  0x00    0    
  24355	:  0010_1010  0x2A   42  *  
  24356	:  0011_0000  0x30   48  0  
  24357	:  0000_0000  0x00    0    
  24358	:  0000_0100  0x04    4    
  24359	:  0010_1101  0x2D   45  -  
  24360	:  0100_0011  0x43   67  C  
  24361	:  0011_0101  0x35   53  5  
  24362	:  1100_1100  0xCC  204    
  24363	:  0000_1000  0x08    8    
  24364	:  0100_0001  0x41   65  A  
  24365	:  0010_1101  0x2D   45  -  
  24366	:  0011_0101  0x35   53  5  
  24367	:  0011_0011  0x33   51  3  
  24368	:  0010_1101  0x2D   45  -  
  24369	:  0011_0010  0x32   50  2  
  24370	:  0011_0000  0x30   48  0  
  24371	:  0011_0101  0x35   53  5  
  24372	:  1100_0000  0xC0  192    
  24373	:  0000_1100  0x0C   12    
  24374	:  0000_0000  0x00    0    
  24375	:  0000_0001  0x01    1    
  24376	:  0000_0000  0x00    0    
  24377	:  0000_0001  0x01    1    
  24378	:  0000_0000  0x00    0    
  24379	:  0000_0000  0x00    0    
  24380	:  0010_1010  0x2A   42  *  
  24381	:  0011_0000  0x30   48  0  
  24382	:  0000_0000  0x00    0    
  24383	:  0000_0100  0x04    4    
  24384	:  0010_1101  0x2D   45  -  
  24385	:  0100_0011  0x43   67  C  
  24386	:  0011_0101  0x35   53  5  
  24387	:  1100_1101  0xCD  205    
  24388	:  0000_1000  0x08    8    
  24389	:  0100_0001  0x41   65  A  
  24390	:  0010_1101  0x2D   45  -  
  24391	:  0011_0101  0x35   53  5  
  24392	:  0011_0011  0x33   51  3  
  24393	:  0010_1101  0x2D   45  -  
  24394	:  0011_0010  0x32   50  2  
  24395	:  0011_0000  0x30   48  0  
  24396	:  0011_0110  0x36   54  6  
  24397	:  1100_0000  0xC0  192    
  24398	:  0000_1100  0x0C   12    
  24399	:  0000_0000  0x00    0    
  24400	:  0000_0001  0x01    1    
  24401	:  0000_0000  0x00    0    
  24402	:  0000_0001  0x01    1    
  24403	:  0000_0000  0x00    0    
  24404	:  0000_0000  0x00    0    
  24405	:  0010_1010  0x2A   42  *  
  24406	:  0011_0000  0x30   48  0  
  24407	:  0000_0000  0x00    0    
  24408	:  0000_0100  0x04    4    
  24409	:  0010_1101  0x2D   45  -  
  24410	:  0100_0011  0x43   67  C  
  24411	:  0011_0101  0x35   53  5  
  24412	:  1100_1110  0xCE  206    
  24413	:  0000_1000  0x08    8    
  24414	:  0100_0001  0x41   65  A  
  24415	:  0010_1101  0x2D   45  -  
  24416	:  0011_0101  0x35   53  5  
  24417	:  0011_0011  0x33   51  3  
  24418	:  0010_1101  0x2D   45  -  
  24419	:  0011_0010  0x32   50  2  
  24420	:  0011_0000  0x30   48  0  
  24421	:  0011_0111  0x37   55  7  
  24422	:  1100_0000  0xC0  192    
  24423	:  0000_1100  0x0C   12    
  24424	:  0000_0000  0x00    0    
  24425	:  0000_0001  0x01    1    
  24426	:  0000_0000  0x00    0    
  24427	:  0000_0001  0x01    1    
  24428	:  0000_0000  0x00    0    
  24429	:  0000_0000  0x00    0    
  24430	:  0010_1010  0x2A   42  *  
  24431	:  0011_0000  0x30   48  0  
  24432	:  0000_0000  0x00    0    
  24433	:  0000_0100  0x04    4    
  24434	:  0010_1101  0x2D   45  -  
  24435	:  0100_0011  0x43   67  C  
  24436	:  0011_0101  0x35   53  5  
  24437	:  1100_1111  0xCF  207    
  24438	:  0000_1000  0x08    8    
  24439	:  0100_0001  0x41   65  A  
  24440	:  0010_1101  0x2D   45  -  
  24441	:  0011_0101  0x35   53  5  
  24442	:  0011_0011  0x33   51  3  
  24443	:  0010_1101  0x2D   45  -  
  24444	:  0011_0010  0x32   50  2  
  24445	:  0011_0000  0x30   48  0  
  24446	:  0011_1000  0x38   56  8  
  24447	:  1100_0000  0xC0  192    
  24448	:  0000_1100  0x0C   12    
  24449	:  0000_0000  0x00    0    
  24450	:  0000_0001  0x01    1    
  24451	:  0000_0000  0x00    0    
  24452	:  0000_0001  0x01    1    
  24453	:  0000_0000  0x00    0    
  24454	:  0000_0000  0x00    0    
  24455	:  0010_1010  0x2A   42  *  
  24456	:  0011_0000  0x30   48  0  
  24457	:  0000_0000  0x00    0    
  24458	:  0000_0100  0x04    4    
  24459	:  0010_1101  0x2D   45  -  
  24460	:  0100_0011  0x43   67  C  
  24461	:  0011_0101  0x35   53  5  
  24462	:  1101_0000  0xD0  208    
  24463	:  0000_1000  0x08    8    
  24464	:  0100_0001  0x41   65  A  
  24465	:  0010_1101  0x2D   45  -  
  24466	:  0011_0101  0x35   53  5  
  24467	:  0011_0011  0x33   51  3  
  24468	:  0010_1101  0x2D   45  -  
  24469	:  0011_0010  0x32   50  2  
  24470	:  0011_0000  0x30   48  0  
  24471	:  0011_1001  0x39   57  9  
  24472	:  1100_0000  0xC0  192    
  24473	:  0000_1100  0x0C   12    
  24474	:  0000_0000  0x00    0    
  24475	:  0000_0001  0x01    1    
  24476	:  0000_0000  0x00    0    
  24477	:  0000_0001  0x01    1    
  24478	:  0000_0000  0x00    0    
  24479	:  0000_0000  0x00    0    
  24480	:  0010_1010  0x2A   42  *  
  24481	:  0011_0000  0x30   48  0  
  24482	:  0000_0000  0x00    0    
  24483	:  0000_0100  0x04    4    
  24484	:  0010_1101  0x2D   45  -  
  24485	:  0100_0011  0x43   67  C  
  24486	:  0011_0101  0x35   53  5  
  24487	:  1101_0001  0xD1  209    
  24488	:  0000_1000  0x08    8    
  24489	:  0100_0001  0x41   65  A  
  24490	:  0010_1101  0x2D   45  -  
  24491	:  0011_0101  0x35   53  5  
  24492	:  0011_0011  0x33   51  3  
  24493	:  0010_1101  0x2D   45  -  
  24494	:  0011_0010  0x32   50  2  
  24495	:  0011_0001  0x31   49  1  
  24496	:  0011_0000  0x30   48  0  
  24497	:  1100_0000  0xC0  192    
  24498	:  0000_1100  0x0C   12    
  24499	:  0000_0000  0x00    0    
  24500	:  0000_0001  0x01    1    
  24501	:  0000_0000  0x00    0    
  24502	:  0000_0001  0x01    1    
  24503	:  0000_0000  0x00    0    
  24504	:  0000_0000  0x00    0    
  24505	:  0010_1010  0x2A   42  *  
  24506	:  0011_0000  0x30   48  0  
  24507	:  0000_0000  0x00    0    
  24508	:  0000_0100  0x04    4    
  24509	:  0010_1101  0x2D   45  -  
  24510	:  0100_0011  0x43   67  C  
  24511	:  0011_0101  0x35   53  5  
  24512	:  1101_0010  0xD2  210    
  24513	:  0000_1000  0x08    8    
  24514	:  0100_0001  0x41   65  A  
  24515	:  0010_1101  0x2D   45  -  
  24516	:  0011_0101  0x35   53  5  
  24517	:  0011_0011  0x33   51  3  
  24518	:  0010_1101  0x2D   45  -  
  24519	:  0011_0010  0x32   50  2  
  24520	:  0011_0001  0x31   49  1  
  24521	:  0011_0001  0x31   49  1  
  24522	:  1100_0000  0xC0  192    
  24523	:  0000_1100  0x0C   12    
  24524	:  0000_0000  0x00    0    
  24525	:  0000_0001  0x01    1    
  24526	:  0000_0000  0x00    0    
  24527	:  0000_0001  0x01    1    
  24528	:  0000_0000  0x00    0    
  24529	:  0000_0000  0x00    0    
  24530	:  0010_1010  0x2A   42  *  
  24531	:  0011_0000  0x30   48  0  
  24532	:  0000_0000  0x00    0    
  24533	:  0000_0100  0x04    4    
  24534	:  0010_1101  0x2D   45  -  
  24535	:  0100_0011  0x43   67  C  
  24536	:  0011_0101  0x35   53  5  
  24537	:  1101_0011  0xD3  211    
  24538	:  0000_1000  0x08    8    
  24539	:  0100_0001  0x41   65  A  
  24540	:  0010_1101  0x2D   45  -  
  24541	:  0011_0101  0x35   53  5  
  24542	:  0011_0011  0x33   51  3  
  24543	:  0010_1101  0x2D   45  -  
  24544	:  0011_0010  0x32   50  2  
  24545	:  0011_0001  0x31   49  1  
  24546	:  0011_0010  0x32   50  2  
  24547	:  1100_0000  0xC0  192    
  24548	:  0000_1100  0x0C   12    
  24549	:  0000_0000  0x00    0    
  24550	:  0000_0001  0x01    1    
  24551	:  0000_0000  0x00    0    
  24552	:  0000_0001  0x01    1    
  24553	:  0000_0000  0x00    0    
  24554	:  0000_0000  0x00    0    
  24555	:  0010_1010  0x2A   42  *  
  24556	:  0011_0000  0x30   48  0  
  24557	:  0000_0000  0x00    0    
  24558	:  0000_0100  0x04    4    
  24559	:  0010_1101  0x2D   45  -  
  24560	:  0100_0011  0x43   67  C  
  24561	:  0011_0101  0x35   53  5  
  24562	:  1101_0100  0xD4  212    
  24563	:  0000_1000  0x08    8    
  24564	:  0100_0001  0x41   65  A  
  24565	:  0010_1101  0x2D   45  -  
  24566	:  0011_0101  0x35   53  5  
  24567	:  0011_0011  0x33   51  3  
  24568	:  0010_1101  0x2D   45  -  
  24569	:  0011_0010  0x32   50  2  
  24570	:  0011_0001  0x31   49  1  
  24571	:  0011_0011  0x33   51  3  
  24572	:  1100_0000  0xC0  192    
  24573	:  0000_1100  0x0C   12    
  24574	:  0000_0000  0x00    0    
  24575	:  0000_0001  0x01    1    
  24576	:  0000_0000  0x00    0    
  24577	:  0000_0001  0x01    1    
  24578	:  0000_0000  0x00    0    
  24579	:  0000_0000  0x00    0    
  24580	:  0010_1010  0x2A   42  *  
  24581	:  0011_0000  0x30   48  0  
  24582	:  0000_0000  0x00    0    
  24583	:  0000_0100  0x04    4    
  24584	:  0010_1101  0x2D   45  -  
  24585	:  0100_0011  0x43   67  C  
  24586	:  0011_0101  0x35   53  5  
  24587	:  1101_0101  0xD5  213    
  24588	:  0000_1000  0x08    8    
  24589	:  0100_0001  0x41   65  A  
  24590	:  0010_1101  0x2D   45  -  
  24591	:  0011_0101  0x35   53  5  
  24592	:  0011_0011  0x33   51  3  
  24593	:  0010_1101  0x2D   45  -  
  24594	:  0011_0010  0x32   50  2  
  24595	:  0011_0001  0x31   49  1  
  24596	:  0011_0100  0x34   52  4  
  24597	:  1100_0000  0xC0  192    
  24598	:  0000_1100  0x0C   12    
  24599	:  0000_0000  0x00    0    
  24600	:  0000_0001  0x01    1    
  24601	:  0000_0000  0x00    0    
  24602	:  0000_0001  0x01    1    
  24603	:  0000_0000  0x00    0    
  24604	:  0000_0000  0x00    0    
  24605	:  0010_1010  0x2A   42  *  
  24606	:  0011_0000  0x30   48  0  
  24607	:  0000_0000  0x00    0    
  24608	:  0000_0100  0x04    4    
  24609	:  0010_1101  0x2D   45  -  
  24610	:  0100_0011  0x43   67  C  
  24611	:  0011_0101  0x35   53  5  
  24612	:  1101_0110  0xD6  214    
  24613	:  0000_1000  0x08    8    
  24614	:  0100_0001  0x41   65  A  
  24615	:  0010_1101  0x2D   45  -  
  24616	:  0011_0101  0x35   53  5  
  24617	:  0011_0011  0x33   51  3  
  24618	:  0010_1101  0x2D   45  -  
  24619	:  0011_0010  0x32   50  2  
  24620	:  0011_0001  0x31   49  1  
  24621	:  0011_0101  0x35   53  5  
  24622	:  1100_0000  0xC0  192    
  24623	:  0000_1100  0x0C   12    
  24624	:  0000_0000  0x00    0    
  24625	:  0000_0001  0x01    1    
  24626	:  0000_0000  0x00    0    
  24627	:  0000_0001  0x01    1    
  24628	:  0000_0000  0x00    0    
  24629	:  0000_0000  0x00    0    
  24630	:  0010_1010  0x2A   42  *  
  24631	:  0011_0000  0x30   48  0  
  24632	:  0000_0000  0x00    0    
  24633	:  0000_0100  0x04    4    
  24634	:  0010_1101  0x2D   45  -  
  24635	:  0100_0011  0x43   67  C  
  24636	:  0011_0101  0x35   53  5  
  24637	:  1101_0111  0xD7  215    
  24638	:  0000_1000  0x08    8    
  24639	:  0100_0001  0x41   65  A  
  24640	:  0010_1101  0x2D   45  -  
  24641	:  0011_0101  0x35   53  5  
  24642	:  0011_0011  0x33   51  3  
  24643	:  0010_1101  0x2D   45  -  
  24644	:  0011_0010  0x32   50  2  
  24645	:  0011_0001  0x31   49  1  
  24646	:  0011_0110  0x36   54  6  
  24647	:  1100_0000  0xC0  192    
  24648	:  0000_1100  0x0C   12    
  24649	:  0000_0000  0x00    0    
  24650	:  0000_0001  0x01    1    
  24651	:  0000_0000  0x00    0    
  24652	:  0000_0001  0x01    1    
  24653	:  0000_0000  0x00    0    
  24654	:  0000_0000  0x00    0    
  24655	:  0010_1010  0x2A   42  *  
  24656	:  0011_0000  0x30   48  0  
  24657	:  0000_0000  0x00    0    
  24658	:  0000_0100  0x04    4    
  24659	:  0010_1101  0x2D   45  -  
  24660	:  0100_0011  0x43   67  C  
  24661	:  0011_0101  0x35   53  5  
  24662	:  1101_1000  0xD8  216    
  24663	:  0000_1000  0x08    8    
  24664	:  0100_0001  0x41   65  A  
  24665	:  0010_1101  0x2D   45  -  
  24666	:  0011_0101  0x35   53  5  
  24667	:  0011_0011  0x33   51  3  
  24668	:  0010_1101  0x2D   45  -  
  24669	:  0011_0010  0x32   50  2  
  24670	:  0011_0001  0x31   49  1  
  24671	:  0011_0111  0x37   55  7  
  24672	:  1100_0000  0xC0  192    
  24673	:  0000_1100  0x0C   12    
  24674	:  0000_0000  0x00    0    
  24675	:  0000_0001  0x01    1    
  24676	:  0000_0000  0x00    0    
  24677	:  0000_0001  0x01    1    
  24678	:  0000_0000  0x00    0    
  24679	:  0000_0000  0x00    0    
  24680	:  0010_1010  0x2A   42  *  
  24681	:  0011_0000  0x30   48  0  
  24682	:  0000_0000  0x00    0    
  24683	:  0000_0100  0x04    4    
  24684	:  0010_1101  0x2D   45  -  
  24685	:  0100_0011  0x43   67  C  
  24686	:  0011_0101  0x35   53  5  
  24687	:  1101_1001  0xD9  217    
  24688	:  0000_1000  0x08    8    
  24689	:  0100_0001  0x41   65  A  
  24690	:  0010_1101  0x2D   45  -  
  24691	:  0011_0101  0x35   53  5  
  24692	:  0011_0011  0x33   51  3  
  24693	:  0010_1101  0x2D   45  -  
  24694	:  0011_0010  0x32   50  2  
  24695	:  0011_0001  0x31   49  1  
  24696	:  0011_1000  0x38   56  8  
  24697	:  1100_0000  0xC0  192    
  24698	:  0000_1100  0x0C   12    
  24699	:  0000_0000  0x00    0    
  24700	:  0000_0001  0x01    1    
  24701	:  0000_0000  0x00    0    
  24702	:  0000_0001  0x01    1    
  24703	:  0000_0000  0x00    0    
  24704	:  0000_0000  0x00    0    
  24705	:  0010_1010  0x2A   42  *  
  24706	:  0011_0000  0x30   48  0  
  24707	:  0000_0000  0x00    0    
  24708	:  0000_0100  0x04    4    
  24709	:  0010_1101  0x2D   45  -  
  24710	:  0100_0011  0x43   67  C  
  24711	:  0011_0101  0x35   53  5  
  24712	:  1101_1010  0xDA  218    
  24713	:  0000_1000  0x08    8    
  24714	:  0100_0001  0x41   65  A  
  24715	:  0010_1101  0x2D   45  -  
  24716	:  0011_0101  0x35   53  5  
  24717	:  0011_0011  0x33   51  3  
  24718	:  0010_1101  0x2D   45  -  
  24719	:  0011_0010  0x32   50  2  
  24720	:  0011_0001  0x31   49  1  
  24721	:  0011_1001  0x39   57  9  
  24722	:  1100_0000  0xC0  192    
  24723	:  0000_1100  0x0C   12    
  24724	:  0000_0000  0x00    0    
  24725	:  0000_0001  0x01    1    
  24726	:  0000_0000  0x00    0    
  24727	:  0000_0001  0x01    1    
  24728	:  0000_0000  0x00    0    
  24729	:  0000_0000  0x00    0    
  24730	:  0010_1010  0x2A   42  *  
  24731	:  0011_0000  0x30   48  0  
  24732	:  0000_0000  0x00    0    
  24733	:  0000_0100  0x04    4    
  24734	:  0010_1101  0x2D   45  -  
  24735	:  0100_0011  0x43   67  C  
  24736	:  0011_0101  0x35   53  5  
  24737	:  1101_1011  0xDB  219    
  24738	:  0000_1000  0x08    8    
  24739	:  0100_0001  0x41   65  A  
  24740	:  0010_1101  0x2D   45  -  
  24741	:  0011_0101  0x35   53  5  
  24742	:  0011_0011  0x33   51  3  
  24743	:  0010_1101  0x2D   45  -  
  24744	:  0011_0010  0x32   50  2  
  24745	:  0011_0010  0x32   50  2  
  24746	:  0011_0000  0x30   48  0  
  24747	:  1100_0000  0xC0  192    
  24748	:  0000_1100  0x0C   12    
  24749	:  0000_0000  0x00    0    
  24750	:  0000_0001  0x01    1    
  24751	:  0000_0000  0x00    0    
  24752	:  0000_0001  0x01    1    
  24753	:  0000_0000  0x00    0    
  24754	:  0000_0000  0x00    0    
  24755	:  0010_1010  0x2A   42  *  
  24756	:  0011_0000  0x30   48  0  
  24757	:  0000_0000  0x00    0    
  24758	:  0000_0100  0x04    4    
  24759	:  0010_1101  0x2D   45  -  
  24760	:  0100_0011  0x43   67  C  
  24761	:  0011_0101  0x35   53  5  
  24762	:  1101_1100  0xDC  220    
  24763	:  0000_1000  0x08    8    
  24764	:  0100_0001  0x41   65  A  
  24765	:  0010_1101  0x2D   45  -  
  24766	:  0011_0101  0x35   53  5  
  24767	:  0011_0011  0x33   51  3  
  24768	:  0010_1101  0x2D   45  -  
  24769	:  0011_0010  0x32   50  2  
  24770	:  0011_0010  0x32   50  2  
  24771	:  0011_0001  0x31   49  1  
  24772	:  1100_0000  0xC0  192    
  24773	:  0000_1100  0x0C   12    
  24774	:  0000_0000  0x00    0    
  24775	:  0000_0001  0x01    1    
  24776	:  0000_0000  0x00    0    
  24777	:  0000_0001  0x01    1    
  24778	:  0000_0000  0x00    0    
  24779	:  0000_0000  0x00    0    
  24780	:  0010_1010  0x2A   42  *  
  24781	:  0011_0000  0x30   48  0  
  24782	:  0000_0000  0x00    0    
  24783	:  0000_0100  0x04    4    
  24784	:  0010_1101  0x2D   45  -  
  24785	:  0100_0011  0x43   67  C  
  24786	:  0011_0101  0x35   53  5  
  24787	:  1101_1101  0xDD  221    
  24788	:  0000_1000  0x08    8    
  24789	:  0100_0001  0x41   65  A  
  24790	:  0010_1101  0x2D   45  -  
  24791	:  0011_0101  0x35   53  5  
  24792	:  0011_0011  0x33   51  3  
  24793	:  0010_1101  0x2D   45  -  
  24794	:  0011_0010  0x32   50  2  
  24795	:  0011_0010  0x32   50  2  
  24796	:  0011_0010  0x32   50  2  
  24797	:  1100_0000  0xC0  192    
  24798	:  0000_1100  0x0C   12    
  24799	:  0000_0000  0x00    0    
  24800	:  0000_0001  0x01    1    
  24801	:  0000_0000  0x00    0    
  24802	:  0000_0001  0x01    1    
  24803	:  0000_0000  0x00    0    
  24804	:  0000_0000  0x00    0    
  24805	:  0010_1010  0x2A   42  *  
  24806	:  0011_0000  0x30   48  0  
  24807	:  0000_0000  0x00    0    
  24808	:  0000_0100  0x04    4    
  24809	:  0010_1101  0x2D   45  -  
  24810	:  0100_0011  0x43   67  C  
  24811	:  0011_0101  0x35   53  5  
  24812	:  1101_1110  0xDE  222    
  24813	:  0000_1000  0x08    8    
  24814	:  0100_0001  0x41   65  A  
  24815	:  0010_1101  0x2D   45  -  
  24816	:  0011_0101  0x35   53  5  
  24817	:  0011_0011  0x33   51  3  
  24818	:  0010_1101  0x2D   45  -  
  24819	:  0011_0010  0x32   50  2  
  24820	:  0011_0010  0x32   50  2  
  24821	:  0011_0011  0x33   51  3  
  24822	:  1100_0000  0xC0  192    
  24823	:  0000_1100  0x0C   12    
  24824	:  0000_0000  0x00    0    
  24825	:  0000_0001  0x01    1    
  24826	:  0000_0000  0x00    0    
  24827	:  0000_0001  0x01    1    
  24828	:  0000_0000  0x00    0    
  24829	:  0000_0000  0x00    0    
  24830	:  0010_1010  0x2A   42  *  
  24831	:  0011_0000  0x30   48  0  
  24832	:  0000_0000  0x00    0    
  24833	:  0000_0100  0x04    4    
  24834	:  0010_1101  0x2D   45  -  
  24835	:  0100_0011  0x43   67  C  
  24836	:  0011_0101  0x35   53  5  
  24837	:  1101_1111  0xDF  223    
  24838	:  0000_1000  0x08    8    
  24839	:  0100_0001  0x41   65  A  
  24840	:  0010_1101  0x2D   45  -  
  24841	:  0011_0101  0x35   53  5  
  24842	:  0011_0011  0x33   51  3  
  24843	:  0010_1101  0x2D   45  -  
  24844	:  0011_0010  0x32   50  2  
  24845	:  0011_0010  0x32   50  2  
  24846	:  0011_0100  0x34   52  4  
  24847	:  1100_0000  0xC0  192    
  24848	:  0000_1100  0x0C   12    
  24849	:  0000_0000  0x00    0    
  24850	:  0000_0001  0x01    1    
  24851	:  0000_0000  0x00    0    
  24852	:  0000_0001  0x01    1    
  24853	:  0000_0000  0x00    0    
  24854	:  0000_0000  0x00    0    
  24855	:  0010_1010  0x2A   42  *  
  24856	:  0011_0000  0x30   48  0  
  24857	:  0000_0000  0x00    0    
  24858	:  0000_0100  0x04    4    
  24859	:  0010_1101  0x2D   45  -  
  24860	:  0100_0011  0x43   67  C  
  24861	:  0011_0101  0x35   53  5  
  24862	:  1110_0000  0xE0  224    
  24863	:  0000_1000  0x08    8    
  24864	:  0100_0001  0x41   65  A  
  24865	:  0010_1101  0x2D   45  -  
  24866	:  0011_0101  0x35   53  5  
  24867	:  0011_0011  0x33   51  3  
  24868	:  0010_1101  0x2D   45  -  
  24869	:  0011_0010  0x32   50  2  
  24870	:  0011_0010  0x32   50  2  
  24871	:  0011_0101  0x35   53  5  
  24872	:  1100_0000  0xC0  192    
  24873	:  0000_1100  0x0C   12    
  24874	:  0000_0000  0x00    0    
  24875	:  0000_0001  0x01    1    
  24876	:  0000_0000  0x00    0    
  24877	:  0000_0001  0x01    1    
  24878	:  0000_0000  0x00    0    
  24879	:  0000_0000  0x00    0    
  24880	:  0010_1010  0x2A   42  *  
  24881	:  0011_0000  0x30   48  0  
  24882	:  0000_0000  0x00    0    
  24883	:  0000_0100  0x04    4    
  24884	:  0010_1101  0x2D   45  -  
  24885	:  0100_0011  0x43   67  C  
  24886	:  0011_0101  0x35   53  5  
  24887	:  1110_0001  0xE1  225    
  24888	:  0000_1000  0x08    8    
  24889	:  0100_0001  0x41   65  A  
  24890	:  0010_1101  0x2D   45  -  
  24891	:  0011_0101  0x35   53  5  
  24892	:  0011_0011  0x33   51  3  
  24893	:  0010_1101  0x2D   45  -  
  24894	:  0011_0010  0x32   50  2  
  24895	:  0011_0010  0x32   50  2  
  24896	:  0011_0110  0x36   54  6  
  24897	:  1100_0000  0xC0  192    
  24898	:  0000_1100  0x0C   12    
  24899	:  0000_0000  0x00    0    
  24900	:  0000_0001  0x01    1    
  24901	:  0000_0000  0x00    0    
  24902	:  0000_0001  0x01    1    
  24903	:  0000_0000  0x00    0    
  24904	:  0000_0000  0x00    0    
  24905	:  0010_1010  0x2A   42  *  
  24906	:  0011_0000  0x30   48  0  
  24907	:  0000_0000  0x00    0    
  24908	:  0000_0100  0x04    4    
  24909	:  0010_1101  0x2D   45  -  
  24910	:  0100_0011  0x43   67  C  
  24911	:  0011_0101  0x35   53  5  
  24912	:  1110_0010  0xE2  226    
  24913	:  0000_1000  0x08    8    
  24914	:  0100_0001  0x41   65  A  
  24915	:  0010_1101  0x2D   45  -  
  24916	:  0011_0101  0x35   53  5  
  24917	:  0011_0011  0x33   51  3  
  24918	:  0010_1101  0x2D   45  -  
  24919	:  0011_0010  0x32   50  2  
  24920	:  0011_0010  0x32   50  2  
  24921	:  0011_0111  0x37   55  7  
  24922	:  1100_0000  0xC0  192    
  24923	:  0000_1100  0x0C   12    
  24924	:  0000_0000  0x00    0    
  24925	:  0000_0001  0x01    1    
  24926	:  0000_0000  0x00    0    
  24927	:  0000_0001  0x01    1    
  24928	:  0000_0000  0x00    0    
  24929	:  0000_0000  0x00    0    
  24930	:  0010_1010  0x2A   42  *  
  24931	:  0011_0000  0x30   48  0  
  24932	:  0000_0000  0x00    0    
  24933	:  0000_0100  0x04    4    
  24934	:  0010_1101  0x2D   45  -  
  24935	:  0100_0011  0x43   67  C  
  24936	:  0011_0101  0x35   53  5  
  24937	:  1110_0011  0xE3  227    
  24938	:  0000_1000  0x08    8    
  24939	:  0100_0001  0x41   65  A  
  24940	:  0010_1101  0x2D   45  -  
  24941	:  0011_0101  0x35   53  5  
  24942	:  0011_0011  0x33   51  3  
  24943	:  0010_1101  0x2D   45  -  
  24944	:  0011_0010  0x32   50  2  
  24945	:  0011_0010  0x32   50  2  
  24946	:  0011_1000  0x38   56  8  
  24947	:  1100_0000  0xC0  192    
  24948	:  0000_1100  0x0C   12    
  24949	:  0000_0000  0x00    0    
  24950	:  0000_0001  0x01    1    
  24951	:  0000_0000  0x00    0    
  24952	:  0000_0001  0x01    1    
  24953	:  0000_0000  0x00    0    
  24954	:  0000_0000  0x00    0    
  24955	:  0010_1010  0x2A   42  *  
  24956	:  0011_0000  0x30   48  0  
  24957	:  0000_0000  0x00    0    
  24958	:  0000_0100  0x04    4    
  24959	:  0010_1101  0x2D   45  -  
  24960	:  0100_0011  0x43   67  C  
  24961	:  0011_0101  0x35   53  5  
  24962	:  1110_0100  0xE4  228    
  24963	:  0000_1000  0x08    8    
  24964	:  0100_0001  0x41   65  A  
  24965	:  0010_1101  0x2D   45  -  
  24966	:  0011_0101  0x35   53  5  
  24967	:  0011_0011  0x33   51  3  
  24968	:  0010_1101  0x2D   45  -  
  24969	:  0011_0010  0x32   50  2  
  24970	:  0011_0010  0x32   50  2  
  24971	:  0011_1001  0x39   57  9  
  24972	:  1100_0000  0xC0  192    
  24973	:  0000_1100  0x0C   12    
  24974	:  0000_0000  0x00    0    
  24975	:  0000_0001  0x01    1    
  24976	:  0000_0000  0x00    0    
  24977	:  0000_0001  0x01    1    
  24978	:  0000_0000  0x00    0    
  24979	:  0000_0000  0x00    0    
  24980	:  0010_1010  0x2A   42  *  
  24981	:  0011_0000  0x30   48  0  
  24982	:  0000_0000  0x00    0    
  24983	:  0000_0100  0x04    4    
  24984	:  0010_1101  0x2D   45  -  
  24985	:  0100_0011  0x43   67  C  
  24986	:  0011_0101  0x35   53  5  
  24987	:  1110_0101  0xE5  229    
  24988	:  0000_1000  0x08    8    
  24989	:  0100_0001  0x41   65  A  
  24990	:  0010_1101  0x2D   45  -  
  24991	:  0011_0101  0x35   53  5  
  24992	:  0011_0011  0x33   51  3  
  24993	:  0010_1101  0x2D   45  -  
  24994	:  0011_0010  0x32   50  2  
  24995	:  0011_0011  0x33   51  3  
  24996	:  0011_0000  0x30   48  0  
  24997	:  1100_0000  0xC0  192    
  24998	:  0000_1100  0x0C   12    
  24999	:  0000_0000  0x00    0    
  25000	:  0000_0001  0x01    1    
  25001	:  0000_0000  0x00    0    
  25002	:  0000_0001  0x01    1    
  25003	:  0000_0000  0x00    0    
  25004	:  0000_0000  0x00    0    
  25005	:  0010_1010  0x2A   42  *  
  25006	:  0011_0000  0x30   48  0  
  25007	:  0000_0000  0x00    0    
  25008	:  0000_0100  0x04    4    
  25009	:  0010_1101  0x2D   45  -  
  25010	:  0100_0011  0x43   67  C  
  25011	:  0011_0101  0x35   53  5  
  25012	:  1110_0110  0xE6  230    
  25013	:  0000_1000  0x08    8    
  25014	:  0100_0001  0x41   65  A  
  25015	:  0010_1101  0x2D   45  -  
  25016	:  0011_0101  0x35   53  5  
  25017	:  0011_0011  0x33   51  3  
  25018	:  0010_1101  0x2D   45  -  
  25019	:  0011_0010  0x32   50  2  
  25020	:  0011_0011  0x33   51  3  
  25021	:  0011_0001  0x31   49  1  
  25022	:  1100_0000  0xC0  192    
  25023	:  0000_1100  0x0C   12    
  25024	:  0000_0000  0x00    0    
  25025	:  0000_0001  0x01    1    
  25026	:  0000_0000  0x00    0    
  25027	:  0000_0001  0x01    1    
  25028	:  0000_0000  0x00    0    
  25029	:  0000_0000  0x00    0    
  25030	:  0010_1010  0x2A   42  *  
  25031	:  0011_0000  0x30   48  0  
  25032	:  0000_0000  0x00    0    
  25033	:  0000_0100  0x04    4    
  25034	:  0010_1101  0x2D   45  -  
  25035	:  0100_0011  0x43   67  C  
  25036	:  0011_0101  0x35   53  5  
  25037	:  1110_0111  0xE7  231    
  25038	:  0000_1000  0x08    8    
  25039	:  0100_0001  0x41   65  A  
  25040	:  0010_1101  0x2D   45  -  
  25041	:  0011_0101  0x35   53  5  
  25042	:  0011_0011  0x33   51  3  
  25043	:  0010_1101  0x2D   45  -  
  25044	:  0011_0010  0x32   50  2  
  25045	:  0011_0011  0x33   51  3  
  25046	:  0011_0010  0x32   50  2  
  25047	:  1100_0000  0xC0  192    
  25048	:  0000_1100  0x0C   12    
  25049	:  0000_0000  0x00    0    
  25050	:  0000_0001  0x01    1    
  25051	:  0000_0000  0x00    0    
  25052	:  0000_0001  0x01    1    
  25053	:  0000_0000  0x00    0    
  25054	:  0000_0000  0x00    0    
  25055	:  0010_1010  0x2A   42  *  
  25056	:  0011_0000  0x30   48  0  
  25057	:  0000_0000  0x00    0    
  25058	:  0000_0100  0x04    4    
  25059	:  0010_1101  0x2D   45  -  
  25060	:  0100_0011  0x43   67  C  
  25061	:  0011_0101  0x35   53  5  
  25062	:  1110_1000  0xE8  232    
  25063	:  0000_1000  0x08    8    
  25064	:  0100_0001  0x41   65  A  
  25065	:  0010_1101  0x2D   45  -  
  25066	:  0011_0101  0x35   53  5  
  25067	:  0011_0011  0x33   51  3  
  25068	:  0010_1101  0x2D   45  -  
  25069	:  0011_0010  0x32   50  2  
  25070	:  0011_0011  0x33   51  3  
  25071	:  0011_0011  0x33   51  3  
  25072	:  1100_0000  0xC0  192    
  25073	:  0000_1100  0x0C   12    
  25074	:  0000_0000  0x00    0    
  25075	:  0000_0001  0x01    1    
  25076	:  0000_0000  0x00    0    
  25077	:  0000_0001  0x01    1    
  25078	:  0000_0000  0x00    0    
  25079	:  0000_0000  0x00    0    
  25080	:  0010_1010  0x2A   42  *  
  25081	:  0011_0000  0x30   48  0  
  25082	:  0000_0000  0x00    0    
  25083	:  0000_0100  0x04    4    
  25084	:  0010_1101  0x2D   45  -  
  25085	:  0100_0011  0x43   67  C  
  25086	:  0011_0101  0x35   53  5  
  25087	:  1110_1001  0xE9  233    
  25088	:  0000_1000  0x08    8    
  25089	:  0100_0001  0x41   65  A  
  25090	:  0010_1101  0x2D   45  -  
  25091	:  0011_0101  0x35   53  5  
  25092	:  0011_0011  0x33   51  3  
  25093	:  0010_1101  0x2D   45  -  
  25094	:  0011_0010  0x32   50  2  
  25095	:  0011_0011  0x33   51  3  
  25096	:  0011_0100  0x34   52  4  
  25097	:  1100_0000  0xC0  192    
  25098	:  0000_1100  0x0C   12    
  25099	:  0000_0000  0x00    0    
  25100	:  0000_0001  0x01    1    
  25101	:  0000_0000  0x00    0    
  25102	:  0000_0001  0x01    1    
  25103	:  0000_0000  0x00    0    
  25104	:  0000_0000  0x00    0    
  25105	:  0010_1010  0x2A   42  *  
  25106	:  0011_0000  0x30   48  0  
  25107	:  0000_0000  0x00    0    
  25108	:  0000_0100  0x04    4    
  25109	:  0010_1101  0x2D   45  -  
  25110	:  0100_0011  0x43   67  C  
  25111	:  0011_0101  0x35   53  5  
  25112	:  1110_1010  0xEA  234    
  25113	:  0000_1000  0x08    8    
  25114	:  0100_0001  0x41   65  A  
  25115	:  0010_1101  0x2D   45  -  
  25116	:  0011_0101  0x35   53  5  
  25117	:  0011_0011  0x33   51  3  
  25118	:  0010_1101  0x2D   45  -  
  25119	:  0011_0010  0x32   50  2  
  25120	:  0011_0011  0x33   51  3  
  25121	:  0011_0101  0x35   53  5  
  25122	:  1100_0000  0xC0  192    
  25123	:  0000_1100  0x0C   12    
  25124	:  0000_0000  0x00    0    
  25125	:  0000_0001  0x01    1    
  25126	:  0000_0000  0x00    0    
  25127	:  0000_0001  0x01    1    
  25128	:  0000_0000  0x00    0    
  25129	:  0000_0000  0x00    0    
  25130	:  0010_1010  0x2A   42  *  
  25131	:  0011_0000  0x30   48  0  
  25132	:  0000_0000  0x00    0    
  25133	:  0000_0100  0x04    4    
  25134	:  0010_1101  0x2D   45  -  
  25135	:  0100_0011  0x43   67  C  
  25136	:  0011_0101  0x35   53  5  
  25137	:  1110_1011  0xEB  235    
  25138	:  0000_1000  0x08    8    
  25139	:  0100_0001  0x41   65  A  
  25140	:  0010_1101  0x2D   45  -  
  25141	:  0011_0101  0x35   53  5  
  25142	:  0011_0011  0x33   51  3  
  25143	:  0010_1101  0x2D   45  -  
  25144	:  0011_0010  0x32   50  2  
  25145	:  0011_0011  0x33   51  3  
  25146	:  0011_0110  0x36   54  6  
  25147	:  1100_0000  0xC0  192    
  25148	:  0000_1100  0x0C   12    
  25149	:  0000_0000  0x00    0    
  25150	:  0000_0001  0x01    1    
  25151	:  0000_0000  0x00    0    
  25152	:  0000_0001  0x01    1    
  25153	:  0000_0000  0x00    0    
  25154	:  0000_0000  0x00    0    
  25155	:  0010_1010  0x2A   42  *  
  25156	:  0011_0000  0x30   48  0  
  25157	:  0000_0000  0x00    0    
  25158	:  0000_0100  0x04    4    
  25159	:  0010_1101  0x2D   45  -  
  25160	:  0100_0011  0x43   67  C  
  25161	:  0011_0101  0x35   53  5  
  25162	:  1110_1100  0xEC  236    
  25163	:  0000_1000  0x08    8    
  25164	:  0100_0001  0x41   65  A  
  25165	:  0010_1101  0x2D   45  -  
  25166	:  0011_0101  0x35   53  5  
  25167	:  0011_0011  0x33   51  3  
  25168	:  0010_1101  0x2D   45  -  
  25169	:  0011_0010  0x32   50  2  
  25170	:  0011_0011  0x33   51  3  
  25171	:  0011_0111  0x37   55  7  
  25172	:  1100_0000  0xC0  192    
  25173	:  0000_1100  0x0C   12    
  25174	:  0000_0000  0x00    0    
  25175	:  0000_0001  0x01    1    
  25176	:  0000_0000  0x00    0    
  25177	:  0000_0001  0x01    1    
  25178	:  0000_0000  0x00    0    
  25179	:  0000_0000  0x00    0    
  25180	:  0010_1010  0x2A   42  *  
  25181	:  0011_0000  0x30   48  0  
  25182	:  0000_0000  0x00    0    
  25183	:  0000_0100  0x04    4    
  25184	:  0010_1101  0x2D   45  -  
  25185	:  0100_0011  0x43   67  C  
  25186	:  0011_0101  0x35   53  5  
  25187	:  1110_1101  0xED  237    
  25188	:  0000_1000  0x08    8    
  25189	:  0100_0001  0x41   65  A  
  25190	:  0010_1101  0x2D   45  -  
  25191	:  0011_0101  0x35   53  5  
  25192	:  0011_0011  0x33   51  3  
  25193	:  0010_1101  0x2D   45  -  
  25194	:  0011_0010  0x32   50  2  
  25195	:  0011_0011  0x33   51  3  
  25196	:  0011_1000  0x38   56  8  
  25197	:  1100_0000  0xC0  192    
  25198	:  0000_1100  0x0C   12    
  25199	:  0000_0000  0x00    0    
  25200	:  0000_0001  0x01    1    
  25201	:  0000_0000  0x00    0    
  25202	:  0000_0001  0x01    1    
  25203	:  0000_0000  0x00    0    
  25204	:  0000_0000  0x00    0    
  25205	:  0010_1010  0x2A   42  *  
  25206	:  0011_0000  0x30   48  0  
  25207	:  0000_0000  0x00    0    
  25208	:  0000_0100  0x04    4    
  25209	:  0010_1101  0x2D   45  -  
  25210	:  0100_0011  0x43   67  C  
  25211	:  0011_0101  0x35   53  5  
  25212	:  1110_1110  0xEE  238    
  25213	:  0000_1000  0x08    8    
  25214	:  0100_0001  0x41   65  A  
  25215	:  0010_1101  0x2D   45  -  
  25216	:  0011_0101  0x35   53  5  
  25217	:  0011_0011  0x33   51  3  
  25218	:  0010_1101  0x2D   45  -  
  25219	:  0011_0010  0x32   50  2  
  25220	:  0011_0011  0x33   51  3  
  25221	:  0011_1001  0x39   57  9  
  25222	:  1100_0000  0xC0  192    
  25223	:  0000_1100  0x0C   12    
  25224	:  0000_0000  0x00    0    
  25225	:  0000_0001  0x01    1    
  25226	:  0000_0000  0x00    0    
  25227	:  0000_0001  0x01    1    
  25228	:  0000_0000  0x00    0    
  25229	:  0000_0000  0x00    0    
  25230	:  0010_1010  0x2A   42  *  
  25231	:  0011_0000  0x30   48  0  
  25232	:  0000_0000  0x00    0    
  25233	:  0000_0100  0x04    4    
  25234	:  0010_1101  0x2D   45  -  
  25235	:  0100_0011  0x43   67  C  
  25236	:  0011_0101  0x35   53  5  
  25237	:  1110_1111  0xEF  239    
  25238	:  0000_1000  0x08    8    
  25239	:  0100_0001  0x41   65  A  
  25240	:  0010_1101  0x2D   45  -  
  25241	:  0011_0101  0x35   53  5  
  25242	:  0011_0011  0x33   51  3  
  25243	:  0010_1101  0x2D   45  -  
  25244	:  0011_0010  0x32   50  2  
  25245	:  0011_0100  0x34   52  4  
  25246	:  0011_0000  0x30   48  0  
  25247	:  1100_0000  0xC0  192    
  25248	:  0000_1100  0x0C   12    
  25249	:  0000_0000  0x00    0    
  25250	:  0000_0001  0x01    1    
  25251	:  0000_0000  0x00    0    
  25252	:  0000_0001  0x01    1    
  25253	:  0000_0000  0x00    0    
  25254	:  0000_0000  0x00    0    
  25255	:  0010_1010  0x2A   42  *  
  25256	:  0011_0000  0x30   48  0  
  25257	:  0000_0000  0x00    0    
  25258	:  0000_0100  0x04    4    
  25259	:  0010_1101  0x2D   45  -  
  25260	:  0100_0011  0x43   67  C  
  25261	:  0011_0101  0x35   53  5  
  25262	:  1111_0000  0xF0  240    
  25263	:  0000_1000  0x08    8    
  25264	:  0100_0001  0x41   65  A  
  25265	:  0010_1101  0x2D   45  -  
  25266	:  0011_0101  0x35   53  5  
  25267	:  0011_0011  0x33   51  3  
  25268	:  0010_1101  0x2D   45  -  
  25269	:  0011_0010  0x32   50  2  
  25270	:  0011_0100  0x34   52  4  
  25271	:  0011_0001  0x31   49  1  
  25272	:  1100_0000  0xC0  192    
  25273	:  0000_1100  0x0C   12    
  25274	:  0000_0000  0x00    0    
  25275	:  0000_0001  0x01    1    
  25276	:  0000_0000  0x00    0    
  25277	:  0000_0001  0x01    1    
  25278	:  0000_0000  0x00    0    
  25279	:  0000_0000  0x00    0    
  25280	:  0010_1010  0x2A   42  *  
  25281	:  0011_0000  0x30   48  0  
  25282	:  0000_0000  0x00    0    
  25283	:  0000_0100  0x04    4    
  25284	:  0010_1101  0x2D   45  -  
  25285	:  0100_0011  0x43   67  C  
  25286	:  0011_0101  0x35   53  5  
  25287	:  1111_0001  0xF1  241    
  25288	:  0000_1000  0x08    8    
  25289	:  0100_0001  0x41   65  A  
  25290	:  0010_1101  0x2D   45  -  
  25291	:  0011_0101  0x35   53  5  
  25292	:  0011_0011  0x33   51  3  
  25293	:  0010_1101  0x2D   45  -  
  25294	:  0011_0010  0x32   50  2  
  25295	:  0011_0100  0x34   52  4  
  25296	:  0011_0010  0x32   50  2  
  25297	:  1100_0000  0xC0  192    
  25298	:  0000_1100  0x0C   12    
  25299	:  0000_0000  0x00    0    
  25300	:  0000_0001  0x01    1    
  25301	:  0000_0000  0x00    0    
  25302	:  0000_0001  0x01    1    
  25303	:  0000_0000  0x00    0    
  25304	:  0000_0000  0x00    0    
  25305	:  0010_1010  0x2A   42  *  
  25306	:  0011_0000  0x30   48  0  
  25307	:  0000_0000  0x00    0    
  25308	:  0000_0100  0x04    4    
  25309	:  0010_1101  0x2D   45  -  
  25310	:  0100_0011  0x43   67  C  
  25311	:  0011_0101  0x35   53  5  
  25312	:  1111_0010  0xF2  242    
  25313	:  0000_1000  0x08    8    
  25314	:  0100_0001  0x41   65  A  
  25315	:  0010_1101  0x2D   45  -  
  25316	:  0011_0101  0x35   53  5  
  25317	:  0011_0011  0x33   51  3  
  25318	:  0010_1101  0x2D   45  -  
  25319	:  0011_0010  0x32   50  2  
  25320	:  0011_0100  0x34   52  4  
  25321	:  0011_0011  0x33   51  3  
  25322	:  1100_0000  0xC0  192    
  25323	:  0000_1100  0x0C   12    
  25324	:  0000_0000  0x00    0    
  25325	:  0000_0001  0x01    1    
  25326	:  0000_0000  0x00    0    
  25327	:  0000_0001  0x01    1    
  25328	:  0000_0000  0x00    0    
  25329	:  0000_0000  0x00    0    
  25330	:  0010_1010  0x2A   42  *  
  25331	:  0011_0000  0x30   48  0  
  25332	:  0000_0000  0x00    0    
  25333	:  0000_0100  0x04    4    
  25334	:  0010_1101  0x2D   45  -  
  25335	:  0100_0011  0x43   67  C  
  25336	:  0011_0101  0x35   53  5  
  25337	:  1111_0011  0xF3  243    
  25338	:  0000_1000  0x08    8    
  25339	:  0100_0001  0x41   65  A  
  25340	:  0010_1101  0x2D   45  -  
  25341	:  0011_0101  0x35   53  5  
  25342	:  0011_0011  0x33   51  3  
  25343	:  0010_1101  0x2D   45  -  
  25344	:  0011_0010  0x32   50  2  
  25345	:  0011_0100  0x34   52  4  
  25346	:  0011_0100  0x34   52  4  
  25347	:  1100_0000  0xC0  192    
  25348	:  0000_1100  0x0C   12    
  25349	:  0000_0000  0x00    0    
  25350	:  0000_0001  0x01    1    
  25351	:  0000_0000  0x00    0    
  25352	:  0000_0001  0x01    1    
  25353	:  0000_0000  0x00    0    
  25354	:  0000_0000  0x00    0    
  25355	:  0010_1010  0x2A   42  *  
  25356	:  0011_0000  0x30   48  0  
  25357	:  0000_0000  0x00    0    
  25358	:  0000_0100  0x04    4    
  25359	:  0010_1101  0x2D   45  -  
  25360	:  0100_0011  0x43   67  C  
  25361	:  0011_0101  0x35   53  5  
  25362	:  1111_0100  0xF4  244    
  25363	:  0000_1000  0x08    8    
  25364	:  0100_0001  0x41   65  A  
  25365	:  0010_1101  0x2D   45  -  
  25366	:  0011_0101  0x35   53  5  
  25367	:  0011_0011  0x33   51  3  
  25368	:  0010_1101  0x2D   45  -  
  25369	:  0011_0010  0x32   50  2  
  25370	:  0011_0100  0x34   52  4  
  25371	:  0011_0101  0x35   53  5  
  25372	:  1100_0000  0xC0  192    
  25373	:  0000_1100  0x0C   12    
  25374	:  0000_0000  0x00    0    
  25375	:  0000_0001  0x01    1    
  25376	:  0000_0000  0x00    0    
  25377	:  0000_0001  0x01    1    
  25378	:  0000_0000  0x00    0    
  25379	:  0000_0000  0x00    0    
  25380	:  0010_1010  0x2A   42  *  
  25381	:  0011_0000  0x30   48  0  
  25382	:  0000_0000  0x00    0    
  25383	:  0000_0100  0x04    4    
  25384	:  0010_1101  0x2D   45  -  
  25385	:  0100_0011  0x43   67  C  
  25386	:  0011_0101  0x35   53  5  
  25387	:  1111_0101  0xF5  245    
  25388	:  0000_1000  0x08    8    
  25389	:  0100_0001  0x41   65  A  
  25390	:  0010_1101  0x2D   45  -  
  25391	:  0011_0101  0x35   53  5  
  25392	:  0011_0011  0x33   51  3  
  25393	:  0010_1101  0x