use strict;
use warnings;
package MetaCPAN::Client::Mirror;
# ABSTRACT: A Mirror data object
$MetaCPAN::Client::Mirror::VERSION = '1.016000';
use Moo;
use Carp;

with 'MetaCPAN::Client::Role::Entity';

my @known_fields = qw< name org ftp contact city rsync src ccode
                       aka_name tz note dnsrr region inceptdate
                       country location freq continent http
                       reitredate A_or_CNAME >;

foreach my $field (@known_fields) {
    has $field => (
        is      => 'ro',
        lazy    => 1,
        default => sub {
            my $self = shift;
            return $self->data->{$field};
        },
    );
}

sub _known_fields { return \@known_fields }


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

MetaCPAN::Client::Mirror - A Mirror data object

=head1 VERSION

version 1.016000

=head1 
DESCRIPTION

=head1 
ATTRIBUTES

=head2 name

=head2 org

=head2 ftp

=head2 contact

=head2 city

=head2 rsync

=head2 src

=head2 ccode

=head2 aka_name

=head2 tz

=head2 note

=head2 dnsrr

=head2 region

=head2 inceptdate

=head2 country

=head2 location

=head2 freq

=head2 continent

=head2 http

=head2 reitredate

=head2 A_or_CNAME

=head1 METHODS

=head1 AUTHORS

=over 4

=item *

Sawyer X <xsawyerx@cpan.org>

=item *

Mickey Nasriachi <mickey@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Sawyer X.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
