#!/usr/bin/perl
use strict;
use warnings;

use Test::More tests => 5;
BEGIN { use_ok('Image::OpenALPR') };

my $alpr = Image::OpenALPR->new('eu');
$alpr->set_top_n(3);
my @plates = $alpr->recognise('t/ex.jpg');
is @plates, 1, 'Found only one plate';
is $plates[0]->plate, 'ZP36709', 'plate number';
cmp_ok $plates[0]->confidence, '>=', 80, 'high confidence';
my @cands = $plates[0]->candidates;
is @cands, 3, 'number of candidates matches top_n';
