// Copyright (C) 2006, The Perl Foundation.
// $Id: antlr_past2pir_past.g 12965 2006-06-18 13:12:15Z bernhard $

// Transform ANTLR PAST to PIR that sets up PAST and does the execution

tree grammar AntlrPast2PirPast;

options
{
  ASTLabelType = CommonTree;
  tokenVocab   = 'grammar/antlr_3/BcParser';
}

gen_pir_past 
  :
  {
    String pirBefore = "" 
          + "#!/usr/bin/env parrot" + "\n"
          + "\n"
          + "# Do not edit this file." + "\n"
          + "# This file has been generated by Bc.java." + "\n"
          + "\n"
          + ".sub bc :main" + "\n"
          + "  load_bytecode 'languages/punie/lib/ASTGrammar.pir'" + "\n"
          + "  load_bytecode 'TGE.pbc'" + "\n"
          + "  load_bytecode 'PAST.pbc'" + "\n"
          + "  load_bytecode 'languages/punie/lib/POST.pir'" + "\n"
          + "  load_bytecode 'languages/punie/lib/OSTGrammar.pir'" + "\n"
          + "\n"
          ;

    System.out.println( pirBefore );    
  }
    ^(PROGRAM expr+ )
    {
      String pirAfter = "" 
          + "# entering gen_pir_past" + "\n"
          + "  .local pmc stmts" + "\n"
          + "  stmts = new 'PAST::Stmts'" + "\n"
          + "  stmts.'add_child'( \$P50 )" + "\n"
          + "  stmts.'add_child'( \$P100 )" + "\n"
          + "  stmts.'source'('1')" + "\n"
          + "  stmts.'pos'(1)" + "\n"
          + "\n"
          + "  # Compile the abstract syntax tree down to an opcode syntax tree" + "\n"
          + "  .local string ost_tg_source" + "\n"
          + "  ost_tg_source = _slurp_file('languages/punie/lib/OSTGrammar.tg')" + "\n"
          + "  .local pmc tge_compiler, ost_grammar" + "\n"
          + "  tge_compiler = new 'TGE::Compiler'" + "\n"
          + "  ost_grammar = tge_compiler.'compile'(ost_tg_source)" + "\n"
          + "  .local pmc ost_builder" + "\n"
          + "  ost_builder = ost_grammar.apply(stmts)" + "\n"
          + "  .local pmc ost" + "\n"
          + "  ost = ost_builder.get('result')" + "\n"
          + "  \$I0 = defined ost" + "\n"
          + "  unless \$I0 goto err_no_ost # if OST fails stop" + "\n"
          + "\n"
          + "  # Compile the OST down to PIR" + "\n"
          + "  .local string pir_tg_source" + "\n"
          + "  pir_tg_source = _slurp_file('languages/punie/lib/PIRGrammar.tg')" + "\n"
          + "  .local pmc pir_grammar" + "\n"
          + "  pir_grammar = tge_compiler.'compile'(pir_tg_source)" + "\n"
          + "  .local pmc pir_builder" + "\n"
          + "  pir_builder = pir_grammar.apply(ost)" + "\n"
          + "  .local pmc pir" + "\n"
          + "  pir = pir_builder.get('result')" + "\n"
          + "  unless pir goto err_no_pir # if PIR not generated, stop" + "\n"
          + "\n"
          + "  # Execute" + "\n"
          + "  .local pmc pir_compiler" + "\n"
          + "  .local pmc pir_compiled" + "\n"
          + "  pir_compiler = compreg \"PIR\"" + "\n"
          + "  pir_compiled = pir_compiler( pir )" + "\n"
          + "\n"
          + "  pir_compiled()" + "\n"
          + "\n"
          + "  print \"\\n\"" + "\n"
          + "\n"
          + "  end" + "\n"
          + "\n"
          + "  err_match_fail:" + "\n"
          + "    print \"parse failed\\n\"" + "\n"
          + "    goto cleanup" + "\n"
          + "\n"
          + "  err_no_ast:" + "\n"
          + "    print 'Unable to construct AST.'" + "\n"
          + "    goto cleanup" + "\n"
          + "\n"
          + "  err_no_ost:" + "\n"
          + "    print 'Unable to construct OST.'" + "\n"
          + "    goto cleanup" + "\n"
          + "\n"
          + "  err_no_pir:" + "\n"
          + "    print 'Unable to construct PIR.'" + "\n"
          + "    goto cleanup" + "\n"
          + "\n"
          + "  cleanup:" + "\n"
          + ".end" + "\n"
          + "\n"
          + ".sub _slurp_file" + "\n"
          + "  .param string filename" + "\n"
          + "  .local pmc filehandle" + "\n"
          + "  filehandle = open filename, '<'" + "\n"
          + "  unless filehandle goto err_no_file" + "\n"
          + "  \$S1 = read filehandle, 65535" + "\n"
          + "  close filehandle" + "\n"
          + "  .return (\$S1)" + "\n"
          + "  err_no_file:" + "\n"
          + "    print 'Unable to open file: '" + "\n"
          + "    print filename" + "\n"
          + "    end" + "\n"
          + ".end" + "\n"
          + "# leaving gen_pir_past" + "\n"
          ;

       System.out.print( pirAfter );    
    }
  ;

expr_int_1
  : INT
  ;


expr returns [String reg]
  @init
  {
    $reg = "reg_expr";
  }
  : expr_int_1
    {
      String pir = "" 
          + "# entering expr" + "\n"
          + ".local pmc " + $reg + "\n"
          + $reg + " = new 'PAST::Val'" + "\n"
          + $reg + ".value( " + $expr_int_1.text + " )" + "\n"
          + $reg + ".'source'('1')" + "\n"
          + $reg + ".'pos'(0)" + "\n"
          + $reg + ".valtype( 'num' )" + "\n"
          + "# leaving expr" + "\n"
          + "               \$P20 = new 'PAST::Exp' " + "\n"
          + "               \$P20.'add_child'( " + $reg + " )" + "\n"
          + "               \$P20.'source'('1')" + "\n"
          + "               \$P20.'pos'(1)" + "\n"
          + "       \$P30 = new 'PAST::Op' " + "\n"
          + "       \$P30.'add_child'( \$P20 )" + "\n"
          + "       \$P30.'op'( 'print' )" + "\n"
          + "       \$P30.'source'('1')" + "\n"
          + "       \$P30.'pos'(1)" + "\n"
          + "               \$P40 = new 'PAST::Exp' " + "\n"
          + "               \$P40.'add_child'( \$P30 )" + "\n"
          + "               \$P40.'source'('1')" + "\n"
          + "               \$P40.'pos'(1)" + "\n"
          + "  \$P50 = new 'PAST::Stmt' " + "\n"
          + "  \$P50.'add_child'( \$P40 )" + "\n"
          + "  \$P50.'source'('1')" + "\n"
          + "  \$P50.'pos'(1)" + "\n"
          + "               \$P60 = new 'PAST::Val' " + "\n"
          + "               \$P60.value( '\\n' ) " + "\n"
          + "               \$P60.'source'('1')" + "\n"
          + "               \$P60.'pos'(0)" + "\n"
          + "               \$P60.valtype( 'strqq' ) " + "\n"
          + "               \$P70 = new 'PAST::Exp' " + "\n"
          + "               \$P70.'add_child'( \$P60 )" + "\n"
          + "               \$P70.'source'('1')" + "\n"
          + "               \$P70.'pos'(1)" + "\n"
          + "       \$P80 = new 'PAST::Op' " + "\n"
          + "       \$P80.'add_child'( \$P70 )" + "\n"
          + "       \$P80.'op'( 'print' )" + "\n"
          + "       \$P80.'source'('1')" + "\n"
          + "       \$P80.'pos'(1)" + "\n"
          + "               \$P90 = new 'PAST::Exp' " + "\n"
          + "               \$P90.'add_child'( \$P80 )" + "\n"
          + "               \$P90.'source'('1')" + "\n"
          + "               \$P90.'pos'(1)" + "\n"
          + "  \$P100 = new 'PAST::Stmt' " + "\n"
          + "  \$P100.'add_child'( \$P90 )" + "\n"
          + "  \$P100.'source'('1')" + "\n"
          + "  \$P100.'pos'(1)" + "\n"
          + "\n"
          ;
      System.out.println( pir );    
    }
  ;
