#! perl --			-*- coding: utf-8 -*-

use utf8;

package main;

use strict;
use warnings;

use EekBoek;
use EB;
use EB::Tools::MiniAdm;
use Archive::Zip qw( :ERROR_CODES :CONSTANTS );

our $app;
our $cfg;
our $bin;

our @ebz;			# ( [ "filename.ebz", "flags" ], [...], ... )

my @configs = ( qw( schema.dat mutaties.eb relaties.eb opening.eb ) );

package EB::Wx::IniWiz;

use base qw(Wx::Frame);

use EB;
use File::Spec;
use File::Basename;
use File::Glob ( $] >= 5.014 ? ":bsd_glob" : ":glob" );

my @db_drivers;
my @adm_dirs;
my @adm_names;

my $runeb;

my $default = _T("--standaard--");

use Wx qw[
	  wxADJUST_MINSIZE
	  wxALIGN_CENTER_VERTICAL
	  wxALL
	  wxBITMAP_TYPE_ANY
	  wxBOTTOM
	  wxCANCEL
	  wxCONFIG_USE_LOCAL_FILE
	  wxDEFAULT_FRAME_STYLE
	  wxDefaultPosition
	  wxDefaultSize
	  wxEXPAND
	  wxHORIZONTAL
	  wxICON_ERROR
	  wxICON_INFORMATION
	  wxID_CANCEL
	  wxID_NEW
	  wxID_OK
	  wxID_OPEN
	  wxID_REMOVE
	  wxLEFT
	  wxNORMAL
	  wxOK
	  wxRA_SPECIFY_ROWS
	  wxRIGHT
	  wxSP_ARROW_KEYS
	  wxTELETYPE
	  wxTE_AUTO_URL
	  wxTE_MULTILINE
	  wxTE_PASSWORD
	  wxTE_READONLY
	  wxTOP
	  wxVERTICAL
       ];

# Dummy as of Wx 2.8, but still generated by wxGlade.
{ no warnings 'redefine'; sub wxADJUST_MINSIZE() { 0 } }

# The wizard panels.
my $wp;
for ( qw( select admname btw batch db confirm ) ) {
    $wp->{$_} = sprintf("wiz_p%02d", 0+keys(%$wp));
}

sub new {
	my( $self, $parent, $id, $title, $pos, $size, $style, $name ) = @_;
	$parent = undef              unless defined $parent;
	$id     = -1                 unless defined $id;
	$title  = ""                 unless defined $title;
	$pos    = wxDefaultPosition  unless defined $pos;
	$size   = wxDefaultSize      unless defined $size;
	$name   = ""                 unless defined $name;

# begin wxGlade: EB::Wx::IniWiz::new

	$style = wxDEFAULT_FRAME_STYLE 
		unless defined $style;

	$self = $self->SUPER::new( $parent, $id, $title, $pos, $size, $style, $name );
	$self->{p_dummy} = Wx::Panel->new($self, -1, wxDefaultPosition, wxDefaultSize, );
	$self->{wiz_p05} = Wx::WizardPanel->new($self->{p_dummy}, -1, wxDefaultPosition, wxDefaultSize, );
	$self->{wiz_p04} = Wx::WizardPanel->new($self->{p_dummy}, -1, wxDefaultPosition, wxDefaultSize, );
	$self->{wiz_p03} = Wx::WizardPanel->new($self->{p_dummy}, -1, wxDefaultPosition, wxDefaultSize, );
	$self->{wiz_p02} = Wx::WizardPanel->new($self->{p_dummy}, -1, wxDefaultPosition, wxDefaultSize, );
	$self->{wiz_p01} = Wx::WizardPanel->new($self->{p_dummy}, -1, wxDefaultPosition, wxDefaultSize, );
	$self->{sizer_5_staticbox} = Wx::StaticBox->new($self->{wiz_p01}, -1, _T("Administratie") );
	$self->{sizer_8_staticbox} = Wx::StaticBox->new($self->{wiz_p02}, -1, _T("BTW") );
	$self->{sizer_6_staticbox} = Wx::StaticBox->new($self->{wiz_p03}, -1, _T("Dagboeken") );
	$self->{sizer_4_staticbox} = Wx::StaticBox->new($self->{wiz_p04}, -1, _T("Database") );
	$self->{sizer_2_staticbox} = Wx::StaticBox->new($self->{wiz_p05}, -1, _T("Bevestiging") );
	$self->{wiz_p00} = Wx::WizardPanel->new($self->{p_dummy}, -1, wxDefaultPosition, wxDefaultSize, );
	$self->{t_main} = Wx::TextCtrl->new($self->{p_dummy}, -1, "", wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY);
	$self->{ch_runeb} = Wx::CheckBox->new($self->{p_dummy}, -1, _T("EekBoek opstarten"), wxDefaultPosition, wxDefaultSize, );
	$self->{b_details} = Wx::Button->new($self->{p_dummy}, -1, _T("Details..."));
	$self->{b_ok} = Wx::Button->new($self->{p_dummy}, wxID_OK, "");
	$self->{label_2} = Wx::StaticText->new($self->{wiz_p00}, -1, _T("Welkom bij de EekBoek administratie-wizard."), wxDefaultPosition, wxDefaultSize, );
	$self->{rb_select} = Wx::RadioBox->new($self->{wiz_p00}, -1, _T("Maak uw keuze"), wxDefaultPosition, wxDefaultSize, [_T("Een nieuwe administratie aanmaken"), _T("Verbinden met een bestaande administratie")], 0, wxRA_SPECIFY_ROWS);
	$self->{label_3} = Wx::StaticText->new($self->{wiz_p01}, -1, _T("Naam"), wxDefaultPosition, wxDefaultSize, );
	$self->{t_adm_name} = Wx::TextCtrl->new($self->{wiz_p01}, -1, _T("Mijn eerste EekBoek"), wxDefaultPosition, wxDefaultSize, );
	$self->{label_10} = Wx::StaticText->new($self->{wiz_p01}, -1, _T("Code"), wxDefaultPosition, wxDefaultSize, );
	$self->{t_adm_code} = Wx::TextCtrl->new($self->{wiz_p01}, -1, "", wxDefaultPosition, wxDefaultSize, );
	$self->{l_begin_date_1} = Wx::StaticText->new($self->{wiz_p01}, -1, _T("Begindatum"), wxDefaultPosition, wxDefaultSize, );
	$self->{l_begin_date_2} = Wx::StaticText->new($self->{wiz_p01}, -1, _T("01-01-"), wxDefaultPosition, wxDefaultSize, );
	$self->{sp_adm_begin} = Wx::SpinCtrl->new($self->{wiz_p01}, -1, "", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS|wxTE_AUTO_URL, 0, 100, );
	$self->{l_template} = Wx::StaticText->new($self->{wiz_p01}, -1, _T("Sjabloon"), wxDefaultPosition, wxDefaultSize, );
	$self->{ch_template} = Wx::Choice->new($self->{wiz_p01}, -1, wxDefaultPosition, wxDefaultSize, [_T("Lege administratie")], );
	$self->{cb_btw} = Wx::CheckBox->new($self->{wiz_p02}, -1, _T("BTW toepassen op deze administratie"), wxDefaultPosition, wxDefaultSize, );
	$self->{l_btw_period} = Wx::StaticText->new($self->{wiz_p02}, -1, _T("Aangifteperiode"), wxDefaultPosition, wxDefaultSize, );
	$self->{ch_btw_period} = Wx::Choice->new($self->{wiz_p02}, -1, wxDefaultPosition, wxDefaultSize, [_T("Maand"), _T("Kwartaal"), _T("Jaar")], );
	$self->{cb_debiteuren} = Wx::CheckBox->new($self->{wiz_p03}, -1, _T("Verkoop"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_crediteuren} = Wx::CheckBox->new($self->{wiz_p03}, -1, _T("Inkoop"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_kas} = Wx::CheckBox->new($self->{wiz_p03}, -1, _T("Kas"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_bank} = Wx::CheckBox->new($self->{wiz_p03}, -1, _T("Bank"), wxDefaultPosition, wxDefaultSize, );
	$self->{label_1} = Wx::StaticText->new($self->{wiz_p04}, -1, _T("Database naam"), wxDefaultPosition, wxDefaultSize, );
	$self->{t_db_name} = Wx::TextCtrl->new($self->{wiz_p04}, -1, "", wxDefaultPosition, wxDefaultSize, );
	$self->{label_db_type} = Wx::StaticText->new($self->{wiz_p04}, -1, _T("Database type"), wxDefaultPosition, wxDefaultSize, );
	$self->{ch_db_driver} = Wx::Choice->new($self->{wiz_p04}, -1, wxDefaultPosition, wxDefaultSize, [_T("PostgreSQL"), _T("SQLite")], );
	$self->{label_db_host} = Wx::StaticText->new($self->{wiz_p04}, -1, _T("Server host"), wxDefaultPosition, wxDefaultSize, );
	$self->{t_db_host} = Wx::TextCtrl->new($self->{wiz_p04}, -1, "", wxDefaultPosition, wxDefaultSize, );
	$self->{label_db_port} = Wx::StaticText->new($self->{wiz_p04}, -1, _T("Server port"), wxDefaultPosition, wxDefaultSize, );
	$self->{t_db_port} = Wx::TextCtrl->new($self->{wiz_p04}, -1, "", wxDefaultPosition, wxDefaultSize, );
	$self->{label_db_user} = Wx::StaticText->new($self->{wiz_p04}, -1, _T("Database user"), wxDefaultPosition, wxDefaultSize, );
	$self->{t_db_user} = Wx::TextCtrl->new($self->{wiz_p04}, -1, "", wxDefaultPosition, wxDefaultSize, );
	$self->{label_db_password} = Wx::StaticText->new($self->{wiz_p04}, -1, _T("Password"), wxDefaultPosition, wxDefaultSize, );
	$self->{t_db_password} = Wx::TextCtrl->new($self->{wiz_p04}, -1, "", wxDefaultPosition, wxDefaultSize, wxTE_PASSWORD);
	$self->{b_db_test} = Wx::Button->new($self->{wiz_p04}, -1, _T("Test database"));
	$self->{label_5} = Wx::StaticText->new($self->{wiz_p05}, -1, _T("Druk op 'Voltooien' om de volgende bestanden aan te maken:"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_cr_config} = Wx::CheckBox->new($self->{wiz_p05}, -1, _T("Configuratiebestand"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_cr_schema} = Wx::CheckBox->new($self->{wiz_p05}, -1, _T("Rekeningschema"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_cr_relaties} = Wx::CheckBox->new($self->{wiz_p05}, -1, _T("Relaties (debiteuren en crediteuren)"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_cr_opening} = Wx::CheckBox->new($self->{wiz_p05}, -1, _T("Openingsgegevens"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_cr_mutaties} = Wx::CheckBox->new($self->{wiz_p05}, -1, _T("Mutaties (boekingen)"), wxDefaultPosition, wxDefaultSize, );
	$self->{cb_cr_database} = Wx::CheckBox->new($self->{wiz_p05}, -1, _T("Database"), wxDefaultPosition, wxDefaultSize, );
	$self->{label_8} = Wx::StaticText->new($self->{wiz_p05}, -1, _T("Let op! Eventuele bestaande bestanden worden overschreven!"), wxDefaultPosition, wxDefaultSize, );

	$self->__set_properties();
	$self->__do_layout();

	Wx::Event::EVT_BUTTON($self, $self->{b_details}->GetId, \&OnDetails);
	Wx::Event::EVT_BUTTON($self, $self->{b_ok}->GetId, \&OnOk);

# end wxGlade

	# Set defaults for code and db name.
	OnSelectAdmName( $self->{wiz} );

	my $prev;
	for ( my $i = 0; ; $i++ ) {
	    my $page = sprintf("wiz_p%02d", $i);
	    last unless exists $self->{$page};
	    $self->{sz_main}->Detach($self->{$page});
	    Wx::WizardPageSimple::Chain( $self->{$prev}, $self->{$page} )
		if $prev;
	    $prev = $page;
	}

	my $dir = dirname( findlib( "templates.txt", "templates" ) );
	@ebz = map { [ $_, "" ] } glob( "$dir/*.ebz" );

	my $i = 0;
	my $dp = quotemeta( _T("Omschrijving").": " );
	foreach my $ebz ( @ebz ) {
	    require Archive::Zip;
	    my $zip = Archive::Zip->new();
	    next unless $zip->read($ebz->[0]) == ::AZ_OK;
	    my $desc = $zip->zipfileComment;
	    if ( $desc =~ /flags:\s*(.*)/i ) {
		$ebz->[1] = $1;
	    }
	    if ( $desc =~ /^$dp\s*(.*)$/m ) {
		$desc = $1;
	    }
	    elsif ( $desc =~ /export van (.*) aangemaakt door eekboek/i ) {
		$desc = $1;
	    }
	    else {
		$desc = $1 if $ebz->[0] =~ m/([^\\\/]+)\.ebz$/i;
	    }
	    $desc =~ s/[\n\r]+$//; # can't happen? think again...

	    $self->{ch_template}->Append($desc);
	    $i++;
	    if ( $ebz->[0] =~ /\/sample(db)?\.ebz$/ ) {
		$self->{ch_template}->SetSelection($i);
		OnSelectTemplate( $self->{wiz} );
	    }
	}
	unshift (@ebz, undef );	# skeleton

	# Enumerate DB drivers.
	my $drivers = find_db_drivers();
	$self->{ch_db_driver}->Delete(0) while $self->{ch_db_driver}->GetCount;
	foreach ( sort keys %$drivers ) {
	    push( @db_drivers, $_ );
	    $self->{ch_db_driver}->Append( $drivers->{$_} );
	    $self->{ch_db_driver}->SetSelection(@db_drivers-1) if $_ eq "sqlite";
	}

	#### WARNING: Hard-wired reference to wiz_p04.
#	$self->{dc_dbpath} = Wx::DirPickerCtrl->new($self->{wiz_p04}, -1, "", _T("Kies een folder"), wxDefaultPosition, wxDefaultSize, 2 );
#	$self->{grid_db}->Replace( $self->{l_placeholder_dbpath}, $self->{dc_dbpath}, 1 );
#	$self->{l_placeholder_dbpath}->Destroy;
#	$self->{dc_dbpath}->SetToolTipString(_T("Folder waar databases worden opgeslagen (niet voor alle database typen)"));
#	$self->{dc_dbpath}->SetPath(_T("-- Huidige directory --"));

	Wx::Event::EVT_WIZARD_PAGE_CHANGING($self, $self->{wiz}->GetId, \&OnPageChanging);
	Wx::Event::EVT_WIZARD_FINISHED($self, $self->{wiz}->GetId, \&OnWizardFinished );
	Wx::Event::EVT_WIZARD_CANCEL($self, $self->{wiz}->GetId, \&OnWizardCancel );
	Wx::Event::EVT_RADIOBOX($self->{wiz}, $self->{rb_select}->GetId, \&OnSelectFunction );
	Wx::Event::EVT_CHECKBOX($self->{wiz}, $self->{cb_btw}->GetId, \&OnToggleBTW );
	Wx::Event::EVT_CHECKBOX($self->{wiz}, $self->{cb_cr_schema}->GetId, \&OnToggleCreate );
	Wx::Event::EVT_CHECKBOX($self->{wiz}, $self->{cb_cr_opening}->GetId, \&OnToggleCreate );
	Wx::Event::EVT_CHECKBOX($self->{wiz}, $self->{cb_cr_relaties}->GetId, \&OnToggleCreate );
	Wx::Event::EVT_CHECKBOX($self->{wiz}, $self->{cb_cr_mutaties}->GetId, \&OnToggleCreate );
	Wx::Event::EVT_CHOICE($self->{wiz}, $self->{ch_template}->GetId, \&OnSelectTemplate );
	Wx::Event::EVT_TEXT($self->{wiz}, $self->{t_adm_name}->GetId, \&OnSelectAdmName );
	Wx::Event::EVT_TEXT($self->{wiz}, $self->{t_adm_code}->GetId, \&OnSelectAdmCode );
	Wx::Event::EVT_SPINCTRL($self->{wiz}, $self->{sp_adm_begin}->GetId, \&OnSelectAdmName );
	Wx::Event::EVT_CHOICE($self->{wiz}, $self->{ch_db_driver}->GetId, \&OnSelectDbDriver );
	Wx::Event::EVT_BUTTON($self->{wiz}, $self->{b_db_test}->GetId, \&OnDbTest);

	$self->{wiz}->SetPageSize([600,-1]);

	my $icon = Wx::Icon->new();
	$icon->CopyFromBitmap(Wx::Bitmap->new("eb.jpg", wxBITMAP_TYPE_ANY));
	$self->SetIcon($icon);
	$self->{wiz}->SetIcon($icon);
	$self->SetSize([450,300]);
	$self->Center;
	return $self;
}

sub runwiz {
    my ( $self, $opts ) = @_;
    $self->{wiz}->RunWizard( $self->{$wp->{select}} );
    $self->{wiz}->Destroy;
}

sub getadm {			# STATIC
    my ( $pkg, $opts ) = @_;
    chdir($opts->{admdir});

    my %h;
    $h{$_} = 1 foreach glob( "*/" . $cfg->std_config );
    $h{$_} = 1 foreach glob( "*/" . $cfg->std_config_alt );
    my @files = keys(%h);
    @adm_names = ();
    @adm_dirs = ();
    foreach ( sort @files ) {
	push( @adm_dirs, dirname($_) );
	my $desc = $adm_dirs[-1];
	if ( open( my $fd, '<:utf8', $adm_dirs[-1]."/opening.eb" ) ) {
	    while ( <$fd> ) {
		next unless /adm_naam\s+"(.+)"/;
		$desc = $1;
		last;
	    }
	    close($fd);
	}
	push( @adm_names, $desc);
    }

    my $ret = wxID_NEW;
    if ( @adm_dirs ) {
	require EB::Wx::IniWiz::OpenDialog;
	my $d = EB::Wx::IniWiz::OpenDialog->new( undef, -1,
						 _T("Kies"),
						 wxDefaultPosition, wxDefaultSize, );
	$d->init( \@adm_names );
	$ret = $d->ShowModal;
	if ( $ret == wxID_OK ) {
	    chdir( $adm_dirs[ $d->GetSelection ] ) || die("chdir");
	}
	elsif ( $ret == wxID_REMOVE ) {
	    my $sel = $d->GetSelection;
	    $d->Destroy;
	    $d = Wx::MessageDialog->new( undef,
					 $adm_names[$sel] . "\n\n" .
					 _T("Administratie verwijderen?"),
					 _T("Verwijderen administratie"),
					 wxOK|wxCANCEL, wxDefaultPosition );
	    my $ret = $d->ShowModal;
	    $d->Destroy;
	    if ( $ret == wxID_OK ) {
		use File::Path qw(remove_tree);
		remove_tree( $adm_dirs[$sel], { verbose => 1 } );
	    }
	    # Try again.
	    return getadm( $pkg, $opts );
	}
	$d->Destroy;
    }
    return $ret;

}

sub __set_properties {
	my $self = shift;

	my $year = 1900 + (localtime(time))[5];
	$self->{sp_adm_begin}->SetRange( $year-100, $year+100 );
	$self->{sp_adm_begin}->SetValue( $year );

# begin wxGlade: EB::Wx::IniWiz::__set_properties

	$self->SetTitle(_T("EekBoek MiniAdm Setup"));
	$self->{t_main}->SetFont(Wx::Font->new(10, wxTELETYPE, wxNORMAL, wxNORMAL, 0, ""));
	$self->{ch_runeb}->SetValue(1);
	$self->{b_details}->Show(0);
	$self->{b_ok}->Enable(0);
	$self->{rb_select}->SetSelection(0);
	$self->{wiz_p00}->Show(0);
	$self->{t_adm_name}->SetToolTipString(_T("Een omschrijving van deze administratie, bijvoorbeeld \"Boekhouding 2009\"."));
	$self->{t_adm_code}->SetToolTipString(_T("Een korte, unieke aanduiding van deze administratie, bijvoorbeeld \"admin2009\"."));
	$self->{sp_adm_begin}->SetToolTipString(_T("De begindatum. Het boekjaar begint op 1 januari van dit jaar."));
	$self->{ch_template}->SetSelection(0);
	$self->{wiz_p01}->Show(0);
	$self->{cb_btw}->SetToolTipString(_T("BTW toepassen"));
	$self->{cb_btw}->SetValue(1);
	$self->{ch_btw_period}->SetToolTipString(_T("De aangifteperiode voor de omzetbelasting"));
	$self->{ch_btw_period}->SetSelection(1);
	$self->{wiz_p02}->Show(0);
	$self->{cb_debiteuren}->SetToolTipString(_T("Verkoop- en Debiteurenadministratie"));
	$self->{cb_debiteuren}->SetValue(1);
	$self->{cb_crediteuren}->SetToolTipString(_T("Inkoop- en Crediteurenadministratie"));
	$self->{cb_crediteuren}->SetValue(1);
	$self->{cb_kas}->SetToolTipString(_T("Kas (contant geld)"));
	$self->{cb_kas}->SetValue(1);
	$self->{cb_bank}->SetToolTipString(_T("Er wordt gebruik gemaakt van een bankrekening"));
	$self->{cb_bank}->SetValue(1);
	$self->{wiz_p03}->Show(0);
	$self->{t_db_name}->SetToolTipString(_T("De naam van de aan te maken database, b.v. \"admin2009\"."));
	$self->{ch_db_driver}->SetToolTipString(_T("Het databasesysteem waar de database wordt opgeslagen"));
	$self->{ch_db_driver}->SetSelection(1);
	$self->{label_db_host}->Enable(0);
	$self->{t_db_host}->SetToolTipString(_T("Het systeem waarop de database server draait, indien niet lokaal."));
	$self->{t_db_host}->Enable(0);
	$self->{label_db_port}->Enable(0);
	$self->{t_db_port}->SetToolTipString(_T("De netwerkpoort waarop de database server luistert, indien niet lokaal."));
	$self->{t_db_port}->Enable(0);
	$self->{label_db_user}->Enable(0);
	$self->{t_db_user}->SetToolTipString(_T("De user naam voor de database server."));
	$self->{t_db_user}->Enable(0);
	$self->{label_db_password}->Enable(0);
	$self->{t_db_password}->SetToolTipString(_T("Het password van deze user."));
	$self->{t_db_password}->Enable(0);
	$self->{wiz_p04}->Show(0);
	$self->{cb_cr_config}->SetValue(1);
	$self->{cb_cr_schema}->SetToolTipString(_T("Rekeningschema, dagboeken, BTW instellingen"));
	$self->{cb_cr_schema}->SetValue(1);
	$self->{cb_cr_relaties}->SetToolTipString(_T("Debiteuren en Crediteuren"));
	$self->{cb_cr_relaties}->SetValue(1);
	$self->{cb_cr_opening}->SetToolTipString(_T("Administratieve gegevens"));
	$self->{cb_cr_opening}->SetValue(1);
	$self->{cb_cr_mutaties}->SetToolTipString(_T("Mutaties (boekingen)"));
	$self->{cb_cr_mutaties}->SetValue(1);
	$self->{cb_cr_database}->SetToolTipString(_T("De database wordt aangemaakt en gevuld"));
	$self->{cb_cr_database}->SetValue(1);
	$self->{wiz_p05}->Show(0);

# end wxGlade

	$self->{cb_cr_schema  }->SetValue( ! -f "schema.dat"    );
	$self->{cb_cr_opening }->SetValue( ! -f "opening.eb"    );
	$self->{cb_cr_mutaties}->SetValue( ! -f "mutaties.eb"   );
	$self->{cb_cr_relaties}->SetValue( ! -f "relaties.eb"   );
	$self->{cb_cr_config  }->SetValue( ! ( -f $cfg->std_config
					       ||
					       -f $cfg->std_config_alt ) );

	$self->{t_db_name}->SetValue(sprintf("adm%04d",
					     1900+(localtime(time))[5]));

	$self->{t_db_host}->SetValue( $ENV{EB_DB_HOST} || $default );
	$self->{t_db_port}->SetValue( $ENV{EB_DB_PORT} || $default );
	$self->{t_db_user}->SetValue( $ENV{EB_DB_USER} || $default );
	$self->{t_db_password}->SetValue( $ENV{EB_DB_PASSWORD} || "" );
}

sub __do_layout {
	my $self = shift;

# begin wxGlade: EB::Wx::IniWiz::__do_layout

	$self->{sz_dummy} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sz_main} = Wx::BoxSizer->new(wxVERTICAL);
	$self->{sizer_1} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_2}= Wx::StaticBoxSizer->new($self->{sizer_2_staticbox}, wxVERTICAL);
	$self->{grid_sizer_5} = Wx::FlexGridSizer->new(6, 1, 5, 5);
	$self->{sizer_16} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_4}= Wx::StaticBoxSizer->new($self->{sizer_4_staticbox}, wxVERTICAL);
	$self->{grid_db} = Wx::FlexGridSizer->new(7, 2, 5, 5);
	$self->{sizer_15} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_6}= Wx::StaticBoxSizer->new($self->{sizer_6_staticbox}, wxHORIZONTAL);
	$self->{grid_sizer_3} = Wx::FlexGridSizer->new(4, 1, 5, 5);
	$self->{sizer_14} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_8}= Wx::StaticBoxSizer->new($self->{sizer_8_staticbox}, wxHORIZONTAL);
	$self->{grid_sizer_4} = Wx::FlexGridSizer->new(2, 1, 5, 5);
	$self->{sizer_7} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_13} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_5}= Wx::StaticBoxSizer->new($self->{sizer_5_staticbox}, wxHORIZONTAL);
	$self->{grid_sizer_2} = Wx::FlexGridSizer->new(4, 2, 5, 5);
	$self->{sizer_3} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_11} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_17} = Wx::BoxSizer->new(wxVERTICAL);
	$self->{sizer_9} = Wx::BoxSizer->new(wxVERTICAL);
	$self->{sz_buttons} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{sizer_9}->Add($self->{t_main}, 1, wxBOTTOM|wxEXPAND|wxADJUST_MINSIZE, 10);
	$self->{sizer_9}->Add($self->{ch_runeb}, 0, wxBOTTOM|wxADJUST_MINSIZE, 10);
	$self->{sz_buttons}->Add(1, 1, 1, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{sz_buttons}->Add($self->{b_details}, 0, wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);
	$self->{sz_buttons}->Add($self->{b_ok}, 0, wxADJUST_MINSIZE, 0);
	$self->{sizer_9}->Add($self->{sz_buttons}, 0, wxEXPAND, 0);
	$self->{sz_main}->Add($self->{sizer_9}, 1, wxALL|wxEXPAND, 10);
	$self->{sizer_17}->Add($self->{label_2}, 1, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{sizer_17}->Add($self->{rb_select}, 1, wxEXPAND|wxADJUST_MINSIZE, 10);
	$self->{sizer_11}->Add($self->{sizer_17}, 1, wxEXPAND, 0);
	$self->{wiz_p00}->SetSizer($self->{sizer_11});
	$self->{sz_main}->Add($self->{wiz_p00}, 0, wxEXPAND, 0);
	$self->{grid_sizer_2}->Add($self->{label_3}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_2}->Add($self->{t_adm_name}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_2}->Add($self->{label_10}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_2}->Add($self->{t_adm_code}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_2}->Add($self->{l_begin_date_1}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{sizer_3}->Add($self->{l_begin_date_2}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{sizer_3}->Add($self->{sp_adm_begin}, 0, wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_2}->Add($self->{sizer_3}, 1, wxEXPAND, 0);
	$self->{grid_sizer_2}->Add($self->{l_template}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_2}->Add($self->{ch_template}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_2}->AddGrowableCol(1);
	$self->{sizer_5}->Add($self->{grid_sizer_2}, 1, wxALL|wxEXPAND, 5);
	$self->{sizer_13}->Add($self->{sizer_5}, 1, wxEXPAND, 0);
	$self->{wiz_p01}->SetSizer($self->{sizer_13});
	$self->{sz_main}->Add($self->{wiz_p01}, 0, wxEXPAND, 0);
	$self->{grid_sizer_4}->Add($self->{cb_btw}, 0, wxADJUST_MINSIZE, 0);
	$self->{sizer_7}->Add($self->{l_btw_period}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{sizer_7}->Add($self->{ch_btw_period}, 0, wxLEFT|wxEXPAND|wxADJUST_MINSIZE, 5);
	$self->{grid_sizer_4}->Add($self->{sizer_7}, 1, wxEXPAND, 0);
	$self->{grid_sizer_4}->AddGrowableCol(0);
	$self->{sizer_8}->Add($self->{grid_sizer_4}, 1, wxALL|wxEXPAND, 5);
	$self->{sizer_14}->Add($self->{sizer_8}, 1, wxEXPAND, 0);
	$self->{wiz_p02}->SetSizer($self->{sizer_14});
	$self->{sz_main}->Add($self->{wiz_p02}, 0, wxEXPAND, 0);
	$self->{grid_sizer_3}->Add($self->{cb_debiteuren}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_3}->Add($self->{cb_crediteuren}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_3}->Add($self->{cb_kas}, 0, wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_3}->Add($self->{cb_bank}, 0, wxADJUST_MINSIZE, 0);
	$self->{sizer_6}->Add($self->{grid_sizer_3}, 1, wxALL|wxEXPAND, 5);
	$self->{sizer_15}->Add($self->{sizer_6}, 1, wxEXPAND, 0);
	$self->{wiz_p03}->SetSizer($self->{sizer_15});
	$self->{sz_main}->Add($self->{wiz_p03}, 0, wxEXPAND, 0);
	$self->{grid_db}->Add($self->{label_1}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{t_db_name}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{label_db_type}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{ch_db_driver}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{label_db_host}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{t_db_host}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{label_db_port}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{t_db_port}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{label_db_user}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{t_db_user}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{label_db_password}, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{t_db_password}, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add(0, 0, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
	$self->{grid_db}->Add($self->{b_db_test}, 0, wxADJUST_MINSIZE, 0);
	$self->{grid_db}->AddGrowableCol(1);
	$self->{sizer_4}->Add($self->{grid_db}, 1, wxALL|wxEXPAND, 5);
	$self->{sizer_16}->Add($self->{sizer_4}, 1, wxEXPAND, 0);
	$self->{wiz_p04}->SetSizer($self->{sizer_16});
	$self->{sz_main}->Add($self->{wiz_p04}, 0, wxEXPAND, 0);
	$self->{sizer_2}->Add($self->{label_5}, 0, wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
	$self->{grid_sizer_5}->Add($self->{cb_cr_config}, 0, wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_5}->Add($self->{cb_cr_schema}, 0, wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_5}->Add($self->{cb_cr_relaties}, 0, wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_5}->Add($self->{cb_cr_opening}, 0, wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_5}->Add($self->{cb_cr_mutaties}, 0, wxADJUST_MINSIZE, 0);
	$self->{grid_sizer_5}->Add($self->{cb_cr_database}, 0, wxADJUST_MINSIZE, 0);
	$self->{sizer_2}->Add($self->{grid_sizer_5}, 1, wxALL|wxEXPAND, 5);
	$self->{sizer_2}->Add($self->{label_8}, 0, wxALL|wxADJUST_MINSIZE, 5);
	$self->{sizer_1}->Add($self->{sizer_2}, 1, wxEXPAND, 5);
	$self->{wiz_p05}->SetSizer($self->{sizer_1});
	$self->{sz_main}->Add($self->{wiz_p05}, 0, wxEXPAND, 0);
	$self->{p_dummy}->SetSizer($self->{sz_main});
	$self->{sz_dummy}->Add($self->{p_dummy}, 1, wxEXPAND, 0);
	$self->SetSizer($self->{sz_dummy});
	$self->{sz_dummy}->Fit($self);
	$self->Layout();

# end wxGlade
}

sub OnSelectFunction {
    my ( $self, $event ) = @_;
    $self = $self->GetParent;

    my @hideshow = qw( l_begin_date_1 l_begin_date_2 sp_adm_begin l_template ch_template );
    my @hideshow0 = qw( schema relaties mutaties database );
    my @hideshow1 = qw( config opening );

    if ( $self->{rb_select}->GetSelection == 0 ) {
	Wx::WizardPageSimple::Chain( $self->{$wp->{select}}, $self->{$wp->{admname}} );
	Wx::WizardPageSimple::Chain( $self->{$wp->{admname}}, $self->{$wp->{btw}} );
	Wx::WizardPageSimple::Chain( $self->{$wp->{btw}}, $self->{$wp->{batch}} );
	Wx::WizardPageSimple::Chain( $self->{$wp->{batch}}, $self->{$wp->{db}} );
	Wx::WizardPageSimple::Chain( $self->{$wp->{db}}, $self->{$wp->{confirm}} );
	foreach ( @hideshow0, @hideshow1 ) {
	    $self->{"cb_cr_$_"}->SetValue(1);
	    $self->{"cb_cr_$_"}->Enable(1);
	    $self->{"cb_cr_$_"}->Show(1);
	}
	foreach ( @hideshow ) {
	    $self->{$_}->Show(1);
	}
	$self->Layout;
	OnSelectTemplate( $self->{wiz} );
    }
    else {
	Wx::WizardPageSimple::Chain( $self->{$wp->{select}}, $self->{$wp->{admname}} );
	Wx::WizardPageSimple::Chain( $self->{$wp->{admname}}, $self->{$wp->{db}} );
	Wx::WizardPageSimple::Chain( $self->{$wp->{db}}, $self->{$wp->{confirm}} );

	for ( my $i = 0; $i < @db_drivers; $i++ ) {
	    next unless $db_drivers[$i] eq "postgres";
	    $self->{ch_db_driver}->SetSelection($i);
	    OnSelectDbDriver( $self->{wiz} );
	    last;
	}

	foreach ( @hideshow1 ) {
	    $self->{"cb_cr_$_"}->SetValue(1);
	    $self->{"cb_cr_$_"}->Enable(0);
	}
	foreach ( @hideshow0 ) {
	    $self->{"cb_cr_$_"}->SetValue(0);
	    $self->{"cb_cr_$_"}->Show(0);
	}
	foreach ( @hideshow ) {
	    $self->{$_}->Show(0);
	}
	$self->Layout;
    }
}

sub OnPageChanging {
    my ($self,  $event) = @_;
    return unless $event->GetDirection;
    my $page = $event->GetPage;

    if ( $page->GetId == $self->{$wp->{admname}}->GetId ) {
	my $nu = sub {
	    my $m = Wx::MessageDialog->new($self->{wiz}, shift,
					   _T("Niet uniek"),
					   wxICON_ERROR|wxOK );
	    my $ret = $m->ShowModal;
	    $m->Destroy;
	    return $ret;
	};

	my $c = $self->{t_adm_name}->GetValue;
	foreach ( @adm_names ) {
	    next unless lc($_) eq lc($c);
	    $nu->( _T("Er bestaat al een administratie met deze naam.") );
	    $event->Veto;
	    # The code will probable also be duplicate.
	    # Prevent double warning.
	    return;
	}
	$c = $self->{t_adm_code}->GetValue;
	foreach ( @adm_dirs ) {
	    next unless lc($_) eq lc($c);
	    $nu->( _T("Er bestaat al een administratie met deze code.") );
	    $event->Veto;
	    last;
	}
    }

    if ( $page->GetId == $self->{$wp->{db}}->GetId ) {
	return unless $self->{rb_select}->GetSelection;
	my $res = $self->_dbtest;
	if ( $res ) {
	    my $m = Wx::MessageDialog->new($self->{wiz},
					   $res,
					   _T("Database Test Resultaat"),
					   wxICON_INFORMATION | wxOK );
	    $m->ShowModal;
	    $m->Destroy;
	    $event->Veto;
	}
    }
}

sub OnToggleBTW {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnToggleBTW <event_handler>

    $self = $self->GetParent;

    my $x = $self->{cb_btw}->IsChecked ? 1 : 0;
    $self->{ch_btw_period}->Enable($x);
    $self->{l_btw_period}->Enable($x);

# end wxGlade
}

sub OnSelectTemplate {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnSelectTemplate <event_handler>

    $self = $self->GetParent;

    my $x = $self->{ch_template}->GetSelection;
    if ( $x ) {
	if ( $ebz[$x]->[1] =~ /\B-btw\b/i ) {
	    $self->{cb_btw}->SetValue(0);
	    $self->{cb_btw}->Enable(0);
	    $self->{ch_btw_period}->Enable(0);
	    $self->{l_btw_period}->Enable(0);
	    Wx::WizardPageSimple::Chain( $self->{$wp->{admname}}, $self->{$wp->{db}} );
	}
	else {
	    $self->{cb_btw}->SetValue(1);
	    $self->{cb_btw}->Enable(0);
	    $self->{ch_btw_period}->Enable(1);
	    $self->{l_btw_period}->Enable(1);
	    Wx::WizardPageSimple::Chain( $self->{$wp->{admname}}, $self->{$wp->{btw}} );
	    Wx::WizardPageSimple::Chain( $self->{$wp->{btw}}, $self->{$wp->{db}} );
	}
    }
    else {
	$self->{cb_btw}->Enable(1);
	Wx::WizardPageSimple::Chain( $self->{$wp->{admname}}, $self->{$wp->{btw}} );
	Wx::WizardPageSimple::Chain( $self->{$wp->{btw}}, $self->{$wp->{batch}} );
    }

# end wxGlade
}

sub OnSelectAdmName {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnSelectAdmName <event_handler>

    $self = $self->GetParent;

    my $x = lc $self->{t_adm_name}->GetValue;
    $x =~ s/\s+/_/g;
    $x =~ s/\W//g;
    $x .= "_" . $self->{sp_adm_begin}->GetValue;
    $self->{t_adm_code}->SetValue($x);
    $self->{t_db_name}->SetValue($x);

# end wxGlade
}

sub OnSelectAdmCode {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnSelectAdmCode <event_handler>

    $self = $self->GetParent;

    my $x = lc $self->{t_adm_code}->GetValue;
    $x =~ s/\s+/_/g;
    $x =~ s/\W//g;
    # $x .= "_" . $self->{sp_adm_begin}->GetValue;
    $self->{t_db_name}->SetValue($x);

# end wxGlade
}

sub OnToggleCreate {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnToggleBTW <event_handler>

    $self = $self->GetParent;

    my $x = $event->GetEventObject->IsChecked ? 1 : 0;
    $self->{ "cb_cr_$_" }->SetValue($x)
      foreach qw(schema relaties opening mutaties);

# end wxGlade
}

sub OnWizardFinished {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnWizardFinished <event_handler>
    my %opts;

    $opts{lang} = $ENV{EB_LANG} || $ENV{LANG};
    $opts{lang} =~ s/\..*//;	# strip .utf8

    $opts{adm_naam} = $self->{t_adm_name}->GetValue;
    $opts{adm_code} = $self->{t_adm_code}->GetValue;
    $opts{adm_begindatum} = $self->{sp_adm_begin}->GetValue;

    $opts{db_naam} = $self->{t_db_name}->GetValue;
    $opts{db_driver} = $db_drivers[$self->{ch_db_driver}->GetSelection];
    $opts{db_host} = $self->{t_db_host}->GetValue
      if $self->{t_db_host}->IsEnabled
	&& $self->{t_db_host}->GetValue
	  && $self->{t_db_host}->GetValue ne $default;
    $opts{db_port} = $self->{t_db_port}->GetValue
      if $self->{t_db_port}->IsEnabled
	&& $self->{t_db_port}->GetValue
	  && $self->{t_db_port}->GetValue ne $default;
    $opts{db_user} = $self->{t_db_user}->GetValue
      if $self->{t_db_user}->IsEnabled
	&& $self->{t_db_user}->GetValue
	  && $self->{t_db_user}->GetValue ne $default;
    $opts{db_password} = $self->{t_db_password}->GetValue
      if $self->{t_db_password}->IsEnabled
	&& $self->{t_db_password}->GetValue
	  && $self->{t_db_password}->GetValue ne "";
    #$opts{db_path} = $self->{dc_dbpath}->GetPath
    #  if $self->{dc_dbpath}->IsEnabled
    #	&& $self->{dc_dbpath}->GetPath !~ /^--/;
    $opts{"has_$_"} = $self->{"cb_$_"}->IsChecked
	foreach qw(debiteuren crediteuren kas bank btw);

    $opts{"create_$_"} = $self->{"cb_cr_$_"}->IsChecked
	foreach qw(config schema relaties opening mutaties database);

    $opts{adm_btwperiode} = qw(maand kwartaal jaar)[$self->{ch_btw_period}->GetSelection]
	if $opts{has_btw};

    $opts{template} = $ebz[ $self->{ch_template}->GetSelection ]->[0];

    if ( $opts{adm_code} ) {
	mkdir($opts{adm_code}) unless -d $opts{adm_code};
	chdir($opts{adm_code}) or die("chdir($opts{adm_code}): $!\n");;
    }

    $self->{b_ok}->Enable(0);
    my $log = $self->{t_main};
    eval {

	EB::Tools::MiniAdm->sanitize(\%opts);

	foreach my $c ( qw(config schema relaties opening mutaties database) ) {
	    my $msg = __x("Aanmaken {cfg}: ", cfg => $c);
	    $log->AppendText($msg);
	    if ( $opts{"create_$c"} ) {
		if ( $c eq "database" ) {
		    my $t = $log->GetInsertionPoint;
		    $log->AppendText(_T("Even geduld..."));
		    $self->Refresh;
		    $self->Update;
		    my $ret;
		    EB->app_init( { app => $EekBoek::PACKAGE, %opts } );
		    require EB::Main;
		    local $::app; # defeat Shell blocking of import command
		    local @ARGV = qw( --init );
		    my @msg;
		    my $out;
		    # Intercept warn and die.
		    local $SIG{__WARN__} = sub {
			push( @msg, join("\n", @_) );
		    };
		    local $SIG{__DIE__} = sub {
			push( @msg, "?".join("\n", @_) );
		    };

		    # Intercept STDOUT.
		    open( my $oldout, ">&STDOUT" );
		    close( STDOUT );
		    open( STDOUT, '>', \$out ) or die("STDOUT capture fail");

		    $ret = EB::Main->run;

		    # Restore STDOUT.
		    close(STDOUT);
		    open ( STDOUT, ">&", $oldout );

		    if ( $ret ) {
			$log->Replace($t,
				      $log->GetInsertionPoint,
				      _T("Mislukt")."\n");
		    }
		    else {
			$log->Replace($t,
				      $log->GetInsertionPoint,
				      _T("Gereed")."\n");
		    }
		    if ( $out || @msg ) {
			$self->{b_details}->Show(1);
			$self->{sz_buttons}->Layout;
			$self->{_details} = "";
			if ( @msg ) {
			    $self->{_details} .= _T("==== Meldingen ====")."\n";
			    $self->{_details} .= $_ . "\n" for @msg;
			}
			if ( $out ) {
			    $self->{_details} .= _T("==== Uitvoer ====")."\n";
			    $self->{_details} .= $out . "\n";
			}
		    }
		    $self->Update;
		}
		else {
		    $self->Refresh;
		    my $m = "generate_". $c;
		    EB::Tools::MiniAdm->$m(\%opts);
		    $log->AppendText(_T("Gereed")."\n");
		    $self->Update;
		}
	    }
	    else {
		$log->AppendText(_T("Overgeslagen")."\n");
	    }
	}
    };

    $log->AppendText($@) if $@;

    $self->{b_ok}->Enable(1);
    $self->{b_ok}->SetFocus;

    unless ( -e $cfg->std_config || -e $cfg->std_config_alt ) {
	$self->{ch_runeb}->SetValue(0);
    }
    elsif ( $self->{rb_select}->GetSelection != 0 ) {
	foreach ( qw( opening.eb ) ) {
	    $self->{ch_runeb}->SetValue(0) unless -s $_;
	}
    }
    else {
	foreach ( @configs ) {
	    $self->{ch_runeb}->SetValue(0) unless -s $_;
	}
    }

# end wxGlade
}


sub OnWizardCancel {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnWizardCancel <event_handler>

    $self->Show(1);
    $self->{t_main}->SetValue(_T("Afgebroken!")."\n");
    $self->{b_ok}->Enable(1);
    $self->{ch_runeb}->SetValue(0);

# end wxGlade
}


sub OnOk {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnOk <event_handler>

    $runeb = $self->{ch_runeb}->IsChecked;
    $self->Destroy;

# end wxGlade
}

sub find_db_drivers {
    my %drivers;

    if ( $Cava::Packager::PACKAGED ) {
	# Trust packager.
	unless ( $Cava::Packager::PACKAGED ) {
	    # Ignored, but force packaging.
	    require EB::DB::Postgres;
	    require EB::DB::Sqlite;
	}
	return
	  { sqlite   => "SQLite",
	    postgres => "PostgreSQL",
	  };
    }

    foreach my $lib ( @INC ) {
	next unless -d "$lib/EB/DB";
	foreach my $drv ( glob("$lib/EB/DB/*.pm") ) {
	    open( my $fd, "<", $drv ) or next;
	    while ( <$fd> ) {
		if ( /sub\s+type\s*{\s*"([^"]+)"\s*;?\s*}/ ) {
		    my $s = $1;
		    my $t = substr($drv,length("$lib/EB/DB/"));
		    $t =~ s/\.pm$//;
		    $drivers{lc($t)} ||= $s;
		    last;
		}
	    }
	    close($fd);
	}
    }
    \%drivers;
}


sub OnSelectDbDriver {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnSelectDbDriver <event_handler>

    $self = $self->GetParent;
    my $sel = $self->{ch_db_driver}->GetSelection;
    my $is_default = $db_drivers[$sel] eq 'sqlite';
    for ( qw( label_db_host t_db_host
	      label_db_port t_db_port
	      label_db_user t_db_user
	      label_db_password t_db_password ) ) {
	$self->{$_}->Enable( !$is_default );
	$_[0]->Layout;
	$self->Layout;
    }
# end wxGlade
}

sub _dbtest {
    my $self = shift;
    my $drv = $db_drivers[$self->{ch_db_driver}->GetSelection];
    $drv = "EB::DB::" . ucfirst($drv);
    my $res;
    my $opts;
    $opts->{host} = $self->{t_db_host}->GetValue
      if $self->{t_db_host}->IsEnabled
	&& $self->{t_db_host}->GetValue
	  && $self->{t_db_host}->GetValue ne $default;
    $opts->{port} = $self->{t_db_port}->GetValue
      if $self->{t_db_port}->IsEnabled
	&& $self->{t_db_port}->GetValue
	  && $self->{t_db_port}->GetValue ne $default;
    $opts->{user} = $self->{t_db_user}->GetValue
      if $self->{t_db_user}->IsEnabled
	&& $self->{t_db_user}->GetValue
	  && $self->{t_db_user}->GetValue ne $default;
    $opts->{password} = $self->{t_db_password}->GetValue
      if $self->{t_db_password}->IsEnabled
	&& $self->{t_db_password}->GetValue
	  && $self->{t_db_password}->GetValue ne "";

    my $db;
    if ( $self->{rb_select}->GetSelection == 1 ) {
	$db = $self->{t_db_name}->GetValue;
    }

    eval {
	eval "use $drv";
	die($@) if $@;
	$res = $drv->feature("test") ? $drv->test( $db, $opts ) : '';
    };
    $res = $@ if $@;
    delete( $INC{"EB.pm"} );	# remove fake environment
    return $res;
}

sub OnDbTest {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnDbTest <event_handler>

    $self = $self->GetParent;
    my $res = $self->_dbtest;
    my $icon = ( $res ? wxICON_ERROR : wxICON_INFORMATION );
    $icon |= wxOK;
    my $m = Wx::MessageDialog->new($self->{wiz},
				   $res || _T("Succes!"),
				   _T("Database Test Resultaat"),
				   $icon );
    $m->ShowModal;
    $m->Destroy;

# end wxGlade
}


sub OnDetails {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OnDetails <event_handler>

    return unless $self->{_details};
    $self->{t_main}->SetValue( $self->{_details} );
    $self->{_details} = "";
    $self->{b_details}->Enable(0);

# end wxGlade
}

# end of class EB::Wx::IniWiz

1;

package Wx::WizardPanel;

use Wx qw[wxBITMAP_TYPE_ANY];

use EB;
#use Wx::Locale gettext => '_T';

sub new {
    my ( $class, $self ) = @_;
    $self = $self->GetParent;
    $self->{wiz} ||= Wx::Wizard->new( $self, -1, _T("The Wiz"),
				      Wx::Bitmap->new("ebwiz.jpg",
						      wxBITMAP_TYPE_ANY
						     ));
    Wx::WizardPageSimple->new( $self->{wiz} );
}

package EB::Wx::IniWiz;

sub run {
    my ( $self, $opts ) = @_;
    my $admdir = $opts->{admdir} || $cfg->val(qw(general admdir), $cfg->user_dir("admdir"));
    $runeb = 1;
    $admdir =~ s/\$([A-Z_]+)/$ENV{$1}/ge;
    if ( $admdir ) {
	mkdir($admdir) unless -d $admdir;
	die("No admdir $admdir: $!") unless -d $admdir;
    }
    $opts->{admdir} = $admdir;
    $runeb = 0;

    no warnings 'redefine';
    local *Wx::App::OnInit = sub{1};

    $app = Wx::App->new();
    $app->SetAppName($EekBoek::PACKAGE);
    $app->SetVendorName("Squirrel Consultancy");

    if ( $^O =~ /^mswin/i ) {
	Wx::ConfigBase::Get->SetPath("/ebwxiniwiz");
    }
    else {
	Wx::ConfigBase::Set
	    (Wx::FileConfig->new
	     ( $app->GetAppName() ,
	       $app->GetVendorName() ,
	       $cfg->user_dir("ebwxiniwiz"),
	       '',
	       wxCONFIG_USE_LOCAL_FILE,
	     ));
    }
    Wx::ConfigBase::Get->Write('general/appversion',  $EekBoek::VERSION);

    my $ret = wxID_NEW;
    $ret = EB::Wx::IniWiz->getadm($opts) if $admdir;
    if ( $ret == wxID_CANCEL ) {
	$runeb = 0;
    }
    elsif ( $ret == wxID_NEW
	    || $ret == wxID_OPEN
	    || ! ( -s $cfg->std_config || -s $cfg->std_config_alt ) ) {	# getadm will chdir
	my $top = EB::Wx::IniWiz->new();
	$app->SetTopWindow($top);
	$top->Center;
	$top->Show(1);
	$top->runwiz;
	$app->MainLoop;
    }
    else {
	$runeb = 1;
    }

    $opts->{runeb} = $runeb;

}

1;
