# $Id: dumper.pir 22180 2007-10-17 19:33:17Z allison $

=head1 TITLE

dumper.pir - PIR version of Data::Dumper

=head1 VERSION

version 0.10

=head1 SYNOPSIS

    ...
    # dump the P0 register
    _dumper( P0 )

    # dump the P0 register, with "name"
    _dumper( P0, "name" )
    ...

    END
    .include "library/dumper.pir"


=head1 DESCRIPTION

    PIR implementation of Perl 5's Data::Dumper module.

=cut

# first method prints usage information
.sub __library_dumper_onload
    print "usage:"
    print "\tload_bytecode \"library/Data/Dumper.pir\"\n"
    print "\t...\n"
    print "\tnew dumper, \"Data::Dumper\"\n"
    print "\tdumper.\"dumper\"( foo, \"foo\" )\n\n"
    end
.end

.include "errors.pasm"

=head1 FUNCTIONS

This library provides the following functions:

=over 4

=item _dumper( pmc, ?name, ?indent] )

This is the public (non object) interface to the dumper library.

=over 4

=item pmc

Required. The PMC to dump.

=item name

Optional. The name of the PMC.

=item indent

Optional. The indent used at the start of each line printed.

=back

B<Note:> This function currently returns nothing. It should return
the dumped data as a string, like Perl's Data::Dumper. Instead,
everything is printed out using C<print>.

B<Note: #2> Hash keys are now sorted using C<_sort()> (library/sort.pir)

=cut

.sub _dumper
    .param pmc p
    .param string name    :optional
    .param int has_name   :opt_flag
    .param string ident   :optional
    .param int has_ident  :opt_flag

    $P2 = _global_dumper()
    if has_ident goto w_ident
    unless has_name goto wo_name        # XXX argument order, opt 1st
    $P2."dumper"(p, name)
    goto ex
wo_name:
    $P2."dumper"(p)
    goto ex
w_ident:
    $P2."dumper"(p, name, ident)
ex:
.end

=item _register_dumper( id, sub )

Registers a dumper for new PMC type. B<UNIMPLEMENTED>
But see B<method __dump> below.

=over 4

=item id

the PMC id, as returned by the C<typeof> op.

=item sub

a Sub pmc, that gets called in order to dump the content of the given PMC

=back

For example:

    sub = find_name "_dump_PerlArray"
    _register_dumper( .PerlArray, sub )

This function returns nothing.

=cut

.sub _register_dumper
    .param int id
    .param pmc s
    $P2 = _global_dumper()
    $P2."registerDumper"(id, s)
.end

=item __dump(pmc dumper, str label) method

If a method C<__dump> exists in the namespace of the class, it will be
called with the current dumper object and the label of the PMC.

=item dumper =_global_dumper() B<(internal)>

Internal helper function.

Returns the global dumper instance used by the non object interface.

=cut

.sub _global_dumper
    .local pmc self
    .local pmc dd_class
    .local int is_defined

    get_class dd_class, "Data::Dumper"
    if null dd_class goto load_dd_pir
    goto TYPE_OK

  load_dd_pir:
    load_bytecode "library/Data/Dumper.pir"
    get_class dd_class, "Data::Dumper"
    if null dd_class goto no_class
    goto TYPE_OK

  no_class:
    print "fatal error: failure while loading library/Data/Dumper.pir\n"
    end
TYPE_OK:

    errorsoff .PARROT_ERRORS_GLOBALS_FLAG
    find_global self, "Data::Dumper", "global"
    errorson .PARROT_ERRORS_GLOBALS_FLAG
    if null self goto create_type

create_type:
    new self, "Data::Dumper"
    store_global "Data::Dumper", "global", self

END:
    .return( self )
.end

=back

=head1 AUTHOR

Jens Rieks E<lt>parrot at jensbeimsurfen dot deE<gt> is the author
and maintainer.
Please send patches and suggestions to the Perl 6 Internals mailing list.

=head1 COPYRIGHT

Copyright (C) 2004-2007, The Perl Foundation.

=cut

# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
