package Business::EDI::CodeList::BusinessFunctionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 4025;
my $usage       = 'C';

# 4025  Business function code                                  [C]
# Desc: Code describing the specific business function.
# Repr: an..3

my %code_hash = (
'AAA' => [ 'Payment terms',
    'The business function is to specify payment terms.' ],
'AAB' => [ 'Medical services',
    'The reason for the transaction is medical services.' ],
'AAC' => [ 'Multiple types of service',
    'The reason for the transaction is for multiple types of services.' ],
'AAD' => [ 'Not otherwise specified',
    'The reason for the transaction is for types of services not specified elsewhere.' ],
'AAE' => [ 'Vision care',
    'The reason for the transaction is vision care services.' ],
'AAF' => [ 'Home health care',
    'The reason for the transaction is for home health care services.' ],
'AAG' => [ 'Hospital care',
    'The reason for the transaction is for hospital care services.' ],
'AAH' => [ 'Intermediate care facility',
    'The reason for the transaction is for intermediate care facility services.' ],
'AAI' => [ 'Long-term care facility',
    'The reason for the transaction is for long-term care facility services.' ],
'AAJ' => [ 'Convalescent care facility',
    'The reason for the transaction is for convalescent care facility services.' ],
'AAK' => [ 'Anesthesia service',
    'The reason for the transaction is for health care anesthesia services.' ],
'AAL' => [ 'Dental services',
    'The reason for the transaction is for dental services.' ],
'AAM' => [ 'Durable medical equipment',
    'The reason for the transaction is the use of durable medical equipment.' ],
'AAN' => [ 'Business expenses',
    'The reason for the transaction is business expenses.' ],
'AAO' => [ 'Company social loan payment to bank',
    'Payment made by a company to a bank for financing social loans to the employees.' ],
'AAP' => [ 'Air',
    'Air related business.' ],
'AAQ' => [ 'Ferry',
    'Ferry related business.' ],
'AAR' => [ 'Railway',
    'Railway related business.' ],
'AAS' => [ 'Bus',
    'Bus related business.' ],
'ADV' => [ 'Advance payment',
    'The reason for payment is advance payment.' ],
'AGT' => [ 'Agricultural transfer',
    'Support payment to farmer.' ],
'AMY' => [ 'Alimony',
    'Payment on alimony.' ],
'BEC' => [ 'Child benefit',
    'Payment made to assist to parent/guardian to maintain child.' ],
'BEN' => [ 'Unemployment/disability/benefit',
    'Payment to person unemployed/disabled.' ],
'BON' => [ 'Bonus',
    'The reason the transaction is bonus.' ],
'CAS' => [ 'Cash management transfer',
    'Reason for the transaction is cash management transfer.' ],
'CBF' => [ 'Capital building fringe fortune',
    'Capital building for retirement.' ],
'CDT' => [ 'Commodity transfer',
    'Reason for payment is commodity.' ],
'COC' => [ 'Commercial credit payment',
    'Reason for payment is commercial credit.' ],
'COM' => [ 'Commission payment',
    'Payment of commission.' ],
'COS' => [ 'Costs',
    'Reason for payments is costs.' ],
'CPY' => [ 'Copyright payment',
    'Reason for payment is copyright.' ],
'DIV' => [ 'Dividend payment',
    'Reason for payment is dividend.' ],
'FEX' => [ 'Foreign exchange',
    'Reason for transaction is foreign exchange.' ],
'GDS' => [ 'Purchasing and selling of goods',
    'Purchasing and selling of goods.' ],
'GVT' => [ 'Government payment',
    'Payment to or from a government department.' ],
'IHP' => [ 'Instalment/hire-purchase agreement',
    'Reason for transaction is instalment or hire/purchase agreement.' ],
'INS' => [ 'Insurance premium',
    'Reason for transaction is insurance premium.' ],
'INT' => [ 'Interest payment',
    'Payment of interest.' ],
'LIF' => [ 'Licence fees payment',
    'Payment of licence fees.' ],
'LOA' => [ 'Loan',
    'Transfer of loan to borrower.' ],
'LOR' => [ 'Loan repayment',
    'Repayment of loan to lender.' ],
'NET' => [ 'Netting',
    'Reason for transaction is netting.' ],
'PEN' => [ 'Pension payment',
    'Payment of pension.' ],
'REF' => [ 'Refunding',
    'Payment of refund.' ],
'REN' => [ 'Rent',
    'Reason for transaction is rent.' ],
'ROY' => [ 'Royalties payment',
    'Payment of royalties.' ],
'SAL' => [ 'Salary payment',
    'Reason for payment is salary.' ],
'SCV' => [ 'Purchasing and selling of services',
    'Purchasing and selling of services.' ],
'SEC' => [ 'Securities',
    'Reason for transaction is securities.' ],
'SSB' => [ 'Social security benefit',
    'Payment made by government to support individuals.' ],
'SUB' => [ 'Subscription',
    'Reason for transaction is subscription.' ],
'TAX' => [ 'Tax payment',
    'Payment of tax.' ],
'VAT' => [ 'Value added tax payment',
    'Payment of Value Added Tax (VAT).' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
