
package Paws::EC2::ReleaseAddress;
  use Moose;
  has AllocationId => (is => 'ro', isa => 'Str');
  has DryRun => (is => 'ro', isa => 'Bool', traits => ['NameInRequest'], request_name => 'dryRun' );
  has PublicIp => (is => 'ro', isa => 'Str');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ReleaseAddress');
  class_has _returns => (isa => 'Str', is => 'ro');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::EC2::ReleaseAddress - Arguments for method ReleaseAddress on Paws::EC2

=head1 DESCRIPTION

This class represents the parameters used for calling the method ReleaseAddress on the 
Amazon Elastic Compute Cloud service. Use the attributes of this class
as arguments to method ReleaseAddress.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ReleaseAddress.

As an example:

  $service_obj->ReleaseAddress(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 AllocationId => Str

[EC2-VPC] The allocation ID. Required for EC2-VPC.



=head2 DryRun => Bool

Checks whether you have the required permissions for the action,
without actually making the request, and provides an error response. If
you have the required permissions, the error response is
C<DryRunOperation>. Otherwise, it is C<UnauthorizedOperation>.



=head2 PublicIp => Str

[EC2-Classic] The Elastic IP address. Required for EC2-Classic.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ReleaseAddress in L<Paws::EC2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

