
package Paws::Inspector::CreateAssessment;
  use Moose;
  has ApplicationArn => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'applicationArn' );
  has AssessmentName => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'assessmentName' );
  has DurationInSeconds => (is => 'ro', isa => 'Int', traits => ['NameInRequest'], request_name => 'durationInSeconds' );
  has UserAttributesForFindings => (is => 'ro', isa => 'ArrayRef[Paws::Inspector::Attribute]', traits => ['NameInRequest'], request_name => 'userAttributesForFindings' );

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'CreateAssessment');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Inspector::CreateAssessmentResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Inspector::CreateAssessment - Arguments for method CreateAssessment on Paws::Inspector

=head1 DESCRIPTION

This class represents the parameters used for calling the method CreateAssessment on the 
Amazon Inspector service. Use the attributes of this class
as arguments to method CreateAssessment.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to CreateAssessment.

As an example:

  $service_obj->CreateAssessment(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 ApplicationArn => Str

  The ARN specifying the application for which you want to create an
assessment.


=head2 AssessmentName => Str

  The user-defined name identifying the assessment that you want to
create. You can create several assessments for an application. The
names of the assessments corresponding to a particular application must
be unique.


=head2 DurationInSeconds => Int

  The duration of the assessment in seconds. The default value is 3600
seconds (one hour). The maximum value is 86400 seconds (one day).


=head2 UserAttributesForFindings => ArrayRef[L<Paws::Inspector::Attribute>]

  The user-defined attributes that are assigned to every finding
generated by running this assessment.



=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method CreateAssessment in L<Paws::Inspector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

