
package Paws::CognitoSync::DescribeDataset {
  use Moose;
  has DatasetName => (is => 'ro', isa => 'Str', required => 1);
  has IdentityId => (is => 'ro', isa => 'Str', required => 1);
  has IdentityPoolId => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeDataset');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::CognitoSync::DescribeDatasetResponse');
  class_has _result_key => (isa => 'Str', is => 'ro', default => 'DescribeDatasetResult');
}
1;

### main pod documentation begin ###

=head1 NAME

Paws::CognitoSync::DescribeDataset - Arguments for method DescribeDataset on Paws::CognitoSync

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeDataset on the 
Amazon Cognito Sync service. Use the attributes of this class
as arguments to method DescribeDataset.

You shouln't make instances of this class. Each attribute should be used as a named argument in the call to DescribeDataset.

As an example:

  $service_obj->DescribeDataset(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES

=head2 B<REQUIRED> DatasetName => Str

  

A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9,
'_' (underscore), '-' (dash), and '.' (dot).










=head2 B<REQUIRED> IdentityId => Str

  

A name-spaced GUID (for example,
us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
Cognito. GUID generation is unique within a region.










=head2 B<REQUIRED> IdentityPoolId => Str

  

A name-spaced GUID (for example,
us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
Cognito. GUID generation is unique within a region.












=head1 SEE ALSO

This class forms part of L<Paws>, and documents parameters for DescribeDataset in Paws::CognitoSync

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

