package Locale::CLDR::Ka;
# This file auto generated from Data\common\main\ka.xml
#	on Sat 17 May  3:30:18 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use version;

our $VERSION = version->declare('v0.25.1');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'აფარი',
 				'ab' => 'აფხაზური',
 				'ace' => 'აჩეხური',
 				'ach' => 'აჩოლი',
 				'ada' => 'ადანგმე',
 				'ady' => 'ადიღეური',
 				'ae' => 'ავესტური',
 				'af' => 'აფრიკაანსი',
 				'agq' => 'აღემი',
 				'ain' => 'აინუური',
 				'ak' => 'აკანი',
 				'akk' => 'აქადური',
 				'ale' => 'ალეუტური',
 				'alt' => 'სამხრეთ ალთაური',
 				'am' => 'ამჰარული',
 				'an' => 'არაგონული',
 				'ang' => 'ძველი ინგლისური',
 				'anp' => 'ანგიკა',
 				'ar' => 'არაბული',
 				'ar_001' => 'თანამედროვე სტანდარტული არაბული',
 				'arc' => 'არამეული',
 				'arn' => 'მაპუდუნგუნი',
 				'arp' => 'არაპაჰო',
 				'arw' => 'არავაკი',
 				'as' => 'ასამური',
 				'asa' => 'ასუ',
 				'ast' => 'ასტურიული',
 				'av' => 'ხუნძური',
 				'awa' => 'ავადი',
 				'ay' => 'აიმარა',
 				'az' => 'აზერბაიჯანული',
 				'ba' => 'ბაშკირული',
 				'bal' => 'ბელუჯი',
 				'ban' => 'ბალინური',
 				'bas' => 'ბასა',
 				'bax' => 'ბამუნი',
 				'be' => 'ბელორუსული',
 				'bej' => 'ბეჯა',
 				'bem' => 'ბემბა',
 				'bez' => 'ბენა',
 				'bg' => 'ბულგარული',
 				'bho' => 'ბოჯპური',
 				'bn' => 'ბენგალური',
 				'bo' => 'ტიბეტური',
 				'br' => 'ბრეტონული',
 				'bra' => 'ბრაჯი',
 				'brx' => 'ბოდო',
 				'bs' => 'ბოსნიური',
 				'bua' => 'ბურიატული',
 				'byn' => 'ბილინი',
 				'ca' => 'კატალანური',
 				'cay' => 'კაიუგა',
 				'ce' => 'ჩეჩნური',
 				'chb' => 'ჩიბჩა',
 				'chm' => 'მარიული',
 				'chn' => 'ჩინუკი ვავა',
 				'cho' => 'ჩოკტო',
 				'chp' => 'დენე სულინე',
 				'chr' => 'ჩეროკი',
 				'chy' => 'ჩეიენი',
 				'ckb' => 'სორანი ქურთული',
 				'co' => 'კორსიკული',
 				'cop' => 'კოპტური',
 				'cr' => 'კრი',
 				'crh' => 'ყირიმულ-თურქული',
 				'cs' => 'ჩეხური',
 				'csb' => 'კაშუბური',
 				'cu' => 'საეკლესიო სლავური',
 				'cv' => 'ჩუვაშური',
 				'cy' => 'უელსური',
 				'da' => 'დანიური',
 				'dak' => 'დაკოტა',
 				'dar' => 'დარგუული',
 				'dav' => 'ტაიტა',
 				'de' => 'გერმანული',
 				'de_AT' => 'ავსტრიული გერმანული',
 				'de_CH' => 'შვეიცარიული ზემოგერმანული',
 				'del' => 'დელავარული',
 				'den' => 'სლეივი',
 				'dgr' => 'დოგრიბი',
 				'din' => 'დინკა',
 				'dje' => 'ზარმა',
 				'doi' => 'დოგრი',
 				'dua' => 'დუალა',
 				'dum' => 'საშუალო ჰოლანდიური',
 				'dv' => 'დივეჰი',
 				'dyo' => 'დიოლა',
 				'dyu' => 'დიულა',
 				'dz' => 'ძონგხა',
 				'ebu' => 'ემბუ',
 				'ee' => 'ევე',
 				'efi' => 'ეფიკი',
 				'egy' => 'ძველეგვიპტური',
 				'el' => 'ბერძნული',
 				'en' => 'ინგლისური',
 				'en_AU' => 'ავსტრალიური ინგლისური',
 				'en_CA' => 'კანადური ინგლისური',
 				'en_GB' => 'ბრიტანული ინგლისური',
 				'en_GB@alt=short' => 'გართ. სამ. ინგლისური',
 				'en_US' => 'ამერიკული ინგლისური',
 				'en_US@alt=short' => 'აშშ ინგლისური',
 				'enm' => 'საშუალო ინგლისური',
 				'eo' => 'ესპერანტო',
 				'es' => 'ესპანური',
 				'es_419' => 'ლათინურ ამერიკული ესპანური',
 				'es_ES' => 'ევროპული ესპანური',
 				'es_MX' => 'მექსიკური ესპანური',
 				'et' => 'ესტონური',
 				'eu' => 'ბასკური',
 				'ewo' => 'ევონდო',
 				'fa' => 'სპარსული',
 				'fi' => 'ფინური',
 				'fil' => 'ფილიპინური',
 				'fj' => 'ფიჯი',
 				'fo' => 'ფარერული',
 				'fon' => 'ფონი',
 				'fr' => 'ფრანგული',
 				'fr_CA' => 'კანადური ფრანგული',
 				'fr_CH' => 'შვეიცარიული ფრანგული',
 				'frm' => 'საშუალო ფრანგული',
 				'fro' => 'ძველი ფრანგული',
 				'frr' => 'ჩრდილოფრიზიული',
 				'frs' => 'აღმოსავლეთფრიზიული',
 				'fur' => 'ფრიულური',
 				'fy' => 'დასავლეთფრიზიული',
 				'ga' => 'ირლანდიური',
 				'gba' => 'გბაია',
 				'gd' => 'შოტლანდიური გელური',
 				'gez' => 'გეეზი',
 				'gl' => 'გალისიური',
 				'gmh' => 'საშუალო ზემოგერმანული',
 				'gn' => 'გუარანი',
 				'goh' => 'ძველი ზემოგერმანული',
 				'gon' => 'გონდი',
 				'got' => 'გოთური',
 				'grc' => 'ძველი ბერძნული',
 				'gsw' => 'შვეიცარიული გერმანული',
 				'gu' => 'გუჯარათი',
 				'gv' => 'მენური',
 				'ha' => 'ჰაუსა',
 				'haw' => 'ჰავაიური',
 				'he' => 'ებრაული',
 				'hi' => 'ჰინდი',
 				'hit' => 'ხეთური ენა',
 				'hr' => 'ხორვატული',
 				'ht' => 'ჰაიტიური',
 				'hu' => 'უნგრული',
 				'hy' => 'სომხური',
 				'ia' => 'ინტერლინგუალური',
 				'iba' => 'იბანი',
 				'ibb' => 'იბიბიო',
 				'id' => 'ინდონეზიური',
 				'ie' => 'ინტერლინგი',
 				'ig' => 'იგბო',
 				'inh' => 'ინგუშური',
 				'io' => 'იდო',
 				'is' => 'ისლანდიური',
 				'it' => 'იტალიური',
 				'iu' => 'ინუკტიტუტი',
 				'ja' => 'იაპონური',
 				'jbo' => 'ლოჟბანი',
 				'jpr' => 'იუდეო-სპარსული',
 				'jrb' => 'იუდეო-არაბული',
 				'jv' => 'იავური',
 				'ka' => 'ქართული',
 				'kaa' => 'ყარაყალფახური',
 				'kac' => 'კაჩინი',
 				'kam' => 'კამბა',
 				'kbd' => 'ყაბარდოული',
 				'kea' => 'კაბუვერდიანუ',
 				'kg' => 'კონგო',
 				'kk' => 'ყაზახური',
 				'kl' => 'გრენლანდიური',
 				'kln' => 'კალენჯინი',
 				'km' => 'ქმერული',
 				'kmb' => 'კიმბუნდუ',
 				'kn' => 'კანადა',
 				'ko' => 'კორეული',
 				'kok' => 'კონკანი',
 				'kos' => 'კუსაიე',
 				'kpe' => 'კპელე',
 				'kr' => 'კანური',
 				'krc' => 'ყარაჩაულ-ბალყარული',
 				'krl' => 'კარელიური',
 				'kru' => 'კურუქი',
 				'ks' => 'ქაშმირული',
 				'ksb' => 'შამბალა',
 				'ksf' => 'ბაფია',
 				'ku' => 'ქურთული',
 				'kum' => 'ყუმუხური',
 				'kut' => 'კუტენაი',
 				'kv' => 'კომი',
 				'kw' => 'კორნული',
 				'ky' => 'ყირგიზული',
 				'la' => 'ლათინური',
 				'lad' => 'ლადინო',
 				'lag' => 'ლანგი',
 				'lah' => 'ლანდა',
 				'lam' => 'ლამბა',
 				'lb' => 'ლუქსემბურგული',
 				'lez' => 'ლეზგიური',
 				'lg' => 'განდა',
 				'li' => 'ლიმბურგული',
 				'ln' => 'ლინგალა',
 				'lo' => 'ლაოსური',
 				'lol' => 'მონგო',
 				'loz' => 'ლოზი',
 				'lt' => 'ლიტვური',
 				'lu' => 'ლუბა-კატანგა',
 				'lua' => 'ლუბა-კასაი',
 				'lui' => 'ლუისენიო',
 				'lun' => 'ლუნდა',
 				'luo' => 'ლუო',
 				'lus' => 'მიზო',
 				'luy' => 'ლუჰია',
 				'lv' => 'ლატვიური',
 				'maf' => 'მაფა',
 				'mag' => 'მაგაჰი',
 				'mai' => 'მაითილი',
 				'mde' => 'მაბა',
 				'mdf' => 'მოქშა',
 				'men' => 'მენდე',
 				'mer' => 'მერუ',
 				'mg' => 'მალაგასიური',
 				'mga' => 'საშუალო ირლანდიური',
 				'mgh' => 'მაქუვა-მეეტო',
 				'mi' => 'მაორი',
 				'mic' => 'მიკმაკი',
 				'min' => 'მინანგკაბაუ',
 				'mk' => 'მაკედონური',
 				'ml' => 'მალაიალამური',
 				'mn' => 'მონღოლური',
 				'mnc' => 'მანჯურიული',
 				'mni' => 'მანიპური',
 				'moh' => 'მოჰავკი',
 				'mos' => 'მოორე',
 				'mr' => 'მარათჰი',
 				'ms' => 'მალაიური',
 				'mt' => 'მალტური',
 				'mua' => 'მუნდანგი',
 				'mus' => 'კრიკი',
 				'mwl' => 'მირანდული',
 				'mwr' => 'მარვარი',
 				'my' => 'ბირმული',
 				'mye' => 'მიენე',
 				'myv' => 'ერზია',
 				'na' => 'ნაურუ',
 				'nap' => 'ნეაპოლიტანური',
 				'naq' => 'ნამა',
 				'nb' => 'ნორვეგიული ბუკმოლი',
 				'nds' => 'ქვემოგერმანული',
 				'ne' => 'ნეპალური',
 				'new' => 'ნევარი',
 				'nl' => 'ნიდერლანდური',
 				'nl_BE' => 'ფლამანდიური',
 				'nn' => 'ნორვეგიული ნიუნორსკი',
 				'no' => 'ნორვეგიული',
 				'nog' => 'ნოღაური',
 				'non' => 'ძველსკანდინავიური',
 				'nqo' => 'ნკო',
 				'nv' => 'ნავახო',
 				'nwc' => 'კლასიკური ნევარული',
 				'ny' => 'ნიანჯა',
 				'nym' => 'ნიამვეზი',
 				'nyn' => 'ნიანკოლე',
 				'nyo' => 'ნიორო',
 				'nzi' => 'ნზიმა',
 				'oc' => 'ოქსიტანური',
 				'oj' => 'ოჯიბვე',
 				'or' => 'ორია',
 				'os' => 'ოსური',
 				'pa' => 'პენჯაბური',
 				'pal' => 'ფალაური',
 				'peo' => 'ძველი სპარსული',
 				'phn' => 'ფინიკიური',
 				'pi' => 'პალი',
 				'pl' => 'პოლონური',
 				'pro' => 'ძველი პროვანსული',
 				'ps' => 'პუშტუ',
 				'pt' => 'პორტუგალიური',
 				'pt_BR' => 'ბრაზილიური პორტუგალიური',
 				'pt_PT' => 'ევროპული პორტუგალიური',
 				'qu' => 'კეჩუა',
 				'raj' => 'რაჯასთანი',
 				'rap' => 'რაპანუი',
 				'rar' => 'რაროტონგული',
 				'rm' => 'რეტორომანული',
 				'rn' => 'რუნდი',
 				'ro' => 'რუმინული',
 				'ro_MD' => 'მოლდავური',
 				'rom' => 'ბოშური',
 				'ru' => 'რუსული',
 				'sa' => 'სანსკრიტი',
 				'sah' => 'იაკუტური',
 				'sam' => 'სამარიულ-არამეული',
 				'sc' => 'სარდინიული',
 				'scn' => 'სიცილიური',
 				'sd' => 'სინდჰური',
 				'see' => 'სენეკა',
 				'sel' => 'სელკუპური',
 				'sga' => 'ძველი ირლანდიური',
 				'sh' => 'სერბულ-ხორვატული',
 				'shi' => 'შილჰა',
 				'shn' => 'შანი',
 				'shu' => 'ჩადური არაბული',
 				'si' => 'სინჰალური',
 				'sk' => 'სლოვაკური',
 				'sl' => 'სლოვენური',
 				'sm' => 'სამოა',
 				'so' => 'სომალიური',
 				'sq' => 'ალბანური',
 				'sr' => 'სერბული',
 				'st' => 'სამხრეთ სოთოს ენა',
 				'su' => 'სუნდური',
 				'sux' => 'შუმერული',
 				'sv' => 'შვედური',
 				'sw' => 'სუაჰილი',
 				'swb' => 'კომორული',
 				'syc' => 'კლასიკური სირიული',
 				'syr' => 'სირიული',
 				'ta' => 'ტამილური',
 				'te' => 'ტელუგუ',
 				'tg' => 'ტაჯიკური',
 				'th' => 'ტაი',
 				'ti' => 'თიგრინია',
 				'tig' => 'თიგრე',
 				'tk' => 'თურქმენული',
 				'tlh' => 'კლინგონი',
 				'tn' => 'ტსვანა',
 				'to' => 'ტონგანური',
 				'tr' => 'თურქული',
 				'tt' => 'თათრული',
 				'tw' => 'თუი',
 				'tyv' => 'ტუვა',
 				'udm' => 'უდმურტული',
 				'ug' => 'უიღურული',
 				'uga' => 'უგარითული',
 				'uk' => 'უკრაინული',
 				'und' => 'უცნობი ენა',
 				'ur' => 'ურდუ',
 				'uz' => 'უზბეკური',
 				'vai' => 'ვაი',
 				'vi' => 'ვიეტნამური',
 				'wal' => 'ველაითა',
 				'wo' => 'ვოლოფური',
 				'xal' => 'ყალმუხური',
 				'xh' => 'ქჰოსა',
 				'yi' => 'იდიში',
 				'yo' => 'იორუბა',
 				'yue' => 'კანტონური',
 				'zbl' => 'ბლისსიმბოლოები',
 				'zen' => 'ზენაგა',
 				'zgh' => 'სტანდარტული მაროკოული ტამაზიგხტი',
 				'zh' => 'ჩინური',
 				'zh_Hans' => 'გამარტივებული ჩინური',
 				'zh_Hant' => 'ტრადიციული ჩინური',
 				'zu' => 'ზულუ',
 				'zxx' => 'ლინგვისტური შიგთავსი არ არის',
 				'zza' => 'ზაზაკი',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'აფაკა',
 			'Arab' => 'არაბული',
 			'Armi' => 'იმპერიული არამეული',
 			'Armn' => 'სომხური',
 			'Avst' => 'ავესტური',
 			'Bali' => 'ბალიური',
 			'Bamu' => 'ბამუმი',
 			'Bass' => 'ბასა ვაჰი',
 			'Batk' => 'ბატაკი',
 			'Beng' => 'ბენგალური',
 			'Blis' => 'ბლისსიმბოლოები',
 			'Bopo' => 'ბოპომოფო',
 			'Brah' => 'ბრაჰმი',
 			'Brai' => 'ბრაილი',
 			'Bugi' => 'ლონტარა',
 			'Buhd' => 'ბუჰიდი',
 			'Cakm' => 'ჩაკმა',
 			'Cans' => 'კანადური სილაბური',
 			'Cari' => 'კარიული',
 			'Cham' => 'ჩამი',
 			'Cher' => 'ჩეროკი',
 			'Cirt' => 'კირთი',
 			'Copt' => 'კოპტური',
 			'Cprt' => 'კვიპროსული',
 			'Cyrl' => 'კირილიცა',
 			'Cyrs' => 'ძველი სლავური კირილიცა',
 			'Deva' => 'დევანაგარი',
 			'Dsrt' => 'დეზერეტის',
 			'Dupl' => 'დუპლოის სტენოგრაფია',
 			'Egyd' => 'ეგვიპტური დემოტიკური',
 			'Egyh' => 'ეგვიპტური იერატიკული',
 			'Egyp' => 'ეგვიპტური იეროგლიფური',
 			'Ethi' => 'ეთიოპიური',
 			'Geok' => 'ხუცური',
 			'Geor' => 'ქართული',
 			'Glag' => 'გლაგოლიცა',
 			'Goth' => 'გოთური',
 			'Gran' => 'გრანთა',
 			'Grek' => 'ბერძნული',
 			'Gujr' => 'გუჯარათული',
 			'Guru' => 'გურმუხი',
 			'Hang' => 'ჰანგული',
 			'Hani' => 'ჰანი',
 			'Hano' => 'ჰანუნოო',
 			'Hans' => 'გამარტივებული',
 			'Hans@alt=stand-alone' => 'გამარტივებული ჰანი',
 			'Hant' => 'ტრადიციული',
 			'Hant@alt=stand-alone' => 'ტრადიციული ჰანი',
 			'Hebr' => 'ებრაული',
 			'Hira' => 'ჰირაგანა',
 			'Hluw' => 'ანატოლიური იეროგლიფური',
 			'Hmng' => 'ფაჰაუ-მონი',
 			'Hrkt' => 'იაპონური კანა',
 			'Hung' => 'ძველი უნგრული',
 			'Inds' => 'ჰარაფული',
 			'Ital' => 'იტალიკური',
 			'Java' => 'იავური',
 			'Jpan' => 'იაპონური',
 			'Jurc' => 'ჯურჯენული',
 			'Kali' => 'კაიაჰ-ლი',
 			'Kana' => 'კატაკანა',
 			'Khar' => 'ქაროშთი',
 			'Khmr' => 'ქმერული',
 			'Khoj' => 'ქოჯკი',
 			'Knda' => 'კანადა',
 			'Kore' => 'კორეული',
 			'Kpel' => 'კპელე',
 			'Kthi' => 'კაითი',
 			'Lana' => 'ტაი თამ',
 			'Laoo' => 'ლაოსური',
 			'Latf' => 'გოტიკური ლათინური',
 			'Latg' => 'გელური ლათინური',
 			'Latn' => 'ლათინური',
 			'Lepc' => 'რონგ-რინგი',
 			'Limb' => 'ლიმბუ',
 			'Lina' => 'A-ხაზოვანი',
 			'Linb' => 'B-ხაზოვანი',
 			'Lisu' => 'ფრეიზერის',
 			'Loma' => 'ლომა',
 			'Lyci' => 'ლიკიური',
 			'Lydi' => 'ლიდიური',
 			'Mand' => 'მანდეური',
 			'Mani' => 'მანიქეური',
 			'Maya' => 'მაიას იეროგლიფები',
 			'Mend' => 'მენდე',
 			'Merc' => 'მეროიტული კურსივი',
 			'Mero' => 'მეროიტული',
 			'Mlym' => 'მალაიალამური',
 			'Mong' => 'მონღოლური',
 			'Moon' => 'მუნისი',
 			'Mroo' => 'მრო',
 			'Mtei' => 'მანიპური',
 			'Mymr' => 'მიანმური',
 			'Narb' => 'ძველი ჩრდილოეთ-არაბული',
 			'Nbat' => 'ნაბატეური',
 			'Nkgb' => 'ნახი-გება',
 			'Nkoo' => 'ნკო',
 			'Nshu' => 'ნუშუ',
 			'Ogam' => 'ოღამი',
 			'Olck' => 'ოლ-ჩიკი',
 			'Orkh' => 'ორხონული',
 			'Orya' => 'ორია',
 			'Osma' => 'ოსმანია',
 			'Palm' => 'პალმირული',
 			'Perm' => 'ძველი პერმული',
 			'Phag' => 'ფაგსპა',
 			'Phli' => 'მონუმენტური ფალაური',
 			'Phlp' => 'ფსალმუნური ფალაური',
 			'Phlv' => 'წიგნური ფალაური',
 			'Phnx' => 'ფინიკიური',
 			'Plrd' => 'პოლარდისი',
 			'Prti' => 'მონუმენტური პართული',
 			'Rjng' => 'რეჯანგი',
 			'Roro' => 'რონგორონგო',
 			'Runr' => 'რუნული',
 			'Samr' => 'სამარიული',
 			'Sara' => 'სარატი',
 			'Sarb' => 'ძველი სამხრეთ-არაბული',
 			'Saur' => 'საურაშტრა',
 			'Sgnw' => 'ჟესტთა',
 			'Shaw' => 'შოუსი',
 			'Shrd' => 'შარადა',
 			'Sind' => 'ქუდავადი',
 			'Sinh' => 'სინჰალური',
 			'Sora' => 'სორან-სომპენი',
 			'Sund' => 'სუნდანური',
 			'Sylo' => 'სილოტი ნაგრი',
 			'Syrc' => 'სირიული',
 			'Syre' => 'სირიული ესტრანგელო',
 			'Syrj' => 'დასავლეთი სირიული',
 			'Syrn' => 'აღმოსავლეთი სირიული',
 			'Tagb' => 'ტაგბანვა',
 			'Takr' => 'ტაკრი',
 			'Tale' => 'ტაი ლე',
 			'Talu' => 'ახალი ტაი ლიუ',
 			'Taml' => 'ტამილური',
 			'Tang' => 'ტანღუტური',
 			'Tavt' => 'ტაი-ვიეტი',
 			'Telu' => 'ტელუგუ',
 			'Teng' => 'ტენგვარი',
 			'Tfng' => 'ტიფინაღი',
 			'Tglg' => 'ბაიბაინი',
 			'Thaa' => 'თაანა',
 			'Thai' => 'ტაი',
 			'Tibt' => 'ტიბეტური',
 			'Tirh' => 'ტირჰუტა',
 			'Ugar' => 'უგარითული',
 			'Vaii' => 'ვაი',
 			'Visp' => 'ხილული მეტყველება',
 			'Wara' => 'ვარანგ-კშიტი',
 			'Wole' => 'ვოლეაი',
 			'Xpeo' => 'ძველი სპარსული',
 			'Xsux' => 'შუმერულ-აქადური ლურსმნული',
 			'Yiii' => 'ი',
 			'Zinh' => 'გადაღებული',
 			'Zmth' => 'მათემატიკური ნოტაცია',
 			'Zsym' => 'სიმბოლოები',
 			'Zxxx' => 'უმწერლობო',
 			'Zyyy' => 'ზოგადი',
 			'Zzzz' => 'უცნობი დამწერლობა',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'მსოფლიო',
 			'002' => 'აფრიკა',
 			'003' => 'ჩრდილოეთი ამერიკა',
 			'005' => 'სამხრეთი ამერიკა',
 			'009' => 'ოკეანეთი',
 			'011' => 'დასავლეთი აფრიკა',
 			'013' => 'ცენტრალური ამერიკა',
 			'014' => 'აღმოსავლეთი აფრიკა',
 			'015' => 'ჩრდილოეთი აფრიკა',
 			'017' => 'შუა აფრიკა',
 			'018' => 'სამხრეთი აფრიკა',
 			'019' => 'ამერიკები',
 			'021' => 'ამერიკის ჩრდილოეთი',
 			'029' => 'კარიბის ზღვა',
 			'030' => 'აღმოსავლეთი აზია',
 			'034' => 'სამხრეთი აზია',
 			'035' => 'სამხრეთ-აღმოსავლეთი აზია',
 			'039' => 'სამხრეთი ევროპა',
 			'053' => 'ავსტრალაზია',
 			'054' => 'მელანეზია',
 			'057' => 'მიკრონეზიის რეგიონი',
 			'061' => 'პოლინეზია',
 			'142' => 'აზია',
 			'143' => 'ცენტრალური აზია',
 			'145' => 'დასავლეთი აზია',
 			'150' => 'ევროპა',
 			'151' => 'აღმოსავლეთი ევროპა',
 			'154' => 'ჩრდილოეთი ევროპა',
 			'155' => 'დასავლეთი ევროპა',
 			'419' => 'ლათინური ამერიკა',
 			'AC' => 'ამაღლების კუნძული',
 			'AD' => 'ანდორა',
 			'AE' => 'არაბთა გაერთიანებული საამიროები',
 			'AF' => 'ავღანეთი',
 			'AG' => 'ანტიგუა და ბარბუდა',
 			'AI' => 'ანგვილა',
 			'AL' => 'ალბანეთი',
 			'AM' => 'სომხეთი',
 			'AN' => 'ნიდერლანდების ანტილები',
 			'AO' => 'ანგოლა',
 			'AQ' => 'ანტარქტიკა',
 			'AR' => 'არგენტინა',
 			'AS' => 'ამერიკული სამოა',
 			'AT' => 'ავსტრია',
 			'AU' => 'ავსტრალია',
 			'AW' => 'არუბა',
 			'AX' => 'ალანდის კუნძულები',
 			'AZ' => 'აზერბაიჯანი',
 			'BA' => 'ბოსნია და ჰერცეგოვინა',
 			'BB' => 'ბარბადოსი',
 			'BD' => 'ბანგლადეში',
 			'BE' => 'ბელგია',
 			'BF' => 'ბურკინა-ფასო',
 			'BG' => 'ბულგარეთი',
 			'BH' => 'ბაჰრეინი',
 			'BI' => 'ბურუნდი',
 			'BJ' => 'ბენინი',
 			'BL' => 'სენ-ბართლემი',
 			'BM' => 'ბერმუდი',
 			'BN' => 'ბრუნეი',
 			'BO' => 'ბოლივია',
 			'BQ' => 'კარიბის ნიდერლანდები',
 			'BR' => 'ბრაზილია',
 			'BS' => 'ბაჰამის კუნძულები',
 			'BT' => 'ბუტანი',
 			'BV' => 'ბუვეს კუნძული',
 			'BW' => 'ბოტსვანა',
 			'BY' => 'ბელორუსია',
 			'BZ' => 'ბელიზი',
 			'CA' => 'კანადა',
 			'CC' => 'ქოქოსის (კილინგის) კუნძულები',
 			'CD' => 'კონგო - კინშასა',
 			'CD@alt=variant' => 'კონგო (კონგოს დემოკრატიული რესპუბლიკა)',
 			'CF' => 'ცენტრალური აფრიკის რესპუბლიკა',
 			'CG' => 'კონგო - ბრაზავილი',
 			'CG@alt=variant' => 'კონგო (რესპუბლიკა)',
 			'CH' => 'შვეიცარია',
 			'CI' => 'კოტ-დივუარი',
 			'CI@alt=variant' => 'სპილოს ძვლის სანაპირო',
 			'CK' => 'კუკის კუნძულები',
 			'CL' => 'ჩილე',
 			'CM' => 'კამერუნი',
 			'CN' => 'ჩინეთი',
 			'CO' => 'კოლუმბია',
 			'CP' => 'კლიპერტონის კუნძული',
 			'CR' => 'კოსტა-რიკა',
 			'CU' => 'კუბა',
 			'CV' => 'კაბო-ვერდე',
 			'CW' => 'კიურასაო',
 			'CX' => 'შობის კუნძული',
 			'CY' => 'კვიპროსი',
 			'CZ' => 'ჩეხეთის რესპუბლიკა',
 			'DE' => 'გერმანია',
 			'DG' => 'დიეგო-გარსია',
 			'DJ' => 'ჯიბუტი',
 			'DK' => 'დანია',
 			'DM' => 'დომინიკა',
 			'DO' => 'დომინიკანის რესპუბლიკა',
 			'DZ' => 'ალჟირი',
 			'EA' => 'სეუტა და მელილა',
 			'EC' => 'ეკვადორი',
 			'EE' => 'ესტონეთი',
 			'EG' => 'ეგვიპტე',
 			'EH' => 'დასავლეთი საჰარა',
 			'ER' => 'ერიტრეა',
 			'ES' => 'ესპანეთი',
 			'ET' => 'ეთიოპია',
 			'EU' => 'ევროკავშირი',
 			'FI' => 'ფინეთი',
 			'FJ' => 'ფიჯი',
 			'FK' => 'ფოლკლენდის კუნძულები',
 			'FK@alt=variant' => 'ფოლკლენდის კუნძულები (მალვინის კუნძულები)',
 			'FM' => 'მიკრონეზია',
 			'FO' => 'ფარერის კუნძულები',
 			'FR' => 'საფრანგეთი',
 			'GA' => 'გაბონი',
 			'GB' => 'დიდი ბრიტანეთი',
 			'GB@alt=short' => 'გაერთ.სამ.',
 			'GD' => 'გრენადა',
 			'GE' => 'საქართველო',
 			'GF' => 'ფრანგული გვიანა',
 			'GG' => 'გერნსი',
 			'GH' => 'განა',
 			'GI' => 'გიბრალტარი',
 			'GL' => 'გრენლანდია',
 			'GM' => 'გამბია',
 			'GN' => 'გვინეა',
 			'GP' => 'გვადელუპე',
 			'GQ' => 'ეკვატორული გვინეა',
 			'GR' => 'საბერძნეთი',
 			'GS' => 'სამხრეთი გეორგია და სამხრეთ სენდვიჩის კუნძულები',
 			'GT' => 'გვატემალა',
 			'GU' => 'გუამი',
 			'GW' => 'გვინეა-ბისაუ',
 			'GY' => 'გაიანა',
 			'HK' => 'ჰონკონგის სპეციალური ადმინისტრაციული რეგიონი ჩინეთი',
 			'HK@alt=short' => 'ჰონკონგი',
 			'HM' => 'ჰერდი და მაკდონალდის კუნძულები',
 			'HN' => 'ჰონდურასი',
 			'HR' => 'ხორვატია',
 			'HT' => 'ჰაიტი',
 			'HU' => 'უნგრეთი',
 			'IC' => 'კანარის კუნძულები',
 			'ID' => 'ინდონეზია',
 			'IE' => 'ირლანდია',
 			'IL' => 'ისრაელი',
 			'IM' => 'მენის კუნძული',
 			'IN' => 'ინდოეთი',
 			'IO' => 'ბრიტანული ტერიტორია ინდოეთის ოკეანეში',
 			'IQ' => 'ერაყი',
 			'IR' => 'ირანი',
 			'IS' => 'ისლანდია',
 			'IT' => 'იტალია',
 			'JE' => 'ჯერსი',
 			'JM' => 'იამაიკა',
 			'JO' => 'იორდანია',
 			'JP' => 'იაპონია',
 			'KE' => 'კენია',
 			'KG' => 'ყირგიზეთი',
 			'KH' => 'კამბოჯა',
 			'KI' => 'კირიბატი',
 			'KM' => 'კომორის კუნძულები',
 			'KN' => 'სენტ-კიტსი და ნევისი',
 			'KP' => 'ჩრდილოეთი კორეა',
 			'KR' => 'სამხრეთი კორეა',
 			'KW' => 'ქუვეითი',
 			'KY' => 'კაიმანის კუნძულები',
 			'KZ' => 'ყაზახეთი',
 			'LA' => 'ლაოსი',
 			'LB' => 'ლიბანი',
 			'LC' => 'სენტ-ლუსია',
 			'LI' => 'ლიხტენშტეინი',
 			'LK' => 'შრი-ლანკა',
 			'LR' => 'ლიბერია',
 			'LS' => 'ლესოთო',
 			'LT' => 'ლიტვა',
 			'LU' => 'ლუქსემბურგი',
 			'LV' => 'ლატვია',
 			'LY' => 'ლიბია',
 			'MA' => 'მაროკო',
 			'MC' => 'მონაკო',
 			'MD' => 'მოლდოვა',
 			'ME' => 'მონტენეგრო',
 			'MF' => 'სენ-მარტენი',
 			'MG' => 'მადაგასკარი',
 			'MH' => 'მარშალის კუნძულები',
 			'MK' => 'მაკედონია',
 			'MK@alt=variant' => 'მაკედონია (ყოფილი იუგოსლავიის რესპუბლიკა მაკედონია)',
 			'ML' => 'მალი',
 			'MM' => 'მიანმარი (ბირმა)',
 			'MN' => 'მონღოლეთი',
 			'MO' => 'მაკაოს სპეციალური ადმინისტრაციული რეგიონი ჩინეთი',
 			'MO@alt=short' => 'მაკაო',
 			'MP' => 'ჩრდილოეთ მარიანას კუნძულები',
 			'MQ' => 'მარტინიკა',
 			'MR' => 'მავრიტანია',
 			'MS' => 'მონსერატი',
 			'MT' => 'მალტა',
 			'MU' => 'მავრიკი',
 			'MV' => 'მალდივის კუნძულები',
 			'MW' => 'მალავი',
 			'MX' => 'მექსიკა',
 			'MY' => 'მალაიზია',
 			'MZ' => 'მოზამბიკი',
 			'NA' => 'ნამიბია',
 			'NC' => 'ახალი კალედონია',
 			'NE' => 'ნიგერი',
 			'NF' => 'ნორფოლკის კუნძული',
 			'NG' => 'ნიგერია',
 			'NI' => 'ნიკარაგუა',
 			'NL' => 'ნიდერლანდები',
 			'NO' => 'ნორვეგია',
 			'NP' => 'ნეპალი',
 			'NR' => 'ნაურუ',
 			'NU' => 'ნიუე',
 			'NZ' => 'ახალი ზელანდია',
 			'OM' => 'ომანი',
 			'PA' => 'პანამა',
 			'PE' => 'პერუ',
 			'PF' => 'ფრანგული პოლინეზია',
 			'PG' => 'პაპუა-ახალი გვინეა',
 			'PH' => 'ფილიპინები',
 			'PK' => 'პაკისტანი',
 			'PL' => 'პოლონეთი',
 			'PM' => 'სენ-პიერი და მიკელონი',
 			'PN' => 'პიტკერნის კუნძულები',
 			'PR' => 'პუერტო-რიკო',
 			'PS' => 'პალესტინის ტერიტორიები',
 			'PS@alt=short' => 'პალესტინა',
 			'PT' => 'პორტუგალია',
 			'PW' => 'პალაუ',
 			'PY' => 'პარაგვაი',
 			'QA' => 'კატარი',
 			'QO' => 'შორეული ოკეანეთი',
 			'RE' => 'რეუნიონი',
 			'RO' => 'რუმინეთი',
 			'RS' => 'სერბეთი',
 			'RU' => 'რუსეთი',
 			'RW' => 'რუანდა',
 			'SA' => 'საუდის არაბეთი',
 			'SB' => 'სოლომონის კუნძულები',
 			'SC' => 'სეიშელის კუნძულები',
 			'SD' => 'სუდანი',
 			'SE' => 'შვედეთი',
 			'SG' => 'სინგაპური',
 			'SH' => 'წმინდა ელენეს კუნძული',
 			'SI' => 'სლოვენია',
 			'SJ' => 'შპიცბერგენი და იან-მაიენი',
 			'SK' => 'სლოვაკეთი',
 			'SL' => 'სიერა-ლეონე',
 			'SM' => 'სან-მარინო',
 			'SN' => 'სენეგალი',
 			'SO' => 'სომალი',
 			'SR' => 'სურინამი',
 			'SS' => 'სამხრეთი სუდანი',
 			'ST' => 'სან-ტომე და პრინსიპი',
 			'SV' => 'სალვადორი',
 			'SX' => 'სინტ-მარტენი',
 			'SY' => 'სირია',
 			'SZ' => 'სვაზილენდი',
 			'TA' => 'ტრისტან-და-კუნია',
 			'TC' => 'ტერკსის და კაიკოსის კუნძულები',
 			'TD' => 'ჩადი',
 			'TF' => 'ფრანგული სამხრეთის ტერიტორიები',
 			'TG' => 'ტოგო',
 			'TH' => 'ტაილანდი',
 			'TJ' => 'ტაჯიკეთი',
 			'TK' => 'ტოკელაუ',
 			'TL' => 'ტიმორ-ლეშტი',
 			'TL@alt=variant' => 'აღმოსავლეთი ტიმორი',
 			'TM' => 'თურქმენეთი',
 			'TN' => 'ტუნისი',
 			'TO' => 'ტონგა',
 			'TR' => 'თურქეთი',
 			'TT' => 'ტრინიდადი და ტობაგო',
 			'TV' => 'ტუვალუ',
 			'TW' => 'ტაივანი',
 			'TZ' => 'ტანზანია',
 			'UA' => 'უკრაინა',
 			'UG' => 'უგანდა',
 			'UM' => 'აშშ-ის შორეული კუნძულები',
 			'US' => 'ამერიკის შეერთებული შტატები',
 			'US@alt=short' => 'აშშ',
 			'UY' => 'ურუგვაი',
 			'UZ' => 'უზბეკეთი',
 			'VA' => 'ქალაქი ვატიკანი',
 			'VC' => 'სენტ-ვინსენტი და გრენადინები',
 			'VE' => 'ვენესუელა',
 			'VG' => 'ბრიტანეთის ვირჯინიის კუნძულები',
 			'VI' => 'აშშ-ის ვირჯინიის კუნძულები',
 			'VN' => 'ვიეტნამი',
 			'VU' => 'ვანუატუ',
 			'WF' => 'უოლისი და ფუტუნა',
 			'WS' => 'სამოა',
 			'XK' => 'კოსოვო',
 			'YE' => 'იემენი',
 			'YT' => 'მაიოტა',
 			'ZA' => 'სამხრეთ აფრიკა',
 			'ZM' => 'ზამბია',
 			'ZW' => 'ზიმბაბვე',
 			'ZZ' => 'უცნობი რეგიონი',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'ტრადიციული გერმანული ორთოგრაფია',
 			'1994' => 'სტანდარტული რეზიანული ორთოგრაფია',
 			'1996' => '1996 წლის გერმანული ორთოგრაფია',
 			'1606NICT' => 'გვიანი საშუალო ფრანგული',
 			'1694ACAD' => 'ადრე ახალი ფრანგული',
 			'1959ACAD' => 'აკადემიური',
 			'ALALC97' => 'ALA-LC რომანიზაცია',
 			'ALUKU' => 'ალუკუ',
 			'AREVELA' => 'აღმოსავლეთსომხური',
 			'AREVMDA' => 'დასავლეთსომხური',
 			'BAKU1926' => 'უნიფიცირებული თურქული ლათინური',
 			'BAUDDHA' => 'ბუდისტური სანსკრიტი',
 			'BISCAYAN' => 'ბისკაიური ბასკური',
 			'BISKE' => 'ბილური რეზიული',
 			'BOHORIC' => 'ბოხორიჩიცა',
 			'BOONT' => 'ბუნტლინგი',
 			'DAJNKO' => 'დაინჩიცა',
 			'EMODENG' => 'ადრე ახალი ინგლისური',
 			'FONIPA' => 'IPA',
 			'FONUPA' => 'UPA',
 			'FONXSAMP' => 'X-SAMPA',
 			'HEPBURN' => 'ჰეპბერნის რომანიზაცია',
 			'HOGNORSK' => 'ჰეგნორსკი',
 			'ITIHASA' => 'იტიხასა',
 			'JAUER' => 'მიუნსტერული რეტორომანული',
 			'JYUTPING' => 'იუტ-ფინი',
 			'KKCOR' => 'ზოგადი ორთოგრაფია',
 			'KSCOR' => 'სტანდარტული ორთოგრაფია',
 			'LAUKIKA' => 'ლაუკიკა',
 			'LIPAW' => 'ლიპოვაცური რეზიული',
 			'LUNA1918' => '1918 წლის რუსილი',
 			'METELKO' => 'მეტელკოსი',
 			'NDYUKA' => 'ნჯუკა',
 			'NEDIS' => 'ნატისონური',
 			'NJIVA' => 'ნიივური რეზიული',
 			'NULIK' => 'თანამედროვე ვოლაპიუკი',
 			'OSOJS' => 'ოსოიანური რეზიული',
 			'PAMAKA' => 'პამაკა',
 			'PETR1708' => 'პეტრის 1708 წლის',
 			'PINYIN' => 'პინ-ინი',
 			'POSIX' => 'კომპიუტერული',
 			'PUTER' => 'პუტერული რეტორომანული',
 			'REVISED' => 'ახალი ორთოგრაფია',
 			'RIGIK' => 'კლასიკური ვოლაპიუკი',
 			'ROZAJ' => 'რეზიული',
 			'RUMGR' => 'გრიშუნული რეტორომანული',
 			'SAAHO' => 'საჰო',
 			'SCOTLAND' => 'შოტლანდიური ინგლისური',
 			'SCOUSE' => 'სკაუსი',
 			'SOLBA' => 'სოლბიცური რეზიული',
 			'SURMIRAN' => 'სურმირანული რეტორომანული',
 			'SURSILV' => 'სურსილვანური რეტორომანული',
 			'SUTSILV' => 'სუტსილვანური რეტორომანული',
 			'TARASK' => 'ტარაშკევიცა',
 			'UCCOR' => 'უნიფიცირებული ორთოგრაფია',
 			'UCRCOR' => 'გადასინჯული უნიფიცირებული ორთოგრაფია',
 			'ULSTER' => 'ულსტერის ირლანდიური',
 			'VAIDIKA' => 'ვედური სანსკრიტი',
 			'VALENCIA' => 'ვალენსიური კატალანური',
 			'VALLADER' => 'ვალადერული რეტორომანული',
 			'WADEGILE' => 'ვეიდ-ჯაილზი',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'კალენდარი',
 			'collation' => 'დახარისხების თანმიმდევრობა',
 			'currency' => 'ვალუტა',
 			'numbers' => 'რიცხვები',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ბუდისტური კალენდარი},
 				'chinese' => q{ჩინური კალენდარი},
 				'coptic' => q{კოპტური კალენდარი},
 				'dangi' => q{კალენდარი დანგი},
 				'ethiopic' => q{ეთიოპიური კალენდარი},
 				'ethiopic-amete-alem' => q{ეთიოპიური ამეთე ალემი კალენდარი},
 				'gregorian' => q{გრიგორიანული კალენდარი},
 				'hebrew' => q{ებრაული კალენდარი},
 				'indian' => q{ინდოეთის ეროვნული კალენდარი},
 				'islamic' => q{ისლამური კალენდარი},
 				'islamic-civil' => q{ისლამური სამოქალაქო კალენდარი},
 				'japanese' => q{იაპონური კალენდარი},
 				'persian' => q{სპარსული კალენდარი},
 				'roc' => q{ჩინეთის რესპუბლიკის კალენდარი},
 			},
 			'collation' => {
 				'big5han' => q{ტრადიციული ჩინური},
 				'dictionary' => q{ლექსიკონით},
 				'ducet' => q{უნიკოდის ნაგულისხმევი დახარისხების თანმიმდევრობა},
 				'gb2312han' => q{გამარტივებული ჩინური},
 				'phonebook' => q{ტელეფონის წიგნით},
 				'pinyin' => q{პინ-ინი},
 				'reformed' => q{რეფორმირებული},
 				'search' => q{ზოგადი დანიშნულების ძიება},
 				'searchjl' => q{ჰანგულის პირველი თანხმოვნით},
 				'standard' => q{სტანდარტული დახარისხების თანმიმდევრობა},
 				'stroke' => q{შტრიხით},
 				'traditional' => q{ტრადიციული},
 				'unihan' => q{ძირითადი შტრიხით},
 				'zhuyin' => q{ჟუინი},
 			},
 			'numbers' => {
 				'arab' => q{არაბულ-ინდური ციფრები},
 				'arabext' => q{გაფართოებული არაბულ-ინდური ციფრები},
 				'armn' => q{სომხური რიცხვები},
 				'armnlow' => q{სომხური ქვედა რეგისტრის რიცხვები},
 				'bali' => q{ბალიური ციფრები},
 				'beng' => q{ბენგალური ციფრები},
 				'cham' => q{ჩამური ციფრები},
 				'deva' => q{დევანაგარის ციფრები},
 				'ethi' => q{ეთიოპიური რიცხვები},
 				'fullwide' => q{სრულსიგანიანი ციფრები},
 				'geor' => q{ქართული რიცხვები},
 				'grek' => q{ბერძნული რიცხვები},
 				'greklow' => q{ბერძნული ქვედა რეგისტრის რიცხვები},
 				'gujr' => q{გუჯარათული ციფრები},
 				'guru' => q{გურმუხული ციფრები},
 				'hanidec' => q{ჩინური ათობითი რიცხვები},
 				'hans' => q{გამარტივებული ჩინური რიცხვები},
 				'hansfin' => q{გამარტივებული ჩინური ფინანსური რიცხვები},
 				'hant' => q{ტრადიციული ჩინური რიცხვები},
 				'hantfin' => q{ტრადიციული ჩინური ფინანსური რიცხვები},
 				'hebr' => q{ებრაული რიცხვები},
 				'java' => q{იავური ციფრები},
 				'jpan' => q{იაპონური რიცხვები},
 				'jpanfin' => q{იაპონური ფინანსური რიცხვები},
 				'kali' => q{კაიაჰ-ლისი ციფრები},
 				'khmr' => q{ქხმერული ციფრები},
 				'knda' => q{კანადური რიცხვები},
 				'lana' => q{ტაი თამის ჰორასი ციფრები},
 				'lanatham' => q{ტაი თამის თამისი ციფრები},
 				'laoo' => q{ლაოსური ციფრები},
 				'latn' => q{დასავლური ციფრები},
 				'lepc' => q{რონგ-რინგის ციფრები},
 				'limb' => q{ლიმბური ციფრები},
 				'mlym' => q{მალაიალამური ციფრები},
 				'mong' => q{მონღოლური ციფრები},
 				'mtei' => q{მანიპური ციფრები},
 				'mymr' => q{მიანმური ციფრები},
 				'mymrshan' => q{მიანმური შანი ციფრები},
 				'nkoo' => q{ნკოური ციფრები},
 				'olck' => q{ოლ-ჩიკის ციფრები},
 				'orya' => q{ორიული ციფრები},
 				'roman' => q{რომაული ციფრები},
 				'romanlow' => q{რომაული ქვედა რეგისტრის რიცხვები},
 				'saur' => q{საურაშტრული ციფრები},
 				'sund' => q{სუნდანური ციფრები},
 				'talu' => q{ახალი ტაი ლიუსი ციფრები},
 				'taml' => q{ტრადიციული ტამილური რიცხვები},
 				'tamldec' => q{ტამილური ციფრები},
 				'telu' => q{ტელუგუს ციფრები},
 				'thai' => q{ტაილანდური ციფრები},
 				'tibt' => q{ტიბეტური ციფრები},
 				'vaii' => q{ვაიური ციფრები},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{მეტრული},
 			'UK' => q{ბრიტანული},
 			'US' => q{ამერიკული},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ენა: {0}',
 			'script' => 'დამწერლობა: {0}',
 			'territory' => 'რეგიონი: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[ⴀ ⴁ ⴂ ⴃ ⴄ ⴅ ⴆ ჱ ⴡ ⴇ ⴈ ⴉ ⴊ ⴋ ⴌ ჲ ⴢ ⴍ ⴎ ⴏ ⴐ ⴑ ⴒ ჳ ⴣ ⴓ ⴔ ⴕ ⴖ ⴗ ⴘ ⴙ ⴚ ⴛ ⴜ ⴝ ⴞ ჴ ⴤ ⴟ ⴠ ჵ ⴥ ჶ ჷ ჸ ჹ ჺ])},
			index => ['ა', 'ბ', 'გ', 'დ', 'ე', 'ვ', 'ზ', 'თ', 'ი', 'კ', 'ლ', 'მ', 'ნ', 'ო', 'პ', 'ჟ', 'რ', 'ს', 'ტ', 'უ', 'ფ', 'ქ', 'ღ', 'ყ', 'შ', 'ჩ', 'ც', 'ძ', 'წ', 'ჭ', 'ხ', 'ჯ', 'ჰ'],
			main => qr{(?^u:[ა ბ გ დ ე ვ ზ თ ი კ ლ მ ნ ო პ ჟ რ ს ტ უ ფ ქ ღ ყ შ ჩ ც ძ წ ჭ ხ ჯ ჰ])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ჻ ' ‘ ‚ “ „ « » ( ) \[ \] \{ \} § @ * / \& # † ‡ ′ ″ №])},
		};
	},
EOT
: sub {
	return { index => ['ა', 'ბ', 'გ', 'დ', 'ე', 'ვ', 'ზ', 'თ', 'ი', 'კ', 'ლ', 'მ', 'ნ', 'ო', 'პ', 'ჟ', 'რ', 'ს', 'ტ', 'უ', 'ფ', 'ქ', 'ღ', 'ყ', 'შ', 'ჩ', 'ც', 'ძ', 'წ', 'ჭ', 'ხ', 'ჯ', 'ჰ'], };
},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{«},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{»},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					'arc-minute' => {
						'one' => q({0} წუთი),
						'other' => q({0} წუთი),
					},
					'arc-second' => {
						'one' => q({0} წამი),
						'other' => q({0} წამი),
					},
					'celsius' => {
						'one' => q({0} გრადუსი ცელსიუსით),
						'other' => q({0} გრადუსი ცელსიუსით),
					},
					'centimeter' => {
						'one' => q({0} სანტიმეტრი),
						'other' => q({0} სანტიმეტრი),
					},
					'cubic-kilometer' => {
						'one' => q({0} კუბური კილომეტრი),
						'other' => q({0} კუბური კილომეტრი),
					},
					'cubic-mile' => {
						'one' => q({0} კუბური მილი),
						'other' => q({0} კუბური მილი),
					},
					'day' => {
						'one' => q({0} დღე),
						'other' => q({0} დღე),
					},
					'degree' => {
						'one' => q({0} გრადუსი),
						'other' => q({0} გრადუსი),
					},
					'fahrenheit' => {
						'one' => q({0} გრადუსი ფარენჰეიტით),
						'other' => q({0} გრადუსი ფარენჰეიტით),
					},
					'foot' => {
						'one' => q({0} ფუტი),
						'other' => q({0} ფუტი),
					},
					'g-force' => {
						'one' => q({0} ინერციის ძალა),
						'other' => q({0} ინერციის ძალა),
					},
					'gram' => {
						'one' => q({0} გრამი),
						'other' => q({0} გრამი),
					},
					'hectare' => {
						'one' => q({0} ჰექტარი),
						'other' => q({0} ჰექტარი),
					},
					'hectopascal' => {
						'one' => q({0} ჰექტოპასკალი),
						'other' => q({0} ჰექტოპასკალი),
					},
					'horsepower' => {
						'one' => q({0} ცხენის ძალა),
						'other' => q({0} ცხენის ძალა),
					},
					'hour' => {
						'one' => q({0} საათი),
						'other' => q({0} საათი),
					},
					'inch' => {
						'one' => q({0} დუიმი),
						'other' => q({0} დუიმი),
					},
					'inch-hg' => {
						'one' => q({0} ვერცხლისწყლის დუიმი),
						'other' => q({0} ვერცხლისწყლის დუიმი),
					},
					'kilogram' => {
						'one' => q({0} კილოგრამი),
						'other' => q({0} კილოგრამი),
					},
					'kilometer' => {
						'one' => q({0} კილომეტრი),
						'other' => q({0} კილომეტრი),
					},
					'kilometer-per-hour' => {
						'one' => q({0} კილომეტრი საათში),
						'other' => q({0} კილომეტრი საათში),
					},
					'kilowatt' => {
						'one' => q({0} კილოვატი),
						'other' => q({0} კილოვატი),
					},
					'light-year' => {
						'one' => q({0} სინათლის წელი),
						'other' => q({0} სინათლის წელი),
					},
					'liter' => {
						'one' => q({0} ლიტრი),
						'other' => q({0} ლიტრი),
					},
					'meter' => {
						'one' => q({0}მეტრი),
						'other' => q({0}მეტრი),
					},
					'meter-per-second' => {
						'one' => q({0} მეტრი წამში),
						'other' => q({0} მეტრი წამში),
					},
					'mile' => {
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					'mile-per-hour' => {
						'one' => q({0} მილი საათში),
						'other' => q({0} მილი საათში),
					},
					'millibar' => {
						'one' => q({0} მილიბარი),
						'other' => q({0} მილიბარი),
					},
					'millimeter' => {
						'one' => q({0} მილიმეტრი),
						'other' => q({0} მილიმეტრი),
					},
					'millisecond' => {
						'one' => q({0} მილიწამი),
						'other' => q({0} მილიწამი),
					},
					'minute' => {
						'one' => q({0} წუთი),
						'other' => q({0} წუთი),
					},
					'month' => {
						'one' => q({0} თვე),
						'other' => q({0} თვე),
					},
					'ounce' => {
						'one' => q({0} უნცია),
						'other' => q({0} უნცია),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} პიკომეტრი),
						'other' => q({0} პიკომეტრი),
					},
					'pound' => {
						'one' => q({0} ფუნტი),
						'other' => q({0} ფუნტი),
					},
					'second' => {
						'one' => q({0} წამი),
						'other' => q({0} წამი),
					},
					'square-foot' => {
						'one' => q({0} კვადრატული ფუტი),
						'other' => q({0} კვადრატული ფუტი),
					},
					'square-kilometer' => {
						'one' => q({0} კვადრატული კილომეტრი),
						'other' => q({0} კვადრატული კილომეტრი),
					},
					'square-meter' => {
						'one' => q({0} კვადრატული მეტრი),
						'other' => q({0} კვადრატული მეტრი),
					},
					'square-mile' => {
						'one' => q({0} კვადრატული მილი),
						'other' => q({0} კვადრატული მილი),
					},
					'watt' => {
						'one' => q({0} ვატი),
						'other' => q({0} ვატი),
					},
					'week' => {
						'one' => q({0} კვირა),
						'other' => q({0} კვირა),
					},
					'yard' => {
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					'year' => {
						'one' => q({0} წელი),
						'other' => q({0} წელი),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					'arc-minute' => {
						'one' => q({0} წთ),
						'other' => q({0} წთ),
					},
					'arc-second' => {
						'one' => q({0} წმ),
						'other' => q({0} წმ),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} სმ),
						'other' => q({0} სმ),
					},
					'cubic-kilometer' => {
						'one' => q({0} კმ³),
						'other' => q({0} კმ³),
					},
					'cubic-mile' => {
						'one' => q({0} მილი³),
						'other' => q({0} მილი³),
					},
					'day' => {
						'one' => q({0} დღე),
						'other' => q({0} დღე),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} ფტ),
						'other' => q({0} ფტ),
					},
					'g-force' => {
						'one' => q({0} ინ. ძ.),
						'other' => q({0} ინ. ძ.),
					},
					'gram' => {
						'one' => q({0} გ),
						'other' => q({0} გ),
					},
					'hectare' => {
						'one' => q({0} ჰა),
						'other' => q({0} ჰა),
					},
					'hectopascal' => {
						'one' => q({0} ჰპა),
						'other' => q({0} ჰპა),
					},
					'horsepower' => {
						'one' => q({0}ცხ.ძ.),
						'other' => q({0}ცხ.ძ.),
					},
					'hour' => {
						'one' => q({0} სთ),
						'other' => q({0} სთ),
					},
					'inch' => {
						'one' => q({0} დმ),
						'other' => q({0} დმ),
					},
					'inch-hg' => {
						'one' => q({0} ვრც. დმ.),
						'other' => q({0} ვრც. დმ.),
					},
					'kilogram' => {
						'one' => q({0} კგ),
						'other' => q({0} კგ),
					},
					'kilometer' => {
						'one' => q({0} კმ),
						'other' => q({0} კმ),
					},
					'kilometer-per-hour' => {
						'one' => q({0} კმ/სთ),
						'other' => q({0} კმ/სთ),
					},
					'kilowatt' => {
						'one' => q({0} კვტ),
						'other' => q({0} კვტ),
					},
					'light-year' => {
						'one' => q({0} სწ),
						'other' => q({0} სწ),
					},
					'liter' => {
						'one' => q({0}ლ),
						'other' => q({0}ლ),
					},
					'meter' => {
						'one' => q({0}მ),
						'other' => q({0}მ),
					},
					'meter-per-second' => {
						'one' => q({0} მ/წმ),
						'other' => q({0} მ/წმ),
					},
					'mile' => {
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					'mile-per-hour' => {
						'one' => q({0} მილი/სთ),
						'other' => q({0} მილი/სთ),
					},
					'millibar' => {
						'one' => q({0} მბრ),
						'other' => q({0} მბრ),
					},
					'millimeter' => {
						'one' => q({0} მმ),
						'other' => q({0} მმ),
					},
					'millisecond' => {
						'one' => q({0} მწ),
						'other' => q({0} მწ),
					},
					'minute' => {
						'one' => q({0} წთ),
						'other' => q({0} წთ),
					},
					'month' => {
						'one' => q({0} თვე),
						'other' => q({0} თვე),
					},
					'ounce' => {
						'one' => q({0} უნც),
						'other' => q({0} უნც),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} პმ),
						'other' => q({0} პმ),
					},
					'pound' => {
						'one' => q({0} ფნტ),
						'other' => q({0} ფნტ),
					},
					'second' => {
						'one' => q({0} წმ),
						'other' => q({0} წმ),
					},
					'square-foot' => {
						'one' => q({0} ფტ²),
						'other' => q({0} ფტ²),
					},
					'square-kilometer' => {
						'one' => q({0} კმ²),
						'other' => q({0} კმ²),
					},
					'square-meter' => {
						'one' => q({0} მ²),
						'other' => q({0} მ²),
					},
					'square-mile' => {
						'one' => q({0} მილი²),
						'other' => q({0} მილი²),
					},
					'watt' => {
						'one' => q({0} ვტ),
						'other' => q({0} ვტ),
					},
					'week' => {
						'one' => q({0} კვრ),
						'other' => q({0} კვრ),
					},
					'yard' => {
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					'year' => {
						'one' => q({0} წ),
						'other' => q({0} წ),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					'arc-minute' => {
						'one' => q({0} წთ),
						'other' => q({0} წთ),
					},
					'arc-second' => {
						'one' => q({0} წმ),
						'other' => q({0} წმ),
					},
					'celsius' => {
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'one' => q({0} სმ),
						'other' => q({0} სმ),
					},
					'cubic-kilometer' => {
						'one' => q({0} კმ³),
						'other' => q({0} კმ³),
					},
					'cubic-mile' => {
						'one' => q({0} მილი³),
						'other' => q({0} მილი³),
					},
					'day' => {
						'one' => q({0} დღე),
						'other' => q({0} დღე),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} ფტ),
						'other' => q({0} ფტ),
					},
					'g-force' => {
						'one' => q({0} ინ. ძ.),
						'other' => q({0} ინ. ძ.),
					},
					'gram' => {
						'one' => q({0} გ),
						'other' => q({0} გ),
					},
					'hectare' => {
						'one' => q({0} ჰა),
						'other' => q({0} ჰა),
					},
					'hectopascal' => {
						'one' => q({0} ჰპა),
						'other' => q({0} ჰპა),
					},
					'horsepower' => {
						'one' => q({0} ცხ. ძ.),
						'other' => q({0} ცხ. ძ.),
					},
					'hour' => {
						'one' => q({0} სთ),
						'other' => q({0} სთ),
					},
					'inch' => {
						'one' => q({0} დმ),
						'other' => q({0} დმ),
					},
					'inch-hg' => {
						'one' => q({0} ვრც. დმ.),
						'other' => q({0} ვრც. დმ.),
					},
					'kilogram' => {
						'one' => q({0} კგ),
						'other' => q({0} კგ),
					},
					'kilometer' => {
						'one' => q({0} კმ),
						'other' => q({0} კმ),
					},
					'kilometer-per-hour' => {
						'one' => q({0} კმ/სთ),
						'other' => q({0} კმ/სთ),
					},
					'kilowatt' => {
						'one' => q({0} კვტ),
						'other' => q({0} კვტ),
					},
					'light-year' => {
						'one' => q({0} სწ),
						'other' => q({0} სწ),
					},
					'liter' => {
						'one' => q({0} ლ),
						'other' => q({0}ლ),
					},
					'meter' => {
						'one' => q({0} მ),
						'other' => q({0} მ),
					},
					'meter-per-second' => {
						'one' => q({0} მ/წმ),
						'other' => q({0} მ/წმ),
					},
					'mile' => {
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					'mile-per-hour' => {
						'one' => q({0} მილი/სთ),
						'other' => q({0} მილი/სთ),
					},
					'millibar' => {
						'one' => q({0} მბარი),
						'other' => q({0} მბარი),
					},
					'millimeter' => {
						'one' => q({0} მმ),
						'other' => q({0} მმ),
					},
					'millisecond' => {
						'one' => q({0} მწ),
						'other' => q({0} მწ),
					},
					'minute' => {
						'one' => q({0} წთ),
						'other' => q({0} წთ),
					},
					'month' => {
						'one' => q({0} თვე),
						'other' => q({0} თვე),
					},
					'ounce' => {
						'one' => q({0} უნც),
						'other' => q({0} უნც),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} პმ),
						'other' => q({0} პმ),
					},
					'pound' => {
						'one' => q({0} ფნტ),
						'other' => q({0} ფნტ),
					},
					'second' => {
						'one' => q({0} წმ),
						'other' => q({0} წმ),
					},
					'square-foot' => {
						'one' => q({0} ფტ²),
						'other' => q({0} ფტ²),
					},
					'square-kilometer' => {
						'one' => q({0} კმ²),
						'other' => q({0} კმ²),
					},
					'square-meter' => {
						'one' => q({0} მ²),
						'other' => q({0} მ²),
					},
					'square-mile' => {
						'one' => q({0} მილი²),
						'other' => q({0} მილი²),
					},
					'watt' => {
						'one' => q({0} ვტ),
						'other' => q({0} ვტ),
					},
					'week' => {
						'one' => q({0} კვრ),
						'other' => q({0} კვრ),
					},
					'yard' => {
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					'year' => {
						'one' => q({0} წ),
						'other' => q({0} წ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:კი|კ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:არა|ა|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has traditional_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'geor',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q( ),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(არ არის რიცხვი),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0 ათ'.'',
					'other' => '0 ათ'.'',
				},
				'10000' => {
					'one' => '00 ათ'.'',
					'other' => '00 ათ'.'',
				},
				'100000' => {
					'one' => '000 ათ'.'',
					'other' => '000 ათ'.'',
				},
				'1000000' => {
					'one' => '0 მლნ'.'',
					'other' => '0 მლნ'.'',
				},
				'10000000' => {
					'one' => '00 მლნ'.'',
					'other' => '00 მლნ'.'',
				},
				'100000000' => {
					'one' => '000 მლნ'.'',
					'other' => '000 მლნ'.'',
				},
				'1000000000' => {
					'one' => '0 მლრდ'.'',
					'other' => '0 მლრდ'.'',
				},
				'10000000000' => {
					'one' => '00 მლრდ'.'',
					'other' => '00 მლრდ'.'',
				},
				'100000000000' => {
					'one' => '000 მლრ'.'',
					'other' => '000 მლრ'.'',
				},
				'1000000000000' => {
					'one' => '0 ტრლ'.'',
					'other' => '0 ტრლ'.'',
				},
				'10000000000000' => {
					'one' => '00 ტრლ'.'',
					'other' => '00 ტრლ'.'',
				},
				'100000000000000' => {
					'one' => '000 ტრლ'.'',
					'other' => '000 ტრლ'.'',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ათასი',
					'other' => '0 ათასი',
				},
				'10000' => {
					'one' => '00 ათასი',
					'other' => '00 ათასი',
				},
				'100000' => {
					'one' => '000 ათასი',
					'other' => '000 ათასი',
				},
				'1000000' => {
					'one' => '0 მილიონი',
					'other' => '0 მილიონი',
				},
				'10000000' => {
					'one' => '00 მილიონი',
					'other' => '00 მილიონი',
				},
				'100000000' => {
					'one' => '000 მილიონი',
					'other' => '000 მილიონი',
				},
				'1000000000' => {
					'one' => '0 მილიარდი',
					'other' => '0 მილიარდი',
				},
				'10000000000' => {
					'one' => '00 მილიარდი',
					'other' => '00 მილიარდი',
				},
				'100000000000' => {
					'one' => '000 მილიარდი',
					'other' => '000 მილიარდი',
				},
				'1000000000000' => {
					'one' => '0 ტრილიონი',
					'other' => '0 ტრილიონი',
				},
				'10000000000000' => {
					'one' => '00 ტრილიონი',
					'other' => '00 ტრილიონი',
				},
				'100000000000000' => {
					'one' => '000 ტრილიონი',
					'other' => '000 ტრილიონი',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ათ'.'',
					'other' => '0 ათ'.'',
				},
				'10000' => {
					'one' => '00 ათ'.'',
					'other' => '00 ათ'.'',
				},
				'100000' => {
					'one' => '000 ათ'.'',
					'other' => '000 ათ'.'',
				},
				'1000000' => {
					'one' => '0 მლნ'.'',
					'other' => '0 მლნ'.'',
				},
				'10000000' => {
					'one' => '00 მლნ'.'',
					'other' => '00 მლნ'.'',
				},
				'100000000' => {
					'one' => '000 მლნ'.'',
					'other' => '000 მლნ'.'',
				},
				'1000000000' => {
					'one' => '0 მლრდ'.'',
					'other' => '0 მლრდ'.'',
				},
				'10000000000' => {
					'one' => '00 მლრდ'.'',
					'other' => '00 მლრდ'.'',
				},
				'100000000000' => {
					'one' => '000 მლრ'.'',
					'other' => '000 მლრ'.'',
				},
				'1000000000000' => {
					'one' => '0 ტრლ'.'',
					'other' => '0 ტრლ'.'',
				},
				'10000000000000' => {
					'one' => '00 ტრლ'.'',
					'other' => '00 ტრლ'.'',
				},
				'100000000000000' => {
					'one' => '000 ტრლ'.'',
					'other' => '000 ტრლ'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0 %',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '#,##0.00 ¤',
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'negative' => '#,##0.00 ¤',
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(ანდორული პესეტა),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(არაბთა გაერთიანებული საამიროების დირჰამი),
				'one' => q(არაბთა გაერთიანებული საამიროების დირჰამი),
				'other' => q(არაბთა გაერთიანებული საამიროების დირჰამი),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(ავღანი \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(ავღანური ავღანი),
				'one' => q(ავღანური ავღანი),
				'other' => q(ავღანი),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(ალბანური ლეკი),
				'one' => q(ალბანური ლეკი),
				'other' => q(ალბანური ლეკი),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(სომხური დრამი),
				'one' => q(სომხური დრამი),
				'other' => q(სომხური დრამი),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(ნიდერლანდების ანტილების გულდენი),
				'one' => q(ნიდრელანდების ანტილიის გულდენი),
				'other' => q(ნიდრელანდების ანტილიის გულდენი),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(ანგოლური კვანზა),
				'one' => q(ანგოლური კვანზა),
				'other' => q(ანგოლური კვანზა),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(ანგოლური კვანზა \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(ანგოლური ახალი კვანზა \(1990–2000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(ანგოლური მიტოლებული კვანზა \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(არგენტინული აუსტრალი),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(არგენტინული პესო \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(არგენტინული პესო),
				'one' => q(არგენტინული პესო),
				'other' => q(არგენტინული პესო),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ავსტრიული შილინგი),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(ავსტრალიური დოლარი),
				'one' => q(ავსტრალიური დოლარი),
				'other' => q(ავსტრალიური დოლარი),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(არუბანული გულდენი),
				'one' => q(არუბანული გულდენი),
				'other' => q(არუბანული გულდენი),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(აზერბაიჯანული მანათი \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(აზერბაიჯანული მანათი),
				'one' => q(აზერბაიჯანული მანათი),
				'other' => q(აზერბაიჯანული მანათი),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(ბოსნია-ჰერცოგოვინას დინარი),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(ბოსნია და ჰერცოგოვინას კონვერტირებადი მარკა),
				'one' => q(ბოსნია და ჰერცოგოვინას კონვერტირებადი მარკა),
				'other' => q(ბოსნია და ჰერცოგოვინას კონვერტირებადი მარკა),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(ბარბადოსული დოლარი),
				'one' => q(ბარბადოსული დოლარი),
				'other' => q(ბარბადოსული დოლარი),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(ბანგლადეშური ტაკა),
				'one' => q(ბანგლადეშური ტაკა),
				'other' => q(ბანგლადეშური ტაკა),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(ბელგიური ფრანკი \(კოვერტირებადი\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ბელგიური ფრანკი),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(ბელგიური ფრანკი \(ფინანსური\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(ბულგარული მყარი ლევი),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(ბულგარული ლევი),
				'one' => q(ბულგარული ლევი),
				'other' => q(ბულგარული ლევი),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(ბაჰრეინული დინარი),
				'one' => q(ბაჰრეინული დინარი),
				'other' => q(ბაჰრეინული დინარი),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(ბურუნდიული ფრანკი),
				'one' => q(ბურუნდიული ფრანკი),
				'other' => q(ბურუნდიული ფრანკი),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(ბერმუდული დოლარი),
				'one' => q(ბერმუდული დოლარი),
				'other' => q(ბერმუდული დოლარი),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ბრუნეული დოლარი),
				'one' => q(ბრუნეული დოლარი),
				'other' => q(ბრუნეული დოლარი),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(ბოლივიური ბოლივიანო),
				'one' => q(ბოლივიური ბოლივიანო),
				'other' => q(ბოლივიური ბოლივიანო),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(ბოლივიური პესო),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზეირო ნოვო \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზადო),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზეირო \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ბრაზილიური რეალი),
				'one' => q(ბრაზილიური რეალი),
				'other' => q(ბრაზილიური რეალი),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზადო ნოვო),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზეირო),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(ბაჰამური დოლარი),
				'one' => q(ბაჰამური დოლარი),
				'other' => q(ბაჰამური დოლარი),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ბუტანური ნგულტრუმი),
				'one' => q(ბუტანური ნგულტრუმი),
				'other' => q(ბუტანური ნგულტრუმი),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(ბოცვანური პულა),
				'one' => q(ბოცვანური პულა),
				'other' => q(ბოცვანური პულა),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(ახალი ბელარუსიული რუბლი \(1994–1999\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(ბელორუსული რუბლი),
				'one' => q(ბელორუსული რუბლი),
				'other' => q(ბელორუსული რუბლი),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(ბელიზის დოლარი),
				'one' => q(ბელიზის დოლარი),
				'other' => q(ბელიზის დოლარი),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(კანადური დოლარი),
				'one' => q(კანადური დოლარი),
				'other' => q(კანადური დოლარი),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(კონგოს ფრანკი),
				'one' => q(კონგოს ფრანკი),
				'other' => q(კონგოს ფრანკი),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(შვეიცარიული ფრანკი),
				'one' => q(შვეიცარიული ფრანკი),
				'other' => q(შვეიცარიული ფრანკი),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ჩილეს პესო),
				'one' => q(ჩილეს პესო),
				'other' => q(ჩილიური პესო),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(ჩინური იუანი),
				'one' => q(ჩინური უანი),
				'other' => q(ჩინური უანი),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(კოლუმბიური პესო),
				'one' => q(კოლუმბიური პესო),
				'other' => q(კოლუმბიური პესო),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(კოსტა-რიკული კოლონი),
				'one' => q(კოსტა-რიკული კოლონი),
				'other' => q(კოსტა რიკული კოლონი),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(ძველი სერბიული დინარი),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(ჩეხოსლოვაკიის მყარი კრონა),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(კუბური კონვერტირებადი პესო),
				'one' => q(კუბური კონვერტირებადი პესო),
				'other' => q(კუბური კონვერტირებადი პესო),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(კუბური პესო),
				'one' => q(კუბური პესო),
				'other' => q(კუბური პესო),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(კაბო-ვერდეს ესკუდო),
				'one' => q(კაბო-ვერდეს ესკუდო),
				'other' => q(კაბო-ვერდეს ესკუდო),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(კვიპროსის გირვანქა),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(ჩეხური კრონა),
				'one' => q(ჩეხური კრონა),
				'other' => q(ჩეხური კრონა),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(აღმოსავლეთ გერმანული მარკა),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(გერმანული მარკა),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(ჯიბუტის ფრანკი),
				'one' => q(ჯიბუტის ფრანკი),
				'other' => q(ჯიბუტის ფრანკი),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(დანიური კრონა),
				'one' => q(დანიური კრონა),
				'other' => q(დანიური კრონა),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(დომინიკური პესო),
				'one' => q(დომინიკური პესო),
				'other' => q(დომინიკური პესო),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(ალჟირული დინარი),
				'one' => q(ალჟირული დინარი),
				'other' => q(ალჟირული დინარი),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ესტონური კრუნა),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ეგვიპტური გირვანქა),
				'one' => q(ეგვიპტური გირვანქა),
				'other' => q(ეგვიპტური გირვანქა),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ერიტრეის ნაკფა),
				'one' => q(ერიტრეის ნაკფა),
				'other' => q(ერიტრეის ნაკფა),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(ესპანური პესეტა),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ეთიოპიური ბირი),
				'one' => q(ეთიოპიური ბირი),
				'other' => q(ეთიოპიური ბირი),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ევრო),
				'one' => q(ევრო),
				'other' => q(ევრო),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(ფინური მარკა),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ფიჯის დოლარი),
				'one' => q(ფიჯის დოლარი),
				'other' => q(ფიჯის დოლარი),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ფოლკლენდის კუნძულების ფუნტი),
				'one' => q(ფოლკლენდის კუნძულების ფუნტი),
				'other' => q(ფოლკლენდის კუნძულების ფუნტი),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ფრანგული ფრანკი),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ბრიტანული გირვანქა სტერლინგი),
				'one' => q(ბრიტანული გირვანქა სტერლინგი),
				'other' => q(ინგლისური გირვანქა სტერლინგი),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(ქართული კუპონი ლარით),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(ქართული ლარი),
				'one' => q(ქართული ლარი),
				'other' => q(ქართული ლარი),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(განური სედი),
				'one' => q(განური სედი),
				'other' => q(განური სედი),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(გიბრალტარული ფუნტი),
				'one' => q(გიბრალტარული ფუნტი),
				'other' => q(გიბრალტარული ფუნტი),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(გამბიური დალასი),
				'one' => q(გამბიური დალასი),
				'other' => q(გამბიური დალასი),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(გვინეური ფრანკი),
				'one' => q(გვინეური ფრანკი),
				'other' => q(გვინეური ფრანკი),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(ბერძნული დრაჰმა),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(გვატემალური კეტსალი),
				'one' => q(გვატემალური კეტსალი),
				'other' => q(გვატემალური კეტსალი),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(პორტუგალიური გინეა ესკუდო),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(გაიანური დოლარი),
				'one' => q(გაიანური დოლარი),
				'other' => q(გაიანური დოლარი),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(ჰონკონგის დოლარი),
				'one' => q(ჰონკონგის დოლარი),
				'other' => q(ჰონგ კონგის დოლარი),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ჰონდურასული ლემპირა),
				'one' => q(ჰონდურასული ლემპირა),
				'other' => q(ჰონდურასული ლემპირა),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ხორვატიული დინარი),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ხორვატული კუნა),
				'one' => q(ხორვატული კუნა),
				'other' => q(ხორვატული კუნა),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ჰაიტური გურდი),
				'one' => q(ჰაიტური გურდი),
				'other' => q(ჰაიტური გურდი),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(უნგრული ფორინტი),
				'one' => q(უნგრული ფორინტი),
				'other' => q(უნგრული ფორინტი),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ინდონეზიური რუპია),
				'one' => q(ინდონეზიური რუპია),
				'other' => q(ინდონეზიური რუპია),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ირლანდიური გირვანქა),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(ისრაელის ახალი შეკელი),
				'one' => q(ისრაელის ახალი შეკელი),
				'other' => q(ისრაელის ახალი შეკელი),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(ინდური რუპია),
				'one' => q(ინდური რუპია),
				'other' => q(ინდური რუპია),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ერაყული დინარი),
				'one' => q(ერაყული დინარი),
				'other' => q(ერაყული დინარი),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ირანული რიალი),
				'one' => q(ირანული რიალი),
				'other' => q(ირანული რიალი),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ისლანდიური კრონა),
				'one' => q(ისლანდიური კრონა),
				'other' => q(ისლანდიური კრონა),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(იტალიური ლირა),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(იამაიკური დოლარი),
				'one' => q(იამაიკური დოლარი),
				'other' => q(იამაიკური დოლარი),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(იორდანიული დოლარი),
				'one' => q(იორდანიული დოლარი),
				'other' => q(იორდანიული დოლარი),
			},
		},
		'JPY' => {
			symbol => 'JPY',
			display_name => {
				'currency' => q(იაპონური იენი),
				'one' => q(იაპონური იენი),
				'other' => q(იაპონური იენი),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(კენიური შილინგი),
				'one' => q(კენიური შილინგი),
				'other' => q(კენიური შილინგი),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(ყირგიზული სომი),
				'one' => q(ყირგიზული სომი),
				'other' => q(ყირგიზული სომი),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(კამბოჯური რიელი),
				'one' => q(კამბოჯური რიელი),
				'other' => q(კამბოჯური რიელი),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(კომორული ფრანკი),
				'one' => q(კომორული ფრანკი),
				'other' => q(კომორული ფრანკი),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(ჩრდილოეთ კორეული ვონი),
				'one' => q(ჩრდილოეთ კორეული ვონი),
				'other' => q(ჩრდილოეთ კორეული ვონი),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(სამხრეთ კორეული ვონი),
				'one' => q(სამხრეთ კორეული ვონი),
				'other' => q(სამხრეთ კორეული ვონი),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(ქუვეითური დინარი),
				'one' => q(ქუვეითური დინარი),
				'other' => q(ქუვეითური დინარი),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(კაიმანის კუნძულების დოლარი),
				'one' => q(კაიმანის კუნძულების დოლარი),
				'other' => q(კაიმანის კუნძულების დოლარი),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(ყაზახური ტენგე),
				'one' => q(ყაზახური ტენგე),
				'other' => q(ყაზახური ტენგე),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(ლაოსური კიპი),
				'one' => q(ლაოსური კიპი),
				'other' => q(ლაოსური კიპი),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ლიბანური ფუნტი),
				'one' => q(ლიბანური ფუნტი),
				'other' => q(ლიბანური ფუნტი),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(შრი-ლანკური რუპია),
				'one' => q(შრი-ლანკური რუპია),
				'other' => q(შრი ლანკას რუპია),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ლიბერიული დოლარი),
				'one' => q(ლიბერიული დოლარი),
				'other' => q(ლიბერიული დოლარი),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(ლიტვური ლიტა),
				'one' => q(ლიტვური ლიტა),
				'other' => q(ლიტვური ლიტა),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(ლიტვური ტალონი),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(ლუქსემბურგის კონვერტირებადი ფრანკი),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(ლუქსემბურგის ფრანკი),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(ლუქსემბურგის ფინანსური ფრანკი),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ლატვიური ლატი),
				'one' => q(ლატვიური ლატი),
				'other' => q(ლატვიური ლატი),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(ლატვიური რუბლი),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ლიბიური დინარი),
				'one' => q(ლიბიური დინარი),
				'other' => q(ლიბიური დინარი),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(მაროკოს დირჰამი),
				'one' => q(მაროკოს დირჰამი),
				'other' => q(მაროკოს დირჰამი),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(მაროკოს ფრანკი),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(მოლდოვური ლეუ),
				'one' => q(მოლდოვური ლეუ),
				'other' => q(მოლდოვური ლეუ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(მადაგასკარის არიარი),
				'one' => q(მადაგასკარის არიარი),
				'other' => q(მადაგასკარის არიარი),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(მადაგასკარის ფრანკი),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(მაკედონიური დინარი),
				'one' => q(მაკედონიური დინარი),
				'other' => q(მაკედონიური დინარი),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(მალის ფრანკი),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(მიანმარის კიატი),
				'one' => q(მიანმარის კიატი),
				'other' => q(მიანმარის კიატი),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(მონღოლური ტუგრიკი),
				'one' => q(მონღოლური ტუგრიკი),
				'other' => q(მონღოლური ტუგრიკი),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(მაკაუს პატაკა),
				'one' => q(მაკაუს პატაკა),
				'other' => q(მაკაუს პატაკა),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(მავრიტანული უგია),
				'one' => q(მავრიტანული უგია),
				'other' => q(მავრიტანული უგია),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(მალტის ლირა),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(მალტის გირვანქა),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(მავრიტანული რუპია),
				'one' => q(მავრიტანული რუპია),
				'other' => q(მავრიტანული რუპია),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(მალდივური რუფია),
				'one' => q(მალდივური რუფია),
				'other' => q(მალდივური რუფია),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(მალავიური კვაჩა),
				'one' => q(მალავიური კვაჩა),
				'other' => q(მალავიური კვაჩა),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(მექსიკური პესო),
				'one' => q(მექსიკური პესო),
				'other' => q(მექსიკური პესო),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(მექსიკური ვერცხლის პესო \(1861–1992\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(მალაიზიური რინგიტი),
				'one' => q(მალაიზიური რინგიტი),
				'other' => q(მალაიზიური რინგიტი),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(მოზამბიკური ესკუდო),
				'one' => q(მოზამბიკური ესკუდო),
				'other' => q(მოზამბიკური ესკუდო),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(ძველი მოზამბიკური მეტიკალი),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(მოზამბიკური მეტიკალი),
				'one' => q(მოზამბიკური მეტიკალი),
				'other' => q(მოზამბიკური მეტიკალი),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(ნამიბიური დოლარი),
				'one' => q(ნამიბიური დოლარი),
				'other' => q(ნამიბიური დოლარი),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(ნიგერიული ნაირა),
				'one' => q(ნიგერიული ნაირა),
				'other' => q(ნიგერიული ნაირა),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(ნიკარაგუას კორდობა),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(ნიკარაგუული კორდობა),
				'one' => q(ნიკარაგუას ოქროს კორდობა),
				'other' => q(ნიკარაგუას ოქროს კორდობა),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(ჰოლანდიური გულდენი),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(ნორვეგიული კრონა),
				'one' => q(ნორვეგიული კრონა),
				'other' => q(ნორვეგიული კრონა),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(ნეპალური რუპია),
				'one' => q(ნეპალური რუპია),
				'other' => q(ნეპალური რუპია),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(ახალი ზელანდიის დოლარი),
				'one' => q(ახალი ზელანდიის დოლარი),
				'other' => q(ახალი ზელანდიის დოლარი),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ომანის რიალი),
				'one' => q(ომანის რიალი),
				'other' => q(ომანის რიალი),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(პანამური ბალბოა),
				'one' => q(პანამური ბალბოა),
				'other' => q(პანამური ბალბოა),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(პერუს ინტი),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(პერუს ახალი სოლი),
				'one' => q(პერუს ახალი სოლი),
				'other' => q(პერუს ახალი სოლი),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(პერუს სოლი),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(პაპუა-ახალი გვინეის კინა),
				'one' => q(პაპუა-ახალი გვინეის კინა),
				'other' => q(პაპუა-ახალი გვინეის კინა),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(ფილიპინური პესო),
				'one' => q(ფილიპინური პესო),
				'other' => q(ფილიპინური პესო),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(პაკისტანური რუპია),
				'one' => q(პაკისტანური რუპია),
				'other' => q(პაკისტანური რუპია),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(პოლონური ზლოტი),
				'one' => q(პოლონური ზლოტი),
				'other' => q(პოლონური ზლოტი),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(პოლონური ზლოტი \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(პორტუგალიური ესკუდო),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(პარაგვაული გუარანი),
				'one' => q(პარაგვაული გუარანი),
				'other' => q(პარაგვაული გუარანი),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(კატარის რიალი),
				'one' => q(კატარის რიალი),
				'other' => q(კატარის რიალი),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(როდეზიული დოლარი),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(ძველი რუმინული ლეუ),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(რუმინული ლეუ),
				'one' => q(რუმინული ლეუ),
				'other' => q(რუმინული ლეუ),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(სერბული დინარი),
				'one' => q(სერბული დინარი),
				'other' => q(სერბული დინარი),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(რუსული რუბლი),
				'one' => q(რუსული რუბლი),
				'other' => q(რუსული რუბლი),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(რუსული რუბლი \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(რუანდული ფრანკი),
				'one' => q(რუანდული ფრანკი),
				'other' => q(რუანდული ფრანკი),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(საუდის არაბეთის რიალი),
				'one' => q(საუდის არაბეთის რიალი),
				'other' => q(საუდის არაბეთის რიალი),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(სოლომონის კუნძულების დოლარი),
				'one' => q(სოლომონის კუნძულების დოლარი),
				'other' => q(სოლომონის კუნძულების დოლარი),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(სეიშელური რუპია),
				'one' => q(სეიშელური რუპია),
				'other' => q(სეიშელური რუპია),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(სუდანის დინარი),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(სუდანური ფუნტი),
				'one' => q(სუდანური ფუნტი),
				'other' => q(სუდანური ფუნტი),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(სუდანის გირვანქა),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(შვედური კრონა),
				'one' => q(შვედური კრონა),
				'other' => q(შვედური კრონა),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(სინგაპურის დოლარი),
				'one' => q(სინგაპურის დოლარი),
				'other' => q(სინგაპურის დოლარი),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(წმ. ელენეს კუნძულის ფუნტი),
				'one' => q(წმ. ელენეს კუნძულის ფუნტი),
				'other' => q(წმ. ელენეს კუნძულის ფუნტი),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(სიერა-ლეონეს ლეონე),
				'one' => q(სიერა-ლეონეს ლეონე),
				'other' => q(სიერა-ლეონეს ლეონე),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(სომალური შილინგი),
				'one' => q(სომალური შილინგი),
				'other' => q(სომალური შილინგი),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(სურინამული დოლარი),
				'one' => q(სურინამული დოლარი),
				'other' => q(სურინამული დოლარი),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(სურინამის გულდენი),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(სამხრეთ სუდანური ფუნტი),
				'one' => q(სამხრეთ სუდანური ფუნტი),
				'other' => q(სამხრეთ სუდანური ფუნტი),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(სან-ტომე და პრინსიპის დობრა),
				'one' => q(სან-ტომე და პრინსიპის დობრა),
				'other' => q(სან-ტომე და პრინსიპის დობრა),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(საბჭოთა რუბლი),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(სირიული ფუნტი),
				'one' => q(სირიული გირვანქა),
				'other' => q(სირიული გირვანქა),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(სვაზილენდის ლილანგენი),
				'one' => q(სვაზილენდის ლილანგენი),
				'other' => q(სვაზილენდის ლილანგენი),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(ტაილანდური ბატი),
				'one' => q(ტაილანდური ბატი),
				'other' => q(ტაილანდური ბატი),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(ტაჯიკური რუბლი),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ტაჯიკური სომონი),
				'one' => q(ტაჯიკური სომონი),
				'other' => q(ტაჯიკური სომონი),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(თურქმენული მანათი),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(თურქმენეთის მანათი),
				'one' => q(თურქმენეთის მანათი),
				'other' => q(თურქმენეთის მანათი),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ტუნისური დინარი),
				'one' => q(ტუნისის დინარი),
				'other' => q(ტუნისის დინარი),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ტონგანური პაანგა),
				'one' => q(ტონგანური პაანგა),
				'other' => q(ტონგანური პაანგა),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(თურქული ლირა),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ახალი თურქული ლირა),
				'one' => q(ახალი თურქული ლირა),
				'other' => q(ახალი თურქული ლირა),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ტრინიდად და ტობაგოს დოლარი),
				'one' => q(ტრინიდად და ტობაგოს დოლარი),
				'other' => q(ტრინიდად და ტობაგოს დოლარი),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(ტაივანური ახალი დოლარი),
				'one' => q(ტაივანური ახალი დოლარი),
				'other' => q(ტაივანური ახალი დოლარი),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ტანზანიური შილინგი),
				'one' => q(ტანზანიური შილინგი),
				'other' => q(ტანზანიური შილინგი),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(უკრაინული გრივნა),
				'one' => q(უკრაინული გრივნა),
				'other' => q(უკრაინული გრივნა),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(უკრაინული კარბოვანეცი),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(უგანდური შილინგი \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(უგანდური შილინგი),
				'one' => q(უგანდური შილინგი),
				'other' => q(უგანდური შილინგი),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(აშშ დოლარი),
				'one' => q(აშშ დოლარი),
				'other' => q(აშშ დოლარი),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(აშშ დოლარი \(შემდეგი დღე\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(აშშ დოლარი \(იგივე დღე\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ურუგვაის პესო \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ურუგვაის პესო),
				'one' => q(ურუგვაის პესო),
				'other' => q(ურუგვაის პესო),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(უზბეკური სუმი),
				'one' => q(უზბეკური სუმი),
				'other' => q(უზბეკური სუმი),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(ვენესუელის ბოლივარი \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(ვენესუელის ბოლივარი),
				'one' => q(ვენესუელის ბოლივარი),
				'other' => q(ვენესუელის ბოლივარი),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(ვიეტნამური დონგი),
				'one' => q(ვიეტნამური დონგი),
				'other' => q(ვიეტნამური დონგი),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(ვანუატუს ვატუ),
				'one' => q(ვანატუს ვატუ),
				'other' => q(ვანატუს ვატუ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(სამოური ტალა),
				'one' => q(დასავლეთ სამოას ტალა),
				'other' => q(დასავლეთ სამოას ტალა),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(CFA ფრანკი \(BEAC\)),
				'one' => q(CFA ფრანკი \(BEAC\)),
				'other' => q(CFA ფრანკი \(BEAC\)),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(ვერცხლი),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(ევროპული კომპპოზიტური ერთეული),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ევროპული ფულადი ერთეული),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(აღმოსავლეთ კარიბიული დოლარი),
				'one' => q(აღმოსავლეთ კარიბიული დოლარი),
				'other' => q(აღმოსავლეთ კარიბიული დოლარი),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(ევროპული სავალუტო ერთეული),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ფრანგული ოქროს ფრანკი),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(\(CFA\) ფრანკი \(BCEAO\)),
				'one' => q(CFA ფრანკი \(BCEAO\)),
				'other' => q(CFA ფრანკი \(BCEAO\)),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP ფრანკი),
				'one' => q(CFP ფრანკი),
				'other' => q(CFP ფრანკი),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(უცნობი ვალუტა),
				'one' => q(\(ვალუტის უცნობი ერთეული\)),
				'other' => q(უცნობი ვალუტა),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(იემენის დინარი),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(იემენის რეალი),
				'one' => q(იემენის რეალი),
				'other' => q(იემენის რეალი),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(იუგოსლავიური მყარი დინარი),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(იუგოსლავიური ახალი დინარი),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(იუგოსლავიური კონვერტირებადი დინარი),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(სამხრეთ აფრიკული რანდი),
				'one' => q(სამხრეთ აფრიკული რანდი),
				'other' => q(სამხრეთ აფრიკული რანდი),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ზამბიური კვაჩა \(1968–2012\)),
				'one' => q(ზამბიური კვაჭა \(1968–2012\)),
				'other' => q(ზამბიური კვაჭა \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ზამბიური კვაჭა),
				'one' => q(ზამბიური კვაჭა),
				'other' => q(ზამბიური კვაჭა),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(ზაირის ახალი ზაირი),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(ზაირის ზაირი),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ზიმბაბვეს დოლარი),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'იან',
							'თებ',
							'მარ',
							'აპრ',
							'მაი',
							'ივნ',
							'ივლ',
							'აგვ',
							'სექ',
							'ოქტ',
							'ნოე',
							'დეკ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ი',
							'თ',
							'მ',
							'ა',
							'მ',
							'ი',
							'ი',
							'ა',
							'ს',
							'ო',
							'ნ',
							'დ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'იანვარი',
							'თებერვალი',
							'მარტი',
							'აპრილი',
							'მაისი',
							'ივნისი',
							'ივლისი',
							'აგვისტო',
							'სექტემბერი',
							'ოქტომბერი',
							'ნოემბერი',
							'დეკემბერი'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'იან',
							'თებ',
							'მარ',
							'აპრ',
							'მაი',
							'ივნ',
							'ივლ',
							'აგვ',
							'სექ',
							'ოქტ',
							'ნოე',
							'დეკ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ი',
							'თ',
							'მ',
							'ა',
							'მ',
							'ი',
							'ი',
							'ა',
							'ს',
							'ო',
							'ნ',
							'დ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'იანვარი',
							'თებერვალი',
							'მარტი',
							'აპრილი',
							'მაისი',
							'ივნისი',
							'ივლისი',
							'აგვისტო',
							'სექტემბერი',
							'ოქტომბერი',
							'ნოემბერი',
							'დეკემბერი'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'თიშრეი',
							'ხეშვანი',
							'ქისლევი',
							'ტევეთი',
							'შვატი',
							'ადარი I',
							'ადარი',
							'ნისანი',
							'იარი',
							'სივანი',
							'თამუზი',
							'ავი',
							'ელული'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ადარი II'
						],
					},
					wide => {
						nonleap => [
							'თიშრეი',
							'ხეშვანი',
							'ქისლევი',
							'ტევეთი',
							'შვატი',
							'ადარი I',
							'ადარი',
							'ნისანი',
							'იარი',
							'სივანი',
							'თამუზი',
							'ავი',
							'ელული'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ადარი II'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'თიშრეი',
							'ხეშვანი',
							'ქისლევი',
							'ტევეთი',
							'შვატი',
							'ადარი I',
							'ადარი',
							'ნისანი',
							'იარი',
							'სივანი',
							'თამუზი',
							'ავი',
							'ელული'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ადარი II'
						],
					},
					wide => {
						nonleap => [
							'თიშრეი',
							'ხეშვანი',
							'ქისლევი',
							'ტევეთი',
							'შვატი',
							'ადარი I',
							'ადარი',
							'ნისანი',
							'იარი',
							'სივანი',
							'თამუზი',
							'ავი',
							'ელული'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ადარი II'
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'მუჰ.',
							'საფ.',
							'რაბ. I',
							'რაბ. II',
							'ჯუმ. I',
							'ჯუმ. II',
							'რაჯ.',
							'შაბ.',
							'რამ.',
							'შავ.',
							'ზულ-კ.',
							'ზულ-ჰ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'მუჰარამი',
							'საფარი',
							'რაბი ულ-ავალი',
							'რაბი ულ-ახირი',
							'ჯუმადა ულ-ავალი',
							'ჯუმადა ულ-ახირი',
							'რაჯაბი',
							'შაბანი',
							'რამადანი',
							'შავალი',
							'ზულ-კაადა',
							'ზულ-ჰიჯა'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'მუჰ.',
							'საფ.',
							'რაბ. I',
							'რაბ. II',
							'ჯუმ. I',
							'ჯუმ. II',
							'რაჯ.',
							'შაბ.',
							'რამ.',
							'შავ.',
							'ზულ-კ.',
							'ზულ-ჰ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'მუჰარამი',
							'საფარი',
							'რაბი ულ-ავალი',
							'რაბი ულ-ახირი',
							'ჯუმადა ულ-ავალი',
							'ჯუმადა ულ-ახირი',
							'რაჯაბი',
							'შაბანი',
							'რამადანი',
							'შავალი',
							'ზულ-კაადა',
							'ზულ-ჰიჯა'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ფარვარდინი',
							'ორდიბეჰეშთი',
							'ხორდადი',
							'თირი',
							'მორდადი',
							'შაჰრივარი',
							'მეჰრი',
							'აბანი',
							'აზარი',
							'დეი',
							'ბაჰმანი',
							'ესფანდი'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ფარვარდინი',
							'ორდიბეჰეშთი',
							'ხორდადი',
							'თირი',
							'მორდადი',
							'შაჰრივარი',
							'მეჰრი',
							'აბანი',
							'აზარი',
							'დეი',
							'ბაჰმანი',
							'ესფანდი'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ფარვარდინი',
							'ორდიბეჰეშთი',
							'ხორდადი',
							'თირი',
							'მორდადი',
							'შაჰრივარი',
							'მეჰრი',
							'აბანი',
							'აზარი',
							'დეი',
							'ბაჰმანი',
							'ესფანდი'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ფარვარდინი',
							'ორდიბეჰეშთი',
							'ხორდადი',
							'თირი',
							'მორდადი',
							'შაჰრივარი',
							'მეჰრი',
							'აბანი',
							'აზარი',
							'დეი',
							'ბაჰმანი',
							'ესფანდი'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ორშ',
						tue => 'სამ',
						wed => 'ოთხ',
						thu => 'ხუთ',
						fri => 'პარ',
						sat => 'შაბ',
						sun => 'კვი'
					},
					narrow => {
						mon => 'ო',
						tue => 'ს',
						wed => 'ო',
						thu => 'ხ',
						fri => 'პ',
						sat => 'შ',
						sun => 'კ'
					},
					short => {
						mon => 'ორ',
						tue => 'სმ',
						wed => 'ოთ',
						thu => 'ხთ',
						fri => 'პრ',
						sat => 'შბ',
						sun => 'კვ'
					},
					wide => {
						mon => 'ორშაბათი',
						tue => 'სამშაბათი',
						wed => 'ოთხშაბათი',
						thu => 'ხუთშაბათი',
						fri => 'პარასკევი',
						sat => 'შაბათი',
						sun => 'კვირა'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ორშ',
						tue => 'სამ',
						wed => 'ოთხ',
						thu => 'ხუთ',
						fri => 'პარ',
						sat => 'შაბ',
						sun => 'კვი'
					},
					narrow => {
						mon => 'ო',
						tue => 'ს',
						wed => 'ო',
						thu => 'ხ',
						fri => 'პ',
						sat => 'შ',
						sun => 'კ'
					},
					short => {
						mon => 'ორ',
						tue => 'სმ',
						wed => 'ოთ',
						thu => 'ხთ',
						fri => 'პრ',
						sat => 'შბ',
						sun => 'კვ'
					},
					wide => {
						mon => 'ორშაბათი',
						tue => 'სამშაბათი',
						wed => 'ოთხშაბათი',
						thu => 'ხუთშაბათი',
						fri => 'პარასკევი',
						sat => 'შაბათი',
						sun => 'კვირა'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'I კვ.',
						1 => 'II კვ.',
						2 => 'III კვ.',
						3 => 'IV კვ.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'I კვარტალი',
						1 => 'II კვარტალი',
						2 => 'III კვარტალი',
						3 => 'IV კვარტალი'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'I კვ.',
						1 => 'II კვ.',
						2 => 'III კვ.',
						3 => 'IV კვ.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'I კვარტალი',
						1 => 'II კვარტალი',
						2 => 'III კვარტალი',
						3 => 'IV კვარტალი'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'noon' => q{შუადღე},
					'pm' => q{PM},
					'am' => q{AM},
				},
				'narrow' => {
					'pm' => q{PM},
					'am' => q{AM},
					'noon' => q{შუადღე},
				},
				'wide' => {
					'pm' => q{საღამოს},
					'am' => q{დილის},
					'noon' => q{შუადღე},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ძვ. წ.',
				'1' => 'ახ. წ.'
			},
			wide => {
				'0' => 'ძველი წელთაღრიცხვით',
				'1' => 'ახალი წელთაღრიცხვით'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, dd MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{dd.MM.y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{dd.MM.yy},
		},
		'hebrew' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM, y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d.M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMd => q{d MMM},
			Md => q{d.M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M.y G},
			yyyyMEd => q{E, d.M.y G},
			yyyyMMM => q{MMM, y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d.M.y G},
			yyyyQQQ => q{QQQ, y G},
			yyyyQQQQ => q{QQQQ, y G},
		},
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM, y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d.M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMd => q{d MMM},
			Md => q{d.M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M.y},
			yMEd => q{E, d.M.y},
			yMMM => q{MMM, y},
			yMMMEd => q{E, d MMM, y},
			yMMMd => q{d MMM, y},
			yMd => q{d.M.y},
			yQQQ => q{QQQ, y},
			yQQQQ => q{QQQQ, y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM. - E, dd.MM.},
				d => q{E, dd.MM. - E, dd.MM.},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, d MMM - E, d MMM},
				d => q{E, d - E, d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d-d MMM},
			},
			Md => {
				M => q{dd.MM. - dd.MM.},
				d => q{dd.MM. - dd.MM.},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{MM.y - MM.y G},
				y => q{MM.y - MM.y G},
			},
			yMEd => {
				M => q{E, dd.MM.y - E, dd.MM.y G},
				d => q{E, dd.MM.y - E, dd.MM.y G},
				y => q{E, dd.MM.y - E, dd.MM.y G},
			},
			yMMM => {
				M => q{MMM-MMM y G},
				y => q{MMM y - MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM - E, d MMM, y G},
				d => q{E, d - E, d MMM y G},
				y => q{E, d MMM, y - E, d MMM, y G},
			},
			yMMMM => {
				M => q{MM - MM.y G},
				y => q{MM.y - MM.y G},
			},
			yMMMd => {
				M => q{dd MM - dd MM, y},
				d => q{d – d MMM, y},
				y => q{dd MMM, y - d MMM, y},
			},
			yMd => {
				M => q{dd.MM.y - dd.MM.y G},
				d => q{dd.MM.y - dd.MM.y G},
				y => q{dd.MM.y - dd.MM.y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM. - E, dd.MM.},
				d => q{E, dd.MM. - E, dd.MM.},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, d MMM - E, d MMM},
				d => q{E, d - E, d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d-d MMM},
			},
			Md => {
				M => q{dd.MM. - dd.MM.},
				d => q{dd.MM. - dd.MM.},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM.y - MM.y},
				y => q{MM.y - MM.y},
			},
			yMEd => {
				M => q{E, dd.MM.y - E, dd.MM.y},
				d => q{E, dd.MM.y - E, dd.MM.y},
				y => q{E, dd.MM.y - E, dd.MM.y},
			},
			yMMM => {
				M => q{MMM-MMM y},
				y => q{MMM y - MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM - E, d MMM, y},
				d => q{E, d MMM - E, d MMM, y},
				y => q{E, d MMM, y - E, d MMM, y},
			},
			yMMMM => {
				M => q{MM - MM.y},
				y => q{MM.y - MM.y},
			},
			yMMMd => {
				M => q{dd MM - dd MM, y},
				d => q{d-d MMM, y},
				y => q{dd MMM, y - d MMM, y},
			},
			yMd => {
				M => q{dd.MM.y - dd.MM.y},
				d => q{dd.MM.y - dd.MM.y},
				y => q{dd.MM.y - dd.MM.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(დრო: {0}),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(ავღანეთის დრო),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#აბიჯანი#,
		},
		'Africa/Accra' => {
			exemplarCity => q#აკრა#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ადის-აბება#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ალჟირი#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ასმარა#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ბამაკო#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ბანგი#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ბანჯული#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ბისაუ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ბლანტირი#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ბრაზავილი#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ბუჯუმბურა#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#კაირო#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#კასაბლანკა#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#სეუტა#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#კონაკრი#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#დაკარი#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#დარ-ეს-სალამი#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ჯიბუტი#,
		},
		'Africa/Douala' => {
			exemplarCity => q#დუალა#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ელ-ააიუნი#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ფრიტაუნი#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#გაბორონე#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ჰარარე#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#იოჰანესბურგი#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ჯუბა#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#კამპალა#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ხარტუმი#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#კიგალი#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#კინშასა#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ლაგოსი#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ლიბრევილი#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ლომე#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ლუანდა#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ლუბუმბაში#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ლუსაკა#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#მალაბო#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#მაპუტო#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#მასერუ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#მბაბანე#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#მოგადიშუ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#მონროვია#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ნაირობი#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ნჯამენა#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ნიამეი#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ნუაკშოტი#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#უაგადუგუ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#პორტო-ნოვო#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#სენ-ტომე#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ტრიპოლი#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ტუნისი#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ვინდხუკი#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(ცენტრალური აფრიკის დრო),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(აღმოსავლეთ აფრიკის დრო),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(სამხრეთ აფრიკის დრო),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(დასავლეთ აფრიკის ზაფხულის დრო),
				'generic' => q(დასავლეთ აფრიკის დრო),
				'standard' => q(დასავლეთ აფრიკის სტანდარტული დრო),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(ალასკის დროის სარტყელი),
				'generic' => q(ალასკის დრო),
				'standard' => q(ალასკის სტანდარტული დრო),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(ამაზონიის ზაფხულის დრო),
				'generic' => q(ამაზონიის დრო),
				'standard' => q(ამაზონიის სტანდარტული დრო),
			},
		},
		'America/Adak' => {
			exemplarCity => q#ადაკი#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ენქორაჯი#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ანგილა#,
		},
		'America/Antigua' => {
			exemplarCity => q#ანტიგუა#,
		},
		'America/Araguaina' => {
			exemplarCity => q#არაგუაინა#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ლა რიოხა#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#რიო გალეგოსი#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#სალტა#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#სან ხუანი#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#სან-ლუისი#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ტუკუმანი#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#უშუაია#,
		},
		'America/Aruba' => {
			exemplarCity => q#არუბა#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ასუნსიონი#,
		},
		'America/Bahia' => {
			exemplarCity => q#ბაია#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ბაჰია ბანდერასი#,
		},
		'America/Barbados' => {
			exemplarCity => q#ბარბადოსი#,
		},
		'America/Belem' => {
			exemplarCity => q#ბელემი#,
		},
		'America/Belize' => {
			exemplarCity => q#ბელიზი#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ბლან-საბლონი#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ბოა ვისტა#,
		},
		'America/Bogota' => {
			exemplarCity => q#ბოგოტა#,
		},
		'America/Boise' => {
			exemplarCity => q#ბუასი#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ბუენოს-აირესი#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#კემბრიჯ ბეი#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#კამპო გრანდე#,
		},
		'America/Cancun' => {
			exemplarCity => q#კანკუნი#,
		},
		'America/Caracas' => {
			exemplarCity => q#კარაკასი#,
		},
		'America/Catamarca' => {
			exemplarCity => q#კატამარკა#,
		},
		'America/Cayenne' => {
			exemplarCity => q#კაიენა#,
		},
		'America/Cayman' => {
			exemplarCity => q#კაიმანი#,
		},
		'America/Chicago' => {
			exemplarCity => q#ჩიკაგო#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ჩიჰუაჰუა#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ატიკოკანი#,
		},
		'America/Cordoba' => {
			exemplarCity => q#კორდობა#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#კოსტა-რიკა#,
		},
		'America/Creston' => {
			exemplarCity => q#კრესტონი#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#კუიაბა#,
		},
		'America/Curacao' => {
			exemplarCity => q#კიურასაო#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#დენმარკშავნი#,
		},
		'America/Dawson' => {
			exemplarCity => q#დოუსონი#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#დოუსონ ქრიკი#,
		},
		'America/Denver' => {
			exemplarCity => q#დენვერი#,
		},
		'America/Detroit' => {
			exemplarCity => q#დეტროიტი#,
		},
		'America/Dominica' => {
			exemplarCity => q#დომინიკა#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ედმონტონი#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ეირუნეპე#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#სალვადორი#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ფორტალეზა#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#გლეის ბეი#,
		},
		'America/Godthab' => {
			exemplarCity => q#გოდთები#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#გუზ ბეი#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#გრანდ-ტურკი#,
		},
		'America/Grenada' => {
			exemplarCity => q#გრენადა#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#გვადელუპე#,
		},
		'America/Guatemala' => {
			exemplarCity => q#გვატემალა#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#გუაიაკილი#,
		},
		'America/Guyana' => {
			exemplarCity => q#გაიანა#,
		},
		'America/Halifax' => {
			exemplarCity => q#ჰალიფაქსი#,
		},
		'America/Havana' => {
			exemplarCity => q#ჰავანა#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ჰერმოსილო#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ნოქსი, ინდიანა#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#მარენგო, ინდიანა#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#პიტერსბურგი, ინდიანა#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#თელ სითი, ინდიანა#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ვივეი, ინდიანა#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ვინსენი, ინდიანა#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#უინემაკი, ინდიანა#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ინდიანაპოლისი#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ინუვიკი#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#იქალუიტი#,
		},
		'America/Jamaica' => {
			exemplarCity => q#იამაიკა#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ჯუჯუი#,
		},
		'America/Juneau' => {
			exemplarCity => q#ჯუნო#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#მონტიჩელო, კენტუკი#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#კრალენდიიკი#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ლა-პაზი#,
		},
		'America/Lima' => {
			exemplarCity => q#ლიმა#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ლოს-ანჯელესი#,
		},
		'America/Louisville' => {
			exemplarCity => q#ლუისვილი#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ლოერ პრინც კვორტერი#,
		},
		'America/Maceio' => {
			exemplarCity => q#მასეიო#,
		},
		'America/Managua' => {
			exemplarCity => q#მანაგუა#,
		},
		'America/Manaus' => {
			exemplarCity => q#მანაუსი#,
		},
		'America/Marigot' => {
			exemplarCity => q#მარიგო#,
		},
		'America/Martinique' => {
			exemplarCity => q#მარტინიკი#,
		},
		'America/Matamoros' => {
			exemplarCity => q#მატამოროსი#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#მაზატლანი#,
		},
		'America/Mendoza' => {
			exemplarCity => q#მენდოზა#,
		},
		'America/Menominee' => {
			exemplarCity => q#მენომინი#,
		},
		'America/Merida' => {
			exemplarCity => q#მერიდა#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#მეტლაკატლა#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#მეხიკო#,
		},
		'America/Miquelon' => {
			exemplarCity => q#მიკელონი#,
		},
		'America/Moncton' => {
			exemplarCity => q#მონქტონი#,
		},
		'America/Monterrey' => {
			exemplarCity => q#მონტერეი#,
		},
		'America/Montevideo' => {
			exemplarCity => q#მონტევიდეო#,
		},
		'America/Montserrat' => {
			exemplarCity => q#მონსერატი#,
		},
		'America/Nassau' => {
			exemplarCity => q#ნასაუ#,
		},
		'America/New_York' => {
			exemplarCity => q#ნიუ-იორკი#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ნიპიგონი#,
		},
		'America/Nome' => {
			exemplarCity => q#ნომი#,
		},
		'America/Noronha' => {
			exemplarCity => q#ნორონია#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ბიულა, ჩრდილოეთი დაკოტა#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ცენტრი, ჩრდილოეთი დაკოტა#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ნიუ სალემი, ჩრდილოეთი დაკოტა#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ოხინაგა#,
		},
		'America/Panama' => {
			exemplarCity => q#პანამა#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#პანგნირტუნგი#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#პარამარიბო#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ფენიქსი#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#პორტ-ა-პრინსი#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#პორტ-ოვ-სპეინი#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#პორტუ-ველიო#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#პუერტო-რიკო#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#რეინი რივერი#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#რენკინ ინლეტი#,
		},
		'America/Recife' => {
			exemplarCity => q#რეციფე#,
		},
		'America/Regina' => {
			exemplarCity => q#რეჯინა#,
		},
		'America/Resolute' => {
			exemplarCity => q#რეზოლუტე#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#რიო ბრანკო#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#სანტა ისაბელი#,
		},
		'America/Santarem' => {
			exemplarCity => q#სანტარემი#,
		},
		'America/Santiago' => {
			exemplarCity => q#სანტიაგო#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#სანტო-დომინგო#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#სან-პაულუ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#სკორსბისუნდი#,
		},
		'America/Sitka' => {
			exemplarCity => q#სიტკა#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#სენ-ბართელემი#,
		},
		'America/St_Johns' => {
			exemplarCity => q#სენტ ჯონსი#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#სენტ-კიტსი#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#სენტ-ლუსია#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#სენ-ტომასი#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#სენ-ვინსენტი#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#სვიფტ კარენტი#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ტეგუჩიგალპა#,
		},
		'America/Thule' => {
			exemplarCity => q#თულე#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#თანდერ ბეი#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ტიხუანა#,
		},
		'America/Toronto' => {
			exemplarCity => q#ტორონტო#,
		},
		'America/Tortola' => {
			exemplarCity => q#ტორტოლა#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ვანკუვერი#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#უაითჰორსი#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#უინიპეგი#,
		},
		'America/Yakutat' => {
			exemplarCity => q#იაკუტატი#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#იელოუნაიფი#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(ჩრდილოეთ ამერიკის ცენტრალური დროის სარტყელი),
				'generic' => q(ჩრდილოეთ ამერიკის ცენტრალური დრო),
				'standard' => q(ჩრდილოეთ ამერიკის ცენტრალური სტანდარტული დრო),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(ჩრდილოეთ ამერიკის აღმოსავლეთის დროის სარტყელი),
				'generic' => q(ჩრდილოეთ ამერიკის აღმოსავლეთის დრო),
				'standard' => q(ჩრდილოეთ ამერიკის აღმოსავლეთის სტანდარტული დრო),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(ჩრდილოეთ ამერიკის მაუნთინის დროის სარტყელი),
				'generic' => q(ჩრდილოეთ ამერიკის მაუნთინის დრო),
				'standard' => q(ჩრდილოეთ ამერიკის მაუნთინის სტანდარტული დრო),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(ჩრდილოეთ ამერიკის წყნარი ოკეანის დროის სარტყელი),
				'generic' => q(ჩრდილოეთ ამერიკის წყნარი ოკეანის დრო),
				'standard' => q(ჩრდილოეთ ამერიკის წყნარი ოკეანის სტანდარტული დრო),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#კეისი#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#დევისი#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#დიუმონ დ'ურვილი#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#მექვორი#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#მოუსონი#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#მაკმურდო#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#პალმერი#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#როთერა#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#სიოუა#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ვოსტოკი#,
		},
		'Arabian' => {
			long => {
				'daylight' => q(არაბეთის დროის სარტყელი),
				'generic' => q(არაბეთის დრო),
				'standard' => q(არაბეთის სტანდარტული დრო),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ლონგირბიენი#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(არგენტინის ზაფხულის დრო),
				'generic' => q(არგენტინის დრო),
				'standard' => q(არგენტინის სტანდარტული დრო),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(დასავლეთ არგენტინის ზაფხულის დრო),
				'generic' => q(დასავლეთ არგენტინის დრო),
				'standard' => q(დასავლეთ არგენტინის სტანდარტული დრო),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(სომხეთის ზაფხულის დრო),
				'generic' => q(სომხეთის დრო),
				'standard' => q(სომხეთის სტანდარტული დრო),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ადენი#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ალმატი#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ამანი#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ანადირი#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#აქტაუ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#აქტობე#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#აშხაბადი#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ბაღდადი#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ბაჰრეინი#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ბაქო#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ბანგკოკი#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ბეირუთი#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ბიშკეკი#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ბრუნეი#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#კალკუტა#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ჩოიბალსანი#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#ჩონგქინგი#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#კოლომბო#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#დამასკი#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#დაკა#,
		},
		'Asia/Dili' => {
			exemplarCity => q#დილი#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#დუბაი#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#დუშანბე#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#გაზა#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#ჰარბინი#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ჰებრონი#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ჰონკონგი#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ჰოვდი#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ირკუტსკი#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ჯაკარტა#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ჯაიაპურა#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#იერუსალიმი#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ქაბული#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#კამჩატკა#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#კარაჩი#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#კაშგარი#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#კატმანდუ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ხანდიგა#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#კრასნოიარსკი#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#კუალა-ლუმპური#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#კუჩინგი#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ქუვეითი#,
		},
		'Asia/Macau' => {
			exemplarCity => q#მაკაო#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#მაგადანი#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#მაკასარი#,
		},
		'Asia/Manila' => {
			exemplarCity => q#მანილა#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#მუსკატი#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ნიკოსია#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ნოვოკუზნეცკი#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ნოვოსიბირსკი#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ომსკი#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ორალი#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#პნომპენი#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#პონტიანაკი#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ფხენიანი#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#კატარი#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ყიზილორდა#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#რანგუნი#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ერ-რიადი#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ჰოჩიმინი#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#სახალინი#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#სამარყანდი#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#სეული#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#შანხაი#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#სინგაპური#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ტაიპეი#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ტაშკენტი#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#თბილისი#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#თეირანი#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#თხიმფხუ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ტოკიო#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ულანბატარი#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ურუმქი#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#უსტ-ნერა#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ვიენტიანი#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ვლადივოსტოკი#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#იაკუტსკი#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ეკატერინბურგი#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ერევანი#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(ატლანტიკის ოკეანის დროის სარტყელი),
				'generic' => q(ატლანტიკის ოკეანის დრო),
				'standard' => q(ატლანტიკის ოკეანის სტანდარტული დრო),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#აზორის კუნძულები#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ბერმუდი#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#კანარი#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#კაბო-ვერდე#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ფარერის კუნძულები#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#მადეირა#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#რეიკიავიკი#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#სამხრეთ ჯორჯია#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#წმ. ელენეს კუნძული#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#სტენლი#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ადელაიდა#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ბრისბეინი#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ბროუკენ ჰილი#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ქური#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#დარვინი#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ეუკლა#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ჰობარტი#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ლინდმანი#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ლორდ ჰოუი#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#მელბურნი#,
		},
		'Australia/Perth' => {
			exemplarCity => q#პერთი#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#სიდნეი#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ცენტრალური ავსტრალიის დროის სარტყელი),
				'generic' => q(ცენტრალური ავსტრალიის დრო),
				'standard' => q(ავსტრალიის ცენტრალური სტანდარტული დრო),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ცენტრალური და დასავლეთ ავსტრალიის დროის სარტყელი),
				'generic' => q(ცენტრალური და დასავლეთ ავსტრალიის დრო),
				'standard' => q(ცენტრალური და დასავლეთ ავსტრალიის სტანდარტული დრო),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(აღმოსავლეთ ავსტრალიის დროის სარტყელი),
				'generic' => q(აღმოსავლეთ ავსტრალიის დრო),
				'standard' => q(აღმოსავლეთ ავსტრალიის სტანდარტული დრო),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(დასავლეთ ავსტრალიის დროის სარტყელი),
				'generic' => q(დასავლეთ ავსტრალიის დრო),
				'standard' => q(დასავლეთ ავსტრალიის სტანდარტული დრო),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(აზერბაიჯანის ზაფხულის დრო),
				'generic' => q(აზერბაიჯანის დრო),
				'standard' => q(აზერბაიჯანის სტანდარტული დრო),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(აზორის კუნძულების ზაფხულის დრო),
				'generic' => q(აზორის კუნძულების დრო),
				'standard' => q(აზორის კუნძულების სტანდარტული დრო),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(ბანგლადეშის ზაფხულის დრო),
				'generic' => q(ბანგლადეშის დრო),
				'standard' => q(ბანგლადეშის სტანდარტული დრო),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ბუტანის დრო),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(ბოლივიის დრო),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ბრაზილიის ზაფხულის დრო),
				'generic' => q(ბრაზილიის დრო),
				'standard' => q(ბრაზილიის სტანდარტული დრო),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ბრუნეი-დარუსალამის დრო),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(კაბო-ვერდეს ზაფხულის დრო),
				'generic' => q(კაბო-ვერდეს დრო),
				'standard' => q(კაბო-ვერდეს სტანდარტული დრო),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(ჩამოროს დრო),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(ჩატემის დროის სარტყელი),
				'generic' => q(ჩატემის დრო),
				'standard' => q(ჩატემის სტანდარტული დრო),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(ჩილეს ზაფხულის დრო),
				'generic' => q(ჩილეს დრო),
				'standard' => q(ჩილეს სტანდარტული დრო),
			},
		},
		'China' => {
			long => {
				'daylight' => q(ჩინეთის დროის სარტყელი),
				'generic' => q(ჩინეთის დრო),
				'standard' => q(ჩინეთის სტანდარტული დრო),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(ჩოიბალსანის ზაფხულის დრო),
				'generic' => q(ჩოიბალსანის დრო),
				'standard' => q(ჩოიბალსანის სტანდარტული დრო),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(შობის კუნძულის დრო),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(ქოქოსის კუნძულების დრო),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(კოლუმბიის ზაფხულის დრო),
				'generic' => q(კოლუმბიის დრო),
				'standard' => q(კოლუმბიის სტანდარტული დრო),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(კუკის კუნძულების ნახევრად ზაფხულის დრო),
				'generic' => q(კუკის კუნძულების დრო),
				'standard' => q(კუკის კუნძულების სტანდარტული დრო),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(კუბის დროის სარტყელი),
				'generic' => q(კუბის დრო),
				'standard' => q(კუბის სტანდარტული დრო),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(დევისის დრო),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(დუმონ-დურვილის დრო),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(აღმოსავლეთ ტიმორის დრო),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(აღდგომის კუნძულის ზაფხულის დრო),
				'generic' => q(აღდგომის კუნძულის დრო),
				'standard' => q(აღდგომის კუნძულის სტანდარტული დრო),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ეკვადორის დრო),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#უცნობი ქალაქი#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ამსტერდამი#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ანდორა#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ათენი#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ბელგრადი#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ბერლინი#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ბრატისლავა#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ბრიუსელი#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ბუხარესტი#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ბუდაპეშტი#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ბუსინგენი#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#კიშინიოვი#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#კოპენჰაგენი#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#დუბლინი#,
			long => {
				'daylight' => q(ირლანდიის ზაფხულის დრო),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#გიბრალტარი#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#გერნსი#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ჰელსინკი#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#მენის კუნძული#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#სტამბოლი#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ჯერსი#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#კალინინგრადი#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#კიევი#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ლისაბონი#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ლიუბლიანა#,
		},
		'Europe/London' => {
			exemplarCity => q#ლონდონი#,
			long => {
				'daylight' => q(ბრიტანეთის ზაფხულის დრო),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ლუქსემბურგი#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#მადრიდი#,
		},
		'Europe/Malta' => {
			exemplarCity => q#მალტა#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#მარიჰამნი#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#მინსკი#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#მონაკო#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#მოსკოვი#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ოსლო#,
		},
		'Europe/Paris' => {
			exemplarCity => q#პარიზი#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#პოდგორიცა#,
		},
		'Europe/Prague' => {
			exemplarCity => q#პრაღა#,
		},
		'Europe/Riga' => {
			exemplarCity => q#რიგა#,
		},
		'Europe/Rome' => {
			exemplarCity => q#რომი#,
		},
		'Europe/Samara' => {
			exemplarCity => q#სამარა#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#სან-მარინო#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#სარაევო#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#სიმფეროპოლი#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#სკოპიე#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#სოფია#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#სტოკჰოლმი#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ტალინი#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ტირანა#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#უჟგოროდი#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ვადუზი#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ვატიკანი#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ვენა#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ვილნიუსი#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ვოლგოგრადი#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ვარშავა#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ზაგრები#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ზაპოროჟიე#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ციურიხი#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(ცენტრალური ევროპის ზაფხულის დრო),
				'generic' => q(ცენტრალური ევროპის დრო),
				'standard' => q(ცენტრალური ევროპის სტანდარტული დრო),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(აღმოსავლეთ ევროპის ზაფხულის დრო),
				'generic' => q(აღმოსავლეთ ევროპის დრო),
				'standard' => q(აღმოსავლეთ ევროპის სტანდარტული დრო),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(დასავლეთ ევროპის ზაფხულის დრო),
				'generic' => q(დასავლეთ ევროპის დრო),
				'standard' => q(დასავლეთ ევროპის სტანდარტული დრო),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ფოლკლენდის კუნძულების ზაფხულის დრო),
				'generic' => q(ფოლკლენდის კუნძულების დრო),
				'standard' => q(ფოლკლენდის კუნძულების სტანდარტული დრო),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ფიჯის ზაფხულის დრო),
				'generic' => q(ფიჯის დრო),
				'standard' => q(ფიჯის სტანდარტული დრო),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(საფრანგეთის გვიანის დრო),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ფრანგული სამხრეთის და ანტარქტიკის დრო),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(გრინვიჩის საშუალო დრო),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(გალაპაგოსის დრო),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(გამბიერის დრო),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(საქართველოს ზაფხულის დრო),
				'generic' => q(საქართველოს დრო),
				'standard' => q(საქართველოს სტანდარტული დრო),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(გილბერტის კუნძულების დრო),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(აღმოსავლეთ გრენლანდიის ზაფხულის დრო),
				'generic' => q(აღმოსავლეთ გრენლანდიის დრო),
				'standard' => q(აღმოსავლეთ გრენლანდიის სტანდარტული დრო),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(დასავლეთ გრენლანდიის ზაფხულის დრო),
				'generic' => q(დასავლეთ გრენლანდიის დრო),
				'standard' => q(დასავლეთ გრენლანდიის სტანდარტული დრო),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(გალფის დრო),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(გაიანის დრო),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ჰავაის და ალეუტის დროის სარტყელი),
				'generic' => q(ჰავაის და ალეუტის დრო),
				'standard' => q(ჰავაის და ალეუტის სტანდარტული დრო),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ჰონკონგის ზაფხულის დრო),
				'generic' => q(ჰონკონგის დრო),
				'standard' => q(ჰონკონგის სტანდარტული დრო),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ჰოვდის ზაფხულის დრო),
				'generic' => q(ჰოვდის დრო),
				'standard' => q(ჰოვდის სტანდარტული დრო),
			},
		},
		'India' => {
			long => {
				'standard' => q(ინდოეთის დრო),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ანტანანარივუ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ჩაგოსი#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#შობის კუნძული#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ქოქოსი#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#კომორო#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#კერგელენი#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#მაჰე#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#მალდივები#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#მავრიკი#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#მაიოტი#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#რეიუნიონი#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ინდოეთის ოკეანის კუნძულების დრო),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ინდოჩინეთის დრო),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(ცენტრალური ინდონეზიის დრო),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(აღმოსავლეთ ინდონეზიის დრო),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(დასავლეთ ინდონეზიის დრო),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ირანის დროის სარტყელი),
				'generic' => q(ირანის დრო),
				'standard' => q(ირანის სტანდარტული დრო),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ირკუტსკის ზაფხულის დრო),
				'generic' => q(ირკუტსკის დრო),
				'standard' => q(ირკუტსკის სტანდარტული დრო),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ისრაელის დროის სარტყელი),
				'generic' => q(ისრაელის დრო),
				'standard' => q(ისრაელის სტანდარტული დრო),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(იაპონიის დროის სარტყელი),
				'generic' => q(იაპონიის დრო),
				'standard' => q(იაპონიის სტანდარტული დრო),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(აღმოსავლეთ ყაზახეთის დრო),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(დასავლეთ ყაზახეთის დრო),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(კორეის დროის სარტყელი),
				'generic' => q(კორეის დრო),
				'standard' => q(კორეის სტანდარტული დრო),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(კოსრეს დრო),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(კრასნოიარსკის ზაფხულის დრო),
				'generic' => q(კრასნოიარსკის დრო),
				'standard' => q(კრასნოიარსკის სტანდარტული დრო),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(ყირგიზეთის დრო),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(ლაინის კუნძულების დრო),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(ლორდ-ჰაუს დროის სარტყელი),
				'generic' => q(ლორდ-ჰაუს დრო),
				'standard' => q(ლორდ-ჰაუს სტანდარტული დრო),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(მაქკუორის კუნძულის დრო),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(მაგადანის ზაფხულის დრო),
				'generic' => q(მაგადანის დრო),
				'standard' => q(მაგადანის სტანდარტული დრო),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(მალაიზიის დრო),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(მალდივების დრო),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(მარკიზის კუნძულების დრო),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(მარშალის კუნძულების დრო),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(მავრიკის ზაფხულის დრო),
				'generic' => q(მავრიკის დრო),
				'standard' => q(მავრიკის სტანდარტული დრო),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(მოუსონის დრო),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(ულან-ბატორის ზაფხულის დრო),
				'generic' => q(ულან-ბატორის დრო),
				'standard' => q(ულან-ბატორის სტანდარტული დრო),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(მოსკოვის ზაფხულის დრო),
				'generic' => q(მოსკოვის დრო),
				'standard' => q(მოსკოვის სტანდარტული დრო),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(მიანმარის დრო),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(ნაურუს დრო),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(ნეპალის დრო),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(ახალი კალედონიის ზაფხულის დრო),
				'generic' => q(ახალი კალედონიის დრო),
				'standard' => q(ახალი კალედონიის სტანდარტული დრო),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(ახალი ზელანდიის დროის სარტყელი),
				'generic' => q(ახალი ზელანდიის დრო),
				'standard' => q(ახალი ზელანდიის სტანდარტული დრო),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(ნიუფაუნდლენდის დროის სარტყელი),
				'generic' => q(ნიუფაუნდლენდის დრო),
				'standard' => q(ნიუფაუნდლენდის სტანდარტული დრო),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(ნიუეს დრო),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(ნორფოლკის კუნძულის დრო),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ფერნანდო-დე-ნორონიას ზაფხულის დრო),
				'generic' => q(ფერნანდო-დე-ნორონიას დრო),
				'standard' => q(ფერნანდო-დე-ნორონიას სტანდარტული დრო),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(ნოვოსიბირსკის ზაფხულის დრო),
				'generic' => q(ნოვოსიბირსკის დრო),
				'standard' => q(ნოვოსიბირსკის სტანდარტული დრო),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ომსკის ზაფხულის დრო),
				'generic' => q(ომსკის დრო),
				'standard' => q(ომსკის სტანდარტული დრო),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#აპია#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ოკლენდი#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ჩათამი#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ისთერი#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ეფატე#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ენდერბური#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ფაკაოფო#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ფიჯი#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ფუნაფუტი#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#გალაპაგოსი#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#გამბიერი#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#გვადალკანალი#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#გუამი#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ჰონოლულუ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ჯონსტონი#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#კირიტიმატი#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#კოსრაე#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#კვაჯალეინი#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#მახურო#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#მარკეზასი#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#მიდუეი#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ნაურუ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ნიუე#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ნორფოლკი#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ნუმეა#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#პაგო-პაგო#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#პალაუ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#პიტკერნი#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#პონპეი#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#პორტ მორსბი#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#რაროტონგა#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#საიპანი#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ტაიტი#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ტარაუა#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ტონგატაპუ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ჩუუკი#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#უეიკი#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ვალისი#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(პაკისტანის ზაფხულის დრო),
				'generic' => q(პაკისტანის დრო),
				'standard' => q(პაკისტანის სტანდარტული დრო),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(პალაუს დრო),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(პაპუა-ახალი გვინეის დრო),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(პარაგვაის ზაფხულის დრო),
				'generic' => q(პარაგვაის დრო),
				'standard' => q(პარაგვაის სტანდარტული დრო),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(პერუს ზაფხულის დრო),
				'generic' => q(პერუს დრო),
				'standard' => q(პერუს სტანდარტული დრო),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ფილიპინების ზაფხულის დრო),
				'generic' => q(ფილიპინების დრო),
				'standard' => q(ფილიპინების სტანდარტული დრო),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ფენიქსის კუნძულების დრო),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(სენ-პიერის და მიკელონის დროის სარტყელი),
				'generic' => q(სენ-პიერის და მიკელონის დრო),
				'standard' => q(სენ-პიერის და მიკელონის სტანდარტული დრო),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(პიტკერნის დრო),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(პონაპეს დრო),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(რეიუნიონის დრო),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(როთერის დრო),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(სახალინის ზაფხულის დრო),
				'generic' => q(სახალინის დრო),
				'standard' => q(სახალინის სტანდარტული დრო),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(სამოას ზაფხულის დრო),
				'generic' => q(სამოას დრო),
				'standard' => q(სამოას სტანდარტული დრო),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(სეიშელის კუნძულების დრო),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(სინგაპურის დრო),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(სოლომონის კუნძულების დრო),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(სამხრეთ გეორგიის დრო),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(სურინამის დრო),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(სიოვას დრო),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ტაიტის დრო),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(ტაიბეის დროის სარტყელი),
				'generic' => q(ტაიბეის დრო),
				'standard' => q(ტაიბეის სტანდარტული დრო),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(ტაჯიკეთის დრო),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(ტოკელაუს დრო),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(ტონგის ზაფხულის დრო),
				'generic' => q(ტონგის დრო),
				'standard' => q(ტონგის სტანდარტული დრო),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ჩუუკის დრო),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(თურქმენეთის ზაფხულის დრო),
				'generic' => q(თურქმენეთის დრო),
				'standard' => q(თურქმენეთის სტანდარტული დრო),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ტუვალუს დრო),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ურუგვაის ზაფხულის დრო),
				'generic' => q(ურუგვაის დრო),
				'standard' => q(ურუგვაის სტანდარტული დრო),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(უზბეკეთის ზაფხულის დრო),
				'generic' => q(უზბეკეთის დრო),
				'standard' => q(უზბეკეთის სტანდარტული დრო),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(ვანუატუს ზაფხულის დრო),
				'generic' => q(ვანუატუს დრო),
				'standard' => q(ვანუატუს სტანდარტული დრო),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(ვენესუელის დრო),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ვლადივოსტოკის ზაფხულის დრო),
				'generic' => q(ვლადივოსტოკის დრო),
				'standard' => q(ვლადივოსტოკის სტანდარტული დრო),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(ვოლგოგრადის ზაფხულის დრო),
				'generic' => q(ვოლგოგრადის დრო),
				'standard' => q(ვოლგოგრადის სტანდარტული დრო),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ვოსტოკის დრო),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ვეიკის კუნძულის დრო),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(ვოლისი და ფუტუნას დრო),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(იაკუტსკის ზაფხულის დრო),
				'generic' => q(იაკუტსკის დრო),
				'standard' => q(იაკუტსკის სტანდარტული დრო),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ეკატერინბურგის ზაფხულის დრო),
				'generic' => q(ეკატერინბურგის დრო),
				'standard' => q(ეკატერინბურგის სტანდარტული დრო),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
