=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Te - Package for language Telugu

=cut

package Locale::CLDR::Locales::Te;
# This file auto generated from Data\common\main\te.xml
#	on Sun  3 Dec 10:41:55 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.4');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'అఫార్',
 				'ab' => 'అబ్ఖాజియన్',
 				'ace' => 'ఆఖినీస్',
 				'ach' => 'అకోలి',
 				'ada' => 'అడాంగ్మే',
 				'ady' => 'అడిగాబ్జే',
 				'ae' => 'అవేస్టాన్',
 				'aeb' => 'టునీషియా అరబిక్',
 				'af' => 'ఆఫ్రికాన్స్',
 				'afh' => 'అఫ్రిహిలి',
 				'agq' => 'అగేమ్',
 				'ain' => 'ఐను',
 				'ak' => 'అకాన్',
 				'akk' => 'అక్కాడియాన్',
 				'ale' => 'అలియుట్',
 				'alt' => 'దక్షిణ ఆల్టై',
 				'am' => 'అమ్హారిక్',
 				'an' => 'అరగోనిస్',
 				'ang' => 'ప్రాచీన ఆంగ్లం',
 				'anp' => 'ఆంగిక',
 				'ar' => 'అరబిక్',
 				'ar_001' => 'ఆధునిక ప్రామాణిక అరబిక్',
 				'arc' => 'అరామైక్',
 				'arn' => 'మపుచే',
 				'arp' => 'అరాపాహో',
 				'arw' => 'అరావాక్',
 				'arz' => 'ఈజిప్షియన్ అరబిక్',
 				'as' => 'అస్సామీస్',
 				'asa' => 'అసు',
 				'ast' => 'ఆస్టూరియన్',
 				'av' => 'అవారిక్',
 				'awa' => 'అవధి',
 				'ay' => 'ఐమారా',
 				'az' => 'అజర్బైజాని',
 				'az@alt=short' => 'అజెరి',
 				'ba' => 'బాష్కిర్',
 				'bal' => 'బాలుచి',
 				'ban' => 'బాలినీస్',
 				'bas' => 'బసా',
 				'be' => 'బెలారుషియన్',
 				'bej' => 'బేజా',
 				'bem' => 'బెంబా',
 				'bez' => 'బెనా',
 				'bg' => 'బల్గేరియన్',
 				'bgn' => 'పశ్చిమ బలూచీ',
 				'bho' => 'భోజ్‌పురి',
 				'bi' => 'బిస్లామా',
 				'bik' => 'బికోల్',
 				'bin' => 'బిని',
 				'bla' => 'సిక్సికా',
 				'bm' => 'బంబారా',
 				'bn' => 'బంగ్లా',
 				'bo' => 'టిబెటన్',
 				'bpy' => 'బిష్ణుప్రియ',
 				'br' => 'బ్రెటన్',
 				'bra' => 'బ్రాజ్',
 				'brx' => 'బోడో',
 				'bs' => 'బోస్నియన్',
 				'bua' => 'బురియట్',
 				'bug' => 'బుగినీస్',
 				'byn' => 'బ్లిన్',
 				'ca' => 'కాటలాన్',
 				'cad' => 'కేడ్డో',
 				'car' => 'కేరిబ్',
 				'cch' => 'అట్సామ్',
 				'ce' => 'చెచెన్',
 				'ceb' => 'సెబువానో',
 				'cgg' => 'ఛిగా',
 				'ch' => 'చమర్రో',
 				'chb' => 'చిబ్చా',
 				'chg' => 'చాగటై',
 				'chk' => 'చూకీస్',
 				'chm' => 'మారి',
 				'chn' => 'చినూక్ జార్గన్',
 				'cho' => 'చక్టా',
 				'chp' => 'చిపెవ్యాన్',
 				'chr' => 'చెరోకీ',
 				'chy' => 'చేయేన్',
 				'ckb' => 'సెంట్రల్ కర్డిష్',
 				'co' => 'కోర్సికన్',
 				'cop' => 'కోప్టిక్',
 				'cr' => 'క్రి',
 				'crh' => 'క్రిమియన్ టర్కిష్',
 				'crs' => 'సెసేల్వా క్రియోల్ ఫ్రెంచ్',
 				'cs' => 'చెక్',
 				'csb' => 'కషుబియన్',
 				'cu' => 'చర్చ్ స్లావిక్',
 				'cv' => 'చువాష్',
 				'cy' => 'వెల్ష్',
 				'da' => 'డానిష్',
 				'dak' => 'డకోటా',
 				'dar' => 'డార్గ్వా',
 				'dav' => 'టైటా',
 				'de' => 'జర్మన్',
 				'de_AT' => 'ఆస్ట్రియన్ జర్మన్',
 				'de_CH' => 'స్విస్ హై జర్మన్',
 				'del' => 'డెలావేర్',
 				'den' => 'స్లేవ్',
 				'dgr' => 'డోగ్రిబ్',
 				'din' => 'డింకా',
 				'dje' => 'జార్మా',
 				'doi' => 'డోగ్రి',
 				'dsb' => 'లోయర్ సోర్బియన్',
 				'dua' => 'డ్యూలా',
 				'dum' => 'మధ్యమ డచ్',
 				'dv' => 'దివేహి',
 				'dyo' => 'జోలా-ఫోనయి',
 				'dyu' => 'డ్యులా',
 				'dz' => 'జోంఖా',
 				'dzg' => 'డాజాగా',
 				'ebu' => 'ఇంబు',
 				'ee' => 'యూ',
 				'efi' => 'ఎఫిక్',
 				'egy' => 'ప్రాచీన ఈజిప్షియన్',
 				'eka' => 'ఏకాజక్',
 				'el' => 'గ్రీక్',
 				'elx' => 'ఎలామైట్',
 				'en' => 'ఆంగ్లం',
 				'en_AU' => 'ఆస్ట్రేలియన్ ఇంగ్లీష్',
 				'en_CA' => 'కెనడియన్ ఇంగ్లీష్',
 				'en_GB' => 'బ్రిటిష్ ఇంగ్లీష్',
 				'en_GB@alt=short' => 'యు.కె. ఇంగ్లీష్',
 				'en_US' => 'అమెరికన్ ఇంగ్లీష్',
 				'en_US@alt=short' => 'యు.ఎస్. ఇంగ్లీష్',
 				'enm' => 'మధ్యమ ఆంగ్లం',
 				'eo' => 'ఎస్పెరాంటో',
 				'es' => 'స్పానిష్',
 				'es_419' => 'లాటిన్ అమెరికన్ స్పానిష్',
 				'es_ES' => 'యూరోపియన్ స్పానిష్',
 				'es_MX' => 'మెక్సికన్ స్పానిష్',
 				'et' => 'ఎస్టోనియన్',
 				'eu' => 'బాస్క్యూ',
 				'ewo' => 'ఎవోండొ',
 				'fa' => 'పర్షియన్',
 				'fan' => 'ఫాంగ్',
 				'fat' => 'ఫాంటి',
 				'ff' => 'ఫ్యుల',
 				'fi' => 'ఫిన్నిష్',
 				'fil' => 'ఫిలిపినో',
 				'fj' => 'ఫిజియన్',
 				'fo' => 'ఫారోస్',
 				'fon' => 'ఫాన్',
 				'fr' => 'ఫ్రెంచ్',
 				'fr_CA' => 'కెనడియెన్ ఫ్రెంచ్',
 				'fr_CH' => 'స్విస్ ఫ్రెంచ్',
 				'frc' => 'కాజున్ ఫ్రెంచ్',
 				'frm' => 'మధ్యమ ప్రెంచ్',
 				'fro' => 'ప్రాచీన ఫ్రెంచ్',
 				'frr' => 'ఉత్తర ఫ్రిసియన్',
 				'frs' => 'తూర్పు ఫ్రిసియన్',
 				'fur' => 'ఫ్రియులియన్',
 				'fy' => 'పశ్చిమ ఫ్రిసియన్',
 				'ga' => 'ఐరిష్',
 				'gaa' => 'గా',
 				'gag' => 'గాగౌజ్',
 				'gan' => 'గాన్ చైనీస్',
 				'gay' => 'గాయో',
 				'gba' => 'గ్బాయా',
 				'gd' => 'స్కాటిష్ గేలిక్',
 				'gez' => 'జీజ్',
 				'gil' => 'గిల్బర్టీస్',
 				'gl' => 'గాలిషియన్',
 				'gmh' => 'మధ్యమ హై జర్మన్',
 				'gn' => 'గ్వారనీ',
 				'goh' => 'ప్రాచీన హై జర్మన్',
 				'gon' => 'గోండి',
 				'gor' => 'గోరోంటలా',
 				'got' => 'గోథిక్',
 				'grb' => 'గ్రేబో',
 				'grc' => 'ప్రాచీన గ్రీక్',
 				'gsw' => 'స్విస్ జర్మన్',
 				'gu' => 'గుజరాతి',
 				'guz' => 'గుస్సీ',
 				'gv' => 'మాంక్స్',
 				'gwi' => 'గ్విచిన్',
 				'ha' => 'హౌసా',
 				'hai' => 'హైడా',
 				'hak' => 'హక్కా చైనీస్',
 				'haw' => 'హవాయియన్',
 				'he' => 'హిబ్రూ',
 				'hi' => 'హిందీ',
 				'hil' => 'హిలిగెనాన్',
 				'hit' => 'హిట్టిటే',
 				'hmn' => 'మోంగ్',
 				'ho' => 'హిరి మోటు',
 				'hr' => 'క్రొయేషియన్',
 				'hsb' => 'అప్పర్ సోర్బియన్',
 				'hsn' => 'జియాంగ్ చైనీస్',
 				'ht' => 'హైటియన్ క్రియోల్',
 				'hu' => 'హంగేరియన్',
 				'hup' => 'హుపా',
 				'hy' => 'ఆర్మేనియన్',
 				'hz' => 'హెరెరో',
 				'ia' => 'ఇంటర్లింగ్వా',
 				'iba' => 'ఐబాన్',
 				'ibb' => 'ఇబిబియో',
 				'id' => 'ఇండోనేషియన్',
 				'ie' => 'ఇంటర్లింగ్',
 				'ig' => 'ఇగ్బో',
 				'ii' => 'శిషువన్ ఈ',
 				'ik' => 'ఇనుపైయాక్',
 				'ilo' => 'ఐలోకో',
 				'inh' => 'ఇంగుష్',
 				'io' => 'ఈడో',
 				'is' => 'ఐస్లాండిక్',
 				'it' => 'ఇటాలియన్',
 				'iu' => 'ఇనుక్టిటుట్',
 				'ja' => 'జపనీస్',
 				'jbo' => 'లోజ్బాన్',
 				'jgo' => 'గోంబా',
 				'jmc' => 'మకొమ్',
 				'jpr' => 'జ్యుడియో-పర్షియన్',
 				'jrb' => 'జ్యుడియో-అరబిక్',
 				'jv' => 'జావనీస్',
 				'ka' => 'జార్జియన్',
 				'kaa' => 'కారా-కల్పాక్',
 				'kab' => 'కాబిల్',
 				'kac' => 'కాచిన్',
 				'kaj' => 'జ్యూ',
 				'kam' => 'కంబా',
 				'kaw' => 'కావి',
 				'kbd' => 'కబార్డియన్',
 				'kcg' => 'ట్యాప్',
 				'kde' => 'మకొండే',
 				'kea' => 'కాబువేర్దియను',
 				'kfo' => 'కోరో',
 				'kg' => 'కోంగో',
 				'kha' => 'ఖాసి',
 				'kho' => 'ఖోటనీస్',
 				'khq' => 'కొయరా చీన్నీ',
 				'ki' => 'కికుయు',
 				'kj' => 'క్వాన్యామ',
 				'kk' => 'కజఖ్',
 				'kkj' => 'కాకో',
 				'kl' => 'కలాల్లిసూట్',
 				'kln' => 'కలెంజిన్',
 				'km' => 'ఖ్మేర్',
 				'kmb' => 'కిమ్బుండు',
 				'kn' => 'కన్నడ',
 				'ko' => 'కొరియన్',
 				'koi' => 'కోమి-పర్మాక్',
 				'kok' => 'కొంకణి',
 				'kos' => 'కోస్రేయన్',
 				'kpe' => 'పెల్లే',
 				'kr' => 'కానురి',
 				'krc' => 'కరచే-బల్కార్',
 				'krl' => 'కరేలియన్',
 				'kru' => 'కూరుఖ్',
 				'ks' => 'కాశ్మీరి',
 				'ksb' => 'శంబాలా',
 				'ksf' => 'బాఫియ',
 				'ksh' => 'కొలోనియన్',
 				'ku' => 'కుర్దిష్',
 				'kum' => 'కుమ్యిక్',
 				'kut' => 'కుటేనై',
 				'kv' => 'కోమి',
 				'kw' => 'కోర్నిష్',
 				'ky' => 'కిర్గిజ్',
 				'la' => 'లాటిన్',
 				'lad' => 'లాడినో',
 				'lag' => 'లాంగీ',
 				'lah' => 'లాహండా',
 				'lam' => 'లాంబా',
 				'lb' => 'లక్సెంబర్గిష్',
 				'lez' => 'లేజ్ఘియన్',
 				'lg' => 'గాండా',
 				'li' => 'లిమ్బర్గిష్',
 				'lkt' => 'లకొటా',
 				'ln' => 'లింగాల',
 				'lo' => 'లావో',
 				'lol' => 'మొంగో',
 				'lou' => 'లూసియానా క్రియోల్',
 				'loz' => 'లోజి',
 				'lrc' => 'ఉత్తర లూరీ',
 				'lt' => 'లిథువేనియన్',
 				'lu' => 'లూబ-కటాంగ',
 				'lua' => 'లుబా-లులువ',
 				'lui' => 'లుయిసెనో',
 				'lun' => 'లుండా',
 				'luo' => 'లువో',
 				'lus' => 'మిజో',
 				'luy' => 'లుయియ',
 				'lv' => 'లాట్వియన్',
 				'mad' => 'మాదురీస్',
 				'mag' => 'మగాహి',
 				'mai' => 'మైథిలి',
 				'mak' => 'మకాసార్',
 				'man' => 'మండింగో',
 				'mas' => 'మాసై',
 				'mdf' => 'మోక్ష',
 				'mdr' => 'మండార్',
 				'men' => 'మెండే',
 				'mer' => 'మెరు',
 				'mfe' => 'మొరిస్యేన్',
 				'mg' => 'మలగాసి',
 				'mga' => 'మధ్యమ ఐరిష్',
 				'mgh' => 'మక్వా-మిట్టో',
 				'mgo' => 'మెటా',
 				'mh' => 'మార్షలీస్',
 				'mi' => 'మావొరీ',
 				'mic' => 'మికమాక్',
 				'min' => 'మినాంగ్‌కాబో',
 				'mk' => 'మాసిడోనియన్',
 				'ml' => 'మలయాళం',
 				'mn' => 'మంగోలియన్',
 				'mnc' => 'మంచు',
 				'mni' => 'మణిపురి',
 				'moh' => 'మోహాక్',
 				'mos' => 'మోస్సి',
 				'mr' => 'మరాఠీ',
 				'ms' => 'మలయ్',
 				'mt' => 'మాల్టీస్',
 				'mua' => 'మండాంగ్',
 				'mul' => 'బహుళ భాషలు',
 				'mus' => 'క్రీక్',
 				'mwl' => 'మిరాండిస్',
 				'mwr' => 'మార్వాడి',
 				'my' => 'బర్మీస్',
 				'myv' => 'ఎర్జియా',
 				'mzn' => 'మాసన్‌దెరాని',
 				'na' => 'నౌరు',
 				'nan' => 'మిన్ నాన్ చైనీస్',
 				'nap' => 'నియాపోలిటన్',
 				'naq' => 'నమ',
 				'nb' => 'నార్వేజియన్ బొక్మాల్',
 				'nd' => 'ఉత్తర దెబెలె',
 				'nds' => 'లో జర్మన్',
 				'nds_NL' => 'లో సాక్సన్',
 				'ne' => 'నేపాలి',
 				'new' => 'నెవారి',
 				'ng' => 'డోంగా',
 				'nia' => 'నియాస్',
 				'niu' => 'నియాన్',
 				'nl' => 'డచ్',
 				'nl_BE' => 'ఫ్లెమిష్',
 				'nmg' => 'క్వాసియె',
 				'nn' => 'నార్వేజియాన్ న్యోర్స్క్',
 				'nnh' => 'గింబూన్',
 				'no' => 'నార్వేజియన్',
 				'nog' => 'నోగై',
 				'non' => 'ప్రాచిన నోర్స్',
 				'nqo' => 'న్కో',
 				'nr' => 'దక్షిణ దెబెలె',
 				'nso' => 'ఉత్తర సోతో',
 				'nus' => 'న్యుర్',
 				'nv' => 'నవాజొ',
 				'nwc' => 'సాంప్రదాయ న్యూయారీ',
 				'ny' => 'న్యాన్జా',
 				'nym' => 'న్యంవేజి',
 				'nyn' => 'న్యాన్కోలె',
 				'nyo' => 'నేయోరో',
 				'nzi' => 'జీమా',
 				'oc' => 'ఆక్సిటన్',
 				'oj' => 'చేవా',
 				'om' => 'ఒరోమో',
 				'or' => 'ఒడియా',
 				'os' => 'ఒసేటిక్',
 				'osa' => 'ఒసాజ్',
 				'ota' => 'ఒట్టోమన్ టర్కిష్',
 				'pa' => 'పంజాబీ',
 				'pag' => 'పంగాసినాన్',
 				'pal' => 'పహ్లావి',
 				'pam' => 'పంపన్గా',
 				'pap' => 'పపియమేంటో',
 				'pau' => 'పలావెన్',
 				'pcm' => 'నైజీరియా పిడ్గిన్',
 				'peo' => 'ప్రాచీన పర్షియన్',
 				'phn' => 'ఫోనికన్',
 				'pi' => 'పాలీ',
 				'pl' => 'పోలిష్',
 				'pon' => 'పోహ్న్పెయన్',
 				'prg' => 'ప్రష్యన్',
 				'pro' => 'ప్రాచీన ప్రోవెంసాల్',
 				'ps' => 'పాష్టో',
 				'ps@alt=variant' => 'పుష్టో',
 				'pt' => 'పోర్చుగీస్',
 				'pt_BR' => 'బ్రెజీలియన్ పోర్చుగీస్',
 				'pt_PT' => 'యూరోపియన్ పోర్చుగీస్',
 				'qu' => 'కెచువా',
 				'quc' => 'కిచే',
 				'raj' => 'రాజస్తానీ',
 				'rap' => 'రాపన్యుయి',
 				'rar' => 'రారోటొంగాన్',
 				'rm' => 'రోమన్ష్',
 				'rn' => 'రుండి',
 				'ro' => 'రోమేనియన్',
 				'ro_MD' => 'మొల్డావియన్',
 				'rof' => 'రోంబో',
 				'rom' => 'రోమానీ',
 				'root' => 'రూట్',
 				'ru' => 'రష్యన్',
 				'rup' => 'ఆరోమేనియన్',
 				'rw' => 'కిన్యర్వాండా',
 				'rwk' => 'ర్వా',
 				'sa' => 'సంస్కృతం',
 				'sad' => 'సండావి',
 				'sah' => 'సాఖా',
 				'sam' => 'సమారిటన్ అరామైక్',
 				'saq' => 'సంబురు',
 				'sas' => 'ససక్',
 				'sat' => 'సంతాలి',
 				'sba' => 'గాంబే',
 				'sbp' => 'సాంగు',
 				'sc' => 'సార్డీనియన్',
 				'scn' => 'సిసిలియన్',
 				'sco' => 'స్కాట్స్',
 				'sd' => 'సింధీ',
 				'sdh' => 'దక్షిణ కుర్డిష్',
 				'se' => 'ఉత్తర సామి',
 				'seh' => 'సెనా',
 				'sel' => 'సేల్కప్',
 				'ses' => 'కోయోరాబోరో సెన్నీ',
 				'sg' => 'సాంగో',
 				'sga' => 'ప్రాచీన ఐరిష్',
 				'sh' => 'సేర్బో-క్రొయేషియన్',
 				'shi' => 'టాచెల్‌హిట్',
 				'shn' => 'షాన్',
 				'si' => 'సింహళం',
 				'sid' => 'సిడామో',
 				'sk' => 'స్లోవక్',
 				'sl' => 'స్లోవేనియన్',
 				'sm' => 'సమోవన్',
 				'sma' => 'దక్షిణ సామి',
 				'smj' => 'లులే సామి',
 				'smn' => 'ఇనారి సామి',
 				'sms' => 'స్కోల్ట్ సామి',
 				'sn' => 'షోన',
 				'snk' => 'సోనింకి',
 				'so' => 'సోమాలి',
 				'sog' => 'సోగ్డియన్',
 				'sq' => 'అల్బేనియన్',
 				'sr' => 'సెర్బియన్',
 				'srn' => 'స్రానన్ టోంగో',
 				'srr' => 'సెరేర్',
 				'ss' => 'స్వాతి',
 				'ssy' => 'సాహో',
 				'st' => 'దక్షిణ సోతో',
 				'su' => 'సండానీస్',
 				'suk' => 'సుకుమా',
 				'sus' => 'సుసు',
 				'sux' => 'సుమేరియాన్',
 				'sv' => 'స్వీడిష్',
 				'sw' => 'స్వాహిలి',
 				'sw_CD' => 'కాంగో స్వాహిలి',
 				'swb' => 'కొమొరియన్',
 				'syc' => 'సాంప్రదాయ సిరియాక్',
 				'syr' => 'సిరియాక్',
 				'ta' => 'తమిళము',
 				'tcy' => 'తుళు',
 				'te' => 'తెలుగు',
 				'tem' => 'టిమ్నే',
 				'teo' => 'టెసో',
 				'ter' => 'టెరెనో',
 				'tet' => 'టేటం',
 				'tg' => 'తజిక్',
 				'th' => 'థాయ్',
 				'ti' => 'టిగ్రిన్యా',
 				'tig' => 'టీగ్రె',
 				'tiv' => 'టివ్',
 				'tk' => 'తుర్క్‌మెన్',
 				'tkl' => 'టోకెలావ్',
 				'tl' => 'టగలాగ్',
 				'tlh' => 'క్లింగాన్',
 				'tli' => 'ట్లింగిట్',
 				'tmh' => 'టామషేక్',
 				'tn' => 'స్వానా',
 				'to' => 'టాంగాన్',
 				'tog' => 'న్యాసా టోన్గా',
 				'tpi' => 'టోక్ పిసిన్',
 				'tr' => 'టర్కిష్',
 				'trv' => 'తరోకో',
 				'ts' => 'సోంగా',
 				'tsi' => 'శింషీయన్',
 				'tt' => 'టాటర్',
 				'tum' => 'టుంబుకా',
 				'tvl' => 'టువాలు',
 				'tw' => 'ట్వి',
 				'twq' => 'టసావాఖ్',
 				'ty' => 'తహితియన్',
 				'tyv' => 'టువినియన్',
 				'tzm' => 'సెంట్రల్ అట్లాస్ టామాజైట్',
 				'udm' => 'ఉడ్ముర్ట్',
 				'ug' => 'ఉయ్‌ఘర్',
 				'uga' => 'ఉగారిటిక్',
 				'uk' => 'ఉక్రెయినియన్',
 				'umb' => 'ఉమ్బుండు',
 				'und' => 'తెలియని భాష',
 				'ur' => 'ఉర్దూ',
 				'uz' => 'ఉజ్బెక్',
 				'vai' => 'వాయి',
 				've' => 'వెండా',
 				'vi' => 'వియత్నామీస్',
 				'vo' => 'వోలాపుక్',
 				'vot' => 'వోటిక్',
 				'vun' => 'వుంజొ',
 				'wa' => 'వాలూన్',
 				'wae' => 'వాల్సర్',
 				'wal' => 'వాలేట్టా',
 				'war' => 'వారే',
 				'was' => 'వాషో',
 				'wbp' => 'వార్లపిరి',
 				'wo' => 'ఉలూఫ్',
 				'wuu' => 'వు చైనీస్',
 				'xal' => 'కల్మిక్',
 				'xh' => 'షోసా',
 				'xog' => 'సొగా',
 				'yao' => 'యాయే',
 				'yap' => 'యాపిస్',
 				'yav' => 'యాంగ్‌బెన్',
 				'ybb' => 'యెంబా',
 				'yi' => 'ఇడ్డిష్',
 				'yo' => 'యోరుబా',
 				'yue' => 'కాంటనీస్',
 				'za' => 'జువాన్',
 				'zap' => 'జపోటెక్',
 				'zbl' => 'బ్లిసింబల్స్',
 				'zen' => 'జెనాగా',
 				'zgh' => 'ప్రామాణిక మొరొకన్ టామజైట్',
 				'zh' => 'చైనీస్',
 				'zh_Hans' => 'సరళీకృత చైనీస్',
 				'zh_Hant' => 'సాంప్రదాయక చైనీస్',
 				'zu' => 'జూలూ',
 				'zun' => 'జుని',
 				'zxx' => 'లిపి లేదు',
 				'zza' => 'జాజా',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'అరబిక్',
 			'Arab@alt=variant' => 'పెర్‌సో-అరబిక్',
 			'Armi' => 'ఇంపీరియల్ అరామాక్',
 			'Armn' => 'అర్మేనియన్',
 			'Avst' => 'అవేస్టాన్',
 			'Bali' => 'బాలినీస్',
 			'Batk' => 'బాటక్',
 			'Beng' => 'బాంగ్లా',
 			'Blis' => 'బ్లిస్సింబల్స్',
 			'Bopo' => 'బోపోమోఫో',
 			'Brah' => 'బ్రాహ్మి',
 			'Brai' => 'బ్రెయిల్',
 			'Bugi' => 'బ్యుగినీస్',
 			'Buhd' => 'బుహిడ్',
 			'Cakm' => 'చక్మా',
 			'Cans' => 'యునిఫైడ్ కెనెడియన్ అబొరిజినల్ సిలబిక్స్',
 			'Cari' => 'కారియన్',
 			'Cham' => 'చామ్',
 			'Cher' => 'చిరోకి',
 			'Cirt' => 'సిర్థ్',
 			'Copt' => 'కోప్టిక్',
 			'Cprt' => 'సైప్రోట్',
 			'Cyrl' => 'సిరిలిక్',
 			'Cyrs' => 'ప్రాచీన చర్చ స్లావోనిక్ సిరిలిక్',
 			'Deva' => 'దేవనాగరి',
 			'Dsrt' => 'డేసెరెట్',
 			'Egyd' => 'ఇజిప్షియన్ డెమోటిక్',
 			'Egyh' => 'ఇజిప్షియన్ హైరాటిక్',
 			'Egyp' => 'ఇజిప్షియన్ హైరోగ్లైఫ్స్',
 			'Ethi' => 'ఇథియోపిక్',
 			'Geok' => 'జార్జియన్ ఖట్సూరి',
 			'Geor' => 'జార్జియన్',
 			'Glag' => 'గ్లాగో లిటిక్',
 			'Goth' => 'గోతిక్',
 			'Grek' => 'గ్రీక్',
 			'Gujr' => 'గుజరాతీ',
 			'Guru' => 'గుర్ముఖి',
 			'Hanb' => 'హాన్బ్',
 			'Hang' => 'హంగుల్',
 			'Hani' => 'హాన్',
 			'Hano' => 'హనునూ',
 			'Hans' => 'సరళీకృతం',
 			'Hans@alt=stand-alone' => 'సరళీకృత హాన్',
 			'Hant' => 'సాంప్రదాయక',
 			'Hant@alt=stand-alone' => 'సాంప్రదాయక హాన్',
 			'Hebr' => 'హీబ్రు',
 			'Hira' => 'హిరాగాన',
 			'Hmng' => 'పాహవా హ్మోంగ్',
 			'Hrkt' => 'జపనీస్ సిలబెరీస్',
 			'Hung' => 'ప్రాచీన హంగేరియన్',
 			'Inds' => 'సింధు',
 			'Ital' => 'ప్రాచిన ఐటాలిక్',
 			'Jamo' => 'జమో',
 			'Java' => 'జావనీస్',
 			'Jpan' => 'జాపనీస్',
 			'Kali' => 'కాయాహ్ లి',
 			'Kana' => 'కాటాకాన',
 			'Khar' => 'ఖరోషథి',
 			'Khmr' => 'ఖ్మేర్',
 			'Knda' => 'కన్నడ',
 			'Kore' => 'కొరియన్',
 			'Kthi' => 'కైథి',
 			'Lana' => 'లన్నా',
 			'Laoo' => 'లావో',
 			'Latf' => 'ఫ్రాక్టూర్ లాటిన్',
 			'Latg' => 'గేలిక్ లాటిన్',
 			'Latn' => 'లాటిన్',
 			'Lepc' => 'లేప్చా',
 			'Limb' => 'లింబు',
 			'Lina' => 'లినియర్ ఎ',
 			'Linb' => 'లినియర్ బి',
 			'Lyci' => 'లిసియన్',
 			'Lydi' => 'లిడియన్',
 			'Mand' => 'మాన్డియన్',
 			'Mani' => 'మానిచేన్',
 			'Maya' => 'మాయన్ హైరోగ్లైఫ్స్',
 			'Mero' => 'మెరోఇటిక్',
 			'Mlym' => 'మలయాళం',
 			'Mong' => 'మంగోలియన్',
 			'Moon' => 'మూన్',
 			'Mtei' => 'మీటి మయెక్',
 			'Mymr' => 'మయాన్మార్',
 			'Nkoo' => 'న్కో',
 			'Ogam' => 'ఒఘమ్',
 			'Olck' => 'ఓల్ చికి',
 			'Orkh' => 'ఓర్ఖోన్',
 			'Orya' => 'ఒడియా',
 			'Osma' => 'ఓసమాన్య',
 			'Perm' => 'ప్రాచీన పెర్మిక్',
 			'Phag' => 'ఫాగ్స్-పా',
 			'Phli' => 'ఇంస్క్రిప్షనాల్ పహ్లావి',
 			'Phlp' => 'సల్టార్ పహ్లావి',
 			'Phlv' => 'పుస్తక పహ్లావి',
 			'Phnx' => 'ఫోనిశియన్',
 			'Plrd' => 'పోల్లర్డ్ ఫోనెటిక్',
 			'Prti' => 'ఇంస్క్రిప్షనాల్ పార్థియన్',
 			'Rjng' => 'రేజాంగ్',
 			'Roro' => 'రోంగో రోంగో',
 			'Runr' => 'రూనిక్',
 			'Samr' => 'సమారిటన్',
 			'Sara' => 'సరాటి',
 			'Saur' => 'సౌరాష్ట్ర',
 			'Sgnw' => 'సంజ్ఞ లిపి',
 			'Shaw' => 'షవియాన్',
 			'Sinh' => 'సింహళం',
 			'Sund' => 'సుడానీస్',
 			'Sylo' => 'స్లోటి నాగ్రి',
 			'Syrc' => 'సిరియాక్',
 			'Syre' => 'ఎస్ట్రానజీలో సిరియాక్',
 			'Syrj' => 'పశ్చిమ సిరియాక్',
 			'Syrn' => 'తూర్పు సిరియాక్',
 			'Tagb' => 'టాగ్బానవా',
 			'Tale' => 'తై లీ',
 			'Talu' => 'క్రొత్త టై లుఇ',
 			'Taml' => 'తమిళము',
 			'Tavt' => 'టై వియట్',
 			'Telu' => 'తెలుగు',
 			'Teng' => 'టేంగ్వార్',
 			'Tfng' => 'టిఫీనాఘ్',
 			'Tglg' => 'టగలాగ్',
 			'Thaa' => 'థానా',
 			'Thai' => 'థాయ్',
 			'Tibt' => 'టిబెటన్',
 			'Ugar' => 'యుగారిటిక్',
 			'Vaii' => 'వాయి',
 			'Visp' => 'కనిపించే భాష',
 			'Xpeo' => 'ప్రాచీన పర్షియన్',
 			'Xsux' => 'సుమేరో- అక్కడియన్ క్యునిఫార్మ్',
 			'Yiii' => 'యి',
 			'Zinh' => 'వారసత్వం',
 			'Zmth' => 'గణిత సంకేతలిపి',
 			'Zsye' => 'ఎమోజి',
 			'Zsym' => 'చిహ్నాలు',
 			'Zxxx' => 'లిపి లేని',
 			'Zyyy' => 'సామాన్య',
 			'Zzzz' => 'తెలియని లిపి',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ప్రపంచం',
 			'002' => 'ఆఫ్రికా',
 			'003' => 'ఉత్తర అమెరికా',
 			'005' => 'దక్షిణ అమెరికా',
 			'009' => 'ఓషినియా',
 			'011' => 'పశ్చిమ ఆఫ్రికా భూభాగం',
 			'013' => 'మధ్యమ అమెరికా',
 			'014' => 'తూర్పు ఆఫ్రికా',
 			'015' => 'ఉత్తర ఆఫ్రికా',
 			'017' => 'మధ్యమ ఆఫ్రికా',
 			'018' => 'దక్షిణ ఆఫ్రికా భూభాగం',
 			'019' => 'అమెరికాస్',
 			'021' => 'ఉత్తర అమెరికా భూభాగం',
 			'029' => 'కరిబ్బియన్',
 			'030' => 'తూర్పు ఆసియా',
 			'034' => 'దక్షిణ ఆసియా',
 			'035' => 'నైరుతి ఆసియా',
 			'039' => 'దక్షిణ యూరోప్',
 			'053' => 'ఆస్ట్రేలేసియా',
 			'054' => 'మెలనేశియ',
 			'057' => 'మైక్రోనేశియ ప్రాంతం',
 			'061' => 'పాలినేషియా',
 			'142' => 'ఆసియా',
 			'143' => 'మధ్య ఆసియా',
 			'145' => 'పడమటి ఆసియా',
 			'150' => 'యూరోప్',
 			'151' => 'తూర్పు యూరోప్',
 			'154' => 'ఉత్తర యూరోప్',
 			'155' => 'పశ్చిమ యూరోప్',
 			'202' => 'ఉప సెహరన్ ఆఫ్రికా',
 			'419' => 'లాటిన్ అమెరికా',
 			'AC' => 'అసెన్షన్ దీవి',
 			'AD' => 'ఆండోరా',
 			'AE' => 'యునైటెడ్ అరబ్ ఎమిరేట్స్',
 			'AF' => 'ఆఫ్ఘనిస్తాన్',
 			'AG' => 'ఆంటిగ్వా మరియు బార్బుడా',
 			'AI' => 'ఆంగ్విల్లా',
 			'AL' => 'అల్బేనియా',
 			'AM' => 'ఆర్మేనియా',
 			'AO' => 'అంగోలా',
 			'AQ' => 'అంటార్కిటికా',
 			'AR' => 'అర్జెంటీనా',
 			'AS' => 'అమెరికన్ సమోవా',
 			'AT' => 'ఆస్ట్రియా',
 			'AU' => 'ఆస్ట్రేలియా',
 			'AW' => 'అరుబా',
 			'AX' => 'ఆలాండ్ దీవులు',
 			'AZ' => 'అజర్బైజాన్',
 			'BA' => 'బోస్నియా మరియు హెర్జిగోవినా',
 			'BB' => 'బార్బడోస్',
 			'BD' => 'బంగ్లాదేశ్',
 			'BE' => 'బెల్జియం',
 			'BF' => 'బుర్కినా ఫాసో',
 			'BG' => 'బల్గేరియా',
 			'BH' => 'బహ్రెయిన్',
 			'BI' => 'బురుండి',
 			'BJ' => 'బెనిన్',
 			'BL' => 'సెయింట్ బర్థెలిమి',
 			'BM' => 'బెర్ముడా',
 			'BN' => 'బ్రూనే',
 			'BO' => 'బొలీవియా',
 			'BQ' => 'కరీబియన్ నెదర్లాండ్స్',
 			'BR' => 'బ్రెజిల్',
 			'BS' => 'బహామాస్',
 			'BT' => 'భూటాన్',
 			'BV' => 'బువై దీవి',
 			'BW' => 'బోట్స్వానా',
 			'BY' => 'బెలారస్',
 			'BZ' => 'బెలిజ్',
 			'CA' => 'కెనడా',
 			'CC' => 'కోకోస్ (కీలింగ్) దీవులు',
 			'CD' => 'కాంగో- కిన్షాసా',
 			'CD@alt=variant' => 'కాంగో (DRC)',
 			'CF' => 'సెంట్రల్ ఆఫ్రికన్ రిపబ్లిక్',
 			'CG' => 'కాంగో- బ్రాజావిల్లి',
 			'CG@alt=variant' => 'కాంగో (రిపబ్లిక్)',
 			'CH' => 'స్విట్జర్లాండ్',
 			'CI' => 'కోట్ డి ఐవోర్',
 			'CI@alt=variant' => 'ఐవరీ కోస్ట్',
 			'CK' => 'కుక్ దీవులు',
 			'CL' => 'చిలీ',
 			'CM' => 'కామెరూన్',
 			'CN' => 'చైనా',
 			'CO' => 'కొలంబియా',
 			'CP' => 'క్లిప్పర్టన్ దీవి',
 			'CR' => 'కోస్టా రికా',
 			'CU' => 'క్యూబా',
 			'CV' => 'కేప్ వెర్డె',
 			'CW' => 'క్యూరసో',
 			'CX' => 'క్రిస్మస్ దీవి',
 			'CY' => 'సైప్రస్',
 			'CZ' => 'చెకియా',
 			'CZ@alt=variant' => 'చెక్ రిపబ్లిక్',
 			'DE' => 'జర్మనీ',
 			'DG' => 'డియాగో గార్సియా',
 			'DJ' => 'జిబౌటి',
 			'DK' => 'డెన్మార్క్',
 			'DM' => 'డొమినికా',
 			'DO' => 'డొమినికన్ రిపబ్లిక్',
 			'DZ' => 'అల్జీరియా',
 			'EA' => 'స్యూటా & మెలిల్లా',
 			'EC' => 'ఈక్వడార్',
 			'EE' => 'ఎస్టోనియా',
 			'EG' => 'ఈజిప్ట్',
 			'EH' => 'పడమటి సహారా',
 			'ER' => 'ఎరిట్రియా',
 			'ES' => 'స్పెయిన్',
 			'ET' => 'ఇథియోపియా',
 			'EU' => 'యూరోపియన్ యూనియన్',
 			'EZ' => 'యూరోజోన్',
 			'FI' => 'ఫిన్లాండ్',
 			'FJ' => 'ఫిజీ',
 			'FK' => 'ఫాక్‌ల్యాండ్ దీవులు',
 			'FK@alt=variant' => 'ఫాక్‌ల్యాండ్ దీవులు (ఇస్లాస్ మాల్వినాస్)',
 			'FM' => 'మైక్రోనేషియా',
 			'FO' => 'ఫారో దీవులు',
 			'FR' => 'ఫ్రాన్స్‌',
 			'GA' => 'గేబన్',
 			'GB' => 'యునైటెడ్ కింగ్‌డమ్',
 			'GB@alt=short' => 'యు.కె.',
 			'GD' => 'గ్రెనడా',
 			'GE' => 'జార్జియా',
 			'GF' => 'ఫ్రెంచ్ గియానా',
 			'GG' => 'గర్న్‌సీ',
 			'GH' => 'ఘనా',
 			'GI' => 'జిబ్రాల్టర్',
 			'GL' => 'గ్రీన్‌ల్యాండ్',
 			'GM' => 'గాంబియా',
 			'GN' => 'గినియా',
 			'GP' => 'గ్వాడెలోప్',
 			'GQ' => 'ఈక్వటోరియల్ గినియా',
 			'GR' => 'గ్రీస్',
 			'GS' => 'దక్షిణ జార్జియా మరియు దక్షిణ శాండ్విచ్ దీవులు',
 			'GT' => 'గ్వాటిమాలా',
 			'GU' => 'గ్వామ్',
 			'GW' => 'గినియా-బిస్సావ్',
 			'GY' => 'గయానా',
 			'HK' => 'హాంకాంగ్ ఎస్ఏఆర్',
 			'HK@alt=short' => 'హాంకాంగ్',
 			'HM' => 'హెర్డ్ దీవి మరియు మెక్‌డొనాల్డ్ దీవులు',
 			'HN' => 'హోండురాస్',
 			'HR' => 'క్రొయేషియా',
 			'HT' => 'హైటి',
 			'HU' => 'హంగేరీ',
 			'IC' => 'కేనరీ దీవులు',
 			'ID' => 'ఇండోనేషియా',
 			'IE' => 'ఐర్లాండ్',
 			'IL' => 'ఇజ్రాయెల్',
 			'IM' => 'ఐల్ ఆఫ్ మాన్',
 			'IN' => 'భారతదేశం',
 			'IO' => 'బ్రిటీష్ హిందూ మహాసముద్ర ప్రాంతం',
 			'IQ' => 'ఇరాక్',
 			'IR' => 'ఇరాన్',
 			'IS' => 'ఐస్లాండ్',
 			'IT' => 'ఇటలీ',
 			'JE' => 'జెర్సీ',
 			'JM' => 'జమైకా',
 			'JO' => 'జోర్డాన్',
 			'JP' => 'జపాన్',
 			'KE' => 'కెన్యా',
 			'KG' => 'కిర్గిజిస్తాన్',
 			'KH' => 'కంబోడియా',
 			'KI' => 'కిరిబాటి',
 			'KM' => 'కొమొరోస్',
 			'KN' => 'సెయింట్ కిట్స్ మరియు నెవిస్',
 			'KP' => 'ఉత్తర కొరియా',
 			'KR' => 'దక్షిణ కొరియా',
 			'KW' => 'కువైట్',
 			'KY' => 'కేమాన్ దీవులు',
 			'KZ' => 'కజకిస్తాన్',
 			'LA' => 'లావోస్',
 			'LB' => 'లెబనాన్',
 			'LC' => 'సెయింట్ లూసియా',
 			'LI' => 'లిక్టెన్‌స్టెయిన్',
 			'LK' => 'శ్రీలంక',
 			'LR' => 'లైబీరియా',
 			'LS' => 'లెసోతో',
 			'LT' => 'లిథువేనియా',
 			'LU' => 'లక్సెంబర్గ్',
 			'LV' => 'లాత్వియా',
 			'LY' => 'లిబియా',
 			'MA' => 'మొరాకో',
 			'MC' => 'మొనాకో',
 			'MD' => 'మోల్డోవా',
 			'ME' => 'మాంటెనెగ్రో',
 			'MF' => 'సెయింట్ మార్టిన్',
 			'MG' => 'మడగాస్కర్',
 			'MH' => 'మార్షల్ దీవులు',
 			'MK' => 'మేసిడోనియా',
 			'MK@alt=variant' => 'పూర్వ రిపబ్లిక్ యుగోస్లావ్ మేసిడోనియా',
 			'ML' => 'మాలి',
 			'MM' => 'మయన్మార్',
 			'MN' => 'మంగోలియా',
 			'MO' => 'మకావ్ ఎస్ఏఆర్ చైనా',
 			'MO@alt=short' => 'మకావ్',
 			'MP' => 'ఉత్తర మరియానా దీవులు',
 			'MQ' => 'మార్టినీక్',
 			'MR' => 'మౌరిటేనియా',
 			'MS' => 'మాంట్సెరాట్',
 			'MT' => 'మాల్టా',
 			'MU' => 'మారిషస్',
 			'MV' => 'మాల్దీవులు',
 			'MW' => 'మలావీ',
 			'MX' => 'మెక్సికో',
 			'MY' => 'మలేషియా',
 			'MZ' => 'మొజాంబిక్',
 			'NA' => 'నమీబియా',
 			'NC' => 'క్రొత్త కాలెడోనియా',
 			'NE' => 'నైజర్',
 			'NF' => 'నార్ఫోక్ దీవి',
 			'NG' => 'నైజీరియా',
 			'NI' => 'నికరాగువా',
 			'NL' => 'నెదర్లాండ్స్',
 			'NO' => 'నార్వే',
 			'NP' => 'నేపాల్',
 			'NR' => 'నౌరు',
 			'NU' => 'నియూ',
 			'NZ' => 'న్యూజిలాండ్',
 			'OM' => 'ఓమన్',
 			'PA' => 'పనామా',
 			'PE' => 'పెరూ',
 			'PF' => 'ఫ్రెంచ్ పోలినీషియా',
 			'PG' => 'పాపువా న్యూ గినియా',
 			'PH' => 'ఫిలిప్పైన్స్',
 			'PK' => 'పాకిస్తాన్',
 			'PL' => 'పోలాండ్',
 			'PM' => 'సెయింట్ పియెర్ మరియు మికెలాన్',
 			'PN' => 'పిట్‌కెయిర్న్ దీవులు',
 			'PR' => 'ప్యూర్టో రికో',
 			'PS' => 'పాలస్తీనియన్ ప్రాంతాలు',
 			'PS@alt=short' => 'పాలస్తీనా',
 			'PT' => 'పోర్చుగల్',
 			'PW' => 'పాలావ్',
 			'PY' => 'పరాగ్వే',
 			'QA' => 'ఖతార్',
 			'QO' => 'ఒషీనియా బయటున్నవి',
 			'RE' => 'రీయూనియన్',
 			'RO' => 'రోమేనియా',
 			'RS' => 'సెర్బియా',
 			'RU' => 'రష్యా',
 			'RW' => 'రువాండా',
 			'SA' => 'సౌదీ అరేబియా',
 			'SB' => 'సోలమన్ దీవులు',
 			'SC' => 'సీషెల్స్',
 			'SD' => 'సూడాన్',
 			'SE' => 'స్వీడన్',
 			'SG' => 'సింగపూర్',
 			'SH' => 'సెయింట్ హెలెనా',
 			'SI' => 'స్లోవేనియా',
 			'SJ' => 'స్వాల్‌బార్డ్ మరియు జాన్ మాయెన్',
 			'SK' => 'స్లొవేకియా',
 			'SL' => 'సియెర్రా లియాన్',
 			'SM' => 'శాన్ మారినో',
 			'SN' => 'సెనెగల్',
 			'SO' => 'సోమాలియా',
 			'SR' => 'సూరినామ్',
 			'SS' => 'దక్షిణ సూడాన్',
 			'ST' => 'సావో టోమ్ మరియు ప్రిన్సిపి',
 			'SV' => 'ఎల్ సాల్వడోర్',
 			'SX' => 'సింట్ మార్టెన్',
 			'SY' => 'సిరియా',
 			'SZ' => 'స్వాజిల్యాండ్',
 			'TA' => 'ట్రిస్టన్ డ కన్హా',
 			'TC' => 'టర్క్స్ మరియు కైకోస్ దీవులు',
 			'TD' => 'చాద్',
 			'TF' => 'ఫ్రెంచ్ దక్షిణ ప్రాంతాలు',
 			'TG' => 'టోగో',
 			'TH' => 'థాయిలాండ్',
 			'TJ' => 'తజికిస్తాన్',
 			'TK' => 'టోకెలావ్',
 			'TL' => 'టిమోర్-లెస్టె',
 			'TL@alt=variant' => 'తూర్పు టిమోర్',
 			'TM' => 'టర్క్‌మెనిస్తాన్',
 			'TN' => 'ట్యునీషియా',
 			'TO' => 'టోంగా',
 			'TR' => 'టర్కీ',
 			'TT' => 'ట్రినిడాడ్ మరియు టొబాగో',
 			'TV' => 'టువాలు',
 			'TW' => 'తైవాన్',
 			'TZ' => 'టాంజానియా',
 			'UA' => 'ఉక్రెయిన్',
 			'UG' => 'ఉగాండా',
 			'UM' => 'సంయుక్త రాజ్య అమెరికా బయట ఉన్న దీవులు',
 			'UN' => 'యునైటెడ్ నేషన్స్',
 			'UN@alt=short' => 'యు.ఎన్',
 			'US' => 'యునైటెడ్ స్టేట్స్',
 			'US@alt=short' => 'యు.ఎస్.',
 			'UY' => 'ఉరుగ్వే',
 			'UZ' => 'ఉజ్బెకిస్తాన్',
 			'VA' => 'వాటికన్ నగరం',
 			'VC' => 'సెయింట్ విన్సెంట్ మరియు గ్రెనడీన్స్',
 			'VE' => 'వెనిజులా',
 			'VG' => 'బ్రిటిష్ వర్జిన్ దీవులు',
 			'VI' => 'యు.ఎస్. వర్జిన్ దీవులు',
 			'VN' => 'వియత్నాం',
 			'VU' => 'వనాటు',
 			'WF' => 'వాల్లిస్ మరియు ఫుటునా',
 			'WS' => 'సమోవా',
 			'XK' => 'కొసోవో',
 			'YE' => 'యెమెన్',
 			'YT' => 'మాయొట్',
 			'ZA' => 'దక్షిణ ఆఫ్రికా',
 			'ZM' => 'జాంబియా',
 			'ZW' => 'జింబాబ్వే',
 			'ZZ' => 'తెలియని ప్రాంతం',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'ప్రాచీన ఙర్మన వర్ణక్రమం',
 			'1996' => '1996 ఙర్మన వర్ణక్రమం',
 			'MONOTON' => 'మోనోటోనిక్',
 			'PINYIN' => 'పిన్‌యిన్ రోమనైజేషన్',
 			'POLYTON' => 'పాలీటోనిక్',
 			'POSIX' => 'కంప్యూటర్',
 			'REVISED' => 'సవరించబడిన వర్ణక్రమం',
 			'WADEGILE' => 'వేడ్-గైల్స్ రోమనైజేషన్',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'క్యాలెండర్',
 			'cf' => 'కరెన్సీ ఫార్మాట్',
 			'colalternate' => 'చిహ్నాలను క్రమబద్ధీకరించడాన్ని విస్మరించు',
 			'colbackwards' => 'వ్యతిరేక ఉచ్ఛారణ క్రమబద్ధీకరణ',
 			'colcasefirst' => 'అప్పర్‌కేస్‌/లోయర్ కేస్ క్రమం',
 			'colcaselevel' => 'కేస్ సెన్సిటివ్ క్రమబద్ధీకరణ',
 			'collation' => 'క్రమబద్ధీకరణ క్రమం',
 			'colnormalization' => 'సాధారణీకరించిన క్రమబద్ధీకరణ',
 			'colnumeric' => 'సంఖ్యాత్మక క్రమబద్ధీకరణ',
 			'colstrength' => 'క్రమబద్ధీకరణ సామర్థ్యం',
 			'currency' => 'కరెన్సీ',
 			'hc' => 'గంటల పద్ధతి (12 వర్సెస్ 24)',
 			'lb' => 'లైన్ బ్రేక్ శైలి',
 			'ms' => 'కొలమాన పద్ధతి',
 			'numbers' => 'సంఖ్యలు',
 			'timezone' => 'సమయ మండలి',
 			'va' => 'లొకేల్ రూపాంతరం',
 			'x' => 'ప్రైవేట్-ఉపయోగం',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{బుద్ధుల క్యాలెండర్‌},
 				'chinese' => q{చైనీస్ క్యాలెండర్},
 				'coptic' => q{కాప్టిక్ క్యాలెండర్},
 				'dangi' => q{దాంగీ క్యాలెండర్},
 				'ethiopic' => q{ఎథియోపిక్ క్యాలెండర్},
 				'ethiopic-amete-alem' => q{ఎథోపిక్ అమేటే అలెమ్ క్యాలెండర్},
 				'gregorian' => q{గ్రేగోరియన్ క్యాలెండర్},
 				'hebrew' => q{హిబ్రూ క్యాలెండర్},
 				'indian' => q{భారతీయ జాతీయ క్యాలెండర్},
 				'islamic' => q{ఇస్లామిక్ క్యాలెండర్},
 				'islamic-civil' => q{ఇస్లామిక్-సివిల్ క్యాలెండర్},
 				'islamic-rgsa' => q{ఇస్లామిక్ క్యాలెండర్ (సౌదీ అరేబియా)},
 				'islamic-tbla' => q{ఇస్లామిక్ క్యాలెండర్},
 				'islamic-umalqura' => q{ఇస్లామిక్ క్యాలెండర్ (ఉమ్ అల్-ఖురా)},
 				'iso8601' => q{ISO-8601 క్యాలెండర్},
 				'japanese' => q{జపానీయుల క్యాలెండర్},
 				'persian' => q{పర్షియన్ క్యాలెండర్},
 				'roc' => q{మింగ్యూ క్యాలెండర్},
 			},
 			'cf' => {
 				'account' => q{అకౌంటింగ్ కరెన్సీ ఫార్మాట్},
 				'standard' => q{ప్రామాణిక కరెన్సీ ఫార్మాట్},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{చిహ్నాలను క్రమబద్ధీకరించు},
 				'shifted' => q{చిహ్నాలను విస్మరించడాన్ని క్రమబద్ధీకరించు},
 			},
 			'colbackwards' => {
 				'no' => q{ఉచ్ఛారణలను సాధారణంగా క్రమబద్ధీకరించు},
 				'yes' => q{ఉచ్ఛారణలను వ్యతిరేక క్రమంలో క్రమబద్ధీకరించు},
 			},
 			'colcasefirst' => {
 				'lower' => q{ముందు లోయర్‌కేస్‌ని క్రమబద్ధీకరించు},
 				'no' => q{సాధారణ కేస్ క్రమాన్ని క్రమబద్ధీకరించు},
 				'upper' => q{ముందు అప్పర్‌కేస్‌ని క్రమబద్ధీకరించు},
 			},
 			'colcaselevel' => {
 				'no' => q{కేస్ ఇన్‌సెన్సిటివ్‌ను క్రమబద్ధీకరించు},
 				'yes' => q{కేస్ సెన్సిటివ్‌ని క్రమబద్ధీకరించు},
 			},
 			'collation' => {
 				'big5han' => q{సాంప్రదాయ చైనీస్ క్రమబద్ధీకరణ క్రమం - Big5},
 				'compat' => q{మునుపటి క్రమబద్ధీకరణ క్రమం, అనుకూలం},
 				'dictionary' => q{నిఘంటువు క్రమబద్ధీకరణ క్రమం},
 				'ducet' => q{డిఫాల్ట్ యూనీకోడ్ క్రమబద్ధీకరణ క్రమం},
 				'eor' => q{యురోపియన్ క్రమబద్ధీకరణ నిబంధనలు},
 				'gb2312han' => q{సరళీకృత చైనీస్ క్రమబద్ధీకరణ క్రమం - GB2312},
 				'phonebook' => q{ఫోన్‌బుక్ క్రమబద్ధీకరణ క్రమం},
 				'phonetic' => q{ధ్వని ఉచ్ఛారిత క్రమబద్ధీకరణ క్రమం},
 				'pinyin' => q{పిన్‌యిన్ క్రమబద్ధీకరణ క్రమం},
 				'reformed' => q{మళ్ళీ ఆకృతీకరించబడిన క్రమబద్ధీకరణ క్రమం},
 				'search' => q{సాధారణ-ప్రయోజన శోధన},
 				'searchjl' => q{హాంగుల్ ప్రారంభ హల్లు ద్వారా శోధించు},
 				'standard' => q{ప్రామాణిక క్రమబద్ధీకరణ క్రమం},
 				'stroke' => q{స్ట్రోక్ క్రమబద్ధీకరణ క్రమం},
 				'traditional' => q{సాంప్రదాయ క్రమబద్ధీకరణ క్రమం},
 				'unihan' => q{రాడికల్-స్ట్రోక్ క్రమబద్ధీకరణ క్రమం},
 			},
 			'colnormalization' => {
 				'no' => q{సాధారణీకరణ చేయకుండా క్రమబద్ధీకరించు},
 				'yes' => q{సాధారణీకరించిన యూనికోడ్‌ని క్రమబద్ధీకరించు},
 			},
 			'colnumeric' => {
 				'no' => q{అంకెలను ఒక్కొక్కటిగా క్రమబద్ధీకరించు},
 				'yes' => q{అంకెలను సంఖ్యాత్మకంగా క్రమబద్ధీకరించు},
 			},
 			'colstrength' => {
 				'identical' => q{అన్నింటినీ క్రమబద్ధీకరించు},
 				'primary' => q{ప్రాథమిక అక్షరాలను మాత్రమే క్రమబద్ధీకరించు},
 				'quaternary' => q{ఉచ్ఛారణలు/కేస్‌/వెడల్పు/కానాను క్రమబద్ధీకరించు},
 				'secondary' => q{ఉచ్ఛారణలని క్రమబద్ధీకరించు},
 				'tertiary' => q{ఉచ్ఛారణలని/కేస్‌ని/వెడల్పుని క్రమబద్ధీకరించు},
 			},
 			'd0' => {
 				'fwidth' => q{పూర్తి వెడల్పు},
 				'hwidth' => q{సగం వెడల్పు},
 				'npinyin' => q{సంఖ్య},
 			},
 			'hc' => {
 				'h11' => q{12 గంటల పద్ధతి (0–11)},
 				'h12' => q{12 గంటల పద్ధతి (1–12)},
 				'h23' => q{24 గంటల పద్ధతి (0–23)},
 				'h24' => q{24 గంటల పద్ధతి (1–24)},
 			},
 			'lb' => {
 				'loose' => q{అపక్రమ లైన్ బ్రేక్ శైలి},
 				'normal' => q{సాధారణ లైన్ బ్రేక్ శైలి},
 				'strict' => q{క్రమ లైన్ బ్రేక్ శైలి},
 			},
 			'm0' => {
 				'bgn' => q{US BGN ట్రాన్స్‌లిట్రేషన్},
 				'ungegn' => q{UN GEGN ట్రాన్స్‌లిట్రేషన్},
 			},
 			'ms' => {
 				'metric' => q{మెట్రిక్ పద్ధతి},
 				'uksystem' => q{ఇంపీరియల్ కొలమాన పద్ధతి},
 				'ussystem' => q{యు.ఎస్. కొలమాన పద్ధతి},
 			},
 			'numbers' => {
 				'arab' => q{అరబిక్-ఇండిక్ అంకెలు},
 				'arabext' => q{పొడిగించబడిన అరబిక్-ఇండిక్ అంకెలు},
 				'armn' => q{ఆర్మేనియన్ సంఖ్యలు},
 				'armnlow' => q{ఆర్మేనియన్ చిన్నబడి సంఖ్యలు},
 				'beng' => q{బెంగాలీ అంకెలు},
 				'deva' => q{దేవనాగరి అంకెలు},
 				'ethi' => q{ఎథియోపిక్ సంఖ్యలు},
 				'finance' => q{ఆర్థిక సంఖ్యలు},
 				'fullwide' => q{పూర్తి వెడల్పు అంకెలు},
 				'geor' => q{జార్జియన్ సంఖ్యలు},
 				'grek' => q{గ్రీక్ సంఖ్యలు},
 				'greklow' => q{గ్రీక్ చిన్నబడి సంఖ్యలు},
 				'gujr' => q{గుజరాతీ అంకెలు},
 				'guru' => q{గుర్ముఖీ అంకెలు},
 				'hanidec' => q{చైనీయుల దశాంశ సంఖ్యలు},
 				'hans' => q{సరళీకృత చైనీయుల సంఖ్యలు},
 				'hansfin' => q{సరళీకృత చైనీయుల ఆర్థిక సంఖ్యలు},
 				'hant' => q{సాంప్రదాయ చైనీయుల సంఖ్యలు},
 				'hantfin' => q{సాంప్రదాయ చైనీయుల ఆర్థిక సంఖ్యలు},
 				'hebr' => q{హిబ్రూ సంఖ్యలు},
 				'jpan' => q{జపానీయుల సంఖ్యలు},
 				'jpanfin' => q{జపానీయలు ఆర్థిక సంఖ్యలు},
 				'khmr' => q{ఖ్మేర్ అంకెలు},
 				'knda' => q{కన్నడ అంకెలు},
 				'laoo' => q{లావో అంకెలు},
 				'latn' => q{పశ్చిమ అంకెలు},
 				'mlym' => q{మలయాళం అంకెలు},
 				'mong' => q{మంగోలియన్ అంకెలు},
 				'mymr' => q{మయన్మార్ అంకెలు},
 				'native' => q{స్థానిక అంకెలు},
 				'orya' => q{ఒరియా అంకెలు},
 				'roman' => q{రోమన్ సంఖ్యలు},
 				'romanlow' => q{రోమన్ చిన్నబడి సంఖ్యలు},
 				'taml' => q{సాంప్రదాయ తమిళ సంఖ్యలు},
 				'tamldec' => q{తమిళ అంకెలు},
 				'telu' => q{తెలుగు అంకెలు},
 				'thai' => q{థాయ్ అంకెలు},
 				'tibt' => q{టిబిటన్ అంకెలు},
 				'traditional' => q{సాంప్రదాయ సంఖ్యలు},
 				'vaii' => q{వాయ్ అంకెలు},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{దశాంశం},
 			'UK' => q{యుకె},
 			'US' => q{యుఎస్},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'భాష: {0}',
 			'script' => 'లిపి: {0}',
 			'region' => 'ప్రాంతం: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍ ౦ ౧ ౨ ౩ ౪ ౫ ౬ ౭ ౮ ౯]},
			index => ['అ', 'ఆ', 'ఇ', 'ఈ', 'ఉ', 'ఊ', 'ఋ', 'ౠ', 'ఎ', 'ఏ', 'ఐ', 'ఒ', 'ఓ', 'ఔ', 'క', 'ఖ', 'గ', 'ఘ', 'ఙ', 'చ', 'ఛ', 'జ', 'ఝ', 'ఞ', 'ట', 'ఠ', 'డ', 'ఢ', 'ణ', 'త', 'థ', 'ద', 'ధ', 'న', 'ప', 'ఫ', 'బ', 'భ', 'మ', 'య', 'ర', 'ఱ', 'ల', 'వ', 'శ', 'ష', 'స', 'హ', 'ళ'],
			main => qr{[అ ఆ ఇ ఈ ఉ ఊ ఋ ౠ ఌ ౡ ఎ ఏ ఐ ఒ ఓ ఔ ఁ ం ః క ఖ గ ఘ ఙ చ ఛ జ ఝ ఞ ట ఠ డ ఢ ణ త థ ద ధ న ప ఫ బ భ మ య ర ఱ ల వ శ ష స హ ళ ా ి ీ ు ూ ృ ౄ ె ే ై ొ ో ౌ ్ ౕ ౖ]},
			numbers => qr{[\- , . % ‰ + 0౦ 1౧ 2౨ 3౩ 4౪ 5౫ 6౬ 7౭ 8౮ 9౯]},
			punctuation => qr{[\- , ; \: ! ? . ' ‘ ’ " “ ” ( ) \[ \] \{ \}]},
		};
	},
EOT
: sub {
		return { index => ['అ', 'ఆ', 'ఇ', 'ఈ', 'ఉ', 'ఊ', 'ఋ', 'ౠ', 'ఎ', 'ఏ', 'ఐ', 'ఒ', 'ఓ', 'ఔ', 'క', 'ఖ', 'గ', 'ఘ', 'ఙ', 'చ', 'ఛ', 'జ', 'ఝ', 'ఞ', 'ట', 'ఠ', 'డ', 'ఢ', 'ణ', 'త', 'థ', 'ద', 'ధ', 'న', 'ప', 'ఫ', 'బ', 'భ', 'మ', 'య', 'ర', 'ఱ', 'ల', 'వ', 'శ', 'ష', 'స', 'హ', 'ళ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(కార్డినల్ దిశ),
					},
					'acre' => {
						'name' => q(ఎకరాలు),
						'one' => q({0} ఎకరం),
						'other' => q({0} ఎకరాలు),
					},
					'acre-foot' => {
						'name' => q(ఎకరా-అడుగులు),
						'one' => q({0} ఎకరా-అడుగు),
						'other' => q({0} ఎకరా-అడుగులు),
					},
					'ampere' => {
						'name' => q(ఆంపియర్స్),
						'one' => q({0} ఆంపియర్),
						'other' => q({0} ఆంపియర్స్),
					},
					'arc-minute' => {
						'name' => q(ఆర్క్ నిమిషాలు),
						'one' => q({0} ఆర్క్ నిమిషం),
						'other' => q({0} ఆర్క్ నిమిషాలు),
					},
					'arc-second' => {
						'name' => q(ఆర్క్ సెకన్లు),
						'one' => q({0} ఆర్క్ సెకను),
						'other' => q({0} ఆర్క్ సెకన్లు),
					},
					'astronomical-unit' => {
						'name' => q(ఖగోళ ప్రమాణాలు),
						'one' => q({0} ఖగోళ ప్రమాణం),
						'other' => q({0} ఖగోళ ప్రమాణాలు),
					},
					'atmosphere' => {
						'name' => q(వాతావరణాలు),
						'one' => q({0} వాతావరణం),
						'other' => q({0} వాతావరణాలు),
					},
					'bit' => {
						'name' => q(బిట్‌లు),
						'one' => q({0} బిట్),
						'other' => q({0} బిట్‌లు),
					},
					'byte' => {
						'name' => q(బైట్‌లు),
						'one' => q({0} బైట్),
						'other' => q({0} బైట్‌లు),
					},
					'calorie' => {
						'name' => q(కేలరీలు),
						'one' => q({0} కేలరీ),
						'other' => q({0} కేలరీలు),
					},
					'carat' => {
						'name' => q(క్యారెట్లు),
						'one' => q({0} క్యారెట్),
						'other' => q({0} క్యారెట్లు),
					},
					'celsius' => {
						'name' => q(డిగ్రీల సెల్సియస్),
						'one' => q({0} డిగ్రీ సెల్సియస్),
						'other' => q({0} డిగ్రీల సెల్సియస్),
					},
					'centiliter' => {
						'name' => q(సెంటీలీటర్లు),
						'one' => q({0} సెంటీలీటరు),
						'other' => q({0} సెంటీలీటర్లు),
					},
					'centimeter' => {
						'name' => q(సెంటీమీటర్లు),
						'one' => q({0} సెంటీమీటరు),
						'other' => q({0} సెంటీమీటర్లు),
						'per' => q(సెంటీమీటరుకు {0}),
					},
					'century' => {
						'name' => q(శతాబ్దాలు),
						'one' => q({0} శతాబ్దం),
						'other' => q({0} శతాబ్దాలు),
					},
					'coordinate' => {
						'east' => q({0} తూర్పు),
						'north' => q({0} ఉత్తరం),
						'south' => q({0} దక్షిణం),
						'west' => q({0} పశ్చిమం),
					},
					'cubic-centimeter' => {
						'name' => q(క్యూబిక్ సెంటీమీటర్లు),
						'one' => q({0} క్యూబిక్ సెంటీమీటరు),
						'other' => q({0} క్యూబిక్ సెంటీమీటర్లు),
						'per' => q(క్యూబిక్ సెంటీమీటరుకు {0}),
					},
					'cubic-foot' => {
						'name' => q(ఘనపు అడుగులు),
						'one' => q({0} ఘనపు అడుగు),
						'other' => q({0} ఘనపు అడుగులు),
					},
					'cubic-inch' => {
						'name' => q(ఘనపు అంగుళాలు),
						'one' => q({0} ఘనపు అంగుళం),
						'other' => q({0} ఘనపు అంగుళాలు),
					},
					'cubic-kilometer' => {
						'name' => q(క్యూబిక్ కిలోమీటర్లు),
						'one' => q({0} క్యూబిక్ కిలోమీటరు),
						'other' => q({0} క్యూబిక్ కిలోమీటర్లు),
					},
					'cubic-meter' => {
						'name' => q(క్యూబిక్ మీటర్లు),
						'one' => q({0} క్యూబిక్ మీటరు),
						'other' => q({0} క్యూబిక్ మీటర్లు),
						'per' => q(క్యూబిక్ మీటరుకు {0}),
					},
					'cubic-mile' => {
						'name' => q(క్యూబిక్ మైళ్లు),
						'one' => q({0} క్యూబిక్ మైలు),
						'other' => q({0} క్యూబిక్ మైళ్లు),
					},
					'cubic-yard' => {
						'name' => q(క్యూబిక్ గజాలు),
						'one' => q({0} క్యూబిక్ గజం),
						'other' => q({0} క్యూబిక్ గజాలు),
					},
					'cup' => {
						'name' => q(కప్పులు),
						'one' => q({0} కప్పు),
						'other' => q({0} కప్పులు),
					},
					'cup-metric' => {
						'name' => q(మెట్రిక్ కప్పులు),
						'one' => q({0} మెట్రిక్ కప్పు),
						'other' => q({0} మెట్రిక్ కప్పులు),
					},
					'day' => {
						'name' => q(రోజులు),
						'one' => q({0} రోజు),
						'other' => q({0} రోజులు),
						'per' => q(రోజుకు {0}),
					},
					'deciliter' => {
						'name' => q(డెసిలీటర్లు),
						'one' => q({0} డెసిలీటరు),
						'other' => q({0} డెసిలీటర్లు),
					},
					'decimeter' => {
						'name' => q(డెసిమీటర్లు),
						'one' => q({0} డెసిమీటరు),
						'other' => q({0} డెసిమీటర్లు),
					},
					'degree' => {
						'name' => q(డిగ్రీలు),
						'one' => q({0} డిగ్రీ),
						'other' => q({0} డిగ్రీలు),
					},
					'fahrenheit' => {
						'name' => q(డిగ్రీల ఫారెన్‌హీట్),
						'one' => q({0} డిగ్రీల ఫారెన్‌హీట్),
						'other' => q({0} డిగ్రీల ఫారెన్‌హీట్),
					},
					'fluid-ounce' => {
						'name' => q(ద్రవరూప ఔన్సులు),
						'one' => q({0} ద్రవరూప ఔన్సు),
						'other' => q({0} ద్రవరూప ఔన్సులు),
					},
					'foodcalorie' => {
						'name' => q(కేలరీలు),
						'one' => q({0} కేలరీ),
						'other' => q({0} కేలరీలు),
					},
					'foot' => {
						'name' => q(అడుగులు),
						'one' => q({0} అడుగు),
						'other' => q({0} అడుగులు),
						'per' => q(అడుగుకి {0}),
					},
					'furlong' => {
						'name' => q(ఫర్లాంగులు),
						'one' => q({0} ఫర్లాంగు),
						'other' => q({0} ఫర్లాంగులు),
					},
					'g-force' => {
						'name' => q(గు-శక్తి),
						'one' => q({0} గు-శక్తి),
						'other' => q({0} గు-శక్తి),
					},
					'gallon' => {
						'name' => q(గ్యాలన్లు),
						'one' => q({0} గ్యాలన్),
						'other' => q({0} గ్యాలన్లు),
						'per' => q(గ్యాలనుకు {0}),
					},
					'gallon-imperial' => {
						'name' => q(ఇంపీరియల్ గ్యాలన్లు),
						'one' => q({0} ఇంపీరియల్ గ్యాలన్),
						'other' => q({0} ఇంపీరియల్ గ్యాలన్లు),
						'per' => q(ఇంపీరియల్ గ్యాలనుకు {0}),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(గిగాబిట్లు),
						'one' => q({0} గిగాబిట్),
						'other' => q({0} గిగాబిట్లు),
					},
					'gigabyte' => {
						'name' => q(గిగాబైట్లు),
						'one' => q({0} గిగాబైట్),
						'other' => q({0} గిగాబైట్లు),
					},
					'gigahertz' => {
						'name' => q(గిగాహెర్ట్‌జ్),
						'one' => q({0} గిగాహెర్ట్‌జ్),
						'other' => q({0} గిగాహెర్ట్‌జ్),
					},
					'gigawatt' => {
						'name' => q(గిగావాట్లు),
						'one' => q({0} గిగావాట్),
						'other' => q({0} గిగావాట్లు),
					},
					'gram' => {
						'name' => q(గ్రాములు),
						'one' => q({0} గ్రాము),
						'other' => q({0} గ్రాములు),
						'per' => q(గ్రాముకు {0}),
					},
					'hectare' => {
						'name' => q(హెక్టార్లు),
						'one' => q({0} హెక్టారు),
						'other' => q({0} హెక్టార్లు),
					},
					'hectoliter' => {
						'name' => q(హెక్టాలీటర్లు),
						'one' => q({0} హెక్టాలీటరు),
						'other' => q({0} హెక్టాలీటర్లు),
					},
					'hectopascal' => {
						'name' => q(హెక్టోపాస్కల్‌లు),
						'one' => q({0} హెక్టోపాస్కల్),
						'other' => q({0} హెక్టోపాస్కల్‌లు),
					},
					'hertz' => {
						'name' => q(హెర్ట్‌జ్),
						'one' => q({0} హెర్ట్‌జ్),
						'other' => q({0} హెర్ట్‌జ్),
					},
					'horsepower' => {
						'name' => q(హార్స్‌పవర్),
						'one' => q({0} హార్స్‌పవర్),
						'other' => q({0} హార్స్‌పవర్),
					},
					'hour' => {
						'name' => q(గంటలు),
						'one' => q({0} గంట),
						'other' => q({0} గంటలు),
						'per' => q({0}/గంట),
					},
					'inch' => {
						'name' => q(అంగుళాలు),
						'one' => q({0} అంగుళం),
						'other' => q({0} అంగుళాలు),
						'per' => q(అంగుళానికి {0}),
					},
					'inch-hg' => {
						'name' => q(అంగుళాల పాదరసం),
						'one' => q({0} అంగుళం పాదరసం),
						'other' => q({0} అంగుళాల పాదరసం),
					},
					'joule' => {
						'name' => q(జౌల్స్),
						'one' => q({0} జౌల్),
						'other' => q({0} జౌల్స్),
					},
					'karat' => {
						'name' => q(కేరట్లు),
						'one' => q({0} కేరట్),
						'other' => q({0} కేరట్లు),
					},
					'kelvin' => {
						'name' => q(కెల్విన్స్),
						'one' => q({0} కెల్విన్),
						'other' => q({0} కెల్విన్స్),
					},
					'kilobit' => {
						'name' => q(కిలోబిట్లు),
						'one' => q({0} కిలోబిట్),
						'other' => q({0} కిలోబిట్లు),
					},
					'kilobyte' => {
						'name' => q(కిలోబైట్లు),
						'one' => q({0} కిలోబైట్),
						'other' => q({0} కిలోబైట్లు),
					},
					'kilocalorie' => {
						'name' => q(కిలోకేలరీలు),
						'one' => q({0} కిలోకేలరీ),
						'other' => q({0} కిలోకేలరీలు),
					},
					'kilogram' => {
						'name' => q(కిలోగ్రాములు),
						'one' => q({0} కిలోగ్రాము),
						'other' => q({0} కిలోగ్రాములు),
						'per' => q(కిలోగ్రాముకు {0}),
					},
					'kilohertz' => {
						'name' => q(కిలోహెర్ట్‌జ్),
						'one' => q({0} కిలోహెర్ట్‌జ్),
						'other' => q({0} కిలోహెర్ట్‌జ్),
					},
					'kilojoule' => {
						'name' => q(కిలోజౌల్స్),
						'one' => q({0} కిలోజౌల్),
						'other' => q({0} కిలోజౌల్స్),
					},
					'kilometer' => {
						'name' => q(కిలోమీటర్లు),
						'one' => q({0} కిలోమీటరు),
						'other' => q({0} కిలోమీటర్లు),
						'per' => q(కిలోమీటరుకు {0}),
					},
					'kilometer-per-hour' => {
						'name' => q(కిలోమీటర్లు/గంట),
						'one' => q(గంటకు {0} కిలోమీటరు),
						'other' => q(గంటకు {0} కిలోమీటర్లు),
					},
					'kilowatt' => {
						'name' => q(కిలోవాట్లు),
						'one' => q({0} కిలోవాట్),
						'other' => q({0} కిలోవాట్లు),
					},
					'kilowatt-hour' => {
						'name' => q(కిలోవాట్-గంటలు),
						'one' => q({0} కిలోవాట్ గంట),
						'other' => q({0} కిలోవాట్-గంటలు),
					},
					'knot' => {
						'name' => q(నాట్),
						'one' => q({0} నాట్),
						'other' => q({0} నాట్‌లు),
					},
					'light-year' => {
						'name' => q(కాంతి సంవత్సరాలు),
						'one' => q({0} కాంతి సంవత్సరం),
						'other' => q({0} కాంతి సంవత్సరాలు),
					},
					'liter' => {
						'name' => q(లీటర్లు),
						'one' => q({0} లీటరు),
						'other' => q({0} లీటర్లు),
						'per' => q(లీటరుకు {0}),
					},
					'liter-per-100kilometers' => {
						'name' => q(లీటర్లు/100 కీలోమీటర్లు),
						'one' => q({0} లీటరు/100 కీలోమీటర్లు),
						'other' => q({0} లీటర్లు/100 కీలోమీటర్లు),
					},
					'liter-per-kilometer' => {
						'name' => q(లీటర్లు/కిలోమీటరు),
						'one' => q({0} లీటరు/కిలోమీటరు),
						'other' => q({0} లీటర్లు/కిలోమీటరు),
					},
					'lux' => {
						'name' => q(లక్స్),
						'one' => q({0} లక్స్),
						'other' => q({0} లక్స్),
					},
					'megabit' => {
						'name' => q(మెగాబిట్లు),
						'one' => q({0} మెగాబిట్),
						'other' => q({0} మెగాబిట్లు),
					},
					'megabyte' => {
						'name' => q(మెగాబైట్లు),
						'one' => q({0} మెగాబైట్),
						'other' => q({0} మెగాబైట్లు),
					},
					'megahertz' => {
						'name' => q(మెగాహెర్ట్‌జ్),
						'one' => q({0} మెగాహెర్ట్‌జ్),
						'other' => q({0} మెగాహెర్ట్‌జ్),
					},
					'megaliter' => {
						'name' => q(మెగాలీటర్లు),
						'one' => q({0} మెగాలీటరు),
						'other' => q({0} మెగాలీటర్లు),
					},
					'megawatt' => {
						'name' => q(మెగావాట్లు),
						'one' => q({0} మెగావాట్),
						'other' => q({0} మెగావాట్లు),
					},
					'meter' => {
						'name' => q(మీటర్లు),
						'one' => q({0} మీటరు),
						'other' => q({0} మీటర్లు),
						'per' => q(మీటరుకు {0}),
					},
					'meter-per-second' => {
						'name' => q(మీటర్లు/సెకను),
						'one' => q(సెకనుకు {0} మీటరు),
						'other' => q(సెకనుకు {0} మీటర్లు),
					},
					'meter-per-second-squared' => {
						'name' => q(మీటర్లు/స్క్వేర్ సెకన్లు),
						'one' => q({0} మీటరు/స్క్వేర్ సెకను),
						'other' => q({0} మీటర్లు/స్క్వేర్ సెకన్లు),
					},
					'metric-ton' => {
						'name' => q(మెట్రిక్ టన్నులు),
						'one' => q({0} మెట్రిక్ టన్ను),
						'other' => q({0} మెట్రిక్ టన్నులు),
					},
					'microgram' => {
						'name' => q(మైక్రోగ్రాములు),
						'one' => q({0} మైక్రోగ్రాము),
						'other' => q({0} మైక్రోగ్రాములు),
					},
					'micrometer' => {
						'name' => q(మైక్రోమీటర్లు),
						'one' => q({0} మైక్రోమీటరు),
						'other' => q({0} మైక్రోమీటర్లు),
					},
					'microsecond' => {
						'name' => q(మైక్రోసెకన్లు),
						'one' => q({0} మైక్రోసెకను),
						'other' => q({0} మైక్రోసెకన్లు),
					},
					'mile' => {
						'name' => q(మైళ్లు),
						'one' => q({0} మైలు),
						'other' => q({0} మైళ్లు),
					},
					'mile-per-gallon' => {
						'name' => q(మైళ్లు/గ్యాలన్),
						'one' => q({0} మైలు/గ్యాలన్),
						'other' => q({0} మైళ్లు/గ్యాలన్),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(మైళ్లు/ఇంపీరియల్ గ్యాలన్),
						'one' => q({0} మైలు/ఇంపీరియల్ గ్యాలన్),
						'other' => q({0} మైళ్లు/ఇంపీరియల్ గ్యాలన్),
					},
					'mile-per-hour' => {
						'name' => q(గంటకు మైళ్లు),
						'one' => q(గంటకు {0} మైలు),
						'other' => q(గంటకు {0} మైళ్లు),
					},
					'mile-scandinavian' => {
						'name' => q(స్కాండినేవియన్ మైలు),
						'one' => q({0} స్కాండినేవియన్ మైలు),
						'other' => q({0} స్కాండినేవియన్ మైళ్లు),
					},
					'milliampere' => {
						'name' => q(మిల్లీ ఆంపియర్స్),
						'one' => q({0} మిల్లీ ఆంపియర్),
						'other' => q({0} మిల్లీ ఆంపియర్స్),
					},
					'millibar' => {
						'name' => q(మిల్లీబార్‌లు),
						'one' => q({0} మిల్లీబార్),
						'other' => q({0} మిల్లీబార్‌లు),
					},
					'milligram' => {
						'name' => q(మిల్లీగ్రాములు),
						'one' => q({0} మిల్లీగ్రాము),
						'other' => q({0} మిల్లీగ్రాములు),
					},
					'milligram-per-deciliter' => {
						'name' => q(మిల్లీగ్రాములు/డెసిలీటర్),
						'one' => q({0} మిల్లీగ్రాము/డెసిలీటర్),
						'other' => q({0} మిల్లీగ్రాములు/డెసిలీటర్),
					},
					'milliliter' => {
						'name' => q(మిల్లీలీటర్లు),
						'one' => q({0} మిల్లీలీటరు),
						'other' => q({0} మిల్లీలీటర్లు),
					},
					'millimeter' => {
						'name' => q(మిల్లీమీటర్లు),
						'one' => q({0} మిల్లీమీటరు),
						'other' => q({0} మిల్లీమీటర్లు),
					},
					'millimeter-of-mercury' => {
						'name' => q(మిల్లీమీటర్ల పాదరసం),
						'one' => q({0} మిల్లీమీటర్ పాదరసం),
						'other' => q({0} మిల్లీమీటర్ల పాదరసం),
					},
					'millimole-per-liter' => {
						'name' => q(మిల్లీమోల్‌లు/లీటర్),
						'one' => q({0} మిల్లీమోల్‌/లీటర్),
						'other' => q({0} మిల్లీమోల్‌లు/లీటర్),
					},
					'millisecond' => {
						'name' => q(మిల్లీసెకన్లు),
						'one' => q({0} మిల్లీసెకను),
						'other' => q({0} మిల్లీసెకన్లు),
					},
					'milliwatt' => {
						'name' => q(మిల్లీవాట్లు),
						'one' => q({0} మిల్లీవాట్),
						'other' => q({0} మిల్లీవాట్లు),
					},
					'minute' => {
						'name' => q(నిమిషాలు),
						'one' => q({0} నిమిషం),
						'other' => q({0} నిమిషాలు),
						'per' => q(నిమిషానికి {0}),
					},
					'month' => {
						'name' => q(నెలలు),
						'one' => q({0} నెల),
						'other' => q({0} నెలలు),
						'per' => q(నెలకు {0}),
					},
					'nanometer' => {
						'name' => q(నానోమీటర్లు),
						'one' => q({0} నానోమీటరు),
						'other' => q({0} నానోమీటర్లు),
					},
					'nanosecond' => {
						'name' => q(నానోసెకన్లు),
						'one' => q({0} నానోసెకను),
						'other' => q({0} నానోసెకన్లు),
					},
					'nautical-mile' => {
						'name' => q(నాటికల్ మైళ్లు),
						'one' => q({0} నాటికల్ మైలు),
						'other' => q({0} నాటికల్ మైళ్లు),
					},
					'ohm' => {
						'name' => q(ఓమ్స్),
						'one' => q({0} ఓమ్),
						'other' => q({0} ఓమ్స్),
					},
					'ounce' => {
						'name' => q(ఔన్సులు),
						'one' => q({0} ఔన్సు),
						'other' => q({0} ఔన్సులు),
						'per' => q(ఔన్సుకు {0}),
					},
					'ounce-troy' => {
						'name' => q(ట్రాయ్ ఔన్సులు),
						'one' => q({0} ట్రాయ్ ఔన్సు),
						'other' => q({0} ట్రాయ్ ఔన్సులు),
					},
					'parsec' => {
						'name' => q(పార్సెక్‌లు),
						'one' => q({0} పార్సెక్),
						'other' => q({0} పార్సెక్‌లు),
					},
					'part-per-million' => {
						'name' => q(భాగాలు/మిలియన్),
						'one' => q({0} భాగం/మిలియన్),
						'other' => q({0} భాగాలు/మిలియన్),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(శాతం),
						'one' => q({0} శాతం),
						'other' => q({0} శాతం),
					},
					'permille' => {
						'name' => q(మైలుకు),
						'one' => q({0}/మైలుకు),
						'other' => q({0}/మైలుకు),
					},
					'petabyte' => {
						'name' => q(పెటాబైట్లు),
						'one' => q({0} పెటాబైట్),
						'other' => q({0} పెటాబైట్లు),
					},
					'picometer' => {
						'name' => q(పికోమీటర్లు),
						'one' => q({0} పికోమీటరు),
						'other' => q({0} పికోమీటర్లు),
					},
					'pint' => {
						'name' => q(పింట్లు),
						'one' => q({0} పింట్),
						'other' => q({0} పింట్లు),
					},
					'pint-metric' => {
						'name' => q(మెట్రిక్ పింట్లు),
						'one' => q({0} మెట్రిక్ పింటు),
						'other' => q({0} మెట్రిక్ పింట్లు),
					},
					'point' => {
						'name' => q(పాయింట్‌లు),
						'one' => q({0} పాయింట్),
						'other' => q({0} పాయింట్‌లు),
					},
					'pound' => {
						'name' => q(పౌండ్లు),
						'one' => q({0} పౌండు),
						'other' => q({0} పౌండ్లు),
						'per' => q(పౌండుకు {0}),
					},
					'pound-per-square-inch' => {
						'name' => q(చదరపు అంగుళానికి పౌండ్లు),
						'one' => q(చదరపు అంగుళానికి {0} పౌండు),
						'other' => q(చదరపు అంగుళానికి {0} పౌండ్లు),
					},
					'quart' => {
						'name' => q(పావు వంతులు),
						'one' => q({0} పావు వంతు),
						'other' => q({0} పావు వంతులు),
					},
					'radian' => {
						'name' => q(రేడియన్లు),
						'one' => q({0} రేడియన్),
						'other' => q({0} రేడియన్లు),
					},
					'revolution' => {
						'name' => q(భ్రమణాలు),
						'one' => q({0} భ్రమణం),
						'other' => q({0} భ్రమణాలు),
					},
					'second' => {
						'name' => q(సెకన్లు),
						'one' => q({0} సెకను),
						'other' => q({0} సెకన్లు),
						'per' => q(సెకనుకు {0}),
					},
					'square-centimeter' => {
						'name' => q(చదరపు సెంటీమీటర్లు),
						'one' => q({0} చదరపు సెంటీమీటరు),
						'other' => q({0} చదరపు సెంటీమీటర్లు),
						'per' => q(చదరపు సెంటీమీటరుకు {0}),
					},
					'square-foot' => {
						'name' => q(చదరపు అడుగులు),
						'one' => q({0} చదరపు అడుగు),
						'other' => q({0} చదరపు అడుగులు),
					},
					'square-inch' => {
						'name' => q(చదరపు అంగుళాలు),
						'one' => q({0} చదరపు అంగుళం),
						'other' => q({0} చదరపు అంగుళాలు),
						'per' => q(చదరపు అంగుళానికి {0}),
					},
					'square-kilometer' => {
						'name' => q(చదరపు కిలోమీటర్లు),
						'one' => q({0} చదరపు కిలోమీటరు),
						'other' => q({0} చదరపు కిలోమీటర్లు),
						'per' => q(చదరపు కిలోమీటరుకు {0}),
					},
					'square-meter' => {
						'name' => q(చదరపు మీటర్లు),
						'one' => q({0} చదరపు మీటరు),
						'other' => q({0} చదరపు మీటర్లు),
						'per' => q(చదరపు మీటరుకు {0}),
					},
					'square-mile' => {
						'name' => q(చదరపు మైళ్లు),
						'one' => q({0} చదరపు మైలు),
						'other' => q({0} చదరపు మైళ్లు),
						'per' => q(చదరపు మైలుకు {0}),
					},
					'square-yard' => {
						'name' => q(చదరపు గజాలు),
						'one' => q({0} చదరపు గజం),
						'other' => q({0} చదరపు గజాలు),
					},
					'stone' => {
						'name' => q(స్టోన్లు),
						'one' => q({0} స్టోను),
						'other' => q({0} స్టోన్లు),
					},
					'tablespoon' => {
						'name' => q(టేబుల్ స్పూన్లు),
						'one' => q({0} టేబుల్ స్పూన్),
						'other' => q({0} టేబుల్ స్పూన్లు),
					},
					'teaspoon' => {
						'name' => q(టీ స్పూన్లు),
						'one' => q({0} టీ స్పూన్),
						'other' => q({0} టీ స్పూన్లు),
					},
					'terabit' => {
						'name' => q(టెరాబిట్లు),
						'one' => q({0} టెరాబిట్),
						'other' => q({0} టెరాబిట్లు),
					},
					'terabyte' => {
						'name' => q(టెరాబైట్లు),
						'one' => q({0} టెరాబైట్),
						'other' => q({0} టెరాబైట్లు),
					},
					'ton' => {
						'name' => q(టన్నులు),
						'one' => q({0} టన్ను),
						'other' => q({0} టన్నులు),
					},
					'volt' => {
						'name' => q(వోల్ట్స్),
						'one' => q({0} వోల్ట్),
						'other' => q({0} వోల్ట్స్),
					},
					'watt' => {
						'name' => q(వాట్లు),
						'one' => q({0} వాట్),
						'other' => q({0} వాట్లు),
					},
					'week' => {
						'name' => q(వారాలు),
						'one' => q({0} వారం),
						'other' => q({0} వారాలు),
						'per' => q(వారానికి {0}),
					},
					'yard' => {
						'name' => q(గజాలు),
						'one' => q({0} గజం),
						'other' => q({0} గజాలు),
					},
					'year' => {
						'name' => q(సంవత్సరాలు),
						'one' => q({0} సంవత్సరం),
						'other' => q({0} సంవత్సరాలు),
						'per' => q(సంవత్సరానికి {0}),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(దిశ),
					},
					'acre' => {
						'one' => q({0} ఎక.),
						'other' => q({0} ఎక.),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'name' => q(°సెల్సి),
						'one' => q({0}°సెల్సి),
						'other' => q({0}°సెల్సి),
					},
					'centimeter' => {
						'name' => q(సెం.మీ),
						'one' => q({0}సెం.మీ),
						'other' => q({0}సెం.మీ),
						'per' => q({0}/సెం.మీ.),
					},
					'coordinate' => {
						'east' => q({0} తూ.),
						'north' => q({0} ఉ.),
						'south' => q({0} ద.),
						'west' => q({0} ప.),
					},
					'cubic-kilometer' => {
						'one' => q({0} కిమీ³),
						'other' => q({0} కిమీ³),
					},
					'cubic-mile' => {
						'one' => q({0} మై³),
						'other' => q({0} మై³),
					},
					'day' => {
						'name' => q(రోజు),
						'one' => q({0}రో),
						'other' => q({0}రో),
						'per' => q({0}/రో),
					},
					'decimeter' => {
						'name' => q(డె.మీ.),
						'one' => q({0} డె.మీ.),
						'other' => q({0} డె.మీ.),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'name' => q(°ఫా),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'name' => q(అడుగులు),
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0}/అ.),
					},
					'g-force' => {
						'one' => q({0} గు),
						'other' => q({0} గు),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gram' => {
						'name' => q(గ్రాము),
						'one' => q({0}గ్రా),
						'other' => q({0}గ్రా),
						'per' => q({0}/గ్రా.),
					},
					'hectare' => {
						'one' => q({0} హె.),
						'other' => q({0} హె.),
					},
					'hectopascal' => {
						'name' => q(హె.పా),
						'one' => q({0} హె.పా),
						'other' => q({0} హె.పా),
					},
					'horsepower' => {
						'one' => q({0} హా.ప),
						'other' => q({0} హా.ప),
					},
					'hour' => {
						'name' => q(గంట),
						'one' => q({0}గం),
						'other' => q({0}గం),
						'per' => q({0}/గం),
					},
					'inch' => {
						'name' => q(అంగుళాలు),
						'one' => q({0}″),
						'other' => q({0}″),
						'per' => q({0}/అం.),
					},
					'inch-hg' => {
						'name' => q(అం.పాద),
						'one' => q({0} అం.పాద),
						'other' => q({0} అం.పాద),
					},
					'kelvin' => {
						'name' => q(కె),
						'one' => q({0} కె),
						'other' => q({0} కె),
					},
					'kilogram' => {
						'name' => q(కి.గ్రా),
						'one' => q({0}కి.గ్రా),
						'other' => q({0}కి.గ్రా),
						'per' => q({0}/కి.గ్రా.),
					},
					'kilometer' => {
						'name' => q(కి.మీ),
						'one' => q({0}కి.మీ),
						'other' => q({0}కి.మీ),
						'per' => q({0}/కి.మీ.),
					},
					'kilometer-per-hour' => {
						'name' => q(కి.మీ/గం),
						'one' => q({0}కి.మీ/గం),
						'other' => q({0}కి.మీ/గం),
					},
					'kilowatt' => {
						'one' => q({0} కి.వా),
						'other' => q({0} కి.వా),
					},
					'light-year' => {
						'one' => q({0} కాం. సం),
						'other' => q({0} కాం. సం),
					},
					'liter' => {
						'name' => q(లీటరు),
						'one' => q({0}లీ),
						'other' => q({0}లీ),
					},
					'liter-per-100kilometers' => {
						'name' => q(లీ/100కి.మీ.),
						'one' => q({0}లీ/100కి.మీ.),
						'other' => q({0}లీ/100కి.మీ.),
					},
					'meter' => {
						'name' => q(మీటరు),
						'one' => q({0}మీ),
						'other' => q({0}మీ),
						'per' => q({0}/మీ.),
					},
					'meter-per-second' => {
						'name' => q(మీటర్లు/సెక.),
						'one' => q({0} మీ/సె),
						'other' => q({0} మీ/సె),
					},
					'mile' => {
						'name' => q(మైళ్లు),
						'one' => q({0} మై),
						'other' => q({0} మై),
					},
					'mile-per-hour' => {
						'name' => q(మైళ్లు/గంట),
						'one' => q({0} మై/గం.),
						'other' => q({0} మై/గం.),
					},
					'mile-scandinavian' => {
						'name' => q(స్కాం.మై.),
						'one' => q({0} స్కాం.మై.),
						'other' => q({0} స్కాం.మై.),
					},
					'millibar' => {
						'name' => q(మి.బార్),
						'one' => q({0} మి.బార్),
						'other' => q({0} మి.బార్),
					},
					'millimeter' => {
						'name' => q(మి.మీ),
						'one' => q({0}మి.మీ),
						'other' => q({0}మి.మీ),
					},
					'millimeter-of-mercury' => {
						'name' => q(మిమీ. పాద),
						'one' => q({0} మిమీ. పాద),
						'other' => q({0} మిమీ. పాద),
					},
					'millisecond' => {
						'name' => q(మి.సె.),
						'one' => q({0}మి.సె),
						'other' => q({0}మి.సె),
					},
					'minute' => {
						'name' => q(నిమి),
						'one' => q({0}ని),
						'other' => q({0}ని),
						'per' => q({0}/నిమి.),
					},
					'month' => {
						'name' => q(నెల),
						'one' => q({0}నె),
						'other' => q({0}నె),
					},
					'ounce' => {
						'name' => q(ఔ.),
						'one' => q({0} ఔ.),
						'other' => q({0} ఔ.),
						'per' => q({0}/ ఔ.),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'picometer' => {
						'one' => q({0} పి.మీ),
						'other' => q({0} పి.మీ),
					},
					'pound' => {
						'name' => q(పౌండ్లు),
						'one' => q({0} పౌ.),
						'other' => q({0} పౌ.),
						'per' => q({0}/పౌ.),
					},
					'pound-per-square-inch' => {
						'name' => q(పౌ/చ.అం),
						'one' => q({0} పౌ/చ.అం),
						'other' => q({0} పౌ/చ.అం),
					},
					'second' => {
						'name' => q(సె),
						'one' => q({0}సె),
						'other' => q({0}సె),
						'per' => q({0}/సె),
					},
					'square-foot' => {
						'one' => q({0} అ²),
						'other' => q({0} అ²),
					},
					'square-kilometer' => {
						'one' => q({0} కి.మీ²),
						'other' => q({0} కి.మీ²),
					},
					'square-meter' => {
						'one' => q({0} మీ²),
						'other' => q({0} మీ²),
					},
					'square-mile' => {
						'one' => q({0} మై²),
						'other' => q({0} మై²),
					},
					'stone' => {
						'name' => q(స్టోను),
						'one' => q({0} స్టో),
						'other' => q({0} స్టో),
					},
					'ton' => {
						'one' => q({0} ట),
						'other' => q({0} ట),
					},
					'watt' => {
						'one' => q({0} వా.),
						'other' => q({0} వా.),
					},
					'week' => {
						'name' => q(వా),
						'one' => q({0}వా),
						'other' => q({0}వా),
					},
					'yard' => {
						'name' => q(గజాలు),
						'one' => q({0} గ.),
						'other' => q({0} గ.),
					},
					'year' => {
						'name' => q(సం),
						'one' => q({0}సం),
						'other' => q({0}సం),
					},
				},
				'short' => {
					'' => {
						'name' => q(దిశ),
					},
					'acre' => {
						'name' => q(ఎకరాలు),
						'one' => q({0} ఎక.),
						'other' => q({0} ఎక.),
					},
					'acre-foot' => {
						'name' => q(ఎ.అ.),
						'one' => q({0} ఎ.అ.),
						'other' => q({0} ఎ.అ.),
					},
					'ampere' => {
						'name' => q(ఆంప్స్),
						'one' => q({0} ఆం),
						'other' => q({0} ఆం),
					},
					'arc-minute' => {
						'name' => q(ఆర్క్ నిమి.),
						'one' => q({0} ఆర్క్ నిమి.),
						'other' => q({0} ఆర్క్ నిమి.),
					},
					'arc-second' => {
						'name' => q(ఆర్క్ సెక.),
						'one' => q({0} ఆర్క్ సెక.),
						'other' => q({0} ఆర్క్ సెక.),
					},
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q(au),
						'other' => q({0} au),
					},
					'atmosphere' => {
						'name' => q(వాతావ),
						'one' => q({0} వాతావ),
						'other' => q({0} వాతావ),
					},
					'bit' => {
						'name' => q(బిట్),
						'one' => q({0} బి),
						'other' => q({0} బి),
					},
					'byte' => {
						'name' => q(బైట్),
						'one' => q({0} బై),
						'other' => q({0} బై),
					},
					'calorie' => {
						'name' => q(కే),
						'one' => q({0} కే.),
						'other' => q({0} కే.),
					},
					'carat' => {
						'name' => q(క్యారెట్లు),
						'one' => q({0} క్యారె.),
						'other' => q({0} క్యారె.),
					},
					'celsius' => {
						'name' => q(డి.సెల్సి),
						'one' => q({0}°సెల్సి),
						'other' => q({0}°సెల్సి),
					},
					'centiliter' => {
						'name' => q(సె.లీ.),
						'one' => q({0} సె.లీ.),
						'other' => q({0} సె.లీ.),
					},
					'centimeter' => {
						'name' => q(సెం.మీ.),
						'one' => q({0} సెం.మీ.),
						'other' => q({0} సెం.మీ.),
						'per' => q({0}/సెం.మీ.),
					},
					'century' => {
						'name' => q(శ),
						'one' => q({0} శ),
						'other' => q({0} శ),
					},
					'coordinate' => {
						'east' => q({0} తూ.),
						'north' => q({0} ఉ.),
						'south' => q({0} ద.),
						'west' => q({0} ప.),
					},
					'cubic-centimeter' => {
						'name' => q(సెం.మీ³),
						'one' => q({0} సెం.మీ³),
						'other' => q({0} సెం.మీ³),
						'per' => q({0}/సెం.మీ³),
					},
					'cubic-foot' => {
						'name' => q(అ³),
						'one' => q({0} అ³),
						'other' => q({0} అ³),
					},
					'cubic-inch' => {
						'name' => q(అం³),
						'one' => q({0} అం³),
						'other' => q({0} అం³),
					},
					'cubic-kilometer' => {
						'name' => q(కి.మీ³),
						'one' => q({0} కి.మీ³),
						'other' => q({0} కి.మీ³),
					},
					'cubic-meter' => {
						'name' => q(మీ³),
						'one' => q({0} మీ³),
						'other' => q({0} మీ³),
						'per' => q({0}/మీ³),
					},
					'cubic-mile' => {
						'name' => q(మై³),
						'one' => q({0} మై³),
						'other' => q({0} మై³),
					},
					'cubic-yard' => {
						'name' => q(గజాలు³),
						'one' => q({0} గ³),
						'other' => q({0} గ³),
					},
					'cup' => {
						'name' => q(కప్పులు),
						'one' => q({0} క.),
						'other' => q({0} క.),
					},
					'cup-metric' => {
						'name' => q(మె.కప్పు),
						'one' => q({0}/మె.క.),
						'other' => q({0}/మె.క.),
					},
					'day' => {
						'name' => q(రోజులు),
						'one' => q({0} రోజు),
						'other' => q({0} రోజులు),
						'per' => q({0}/రో),
					},
					'deciliter' => {
						'name' => q(డె.లీ.),
						'one' => q({0} డె.లీ.),
						'other' => q({0} డె.లీ.),
					},
					'decimeter' => {
						'name' => q(డె.మీ.),
						'one' => q({0} డె.మీ.),
						'other' => q({0} డె.మీ.),
					},
					'degree' => {
						'name' => q(డిగ్రీలు),
						'one' => q({0} డి.),
						'other' => q({0} డి.),
					},
					'fahrenheit' => {
						'name' => q(డి.ఫా),
						'one' => q({0}°ఫా),
						'other' => q({0}°ఫా),
					},
					'fluid-ounce' => {
						'name' => q(ద్ర.ఔ.),
						'one' => q({0} ద్ర.ఔ.),
						'other' => q({0} ద్ర.ఔ.),
					},
					'foodcalorie' => {
						'name' => q(కే.),
						'one' => q({0} కే.),
						'other' => q({0} కే.),
					},
					'foot' => {
						'name' => q(అడుగులు),
						'one' => q({0} అ.),
						'other' => q({0} అ.),
						'per' => q({0}/అ.),
					},
					'furlong' => {
						'name' => q(ఫర్లాంగులు),
					},
					'g-force' => {
						'name' => q(గు-శక్తి),
						'one' => q({0} గు),
						'other' => q({0} గు),
					},
					'gallon' => {
						'name' => q(గ్యా.),
						'one' => q({0} గ్యా.),
						'other' => q({0} గ్యా.),
						'per' => q({0}/గ్యా.),
					},
					'gallon-imperial' => {
						'name' => q(ఇంపీరియల్ గ్యా.),
						'one' => q({0} గ్యా. ఇంపీరియల్),
						'other' => q({0} గ్యా. ఇంపీరియల్),
						'per' => q({0}/ గ్యా. ఇంపీరియల్),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(గి.బిట్),
						'one' => q({0} గి.బిట్),
						'other' => q({0} గి.బిట్లు),
					},
					'gigabyte' => {
						'name' => q(గి.బైట్),
						'one' => q({0} జీబీ),
						'other' => q({0} జీబీ),
					},
					'gigahertz' => {
						'name' => q(గిగా హెడ్జ్),
						'one' => q({0} గిగా హెడ్జ్),
						'other' => q({0} గిగా హెడ్జ్),
					},
					'gigawatt' => {
						'name' => q(గి.వా),
						'one' => q({0} గి.వా),
						'other' => q({0} గి.వా),
					},
					'gram' => {
						'name' => q(గ్రాములు),
						'one' => q({0} గ్రా.),
						'other' => q({0} గ్రా.),
						'per' => q({0}/గ్రా.),
					},
					'hectare' => {
						'name' => q(హెక్టార్లు),
						'one' => q({0} హె.),
						'other' => q({0} హె.),
					},
					'hectoliter' => {
						'name' => q(హె.లీ.),
						'one' => q({0} హె.లీ.),
						'other' => q({0} హె.లీ.),
					},
					'hectopascal' => {
						'name' => q(హె.పా),
						'one' => q({0} హె.పా),
						'other' => q({0} హె.పా),
					},
					'hertz' => {
						'name' => q(హెర్ట్‌జ్),
						'one' => q({0} హెర్ట్‌జ్),
						'other' => q({0} హెర్ట్‌జ్),
					},
					'horsepower' => {
						'name' => q(హా.ప),
						'one' => q({0} హా.ప),
						'other' => q({0} హా.ప),
					},
					'hour' => {
						'name' => q(గంటలు),
						'one' => q({0} గం.),
						'other' => q({0} గం.),
						'per' => q({0}/గం),
					},
					'inch' => {
						'name' => q(అంగుళాలు),
						'one' => q({0} అం.),
						'other' => q({0} అం.),
						'per' => q({0}/అం.),
					},
					'inch-hg' => {
						'name' => q(అం.పాద),
						'one' => q({0} అం.పాద),
						'other' => q({0} అం.పాద),
					},
					'joule' => {
						'name' => q(జౌల్స్),
						'one' => q({0} జౌ.),
						'other' => q({0} జౌ.),
					},
					'karat' => {
						'name' => q(కేరట్లు),
						'one' => q({0} కేర.),
						'other' => q({0} కేర.),
					},
					'kelvin' => {
						'name' => q(కె),
						'one' => q({0} కె),
						'other' => q({0} కె),
					},
					'kilobit' => {
						'name' => q(కి.బిట్),
						'one' => q({0} కి.బిట్),
						'other' => q({0} కి.బిట్లు),
					},
					'kilobyte' => {
						'name' => q(కి.బైట్),
						'one' => q({0} కేబీ),
						'other' => q({0} కేబీ),
					},
					'kilocalorie' => {
						'name' => q(కి.కే),
						'one' => q({0} కి.కే),
						'other' => q({0} కి.కే),
					},
					'kilogram' => {
						'name' => q(కి.గ్రా.),
						'one' => q({0} కి.గ్రా.),
						'other' => q({0} కి.గ్రా.),
						'per' => q({0}/కి.గ్రా.),
					},
					'kilohertz' => {
						'name' => q(కి.హె),
						'one' => q({0} కి.హె),
						'other' => q({0} కి.హె),
					},
					'kilojoule' => {
						'name' => q(కిలోజౌల్),
						'one' => q({0} కి.జౌ),
						'other' => q({0} కి.జౌ),
					},
					'kilometer' => {
						'name' => q(కి.మీ.),
						'one' => q({0} కి.మీ.),
						'other' => q({0} కి.మీ.),
						'per' => q({0}/కి.మీ.),
					},
					'kilometer-per-hour' => {
						'name' => q(కి.మీ/గంట),
						'one' => q({0} కి.మీ/గం),
						'other' => q({0} కి.మీ/గం),
					},
					'kilowatt' => {
						'name' => q(కి.వా),
						'one' => q({0} కి.వా),
						'other' => q({0} కి.వా),
					},
					'kilowatt-hour' => {
						'name' => q(కి.వా. గంట),
						'one' => q({0} కి.వా.గం),
						'other' => q({0} కి.వా.గం),
					},
					'knot' => {
						'name' => q(నా.),
						'one' => q({0} నా.),
						'other' => q({0} నా.),
					},
					'light-year' => {
						'name' => q(కాంతి సం.),
						'one' => q({0} కాం. సం),
						'other' => q({0} కాం. సం),
					},
					'liter' => {
						'name' => q(లీటర్లు),
						'one' => q({0} లీ.),
						'other' => q({0} లీ.),
						'per' => q({0}/లీ.),
					},
					'liter-per-100kilometers' => {
						'name' => q(లీ/100 కి.మీ.),
						'one' => q({0} లీ/100 కి.మీ.),
						'other' => q({0} లీ/100 కి.మీ.),
					},
					'liter-per-kilometer' => {
						'name' => q(లీటర్లు/కి.మీ),
						'one' => q({0} లీ./కి.మీ),
						'other' => q({0} లీ./కి.మీ),
					},
					'lux' => {
						'name' => q(లక్స్),
						'one' => q({0} ల.),
						'other' => q({0} ల.),
					},
					'megabit' => {
						'name' => q(మె.బిట్),
						'one' => q({0} మె.బిట్),
						'other' => q({0} మె.బిట్లు),
					},
					'megabyte' => {
						'name' => q(మె.బైట్),
						'one' => q({0} ఎమ్‌బి),
						'other' => q({0} ఎమ్‌బి),
					},
					'megahertz' => {
						'name' => q(మె.హె),
						'one' => q({0} మె.హె),
						'other' => q({0} మె.హె),
					},
					'megaliter' => {
						'name' => q(మె.లీ.),
						'one' => q({0} మె.లీ.),
						'other' => q({0} మె.లీ.),
					},
					'megawatt' => {
						'name' => q(మె.వా),
						'one' => q({0} మె.వా),
						'other' => q({0} మె.వా),
					},
					'meter' => {
						'name' => q(మీటర్లు),
						'one' => q({0} మీ.),
						'other' => q({0} మీ.),
						'per' => q({0}/మీ.),
					},
					'meter-per-second' => {
						'name' => q(మీటర్లు/సెక.),
						'one' => q({0} మీ/సె),
						'other' => q({0} మీ/సె),
					},
					'meter-per-second-squared' => {
						'name' => q(మీటర్లు/సెక²),
						'one' => q({0} మీ/సె²),
						'other' => q({0} మీ/సె²),
					},
					'metric-ton' => {
						'name' => q(ట),
						'one' => q({0} ట),
						'other' => q({0} ట),
					},
					'microgram' => {
						'name' => q(మై.గ్రా.),
						'one' => q({0} మై.గ్రా.),
						'other' => q({0} మై.గ్రా.),
					},
					'micrometer' => {
						'name' => q(మై.మీటర్లు),
						'one' => q({0} మై.మీ.),
						'other' => q({0} మై.మీ.),
					},
					'microsecond' => {
						'name' => q(మై.సె.),
						'one' => q({0} మై.సె),
						'other' => q({0} మై.సె),
					},
					'mile' => {
						'name' => q(మైళ్లు),
						'one' => q({0} మై.),
						'other' => q({0} మై.),
					},
					'mile-per-gallon' => {
						'name' => q(మైళ్లు/గ్యా.),
						'one' => q({0} మై./గ్యా.),
						'other' => q({0} మై./గ్యా.),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(మైళ్లు/గ్యా. ఇంపీరియల్),
						'one' => q({0} మై./గ్యా. ఇంపీరియల్),
						'other' => q({0} మై./గ్యా. ఇంపీరియల్),
					},
					'mile-per-hour' => {
						'name' => q(మైళ్లు/గంట),
						'one' => q({0} మై/గం),
						'other' => q({0} మై/గం),
					},
					'mile-scandinavian' => {
						'name' => q(స్కాం.మై.),
						'one' => q({0} స్కాం.మై.),
						'other' => q({0} స్కాం.మై.),
					},
					'milliampere' => {
						'name' => q(మిల్లీ ఆంప్స్),
						'one' => q({0} మి. ఆం),
						'other' => q({0} మి. ఆం),
					},
					'millibar' => {
						'name' => q(మి.బార్),
						'one' => q({0} మి.బార్),
						'other' => q({0} మి.బార్),
					},
					'milligram' => {
						'name' => q(మి.గ్రా.),
						'one' => q({0} మి.గ్రా.),
						'other' => q({0} మి.గ్రా.),
					},
					'milligram-per-deciliter' => {
						'name' => q(మి.గ్రా./డె.లీ.),
						'one' => q({0} మి.గ్రా./డె.లీ.),
						'other' => q({0} మి.గ్రా./డె.లీ.),
					},
					'milliliter' => {
						'name' => q(మి.లీ.),
						'one' => q({0} మి.లీ.),
						'other' => q({0} మి.లీ.),
					},
					'millimeter' => {
						'name' => q(మి.మీ.),
						'one' => q({0} మి.మీ.),
						'other' => q({0} మి.మీ.),
					},
					'millimeter-of-mercury' => {
						'name' => q(మిమీ. పాద),
						'one' => q({0} మిమీ. పాద),
						'other' => q({0} మిమీ. పాద),
					},
					'millimole-per-liter' => {
						'name' => q(మిల్లీమోల్‌/లీటర్),
						'one' => q({0} మి.మో./లీ.),
						'other' => q({0} మి.మో./లీ.),
					},
					'millisecond' => {
						'name' => q(మిల్లీసె.),
						'one' => q({0} మి.సె),
						'other' => q({0} మి.సె),
					},
					'milliwatt' => {
						'name' => q(మి.వా),
						'one' => q({0} మి.వా),
						'other' => q({0} మి.వా),
					},
					'minute' => {
						'name' => q(నిమి.),
						'one' => q({0} నిమి.),
						'other' => q({0} నిమి.),
						'per' => q({0}/నిమి.),
					},
					'month' => {
						'name' => q(నెలలు),
						'one' => q({0} నె.),
						'other' => q({0} నె.),
						'per' => q({0}/నె.),
					},
					'nanometer' => {
						'name' => q(నా.మీ.),
						'one' => q({0} నా.మీ.),
						'other' => q({0} నా.మీ.),
					},
					'nanosecond' => {
						'name' => q(నా.సె.),
						'one' => q({0} నా.సె),
						'other' => q({0} నా.సె),
					},
					'nautical-mile' => {
						'name' => q(నా.మై.),
						'one' => q({0} నా.మై.),
						'other' => q({0} నా.మై.),
					},
					'ohm' => {
						'name' => q(ఓమ్స్),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(ఔ.),
						'one' => q({0} ఔ.),
						'other' => q({0} ఔ.),
						'per' => q({0}/ ఔ.),
					},
					'ounce-troy' => {
						'name' => q(ట్రా.ఔ.),
						'one' => q({0} ట్రా.ఔ.),
						'other' => q({0} ట్రా.ఔ.),
					},
					'parsec' => {
						'name' => q(పార్సెక్‌లు),
						'one' => q({0} పా.లు),
						'other' => q({0} పా.),
					},
					'part-per-million' => {
						'name' => q(భాగాలు/మిలియన్),
						'one' => q({0} భా./మి.),
						'other' => q({0} భా./మి.),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(శాతం),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(మైలుకు),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(పె.బైట్),
						'one' => q({0} పీబీ),
						'other' => q({0} పీబీ),
					},
					'picometer' => {
						'name' => q(పి.మీ.),
						'one' => q({0} పి.మీ.),
						'other' => q({0} పి.మీ.),
					},
					'pint' => {
						'name' => q(పింట్లు),
						'one' => q({0} పిం.),
						'other' => q({0} పిం.),
					},
					'pint-metric' => {
						'name' => q(మె.పిం.),
						'one' => q({0} మె.పిం.),
						'other' => q({0} మె.పిం.),
					},
					'point' => {
						'name' => q(పాయింట్‌లు),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'name' => q(పౌండ్లు),
						'one' => q({0} పౌ.),
						'other' => q({0} పౌ.),
						'per' => q({0}/పౌ.),
					},
					'pound-per-square-inch' => {
						'name' => q(పౌ/చ.అం),
						'one' => q({0} పౌ/చ.అం),
						'other' => q({0} పౌ/చ.అం),
					},
					'quart' => {
						'name' => q(పావు వం.),
						'one' => q({0} పావు వం.),
						'other' => q({0} పావు వం.),
					},
					'radian' => {
						'name' => q(రేడియన్లు),
						'one' => q({0} రే.),
						'other' => q({0} రే.),
					},
					'revolution' => {
						'name' => q(భ్రమ.),
						'one' => q({0} భ్రమ),
						'other' => q({0} భ్రమ.),
					},
					'second' => {
						'name' => q(సె.),
						'one' => q({0} సె.),
						'other' => q({0} సెక.),
						'per' => q({0}/సె),
					},
					'square-centimeter' => {
						'name' => q(సెం.మీ²),
						'one' => q({0} సెం.మీ²),
						'other' => q({0} సెం.మీ²),
						'per' => q({0}/సెం.మీ²),
					},
					'square-foot' => {
						'name' => q(చద. అడుగులు),
						'one' => q({0} చద. అ.),
						'other' => q({0} చద. అ.),
					},
					'square-inch' => {
						'name' => q(అంగుళాలు²),
						'one' => q({0} అం²),
						'other' => q({0} అం²),
						'per' => q({0}/అం²),
					},
					'square-kilometer' => {
						'name' => q(కి.మీ²),
						'one' => q({0} కి.మీ²),
						'other' => q({0} కి.మీ²),
						'per' => q({0}/ కి.మీ²),
					},
					'square-meter' => {
						'name' => q(మీటర్లు²),
						'one' => q({0} మీ²),
						'other' => q({0} మీ²),
						'per' => q({0}/మీ²),
					},
					'square-mile' => {
						'name' => q(చద. మైళ్లు),
						'one' => q({0} చద. మై.),
						'other' => q({0} చద. మై.),
						'per' => q({0}/ చద. మై²),
					},
					'square-yard' => {
						'name' => q(గజాలు²),
						'one' => q({0} గ²),
						'other' => q({0} గ²),
					},
					'stone' => {
						'name' => q(స్టోన్లు),
						'one' => q({0} స్టో),
						'other' => q({0} స్టో),
					},
					'tablespoon' => {
						'name' => q(టే.స్పూ.),
						'one' => q({0} టే.స్పూ),
						'other' => q({0} టే.స్పూ),
					},
					'teaspoon' => {
						'name' => q(టీ.స్పూ.),
						'one' => q({0} టీ.స్పూ.),
						'other' => q({0} టీ.స్పూ.),
					},
					'terabit' => {
						'name' => q(టె.బిట్),
						'one' => q({0} టె.బిట్),
						'other' => q({0} టె.బిట్లు),
					},
					'terabyte' => {
						'name' => q(టె.బైట్),
						'one' => q({0} టీబీ),
						'other' => q({0} టీబీ),
					},
					'ton' => {
						'name' => q(టన్నులు),
						'one' => q({0} టన్ను),
						'other' => q({0} టన్ను),
					},
					'volt' => {
						'name' => q(వోల్ట్స్),
						'one' => q({0} వో),
						'other' => q({0} వో),
					},
					'watt' => {
						'name' => q(వాట్లు),
						'one' => q({0} వా.),
						'other' => q({0} వా.),
					},
					'week' => {
						'name' => q(వారాలు),
						'one' => q({0} వా.),
						'other' => q({0} వా.),
						'per' => q({0}/వా.),
					},
					'yard' => {
						'name' => q(గజాలు),
						'one' => q({0} గ.),
						'other' => q({0} గ.),
					},
					'year' => {
						'name' => q(సంవత్సరాలు),
						'one' => q({0} సం.),
						'other' => q({0} సం.),
						'per' => q({0}/సం.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:అవును|అ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:వద్దు|వ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'telu',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
		'telu' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0వే',
					'other' => '0వే',
				},
				'10000' => {
					'one' => '00వే',
					'other' => '00వే',
				},
				'100000' => {
					'one' => '000వే',
					'other' => '000వే',
				},
				'1000000' => {
					'one' => '0మి',
					'other' => '0మి',
				},
				'10000000' => {
					'one' => '00మి',
					'other' => '00మి',
				},
				'100000000' => {
					'one' => '000మి',
					'other' => '000మి',
				},
				'1000000000' => {
					'one' => '0బి',
					'other' => '0బి',
				},
				'10000000000' => {
					'one' => '00బి',
					'other' => '00బి',
				},
				'100000000000' => {
					'one' => '000బి',
					'other' => '000బి',
				},
				'1000000000000' => {
					'one' => '0ట్రి',
					'other' => '0ట్రి',
				},
				'10000000000000' => {
					'one' => '00ట్రి',
					'other' => '00ట్రి',
				},
				'100000000000000' => {
					'one' => '000ట్రి',
					'other' => '000ట్రి',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 వేయి',
					'other' => '0 వేలు',
				},
				'10000' => {
					'one' => '00 వేలు',
					'other' => '00 వేలు',
				},
				'100000' => {
					'one' => '000 వేలు',
					'other' => '000 వేలు',
				},
				'1000000' => {
					'one' => '0 మిలియన్',
					'other' => '0 మిలియన్లు',
				},
				'10000000' => {
					'one' => '00 మిలియన్లు',
					'other' => '00 మిలియన్లు',
				},
				'100000000' => {
					'one' => '000 మిలియన్లు',
					'other' => '000 మిలియన్లు',
				},
				'1000000000' => {
					'one' => '0 బిలియన్',
					'other' => '0 బిలియన్లు',
				},
				'10000000000' => {
					'one' => '00 బిలియన్లు',
					'other' => '00 బిలియన్లు',
				},
				'100000000000' => {
					'one' => '000 బిలియన్లు',
					'other' => '000 బిలియన్లు',
				},
				'1000000000000' => {
					'one' => '0 ట్రిలియన్',
					'other' => '0 ట్రిలియన్లు',
				},
				'10000000000000' => {
					'one' => '00 ట్రిలియన్లు',
					'other' => '00 ట్రిలియన్లు',
				},
				'100000000000000' => {
					'one' => '000 ట్రిలియన్లు',
					'other' => '000 ట్రిలియన్లు',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0వే',
					'other' => '0వే',
				},
				'10000' => {
					'one' => '00వే',
					'other' => '00వే',
				},
				'100000' => {
					'one' => '000వే',
					'other' => '000వే',
				},
				'1000000' => {
					'one' => '0మి',
					'other' => '0మి',
				},
				'10000000' => {
					'one' => '00మి',
					'other' => '00మి',
				},
				'100000000' => {
					'one' => '000మి',
					'other' => '000మి',
				},
				'1000000000' => {
					'one' => '0బి',
					'other' => '0బి',
				},
				'10000000000' => {
					'one' => '00బి',
					'other' => '00బి',
				},
				'100000000000' => {
					'one' => '000బి',
					'other' => '000బి',
				},
				'1000000000000' => {
					'one' => '0ట్రి',
					'other' => '0ట్రి',
				},
				'10000000000000' => {
					'one' => '00ట్రి',
					'other' => '00ట్రి',
				},
				'100000000000000' => {
					'one' => '000ట్రి',
					'other' => '000ట్రి',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##,##0.00)',
						'positive' => '¤#,##,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
		'telu' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(యునైటెడ్ ఆరబ్ ఎమిరేట్స్ దిరామ్),
				'one' => q(యునైటెడ్ ఆరబ్ ఎమిరేట్స్ దిరామ్),
				'other' => q(యునైటెడ్ ఆరబ్ ఎమిరేట్స్ దిరామ్‌లు),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ఆఫ్ఘాన్ ఆఫ్ఘాని),
				'one' => q(ఆఫ్ఘాన్ ఆఫ్ఘాని),
				'other' => q(ఆఫ్ఘాన్ ఆఫ్ఘాని),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ఆల్బేనియన్ లేక్),
				'one' => q(ఆల్బేనియన్ లేక్),
				'other' => q(ఆల్బేనియన్ లేక్),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(అమెరికన్ డ్రామ్),
				'one' => q(అమెరికన్ డ్రామ్),
				'other' => q(అమెరికన్ డ్రామ్‌లు),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(నెదర్లాండ్స్ యాంటిల్లియన్ గిల్‌డర్),
				'one' => q(నెదర్లాండ్స్ యాంటిల్లియన్ గిల్‌డర్),
				'other' => q(నెదర్లాండ్స్ యాంటిల్లియన్ గిల్‌డర్‌లు),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(అంగోలాన్ క్వాన్‌జా),
				'one' => q(అంగోలాన్ క్వాన్‌జా),
				'other' => q(అంగోలాన్ క్వాన్‌జా‌లు),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(అర్జెంటీనా పెసో),
				'one' => q(అర్జెంటీనా పెసో),
				'other' => q(అర్జెంటీనా పెసోలు),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ఆస్ట్రేలియన్ డాలర్),
				'one' => q(ఆస్ట్రేలియన్ డాలర్),
				'other' => q(ఆస్ట్రేలియన్ డాలర్‌లు),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(అరుబన్ ఫ్లోరిన్),
				'one' => q(అరుబన్ ఫ్లోరిన్),
				'other' => q(అరుబన్ ఫ్లోరిన్),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(అజర్బైజాన్ మానట్),
				'one' => q(అజర్బైజాన్ మానట్),
				'other' => q(అజర్బైజాన్ మానట్‌లు),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(బోస్నియా-హెర్జగోవినా మార్పిడి చెయ్యగలిగే మార్క్),
				'one' => q(బోస్నియా-హెర్జగోవినా మార్పిడి చెయ్యగలిగే మార్క్),
				'other' => q(బోస్నియా-హెర్జగోవినా మార్పిడి చెయ్యగలిగే మార్క్‌లు),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(బర్బాడియన్ డాలర్),
				'one' => q(బర్బాడియన్ డాలర్),
				'other' => q(బర్బాడియన్ డాలర్‌లు),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(బాంగ్లాదేశ్ టాకా),
				'one' => q(బాంగ్లాదేశ్ టాకా),
				'other' => q(బాంగ్లాదేశ్ టాకాలు),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(బల్గేరియన్ లేవ్),
				'one' => q(బల్గేరియన్ లేవ్),
				'other' => q(బల్గేరియన్ లేవ),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(బహ్రెయిన్ దినార్),
				'one' => q(బహ్రెయిన్ దినార్),
				'other' => q(బహ్రెయిన్ దినార్‌లు),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(బురిండియన్ ఫ్రాంక్),
				'one' => q(బురిండియన్ ఫ్రాంక్),
				'other' => q(బురిండియన్ ఫ్రాంక్‌లు),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(బెర్ముడన్ డాలర్),
				'one' => q(బెర్ముడన్ డాలర్),
				'other' => q(బెర్ముడన్ డాలర్‌లు),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(బ్రూనై డాలర్),
				'one' => q(బ్రూనై డాలర్),
				'other' => q(బ్రూనై డాలర్‌లు),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(బొలీవియన్ బొలీవియానో),
				'one' => q(బొలీవియన్ బొలీవియానో),
				'other' => q(బొలీవియన్ బొలీవియానోలు),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(బ్రెజిలియన్ రియల్),
				'one' => q(బ్రెజిలియన్ రియల్),
				'other' => q(బ్రెజిలియన్ రియల్‌లు),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(బహామియన్ డాలర్),
				'one' => q(బహామియన్ డాలర్),
				'other' => q(బహామియన్ డాలర్‌లు),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(భూటానీయుల గుల్‌ట్రుమ్),
				'one' => q(భూటానీయుల గుల్‌ట్రుమ్),
				'other' => q(భూటానీయుల గుల్‌ట్రుమ్‌లు),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(బోట్స్‌వానా పులా),
				'one' => q(బోట్స్‌వానా పులా),
				'other' => q(బోట్స్‌వానా పులాలు),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(బెలరూసియన్ రూబల్),
				'one' => q(బెలరూసియన్ రూబల్),
				'other' => q(బెలరూసియన్ రూబల్‌లు),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(బెలరూసియన్ రూబల్ \(2000–2016\)),
				'one' => q(బెలరూసియన్ రూబల్ \(2000–2016\)),
				'other' => q(బెలరూసియన్ రూబల్‌లు \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(బెలీజ్ డాలర్),
				'one' => q(బెలీజ్ డాలర్),
				'other' => q(బెలీజ్ డాలర్‌లు),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(కెనడియన్ డాలర్),
				'one' => q(కెనడియన్ డాలర్),
				'other' => q(కెనడియన్ డాలర్‌లు),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(కొంగోలిస్ ఫ్రాంక్),
				'one' => q(కొంగోలిస్ ఫ్రాంక్),
				'other' => q(కొంగోలిస్ ఫ్రాంక్‌లు),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(స్విస్ ఫ్రాంక్),
				'one' => q(స్విస్ ఫ్రాంక్),
				'other' => q(స్విస్ ఫ్రాంక్‌లు),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(చిలియన్ పెసో),
				'one' => q(చిలియన్ పెసో),
				'other' => q(చిలియన్ పెసోలు),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(చైనీస్ యూవాన్ \(ఆఫ్‌షోర్\)),
				'one' => q(చైనీస్ యూవాన్ \(ఆఫ్‌షోర్\)),
				'other' => q(చైనీస్ యూవాన్ \(ఆఫ్‌షోర్\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(చైనా దేశ యువాన్),
				'one' => q(చైనా దేశ యువాన్),
				'other' => q(చైనా దేశ యువాన్),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(కొలంబియన్ పెసో),
				'one' => q(కొలంబియన్ పెసో),
				'other' => q(కొలంబియన్ పెసోలు),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(కోస్టా రికన్ కోలోన్),
				'one' => q(కోస్టా రికన్ కోలోన్),
				'other' => q(కోస్టా రికన్ కోలోన్‌లు),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(క్యూబన్ కన్వర్టబుల్ పెసో),
				'one' => q(క్యూబన్ కన్వర్టబుల్ పెసో),
				'other' => q(క్యూబన్ కన్వర్టబుల్ పెసోలు),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(క్యూబన్ పెసో),
				'one' => q(క్యూబన్ పెసో),
				'other' => q(క్యూబన్ పెసోలు),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(కేప్ వెర్డియన్ ఎస్కుడో),
				'one' => q(కేప్ వెర్డియన్ ఎస్కుడో),
				'other' => q(కేప్ వెర్డియన్ ఎస్కుడోలు),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(చెక్ రిపబ్లిక్ కోరునా),
				'one' => q(చెక్ రిపబ్లిక్ కోరునా),
				'other' => q(చెక్ రిపబ్లిక్ కోరునాలు),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(జిబోటియన్ ఫ్రాంక్),
				'one' => q(జిబోటియన్ ఫ్రాంక్),
				'other' => q(జిబోటియన్ ఫ్రాంక్‌లు),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(డానిష్ క్రోన్),
				'one' => q(డానిష్ క్రోన్),
				'other' => q(డానిష్ క్రోనర్),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(డోమినికన్ పెసో),
				'one' => q(డోమినికన్ పెసో),
				'other' => q(డోమినికన్ పెసోలు),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(అల్జీరియన్ దీనార్),
				'one' => q(అల్జీరియన్ దీనార్),
				'other' => q(అల్జీరియన్ దీనార్‌లు),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ఈజిప్షియన్ పౌండ్),
				'one' => q(ఈజిప్షియన్ పౌండ్),
				'other' => q(ఈజిప్షియన్ పౌండ్‌లు),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ఎరిట్రీన్ నక్ఫా),
				'one' => q(ఎరిట్రీన్ నక్ఫా),
				'other' => q(ఎరిట్రీన్ నక్ఫా‌లు),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ఇథియోపియన్ బర్),
				'one' => q(ఇథియోపియన్ బర్),
				'other' => q(ఇథియోపియన్ బర్‌లు),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(యురొ),
				'one' => q(యురొ),
				'other' => q(యురోలు),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ఫీజియన్ డాలర్),
				'one' => q(ఫీజియన్ డాలర్),
				'other' => q(ఫీజియన్ డాలర్‌లు),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ఫాక్‌ల్యాండ్ దీవులు పౌండ్),
				'one' => q(ఫాక్‌ల్యాండ్ దీవులు పౌండ్),
				'other' => q(ఫాక్‌ల్యాండ్ దీవులు పౌండ్‌లు),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(బ్రిటిష్ పౌండ్),
				'one' => q(బ్రిటిష్ పౌండ్),
				'other' => q(బ్రిటిష్ పౌండ్‌లు),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(జార్జియన్ లారి),
				'one' => q(జార్జియన్ లారి),
				'other' => q(జార్జియన్ లారీలు),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(గానెయన్ సెడి),
				'one' => q(గానెయన్ సెడి),
				'other' => q(గానెయన్ సెడిలు),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(జిబ్రల్‌టూర్ పౌండ్),
				'one' => q(జిబ్రల్‌టూర్ పౌండ్),
				'other' => q(జిబ్రల్‌టూర్ పౌండ్‌లు),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(గాంబియన్ దలాసి),
				'one' => q(గాంబియన్ దలాసి),
				'other' => q(గాంబియన్ దలాసిలు),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(గ్వినియన్ ఫ్రాంక్),
				'one' => q(గ్వినియన్ ఫ్రాంక్),
				'other' => q(గ్వినియన్ ఫ్రాంక్‌లు),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(గ్యుటెమాలన్ క్వెట్‌జల్),
				'one' => q(గ్యుటెమాలన్ క్వెట్‌జల్),
				'other' => q(గ్యుటెమాలన్ క్వెట్‌జల్‌లు),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(గుయనియాస్ డాలర్),
				'one' => q(గుయనియాస్ డాలర్),
				'other' => q(గుయనియాస్ డాలర్‌లు),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(హాంకాంగ్ డాలర్),
				'one' => q(హాంకాంగ్ డాలర్),
				'other' => q(హాంకాంగ్ డాలర్‌లు),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(హోండురన్ లెమిపిరా),
				'one' => q(హోండురన్ లెమిపిరా),
				'other' => q(హోండురన్ లెమిపిరాలు),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(క్రొయేషియన్ క్యూన),
				'one' => q(క్రొయేషియన్ క్యూన),
				'other' => q(క్రొయేషియన్ క్యూనాలు),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(హైటియన్ గ్వోర్డే),
				'one' => q(హైటియన్ గ్వోర్డే),
				'other' => q(హైటియన్ గ్వోర్డేలు),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(హంగేరియన్ ఫోరింట్),
				'one' => q(హంగేరియన్ ఫోరింట్),
				'other' => q(హంగేరియన్ ఫోరింట్‌లు),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ఇండోనేషియా రూపాయి),
				'one' => q(ఇండోనేషియా రూపాయి),
				'other' => q(ఇండోనేషియా రూపాయలు),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ఐరాయిలి న్యూ షెక్యెల్),
				'one' => q(ఐరాయిలి న్యూ షెక్యెల్),
				'other' => q(ఐరాయిలి న్యూ షెక్యెల్‌లు),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(రూపాయి),
				'one' => q(రూపాయి),
				'other' => q(రూపాయలు),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ఇరాకీ దీనార్),
				'one' => q(ఇరాకీ దీనార్),
				'other' => q(ఇరాకీ దీనార్‌లు),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ఇరానియన్ రీయల్),
				'one' => q(ఇరానియన్ రీయల్),
				'other' => q(ఇరానియన్ రీయల్‌లు),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ఐస్లాండిక్ క్రోనా),
				'one' => q(ఐస్లాండిక్ క్రోనా),
				'other' => q(ఐస్లాండిక్ క్రోనర్),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(జమైకన్ డాలర్),
				'one' => q(జమైకన్ డాలర్),
				'other' => q(జమైకన్ డాలర్‌లు),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(జోర్‌డానియన్ దీనార్),
				'one' => q(జోర్‌డానియన్ దీనార్),
				'other' => q(జోర్‌డానియన్ దీనార్‌లు),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(జపాను దేశ యెన్),
				'one' => q(జపాను దేశ యెన్),
				'other' => q(జపాను దేశ యెన్),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(కెన్యాన్ షిల్లింగ్),
				'one' => q(కెన్యాన్ షిల్లింగ్),
				'other' => q(కెన్యాన్ షిల్లింగ్‌లు),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(కిర్గిస్థాని సౌమ్),
				'one' => q(కిర్గిస్థాని సౌమ్),
				'other' => q(కిర్గిస్థాని సౌమ్‌లు),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(కాంబోడియన్ రీల్),
				'one' => q(కాంబోడియన్ రీల్),
				'other' => q(కాంబోడియన్ రీల్‌లు),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(కొమోరియన్ ఫ్రాంక్),
				'one' => q(కొమోరియన్ ఫ్రాంక్),
				'other' => q(కొమోరియన్ ఫ్రాంక్‌లు),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(ఉత్తర కొరియా వోన్),
				'one' => q(ఉత్తర కొరియా వోన్),
				'other' => q(ఉత్తర కొరియా వోన్),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(దక్షిణ కొరియా వోన్),
				'one' => q(దక్షిణ కొరియా వోన్),
				'other' => q(దక్షిణ కొరియా వోన్),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(కువైట్ దీనార్),
				'one' => q(కువైట్ దీనార్),
				'other' => q(కువైట్ దీనార్‌లు),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(కేమాన్ దీవుల డాలర్),
				'one' => q(కేమాన్ దీవుల డాలర్),
				'other' => q(కేమాన్ దీవుల డాలర్‌లు),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(ఖజికిస్థాన్ టెంగే),
				'one' => q(ఖజికిస్థాన్ టెంగే),
				'other' => q(ఖజికిస్థాన్ టెంగేలు),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(లాటియన్ కిప్),
				'one' => q(లాటియన్ కిప్),
				'other' => q(లాటియన్ కిప్‌లు),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(లెబనీస్ పౌండ్),
				'one' => q(లెబనీస్ పౌండ్),
				'other' => q(లెబనీస్ పౌండ్‌లు),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(శ్రీలంక రూపాయి),
				'one' => q(శ్రీలంక రూపాయి),
				'other' => q(శ్రీలంక రూపాయలు),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(లిబేరియన్ డాలర్),
				'one' => q(లిబేరియన్ డాలర్),
				'other' => q(లిబేరియన్ డాలర్‌లు),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(లెసోధో లోటి),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(లిథోనియన్ లీటాస్),
				'one' => q(లిథోనియన్ లీటాస్),
				'other' => q(లిథోనియన్ లీటై),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(లాత్వియన్ లాట్స్),
				'one' => q(లాత్వియన్ లాట్స్),
				'other' => q(లాత్వియన్ లాటి),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(లిబియన్ దీనార్),
				'one' => q(లిబియన్ దీనార్),
				'other' => q(లిబియన్ దీనార్‌లు),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(మోరోకన్ దిర్హుమ్),
				'one' => q(మోరోకన్ దిర్హుమ్),
				'other' => q(మోరోకన్ దిర్హుమ్‌లు),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(మోల్‌డోవన్ ల్యూ),
				'one' => q(మోల్‌డోవన్ ల్యూ),
				'other' => q(మోల్‌డోవన్ లీ),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(మలగసీ అరియరీ),
				'one' => q(మలగసీ అరియరీ),
				'other' => q(మలగసీ అరియరీలు),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(మెసిడోనియన్ దినార్),
				'one' => q(మెసిడోనియన్ దినార్),
				'other' => q(మెసిడోనియన్ దినారి),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(మయన్మార్ క్యాట్),
				'one' => q(మయన్మార్ క్యాట్),
				'other' => q(మయన్మార్ క్యాట్‌లు),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(మంగోలియన్ టుగ్రిక్),
				'one' => q(మంగోలియన్ టుగ్రిక్),
				'other' => q(మంగోలియన్ టుగ్రిక్‌లు),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(మకనీస్ పటాక),
				'one' => q(మకనీస్ పటాక),
				'other' => q(మకనీస్ పటాకాలు),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(మౌరిటానియన్ ఒగ్యియా \(1973–2017\)),
				'one' => q(మౌరిటానియన్ ఒగ్యియా \(1973–2017\)),
				'other' => q(మౌరిటానియన్ ఒగ్యియాలు \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(మౌరిటానియన్ ఒగ్యియా),
				'one' => q(మౌరిటానియన్ ఒగ్యియా),
				'other' => q(మౌరిటానియన్ ఒగ్యియాలు),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(మారిషన్ రూపాయి),
				'one' => q(మారిషన్ రూపాయి),
				'other' => q(మారిషన్ రూపాయలు),
			},
		},
		'MVP' => {
			display_name => {
				'currency' => q(మాల్దీవుల రూపాయి),
				'one' => q(మాల్దీవుల రూపాయి),
				'other' => q(మాల్దీవులు రూపాయిలు),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(మాల్దీవియన్ రుఫియా),
				'one' => q(మాల్దీవియన్ రుఫియా),
				'other' => q(మాల్దీవియన్ రుఫియాలు),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(మలావియన్ క్వాచా),
				'one' => q(మలావియన్ క్వాచా),
				'other' => q(మలావియన్ క్వాచాలు),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(మెక్సికన్ పెసో),
				'one' => q(మెక్సికన్ పెసో),
				'other' => q(మెక్సికన్ పెసోలు),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(మలేషియా రింగ్గిట్),
				'one' => q(మలేషియా రింగ్గిట్),
				'other' => q(మలేషియా రింగ్గిట్‌లు),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(మొజాంబికన్ మెటికల్),
				'one' => q(మొజాంబికన్ మెటికల్),
				'other' => q(మొజాంబికన్ మెటికల్‌లు),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(నమిబియన్ డాలర్),
				'one' => q(నమిబియన్ డాలర్),
				'other' => q(నమిబియన్ డాలర్‌లు),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(నైజీరియన్ నైరా),
				'one' => q(నైజీరియన్ నైరా),
				'other' => q(నైజీరియన్ నైరాలు),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(నికరగ్యుయన్ కొర్‌డుబు),
				'one' => q(నికరగ్యుయన్ కొర్‌డుబు),
				'other' => q(నికరగ్యుయన్ కొర్‌డుబులు),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(నార్వేజీయన్ క్రోన్),
				'one' => q(నార్వేజీయన్ క్రోన్),
				'other' => q(నార్వేజీయన్ క్రోనర్),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(నేపాలీయుల రూపాయి),
				'one' => q(నేపాలీయుల రూపాయి),
				'other' => q(నేపాలీయుల రూపాయలు),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(న్యూజిలాండ్ డాలర్),
				'one' => q(న్యూజిలాండ్ డాలర్),
				'other' => q(న్యూజిలాండ్ డాలర్‌లు),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ఒమాని రీయల్),
				'one' => q(ఒమాని రీయల్),
				'other' => q(ఒమాని రీయల్‌లు),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(పనామనియన్ బల్బోవ),
				'one' => q(పనామనియన్ బల్బోవ),
				'other' => q(పనామనియన్ బల్బోవాలు),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(పెరువియన్ సోల్),
				'one' => q(పెరువియన్ సోల్),
				'other' => q(పెరువియన్ సోల్‌లు),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(పప్యూ న్యూ గ్యినియన్ కినా),
				'one' => q(పప్యూ న్యూ గ్యినియన్ కినా),
				'other' => q(పప్యూ న్యూ గ్యినియన్ కినా),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ఫిలిప్పిన్ పెసో),
				'one' => q(ఫిలిప్పిన్ పెసో),
				'other' => q(ఫిలిప్పిన్ పెసోలు),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(పాకిస్థాన్ రూపాయి),
				'one' => q(పాకిస్థాన్ రూపాయి),
				'other' => q(పాకిస్థాన్ రూపాయలు),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(పోలిష్ జ్లోటీ),
				'one' => q(పోలిష్ జ్లోటీ),
				'other' => q(పోలిష్ జ్లోటీలు),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(పరగ్వాయన్ గ్వారని),
				'one' => q(పరగ్వాయన్ గ్వారని),
				'other' => q(పరగ్వాయన్ గ్వారనీలు),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(క్వాటరి రీయల్),
				'one' => q(క్వాటరి రీయల్),
				'other' => q(క్వాటరి రీయల్‌లు),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(రోమానియాన్ లెయు),
				'one' => q(రోమానియాన్ లెయు),
				'other' => q(రోమానియాన్ లీ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(సెర్బియన్ దీనార్),
				'one' => q(సెర్బియన్ దీనార్),
				'other' => q(సెర్బియన్ దీనార్‌లు),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(రష్యన్ రూబల్),
				'one' => q(రష్యన్ రూబల్),
				'other' => q(రష్యన్ రూబల్‌లు),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ర్వానడాన్ ఫ్రాంక్),
				'one' => q(ర్వానడాన్ ఫ్రాంక్),
				'other' => q(ర్వానడాన్ ఫ్రాంక్‌లు),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(సౌది రియల్),
				'one' => q(సౌది రియల్),
				'other' => q(సౌది రియల్‌లు),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(సోలోమన్ దీవుల డాలర్),
				'one' => q(సోలోమన్ దీవుల డాలర్),
				'other' => q(సోలోమన్ దీవుల డాలర్‌లు),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(సెయిచెల్లోయిస్ రూపాయి),
				'one' => q(సెయిచెల్లోయిస్ రూపాయి),
				'other' => q(సెయిచెల్లోయిస్ రూపాయలు),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(సుడానీస్ పౌండ్),
				'one' => q(సుడానీస్ పౌండ్),
				'other' => q(సుడానీస్ పౌండ్‌లు),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(స్వీడిష్ క్రోనా),
				'one' => q(స్వీడిష్ క్రోనా),
				'other' => q(స్వీడిష్ క్రోనర్),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(సింగపూర్ డాలర్),
				'one' => q(సింగపూర్ డాలర్),
				'other' => q(సింగపూర్ డాలర్‌లు),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(సెయింట్ హెలెనా పౌండ్),
				'one' => q(సెయింట్ హెలెనా పౌండ్),
				'other' => q(సెయింట్ హెలెనా పౌండ్‌లు),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(సీయిరు లియోనియన్ లీయోన్),
				'one' => q(సీయిరు లియోనియన్ లీయోన్),
				'other' => q(సీయిరు లియోనియన్ లీయోన్‌లు),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(సొమాలి షిల్లింగ్),
				'one' => q(సొమాలి షిల్లింగ్),
				'other' => q(సొమాలి షిల్లింగ్‌లు),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(సురినామీయుల డాలర్),
				'one' => q(సురినామీయుల డాలర్),
				'other' => q(సురినామీయుల డాలర్‌లు),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(దక్షిణ సుడానీస్ పౌండ్),
				'one' => q(దక్షిణ సుడానీస్ పౌండ్),
				'other' => q(దక్షిణ సుడానీస్ పౌండ్‌లు),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రా \(1977–2017\)),
				'one' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రా \(1977–2017\)),
				'other' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రాలు \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రా),
				'one' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రా),
				'other' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రాలు),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(సిరీయన్ పౌండ్),
				'one' => q(సిరీయన్ పౌండ్),
				'other' => q(సిరీయన్ పౌండ్‌లు),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(స్వాజి లిలాన్గేని),
				'one' => q(స్వాజి లిలాన్గేని),
				'other' => q(స్వాజి ఎమలాన్గేని),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(థాయ్ బాట్),
				'one' => q(థాయ్ బాట్),
				'other' => q(థాయ్ బాట్),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(తజికిస్థాన్ సమోని),
				'one' => q(తజికిస్థాన్ సమోని),
				'other' => q(తజికిస్థాన్ సమోనీలు),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(తుర్క్‌మెనిస్థాని మనాట్),
				'one' => q(తుర్క్‌మెనిస్థాని మనాట్),
				'other' => q(తుర్క్‌మెనిస్థాని మనాట్),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(తునీషియన్ దీనార్),
				'one' => q(తునీషియన్ దీనార్),
				'other' => q(తునీషియన్ దీనార్‌లు),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(టోంగాన్ పాంʻగా),
				'one' => q(టోంగాన్ పాంʻగా),
				'other' => q(టోంగాన్ పాంʻగా),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(తుర్కిష్ లిరా),
				'one' => q(తుర్కిష్ లిరా),
				'other' => q(తుర్కిష్ లిరా),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ట్రినిడాడ్ మరియు టొబాగో డాలర్),
				'one' => q(ట్రినిడాడ్ మరియు టొబాగో డాలర్),
				'other' => q(ట్రినిడాడ్ మరియు టొబాగో డాలర్‌లు),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(క్రొత్త తైవాన్ డాలర్),
				'one' => q(క్రొత్త తైవాన్ డాలర్),
				'other' => q(కొత్త తైవాన్ డాలర్‌లు),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(టాంజానియన్ షిల్లింగ్),
				'one' => q(టాంజానియన్ షిల్లింగ్),
				'other' => q(టాంజానియన్ షిల్లింగ్‌లు),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ఉక్రయినియన్ హ్రివ్‌నియా),
				'one' => q(ఉక్రయినియన్ హ్రివ్‌నియా),
				'other' => q(ఉక్రయినియన్ హ్రివ్‌నియాలు),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ఉగాండన్ షిల్లింగ్),
				'one' => q(ఉగాండన్ షిల్లింగ్),
				'other' => q(ఉగాండన్ షిల్లింగ్‌లు),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(అమెరికా డాలర్),
				'one' => q(అమెరికా డాలర్),
				'other' => q(అమెరికా డాలర్‌లు),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ఉరుగ్వెయన్ పెసో),
				'one' => q(ఉరుగ్వెయన్ పెసో),
				'other' => q(ఉరుగ్వెయన్ పెసోలు),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ఉజ్‌బెకిస్తాన్ సౌమ్),
				'one' => q(ఉజ్‌బెకిస్తాన్ సౌమ్),
				'other' => q(ఉజ్‌బెకిస్తాన్ సౌమ్),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(వెనుజులా బోలివర్ \(2008–2018\)),
				'one' => q(వెనుజులా బోలివర్ \(2008–2018\)),
				'other' => q(వెనుజులా బోలివర్‌లు \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(వెనుజులా బోలివర్),
				'one' => q(వెనుజులా బోలివర్),
				'other' => q(వెనుజులా బోలివర్‌లు),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(వియత్నామీయుల డాంగ్),
				'one' => q(వియత్నామీయుల డాంగ్),
				'other' => q(వియత్నామీయుల డాంగ్),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(వనాటు వటు),
				'one' => q(వనాటు వటు),
				'other' => q(వవాటు వటూలు),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(సమోయన్ తాలా),
				'one' => q(సమోయన్ తాలా),
				'other' => q(సమోయన్ తాలా),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(సెంట్రల్ ఆఫ్రికన్ సిఎఫ్‌ఎ ఫ్రాంక్),
				'one' => q(సెంట్రల్ ఆఫ్రికన్ సిఎఫ్‌ఎ ఫ్రాంక్),
				'other' => q(సెంట్రల్ ఆఫ్రికన్ సిఎఫ్‌ఎ ఫ్రాంక్‌లు),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(వెండి),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(బంగారం),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(తూర్పు కరీబియన్ డాలర్),
				'one' => q(తూర్పు కరీబియన్ డాలర్),
				'other' => q(తూర్పు కరీబియన్ డాలర్‌లు),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(పశ్చిమ ఆఫ్రికన్ సిఏఫ్ఏ ఫ్రాంక్),
				'one' => q(పశ్చిమ ఆఫ్రికన్ సిఏఫ్ఏ ఫ్రాంక్),
				'other' => q(పశ్చిమ ఆఫ్రికన్ సిఏఫ్ఏ ఫ్రాంక్‌లు),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(సిఎఫ్‌పి ఫ్రాంక్),
				'one' => q(సిఎఫ్‌పి ఫ్రాంక్),
				'other' => q(సిఎఫ్‌పి ఫ్రాంక్‌లు),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(ప్లాటినం),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(తెలియని కరెన్సీ),
				'one' => q(తెలియని కరెన్సీ ప్రమాణం),
				'other' => q(తెలియని కరెన్సీ),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ఎమునీ రీయల్),
				'one' => q(ఎమునీ రీయల్),
				'other' => q(ఎమునీ రీయల్‌లు),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(దక్షిణ ఆఫ్రికా ర్యాండ్),
				'one' => q(దక్షిణ ఆఫ్రికా ర్యాండ్),
				'other' => q(దక్షిణ ఆఫ్రికా ర్యాండ్),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(జాంబియన్ క్వాచా \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(జాంబియన్ క్వాచా),
				'one' => q(జాంబియన్ క్వాచా),
				'other' => q(జాంబియన్ క్వాచాలు),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'టౌట్',
							'బాబా',
							'హాటర్',
							'కిహఖ్',
							'తోబా',
							'అమ్షిర్',
							'బారామ్హట్',
							'బారామౌదా',
							'బషాన్స్',
							'పఓనా',
							'ఇపెప్',
							'మెస్రా',
							'నైసే'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'టౌట్',
							'బాబా',
							'హాటర్',
							'కిహఖ్',
							'తోబా',
							'అమ్షిర్',
							'బారామ్హట్',
							'బారామౌదా',
							'బషాన్స్',
							'పఓనా',
							'ఇపెప్',
							'మెస్రా',
							'నైసే'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'టౌట్',
							'బాబా',
							'హాటర్',
							'కిహఖ్',
							'తోబా',
							'అమ్షిర్',
							'బారామ్హట్',
							'బారామౌదా',
							'బషాన్స్',
							'పఓనా',
							'ఇపెప్',
							'మెస్రా',
							'నైసే'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'టౌట్',
							'బాబా',
							'హాటర్',
							'కిహఖ్',
							'తోబా',
							'అమ్షిర్',
							'బారామ్హట్',
							'బారామౌదా',
							'బషాన్స్',
							'పఓనా',
							'ఇపెప్',
							'మెస్రా',
							'నైసే'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'మెస్క్‌రమ్',
							'టెకెమట్',
							'హెదర్',
							'తహసాస్',
							'టర్',
							'యెకాటిట్',
							'మెగాబిట్',
							'మియజియ',
							'గెన్‌బోట్',
							'సెనె',
							'హమ్లె',
							'నెహస్సె',
							'పగుమెన్'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'మెస్క్‌రమ్',
							'టెకెమట్',
							'హెదర్',
							'తహసాస్',
							'టర్',
							'యెకాటిట్',
							'మెగాబిట్',
							'మియజియ',
							'గెన్‌బోట్',
							'సెనె',
							'హమ్లె',
							'నెహస్సె',
							'పగుమెన్'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'మెస్క్‌రమ్',
							'టెకెమట్',
							'హెదర్',
							'తహసాస్',
							'టర్',
							'యెకాటిట్',
							'మెగాబిట్',
							'మియజియ',
							'గెన్‌బోట్',
							'సెనె',
							'హమ్లె',
							'నెహస్సె',
							'పగుమెన్'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'మెస్క్‌రమ్',
							'టెకెమట్',
							'హెదర్',
							'తహసాస్',
							'టర్',
							'యెకాటిట్',
							'మెగాబిట్',
							'మియజియ',
							'గెన్‌బోట్',
							'సెనె',
							'హమ్లె',
							'నెహస్సె',
							'పగుమెన్'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'జన',
							'ఫిబ్ర',
							'మార్చి',
							'ఏప్రి',
							'మే',
							'జూన్',
							'జులై',
							'ఆగ',
							'సెప్టెం',
							'అక్టో',
							'నవం',
							'డిసెం'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'జ',
							'ఫి',
							'మా',
							'ఏ',
							'మే',
							'జూ',
							'జు',
							'ఆ',
							'సె',
							'అ',
							'న',
							'డి'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'జనవరి',
							'ఫిబ్రవరి',
							'మార్చి',
							'ఏప్రిల్',
							'మే',
							'జూన్',
							'జులై',
							'ఆగస్టు',
							'సెప్టెంబర్',
							'అక్టోబర్',
							'నవంబర్',
							'డిసెంబర్'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'జన',
							'ఫిబ్ర',
							'మార్చి',
							'ఏప్రి',
							'మే',
							'జూన్',
							'జులై',
							'ఆగ',
							'సెప్టెం',
							'అక్టో',
							'నవం',
							'డిసెం'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'జ',
							'ఫి',
							'మా',
							'ఏ',
							'మే',
							'జూ',
							'జు',
							'ఆ',
							'సె',
							'అ',
							'న',
							'డి'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'జనవరి',
							'ఫిబ్రవరి',
							'మార్చి',
							'ఏప్రిల్',
							'మే',
							'జూన్',
							'జులై',
							'ఆగస్టు',
							'సెప్టెంబర్',
							'అక్టోబర్',
							'నవంబర్',
							'డిసెంబర్'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'టిశ్రీ',
							'హేష్‌వాన్',
							'కిస్లెవ్',
							'టెవెట్',
							'షెవాట్',
							'అదర్ I',
							'అదర్',
							'నిసాన్',
							'ఐయర్',
							'సివాన్',
							'తముజ్',
							'అవ',
							'ఇలుల్'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'అదర్ II'
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'7'
						],
					},
					wide => {
						nonleap => [
							'టిశ్రీ',
							'హేష్‌వాన్',
							'కిస్లెవ్',
							'టెవెట్',
							'షెవాట్',
							'అదర్ I',
							'అదర్',
							'నిసాన్',
							'ఐయర్',
							'సివాన్',
							'తముజ్',
							'అవ',
							'ఇలుల్'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'అదర్ II'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'టిశ్రీ',
							'హేష్‌వాన్',
							'కిస్లెవ్',
							'టెవెట్',
							'షెవాట్',
							'అదర్ I',
							'అదర్',
							'నిసాన్',
							'ఐయర్',
							'సివాన్',
							'తముజ్',
							'అవ',
							'ఇలుల్'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'అదర్ II'
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'7'
						],
					},
					wide => {
						nonleap => [
							'టిశ్రీ',
							'హేష్‌వాన్',
							'కిస్లెవ్',
							'టెవెట్',
							'షెవాట్',
							'అదర్ I',
							'అదర్',
							'నిసాన్',
							'ఐయర్',
							'సివాన్',
							'తముజ్',
							'అవ',
							'ఇలుల్'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'అదర్ II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'చైత్రం',
							'వైశాఖం',
							'జ్యేష్ఠం',
							'ఆషాఢం',
							'శ్రావణం',
							'భాద్రపదం',
							'ఆశ్వయుజం',
							'కార్తీకం',
							'మార్గశిరం',
							'పుష్యం',
							'మాఘం',
							'ఫల్గుణం'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'చైత్రం',
							'వైశాఖం',
							'జ్యేష్ఠం',
							'ఆషాఢం',
							'శ్రావణం',
							'భాద్రపదం',
							'ఆశ్వయుజం',
							'కార్తీకం',
							'మార్గశిరం',
							'పుష్యం',
							'మాఘం',
							'ఫల్గుణం'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'చైత్రం',
							'వైశాఖం',
							'జ్యేష్ఠం',
							'ఆషాఢం',
							'శ్రావణం',
							'భాద్రపదం',
							'ఆశ్వయుజం',
							'కార్తీకం',
							'మార్గశిరం',
							'పుష్యం',
							'మాఘం',
							'ఫల్గుణం'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'చైత్రం',
							'వైశాఖం',
							'జ్యేష్ఠం',
							'ఆషాఢం',
							'శ్రావణం',
							'భాద్రపదం',
							'ఆశ్వయుజం',
							'కార్తీకం',
							'మార్గశిరం',
							'పుష్యం',
							'మాఘం',
							'ఫల్గుణం'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ముహ.',
							'సఫ.',
							'ర. I',
							'ర. II',
							'జుమ. I',
							'జుమ. II',
							'రజ.',
							'షబా.',
							'రంజా.',
							'షవ్వా.',
							'ధుల్-కి.',
							'ధుల్-హి.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Muharram',
							'Safar',
							'Rabiʻ I',
							'Rabiʻ II',
							'Jumada I',
							'Jumada II',
							'Rajab',
							'Shaʻban',
							'Ramadan',
							'Shawwal',
							'Dhuʻl-Qiʻdah',
							'Dhuʻl-Hijjah'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ముహ.',
							'సఫ.',
							'ర. I',
							'ర. II',
							'జుమ. I',
							'జుమ. II',
							'రజ.',
							'షబా.',
							'రంజా.',
							'షవ్వా.',
							'ధుల్-కి.',
							'ధుల్-హి.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ముహర్రం',
							'సఫర్',
							'రబీ I',
							'రబీ II',
							'జుమదా I',
							'జుమదా II',
							'రజబ్',
							'షబాన్',
							'రంజాన్',
							'షవ్వాల్',
							'ధుల్-కి దాహ్',
							'ధుల్-హిజ్జాహ్'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ఫావర్డిన్',
							'ఊడాబహష్ట్',
							'ఖోర్డాడ్',
							'టిర్',
							'మెర్డాడ్',
							'శశివర్',
							'మెహర్',
							'అబన్',
							'అజర్',
							'డే',
							'బాహ్‌మాన్',
							'ఎస్‌ఫాండ్'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ఫావర్డిన్',
							'ఊడాబహష్ట్',
							'ఖోర్డాడ్',
							'టిర్',
							'మెర్డాడ్',
							'శశివర్',
							'మెహర్',
							'అబన్',
							'అజర్',
							'డే',
							'బాహ్‌మాన్',
							'ఎస్‌ఫాండ్'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ఫావర్డిన్',
							'ఊడాబహష్ట్',
							'ఖోర్డాడ్',
							'టిర్',
							'మెర్డాడ్',
							'శశివర్',
							'మెహర్',
							'అబన్',
							'అజర్',
							'డే',
							'బాహ్‌మాన్',
							'ఎస్‌ఫాండ్'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ఫావర్డిన్',
							'ఊడాబహష్ట్',
							'ఖోర్డాడ్',
							'టిర్',
							'మెర్డాడ్',
							'శశివర్',
							'మెహర్',
							'అబన్',
							'అజర్',
							'డే',
							'బాహ్‌మాన్',
							'ఎస్‌ఫాండ్'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'సోమ',
						tue => 'మంగళ',
						wed => 'బుధ',
						thu => 'గురు',
						fri => 'శుక్ర',
						sat => 'శని',
						sun => 'ఆది'
					},
					narrow => {
						mon => 'సో',
						tue => 'మ',
						wed => 'బు',
						thu => 'గు',
						fri => 'శు',
						sat => 'శ',
						sun => 'ఆ'
					},
					short => {
						mon => 'సోమ',
						tue => 'మం',
						wed => 'బుధ',
						thu => 'గురు',
						fri => 'శుక్ర',
						sat => 'శని',
						sun => 'ఆది'
					},
					wide => {
						mon => 'సోమవారం',
						tue => 'మంగళవారం',
						wed => 'బుధవారం',
						thu => 'గురువారం',
						fri => 'శుక్రవారం',
						sat => 'శనివారం',
						sun => 'ఆదివారం'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'సోమ',
						tue => 'మంగళ',
						wed => 'బుధ',
						thu => 'గురు',
						fri => 'శుక్ర',
						sat => 'శని',
						sun => 'ఆది'
					},
					narrow => {
						mon => 'సో',
						tue => 'మ',
						wed => 'బు',
						thu => 'గు',
						fri => 'శు',
						sat => 'శ',
						sun => 'ఆ'
					},
					short => {
						mon => 'సోమ',
						tue => 'మం',
						wed => 'బుధ',
						thu => 'గురు',
						fri => 'శుక్ర',
						sat => 'శని',
						sun => 'ఆది'
					},
					wide => {
						mon => 'సోమవారం',
						tue => 'మంగళవారం',
						wed => 'బుధవారం',
						thu => 'గురువారం',
						fri => 'శుక్రవారం',
						sat => 'శనివారం',
						sun => 'ఆదివారం'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'త్రై1',
						1 => 'త్రై2',
						2 => 'త్రై3',
						3 => 'త్రై4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1వ త్రైమాసికం',
						1 => '2వ త్రైమాసికం',
						2 => '3వ త్రైమాసికం',
						3 => '4వ త్రైమాసికం'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'త్రై1',
						1 => 'త్రై2',
						2 => 'త్రై3',
						3 => 'త్రై4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1వ త్రైమాసికం',
						1 => '2వ త్రైమాసికం',
						2 => '3వ త్రైమాసికం',
						3 => '4వ త్రైమాసికం'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{మధ్యాహ్నం},
					'am' => q{AM},
					'evening1' => q{సాయంత్రం},
					'midnight' => q{అర్ధరాత్రి},
					'morning1' => q{ఉదయం},
					'night1' => q{రాత్రి},
					'pm' => q{PM},
				},
				'narrow' => {
					'afternoon1' => q{మధ్యాహ్నం},
					'am' => q{ఉ},
					'evening1' => q{సాయంత్రం},
					'midnight' => q{అర్ధరాత్రి},
					'morning1' => q{ఉదయం},
					'night1' => q{రాత్రి},
					'pm' => q{సా},
				},
				'wide' => {
					'afternoon1' => q{మధ్యాహ్నం},
					'am' => q{AM},
					'evening1' => q{సాయంత్రం},
					'midnight' => q{అర్ధరాత్రి},
					'morning1' => q{ఉదయం},
					'night1' => q{రాత్రి},
					'pm' => q{PM},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{మధ్యాహ్నం},
					'am' => q{AM},
					'evening1' => q{సాయంత్రం},
					'midnight' => q{అర్ధరాత్రి},
					'morning1' => q{ఉదయం},
					'night1' => q{రాత్రి},
					'pm' => q{PM},
				},
				'narrow' => {
					'afternoon1' => q{మధ్యాహ్నం},
					'am' => q{AM},
					'evening1' => q{సాయంత్రం},
					'midnight' => q{అర్ధరాత్రి},
					'morning1' => q{ఉదయం},
					'night1' => q{రాత్రి},
					'pm' => q{PM},
				},
				'wide' => {
					'afternoon1' => q{మధ్యాహ్నం},
					'am' => q{AM},
					'evening1' => q{సాయంత్రం},
					'midnight' => q{అర్ధరాత్రి},
					'morning1' => q{ఉదయం},
					'night1' => q{రాత్రి},
					'pm' => q{PM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'BE'
			},
			narrow => {
				'0' => 'BE'
			},
			wide => {
				'0' => 'BE'
			},
		},
		'coptic' => {
			abbreviated => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			narrow => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			wide => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			narrow => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			wide => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'క్రీపూ',
				'1' => 'క్రీశ'
			},
			wide => {
				'0' => 'క్రీస్తు పూర్వం',
				'1' => 'క్రీస్తు శకం'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
			narrow => {
				'0' => 'AM'
			},
			wide => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'శక'
			},
			narrow => {
				'0' => 'శక'
			},
			wide => {
				'0' => 'శక'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
			narrow => {
				'0' => 'AH'
			},
			wide => {
				'0' => 'AH'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
			narrow => {
				'0' => 'AP'
			},
			wide => {
				'0' => 'AP'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'R.O.C. పూర్వం',
				'1' => 'R.O.C.'
			},
			narrow => {
				'0' => 'R.O.C. పూర్వం',
				'1' => 'R.O.C.'
			},
			wide => {
				'0' => 'R.O.C. పూర్వం',
				'1' => 'R.O.C.'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{dd-MM-y GGGGG},
		},
		'gregorian' => {
			'full' => q{d, MMMM y, EEEE},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{dd-MM-yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}కి},
			'long' => q{{1} {0}కి},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			E => q{ccc},
			EBhm => q{B E h:mm},
			EBhms => q{B E h:mm:ss},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d, MMM y G},
			GyMMMd => q{d, MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, d/M/y GGGGG},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d, MMM y G},
			yyyyMMMM => q{MMMM YYYY},
			yyyyMMMd => q{d, MMM y G},
			yyyyMd => q{d/M/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G MMM y},
			GyMMMEd => q{G, d MMM, y, E},
			GyMMMd => q{G d, MMM y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{d/M, E},
			MMM => q{LLL},
			MMMEd => q{d MMM, E},
			MMMMW => q{MMMMలో Wవ వారం},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{d/M/y, E},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{d MMM, y, E},
			yMMMM => q{MMMM y},
			yMMMd => q{d, MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Yలో wవ వారం},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y – y},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{G y MMM d–d},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y GGGG},
				y => q{d/M/y – d/M/y},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{d/M, E – d/M, E},
				d => q{d/M, E – d/M, E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{d MMM, E – d MMM, E},
				d => q{d MMM, E – d MMM, E},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{d/M/y, E – d/M/y, E},
				d => q{d/M/y, E – d/M/y, E},
				y => q{d/M/y, E – d/M/y, E},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{d MMM, E – d MMM, y, E},
				d => q{d MMM, E – d MMM, y, E},
				y => q{d MMM, y, E – d MMM, y, E},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d–d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} సమయం),
		regionFormat => q({0} పగటి వెలుతురు సమయం),
		regionFormat => q({0} ప్రామాణిక సమయం),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q#ఏకర్ వేసవి సమయం#,
				'generic' => q#ఏకర్ సమయం#,
				'standard' => q#ఏకర్ ప్రామాణిక సమయం#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#ఆఫ్ఘనిస్తాన్ సమయం#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#అబిడ్జాన్#,
		},
		'Africa/Accra' => {
			exemplarCity => q#అక్రా#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#యాడిస్ అబాబా#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#అల్జియర్స్#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#అస్మారా#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#బామాకో#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#బాంగుయ్#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#బంజూల్#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#బిస్సావ్#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#బ్లాన్టైర్#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#బ్రాజావిల్లే#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#బుజమ్బురా#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#కైరో#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#కాసాబ్లాంకా#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#స్యూటా#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#కోనాక్రీ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#డకార్#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#దార్ ఎస్ సలామ్#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#డిజ్బౌటి#,
		},
		'Africa/Douala' => {
			exemplarCity => q#డౌలా#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ఎల్ ఎయున్#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ఫ్రీటౌన్#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#గబోరోన్#,
		},
		'Africa/Harare' => {
			exemplarCity => q#హరారే#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#జొహెన్స్‌బర్గ్#,
		},
		'Africa/Juba' => {
			exemplarCity => q#జుబా#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#కంపాలా#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ఖార్టోమ్#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#కీగలి#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#కిన్షాసా#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#లాగోస్#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#లెబర్విల్లే#,
		},
		'Africa/Lome' => {
			exemplarCity => q#లోమ్#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#లువాండా#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#లుబంబాషి#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#లుసాకా#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#మలాబో#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#మాపుటో#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#మసేరు#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#బాబెన్#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#మోగాదిషు#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#మోన్రోవియా#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#నైరోబీ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#డ్జామెనా#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#నియామే#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#న్వాక్షోట్#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ఔగాడౌగోవ్#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#పోర్టో-నోవో#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#సావో టోమ్#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ట్రిపోలి#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ట్యునిస్#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#విండ్హోక్#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#సెంట్రల్ ఆఫ్రికా సమయం#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#తూర్పు ఆఫ్రికా సమయం#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#దక్షిణ ఆఫ్రికా ప్రామాణిక సమయం#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#పశ్చిమ ఆఫ్రికా వేసవి సమయం#,
				'generic' => q#పశ్చిమ ఆఫ్రికా సమయం#,
				'standard' => q#పశ్చిమ ఆఫ్రికా ప్రామాణిక సమయం#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#అలాస్కా పగటి వెలుతురు సమయం#,
				'generic' => q#అలాస్కా సమయం#,
				'standard' => q#అలాస్కా ప్రామాణిక సమయం#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#అల్మాటి వేసవి సమయం#,
				'generic' => q#అల్మాటి సమయం#,
				'standard' => q#అల్మాటి ప్రామాణిక సమయం#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#అమెజాన్ వేసవి సమయం#,
				'generic' => q#అమెజాన్ సమయం#,
				'standard' => q#అమెజాన్ ప్రామాణిక సమయం#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#అడాక్#,
		},
		'America/Anchorage' => {
			exemplarCity => q#యాంకరేజ్#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ఆంగ్విల్లా#,
		},
		'America/Antigua' => {
			exemplarCity => q#ఆంటిగ్వా#,
		},
		'America/Araguaina' => {
			exemplarCity => q#అరాగ్వేయీనా#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#లా రియోజ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#రియో గల్లేగోస్#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#సాల్టా#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#శాన్ జ్యూన్#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#శాన్ లూయిస్#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#టుకుమన్#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ఉష్యూయ#,
		},
		'America/Aruba' => {
			exemplarCity => q#అరుబా#,
		},
		'America/Asuncion' => {
			exemplarCity => q#అసున్సియోన్#,
		},
		'America/Bahia' => {
			exemplarCity => q#బహియ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#బహియా బండరాస్#,
		},
		'America/Barbados' => {
			exemplarCity => q#బార్బడోస్#,
		},
		'America/Belem' => {
			exemplarCity => q#బెలెమ్#,
		},
		'America/Belize' => {
			exemplarCity => q#బెలీజ్#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#బ్లాంక్-సబ్లోన్#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#బోవా విస్టా#,
		},
		'America/Bogota' => {
			exemplarCity => q#బగోటా#,
		},
		'America/Boise' => {
			exemplarCity => q#బొయిసీ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#బ్యూనోస్ ఎయిర్స్#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#కేంబ్రిడ్జ్ బే#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#కాంపో గ్రాండ్#,
		},
		'America/Cancun' => {
			exemplarCity => q#కన్‌కూన్#,
		},
		'America/Caracas' => {
			exemplarCity => q#కారాకస్#,
		},
		'America/Catamarca' => {
			exemplarCity => q#కటమార్కా#,
		},
		'America/Cayenne' => {
			exemplarCity => q#కయేన్#,
		},
		'America/Cayman' => {
			exemplarCity => q#కేమాన్#,
		},
		'America/Chicago' => {
			exemplarCity => q#చికాగో#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#చువావా#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#అటికోకన్#,
		},
		'America/Cordoba' => {
			exemplarCity => q#కోర్డోబా#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#కోస్టా రికా#,
		},
		'America/Creston' => {
			exemplarCity => q#క్రెస్టన్#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#కుయబా#,
		},
		'America/Curacao' => {
			exemplarCity => q#కురాకవో#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#డెన్మార్క్‌షాన్#,
		},
		'America/Dawson' => {
			exemplarCity => q#డాసన్#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#డాసన్ క్రీక్#,
		},
		'America/Denver' => {
			exemplarCity => q#డెన్వెర్#,
		},
		'America/Detroit' => {
			exemplarCity => q#డిట్రోయిట్#,
		},
		'America/Dominica' => {
			exemplarCity => q#డొమినికా#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ఎడ్మోంటన్#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ఇరునెప్#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ఎల్ సాల్వడోర్#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ఫోర్ట్ నెల్సన్#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ఫోర్టలేజా#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#గ్లేస్ బే#,
		},
		'America/Godthab' => {
			exemplarCity => q#నూక్#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#గూస్ బే#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#గ్రాండ్ టర్క్#,
		},
		'America/Grenada' => {
			exemplarCity => q#గ్రెనడా#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#గ్వాడెలోప్#,
		},
		'America/Guatemala' => {
			exemplarCity => q#గ్వాటిమాలా#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#గయాక్విల్#,
		},
		'America/Guyana' => {
			exemplarCity => q#గయానా#,
		},
		'America/Halifax' => {
			exemplarCity => q#హాలిఫాక్స్#,
		},
		'America/Havana' => {
			exemplarCity => q#హవానా#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#హెర్మోసిల్లో#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#నోక్స్, ఇండియాన#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#మరెంగో, ఇండియాన#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#పీటర్స్‌బర్గ్, ఇండియాన#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#టెల్ నగరం, ఇండియాన#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#వెవయ్, ఇండియాన#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#విన్‌సెన్నెస్, ఇండియాన#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#వినామాక్, ఇండియాన#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ఇండియానపోలిస్#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ఇనువిక్#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ఇక్వాలిట్#,
		},
		'America/Jamaica' => {
			exemplarCity => q#జమైకా#,
		},
		'America/Jujuy' => {
			exemplarCity => q#జుజుయ్#,
		},
		'America/Juneau' => {
			exemplarCity => q#జూనో#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#మోంటిసెల్లో, కెన్‌టుక్కీ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#క్రలెండ్జిక్#,
		},
		'America/La_Paz' => {
			exemplarCity => q#లా పాజ్#,
		},
		'America/Lima' => {
			exemplarCity => q#లిమా#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#లాస్ ఏంజల్స్#,
		},
		'America/Louisville' => {
			exemplarCity => q#లూయివిల్#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#లోయర్ ప్రిన్స్ క్వార్టర్#,
		},
		'America/Maceio' => {
			exemplarCity => q#మాసియో#,
		},
		'America/Managua' => {
			exemplarCity => q#మనాగువా#,
		},
		'America/Manaus' => {
			exemplarCity => q#మనాస్#,
		},
		'America/Marigot' => {
			exemplarCity => q#మారిగోట్#,
		},
		'America/Martinique' => {
			exemplarCity => q#మార్టినీక్#,
		},
		'America/Matamoros' => {
			exemplarCity => q#మాటమొరోస్#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#మాసట్‌లాన్#,
		},
		'America/Mendoza' => {
			exemplarCity => q#మెండోజా#,
		},
		'America/Menominee' => {
			exemplarCity => q#మెనోమినీ#,
		},
		'America/Merida' => {
			exemplarCity => q#మెరిడా#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#మెట్లకట్ల#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#మెక్సికో నగరం#,
		},
		'America/Miquelon' => {
			exemplarCity => q#మికెలాన్#,
		},
		'America/Moncton' => {
			exemplarCity => q#మోన్‌క్టోన్#,
		},
		'America/Monterrey' => {
			exemplarCity => q#మోంటెర్రే#,
		},
		'America/Montevideo' => {
			exemplarCity => q#మోంటెవీడియో#,
		},
		'America/Montserrat' => {
			exemplarCity => q#మాంట్సెరాట్#,
		},
		'America/Nassau' => {
			exemplarCity => q#నాస్సావ్#,
		},
		'America/New_York' => {
			exemplarCity => q#న్యూయార్క్#,
		},
		'America/Nipigon' => {
			exemplarCity => q#నిపిగోన్#,
		},
		'America/Nome' => {
			exemplarCity => q#నోమ్#,
		},
		'America/Noronha' => {
			exemplarCity => q#నరోన్హా#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#బ్యులా, ఉత్తర డకోట#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#సెంటర్, ఉత్తర డకోటా#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#న్యూ సలేమ్, ఉత్తర డకోట#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ఒజినగ#,
		},
		'America/Panama' => {
			exemplarCity => q#పనామా#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#పాంగ్‌నీర్‌టుంగ్#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#పరామారిబో#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ఫినిక్స్#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#పోర్ట్-అవ్-ప్రిన్స్#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#పోర్ట్ ఆఫ్ స్పెయిన్#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#పోర్టో వెల్హో#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ప్యూర్టో రికో#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#పుంటా అరీనస్#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#రెయినీ రివర్#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#రన్‌కిన్ ఇన్‌లెట్#,
		},
		'America/Recife' => {
			exemplarCity => q#రెసిఫీ#,
		},
		'America/Regina' => {
			exemplarCity => q#రెజీనా#,
		},
		'America/Resolute' => {
			exemplarCity => q#రిజల్యూట్#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#రియో బ్రాంకో#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#శాంటా ఇసబెల్#,
		},
		'America/Santarem' => {
			exemplarCity => q#సాంటరెమ్#,
		},
		'America/Santiago' => {
			exemplarCity => q#శాంటియాగో#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#శాంటో డోమింగో#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#సావో పాలో#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ఇటోక్కోర్టూర్మిట్#,
		},
		'America/Sitka' => {
			exemplarCity => q#సిట్కా#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#సెయింట్ బర్తెలెమీ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#సెయింట్ జాన్స్#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#సెయింట్ కిట్స్#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#సెయింట్ లూసియా#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#సెయింట్ థామస్#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#సెయింట్ విన్సెంట్#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#స్విఫ్ట్ కరెంట్#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#తెగుసిగల్పా#,
		},
		'America/Thule' => {
			exemplarCity => q#థులే#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#థండర్ బే#,
		},
		'America/Tijuana' => {
			exemplarCity => q#టిజువానా#,
		},
		'America/Toronto' => {
			exemplarCity => q#టొరంటో#,
		},
		'America/Tortola' => {
			exemplarCity => q#టోర్టోలా#,
		},
		'America/Vancouver' => {
			exemplarCity => q#వాన్కూవర్#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#వైట్‌హార్స్#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#విన్నిపెగ్#,
		},
		'America/Yakutat' => {
			exemplarCity => q#యకుటాట్#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ఎల్లోనైఫ్#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#మధ్యమ పగటి వెలుతురు సమయం#,
				'generic' => q#మధ్యమ సమయం#,
				'standard' => q#మధ్యమ ప్రామాణిక సమయం#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#తూర్పు పగటి వెలుతురు సమయం#,
				'generic' => q#తూర్పు సమయం#,
				'standard' => q#తూర్పు ప్రామాణిక సమయం#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#మౌంటెయిన్ పగటి వెలుతురు సమయం#,
				'generic' => q#మౌంటెయిన్ సమయం#,
				'standard' => q#మౌంటెయిన్ ప్రామాణిక సమయం#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#పసిఫిక్ పగటి వెలుతురు సమయం#,
				'generic' => q#పసిఫిక్ సమయం#,
				'standard' => q#పసిఫిక్ ప్రామాణిక సమయం#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#అనాన్డ్రి వేసవి సమయం#,
				'generic' => q#అనడైర్ సమయం#,
				'standard' => q#అనాన్డ్రి ప్రామాణిక సమయం#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#కేసీ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#డెవిస్#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#డ్యూమాంట్ డి’ఉర్విల్లే#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#మకారీ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#మాసన్#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#మెక్‌ముర్డో#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#పాల్మర్#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#రొతేరా#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#స్యోవా#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ట్రోల్#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#వోస్టోక్#,
		},
		'Apia' => {
			long => {
				'daylight' => q#ఏపియా పగటి సమయం#,
				'generic' => q#ఏపియా సమయం#,
				'standard' => q#ఏపియా ప్రామాణిక సమయం#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#అక్వాటు వేసవి సమయం#,
				'generic' => q#అక్వాటు సమయం#,
				'standard' => q#అక్వాటు ప్రామాణిక సమయం#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#అక్టోబె వేసవి సమయం#,
				'generic' => q#అక్టోబె సమయం#,
				'standard' => q#అక్టోబె ప్రామాణిక సమయం#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#అరేబియన్ పగటి వెలుతురు సమయం#,
				'generic' => q#అరేబియన్ సమయం#,
				'standard' => q#అరేబియన్ ప్రామాణిక సమయం#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#లాంగ్‌యియర్‌బైయన్#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ఆర్జెంటీనా వేసవి సమయం#,
				'generic' => q#అర్జెంటీనా సమయం#,
				'standard' => q#అర్జెంటీనా ప్రామాణిక సమయం#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#పశ్చిమ అర్జెంటీనా వేసవి సమయం#,
				'generic' => q#పశ్చిమ అర్జెంటీనా సమయం#,
				'standard' => q#పశ్చిమ అర్జెంటీనా ప్రామాణిక సమయం#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ఆర్మేనియా వేసవి సమయం#,
				'generic' => q#ఆర్మేనియా సమయం#,
				'standard' => q#ఆర్మేనియా ప్రామాణిక సమయం#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ఎడెన్#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ఆల్మాటి#,
		},
		'Asia/Amman' => {
			exemplarCity => q#అమ్మన్#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#అనడైర్#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#అక్టావ్#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#అక్టోబ్#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#యాష్గాబాట్#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#ఆటిరా#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#బాగ్దాద్#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#బహ్రెయిన్#,
		},
		'Asia/Baku' => {
			exemplarCity => q#బాకు#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#బ్యాంకాక్#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#బార్నాల్#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#బీరట్#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#బిష్కెక్#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#బ్రూనై#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#కోల్‌కతా#,
		},
		'Asia/Chita' => {
			exemplarCity => q#చితా#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#చోయిబాల్సన్#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#కొలంబో#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#డమాస్కస్#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ఢాకా#,
		},
		'Asia/Dili' => {
			exemplarCity => q#డిలి#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#దుబాయి#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#డుషన్బీ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ఫామగుస్టా#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#గాజా#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#హెబ్రాన్#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#హాంకాంగ్#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#హోవ్డ్#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ఇర్కుట్స్క్#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#జకార్తా#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#జయపుర#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#జరూసలేం#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#కాబుల్#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#కమ్‌చత్కా#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#కరాచీ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ఖాట్మండు#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#కంద్యాగ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#క్రసనోయార్స్క్#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#కౌలాలంపూర్#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#కుచింగ్#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#కువైట్#,
		},
		'Asia/Macau' => {
			exemplarCity => q#మకావ్#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#మగడాన్#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#మకాస్సర్#,
		},
		'Asia/Manila' => {
			exemplarCity => q#మనీలా#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#మస్కట్#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#నికోసియా#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#నొవొకుజ్‌నెట్‌స్క్#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#నవోసిబిర్స్క్#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ఓమ్స్క్#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ఓరల్#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#నోమ్‌పెన్హ్#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#పొన్టియనాక్#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ప్యోంగాంగ్#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ఖతార్#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#క్విజిలోర్డా#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#యాంగన్#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#రియాధ్#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#హో చి మిన్హ్ నగరం#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#సఖాలిన్#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#సమర్కాండ్#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#సియోల్#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#షాంఘై#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#సింగపూర్#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#స్రెడ్నెకొలిమ్స్క్#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#తైపీ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#తాష్కెంట్#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#టిబిలిసి#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#టెహ్రాన్#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#థింఫు#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#టోక్యో#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#టామ్స్క్#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ఉలాన్బాటర్#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ఉరుమ్‌కీ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#అస్ట్-నెరా#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#వియన్టైన్#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#వ్లాడివోస్టోక్#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#యకుట్స్క్#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#యెకటెరింబర్గ్#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#యెరెవన్#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#అట్లాంటిక్ పగటి వెలుతురు సమయం#,
				'generic' => q#అట్లాంటిక్ సమయం#,
				'standard' => q#అట్లాంటిక్ ప్రామాణిక సమయం#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#అజోర్స్#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#బెర్ముడా#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#కెనరీ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#కేప్ వెర్డె#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ఫారో#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#మదైరా#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#రెక్జావిక్#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#దక్షిణ జార్జియా#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#సెయింట్ హెలెనా#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#స్టాన్లీ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#అడెలైడ్#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#బ్రిస్‌బెయిన్#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#బ్రోకెన్ హిల్#,
		},
		'Australia/Currie' => {
			exemplarCity => q#కర్రీ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#డార్విన్#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#యుక్లా#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#హోబర్ట్#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#లిండెమాన్#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#లార్డ్ హౌ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#మెల్బోర్న్#,
		},
		'Australia/Perth' => {
			exemplarCity => q#పెర్త్#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#సిడ్నీ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ఆస్ట్రేలియా మధ్యమ పగటి వెలుతురు సమయం#,
				'generic' => q#ఆస్ట్రేలియా మధ్యమ సమయం#,
				'standard' => q#ఆస్ట్రేలియా మధ్యమ ప్రామాణిక సమయం#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ఆస్ట్రేలియా మధ్యమ పశ్చిమ పగటి వెలుతురు సమయం#,
				'generic' => q#ఆస్ట్రేలియా మధ్యమ పశ్చిమ సమయం#,
				'standard' => q#మధ్యమ ఆస్ట్రేలియన్ పశ్చిమ ప్రామాణిక సమయం#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ఆస్ట్రేలియన్ తూర్పు పగటి వెలుతురు సమయం#,
				'generic' => q#తూర్పు ఆస్ట్రేలియా సమయం#,
				'standard' => q#ఆస్ట్రేలియన్ తూర్పు ప్రామాణిక సమయం#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ఆస్ట్రేలియన్ పశ్చిమ పగటి వెలుతురు సమయం#,
				'generic' => q#పశ్చిమ ఆస్ట్రేలియా సమయం#,
				'standard' => q#ఆస్ట్రేలియన్ పశ్చిమ ప్రామాణిక సమయం#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#అజర్బైజాన్ వేసవి సమయం#,
				'generic' => q#అజర్బైజాన్ సమయం#,
				'standard' => q#అజర్బైజాన్ ప్రామాణిక సమయం#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#అజోర్స్ వేసవి సమయం#,
				'generic' => q#అజోర్స్ సమయం#,
				'standard' => q#అజోర్స్ ప్రామాణిక సమయం#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#బంగ్లాదేశ్ వేసవి సమయం#,
				'generic' => q#బంగ్లాదేశ్ సమయం#,
				'standard' => q#బంగ్లాదేశ్ ప్రామాణిక సమయం#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#భూటాన్ సమయం#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#బొలీవియా సమయం#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#బ్రెజిలియా వేసవి సమయం#,
				'generic' => q#బ్రెజిలియా సమయం#,
				'standard' => q#బ్రెజిలియా ప్రామాణిక సమయం#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#బ్రూనే దరుసలామ్ సమయం#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#కేప్ వెర్డె వేసవి సమయం#,
				'generic' => q#కేప్ వెర్డె సమయం#,
				'standard' => q#కేప్ వెర్డె ప్రామాణిక సమయం#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#చామర్రో ప్రామాణిక సమయం#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#చాథమ్ పగటి వెలుతురు సమయం#,
				'generic' => q#చాథమ్ సమయం#,
				'standard' => q#చాథమ్ ప్రామాణిక సమయం#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#చిలీ వేసవి సమయం#,
				'generic' => q#చిలీ సమయం#,
				'standard' => q#చిలీ ప్రామాణిక సమయం#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#చైనా పగటి వెలుతురు సమయం#,
				'generic' => q#చైనా సమయం#,
				'standard' => q#చైనా ప్రామాణిక సమయం#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#చోయిబల్సాన్ వేసవి సమయం#,
				'generic' => q#చోయిబల్సాన్ సమయం#,
				'standard' => q#చోయిబల్సాన్ ప్రామాణిక సమయం#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#క్రిస్మస్ దీవి సమయం#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#కోకోస్ దీవుల సమయం#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#కొలంబియా వేసవి సమయం#,
				'generic' => q#కొలంబియా సమయం#,
				'standard' => q#కొలంబియా ప్రామాణిక సమయం#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#కుక్ దీవుల అర్ధ వేసవి సమయం#,
				'generic' => q#కుక్ దీవుల సమయం#,
				'standard' => q#కుక్ దీవుల ప్రామాణిక సమయం#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#క్యూబా పగటి వెలుతురు సమయం#,
				'generic' => q#క్యూబా సమయం#,
				'standard' => q#క్యూబా ప్రామాణిక సమయం#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#డేవిస్ సమయం#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#డ్యూమాంట్-డి’ఉర్విల్లే సమయం#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#తూర్పు తైమూర్ సమయం#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ఈస్టర్ దీవి వేసవి సమయం#,
				'generic' => q#ఈస్టర్ దీవి సమయం#,
				'standard' => q#ఈస్టర్ దీవి ప్రామాణిక సమయం#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ఈక్వడార్ సమయం#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#సమన్వయ సార్వజనీన సమయం#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#తెలియని నగరం#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ఆమ్‌స్టర్‌డామ్#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#అండోరా#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#అస్ట్రఖాన్#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ఏథెన్స్#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#బెల్‌గ్రేడ్#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#బెర్లిన్#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#బ్రాటిస్లావా#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#బ్రస్సెల్స్#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#బుకారెస్ట్#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#బుడాపెస్ట్#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#బసింజన్#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#చిసినావ్#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#కోపెన్హాగన్#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#డబ్లిన్#,
			long => {
				'daylight' => q#ఐరిష్ ప్రామాణిక సమయం#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#జిబ్రాల్టర్#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#గ్వెర్న్సే#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#హెల్సింకి#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ఐల్ ఆఫ్ మేన్#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ఇస్తాంబుల్#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#జెర్సీ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#కలినిన్‌గ్రద్#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#కీవ్#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#కిరోవ్#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#లిస్బన్#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ల్యూబ్ల్యానా#,
		},
		'Europe/London' => {
			exemplarCity => q#లండన్#,
			long => {
				'daylight' => q#బ్రిటీష్ వేసవి సమయం#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#లక్సెంబర్గ్#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#మాడ్రిడ్#,
		},
		'Europe/Malta' => {
			exemplarCity => q#మాల్టా#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#మారీయుహమ్#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#మిన్స్క్#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#మొనాకో#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#మాస్కో#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ఓస్లో#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ప్యారిస్#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#పోడ్గోరికా#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ప్రాగ్#,
		},
		'Europe/Riga' => {
			exemplarCity => q#రీగా#,
		},
		'Europe/Rome' => {
			exemplarCity => q#రోమ్#,
		},
		'Europe/Samara' => {
			exemplarCity => q#సమార#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#శాన్ మారినో#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#సరాజోవో#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#సరాటవ్#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#సిమ్‌ఫెరోపోల్#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#స్కోప్‌యే#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#సోఫియా#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#స్టాక్హోమ్#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#తాల్లిన్#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#టిరేన్#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ఉల్యనోవ్స్క్#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ఉజ్‌హోరోడ్#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#వాడుజ్#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#వాటికన్#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#వియన్నా#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#విల్నియస్#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#వోల్గోగ్రాడ్#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#వార్షా#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#జాగ్రెబ్#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#జపరోజై#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#జ్యూరిచ్#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#సెంట్రల్ యూరోపియన్ వేసవి సమయం#,
				'generic' => q#సెంట్రల్ యూరోపియన్ సమయం#,
				'standard' => q#సెంట్రల్ యూరోపియన్ ప్రామాణిక సమయం#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#తూర్పు యూరోపియన్ వేసవి సమయం#,
				'generic' => q#తూర్పు యూరోపియన్ సమయం#,
				'standard' => q#తూర్పు యూరోపియన్ ప్రామాణిక సమయం#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#సుదూర-తూర్పు యూరోపియన్ సమయం#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#పశ్చిమ యూరోపియన్ వేసవి సమయం#,
				'generic' => q#పశ్చిమ యూరోపియన్ సమయం#,
				'standard' => q#పశ్చిమ యూరోపియన్ ప్రామాణిక సమయం#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ఫాక్‌ల్యాండ్ దీవుల వేసవి సమయం#,
				'generic' => q#ఫాక్‌ల్యాండ్ దీవుల సమయం#,
				'standard' => q#ఫాక్‌ల్యాండ్ దీవుల ప్రామాణిక సమయం#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ఫిజీ వేసవి సమయం#,
				'generic' => q#ఫిజీ సమయం#,
				'standard' => q#ఫిజీ ప్రామాణిక సమయం#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ఫ్రెంచ్ గయానా సమయం#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ఫ్రెంచ్ దక్షిణ మరియు అంటార్కిటిక్ సమయం#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#గ్రీన్‌విచ్ సగటు సమయం#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#గాలాపాగోస్ సమయం#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#గాంబియర్ సమయం#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#జార్జియా వేసవి సమయం#,
				'generic' => q#జార్జియా సమయం#,
				'standard' => q#జార్జియా ప్రామాణిక సమయం#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#గిల్బర్ట్ దీవుల సమయం#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#తూర్పు గ్రీన్‌ల్యాండ్ వేసవి సమయం#,
				'generic' => q#తూర్పు గ్రీన్‌ల్యాండ్ సమయం#,
				'standard' => q#తూర్పు గ్రీన్‌ల్యాండ్ ప్రామాణిక సమయం#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#పశ్చిమ గ్రీన్‌ల్యాండ్ వేసవి సమయం#,
				'generic' => q#పశ్చిమ గ్రీన్‌ల్యాండ్ సమయం#,
				'standard' => q#పశ్చిమ గ్రీన్‌ల్యాండ్ ప్రామాణిక సమయం#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#గ్వామ్ ప్రామాణిక సమయం#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#గల్ఫ్ ప్రామాణిక సమయం#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#గయానా సమయం#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#హవాయ్-అల్యూషియన్ పగటి వెలుతురు సమయం#,
				'generic' => q#హవాయ్-అల్యూషియన్ సమయం#,
				'standard' => q#హవాయ్-అల్యూషియన్ ప్రామాణిక సమయం#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#హాంకాంగ్ వేసవి సమయం#,
				'generic' => q#హాంకాంగ్ సమయం#,
				'standard' => q#హాంకాంగ్ ప్రామాణిక సమయం#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#హోవ్డ్ వేసవి సమయం#,
				'generic' => q#హోవ్డ్ సమయం#,
				'standard' => q#హోవ్డ్ ప్రామాణిక సమయం#,
			},
		},
		'India' => {
			long => {
				'standard' => q#భారతదేశ సమయం#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#అంటానానారివో#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#చాగోస్#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#క్రిస్మస్#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#కోకోస్#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#కొమోరో#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#కెర్గ్యూలెన్#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#మాహె#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#మాల్దీవులు#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#మారిషస్#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#మయోట్#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#రీయూనియన్#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#హిందూ మహా సముద్ర సమయం#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ఇండోచైనా సమయం#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#సెంట్రల్ ఇండోనేషియా సమయం#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#తూర్పు ఇండోనేషియా సమయం#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#పశ్చిమ ఇండోనేషియా సమయం#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ఇరాన్ పగటి వెలుతురు సమయం#,
				'generic' => q#ఇరాన్ సమయం#,
				'standard' => q#ఇరాన్ ప్రామాణిక సమయం#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ఇర్కుట్స్క్ వేసవి సమయం#,
				'generic' => q#ఇర్కుట్స్క్ సమయం#,
				'standard' => q#ఇర్కుట్స్క్ ప్రామాణిక సమయం#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ఇజ్రాయిల్ పగటి వెలుతురు సమయం#,
				'generic' => q#ఇజ్రాయిల్ సమయం#,
				'standard' => q#ఇజ్రాయిల్ ప్రామాణిక సమయం#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#జపాన్ పగటి వెలుతురు సమయం#,
				'generic' => q#జపాన్ సమయం#,
				'standard' => q#జపాన్ ప్రామాణిక సమయం#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి వేసవి సమయం#,
				'generic' => q#పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి సమయం#,
				'standard' => q#పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి ప్రామాణిక సమయం#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#తూర్పు కజకి‌స్తాన్ సమయం#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#పశ్చిమ కజకిస్తాన్ సమయం#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#కొరియన్ పగటి వెలుతురు సమయం#,
				'generic' => q#కొరియన్ సమయం#,
				'standard' => q#కొరియన్ ప్రామాణిక సమయం#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#కోస్రాయి సమయం#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#క్రాస్నోయార్స్క్ వేసవి సమయం#,
				'generic' => q#క్రాస్నోయార్స్క్ సమయం#,
				'standard' => q#క్రాస్నోయార్స్క్ ప్రామాణిక సమయం#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#కిర్గిస్తాన్ సమయం#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#లంకా సమయం#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#లైన్ దీవుల సమయం#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#లార్డ్ హోవ్ పగటి సమయం#,
				'generic' => q#లార్డ్ హోవ్ సమయం#,
				'standard' => q#లార్డ్ హోవ్ ప్రామాణిక సమయం#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#మకావ్ వేసవి సమయం#,
				'generic' => q#మకావ్ సమయం#,
				'standard' => q#మకావ్ ప్రామాణిక సమయం#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#మాక్క్వారీ దీవి సమయం#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#మగడాన్ వేసవి సమయం#,
				'generic' => q#మగడాన్ సమయం#,
				'standard' => q#మగడాన్ ప్రామాణిక సమయం#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#మలేషియా సమయం#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#మాల్దీవుల సమయం#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#మార్క్వేసాస్ సమయం#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#మార్షల్ దీవుల సమయం#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#మారిషస్ వేసవి సమయం#,
				'generic' => q#మారిషస్ సమయం#,
				'standard' => q#మారిషస్ ప్రామాణిక సమయం#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#మాసన్ సమయం#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#వాయువ్య మెక్సికో పగటి వెలుతురు సమయం#,
				'generic' => q#వాయువ్య మెక్సికో సమయం#,
				'standard' => q#వాయువ్య మెక్సికో ప్రామాణిక సమయం#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#మెక్సికన్ పసిఫిక్ పగటి వెలుతురు సమయం#,
				'generic' => q#మెక్సికన్ పసిఫిక్ సమయం#,
				'standard' => q#మెక్సికన్ పసిఫిక్ ప్రామాణిక సమయం#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ఉలన్ బతోర్ వేసవి సమయం#,
				'generic' => q#ఉలన్ బతోర్ సమయం#,
				'standard' => q#ఉలన్ బతోర్ ప్రామాణిక సమయం#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#మాస్కో వేసవి సమయం#,
				'generic' => q#మాస్కో సమయం#,
				'standard' => q#మాస్కో ప్రామాణిక సమయం#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#మయన్మార్ సమయం#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#నౌరు సమయం#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#నేపాల్ సమయం#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#న్యూ కాలెడోనియా వేసవి సమయం#,
				'generic' => q#న్యూ కాలెడోనియా సమయం#,
				'standard' => q#న్యూ కాలెడోనియా ప్రామాణిక సమయం#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#న్యూజిల్యాండ్ పగటి వెలుతురు సమయం#,
				'generic' => q#న్యూజిల్యాండ్ సమయం#,
				'standard' => q#న్యూజిల్యాండ్ ప్రామాణిక సమయం#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#న్యూఫౌండ్‌ల్యాండ్ పగటి వెలుతురు సమయం#,
				'generic' => q#న్యూఫౌండ్‌ల్యాండ్ సమయం#,
				'standard' => q#న్యూఫౌండ్‌ల్యాండ్ ప్రామాణిక సమయం#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#నియూ సమయం#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#నార్ఫోక్ దీవి సమయం#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ఫెర్నాండో డి నొరోన్హా వేసవి సమయం#,
				'generic' => q#ఫెర్నాండో డి నొరోన్హా సమయం#,
				'standard' => q#ఫెర్నాండో డి నొరోన్హా ప్రామాణిక సమయం#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#ఉత్తర మారియానా దీవుల సమయం#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#నోవోసిబిర్స్క్ వేసవి సమయం#,
				'generic' => q#నోవోసిబిర్స్క్ సమయం#,
				'standard' => q#నోవోసిబిర్క్స్ ప్రామాణిక సమయం#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ఓమ్స్క్ వేసవి సమయం#,
				'generic' => q#ఓమ్స్క్ సమయం#,
				'standard' => q#ఓమ్స్క్ ప్రామాణిక సమయం#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ఏపియా#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ఆక్లాండ్#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#బొగెయిన్‌విల్లే#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#చాథమ్#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ఈస్టర్#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ఇఫేట్#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ఎండర్బెరీ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ఫాకోఫో#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ఫీజీ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ఫునాఫుటి#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#గాలాపాగోస్#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#గాంబియేర్#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#గ్వాడల్కెనాల్#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#గ్వామ్#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#హోనోలులు#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#జాన్సటన్#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#కిరీటిమాటి#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#కోస్రే#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#క్వాజాలైన్#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#మజురో#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#మార్క్వేసాస్#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#మిడ్వే#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#నౌరు#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#నియూ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#నోర్ఫోక్#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#నౌమియా#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#పాగో పాగో#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#పాలావ్#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#పిట్‌కైర్న్#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#పోన్‌పై#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#పోర్ట్ మోరెస్బే#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#రరోటోంగా#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#సాయ్పాన్#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#తహితి#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#టరావా#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#టోంగాటాపు#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#చుక్#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#వేక్#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#వాల్లిస్#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#పాకిస్తాన్ వేసవి సమయం#,
				'generic' => q#పాకిస్తాన్ సమయం#,
				'standard' => q#పాకిస్తాన్ ప్రామాణిక సమయం#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#పాలావ్ సమయం#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#పాపువా న్యూ గినియా సమయం#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#పరాగ్వే వేసవి సమయం#,
				'generic' => q#పరాగ్వే సమయం#,
				'standard' => q#పరాగ్వే ప్రామాణిక సమయం#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#పెరూ వేసవి సమయం#,
				'generic' => q#పెరూ సమయం#,
				'standard' => q#పెరూ ప్రామాణిక సమయం#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ఫిలిప్పైన్ వేసవి సమయం#,
				'generic' => q#ఫిలిప్పైన్ సమయం#,
				'standard' => q#ఫిలిప్పైన్ ప్రామాణిక సమయం#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ఫినిక్స్ దీవుల సమయం#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#సెయింట్ పియర్ మరియు మిక్వెలాన్ పగటి వెలుతురు సమయం#,
				'generic' => q#సెయింట్ పియెర్ మరియు మిక్వెలాన్ సమయం#,
				'standard' => q#సెయింట్ పియెర్ మరియు మిక్వెలాన్ ప్రామాణిక సమయం#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#పిట్‌కైర్న్ సమయం#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#పొనేప్ సమయం#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#ప్యోంగాంగ్ సమయం#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#కిజిలోర్డా వేసవి సమయం#,
				'generic' => q#కిజిలోర్డా సమయం#,
				'standard' => q#కిజిలోర్డా ప్రామాణిక సమయం#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#రీయూనియన్ సమయం#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#రొతేరా సమయం#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#సఖాలిన్ వేసవి సమయం#,
				'generic' => q#సఖాలిన్ సమయం#,
				'standard' => q#సఖాలిన్ ప్రామాణిక సమయం#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#సమారా వేసవి సమయం#,
				'generic' => q#సమారా సమయం#,
				'standard' => q#సమారా ప్రామాణిక సమయం#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#సమోవా పగటి వెలుతురు సమయం#,
				'generic' => q#సమోవా సమయం#,
				'standard' => q#సమోవా ప్రామాణిక సమయం#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#సీషెల్స్ సమయం#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#సింగపూర్ ప్రామాణిక సమయం#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#సోలమన్ దీవుల సమయం#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#దక్షిణ జార్జియా సమయం#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#సూరినామ్ సమయం#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#స్యోవా సమయం#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#తహితి సమయం#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#తైపీ పగటి వెలుతురు సమయం#,
				'generic' => q#తైపీ సమయం#,
				'standard' => q#తైపీ ప్రామాణిక సమయం#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#తజికిస్తాన్ సమయం#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#టోకెలావ్ సమయం#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#టాంగా వేసవి సమయం#,
				'generic' => q#టాంగా సమయం#,
				'standard' => q#టాంగా ప్రామాణిక సమయం#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#చక్ సమయం#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#తుర్క్‌మెనిస్తాన్ వేసవి సమయం#,
				'generic' => q#తుర్క్‌మెనిస్తాన్ సమయం#,
				'standard' => q#తుర్క్‌మెనిస్తాన్ ప్రామాణిక సమయం#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#తువాలు సమయం#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ఉరుగ్వే వేసవి సమయం#,
				'generic' => q#ఉరుగ్వే సమయం#,
				'standard' => q#ఉరుగ్వే ప్రామాణిక సమయం#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ఉజ్బెకిస్తాన్ వేసవి సమయం#,
				'generic' => q#ఉజ్బెకిస్తాన్ సమయం#,
				'standard' => q#ఉజ్బెకిస్తాన్ ప్రామాణిక సమయం#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#వనౌటు వేసవి సమయం#,
				'generic' => q#వనౌటు సమయం#,
				'standard' => q#వనౌటు ప్రామాణిక సమయం#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#వెనిజులా సమయం#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#వ్లాడివోస్టోక్ వేసవి సమయం#,
				'generic' => q#వ్లాడివోస్టోక్ సమయం#,
				'standard' => q#వ్లాడివోస్టోక్ ప్రామాణిక సమయం#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#వోల్గోగ్రాడ్ వేసవి సమయం#,
				'generic' => q#వోల్గోగ్రాడ్ సమయం#,
				'standard' => q#వోల్గోగ్రాడ్ ప్రామాణిక సమయం#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#వోస్టోక్ సమయం#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#వేక్ దీవి సమయం#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#వాలీస్ మరియు ఫుటునా సమయం#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#యాకుట్స్క్ వేసవి సమయం#,
				'generic' => q#యాకుట్స్క్ సమయం#,
				'standard' => q#యాకుట్స్క్ ప్రామాణిక సమయం#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#యెకటెరిన్‌బర్గ్ వేసవి సమయం#,
				'generic' => q#యెకటెరిన్‌బర్గ్ సమయం#,
				'standard' => q#యెకటెరిన్‌బర్గ్ ప్రామాణిక సమయం#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
