=head1

Locale::CLDR::Locales::Ru::Any::Ua - Package for language Russian

=cut

package Locale::CLDR::Locales::Ru::Any::Ua;
# This file auto generated from Data\common\main\ru_UA.xml
#	on Wed 10 Feb  8:21:53 am GMT

use version;

our $VERSION = version->declare('v0.28.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Ru::Any');
has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'noon' if $time == 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'midnight' if $time == 0;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'default') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'noon' if $time == 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'midnight' if $time == 0;
				}
				last SWITCH;
				}
		}
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH 'ч'.},
			},
			Hv => {
				H => q{HH–HH 'ч'., v},
			},
			MMMEd => {
				d => q{E, d – E, d MMM},
			},
			h => {
				h => q{h–h 'ч'. a},
			},
			hv => {
				h => q{h–h 'ч'. a, v},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y},
				d => q{E, dd.MM.y – E, dd.MM.y},
				y => q{E, dd.MM.y – E, dd.MM.y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y 'г'.},
				d => q{E, d – E, d MMM y 'г'.},
				y => q{E, d MMM y – E, d MMM y 'г'.},
			},
			yMMMM => {
				M => q{LLLL–LLLL y},
				y => q{LLLL y – LLLL y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH 'ч'.},
			},
			Hv => {
				H => q{HH–HH 'ч'., v},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			h => {
				h => q{h–h 'ч'. a},
			},
			hv => {
				h => q{h–h 'ч'. a, v},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y},
				d => q{E, dd.MM.y – E, dd.MM.y},
				y => q{E, dd.MM.y – E, dd.MM.y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y 'г'.},
				d => q{E, d – E, d MMM y 'г'.},
				y => q{E, d MMM y – E, d MMM y 'г'.},
			},
			yMMMM => {
				M => q{LLLL–LLLL y},
				y => q{LLLL y – LLLL y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
		},
	} },
);

no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
