=encoding utf8

=head1 NAME

Locale::CLDR::Locales::My - Package for language Burmese

=cut

package Locale::CLDR::Locales::My;
# This file auto generated from Data\common\main\my.xml
#	on Fri  3 Nov  7:04:07 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { 
		use bigfloat;
		return {
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(အနုတ်→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(သုည),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←←ဒသမ→→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(တစ်),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(နှစ်),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(သုံး),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(လေး),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ငါး),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ခြောက်),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(ခုနှစ်),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(ရှစ်),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ကိုး),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ဆယ်),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(ဆယ့်[→→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(←←ဆယ်[→→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←←ရာ),
				},
				'101' => {
					base_value => q(101),
					divisor => q(100),
					rule => q(←←ရာ့[→→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←←ထောင်),
				},
				'1001' => {
					base_value => q(1001),
					divisor => q(1000),
					rule => q(←←ထောင့်[→→]),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(←←သောင်း[→→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←←သိန်း[→→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←←သန်း[→→]),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(←←ကုဋေ[→→]),
				},
				'100000000000000' => {
					base_value => q(100000000000000),
					divisor => q(100000000000000),
					rule => q(←←ကောဋိ[→→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(အနုတ်→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(ပထမ),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(ဒုတိယ),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(တတိယ),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(စတုတ္ထ),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ပဉ္စမ),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ဆဋ္ဌမ),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(သတ္တမ),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(အဋ္ဌမ),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(နဝမ),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ဒသမ),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}၊ {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'အာဖာ',
 				'ab' => 'အဘ်ခါဇီရာ',
 				'ace' => 'အာချေး',
 				'ada' => 'ဒန်မဲ',
 				'ady' => 'အဒိုင်ဂီ',
 				'af' => 'တောင်အာဖရိက',
 				'agq' => 'အာဂ်ဟိန်း',
 				'ain' => 'အိန်နု',
 				'ak' => 'အာကန်',
 				'ale' => 'အာလီယု',
 				'alt' => 'တောင် အာလ်တိုင်း',
 				'am' => 'အမ်ဟာရစ်ခ်',
 				'an' => 'အာရာဂွန်',
 				'ang' => 'အင်ဂလို ဆက္ကစွန်',
 				'anp' => 'အန်ဂီကာ',
 				'ar' => 'အာရဗီ',
 				'arn' => 'မာပုချီ',
 				'arp' => 'အာရာပါဟို',
 				'as' => 'အာသံ',
 				'asa' => 'အာစု',
 				'ast' => 'အက်စတူရီယန်း',
 				'av' => 'အာဗာရစ်ခ်',
 				'awa' => 'အာဝါဒီ',
 				'ay' => 'အိုင်မာရ',
 				'az' => 'အဇာဘိုင်ဂျန်',
 				'az@alt=short' => 'အဇာရီ',
 				'ba' => 'ဘက်ရှ်ကာ',
 				'ban' => 'ဘာလီ',
 				'bas' => 'ဘာဆာ',
 				'be' => 'ဘီလာရုစ်',
 				'bem' => 'ဘိန်ဘာ',
 				'bez' => 'ဘီနာ',
 				'bg' => 'ဘူလ်ဂေးရီးယား',
 				'bgn' => 'အနောက် ဘဲလိုချီ',
 				'bho' => 'ဘို့ဂျ်ပူရီ',
 				'bi' => 'ဘစ်စ်လာမာ',
 				'bin' => 'ဘီနီ',
 				'bla' => 'စစ္စီကာ',
 				'bm' => 'ဘန်ဘာရာ',
 				'bn' => 'ဘင်္ဂါလီ',
 				'bo' => 'တိဘက်',
 				'br' => 'ဘရီတွန်',
 				'brx' => 'ဗိုဒို',
 				'bs' => 'ဘော့စ်နီးယား',
 				'bug' => 'ဘူဂစ်စ်',
 				'byn' => 'ဘလင်',
 				'ca' => 'ကတ်တလန်',
 				'ce' => 'ချက်ချန်း',
 				'ceb' => 'စီဗူအာနို',
 				'cgg' => 'ချီဂါ',
 				'ch' => 'ချမိုရို',
 				'chk' => 'ချူကီးစ်',
 				'chm' => 'မာရီ',
 				'cho' => 'ချော့တို',
 				'chr' => 'ချာရိုကီ',
 				'chy' => 'ချေယန်း',
 				'ckb' => 'ဆိုရာနီ',
 				'co' => 'ခိုစီကန်',
 				'cr' => 'ခရီး',
 				'crs' => 'ခရီအိုလီ',
 				'cs' => 'ချက်',
 				'cu' => 'ချပ်ချ် စလာဗစ်',
 				'cv' => 'ချူဗက်ရှ်',
 				'cy' => 'ဝေလ',
 				'da' => 'ဒိန်းမတ်',
 				'dak' => 'ဒါကိုတာ',
 				'dar' => 'ဒါဂ်ဝါ',
 				'dav' => 'တိုင်တာ',
 				'de' => 'ဂျာမန်',
 				'de_AT' => 'ဩစတြီးယား ဂျာမန်',
 				'de_CH' => 'အလီမဲန်နစ် ဂျာမန်',
 				'del' => 'ဒယ်လာဝဲလ်',
 				'dgr' => 'ဒေါ့ဂ်ရစ်ဘ်',
 				'dje' => 'ဇာမာ',
 				'dsb' => 'အနိမ့် ဆိုဘီယန်း',
 				'dua' => 'ဒူအလာ',
 				'dum' => 'အလယ်ပိုင်း ဒတ်ချ်',
 				'dv' => 'ဒီဗာဟီ',
 				'dyo' => 'ဂျိုလာ-ဖွန်ရီ',
 				'dz' => 'ဒဇွန်ကာ',
 				'dzg' => 'ဒဇာဂါ',
 				'ebu' => 'အမ်ဘူ',
 				'ee' => 'အီဝီ',
 				'efi' => 'အာဖိခ်',
 				'egy' => 'ရှေးဟောင်း အီဂျစ်',
 				'eka' => 'အီကာဂျုခ်',
 				'el' => 'ဂရိ',
 				'en' => 'အင်္ဂလိပ်',
 				'en_AU' => 'ဩစတြေးလျှ အင်္ဂလိပ်',
 				'en_CA' => 'ကနေဒါ အင်္ဂလိပ်',
 				'en_GB' => 'ဗြိတိသျှ အင်္ဂလိပ်',
 				'en_GB@alt=short' => 'ယူကေ အင်္ဂလိပ်',
 				'en_US' => 'အမေရိကန် အင်္ဂလိပ်',
 				'en_US@alt=short' => 'ယူအက်စ် အင်္ဂလိပ်',
 				'enm' => 'အလယ်ပိုင်း အင်္ဂလိပ်',
 				'eo' => 'အက်စ်ပရန်တို',
 				'es' => 'စပိန်',
 				'es_ES' => 'စပိန် (ဥရောပ)',
 				'et' => 'အက်စ်တိုးနီးယား',
 				'eu' => 'ဘာစ်ခ်',
 				'ewo' => 'အီဝန်ဒို',
 				'fa' => 'ပါရှန်',
 				'ff' => 'ဖူလာ',
 				'fi' => 'ဖင်လန်',
 				'fil' => 'ဖိလစ်ပိုင်',
 				'fj' => 'ဖီဂျီ',
 				'fo' => 'ဖာရို',
 				'fon' => 'ဖော်န်',
 				'fr' => 'ပြင်သစ်',
 				'fr_CA' => 'ကနေဒါ ပြင်သစ်',
 				'fr_CH' => 'ဆွစ် ပြင်သစ်',
 				'frm' => 'အလယ်ပိုင်း ပြင်သစ်',
 				'fro' => 'ဖရန်စီစ်',
 				'frr' => 'မြောက် ဖရီစီရန်',
 				'frs' => 'အရှေ့ ဖရီစီရန်',
 				'fur' => 'ဖရူလီယန်း',
 				'fy' => 'အနောက် ဖရီစီရန်',
 				'ga' => 'အိုင်းရစ်ရှ်',
 				'gaa' => 'ဂါ',
 				'gag' => 'ဂါဂုဇ်',
 				'gd' => 'စကော့တစ်ရှ် ဂေးလစ်ခ်',
 				'gez' => 'ဂီးဇ်',
 				'gil' => 'ကာရီဗာတီ',
 				'gl' => 'ဂါလီစီယာ',
 				'gmh' => 'အလယ်ပိုင်း အမြင့် ဂျာမန်',
 				'gn' => 'ဂူအာရာနီ',
 				'gor' => 'ဂိုရိုတာလို',
 				'grc' => 'ရှေးဟောင်း ဂရိ',
 				'gsw' => 'ဆွစ် ဂျာမန်',
 				'gu' => 'ဂူဂျာရသီ',
 				'guz' => 'ဂူစီး',
 				'gv' => 'မန်းဇ်',
 				'gwi' => 'ဂွစ်ချင်',
 				'ha' => 'ဟာဥစာ',
 				'haw' => 'ဟာဝိုင်ယီ',
 				'he' => 'ဟီးဘရူး',
 				'hi' => 'ဟိန်ဒူ',
 				'hil' => 'ဟီလီဂေနွန်',
 				'hmn' => 'မုံ',
 				'hr' => 'ခရိုအေးရှား',
 				'hsb' => 'ဆက္ကဆိုနီ',
 				'ht' => 'ဟေတီ',
 				'hu' => 'ဟန်ဂေရီ',
 				'hup' => 'ဟူပါ',
 				'hy' => 'အာမေးနီးယား',
 				'hz' => 'ဟီရဲရို',
 				'ia' => 'အင်တာလင်ဂွါ',
 				'iba' => 'အီဗန်',
 				'ibb' => 'အီဘီဘီယို',
 				'id' => 'အင်ဒိုနီးရှား',
 				'ig' => 'အစ္ဂဘို',
 				'ii' => 'စီချွမ် ရီ',
 				'ilo' => 'အီလိုကို',
 				'inh' => 'အင်ဂုရှ်',
 				'io' => 'အီဒို',
 				'is' => 'အိုက်စ်လန်',
 				'it' => 'အီတလီ',
 				'iu' => 'အီနုခ်တီတု',
 				'ja' => 'ဂျပန်',
 				'jbo' => 'လိုဂျ်ဘန်',
 				'jgo' => 'ဂွမ်ဘာ',
 				'jmc' => 'မချာမီ',
 				'jpr' => 'ဂျူဒီယို-ပါရှန်',
 				'jrb' => 'ဂျူဒီယို-အာရဗီ',
 				'jv' => 'ဂျာဗား',
 				'ka' => 'ဂျော်ဂျီယာ',
 				'kab' => 'ကဘိုင်လ်',
 				'kac' => 'ကချင်',
 				'kaj' => 'ဂျူအူ',
 				'kam' => 'ကမ်ဘာ',
 				'kbd' => 'ကဘာဒင်',
 				'kcg' => 'တိုင်အပ်',
 				'kde' => 'မာခွန်ဒီ',
 				'kea' => 'ကဘူဗာဒီအာနူ',
 				'kfo' => 'ကိုရို',
 				'kg' => 'ကွန်ဂို',
 				'kha' => 'ခါစီ',
 				'khq' => 'ကိုရာ ချီအီနီ',
 				'ki' => 'ကီကူယူ',
 				'kj' => 'ကွန်းယာမာ',
 				'kk' => 'ကာဇာချ',
 				'kkj' => 'ကကို',
 				'kl' => 'ကလာအ်လီဆပ်',
 				'kln' => 'ကလန်ဂျင်',
 				'km' => 'ခမာ',
 				'kmb' => 'ကင်ဘွန်ဒူ',
 				'kn' => 'ကန်နာဒါ',
 				'ko' => 'ကိုရီးယား',
 				'koi' => 'ကိုမီ-ပါမြက်',
 				'kok' => 'ကွန်ကနီ',
 				'kpe' => 'ကပ်ပဲလ်',
 				'kr' => 'ကနူရီ',
 				'krc' => 'ကရာချေး-ဘာကာ',
 				'krl' => 'ကာရီလီယန်',
 				'kru' => 'ကူရုပ်ခ်',
 				'ks' => 'ကက်ရှ်မီးယား',
 				'ksb' => 'ရှန်ဘာလာ',
 				'ksf' => 'ဘာဖီအာ',
 				'ksh' => 'ကိုလိုနီယန်း',
 				'ku' => 'ကဒ်',
 				'kum' => 'ကွမ်မိုက်',
 				'kv' => 'ကိုမီ',
 				'kw' => 'ခိုနီရှ်',
 				'ky' => 'ကာဂျစ်',
 				'la' => 'လက်တင်',
 				'lad' => 'လာဒီနို',
 				'lag' => 'လန်ဂီ',
 				'lb' => 'လူဇင်ဘတ်',
 				'lez' => 'လက်ဇ်ဂီးယား',
 				'lg' => 'ဂန်ဒါ',
 				'li' => 'လင်ဘာဂစ်ရှ်',
 				'lkt' => 'လာကိုတာ',
 				'ln' => 'လင်ဂါလာ',
 				'lo' => 'လာအို',
 				'loz' => 'လိုဇီ',
 				'lrc' => 'မြောက်လူရီ',
 				'lt' => 'လစ်သူဝေးနီးယား',
 				'lu' => 'လူဘာ-ကတန်ဂါ',
 				'lua' => 'လူဘာ-လူလူအာ',
 				'lun' => 'လွန်ဒါ',
 				'luo' => 'လူအို',
 				'lus' => 'မီဇို',
 				'luy' => 'လူရီအာ',
 				'lv' => 'လတ်ဗီးယား',
 				'mad' => 'မဒူရာ',
 				'mag' => 'မဂါဟီ',
 				'mai' => 'မိုင်သီလီ',
 				'mak' => 'မကာဆာ',
 				'mas' => 'မာဆိုင်',
 				'mdf' => 'မို့ခ်ရှာ',
 				'men' => 'မန်ဒဲ',
 				'mer' => 'မီရု',
 				'mfe' => 'မောရစ်ရှ',
 				'mg' => 'မာလဂက်စီ',
 				'mga' => 'အလယ်ပိုင်း အိုင်းရစ်ရှ်',
 				'mgh' => 'မာခူဝါ-မီအီတို',
 				'mgo' => 'မီတာ',
 				'mh' => 'မာရှယ်လိဇ်',
 				'mi' => 'မာအိုရီ',
 				'mic' => 'မစ်ခ်မက်ခ်',
 				'min' => 'စူကူမီနန်',
 				'mk' => 'မက်ဆီဒိုးနီးယား',
 				'ml' => 'မလေယာလမ်',
 				'mn' => 'မွန်ဂိုလီးယား',
 				'mnc' => 'မန်ချူး',
 				'mni' => 'မနိပူရ',
 				'moh' => 'မိုဟော့ခ်',
 				'mos' => 'မိုစီ',
 				'mr' => 'မာရသီ',
 				'ms' => 'မလေး',
 				'mt' => 'မော်လ်တာ',
 				'mua' => 'မွန်ဒန်း',
 				'mul' => 'ဘာသာစကား အမျိုးမျိုး',
 				'mus' => 'ခရိချ',
 				'mwl' => 'မီရန်ဒီးဇ်',
 				'my' => 'မြန်မာ',
 				'myv' => 'အီဇယာ',
 				'mzn' => 'မာဇန်ဒါရန်နီ',
 				'na' => 'နော်ရူး',
 				'nap' => 'နပိုလီတန်',
 				'naq' => 'နာမာ',
 				'nb' => 'နော်ဝေ ဘွတ်ခ်မော်လ်',
 				'nd' => 'မြောက် အွန်န်ဒီဘီလီ',
 				'nds' => 'အနိမ့် ဂျာမန်',
 				'nds_NL' => 'ဂျာမန် (နယ်သာလန်)',
 				'ne' => 'နီပေါ',
 				'new' => 'နီဝါရီ',
 				'ng' => 'အွန်ဒွန်ဂါ',
 				'nia' => 'နီးရပ်စ်',
 				'niu' => 'နူအဲယန်း',
 				'nl' => 'ဒတ်ခ်ျ',
 				'nl_BE' => 'ဖလီမစ်ရှ်',
 				'nmg' => 'ကွာစီအို',
 				'nn' => 'နော်ဝေ နီးနောစ်',
 				'nnh' => 'အွန်ရဲဘွန်း',
 				'no' => 'နော်ဝေး',
 				'nog' => 'နိုဂိုင်',
 				'nqo' => 'အွန်ကို',
 				'nr' => 'တောင် အွန်န်ဘီလီ',
 				'nso' => 'မြောက် ဆိုသို',
 				'nus' => 'နူအာ',
 				'nv' => 'နာဗာဟို',
 				'ny' => 'နရန်ဂျာ',
 				'nyn' => 'နရန်ကိုလီ',
 				'oc' => 'အိုစီတန်',
 				'om' => 'အိုရိုမို',
 				'or' => 'အိုရီရာ',
 				'os' => 'အိုဆဲတစ်ခ်',
 				'pa' => 'ပန်ချာပီ',
 				'pag' => 'ပန်ဂါစီနန်',
 				'pam' => 'ပမ်ပန်ညာ',
 				'pap' => 'ပါပီမင်တို',
 				'pau' => 'ပလာအို',
 				'pcm' => 'နိုင်ဂျီးရီးယား ပစ်ဂျင်',
 				'peo' => 'ပါရှန် အဟောင်း',
 				'pi' => 'ပါဠိ',
 				'pl' => 'ပိုလန်',
 				'prg' => 'ပရူရှန်',
 				'ps' => 'ပက်ရှ်တွန်း',
 				'pt' => 'ပေါ်တူဂီ',
 				'pt_BR' => 'ဘရာဇီး ပေါ်တူဂီ',
 				'pt_PT' => 'ဥရောပ ပေါ်တူဂီ',
 				'qu' => 'ခီချူဝါအိုဝါ',
 				'quc' => 'ကီခ်အီချီ',
 				'rap' => 'ရပန်နူအီ',
 				'rar' => 'ရရိုတွန်ဂန်',
 				'rm' => 'ရောမ',
 				'rn' => 'ရွန်ဒီ',
 				'ro' => 'ရိုမေနီယား',
 				'ro_MD' => 'မော်လဒိုဗာ',
 				'rof' => 'ရွမ်ဘို',
 				'root' => 'မူလရင်းမြစ်',
 				'ru' => 'ရုရှ',
 				'rup' => 'အာရိုမန်းနီးယန်း',
 				'rw' => 'ကင်ရာဝန်ဒါ',
 				'rwk' => 'ရူဝမ်',
 				'sa' => 'သင်္သကရိုက်',
 				'sad' => 'ဆန်ဒါဝီ',
 				'sah' => 'ဆခါ',
 				'saq' => 'ဆမ်ဘူရူ',
 				'sat' => 'ဆန်တာလီ',
 				'sba' => 'အွန်ဂမ်းဘေး',
 				'sbp' => 'ဆန်ဂု',
 				'sc' => 'ဆာဒီနီးယား',
 				'scn' => 'စစ္စလီ',
 				'sco' => 'စကော့တ်',
 				'sd' => 'စင်ဒီ',
 				'se' => 'မြောက် ဆာမိ',
 				'seh' => 'စီနာ',
 				'ses' => 'ကိုရာဘိုရို ဆမ်နီ',
 				'sg' => 'ဆန်ဂို',
 				'sga' => 'အိုင်းရစ် ဟောင်း',
 				'shi' => 'တာချယ်လ်ဟစ်',
 				'shn' => 'ရှမ်း',
 				'si' => 'စင်ဟာလာ',
 				'sk' => 'ဆလိုဗက်',
 				'sl' => 'ဆလိုဗေးနီးယား',
 				'sm' => 'ဆမိုအာ',
 				'sma' => 'တောင် ဆာမိ',
 				'smj' => 'လူလီ ဆာမိ',
 				'smn' => 'အီနာရီ ဆာမိ',
 				'sms' => 'စခိုးလ် ဆာမိ',
 				'sn' => 'ရှိုနာ',
 				'snk' => 'ဆိုနင်ကေး',
 				'so' => 'ဆိုမာလီ',
 				'sq' => 'အယ်လ်ဘေးနီးယား',
 				'sr' => 'ဆားဘီးယား',
 				'srn' => 'ဆရာနန် တွန်ဂို',
 				'ss' => 'ဆွာဇီလန်',
 				'ssy' => 'ဆာဟို',
 				'st' => 'တောင်ပိုင်း ဆိုသို',
 				'su' => 'ဆူဒန်',
 				'suk' => 'ဆူကူမာ',
 				'sv' => 'ဆွီဒင်',
 				'sw' => 'ဆွာဟီလီ',
 				'sw_CD' => 'ကွန်ဂို ဆွာဟီလီ',
 				'swb' => 'ကိုမိုရီးယန်း',
 				'syr' => 'ဆီးရီးယား',
 				'ta' => 'တမီးလ်',
 				'te' => 'တီလီဂူ',
 				'tem' => 'တင်မ်နဲ',
 				'teo' => 'တီဆို',
 				'tet' => 'တီတွမ်',
 				'tg' => 'တာဂျစ်',
 				'th' => 'ထိုင်း',
 				'ti' => 'တီဂ်ရင်ယာ',
 				'tig' => 'တီဂရီ',
 				'tk' => 'တာ့ခ်မင်နစ္စတန်',
 				'tlh' => 'ကလင်ဂွန်',
 				'tn' => 'တီဆဝါနာ',
 				'to' => 'တွန်ဂါ',
 				'tpi' => 'တော့ခ် ပိစင်',
 				'tr' => 'တူရကီ',
 				'trv' => 'တရိုကို',
 				'ts' => 'ဆွန်ဂါ',
 				'tt' => 'တာတာ',
 				'tum' => 'တမ်ဘူကာ',
 				'tvl' => 'တူဗာလူ',
 				'twq' => 'တာဆာဝါချ',
 				'ty' => 'တဟီတီ',
 				'tyv' => 'တူဗန်',
 				'tzm' => 'အလယ်အာ့တလာစ် တာမာဇိုက်',
 				'udm' => 'အူမူရတ်',
 				'ug' => 'ဝီဂါ',
 				'uk' => 'ယူကရိန်း',
 				'umb' => 'အူဘန်ဒူ',
 				'und' => 'မသိသော ဘာသာ',
 				'ur' => 'အူရ်ဒူ',
 				'uz' => 'ဥဇဘတ်',
 				'vai' => 'ဗိုင်',
 				've' => 'ဗင်န်ဒါ',
 				'vi' => 'ဗီယက်နမ်',
 				'vo' => 'ဗိုလာပိုက်',
 				'vun' => 'ဗွန်ဂျို',
 				'wa' => 'ဝါလူးန်',
 				'wae' => 'ဝေါလ်ဆာ',
 				'wal' => 'ဝိုလက်တာ',
 				'war' => 'ဝါရေး',
 				'wbp' => 'ဝေါလ်ပီရီ',
 				'wo' => 'ဝူလိုဖ်',
 				'xal' => 'ကာလ်မိုက်',
 				'xh' => 'ဇိုစာ',
 				'xog' => 'ဆိုဂါ',
 				'yav' => 'ရန်ဘဲန်',
 				'ybb' => 'ရမ်ဘာ',
 				'yi' => 'ဂျူး',
 				'yo' => 'ယိုရူဘာ',
 				'yue' => 'ကွမ်တုံ',
 				'zgh' => 'မိုရိုကို တမဇိုက်',
 				'zh' => 'တရုတ်',
 				'zu' => 'ဇူးလူး',
 				'zun' => 'ဇူနီ',
 				'zxx' => 'ဘာသာစကားနှင့် ပတ်သက်သောအရာ မရှိပါ',
 				'zza' => 'ဇာဇာ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'အာရေဗျ',
 			'Armn' => 'အာမေးနီးယား',
 			'Beng' => 'ဘင်္ဂါလီ',
 			'Bopo' => 'ဘိုပို',
 			'Brah' => 'ဗွဟ်မမီ',
 			'Brai' => 'ဘရေ',
 			'Cyrl' => 'စစ်ရိလစ်',
 			'Deva' => 'ဒီဗနာဂရီ',
 			'Ethi' => 'အီသီယိုးပီးယား',
 			'Geor' => 'ဂျော်ဂျီယာ',
 			'Grek' => 'ဂရိ',
 			'Gujr' => 'ဂုဂျာရသီ',
 			'Guru' => 'ဂူရူ',
 			'Hanb' => 'ဟန်ဘ်',
 			'Hang' => 'ဟန်ဂူးလ်',
 			'Hani' => 'ဟန်',
 			'Hans' => 'ရိုးရှင်း',
 			'Hans@alt=stand-alone' => 'ဟန် ရိုးရှင်း',
 			'Hant' => 'ရိုးရာ',
 			'Hant@alt=stand-alone' => 'ဟန် ရိုးရာ',
 			'Hebr' => 'ဟီဗရူး',
 			'Hira' => 'ဟီရဂန',
 			'Hrkt' => 'ဂျပန် အက္ခရာ',
 			'Jamo' => 'ဂျမို',
 			'Java' => 'ဂျာဗားနီးစ်',
 			'Jpan' => 'ဂျပန်',
 			'Kali' => 'ကယားလီ',
 			'Kana' => 'ခတခန',
 			'Khmr' => 'ခမာ',
 			'Knda' => 'ခန်နာဒါ',
 			'Kore' => 'ကိုရီးယား',
 			'Laoo' => 'လာအို',
 			'Latn' => 'လက်တင်',
 			'Mlym' => 'မလေယာလမ်',
 			'Mong' => 'မွန်ဂိုလီးယား',
 			'Mymr' => 'မြန်မာ',
 			'Orya' => 'အိုရာ',
 			'Sinh' => 'ဆင်ဟာလ',
 			'Tale' => 'တိုင်လီ',
 			'Taml' => 'တမီးလ်',
 			'Telu' => 'တီလု',
 			'Tglg' => 'တဂလော့ဂ်',
 			'Thaa' => 'သာအ်',
 			'Thai' => 'ထိုင်း',
 			'Tibt' => 'တိဘက်',
 			'Visp' => 'မြင်နိုင်သော စကား',
 			'Xpeo' => 'ပါရှန် အဟောင်း',
 			'Yiii' => 'ရီ',
 			'Zmth' => 'ဂဏန်းသင်္ချာ',
 			'Zsye' => 'အီမိုဂျီ',
 			'Zsym' => 'သင်္ကေတ',
 			'Zxxx' => 'ထုံးတမ်းသဖွယ်လိုက်နာလျက်ရှိသော',
 			'Zyyy' => 'အများနှင့်သက်ဆိုင်သော',
 			'Zzzz' => 'မသိ သို့မဟုတ် မရှိသော စကားလုံး',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ကမ္ဘာ',
 			'002' => 'အာဖရိက',
 			'003' => 'မြောက် အမေရိကတိုက်',
 			'005' => 'တောင် အမေရိက',
 			'009' => 'သမုဒ္ဒရာဒေသ',
 			'011' => 'အနောက် အာဖရိက',
 			'013' => 'ဗဟို အမေရိက',
 			'014' => 'အရှေ့ အာဖရိက',
 			'015' => 'မြောက် အာဖရိက',
 			'017' => 'အလယ် အာဖရိက',
 			'018' => 'အာဖရိက တောင်ပိုင်း',
 			'019' => 'အမေရိကန်',
 			'021' => 'မြောက် အမေရိက',
 			'029' => 'ကာရစ်ဘီယံ',
 			'030' => 'အရှေ့အာရှ',
 			'034' => 'တောင်အာရှ',
 			'035' => 'အရှေ့တောင်အာရှ',
 			'039' => 'တောင်ဥရောပ',
 			'053' => 'ဩစတြေးလျနှင့် နယူးဇီလန်',
 			'054' => 'မီလာနီးရှား',
 			'057' => 'မိုက်ခရိုနီးရှား ဒေသ',
 			'061' => 'ပိုလီနီရှား',
 			'142' => 'အာရှ',
 			'143' => 'အလယ်အာရှ',
 			'145' => 'အနောက်အာရှ',
 			'150' => 'ဥရောပ',
 			'151' => 'အရှေ့ ဥရောပ',
 			'154' => 'မြောက် ဥရောပ',
 			'155' => 'အနောက် ဥရောပ',
 			'202' => 'ဆာဟာရ-အောက်ပိုင်း အာဖရိက',
 			'419' => 'လက်တင်အမေရိက',
 			'AC' => 'အဆန်းရှင်းကျွန်း',
 			'AD' => 'အန်ဒိုရာ',
 			'AE' => 'ယူအေအီး',
 			'AF' => 'အာဖဂန်နစ္စတန်',
 			'AG' => 'အန်တီဂွါနှင့် ဘာဘူဒါ',
 			'AI' => 'အန်ဂီလာ',
 			'AL' => 'အယ်လ်ဘေးနီးယား',
 			'AM' => 'အာမေးနီးယား',
 			'AO' => 'အန်ဂိုလာ',
 			'AQ' => 'အန်တာတိက',
 			'AR' => 'အာဂျင်တီးနား',
 			'AS' => 'အမေရိကန် ဆမိုးအား',
 			'AT' => 'ဩစတြီးယား',
 			'AU' => 'ဩစတြေးလျ',
 			'AW' => 'အာရူးဗား',
 			'AX' => 'အာလန်ကျွန်း',
 			'AZ' => 'အဇာဘိုင်ဂျန်',
 			'BA' => 'ဘော့စနီးယားနှင့် ဟာဇီဂိုဗီနား',
 			'BB' => 'ဘာဘေးဒိုးစ်',
 			'BD' => 'ဘင်္ဂလားဒေ့ရှ်',
 			'BE' => 'ဘယ်လ်ဂျီယမ်',
 			'BF' => 'ဘာကီးနား ဖားဆို',
 			'BG' => 'ဘူလ်ဂေးရီးယား',
 			'BH' => 'ဘာရိန်း',
 			'BI' => 'ဘူရွန်ဒီ',
 			'BJ' => 'ဘီနင်',
 			'BL' => 'စိန့်ဘာသယ်လ်မီ',
 			'BM' => 'ဘာမြူဒါ',
 			'BN' => 'ဘရူနိုင်း',
 			'BO' => 'ဘိုလီးဗီးယား',
 			'BQ' => 'ကာရစ်ဘီယံ နယ်သာလန်',
 			'BR' => 'ဘရာဇီး',
 			'BS' => 'ဘဟားမား',
 			'BT' => 'ဘူတန်',
 			'BV' => 'ဘူဗက်ကျွန်း',
 			'BW' => 'ဘော့ဆွာနာ',
 			'BY' => 'ဘီလာရုစ်',
 			'BZ' => 'ဘလိဇ်',
 			'CA' => 'ကနေဒါ',
 			'CC' => 'ကိုကိုးကျွန်း',
 			'CD' => 'ကွန်ဂို',
 			'CD@alt=variant' => 'ကွန်ဂို ဒီမိုကရက်တစ် သမ္မတနိုင်ငံ',
 			'CF' => 'ဗဟို အာဖရိက ပြည်ထောင်စု',
 			'CG' => 'ကွန်ဂို-ဘရာဇာဗီးလ်',
 			'CG@alt=variant' => 'ကွန်ဂို သမ္မတနိုင်ငံ',
 			'CH' => 'ဆွစ်ဇာလန်',
 			'CI' => 'ကို့တ် ဒီဗွာ',
 			'CI@alt=variant' => 'အိုင်ဗရီကို့စ်',
 			'CK' => 'ကွတ် ကျွန်းစု',
 			'CL' => 'ချီလီ',
 			'CM' => 'ကင်မရွန်း',
 			'CN' => 'တရုတ်',
 			'CO' => 'ကိုလံဘီယာ',
 			'CP' => 'ကလစ်ပါတန်ကျွန်း',
 			'CR' => 'ကို့စ်တာရီကာ',
 			'CU' => 'ကျူးဘား',
 			'CV' => 'ကိတ်ဗာဒီ',
 			'CW' => 'ကျူရေးကိုးစ်',
 			'CX' => 'ခရစ်စမတ် ကျွန်း',
 			'CY' => 'ဆိုက်ပရပ်စ်',
 			'CZ' => 'ချက်ကီယား',
 			'CZ@alt=variant' => 'ချက် ပြည်ထောင်စု',
 			'DE' => 'ဂျာမနီ',
 			'DG' => 'ဒီအဲဂိုဂါစီရာ',
 			'DJ' => 'ဂျီဘူတီ',
 			'DK' => 'ဒိန်းမတ်',
 			'DM' => 'ဒိုမီနီကာ',
 			'DO' => 'ဒိုမီနီကန်',
 			'DZ' => 'အယ်လ်ဂျီးရီးယား',
 			'EA' => 'ဆယ်ဥတာနှင့်မယ်လီလ်လာ',
 			'EC' => 'အီကွေဒေါ',
 			'EE' => 'အက်စတိုးနီးယား',
 			'EG' => 'အီဂျစ်',
 			'EH' => 'အနောက် ဆာဟာရ',
 			'ER' => 'အီရီထရီးယား',
 			'ES' => 'စပိန်',
 			'ET' => 'အီသီယိုးပီးယား',
 			'EU' => 'ဥရောပသမဂ္ဂ',
 			'EZ' => 'ဥရောပဒေသ',
 			'FI' => 'ဖင်လန်',
 			'FJ' => 'ဖီဂျီ',
 			'FK' => 'ဖော့ကလန် ကျွန်းစု',
 			'FK@alt=variant' => 'ဖော့ကလန် ကျွန်းစု (အီလားစ် မောလ်ဗီနာစ်)',
 			'FM' => 'မိုင်ခရိုနီရှား',
 			'FO' => 'ဖာရိုး ကျွန်းစုများ',
 			'FR' => 'ပြင်သစ်',
 			'GA' => 'ဂါဘွန်',
 			'GB' => 'ယူနိုက်တက်ကင်းဒမ်း',
 			'GB@alt=short' => 'ယူကေ',
 			'GD' => 'ဂရီနေဒါ',
 			'GE' => 'ဂျော်ဂျီယာ',
 			'GF' => 'ပြင်သစ် ဂီယာနာ',
 			'GG' => 'ဂွန်းဇီ',
 			'GH' => 'ဂါနာ',
 			'GI' => 'ဂျီဘရော်လ်တာ',
 			'GL' => 'ဂရင်းလန်း',
 			'GM' => 'ဂမ်ဘီရာ',
 			'GN' => 'ဂီနီ',
 			'GP' => 'ဂွါဒီလု',
 			'GQ' => 'အီကွေတာ ဂီနီ',
 			'GR' => 'ဂရိ',
 			'GS' => 'တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ',
 			'GT' => 'ဂွါတီမာလာ',
 			'GU' => 'ဂူအမ်',
 			'GW' => 'ဂီနီ-ဘီစော',
 			'GY' => 'ဂိုင်ယာနာ',
 			'HK' => 'ဟောင်ကောင် (တရုတ်ပြည်)',
 			'HK@alt=short' => 'ဟောင်ကောင်',
 			'HM' => 'ဟတ်ကျွန်းနှင့်မက်ဒေါနယ်ကျွန်းစု',
 			'HN' => 'ဟွန်ဒူးရပ်စ်',
 			'HR' => 'ခရိုအေးရှား',
 			'HT' => 'ဟေတီ',
 			'HU' => 'ဟန်ဂေရီ',
 			'IC' => 'ကနေရီ ကျွန်းစု',
 			'ID' => 'အင်ဒိုနီးရှား',
 			'IE' => 'အိုင်ယာလန်',
 			'IL' => 'အစ္စရေး',
 			'IM' => 'မန်ကျွန်း',
 			'IN' => 'အိန္ဒိယ',
 			'IO' => 'ဗြိတိသျှပိုင် အိန္ဒိယသမုဒ္ဒရာကျွန်းများ',
 			'IQ' => 'အီရတ်',
 			'IR' => 'အီရန်',
 			'IS' => 'အိုက်စလန်',
 			'IT' => 'အီတလီ',
 			'JE' => 'ဂျာစီ',
 			'JM' => 'ဂျမေကာ',
 			'JO' => 'ဂျော်ဒန်',
 			'JP' => 'ဂျပန်',
 			'KE' => 'ကင်ညာ',
 			'KG' => 'ကာဂျစ္စတန်',
 			'KH' => 'ကမ္ဘောဒီးယား',
 			'KI' => 'ခီရီဘာတီ',
 			'KM' => 'ကိုမိုရိုစ်',
 			'KN' => 'စိန့်ကစ်နှင့်နီဗီစ်',
 			'KP' => 'မြောက်ကိုရီးယား',
 			'KR' => 'တောင်ကိုရီးယား',
 			'KW' => 'ကူဝိတ်',
 			'KY' => 'ကေမန် ကျွန်းစု',
 			'KZ' => 'ကာဇက်စတန်',
 			'LA' => 'လာအို',
 			'LB' => 'လက်ဘနွန်',
 			'LC' => 'စိန့်လူစီယာ',
 			'LI' => 'လစ်တန်စတိန်း',
 			'LK' => 'သီရိလင်္ကာ',
 			'LR' => 'လိုက်ဘေးရီးယား',
 			'LS' => 'လီဆိုသို',
 			'LT' => 'လစ်သူယေးနီးယား',
 			'LU' => 'လူဇင်ဘတ်',
 			'LV' => 'လတ်ဗီးယား',
 			'LY' => 'လစ်ဗျား',
 			'MA' => 'မော်ရိုကို',
 			'MC' => 'မိုနာကို',
 			'MD' => 'မောလ်ဒိုဗာ',
 			'ME' => 'မွန်တီနိဂရိုး',
 			'MF' => 'စိန့်မာတင်',
 			'MG' => 'မဒါဂတ်စကား',
 			'MH' => 'မာရှယ် ကျွန်းစု',
 			'MK' => 'မက်ဆီဒိုးနီးယား',
 			'MK@alt=variant' => 'မက်ဆီဒိုးနီးယား (ယခင် ယူဂိုစလားဗီးယား မက်ဆီဒိုးနီးယားပြည်ထောင်စု)',
 			'ML' => 'မာလီ',
 			'MM' => 'မြန်မာ',
 			'MN' => 'မွန်ဂိုးလီးယား',
 			'MO' => 'မကာအို (တရုတ်ပြည်)',
 			'MO@alt=short' => 'မကာအို',
 			'MP' => 'မြောက်ပိုင်းမာရီအာနာကျွန်းစု',
 			'MQ' => 'မာတီနိခ်',
 			'MR' => 'မော်ရီတေးနီးယား',
 			'MS' => 'မောင့်စဲရက်',
 			'MT' => 'မောလ်တာ',
 			'MU' => 'မောရစ်ရှ',
 			'MV' => 'မော်လ်ဒိုက်',
 			'MW' => 'မာလာဝီ',
 			'MX' => 'မက်ကဆီကို',
 			'MY' => 'မလေးရှား',
 			'MZ' => 'မိုဇမ်ဘစ်',
 			'NA' => 'နမီးဘီးယား',
 			'NC' => 'နယူး ကယ်လီဒိုနီးယား',
 			'NE' => 'နိုင်ဂျာ',
 			'NF' => 'နောဖုတ်ကျွန်း',
 			'NG' => 'နိုင်ဂျီးရီးယား',
 			'NI' => 'နီကာရာဂွါ',
 			'NL' => 'နယ်သာလန်',
 			'NO' => 'နော်ဝေ',
 			'NP' => 'နီပေါ',
 			'NR' => 'နော်ရူး',
 			'NU' => 'နီဥူအေ',
 			'NZ' => 'နယူးဇီလန်',
 			'OM' => 'အိုမန်',
 			'PA' => 'ပနားမား',
 			'PE' => 'ပီရူး',
 			'PF' => 'ပြင်သစ် ပေါ်လီနီးရှား',
 			'PG' => 'ပါပူအာ နယူးဂီနီ',
 			'PH' => 'ဖိလစ်ပိုင်',
 			'PK' => 'ပါကစ္စတန်',
 			'PL' => 'ပိုလန်',
 			'PM' => 'စိန့်ပီအဲရ်နှင့် မီကွီလွန်',
 			'PN' => 'ပစ်တ်ကိန်းကျွန်းစု',
 			'PR' => 'ပေါ်တိုရီကို',
 			'PS' => 'ပါလက်စတိုင်း ပိုင်နက်',
 			'PS@alt=short' => 'ပါလက်စတိုင်း',
 			'PT' => 'ပေါ်တူဂီ',
 			'PW' => 'ပလာအို',
 			'PY' => 'ပါရာဂွေး',
 			'QA' => 'ကာတာ',
 			'QO' => 'သမုဒ္ဒရာ အပြင်ဘက်ရှိ ကျွန်းနိုင်ငံများ',
 			'RE' => 'ရီယူနီယန်',
 			'RO' => 'ရိုမေးနီးယား',
 			'RS' => 'ဆားဘီးယား',
 			'RU' => 'ရုရှား',
 			'RW' => 'ရဝန်ဒါ',
 			'SA' => 'ဆော်ဒီအာရေးဘီးယား',
 			'SB' => 'ဆော်လမွန်ကျွန်းစု',
 			'SC' => 'ဆေးရှဲ',
 			'SD' => 'ဆူဒန်',
 			'SE' => 'ဆွီဒင်',
 			'SG' => 'စင်္ကာပူ',
 			'SH' => 'စိန့်ဟယ်လယ်နာ',
 			'SI' => 'ဆလိုဗေးနီးယား',
 			'SJ' => 'စဗိုလ်ဘတ်နှင့်ဂျန်မေရန်',
 			'SK' => 'ဆလိုဗက်ကီးယား',
 			'SL' => 'ဆီယာရာ လီယွန်း',
 			'SM' => 'ဆန်မာရီနို',
 			'SN' => 'ဆီနီဂေါ',
 			'SO' => 'ဆိုမာလီယာ',
 			'SR' => 'ဆူရာနမ်',
 			'SS' => 'တောင် ဆူဒန်',
 			'ST' => 'ဆောင်တူမေးနှင့် ပရင်စီပီ',
 			'SV' => 'အယ်လ်ဆာဗေးဒိုး',
 			'SX' => 'စင့်မာတင်',
 			'SY' => 'ဆီးရီးယား',
 			'SZ' => 'ဆွာဇီလန်',
 			'TA' => 'ထရစ္စတန် ဒါ ကွန်ဟာ',
 			'TC' => 'တခ်စ်နှင့်ကာအီကိုစ်ကျွန်းစု',
 			'TD' => 'ချဒ်',
 			'TF' => 'ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ',
 			'TG' => 'တိုဂို',
 			'TH' => 'ထိုင်း',
 			'TJ' => 'တာဂျီကစ္စတန်',
 			'TK' => 'တိုကလောင်',
 			'TL' => 'အရှေ့တီမော',
 			'TM' => 'တာ့ခ်မင်နစ္စတန်',
 			'TN' => 'တူနီးရှား',
 			'TO' => 'တွန်ဂါ',
 			'TR' => 'တူရကီ',
 			'TT' => 'ထရီနီဒတ်နှင့် တိုဘက်ဂို',
 			'TV' => 'တူဗားလူ',
 			'TW' => 'ထိုင်ဝမ်',
 			'TZ' => 'တန်ဇန်းနီးယား',
 			'UA' => 'ယူကရိန်း',
 			'UG' => 'ယူဂန်းဒါး',
 			'UM' => 'ယူနိုက်တက်စတိတ် ကျွန်းနိုင်ငံများ',
 			'UN' => 'ကုလသမဂ္ဂ',
 			'UN@alt=short' => 'ကုလသမဂ္ဂ',
 			'US' => 'အမေရိကန် ပြည်ထောင်စု',
 			'US@alt=short' => 'ယူအက်စ်',
 			'UY' => 'ဥရုဂွေး',
 			'UZ' => 'ဥဇဘက်ကစ္စတန်',
 			'VA' => 'ဗာတီကန်စီးတီး',
 			'VC' => 'စိန့်ဗင်းဆင့်နှင့် ဂရိနေဒိုင်',
 			'VE' => 'ဗင်နီဇွဲလား',
 			'VG' => 'ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု',
 			'VI' => 'ယူအက်စ် ဗာဂျင်း ကျွန်းစု',
 			'VN' => 'ဗီယက်နမ်',
 			'VU' => 'ဗနွားတူ',
 			'WF' => 'ဝေါလစ်နှင့် ဖူကျူးနား',
 			'WS' => 'ဆမိုးအား',
 			'XK' => 'ကိုဆိုဗို',
 			'YE' => 'ယီမင်',
 			'YT' => 'မေယော့',
 			'ZA' => 'တောင်အာဖရိက',
 			'ZM' => 'ဇမ်ဘီယာ',
 			'ZW' => 'ဇင်ဘာဘွေ',
 			'ZZ' => 'မသိ (သို့) မရှိသော ဒေသ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'ရှေးရိုးစဉ်လာ ဂျာမန် ရေးထုံး',
 			'1996' => '၁၉၉၆ ဂျာမန် ရေးထုံး',
 			'1606NICT' => 'အလယ်ပိုင်းနောက်ကျသောပြင်သစ်မှ ၁၆၀၆',
 			'1694ACAD' => '၁၆၉၄ACAD',
 			'AREVELA' => 'အရှေ့ပိုင်းအာမေးနီးယန်း',
 			'BAKU1926' => 'ပေါင်းစပ်ထားသော တူရကီ လက်တင်စကားလုံး',
 			'FONIPA' => 'IPA အသံထွက်',
 			'FONUPA' => 'UPA အသံထွက်',
 			'POSIX' => 'ကွန်ပျူတာ',
 			'REVISED' => 'ပြန်လည်စီစစ်ထားသော ရေးထုံး',
 			'SCOTLAND' => 'စကော့ စံ အင်္ဂလိပ်',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ပြက္ခဒိန်',
 			'cf' => 'ငွေရေတွက်ပုံစနစ်',
 			'collation' => 'အစဉ်လိုက်စီရန်',
 			'currency' => 'ငွေကြေး',
 			'hc' => 'နာရီစက်ဝန်း (၁၂ နှင့် ၂၄)',
 			'lb' => 'စာပိုဒ်ခွဲပုံစံ',
 			'ms' => 'တိုင်းတာရေးစနစ်',
 			'numbers' => 'ကိန်းဂဏန်း',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ဗုဒ္ဓ ပြက္ခဒိန်},
 				'chinese' => q{တရုတ် ပြက္ခဒိန်},
 				'dangi' => q{ဒန်းဂိ ပြက္ခဒိန်},
 				'ethiopic' => q{အီသီယိုးပီးယား ပြက္ခဒိန်},
 				'gregorian' => q{နိုင်ငံတကာသုံး ပြက္ခဒိန်},
 				'hebrew' => q{ဟီဘရူး ပြက္ခဒိန်},
 				'indian' => q{အိန္ဒြိယ အမျိုးသား ပြက္ခဒိန်},
 				'islamic' => q{အစ္စလာမ် ပြက္ခဒိန်},
 				'iso8601' => q{ISO-8601 ပြက္ခဒိန်},
 				'japanese' => q{ဂျပန် ပြက္ခဒိန်},
 				'persian' => q{ပါရှား ပြက္ခဒိန်},
 				'roc' => q{မင်ဂုအို ပြက္ခဒိန်},
 			},
 			'cf' => {
 				'account' => q{စာရင်းကိုင်သုံး ငွေရေတွက်ပုံစနစ်},
 				'standard' => q{ပုံမှန် ငွေရေတွက်ပုံစနစ်},
 			},
 			'collation' => {
 				'ducet' => q{အစဉ်လိုက်စီထားသော ယူနီကုတ်},
 				'phonebook' => q{ဖုန်းစာအုပ် အစီအစဉ်},
 				'search' => q{ယေဘုယျရှာခြင်း},
 				'standard' => q{ပုံမှန်စီထားသော},
 			},
 			'hc' => {
 				'h11' => q{၁၂ နာရီ စနစ် (၀–၁၁)},
 				'h12' => q{၁၂ နာရီစနစ် (၁–၁၂)},
 				'h23' => q{၂၄ နာရီ စနစ် (၀–၂၃)},
 				'h24' => q{၂၄ နာရီ စနစ်(၁–၂၄)},
 			},
 			'lb' => {
 				'loose' => q{ကန့်သတ်မထားသော စာပိုဒ်ခွဲပုံစံ},
 				'normal' => q{ပုံမှန်စာပိုဒ်ခွဲပုံစံ},
 				'strict' => q{ကန့်သတ်ထားသော စာပိုဒ်ခွဲပုံစံ},
 			},
 			'ms' => {
 				'metric' => q{မက်ထရစ်စနစ်},
 				'uksystem' => q{ဗြိတိသျှတိုင်းတာစနစ်},
 				'ussystem' => q{အမေရိကန်တိုင်းတာစနစ်},
 			},
 			'numbers' => {
 				'arab' => q{အာရပ် ဂဏန်းခြေ},
 				'arabext' => q{တိုးချဲ့အာရပ် ဂဏန်းခြေ},
 				'armn' => q{အာမေးနီးယား ဂဏန်းခြေ},
 				'armnlow' => q{အာမေးနီးယား ဂဏန်းခြေ စာလုံးသေး},
 				'beng' => q{ဘင်္ဂါလီ ဂဏန်းခြေ},
 				'deva' => q{ဒီဗာနာဂရီ ဂဏန်းခြေ},
 				'ethi' => q{အီသီယိုပီးယား ဂဏန်းခြေ},
 				'fullwide' => q{ဗြက်ပြည့် ဂဏန်းခြေ},
 				'geor' => q{နိုင်ငံတကာသုံးဂဏန်းခြေ},
 				'grek' => q{ဂရိ ဂဏန်းခြေ},
 				'greklow' => q{ဂရိ ဂဏန်းခြေ စာလုံးသေး},
 				'gujr' => q{ဂုဂျာရတီ ဂဏန်းခြေ},
 				'guru' => q{ဂူမူခီ ဂဏန်းခြေ},
 				'hanidec' => q{တရုတ် ဆယ်လီစနစ် ဂဏန်းခြေ},
 				'hans' => q{ရိုးရှင်း တရုတ် ဂဏန်းခြေ},
 				'hansfin' => q{ရိုးရှင်း တရုတ် ဘဏ္ဍာရေးသုံး ဂဏန်းခြေ},
 				'hant' => q{ရိုးရာ တရုတ် ဂဏန်းခြေ},
 				'hantfin' => q{ရိုးရာ တရုတ် ဘဏ္ဍာရေးသုံး ဂဏန်းခြေ},
 				'hebr' => q{ဟီဘရူး ဂဏန်းခြေ},
 				'jpan' => q{ဂျပန် ဂဏန်းခြေ},
 				'jpanfin' => q{ဂျပန် ဘဏ္ဍာရေးသုံး ဂဏန်းခြေ},
 				'khmr' => q{ခမာ ဂဏန်းခြေ},
 				'knda' => q{ခန္နဒါ ဂဏန်းခြေ},
 				'laoo' => q{လာအို ဂဏန်းခြေ},
 				'latn' => q{အနောက်တိုင်း ဂဏန်းခြေ},
 				'mlym' => q{မလေယာလမ် ဂဏန်းခြေ},
 				'mymr' => q{မြန်မာ ဂဏန်းခြေ},
 				'mymrshan' => q{ရှမ်း ဂဏန်းခြေ},
 				'orya' => q{ဩရီရာ ဂဏန်းခြေ},
 				'roman' => q{ရောမ ဂဏန်းခြေ},
 				'romanlow' => q{ရောမ ဂဏန်းခြေ စာလုံးသေး},
 				'taml' => q{ရိုးရာ တမီးလ် ဂဏန်းခြေ},
 				'tamldec' => q{တမီးလ် ဂဏန်းခြေ},
 				'telu' => q{တလုဂု ဂဏန်းခြေ},
 				'thai' => q{ထိုင်း ဂဏန်းခြေ},
 				'tibt' => q{တိဘက် ဂဏန်းခြေ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{မက်ထရစ်စနစ်},
 			'UK' => q{ဗြိတိန်စနစ်},
 			'US' => q{အမေရိကန်စနစ်},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ဘာသာစကား - {0}',
 			'script' => 'စာ - {0}',
 			'region' => 'နယ်ပယ်ဒေသ - {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[၀႐ ၁႑ ၂႒ ၃႓ ၄႔ ၅႕ ၆႖ ၇႗ ၈႘ ၉႙ ၵ ၚ ၽ ၾ ၐ ၑ ၥ ဨ ဢ ၒ ၓ ၔ ၕ ဳ ၖ ၗ ၘ ၙ ဴ ၢ ႆ ၤ ႈ ႊ ႏ]},
			index => ['က', 'ခ', 'ဂ', 'ဃ', 'င', 'စ', 'ဆ', 'ဇ', 'ဈ', 'ဉ', 'ည', 'ဋ', 'ဌ', 'ဍ', 'ဎ', 'ဏ', 'တ', 'ထ', 'ဒ', 'ဓ', 'န', 'ပ', 'ဖ', 'ဗ', 'ဘ', 'မ', 'ယ', 'ရ', 'လ', 'ဝ', 'သ', 'ဟ', 'ဠ', 'အ'],
			main => qr{[က ခ ဂ ဃ င စ ဆ ဇ ဈ ဉ ည ဋ ဌ ဍ ဎ ဏ တ ထ ဒ ဓ န ပ ဖ ဗ ဘ မ ယ ရ လ ဝ သ ဟ ဠ အ ဣ ၏ ဤ ဥ ဦ ဧ ဩ ဪ ာ ါ ိ ီ ု ူ ေ ဲ ံ ဿ ျ ြ ွ ှ ္ ် ့ း]},
			numbers => qr{[\- , . % ‰ + 0၀ 1၁ 2၂ 3၃ 4၄ 5၅ 6၆ 7၇ 8၈ 9၉]},
			punctuation => qr{[၊ ။ ‘ ’ “ ”]},
		};
	},
EOT
: sub {
		return { index => ['က', 'ခ', 'ဂ', 'ဃ', 'င', 'စ', 'ဆ', 'ဇ', 'ဈ', 'ဉ', 'ည', 'ဋ', 'ဌ', 'ဍ', 'ဎ', 'ဏ', 'တ', 'ထ', 'ဒ', 'ဓ', 'န', 'ပ', 'ဖ', 'ဗ', 'ဘ', 'မ', 'ယ', 'ရ', 'လ', 'ဝ', 'သ', 'ဟ', 'ဠ', 'အ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(အရပ် လေးမျက်နှာ),
					},
					'acre' => {
						'name' => q(ဧက),
						'other' => q({0} ဧက),
					},
					'acre-foot' => {
						'name' => q(ဧက-ပေ),
						'other' => q({0} ဧက-ပေ),
					},
					'ampere' => {
						'name' => q(အမ်ပီယာ),
						'other' => q({0} အမ်ပီယာ),
					},
					'arc-minute' => {
						'name' => q(မိနစ်),
						'other' => q({0} မိနစ်),
					},
					'arc-second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0} စက္ကန့်),
					},
					'astronomical-unit' => {
						'name' => q(နက်ခတ်တဗဒေယူနဈ),
						'other' => q({0} နက်ခတ်တဗဒေယူနဈ),
					},
					'atmosphere' => {
						'name' => q(ကမ္ဘာ့လေထု),
						'other' => q({0} ကမ္ဘာ့လေထု),
					},
					'bit' => {
						'name' => q(ဘစ်),
						'other' => q({0} ဘစ်),
					},
					'byte' => {
						'name' => q(ဘိုက်),
						'other' => q({0} ဘိုက်),
					},
					'calorie' => {
						'name' => q(ကယ်လိုရီ),
						'other' => q({0} ကယ်လိုရီ),
					},
					'carat' => {
						'name' => q(ကာရက်),
						'other' => q({0} ကာရက်),
					},
					'celsius' => {
						'name' => q(ဒီဂရီ စင်တီဂရိတ်),
						'other' => q({0} ဒီဂရီ စင်တီဂရိတ်),
					},
					'centiliter' => {
						'name' => q(စင်တီလီတာ),
						'other' => q({0} စင်တီလီတာ),
					},
					'centimeter' => {
						'name' => q(စင်တီမီတာ),
						'other' => q({0} စင်တီမီတာ),
						'per' => q(တစ်စင်တီမီလာလျှင် {0}),
					},
					'century' => {
						'name' => q(ရာစုနှစ်),
						'other' => q({0} ရာစုနှစ်),
					},
					'coordinate' => {
						'east' => q({0} အရှေ့),
						'north' => q({0} မြောက်),
						'south' => q({0} တောင်),
						'west' => q({0} အနောက်),
					},
					'cubic-centimeter' => {
						'name' => q(ကုဗစင်တီမီတာ),
						'other' => q({0} ကုဗစင်တီမီတာ),
						'per' => q(တစ်ကုဗစင်တီမီတာလျှင် {0}),
					},
					'cubic-foot' => {
						'name' => q(ကုဗပေ),
						'other' => q({0} ကုဗပေ),
					},
					'cubic-inch' => {
						'name' => q(ကုဗလက်မ),
						'other' => q({0} ကုဗလက်မ),
					},
					'cubic-kilometer' => {
						'name' => q(ကုဗကီလိုမီတာ),
						'other' => q({0} ကုဗကီလိုမီတာ),
					},
					'cubic-meter' => {
						'name' => q(ကုဗမီတာ),
						'other' => q({0} ကုဗမီတာ),
						'per' => q(တစ်ကုဗမီတာလျှင် {0}),
					},
					'cubic-mile' => {
						'name' => q(ကုဗမိုင်),
						'other' => q({0} ကုဗမိုင်),
					},
					'cubic-yard' => {
						'name' => q(ကုဗကိုက်),
						'other' => q({0} ကုဗကိုက်),
					},
					'cup' => {
						'name' => q(ခွက်),
						'other' => q({0} ခွက်),
					},
					'cup-metric' => {
						'name' => q(မထ္ထရစ် ခွက်),
						'other' => q({0} မထ္ထရစ် ခွက်),
					},
					'day' => {
						'name' => q(ရက်),
						'other' => q({0} ရက်),
						'per' => q(တစ်ရက်လျှင် {0}),
					},
					'deciliter' => {
						'name' => q(ဒက်စီလီတာ),
						'other' => q({0} ဒက်စီလီတာ),
					},
					'decimeter' => {
						'name' => q(ဒက်စီမီတာ),
						'other' => q({0} ဒက်စီမီတာ),
					},
					'degree' => {
						'name' => q(ဒီဂရီ),
						'other' => q({0} ဒီဂရီ),
					},
					'fahrenheit' => {
						'name' => q(ဒီဂရီ ဖာရင်ဟိုက်),
						'other' => q({0} ဒီဂရီ ဖာရင်ဟိုက်),
					},
					'fluid-ounce' => {
						'name' => q(အရည်အောင်စ),
						'other' => q({0} အရည်အောင်စ),
					},
					'foodcalorie' => {
						'name' => q(ကယ်လိုရီ),
						'other' => q({0} ကယ်လိုရီ),
					},
					'foot' => {
						'name' => q(ပေ),
						'other' => q({0} ပေ),
						'per' => q(တစ်ပေလျှင် {0}),
					},
					'g-force' => {
						'name' => q(ဆွဲငင်အား),
						'other' => q({0} ဆွဲငင်အား),
					},
					'gallon' => {
						'name' => q(ဂါလံ),
						'other' => q({0} ဂါလံ),
						'per' => q(တစ်ဂါလံလျှင် {0}),
					},
					'gallon-imperial' => {
						'name' => q(ယူကေ ဂါလံ),
						'other' => q({0} ယူကေ ဂါလံ),
						'per' => q(တစ် ယူကေ ဂါလံလျှင် {0}),
					},
					'generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ဂစ်ဂါဘစ်),
						'other' => q({0} ဂစ်ဂါဘစ်),
					},
					'gigabyte' => {
						'name' => q(ဂစ်ဂါဘိုက်),
						'other' => q({0} ဂစ်ဂါဘိုက်),
					},
					'gigahertz' => {
						'name' => q(ဂီဂါဟတ်ဇ်),
						'other' => q({0} ဂီဂါဟတ်ဇ်),
					},
					'gigawatt' => {
						'name' => q(ဂစ်ဂါဝပ်),
						'other' => q({0} ဂစ်ဂါဝပ်),
					},
					'gram' => {
						'name' => q(ဂရမ်),
						'other' => q({0} ဂရမ်),
						'per' => q(တစ်ဂရမ်လျှင် {0}),
					},
					'hectare' => {
						'name' => q(ဟက်တာ),
						'other' => q({0} ဟက်တာ),
					},
					'hectoliter' => {
						'name' => q(ဟက်တိုလီတာ),
						'other' => q({0} ဟက်တိုမီတာ),
					},
					'hectopascal' => {
						'name' => q(ဟက်တိုပါစကယ်),
						'other' => q({0} ဟက်တိုပါစကယ်),
					},
					'hertz' => {
						'name' => q(ဟတ်ဇ်),
						'other' => q({0} ဟတ်ဇ်),
					},
					'horsepower' => {
						'name' => q(မြင်းကောင်ရေအား),
						'other' => q({0} မြင်းကောင်ရေအား),
					},
					'hour' => {
						'name' => q(နာရီ),
						'other' => q({0} နာရီ),
						'per' => q(တစ်နာရီလျှင် {0}),
					},
					'inch' => {
						'name' => q(လက်မ),
						'other' => q({0} လက်မ),
						'per' => q(တစ်လက်မလျှင် {0}),
					},
					'inch-hg' => {
						'name' => q(ပြဒါးလက်မ),
						'other' => q({0} ပြဒါးလက်မ),
					},
					'joule' => {
						'name' => q(ဂျူးလ်),
						'other' => q({0} ဂျူးလ်),
					},
					'karat' => {
						'name' => q(ကာရက်),
						'other' => q({0} ကာရက်),
					},
					'kelvin' => {
						'name' => q(ကယ်လ်ဗင်),
						'other' => q({0} ကယ်လ်ဗင်),
					},
					'kilobit' => {
						'name' => q(ကီလိုဘစ်),
						'other' => q({0} ကီလိုဘစ်),
					},
					'kilobyte' => {
						'name' => q(ကီလိုဘိုက်),
						'other' => q({0} ကီလိုဘိုက်),
					},
					'kilocalorie' => {
						'name' => q(ကီလိုကယ်လိုရီ),
						'other' => q({0} ကီလိုကယ်လိုရီ),
					},
					'kilogram' => {
						'name' => q(ကီလိုဂရမ်),
						'other' => q({0} ကီလိုဂရမ်),
						'per' => q(တစ်ကီလိုဂရမ်လျှင် {0}),
					},
					'kilohertz' => {
						'name' => q(ကီလိုဟတ်ဇ်),
						'other' => q({0} ကီလိုဟတ်ဇ်),
					},
					'kilojoule' => {
						'name' => q(ကီလိုဂျူးလ်),
						'other' => q({0} ကီလိုဂျူးလ်),
					},
					'kilometer' => {
						'name' => q(ကီလိုမီတာ),
						'other' => q({0} ကီလိုမီတာ),
						'per' => q(တစ်ကီလိုမီတာလျှင် {0}),
					},
					'kilometer-per-hour' => {
						'name' => q(ကီလိုမီတာ/နာရီ),
						'other' => q(တစ်နာရီလျှင် {0} ကီလိုမီတာ),
					},
					'kilowatt' => {
						'name' => q(ကီလိုဝပ်),
						'other' => q({0} ကီလိုဝပ်),
					},
					'kilowatt-hour' => {
						'name' => q(ကီလိုဝပ်-နာရီ),
						'other' => q({0} ကီလိုဝပ်-နာရီ),
					},
					'knot' => {
						'name' => q(နော့တီကယ်မိုင်),
						'other' => q({0} နော့တီကယ်မိုင်),
					},
					'light-year' => {
						'name' => q(အလင်းနှစ်),
						'other' => q({0} အလင်းနှစ်),
					},
					'liter' => {
						'name' => q(လီတာ),
						'other' => q({0} လီတာ),
						'per' => q(တစ်လီတာလျှင် {0}),
					},
					'liter-per-100kilometers' => {
						'name' => q(တစ်ရာကီလိုမီတာရှိ လီတာ),
						'other' => q(တစ်ရာကီလိုမီတာရှိ {0} လီတာ),
					},
					'liter-per-kilometer' => {
						'name' => q(တစ်ကီလိုမီတာရှိ လီတာ),
						'other' => q(တစ်ကီလိုမီတာရှိ {0} လီတာ),
					},
					'lux' => {
						'name' => q(လတ်ခ်),
						'other' => q({0} လတ်ခ်),
					},
					'megabit' => {
						'name' => q(မီဂါဘစ်),
						'other' => q({0} မီဂါဘစ်),
					},
					'megabyte' => {
						'name' => q(မီဂါဘိုက်),
						'other' => q({0} မီဂါဘိုက်),
					},
					'megahertz' => {
						'name' => q(မီဂါဟတ်ဇ်),
						'other' => q({0} မီဂါဟတ်ဇ်),
					},
					'megaliter' => {
						'name' => q(မီဂါလီတာ),
						'other' => q({0} မီဂါလီတာ),
					},
					'megawatt' => {
						'name' => q(မီဂါဝပ်),
						'other' => q({0} မီဂါဝပ်),
					},
					'meter' => {
						'name' => q(မီတာ),
						'other' => q({0} မီတာ),
						'per' => q(တစ်မီတာလျှင် {0}),
					},
					'meter-per-second' => {
						'name' => q(မီတာ/စက္ကန့်),
						'other' => q(တစ်စက္ကန့်လျှင် {0} မီတာ),
					},
					'meter-per-second-squared' => {
						'name' => q(မီတာ/စက္ကန့်နှစ်ထပ်ကိန်း),
						'other' => q({0} မီတာ/စက္ကန့်နှစ်ထပ်ကိန်း),
					},
					'metric-ton' => {
						'name' => q(မက်ထရစ်တန်),
						'other' => q({0} မက်ထရစ်တန်),
					},
					'microgram' => {
						'name' => q(မိုက်ခရို ဂရမ်),
						'other' => q({0} မိုက်ခရို ဂရမ်),
					},
					'micrometer' => {
						'name' => q(မိုက်ခရိုမီတာ),
						'other' => q({0} မိုက်ခရိုမီတာ),
					},
					'microsecond' => {
						'name' => q(မိုက်ခရိုစက္ကန့်),
						'other' => q({0} မိုက်ခရိုစက္ကန့်),
					},
					'mile' => {
						'name' => q(မိုင်),
						'other' => q({0} မိုင်),
					},
					'mile-per-gallon' => {
						'name' => q(တစ်ဂါလံ မိုင်နှုန်း),
						'other' => q(တစ်ဂါလံလျှင် {0} မိုင်),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(ယူကေတစ်ဂါလံ မိုင်နှုန်း),
						'other' => q(ယူကေတစ်ဂါလံလျှင် {0} မိုင်),
					},
					'mile-per-hour' => {
						'name' => q(မိုင်/နာရီ),
						'other' => q(တစ်နာရီလျှင် {0} မိုင်),
					},
					'mile-scandinavian' => {
						'name' => q(စကင်ဒီနေဗီးယန်း မိုင်),
						'other' => q({0} စကင်ဒီနေဗီးယန်း မိုင်),
					},
					'milliampere' => {
						'name' => q(မီလီအမ်ပီယာ),
						'other' => q({0} မီလီအမ်ပီယာ),
					},
					'millibar' => {
						'name' => q(မီလီဘား),
						'other' => q({0} မီလီဘား),
					},
					'milligram' => {
						'name' => q(မီလီဂရမ်),
						'other' => q({0} မီလီဂရမ်),
					},
					'milligram-per-deciliter' => {
						'name' => q(တစ်ဒက်စီလီတာရှိ မီလီဂရမ်),
						'other' => q(တစ်ဒက်စီလီတာရှိ {0} မီလီဂရမ်),
					},
					'milliliter' => {
						'name' => q(မီလီလီတာ),
						'other' => q({0} မီလီလီတာ),
					},
					'millimeter' => {
						'name' => q(မီလီမီတာ),
						'other' => q({0} မီလီမီတာ),
					},
					'millimeter-of-mercury' => {
						'name' => q(ပြဒါးမီလီမီတာ),
						'other' => q({0} ပြဒါးမီလီမီတာ),
					},
					'millimole-per-liter' => {
						'name' => q(တစ်လီတာရှိ မီလီမိုးလ်),
						'other' => q(တစ်လီတာရှိ {0} မီလီမိုးလ်),
					},
					'millisecond' => {
						'name' => q(မီလီစက္ကန့်),
						'other' => q({0} မီလီစက္ကန့်),
					},
					'milliwatt' => {
						'name' => q(မီလီဝပ်),
						'other' => q({0} မီလီဝပ်),
					},
					'minute' => {
						'name' => q(မိနစ်),
						'other' => q({0} မိနစ်),
						'per' => q(တစ်မိနစ်လျှင် {0}),
					},
					'month' => {
						'name' => q(လ),
						'other' => q({0} လ),
						'per' => q(တစ်လလျှင် {0}),
					},
					'nanometer' => {
						'name' => q(နာနိုမီတာ),
						'other' => q({0} နာနိုမီတာ),
					},
					'nanosecond' => {
						'name' => q(နာနိုစက္ကန့်),
						'other' => q({0} နာနိုစက္ကန့်),
					},
					'nautical-mile' => {
						'name' => q(ရေမိုင်),
						'other' => q({0} ရေမိုင်),
					},
					'ohm' => {
						'name' => q(အုမ်း),
						'other' => q({0} အုမ်း),
					},
					'ounce' => {
						'name' => q(အောင်စ),
						'other' => q({0} အောင်စ),
						'per' => q(တစ်အောင်စလျှင် {0}),
					},
					'ounce-troy' => {
						'name' => q(ထရိုအောင်စ),
						'other' => q({0} ထရိုအောင်စ),
					},
					'parsec' => {
						'name' => q(ပါစက်ခ်),
						'other' => q({0} ပါစက်ခ်),
					},
					'part-per-million' => {
						'name' => q(တစ်သန်းပုံ တစ်ပုံ),
						'other' => q(တစ်သန်းပုံ {0} ပုံ),
					},
					'per' => {
						'1' => q(တစ်{1} လျှင် {0}),
					},
					'percent' => {
						'name' => q(ရာခိုင်နှုန်း),
						'other' => q({0} ရာခိုင်နှုန်း),
					},
					'permille' => {
						'name' => q(ထောင်လီစိတ်),
						'other' => q({0} ထောင်လီစိတ်),
					},
					'petabyte' => {
						'name' => q(ပက်တာဘိုက်),
						'other' => q({0} ပက်တာဘိုက်),
					},
					'picometer' => {
						'name' => q(ပီကိုမီတာ),
						'other' => q({0} ပီကိုမီတာ),
					},
					'pint' => {
						'name' => q(ပိုင့်),
						'other' => q({0} ပိုင့်),
					},
					'pint-metric' => {
						'name' => q(မထ္ထရစ် ပိုင့်),
						'other' => q({0} မထ္ထရစ် ပိုင့်),
					},
					'point' => {
						'name' => q(ပွိုင့်),
						'other' => q({0} ပွိုင့်),
					},
					'pound' => {
						'name' => q(ပေါင်),
						'other' => q({0} ပေါင်),
						'per' => q(တစ်ပေါင်လျှင် {0}),
					},
					'pound-per-square-inch' => {
						'name' => q(ပေါင်/စတုရန်းလက်မ),
						'other' => q(တစ်စတုရန်းလက်မလျှင် {0} ပေါင်),
					},
					'quart' => {
						'name' => q(ကွတ်),
						'other' => q({0} ကွတ်),
					},
					'radian' => {
						'name' => q(ရေဒီယဲန်း),
						'other' => q({0} ရေဒီယဲန်း),
					},
					'revolution' => {
						'name' => q(လည်ပတ်ခြင်း),
						'other' => q({0} လည်ပတ်ခြင်း),
					},
					'second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0} စက္ကန့်),
						'per' => q(တစ်စက္ကန့်လျှင် {0}),
					},
					'square-centimeter' => {
						'name' => q(စတုရန်းစင်တီမီတာ),
						'other' => q({0} စတုရန်းစင်တီမီတာ),
						'per' => q(တစ်စတုရန်းစင်တီမီတာလျှင် {0}),
					},
					'square-foot' => {
						'name' => q(စတုရန်းပေ),
						'other' => q({0} စတုရန်းပေ),
					},
					'square-inch' => {
						'name' => q(စတုရန်းလက်မ),
						'other' => q({0} စတုရန်းလက်မ),
						'per' => q(တစ်စတုရန်းလက်မလျှင် {0}),
					},
					'square-kilometer' => {
						'name' => q(စတုရန်းကီလိုမီတာ),
						'other' => q({0} စတုရန်းကီလိုမီတာ),
						'per' => q(တစ်စတုရန်းကီလိုမီတာလျှင် {0}),
					},
					'square-meter' => {
						'name' => q(စတုရန်းမီတာ),
						'other' => q({0} စတုရန်းမီတာ),
						'per' => q(တစ်စတုရန်းမီတာလျှင် {0}),
					},
					'square-mile' => {
						'name' => q(စတုရန်းမိုင်),
						'other' => q({0} စတုရန်းမိုင်),
						'per' => q(တစ်စတုရန်းမိုင်လျှင် {0}),
					},
					'square-yard' => {
						'name' => q(စတုရန်းကိုက်),
						'other' => q({0} စတုရန်းကိုက်),
					},
					'tablespoon' => {
						'name' => q(စားပွဲဇွန်း),
						'other' => q(စားပွဲဇွန်း {0} ဇွန်း),
					},
					'teaspoon' => {
						'name' => q(လက်ဖက်ရည်ဇွန်း),
						'other' => q(လက်ဖက်ရည်ဇွန်း {0} ဇွန်း),
					},
					'terabit' => {
						'name' => q(တယ်ရာဘစ်),
						'other' => q({0} တယ်ရာဘစ်),
					},
					'terabyte' => {
						'name' => q(တယ်ရာဘိုက်),
						'other' => q({0} တယ်ရာဘိုက်),
					},
					'ton' => {
						'name' => q(တန်),
						'other' => q({0} တန်),
					},
					'volt' => {
						'name' => q(ဗို့),
						'other' => q({0} ဗို့),
					},
					'watt' => {
						'name' => q(ဝပ်),
						'other' => q({0} ဝပ်),
					},
					'week' => {
						'name' => q(ပတ်),
						'other' => q({0} ပတ်),
						'per' => q(တစ်ပတ်လျှင် {0}),
					},
					'yard' => {
						'name' => q(ကိုက်),
						'other' => q({0} ကိုက်),
					},
					'year' => {
						'name' => q(နှစ်),
						'other' => q({0} နှစ်),
						'per' => q(တစ်နှစ်လျှင် {0}),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(လမ်းကြောင်း),
					},
					'acre' => {
						'other' => q({0} ac),
					},
					'arc-minute' => {
						'other' => q({0}′),
					},
					'arc-second' => {
						'other' => q({0}″),
					},
					'celsius' => {
						'name' => q(°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'name' => q(cm),
						'other' => q({0} cm),
					},
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					'cubic-kilometer' => {
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'other' => q({0} mi³),
					},
					'day' => {
						'name' => q(ရက်),
						'other' => q({0} ရက်),
					},
					'degree' => {
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'other' => q({0}°F),
					},
					'foot' => {
						'other' => q({0} '),
					},
					'g-force' => {
						'other' => q({0} G),
					},
					'gram' => {
						'name' => q(ဂရမ်),
						'other' => q({0} g),
					},
					'hectare' => {
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(နာရီ),
						'other' => q({0} နာရီ),
					},
					'inch' => {
						'other' => q({0} ″),
					},
					'inch-hg' => {
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'name' => q(ကီလိုဂရမ်),
						'other' => q({0} kg),
					},
					'kilometer' => {
						'name' => q(km),
						'other' => q({0}km),
					},
					'kilometer-per-hour' => {
						'name' => q(ကီလိုမီတာ/နာရီ),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'other' => q({0} kW),
					},
					'light-year' => {
						'other' => q({0} အလင်းနှစ်),
					},
					'liter' => {
						'name' => q(လီတာ),
						'other' => q({0}L),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'other' => q({0} L/100km),
					},
					'meter' => {
						'name' => q(m),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'other' => q({0} m/s),
					},
					'mile' => {
						'other' => q({0}မိုင်),
					},
					'mile-per-hour' => {
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'name' => q(mm),
						'other' => q({0} mm),
					},
					'millisecond' => {
						'name' => q(မီလီစက္ကန့်),
						'other' => q({0} ms),
					},
					'minute' => {
						'name' => q(မိနစ်),
						'other' => q({0} မိနစ်),
					},
					'month' => {
						'name' => q(လ),
						'other' => q({0} လ),
					},
					'ounce' => {
						'other' => q({0} oz),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'other' => q({0}%),
					},
					'picometer' => {
						'other' => q({0} pm),
					},
					'pound' => {
						'other' => q({0} lb),
					},
					'second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0} s),
					},
					'square-foot' => {
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'other' => q({0} km²),
					},
					'square-meter' => {
						'other' => q({0} m²),
					},
					'square-mile' => {
						'other' => q({0} mi²),
					},
					'watt' => {
						'other' => q({0} W),
					},
					'week' => {
						'name' => q(ပတ်),
						'other' => q({0} ပတ်),
					},
					'yard' => {
						'other' => q({0} ကိုက်),
					},
					'year' => {
						'name' => q(နှစ်),
						'other' => q({0} နှစ်),
					},
				},
				'short' => {
					'' => {
						'name' => q(လမ်းကြောင်း),
					},
					'acre' => {
						'name' => q(ဧက),
						'other' => q({0} ac),
					},
					'acre-foot' => {
						'name' => q(ဧက-ပေ),
						'other' => q({0} ac ft),
					},
					'ampere' => {
						'name' => q(အမ်ပီယာ),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(မိနစ်),
						'other' => q({0}′),
					},
					'arc-second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'name' => q(နက်ခတ်တဗဒေယူနဈ),
						'other' => q({0} au),
					},
					'atmosphere' => {
						'name' => q(atm),
						'other' => q({0} atm),
					},
					'bit' => {
						'name' => q(ဘစ်),
						'other' => q({0} bit),
					},
					'byte' => {
						'name' => q(ဘိုက်),
						'other' => q({0} byte),
					},
					'calorie' => {
						'name' => q(ကယ်လိုရီ),
						'other' => q({0} cal),
					},
					'carat' => {
						'name' => q(ကာရက်),
						'other' => q({0} CD),
					},
					'celsius' => {
						'name' => q(°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(စင်တီလီတာ),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'name' => q(cm),
						'other' => q({0} cm),
						'per' => q({0}/cm),
					},
					'century' => {
						'name' => q(ရာစု),
						'other' => q({0} ရာစု),
					},
					'coordinate' => {
						'east' => q({0} E),
						'north' => q({0} N),
						'south' => q({0} S),
						'west' => q({0} W),
					},
					'cubic-centimeter' => {
						'name' => q(ကုဗစင်တီမီတာ),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'name' => q(ကုဗပေ),
						'other' => q({0} ft³),
					},
					'cubic-inch' => {
						'name' => q(ကုဗလက်မ),
						'other' => q({0} in³),
					},
					'cubic-kilometer' => {
						'name' => q(ကုဗကီလိုမီတာ),
						'other' => q({0} km³),
					},
					'cubic-meter' => {
						'name' => q(ကုဗမီတာ),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					'cubic-mile' => {
						'name' => q(ကုဗမိုင်),
						'other' => q({0} mi³),
					},
					'cubic-yard' => {
						'name' => q(ကုဗကိုက်),
						'other' => q({0} yd³),
					},
					'cup' => {
						'name' => q(ခွက်),
						'other' => q({0} c),
					},
					'cup-metric' => {
						'name' => q(မထ္ထရစ်ခွက်),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(ရက်),
						'other' => q({0} ရက်),
						'per' => q({0}/ ရက်),
					},
					'deciliter' => {
						'name' => q(ဒက်စီလီတာ),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'name' => q(dm),
						'other' => q({0} dm),
					},
					'degree' => {
						'name' => q(ဒီဂရီ),
						'other' => q({0} deg),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'name' => q(အရည်အောင်စ),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'name' => q(ကယ်လိုရီ),
						'other' => q({0} Cal),
					},
					'foot' => {
						'name' => q(ပေ),
						'other' => q({0} ပေ),
						'per' => q({0}/ပေ),
					},
					'g-force' => {
						'name' => q(ဆွဲငင်အား),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(ဂါလံ),
						'other' => q({0} ဂါလံ),
						'per' => q({0}/gal US),
					},
					'gallon-imperial' => {
						'name' => q(ယူကဂေါလံ),
						'other' => q({0} ယူကဂေါလံ),
						'per' => q({0}/gal Imp.),
					},
					'generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ဂစ်ဂါဘစ်),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(ဂစ်ဂါဘိုက်),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(ဂီဂါဟတ်ဇ်),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(ဂစ်ဂါဝပ်),
						'other' => q({0} GW),
					},
					'gram' => {
						'name' => q(ဂရမ်),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					'hectare' => {
						'name' => q(ဟက်တာ),
						'other' => q({0} ha),
					},
					'hectoliter' => {
						'name' => q(ဟက်တိုလီတာ),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'name' => q(Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(နာရီ),
						'other' => q({0} နာရီ),
						'per' => q({0}/ နာရီ),
					},
					'inch' => {
						'name' => q(လက်မ),
						'other' => q({0} လက်မ),
						'per' => q({0}/လက်မ),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(ဂျူးလ်),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(ကာရက်),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'name' => q(K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(ကီလိုဘစ်),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(ကီလိုဘိုက်),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(ကီလိုကယ်လိုရီ),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'name' => q(ကီလိုဂရမ်),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(ကီလိုဂျူးလ်),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'name' => q(km),
						'other' => q({0} km),
						'per' => q({0}/km),
					},
					'kilometer-per-hour' => {
						'name' => q(ကီလိုမီတာ/နာရီ),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'name' => q(ကီလိုဝပ်),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'name' => q(ကီလိုဝပ်-နာရီ),
						'other' => q({0} kWh),
					},
					'knot' => {
						'name' => q(kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(အလင်းနှစ်),
						'other' => q({0} အလင်းနှစ်),
					},
					'liter' => {
						'name' => q(လီတာ),
						'other' => q({0} လီတာ),
						'per' => q({0}/l),
					},
					'liter-per-100kilometers' => {
						'name' => q(တစ်ရာကီလိုမီတာရှိ လီတာ),
						'other' => q({0} L/100 km),
					},
					'liter-per-kilometer' => {
						'name' => q(လီတာ/ကီလိုမီတာ),
						'other' => q({0} L/km),
					},
					'lux' => {
						'name' => q(လတ်ခ်),
						'other' => q({0} lx),
					},
					'megabit' => {
						'name' => q(မီဂါဘစ်),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(မီဂါဘိုက်),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(မီဂါဟတ်ဇ်),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(မီဂါလီတာ),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'name' => q(မီဂါဝပ်),
						'other' => q({0} MW),
					},
					'meter' => {
						'name' => q(m),
						'other' => q({0} m),
						'per' => q({0}/m),
					},
					'meter-per-second' => {
						'name' => q(မီတာ/စက္ကန့်),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(မီတာ/စက္ကန့်နှစ်ထပ်ကိန်း),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(မက်ထရစ်တန်),
						'other' => q({0} t),
					},
					'microgram' => {
						'name' => q(µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(မိုက်ခရိုမီတာ),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(မိုက်ခရိုစက္ကန့်),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(မိုင်),
						'other' => q({0} မိုင်),
					},
					'mile-per-gallon' => {
						'name' => q(မိုင်/ဂါလန်),
						'other' => q({0} mpg),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					'mile-per-hour' => {
						'name' => q(မိုင်/နာရီ),
						'other' => q({0} mi/h),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(မီလီဘား),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'name' => q(မီလီဂရမ်),
						'other' => q({0} mg),
					},
					'milligram-per-deciliter' => {
						'name' => q(mg/dL),
						'other' => q({0} mg/dL),
					},
					'milliliter' => {
						'name' => q(မီလီလီတာ),
						'other' => q({0} mL),
					},
					'millimeter' => {
						'name' => q(mm),
						'other' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'name' => q(mm Hg),
						'other' => q({0} mm Hg),
					},
					'millimole-per-liter' => {
						'name' => q(mmol/L),
						'other' => q({0} mmol/L),
					},
					'millisecond' => {
						'name' => q(မီလီစက္ကန့်),
						'other' => q({0} မီလီစက္ကန့်),
					},
					'milliwatt' => {
						'name' => q(မီလီဝပ်),
						'other' => q({0} mW),
					},
					'minute' => {
						'name' => q(မိနစ်),
						'other' => q({0} မိနစ်),
						'per' => q({0}/ မိနစ်),
					},
					'month' => {
						'name' => q(လ),
						'other' => q({0} လ),
						'per' => q({0}/ လ),
					},
					'nanometer' => {
						'name' => q(nm),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'name' => q(နာနိုစက္ကန့်),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'name' => q(ရေမိုင်),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'name' => q(အုမ်း),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(အောင်စ),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					'ounce-troy' => {
						'name' => q(ထရိုအောင်စ),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'name' => q(ပါစက်ခ်),
						'other' => q({0} pc),
					},
					'part-per-million' => {
						'name' => q(တစ်သန်းပုံ တစ်ပုံ),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(PB),
						'other' => q({0} PB),
					},
					'picometer' => {
						'name' => q(pm),
						'other' => q({0} pm),
					},
					'pint' => {
						'name' => q(ပိုင့်),
						'other' => q({0} pt),
					},
					'pint-metric' => {
						'name' => q(မထ္ထရစ်ပိုင့်),
						'other' => q({0} mpt),
					},
					'point' => {
						'name' => q(ပွိုင့်),
						'other' => q({0} ပွိုင့်),
					},
					'pound' => {
						'name' => q(ပေါင်),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'name' => q(ပေါင်/စတုရန်းလက်မ),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(ကွတ်),
						'other' => q({0} qt),
					},
					'radian' => {
						'name' => q(ရေဒီယဲန်း),
						'other' => q({0} rad),
					},
					'revolution' => {
						'name' => q(rev),
						'other' => q({0} rev),
					},
					'second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0} စက္ကန့်),
						'per' => q({0}/ စက္ကန့်),
					},
					'square-centimeter' => {
						'name' => q(စတုရန်းစင်တီမီတာ),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'name' => q(စတုရန်းပေ),
						'other' => q({0} ft²),
					},
					'square-inch' => {
						'name' => q(စတုရန်းလက်မ),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'name' => q(စတုရန်းကီလိုမီတာ),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					'square-meter' => {
						'name' => q(စတုရန်းမီတာ),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					'square-mile' => {
						'name' => q(စတုရန်းမိုင်),
						'other' => q({0} mi²),
						'per' => q({0}/mi²),
					},
					'square-yard' => {
						'name' => q(စတုရန်းကိုက်),
						'other' => q({0} yd²),
					},
					'tablespoon' => {
						'name' => q(စားပွဲဇွန်း),
						'other' => q({0} tbsp),
					},
					'teaspoon' => {
						'name' => q(လက်ဖက်ရည်ဇွန်း),
						'other' => q({0} tsp),
					},
					'terabit' => {
						'name' => q(တယ်ရာဘစ်),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(တယ်ရာဘိုက်),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(တန်),
						'other' => q({0} tn),
					},
					'volt' => {
						'name' => q(ဗို့),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(ဝပ်),
						'other' => q({0} W),
					},
					'week' => {
						'name' => q(ပတ်),
						'other' => q({0} ပတ်),
						'per' => q({0}/ ပတ်),
					},
					'yard' => {
						'name' => q(ကိုက်),
						'other' => q({0} ကိုက်),
					},
					'year' => {
						'name' => q(နှစ်),
						'other' => q({0} နှစ်),
						'per' => q({0}/ နှစ်),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:Yes)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:No)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0} {1}),
				middle => q({0} {1}),
				end => q({0}နှင့် {1}),
				2 => q({0}နှင့် {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'mymr',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'mymr',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(ဂဏန်းမဟုတ်သော),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
		'mymr' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(၊),
			'minusSign' => q(-),
			'nan' => q(ဂဏန်းမဟုတ်သော),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'other' => '0ထောင်',
				},
				'10000' => {
					'other' => '0သောင်း',
				},
				'100000' => {
					'other' => '0သိန်း',
				},
				'1000000' => {
					'other' => '0သန်း',
				},
				'10000000' => {
					'other' => '0ကုဋေ',
				},
				'100000000' => {
					'other' => '00ကုဋေ',
				},
				'1000000000' => {
					'other' => 'ကုဋေ000',
				},
				'10000000000' => {
					'other' => 'ကုဋေ0ထ',
				},
				'100000000000' => {
					'other' => 'ကုဋေ0သ',
				},
				'1000000000000' => {
					'other' => 'ဋေ0သိန်း',
				},
				'10000000000000' => {
					'other' => 'ဋေ0သန်း',
				},
				'100000000000000' => {
					'other' => '0ကောဋိ',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'other' => '0ထောင်',
				},
				'10000' => {
					'other' => '0သောင်း',
				},
				'100000' => {
					'other' => '0သိန်း',
				},
				'1000000' => {
					'other' => '0သန်း',
				},
				'10000000' => {
					'other' => '0ကုဋေ',
				},
				'100000000' => {
					'other' => '00ကုဋေ',
				},
				'1000000000' => {
					'other' => 'ကုဋေ000',
				},
				'10000000000' => {
					'other' => 'ကုဋေ0000',
				},
				'100000000000' => {
					'other' => 'ကုဋေ0သောင်း',
				},
				'1000000000000' => {
					'other' => 'ကုဋေ0သိန်း',
				},
				'10000000000000' => {
					'other' => 'ကုဋေ0သန်း',
				},
				'100000000000000' => {
					'other' => '0ကောဋိ',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0ထောင်',
				},
				'10000' => {
					'other' => '0သောင်း',
				},
				'100000' => {
					'other' => '0သိန်း',
				},
				'1000000' => {
					'other' => '0သန်း',
				},
				'10000000' => {
					'other' => '0ကုဋေ',
				},
				'100000000' => {
					'other' => '00ကုဋေ',
				},
				'1000000000' => {
					'other' => 'ကုဋေ000',
				},
				'10000000000' => {
					'other' => 'ကုဋေ0ထ',
				},
				'100000000000' => {
					'other' => 'ကုဋေ0သ',
				},
				'1000000000000' => {
					'other' => 'ဋေ0သိန်း',
				},
				'10000000000000' => {
					'other' => 'ဋေ0သန်း',
				},
				'100000000000000' => {
					'other' => '0ကောဋိ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
		'mymr' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(အာရပ်စော်ဘွားများ ပြည်ထောင်စု ဒါဟမ်း),
				'other' => q(အာရပ်စော်ဘွားများ ပြည်ထောင်စု ဒါဟမ်း),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(အာဖဂန် အာဖဂါနီ),
				'other' => q(အာဖဂန် အာဖဂါနီ),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(အယ်ဘေးနီးယား လီခ်),
				'other' => q(အယ်ဘေးနီးယား လီခ်),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(အာမေးနီးယား ဒရမ်),
				'other' => q(အာမေးနီးယား ဒရမ်),
			},
		},
		'ANG' => {
			symbol => 'NAf',
			display_name => {
				'currency' => q(နယ်သာလန် အန်တီလန် ဂင်းဒါး),
				'other' => q(နယ်သာလန် အန်တီလန် ဂင်းဒါး),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(အန်ဂိုလာ ကွမ်ဇာ),
				'other' => q(အန်ဂိုလာ ကွမ်ဇာ),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(အာဂျင်တီးနား ပီဆို \(၁၉၈၃–၁၉၈၅\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(အာဂျင်တီးနား ပီဆို),
				'other' => q(အာဂျင်တီးနား ပီဆို),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ဩစတြေးလျ ဒေါ်လာ),
				'other' => q(ဩစတြေးလျ ဒေါ်လာ),
			},
		},
		'AWG' => {
			symbol => 'Afl',
			display_name => {
				'currency' => q(အရူးဗာ ဖလိုရင်း),
				'other' => q(အရူးဗာ ဖလိုရင်း),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(အဇာဘိုင်ဂျန် မာနတ်),
				'other' => q(အဇာဘိုင်ဂျန် မာနတ်),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ဘော့စနီးယားနှင့် ဟာဇီဂိုဘီးနား ငွေလဲနိုင်သော မတ်က်),
				'other' => q(ဘော့စနီးယားနှင့် ဟာဇီဂိုဘီးနားမတ်က်),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(ဘာဘေးဒီယန်း ဒေါ်လာ),
				'other' => q(ဘာဘေးဒီယန်း ဒေါ်လာ),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(ဘင်္ဂလားဒေ့ရှ် တာကာ),
				'other' => q(ဘင်္ဂလားဒေ့ရှ် တာကာ),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ဘယ်လ်ဂျီယမ် ဖရန့်),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(ဘူလ်ဂေးရီးယား လက်ဖ်),
				'other' => q(ဘူလ်ဂေးရီးယား လက်ဖ်),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(ဘာရိန်း ဒီနား),
				'other' => q(ဘာရိန်း ဒီနား),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(ဘူရွန်ဒီ ဖရန့်),
				'other' => q(ဘူရွန်ဒီ ဖရန့်),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(ဘာမြူဒါ ဒေါ်လာ),
				'other' => q(ဘာမြူဒါ ဒေါ်လာ),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ဘရူနိုင်း ဒေါ်လာ),
				'other' => q(ဘရူနိုင်း ဒေါ်လာ),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(ဘိုလီးဗီးယား ဘိုလီးဗီယားနို),
				'other' => q(ဘိုလီးဗီးယား ဘိုလီးဗီယားနို),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(ဘိုလီးဘီးယား ပီဆို),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ဘရာဇီး ရီးယဲ),
				'other' => q(ဘရာဇီး ရီးယဲ),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(ဘဟားမား ဒေါ်လာ),
				'other' => q(ဘဟားမား ဒေါ်လာ),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ဘူတန် အံဂါလ်ထရန်),
				'other' => q(ဘူတန် အံဂါလ်ထရန်),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(ဗမာ ကျပ်),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ဘော့ဆွာနာ ပုလ),
				'other' => q(ဘော့ဆွာနာ ပုလ),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(ဘီလာရုစ် ရူဘယ်အသစ် \(၁၉၉၄–၁၉၉၉\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(ဘီလာရုစ် ရူဘယ်),
				'other' => q(ဘီလာရုစ် ရူဘယ်),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(ဘီလာရုဇ် ရူဘယ် \(၂၀၀၀–၂၀၁၆\)),
				'other' => q(ဘီလာရုဇ် ရူဘယ် \(၂၀၀၀–၂၀၁၆\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(ဘလိဇ် ဒေါ်လာ),
				'other' => q(ဘလိဇ် ဒေါ်လာ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ကနေဒါ ဒေါ်လာ),
				'other' => q(ကနေဒါ ဒေါ်လာ),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(ကွန်ဂို ဖရန့်),
				'other' => q(ကွန်ဂို ဖရန့်),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(ဆွစ် ဖရန့်),
				'other' => q(ဆွစ် ဖရန့်),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(ချီလီ ပီဆို),
				'other' => q(ချီလီ ပီဆို),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(တရုတ် ယွမ် \(ဟောင်ကောင်\)),
				'other' => q(တရုတ် ယွမ် \(ဟောင်ကောင်\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(တရုတ် ယွမ်),
				'other' => q(တရုတ် ယွမ်),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(ကိုလံဘီယာ ပီဆို),
				'other' => q(ကိုလံဘီယာ ပီဆို),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(ကို့စတာရီကာ ကိုလွန်),
				'other' => q(ကို့စတာရီကာ ကိုလွန်),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(နိုင်ငံခြားငွေလဲလှယ်နိုင်သော ကျူးဘားပီဆို),
				'other' => q(နိုင်ငံခြားငွေလဲလှယ်နိုင်သော ကျူးဘားပီဆို),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(ကျူးဘား ပီဆို),
				'other' => q(ကျူးဘား ပီဆို),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ကိတ်ပ်ဗာဒီ အက်စ်ခူဒို),
				'other' => q(ကိတ်ပ်ဗာဒီ အက်စ်ခူဒို),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(ဆိုက်ပရက်စ် ပေါင်),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(ချက် ခိုရိုနာ),
				'other' => q(ချက် ခိုရိုနာ),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ဂျာမဏီ မတ်),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ဂျီဘူတီ ဖရန့်),
				'other' => q(ဂျီဘူတီ ဖရန့်),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ဒိန်းမတ် ခရိုဏာ),
				'other' => q(ဒိန်းမတ် ခရိုဏာ),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ဒိုမီနီကန် ပီဆို),
				'other' => q(ဒိုမီနီကန် ပီဆို),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(အယ်လ်ဂျီးရီးယား ဒီနာ),
				'other' => q(အယ်လ်ဂျီးရီးယား ဒီနာ),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(အီဂျစ် ပေါင်),
				'other' => q(အီဂျစ် ပေါင်),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(အီရီထရီးယား နာ့ခ်ဖာ),
				'other' => q(အီရီထရီးယား နာ့ခ်ဖာ),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(စပိန် ပယ်စေးတာ),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(အီသီယိုးပီးယား ဘီးယာ),
				'other' => q(အီသီယိုးပီးယား ဘီးယာ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ယူရို),
				'other' => q(ယူရို),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ဖီဂျီ ဒေါ်လာ),
				'other' => q(ဖီဂျီ ဒေါ်လာ),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ဖော့ကလန်ကျွန်းစု ပေါင်),
				'other' => q(ဖော့ကလန်ကျွန်းစု ပေါင်),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ပြင်သစ် ဖရန့်),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ဗြိတိသျှ ပေါင်),
				'other' => q(ဗြိတိသျှ ပေါင်),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ဂျော်ဂျီယာ လားရီ),
				'other' => q(ဂျော်ဂျီယာ လားရီ),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ဂါနာ ဆဲဒီ),
				'other' => q(ဂါနာ ဆဲဒီ),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(ဂျီဘရော်လ်တာ ပေါင်),
				'other' => q(ဂျီဘရော်လ်တာ ပေါင်),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(ဂမ်ဘီယာ ဒါလာစီ),
				'other' => q(ဂမ်ဘီယာ ဒါလာစီ),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ဂီနီရာ ဖရန့်),
				'other' => q(ဂီနီရာ ဖရန့်),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ဂွါတီမာလာ ခက်ဇော်လ်),
				'other' => q(ဂွါတီမာလာ ခက်ဇော်လ်),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(ဂိုင်ယာနာ ဒေါ်လာ),
				'other' => q(ဂိုင်ယာနာ ဒေါ်လာ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ဟောင်ကောင် ဒေါ်လာ),
				'other' => q(ဟောင်ကောင် ဒေါ်လာ),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ဟွန်ဒူးရပ်စ် လမ်းပီရာ),
				'other' => q(ဟွန်ဒူးရပ်စ် လမ်းပီရာ),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ခရိုအေးရှား ခူးနာ),
				'other' => q(ခရိုအေးရှား ခူးနာ),
			},
		},
		'HTG' => {
			symbol => 'G',
			display_name => {
				'currency' => q(ဟေတီဂူးအော်ဒ်),
				'other' => q(ဟေတီဂူးအော်ဒ်),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ဟန်ဂေရီယံ ဖော်ရင့်တ်),
				'other' => q(ဟန်ဂေရီယံ ဖော်ရင့်တ်),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(အင်ဒိုနီးရှား ရူပီးယား),
				'other' => q(အင်ဒိုနီးရှား ရူပီးယား),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(အစ္စရေး ပေါင်),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(အစ္စရေး ရှဲကလ်အသစ်),
				'other' => q(အစ္စရေး ရှဲကလ်အသစ်),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(အိန္ဒိယ ရူပီး),
				'other' => q(အိန္ဒိယ ရူပီး),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(အီရတ် ဒီနာ),
				'other' => q(အီရတ် ဒီနာ),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(အီရန် ရီအော်လ်),
				'other' => q(အီရန် ရီအော်လ်),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(အိုက်စလန် ခရိုဏာ),
				'other' => q(အိုက်စလန် ခရိုဏာ),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ဂျမေကာ ဒေါ်လာ),
				'other' => q(ဂျမေကာ ဒေါ်လာ),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ဂျော်ဒန် ဒီနာ),
				'other' => q(ဂျော်ဒန် ဒီနာ),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ဂျပန် ယန်း),
				'other' => q(ဂျပန် ယန်း),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(ကင်ညာ သျှီလင်),
				'other' => q(ကင်ညာ သျှီလင်),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(ကာဂျစ္စတန် ဆော်မ်),
				'other' => q(ကာဂျစ္စတန် ဆော်မ်),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(ကမ္ဘောဒီးယား ရီးယဲ),
				'other' => q(ကမ္ဘောဒီးယား ရီးယဲ),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(ကိုမိုရိုစ် ဖရန့်),
				'other' => q(ကိုမိုရိုစ် ဖရန့်),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(မြောက်ကိုရီးယား ဝမ်),
				'other' => q(မြောက်ကိုရီးယား ဝမ်),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(တောင်ကိုရီးယား ဝမ်),
				'other' => q(တောင်ကိုရီးယား ဝမ်),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(ကူဝိတ် ဒီနာ),
				'other' => q(ကူဝိတ် ဒီနာ),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(ကေမန် ကျွန်းစု ဒေါ်လာ),
				'other' => q(ကေမန် ကျွန်းစု ဒေါ်လာ),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(ကာဇက်စတန် ထိန်ဂျီ),
				'other' => q(ကာဇက်စတန် ထိန်ဂျီ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(လာအို ကစ်),
				'other' => q(လာအို ကစ်),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(လက်ဘနွန် ပေါင်),
				'other' => q(လက်ဘနွန် ပေါင်),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(သီရိလင်္ကာ ရူပီး),
				'other' => q(သီရိလင်္ကာ ရူပီး),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(လိုက်ဘေးရီးယား ဒေါ်လာ),
				'other' => q(လိုက်ဘေးရီးယား ဒေါ်လာ),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(လစ်သူယေးနီးယားလီတားစ်),
				'other' => q(လစ်သူယေးနီးယားလီတားစ်),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(လတ်ဗီးယားလတ်),
				'other' => q(လတ်ဗီးယားလတ်),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(လစ်ဗျား ဒိုင်နာ),
				'other' => q(လစ်ဗျား ဒိုင်နာ),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(မိုရိုကို ဒရမ်),
				'other' => q(မိုရိုကို ဒရမ်),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(မောလ်ဒိုဗာ လယ်အို),
				'other' => q(မောလ်ဒိုဗာ လယ်အို),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(မာလာဂါစီ အရီရရီ),
				'other' => q(မာလာဂါစီ အရီရရီ),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(မက်ဆီဒိုးနီးယား ဒီနာ),
				'other' => q(မက်ဆီဒိုးနီးယား ဒီနာ),
			},
		},
		'MMK' => {
			symbol => 'K',
			display_name => {
				'currency' => q(မြန်မာ ကျပ်),
				'other' => q(မြန်မာ ကျပ်),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(မွန်ဂိုးလီးယား ထူးဂရခ်),
				'other' => q(မွန်ဂိုးလီးယား ထူးဂရခ်),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(မကာအို ပါတားကား),
				'other' => q(မကာအို ပါတားကား),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(မော်ရီတေးနီးယား အူဂီးယာ \(၁၉၇၃–၂၀၁၇\)),
				'other' => q(မော်ရီတေးနီးယား အူဂီးယာ \(၁၉၇၃–၂၀၁၇\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(မော်ရီတေးနီးယန်း အူဂီးယာ),
				'other' => q(မော်ရီတေးနီးယန်း အူဂီးယာ),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(မောရစ်ရှ ရူပီး),
				'other' => q(မောရစ်ရှ ရူပီး),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(မော်လ်ဒိုက် ရူးဖီရာ),
				'other' => q(မော်လ်ဒိုက် ရူးဖီရာ),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(မာလာဝီ ခွါးချာ),
				'other' => q(မာလာဝီ ခွါးချာ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(မက်ကဆီကို ပီဆို),
				'other' => q(မက်ကဆီကို ပီဆို),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(မလေးရှား ရင်းဂစ်),
				'other' => q(မလေးရှား ရင်းဂစ်),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(မိုဇမ်ဘစ် မက်တီခယ်လ်),
				'other' => q(မိုဇမ်ဘစ် မက်တီခယ်လ်),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(နမီးဘီးယား ဒေါ်လာ),
				'other' => q(နမီးဘီးယား ဒေါ်လာ),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(နိုင်ဂျီးရီးယား နိုင်းရာ),
				'other' => q(နိုင်ဂျီးရီးယား နိုင်းရာ),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(နီကာရာဂွါ ခိုးဒိုဘာ),
				'other' => q(နီကာရာဂွါ ခိုးဒိုဘာ),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(နော်ဝေ ခရိုဏာ),
				'other' => q(နော်ဝေ ခရိုဏာ),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(နီပေါ ရူပီး),
				'other' => q(နီပေါ ရူပီး),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(နယူးဇီလန် ဒေါ်လာ),
				'other' => q(နယူးဇီလန် ဒေါ်လာ),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(အိုမန်နီ ရီရယ်),
				'other' => q(အိုမန်နီ ရီရယ်),
			},
		},
		'PAB' => {
			symbol => 'B/.',
			display_name => {
				'currency' => q(ပနားမား ဘလျဘိုးအာ),
				'other' => q(ပနားမား ဘလျဘိုးအာ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(ပီရူး ဆိုးလ်),
				'other' => q(ပီရူး ဆိုးလ်),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(ပါပူအာ နယူးဂီနီ ခီးနာ),
				'other' => q(ပါပူအာ နယူးဂီနီ ခီးနာ),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ဖိလစ်ပိုင် ပီဆို),
				'other' => q(ဖိလစ်ပိုင် ပီဆို),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(ပါကစ္စတန် ရူပီး),
				'other' => q(ပါကစ္စတန် ရူပီး),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(ပိုလန် ဇလော့တီ),
				'other' => q(ပိုလန် ဇလော့တီ),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(ပါရာဂွေး ဂွါးအ်နီး),
				'other' => q(ပါရာဂွေး ဂွါးအ်နီး),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(ကာတာရီ ရီရယ်),
				'other' => q(ကာတာရီ ရီရယ်),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ရိုမေးနီးယား လယ်အို),
				'other' => q(ရိုမေးနီးယား လယ်အို),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(ဆားဘီးယား ဒယ်နား),
				'other' => q(ဆားဘီးယား ဒယ်နား),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ရုရှ ရူဘယ်),
				'other' => q(ရုရှ ရူဘယ်),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(ရုရှ ရူဘယ် \(၁၉၉၁–၁၉၉၈\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ရဝန်ဒါ ဖရန့်),
				'other' => q(ရဝန်ဒါ ဖရန့်),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(ဆော်ဒီအာရေးဗီးယား ရီယော်လ်),
				'other' => q(ဆော်ဒီအာရေးဗီးယား ရီယော်လ်),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(ဆော်လမွန်ကျွန်းစု ဒေါ်လာ),
				'other' => q(ဆော်လမွန်ကျွန်းစု ဒေါ်လာ),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(ဆေးရှဲ ရူပီး),
				'other' => q(ဆေးရှဲ ရူပီး),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(ဆူဒန် ပေါင်),
				'other' => q(ဆူဒန် ပေါင်),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(ဆူဒန် ပေါင်အဟောင်း),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(ဆွီဒင် ခရိုဏာ),
				'other' => q(ဆွီဒင် ခရိုဏာ),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(စင်္ကာပူ ဒေါ်လာ),
				'other' => q(စင်္ကာပူ ဒေါ်လာ),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(စိန့်ဟယ်လယ်နာ ပေါင်),
				'other' => q(စိန့်ဟယ်လယ်နာ ပေါင်),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(ဆီယာရာလီယွန်း လီအိုနီ),
				'other' => q(ဆီယာရာလီယွန်း လီအိုနီ),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(ဆိုမာလီ သျှီလင်),
				'other' => q(ဆိုမာလီ သျှီလင်),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(ဆူရီနမ်း ဒေါ်လာ),
				'other' => q(ဆူရီနမ်း ဒေါ်လာ),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(တောင်ဆူဒန် ပေါင်),
				'other' => q(တောင်ဆူဒန် ပေါင်),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(ဆောင်တူမေးနှင့် ပရင်စီပီ ဒိုဘရာ),
				'other' => q(ဆောင်တူမေးနှင့် ပရင်စီပီ ဒိုဘရာ),
			},
		},
		'STN' => {
			symbol => 'Db',
			display_name => {
				'currency' => q(ဆောင်တူမေးနှင့် ပရင်စီပီ ဒိုဘရာ \(၂၀၁၈\)),
				'other' => q(ဆောင်တူမေးနှင့် ပရင်စီပီ ဒိုဘရာစ် \(၂၀၁၈\)),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(ဆိုဗီယက် ရူဗယ်),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(ဆီးရီးယား ပေါင်),
				'other' => q(ဆီးရီးယား ပေါင်),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(ဆွာဇီလန် လီလန်းဂီနီ),
				'other' => q(ဆွာဇီလန် လီလန်းဂီနီ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(ထိုင်း ဘတ်),
				'other' => q(ထိုင်း ဘတ်),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(တာဂျစ်ကစ္စတန် ဆိုမိုနီ),
				'other' => q(တာဂျစ်ကစ္စတန် ဆိုမိုနီ),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(တာ့ခ်မင်နစ္စတန် မာနတ်),
				'other' => q(တာ့ခ်မင်နစ္စတန် မာနတ်),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(တူနီးရှား ဒိုင်နာ),
				'other' => q(တူနီးရှား ဒိုင်နာ),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(တွန်ဂါ ဗန်ဂါ),
				'other' => q(တွန်ဂါ ဗန်ဂါ),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(ရှေးဟောင်းတူရကီ လိုင်ရာ),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(တူရကီ လိုင်ရာ),
				'other' => q(တူရကီ လိုင်ရာ),
			},
		},
		'TTD' => {
			symbol => 'TT$',
			display_name => {
				'currency' => q(ထရီနီဒတ်နှင့် တိုဘက်ဂို ဒေါ်လာ),
				'other' => q(ထရီနီဒတ်နှင့် တိုဘက်ဂို ဒေါ်လာ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ထိုင်ဝမ် ဒေါ်လာအသစ်),
				'other' => q(ထိုင်ဝမ် ဒေါ်လာအသစ်),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(တန်ဇန်းနီးယား သျှီလင်),
				'other' => q(တန်ဇန်းနီးယား သျှီလင်),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ယူကရိန်း ဟီရီဗင်းညား),
				'other' => q(ယူကရိန်း ဟီရီဗင်းညား),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ယူဂန္ဒာ သျှီလင်),
				'other' => q(ယူဂန္ဒာ သျှီလင်),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(အမေရိကန် ဒေါ်လာ),
				'other' => q(အမေရိကန် ဒေါ်လာ),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(အမေရိကန် ဒေါ်လာ \(နောက်နေ့\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(အမေရိကန် ဒေါ်လာ \(တနေ့တည်း\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ဥရုဂွေး ပီဆို),
				'other' => q(ဥရုဂွေး ပီဆို),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ဥဇဘက်ကစ္စတန် ဆော်မ်),
				'other' => q(ဥဇဘက်ကစ္စတန် ဆော်မ်),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ဗင်နီဇွဲလား ဘိုလီဗာ \(၂၀၀၈–၂၀၁၈\)),
				'other' => q(ဗင်နီဇွဲလား ဘိုလီဗာ \(၂၀၀၈–၂၀၁၈\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(ဗင်နီဇွဲလန်း ဘိုလီဗာ),
				'other' => q(ဗင်နီဇွဲလန်း ဘိုလီဗာ),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ဗီယက်နမ် ဒေါင်),
				'other' => q(ဗီယက်နမ် ဒေါင်),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(ဗနွားတူ ဗားထူ),
				'other' => q(ဗနွားတူ ဗားထူ),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ဆမိုအား ထားလာ),
				'other' => q(ဆမိုအား ထားလာ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ကင်မရွန်း ဖရန့်),
				'other' => q(ကင်မရွန်း ဖရန့်),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(ငွေ),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(ရွှေ),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ဥရောပငွေကြေးစံနစ်),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(အရှေ့ကာရစ်ဘီယံ ဒေါ်လာ),
				'other' => q(အရှေ့ကာရစ်ဘီယံ ဒေါ်လာ),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(အထူးထုတ်ယူခွင့်),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(အနောက် အာဖရိက CFA ဖရန့်),
				'other' => q(အနောက် အာဖရိက CFA ဖရန့်),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP ဖရန့်),
				'other' => q(CFP ဖရန့်),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(ပလက်တီနမ်),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(စမ်းသပ် ငွေကြေး ကုဒ်),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(မသိသို့မဟုတ်မရှိသောငွေကြေး),
				'other' => q(\(မသိသို့မဟုတ်မရှိသောငွေကြေး\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ယီမင်နီ ရီရယ်),
				'other' => q(ယီမင်နီ ရီရယ်),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(တောင်အာဖရိက ရန်း),
				'other' => q(တောင်အာဖရိက ရန်း),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ဇင်ဘာဘွေ ခွါးချာ),
				'other' => q(ဇင်ဘာဘွေ ခွါးချာ),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ဇင်ဘာဘွေ ဒေါ်လာ),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ဇန်',
							'ဖေ',
							'မတ်',
							'ဧ',
							'မေ',
							'ဇွန်',
							'ဇူ',
							'ဩ',
							'စက်',
							'အောက်',
							'နို',
							'ဒီ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ဇ',
							'ဖ',
							'မ',
							'ဧ',
							'မ',
							'ဇ',
							'ဇ',
							'ဩ',
							'စ',
							'အ',
							'န',
							'ဒ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ဇန်နဝါရီ',
							'ဖေဖော်ဝါရီ',
							'မတ်',
							'ဧပြီ',
							'မေ',
							'ဇွန်',
							'ဇူလိုင်',
							'ဩဂုတ်',
							'စက်တင်ဘာ',
							'အောက်တိုဘာ',
							'နိုဝင်ဘာ',
							'ဒီဇင်ဘာ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ဇန်',
							'ဖေ',
							'မတ်',
							'ဧ',
							'မေ',
							'ဇွန်',
							'ဇူ',
							'ဩ',
							'စက်',
							'အောက်',
							'နို',
							'ဒီ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ဇ',
							'ဖ',
							'မ',
							'ဧ',
							'မ',
							'ဇ',
							'ဇ',
							'ဩ',
							'စ',
							'အ',
							'န',
							'ဒ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ဇန်နဝါရီ',
							'ဖေဖော်ဝါရီ',
							'မတ်',
							'ဧပြီ',
							'မေ',
							'ဇွန်',
							'ဇူလိုင်',
							'ဩဂုတ်',
							'စက်တင်ဘာ',
							'အောက်တိုဘာ',
							'နိုဝင်ဘာ',
							'ဒီဇင်ဘာ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
					narrow => {
						mon => 'တ',
						tue => 'အ',
						wed => 'ဗ',
						thu => 'က',
						fri => 'သ',
						sat => 'စ',
						sun => 'တ'
					},
					short => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
					wide => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
					narrow => {
						mon => 'တ',
						tue => 'အ',
						wed => 'ဗ',
						thu => 'က',
						fri => 'သ',
						sat => 'စ',
						sun => 'တ'
					},
					short => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
					wide => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ပထမ သုံးလပတ်',
						1 => 'ဒုတိယ သုံးလပတ်',
						2 => 'တတိယ သုံးလပတ်',
						3 => 'စတုတ္ထ သုံးလပတ်'
					},
					narrow => {0 => 'ပ',
						1 => 'ဒု',
						2 => 'တ',
						3 => 'စ'
					},
					wide => {0 => 'ပထမ သုံးလပတ်',
						1 => 'ဒုတိယ သုံးလပတ်',
						2 => 'တတိယ သုံးလပတ်',
						3 => 'စတုတ္ထ သုံးလပတ်'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ပထမ သုံးလပတ်',
						1 => 'ဒုတိယ သုံးလပတ်',
						2 => 'တတိယ သုံးလပတ်',
						3 => 'စတုတ္ထ သုံးလပတ်'
					},
					narrow => {0 => 'ပ',
						1 => 'ဒု',
						2 => 'တ',
						3 => 'စ'
					},
					wide => {0 => 'ပထမ သုံးလပတ်',
						1 => 'ဒုတိယ သုံးလပတ်',
						2 => 'တတိယ သုံးလပတ်',
						3 => 'စတုတ္ထ သုံးလပတ်'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{နေ့လယ်},
					'am' => q{နံနက်},
					'evening1' => q{ညနေ},
					'midnight' => q{သန်းခေါင်ယံ},
					'morning1' => q{နံနက်},
					'night1' => q{ည},
					'noon' => q{မွန်းတည့်},
					'pm' => q{ညနေ},
				},
				'narrow' => {
					'afternoon1' => q{နေ့လယ်},
					'am' => q{နံနက်},
					'evening1' => q{ညနေ},
					'midnight' => q{သန်းခေါင်ယံ},
					'morning1' => q{နံနက်},
					'night1' => q{ည},
					'noon' => q{မွန်းတည့်},
					'pm' => q{ညနေ},
				},
				'wide' => {
					'afternoon1' => q{နေ့လယ်},
					'am' => q{နံနက်},
					'evening1' => q{ညနေ},
					'midnight' => q{သန်းခေါင်ယံ},
					'morning1' => q{နံနက်},
					'night1' => q{ည},
					'noon' => q{မွန်းတည့်},
					'pm' => q{ညနေ},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{နေ့လယ်},
					'am' => q{နံနက်},
					'evening1' => q{ညနေ},
					'midnight' => q{သန်းခေါင်ယံ},
					'morning1' => q{နံနက်},
					'night1' => q{ည},
					'noon' => q{မွန်းတည့်},
					'pm' => q{ညနေ},
				},
				'narrow' => {
					'afternoon1' => q{နေ့လယ်},
					'am' => q{နံနက်},
					'evening1' => q{ညနေ},
					'midnight' => q{သန်းခေါင်ယံ},
					'morning1' => q{နံနက်},
					'night1' => q{ည},
					'noon' => q{မွန်းတည့်},
					'pm' => q{ညနေ},
				},
				'wide' => {
					'afternoon1' => q{နေ့လယ်},
					'am' => q{နံနက်},
					'evening1' => q{ညနေ},
					'midnight' => q{သန်းခေါင်ယံ},
					'morning1' => q{နံနက်},
					'night1' => q{ည},
					'noon' => q{မွန်းတည့်},
					'pm' => q{ညနေ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ဘီစီ',
				'1' => 'အဒေီ'
			},
			wide => {
				'0' => 'ခရစ်တော် မပေါ်မီနှစ်',
				'1' => 'ခရစ်နှစ်'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE G dd MMMM y},
			'long' => q{G dd MMMM y},
			'medium' => q{G d MMM y},
			'short' => q{GGGGG dd-MM-yy},
		},
		'gregorian' => {
			'full' => q{y၊ MMMM d၊ EEEE},
			'long' => q{y၊ d MMMM},
			'medium' => q{y၊ MMM d},
			'short' => q{dd-MM-yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{zzzz HH:mm:ss},
			'long' => q{z HH:mm:ss},
			'medium' => q{B HH:mm:ss},
			'short' => q{B H:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			E => q{ccc},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E a h:mm},
			Ehms => q{E a h:mm:ss},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G d MMM y Eနေ့},
			GyMMMd => q{G d MMM y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{d/M Eနေ့},
			MMM => q{LLL},
			MMMEd => q{MMM d၊ E},
			MMMMEd => q{MMMM d Eနေ့},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{d/M},
			d => q{d},
			h => q{a h},
			hm => q{a h:mm},
			hms => q{a h:mm:ss},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{G M/y},
			yyyyMEd => q{GGGGG dd/MM/y Eနေ့},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G d MMM y Eနေ့},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G d MMM y},
			yyyyMd => q{GGGGG dd/MM/Y},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			E => q{cccနေ့},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d ရက် Eနေ့},
			Ehm => q{E B h:mm},
			Ehms => q{E B h:mm:ss},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y၊ MMM d၊ E},
			GyMMMd => q{G y၊ MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{v HH:mm:ss},
			Hmv => q{v HH:mm},
			M => q{L},
			MEd => q{d/M၊ E},
			MMM => q{LLL},
			MMMEd => q{MMM d၊ E},
			MMMMEd => q{MMMM d ရက် Eနေ့},
			MMMMW => q{MMM လ W ပတ်မြောက်},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{B h},
			hm => q{B h:mm},
			hms => q{B h:mm:ss},
			hmsv => q{v a h:mm:ss},
			hmv => q{v a h:mm},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{d/M/y၊ E},
			yMMM => q{MMM y},
			yMMMEd => q{y၊ MMM d၊ E},
			yMMMM => q{y MMMM},
			yMMMd => q{y၊ MMM d},
			yMd => q{dd-MM-y},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
			yw => q{Y ခု w ပတ်မြောက်},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{1} {0}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{d/M Eနေ့ – d/M Eနေ့},
				d => q{d/M Eနေ့ – d/M Eနေ့},
			},
			MMM => {
				M => q{MMMM – MMMM},
			},
			MMMEd => {
				M => q{d MMM Eနေ့ – d MMM Eနေ့},
				d => q{d MMM Eနေ့ – d MMM Eနေ့},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d –d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y – y},
			},
			yM => {
				M => q{GGGGG M/y – M/y},
				y => q{GGGGG M/y – M/y},
			},
			yMEd => {
				M => q{GGGGG d/M/y Eနေ့ – d/M/y Eနေ့},
				d => q{GGGGG d/M/y Eနေ့ – d/M/y Eနေ့},
				y => q{GGGGG d/M/y Eနေ့ – d/M/y Eနေ့},
			},
			yMMM => {
				M => q{G MMM y – MMM y},
				y => q{G MMM y – MMM y},
			},
			yMMMEd => {
				M => q{G y MMM d E – y MMM d E},
				d => q{G y MMM d E – y MMM d E},
				y => q{G y MMM d E – y MMM d E},
			},
			yMMMM => {
				M => q{G y MMMM – MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G d – d MMM y},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{GGGGG d/M/y – d/M/y},
				d => q{GGGGG d/M/y – d/M/y},
				y => q{GGGGG d/M/y – d/M/y},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{v HH:mm – HH:mm},
				m => q{v HH:mm – HH:mm},
			},
			Hv => {
				H => q{v HH – HH},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{d/M၊ EEEE – d/M၊ EEEE},
				d => q{d/M၊ EEEE – d/M၊ EEEE},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{MMM d၊ E – MMM d၊ E},
				d => q{MMM d၊ E – MMM d၊ E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d – d},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{a h – a h},
				h => q{a h – h},
			},
			hm => {
				a => q{a h:mm – a h:mm},
				h => q{a h:mm – h:mm},
				m => q{a h:mm – h:mm},
			},
			hmv => {
				a => q{v a h:mm – a h:mm},
				h => q{v a h:mm – h:mm},
				m => q{v a h:mm – h:mm},
			},
			hv => {
				a => q{v a h – a h},
				h => q{v a h – h},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{d/M/y၊ EEEE – d/M/y၊ EEEE},
				d => q{d/M/y၊ EEEE – d/M/y၊ EEEE},
				y => q{d/M/y၊ EEEE – d/M/y၊ EEEE},
			},
			yMMM => {
				M => q{y MMM – MMM},
				y => q{y MMM – y MMM},
			},
			yMMMEd => {
				M => q{y၊ MMM d၊ EEEE – MMM d၊ EEEE},
				d => q{y၊ MMM d၊ EEEE – MMM d၊ EEEE},
				y => q{y၊ MMM d၊ EEEE – y၊ MMM d၊ EEEE},
			},
			yMMMM => {
				M => q{y MMMM – MMMM},
				y => q{y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{y၊ MMM d – MMM d},
				d => q{y၊ MMM d – d},
				y => q{y၊ MMM d – y၊ MMM d},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} အချိန်),
		regionFormat => q({0} နွေရာသီ စံတော်ချိန်),
		regionFormat => q({0} စံတော်ချိန်),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#အာဖဂန်နစ္စတန် အချိန်#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#အာဘီဂျန်#,
		},
		'Africa/Accra' => {
			exemplarCity => q#အက်ကရာ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#အားဒစ် အဘာဘာ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#အယ်လ်ဂျီးရီးယား#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#အားစ်မားရာ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ဘာမာကို#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ဘာန်ဂီး#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ဘန်ဂျုးလ်#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ဘီစာအို#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ဘလန်တိုင်းရဲလ်#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ဘရားဇာဗီးလ်#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ဘူဂျွန်ဘူးရာ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ကိုင်ရို#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ကာဆာဘလန်ကာ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ဆီရူးတာ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ကိုနာကရီး#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ဒက်ကား#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ဒါရက်စ်ဆာလမ်#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ဂျီဘူတီ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ဒိုအူအာလာ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#အယ်လ်အာယွန်း#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ဖရီးတောင်းန်#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ဂါဘာရွန်းနီ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ဟာရားရဲယ်#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ဂျိုဟန်းနက်စဘတ်#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ဂျုဘာ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ကမ်ပါလာ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ခါတိုအန်#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ကီဂါးလီ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ကင်ရှာစာ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#လာဂိုစ်#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#လီဗရာဗီးလ်#,
		},
		'Africa/Lome' => {
			exemplarCity => q#လိုမီ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#လူဝမ်ဒါ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#လူဘွန်းဘာရှီ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#လူစာကာ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#မာလာဘို#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#မာပူးတို#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#မာဆူရူး#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ဘားဘာန်း#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#မော်ဂါဒီးသျုး#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#မွန်ရိုးဗီးယား#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#နိုင်ရိုဘီ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#အင်ဂျာမီနာ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ညာမဲယ်#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#နိုအာ့ခ်ရှော့တ်#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ဝါဂါဒူးဂူ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ပိုတို-နိုဗို#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ဆောင်တူမေး#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ထရီပိုလီ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#တူနီစ်#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ဗင်းဟူးခ်#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#အလယ်အာဖရိက အချိန်#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#အရှေ့အာဖရိက အချိန်#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#တောင်အာဖရိက အချိန်#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#အနောက်အာဖရိက နွေရာသီ အချိန်#,
				'generic' => q#အနောက်အာဖရိက အချိန်#,
				'standard' => q#အနောက်အာဖရိက စံတော်ချိန်#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#အလာစကာ နွေရာသီ စံတော်ချိန်#,
				'generic' => q#အလာစကာ အချိန်#,
				'standard' => q#အလာစကာ စံတော်ချိန်#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#အမေဇုံ နွေရာသီအချိန်#,
				'generic' => q#အမေဇုံ အချိန်#,
				'standard' => q#အမေဇုံ စံတော်ချိန်#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#အာဒချ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#အန်ကာရေ့ဂျ်#,
		},
		'America/Anguilla' => {
			exemplarCity => q#အန်ဂီလာ#,
		},
		'America/Antigua' => {
			exemplarCity => q#အန်တီဂွါ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#အာရာဂွါအီနာ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#လာ ရီယိုဟာ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ရီယို ဂါလီဂိုစ်#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ဆာလ်တာ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ဆန် ဂွမ်#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ဆန် လူဝီစ်#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#တူကူမန်#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ဥဆွာအီအာ#,
		},
		'America/Aruba' => {
			exemplarCity => q#အာရူးဗာ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#အာဆူစီအွန်း#,
		},
		'America/Bahia' => {
			exemplarCity => q#ဘာဟီအာ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ဘာဟီအာ ဘန်ဒရက်စ်#,
		},
		'America/Barbados' => {
			exemplarCity => q#ဘာဘေးဒိုးစ်#,
		},
		'America/Belem' => {
			exemplarCity => q#ဘီလင်မ်#,
		},
		'America/Belize' => {
			exemplarCity => q#ဘလိဇ်#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ဘလွန်ခ်-စာဘလွန်#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ဘိုအာဗီစ်တာ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ဘိုဂိုတာ#,
		},
		'America/Boise' => {
			exemplarCity => q#ဗွိုက်စီ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ဗျူနိုအေးရိစ်#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ကိန်းဘရစ်ချ် ဘေး#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ကိမ်ပို ဂရန်ဒီ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ကန်ခန်#,
		},
		'America/Caracas' => {
			exemplarCity => q#ကာရာကာစ်#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ကာတာမာရျကာ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ကေညင်န်#,
		},
		'America/Cayman' => {
			exemplarCity => q#ကေမန်#,
		},
		'America/Chicago' => {
			exemplarCity => q#ချီကာကို#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ချီဟူအာဟူအာ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#အာတီကိုကန်#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ကိုဒိုဘာ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ကို့စတာရီကာ#,
		},
		'America/Creston' => {
			exemplarCity => q#ကရစ်စတွန်#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ကွီရာဘာ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ကျူရေးကိုး#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ဒန်မတ်ရှ်ဗာန်#,
		},
		'America/Dawson' => {
			exemplarCity => q#ဒေါ်ဆန်#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ဒေါ်ဆန် ခရိခ်#,
		},
		'America/Denver' => {
			exemplarCity => q#ဒင်န်ဗာ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ဒက်ထရွိုက်#,
		},
		'America/Dominica' => {
			exemplarCity => q#ဒိုမီနီကာ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#အက်ဒ်မွန်တန်#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#အီရူနီပီ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#အယ်လ်ဆာဗေဒို#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ဖို့တ် နယ်လ်ဆင်#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ဖို့တ်တာလီဇာ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ဂလဲစ်ဘေး#,
		},
		'America/Godthab' => {
			exemplarCity => q#နုခ်#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ဂူးစ်ဘေး#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ဂရန်ဒ် တခ်#,
		},
		'America/Grenada' => {
			exemplarCity => q#ဂရီနေဒါ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ဂွါဒီလုပ်#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ဂွါတီမာလာ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ဂွါရာကွီးလ်#,
		},
		'America/Guyana' => {
			exemplarCity => q#ဂိုင်ယာနာ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ဟလီဖက်စ်#,
		},
		'America/Havana' => {
			exemplarCity => q#ဟာဗာနာ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ဟာမိုစ်စီလို#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#နောက်ခ်စ် အင်ဒီယားနား#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#မာရန်ဂို အင်ဒီယားနား#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ပီတာစ်ဘတ်ခ် အင်ဒီယားနား#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#တဲလ်စီးတီး အင်ဒီယားနား#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ဗီဗဲ အင်ဒီယားနား#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ဗင်ဆင့်စ် အင်ဒီယားနား#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ဝီနာမက်ခ် အင်ဒီယားနား#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#အင်ဒီယားနား ပိုလိစ်#,
		},
		'America/Inuvik' => {
			exemplarCity => q#အီနုဗီခ်#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#အီကာလူအီတ်#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ဂျမေကာ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ဂျုဂျေ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ဂျုနိုအော#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#မွန်တီချယ်လို ကင်တပ်ကီ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ခရာလဲန်းဒစ်ချ်#,
		},
		'America/La_Paz' => {
			exemplarCity => q#လာပါဇ်#,
		},
		'America/Lima' => {
			exemplarCity => q#လီမာ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#လော့စ်အိန်ဂျယ်လိစ်#,
		},
		'America/Louisville' => {
			exemplarCity => q#လူဝီဗီးလ်#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#လိုအာပရင့်စ် ကွာတာ#,
		},
		'America/Maceio' => {
			exemplarCity => q#မာဆဲသွာ#,
		},
		'America/Managua' => {
			exemplarCity => q#မာနာဂွါ#,
		},
		'America/Manaus' => {
			exemplarCity => q#မာနောက်စ်#,
		},
		'America/Marigot' => {
			exemplarCity => q#မာရီဂေါ့#,
		},
		'America/Martinique' => {
			exemplarCity => q#မာတီနီဂ်#,
		},
		'America/Matamoros' => {
			exemplarCity => q#မာတာမိုရိုစ်#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#မာဇတ်လန်#,
		},
		'America/Mendoza' => {
			exemplarCity => q#မန်ဒိုဇာ#,
		},
		'America/Menominee' => {
			exemplarCity => q#မီနိုမီနီး#,
		},
		'America/Merida' => {
			exemplarCity => q#မီရီဒါ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#မက်တ်လာကက်လာ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#မက်ကဆီကို စီးတီး#,
		},
		'America/Miquelon' => {
			exemplarCity => q#မီကွီလွန်#,
		},
		'America/Moncton' => {
			exemplarCity => q#မွန်ခ်တွန်#,
		},
		'America/Monterrey' => {
			exemplarCity => q#မွန်တဲရေး#,
		},
		'America/Montevideo' => {
			exemplarCity => q#မွန်တီဗီဒီအို#,
		},
		'America/Montserrat' => {
			exemplarCity => q#မွန့်(တ်)ဆေးရတ်#,
		},
		'America/Nassau' => {
			exemplarCity => q#နာ့ဆော်#,
		},
		'America/New_York' => {
			exemplarCity => q#နယူးယောက်#,
		},
		'America/Nipigon' => {
			exemplarCity => q#နီပီဂွန်#,
		},
		'America/Nome' => {
			exemplarCity => q#နိုမီ#,
		},
		'America/Noronha' => {
			exemplarCity => q#နိုရိုညာ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ဗြူလာ၊ မြောက်ဒါကိုတာ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#စင်တာ၊ မြောက်ဒါကိုတာ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#နယူးဆေးလမ်၊ မြောက်ဒါကိုတာ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#အိုခီနဂါ#,
		},
		'America/Panama' => {
			exemplarCity => q#ပနားမား#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ဖန်ဂ်နသ်တံ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ပါရာမာရီဘို#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ဖီးနစ်#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ပို့တ်-အို-ပရင့်စ်#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ပို့တ် အော့ဖ် စပိန်#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ပို့တ်တို ဗဲလီယို#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ပေါ်တိုရီကို#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#ပွန်တာ အရီနာစ်#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ရိမ်းနီး ရီဗာ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ရန်ကင် အင်းလက်#,
		},
		'America/Recife' => {
			exemplarCity => q#ဟေစီဖီလ်#,
		},
		'America/Regina' => {
			exemplarCity => q#ရယ်ဂျီနာ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ရီဆိုလုပ်(တ်)#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ရီယို ဘရန်ကို#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ဆန်တာ အစ္ဇဘဲလ်#,
		},
		'America/Santarem' => {
			exemplarCity => q#ဆန်တာရမ်#,
		},
		'America/Santiago' => {
			exemplarCity => q#ဆန်တီအာဂို#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ဆန်တို ဒိုမင်းဂို#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ဆော်ပိုလို#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#အစ်တာကာ တိုးမိရက်တ်#,
		},
		'America/Sitka' => {
			exemplarCity => q#စစ်ကာ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#စိန့်ဘာသယ်လမီ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#စိန့်ဂျွန်း#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#စိန့်ကိစ်#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#စိန့်လူစီယာ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#စိန့်သောမတ်စ်#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#စိန့်ဗင်းဆင့်#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#စွတ်ဖ်တ် ကားရင့်#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#တီဂူစီဂလ်ပါ#,
		},
		'America/Thule' => {
			exemplarCity => q#သုလီ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#သန်းန်ဒါး ဘေး#,
		},
		'America/Tijuana' => {
			exemplarCity => q#တီဂွါနာ#,
		},
		'America/Toronto' => {
			exemplarCity => q#တိုရန်တို#,
		},
		'America/Tortola' => {
			exemplarCity => q#တောတိုလာ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ဗန်ကူးဗား#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ဝိုက်(တ်)ဟိုစ်#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ဝီနီဗက်ဂ်#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ရာကုတတ်#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ရဲလိုနိုက်ဖ်#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#မြောက်အမေရိက အလယ်ပိုင်း နွေရာသီစံတော်ချိန်#,
				'generic' => q#မြောက်အမေရိက အလယ်ပိုင်းအချိန်#,
				'standard' => q#မြောက်အမေရိက အလယ်ပိုင်းစံတော်ချိန်#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#မြောက်အမေရိက အရှေ့ပိုင်း နွေရာသီစံတော်ချိန်#,
				'generic' => q#မြောက်အမေရိက အရှေ့ပိုင်းအချိန်#,
				'standard' => q#မြောက်အမေရိက အရှေ့ပိုင်းစံတော်ချိန်#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#မြောက်အမေရိက တောင်တန်းဒေသ နွေရာသီစံတော်ချိန်#,
				'generic' => q#မြောက်အမေရိက တောင်တန်းဒေသအချိန်#,
				'standard' => q#မြောက်အမေရိက တောင်တန်းဒေသစံတော်ချိန်#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#မြောက်အမေရိက ပစိဖိတ် နွေရာသီစံတော်ချိန်#,
				'generic' => q#မြောက်အမေရိက ပစိဖိတ်အချိန်#,
				'standard' => q#မြောက်အမေရိက ပစိဖိတ်စံတော်ချိန်#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ကေစီ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ဒေးဗစ်#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ဒူးမော့တ် ဒါရ်ဗီးလ်#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#မက်ကွယ်ရီ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#မော်စွန်#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#မက်မူဒိုး#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ပါလ်မာ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ရိုသီရာ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ရှိုးဝါ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ထရိုလ်#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ဗိုစ်တိုခ်#,
		},
		'Apia' => {
			long => {
				'daylight' => q#အပီယာ နွေရာသီ အချိန်#,
				'generic' => q#အပီယာ အချိန်#,
				'standard' => q#အပီယာ စံတော်ချိန်#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#အာရေဗျ နွေရာသီ အချိန်#,
				'generic' => q#အာရေဗျ အချိန်#,
				'standard' => q#အာရေဗျ စံတော်ချိန်#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#လောင်ရီယားဘရံ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#အာဂျင်တီးနား နွေရာသီအချိန်#,
				'generic' => q#အာဂျင်တီးနား အချိန်#,
				'standard' => q#အာဂျင်တီးနား စံတော်ချိန်#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#အနောက် အာဂျင်တီးနား နွေရာသီ အချိန်#,
				'generic' => q#အနောက် အာဂျင်တီးနား အချိန်#,
				'standard' => q#အနောက် အာဂျင်တီးနား စံတော်ချိန်#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#အာမေးနီးယား နွေရာသီ အချိန်#,
				'generic' => q#အာမေးနီးယား အချိန်#,
				'standard' => q#အာမေးနီးယား စံတော်ချိန်#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#အာဒင်#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#အော်မာတီ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#အာမာန်း#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#အန်အာဒီအာ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#အက်တာဥု#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#အာချတူးဘီ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#အာရှ်ဂါဘာဒ်#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#အာတီရအူ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ဘဂ္ဂဒက်#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ဘာရိန်း#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ဘာကူ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ဘန်ကောက်#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#ဘရ်နာအူ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ဘေရွတ်#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ဘီရှ်ခက်#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ဘရူနိုင်း#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ကိုလျကတ်တား#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ချီတာ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ချွဲဘောဆန်#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ကိုလံဘို#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ဒမားစကပ်#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ဒက်ကာ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ဒစ်လီ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ဒူဘိုင်း#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ဒူရှန်းဘဲ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ဖာမာဂူစတာ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ဂါဇာ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ဟီဘရွန်#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ဟောင်ကောင်#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ဟိုးဗျ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#အီရူခူတ်#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ဂျကာတာ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ဂျာရာပူရာ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ဂျေရုဆလင်#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ကဘူးလျ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ခမ်ချာ့ခါ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ကရာချိ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ခတ်တမန်ဒူ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ခန်ဒိုင်ဂါ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ခရာ့စ်နိုရာစ်#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ကွာလာလမ်ပူ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ကူချင်#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ကူဝိတ်#,
		},
		'Asia/Macau' => {
			exemplarCity => q#မကာအို#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#မာဂါဒန်း#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#မခက်စ်ဆာ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#မနီလာ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#မတ်စ်ကက်တ်#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#နီကိုရှား#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#နိုဗိုခူဇ်နက်စ်#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#နိုဗိုစဲဘီအဲယ်စ်#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#အွမ်းစ်ခ်#,
		},
		'Asia/Oral' => {
			exemplarCity => q#အော်ရဲလ်#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ဖနွမ်ပင်#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ပွန်တီအားနာ့ခ်#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ပြုံယန်း#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ကာတာ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ကီဇလော်ဒါ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ရန်ကုန်#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ရီယားဒ်#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ဟိုချီမင်းစီးတီး#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ဆာခါလင်#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ဆမ်းမာခန်းဒ်#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ဆိုးလ်#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ရှန်ဟိုင်း#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#စင်္ကာပူ#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ဆရစ်နစ်ကာလင်မ်စ်#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#တိုင်ပေ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#တာရှ်ကဲန့်#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#တဘီးလီစီ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#တီဟီရန်#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#တင်ဖူး#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#တိုကျို#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#တွန်မ်စ်ခ်#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ဥလန်ဘာတော#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#အူရုမ်ချီ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#အူးစ် နီရား#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ဗီယင်ကျန်း#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ဗလာဒီဗော့စတော့ခ်#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ယူခူးတ်စ်#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ရယ်ခါးတီရင်ဘားခ်#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ရဲယ်ရေဗန်း#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#အတ္တလန်တစ် နွေရာသီ စံတော်ချိန်#,
				'generic' => q#အတ္တလန်တစ် အချိန်#,
				'standard' => q#အတ္တလန်တစ် စံတော်ချိန်#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#အေဇိုးရီးစ်#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ဘာမြူဒါ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ကနေရီ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ကိတ်ပ် ဗာဒီ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ဖါရို#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#မဒီးရာ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ရေးကီဗစ်ခ်#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#တောင်ဂျော်ဂျီယာ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#စိန့်ဟယ်လယ်နာ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#စတန်လေ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#အန္ဒီလိတ်ဒ်#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ဘရစ္စဘိန်း#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ဘရိုကင်ဟီးလ်#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ကာရီ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ဒါဝင်#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ယူးခလာ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ဟိုးဘားတ်#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#လင်းဒီမန်း#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#လော့ဒ် ဟောင်#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#မဲလ်ဘုန်း#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ပါးသ်#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ဆစ်ဒနီ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ဩစတြေးလျ အလယ်ပိုင်း နွေရာသီ အချိန်#,
				'generic' => q#ဩစတြေးလျ အလယ်ပိုင်း အချိန်#,
				'standard' => q#ဩစတြေးလျ အလယ်ပိုင်း စံတော်ချိန်#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#သြစတြေးလျား အနောက်အလယ်ပိုင်း နွေရာသီ အချိန်#,
				'generic' => q#သြစတြေးလျား အနောက်အလယ်ပိုင်း အချိန်#,
				'standard' => q#သြစတြေးလျား အနောက်အလယ်ပိုင်း စံတော်ချိန်#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#အရှေ့ဩစတြေးလျ နွေရာသီ အချိန်#,
				'generic' => q#အရှေ့ဩစတြေးလျ အချိန်#,
				'standard' => q#အရှေ့ဩစတြေးလျ စံတော်ချိန်#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ဩစတြေးလျ နွေရာသီ အချိန်#,
				'generic' => q#အနောက်ဩစတြေးလျ အချိန်#,
				'standard' => q#အနောက်ဩစတြေးလျ စံတော်ချိန်#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#အဇာဘိုင်ဂျန် နွေရာသီ အချိန်#,
				'generic' => q#အဇာဘိုင်ဂျန် အချိန်#,
				'standard' => q#အဇာဘိုင်ဂျန် စံတော်ချိန်#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#အေဇိုးရီးစ် နွေရာသီ အချိန်#,
				'generic' => q#အေဇိုးရီးစ် အချိန်#,
				'standard' => q#အေဇိုးရီးစ် စံတော်ချိန်#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#ဘင်္ဂလားဒေ့ရှ် နွေရာသီ အချိန်#,
				'generic' => q#ဘင်္ဂလားဒေ့ရှ် အချိန်#,
				'standard' => q#ဘင်္ဂလားဒေ့ရှ် စံတော်ချိန်#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ဘူတန် အချိန်#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#ဘိုလီးဘီးယား အချိန်#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ဘရာဇီး နွေရာသီ အချိန်#,
				'generic' => q#ဘရာဇီး အချိန်#,
				'standard' => q#ဘရာဇီး စံတော်ချိန်#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ဘရူနိုင်း စံတော်ချိန်#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#ကိတ်ပ် ဗာဒီ နွေရာသီ အချိန်#,
				'generic' => q#ကိတ်ပ် ဗာဒီ အချိန်#,
				'standard' => q#ကိတ်ပ် ဗာဒီ စံတော်ချိန်#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#ချာမိုရို အချိန်#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#ချာသမ် နွေရာသီ အချိန်#,
				'generic' => q#ချားသမ်အချိန်#,
				'standard' => q#ချားသမ်စံတော်ချိန်#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#ချီလီ နွေရာသီ အချိန်#,
				'generic' => q#ချီလီ အချိန်#,
				'standard' => q#ချီလီ စံတော်ချိန်#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#တရုတ် နွေရာသီ အချိန်#,
				'generic' => q#တရုတ် အချိန်#,
				'standard' => q#တရုတ် စံတော်ချိန်#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#ချွဲဘော်ဆန်း နွေရာသီ အချိန်#,
				'generic' => q#ချွဲဘော်ဆန်း အချိန်#,
				'standard' => q#ချွဲဘော်ဆန်း စံတော်ချိန်#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ခရစ်စမတ်ကျွန်း အချိန်#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#ကိုကိုးကျွန်း အချိန်#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#ကိုလံဘီယာ နွေရာသီ အချိန်#,
				'generic' => q#ကိုလံဘီယာ အချိန်#,
				'standard' => q#ကိုလံဘီယာ စံတော်ချိန်#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#ကွတ်က်ကျွန်းစု နွေရာသီ အချိန်#,
				'generic' => q#ကွတ်ခ်ကျွန်းစု အချိန်#,
				'standard' => q#ကွတ်ခ်ကျွန်းစု စံတော်ချိန်#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#ကျူးဘား နွေရာသီ စံတော်ချိန်#,
				'generic' => q#ကျူးဘား အချိန်#,
				'standard' => q#ကျူးဘား စံတော်ချိန်#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ဒေးဗစ် အချိန်#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ဒူးမော့တ် ဒါရ်ဗီးလ် အချိန်#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#အရှေ့တီမော အချိန်#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#အီစတာကျွန်းနွေရာသီအချိန်#,
				'generic' => q#အီစတာကျွန်းအချိန်#,
				'standard' => q#အီစတာကျွန်းစံတော်ချိန်#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#အီကွေဒေါ အချိန်#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#ညှိထားသည့် ကမ္ဘာ့ စံတော်ချိန်#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#အမည်မသိသောမြို့#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#အမ်စတာဒမ်#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#အန်ဒိုရာ#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#အားစ်တရခန်း#,
		},
		'Europe/Athens' => {
			exemplarCity => q#အေသင်#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ဘဲလ်ဂရိတ်#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ဘာလင်#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ဘရာတီးစ်လားဗာ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ဘရပ်ဆဲလ်#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ဘူခါရက်စ်#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ဘူဒါပက်စ်#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ဘူရှင်ဂျင်#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ချီရှီနားအူ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ကိုပင်ဟေဂင်#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ဒတ်ဘလင်#,
			long => {
				'daylight' => q#အိုင်းရစ်ရှ် စံတော်ချိန်#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ဂျီဘရော်လ်တာ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ဂွန်းဇီ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ဟဲလ်စင်ကီ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#မန်းကျွန်း#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#အစ္စတန်ဘူလ်#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ဂျာစီ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ခါလီနင်ဂရက်#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ခီးအက်ဖ်#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#ခီရိုဗ်#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#လစ္စဘွန်း#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#လူဘလီအားနား#,
		},
		'Europe/London' => {
			exemplarCity => q#လန်ဒန်#,
			long => {
				'daylight' => q#ဗြိတိန် နွေရာသီ အချိန်#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#လူဇင်ဘတ်#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#မဒရစ်#,
		},
		'Europe/Malta' => {
			exemplarCity => q#မော်လ်တာ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#မရီအာ ဟားမန်#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#မင်းစခ်#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#မိုနာကို#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#မော်စကို#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#အော်စလို#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ပဲရစ်#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ပေါ့ဂိုရီကာ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ပရက်ဂ်#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ရီဂါ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ရောမ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ဆာမားရာ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ဆန်မရီးနို#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ဆာရာယေဗို#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ဆာရာတို့ဖ်#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#စင်ဖာရိုးဖို#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#စကော့ပ်ရာ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ဆိုဖီအာ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#စတော့ဟုမ်း#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ထားလင်#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#တီရာနီ#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#အူလီယာနိုစကစ်ဖ်#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ဥဇ်ဂိုရို့တ်#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ဗာဒူးစ်#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ဗာတီကန်#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ဗီယင်နာ#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ဗီးလ်နီအိုးစ်#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ဗိုလ်ဂိုဂရက်#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ဝါဆော#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ဇာဂ်ဂရက်ဘ်#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ဇာဖိုရိုးစ်ဂျာ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ဇူးရစ်ချ်#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#ဥရောပအလယ်ပိုင်း နွေရာသီ အချိန်#,
				'generic' => q#ဥရောပအလယ်ပိုင်း အချိန်#,
				'standard' => q#ဥရောပအလယ်ပိုင်း စံတော်ချိန်#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#အရှေ့ဥရောပ နွေရာသီ အချိန်#,
				'generic' => q#အရှေ့ဥရောပ အချိန်#,
				'standard' => q#အရှေ့ဥရောပ စံတော်ချိန်#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#အရှေ့ဖျား ဥရောပဒေသ အချိန်#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#အနောက်ဥရောပ နွေရာသီ အချိန်#,
				'generic' => q#အနောက်ဥရောပ အချိန်#,
				'standard' => q#အနောက်ဥရောပ စံတော်ချိန်#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ဖော့ကလန်ကျွန်းစု နွေရာသီ အချိန်#,
				'generic' => q#ဖော့ကလန်ကျွန်းစု အချိန်#,
				'standard' => q#ဖော့ကလန်ကျွန်းစု စံတော်ချိန်#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ဖီဂျီ နွေရာသီ အချိန်#,
				'generic' => q#ဖီဂျီ အချိန်#,
				'standard' => q#ဖီဂျီ စံတော်ချိန်#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ပြင်သစ် ဂီအားနား အချိန်#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ပြင်သစ်တောင်ပိုင်းနှင့် အန္တာတိတ် အချိန်#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ဂရင်းနစ် စံတော်ချိန်#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ဂါလားပါဂိုးစ်အချိန်#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ဂမ်ဘီယာ အချိန်#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ဂျော်ဂျီယာ နွေရာသီ အချိန်#,
				'generic' => q#ဂျော်ဂျီယာ အချိန်#,
				'standard' => q#ဂျော်ဂျီယာ စံတော်ချိန်#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ဂီလ်ဘတ်ကျွန်းစု အချိန်#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#အရှေ့ဂရင်းလန် နွေရာသီ စံတော်ချိန်#,
				'generic' => q#အရှေ့ဂရင်းလန်း အချိန်#,
				'standard' => q#အရှေ့ဂရင်းလန်း စံတော်ချိန်#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#အနောက် ဂရင်းလန် နွေရာသီ စံတော်ချိန်#,
				'generic' => q#အနောက် ဂရင်းလန်း အချိန်#,
				'standard' => q#အနောက် ဂရင်းလန်း စံတော်ချိန်#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#ပင်လယ်ကွေ့ အချိန်#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#ဂိုင်ယာနာ အချိန်#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ဟာဝိုင်ယီ အယ်လူးရှန်း နွေရာသီ စံတော်ချိန်#,
				'generic' => q#ဟာဝိုင်ယီ အယ်လူးရှန်း အချိန်#,
				'standard' => q#ဟာဝိုင်ယီ အယ်လူးရှန်း စံတော်ချိန်#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ဟောင်ကောင် နွေရာသီ အချိန်#,
				'generic' => q#ဟောင်ကောင် အချိန်#,
				'standard' => q#ဟောင်ကောင် စံတော်ချိန်#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ဟိုးဗ် နွေရာသီ အချိန်#,
				'generic' => q#ဟိုးဗ် အချိန်#,
				'standard' => q#ဟိုးဗ် စံတော်ချိန်#,
			},
		},
		'India' => {
			long => {
				'standard' => q#အိန္ဒိယ စံတော်ချိန်#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#အန်တာနာနာရီးဘို#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ချာဂိုစ်#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ခရစ်စမတ်#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ကိုကိုးစ်#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ကိုမိုရို#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ခါဂါလန်#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#မာဟီ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#မော်လဒိုက်#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#မောရစ်ရှ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#မာယိုတဲ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ရီယူနီယန်#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#အိန္ဒိယသမုဒ္ဒရာ အချိန်#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#အင်ဒိုချိုင်းနား အချိန်#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#အလယ်ပိုင်း အင်ဒိုနီးရှား အချိန်#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#အရှေ့ပိုင်း အင်ဒိုနီးရှား အချိန်#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#အနောက်ပိုင်း အင်ဒိုနီးရှား အချိန်#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#အီရန် နွေရာသီ အချိန်#,
				'generic' => q#အီရန် အချိန်#,
				'standard' => q#အီရန် စံတော်ချိန်#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#အီရူခူတ် နွေရာသီ အချိန်#,
				'generic' => q#အီရူခူတ် အချိန်#,
				'standard' => q#အီရူခူတ် စံတော်ချိန်#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#အစ္စရေး နွေရာသီ အချိန်#,
				'generic' => q#အစ္စရေး အချိန်#,
				'standard' => q#အစ္စရေး စံတော်ချိန်#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ဂျပန် နွေရာသီ အချိန်#,
				'generic' => q#ဂျပန် အချိန်#,
				'standard' => q#ဂျပန် စံတော်ချိန်#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#အရှေ့ကာဇက်စတန် အချိန်#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#အနောက်ကာဇက်စတန် အချိန်#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#ကိုရီးယား နွေရာသီ အချိန်#,
				'generic' => q#ကိုရီးယား အချိန်#,
				'standard' => q#ကိုရီးယား စံတော်ချိန်#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#ခိုစ်ရိုင် အချိန်#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ခရာ့စ်နိုရာစ် နွေရာသီ အချိန်#,
				'generic' => q#ခရာ့စ်နိုရာစ် အချိန်#,
				'standard' => q#ခရာ့စ်နိုရာစ် စံတော်ချိန်#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#ကာဂျစ္စတန် အချိန်#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#သီရိလင်္ကာ အချိန်#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#လိုင်းကျွန်းစု အချိန်#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#လော့ဒ်ဟောင် နွေရာသီ အချိန်#,
				'generic' => q#လော့ဒ်ဟောင် အချိန်#,
				'standard' => q#လော့ဒ်ဟောင် စံတော်ချိန်#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#မကာအို နွေရာသီ အချိန်#,
				'generic' => q#မကာအို အချိန်#,
				'standard' => q#မကာအို စံတော်ချိန်#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#မက်ကွယ်ရီကျွန်း အချိန်#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#မာဂါဒန်း နွေရာသီ အချိန်#,
				'generic' => q#မာဂါဒန်း အချိန်#,
				'standard' => q#မာဂါဒန်း စံတော်ချိန်#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#မလေးရှား အချိန်#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#မော်လဒိုက် အချိန်#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#မာခေးအပ်စ် အချိန်#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#မာရှယ်ကျွန်းစု အချိန်#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#မောရစ်ရှ် နွေရာသီ အချိန်#,
				'generic' => q#မောရစ်ရှ် အချိန်#,
				'standard' => q#မောရစ်ရှ် စံတော်ချိန်#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#မော်စွန် အချိန်#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#အနောက်တောင် မက္ကစီကို နွေရာသီ စံတော်ချိန်#,
				'generic' => q#အနောက်တောင် မက္ကဆီကို အချိန်#,
				'standard' => q#အနောက်တောင် မက္ကဆီကို စံတော်ချိန်#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#မက္ကစီကန် ပစိဖိတ် နွေရာသီ စံတော်ချိန်#,
				'generic' => q#မက္ကဆီကန် ပစိဖိတ် အချိန်#,
				'standard' => q#မက္ကဆီကန် ပစိဖိတ် စံတော်ချိန်#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ဥလန်ဘာတော နွေရာသီ အချိန်#,
				'generic' => q#ဥလန်ဘာတော အချိန်#,
				'standard' => q#ဥလန်ဘာတော စံတော်ချိန်#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#မော်စကို နွေရာသီ အချိန်#,
				'generic' => q#မော်စကို အချိန်#,
				'standard' => q#မော်စကို စံတော်ချိန်#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#မြန်မာ အချိန်#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#နာဥူရူ အချိန်#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#နီပေါ အချိန်#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#နယူးကာလီဒိုးနီးယား နွေရာသီ အချိန်#,
				'generic' => q#နယူးကယ်လီဒိုးနီးယား အချိန်#,
				'standard' => q#နယူးကာလီဒိုးနီးယား စံတော်ချိန်#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#နယူးဇီလန် နွေရာသီ အချိန်#,
				'generic' => q#နယူးဇီလန် အချိန်#,
				'standard' => q#နယူးဇီလန် စံတော်ချိန်#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#နယူးဖောင်လန် နွေရာသီ စံတော်ချိန်#,
				'generic' => q#နယူးဖောင်လန် အချိန်#,
				'standard' => q#နယူးဖောင်လန် စံတော်ချိန်#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#နီဦးအေ အချိန်#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#နောဖော့ခ်ကျွန်းအချိန်#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ဖာနန်ဒိုးဒီနိုးရိုးညာ နွေရာသီအချိန်#,
				'generic' => q#ဖာနန်ဒိုးဒီနိုးရိုးညာ အချိန်#,
				'standard' => q#ဖာနန်ဒိုးဒီနိုးရိုးညာ စံတော်ချိန်#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#နိုဗိုစဲဘီအဲယ်စ် နွေရာသီ အချိန်#,
				'generic' => q#နိုဗိုစဲဘီအဲယ်စ် အချိန်#,
				'standard' => q#နိုဗိုစဲဘီအဲယ်စ် စံတော်ချိန်#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#အွမ်းစ်ခ် နွေရာသီ အချိန်#,
				'generic' => q#အွမ်းစ်ခ် အချိန်#,
				'standard' => q#အွမ်းစ်ခ် စံတော်ချိန်#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#အားပီအား#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#အော့ကလန်#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ဘူဂန်ဗီးလီးယား#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ချားသမ်#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#အီစတာ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#အီဖာတီ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#အန်ဒါဘူရီ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ဖာခါအိုဖို#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ဖီဂျီ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ဖူနာဖူတီ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ဂါလာပါကပ်စ်#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ဂမ်ဘီယာ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ဂွါဒါကနဲလ်#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ဂူအမ်#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ဟိုနိုလူလူ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ဂျွန်စတန်#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ခရိဒီမတီ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ခိုစ်ရိုင်#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ခွာဂျာလိန်#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#မာဂျူးရို#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#မာခေးအပ်စ်#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#မစ်ဒ်ဝေး#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#နာဥူရူ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#နီဦးအေ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#နော်ဖော့ခ်#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#နူမယ်အာ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ပါဂိုပါဂို#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ပလာအို#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ပါတ်ကယ်ရင်#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ဖိုနာဖဲအ်#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ဖို့တ် မိုရက်စ်ဘီ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ရာရိုတွန်းဂါ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ဆိုင်ပန်#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#တဟီတီ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#တာရာဝါ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#တွန်ဂါတာပု#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ချုခ်#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ဝိက်ခ်#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ဝေါလီစ်#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#ပါကစ္စတန် နွေရာသီ အချိန်#,
				'generic' => q#ပါကစ္စတန် အချိန်#,
				'standard' => q#ပါကစ္စတန် စံတော်ချိန်#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#ပလာအို အချိန်#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#ပါပူအာနယူးဂီနီ အချိန်#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#ပါရာဂွေး နွေရာသီ အချိန်#,
				'generic' => q#ပါရာဂွေး အချိန်#,
				'standard' => q#ပါရာဂွေး စံတော်ချိန်#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#ပီရူး နွေရာသီ အချိန်#,
				'generic' => q#ပီရူး အချိန်#,
				'standard' => q#ပီရူး စံတော်ချိန်#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ဖိလစ်ပိုင် နွေရာသီ အချိန်#,
				'generic' => q#ဖိလစ်ပိုင် အချိန်#,
				'standard' => q#ဖိလစ်ပိုင် စံတော်ချိန်#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ဖီးနစ်ကျွန်းစု အချိန်#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#စိန့်ပီအဲနှင့် မီခွီလွန် နွေရာသီ စံတော်ချိန်#,
				'generic' => q#စိန့်ပီအဲနှင့်မီခွီလွန်အချိန်#,
				'standard' => q#စိန့်ပီအဲနှင့်မီခွီလွန်စံတော်ချိန်#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#ပါတ်ကယ်ရင် အချိန်#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#ဖိုနာဖဲအ် အချိန်#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#ပြုံယန်း အချိန်#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ရီယူနီယံ အချိန်#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#ရိုသီရာ အချိန်#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ဆာခါလင် နွေရာသီ အချိန်#,
				'generic' => q#ဆာခါလင် အချိန်#,
				'standard' => q#ဆာခါလင် စံတော်ချိန်#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ဆမိုးအား နွေရာသီ အချိန်#,
				'generic' => q#ဆမိုအာ အချိန်#,
				'standard' => q#ဆမိုအာ စံတော်ချိန်#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#ဆေးရှဲ အချိန်#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#စင်္ကာပူ အချိန်#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#ဆော်လမွန်ကျွန်းစု အချိန်#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#တောင်ဂျော်ဂျီယာ အချိန်#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#စူးရီနာမ်အချိန်#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#ရှိုဝါ အချိန်#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#တဟီတီ အချိန်#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ထိုင်ပေ နွေရာသီ အချိန်#,
				'generic' => q#ထိုင်ပေ အချိန်#,
				'standard' => q#ထိုင်ပေ စံတော်ချိန်#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#တာဂျစ်ကစ္စတန် အချိန်#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#တိုကီလာဥ အချိန်#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#တွန်ဂါ နွေရာသီ အချိန်#,
				'generic' => q#တွန်ဂါ အချိန်#,
				'standard' => q#တွန်ဂါ စံတော်ချိန်#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ချုခ် အချိန်#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#တာ့ခ်မင်နစ္စတန် နွေရာသီ အချိန်#,
				'generic' => q#တာ့ခ်မင်နစ္စတန် အချိန်#,
				'standard' => q#တာ့ခ်မင်နစ္စတန် စံတော်ချိန်#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#တူဗားလူ အချိန်#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ဥရုဂွေး နွေရာသီ အချိန်#,
				'generic' => q#ဥရုဂွေး အချိန်#,
				'standard' => q#ဥရုဂွေး စံတော်ချိန်#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ဥဇဘက်ကစ္စတန် နွေရာသီ အချိန်#,
				'generic' => q#ဥဇဘက်ကစ္စတန် အချိန်#,
				'standard' => q#ဥဇဘက်ကစ္စတန် စံတော်ချိန်#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ဗနွားတူ နွေရာသီ အချိန်#,
				'generic' => q#ဗနွားတူ အချိန်#,
				'standard' => q#ဗနွားတူ စံတော်ချိန်#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ဗင်နီဇွဲလား အချိန်#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ဗလာဒီဗော့စတော့ခ် နွေရာသီ အချိန်#,
				'generic' => q#ဗလာဒီဗော့စတော့ခ် အချိန်#,
				'standard' => q#ဗလာဒီဗော့စတော့ခ် စံတော်ချိန်#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ဗိုဂိုဂရက် နွေရာသီ အချိန်#,
				'generic' => q#ဗိုလ်ဂိုဂရက် အချိန်#,
				'standard' => q#ဗိုလ်ဂိုဂရက် စံတော်ချိန်#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ဗိုစ်တိုခ် အချိန်#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ဝိတ်ခ်ကျွန်း အချိန်#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ဝေါလီစ်နှင့် ဖူကျူနာ အချိန်#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ယူခူးတ်စ် နွေရာသီ အချိန်#,
				'generic' => q#ယူခူးတ်စ် အချိန်#,
				'standard' => q#ယူခူးတ်စ် စံတော်ချိန်#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ရယ်ခါးတီရင်ဘာခ် နွေရာသီ အချိန်#,
				'generic' => q#ရယ်ခါးတီရင်ဘားခ် အချိန်#,
				'standard' => q#ရယ်ခါးတီရင်ဘားခ် စံတော်ချိန်#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
