=head1

Locale::CLDR::Locales::Hy - Package for language Armenian

=cut

package Locale::CLDR::Locales::Hy;
# This file auto generated from Data\common\main\hy.xml
#	on Thu 29 Mar  9:03:56 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.32.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(հանած →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(զրո),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← ստորակել →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(մեկ),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(երկու),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(երեք),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(չորս),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(հինգ),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(վեց),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(յոթ),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(ութ),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ինը),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(տասն[­→→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(քսան[­→→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(երեսուն[­→→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(քառասուն[­→→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(հիսուն[­→→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(վաթսուն[­→→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(յոթանասուն[­→→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(ութսուն[­→→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(իննասուն[­→→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←←­հարյուր[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←← հազար[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←← միլիօն[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←← միլիար[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←← բիլիօն[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←← բիլիար[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'աֆարերեն',
 				'ab' => 'աբխազերեն',
 				'ace' => 'աչեհերեն',
 				'ach' => 'աչոլի',
 				'ada' => 'ադանգմերեն',
 				'ady' => 'ադիղերեն',
 				'aeb' => 'թունիսական արաբերեն',
 				'af' => 'աֆրիկաանս',
 				'agq' => 'աղեմ',
 				'ain' => 'այներեն',
 				'ak' => 'աքան',
 				'akk' => 'աքքադերեն',
 				'ale' => 'ալեութերեն',
 				'alt' => 'հարավային ալթայերեն',
 				'am' => 'ամհարերեն',
 				'an' => 'արագոներեն',
 				'ang' => 'հին անգլերեն',
 				'anp' => 'անգիկա',
 				'ar' => 'արաբերեն',
 				'ar_001' => 'արդի ընդհանուր արաբերեն',
 				'arc' => 'արամեերեն',
 				'arn' => 'մապուչի',
 				'arp' => 'արապահո',
 				'arq' => 'ալժիրական արաբերեն',
 				'arz' => 'եգիպտական արաբերեն',
 				'as' => 'ասամերեն',
 				'asa' => 'ասու',
 				'ase' => 'ամերիկյան ժեստերի լեզու',
 				'ast' => 'աստուրերեն',
 				'av' => 'ավարերեն',
 				'awa' => 'ավադհի',
 				'ay' => 'այմարա',
 				'az' => 'ադրբեջաներեն',
 				'az@alt=short' => 'ադրբեջաներեն',
 				'ba' => 'բաշկիրերեն',
 				'ban' => 'բալիերեն',
 				'bas' => 'բասաա',
 				'be' => 'բելառուսերեն',
 				'bem' => 'բեմբա',
 				'bez' => 'բենա',
 				'bg' => 'բուլղարերեն',
 				'bgn' => 'արևմտաբելուջիերեն',
 				'bho' => 'բհոպուրի',
 				'bi' => 'բիսլամա',
 				'bin' => 'բինի',
 				'bla' => 'սիկսիկա',
 				'bm' => 'բամբարա',
 				'bn' => 'բենգալերեն',
 				'bo' => 'տիբեթերեն',
 				'br' => 'բրետոներեն',
 				'brx' => 'բոդո',
 				'bs' => 'բոսնիերեն',
 				'bss' => 'աքուզ',
 				'bug' => 'բուգիերեն',
 				'byn' => 'բիլին',
 				'ca' => 'կատալաներեն',
 				'ce' => 'չեչեներեն',
 				'ceb' => 'սեբուերեն',
 				'cgg' => 'չիգա',
 				'ch' => 'չամոռո',
 				'chk' => 'տրուկերեն',
 				'chm' => 'մարի',
 				'cho' => 'չոկտո',
 				'chr' => 'չերոկի',
 				'chy' => 'շայեն',
 				'ckb' => 'սորանի քրդերեն',
 				'co' => 'կորսիկերեն',
 				'cop' => 'ղպտերեն',
 				'crh' => 'ղրիմյան թուրքերեն',
 				'crs' => 'սեյշելյան խառնակերտ ֆրանսերեն',
 				'cs' => 'չեխերեն',
 				'cu' => 'եկեղեցական սլավոներեն',
 				'cv' => 'չուվաշերեն',
 				'cy' => 'ուելսերեն',
 				'da' => 'դանիերեն',
 				'dak' => 'դակոտա',
 				'dar' => 'դարգիներեն',
 				'dav' => 'թաիթա',
 				'de' => 'գերմաներեն',
 				'de_AT' => 'ավստրիական գերմաներեն',
 				'de_CH' => 'շվեյցարական վերին գերմաներեն',
 				'dgr' => 'դոգրիբ',
 				'dje' => 'զարմա',
 				'dsb' => 'ստորին սորբերեն',
 				'dua' => 'դուալա',
 				'dv' => 'մալդիվերեն',
 				'dyo' => 'ջոլա-ֆոնյի',
 				'dz' => 'ջոնգքհա',
 				'dzg' => 'դազագա',
 				'ebu' => 'էմբու',
 				'ee' => 'էվե',
 				'efi' => 'էֆիկ',
 				'egy' => 'հին եգիպտերեն',
 				'eka' => 'էկաջուկ',
 				'el' => 'հունարեն',
 				'en' => 'անգլերեն',
 				'en_AU' => 'ավստրալիական անգլերեն',
 				'en_CA' => 'կանադական անգլերեն',
 				'en_GB' => 'բրիտանական անգլերեն',
 				'en_GB@alt=short' => 'անգլերեն (Բրիտանիա)',
 				'en_US' => 'ամերիկյան անգլերեն',
 				'en_US@alt=short' => 'անգլերեն (ԱՄՆ)',
 				'eo' => 'էսպերանտո',
 				'es' => 'իսպաներեն',
 				'es_419' => 'լատինամերիկյան իսպաներեն',
 				'es_ES' => 'եվրոպական իսպաներեն',
 				'es_MX' => 'մեքսիկական իսպաներեն',
 				'et' => 'էստոներեն',
 				'eu' => 'բասկերեն',
 				'ewo' => 'էվոնդո',
 				'fa' => 'պարսկերեն',
 				'ff' => 'ֆուլահ',
 				'fi' => 'ֆիններեն',
 				'fil' => 'ֆիլիպիներեն',
 				'fit' => 'տորնադելեն ֆիններեն',
 				'fj' => 'ֆիջիերեն',
 				'fo' => 'ֆարյորերեն',
 				'fon' => 'ֆոն',
 				'fr' => 'ֆրանսերեն',
 				'fr_CA' => 'կանադական ֆրանսերեն',
 				'fr_CH' => 'շվեյցարական ֆրանսերեն',
 				'fro' => 'հին ֆրանսերեն',
 				'frs' => 'արևելաֆրիզերեն',
 				'fur' => 'ֆրիուլիերեն',
 				'fy' => 'արևմտաֆրիզերեն',
 				'ga' => 'իռլանդերեն',
 				'gaa' => 'գայերեն',
 				'gag' => 'գագաուզերեն',
 				'gbz' => 'զրադաշտական դարի',
 				'gd' => 'շոտլանդական գաելերեն',
 				'gez' => 'գեեզ',
 				'gil' => 'կիրիբատի',
 				'gl' => 'գալիսերեն',
 				'gn' => 'գուարանի',
 				'goh' => 'հին վերին գերմաներեն',
 				'gor' => 'գորոնտալո',
 				'got' => 'գոթերեն',
 				'grc' => 'հին հունարեն',
 				'gsw' => 'շվեյցարական գերմաներեն',
 				'gu' => 'գուջարաթի',
 				'guc' => 'վայուու',
 				'guz' => 'գուսի',
 				'gv' => 'մեներեն',
 				'gwi' => 'գվիչին',
 				'ha' => 'հաուսա',
 				'haw' => 'հավայիերեն',
 				'he' => 'եբրայերեն',
 				'hi' => 'հինդի',
 				'hil' => 'հիլիգայնոն',
 				'hmn' => 'հմոնգ',
 				'hr' => 'խորվաթերեն',
 				'hsb' => 'վերին սորբերեն',
 				'hsn' => 'սյան չինարեն',
 				'ht' => 'խառնակերտ հայիթերեն',
 				'hu' => 'հունգարերեն',
 				'hup' => 'հուպա',
 				'hy' => 'հայերեն',
 				'hz' => 'հերերո',
 				'ia' => 'ինտերլինգուա',
 				'iba' => 'իբաներեն',
 				'ibb' => 'իբիբիո',
 				'id' => 'ինդոնեզերեն',
 				'ie' => 'ինտերլինգուե',
 				'ig' => 'իգբո',
 				'ii' => 'սիչուան',
 				'ilo' => 'իլոկերեն',
 				'inh' => 'ինգուշերեն',
 				'io' => 'իդո',
 				'is' => 'իսլանդերեն',
 				'it' => 'իտալերեն',
 				'iu' => 'ինուկտիտուտ',
 				'ja' => 'ճապոներեն',
 				'jbo' => 'լոժբան',
 				'jgo' => 'նգոմբա',
 				'jmc' => 'մաշամե',
 				'jv' => 'ճավայերեն',
 				'ka' => 'վրացերեն',
 				'kab' => 'կաբիլերեն',
 				'kac' => 'կաչիներեն',
 				'kaj' => 'ջյու',
 				'kam' => 'կամբա',
 				'kbd' => 'կաբարդերեն',
 				'kcg' => 'տիապ',
 				'kde' => 'մակոնդե',
 				'kea' => 'կաբուվերդերեն',
 				'kfo' => 'կորո',
 				'kha' => 'քասիերեն',
 				'khq' => 'կոյրա չինի',
 				'ki' => 'կիկույու',
 				'kj' => 'կուանյամա',
 				'kk' => 'ղազախերեն',
 				'kkj' => 'կակո',
 				'kl' => 'կալաալիսուտ',
 				'kln' => 'կալենջին',
 				'km' => 'քմերերեն',
 				'kmb' => 'կիմբունդու',
 				'kn' => 'կաննադա',
 				'ko' => 'կորեերեն',
 				'koi' => 'պերմյակ կոմիերեն',
 				'kok' => 'կոնկանի',
 				'kpe' => 'կպելլեերեն',
 				'kr' => 'կանուրի',
 				'krc' => 'կարաչայ-բալկարերեն',
 				'krl' => 'կարելերեն',
 				'kru' => 'կուրուխ',
 				'ks' => 'քաշմիրերեն',
 				'ksb' => 'շամբալա',
 				'ksf' => 'բաֆիա',
 				'ksh' => 'քյոլներեն',
 				'ku' => 'քրդերեն',
 				'kum' => 'կումիկերեն',
 				'kv' => 'կոմիերեն',
 				'kw' => 'կոռներեն',
 				'ky' => 'ղրղզերեն',
 				'la' => 'լատիներեն',
 				'lad' => 'լադինո',
 				'lag' => 'լանգի',
 				'lb' => 'լյուքսեմբուրգերեն',
 				'lez' => 'լեզգիերեն',
 				'lg' => 'գանդա',
 				'li' => 'լիմբուրգերեն',
 				'lkt' => 'լակոտա',
 				'ln' => 'լինգալա',
 				'lo' => 'լաոսերեն',
 				'loz' => 'լոզի',
 				'lrc' => 'հյուսիսային լուրիերեն',
 				'lt' => 'լիտվերեն',
 				'lu' => 'լուբա-կատանգա',
 				'lua' => 'լուբա-լուլուա',
 				'lun' => 'լունդա',
 				'luo' => 'լուո',
 				'lus' => 'միզո',
 				'luy' => 'լույա',
 				'lv' => 'լատվիերեն',
 				'mad' => 'մադուրերեն',
 				'mag' => 'մագահի',
 				'mai' => 'մայթիլի',
 				'mak' => 'մակասարերեն',
 				'mas' => 'մասաի',
 				'mdf' => 'մոկշայերեն',
 				'men' => 'մենդե',
 				'mer' => 'մերու',
 				'mfe' => 'մորիսյեն',
 				'mg' => 'մալգաշերեն',
 				'mgh' => 'մաքուա-մետտո',
 				'mgo' => 'մետա',
 				'mh' => 'մարշալերեն',
 				'mi' => 'մաորի',
 				'mic' => 'միկմակ',
 				'min' => 'մինանգկաբաու',
 				'mk' => 'մակեդոներեն',
 				'ml' => 'մալայալամ',
 				'mn' => 'մոնղոլերեն',
 				'mni' => 'մանիպուրի',
 				'moh' => 'մոհավք',
 				'mos' => 'մոսսի',
 				'mr' => 'մարաթի',
 				'mrj' => 'արևմտամարիերեն',
 				'ms' => 'մալայերեն',
 				'mt' => 'մալթայերեն',
 				'mua' => 'մունդանգ',
 				'mul' => 'բազմալեզու',
 				'mus' => 'կրիկ',
 				'mwl' => 'միրանդերեն',
 				'my' => 'բիրմայերեն',
 				'myv' => 'էրզյա',
 				'mzn' => 'մազանդարաներեն',
 				'na' => 'նաուրու',
 				'nap' => 'նեապոլերեն',
 				'naq' => 'նամա',
 				'nb' => 'գրքային նորվեգերեն',
 				'nd' => 'հյուսիսային նդեբելե',
 				'nds_NL' => 'ստորին սաքսոներեն',
 				'ne' => 'նեպալերեն',
 				'new' => 'նեվարերեն',
 				'ng' => 'նդոնգա',
 				'nia' => 'նիասերեն',
 				'niu' => 'նիուերեն',
 				'nl' => 'հոլանդերեն',
 				'nl_BE' => 'ֆլամանդերեն',
 				'nmg' => 'կվասիո',
 				'nn' => 'նոր նորվեգերեն',
 				'nnh' => 'նգիեմբուն',
 				'no' => 'նորվեգերեն',
 				'nog' => 'նոգայերեն',
 				'non' => 'հին նորվեգերեն',
 				'nqo' => 'նկո',
 				'nr' => 'հարավային նդեբելե',
 				'nso' => 'հյուսիսային սոթո',
 				'nus' => 'նուեր',
 				'nv' => 'նավախո',
 				'ny' => 'նյանջա',
 				'nyn' => 'նյանկոլե',
 				'oc' => 'օքսիտաներեն',
 				'oj' => 'օջիբվա',
 				'om' => 'օրոմո',
 				'or' => 'օրիյա',
 				'os' => 'օսերեն',
 				'osa' => 'օսեյջ',
 				'ota' => 'օսմաներեն',
 				'pa' => 'փենջաբերեն',
 				'pag' => 'պանգասինաներեն',
 				'pal' => 'պահլավերեն',
 				'pam' => 'պամպանգաերեն',
 				'pap' => 'պապյամենտո',
 				'pau' => 'պալաուերեն',
 				'pcd' => 'պիկարդերեն',
 				'pcm' => 'նիգերյան կրեոլերեն',
 				'pdc' => 'փենսիլվանական գերմաներեն',
 				'pdt' => 'պլատագերմաներեն',
 				'peo' => 'հին պարսկերեն',
 				'pfl' => 'պալատինյան գերմաներեն',
 				'phn' => 'փյունիկերեն',
 				'pi' => 'պալի',
 				'pl' => 'լեհերեն',
 				'pms' => 'պիեմոնտերեն',
 				'pnt' => 'պոնտերեն',
 				'pon' => 'պոնպեերեն',
 				'prg' => 'պրուսերեն',
 				'pro' => 'հին պրովանսերեն',
 				'ps' => 'փուշթու',
 				'pt' => 'պորտուգալերեն',
 				'pt_BR' => 'բրազիլական պորտուգալերեն',
 				'pt_PT' => 'եվրոպական պորտուգալերեն',
 				'qu' => 'կեչուա',
 				'quc' => 'քիչե',
 				'raj' => 'ռաջաստաներեն',
 				'rap' => 'ռապանուի',
 				'rar' => 'ռարոտոնգաներեն',
 				'rgn' => 'ռոմանիոլերեն',
 				'rif' => 'ռիֆերեն',
 				'rm' => 'ռոմանշերեն',
 				'rn' => 'ռունդի',
 				'ro' => 'ռումիներեն',
 				'ro_MD' => 'մոլդովերեն',
 				'rof' => 'ռոմբո',
 				'rom' => 'ռոմաներեն',
 				'root' => 'ռուտերեն',
 				'rtm' => 'ռոտուման',
 				'ru' => 'ռուսերեն',
 				'rue' => 'ռուսիներեն',
 				'rug' => 'ռովիանա',
 				'rup' => 'արոմաներեն',
 				'rw' => 'կինյառուանդա',
 				'rwk' => 'ռվա',
 				'sa' => 'սանսկրիտ',
 				'sad' => 'սանդավե',
 				'sah' => 'յակուտերեն',
 				'saq' => 'սամբուրու',
 				'sat' => 'սանտալի',
 				'sba' => 'նգամբայ',
 				'sbp' => 'սանգու',
 				'sc' => 'սարդիներեն',
 				'scn' => 'սիցիլիերեն',
 				'sco' => 'շոտլանդերեն',
 				'sd' => 'սինդհի',
 				'sdh' => 'հարավային քրդերեն',
 				'se' => 'հյուսիսային սաամի',
 				'seh' => 'սենա',
 				'ses' => 'կոյրաբորո սեննի',
 				'sg' => 'սանգո',
 				'sga' => 'հին իռլանդերեն',
 				'sh' => 'սերբա-խորվաթերեն',
 				'shi' => 'տաշելհիթ',
 				'shn' => 'շաներեն',
 				'si' => 'սինհալերեն',
 				'sk' => 'սլովակերեն',
 				'sl' => 'սլովեներեն',
 				'sm' => 'սամոաերեն',
 				'sma' => 'հարավային սաամի',
 				'smj' => 'լուլե սաամի',
 				'smn' => 'ինարի սաամի',
 				'sms' => 'սկոլտ սաամի',
 				'sn' => 'շոնա',
 				'snk' => 'սոնինկե',
 				'so' => 'սոմալիերեն',
 				'sq' => 'ալբաներեն',
 				'sr' => 'սերբերեն',
 				'srn' => 'սրանան տոնգո',
 				'ss' => 'սվազերեն',
 				'ssy' => 'սահոերեն',
 				'st' => 'հարավային սոթո',
 				'su' => 'սունդաներեն',
 				'suk' => 'սուկումա',
 				'sv' => 'շվեդերեն',
 				'sw' => 'սուահիլի',
 				'sw_CD' => 'կոնգոյի սուահիլի',
 				'swb' => 'կոմորերեն',
 				'syr' => 'ասորերեն',
 				'ta' => 'թամիլերեն',
 				'tcy' => 'տուլու',
 				'te' => 'թելուգու',
 				'tem' => 'տեմնե',
 				'teo' => 'տեսո',
 				'ter' => 'տերենո',
 				'tet' => 'տետում',
 				'tg' => 'տաջիկերեն',
 				'th' => 'թայերեն',
 				'ti' => 'տիգրինյա',
 				'tig' => 'տիգրե',
 				'tiv' => 'տիվերեն',
 				'tk' => 'թուրքմեներեն',
 				'tkl' => 'տոկելաու',
 				'tkr' => 'ցախուր',
 				'tl' => 'տագալերեն',
 				'tlh' => 'կլինգոն',
 				'tli' => 'տլինգիտ',
 				'tly' => 'թալիշերեն',
 				'tmh' => 'տամաշեկ',
 				'tn' => 'ցվանա',
 				'to' => 'տոնգերեն',
 				'tpi' => 'տոկ փիսին',
 				'tr' => 'թուրքերեն',
 				'tru' => 'տուրոյո',
 				'trv' => 'տարոկո',
 				'ts' => 'ցոնգա',
 				'tsd' => 'ցակոներեն',
 				'tsi' => 'ցիմշյան',
 				'tt' => 'թաթարերեն',
 				'tum' => 'տումբուկա',
 				'tvl' => 'թուվալուերեն',
 				'tw' => 'տուի',
 				'twq' => 'տասավաք',
 				'ty' => 'թաիտերեն',
 				'tyv' => 'տուվերեն',
 				'tzm' => 'կենտրոնատլասյան թամազիղտ',
 				'udm' => 'ուդմուրտերեն',
 				'ug' => 'ույղուրերեն',
 				'uga' => 'ուգարիտերեն',
 				'uk' => 'ուկրաիներեն',
 				'umb' => 'ումբունդու',
 				'und' => 'անհայտ լեզու',
 				'ur' => 'ուրդու',
 				'uz' => 'ուզբեկերեն',
 				'vai' => 'վաի',
 				've' => 'վենդա',
 				'vec' => 'վենետերեն',
 				'vep' => 'վեպսերեն',
 				'vi' => 'վիետնամերեն',
 				'vls' => 'արևմտաֆլամանդերեն',
 				'vo' => 'վոլապյուկ',
 				'vot' => 'վոդերեն',
 				'vro' => 'վորո',
 				'vun' => 'վունջո',
 				'wa' => 'վալոներեն',
 				'wae' => 'վալսերեն',
 				'wal' => 'վոլայտա',
 				'war' => 'վարայերեն',
 				'was' => 'վաշո',
 				'wbp' => 'վարլպիրի',
 				'wo' => 'վոլոֆ',
 				'wuu' => 'վու չինարեն',
 				'xal' => 'կալմիկերեն',
 				'xh' => 'քոսա',
 				'xog' => 'սոգա',
 				'yao' => 'յաո',
 				'yap' => 'յափերեն',
 				'yav' => 'յանգբեն',
 				'ybb' => 'եմբա',
 				'yi' => 'իդիշ',
 				'yo' => 'յորուբա',
 				'yue' => 'կանտոներեն',
 				'za' => 'ժուանգ',
 				'zap' => 'սապոտեկերեն',
 				'zea' => 'զեյլանդերեն',
 				'zen' => 'զենագա',
 				'zgh' => 'ընդհանուր մարոկյան թամազիղտ',
 				'zh' => 'չինարեն',
 				'zh_Hans' => 'պարզեցված չինարեն',
 				'zh_Hant' => 'ավանդական չինարեն',
 				'zu' => 'զուլուերեն',
 				'zun' => 'զունիերեն',
 				'zxx' => 'առանց լեզվային բովանդակության',
 				'zza' => 'զազաերեն',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'արաբական',
 			'Armn' => 'հայկական',
 			'Beng' => 'բենգալական',
 			'Bopo' => 'բոպոմոֆո',
 			'Brai' => 'բրայլի',
 			'Cyrl' => 'կյուրեղագիր',
 			'Deva' => 'դեւանագարի',
 			'Ethi' => 'եթովպական',
 			'Geor' => 'վրացական',
 			'Grek' => 'հունական',
 			'Gujr' => 'գուջարաթի',
 			'Guru' => 'գուրմուխի',
 			'Hanb' => 'հանբ',
 			'Hang' => 'հանգըլ',
 			'Hani' => 'չինական',
 			'Hans' => 'պարզեցված չինական',
 			'Hans@alt=stand-alone' => 'պարզեցված չինական',
 			'Hant' => 'ավանդական չինական',
 			'Hant@alt=stand-alone' => 'ավանդական չինական',
 			'Hebr' => 'եբրայական',
 			'Hira' => 'հիրագանա',
 			'Hrkt' => 'ճապոնական վանկագիր',
 			'Jamo' => 'ջամո',
 			'Jpan' => 'ճապոնական',
 			'Kana' => 'կատականա',
 			'Khmr' => 'քմերական',
 			'Knda' => 'կաննադա',
 			'Kore' => 'կորեական',
 			'Laoo' => 'լաոսական',
 			'Latn' => 'լատինական',
 			'Mlym' => 'մալայալամ',
 			'Mong' => 'մոնղոլական',
 			'Mymr' => 'մյանմարական',
 			'Orya' => 'օրիյա',
 			'Sinh' => 'սինհալական',
 			'Taml' => 'թամիլական',
 			'Telu' => 'թելուգու',
 			'Thaa' => 'թաանա',
 			'Thai' => 'թայական',
 			'Tibt' => 'տիբեթական',
 			'Zmth' => 'մաթեմատիկական նշաններ',
 			'Zsye' => 'էմոձի',
 			'Zsym' => 'նշաններ',
 			'Zxxx' => 'չգրված',
 			'Zyyy' => 'ընդհանուր',
 			'Zzzz' => 'անհայտ գիր',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Աշխարհ',
 			'002' => 'Աֆրիկա',
 			'003' => 'Հյուսիսային Ամերիկա',
 			'005' => 'Հարավային Ամերիկա',
 			'009' => 'Օվկիանիա',
 			'011' => 'Արևմտյան Աֆրիկա',
 			'013' => 'Կենտրոնական Ամերիկա',
 			'014' => 'Արևելյան Աֆրիկա',
 			'015' => 'Հյուսիսային Աֆրիկա',
 			'017' => 'Կենտրոնական Աֆրիկա',
 			'018' => 'Հարավային Աֆրիկա',
 			'019' => 'Ամերիկա',
 			'021' => 'Հյուսիսային Ամերիկա - ԱՄՆ և Կանադա',
 			'029' => 'Կարիբներ',
 			'030' => 'Արևելյան Ասիա',
 			'034' => 'Հարավային Ասիա',
 			'035' => 'Հարավարևելյան Ասիա',
 			'039' => 'Հարավային Եվրոպա',
 			'053' => 'Ավստրալասիա',
 			'054' => 'Մելանեզիա',
 			'057' => 'Միկրոնեզյան տարածաշրջան',
 			'061' => 'Պոլինեզիա',
 			'142' => 'Ասիա',
 			'143' => 'Կենտրոնական Ասիա',
 			'145' => 'Արևմտյան Ասիա',
 			'150' => 'Եվրոպա',
 			'151' => 'Արևելյան Եվրոպա',
 			'154' => 'Հյուսիսային Եվրոպա',
 			'155' => 'Արևմտյան Եվրոպա',
 			'419' => 'Լատինական Ամերիկա',
 			'AC' => 'Համբարձման կղզի',
 			'AD' => 'Անդորրա',
 			'AE' => 'Արաբական Միացյալ Էմիրություններ',
 			'AF' => 'Աֆղանստան',
 			'AG' => 'Անտիգուա և Բարբուդա',
 			'AI' => 'Անգուիլա',
 			'AL' => 'Ալբանիա',
 			'AM' => 'Հայաստան',
 			'AO' => 'Անգոլա',
 			'AQ' => 'Անտարկտիդա',
 			'AR' => 'Արգենտինա',
 			'AS' => 'Ամերիկյան Սամոա',
 			'AT' => 'Ավստրիա',
 			'AU' => 'Ավստրալիա',
 			'AW' => 'Արուբա',
 			'AX' => 'Ալանդյան կղզիներ',
 			'AZ' => 'Ադրբեջան',
 			'BA' => 'Բոսնիա և Հերցեգովինա',
 			'BB' => 'Բարբադոս',
 			'BD' => 'Բանգլադեշ',
 			'BE' => 'Բելգիա',
 			'BF' => 'Բուրկինա Ֆասո',
 			'BG' => 'Բուլղարիա',
 			'BH' => 'Բահրեյն',
 			'BI' => 'Բուրունդի',
 			'BJ' => 'Բենին',
 			'BL' => 'Սուրբ Բարդուղիմեոս',
 			'BM' => 'Բերմուդներ',
 			'BN' => 'Բրունեյ',
 			'BO' => 'Բոլիվիա',
 			'BQ' => 'Կարիբյան Նիդեռլանդներ',
 			'BR' => 'Բրազիլիա',
 			'BS' => 'Բահամաներ',
 			'BT' => 'Բութան',
 			'BV' => 'Բուվե կղզի',
 			'BW' => 'Բոթսվանա',
 			'BY' => 'Բելառուս',
 			'BZ' => 'Բելիզ',
 			'CA' => 'Կանադա',
 			'CC' => 'Կոկոսյան (Քիլինգ) կղզիներ',
 			'CD' => 'Կոնգո - Կինշասա',
 			'CD@alt=variant' => 'Կոնգո (ԿԺՀ)',
 			'CF' => 'Կենտրոնական Աֆրիկյան Հանրապետություն',
 			'CG' => 'Կոնգո - Բրազավիլ',
 			'CG@alt=variant' => 'Կոնգո (Կոնգոյի Հանրապետություն)',
 			'CH' => 'Շվեյցարիա',
 			'CI' => 'Կոտ դ’Իվուար',
 			'CI@alt=variant' => 'Փղոսկրի Ափ',
 			'CK' => 'Կուկի կղզիներ',
 			'CL' => 'Չիլի',
 			'CM' => 'Կամերուն',
 			'CN' => 'Չինաստան',
 			'CO' => 'Կոլումբիա',
 			'CP' => 'Քլիփերթոն կղզի',
 			'CR' => 'Կոստա Ռիկա',
 			'CU' => 'Կուբա',
 			'CV' => 'Կաբո Վերդե',
 			'CW' => 'Կյուրասաո',
 			'CX' => 'Սուրբ Ծննդյան կղզի',
 			'CY' => 'Կիպրոս',
 			'CZ' => 'Չեխիա',
 			'CZ@alt=variant' => 'Չեխիայի Հանրապետություն',
 			'DE' => 'Գերմանիա',
 			'DG' => 'Դիեգո Գարսիա',
 			'DJ' => 'Ջիբութի',
 			'DK' => 'Դանիա',
 			'DM' => 'Դոմինիկա',
 			'DO' => 'Դոմինիկյան Հանրապետություն',
 			'DZ' => 'Ալժիր',
 			'EA' => 'Սեուտա և Մելիլյա',
 			'EC' => 'Էկվադոր',
 			'EE' => 'Էստոնիա',
 			'EG' => 'Եգիպտոս',
 			'EH' => 'Արևմտյան Սահարա',
 			'ER' => 'Էրիթրեա',
 			'ES' => 'Իսպանիա',
 			'ET' => 'Եթովպիա',
 			'EU' => 'Եվրոպական Միություն',
 			'EZ' => 'Եվրագոտի',
 			'FI' => 'Ֆինլանդիա',
 			'FJ' => 'Ֆիջի',
 			'FK' => 'Ֆոլքլենդյան կղզիներ',
 			'FK@alt=variant' => 'Ֆոլքլենդյան (Մալվինյան) կղզիներ',
 			'FM' => 'Միկրոնեզիա',
 			'FO' => 'Ֆարերյան կղզիներ',
 			'FR' => 'Ֆրանսիա',
 			'GA' => 'Գաբոն',
 			'GB' => 'Միացյալ Թագավորություն',
 			'GB@alt=short' => 'ՄԹ',
 			'GD' => 'Գրենադա',
 			'GE' => 'Վրաստան',
 			'GF' => 'Ֆրանսիական Գվիանա',
 			'GG' => 'Գերնսի',
 			'GH' => 'Գանա',
 			'GI' => 'Ջիբրալթար',
 			'GL' => 'Գրենլանդիա',
 			'GM' => 'Գամբիա',
 			'GN' => 'Գվինեա',
 			'GP' => 'Գվադելուպա',
 			'GQ' => 'Հասարակածային Գվինեա',
 			'GR' => 'Հունաստան',
 			'GS' => 'Հարավային Ջորջիա և Հարավային Սենդվիչյան կղզիներ',
 			'GT' => 'Գվատեմալա',
 			'GU' => 'Գուամ',
 			'GW' => 'Գվինեա-Բիսաու',
 			'GY' => 'Գայանա',
 			'HK' => 'Հոնկոնգի ՀՎՇ',
 			'HK@alt=short' => 'Հոնկոնգ',
 			'HM' => 'Հերդ կղզի և ՄակԴոնալդի կղզիներ',
 			'HN' => 'Հոնդուրաս',
 			'HR' => 'Խորվաթիա',
 			'HT' => 'Հայիթի',
 			'HU' => 'Հունգարիա',
 			'IC' => 'Կանարյան կղզիներ',
 			'ID' => 'Ինդոնեզիա',
 			'IE' => 'Իռլանդիա',
 			'IL' => 'Իսրայել',
 			'IM' => 'Մեն կղզի',
 			'IN' => 'Հնդկաստան',
 			'IO' => 'Բրիտանական Տարածք Հնդկական Օվկիանոսում',
 			'IQ' => 'Իրաք',
 			'IR' => 'Իրան',
 			'IS' => 'Իսլանդիա',
 			'IT' => 'Իտալիա',
 			'JE' => 'Ջերսի',
 			'JM' => 'Ճամայկա',
 			'JO' => 'Հորդանան',
 			'JP' => 'Ճապոնիա',
 			'KE' => 'Քենիա',
 			'KG' => 'Ղրղզստան',
 			'KH' => 'Կամբոջա',
 			'KI' => 'Կիրիբատի',
 			'KM' => 'Կոմորյան կղզիներ',
 			'KN' => 'Սենթ Քիտս և Նևիս',
 			'KP' => 'Հյուսիսային Կորեա',
 			'KR' => 'Հարավային Կորեա',
 			'KW' => 'Քուվեյթ',
 			'KY' => 'Կայման կղզիներ',
 			'KZ' => 'Ղազախստան',
 			'LA' => 'Լաոս',
 			'LB' => 'Լիբանան',
 			'LC' => 'Սենթ Լյուսիա',
 			'LI' => 'Լիխտենշտեյն',
 			'LK' => 'Շրի Լանկա',
 			'LR' => 'Լիբերիա',
 			'LS' => 'Լեսոտո',
 			'LT' => 'Լիտվա',
 			'LU' => 'Լյուքսեմբուրգ',
 			'LV' => 'Լատվիա',
 			'LY' => 'Լիբիա',
 			'MA' => 'Մարոկկո',
 			'MC' => 'Մոնակո',
 			'MD' => 'Մոլդովա',
 			'ME' => 'Չեռնոգորիա',
 			'MF' => 'Սեն Մարտեն',
 			'MG' => 'Մադագասկար',
 			'MH' => 'Մարշալյան կղզիներ',
 			'MK' => 'Մակեդոնիա',
 			'MK@alt=variant' => 'Մակեդոնիա (ՄՆՀՀ)',
 			'ML' => 'Մալի',
 			'MM' => 'Մյանմա (Բիրմա)',
 			'MN' => 'Մոնղոլիա',
 			'MO' => 'Չինաստանի Մակաո ՀՎՇ',
 			'MO@alt=short' => 'Մակաո',
 			'MP' => 'Հյուսիսային Մարիանյան կղզիներ',
 			'MQ' => 'Մարտինիկա',
 			'MR' => 'Մավրիտանիա',
 			'MS' => 'Մոնսեռատ',
 			'MT' => 'Մալթա',
 			'MU' => 'Մավրիկիոս',
 			'MV' => 'Մալդիվներ',
 			'MW' => 'Մալավի',
 			'MX' => 'Մեքսիկա',
 			'MY' => 'Մալայզիա',
 			'MZ' => 'Մոզամբիկ',
 			'NA' => 'Նամիբիա',
 			'NC' => 'Նոր Կալեդոնիա',
 			'NE' => 'Նիգեր',
 			'NF' => 'Նորֆոլկ կղզի',
 			'NG' => 'Նիգերիա',
 			'NI' => 'Նիկարագուա',
 			'NL' => 'Նիդեռլանդներ',
 			'NO' => 'Նորվեգիա',
 			'NP' => 'Նեպալ',
 			'NR' => 'Նաուրու',
 			'NU' => 'Նիուե',
 			'NZ' => 'Նոր Զելանդիա',
 			'OM' => 'Օման',
 			'PA' => 'Պանամա',
 			'PE' => 'Պերու',
 			'PF' => 'Ֆրանսիական Պոլինեզիա',
 			'PG' => 'Պապուա Նոր Գվինեա',
 			'PH' => 'Ֆիլիպիններ',
 			'PK' => 'Պակիստան',
 			'PL' => 'Լեհաստան',
 			'PM' => 'Սեն Պիեռ և Միքելոն',
 			'PN' => 'Պիտկեռն կղզիներ',
 			'PR' => 'Պուերտո Ռիկո',
 			'PS' => 'Պաղեստինյան տարածքներ',
 			'PS@alt=short' => 'Պաղեստին',
 			'PT' => 'Պորտուգալիա',
 			'PW' => 'Պալաու',
 			'PY' => 'Պարագվայ',
 			'QA' => 'Կատար',
 			'QO' => 'Արտաքին Օվկիանիա',
 			'RE' => 'Ռեյունիոն',
 			'RO' => 'Ռումինիա',
 			'RS' => 'Սերբիա',
 			'RU' => 'Ռուսաստան',
 			'RW' => 'Ռուանդա',
 			'SA' => 'Սաուդյան Արաբիա',
 			'SB' => 'Սողոմոնյան կղզիներ',
 			'SC' => 'Սեյշելներ',
 			'SD' => 'Սուդան',
 			'SE' => 'Շվեդիա',
 			'SG' => 'Սինգապուր',
 			'SH' => 'Սուրբ Հեղինեի կղզի',
 			'SI' => 'Սլովենիա',
 			'SJ' => 'Սվալբարդ և Յան Մայեն',
 			'SK' => 'Սլովակիա',
 			'SL' => 'Սիեռա Լեոնե',
 			'SM' => 'Սան Մարինո',
 			'SN' => 'Սենեգալ',
 			'SO' => 'Սոմալի',
 			'SR' => 'Սուրինամ',
 			'SS' => 'Հարավային Սուդան',
 			'ST' => 'Սան Տոմե և Փրինսիպի',
 			'SV' => 'Սալվադոր',
 			'SX' => 'Սինտ Մարտեն',
 			'SY' => 'Սիրիա',
 			'SZ' => 'Սվազիլենդ',
 			'TA' => 'Տրիստան դա Կունյա',
 			'TC' => 'Թըրքս և Կայկոս կղզիներ',
 			'TD' => 'Չադ',
 			'TF' => 'Ֆրանսիական Հարավային Տարածքներ',
 			'TG' => 'Տոգո',
 			'TH' => 'Թայլանդ',
 			'TJ' => 'Տաջիկստան',
 			'TK' => 'Տոկելաու',
 			'TL' => 'Թիմոր Լեշտի',
 			'TL@alt=variant' => 'Արևելյան Թիմոր',
 			'TM' => 'Թուրքմենստան',
 			'TN' => 'Թունիս',
 			'TO' => 'Տոնգա',
 			'TR' => 'Թուրքիա',
 			'TT' => 'Տրինիդադ և Տոբագո',
 			'TV' => 'Տուվալու',
 			'TW' => 'Թայվան',
 			'TZ' => 'Տանզանիա',
 			'UA' => 'Ուկրաինա',
 			'UG' => 'Ուգանդա',
 			'UM' => 'Արտաքին կղզիներ (ԱՄՆ)',
 			'UN' => 'Միավորված ազգերի կազմակերպություն',
 			'UN@alt=short' => 'ՄԱԿ',
 			'US' => 'Միացյալ Նահանգներ',
 			'US@alt=short' => 'ԱՄՆ',
 			'UY' => 'Ուրուգվայ',
 			'UZ' => 'Ուզբեկստան',
 			'VA' => 'Վատիկան',
 			'VC' => 'Սենթ Վինսենթ և Գրենադիններ',
 			'VE' => 'Վենեսուելա',
 			'VG' => 'Բրիտանական Վիրջինյան կղզիներ',
 			'VI' => 'ԱՄՆ Վիրջինյան կղզիներ',
 			'VN' => 'Վիետնամ',
 			'VU' => 'Վանուատու',
 			'WF' => 'Ուոլիս և Ֆուտունա',
 			'WS' => 'Սամոա',
 			'XK' => 'Կոսովո',
 			'YE' => 'Եմեն',
 			'YT' => 'Մայոտ',
 			'ZA' => 'Հարավաֆրիկյան Հանրապետություն',
 			'ZM' => 'Զամբիա',
 			'ZW' => 'Զիմբաբվե',
 			'ZZ' => 'Անհայտ տարածաշրջան',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'AREVELA' => 'արևելահայերեն',
 			'AREVMDA' => 'արեւմտահայերէն',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'օրացույց',
 			'cf' => 'արժույթի ձևաչափ',
 			'collation' => 'տեսակավորման կարգ',
 			'currency' => 'արժույթ',
 			'hc' => 'Ժամանակային համակարգ (12 կամ 24)',
 			'lb' => 'տողանցման ոճ',
 			'ms' => 'չափման համակարգ',
 			'numbers' => 'թվեր',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{բուդդայական օրացույց},
 				'chinese' => q{չինական օրացույց},
 				'dangi' => q{դանգի օրացույց},
 				'ethiopic' => q{եթովպական օրացույց},
 				'gregorian' => q{գրիգորյան օրացույց},
 				'hebrew' => q{հրեական օրացույց},
 				'islamic' => q{իսլամական օրացույց},
 				'iso8601' => q{ISO-8601 օրացույց},
 				'japanese' => q{ճապոնական օրացույց},
 				'persian' => q{պարսկական օրացույց},
 				'roc' => q{մինգուո օրացույց},
 			},
 			'cf' => {
 				'account' => q{արժույթի հաշվապահական ձևաչափ},
 				'standard' => q{արժույթի ստանդարտ ձևաչափ},
 			},
 			'collation' => {
 				'ducet' => q{Յունիկոդ լռելյայն տեսակավորում},
 				'search' => q{որոնում},
 				'standard' => q{տեսակավորման ստանդարտ կարգ},
 			},
 			'hc' => {
 				'h11' => q{12-ժամյա համակարգ (0-11)},
 				'h12' => q{12-ժամյա համակարգ (1-12)},
 				'h23' => q{24-ժամյա համակարգ (0-23)},
 				'h24' => q{24-ժամյա համակարգ (1-24)},
 			},
 			'lb' => {
 				'loose' => q{փափուկ տողանցում},
 				'normal' => q{սովորական տողանցում},
 				'strict' => q{կոշտ տողանցում},
 			},
 			'ms' => {
 				'metric' => q{մետրիկ համակարգ},
 				'uksystem' => q{անգլիական համակարգ},
 				'ussystem' => q{ամերիկյան համակարգ},
 			},
 			'numbers' => {
 				'arab' => q{արաբա-հնդկական թվանշաններ},
 				'arabext' => q{արաբա-հնդկական թվերի ընդլայնված համակարգ},
 				'armn' => q{հայկական թվանշաններ},
 				'armnlow' => q{հայկական թվեր (փոքրատառ)},
 				'beng' => q{բենգալական թվանշաններ},
 				'deva' => q{դեվանագարի թվանշաններ},
 				'ethi' => q{եթովպական թվանշաններ},
 				'fullwide' => q{ամբողջ լայնքով թվանշաններ},
 				'geor' => q{վրացական թվեր},
 				'grek' => q{հունական թվեր},
 				'greklow' => q{հունական թվեր (փոքրատառ)},
 				'gujr' => q{գուջարաթի թվանշաններ},
 				'guru' => q{գուրմուխի թվանշաններ},
 				'hanidec' => q{չինական տասնորդական թվեր},
 				'hans' => q{չինական պարզեցված թվեր},
 				'hansfin' => q{չինական պարզեցված ֆինանսական թվեր},
 				'hant' => q{չինական ավանդական թվեր},
 				'hantfin' => q{չինական ավանդական ֆինանսական թվեր},
 				'hebr' => q{եբրայերեն թվեր},
 				'jpan' => q{ճապոնական թվեր},
 				'jpanfin' => q{ճապոնական ֆինանսական թվեր},
 				'khmr' => q{քմերական թվանշաններ},
 				'knda' => q{կաննադա թվանշաններ},
 				'laoo' => q{լաոսական թվանշաններ},
 				'latn' => q{արևմտյան թվանշաններ},
 				'mlym' => q{մալայալամ թվանշաններ},
 				'mymr' => q{բիրմական թվանշաններ},
 				'orya' => q{օրիյա թվանշաններ},
 				'roman' => q{հռոմեական թվեր},
 				'romanlow' => q{հռոմեական թվեր (փոքրատառ)},
 				'taml' => q{թամիլական ավանդական թվեր},
 				'tamldec' => q{թամիլական թվանշաններ},
 				'telu' => q{թելուգու թվանշաններ},
 				'thai' => q{թայական թվանշաններ},
 				'tibt' => q{տիբեթական թվանշաններ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Մետրական},
 			'UK' => q{Անգլիական},
 			'US' => q{Ամերիկյան},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Լեզու՝ {0}',
 			'script' => 'Գիր՝ {0}',
 			'region' => 'Տարածաշրջան՝ {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['Ա', 'Բ', 'Գ', 'Դ', 'Ե', 'Զ', 'Է', 'Ը', 'Թ', 'Ժ', 'Ի', 'Լ', 'Խ', 'Ծ', 'Կ', 'Հ', 'Ձ', 'Ղ', 'Ճ', 'Մ', 'Յ', 'Ն', 'Շ', 'Ո', 'Չ', 'Պ', 'Ջ', 'Ռ', 'Ս', 'Վ', 'Տ', 'Ր', 'Ց', 'Ւ', 'Փ', 'Ք', 'Օ', 'Ֆ'],
			main => qr{[ա բ գ դ ե զ է ը թ ժ ի լ խ ծ կ հ ձ ղ ճ մ յ ն շ ո չ պ ջ ռ ս վ տ ր ց ւ փ ք և օ ֆ]},
			numbers => qr{[  \- , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[֊ , ՝ \: ՜ ՞ . « » ՚ ՛ ՟]},
		};
	},
EOT
: sub {
		return { index => ['Ա', 'Բ', 'Գ', 'Դ', 'Ե', 'Զ', 'Է', 'Ը', 'Թ', 'Ժ', 'Ի', 'Լ', 'Խ', 'Ծ', 'Կ', 'Հ', 'Ձ', 'Ղ', 'Ճ', 'Մ', 'Յ', 'Ն', 'Շ', 'Ո', 'Չ', 'Պ', 'Ջ', 'Ռ', 'Ս', 'Վ', 'Տ', 'Ր', 'Ց', 'Ւ', 'Փ', 'Ք', 'Օ', 'Ֆ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(ակրեր),
						'one' => q({0} ակր),
						'other' => q({0} ակր),
					},
					'acre-foot' => {
						'name' => q(ակրոֆուտեր),
						'one' => q({0} ակրոֆուտ),
						'other' => q({0} ակրոֆուտ),
					},
					'ampere' => {
						'name' => q(ամպերներ),
						'one' => q({0} ամպեր),
						'other' => q({0} ամպեր),
					},
					'arc-minute' => {
						'name' => q(րոպեներ),
						'one' => q({0} րոպե),
						'other' => q({0} րոպե),
					},
					'arc-second' => {
						'name' => q(վայրկյաններ),
						'one' => q({0} վայրկյան),
						'other' => q({0} վայրկյան),
					},
					'astronomical-unit' => {
						'name' => q(աստղագիտական միավորներ),
						'one' => q({0} աստղագիտական միավոր),
						'other' => q({0} աստղագիտական միավոր),
					},
					'bit' => {
						'name' => q(բիթեր),
						'one' => q({0} բիթ),
						'other' => q({0} բիթ),
					},
					'byte' => {
						'name' => q(բայթեր),
						'one' => q({0} բայթ),
						'other' => q({0} բայթ),
					},
					'calorie' => {
						'name' => q(կալորիաներ),
						'one' => q({0} կալորիա),
						'other' => q({0} կալորիա),
					},
					'carat' => {
						'name' => q(կարատներ),
						'one' => q({0} կարատ),
						'other' => q({0} կարատ),
					},
					'celsius' => {
						'name' => q(աստիճաններ ըստ Ցելսիուսի),
						'one' => q({0} աստիճան ըստ Ցելսիուսի),
						'other' => q({0} աստիճան ըստ Ցելսիուսի),
					},
					'centiliter' => {
						'name' => q(սանտիլիտրեր),
						'one' => q({0} սանտիլիտր),
						'other' => q({0} սանտիլիտր),
					},
					'centimeter' => {
						'name' => q(սանտիմետրեր),
						'one' => q({0} սանտիմետր),
						'other' => q({0} սանտիմետր),
						'per' => q({0} սանտիմետրի վրա),
					},
					'century' => {
						'name' => q(դարեր),
						'one' => q({0} դար),
						'other' => q({0} դար),
					},
					'coordinate' => {
						'east' => q(արևելյան երկարության {0}),
						'north' => q(հյուսիսային լայնության {0}),
						'south' => q(հարավային լայնության {0}),
						'west' => q(արևմտյան երկարության {0}),
					},
					'cubic-centimeter' => {
						'name' => q(խորանարդ սանտիմետրեր),
						'one' => q({0} խորանարդ սանտիմետր),
						'other' => q({0} խորանարդ սանտիմետր),
						'per' => q({0} խորանարդ սանտիմետրի վրա),
					},
					'cubic-foot' => {
						'name' => q(խորանարդ ֆուտ),
						'one' => q({0} խորանարդ ֆուտ),
						'other' => q({0} խորանարդ ֆուտ),
					},
					'cubic-inch' => {
						'name' => q(խորանարդ դյույմ),
						'one' => q({0} խորանարդ դյույմ),
						'other' => q({0} խորանարդ դյույմ),
					},
					'cubic-kilometer' => {
						'name' => q(խորանարդ կիլոմետրեր),
						'one' => q({0} խորանարդ կիլոմետր),
						'other' => q({0} խորանարդ կիլոմետր),
					},
					'cubic-meter' => {
						'name' => q(խորանարդ մետրեր),
						'one' => q({0} խորանարդ մետր),
						'other' => q({0} խորանարդ մետր),
						'per' => q({0} խորանարդ մետրի վրա),
					},
					'cubic-mile' => {
						'name' => q(խորանարդ մղոններ),
						'one' => q({0} խորանարդ մղոն),
						'other' => q({0} խորանարդ մղոն),
					},
					'cubic-yard' => {
						'name' => q(խորանարդ յարդ),
						'one' => q({0} խորանարդ յարդ),
						'other' => q({0} խորանարդ յարդ),
					},
					'cup' => {
						'name' => q(բաժակներ),
						'one' => q({0} բաժակ),
						'other' => q({0} բաժակ),
					},
					'cup-metric' => {
						'name' => q(մետրիկ բաժակներ),
						'one' => q({0} մետրիկ բաժակ),
						'other' => q({0} մետրիկ բաժակ),
					},
					'day' => {
						'name' => q(օրեր),
						'one' => q({0} օր),
						'other' => q({0} օր),
						'per' => q(օրական {0}),
					},
					'deciliter' => {
						'name' => q(դեցիլիտրեր),
						'one' => q({0} դեցիլիտր),
						'other' => q({0} դեցիլիտր),
					},
					'decimeter' => {
						'name' => q(դեցիմետրեր),
						'one' => q({0} դեցիմետր),
						'other' => q({0} դեցիմետր),
					},
					'degree' => {
						'name' => q(աստիճաններ),
						'one' => q({0} աստիճան),
						'other' => q({0} աստիճան),
					},
					'fahrenheit' => {
						'name' => q(աստիճաններ ըստ Ֆարենհայթի),
						'one' => q({0} աստիճան ըստ Ֆարենհայթի),
						'other' => q({0} աստիճան ըստ Ֆարենհայթի),
					},
					'fluid-ounce' => {
						'name' => q(հեղուկ ունցիաներ),
						'one' => q({0} հեղուկ ունցիա),
						'other' => q({0} հեղուկ ունցիա),
					},
					'foodcalorie' => {
						'name' => q(կալորիաներ),
						'one' => q({0} կալորիա),
						'other' => q({0} կալորիա),
					},
					'foot' => {
						'name' => q(ֆուտեր),
						'one' => q({0} ֆուտ),
						'other' => q({0} ֆուտ),
						'per' => q({0} ֆուտի վրա),
					},
					'g-force' => {
						'name' => q(ազատ անկման արագացում),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'gallon' => {
						'name' => q(գալոններ),
						'one' => q({0} գալոն),
						'other' => q({0} գալոն),
						'per' => q({0} գալոնի վրա),
					},
					'gallon-imperial' => {
						'name' => q(անգլիական գալոններ),
						'one' => q({0} անգլիական գալոն),
						'other' => q({0} անգլիական գալոն),
						'per' => q({0} անգլիական գալոնի վրա),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(գիգաբիթեր),
						'one' => q({0} գիգաբիթ),
						'other' => q({0} գիգաբիթ),
					},
					'gigabyte' => {
						'name' => q(գիգաբայթեր),
						'one' => q({0} գիգաբայթ),
						'other' => q({0} գիգաբայթ),
					},
					'gigahertz' => {
						'name' => q(գիգահերցեր),
						'one' => q({0} գիգահերց),
						'other' => q({0} գիգահերց),
					},
					'gigawatt' => {
						'name' => q(գիգավատտեր),
						'one' => q({0} գիգավատտեր),
						'other' => q({0} գիգավատտեր),
					},
					'gram' => {
						'name' => q(գրամներ),
						'one' => q({0} գրամ),
						'other' => q({0} գրամ),
						'per' => q({0} գրամի վրա),
					},
					'hectare' => {
						'name' => q(հեկտարներ),
						'one' => q({0} հեկտար),
						'other' => q({0} հեկտար),
					},
					'hectoliter' => {
						'name' => q(հեկտոլիտրեր),
						'one' => q({0} հեկտոլիտր),
						'other' => q({0} հեկտոլիտր),
					},
					'hectopascal' => {
						'name' => q(հեկտոպասկալ),
						'one' => q({0} հեկտոպասկալ),
						'other' => q({0} հեկտոպասկալ),
					},
					'hertz' => {
						'name' => q(հերցեր),
						'one' => q({0} հերց),
						'other' => q({0} հերց),
					},
					'horsepower' => {
						'name' => q(ձիաուժեր),
						'one' => q({0} ձիաուժ),
						'other' => q({0} ձիաուժ),
					},
					'hour' => {
						'name' => q(ժամեր),
						'one' => q({0} ժամ),
						'other' => q({0} ժամ),
						'per' => q({0} ժամում),
					},
					'inch' => {
						'name' => q(դյույմեր),
						'one' => q({0} դյույմ),
						'other' => q({0} դյույմ),
						'per' => q({0} դյույմի վրա),
					},
					'inch-hg' => {
						'name' => q(սնդիկի սյան դյույմեր),
						'one' => q({0} դյույմ սնդիկի սյուն),
						'other' => q({0} դյույմ սնդիկի սյուն),
					},
					'joule' => {
						'name' => q(ջոուլներ),
						'one' => q({0} ջոուլ),
						'other' => q({0} ջոուլ),
					},
					'karat' => {
						'name' => q(կարատ),
						'one' => q({0} կարատ),
						'other' => q({0} կարատ),
					},
					'kelvin' => {
						'name' => q(կելվիններ),
						'one' => q({0} կելվին),
						'other' => q({0} կելվին),
					},
					'kilobit' => {
						'name' => q(կիլոբիթեր),
						'one' => q({0} կիլոբիթ),
						'other' => q({0} կիլոբիթ),
					},
					'kilobyte' => {
						'name' => q(կիլոբայթեր),
						'one' => q({0} կիլոբայթ),
						'other' => q({0} կիլոբայթ),
					},
					'kilocalorie' => {
						'name' => q(կիլոկալորիաներ),
						'one' => q({0} կիլոկալորիա),
						'other' => q({0} կիլոկալորիա),
					},
					'kilogram' => {
						'name' => q(կիլոգրամներ),
						'one' => q({0} կիլոգրամ),
						'other' => q({0} կիլոգրամ),
						'per' => q({0} կիլոգրամի վրա),
					},
					'kilohertz' => {
						'name' => q(կիլոհերցեր),
						'one' => q({0} կիլոհերց),
						'other' => q({0} կիլոհերց),
					},
					'kilojoule' => {
						'name' => q(կիլոջոուլներ),
						'one' => q({0} կիլոջոուլ),
						'other' => q({0} կիլոջոուլ),
					},
					'kilometer' => {
						'name' => q(կիլոմետրեր),
						'one' => q({0} կիլոմետր),
						'other' => q({0} կիլոմետր),
						'per' => q({0} կիլոմետրի վրա),
					},
					'kilometer-per-hour' => {
						'name' => q(կիլոմետրեր ժամում),
						'one' => q({0} կիլոմետր ժամում),
						'other' => q({0} կիլոմետր ժամում),
					},
					'kilowatt' => {
						'name' => q(կիլովատտեր),
						'one' => q({0} կիլովատտ),
						'other' => q({0} կիլովատտ),
					},
					'kilowatt-hour' => {
						'name' => q(կիլովատտեր-ժամեր),
						'one' => q({0} կիլովատտ-ժամ),
						'other' => q({0} կիլովատտ-ժամ),
					},
					'knot' => {
						'name' => q(հանգույցներ),
						'one' => q({0} հանգույց),
						'other' => q({0} հանգույց),
					},
					'light-year' => {
						'name' => q(լուսատարիներ),
						'one' => q({0} լուսատարի),
						'other' => q({0} լուսատարի),
					},
					'liter' => {
						'name' => q(լիտրեր),
						'one' => q({0} լիտր),
						'other' => q({0} լիտր),
						'per' => q({0} լիտրի վրա),
					},
					'liter-per-100kilometers' => {
						'name' => q(լիտրեր 100 կիլոմետրի վրա),
						'one' => q({0} լիտր 100 կիլոմետրի վրա),
						'other' => q({0} լիտր 100 կիլոմետրի վրա),
					},
					'liter-per-kilometer' => {
						'name' => q(լիտրեր կիլոմետրի վրա),
						'one' => q({0} լիտր կիլոմետրի վրա),
						'other' => q({0} լիտր կիլոմետրի վրա),
					},
					'lux' => {
						'name' => q(լյուքսեր),
						'one' => q({0} լյուքս),
						'other' => q({0} լյուքս),
					},
					'megabit' => {
						'name' => q(մեգաբիթեր),
						'one' => q({0} մեգաբիթ),
						'other' => q({0} մեգաբիթ),
					},
					'megabyte' => {
						'name' => q(մեգաբայթեր),
						'one' => q({0} մեգաբայթ),
						'other' => q({0} մեգաբայթ),
					},
					'megahertz' => {
						'name' => q(մեգահերցեր),
						'one' => q({0} մեգահերց),
						'other' => q({0} մեգահերց),
					},
					'megaliter' => {
						'name' => q(մեգալիտրեր),
						'one' => q({0} մեգալիտր),
						'other' => q({0} մեգալիտր),
					},
					'megawatt' => {
						'name' => q(մեգավատտեր),
						'one' => q({0} մեգավատտ),
						'other' => q({0} մեգավատտ),
					},
					'meter' => {
						'name' => q(մետրեր),
						'one' => q({0} մետր),
						'other' => q({0} մետր),
						'per' => q({0} մետրի վրա),
					},
					'meter-per-second' => {
						'name' => q(մետրեր վայրկյանում),
						'one' => q({0} մետր վայրկյանում),
						'other' => q({0} մետր վայրկյանում),
					},
					'meter-per-second-squared' => {
						'name' => q(մետրեր/վայրկյան քառակուսի),
						'one' => q({0} մետր/վայրկյան քառակուսի),
						'other' => q({0} մետր/վայրկյան քառակուսի),
					},
					'metric-ton' => {
						'name' => q(տոննաներ),
						'one' => q({0} տոննա),
						'other' => q({0} տոննա),
					},
					'microgram' => {
						'name' => q(միկրոգրամներ),
						'one' => q({0} միկրոգրամ),
						'other' => q({0} միկրոգրամ),
					},
					'micrometer' => {
						'name' => q(միկրոմետրեր),
						'one' => q({0} միկրոմետր),
						'other' => q({0} միկրոմետր),
					},
					'microsecond' => {
						'name' => q(միկրովայրկյաններ),
						'one' => q({0} միկրովայրկյան),
						'other' => q({0} միկրովայրկյան),
					},
					'mile' => {
						'name' => q(մղոններ),
						'one' => q({0} մղոն),
						'other' => q({0} մղոն),
					},
					'mile-per-gallon' => {
						'name' => q(մղոններ գալոնի վրա),
						'one' => q({0} մղոն գալոնի վրա),
						'other' => q({0} մղոն գալոնի վրա),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(մղոններ անգլիական գալոնի վրա),
						'one' => q({0} մղոն անգլիական գալոնի վրա),
						'other' => q({0} մղոն անգլիական գալոնի վրա),
					},
					'mile-per-hour' => {
						'name' => q(մղոններ ժամում),
						'one' => q({0} մղոն ժամում),
						'other' => q({0} մղոն ժամում),
					},
					'mile-scandinavian' => {
						'name' => q(սկանդինավյան մղոններ),
						'one' => q({0} սկանդինավյան մղոն),
						'other' => q({0} սկանդինավյան մղոն),
					},
					'milliampere' => {
						'name' => q(միլիամպերներ),
						'one' => q({0} միլիամպեր),
						'other' => q({0} միլիամպեր),
					},
					'millibar' => {
						'name' => q(միլիբարեր),
						'one' => q({0} միլիբար),
						'other' => q({0} միլիբար),
					},
					'milligram' => {
						'name' => q(միլիգրամներ),
						'one' => q({0} միլիգրամ),
						'other' => q({0} միլիգրամ),
					},
					'milligram-per-deciliter' => {
						'name' => q(միլիգրամներ դեցիլիտրի վրա),
						'one' => q({0} միլիգրամ դեցիլիտրի վրա),
						'other' => q({0} միլիգրամ դեցիլիտրի վրա),
					},
					'milliliter' => {
						'name' => q(միլիլիտրեր),
						'one' => q({0} միլիլիտր),
						'other' => q({0} միլիլիտր),
					},
					'millimeter' => {
						'name' => q(միլիմետրեր),
						'one' => q({0} միլիմետր),
						'other' => q({0} միլիմետր),
					},
					'millimeter-of-mercury' => {
						'name' => q(սնդիկի սյան միլիմետրեր),
						'one' => q({0} միլիմետր սնդիկի սյուն),
						'other' => q({0} միլիմետր սնդիկի սյուն),
					},
					'millimole-per-liter' => {
						'name' => q(միլիմոլներ լիտրի վրա),
						'one' => q({0} միլիմոլ լիտրի վրա),
						'other' => q({0} միլիմոլ լիտրի վրա),
					},
					'millisecond' => {
						'name' => q(միլիվայրկյաններ),
						'one' => q({0} միլիվայրկյան),
						'other' => q({0} միլիվայրկյան),
					},
					'milliwatt' => {
						'name' => q(միլիվատտեր),
						'one' => q({0} միլիվատտ),
						'other' => q({0} միլիվատտ),
					},
					'minute' => {
						'name' => q(րոպեներ),
						'one' => q({0} րոպե),
						'other' => q({0} րոպե),
						'per' => q({0} րոպեում),
					},
					'month' => {
						'name' => q(ամիսներ),
						'one' => q({0} ամիս),
						'other' => q({0} ամիս),
						'per' => q(ամսական {0}),
					},
					'nanometer' => {
						'name' => q(նանոմետրեր),
						'one' => q({0} նանոմետր),
						'other' => q({0} նանոմետր),
					},
					'nanosecond' => {
						'name' => q(նանովայրկյաններ),
						'one' => q({0} նանովայրկյան),
						'other' => q({0} նանովայրկյան),
					},
					'nautical-mile' => {
						'name' => q(ծովային մղոններ),
						'one' => q({0} ծովային մղոն),
						'other' => q({0} ծովային մղոն),
					},
					'ohm' => {
						'name' => q(օհմեր),
						'one' => q({0} օհմ),
						'other' => q({0} օհմ),
					},
					'ounce' => {
						'name' => q(ունցիաներ),
						'one' => q({0} ունցիա),
						'other' => q({0} ունցիա),
						'per' => q({0} ունցիայի վրա),
					},
					'ounce-troy' => {
						'name' => q(տրոյական ունցիաներ),
						'one' => q({0} տրոյական ունցիա),
						'other' => q({0} տրոյական ունցիա),
					},
					'parsec' => {
						'name' => q(պարսեկներ),
						'one' => q({0} պարսեկ),
						'other' => q({0} պարսեկ),
					},
					'part-per-million' => {
						'name' => q(մասնիկներ միլիոնի վրա),
						'one' => q({0} մասնիկ միլիոնի վրա),
						'other' => q({0} մասնիկ միլիոնի վրա),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(պիկոմետրեր),
						'one' => q({0} պիկոմետր),
						'other' => q({0} պիկոմետր),
					},
					'pint' => {
						'name' => q(պինտեր),
						'one' => q({0} պինտ),
						'other' => q({0} պինտ),
					},
					'pint-metric' => {
						'name' => q(մետրիկ պինտեր),
						'one' => q({0} մետրիկ պինտ),
						'other' => q({0} մետրիկ պինտ),
					},
					'point' => {
						'name' => q(կետեր),
						'one' => q({0} կետ),
						'other' => q({0} կետ),
					},
					'pound' => {
						'name' => q(ֆունտեր),
						'one' => q({0} ֆունտ),
						'other' => q({0} ֆունտ),
						'per' => q({0} ֆունտի վրա),
					},
					'pound-per-square-inch' => {
						'name' => q(ֆունտեր քառակուսի դյույմի վրա),
						'one' => q({0} ֆունտ քառակուսի դյույմի վրա),
						'other' => q({0} ֆունտ քառակուսի դյույմի վրա),
					},
					'quart' => {
						'name' => q(քվարտեր),
						'one' => q({0} քվարտ),
						'other' => q({0} քվարտ),
					},
					'radian' => {
						'name' => q(ռադիաններ),
						'one' => q({0} ռադիան),
						'other' => q({0} ռադիան),
					},
					'revolution' => {
						'name' => q(պտույտներ),
						'one' => q({0} պտույտ),
						'other' => q({0} պտույտ),
					},
					'second' => {
						'name' => q(վայրկյաններ),
						'one' => q({0} վայրկյան),
						'other' => q({0} վայրկյան),
						'per' => q({0} վայրկյանում),
					},
					'square-centimeter' => {
						'name' => q(քառակուսի սանտիմետրեր),
						'one' => q({0} քառակուսի սանտիմետր),
						'other' => q({0} քառակուսի սանտիմետր),
						'per' => q({0} քառակուսի սանտիմետրի վրա),
					},
					'square-foot' => {
						'name' => q(քառակուսի ֆուտեր),
						'one' => q({0} քառակուսի ֆուտ),
						'other' => q({0} քառակուսի ֆուտ),
					},
					'square-inch' => {
						'name' => q(քառակուսի դյույմեր),
						'one' => q({0} քառակուսի դյույմ),
						'other' => q({0} քառակուսի դյույմ),
						'per' => q({0} քառակուսի դյույմի վրա),
					},
					'square-kilometer' => {
						'name' => q(քառակուսի կիլոմետրեր),
						'one' => q({0} քառակուսի կիլոմետր),
						'other' => q({0} քառակուսի կիլոմետր),
						'per' => q({0} քառակուսի կիլոմետրի վրա),
					},
					'square-meter' => {
						'name' => q(քառակուսի մետրեր),
						'one' => q({0} քառակուսի մետր),
						'other' => q({0} քառակուսի մետր),
						'per' => q({0} քառակուսի մետրի վրա),
					},
					'square-mile' => {
						'name' => q(քառակուսի մղոններ),
						'one' => q({0} քառակուսի մղոն),
						'other' => q({0} քառակուսի մղոն),
						'per' => q({0} քառակուսի մղոնի վրա),
					},
					'square-yard' => {
						'name' => q(քառակուսի յարդեր),
						'one' => q({0} քառակուսի յարդ),
						'other' => q({0} քառակուսի յարդ),
					},
					'tablespoon' => {
						'name' => q(ճաշի գդալ),
						'one' => q({0} ճաշի գդալ),
						'other' => q({0} ճաշի գդալ),
					},
					'teaspoon' => {
						'name' => q(թեյի գդալ),
						'one' => q({0} թեյի գդալ),
						'other' => q({0} թեյի գդալ),
					},
					'terabit' => {
						'name' => q(տերաբիթեր),
						'one' => q({0} տերաբիթ),
						'other' => q({0} տերաբիթ),
					},
					'terabyte' => {
						'name' => q(տերաբայթեր),
						'one' => q({0} տերաբայթ),
						'other' => q({0} տերաբայթ),
					},
					'ton' => {
						'name' => q(ամերիկյան տոննաներ),
						'one' => q({0} ամերիկյան տոննա),
						'other' => q({0} ամերիկյան տոննա),
					},
					'volt' => {
						'name' => q(վոլտեր),
						'one' => q({0} վոլտ),
						'other' => q({0} վոլտ),
					},
					'watt' => {
						'name' => q(վատտեր),
						'one' => q({0} վատտ),
						'other' => q({0} վատտ),
					},
					'week' => {
						'name' => q(շաբաթներ),
						'one' => q({0} շաբաթ),
						'other' => q({0} շաբաթ),
						'per' => q(շաբաթական {0}),
					},
					'yard' => {
						'name' => q(յարդեր),
						'one' => q({0} յարդ),
						'other' => q({0} յարդ),
					},
					'year' => {
						'name' => q(տարիներ),
						'one' => q({0} տարի),
						'other' => q({0} տարի),
						'per' => q(տարեկան {0}),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0}ակր),
						'other' => q({0}ակր),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0} °C),
						'other' => q({0} °C),
					},
					'centimeter' => {
						'name' => q(սմ),
						'one' => q({0} սմ),
						'other' => q({0} սմ),
					},
					'coordinate' => {
						'east' => q({0} ավ․ ե․),
						'north' => q({0} հս․ լ․),
						'south' => q({0} հվ․ լ․),
						'west' => q({0} ամ․ ե․),
					},
					'cubic-kilometer' => {
						'one' => q({0}կմ³),
						'other' => q({0}կմ³),
					},
					'cubic-mile' => {
						'one' => q({0}մղ³),
						'other' => q({0}մղ³),
					},
					'day' => {
						'name' => q(օ),
						'one' => q({0} օ),
						'other' => q({0} օ),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}G),
					},
					'gram' => {
						'name' => q(գ),
						'one' => q({0} գ),
						'other' => q({0} գ),
					},
					'hectare' => {
						'one' => q({0}հա),
						'other' => q({0}հա),
					},
					'hectopascal' => {
						'one' => q({0} հՊա),
						'other' => q({0} հՊա),
					},
					'horsepower' => {
						'one' => q({0}ձ/ու),
						'other' => q({0}ձ/ու),
					},
					'hour' => {
						'name' => q(ժ),
						'one' => q({0} ժ),
						'other' => q({0} ժ),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'one' => q({0}" ս. ս.),
						'other' => q({0}" ս. ս),
					},
					'kilogram' => {
						'name' => q(կգ),
						'one' => q({0} կգ),
						'other' => q({0} կգ),
					},
					'kilometer' => {
						'name' => q(կմ),
						'one' => q({0} կմ),
						'other' => q({0} կմ),
					},
					'kilometer-per-hour' => {
						'name' => q(կմ/ժ),
						'one' => q({0} կմ/ժ),
						'other' => q({0} կմ/ժ),
					},
					'kilowatt' => {
						'one' => q({0}կՎ),
						'other' => q({0}կՎ),
					},
					'light-year' => {
						'one' => q({0} լ. տ.),
						'other' => q({0} լ. տ.),
					},
					'liter' => {
						'name' => q(լ),
						'one' => q({0} լ),
						'other' => q({0} լ),
					},
					'liter-per-100kilometers' => {
						'name' => q(լ/100 կմ),
						'one' => q({0} լ/100 կմ),
						'other' => q({0} լ/100 կմ),
					},
					'meter' => {
						'name' => q(մ),
						'one' => q({0} մ),
						'other' => q({0} մ),
					},
					'meter-per-second' => {
						'one' => q({0}մ/վ),
						'other' => q({0}մ/վ),
					},
					'mile' => {
						'one' => q({0} մղ),
						'other' => q({0} մղ),
					},
					'mile-per-hour' => {
						'one' => q({0}մղ/ժ),
						'other' => q({0}մղ/ժ),
					},
					'millibar' => {
						'one' => q({0} մբ),
						'other' => q({0} մբ),
					},
					'millimeter' => {
						'name' => q(մմ),
						'one' => q({0} մմ),
						'other' => q({0} մմ),
					},
					'millisecond' => {
						'name' => q(մվ),
						'one' => q({0} մվ),
						'other' => q({0} մվ),
					},
					'minute' => {
						'name' => q(ր),
						'one' => q({0} ր),
						'other' => q({0} ր),
					},
					'month' => {
						'name' => q(ա),
						'one' => q({0} ա),
						'other' => q({0} ա),
					},
					'ounce' => {
						'one' => q({0} ունց),
						'other' => q({0} ունց),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} պմ),
						'other' => q({0} պմ),
					},
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					'second' => {
						'name' => q(վ),
						'one' => q({0} վ),
						'other' => q({0} վ),
					},
					'square-foot' => {
						'one' => q({0}ֆտ²),
						'other' => q({0}ֆտ²),
					},
					'square-kilometer' => {
						'one' => q({0} կմ²),
						'other' => q({0} կմ²),
					},
					'square-meter' => {
						'one' => q({0} մ²),
						'other' => q({0} մ²),
					},
					'square-mile' => {
						'one' => q({0}մղ²),
						'other' => q({0}մղ²),
					},
					'watt' => {
						'one' => q({0}Վ),
						'other' => q({0}Վ),
					},
					'week' => {
						'name' => q(շ),
						'one' => q({0} շ),
						'other' => q({0} շ),
					},
					'yard' => {
						'one' => q({0} յդ.),
						'other' => q({0} յդ.),
					},
					'year' => {
						'name' => q(տ),
						'one' => q({0} տ),
						'other' => q({0} տ),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(ակր),
						'one' => q({0} ակր),
						'other' => q({0} ակր),
					},
					'acre-foot' => {
						'name' => q(ակր ֆտ),
						'one' => q({0} ակր ֆտ),
						'other' => q({0} ակր ֆտ),
					},
					'ampere' => {
						'name' => q(Ա),
						'one' => q({0} Ա),
						'other' => q({0} Ա),
					},
					'arc-minute' => {
						'name' => q(րոպեներ),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'name' => q(վայրկյաններ),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'name' => q(ա.մ.),
						'one' => q({0} ա.մ.),
						'other' => q({0} ա.մ.),
					},
					'bit' => {
						'name' => q(բիթ),
						'one' => q({0} բիթ),
						'other' => q({0} բիթ),
					},
					'byte' => {
						'name' => q(Բ),
						'one' => q({0} Բ),
						'other' => q({0} Բ),
					},
					'calorie' => {
						'name' => q(կալ),
						'one' => q({0} կալ),
						'other' => q({0} կալ),
					},
					'carat' => {
						'name' => q(կար),
						'one' => q({0} կար),
						'other' => q({0} կար),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0} °C),
						'other' => q({0} °C),
					},
					'centiliter' => {
						'name' => q(սլ),
						'one' => q({0} սլ),
						'other' => q({0} սլ),
					},
					'centimeter' => {
						'name' => q(սմ),
						'one' => q({0} սմ),
						'other' => q({0} սմ),
						'per' => q({0}/սմ),
					},
					'century' => {
						'name' => q(դ․),
						'one' => q({0} դ․),
						'other' => q({0} դ․),
					},
					'coordinate' => {
						'east' => q({0} ավ․ ե․),
						'north' => q({0} հս․ լ․),
						'south' => q({0} հվ․ լ․),
						'west' => q({0} ամ․ ե․),
					},
					'cubic-centimeter' => {
						'name' => q(սմ³),
						'one' => q({0} սմ³),
						'other' => q({0} սմ³),
						'per' => q({0}/սմ³),
					},
					'cubic-foot' => {
						'name' => q(ֆտ³),
						'one' => q({0} ֆտ³),
						'other' => q({0} ֆտ³),
					},
					'cubic-inch' => {
						'name' => q(դյմ³),
						'one' => q({0} դյմ³),
						'other' => q({0} դյմ³),
					},
					'cubic-kilometer' => {
						'name' => q(կմ³),
						'one' => q({0} կմ³),
						'other' => q({0} կմ³),
					},
					'cubic-meter' => {
						'name' => q(մ³),
						'one' => q({0} մ³),
						'other' => q({0} մ³),
						'per' => q({0}/մ³),
					},
					'cubic-mile' => {
						'name' => q(մղ³),
						'one' => q({0} մղ³),
						'other' => q({0} մղ³),
					},
					'cubic-yard' => {
						'name' => q(յրդ³),
						'one' => q({0} յրդ³),
						'other' => q({0} յրդ³),
					},
					'cup' => {
						'name' => q(բաժակներ),
						'one' => q({0} բաժ․),
						'other' => q({0} բաժ․),
					},
					'cup-metric' => {
						'name' => q(մ․ բաժ․),
						'one' => q({0} մ․ բաժ․),
						'other' => q({0} մ․ բաժ․),
					},
					'day' => {
						'name' => q(օր),
						'one' => q({0} օր),
						'other' => q({0} օր),
						'per' => q({0}/օր),
					},
					'deciliter' => {
						'name' => q(դլ),
						'one' => q({0} դլ),
						'other' => q({0} դլ),
					},
					'decimeter' => {
						'name' => q(դմ),
						'one' => q({0} դմ),
						'other' => q({0} դմ),
					},
					'degree' => {
						'name' => q(աստիճաններ),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'name' => q(հղ․ ունց․),
						'one' => q({0} հղ. ունց․),
						'other' => q({0} հղ. ունց․),
					},
					'foodcalorie' => {
						'name' => q(կալ),
						'one' => q({0} կալ),
						'other' => q({0} կալ),
					},
					'foot' => {
						'name' => q(ֆտ),
						'one' => q({0} ֆտ),
						'other' => q({0} ֆտ),
						'per' => q({0}/ֆտ),
					},
					'g-force' => {
						'name' => q(g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'gallon' => {
						'name' => q(գալ),
						'one' => q({0} գալ),
						'other' => q({0} գալ),
						'per' => q({0}/գալ),
					},
					'gallon-imperial' => {
						'name' => q(անգլ․ գալ),
						'one' => q({0} անգլ․ գալ),
						'other' => q({0} անգլ․ գալ),
						'per' => q({0}/անգլ․ գալ),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Գբիթ),
						'one' => q({0} Գբիթ),
						'other' => q({0} Գբիթ),
					},
					'gigabyte' => {
						'name' => q(ԳԲ),
						'one' => q({0} ԳԲ),
						'other' => q({0} ԳԲ),
					},
					'gigahertz' => {
						'name' => q(ԳՀց),
						'one' => q({0} ԳՀց),
						'other' => q({0} ԳՀց),
					},
					'gigawatt' => {
						'name' => q(ԳՎտ),
						'one' => q({0} ԳՎտ),
						'other' => q({0} ԳՎտ),
					},
					'gram' => {
						'name' => q(գ),
						'one' => q({0} գ),
						'other' => q({0} գ),
						'per' => q({0}/գ),
					},
					'hectare' => {
						'name' => q(հա),
						'one' => q({0} հա),
						'other' => q({0} հա),
					},
					'hectoliter' => {
						'name' => q(հլ),
						'one' => q({0} հլ),
						'other' => q({0} հլ),
					},
					'hectopascal' => {
						'name' => q(հՊա),
						'one' => q({0} հՊա),
						'other' => q({0} հՊա),
					},
					'hertz' => {
						'name' => q(Հց),
						'one' => q({0} Հց),
						'other' => q({0} Հց),
					},
					'horsepower' => {
						'name' => q(ձ․ու․),
						'one' => q({0} ձ․ու․),
						'other' => q({0} ձ․ու․),
					},
					'hour' => {
						'name' => q(ժ),
						'one' => q({0} ժ),
						'other' => q({0} ժ),
						'per' => q({0}/ժ),
					},
					'inch' => {
						'name' => q(դյմ),
						'one' => q({0} դյմ),
						'other' => q({0} դյմ),
						'per' => q({0}/դյմ),
					},
					'inch-hg' => {
						'name' => q(դյույմ ս.ս.),
						'one' => q({0} դյմ. ս.ս.),
						'other' => q({0} դյմ. ս.ս.),
					},
					'joule' => {
						'name' => q(Ջ),
						'one' => q({0} Ջ),
						'other' => q({0} Ջ),
					},
					'karat' => {
						'name' => q(կար),
						'one' => q({0} կար),
						'other' => q({0} կար),
					},
					'kelvin' => {
						'name' => q(Կ),
						'one' => q({0} Կ),
						'other' => q({0} Կ),
					},
					'kilobit' => {
						'name' => q(կբիթ),
						'one' => q({0} կբիթ),
						'other' => q({0} կբիթ),
					},
					'kilobyte' => {
						'name' => q(կԲ),
						'one' => q({0} կԲ),
						'other' => q({0} կԲ),
					},
					'kilocalorie' => {
						'name' => q(կկալ),
						'one' => q({0} կկալ),
						'other' => q({0} կկալ),
					},
					'kilogram' => {
						'name' => q(կգ),
						'one' => q({0} կգ),
						'other' => q({0} կգ),
						'per' => q({0}/կգ),
					},
					'kilohertz' => {
						'name' => q(կՀց),
						'one' => q({0} կՀց),
						'other' => q({0} կՀց),
					},
					'kilojoule' => {
						'name' => q(կՋ),
						'one' => q({0} կՋ),
						'other' => q({0} կՋ),
					},
					'kilometer' => {
						'name' => q(կմ),
						'one' => q({0} կմ),
						'other' => q({0} կմ),
						'per' => q({0}/կմ),
					},
					'kilometer-per-hour' => {
						'name' => q(կմ/ժ),
						'one' => q({0} կմ/ժ),
						'other' => q({0} կմ/ժ),
					},
					'kilowatt' => {
						'name' => q(կՎտ),
						'one' => q({0} կՎտ),
						'other' => q({0} կՎտ),
					},
					'kilowatt-hour' => {
						'name' => q(կՎտ·ժ),
						'one' => q({0} կՎտ·ժ),
						'other' => q({0} կՎտ·ժ),
					},
					'knot' => {
						'name' => q(հանգույցներ),
						'one' => q({0} հանգույց),
						'other' => q({0} հանգույց),
					},
					'light-year' => {
						'name' => q(լ․տ․),
						'one' => q({0} լ.տ.),
						'other' => q({0} լ.տ.),
					},
					'liter' => {
						'name' => q(լ),
						'one' => q({0} լ),
						'other' => q({0} լ),
						'per' => q({0}/լ),
					},
					'liter-per-100kilometers' => {
						'name' => q(լ/100 կմ),
						'one' => q({0} լ/100 կմ),
						'other' => q({0} լ/100 կմ),
					},
					'liter-per-kilometer' => {
						'name' => q(լ/կմ),
						'one' => q({0} լ/կմ),
						'other' => q({0} լ/կմ),
					},
					'lux' => {
						'name' => q(լք),
						'one' => q({0} լք),
						'other' => q({0} լք),
					},
					'megabit' => {
						'name' => q(Մբիթ),
						'one' => q({0} Մբիթ),
						'other' => q({0} Մբիթ),
					},
					'megabyte' => {
						'name' => q(ՄԲ),
						'one' => q({0} ՄԲ),
						'other' => q({0} ՄԲ),
					},
					'megahertz' => {
						'name' => q(ՄՀց),
						'one' => q({0} ՄՀց),
						'other' => q({0} ՄՀց),
					},
					'megaliter' => {
						'name' => q(Մլ),
						'one' => q({0} Մլ),
						'other' => q({0} Մլ),
					},
					'megawatt' => {
						'name' => q(ՄՎտ),
						'one' => q({0} ՄՎտ),
						'other' => q({0} ՄՎտ),
					},
					'meter' => {
						'name' => q(մ),
						'one' => q({0} մ),
						'other' => q({0} մ),
						'per' => q({0}/մ),
					},
					'meter-per-second' => {
						'name' => q(մ/վ),
						'one' => q({0} մ/վ),
						'other' => q({0} մ/վ),
					},
					'meter-per-second-squared' => {
						'name' => q(մ/վ²),
						'one' => q({0} մ/վ²),
						'other' => q({0} մ/վ²),
					},
					'metric-ton' => {
						'name' => q(տ),
						'one' => q({0} տ),
						'other' => q({0} տ),
					},
					'microgram' => {
						'name' => q(մկգ),
						'one' => q({0} մկգ),
						'other' => q({0} մկգ),
					},
					'micrometer' => {
						'name' => q(մկմ),
						'one' => q({0} մկմ),
						'other' => q({0} մկմ),
					},
					'microsecond' => {
						'name' => q(մկվ),
						'one' => q({0} մկվ),
						'other' => q({0} մկվ),
					},
					'mile' => {
						'name' => q(մղ),
						'one' => q({0} մղ),
						'other' => q({0} մղ),
					},
					'mile-per-gallon' => {
						'name' => q(մղ/գալ),
						'one' => q({0} մղ/գալ),
						'other' => q({0} մղ/գալ),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(մղ/անգլ․ գալ),
						'one' => q({0} մղ/անգլ․ գալ),
						'other' => q({0} մղ/անգլ․ գալ),
					},
					'mile-per-hour' => {
						'name' => q(մղ/ժ),
						'one' => q({0} մղ/ժ),
						'other' => q({0} մղ/ժ),
					},
					'mile-scandinavian' => {
						'name' => q(սկանդ․ մղ),
						'one' => q({0} սկանդ․ մղ),
						'other' => q({0} սկանդ․ մղ),
					},
					'milliampere' => {
						'name' => q(մԱ),
						'one' => q({0} մԱ),
						'other' => q({0} մԱ),
					},
					'millibar' => {
						'name' => q(մբար),
						'one' => q({0} մբար),
						'other' => q({0} մբար),
					},
					'milligram' => {
						'name' => q(մգ),
						'one' => q({0} մգ),
						'other' => q({0} մգ),
					},
					'milligram-per-deciliter' => {
						'name' => q(մգ/դլ),
						'one' => q({0} մգ/դլ),
						'other' => q({0} մգ/դլ),
					},
					'milliliter' => {
						'name' => q(մլ),
						'one' => q({0} մլ),
						'other' => q({0} մլ),
					},
					'millimeter' => {
						'name' => q(մմ),
						'one' => q({0} մմ),
						'other' => q({0} մմ),
					},
					'millimeter-of-mercury' => {
						'name' => q(մմ ս.ս.),
						'one' => q({0} մմ ս.ս.),
						'other' => q({0} մմ ս.ս.),
					},
					'millimole-per-liter' => {
						'name' => q(մմոլ/լ),
						'one' => q({0} մմոլ/լ),
						'other' => q({0} մմոլ/լ),
					},
					'millisecond' => {
						'name' => q(մվ),
						'one' => q({0} մվ),
						'other' => q({0} մվ),
					},
					'milliwatt' => {
						'name' => q(մՎտ),
						'one' => q({0} մՎտ),
						'other' => q({0} մՎտ),
					},
					'minute' => {
						'name' => q(ր),
						'one' => q({0} ր),
						'other' => q({0} ր),
						'per' => q({0}/ր),
					},
					'month' => {
						'name' => q(ամս),
						'one' => q({0} ամս),
						'other' => q({0} ամս),
						'per' => q({0}/ամս),
					},
					'nanometer' => {
						'name' => q(նմ),
						'one' => q({0} նմ),
						'other' => q({0} նմ),
					},
					'nanosecond' => {
						'name' => q(նվ),
						'one' => q({0} նվ),
						'other' => q({0} նվ),
					},
					'nautical-mile' => {
						'name' => q(ծով․ մղ),
						'one' => q({0} ծով․ մղ),
						'other' => q({0} ծով․ մղ),
					},
					'ohm' => {
						'name' => q(օմ),
						'one' => q({0} օմ),
						'other' => q({0} օմ),
					},
					'ounce' => {
						'name' => q(ունց),
						'one' => q({0} ունց),
						'other' => q({0} ունց),
						'per' => q({0}/ունց),
					},
					'ounce-troy' => {
						'name' => q(տրոյ․ ունց),
						'one' => q({0} տրոյ․ ունց),
						'other' => q({0} տրոյ․ ունց),
					},
					'parsec' => {
						'name' => q(պկ),
						'one' => q({0} պկ),
						'other' => q({0} պկ),
					},
					'part-per-million' => {
						'name' => q(մասնիկ/միլիոն),
						'one' => q({0} մասնիկ/միլիոն),
						'other' => q({0} մասնիկ/միլիոն),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(պմ),
						'one' => q({0} պմ),
						'other' => q({0} պմ),
					},
					'pint' => {
						'name' => q(պինտեր),
						'one' => q({0} պինտ),
						'other' => q({0} պինտ),
					},
					'pint-metric' => {
						'name' => q(մետր․ պինտեր),
						'one' => q({0} մետր․ պինտ),
						'other' => q({0} մետր․ պինտ),
					},
					'point' => {
						'name' => q(կտ),
						'one' => q({0} կտ),
						'other' => q({0} կտ),
					},
					'pound' => {
						'name' => q(ֆունտեր),
						'one' => q({0} ֆունտ),
						'other' => q({0} ֆունտ),
						'per' => q({0}/ֆունտ),
					},
					'pound-per-square-inch' => {
						'name' => q(ֆ․/քառ․ դյմ),
						'one' => q({0} ֆ./քառ․ դյմ),
						'other' => q({0} ֆ./քառ․ դյմ),
					},
					'quart' => {
						'name' => q(քվարտ),
						'one' => q({0} քվարտ),
						'other' => q({0} քվարտ),
					},
					'radian' => {
						'name' => q(ռադ),
						'one' => q({0} ռադ),
						'other' => q({0} ռադ),
					},
					'revolution' => {
						'name' => q(պտ),
						'one' => q({0} պտ),
						'other' => q({0} պտ),
					},
					'second' => {
						'name' => q(վրկ),
						'one' => q({0} վրկ),
						'other' => q({0} վրկ),
						'per' => q({0}/վրկ),
					},
					'square-centimeter' => {
						'name' => q(սմ²),
						'one' => q({0} սմ²),
						'other' => q({0} սմ²),
						'per' => q({0}/սմ²),
					},
					'square-foot' => {
						'name' => q(ֆտ²),
						'one' => q({0} ֆտ²),
						'other' => q({0} ֆտ²),
					},
					'square-inch' => {
						'name' => q(դյմ²),
						'one' => q({0} դյմ²),
						'other' => q({0} դյմ²),
						'per' => q({0}/դյմ²),
					},
					'square-kilometer' => {
						'name' => q(կմ²),
						'one' => q({0} կմ²),
						'other' => q({0} կմ²),
						'per' => q({0}/կմ²),
					},
					'square-meter' => {
						'name' => q(մ²),
						'one' => q({0} մ²),
						'other' => q({0} մ²),
						'per' => q({0}/մ²),
					},
					'square-mile' => {
						'name' => q(մղ²),
						'one' => q({0} մղ²),
						'other' => q({0} մղ²),
						'per' => q({0}/մղ²),
					},
					'square-yard' => {
						'name' => q(յրդ²),
						'one' => q({0} յրդ²),
						'other' => q({0} յրդ²),
					},
					'tablespoon' => {
						'name' => q(ճգ.),
						'one' => q({0} ճգ.),
						'other' => q({0} ճգ.),
					},
					'teaspoon' => {
						'name' => q(թգ.),
						'one' => q({0} թգ.),
						'other' => q({0} թգ.),
					},
					'terabit' => {
						'name' => q(Տբիթ),
						'one' => q({0} Տբիթ),
						'other' => q({0} Տբիթ),
					},
					'terabyte' => {
						'name' => q(ՏԲ),
						'one' => q({0} ՏԲ),
						'other' => q({0} ՏԲ),
					},
					'ton' => {
						'name' => q(ամեր․ տ),
						'one' => q({0} ամեր․ տ),
						'other' => q({0} ամեր․ տ),
					},
					'volt' => {
						'name' => q(Վ),
						'one' => q({0} Վ),
						'other' => q({0} Վ),
					},
					'watt' => {
						'name' => q(Վտ),
						'one' => q({0} Վտ),
						'other' => q({0} Վտ),
					},
					'week' => {
						'name' => q(շաբ),
						'one' => q({0} շաբ),
						'other' => q({0} շաբ),
						'per' => q({0}/շաբ),
					},
					'yard' => {
						'name' => q(յրդ),
						'one' => q({0} յրդ),
						'other' => q({0} յրդ),
					},
					'year' => {
						'name' => q(տ),
						'one' => q({0} տ),
						'other' => q({0} տ),
						'per' => q({0}/տ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:այո|ա|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ոչ|ո|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0} {1}),
				middle => q({0} {1}),
				end => q({0} և {1}),
				2 => q({0} և {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has traditional_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'armn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q( ),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(ՈչԹ),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 հզր',
					'other' => '0 հզր',
				},
				'10000' => {
					'one' => '00 հզր',
					'other' => '00 հզր',
				},
				'100000' => {
					'one' => '000 հզր',
					'other' => '000 հզր',
				},
				'1000000' => {
					'one' => '0 մլն',
					'other' => '0 մլն',
				},
				'10000000' => {
					'one' => '00 մլն',
					'other' => '00 մլն',
				},
				'100000000' => {
					'one' => '000 մլն',
					'other' => '000 մլն',
				},
				'1000000000' => {
					'one' => '0 մլրդ',
					'other' => '0 մլրդ',
				},
				'10000000000' => {
					'one' => '00 մլրդ',
					'other' => '00 մլրդ',
				},
				'100000000000' => {
					'one' => '000 մլրդ',
					'other' => '000 մլրդ',
				},
				'1000000000000' => {
					'one' => '0 տրլն',
					'other' => '0 տրլն',
				},
				'10000000000000' => {
					'one' => '00 տրլն',
					'other' => '00 տրլն',
				},
				'100000000000000' => {
					'one' => '000 տրլն',
					'other' => '000 տրլն',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 հազար',
					'other' => '0 հազար',
				},
				'10000' => {
					'one' => '00 հազար',
					'other' => '00 հազար',
				},
				'100000' => {
					'one' => '000 հազար',
					'other' => '000 հազար',
				},
				'1000000' => {
					'one' => '0 միլիոն',
					'other' => '0 միլիոն',
				},
				'10000000' => {
					'one' => '00 միլիոն',
					'other' => '00 միլիոն',
				},
				'100000000' => {
					'one' => '000 միլիոն',
					'other' => '000 միլիոն',
				},
				'1000000000' => {
					'one' => '0 միլիարդ',
					'other' => '0 միլիարդ',
				},
				'10000000000' => {
					'one' => '00 միլիարդ',
					'other' => '00 միլիարդ',
				},
				'100000000000' => {
					'one' => '000 միլիարդ',
					'other' => '000 միլիարդ',
				},
				'1000000000000' => {
					'one' => '0 տրիլիոն',
					'other' => '0 տրիլիոն',
				},
				'10000000000000' => {
					'one' => '00 տրիլիոն',
					'other' => '00 տրիլիոն',
				},
				'100000000000000' => {
					'one' => '000 տրիլիոն',
					'other' => '000 տրիլիոն',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 հզր',
					'other' => '0 հզր',
				},
				'10000' => {
					'one' => '00 հզր',
					'other' => '00 հզր',
				},
				'100000' => {
					'one' => '000 հզր',
					'other' => '000 հզր',
				},
				'1000000' => {
					'one' => '0 մլն',
					'other' => '0 մլն',
				},
				'10000000' => {
					'one' => '00 մլն',
					'other' => '00 մլն',
				},
				'100000000' => {
					'one' => '000 մլն',
					'other' => '000 մլն',
				},
				'1000000000' => {
					'one' => '0 մլրդ',
					'other' => '0 մլրդ',
				},
				'10000000000' => {
					'one' => '00 մլրդ',
					'other' => '00 մլրդ',
				},
				'100000000000' => {
					'one' => '000 մլրդ',
					'other' => '000 մլրդ',
				},
				'1000000000000' => {
					'one' => '0 տրլն',
					'other' => '0 տրլն',
				},
				'10000000000000' => {
					'one' => '00 տրլն',
					'other' => '00 տրլն',
				},
				'100000000000000' => {
					'one' => '000 տրլն',
					'other' => '000 տրլն',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(Արաբական Միացյալ Էմիրությունների դիրհամ),
				'one' => q(ԱՄԷ դիրհամ),
				'other' => q(ԱՄԷ դիրհամ),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(աֆղանական աֆղանի),
				'one' => q(աֆղանական աֆղանի),
				'other' => q(աֆղանական աֆղանի),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ալբանական լեկ),
				'one' => q(ալբանական լեկ),
				'other' => q(ալբանական լեկ),
			},
		},
		'AMD' => {
			symbol => '֏',
			display_name => {
				'currency' => q(հայկական դրամ),
				'one' => q(հայկական դրամ),
				'other' => q(հայկական դրամ),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(նիդեռլանդական անտիլյան գուլդեն),
				'one' => q(նիդեռլանդական անտիլյան գուլդեն),
				'other' => q(նիդեռլանդական անտիլյան գուլդեն),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(անգոլական կվանզա),
				'one' => q(անգոլական կվանզա),
				'other' => q(անգոլական կվանզա),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(արգենտինական պեսո),
				'one' => q(արգենտինական պեսո),
				'other' => q(արգենտինական պեսո),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ավստրալիական դոլար),
				'one' => q(ավստրալիական դոլար),
				'other' => q(ավստրալիական դոլար),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(արուբական ֆլորին),
				'one' => q(արուբական ֆլորին),
				'other' => q(արուբական ֆլորին),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(ադրբեջանական մանաթ),
				'one' => q(ադրբեջանական մանաթ),
				'other' => q(ադրբեջանական մանաթ),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(Բոսնիա և Հերցեգովինայի փոխարկվող մարկ),
				'one' => q(Բոսնիա և Հերցեգովինայի փոխարկվող մարկ),
				'other' => q(Բոսնիա և Հերցեգովինայի փոխարկվող մարկ),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(բարբադոսյան դոլար),
				'one' => q(բարբադոսյան դոլար),
				'other' => q(բարբադոսյան դոլար),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Բանգլադեշի տակա),
				'one' => q(Բանգլադեշի տակա),
				'other' => q(Բանգլադեշի տակա),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(բուլղարական լև),
				'one' => q(բուլղարական լև),
				'other' => q(բուլղարական լև),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Բահրեյնի դինար),
				'one' => q(Բահրեյնի դինար),
				'other' => q(Բահրեյնի դինար),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(բուրունդիական ֆրանկ),
				'one' => q(բուրունդիական ֆրանկ),
				'other' => q(բուրունդիական ֆրանկ),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(բերմուդյան դոլար),
				'one' => q(բերմուդյան դոլար),
				'other' => q(բերմուդյան դոլար),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Բրունեյի դոլար),
				'one' => q(Բրունեյի դոլար),
				'other' => q(Բրունեյի դոլար),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(բոլիվիական բոլիվիանո),
				'one' => q(բոլիվիական բոլիվիանո),
				'other' => q(բոլիվիական բոլիվիանո),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(բրազիլական ռեալ),
				'one' => q(բրազիլական ռեալ),
				'other' => q(բրազիլական ռեալ),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(բահամյան դոլար),
				'one' => q(բահամյան դոլար),
				'other' => q(բահամյան դոլար),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(բութանական նգուլտրում),
				'one' => q(բութանական նգուլտրում),
				'other' => q(բութանական նգուլտրում),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(բոթսվանական պուլա),
				'one' => q(բոթսվանական պուլա),
				'other' => q(բոթսվանական պուլա),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(բելառուսական ռուբլի),
				'one' => q(բելառուսական ռուբլի),
				'other' => q(բելառուսական ռուբլի),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(Բելառուսական ռուբլի \(2000–2016\)),
				'one' => q(բելառուսական ռուբլի \(2000–2016\)),
				'other' => q(բելառուսական ռուբլի \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(Բելիզի դոլար),
				'one' => q(Բելիզի դոլար),
				'other' => q(Բելիզի դոլար),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(կանադական դոլար),
				'one' => q(կանադական դոլար),
				'other' => q(կանադական դոլար),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Կոնգոյի ֆրանկ),
				'one' => q(Կոնգոյի ֆրանկ),
				'other' => q(Կոնգոյի ֆրանկ),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(շվեյցարական ֆրանկ),
				'one' => q(շվեյցարական ֆրանկ),
				'other' => q(շվեյցարական ֆրանկ),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(չիլիական պեսո),
				'one' => q(չիլիական պեսո),
				'other' => q(չիլիական պեսո),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(CNH),
				'one' => q(CNH),
				'other' => q(CNH),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(չինական յուան),
				'one' => q(չինական յուան),
				'other' => q(չինական յուան),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(կոլումբիական պեսո),
				'one' => q(կոլումբիական պեսո),
				'other' => q(կոլումբիական պեսո),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(Կոստա Ռիկայի կոլոն),
				'one' => q(Կոստա Ռիկայի կոլոն),
				'other' => q(Կոստա Ռիկայի կոլոն),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(կուբայական փոխարկվող պեսո),
				'one' => q(կուբայական փոխարկվող պեսո),
				'other' => q(կուբայական փոխարկվող պեսո),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(կուբայական պեսո),
				'one' => q(կուբայական պեսո),
				'other' => q(կուբայական պեսո),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Կաբո Վերդեի էսկուդո),
				'one' => q(Կաբո Վերդեի էսկուդո),
				'other' => q(Կաբո Վերդեի էսկուդո),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(չեխական կրոն),
				'one' => q(չեխական կրոն),
				'other' => q(չեխական կրոն),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Ջիբութիի ֆրանկ),
				'one' => q(Ջիբութիի ֆրանկ),
				'other' => q(Ջիբութիի ֆրանկ),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(դանիական կրոն),
				'one' => q(դանիական կրոն),
				'other' => q(դանիական կրոն),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(դոմինիկյան պեսո),
				'one' => q(դոմինիկյան պեսո),
				'other' => q(դոմինիկյան պեսո),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(ալժիրական դինար),
				'one' => q(ալժիրական դինար),
				'other' => q(ալժիրական դինար),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(եգիպտական ֆունտ),
				'one' => q(եգիպտական ֆունտ),
				'other' => q(եգիպտական ֆունտ),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(էրիթրեական նակվա),
				'one' => q(էրիթրեական նակֆա),
				'other' => q(էրիթրեական նակֆա),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(եթովպիական բիր),
				'one' => q(եթովպիական բիր),
				'other' => q(եթովպիական բիր),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(եվրո),
				'one' => q(եվրո),
				'other' => q(եվրո),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ֆիջիական դոլար),
				'one' => q(ֆիջիական դոլար),
				'other' => q(ֆիջիական դոլար),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(Ֆոլքլենդյան կղզիների ֆունտ),
				'one' => q(Ֆոլքլենդյան կղզիների ֆունտ),
				'other' => q(Ֆոլքլենդյան կղզիների ֆունտ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(բրիտանական ֆունտ ստերլինգ),
				'one' => q(բրիտանական ֆունտ ստերլինգ),
				'other' => q(բրիտանական ֆունտ ստերլինգ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(վրացական լարի),
				'one' => q(վրացական լարի),
				'other' => q(վրացական լարի),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(գայանական սեդի),
				'one' => q(գանայական սեդի),
				'other' => q(գանայական սեդի),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(Ջիբրալթարի ֆունտ),
				'one' => q(Ջիբրալթարի ֆունտ),
				'other' => q(Ջիբրալթարի ֆունտ),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(գամբիական դալասի),
				'one' => q(գամբիական դալասի),
				'other' => q(գամբիական դալասի),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(գվինեական ֆրանկ),
				'one' => q(գվինեական ֆրանկ),
				'other' => q(գվինեական ֆրանկ),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(գվատեմալական կետսալ),
				'one' => q(գվատեմալական կետսալ),
				'other' => q(գվատեմալական կետսալ),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(գայանական դոլար),
				'one' => q(գայանական դոլար),
				'other' => q(գայանական դոլար),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(Հոնկոնգի դոլար),
				'one' => q(Հոնկոնգի դոլար),
				'other' => q(Հոնկոնգի դոլար),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(հոնդուրասական լեմպիրա),
				'one' => q(հոնդուրասական լեմպիրա),
				'other' => q(հոնդուրասական լեմպիրա),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(խորվաթական կունա),
				'one' => q(խորվաթական կունա),
				'other' => q(խորվաթական կունա),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(հաիթյան գուրդ),
				'one' => q(հաիթյան գուրդ),
				'other' => q(հաիթյան գուրդ),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(հունգարական ֆորինտ),
				'one' => q(հունգարական ֆորինտ),
				'other' => q(հունգարական ֆորինտ),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ինդոնեզիական ռուփի),
				'one' => q(ինդոնեզիական ռուփի),
				'other' => q(ինդոնեզիական ռուփի),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(Իսրայելի նոր շեկել),
				'one' => q(Իսրայելի նոր շեկել),
				'other' => q(Իսրայելի նոր շեկել),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(հնդկական ռուփի),
				'one' => q(հնդկական ռուփի),
				'other' => q(հնդկական ռուփի),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(իրաքյան դինար),
				'one' => q(իրաքյան դինար),
				'other' => q(իրաքյան դինար),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(իրանական ռիալ),
				'one' => q(իրանական ռիալ),
				'other' => q(իրանական ռիալ),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(իսլանդական կրոն),
				'one' => q(իսլանդական կրոն),
				'other' => q(իսլանդական կրոն),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(Ճամայկայի դոլար),
				'one' => q(Ճամայկայի դոլար),
				'other' => q(Ճամայկայի դոլար),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(հորդանանյան դինար),
				'one' => q(հորդանանյան դինար),
				'other' => q(հորդանանյան դինար),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ճապոնական իեն),
				'one' => q(ճապոնական իեն),
				'other' => q(ճապոնական իեն),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(քենիական շիլինգ),
				'one' => q(քենիական շիլինգ),
				'other' => q(քենիական շիլինգ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(ղրղզական սոմ),
				'one' => q(ղրղզական սոմ),
				'other' => q(ղրղզական սոմ),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(կամբոջական ռիել),
				'one' => q(կամբոջական ռիել),
				'other' => q(կամբոջական ռիել),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(կոմորյան ֆրանկ),
				'one' => q(կոմորյան ֆրանկ),
				'other' => q(կոմորյան ֆրանկ),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(հյուսիսկորեական վոն),
				'one' => q(հյուսիսկորեական վոն),
				'other' => q(հյուսիսկորեական վոն),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(հարավկորեական վոն),
				'one' => q(հարավկորեական վոն),
				'other' => q(հարավկորեական վոն),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Քուվեյթի դինար),
				'one' => q(Քուվեյթի դինար),
				'other' => q(Քուվեյթի դինար),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(Կայմանյան կղզիների դոլար),
				'one' => q(Կայմանյան կղզիների դոլար),
				'other' => q(Կայմանյան կղզիների դոլար),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(ղազախական տենգե),
				'one' => q(ղազախական տենգե),
				'other' => q(ղազախական տենգե),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(լաոսական կիպ),
				'one' => q(լաոսական կիպ),
				'other' => q(լաոսական կիպ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(լիբանանյան ֆունտ),
				'one' => q(լիբանանյան ֆունտ),
				'other' => q(լիբանանյան ֆունտ),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Շրի Լանկայի ռուփի),
				'one' => q(Շրի Լանկայի ռուփի),
				'other' => q(Շրի Լանկայի ռուփի),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(լիբերիական դոլար),
				'one' => q(լիբերիական դոլար),
				'other' => q(լիբերիական դոլար),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(Լիտվական լիտ),
				'one' => q(Լիտվական լիտ),
				'other' => q(Լիտվական լիտ),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(Լատվիական լատ),
				'one' => q(Լատվիական լատ),
				'other' => q(Լատվիական լատ),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(լիբիական դինար),
				'one' => q(լիբիական դինար),
				'other' => q(լիբիական դինար),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(Մարոկկոյի դիրհամ),
				'one' => q(Մարոկկոյի դիրհամ),
				'other' => q(Մարոկկոյի դիրհամ),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(մոլդովական լեյ),
				'one' => q(մոլդովական լեյ),
				'other' => q(մոլդովական լեյ),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Մադագասկարի արիարի),
				'one' => q(Մադագասկարի արիարի),
				'other' => q(Մադագասկարի արիարի),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(մակեդոնական դենար),
				'one' => q(մակեդոնական դենար),
				'other' => q(մակեդոնական դենար),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Մյանմայի կյատ),
				'one' => q(Մյանմայի կյատ),
				'other' => q(Մյանմայի կյատ),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(մոնղոլական տուգրիկ),
				'one' => q(մոնղոլական տուգրիկ),
				'other' => q(մոնղոլական տուգրիկ),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Մակաոյի պատակա),
				'one' => q(Մակաոյի պատակա),
				'other' => q(Մակաոյի պատակա),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(մավրիտանական ուգիյա),
				'one' => q(մավրիտանական ուգիյա),
				'other' => q(մավրիտանական ուգիյա),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(մավրիկյան ռուփի),
				'one' => q(մավրիկյան ռուփի),
				'other' => q(մավրիկյան ռուփի),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(մալդիվյան ռուֆիյա),
				'one' => q(մալդիվյան ռուֆիյա),
				'other' => q(մալդիվյան ռուֆիյա),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(մալավիական կվաչա),
				'one' => q(մալավիական կվաչա),
				'other' => q(մալավիական կվաչա),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(մեքսիկական պեսո),
				'one' => q(մեքսիկական պեսո),
				'other' => q(մեքսիկական պեսո),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(մալայզիական ռինգիտ),
				'one' => q(մալայզիական ռինգիտ),
				'other' => q(մալայզիական ռինգիտ),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(մոզամբիկյան մետիկալ),
				'one' => q(մոզամբիկյան մետիկալ),
				'other' => q(մոզամբիկյան մետիկալ),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(նամիբիական դոլար),
				'one' => q(նամիբիական դոլար),
				'other' => q(նամիբիական դոլար),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(նիգերիական նայրա),
				'one' => q(նիգերիական նայրա),
				'other' => q(նիգերիական նայրա),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(նիկարագուական կորդոբա),
				'one' => q(նիկարագուական կորդոբա),
				'other' => q(նիկարագուական կորդոբա),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(նորվեգական կրոն),
				'one' => q(նորվեգական կրոն),
				'other' => q(նորվեգական կրոն),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Նեպալի ռուփի),
				'one' => q(Նեպալի ռուփի),
				'other' => q(Նեպալի ռուփի),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(նորզելանդական դոլար),
				'one' => q(նորզելանդական դոլար),
				'other' => q(նորզելանդական դոլար),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Օմանի ռիալ),
				'one' => q(Օմանի ռիալ),
				'other' => q(Օմանի ռիալ),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(պանամական բալբոա),
				'one' => q(պանամական բալբոա),
				'other' => q(պանամական բալբոա),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(Պերուի սոլ),
				'one' => q(Պերուի սոլ),
				'other' => q(Պերուի սոլ),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Պապուա Նոր Գվինեայի կինա),
				'one' => q(Պապուա Նոր Գվինեայի կինա),
				'other' => q(Պապուա Նոր Գվինեայի կինա),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ֆիլիպինյան պեսո),
				'one' => q(ֆիլիպինյան պեսո),
				'other' => q(ֆիլիպինյան պեսո),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(պակիստանյան ռուփի),
				'one' => q(պակիստանյան ռուփի),
				'other' => q(պակիստանյան ռուփի),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(լեհական զլոտի),
				'one' => q(լեհական զլոտի),
				'other' => q(լեհական զլոտի),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(պարագվայական գուարանի),
				'one' => q(պարագվայական գուարանի),
				'other' => q(պարագվայական գուարանի),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Կատարի ռիալ),
				'one' => q(Կատարի ռիալ),
				'other' => q(Կատարի ռիալ),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ռումինական լեյ),
				'one' => q(ռումինական լեյ),
				'other' => q(ռումինական լեյ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(սերբական դինար),
				'one' => q(սերբական դինար),
				'other' => q(սերբական դինար),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ռուսական ռուբլի),
				'one' => q(ռուսական ռուբլի),
				'other' => q(ռուսական ռուբլի),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ռուանդական ֆրանկ),
				'one' => q(ռուանդական ֆրանկ),
				'other' => q(ռուանդական ֆրանկ),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(Սաուդյան Արաբիայի ռիալ),
				'one' => q(Սաուդյան Արաբիայի ռիալ),
				'other' => q(Սաուդյան Արաբիայի ռիալ),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Սողոմոնյան կղզիների դոլար),
				'one' => q(Սողոմոնյան կղզիների դոլար),
				'other' => q(Սողոմոնյան կղզիների դոլար),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(սեյշելյան ռուփի),
				'one' => q(սեյշելյան ռուփի),
				'other' => q(սեյշելյան ռուփի),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(սուդանական ֆունտ),
				'one' => q(սուդանական ֆունտ),
				'other' => q(սուդանական ֆունտ),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(շվեդական կրոն),
				'one' => q(շվեդական կրոն),
				'other' => q(շվեդական կրոն),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Սինգապուրի դոլար),
				'one' => q(Սինգապուրի դոլար),
				'other' => q(Սինգապուրի դոլար),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Սուրբ Հեղինեի ֆունտ),
				'one' => q(Սուրբ Հեղինեի ֆունտ),
				'other' => q(Սուրբ Հեղինեի ֆունտ),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Սիեռա Լեոնեի լեոնե),
				'one' => q(Սիեռա Լեոնեի լեոնե),
				'other' => q(Սիեռա Լեոնեի լեոնե),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(սոմալիական շիլինգ),
				'one' => q(սոմալիական շիլինգ),
				'other' => q(սոմալիական շիլինգ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(սուրինամական դոլար),
				'one' => q(սուրինամական դոլար),
				'other' => q(սուրինամական դոլար),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(հարավսուդանական ֆունտ),
				'one' => q(հարավսուդանական ֆունտ),
				'other' => q(հարավսուդանական ֆունտ),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Սան Տոմե և Փրինսիպիի դոբրա),
				'one' => q(Սան Տոմե և Փրինսիպիի դոբրա),
				'other' => q(Սան Տոմե և Փրինսիպիի դոբրա),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(սիրիական ֆունտ),
				'one' => q(սիրիական ֆունտ),
				'other' => q(սիրիական ֆունտ),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(սվազիլենդական լիլանգենի),
				'one' => q(սվազիլենդական լիլանգենի),
				'other' => q(սվազիլենդական լիլանգենի),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(թայլանդական բատ),
				'one' => q(թայլանդական բատ),
				'other' => q(թայլանդական բատ),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(տաջիկական սոմոնի),
				'one' => q(տաջիկական սոմոնի),
				'other' => q(տաջիկական սոմոնի),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(թուրքմենական մանաթ),
				'one' => q(թուրքմենական մանաթ),
				'other' => q(թուրքմենական մանաթ),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(թունիսյան դինար),
				'one' => q(թունիսյան դինար),
				'other' => q(թունիսյան դինար),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Տոնգայի պաանգա),
				'one' => q(Տոնգայի պաանգա),
				'other' => q(Տոնգայի պաանգա),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(թուրքական լիրա),
				'one' => q(թուրքական լիրա),
				'other' => q(թուրքական լիրա),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(Տրինիդադ և Տոբագոյի դոլար),
				'one' => q(Տրինիդադ և Տոբագոյի դոլար),
				'other' => q(Տրինիդադ և Տոբագոյի դոլար),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(թայվանական նոր դոլար),
				'one' => q(թայվանական նոր դոլար),
				'other' => q(թայվանական նոր դոլար),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(տանզանիական շիլինգ),
				'one' => q(տանզանիական շիլինգ),
				'other' => q(տանզանիական շիլինգ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ուկրաինական գրիվնա),
				'one' => q(ուկրաինական գրիվնա),
				'other' => q(ուկրաինական գրիվնա),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ուգանդական շիլինգ),
				'one' => q(ուգանդական շիլինգ),
				'other' => q(ուգանդական շիլինգ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(ԱՄՆ դոլար),
				'one' => q(ԱՄՆ դոլար),
				'other' => q(ԱՄՆ դոլար),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ուրուգվայական պեսո),
				'one' => q(ուրուգվայական պեսո),
				'other' => q(ուրուգվայական պեսո),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ուզբեկական սոմ),
				'one' => q(ուզբեկական սոմ),
				'other' => q(ուզբեկական սոմ),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(վենեսուելական բոլիվար),
				'one' => q(վենեսուելական բոլիվար),
				'other' => q(վենեսուելական բոլիվար),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(վիետնամական դոնգ),
				'one' => q(վիետնամական դոնգ),
				'other' => q(վիետնամական դոնգ),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Վանուատուի վատու),
				'one' => q(Վանուատուի վատու),
				'other' => q(Վանուատուի վատու),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(սամոական տալա),
				'one' => q(սամոական տալա),
				'other' => q(սամոական տալա),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(Կենտրոնական Աֆրիկայի ԿՖԱ ֆրանկ),
				'one' => q(Կենտրոնական Աֆրիկայի ԿՖԱ ֆրանկ),
				'other' => q(Կենտրոնական Աֆրիկայի ԿՖԱ ֆրանկ),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(արևելակարիբյան դոլար),
				'one' => q(արևելակարիբյան դոլար),
				'other' => q(արևելակարիբյան դոլար),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(Արևմտյան Աֆրիկայի ԿՖԱ ֆրանկ),
				'one' => q(Արևմտյան Աֆրիկայի ԿՖԱ ֆրանկ),
				'other' => q(Արևմտյան Աֆրիկայի ԿՖԱ ֆրանկ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ԿՊՖ ֆրանկ),
				'one' => q(ԿՊՖ ֆրանկ),
				'other' => q(ԿՊՖ ֆրանկ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(անհայտ արժույթ),
				'one' => q(\(անհայտ արժույթ\)),
				'other' => q(\(անհայտ արժույթ\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(եմենական ռիալ),
				'one' => q(եմենական ռիալ),
				'other' => q(եմենական ռիալ),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(հարավաֆրիկյան ռանդ),
				'one' => q(հարավաֆրիկյան ռանդ),
				'other' => q(հարավաֆրիկյան ռանդ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Զամբիական կվաչա \(1968–2012\)),
				'one' => q(Զամբիական կվաչա \(1968–2012\)),
				'other' => q(Զամբիական կվաչա \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(զամբիական կվաչա),
				'one' => q(զամբիական կվաչա),
				'other' => q(զամբիական կվաչա),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'հնվ',
							'փտվ',
							'մրտ',
							'ապր',
							'մյս',
							'հնս',
							'հլս',
							'օգս',
							'սեպ',
							'հոկ',
							'նոյ',
							'դեկ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Հ',
							'Փ',
							'Մ',
							'Ա',
							'Մ',
							'Հ',
							'Հ',
							'Օ',
							'Ս',
							'Հ',
							'Ն',
							'Դ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'հունվարի',
							'փետրվարի',
							'մարտի',
							'ապրիլի',
							'մայիսի',
							'հունիսի',
							'հուլիսի',
							'օգոստոսի',
							'սեպտեմբերի',
							'հոկտեմբերի',
							'նոյեմբերի',
							'դեկտեմբերի'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'հնվ',
							'փտվ',
							'մրտ',
							'ապր',
							'մյս',
							'հնս',
							'հլս',
							'օգս',
							'սեպ',
							'հոկ',
							'նոյ',
							'դեկ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Հ',
							'Փ',
							'Մ',
							'Ա',
							'Մ',
							'Հ',
							'Հ',
							'Օ',
							'Ս',
							'Հ',
							'Ն',
							'Դ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'հունվար',
							'փետրվար',
							'մարտ',
							'ապրիլ',
							'մայիս',
							'հունիս',
							'հուլիս',
							'օգոստոս',
							'սեպտեմբեր',
							'հոկտեմբեր',
							'նոյեմբեր',
							'դեկտեմբեր'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'երկ',
						tue => 'երք',
						wed => 'չրք',
						thu => 'հնգ',
						fri => 'ուր',
						sat => 'շբթ',
						sun => 'կիր'
					},
					narrow => {
						mon => 'Ե',
						tue => 'Ե',
						wed => 'Չ',
						thu => 'Հ',
						fri => 'Ո',
						sat => 'Շ',
						sun => 'Կ'
					},
					short => {
						mon => 'եկ',
						tue => 'եք',
						wed => 'չք',
						thu => 'հգ',
						fri => 'ու',
						sat => 'շբ',
						sun => 'կր'
					},
					wide => {
						mon => 'երկուշաբթի',
						tue => 'երեքշաբթի',
						wed => 'չորեքշաբթի',
						thu => 'հինգշաբթի',
						fri => 'ուրբաթ',
						sat => 'շաբաթ',
						sun => 'կիրակի'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'երկ',
						tue => 'երք',
						wed => 'չրք',
						thu => 'հնգ',
						fri => 'ուր',
						sat => 'շբթ',
						sun => 'կիր'
					},
					narrow => {
						mon => 'Ե',
						tue => 'Ե',
						wed => 'Չ',
						thu => 'Հ',
						fri => 'Ո',
						sat => 'Շ',
						sun => 'Կ'
					},
					short => {
						mon => 'եկ',
						tue => 'եք',
						wed => 'չք',
						thu => 'հգ',
						fri => 'ու',
						sat => 'շբ',
						sun => 'կր'
					},
					wide => {
						mon => 'երկուշաբթի',
						tue => 'երեքշաբթի',
						wed => 'չորեքշաբթի',
						thu => 'հինգշաբթի',
						fri => 'ուրբաթ',
						sat => 'շաբաթ',
						sun => 'կիրակի'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-ին եռմս.',
						1 => '2-րդ եռմս.',
						2 => '3-րդ եռմս.',
						3 => '4-րդ եռմս.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-ին եռամսյակ',
						1 => '2-րդ եռամսյակ',
						2 => '3-րդ եռամսյակ',
						3 => '4-րդ եռամսյակ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1-ին եռմս.',
						1 => '2-րդ եռմս.',
						2 => '3-րդ եռմս.',
						3 => '4-րդ եռմս.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-ին եռամսյակ',
						1 => '2-րդ եռամսյակ',
						2 => '3-րդ եռամսյակ',
						3 => '4-րդ եռամսյակ'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'night1' if $time >= 0
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'night1' if $time >= 0
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'midnight' => q{կգ․},
					'evening1' => q{երկ},
					'afternoon1' => q{ցրկ},
					'am' => q{ա},
					'noon' => q{կօ․},
					'morning1' => q{առվ},
					'pm' => q{հ},
					'night1' => q{գշր},
				},
				'wide' => {
					'am' => q{ԿԱ},
					'morning1' => q{առավոտյան},
					'noon' => q{կեսօրին},
					'pm' => q{ԿՀ},
					'night1' => q{գիշերը},
					'midnight' => q{կեսգիշերին},
					'evening1' => q{երեկոյան},
					'afternoon1' => q{ցերեկը},
				},
				'abbreviated' => {
					'afternoon1' => q{ցերեկը},
					'evening1' => q{երեկոյան},
					'midnight' => q{կեսգիշեր},
					'night1' => q{գիշերը},
					'pm' => q{ԿՀ},
					'am' => q{ԿԱ},
					'noon' => q{կեսօր},
					'morning1' => q{առավոտյան},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{ԿԱ},
					'noon' => q{կեսօր},
					'morning1' => q{առավոտ},
					'night1' => q{գիշեր},
					'pm' => q{ԿՀ},
					'evening1' => q{երեկո},
					'midnight' => q{կեսգիշեր},
					'afternoon1' => q{ցերեկ},
				},
				'wide' => {
					'pm' => q{ԿՀ},
					'night1' => q{գիշեր},
					'noon' => q{կեսօր},
					'morning1' => q{առավոտ},
					'am' => q{ԿԱ},
					'afternoon1' => q{ցերեկ},
					'midnight' => q{կեսգիշեր},
					'evening1' => q{երեկո},
				},
				'narrow' => {
					'am' => q{ԿԱ},
					'noon' => q{կեսօր},
					'morning1' => q{առավոտ},
					'night1' => q{գիշեր},
					'pm' => q{ԿՀ},
					'evening1' => q{երեկո},
					'midnight' => q{կեսգիշեր},
					'afternoon1' => q{ցերեկ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'մ.թ.ա.',
				'1' => 'մ.թ.'
			},
			wide => {
				'0' => 'Քրիստոսից առաջ',
				'1' => 'Քրիստոսից հետո'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{d MMMM, y թ. G, EEEE},
			'long' => q{dd MMMM, y թ. G},
			'medium' => q{dd MMM, y թ. G},
			'short' => q{dd.MM.y GGGGG},
		},
		'gregorian' => {
			'full' => q{y թ. MMMM d, EEEE},
			'long' => q{dd MMMM, y թ.},
			'medium' => q{dd MMM, y թ.},
			'short' => q{dd.MM.yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			Bh => q{B h-ին},
			Bhm => q{B h:mm-ին},
			Bhms => q{B h:mm:ss},
			E => q{ccc},
			EBhm => q{E B h:mm-ին},
			EBhms => q{E B h:mm:ss},
			EHm => q{E, HH:mm},
			EHms => q{E, HH:mm:ss},
			Ed => q{d, ccc},
			Ehm => q{E, h:mm a},
			Ehms => q{E, h:mm:ss a},
			Gy => q{G y թ.},
			GyMMM => q{G y թ. MMM},
			GyMMMEd => q{G y թ. MMM d, E},
			GyMMMd => q{d MMM, y թ.},
			H => q{H},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{dd.MM, E},
			MMM => q{LLL},
			MMMEd => q{d MMM, E},
			MMMMW => q{MMM W շաբ},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{MM.y},
			yMEd => q{d.MM.y թ., E},
			yMMM => q{y թ. LLL},
			yMMMEd => q{y թ. MMM d, E},
			yMMMM => q{y թ․ LLLL},
			yMMMd => q{d MMM, y թ.},
			yMd => q{dd.MM.y},
			yQQQ => q{y թ. QQQ},
			yQQQQ => q{y թ. QQQQ},
			yw => q{Y w շաբ},
		},
		'generic' => {
			Bh => q{B h-ին},
			Bhm => q{B h:mm-ին},
			Bhms => q{B h:mm:ss},
			E => q{ccc},
			EBhm => q{E B h:mm-ին},
			EBhms => q{E B h:mm:ss},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, ccc},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y թ․},
			GyMMM => q{G y թ․ MMM},
			GyMMMEd => q{G y թ․ MMM d, E},
			GyMMMd => q{G y թ․ MMM d},
			H => q{H},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{dd.MM, E},
			MMM => q{LLL},
			MMMEd => q{d MMM, E},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y, G},
			yyyy => q{y, G},
			yyyyM => q{G y թ. MM},
			yyyyMEd => q{d.MM.y թ., G, E},
			yyyyMMM => q{G y թ. LLL},
			yyyyMMMEd => q{d MMM, y թ. G, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{d MMM, y թ., G},
			yyyyMd => q{d.M.y թ., G},
			yyyyQQQ => q{G y թ, QQQ},
			yyyyQQQQ => q{G y թ, QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{H–H},
			},
			Hm => {
				H => q{H:mm–H:mm},
				m => q{H:mm–H:mm},
			},
			Hmv => {
				H => q{H:mm–H:mm, v},
				m => q{H:mm–H:mm, v},
			},
			Hv => {
				H => q{H–H, v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, MMM dd – E, MMM dd},
				d => q{E, MMM dd – E, MMM dd},
			},
			MMMd => {
				M => q{MMM dd – MMM dd},
				d => q{MMM dd–dd},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{ccc, dd.MM.y – ccc, dd.MM.y},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y},
			},
			yMMM => {
				M => q{y թ. MMM – MMM},
				y => q{y MMM – y MMM},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y թ.},
				d => q{E, d MMM – E, d MMM, y թ.},
				y => q{E, d MMM, y – E, d MMM, y թ.},
			},
			yMMMM => {
				M => q{y թ․ LLLL – LLLL},
				y => q{y թ․ LLLL – y թ․ LLLL},
			},
			yMMMd => {
				M => q{dd MMM – dd MMM, y թ.},
				d => q{dd–dd MMM, y թ.},
				y => q{dd MMM, y թ․ – dd MMM, y թ.},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
		'generic' => {
			H => {
				H => q{H–H},
			},
			Hm => {
				H => q{H:mm–H:mm},
				m => q{H:mm–H:mm},
			},
			Hmv => {
				H => q{H:mm–H:mm v},
				m => q{H:mm–H:mm v},
			},
			Hv => {
				H => q{H–H v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, MMM dd – E, MMM dd},
				d => q{E, MMM dd – E, MMM dd},
			},
			MMMd => {
				M => q{MMM dd – MMM dd},
				d => q{MMM dd–dd},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			yMEd => {
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			yMMM => {
				M => q{MMM–MMM y թ. G},
				y => q{MMM y – MMM y թ. G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y թ. G},
				d => q{E, d MMM – E, d MMM, y թ. G},
				y => q{E, d MMM, y – E, d MMM, y թ. G},
			},
			yMMMM => {
				M => q{G y թ. MMM – MMM},
				y => q{MMM y – MMM y թ G},
			},
			yMMMd => {
				M => q{dd MMM – dd MMM, y թ. G},
				d => q{dd–dd MMM, y թ. G},
				y => q{dd MMM, y – dd MMM, y թ. G},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0}),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#Աֆղանստանի ժամանակ#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Աբիջան#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Աքրա#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Ադիս Աբեբա#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Ալժիր#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Ասմերա#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Բամակո#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Բանգի#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Բանժուլ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Բիսաու#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Բլանթայր#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Բրազավիլ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Բուժումբուրա#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Կահիրե#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Կասաբլանկա#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Սեուտա#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Կոնակրի#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Դաքար#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Դար-Էս-Սալամ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Ջիբութի#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Դուալա#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Էլ Այուն#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Ֆրիթաուն#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Գաբորոնե#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Հարարե#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Յոհանեսբուրգ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Ջուբա#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Կամպալա#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Խարթում#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Կիգալի#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Կինշասա#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Լագոս#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Լիբրևիլ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Լոմե#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Լուանդա#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Լուբումբաշի#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Լուսակա#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Մալաբո#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Մապուտու#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Մասերու#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Մբաբանե#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Մոգադիշո#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Մոնրովիա#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Նայրոբի#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Նջամենա#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Նիամեյ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Նուակշոտ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Ուագադուգու#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Պորտո Նովո#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Սան Տոմե#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Տրիպոլի#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Թունիս#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Վինդհուկ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Կենտրոնական Աֆրիկայի ժամանակ#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Արևելյան Աֆրիկայի ժամանակ#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Հարավային Աֆրիկայի ժամանակ#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Արևմտյան Աֆրիկայի ամառային ժամանակ#,
				'generic' => q#Արևմտյան Աֆրիկայի ժամանակ#,
				'standard' => q#Արևմտյան Աֆրիկայի ստանդարտ ժամանակ#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Ալյասկայի ամառային ժամանակ#,
				'generic' => q#Ալյասկայի ժամանակ#,
				'standard' => q#Ալյասկայի ստանդարտ ժամանակ#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Ամազոնյան ամառային ժամանակ#,
				'generic' => q#Ամազոնյան ժամանակ#,
				'standard' => q#Ամազոնյան ստանդարտ ժամանակ#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Ադակ կղզի#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Անքորիջ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Անգուիլա#,
		},
		'America/Antigua' => {
			exemplarCity => q#Անտիգուա#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Արագուաինա#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Լա Ռիոխա#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Ռիո Գալյեգոս#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Սալտա#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Սան Խուան#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Սան Լուիս#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Տուկուման#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ուշուայա#,
		},
		'America/Aruba' => {
			exemplarCity => q#Արուբա#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Ասունսյոն#,
		},
		'America/Bahia' => {
			exemplarCity => q#Բաիյա#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Բաիյա Բանդերաս#,
		},
		'America/Barbados' => {
			exemplarCity => q#Բարբադոս#,
		},
		'America/Belem' => {
			exemplarCity => q#Բելեմ#,
		},
		'America/Belize' => {
			exemplarCity => q#Բելիզ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Բլանկ-Սաբլոն#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Բոա Վիստա#,
		},
		'America/Bogota' => {
			exemplarCity => q#Բոգոտա#,
		},
		'America/Boise' => {
			exemplarCity => q#Բոյսե#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Բուենոս Այրես#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Քեմբրիջ Բեյ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Կամպու Գրանդի#,
		},
		'America/Cancun' => {
			exemplarCity => q#Կանկուն#,
		},
		'America/Caracas' => {
			exemplarCity => q#Կարակաս#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Կատամարկա#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Կայեն#,
		},
		'America/Cayman' => {
			exemplarCity => q#Կայման կղզիներ#,
		},
		'America/Chicago' => {
			exemplarCity => q#Չիկագո#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Չիուաուա#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Ատիկոկան#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Կորդովա#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Կոստա Ռիկա#,
		},
		'America/Creston' => {
			exemplarCity => q#Քրեսթոն#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Կույաբա#,
		},
		'America/Curacao' => {
			exemplarCity => q#Կյուրասաո#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Դենմարքսհավն#,
		},
		'America/Dawson' => {
			exemplarCity => q#Դոուսոն#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Դոուսոն Քրիք#,
		},
		'America/Denver' => {
			exemplarCity => q#Դենվեր#,
		},
		'America/Detroit' => {
			exemplarCity => q#Դետրոյթ#,
		},
		'America/Dominica' => {
			exemplarCity => q#Դոմինիկա#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Էդմոնտոն#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Էյրունեպե#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Սալվադոր#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Ֆորտ Նելսոն#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Ֆորտալեզա#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Գլեյս Բեյ#,
		},
		'America/Godthab' => {
			exemplarCity => q#Նուուկ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Գուս Բեյ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Գրանդ Տյորք#,
		},
		'America/Grenada' => {
			exemplarCity => q#Գրենադա#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Գվադելուպա#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Գվատեմալա#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Գուայակիլ#,
		},
		'America/Guyana' => {
			exemplarCity => q#Գայանա#,
		},
		'America/Halifax' => {
			exemplarCity => q#Հալիֆաքս#,
		},
		'America/Havana' => {
			exemplarCity => q#Հավանա#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Էրմոսիլյո#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Նոքս, Ինդիանա#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Մարենգո, Ինդիանա#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Պետերսբուրգ, Ինդիանա#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Թել Սիթի, Ինդիանա#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Վիվեյ, Ինդիանա#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Վինսենս, Ինդիանա#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Վինամակ, Ինդիանա#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Ինդիանապոլիս#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Ինուվիկ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Իկալուիտ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ճամայկա#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Ժուժույ#,
		},
		'America/Juneau' => {
			exemplarCity => q#Ջունո#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Մոնտիսելո, Կենտուկի#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Կրալենդեյկ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Լա Պաս#,
		},
		'America/Lima' => {
			exemplarCity => q#Լիմա#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Լոս Անջելես#,
		},
		'America/Louisville' => {
			exemplarCity => q#Լուիսվիլ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Լոուեր Պրինսես Քվորթեր#,
		},
		'America/Maceio' => {
			exemplarCity => q#Մասեյո#,
		},
		'America/Managua' => {
			exemplarCity => q#Մանագուա#,
		},
		'America/Manaus' => {
			exemplarCity => q#Մանաուս#,
		},
		'America/Marigot' => {
			exemplarCity => q#Մարիգո#,
		},
		'America/Martinique' => {
			exemplarCity => q#Մարտինիկա#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Մատամորոս#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Մազաթլան#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Մենդոսա#,
		},
		'America/Menominee' => {
			exemplarCity => q#Մենոմինի#,
		},
		'America/Merida' => {
			exemplarCity => q#Մերիդա#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Մետլակատլա#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Մեխիկո#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Միքելոն#,
		},
		'America/Moncton' => {
			exemplarCity => q#Մոնկտոն#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Մոնտեռեյ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Մոնտեվիդեո#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Մոնսեռատ#,
		},
		'America/Nassau' => {
			exemplarCity => q#Նասաու#,
		},
		'America/New_York' => {
			exemplarCity => q#Նյու Յորք#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Նիպիգոն#,
		},
		'America/Nome' => {
			exemplarCity => q#Նոմ#,
		},
		'America/Noronha' => {
			exemplarCity => q#Նորոնյա#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Բոյլա, Հյուսիսային Դակոտա#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Հյուսիսային Դակոտա - Կենտրոն#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Նյու Սալեմ, Հյուսիսային Դակոտա#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Օխինագա#,
		},
		'America/Panama' => {
			exemplarCity => q#Պանամա#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Պանգնիրտանգ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Պարամարիբո#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Ֆինիքս#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Պորտ-օ-Պրենս#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Պորտ-օֆ-Սփեյն#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Պորտու Վելյու#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Պուերտո Ռիկո#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Պունտա Արենաս#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Ռեյնի Ռիվեր#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ռանկին Ինլեթ#,
		},
		'America/Recife' => {
			exemplarCity => q#Ռեսիֆի#,
		},
		'America/Regina' => {
			exemplarCity => q#Ռեջայնա#,
		},
		'America/Resolute' => {
			exemplarCity => q#Ռեզոլյուտ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Ռիու Բրանկու#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Սանտա Իզաբել#,
		},
		'America/Santarem' => {
			exemplarCity => q#Սանտարեմ#,
		},
		'America/Santiago' => {
			exemplarCity => q#Սանտյագո#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Սանտո Դոմինգո#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Սան Պաուլու#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Սկորսբիսուն#,
		},
		'America/Sitka' => {
			exemplarCity => q#Սիտկա#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Սեն Բարտելմի#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Սենթ Ջոնս#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Սենթ Քիտս#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Սենթ Լյուսիա#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Սենթ Թոմաս#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Սենթ Վինսենթ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Սվիֆթ Քարենթ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Տեգուսիգալպա#,
		},
		'America/Thule' => {
			exemplarCity => q#Տուլե#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Թանդեր Բեյ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Տիխուանա#,
		},
		'America/Toronto' => {
			exemplarCity => q#Տորոնտո#,
		},
		'America/Tortola' => {
			exemplarCity => q#Թորթոլա#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Վանկուվեր#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Ուայթհորս#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Վինիպեգ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Յակուտատ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Յելոունայֆ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Կենտրոնական Ամերիկայի ամառային ժամանակ#,
				'generic' => q#Կենտրոնական Ամերիկայի ժամանակ#,
				'standard' => q#Կենտրոնական Ամերիկայի ստանդարտ ժամանակ#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Արևելյան Ամերիկայի ամառային ժամանակ#,
				'generic' => q#Արևելյան Ամերիկայի ժամանակ#,
				'standard' => q#Արևելյան Ամերիկայի ստանդարտ ժամանակ#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Լեռնային ամառային ժամանակ (ԱՄՆ)#,
				'generic' => q#Լեռնային ժամանակ (ԱՄՆ)#,
				'standard' => q#Լեռնային ստանդարտ ժամանակ (ԱՄՆ)#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Խաղաղօվկիանոսյան ամառային ժամանակ#,
				'generic' => q#Խաղաղօվկիանոսյան ժամանակ#,
				'standard' => q#Խաղաղօվկիանոսյան ստանդարտ ժամանակ#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Քեյսի#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Դեյվիս#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Դյումոն դ’Յուրվիլ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Մակկուորի կղզի#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Մոուսոն#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Մակ-Մերդո#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Պալմեր#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ռոտերա#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Սյովա#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Տրոլլ#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Վոստոկ#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Ապիայի ամառային ժամանակ#,
				'generic' => q#Ապիայի ժամանակ#,
				'standard' => q#Ապիայի ստանդարտ ժամանակ#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Սաուդյան Արաբիայի ամառային ժամանակ#,
				'generic' => q#Սաուդյան Արաբիայի ժամանակ#,
				'standard' => q#Սաուդյան Արաբիայի ստանդարտ ժամանակ#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Լոնգյիր#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Արգենտինայի ամառային ժամանակ#,
				'generic' => q#Արգենտինայի ժամանակ#,
				'standard' => q#Արգենտինայի ստնադարտ ժամանակ#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Արևմտյան Արգենտինայի ամառային ժամանակ#,
				'generic' => q#Արևմտյան Արգենտինայի ժամանակ#,
				'standard' => q#Արևմտյան Արգենտինայի ստնադարտ ժամանակ#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Հայաստանի ամառային ժամանակ#,
				'generic' => q#Հայաստանի ժամանակ#,
				'standard' => q#Հայաստանի ստանդարտ ժամանակ#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Ադեն#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Ալմաթի#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Ամման#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Անադիր#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Ակտաու#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Ակտոբե#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Աշխաբադ#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Ատիրաու#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Բաղդադ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Բահրեյն#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Բաքու#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Բանգկոկ#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Բառնաուլ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Բեյրութ#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Բիշքեկ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Բրունեյ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Կալկուտա#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Չիտա#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Չոյբալսան#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Կոլոմբո#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Դամասկոս#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Դաքքա#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Դիլի#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Դուբայ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Դուշանբե#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Ֆամագուստա#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Գազա#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Հեբրոն#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Հոնկոնգ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Հովդ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Իրկուտսկ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Ջակարտա#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Ջայպուրա#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Երուսաղեմ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Քաբուլ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Կամչատկա#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Կարաչի#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Կատմանդու#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Խանդիգա#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Կրասնոյարսկ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Կուալա Լումպուր#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Կուչինգ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Քուվեյթ#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Մակաո#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Մագադան#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Մակասար#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Մանիլա#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Մասկատ#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Նիկոսիա#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Նովոկուզնեցկ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Նովոսիբիրսկ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Օմսկ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Ուրալսկ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Պնոմպեն#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Պոնտիանակ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Փխենյան#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Կատար#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Կիզիլորդա#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Ռանգուն#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Էր Ռիադ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Հոշիմին#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Սախալին#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Սամարղանդ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Սեուլ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Շանհայ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Սինգապուր#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Սրեդնեկոլիմսկ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Թայպեյ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Տաշքենդ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Թբիլիսի#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Թեհրան#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Տհիմպհու#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Տոկիո#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Տոմսկ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Ուլան Բատոր#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Ուրումչի#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Ուստ-Ներա#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Վյենտյան#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Վլադիվոստոկ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Յակուտսկ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Եկատերինբուրգ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Երևան#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Ատլանտյան ամառային ժամանակ#,
				'generic' => q#Ատլանտյան ժամանակ#,
				'standard' => q#Ատլանտյան ստանդարտ ժամանակ#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Ազորյան կղզիներ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Բերմուդներ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Կանարյան կղզիներ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Կաբո Վերդե#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Ֆարերյան կղզիներ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Մադեյրա#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Ռեյկյավիկ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Հարավային Ջորջիա#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Սուրբ Հեղինեի կղզի#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Սթենլի#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Ադելաիդա#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Բրիսբեն#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Բրոքեն Հիլ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Քերի#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Դարվին#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Յուկլա#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Հոբարտ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Լինդեման#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Լորդ Հաու կղզի#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Մելբուրն#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Պերթ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Սիդնեյ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Կենտրոնական Ավստրալիայի ամառային ժամանակ#,
				'generic' => q#Կենտրոնական Ավստրալիայի ժամանակ#,
				'standard' => q#Կենտրոնական Ավստրալիայի ստանդարտ ժամանակ#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Կենտրոնական Ավստրալիայի արևմտյան ամառային ժամանակ#,
				'generic' => q#Կենտրոնական Ավստրալիայի արևմտյան ժամանակ#,
				'standard' => q#Կենտրոնական Ավստրալիայի արևմտյան ստանդարտ ժամանակ#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Արևելյան Ավստրալիայի ամառային ժամանակ#,
				'generic' => q#Արևելյան Ավստրալիայի ժամանակ#,
				'standard' => q#Արևելյան Ավստրալիայի ստանդարտ ժամանակ#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Արևմտյան Ավստրալիայի ամառային ժամանակ#,
				'generic' => q#Արևմտյան Ավստրալիայի ժամանակ#,
				'standard' => q#Արևմտյան Ավստրալիայի ստանդարտ ժամանակ#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Ադրբեջանի ամառային ժամանակ#,
				'generic' => q#Ադրբեջանի ժամանակ#,
				'standard' => q#Ադրբեջանի ստանդարտ ժամանակ#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Ազորյան կղզիների ամառային ժամանակ#,
				'generic' => q#Ազորյան կղզիների ժամանակ#,
				'standard' => q#Ազորյան կղզիների ստանդարտ ժամանակ#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Բանգլադեշի ամառային ժամանակ#,
				'generic' => q#Բանգլադեշի ժամանակ#,
				'standard' => q#Բանգլադեշի ստանդարտ ժամանակ#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Բութանի ժամանակ#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Բոլիվիայի ժամանակ#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Բրազիլիայի ամառային ժամանակ#,
				'generic' => q#Բրազիլիայի ժամանակ#,
				'standard' => q#Բրազիլիայի ստանդարտ ժամանակ#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Բրունեյի ժամանակ#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Կաբո Վերդեի ամառային ժամանակ#,
				'generic' => q#Կաբո Վերդեի ժամանակ#,
				'standard' => q#Կաբո Վերդեի ստանդարտ ժամանակ#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Չամոռոյի ժամանակ#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Չաթեմ կղզու ամառային ժամանակ#,
				'generic' => q#Չաթեմ կղզու ժամանակ#,
				'standard' => q#Չաթեմ կղզու ստանդարտ ժամանակ#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Չիլիի ամառային ժամանակ#,
				'generic' => q#Չիլիի ժամանակ#,
				'standard' => q#Չիլիի ստանդարտ ժամանակ#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Չինաստանի ամառային ժամանակ#,
				'generic' => q#Չինաստանի ժամանակ#,
				'standard' => q#Չինաստանի ստանդարտ ժամանակ#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Չոյբալսանի ամառային ժամանակ#,
				'generic' => q#Չոյբալսանի ժամանակ#,
				'standard' => q#Չոյբալսանի ստանդարտ ժամանակ#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Սուրբ Ծննդյան կղզու ժամանակ#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Կոկոսյան կղզիների ժամանակ#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Կոլումբիայի ամառային ժամանակ#,
				'generic' => q#Կոլումբիայի ժամանակ#,
				'standard' => q#Կոլումբիայի ստանդարտ ժամանակ#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Կուկի կղզիների կիսաամառային ժամանակ#,
				'generic' => q#Կուկի կղզիների ժամանակ#,
				'standard' => q#Կուկի կղզիների ստանդարտ ժամանակ#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Կուբայի ամառային ժամանակ#,
				'generic' => q#Կուբայի ժամանակ#,
				'standard' => q#Կուբայի ստանդարտ ժամանակ#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Դեյվիսի ժամանակ#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Դյումոն դ’Յուրվիլի ժամանակ#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Արևելյան Թիմորի ժամանակ#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Զատկի կղզու ամառային ժամանակ#,
				'generic' => q#Զատկի կղզու ժամանակ#,
				'standard' => q#Զատկի կղզու ստանդարտ ժամանակ#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Էկվադորի ժամանակ#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Համաշխարհային կոորդինացված ժամանակ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Անհայտ քաղաք#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Ամստերդամ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Անդորրա#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Աստրախան#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Աթենք#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Բելգրադ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Բեռլին#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Բրատիսլավա#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Բրյուսել#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Բուխարեստ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Բուդապեշտ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Բյուզինգեն#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Քիշնև#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Կոպենհագեն#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Դուբլին#,
			long => {
				'daylight' => q#Իռլանդական ստանդարտ ժամանակ#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Ջիբրալթար#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Գերնսի#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Հելսինկի#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Մեն կղզի#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Ստամբուլ#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Ջերսի#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Կալինինգրադ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Կիև#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Կիրով#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Լիսաբոն#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Լյուբլյանա#,
		},
		'Europe/London' => {
			exemplarCity => q#Լոնդոն#,
			long => {
				'daylight' => q#Բրիտանական ամառային ժամանակ#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Լյուքսեմբուրգ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Մադրիդ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Մալթա#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Մարիեհամն#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Մինսկ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Մոնակո#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Մոսկվա#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Օսլո#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Փարիզ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Պոդգորիցա#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Պրահա#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Ռիգա#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Հռոմ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Սամարա#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Սան Մարինո#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Սարաևո#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Սարատով#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Սիմֆերոպոլ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Սկոպյե#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Սոֆիա#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Ստոկհոլմ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Տալլին#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Տիրանա#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ուլյանովսկ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ուժգորոդ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Վադուց#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Վատիկան#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Վիեննա#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Վիլնյուս#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Վոլգոգրադ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Վարշավա#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Զագրեբ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Զապոռոժյե#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Ցյուրիխ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Կենտրոնական Եվրոպայի ամառային ժամանակ#,
				'generic' => q#Կենտրոնական Եվրոպայի ժամանակ#,
				'standard' => q#Կենտրոնական Եվրոպայի ստանդարտ ժամանակ#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Արևելյան Եվրոպայի ամառային ժամանակ#,
				'generic' => q#Արևելյան Եվրոպայի ժամանակ#,
				'standard' => q#Արևելյան Եվրոպայի ստանդարտ ժամանակ#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Մինսկի ժամանակ#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Արևմտյան Եվրոպայի ամառային ժամանակ#,
				'generic' => q#Արևմտյան Եվրոպայի ժամանակ#,
				'standard' => q#Արևմտյան Եվրոպայի ստանդարտ ժամանակ#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Ֆոլքլենդյան կղզիների ամառային ժամանակ#,
				'generic' => q#Ֆոլքլենդյան կղզիների ժամանակ#,
				'standard' => q#Ֆոլքլենդյան կղզիների ստանդարտ ժամանակ#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Ֆիջիի ամառային ժամանակ#,
				'generic' => q#Ֆիջիի ժամանակ#,
				'standard' => q#Ֆիջիի ստանդարտ ժամանակ#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Ֆրանսիական Գվիանայի ժամանակ#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Ֆրանսիական հարավային և անտարկտիդյան ժամանակ#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Գրինվիչի ժամանակ#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Գալապագոսյան կղզիների ժամանակ#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Գամբյե կղզիների ժամանակ#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Վրաստանի ամառային ժամանակ#,
				'generic' => q#Վրաստանի ժամանակ#,
				'standard' => q#Վրաստանի ստանդարտ ժամանակ#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Ջիլբերթի կղզիների ժամանակ#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Արևելյան Գրենլանդիայի ամառային ժամանակ#,
				'generic' => q#Արևելյան Գրենլանդիայի ժամանակ#,
				'standard' => q#Արևելյան Գրենլանդիայի ստանդարտ ժամանակ#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Արևմտյան Գրենլանդիայի ամառային ժամանակ#,
				'generic' => q#Արևմտյան Գրենլանդիայի ժամանակ#,
				'standard' => q#Արևմտյան Գրենլանդիայի ստանդարտ ժամանակ#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Պարսից ծոցի ստանդարտ ժամանակ#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Գայանայի ժամանակ#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Հավայան-ալեության ամառային ժամանակ#,
				'generic' => q#Հավայան-ալեության ժամանակ#,
				'standard' => q#Հավայան-ալեության ստանդարտ ժամանակ#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Հոնկոնգի ամառային ժամանակ#,
				'generic' => q#Հոնկոնգի ժամանակ#,
				'standard' => q#Հոնկոնգի ստանդարտ ժամանակ#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Հովդի ամառային ժամանակ#,
				'generic' => q#Հովդի ժամանակ#,
				'standard' => q#Հովդի ստանդարտ ժամանակ#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Հնդկաստանի ստանդարտ ժամանակ#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Անտանանարիվու#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Չագոս#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Սուրբ Ծննդյան կղզի#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Կոկոսյան կղզիներ#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Կոմորյան կղզիներ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Կերգելեն#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Մաէ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Մալդիվներ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Մավրիկիոս#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Մայոթ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Ռեյունիոն#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Հնդկական օվկիանոսի ժամանակ#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Հնդկաչինական ժամանակ#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Կենտրոնական Ինդոնեզիայի ժամանակ#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Արևելյան Ինդոնեզիայի ժամանակ#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Արևմտյան Ինդոնեզիայի ժամանակ#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Իրանի ամառային ժամանակ#,
				'generic' => q#Իրանի ժամանակ#,
				'standard' => q#Իրանի ստանդարտ ժամանակ#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Իրկուտսկի ամառային ժամանակ#,
				'generic' => q#Իրկուտսկի ժամանակ#,
				'standard' => q#Իրկուտսկի ստանդարտ ժամանակ#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Իսրայելի ամառային ժամանակ#,
				'generic' => q#Իսրայելի ժամանակ#,
				'standard' => q#Իսրայելի ստանդարտ ժամանակ#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Ճապոնիայի ամառային ժամանակ#,
				'generic' => q#Ճապոնիայի ժամանակ#,
				'standard' => q#Ճապոնիայի ստանդարտ ժամանակ#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Արևելյան Ղազախստանի ժամանակ#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Արևմտյան Ղազախստանի ժամանակ#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Կորեայի ամառային ժամանակ#,
				'generic' => q#Կորեայի ժամանակ#,
				'standard' => q#Կորեայի ստանդարտ ժամանակ#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Կոսրաեյի ժամանակ#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Կրասնոյարսկի ամառային ժամանակ#,
				'generic' => q#Կրասնոյարսկի ժամանակ#,
				'standard' => q#Կրասնոյարսկի ստանդարտ ժամանակ#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Ղրղզստանի ժամանակ#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Լայն կղզիների ժամանակ#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Լորդ Հաուի ամառային ժամանակ#,
				'generic' => q#Լորդ Հաուի ժամանակ#,
				'standard' => q#Լորդ Հաուի ստանդարտ ժամանակ#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Մակկուորի կղզու ժամանակ#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Մագադանի ամառային ժամանակ#,
				'generic' => q#Մագադանի ժամանակ#,
				'standard' => q#Մագադանի ստանդարտ ժամանակ#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Մալայզիայի ժամանակ#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Մալդիվների ժամանակ#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Մարկիզյան կղզիների ժամանակ#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Մարշալյան կղզիների ժամանակ#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Մավրիկիոսի ամառային ժամանակ#,
				'generic' => q#Մավրիկիոսի ժամանակ#,
				'standard' => q#Մավրիկիոսի ստանդարտ ժամանակ#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Մոուսոնի ժամանակ#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Հյուսիսարևմտյան Մեքսիկայի ամառային ժամանակ#,
				'generic' => q#Հյուսիսարևմտյան Մեքսիկայի ժամանակ#,
				'standard' => q#Հյուսիսարևմտյան Մեքսիկայի ստանդարտ ժամանակ#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Մեքսիկայի խաղաղօվկիանոսյան ամառային ժամանակ#,
				'generic' => q#Մեքսիկայի խաղաղօվկիանոսյան ժամանակ#,
				'standard' => q#Մեքսիկայի խաղաղօվկիանոսյան ստանդարտ ժամանակ#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Ուլան Բատորի ամառային ժամանակ#,
				'generic' => q#Ուլան Բատորի ժամանակ#,
				'standard' => q#Ուլան Բատորի ստանդարտ ժամանակ#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Մոսկվայի ամառային ժամանակ#,
				'generic' => q#Մոսկվայի ժամանակ#,
				'standard' => q#Մոսկվայի ստանդարտ ժամանակ#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Մյանմայի ժամանակ#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Նաուրուի ժամանակ#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Նեպալի ժամանակ#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Նոր Կալեդոնիայի ամառային ժամանակ#,
				'generic' => q#Նոր Կալեդոնիայի ժամանակ#,
				'standard' => q#Նոր Կալեդոնիայի ստանդարտ ժամանակ#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Նոր Զելանդիայի ամառային ժամանակ#,
				'generic' => q#Նոր Զելանդիայի ժամանակ#,
				'standard' => q#Նոր Զելանդիայի ստանդարտ ժամանակ#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Նյուֆաունդլենդի ամառային ժամանակ#,
				'generic' => q#Նյուֆաունդլենդի ժամանակ#,
				'standard' => q#Նյուֆաունդլենդի ստանդարտ ժամանակ#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Նիուեյի ժամանակ#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#Նորֆոլկ կղզու ժամանակ#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Ֆերնանդու դի Նորոնյայի ամառային ժամանակ#,
				'generic' => q#Ֆերնանդու դի Նորոնյայի ժամանակ#,
				'standard' => q#Ֆերնանդու դի Նորոնյայի ստանդարտ ժամանակ#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Նովոսիբիրսկի ամառային ժամանակ#,
				'generic' => q#Նովոսիբիրսկի ժամանակ#,
				'standard' => q#Նովոսիբիրսկի ստանդարտ ժամանակ#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Օմսկի ամառային ժամանակ#,
				'generic' => q#Օմսկի ժամանակ#,
				'standard' => q#Օմսկի ստանդարտ ժամանակ#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Ապիա#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Օքլենդ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Բուգենվիլ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Չաթեմ կղզի#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Զատկի կղզի#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Էֆատե#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Էնդերբերի կղզի#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Ֆակաոֆո#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Ֆիջի#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Ֆունաֆուտի#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Գալապագոսյան կղզիներ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Գամբյե կղզիներ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Գուադալկանալ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Գուամ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Հոնոլուլու#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Ջոնսթոն#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Կիրիտիմատի#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Կոսրաե#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Քվաջալեյն#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Մաջուրո#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Մարկիզյան կղզիներ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Միդուեյ կղզի#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Նաուրու#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Նիուե#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Նորֆոլկ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Նումեա#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Պագո Պագո#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Պալաու#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Պիտկեռն#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Պոնպեի#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Պորտ Մորսբի#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Ռարոտոնգա#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Սայպան#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Թաիթի#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Տարավա#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Տոնգատապու#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Չուուկ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Ուեյք կղզի#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Ուոլիս#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Պակիստանի ամառային ժամանակ#,
				'generic' => q#Պակիստանի ժամանակ#,
				'standard' => q#Պակիստանի ստանդարտ ժամանակ#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Պալաույի ժամանակ#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Պապուա Նոր Գվինեայի ժամանակ#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Պարագվայի ամառային ժամանակ#,
				'generic' => q#Պարագվայի ժամանակ#,
				'standard' => q#Պարագվայի ստանդարտ ժամանակ#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Պերուի ամառային ժամանակ#,
				'generic' => q#Պերուի ժամանակ#,
				'standard' => q#Պերուի ստանդարտ ժամանակ#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Ֆիլիպինների ամառային ժամանակ#,
				'generic' => q#Ֆիլիպինների ժամանակ#,
				'standard' => q#Ֆիլիպինների ստանդարտ ժամանակ#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Ֆինիքս կղզիների ժամանակ#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Սեն Պիեռ և Միքելոնի ամառային ժամանակ#,
				'generic' => q#Սեն Պիեռ և Միքելոնի ժամանակ#,
				'standard' => q#Սեն Պիեռ և Միքելոնի ստանդարտ ժամանակ#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Պիտկեռնի ժամանակ#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Պոնապե կղզու ժամանակ#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Փխենյանի ժամանակ#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Ռեյունիոնի ժամանակ#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ռոտերայի ժամանակ#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Սախալինի ամառային ժամանակ#,
				'generic' => q#Սախալինի ժամանակ#,
				'standard' => q#Սախալինի ստանդարտ ժամանակ#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Սամոայի ամառային ժամանակ#,
				'generic' => q#Սամոայի ժամանակ#,
				'standard' => q#Սամոայի ստանդարտ ժամանակ#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Սեյշելյան կղզիների ժամանակ#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Սինգապուրի ժամանակ#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Սողոմոնի կղզիների ժամանակ#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Հարավային Ջորջիայի ժամանակ#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Սուրինամի ժամանակ#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Սյովայի ժամանակ#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Թաիթիի ժամանակ#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Թայպեյի ամառային ժամանակ#,
				'generic' => q#Թայպեյի ժամանակ#,
				'standard' => q#Թայպեյի ստանդարտ ժամանակ#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Տաջիկստանի ժամանակ#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Տոկելաույի ժամանակ#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Տոնգայի ամառային ժամանակ#,
				'generic' => q#Տոնգայի ժամանակ#,
				'standard' => q#Տոնգայի ստանդարտ ժամանակ#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Տրուկի ժամանակ#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Թուրքմենստանի ամառային ժամանակ#,
				'generic' => q#Թուրքմենստանի ժամանակ#,
				'standard' => q#Թուրքմենստանի ստանդարտ ժամանակ#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Տուվալույի ժամանակ#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Ուրուգվայի ամառային ժամանակ#,
				'generic' => q#Ուրուգվայի ժամանակ#,
				'standard' => q#Ուրուգվայի ստանդարտ ժամանակ#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Ուզբեկստանի ամառային ժամանակ#,
				'generic' => q#Ուզբեկստանի ժամանակ#,
				'standard' => q#Ուզբեկստանի ստանդարտ ժամանակ#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Վանուատույի ամառային ժամանակ#,
				'generic' => q#Վանուատույի ժամանակ#,
				'standard' => q#Վանուատույի ստանդարտ ժամանակ#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Վենեսուելայի ժամանակ#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Վլադիվոստոկի ամառային ժամանակ#,
				'generic' => q#Վլադիվոստոկի ժամանակ#,
				'standard' => q#Վլադիվոստոկի ստանդարտ ժամանակ#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Վոլգոգրադի ամառային ժամանակ#,
				'generic' => q#Վոլգոգրադի ժամանակ#,
				'standard' => q#Վոլգոգրադի ստանդարտ ժամանակ#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Վոստոկի ժամանակ#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Ուեյք կղզու ժամանակ#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Ուոլիս և Ֆուտունայի ժամանակ#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Յակուտսկի ամառային ժամանակ#,
				'generic' => q#Յակուտսկի ժամանակ#,
				'standard' => q#Յակուտսկի ստանդարտ ժամանակ#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Եկատերինբուրգի ամառային ժամանակ#,
				'generic' => q#Եկատերինբուրգի ժամանակ#,
				'standard' => q#Եկատերինբուրգի ստանդարտ ժամանակ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
