use strict;
use warnings FATAL => 'all';

package MarpaX::ESLIF::Value::Type;

# ABSTRACT: ESLIF Value Types

our $AUTHORITY = 'cpan:JDDPAUSE'; # AUTHORITY


use Carp qw/croak/;

our $VERSION = '1.0.48'; # VERSION

# This section should be replaced on-the-fly at build time
# AUTOLOAD

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

MarpaX::ESLIF::Value::Type - ESLIF Value Types

=head1 VERSION

version 1.0.48

=head1 SYNOPSIS

  my $valueType;
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_UNDEF;         #  0
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_CHAR;          #  1
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_SHORT;         #  2
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_INT;           #  3
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_LONG;          #  4
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_FLOAT;         #  5
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_DOUBLE;        #  6
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_PTR;           #  7
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_PTR_SHALLOW;   #  8
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_ARRAY;         #  9
  $valueType = MarpaX::ESLIF::Value::Type::MARPAESLIF_VALUE_TYPE_ARRAY_SHALLOW; # 10

=head1 DESCRIPTION

ESLIF values are mapped to constants. This module is giving access to them.

=head1 AUTHOR

Jean-Damien Durand <jeandamiendurand@free.fr>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Jean-Damien Durand.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
