# THIS FILE WAS GENERATED BY src/bootstrap.pl IN PEGEX DISTRIBUTION.

##
# name:      Pegex::Grammar::Bootstrap
# abstract:  Pegex Grammar Class (to Bootstrap TestML)
# author:    Ingy döt Net <ingy@cpan.org>
# license:   perl
# copyright: 2010, 2011

package Pegex::Grammar::Bootstrap;
use Pegex::Base -base;

# Grammar can be in text or tree form. Tree will be compiled from text.
has 'text' => -init =>
    q{die "Can't create a '" . ref($self) . "' grammar. No 'text' or 'tree'."};
has 'tree' => -init => '$self->tree_';
sub tree_ {
    require Pegex::Compiler::Bootstrap;
    Pegex::Compiler::Bootstrap->compile($_[0]->text)->tree;
}

# Parser and receiver classes to use.
has 'parser'    => 'Pegex::Parser::Bootstrap';
has 'receiver'  => -init =>
    q{die ref($self) . " does not define a 'receiver' property"};

sub parse {
    my $self = shift;
    $self = $self->new unless ref $self;

    die "Usage: " . ref($self) . '->parse($input [, $start_rule]'
        unless 1 <= @_ and @_ <= 2;

    my $parser = $self->parser;
    if (not ref $parser) {
        eval "require $parser";
        my $receiver = $self->receiver;
        $receiver = do {
            eval "require $receiver";
            $receiver->new;
        } unless ref $receiver;
        $parser = $parser->new(
            grammar => $self,
            receiver => $receiver,
        );
    }

    return $parser->parse(@_);
}



1;

=head1 DESCRIPTION

Pegex tests itself with TestML. TestML parses itself with Pegex. Bootstrapping
problem. This is the solution.

This is the copy of the Pegex Grammar runtime that TestML relies on. Otherwise
it is impossible to test changes to the runtime using the TestML tests.

This way we can use the last known good Pegex runtime with TestML to test new
changes to the runtime. When the new runtime is stable, then it gets moved to
here, and the TestML grammar gets recompiled and installed.
