/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.openqa.selenium.Beta;
import org.openqa.selenium.logging.LogEntry;

@Beta
public class LogEntries
implements Iterable<LogEntry> {
    private final List<LogEntry> entries;

    public LogEntries(Iterable<LogEntry> entries) {
        ArrayList<LogEntry> mutableEntries = new ArrayList<LogEntry>();
        for (LogEntry entry : entries) {
            mutableEntries.add(entry);
        }
        this.entries = Collections.unmodifiableList(mutableEntries);
    }

    public List<LogEntry> getAll() {
        return this.entries;
    }

    public List<LogEntry> filter(Level level) {
        ArrayList<LogEntry> toReturn = new ArrayList<LogEntry>();
        for (LogEntry entry : this.entries) {
            if (entry.getLevel().intValue() < level.intValue()) continue;
            toReturn.add(entry);
        }
        return toReturn;
    }

    @Override
    public Iterator<LogEntry> iterator() {
        return this.entries.iterator();
    }
}

