/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.logging.LoggingPreferences;

public class MutableCapabilities
implements Capabilities,
Serializable {
    private static final long serialVersionUID = -112816287184979465L;
    private static final Set<String> OPTION_KEYS;
    private final Map<String, Object> caps = new HashMap<String, Object>();

    public MutableCapabilities() {
    }

    public MutableCapabilities(Capabilities other) {
        this(other.asMap());
    }

    public MutableCapabilities(Map<String, ?> capabilities) {
        capabilities.forEach((key, value) -> {
            if (value != null) {
                this.setCapability((String)key, value);
            }
        });
    }

    @Override
    public Object getCapability(String capabilityName) {
        return this.caps.get(capabilityName);
    }

    @Override
    public Map<String, ?> asMap() {
        return Collections.unmodifiableMap(this.caps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capabilities)) {
            return false;
        }
        Capabilities that = (Capabilities)o;
        return this.asMap().equals(that.asMap());
    }

    public int hashCode() {
        return Objects.hash(this.amendHashCode(), this.caps);
    }

    protected int amendHashCode() {
        return 0;
    }

    @Override
    public MutableCapabilities merge(Capabilities extraCapabilities) {
        if (extraCapabilities == null) {
            return this;
        }
        extraCapabilities.asMap().forEach(this::setCapability);
        return this;
    }

    public void setCapability(String capabilityName, boolean value) {
        this.setCapability(capabilityName, (Object)value);
    }

    public void setCapability(String capabilityName, String value) {
        this.setCapability(capabilityName, (Object)value);
    }

    public void setCapability(String capabilityName, Platform value) {
        this.setCapability(capabilityName, (Object)value);
    }

    public void setCapability(String key, Object value) {
        if (OPTION_KEYS.contains(key) && value instanceof Capabilities) {
            this.merge((Capabilities)value);
            return;
        }
        if ("loggingPrefs".equals(key) && value instanceof Map) {
            LoggingPreferences prefs = new LoggingPreferences();
            Map prefsMap = (Map)value;
            for (String logType : prefsMap.keySet()) {
                prefs.enable(logType, LogLevelMapping.toLevel((String)prefsMap.get(logType)));
            }
            this.caps.put(key, prefs);
            return;
        }
        if ("platform".equals(key) && value instanceof String) {
            try {
                this.caps.put(key, (Object)Platform.fromString((String)value));
            }
            catch (WebDriverException e) {
                this.caps.put(key, value);
            }
            return;
        }
        if ("unexpectedAlertBehaviour".equals(key)) {
            this.caps.put("unexpectedAlertBehaviour", value);
            this.caps.put("unhandledPromptBehavior", value);
            return;
        }
        if (value == null) {
            this.caps.remove(key);
        } else {
            this.caps.put(key, value);
        }
    }

    public String toString() {
        return String.format("Capabilities [%s]", this.shortenMapValues(this.asMap()));
    }

    private Map<String, ?> shortenMapValues(Map<String, ?> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object value;
            if (entry.getValue() instanceof Map) {
                value = (Map)entry.getValue();
                newMap.put(entry.getKey(), this.shortenMapValues((Map<String, ?>)value));
                continue;
            }
            value = String.valueOf(entry.getValue());
            if (((String)value).length() > 1024) {
                value = ((String)value).substring(0, 29) + "...";
            }
            newMap.put(entry.getKey(), value);
        }
        return newMap;
    }

    static {
        HashSet<String> keys = new HashSet<String>();
        keys.add("chromeOptions");
        keys.add("edgeOptions");
        keys.add("goog:chromeOptions");
        keys.add("moz:firefoxOptions");
        keys.add("operaOptions");
        keys.add("se:ieOptions");
        keys.add("safari.options");
        OPTION_KEYS = Collections.unmodifiableSet(keys);
    }
}

