/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.continuation;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.util.ajax.Continuation;
import org.seleniumhq.jetty7.continuation.ContinuationFilter;
import org.seleniumhq.jetty7.continuation.ContinuationListener;
import org.seleniumhq.jetty7.continuation.ContinuationThrowable;

public class Jetty6Continuation
implements ContinuationFilter.FilteredContinuation {
    private static final Logger LOG = Log.getLogger((String)Jetty6Continuation.class.getName());
    private static final ContinuationThrowable __exception = new ContinuationThrowable();
    private final ServletRequest _request;
    private ServletResponse _response;
    private final Continuation _j6Continuation;
    private Throwable _retry;
    private int _timeout;
    private boolean _initial = true;
    private volatile boolean _completed = false;
    private volatile boolean _resumed = false;
    private volatile boolean _expired = false;
    private boolean _responseWrapped = false;
    private List<ContinuationListener> _listeners;

    public Jetty6Continuation(ServletRequest request, Continuation continuation) {
        if (!ContinuationFilter._initialized) {
            LOG.warn("!ContinuationFilter installed", null, null);
            throw new IllegalStateException("!ContinuationFilter installed");
        }
        this._request = request;
        this._j6Continuation = continuation;
    }

    public void addContinuationListener(ContinuationListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<ContinuationListener>();
        }
        this._listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        Jetty6Continuation jetty6Continuation = this;
        synchronized (jetty6Continuation) {
            if (this._resumed) {
                throw new IllegalStateException();
            }
            this._completed = true;
            if (this._j6Continuation.isPending()) {
                this._j6Continuation.resume();
            }
        }
    }

    public Object getAttribute(String name) {
        return this._request.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._request.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._request.setAttribute(name, attribute);
    }

    public ServletResponse getServletResponse() {
        return this._response;
    }

    public boolean isExpired() {
        return this._expired;
    }

    public boolean isInitial() {
        return this._initial;
    }

    public boolean isResumed() {
        return this._resumed;
    }

    public boolean isSuspended() {
        return this._retry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Jetty6Continuation jetty6Continuation = this;
        synchronized (jetty6Continuation) {
            if (this._completed) {
                throw new IllegalStateException();
            }
            this._resumed = true;
            if (this._j6Continuation.isPending()) {
                this._j6Continuation.resume();
            }
        }
    }

    public void setTimeout(long timeoutMs) {
        this._timeout = timeoutMs > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeoutMs;
    }

    public void suspend(ServletResponse response) {
        try {
            this._response = response;
            this._responseWrapped = this._response instanceof ServletResponseWrapper;
            this._resumed = false;
            this._expired = false;
            this._completed = false;
            this._j6Continuation.suspend((long)this._timeout);
        }
        catch (Throwable retry) {
            this._retry = retry;
        }
    }

    public void suspend() {
        try {
            this._response = null;
            this._responseWrapped = false;
            this._resumed = false;
            this._expired = false;
            this._completed = false;
            this._j6Continuation.suspend((long)this._timeout);
        }
        catch (Throwable retry) {
            this._retry = retry;
        }
    }

    public boolean isResponseWrapped() {
        return this._responseWrapped;
    }

    public void undispatch() {
        if (this.isSuspended()) {
            if (ContinuationFilter.__debug) {
                throw new ContinuationThrowable();
            }
            throw __exception;
        }
        throw new IllegalStateException("!suspended");
    }

    public boolean enter(ServletResponse response) {
        this._response = response;
        boolean bl = this._expired = !this._j6Continuation.isResumed();
        if (this._initial) {
            return true;
        }
        this._j6Continuation.reset();
        if (this._expired && this._listeners != null) {
            for (ContinuationListener l : this._listeners) {
                l.onTimeout(this);
            }
        }
        return !this._completed;
    }

    public boolean exit() {
        this._initial = false;
        Throwable th = this._retry;
        this._retry = null;
        if (th instanceof Error) {
            throw (Error)th;
        }
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (this._listeners != null) {
            for (ContinuationListener l : this._listeners) {
                l.onComplete(this);
            }
        }
        return true;
    }
}

