/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOptionGroup;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.FormChild;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.xml.sax.helpers.AttributesImpl;

@JsxClasses(value={@JsxClass(domClass=HtmlOption.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(domClass=HtmlOption.class, isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)}), @JsxClass(domClass=HtmlOptionGroup.class, isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class HTMLOptionElement
extends FormChild {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public void jsConstructor(String newText, String newValue, boolean defaultSelected, boolean selected) {
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        AttributesImpl attributes = null;
        if (defaultSelected) {
            attributes = new AttributesImpl();
            attributes.addAttribute(null, "selected", "selected", null, "selected");
        }
        HtmlOption htmlOption = (HtmlOption)HTMLParser.getFactory("option").createElement(page, "option", attributes);
        htmlOption.setSelected(selected);
        this.setDomNode(htmlOption);
        if (!"undefined".equals(newText)) {
            htmlOption.appendChild(new DomText(page, newText));
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPTION_CONSTRUCTOR_IGNORES_LABEL)) {
                htmlOption.setLabelAttribute(newText);
            }
        }
        if (!"undefined".equals(newValue)) {
            htmlOption.setValueAttribute(newValue);
        }
    }

    @JsxGetter
    public String getValue() {
        String value = this.getDomNodeOrNull().getAttribute("value");
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPTION_USE_TEXT_AS_VALUE_IF_NOT_DEFINED)) {
            value = ((HtmlOption)this.getDomNodeOrNull()).getText();
        }
        return value;
    }

    @JsxSetter
    public void setValue(String newValue) {
        if (this.getDomNodeOrNull() instanceof HtmlOption) {
            ((HtmlOption)this.getDomNodeOrNull()).setValueAttribute(newValue);
        }
    }

    @Override
    @JsxGetter
    public String getText() {
        if (this.getDomNodeOrNull() instanceof HtmlOption) {
            return ((HtmlOption)this.getDomNodeOrNull()).getText();
        }
        return null;
    }

    @JsxSetter
    public void setText(String newText) {
        if (this.getDomNodeOrNull() instanceof HtmlOption) {
            ((HtmlOption)this.getDomNodeOrNull()).setText(newText);
        }
    }

    @JsxGetter
    public boolean getSelected() {
        if (this.getDomNodeOrNull() instanceof HtmlOption) {
            return ((HtmlOption)this.getDomNodeOrNull()).isSelected();
        }
        return false;
    }

    @JsxSetter
    public void setSelected(boolean selected) {
        HtmlOption optionNode = (HtmlOption)this.getDomNodeOrNull();
        HtmlSelect enclosingSelect = optionNode.getEnclosingSelect();
        if (!selected && optionNode.isSelected() && enclosingSelect != null && !enclosingSelect.isMultipleSelectEnabled()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLOPTION_UNSELECT_SELECTS_FIRST)) {
                enclosingSelect.getOption(0).setSelected(true, false);
            }
        } else {
            optionNode.setSelected(selected, false);
        }
    }

    @JsxGetter
    public boolean getDefaultSelected() {
        if (this.getDomNodeOrNull() instanceof HtmlOption) {
            return ((HtmlOption)this.getDomNodeOrNull()).isDefaultSelected();
        }
        return false;
    }

    @JsxGetter
    public String getLabel() {
        HtmlElement domNode = this.getDomNodeOrNull();
        if (domNode instanceof HtmlOption) {
            return ((HtmlOption)domNode).getLabelAttribute();
        }
        return ((HtmlOptionGroup)domNode).getLabelAttribute();
    }

    @JsxSetter
    public void setLabel(String label) {
        HtmlElement domNode = this.getDomNodeOrNull();
        if (domNode instanceof HtmlOption) {
            ((HtmlOption)domNode).setLabelAttribute(label);
        } else {
            ((HtmlOptionGroup)domNode).setLabelAttribute(label);
        }
    }

    @Override
    @JsxGetter
    public boolean getDisabled() {
        return super.getDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataFld() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataFld(String dataFld) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataFormatAs() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataFormatAs(String dataFormatAs) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataSrc() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataSrc(String dataSrc) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }
}

