/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLActiveXObjectFactory;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObjectImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE)})
public class ActiveXObject
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(ActiveXObject.class);

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        String xClassString;
        Scriptable scriptable;
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError("ActiveXObject Error: constructor must have one or two String parameters.");
        }
        if (args[0] == Context.getUndefinedValue()) {
            throw Context.reportRuntimeError("ActiveXObject Error: constructor parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError("ActiveXObject Error: constructor parameter must be a String.");
        }
        String activeXName = (String)args[0];
        WebWindow window = ActiveXObject.getWindow(ctorObj).getWebWindow();
        MSXMLActiveXObjectFactory factory = window.getWebClient().getMSXMLActiveXObjectFactory();
        if (factory.supports(activeXName) && (scriptable = factory.create(activeXName, window)) != null) {
            return scriptable;
        }
        WebClient webClient = ActiveXObject.getWindow(ctorObj).getWebWindow().getWebClient();
        Map<String, String> map = webClient.getActiveXObjectMap();
        if (map != null && (xClassString = map.get(activeXName)) != null) {
            try {
                Class<?> xClass = Class.forName(xClassString);
                Object object = xClass.newInstance();
                return Context.toObject(object, ctorObj);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError("ActiveXObject Error: failed instantiating class " + xClassString + " because " + e.getMessage() + ".");
            }
        }
        if (webClient.getOptions().isActiveXNative() && System.getProperty("os.name").contains("Windows")) {
            try {
                return new ActiveXObjectImpl(activeXName);
            }
            catch (Exception e) {
                LOG.warn("Error initiating Jacob", e);
            }
        }
        LOG.warn("Automation server can't create object for '" + activeXName + "'.");
        throw Context.reportRuntimeError("Automation server can't create object for '" + activeXName + "'.");
    }

    public static void addProperty(SimpleScriptable scriptable, String propertyName, boolean isGetter, boolean isSetter) {
        String initialUpper = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String getterName = null;
        if (isGetter) {
            getterName = "get" + initialUpper;
        }
        String setterName = null;
        if (isSetter) {
            setterName = "set" + initialUpper;
        }
        ActiveXObject.addProperty(scriptable, propertyName, getterName, setterName);
    }

    static void addProperty(SimpleScriptable scriptable, String propertyName, String getterMethodName, String setterMethodName) {
        scriptable.defineProperty(propertyName, null, ActiveXObject.getMethod(scriptable.getClass(), getterMethodName, JsxGetter.class), ActiveXObject.getMethod(scriptable.getClass(), setterMethodName, JsxSetter.class), 4);
    }

    static Method getMethod(Class<? extends SimpleScriptable> clazz, String name, Class<? extends Annotation> annotationClass) {
        if (name == null) {
            return null;
        }
        Method foundMethod = null;
        int foundByNameOnlyCount = 0;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            if (null != method.getAnnotation(annotationClass)) {
                return method;
            }
            ++foundByNameOnlyCount;
            foundMethod = method;
        }
        if (foundByNameOnlyCount > 1) {
            throw new IllegalArgumentException("Found " + foundByNameOnlyCount + " methods for name '" + name + "' in class '" + clazz + "'.");
        }
        return foundMethod;
    }
}

