/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import java.util.Map;
import org.w3c.dom.Node;

public class HtmlNoScript
extends HtmlElement {
    public static final String TAG_NAME = "noscript";

    HtmlNoScript(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public DomNode appendChild(Node node) {
        WebClient webClient = this.getPage().getWebClient();
        if (!webClient.getOptions().isJavaScriptEnabled() || webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.NOSCRIPT_BODY_AS_TEXT)) {
            return super.appendChild(node);
        }
        return null;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (!this.getPage().getWebClient().getOptions().isJavaScriptEnabled()) {
            return HtmlElement.DisplayStyle.BLOCK;
        }
        if (this.hasFeature(BrowserVersionFeatures.CSS_NOSCRIPT_DISPLAY_INLINE)) {
            return HtmlElement.DisplayStyle.INLINE;
        }
        return HtmlElement.DisplayStyle.NONE;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }
}

