/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.webapp;

import java.util.List;
import org.seleniumhq.jetty7.util.resource.Resource;
import org.seleniumhq.jetty7.webapp.AbstractConfiguration;
import org.seleniumhq.jetty7.webapp.MetaData;
import org.seleniumhq.jetty7.webapp.WebAppContext;

public class FragmentConfiguration
extends AbstractConfiguration {
    public static final String FRAGMENT_RESOURCES = "org.seleniumhq.jetty7.webFragments";

    public void preConfigure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        this.findWebFragments(context, context.getMetaData());
    }

    public void configure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        context.getMetaData().orderFragments();
    }

    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(FRAGMENT_RESOURCES, null);
    }

    public void findWebFragments(WebAppContext context, MetaData metaData) throws Exception {
        List frags = (List)context.getAttribute(FRAGMENT_RESOURCES);
        if (frags != null) {
            for (Resource frag : frags) {
                if (frag.isDirectory()) {
                    metaData.addFragment(frag, Resource.newResource(frag.getURL() + "/META-INF/web-fragment.xml"));
                    continue;
                }
                metaData.addFragment(frag, Resource.newResource("jar:" + frag.getURL() + "!/META-INF/web-fragment.xml"));
            }
        }
    }
}

