/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seleniumhq.jetty7.server.AsyncContinuation;
import org.seleniumhq.jetty7.server.DispatcherType;
import org.seleniumhq.jetty7.server.Request;
import org.seleniumhq.jetty7.server.RequestLog;
import org.seleniumhq.jetty7.server.Response;
import org.seleniumhq.jetty7.server.Server;
import org.seleniumhq.jetty7.server.handler.HandlerWrapper;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;

public class RequestLogHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(RequestLogHandler.class);
    private RequestLog _requestLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AsyncContinuation continuation = baseRequest.getAsyncContinuation();
        if (!continuation.isInitial()) {
            baseRequest.setDispatchTime(System.currentTimeMillis());
        }
        try {
            super.handle(target, baseRequest, request, response);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this._requestLog != null && DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
                this._requestLog.log(baseRequest, (Response)response);
            }
            throw throwable;
        }
        if (this._requestLog != null && DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
            this._requestLog.log(baseRequest, (Response)response);
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        try {
            if (this._requestLog != null) {
                this._requestLog.stop();
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._requestLog, requestLog, "logimpl", true);
        }
        this._requestLog = requestLog;
        try {
            if (this.isStarted() && this._requestLog != null) {
                this._requestLog.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setServer(Server server) {
        if (this._requestLog != null) {
            if (this.getServer() != null && this.getServer() != server) {
                this.getServer().getContainer().update((Object)this, this._requestLog, null, "logimpl", true);
            }
            super.setServer(server);
            if (server != null && server != this.getServer()) {
                server.getContainer().update((Object)this, null, this._requestLog, "logimpl", true);
            }
        } else {
            super.setServer(server);
        }
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._requestLog != null) {
            this._requestLog.start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._requestLog != null) {
            this._requestLog.stop();
        }
    }
}

