/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.mortbay.html.Element;
import org.mortbay.html.List;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;

public class Include
extends Element {
    private static Log log = LogFactory.getLog(Include.class);
    Reader reader = null;

    public Include(String directory, String fileName) throws IOException {
        if (directory == null) {
            directory = ".";
        }
        if (File.separatorChar != '/') {
            directory = directory.replace('/', File.separatorChar);
            fileName = fileName.replace('/', File.separatorChar);
        }
        if (log.isDebugEnabled()) {
            log.debug("IncludeTag(" + directory + "," + fileName + ")");
        }
        this.includeFile(new File(directory, fileName));
    }

    public Include(String fileName) throws IOException {
        if (File.separatorChar != '/') {
            fileName = fileName.replace('/', File.separatorChar);
        }
        if (log.isDebugEnabled()) {
            log.debug("IncludeTag(" + fileName + ")");
        }
        this.includeFile(new File(fileName));
    }

    public Include(File file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("IncludeTag(" + file + ")");
        }
        this.includeFile(file);
    }

    public Include(InputStream in) throws IOException {
        if (in != null) {
            this.reader = new InputStreamReader(in);
        }
    }

    public Include(URL url) throws IOException {
        if (url != null) {
            this.reader = new InputStreamReader(url.openStream());
        }
    }

    public Include(Reader in) throws IOException {
        this.reader = in;
    }

    private void includeFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (file.isDirectory()) {
            List list = new List("ul");
            String[] ls = file.list();
            for (int i = 0; i < ls.length; ++i) {
                list.add(ls[i]);
            }
            StringWriter sw = new StringWriter();
            list.write(sw);
            this.reader = new StringReader(sw.toString());
        } else {
            this.reader = new BufferedReader(new FileReader(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer out) throws IOException {
        if (this.reader == null) {
            return;
        }
        try {
            IO.copy(this.reader, out);
        }
        finally {
            this.reader.close();
            this.reader = null;
        }
    }
}

