
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.3601"
  },
  "configure_requires" => {
    "Module::Build" => "0.3601"
  },
  "dist_abstract" => "Yet Another Duplicity Wrapper",
  "dist_author" => [
    "John Gravatt <john\@gravatt.org>"
  ],
  "dist_name" => "Backup-Duplicity-YADW",
  "dist_version" => "0.01",
  "license" => "perl",
  "module_name" => "Backup::Duplicity::YADW",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "Carp" => 0,
    "Config::ApacheFormat" => 0,
    "Data::Dumper" => 0,
    "File::Basename" => 0,
    "File::Path" => 0,
    "File::Spec" => 0,
    "Getopt::Long" => 0,
    "IPC::Run3" => 0,
    "Modern::Perl" => 0,
    "Moose" => 0,
    "Smart::Args" => 0,
    "String::Util" => 0,
    "Sys::Syslog" => 0,
    "constant" => 0,
    "namespace::autoclean" => 0,
    "strict" => 0,
    "vars" => 0,
    "warnings" => 0
  },
  "script_files" => [
    "bin/yadw"
  ],
  "share_dir" => {
    "dist" => "share"
  },
  "test_requires" => {
    "Cwd" => 0,
    "File::Copy" => 0,
    "File::RandomGenerator" => 0,
    "Test::More" => 0,
    "perl" => "5.006"
  }
);


my %fallback_build_requires = (
  "Cwd" => 0,
  "File::Copy" => 0,
  "File::RandomGenerator" => 0,
  "Module::Build" => "0.3601",
  "Test::More" => 0,
  "perl" => "5.006"
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  delete $module_build_args{test_requires};
  $module_build_args{build_requires} = \%fallback_build_requires;
}

my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
