package SNMP::Insight::Abstraction;

# ABSTRACT: Device Abstraction helper role

use 5.010;
use Moose::Role;

our $VERSION = '0.002';    # TRIAL VERSION:

sub provides {
    my ( $self, $name );

    return $self->does( 'SNMP::Insight::Abstraction', $name );
}

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::Abstraction - Device Abstraction helper role

=head1 VERSION

version 0.002

=head1 DESCRIPTION

Abstractions implement high level operation that are specific for a class of devices, e.g. retrieving the mac address table from a bridge or a list a installed software from a host.

  if ( $device->provides('Host') ) {
      @packages $device->installed_software;
  }

  if ( $device->provides('Bridge') ) {
      $interface = $device->mac_address_table->{$vlan}->{$mac_addr};
  }

Abstractions should hide all SNMP details.

=head1 METHODS

=head2 provides($name)

Return true if abstraction C<$name> is implemented by the device.

=head1 WARNING

B<Abstrations are not implented yet>. Planned for 0.2

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
