# "This is a template and example of configuration file for Sim::OPT.
# $target = "opt"; # THIS VARIABLE DEFINES THE MODULE TO WHICH THE DATA IN THIS CONFIGURATION FILE ARE AIMED.
# THE POSSIBILITIES ARE: "opt" FOR "Sim::OPT" (ESP-r-specific), or "takechance" FOR "Sim::OPT::Takechance".
# IF UNSPECIFIED, IT DEFAULTS TO "opt".

############################################################################################################
####### BEGINNING OF DATA FOR THE MORPH.pm, RETRIEVE.pm, REPORT.pm AND Descenf.pm MODULES (TILL END) #######

$mypath = "/home/luca/f" ;# path of the directory in which you are going to work

@sweeps = ( [[1], [2], [3], [4], [5], [6], [7], [8]] );
#@sweeps = ( [ [ 1, 2, 3 ] ] );
#@sweeps = ( [ [ 1, 2, 3, 4, 5, 6, 7, 8, 9 ] ] );
#@sweeps = ( [ [ 1, 2, 3, 4, 5, 6, 7 ] ] );
#@sweeps = ( [ [ 1 ] ] );
# DESCRIPTION OF A (MAYBE OVERLAPPING) COORDINATE BLOCK DESCENT. # THE NUMBERS ARE THE VARIABLE NUMBERS.
# MORE THAN ONE SEARCH MAY BE LISTED. # EACH BLOCK SEARCH IS DESCRIBED AS A SEQUENCE OF LIST VARIABLES.
# THIS IS THE BLOCK SEARCH STRUCTURE DECLARED EXPLICITLY AS AN ALTERNATIVE TO USING @chanceseed AND @caseseed.
# IF BOTH @sweeps AND THOSE TWO VARIABLES ARE SPECIFIED, 
# @sweeps IS NOT OVERRIDDEN ON THE BASIS OF WHAT IS SPECIFIED IN @chanceseed AND @caseseed. 
# IT HAS TO BE UNSPECIFIED IF THE SEARCH STRUCTURE HAS TO BE CALCULATE BY THE PROGRAM. @sweepseed MAY BE SPECIFIED IN ITS PLACE.

@varinumbers = ( { 1 => 3, 2 => 3, 3 => 3, 4 => 3, 5 => 3, 6 => 3, 7 => 5, 8 => 3, } );
#@varinumbers = ( { 1 => 3, 2 => 3, 3 => 3 } ); 
#THIS IS THE DEFAULT. THESE VALUES CAN BE OVERRIDDEN BELOW, IN THE PARAMETERS' SPECIFICATIONS
#@varinumbers = ( { 1 => 3, 2 => 3, 3 => 3, 4 => 3, 5 => 3, 6 => 5, 7 => 3, 8 => 3, 9 => 3, } );
#@varinumbers = ( { 1 => 2, 2 => 2, 3 => 2, 4 => 2, 5 => 2, 6 => 4, 7 => 2 } ); #THIS IS THE DEFAULT. THESE VALUES CAN BE OVERRIDDEN BELOW, IN THE PARAMETERS' SPECIFICATIONS
#@varinumbers = ( { 1 => 2 } ); #THIS IS THE DEFAULT. THESE VALUES CAN BE OVERRIDDEN BELOW, IN THE PARAMETERS' SPECIFICATIONS
# OR: @varinumbers = ( { 1 => '3', 2 => '3', 3 => '3', 4 => '3', 5 => '3' } ); # OR: @varinumbers = ( { 1 => '3', 2 => '3', 3 => '3', 4 => '3', 5 => '3' }, { 1 => '3', 2 => '3', 3 => '3' } );
# IN THIS ARRAY OF HASHES (DICTIONARIES) THE NUMBER OF ITERATIONS FOR EACH VARIABLES ARE SPECIFIED.

@mediumiters = ( { 1 => 2, 2 => 2, 3 => 2, 4 => 2, 5 => 2, 6 => 2, 7 => 3, 8 => 2 } );
#@mediumiters = ( { 1 => 2, 2 => 2, 3 => 2 } );
# IN THIS ARRAY OF HASHES (DICTIONARIES) THE INITIALIZATION LEVELS FOR EACH VARIABLES ARE SPECIFIED. 
#@mediumiters = ( { 1 => 1, 2 => 1, 3 => 1, 4 => 1, 5 => 1, 6 => 2, 7 => 1 } ); # IN THIS ARRAY OF HASHES (DICTIONARIES) THE BASE ITERATION FOR EACH VARIABLES ARE SPECIFIED. 
#@mediumiters = ( { 1 => 1 } ); # IN THIS ARRAY OF HASHES (DICTIONARIES) THE BASE ITERATION FOR EACH VARIABLES ARE SPECIFIED. 
# IF LEFT UNSPECIFIED IT DEFAULTS TO THE MIDDLE ITERATION FOR EACH VARIABLE.  # IF LEFT UNSPECIFIED IT DEFAULTS TO THE CENTRAL VALUE FOR EACH GIVEN RANGE. 

$file = "f";  # the root model directory.

%dowhat = ( # This variables tells to the program what to do.
morph => "n", # create cases for simulation?
simulate => "n", # simulate AND retrieve? THIS MUST BE "y" TO PERFORM BLOCK SEARCH.
newretrieve => "n",  # retrieve data? THIS MUST BE "y" TO PERFORM BLOCK SEARCH.
newreport => "y",  # retrieve data? THIS MUST BE "y" TO PERFORM BLOCK SEARCH.
neweraseres => "n", # erase .res and .fl files as they are created or leave them as traces?
neweraseret => "n", # erase .ret files as they are created or leave them as traces?descend => "n", # descend into results? THIS MUST BE "y" FOR BLOCK SEARCH.
descend => "y", # descend into results? THIS MUST BE "y" FOR BLOCK SEARCH.
substitutenames => "n", # substitute names (convert) in non-filtered reports? (UNTESTED SINCE EARLY VERSIONS.)
filterconverted => "n", # filter already converted reports? (UNTESTED SINCE EARLY VERSIONS.)
make3dtable => "n", # make table to be plotted in 3D? (UNTESTED SINCE EARLY VERSIONS.)
overwrite_models => { 1 => "n" },
#direction => [ [ ">", ">", ">", ">", ">", ">", ">", ">" ] ], #if direction "<", ascent
#direction => [ [ "star" ] ], #if direction "star": pure jacobi method, parallel coordinate descent
#direction => [ [ "<", "<", "<", "<", "<", "<", "<", "<" ] ], #if direction ">", descent
direction => [ [ "star" ] ], #if direction "<", ascent
#direction => [ [ "=", "=", "=", "=", "=", "=", "=", "=" ] ],  #if direction "h", "horizontal" transversal, in the middle between ascent and descent
#These are the operator signs used to guide the direction of the search for each search block. There is a point to point correspondence with the variable "@sweeps". ">" means minimizing and "<" means mazimizing. "=" Is for a "star" (in the sense of the Design of Experiment theory) exploration. This variable can be absent and in such a case the program defaults to minimizing order ">". #NEW
precomputed => "/home/luca/f/f-precomputed.csv", #location of the precomputed results. THE PRESENCE OF THOSE INACTIVATES ALL THE SETTINGS FOR RETRIEVING AND REPORTING. #NEW
takecolumns => [ 0, 1 ], #COMUMNS OF THE PRECOMPUTED RESULTS THAT HAS TO BE CONSIDERED AS INDICATOR. THIS OVERRIDES ALL THE SETTINGS FOR RETRIEVAL AND REPORTING (@keepcolumns). #NEW
randomsweeps => "no", # to randomize the order specified in @sweeps.
randominit => "no", # to randomize the init levels specified in @mediumiters.
randomdirs => "no", # to randomize the directions of descent.
inactivatemorph => "n",
inactivatesim => "n",
inactivateres => "n",
incativateret => "n",
actonexisting_models => { 1 => "n" },
menus => "shortb",
simtools => { 1 => "esp-r",
#2 => "energyplus" 
},
#evalfile => "evalfile.pl",
#reptools => { 1 => "esp-r" },
); # 11) THIS MUST BE "y" TO PERFORM BLOCK SEARCH. It checks if it is possible to launch a block search, and if it is does it.

$fileconfig = "f.cfg"; # name of the configuration file of the model, which will reside in the "./cfg/" directory in your model's directory.

$max_processes = 7;

$simnetwork = "n"; # is there a mass/flow network? This information regards the simulation settings.
$exeonfiles = "y";
$preventsim = "n";

$simtitles{1} = [ 
[ "feb", "1 2", "28 2", "20", "1" ], 
];

#$simtitles{2} = [ 
#[ "feb01-feb08", "1 2", "8 2", "20", "1", "milan.epw", "boxform.idf", "boxform_feb.idf", [ "FullInteriorAndExterior", "FullInteriorAndExteriorWithReflections" ], [ "4;   !- Time Step in Hour", "1;   !- Time Step in Hour" ], [ "1, 1,   !- Begin Month", "2, 1,   !- Begin Month" ], [ "12,31,   !- End Month", " 2, 7,   !- End Month" ] ], 
#[ "jul01-jul08", "1 7", "8 7", "20", "1", "milan.epw", "boxform.idf", "boxform_jul.idf",[ "FullInteriorAndExterior", "FullInteriorAndExteriorWithReflections" ], [ "4;   !- Time Step in Hour", "1;   !- Time Step in Hour" ], [ "1, 1,   !- Begin Month", "7, 1,   !- Begin Month" ], [ "12,31,   !- End Month", " 7, 7,   !- End Month" ] ],
#];

#$vals{1}{skipsim} = " ( ( $to =~ /_1-2/ ) or ( $to =~ /_2-2/ ) or ( $to =~ /_3-2/ ) or ( $to =~ /_4-2/ ) or ( $to =~ /_5-2/ ) or ( $to =~ /_6-2/ ) ) ";
#$vals{1}{skipsim} = " ( ( \$to =~ /_1-2/ ) or ( \$to =~ /_2-2/ ) or ( \$to =~ /_3-2/ ) or ( \$to =~ /_4-2/ ) or ( \$to =~ /_5-2/ ) or ( \$to =~ /_6-3/ ) or ( \$to =~ /_6-5/ ) ) ";

$retrievedata{1} = 
[ 
[ 
[ 
"1 2 1", "28 2 24", "1" 
] 
],
]; 

#@varthemes_report = (
#"something", "something_else1","something_else2", "something_else3"
#); ########## Definitions that are going to substitute the variable numbers in the tables. THIS OPERATION IS NOT MANDATORY.

#@varthemes_variations = (
#[-1, 1], [-1, 1],[-36, 36] , [-30, 30],[-30, 30],[-30, 30],[-30, 30], [-1, 1]
#); ######### Minimum and maximum values regarding the variables, in the same order above. THIS OPERATION IS NOT MANDATORY.

#@varthemes_steps = (
#5, 5, 5, 5, 5
#);  ######### Number of steps allowed for each variables. In the same order above. THIS OPERATION IS NOT MANDATORY.

#@rankdata = ( # CUT ZZZ
#"n", "n", "y", "n"
#); # THIS DATA ARE POINT-TO- POINT RELATIVE TO THE ARRAY ABOVE AND TELL WHAT FIELD THE RANKING HAS TO BE BASED ON. THIS OPERATION IS NOT MANDATORY.

#@rankcolumn = (
#0, 0, 3, 0
#); # THIS DATA ARE POINT-TO- POINT RELATIVE TO THE ARRAY ABOVE AND TELLS WHAT FILE COLUMN THE RANKING HAS TO BE BASED ON: 
# 3 for max air temps, 5 for min air temps, 7 for mean air temps, 8 for resultant max temps, 10 for resultant min temps, 12 for resultant mean temps - 
# THIS OPERATION IS NOT MANDATORY.

$reportdata{1} = # THERE IS A POINT-TO POINT CORRESPONDENCE TO THE ITEMS IN @retrievedata
[ 
[ 
[ 
	{
		reporttitle => "feb", #PERIODS TO REPORT IS THE "REPORT STATS" OPTIONS. 
		themereport => "tempsstats", #STRING TO PUT IN THE RESULT FILE NAME TO RECOGNIZE IT. #PRE-MADE OPTIONS ARE "tempstats" and "loads". OTHER OPTIONS MUST BE ADDED BY MODIFYING THE SCRIPT.
		semaphorego => "", # SEMAPHORE ON. STRING SIGNALLING THE ROW HAS ARRIVED AFTER WHICH E THE ROW WITH THE RESULTS IS ARRIVING. IF IT IS BLANK, IT IS IGNORED
		semaphorestop => "", # SEMAPHORE OFF. STRING SIGNALLING THE ROW AFTER WHICH THE ONE THE ROW WITH THE RESULTS CAN ARRIVE NO MORE.
		textpattern => "1  Feb" #STRING IN THE RESULT FILE SIGNALLING WHAT ROW HAS TO BE PICKED. THE TEXT RESULTS FILES HAS TO BE CHECKED TO DEDUCT THOSE.
	},
	{
		reporttitle => "feb", #PERIODS TO REPORT IS THE "REPORT STATS" OPTIONS. 
		themereport => "tempsstats", #STRING TO PUT IN THE RESULT FILE NAME TO RECOGNIZE IT. #PRE-MADE OPTIONS ARE "tempstats" and "loads". OTHER OPTIONS MUST BE ADDED BY MODIFYING THE SCRIPT.
		semaphorego => "", # SEMAPHORE ON. STRING SIGNALLING THE ROW HAS ARRIVED AFTER WHICH E THE ROW WITH THE RESULTS IS ARRIVING. IF IT IS BLANK, IT IS IGNORED
		semaphorestop => "", # SEMAPHORE OFF. STRING SIGNALLING THE ROW AFTER WHICH THE ONE THE ROW WITH THE RESULTS CAN ARRIVE NO MORE.
		textpattern => "2  Feb" #STRING IN THE RESULT FILE SIGNALLING WHAT ROW HAS TO BE PICKED. THE TEXT RESULTS FILES HAS TO BE CHECKED TO DEDUCT THOSE.
	},
	{
		reporttitle => "feb", #PERIODS TO REPORT IS THE "REPORT STATS" OPTIONS. 
		themereport => "tempsstats", #STRING TO PUT IN THE RESULT FILE NAME TO RECOGNIZE IT. #PRE-MADE OPTIONS ARE "tempstats" and "loads". OTHER OPTIONS MUST BE ADDED BY MODIFYING THE SCRIPT.
		semaphorego => "", # SEMAPHORE ON. STRING SIGNALLING THE ROW HAS ARRIVED AFTER WHICH E THE ROW WITH THE RESULTS IS ARRIVING. IF IT IS BLANK, IT IS IGNORED
		semaphorestop => "", # SEMAPHORE OFF. STRING SIGNALLING THE ROW AFTER WHICH THE ONE THE ROW WITH THE RESULTS CAN ARRIVE NO MORE.
		textpattern => "3  Feb" #STRING IN THE RESULT FILE SIGNALLING WHAT ROW HAS TO BE PICKED. THE TEXT RESULTS FILES HAS TO BE CHECKED TO DEDUCT THOSE.
	},
	{
		reporttitle => "feb", #PERIODS TO REPORT IS THE "REPORT STATS" OPTIONS. 
		themereport => "tempsstats", #STRING TO PUT IN THE RESULT FILE NAME TO RECOGNIZE IT. #PRE-MADE OPTIONS ARE "tempstats" and "loads". OTHER OPTIONS MUST BE ADDED BY MODIFYING THE SCRIPT.
		semaphorego => "", # SEMAPHORE ON. STRING SIGNALLING THE ROW HAS ARRIVED AFTER WHICH E THE ROW WITH THE RESULTS IS ARRIVING. IF IT IS BLANK, IT IS IGNORED
		semaphorestop => "", # SEMAPHORE OFF. STRING SIGNALLING THE ROW AFTER WHICH THE ONE THE ROW WITH THE RESULTS CAN ARRIVE NO MORE.
		textpattern => "4  Feb" #STRING IN THE RESULT FILE SIGNALLING WHAT ROW HAS TO BE PICKED. THE TEXT RESULTS FILES HAS TO BE CHECKED TO DEDUCT THOSE.
	},
	{
		reporttitle => "feb", #PERIODS TO REPORT IS THE "REPORT STATS" OPTIONS. 
		themereport => "tempsstats", #STRING TO PUT IN THE RESULT FILE NAME TO RECOGNIZE IT. #PRE-MADE OPTIONS ARE "tempstats" and "loads". OTHER OPTIONS MUST BE ADDED BY MODIFYING THE SCRIPT.
		semaphorego => "", # SEMAPHORE ON. STRING SIGNALLING THE ROW HAS ARRIVED AFTER WHICH E THE ROW WITH THE RESULTS IS ARRIVING. IF IT IS BLANK, IT IS IGNORED
		semaphorestop => "", # SEMAPHORE OFF. STRING SIGNALLING THE ROW AFTER WHICH THE ONE THE ROW WITH THE RESULTS CAN ARRIVE NO MORE.
		textpattern => "5  Feb" #STRING IN THE RESULT FILE SIGNALLING WHAT ROW HAS TO BE PICKED. THE TEXT RESULTS FILES HAS TO BE CHECKED TO DEDUCT THOSE.
	},
	{
		reporttitle => "feb", #PERIODS TO REPORT IS THE "REPORT STATS" OPTIONS. 
		themereport => "tempsstats", #STRING TO PUT IN THE RESULT FILE NAME TO RECOGNIZE IT. #PRE-MADE OPTIONS ARE "tempstats" and "loads". OTHER OPTIONS MUST BE ADDED BY MODIFYING THE SCRIPT.
		semaphorego => "", # SEMAPHORE ON. STRING SIGNALLING THE ROW HAS ARRIVED AFTER WHICH E THE ROW WITH THE RESULTS IS ARRIVING. IF IT IS BLANK, IT IS IGNORED
		semaphorestop => "", # SEMAPHORE OFF. STRING SIGNALLING THE ROW AFTER WHICH THE ONE THE ROW WITH THE RESULTS CAN ARRIVE NO MORE.
		textpattern => "6  Feb" #STRING IN THE RESULT FILE SIGNALLING WHAT ROW HAS TO BE PICKED. THE TEXT RESULTS FILES HAS TO BE CHECKED TO DEDUCT THOSE.
	},
]
],
];

#$vals{skipfile} = "skipfile.txt";
#$vals{skipreport} = " ( ( $simtitle =~ /_1-2/ ) or ( $simtitle =~ /_2-2/ ) or ( $simtitle =~ /_3-2/ ) or ( $simtitle =~ /_4-2/ ) or ( $simtitle =~ /_5-2/ ) or ( $simtitle =~ /_6-2/ ) ) ";
#$vals{skipreport} = " ( ( \$simtitle =~ /_1-2/ ) or ( \$simtitle =~ /_2-2/ ) or ( \$simtitle =~ /_3-2/ ) or ( \$simtitle =~ /_4-2/ ) or ( \$simtitle =~ /_5-2/ ) or ( \$simtitle =~ /_6-3/ ) or ( \$simtitle =~ /_6-5/ )) ";

#@keepcolumns = ( 
#[ "Feb_Avg_ResT", 16 ], [ "Feb_SolAbsInZ", 31 ], [ "Feb_Rad_EntZ", 32 ], [ "Jul_Avg_ResT", 48 ], 
#[ "Jul_SolAbsInZ", 63 ], [ "Jul_Rad_EntZ", 64 ], 
#); 
# COLUMNS TO KEEP FROM THE FILE OF RESULTS. THEY ARE WRITTEN IN PAIRS. 
# THE FIRST ITEM OF EACH PAIR IS THE OBJECTIVE FUNCTION NAME AND THE SECOND IS THE COLUMN TO KEEP 
# FROM THE RESULT FILE AND BRING TO THE RESULT SUMMARY.

#@weights = ( 0.1666, 0.1666, 0.1666, 0.1666, 0.1666, 0.1666 ); 
# RATIO OF EACH OBJECTIVE FUNCTION, OVER THE TOTAL OF 1. IT IS RELATIVE TO @keepcolumns. EACH WEIGHT IS RELATIVE TO ONE @keepcolumn pair. THEREFORE THEY MUST BE THE IN THE SAME NUMBER.
# THESE ARE THE WEIGHTS REGARDING THE OBJECTIVE FUNCTIONS WHICH CONCUR TO DEFINE THE OBJECTIVE FUNCTIONS USED FOR BLOCK COORDINATE DESCENT.

#@weightsaim = ( 1, 1, 1, -1, -1, -1 ); 
# THERE IS A POINT TO POINT CORRENSPONDENCE WITH @weights. THEREFORE THEY MUST BE IN THE SAME NUMBER. A (-1) VALUE TELLS THE PROGRAM THAT THE OBJECTIVE FOR THAT OBJECTIVE FUNCTION IS MINIMIZATION. 
# A (+1) VALUE TELLS THE PROGRAM THAT THE OBJECTIVE IS MAXIMIZATION. 


########### VARIABLES OF SECONDARY IMPORTANCE - ABOUT REPORTING ##############

#@files_to_filter = ("wholenew", "1-2var", "2-3var", 
#"3-4var", "4-5var", "1-3var", 
#"2-4var", "3-5var", "1-4var",
#"2-5var", "1-5var",);
#@filter_reports = ( [ [ 2, 3, 4, 5, 1] ],  [ [1, 2] , [3, 4, 5] , [5, 5, 5], [18]],   [ [2, 3] , [1, 4, 5] , [5, 5, 5], [18]],
#[ [3, 4] , [1, 2, 5] , [5, 5, 5], [18]], [ [4, 5] , [1, 2, 3] , [5, 5, 5], [18]], [ [1, 3] , [2, 4, 5] , [5, 5, 5], [18]],
#[ [2, 4] , [1, 3, 5] , [5, 5, 5], [18]], [ [3, 5] , [5, 5, 5] , [1, 1, 1], [18]], [ [1, 4] , [2, 3, 5] , [5, 5, 5], [18]],
#[ [2, 5] , [1, 3, 4] , [5, 5, 5], [18]], [ [1, 5] , [2, 3, 4] , [5, 5, 5], [18]]
 # ) ; # for the first [] element: a list of all the variables number; from the second on: varnumbers to report, varnumbers not to report, 
#  # casenumber to report among varnumbers not to report, column to extract from tables.
#@base_columns = ([], [0, 1, 18], [1, 2, 18], 
#[2, 3, 18], [3, 4, 18], [0, 2, 18], 
#[1, 3, 18], [2, 4, 18], [0, 3, 18],
#[1, 4, 18], [0, 4, 18]); #position of the columns to select to be put in the table in the maketable subroutine. THE ORDER IS: COLUMN, ROW, VALUE in the table to be obtained. ALWAYS THE COLUMN THAT IS BEFORE IN THE TABLE HAS TO BE USED AS ROW.
#@maketabledata = ([], [5, 5], [5, 5], 
#[5, 5], [5, 5], [5, 5], 
#[5, 5], [5, 5], [5, 5],
#[5, 5], [5, 5]); # THIS VALUES REGARD THE ORDER ABOVE, STARTING FROM THE FIRST GROUP (THAT IS, FROM THE SECOND POSITION) TO THE SECOND GROUP. THE FIRST POSITION HAS TO BE LEFT BLANK: []!
#@filter_columns = (0, 1, 2, 3, 4, 19, 20, 21); #THIS IS OF THE GREATEST IMPORTANCE: (0, 1, 2, 3, 4, 5, 9, 11, 13, 14, 16, 18, 19, 20), IS RIGH FOR TEMPSTASTS. (0, 1, 2, 3, 4, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21); THE LAST COLUMN MUST ALWAYS BE IN, PLUS ONE MORE.

################################################################################
################# MORPHING PARAMETERS ###################

######################### PARAMETER 1. #############################

$vals{1}{1}{applytype} = 
[ 
[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],


] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to", "zone_letter"]), 
# the following morphing operations are available: "translate", "rotate", "rotatez", "surface_translate", "shift_vertices", 
# "rotate_surface", "warping", "construction_reassign", "change_thickness", "obs_modify", "generic_change", "vary_controls", “vary_net”, 
# "change_groundreflectance", "genchange", "translate_vertices", "change_climate"

$vals{1}{1}{translate_vertices} = 
[ 

[
[ "a", "e", "h", "d",   "b", "f", "g", "c" ],  
[ [0.666, 0, 0], [0.666, 0, 0 ], [0.666, 0, 0], [0.666, 0, 0],  [-0.666, 0, 0], [-0.666, 0, 0], [-0.666, 0, 0], [-0.666, 0, 0], ], 
[ "/zones/main.geo", "a" ], # source file
],
[ 
[ "a", "e", "f", "b",     "i",      "j", "k", "l", "m" ],  
[ [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0], 
[0, -1.333, 0], 
[0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0] ], 
[ "/zones/main.geo", "a" ], # source file
],

[
[ "a", "e", "h", "d", "m", "n", "o", "p", "l", "k", "i", "j", "b", "f", "g", "c" ],  
[ [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [1, 0, 0], [1, 0, 0], [1, 0, 0], [1, 0, 0], [0.666, 0, 0], [0.666, 0, 0], [0.666, 0, 0], [0.666, 0, 0], ], 
[ "/zones/right.geo", "b" ], # source file
],
[ 
[ "a", "e", "f", "b",    "i", "j", "k", "l",    "m", "n", "o", "p",      "0\nq" ],  
[ [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0],      [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0],      [0, -0.666, 0], [0, -0.666, 0], [0, -0.666, 0], [0, -0.666, 0],      [0, -1.333, 0] ], 
[ "/zones/right.geo", "b" ], # source file
],

[
[ "a", "e", "h", "d",    "m", "n", "o", "p",    "l", "k", "i", "j",      "b", "f", "g", "c" ],  
[ [-0.666, 0, 0], [-0.666, 0, 0], [-0.666, 0, 0], [-0.666, 0, 0], [-2, 0, 0], [-2, 0, 0], [-2, 0, 0], [-2, 0, 0], [-1, 0, 0], [-1, 0, 0], [-1, 0, 0], [-1, 0, 0], [-2, 0, 0], [-2, 0, 0], [-2, 0, 0], [-2, 0, 0], ], 
[ "/zones/left.geo", "c" ], # source file
],
[ 
[ "a", "e", "f", "b",    "i", "j", "k", "l",    "m", "n", "o", "p",      "0\nq"  ],  
[ [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0],      [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0], [0, -1.333, 0],      [0, -0.666, 0], [0, -0.666, 0], [0, -0.666, 0], [0, -0.666, 0],                           [0, -1.333, 0] ], 
[ "/zones/left.geo", "c" ], # source file
],

[ 
[ "a", "e", "h", "d",   "b", "f", "g", "c" ],  
[ [0.666, 0, 0], [0.666, 0, 0], [0.666, 0, 0], [0.666, 0, 0],  [-0.666, 0, 0], [-0.666, 0, 0], [-0.666, 0, 0], [-0.666, 0, 0], ], 
[ "/zones/mainback.geo", "d" ], # source file
],
[ 
[ "c", "d", "h", "g",     "n",      "j", "k", "l", "m" ],  
[ [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0], 
[0, -1.333, 0], 
[0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0] ], 
[ "/zones/mainback.geo", "d" ], # source file
],

[ 
[ "a", "e", "h", "d", "m", "n", "o", "p", "l", "k", "i", "j", "b", "f", "g", "c" ],  
[ [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [2, 0, 0], [1, 0, 0], [1, 0, 0], [1, 0, 0], [1, 0, 0], [0.666, 0, 0], [0.666, 0, 0], [0.666, 0, 0], [0.666, 0, 0], ], 
[ "/zones/rightback.geo", "e" ], # source file
],

[ 
[ "d", "h", "g", "c",                   "i", "j", "k", "l",                "m", "n", "o", "p",   "0\nq" ],  
[ [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0],           [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0],            [0, 0.666, 0], [0, 0.666, 0], [0, 0.666, 0], [0, 0.666, 0],                 [0, -1.333, 0] ], 
[ "/zones/rightback.geo", "e" ], # source file
],

[
[ "a", "e", "h", "d",    "m", "n", "o", "p",    "l", "k", "i", "j",      "b", "f", "g", "c" ],  
[ [-0.666, 0, 0], [-0.666, 0, 0], [-0.666, 0, 0], [-0.666, 0, 0], [-2, 0, 0], [-2, 0, 0], [-2, 0, 0], [-2, 0, 0], [-1, 0, 0], [-1, 0, 0], [-1, 0, 0], [-1, 0, 0], [-2, 0, 0], [-2, 0, 0], [-2, 0, 0], [-2, 0, 0], ], 
[ "/zones/leftback.geo", "f" ], # source file
],

[ 
[ "d", "h", "g", "c",      "i", "j", "k", "l",      "m", "n", "o", "p",   "0\nq" ],  
[ [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0],      [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0], [0, 1.333, 0],      [0, 0.666, 0], [0, 0.666, 0], [0, 0.666, 0], [0, 0.666, 0],                   [0, -1.333, 0] ], 
[ "/zones/leftback.geo", "f" ], # source file
],

];
# [ @vertexes_to_transl, Consider that after "p" you have to write "0\nq" ]
# [ [ x y z movs ] ],  in case of surface x y z translation
# source file, # long menus?

# transform type: "a" for surface translation along normal, "b" for x y z surface translation.
# [ # surfaces to be translated (letters) ]
# [ # end movements, in case of surface translation along_normal (example: [2, 2, 2, 2, 2, 2] ), or "x y z" translation, in the case of x y z translation of surface (example: ["2  2  2", "2  2  2"]). Relative to the fields above.
# update radiation? "b" for yes or "c" for no.


######################### PARAMETER 2. #############################

$vals{1}{2}{applytype} = 
[ 
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],

[ "translate_vertices", "f.cfg", "f.cfg" ],
[ "translate_vertices", "f.cfg", "f.cfg" ],


] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to", "zone_letter"]), 
# the following morphing operations are available: "translate", "rotate", "rotatez", "surface_translate", "shift_vertices", 
# "rotate_surface", "warping", "construction_reassign", "change_thickness", "obs_modify", "generic_change", "vary_controls", “vary_net”, 
# "change_groundreflectance", "genchange", "translate_vertices", "change_climate"

$vals{1}{2}{translate_vertices} = 
[ 

[
[ "j", "m", "k", "l", ],  
[ [-0.166, 0, 0], [-0.166, 0, 0], [0.166, 0, 0], [0.166, 0, 0], ], 
[ "/zones/main.geo", "a" ], # source file
],

[
[ "i", "l", "j", "k", ],  
[ [-0.166, 0, 0], [-0.166, 0, 0], [0.166, 0, 0], [0.166, 0, 0], ], 
[ "/zones/right.geo", "b" ], # source file
],

[
[ "n", "o", "m", "p", ],  
[ [0, -0.166, 0], [0, -0.166, 0], [0, 0.166, 0], [0, 0.166, 0], ], 
[ "/zones/right.geo", "b" ], # source file
],

[
[ "i", "l", "j", "k", ],  
[ [-0.166, 0, 0], [-0.166, 0, 0], [0.166, 0, 0], [0.166, 0, 0], ], 
[ "/zones/left.geo", "c" ], # source file
],

[ 
[ "n", "o", "m", "p", ],  
[ [0, 0.166, 0], [0, 0.166, 0], [0, -0.166, 0], [0, -0.166, 0], ], 
[ "/zones/left.geo", "c" ], # source file
],

[ 
[ "j", "m", "k", "l", ],  
[ [0.166, 0, 0], [0.166, 0, 0], [-0.166, 0, 0], [-0.166, 0, 0], ], 
[ "/zones/mainback.geo", "d" ], # source file
],

[ 
[ "i", "l", "j", "k", ],  
[ [0.166, 0, 0], [0.166, 0, 0], [-0.166, 0, 0], [-0.166, 0, 0], ], 
[ "/zones/rightback.geo", "e" ], # source file
],

[ 
[ "n", "o", "m", "p", ],  
[ [0, -0.166, 0], [0, -0.166, 0], [0, 0.166, 0], [0, 0.166, 0], ], 
[ "/zones/rightback.geo", "e" ], # source file
],

[
[ "i", "l", "j", "k", ],  
[ [0.166, 0, 0], [0.166, 0, 0], [-0.166, 0, 0], [-0.166, 0, 0], ], 
[ "/zones/leftback.geo", "f" ], # source file
],

[ 
[ "n", "o", "m", "p", ],  
[ [0, 0.166, 0], [0, 0.166, 0], [0, -0.166, 0], [0, -0.166, 0], ], 
[ "/zones/leftback.geo", "f" ], # source file
],

];
# [ @vertexes_to_transl, Consider that after "p" you have to write "0\nq" ]
# [ [ x y z movs ] ],  in case of surface x y z translation
# source file, # long menus?

# transform type: "a" for surface translation along normal, "b" for x y z surface translation.
# [ # surfaces to be translated (letters) ]
# [ # end movements, in case of surface translation along_normal (example: [2, 2, 2, 2, 2, 2] ), or "x y z" translation, in the case of x y z translation of surface (example: ["2  2  2", "2  2  2"]). Relative to the fields above.
# update radiation? "b" for yes or "c" for no.


######################### PARAMETER 3. #############################

$vals{1}{3}{applytype} = 
[ 
[ "apply_constraints", "f.cfg", "f.cfg" ],
] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to" ]), 

$vals{1}{3}{apply_constraints} = ##### APPLY PROPAGATION OF CONSTRAINTS TO THE MODEL AFTER A CERTAIN CHANGE; GENERAL. YOU HAVE TO WRITE A CONFIGURATION FILES TO DO IT. (SEE EXAMPLE MODELS.)
[

[ 
[ "/zones/main.geo", "/zones/right.geo", "/zones/left.geo", "/zones/mainback.geo", "/zones/rightback.geo", "/zones/leftback.geo",  ], # zone files #
[ 1, 2, 3, 4, 5, 6 ], # zone file numbers - point to point correspondence with the names above
[ "/zones/constraints1.pl" ], # configuration file for constraints
[ 9 ], # [ increment_value1..., "increment value2" ]. It can be accessed by position with the variable "@val" in the file for propagation of constraints. 
# Example: $val[0] is increment_value1, $val0 is increment value 2. 
],

]; 
# In the file for the propagation of constraints, the vertices are named for example like this:
# $ver{1}{2}, which means: vertex 2 of zone 1.
# $ver{1}{2}->[0] is the "x" value; $ver{1}{2}->[1] is the "y" value; $ver{1}{2}->[2] is the "z" value
# the obstructions are named for example like this:
# $obs{1}{2}, which means: vertex 2 of zone 1.
# $obs{1}{2}->[0] is the "x" value of the position, ...[1] the "y", ...[2] the "z";
# $obs{1}{2}->[4] is the width, ...[5] the depth, ...[6] the height, 
# ...[7] the "y" rotation, ...[8] the tilt, ...[9] the opacity,
# ...[10] the name, [11] the material.


######################### PARAMETER 4. #############################

$vals{1}{4}{applytype} = 
[ 
[ "translate", "f.cfg", "f.cfg", "a" ],
[ "translate", "f.cfg", "f.cfg", "b" ],
[ "translate", "f.cfg", "f.cfg", "c" ],
[ "translate", "f.cfg", "f.cfg", "d" ],
[ "translate", "f.cfg", "f.cfg", "e" ],
[ "translate", "f.cfg", "f.cfg", "f" ],
] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to" ]), 

$vals{1}{4}{translate} =  
[ 
[ "n", ["5", "0", "0"], "c", ],
[ "n", ["5", "0", "0"], "c", ],
[ "n", ["5", "0", "0"], "c", ],
[ "n", ["5", "0", "0"], "c", ],
[ "n", ["5", "0", "0"], "c", ],
[ "n", ["5", "0", "0"], "c", ],
];
# translate obstructions? "y" or "n".
# [
# coordinate “x” for one extreme of the swing.  The other one will be simmetrical along the line.
# coordinate “y” for one extreme of the swing.  The other one will be simmetrical along the line.
# coordinate “z” for one extreme of the swing.  The other one will be simmetrical along the line.
# ]
# update radiation calculation with the "ish" module?  "a" for yes and "c" for no (= continue).
#### @applytype111 = ( ["translation", "file_name", "target_file_name", "zone_letter"]); 



######################### PARAMETER 5. #############################

$vals{1}{5}{applytype} = 
[ 
[ "translate", "f.cfg", "f.cfg", "a" ],
[ "translate", "f.cfg", "f.cfg", "b" ],
[ "translate", "f.cfg", "f.cfg", "c" ],
[ "translate", "f.cfg", "f.cfg", "d" ],
[ "translate", "f.cfg", "f.cfg", "e" ],
[ "translate", "f.cfg", "f.cfg", "f" ],
] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to" ]), 

$vals{1}{5}{translate} =  
[ 
[ "n", ["0", "5", "0"], "c", ],
[ "n", ["0", "5", "0"], "c", ],
[ "n", ["0", "5", "0"], "c", ],
[ "n", ["0", "5", "0"], "c", ],
[ "n", ["0", "5", "0"], "c", ],
[ "n", ["0", "5", "0"], "c", ],
];
# translate obstructions? "y" or "n".
# [
# coordinate “x” for one extreme of the swing.  The other one will be simmetrical along the line.
# coordinate “y” for one extreme of the swing.  The other one will be simmetrical along the line.
# coordinate “z” for one extreme of the swing.  The other one will be simmetrical along the line.
# ]
# update radiation calculation with the "ish" module?  "a" for yes and "c" for no (= continue).
#### @applytype111 = ( ["translation", "file_name", "target_file_name", "zone_letter"]); 


######################### PARAMETER 6. #############################

$vals{1}{6}{applytype} = 
[ 
[ "rotate", "f.cfg", "f.cfg", "a" ],
[ "rotate", "f.cfg", "f.cfg", "b" ],
[ "rotate", "f.cfg", "f.cfg", "c" ],
[ "rotate", "f.cfg", "f.cfg", "d" ],
[ "rotate", "f.cfg", "f.cfg", "e" ],
[ "rotate", "f.cfg", "f.cfg", "f" ],
] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to" ]), 

$vals{1}{6}{rotate} = 
[ 
[ "n", "90", "c", "i" ],
[ "n", "90", "c", "q" ],
[ "n", "90", "c", "q" ],
[ "n", "90", "c", "n" ],
[ "n", "90", "c", "q" ],
[ "n", "90", "c", "q" ],
];

$vals{1}{6}{todos} = 
[ 

[ 
{ 
	actions => [ "recalculateish" ], #possible actions: "recalculateish", "use_modish", constrain_geometry genprop constrain_obstructions constrain_net constrain_controls apply_constraints pin_obstructions recalculatenet recalculateish daylightcalc use_modish export_toenergyplus
	parameters => [ 1, 2, 3, 4, 5, 6 ],
}
],

];
#possible actions: "recalculateish", "use_modish", constrain_geometry genprop constrain_obstructions constrain_net constrain_controls apply_constraints pin_obstructions recalculatenet recalculateish daylightcalc use_modish export_toenergyplus

$vals{1}{6}{recalculateish} = 
[
[ "y" ],
]; 
# recalculate the solar radiation? "y" or "n". This way the "ish" module is launched just at the end of a whole morphing operation, and not at every sub-operations composing it.


# [ # rotate obstructions? "y" o "n", # swing of rotation (HALF SWING, SWING MEASURED ON ONE SIDE WITH REGARDS TO THE MIDDLE) 
# update radiation calculation with the "ish" module?  "b" for yes and "c" for no, continue, # vertex around which to rotate ]
##### @applytype111 = (["rotation", "file_name", "target_file_name", "zone_letter"]);



######################### PARAMETER 7. #############################

$vals{1}{7}{applytype} = 
[ 
[ "change_thickness", "f.cfg", "f.cfg" ],
] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to" ]), 

$vals{1}{7}{change_thickness} = 
[ 
[
[ "a" ], 
[ [ "n" ] ], 
[ [ [20, 220] ] ],
],
]; 
# [ 
# [ #  entries to be changed in the construction database. It has to be a local copy. ],
# [ groups of strata to change: strata to change for each entry. There is a correspondence with the above ]
# @groups_of_pairs_of_min_max_values, containing @min_max_values: min and max values for each change above.  There is a two to one correnspondence of the values below with the above.
##### @applytype111 = ( ["thickness_change", "file_name", "target_file_name", "zone_letter"]); 




######################### PARAMETER 8. #############################

$vals{1}{8}{applytype} = 
[ 
[ "change_thickness", "f.cfg", "f.cfg" ],
] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to" ]), 

$vals{1}{8}{change_thickness} = 
[ 
[
[ "0\n0\nc\n0\nc\nc" ], 
[ [ "p" ] ], 
[ [ [20, 220] ] ],
],
]; 
# [ 
# [ #  entries to be changed in the construction database. It has to be a local copy. ],
# [ groups of strata to change: strata to change for each entry. There is a correspondence with the above ]
# @groups_of_pairs_of_min_max_values, containing @min_max_values: min and max values for each change above.  There is a two to one correnspondence of the values below with the above.
##### @applytype111 = ( ["thickness_change", "file_name", "target_file_name", "zone_letter"]); 




######################### PARAMETER 9. #############################

$vals{1}{9}{applytype} = 
[ 
[ "change_thickness", "f.cfg", "f.cfg" ],
] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to" ]), 

$vals{1}{9}{change_thickness} = 
[ 
[
[ "0\n0\nc\n0\nc\n0\nc\n0\nc\nd" ], 
[ [ "p" ] ], 
[ [ [30, 100] ] ],
],
]; 
# [ 
# [ #  entries to be changed in the construction database. It has to be a local copy. ],
# [ groups of strata to change: strata to change for each entry. There is a correspondence with the above ]
# @groups_of_pairs_of_min_max_values, containing @min_max_values: min and max values for each change above.  There is a two to one correnspondence of the values below with the above.
##### @applytype111 = ( ["thickness_change", "file_name", "target_file_name", "zone_letter"]); 




######################### PARAMETER 8. #############################

#$vals{1}{8}{applytype} = [ [ "change_climate", "boxform.cfg", "boxform.cfg", "a" ] ] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to", "zone_letter"]), 
## the following morphing operations are available: "translation", "rotation", "rotationz", "surface_translation", "vertices_shift", 
## "surface_rotation", "warping", "construction_reassignment", "thickness_change", "obs_modification", "generic_change", "vary_controls", “vary_net”, 
## "change_groundreflectance", "genchange"
#$vals{1}{8}{general_variables} = 
#[
#"n", # $generate(n) eq "n" # (if the models deriving from this runs will not be generating new models) or y (if they will be generating new models).
#"n" #if $sequencer eq "y", or "last" (of a sequence) iteration between non-continuous cases wanted.  The first gets appended to the middle(s) and to he last. Otherwise, "n".
#];
#$vals{1}{8}{change_climate} = 
#[
#[ "../dbs/milan", "../dbs/cairo", "../dbs/glasgow" ]
#]; # THE FULL PATH OF EACH FILE MUST BE SPECIFIED AND EACH FILE MUST ALREADY BE IN THE ESP-r FORMAT





############################################################################################################
####################### BEGINNING OF DATA FOR THE Sim::OPT::Takechance MODULE ##############################

#@caseseed = # OPTIONAL. NEEDED IF Sim::OPT::Tackechance IS CALLED AND I @sweepchance IS UNDEFINED.
#( 
#[ 
#[0, 8],
#]
#) ;  


#@caseseed = # OPTIONAL. NEEDED IF Sim::OPT::Tackechance IS CALLED AND I @sweepchance IS UNDEFINED.
#( 
#[ 
#[1, 4], [3, 4] , [5, 4],
#]
#) ;  

#@chanceseed = # OPTIONAL. NEEDED IF Sim::OPT::Tackechance IS CALLED
#(
#[
#[ 1, 2, 3, 4, 5, 6, 7, 8 ]
#]
#);

#@chanceseed = # OPTIONAL. NEEDED IF Sim::OPT::Tackechance IS CALLED
#(
#[
#[1, 2, 3, 4, 5], [1, 2, 3, 4, 5] , [1, 2, 3, 4, 5]
#[1, 2, 3, 4, 5], [2, 1, 3, 4, 5] , [5, 2, 3, 4, 1]
#]
#);

#@chancedata = # OPTIONAL. NEEDED IF Sim::OPT::Tackechance IS CALLED
#([4, 3, 3]); 
### HERE: 1) BLOCK LENGTH OF BLOCKS TO ADD; 2) OVERLAP BETWEEN BLOCKS; 3) NUMBER OF SWEEPS TO ADD.

#$dimchance = 3;

#@pars_tocheck = ( [1, 2, 3, 4, 5] );

## @varinumbers = ( { 1 => 3, 2 => 3, 3 => 3, 4 => 3, 5 => 3 } ); # THIS VARIABLE IS NEEDED BY the Takechance.pm MODULE. IT IS ALSO NEEDED BY Sim::OPT. 

######################## END OF DATA FOR THE Sim::OPT::Takechance MODULE ###################################
############################################################################################################


############################################################################################################
####################### BEGINNING OF DATA FOR THE Sim::OPT::Parcoord MODULE ################################

#$convertfile = "./some_file.csv";
#$pick = 50; # pick just the higher and the lower $pick cases in the result file, not all cases. Example: if $pick is 1000, take only the 1000 best and the 1000 worst performing cases. If all the cases have too be considered, specify: $pick = "";
#$numof_pars = 10; # NUMBER OF PARAMETERS
#$xspacing = 5;
#$yspacing = 1;
#$zspacing = 1;
#$ob_column = 10; # COLUMN NUMBER OF THE OBJECTIVE FUNCTION
#$numof_layers = 10; # COLUMN NUMBER OF THE FUNCTION REPRESENTED THROUGH COLOURS.
#$otherob_column = 2; # here the column number to be used has to be specified, counting from 0. If none, specify "none". THIS WILL BE REPRESENTED ON THE THIRD AXIS
#$cut_column = ""; #column to cut from the principal plot, in x y dimensions.
#$writefile = "./$convertfile-writefile.pl";
#$writefile_pretreated = "./$convertfile-writefile_pretreated.pl";
#$transitional = "$convertfile-otherob-transitional.pl";
#$newtransitional = "$convertfile-otherob-newtransitional.pl";
#$lispfile = "$convertfile" . "otherob.lsp";
#@layercolours = (12, 10, 20, 30, 40, 60, 70, 100, 102, 104); # COLOUR NUMBERS (CAD) FOR THE LAYERS.
#$offset = (1/50); # aspect ratio of the 3d lines of the 3d graph
#$brushspacing = (1/30); # spacing between identical coordinates 

######################## END OF DATA FOR THE Sim::OPT::Parcoord MODULE #####################################
############################################################################################################








#################################################################################
#################################################################################
## HERE FOLLOW EXAMPLE DESCRIPTION OF MORPHING OPERATIONS 
## REFERRED TO A HYPOTHETICAL MORPHING PHASE 111

#
$stepsvar111 = 3 ; 
#  Number of steps for this variable.  This should better be an odd number, 
# since thiat way one number will be the central one, which is, the one already supplied in the starting model;

$vals{1}{111}{applytype} = 
[ 
[ "surface_translation", "zone.cfg", "zone.cfg", "a" ],
]; 
# @applytype = (["type_of_change", "your_test_file", "target_file", "zone_letter"]). 
# THIS REPRESENTS A FIRST CYCLE OF ACTIONS, THAT MAY BE THE ONLY ONE FOR THIS MORPHING CYCLE. 
# Presently, the following morphing operations are available: "translation", "rotation", "rotationz", "surface_translation", "vertices_shift", 
# "surface_rotation", "warping", "construction_reassignment", "thickness_change", "obs_modification", "generic_change", "vary_controls", “vary_net”, 
# "change_groundreflectance", "genchange"
# And these operations can be accompanied by the following operations for the propagation of constraints to the models: 
# apply_constraints (regarding geometry), constrain_geometry (more general: it will gradually substitute the former), constrain_controls, 
# bring_obstructions_back (to pin down some obstructions while other are being moved), constrain_obstructions, constrain_net, 
# recalculatenet (this both updates a net and applies constraints to it). 
# The following update operations are also possible: recalculateish, daylightcalc (with Radiance, through e2r).
# "Target file" here means: "file name to which the test file has to be copied to"
# [ type_of_change, test_file, target_file. If it is the same as the test file, no copying takes place, zone letter in the model ]

$vals{1}{111}{copy_config} = 
[
[ "file_old", "file_new" ],
];
# file to be substituted,  # file substituting

$vals{1}{111}{general_variables} = 
[ "y", "n" ];
# 1) generate other models by branching? "y" or "n". 2) attach the morphing operation of the next morphing phase to the present one without generating new cases? 
# If "yes", you'll see the symbol "" attached to file names in place of "_" for morphed models.

$vals{1}{111}{translate} =  
[ 
[ "n", ["9", "0", "0"], "c", ],
];
# translate obstructions? "y" or "n".
# [
# coordinate “x” for one extreme of the swing.  The other one will be simmetrical along the line.
# coordinate “y” for one extreme of the swing.  The other one will be simmetrical along the line.
# coordinate “z” for one extreme of the swing.  The other one will be simmetrical along the line.
# ]
# update radiation calculation with the "ish" module?  "a" for yes and "c" for no (= continue).
#### @applytype111 = ( ["translation", "file_name", "target_file_name", "zone_letter"]); 

$vals{1}{111}{change_groundreflectance} =  
[ 
[ 80, [ 50, 80 ] ] # [ base value, [ low, high ] ]; OR: [ base value, half-range ];
];

$vals{1}{111}{translate_surface} =  
[ 
[ "a", [ "b", "d" ], [  1, 1  ] , "c", ],
];
$vals{111}{translate_surface} =  
[ 
[ "b", [ "b", "d" ], [  1, 1  ] , "c", [ 4, 5, 6] ],
];
# transform type: "a" for surface translation along normal, "b" for x y z surface translation.
# [ # surfaces to be translated (letters) ]
# [ # end movements, in case of surface translation along_normal (example: [2, 2, 2, 2, 2, 2] ), or "x y z" translation, in the case of x y z translation of surface (example: ["2  2  2", "2  2  2"]). Relative to the fields above.
# update radiation? "b" for yes or "c" for no.
#### @applytype111 = ( ["surface_translation", "file_name", "target_file_name", "zone_letter"]); 

$vals{1}{111}{shift_vertices} = 
[ 
[ "j", 
[ "i" , "q" , "j", "r" , "m" , "0\ns", "n", "0\nt" , "0\nv", "c", "0\nu", "d", "0\nz", "f", "0\ny", "e" ], 
[ 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8 ], 
"c", ],
];
# [
# movement type: "j": shift vertices along a line. "h": align vertices with a line.
# [ pairs of vertices defining axes ]
# [ Complete shift movements - whole excursion ]
# configuration file for conditions
# ]


$vals{1}{111}{rotate_surface} = 
[ 
[   [ "b", "d" ], [ 10, 12 ], [ 30, 30 ] , [ "y", "y" ]   ]
];
# [
# [ # surfaces to rotate ]
# [ vertices around which to rotate ]
# [ wing extremes of the rotation ] # THAT IS: HALF RANGE OF THE ROTATION. 
# [ apply to others? "y" or "n" ]
##### @applytype111 = [ ["surface_rotation", "file_name", "target_file_name", "zone_letter"]);

$vals{1}{111}{translate_vertices} = 
[ 
[ 
[ "a", "i", "0\ny", "j",  "b", "f", "k", "l", "e",  "d", "0\nr", "0\na", "0\nq", "c", "g", "0\nt", "0\ns", "h" ],  
[ [0, 2, 0], [0, 2, 0], [0, 2, 0], [0, 2, 0], [0, 2, 0], [0, 2, 0], [0, 2, 0], [0, 2, 0], [0, 2, 0],  [0, -2, 0], [0, -2, 0], [0, -2, 0], [0, -2, 0], [0, -2, 0], [0, -2, 0], [0, -2, 0], [0, -2, 0], [0, -2, 0] ], 
[ "/zones/zone.geo" ], # source file
[ "y" ] # long menus?
],
];
# [ @vertexes_to_transl, Consider that after "p" you have to write "0\nq" ]
# [ [ x y z movs ] ],  in case of surface x y z translation
# source file, # long menus?


$vals{1}{111}{rotate} = 
[ 
[ "n", "90", "c", "a" ],
];
# [ # rotate obstructions? "y" o "n", # swing of rotation (HALF SWING, SWING MEASURED ON ONE SIDE WITH REGARDS TO THE MIDDLE) 
# update radiation calculation with the "ish" module?  "b" for yes and "c" for no, continue, # vertex around which to rotate ]
##### @applytype111 = (["rotation", "file_name", "target_file_name", "zone_letter"]);



$vals{1}{111}{construction_reassignment} = 
[ 
[
[ "a", "b", "c", "d", "e", "f" , "k", "l", "m", "n", "o", "p", "q", "r"  ], 
[
["b", "d", "g", "h"], ["b", "d", "g", "h"], ["b", "d", "g", "h"], ["b", "d", "g", "h"], 
["b", "d", "g", "h"], ["b", "d", "g", "h"] , ["b", "0\nu", "0\nv", "0\nw"] , ["b", "0\nu", "0\nv", "0\nw"], ["b", "0\nu", "0\nv", "0\nw"], ["b", "0\nu", "0\nv", "0\nw"], 
["b", "0\nu", "0\nv", "0\nw"], ["b", "0\nu", "0\nv", "0\nw"], ["b", "0\nu", "0\nv", "0\nw"], ["b", "0\nu", "0\nv", "0\nw"]  
] 
],
];
# [ [ #  surfaces to be reassigned ], [ # constructions to be chosen ] ]
# constructions to be chosen: letter combination, here! IN EACH GROUP WITHIN EACH PARENTHESIS THERE IS A SEQUENCE OF LETTER OF MATERIALS TO BE TRIED. 
# THE NUMBER OF MATERIALS SHOULD BE EQUAL TO THE NUMBER OF ITERATIONS IN THIS MORHING PHASE (OR GREATER – BUT IN THIS CASE SOME LAST ITEMS WILL BE IGNORED). 
# EACH GROUP WITHIN A PARENTHESIS [] REFERS TO A LETTER OF THE FIRST LIST. NOTICE THAT YOU HAVE TO USE THE "0\nw" TRICK IF THE MENU IS MORE THAN ONE PAGE LONG.
 ##### @applytype111 = (["construction_reassignment", "file_name", "target_file_name", "zone_letter"]);
 
 
$vals{1}{111}{change_thickness} = 
[ 
[
[ a, b, c ], 
[ [i, j], [a, b], [k] ], 
[ [ [10, 20] , [20, 50] ], [ [20, 60] , [10, 40] ], [ [20, 50 ] ] ],
],
]; 
# [ 
# change thickness of a construction layer? "y" or "n",
# [ #  entries to be changed in the construction database. It has to be a local copy. ],
# [ groups of strata to change: strata to change for each entry. There is a correspondence with the above ]
# @groups_of_pairs_of_min_max_values, containing @min_max_values: min and max values for each change above.  There is a two to one correnspondence of the values below with the above.


$vals{1}{111}{obs_modify} = 
[   
[  [ "i","j", "k", "l" ] , "c", [ 45 ], [180]  ],
];
# [ 
# [ obstructions to modify (letters) ],
# what to modify? "a" for origin, "b" for dimensions, "c" for z_rotation, "d" for y_rotation, "g" for construction, "h" for opacity, "t" for transform	
# enter value or values corresponding to the above. If origin coordinates of one extreme of the translation. 
# If dimensions: x y z of dimensions. If rotation: swing of the rotation. If construction:construction name. If opacity: percentage of opacity.
# if origin: base x y z origin. If dimensions: base x y z dimensions. If rotations: start rotation. If opacity: base opacity. if transform: "a" for rotation, "b" for transform.
# ]
### @applytype111 = (["obs_modification",trans "cell.geo", "cell.geo", "a"], ["obs_modification", "cell.geo", "cell.geo", "a"]);


$vals{1}{111}{keep_obstructions} = ##### BRING SOME OBSTRUCTIONS BACK IN THE ORIGINAL POSITION AFTER ALL OF THEM HAVE BEEN MOVED.
[
{ 
what => "read", tempname => "../tmp/rem1.tmp", obsnumbers => [ 1, 2 ]
},
];
# { what => "read" or "write", tempname => name of the temporary file, obsnumbers => obstruction numbers }

 
$vals{1}{111}{warp} = 
[ 
[   
[ "b", "d" ],  #  surfaces to warp
[ 2, 2 ], # vertices around which to rotate
[ 36, -36 ] , # swings of rotation
[ "y", "y" ], # apply to other ones? "y" or "n".
"configfile.1.1.warp.pl", # configuration file for conditions. # TO COMPLETE
[ "a" , "d" , "e", "h" , "b" , "c", "f", "g" , "d" , "a" , "h", "e" , "c" , "b", "g", "f" ], # pairs of vertices defining axes
[ "g", "i" ], # windows to be realigned
"/zones/zone.geo", # zone geometry file
"y" # long menus occurring in ESP-r? "y" or "n".
], 
];


$vals{1}{111}{rotatez} = 
[ [ 0.7, 0.7, 0.02 ], "x", 90, 0, 0, 0 ]; 
# [ # x, y (or x) and z of the point that is the center of the axis rotation ],
# # plan of rotation: x or y, # rotation swing of plane xy, # rotation already had by the zone with respect to the x axis, # rotation on plane yz - TO DO, # swing for the rotation on plane xy - TO DO
###  @applytype(n) = [["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to", "zone_letter"]). # THIS ROUTINE KEEPS THE OBSTRUCTIONS STILL AND ROTATE THE ZONE(S) ON THE ALTITUDE ANGLE.  IT DOES NOT PASS THROUGH ESP-R.  IT JUST MANAGES THE .GEO CONFIGURATION FILE.

$vals{1}{111}{generic_change} = ""; ##### # @applytype111 = [["generic_change", "file_name", "target_file_name", "zone_letter"]); TO BE REVRITTEN

$vals{1}{111}{change_climate} = 
[
[ "../dbs/asyut", "../dbs/rome", "../dbs/newdelhi" ]
]; # THE FULL PATH OF EACH FILE MUST BE SPECIFIED AND EACH FILE MUST ALREADY BE IN THE ESP-r FORMAT

$vals{1}{111}{reshape_windows} = [
[
[ 
[ "/zones/zone.geo" ], # source file
[ "/zones/zone.geo" ], # target file
[ "configfile.1.1.window_reshapement.pl" ], # configuration file for constraints
[ ( 40/100 ) ], # windows percentage base value
[ ( 30/100 )], # windows percentage swing
[ "k", "l", "m", "n" ], # vertex number of the windows to change
[ "y" ] # there are long menus for items in ESP-r here? "y" or "n".
]
],
]; 





$vals{1}{111}{constrain_geometry} = # This is similar to "apply_constraints", but more general, because the propagation here criteria has to be specified in the configuration file. 
[  
[
"/zones/zone.geo", # source file
"/zones/zone.geo", # target file
"/opts/default_configfile_geometry_constraints.pl", # configuration file for constraints. Here the criteria for propagation of constraints have to be specified.
[ "k", "l", "m", "n" ], # vertex letters to be changed.
"y", # long vertex letters (long menus) in ESP-r here? "y" or "n"
[ 1, 1, 2, 1 ], # swings, corresponding point to point to vertexletters
], # THIS IS THE FIRST OPERATION IN SERIES. OTHER CAN BE ADDED.
]; #
## THIS VARIABLE REGARDS GEOMETRY USER-IMPOSED CONSTRAINTS
## THIS CONSTRAINT CONFIGURATION FILE MAKES AVAILABLE TO THE USER THE FOLLOWING VARIABLES:
## @v[$number][$x], @v[$number][$y], @v[$number][$z]. 
## EXAMPLE: @v[4][$x] = 1. THIS MEANS: COORDINATE x OF VERTEX 4. OR: @v[4][$x] =  @v[4][$y].
## ALSO, IT FILE MAKES AVAILABLE TO THE USER INFORMATIONS ABOUT THE MORPHING STEP OF THE MODELS 
## AND THE STEPS THE MODEL HAVE TO FOLLOW. SPECIFICALLY, THE FOLLOWING VARIABLES:
## $stepsvar, WHICH TELLS THE PROGRAM HOW MANY ITERATION STEPS IT HAS TO DO IN THE CURRENT MORPHING PHASE.
## $counterzone, WHICH TELLS THE PROGRAM WHAT OPERATION IS BEING EXECUTED IN THE CHAIN OF OPERATIONS 
## THAT MAY BE EXECUTES AT EACH MORPHING PHASE. EACH $counterzone WILL CONTAIN ONE OR MORE ITERATION STEPS.
## TYPICALLY, IT WILL BE USED FOR A ZONE, BUT NOTHING PREVENTS THAT SEVERAL OF THEM CHAINED ONE AFTER 
## THE OTHER ARE APPLIED TO THE SAME ZONE.
## $counterstep, WHICH TELLS THE PROGRAM WHAT THE CURRENT ITERATION STEP IS.
## If the alphabetical order is not accepted as an order to propagate constraints, a new order can be specificed
## WITH THE FOLLOWING VARIABLE: @vertexletters

$vals{1}{111}{constrain_obstructions} = # To apply constraints to and from obstructions.
[ 
[
"a", # zone letter
"/zones/zone.geo", # source file
"/zones/zone.geo", # target file
"/opts/default_configfile_obstruction_constraints.pl", # configuration file for constraints. Here the criteria for propagation of constraints have to be specified.
[  "e", "f", "g", "h" ], # obstruction letters to be changed.
"y" # act on construction too? "y" or "n". Note that constructions letters (as they appear in the construction database) and not construction names have to be given in the configuration files.
], 
];
## THIS PART REGARDS USER-IMPOSED CONSTRAINTS ABOUT OBSTRUCTIONS
## THIS CONSTRAINT CONFIGURATION FILE FILE MAKES AVAILABLE TO THE USER THE FOLLOWING VARIABLES:
## $obs[$obs_number][$x], $obs[$obs_number][$y], $obs[$obs_number][$y]
## $obs[$obs_number][$width], $obs[$obs_number][$depth], $obs[$obs_number][$height]
## $obs[$obs_number][$z_rotation], $obs[$obs_number][$y_rotation], 
## $obs[$obs_number][$tilt], $obs[$obs_number][$opacity], $obs[$obs_number][$material], 
## EXAMPLE: $obs[2][$x] = 2. THIS MEANS: COORDINATE x OF OBSTRUCTION HAS TO BE SET TO 2.
## OTHER EXAMPLE: $obs[2][$x] = $obs[2][$y]. THIS MEANS: 
## NOTE: THE MATERIAL TO BE SPECIFIED IS A MATERIAL LETTER, BETWEEN QUOTES. EXAMPLE: $obs[1][$material] = "a".
##  $tilt IS PRESENTLY UNUSED.
## ALSO, THIS FILE MAKES AVAILABLE TO THE USER INFORMATIONS ABOUT THE MORPHING STEP OF THE MODELS 
## AND THE STEPS THE MODEL HAVE TO FOLLOW. SPECIFICALLY, THE FOLLOWING VARIABLES:
## $stepsvar, WHICH TELLS THE PROGRAM HOW MANY ITERATION STEPS IT HAS TO DO IN THE CURRENT MORPHING PHASE.
## $counterzone, WHICH TELLS THE PROGRAM WHAT OPERATION IS BEING EXECUTED IN THE CHAIN OF OPERATIONS 
## THAT MAY BE EXECUTES AT EACH MORPHING PHASE. EACH $counterzone WILL CONTAIN ONE OR MORE ITERATION STEPS.
## TYPICALLY, IT WILL BE USED FOR A ZONE, BUT NOTHING PREVENTS THAT SEVERAL OF THEM CHAINED ONE AFTER 
## THE OTHER ARE APPLIED TO THE SAME ZONE.
## $counterstep, WHICH TELLS THE PROGRAM WHAT THE CURRENT ITERATION STEP IS.
## If the alphabetical order is not accepted as an order to propagate constraints, a new order can be specificed
## WITH THE FOLLOWING VARIABLE:  @obs_letters 


$vals{1}{111}{vary_controls} = 
[ 
[
"/ctl/cell.ctl", # source file
"/ctl/cell.ctl", # target file
"/opts/default_configfile_control_constraints.pl", # config file
[ #BEGINNING OF BUILDING CONTROLS
["e", # LETTER OF THE FIRST LOOP  # BEGINNING OF THE FIRST CONTROLLER OF THE FIRST LOOP FOR BUILDING CONTROLS
"a", # LETTER OF THE FIRST CONTROLLER OF THE FIRST LOOP
0, # SWINGS FOR ZONE START PERIOD HOUR 
1000, # SWINGS FOR MAXIMUM ZONE HEATING POWER 
0, # SWINGS FOR MINIMUM ZONE HEATING POWER 
500, # SWINGS FOR MAXIMUM ZONE COOLING POWER
0, # SWINGS FOR MINIMUM ZONE COOLING POWER
1, # SWINGS FOR ZONE HEATING SETPOINT 
1],  # SWINGS FOR ZONE COOLING SETPOINT - END OF THE FIRST CONTROLLER OF THE FIRST LOOP FOR BUILDING CONTROLS
["f", # LETTER OF THE SECOND LOOP  # BEGINNING OF THE FIRST CONTROLLER OF THE SECOND LOOP FOR BUILDING CONTROLS
"a", # LETTER OF THE FIRST CONTROLLER OF THE FIRST LOOP
0, # SWINGS FOR ZONE START PERIOD HOUR
1000, # SWINGS FOR MAXIMUM ZONE HEATING POWER 
0, # SWINGS FOR MINIMUM ZONE HEATING POWER 
500, # SWINGS FOR MAXIMUM ZONE COOLING POWER
0, # SWINGS FOR MINIMUM ZONE COOLING POWER
1, # SWINGS FOR ZONE HEATING SETPOINT 
1] # SWINGS FOR ZONE COOLING SETPOINT - END OF THE FIRST CONTROLLER OF THE SECOND LOOP FOR BUILDING CONTROLS
], # END OF BUILDING CONTROLS
[ # BEGINNING OF NET CONTROLS
[ "e", # FIRST LOOP  FOR NETS
"a", #  FIRST CONTROL FOR THE FIRST LOOP FOR NETS
0,  # BEGINNING HOUR SWING
1, #  SETPOINT SWING
0, # VARIATION RELATIVE TO ON-OFF (-1 OR 1)
0 ], # FRACTION
[ "e", "b", 0, 1, 0, 0 ], # FIRST LOOP AND SECON CONTROL FOR THE FIRST LOOP FOR NETS; THEN BEGINNING HOUR SWING, SETPOINT SWING, ON-OFF (-1 OR 1), FRACTION
[ "f", "a", 0, 1, 0, 0 ], # SECOND LOOP AND FIRST CONTROL FOR THE SECOND LOOP FOR NETS; THEN BEGINNING HOUR SWING, SETPOINT SWING, ON-OFF (-1 OR 1), FRACTION
] # END OF NET CONTROLS
], # END OF DATA FOR THE FIRST SEQUENCE OF OPERATIONS IN THIS MORPHING PHASE, ETC. NEW SEQUENCES CAN BE ADDED.
];


$vals{1}{111}{constrain_controls} = # to apply contraints to and from controls.
[
[
"/ctl/cell.ctl", # source file
"/ctl/cell.ctl", # target file
"/opts/default_configfile_control_constraints.pl", # config file 
],
];
## THIS VARIABLE REGARDS CONTROL USER-IMPOSED CONSTRAINTS
## THIS CONSTRAINT CONFIGURATION FILE FILE MAKES AVAILABLE TO THE USER THE FOLLOWING VARIABLES:
## 1) $loop_control[$countloop][$countloopcontrol][$loop_hour] 
## Where $countloop and  $countloopcontrol has to be set to a specified number in the OPT file for constraints.
## 2) $loop_control[$countloop][$countloopcontrol][$max_heating_power] # Same as above.
## 3) $loop_control[$countloop][$countloopcontrol][$min_heating_power] # Same as above.
## 4) $loop_control[$countloop][$countloopcontrol][$max_cooling_power] # Same as above.
## 5) $loop_control[$countloop][$countloopcontrol][$min_cooling_power] # Same as above.
## 6) $loop_control[$countloop][$countloopcontrol][heating_setpoint] # Same as above.
## 7) $loop_control[$countloop][$countloopcontrol][cooling_setpoint] # Same as above.
## 8) $flow_control[$countflow][$countflowcontrol][$flow_hour] 
## Where $countflow and  $countflowcontrol has to be set to a specified number in the OPT file for constraints.
## 9) $flow_control[$countflow][$countflowcontrol][$flow_setpoint] # Same as above.
## 10) $flow_control[$countflow][$countflowcontrol][$flow_onoff] # Same as above.
## 11) $flow_control[$countflow][$countflowcontrol][$flow_fraction] # Same as above.
## EXAMPLE : $flow_control[1][2][$flow_fraction] = 0.7
## OTHER EXAMPLE: $flow_control[1][2][$flow_fraction] = $flow_control[2][1][$flow_fraction]
## ALSO, THIS FILE MAKES AVAILABLE TO THE USER INFORMATIONS ABOUT THE MORPHING STEP OF THE MODELS 
## AND THE STEPS THE MODEL HAVE TO FOLLOW. SPECIFICALLY, THE FOLLOWING VARIABLES:
## $stepsvar, WHICH TELLS THE PROGRAM HOW MANY ITERATION STEPS IT HAS TO DO IN THE CURRENT MORPHING PHASE.
## $counterzone, WHICH TELLS THE PROGRAM WHAT OPERATION IS BEING EXECUTED IN THE CHAIN OF OPERATIONS 
## THAT MAY BE EXECUTES AT EACH MORPHING PHASE. EACH $counterzone WILL CONTAIN ONE OR MORE ITERATION STEPS.
## TYPICALLY, IT WILL BE USED FOR A ZONE, BUT NOTHING PREVENTS THAT SEVERAL OF THEM CHAINED ONE AFTER 
## THE OTHER ARE APPLIED TO THE SAME ZONE.
## $counterstep, WHICH TELLS THE PROGRAM WHAT THE CURRENT ITERATION STEP IS.
## If the alphabetical order is not accepted as an order to propagate constraints, a new order can be specificed
## WITH THE FOLLOWING VARIABLES: @letters AND @period_letters

$vals{1}{111}{vary_net} = 
[ 
[
"/nets/cell.afn", # source file
"/nets/cell.afn", # target file
"/opts/default_configfile_net_constraints.pl", # config file # LEAVE BLANK. SPECIFY PROPARATION OF CONSTRAINTS SEPARATELY.
[ #BEGINNING OF  NODES. JUST THE ONES THAT HAS TO BE CHANGED HAVE TO BE LISTED HERE
["a", # NODE LETTER  # BEGINNING OF THE FIRST NODE. THIS IS AN INTERNAL UNKNOWN NODE.
"a", # FLUID TYPE
"a", # BOUNDARY TYPE
"", # HEIGHT. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE
"", # VOLUME. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE
],  #  END OF THE FIRST NODE
["b", # NODE LETTER  # BEGINNING OF THE SECOND NODE. THIS IS A BOUNDARY, WIND-INDUCED NODE
"a", # FLUID TYPE
"e", # BOUNDARY TYPE. LETTER
"", # HEIGHT. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE
"", # SURFACE AZIMUTH ANGLE. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE
"g", # SURFACE IN ZONE, LETTER. IT CAN'T BE BLANK. THE LETTER MUST BE CHECKED IN ESP-R AND WRITTEN HERE.
[ "f" , "g" ] # PRESSURE COEFFICIENTS (LETTERS) TO APPLY. THEY MUST BE AT LEAST THE SAME NUMBER OF $stepsvar. THE EXCEEDING ITEMS WILL NOT BE USED.
] , # END OF THE SECOND NODE
["c", # NODE LETTER  # BEGINNING OF THE SECOND NODE. THIS IS A BOUNDARY, WIND-INDUCED NODE
"a", # FLUID TYPE
"e", # BOUNDARY TYPE
"", # HEIGHT. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE
"", #  AZIMUTH ANGLE. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE
"h", # SURFACE IN ZONE, LETTER. THE LETTER MUST BE CHECKED IN ESP-R AND WRITTEN HERE.
[ "f" , "g" ] # PRESSURE COEFFICIENTS (LETTERS) TO APPLY. THEY MUST BE AT LEAST THE SAME NUMBER OF $stepsvar. THE EXCEEDING ITEMS WILL NOT BE USED.
]  # END OF THE THIRD NODE
], # END OF NODES
[ # BEGINNING OF COMPONENTS. JUST THE ONES THAT HAS TO BE CHANGED HAVE TO BE LISTED HERE
["a", # COMPONENT LETTER  # BEGINNING OF THE FIRST COMPONENT. THIS IS A WINDOW EXAMPLE
"k", # COMPONENT TYPE. "k" IS FOR WINDOWS, "l" FOR CRACKS, AND "m" FOR DOORS.
.4 # SWING OF THE AREA. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE] , 
], # END OF THE FIRST COMPONENT
["b", # COMPONENT LETTER  # BEGINNING OF THE SECOND COMPONENT. THIS IS THE EXAMPLE OF A CRACK
"l", # COMPONENT TYPE. "k" IS FOR WINDOWS, "l" FOR CRACKS, AND "m" FOR DOORS.
.1,  # SWING OF THE CRACK WIDTH IN MM. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE
.2 # SWING OF THE CRACK LENGTH IN M. LEAVE "" BLANK IF YOU ACCEPT THE CURRENT VALUE
], # END OF THE SECOND COMPONENT
["c", # COMPONENT LETTER  # BEGINNING OF THE THIRD COMPONENT. THIS IS THE EXAMPLE OF A DOOR
"m", # COMPONENT TYPE. "k" IS FOR WINDOWS, "l" FOR CRACKS, AND "m" FOR DOORS.
.1,  # SWING OF THE DOOR WIDTH.
.1, # SWING OF THE DOOR HEIGHT
.1, # SWING OF THE HEIGHT OF THE ADJOINING NODE ABOVE BASE
0 # SWING OF THE DISCHARGE FACTOR
], # END OF THE THIRD COMPONENT
] # END OF NET COMPONENTS
], # END OF DATA FOR THE FIRST SEQUENCE OF OPERATIONS IN THIS MORPHING PHASE, ETC. NEW SEQUENCES CAN BE ADDED.
]; # If the alphabetical order is not accepted as an order to propagate constraints, a new order can be specificed
## WITH THE FOLLOWING VARIABLES:
## @node_letters AND @component_letters 

$vals{1}{111}{constrain_net} = 
[
[
"/nets/cell.afn", # source file
"/nets/cell.afn", # target file
"/opts/default_configfile_net_constraints.pl", # config file 
[ "none", "g", "i", "h", "j" ], # SURFACE LETTERS IN ZONE FOR EACH NETWORK NODE, IN THE SAME ORDER AS THEY APPEAR IN THE ".afn" FILE. THEY MUST BE AT LEAST THE SAME NUMBER OF $stepsvar. 
# ALSO THE INTERNAL NODE WILL NEED A VALUE TO BE SPECIFIED, THAT IT WON'T BE USED. IT DOESN'T MATTER WHAT IT IS. 
[ "none", "g", "k", "f", "g" ] # BASE PRESSURE COEFFICIENT LETTERS TO APPLY TO EACH NETWORK NODE, IN THE SAME ORDER AS THEY APPEAR IN THE ".afn" FILE. THEY MUST BE AT LEAST THE SAME NUMBER OF $stepsvar. 
# ALSO THE INTERNAL NODE WILL NEED A VALUE TO BE SPECIFIED, THAT IT WON'T BE USED.  THE EXCEEDING ITEMS WILL NOT BE USED. 
# ALSO, THESE VALUES WILL NOT BE USED IF DIFFERENT ONES WILL BE CALCULATED THROUGH PROPAGATION OF CONSTRAINTS, DEPENDING ON THE INSTRUCTIONS IN THE CONFIG FILE
], 
]; 
## THIS FILE CAN CONTAIN USER-IMPOSED CONSTRAINTS FOR MASS-FLOW NETWORKS TO BE READ BY OPT.
## IT MAKES AVAILABLE VARIABLES REGARDING THE SETTING OF NODES IN A NETWORK.
## SPECIFICALLY, @nodes and @components.
## CURRENTLY: INTERNAL UNKNOWN AIR NODES AND BOUNDARY WIND-CONCERNED NODES.
## IT MAKES AVAILABLE VARIABLES REGARDING COMPONENTS
## CURRENTLY: WINDOWS, CRACKS, DOORS.
## ALSO, THIS FILE MAKES AVAILABLE TO THE USER INFORMATIONS ABOUT THE MORPHING STEP OF THE MODELS.
## SPECIFICALLY, THE FOLLOWING VARIABLES WHICH REGARD BOTH INTERNAL AND BOUNDARY NODES.
## NOTE THAT "node_number" IS THE NUMBER OF THE NODE IN THE ".afn" ESP-r FILE. 
## $node[node_number][$node]. # EXAMPLE: $node[3][$node]. THIS IS THE LETTER OF THE THIRD NODE.
## $node[node_number][$type]
## $node[node_number][$height]. # EXAMPLE: $node[3][$height]. THIS IS THE HEIGHT OF THE 3RD NODE.
## THEN IT MAKES AVAILABLE THE FOLLOWING VARIABLES REGARDING NODES:
## $node[node_number][$volume] # REGARDING INTERNAL NODES
## $node[node_number][$azimut] # REGARDING BOUNDARY NODES
## THEN IT MAKE AVAILABLE THE FOLLOWING VARIABLES REGARDING COMPONENTS:
## $component[node_number][$area] # REGARDING SIMPLE OPENINGS
## $component[node_number][$width] # REGARDING CRACKS
## $component[node_number][$length] # REGARDING CRACKS
## $component[node_number][$door_width] # REGARDING DOORS
## $component[node_number][$door_height] # REGARDING DOORS
## $component[node_number][$door_nodeheight] # REGARDING DOORS
## $component[node_number][$door_discharge] # REGARDING DOORS (DISCHARGE FACTOR)
## ALSO, THIS FILE MAKES AVAILABLE TO THE USER INFORMATIONS ABOUT THE MORPHING STEP OF THE MODELS 
## AND THE STEPS THE MODEL HAVE TO FOLLOW.
## THIS ALLOWS TO IMPOSE EQUALITY CONSTRAINTS TO THESE VARIABLES, 
## WHICH COULD ALSO BE COMBINED WITH THE FOLLOWING ONES: 
## $stepsvar, WHICH TELLS THE PROGRAM HOW MANY ITERATION STEPS IT HAS TO DO IN THE CURRENT MORPHING PHASE.
## $counterzone, WHICH TELLS THE PROGRAM WHAT OPERATION IS BEING EXECUTED IN THE CHAIN OF OPERATIONS 
## THAT MAY BE EXECUTES AT EACH MORPHING PHASE. EACH $counterzone WILL CONTAIN ONE OR MORE ITERATION STEPS.
## TYPICALLY, IT WILL BE USED FOR A ZONE, BUT NOTHING PREVENTS THAT SEVERAL OF THEM CHAINED ONE AFTER 
## THE OTHER ARE APPLIED TO THE SAME ZONE.
## $counterstep, WHICH TELLS THE PROGRAM WHAT THE CURRENT ITERATION STEP IS.
## If the alphabetical order is not accepted as an order to propagate constraints, a new order can be specificed
## WITH THE FOLLOWING VARIABLES: @vertexletters (FOR GEOMETRY EDITING), @obs_letters (FOR OBSTRUCTIONS), 
## @node_letters AND @component_letters (FOR NETS), @letters AND @period_letters (FOR CONTROLS)


$vals{1}{111}{propagate_constraints} = [ 
[
[ "read_geo", # what to do
"/zones/zone.geo", # source file
"/zones/zone.geo", # target file
"/opts/default_configfile_constraints.pl", # config file 
[ "k", "l", "m", "n" ], # vertex letters to be changed.
"y" # ARE THERE LONG MENUS? "y" or "n".
],
["read_net", # what to do
"/nets/cell.afn", # source file
"/nets/cell.afn", # target file
"/opts/default_configfile_constraints.pl", # config file 
[ "none", "g", "i", "h", "j" ], # SURFACE LETTERS IN ZONE FOR EACH NETWORK NODE, IN THE SAME ORDER AS THEY APPEAR IN THE ".afn" FILE. THEY MUST BE AT LEAST THE SAME NUMBER OF $stepsvar. 
# ALSO THE INTERNAL NODE WILL NEED A VALUE TO BE SPECIFIED, THAT IT WON'T BE USED. IT DOESN'T MATTER WHAT IT IS. "none" IS FINE BECAUSE IT IS CLEAR. 
[ "none", "g", "k", "f", "g" ] # BASE PRESSURE COEFFICIENT LETTERS TO APPLY TO EACH NETWORK NODE, IN THE SAME ORDER AS THEY APPEAR IN THE ".afn" FILE. THEY MUST BE AT LEAST THE SAME NUMBER OF $stepsvar. 
# ALSO THE INTERNAL NODE WILL NEED A VALUE TO BE SPECIFIED, THAT IT WON'T BE USED. IT DOESN'T MATTER WHAT IT IS. "none" IS FINE BECAUSE IT IS CLEAR. # THE EXCEEDING ITEMS WILL NOT BE USED. 
# THE EXCEEDING ITEMS WILL NOT BE USED. ALSO, THESE VALUES WILL NOT BE USED IF DIFFERENT ONES WILL BE CALCULATED THROUGH PROPAGATION OF CONSTRAINTS, DEPENDING ON THE INSTRUCTIONS IN THE CONFIG FILE
], 
[ "read_obs", # what to do
"/zones/zone.geo", # source file
"/zones/zone.geo", # target file
"/opts/default_configfile_constraints.pl", # config file 
[ "e", "f", "g", "h"], # obstruction letters to be changed.
"n" # act on materials too? "y" or "n". That materials letters (as they appear in the material database) and not materials names have to be given in the configuration files.
],
["read_ctl", # what to do
"/ctl/cell.ctl", # source file
"/ctl/cell.ctl", # target file
"/opts/default_configfile_constraints.pl", # config file 
],
["write_ctl", # what to do
"/ctl/cell.ctl", # source file
"/ctl/cell.ctl", # target file
"/opts/default_configfile_constraints.pl", # config file 
],
["write_net", # what to do
"/nets/cell.afn", # source file
"/nets/cell.afn", # target file
"/opts/default_configfile_constraints.pl", # config file 
[ "none", "g", "i", "h", "j" ], # SURFACE LETTERS IN ZONE FOR EACH NETWORK NODE, IN THE SAME ORDER AS THEY APPEAR IN THE ".afn" FILE. THEY MUST BE AT LEAST THE SAME NUMBER OF $stepsvar. 
# ALSO THE INTERNAL NODE WILL NEED A VALUE TO BE SPECIFIED, THAT IT WON'T BE USED. IT DOESN'T MATTER WHAT IT IS.
[ "none", "g", "k", "f", "g" ] # BASE PRESSURE COEFFICIENT LETTERS TO APPLY TO EACH NETWORK NODE, IN THE SAME ORDER AS THEY APPEAR IN THE ".afn" FILE. 
# THEY MUST BE AT LEAST THE SAME NUMBER OF $stepsvar. 
# ALSO THE INTERNAL NODE WILL NEED A VALUE TO BE SPECIFIED, THAT IT WON'T BE USED.  THE EXCEEDING ITEMS WILL NOT BE USED. 
# ALSO, THESE VALUES WILL NOT BE USED IF DIFFERENT ONES WILL BE CALCULATED THROUGH PROPAGATION OF CONSTRAINTS, DEPENDING ON THE INSTRUCTIONS IN THE CONFIG FILE
], 
[ "write_geo", # what to do
"/zones/zone.geo", # source file
"/zones/zone.geo", # target file
"/opts/default_configfile_constraints.pl", # config file 
[ "k", "l", "m", "n"], # vertex letters to be changed.
"y", # ARE THERE LONG MENUS? "y" or "n".
0 # $askop: the number of the subarray in which the data structure to be used is. It depends on the order in which it has been read, on the $countop.
],
[ "write_obs", # what to do
"/zones/zone.geo", # source file
"/zones/zone.geo", # target file
"/opts/default_configfile_constraints.pl", # config file 
[ "e", "f", "g", "h"], # obstruction letters to be changed.
"n" # act on materials too? "y" or "n". That materials letters (as they appear in the material database) and not materials names have to be given in the configuration files.
]
],
]; # THIS FILE CAN CONTAIN USER-IMPOSED CONSTRAINTS FOR MASS-FLOW NETWORKS TO BE READ BY OPT.
## IT MAKES AVAILABLE VARIABLES REGARDING THE SETTING OF NODES IN A NETWORK.
## THIS FILE ALLOWS TO MANIPULATE COMPOUND USER-IMPOSED CONSTRAINTS.
## IT MAKES AVAILABLE TO THE USER THE FOLLOWING VARIABLES FOR MANIPULATION.
## IT IS POSSIBILE TO OPERATE ON GEOMETRY, CONSTRUCTIION
## REGARDING GEOMETRY:
## @v[$number][$x], @v[$number][$y], @v[$number][$z]. EXAMPLE: @v[4][$x] = 1. OR: @v[4][$x] =  @v[4][$y].
## REGARDING OBSTRUCTIONS:
## $obs[$obs_number][$x], $obs[$obs_number][$y], $obs[$obs_number][$y]
## $obs[$obs_number][$width], $obs[$obs_number][$depth], $obs[$obs_number][$height]
## $obs[$obs_number][$z_rotation], $obs[$obs_number][$y_rotation], 
## $obs[$obs_number][$tilt], $obs[$obs_number][$opacity], $obs[$obs_number][$material], 
## EXAMPLE: $obs[2][$x] = 2. THIS MEANS: COORDINATE x OF OBSTRUCTION HAS TO BE SET TO 2.
## OTHER EXAMPLE: $obs[2][$x] = $obs[2][$y]. THIS MEANS: 
## NOTE THAT THE MATERIAL TO BE SPECIFIED IS A MATERIAL LETTER, BETWEEN QUOTES! EXAMPLE: $obs[1][$material] = "a".
##  $tilt IS PRESENTLY UNUSED.
## REGARDING MASS-FLOW NETWORKS:
## @nodes and @components.
## CURRENTLY: INTERNAL UNKNOWN AIR NODES AND BOUNDARY WIND-CONCERNED NODES.
## IT MAKES AVAILABLE VARIABLES REGARDING COMPONENTS
## CURRENTLY: WINDOWS, CRACKS, DOORS.
## ALSO, THIS FILE MAKES AVAILABLE TO THE USER INFORMATIONS ABOUT THE MORPHING STEP OF THE MODELS.
## SPECIFICALLY, THE FOLLOWING VARIABLES WHICH REGARD BOTH INTERNAL AND BOUNDARY NODES.
## NOTE THAT "node_number" IS THE NUMBER OF THE NODE IN THE ".afn" ESP-r FILE. 
## $node[node_number][$node]. # EXAMPLE: $node[3][$node]. THIS IS THE LETTER OF THE THIRD NODE.
## $node[node_number][$type]
## $node[node_number][$height]. # EXAMPLE: $node[3][$height]. THIS IS THE HEIGHT OF THE 3RD NODE.
## THEN IT MAKES AVAILABLE THE FOLLOWING VARIABLES REGARDING NODES:
## $node[node_number][$volume] # REGARDING INTERNAL NODES
## $node[node_number][$azimut] # REGARDING BOUNDARY NODES
## THEN IT MAKE AVAILABLE THE FOLLOWING VARIABLES REGARDING COMPONENTS:
## $component[node_number][$area] # REGARDING SIMPLE OPENINGS
## $component[node_number][$width] # REGARDING CRACKS
## $component[node_number][$length] # REGARDING CRACKS
## $component[node_number][$door_width] # REGARDING DOORS
## $component[node_number][$door_height] # REGARDING DOORS
## $component[node_number][$door_nodeheight] # REGARDING DOORS
## $component[node_number][$door_discharge] # REGARDING DOORS (DISCHARGE FACTOR)
## REGARDING CONTROLS:
## 1) $loop_control[$countloop][$countloopcontrol][$loop_hour] 
## Where $countloop and  $countloopcontrol has to be set to a specified number in the OPT file for constraints.
## 2) $loop_control[$countloop][$countloopcontrol][$max_heating_power] # Same as above.
## 3) $loop_control[$countloop][$countloopcontrol][$min_heating_power] # Same as above.
## 4) $loop_control[$countloop][$countloopcontrol][$max_cooling_power] # Same as above.
## 5) $loop_control[$countloop][$countloopcontrol][$min_cooling_power] # Same as above.
## 6) $loop_control[$countloop][$countloopcontrol][heating_setpoint] # Same as above.
## 7) $loop_control[$countloop][$countloopcontrol][cooling_setpoint] # Same as above.
## 8) $flow_control[$countflow][$countflowcontrol][$flow_hour] 
## Where $countflow and  $countflowcontrol has to be set to a specified number in the OPT file for constraints.
## 9) $flow_control[$countflow][$countflowcontrol][$flow_setpoint] # Same as above.
## 10) $flow_control[$countflow][$countflowcontrol][$flow_onoff] # Same as above.
## 11) $flow_control[$countflow][$countflowcontrol][$flow_fraction] # Same as above.
## EXAMPLE : $flow_control[1][2][$flow_fraction] = 0.7
## OTHER EXAMPLE: $flow_control[1][2][$flow_fraction] = $flow_control[2][1][$flow_fraction]
## If the alphabetical order is not accepted as an order to propagate constraints, a new order can be specificed
## WITH THE FOLLOWING VARIABLES: @vertexletters (FOR GEOMETRY EDITING), @obs_letters (FOR OBSTRUCTIONS), 
## @node_letters AND @component_letters (FOR NETS), @letters AND @period_letters (FOR CONTROLS)
## FINALLY, ALL THE VARIABLES SPECIFIED IN THIS FILE CAN BE ACCESSED. FOR EXAMPLE: $recalculateish1, $translate2, ETC.
## THE VARIABLE AT THE CURRENT SEARCH STEP CAN BE NAMED WITHOUT THE NUMBER. EXAMPLE: $recalculateish, $translate, ETC.


$vals{1}{111}{recalculateish} = [ [ "n" ] ];
## recalculate the solar radiation? "y" or "n". This way the "ish" module is launched just at the end of a whole morphing operation, and not at every sub-operations composing it.

$vals{1}{111}{use_modish} = 
[
[
[ 1, "./relative_path_to_ishfile/ishfile.shd", 7 ]
]
]; 
#EXPLANATION: $vals{111}{use_modish} = 
#[
#[
#[ zonenumber1, "./relative_path_to_ishfile/ishfile1.shd", surface_number_x, ..., surface_number_n ],
#...
##[ zonenumbern, "./relative_path_to_ishfile/ishfilen.shd", surface_number_x, ..., surface_number_n ]
#]
#]; 


## THE CHOICE HERE IS BETWEEN "y", YES, AND EVERYTHING ELSE: LIKE NOTHING, OR "", OR "n", MEANING NO. THE OTHER VALUES BETWEEN BRACKETS ARE: [ word_to_substitute, substituting_word]
## SO: $vals{1}{export_toenergyplus} = [ [ "y", [ "word1_to_substitute", "substituting_word1]" ], [ "word2_to_substitute", "substituting_word2]" ], ... ] ];


$vals{1}{111}{genchange} = 
[
[
[ "/relative_constrainfile1_path", "/relative_constrainfile2_path" ], #FILE IN WHICH RULES FOR PROPAGATION OF CONSTRAINTS ARE WRITTEN. THEY ARE READ_AND_PROPAGATED ONE BY ONE, SEQUENTIALLY. # GIVE SEMI-LOCAL PATH WITHOUT THE DOTS (EXAMPLE: "/cfg/file".
[
[ "/cfg/configfile1.cfg", [ 3, 5, 2, "first_variable", "+" ],
                         [ 3, 5, [ low, high ], "second_variable", "+" ]
],
[ "/cfg/configfile2.cfg", [ 5, 3, [ low, high ], "third_variable", "+" ],
                         [ 3, 5, 4, "first_variable", "+" ]
],
]
]
];


$vals{1}{111}{recalculatenet} = # here the net is re-set using new pressure coefficients.
[ 
"../nets/cell.afn", # path to the file, starting from a model's root directory. Example: "./nets/cell.afn".
[
[ "a" ], # zone letter; if a wind boundary node, put also: letters of the surfaces
[ "a", "g", "g" ], # letters of the surfaces. 
[ "a", "h", "g" ] # letters for the set of pressure coefficients. 
]
]; 


$vals{1}{111}{daylightcalc} = [   ##### THIS VARIABLE GOVERNS A FUNCTION WHICH LAUNCHED DAYLIGHT FACTOR CALCULATION THROUGH RADIANCE. PLEASE NOTICE THAT EVEN THIS FUNCTION PRESENTLY WORKS ONLY FOR A SINGLE ZONE. ALSO NOTICE THAT THIS OPERATION HAS NOT YET BEEN WRITTEN TO BE USED IN SEQUENCE WITH OTHER OPERATIONS IN THE SAME MORPHING PHASE. SO USE IT IN THE FIRST SEQUENCE OF THIS PHASE, AND KEEP JUST ONE SEQUENCE IN THIS PHASE.
"a", # zone letter
"f", # surface with respect to which daylight factors have to be calculated
"a", # "a" for Inside, "b" for Outside: what daylight factor have to be calculated with respect to
"f", # edge with respect to which the first row has to be calculated
"0.9", # distance from surface
"1 2", #  grid layout density
"5", # level of accuracy, for convergence in calculations
"cell_Day_fa.df" # name of daylight factor file
]; #

$vals{1}{111}{skipop} = 
[
[ 
" ( ( \$translate->[\$counterzone][2][0] > 2 ) or ( \$translate_>[\$counterzone][2][0] < 8 ) ) "
, 
" ( ( \$translate->[\$counterzone][2][0] > 2 ) or ( \$translate_>[\$counterzone][2][0] < 8 ) ) " 
]
]; 
# THIS IS AN EXAMPLE OF CONDITION TO SKIP SOME TESTS, WRITTEN IN PERL.
# IT WILL BE EVALED BY THE PROGRAM TO SKIP AN INSTANCE IF THE SPECIFIED CONDITION IS MET.

$vals{111}{pin_obstructions} = 
[ 
[ "/zones/box.geo", #file name of the geo file
1, 2, 3 # obstruction number
]
]; 

$vals{111}{export_toenergyplus} = [ [ "y", "sim", "retrieve", "milan.epw", [ "FullInteriorAndExterior", "FullInteriorAndExteriorWithReflections" ], 
[ "4;   !- Time Step in Hour", "1;   !- Time Step in Hour" ], [ "1, 1,   !- Begin Month", "2, 1,   !- Begin Month" ], 
[ "12,31,   !- End Month", " 2, 7,   !- End Month" ] ] ];

$vals{111}{use_modish} = 
[
[
[ 1, "/zones/box.shd", 7 ]
]
]; 


$vals{1}{112}{translate_surface} =  
[ 
[ "b", [ "b", "d" ], [  1, 1  ] , "c", [ [ -4, -5, -6], [ 4, 5, 6] ] ],
];
# transform type: "a" for surface translation along normal, "b" for x y z surface translation.
# [ # surfaces to be translated (letters) ]
# [ # end movements, in case of surface translation along_normal (example: [2, 2, 2, 2, 2, 2] ), or "x y z" translation, in the case of x y z translation of surface (example: ["2  2  2", "2  2  2"]). Relative to the fields above.
# update radiation? "b" for yes or "c" for no.
#### @applytype111 = ( ["surface_translation", "file_name", "target_file_name", "zone_letter"]); 

$vals{1}{112}{translate} =  
[ 
[ "n", [ ["-9", "0", "0"], ["9", "0", "0"] ], "c", ],
];
#translate zone

$vals{1}{112}{rotate_surface} = 
[ 
[   [ "b", "d" ], [ 10, 12 ], [ [ -30, 30 ], [ -30, 30]  ] , [ "y", "y" ]   ]
];
# [
# [ # surfaces to rotate ]
# [ vertices around which to rotate ]
# [ wing extremes of the rotation ] # THAT IS: HALF RANGE OF THE ROTATION. 
# [ apply to others? "y" or "n" ]
##### @applytype111 = [ ["surface_rotation", "file_name", "target_file_name", "zone_letter"]);

$vals{1}{112}{rotate} = 
[ 
[ "y", [ -180, 180 ], "c", "a" ],
];

$vals{1}{112}{translate_vertices} = 
[ 
[ 
[ "a", "b", ],  
[ [[0, -0.5, 0], [0, 0.5, 0]], [[0, -0.3, 0], [0, 0.3, 0]] ], 
[ "/zones/zone.geo" ], # source file
[ "n" ] # long menus?
]
];
# [ @vertexes_to_transl, Consider that after "p" you have to write "0\nq" ]
# [ [ x y z movs ] ],  in case of surface x y z translation
# source file, # long menus?

$vals{1}{112}{shift_vertices} = 
[ 
[ "j", [ "i" , "l" , "m" ], [ [ -0.8, 0.8 ], [ -0.4, 0.4 ],[ -0.3, 0.3 ] ], "c", ],
];
# [
# movement type: "j": shift vertices along a line. "h": align vertices with a line.
# [ pairs of vertices defining axes ]
# [ Complete shift movements - whole excursion ]
# configuration file for conditions
# ]
#### @applytype111 = ( ["vertices_shift", "file_name", "target_file_name", "zone_letter"]);



$vals{1}{111}{applytype} = [ [ "genchange", "newbox21.idf", "newbox21.idf", "a" ] ] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to", "zone_letter"]), 
# the following morphing operations are available: "translate", "rotate", "rotatez", "surface_translate", "shift_vertices", 
# "rotate_surface", "warping", "construction_reassign", "change_thickness", "obs_modify", "generic_change", "vary_controls", “vary_net”, 
# "change_groundreflectance", "genchange", "translate_vertices", "change_climate"
$vals{1}{5}{genchange} =  #THIS MEANS: CHANGE OF "generic" TYPE, WHICH ARE TRASFORMATIONS OF SPECIFIED PARTS OF TEXT FILES.
[ #BRACKET FOR GROUP
[ #BRACKET FOLLOWING THE @applype BRACKETS. EACH BRACKET IS A SEQUENCE OF OPEARATION TO BE MADE IN PARALLEL. HERE THERE IS JUST ONE SEQUENCE.
[  ], # EXAMPLE: [ "/relative_constrainfile1_path", "/relative_constrainfile2_path" ] THESE CAN BE ABSENT. IN THAT CASE, PUT: [] (EMPTY BARACKETS. THESE ARE ONE OR MORE FILES IN WHICH RULES FOR PROPAGATION OF CONSTRAINTS ARE WRITTEN. THEY ARE READ_AND_PROPAGATED ONE BY ONE, SEQUENTIALLY. # GIVE SEMI-LOCAL PATH WITHOUT THE DOTS (EXAMPLE: "/cfg/file". 
[ # BRACKET DELEMITING THE GROUP OF OPERATIONS FOR THIS GROUP OF ACTIONS.
[ # BKACKET DELIMITING THIS GROUP OF ACTIONS. THERE IS ONLY ONE GROUP OF ACTIONS IN THIS GROUP OF OPERATIONS.
"/ep/newbox21.idf", # FILE TO BE MODIFIED.
[ [ 109, 112, 124, 127, 139, 142, 154, 157, 169, 170, 171, 172 ], # FIRST CHANGE TO BE MADE. THIS MEANS: [ [line_number_to_change1, line_number_to_change2, ... line_number_to_changen], 
[ 3 ], [ 0, 4 ], [  ], "linear", ",", 5  ], # [ line_item_number_to_change1, line_item_number_to_change2, ... line_item_number_to_change3], [ low_variation, high_variation ], [ change's_nickname_1, ... change's_nickname_n ], change_type("linear"_or_"rotation2d"_or_"wordchange"_), "separator"(e.g. "," - optional), precision(number_of_decimals) ]; # IF "wordchange" IS SPECIFIED, THE LIST OF WORDS TO BE PUT IN PLACE OF THE CHOSEN ITEM(S) MUST BE PLACED IN THE SAME SQUARE BRAKETS THAT FOR  OTHER CHANGE_TYPES ARE USED FOR THE max & min VALUES. 
]
]
]
];


$vals{1}{111}{applytype} = [ [ "genchange", "newbox21.idf", "newbox21.idf", "a" ] ] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to", "zone_letter"]), 
# the following morphing operations are available: "translate", "rotate", "rotatez", "surface_translate", "shift_vertices", 
# "rotate_surface", "warping", "construction_reassign", "change_thickness", "obs_modify", "generic_change", "vary_controls", “vary_net”, 
# "change_groundreflectance", "genchange", "translate_vertices", "change_climate"
$vals{1}{6}{genchange} =  #THIS MEANS: CHANGE OF "generic" TYPE, WHICH ARE TRASFORMATIONS OF SPECIFIED PARTS OF TEXT FILES.
[ #BRACKET FOR GROUP
[ #BRACKET FOLLOWING THE @applype BRACKETS. EACH BRACKET IS A SEQUENCE OF OPEARATION TO BE MADE IN PARALLEL. HERE THERE IS JUST ONE SEQUENCE.
[  ], # EXAMPLE: [ "/relative_constrainfile1_path", "/relative_constrainfile2_path" ] THESE CAN BE ABSENT. IN THAT CASE, PUT: [] (EMPTY BARACKETS. THESE ARE ONE OR MORE FILES IN WHICH RULES FOR PROPAGATION OF CONSTRAINTS ARE WRITTEN. THEY ARE READ_AND_PROPAGATED ONE BY ONE, SEQUENTIALLY. # GIVE SEMI-LOCAL PATH WITHOUT THE DOTS (EXAMPLE: "/cfg/file". 
[ # BRACKET DELEMITING THE GROUP OF OPERATIONS FOR THIS GROUP OF ACTIONS.
[ # BKACKET DELIMITING THIS GROUP OF ACTIONS. THERE IS ONLY ONE GROUP OF ACTIONS IN THIS GROUP OF OPERATIONS.
"/ep/newbox21.idf", # FILE TO BE MODIFIED.
[ [ 19, 20, 21, 22, 34, 35, 36, 37, 49, 50, 51, 52, 64, 65, 66, 67, 79, 80, 81, 82, 94, 95, 96, 97,
109, 110, 111, 112, 124, 125, 126, 127, 139, 140, 141, 142, 154, 155, 156, 157, 169, 170, 171, 172, 184, 185, 186, 187,
199, 200, 201, 202, 214, 215, 216, 217, 229, 230, 231, 232, 244, 245, 246, 247, 259, 260, 261, 262, 274, 275, 276, 277,
289, 290, 291, 292, 304, 305, 306, 307, 319, 320, 321, 322, 334, 335, 336, 337, 349, 350, 351, 352, 364, 365, 366, 367,
379, 380, 381, 382, 394, 395, 396, 397, 409, 410, 411, 412, 424, 425, 426, 427, 439, 440, 441, 442, 454, 455, 456, 457,
490, 491, 492, 493, 506, 507, 508, 509, 522, 523, 524, 525, 538, 539, 540, 541, 554, 555, 556, 557, 570, 571, 572, 573, 586, 587, 588, 589 ], # FIRST CHANGE TO BE MADE. THIS MEANS: [ [line_number_to_change1, line_number_to_change2, ... line_number_to_changen], 
[ 1, 2 ], [ -135, 180 ], [  ], "rotation2d", ",", 5, [ 0, 0 ] ], # [ line_item_number_to_change1, line_item_number_to_change2, ... line_item_number_to_change3], [ low_variation, high_variation ], [ change's_nickname_1, ... change's_nickname_n ], change_type("linear"_or_"rotation2d"_or_"wordchange"_), "separator"(e.g. "," - optional), precision(number_of_decimals) ]; # IF "wordchange" IS SPECIFIED, THE LIST OF WORDS TO BE PUT IN PLACE OF THE CHOSEN ITEM(S) MUST BE PLACED IN THE SAME SQUARE BRAKETS THAT FOR  OTHER CHANGE_TYPES ARE USED FOR THE max & min VALUES. 
]
]
]
];

$vals{1}{111}{applytype} = [ [ "genchange", "newbox21.idf", "newbox21.idf", "a" ] ] ; #  @applytype(n) = (["type_of_change", "your_test_file", "file_name_to_which_the_former_will_be_copied_to", "zone_letter"]), 
# the following morphing operations are available: "translate", "rotate", "rotatez", "surface_translate", "shift_vertices", 
# "rotate_surface", "warping", "construction_reassign", "change_thickness", "obs_modify", "generic_change", "vary_controls", “vary_net”, 
# "change_groundreflectance", "genchange", "translate_vertices", "change_climate"
$vals{1}{5}{genchange} =  #THIS MEANS: CHANGE OF "generic" TYPE, WHICH ARE TRASFORMATIONS OF SPECIFIED PARTS OF TEXT FILES.
[ #BRACKET FOR GROUP
[ #BRACKET FOLLOWING THE @applype BRACKETS. EACH BRACKET IS A SEQUENCE OF OPEARATION TO BE MADE IN PARALLEL. HERE THERE IS JUST ONE SEQUENCE.
[  ], # EXAMPLE: [ "/relative_constrainfile1_path", "/relative_constrainfile2_path" ] THESE CAN BE ABSENT. IN THAT CASE, PUT: [] (EMPTY BARACKETS. THESE ARE ONE OR MORE FILES IN WHICH RULES FOR PROPAGATION OF CONSTRAINTS ARE WRITTEN. THEY ARE READ_AND_PROPAGATED ONE BY ONE, SEQUENTIALLY. # GIVE SEMI-LOCAL PATH WITHOUT THE DOTS (EXAMPLE: "/cfg/file". 
[ # BRACKET DELEMITING THE GROUP OF OPERATIONS FOR THIS GROUP OF ACTIONS.
[ # BKACKET DELIMITING THIS GROUP OF ACTIONS. THERE IS ONLY ONE GROUP OF ACTIONS IN THIS GROUP OF OPERATIONS.
"/ep/newbox21.idf", # FILE TO BE MODIFIED.
[ [ 109, 112, 124, 127, 139, 142, 154, 157, 169, 170, 171, 172 ], # FIRST CHANGE TO BE MADE. THIS MEANS: [ [line_number_to_change1, line_number_to_change2, ... line_number_to_changen], 
[ 3 ], [ "bill", "ball", "bull", "bell" ], [  ], "wordchange", ","  ], # [ line_item_number_to_change1, line_item_number_to_change2, ... line_item_number_to_change3], [ low_variation, high_variation ], [ change's_nickname_1, ... change's_nickname_n ], change_type("linear"_or_"rotation2d"_or_"wordchange"_), "separator"(e.g. "," - optional), precision(number_of_decimals) ]; # IF "wordchange" IS SPECIFIED, THE LIST OF WORDS TO BE PUT IN PLACE OF THE CHOSEN ITEM(S) MUST BE PLACED IN THE SAME SQUARE BRAKETS THAT FOR  OTHER CHANGE_TYPES ARE USED FOR THE max & min VALUES. 
]
]
]
];



#############################################################################################






#############################################################################################
################################## TO BE DONE. ##############################################
#
##@caseseed =
##( 
##[ 
##[0, 4], [2, 4] , [4, 4],
##]
##,
##[
##[0, 2], [1, 2]
##]
##) ;  
## OPTIONAL. THIS AND @chanceseed SUPERSEDE @sweeps. 
## IT IS A WAY TO DESCRIBE THE SAME THING: THE STRUCTURE OF A (MAYBE OVERLAPPING) COORDINATE BLOCK DESCENT. 
## THIS IS THE ORDER OR PARAMETERS AT EACH SEARCH SWEEP. THERE IS A POINT TO POINT CORRESPONDENCE WITH @chanceseed.
## BETWEEN SQUARE BRACKETS ARE THE BLOCKS OF THE BLOCK COORDINATE SEARCH. THE FIRST ITEM IN 
## EACH SQUARE BRACKET IS THE POSITION OF THE FIRST ITEM IN THE ACTIVE BLOCK (INDEX FROM 0). 
## THE SECOND ITEM IS THE DIMENSION OF THE ACTIVE BLOCK, IN TERMS OF NUMBER OF PARAMETERS.
#
##@chanceseed = 
##(
##[
##[1, 2, 3, 4, 5], [1, 2, 3, 4, 5] , [1, 2, 3, 4, 5]
##]
##, 
##[
##[1, 2, 3], [1, 2, 3]
##]
##);
## OPTIONAL. THIS AND @caseseed SUPERSEDE @sweeps. 
## IT IS A WAY TO DESCRIBE THE SAME THING: THE STRUCTURE OF A (MAYBE OVERLAPPING) COORDINATE BLOCK DESCENT. 
## THIS IS THE ORDER OR PARAMETERS AT EACH SEARCH SWEEP. THERE IS A POINT TO POINT CORRESPONDENCE WITH @chanceseed.
## EACH OF THIS SERIES IS REFERRED TO THE CORRESPONDING BLOCK IN THE SAME POSITION OF THE $casefile.
## THESE SERIES SPECIFY THE ORDER OF PARAMETERS TO BE DECOMPOSED. THE DECOMPOSITION IS THAT SPECIFIED 
## IN $caseseed. 
#
##@chancedata = 
##([4, 2, 1], [3, 2, 1]); 
## HERE: 1) BLOCK LENGTH OF BLOCKS TO ADD; 2) OVERLAP BETWEEN BLOCKS; 3) NUMBER OF SWEEPS TO ADD.
## UNUSED FOR THE MOMENT.
#
##$dimchance =
##3;
## THIS IS USED IF $generatechance IS "y". IT TELLS TO THE PROGRAM AMONG HOW MANY RANDOM TRIALS THE COMBINATION 
## THAT WILL END UO BEING USED HAS TO BE SELECTED.






