package Prty::Math;
use base qw/Prty::Object/;

use strict;
use warnings;

our $VERSION = 1.06;

# -----------------------------------------------------------------------------

=encoding utf8

=head1 NAME

Prty::Math - Mathematische Funktionen

=head1 BASE CLASS

L<Prty::Object>

=head1 METHODS

=head2 gcd() - Größter gemeinsamer Teiler

=head3 Synopsis

    $gcd = $class->gcd($a,b);

=head3 Description

Berechne den größten gemeinsamen Teiler (greatest common divisor)
der beiden natürlichen Zahlen $a und $b und liefere diesen
zurück. Die Methode ist nach dem L<Euklidschen Algorithmus|https://de.wikipedia.org/wiki/Euklidischer_Algorithmus#Rekursive_Variante> implementiert.

=cut

# -----------------------------------------------------------------------------

sub gcd {
    my ($class,$a,$b) = @_;
    return $b == 0? $a: $class->gcd($b,$a%$b);
}

# -----------------------------------------------------------------------------

=head1 VERSION

1.06

=head1 AUTHOR

Frank Seitz, L<http://fseitz.de/>

=head1 COPYRIGHT

Copyright (C) 2016 Frank Seitz

=head1 LICENSE

This code is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

# -----------------------------------------------------------------------------

1;

# eof
