use strict;
use warnings;

use ExtUtils::MakeMaker 6.64;

WriteMakefile(
    ABSTRACT_FROM    => 'lib/App/cloc.pm',
    VERSION_FROM     => 'lib/App/cloc.pm',
    AUTHOR           => 'G. Casati <fibo@cpan.org>',
    NAME             => 'App::cloc',
    EXE_FILES        => ['bin/cloc'],
    LICENSE          => 'artistic_2',
    MIN_PERL_VERSION => '5.8.0',
    META_MERGE       => {
        resources => {
            homepage   => 'https://metacpan.org/pod/App::cloc',
            license    => 'http://g14n.info/artistic-license',
            repository => 'https://github.com/fibo/App-cloc-pm',
            bugtracker => 'https://github.com/fibo/App-cloc-pm/issues'
        },
    },
    PREREQ_PM => {
        'Algorithm::Diff' => '0',
        'Digest::MD5'     => '0',
        'Regexp::Common'  => '0',
        'Test::Compile'   => '1.2.1',
        'Test::More'      => '1.001009',
        'Test::Pod'       => '1.48'
    },
    BUILD_REQUIRES => {
        'ExtUtils::MakeMaker' => '6.64'
    },
    test          => { TESTS => 't/*.t' },
    TEST_REQUIRES => {
        'Test::Compile' => '1.2.1',
        'Test::More'    => '1.001009',
        'Test::Pod'     => '1.48'
    }
);

