warn <<'EOW';

*** WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING ***

If you're seeing this warning, your toolchain is really, really old and you'll
almost certainly have problems installing CPAN modules from this century. But
never fear, dear user, for we have the technology to fix this!

If you're using CPAN.pm to install things, then you can upgrade it using:

    cpan CPAN

If you're using CPANPLUS to install things, then you can upgrade it using:

    cpanp CPANPLUS

If you're using cpanminus, you shouldn't be seeing this message in the first
place, so please file an issue on github.

If you're installing manually, please retrain your fingers to run Build.PL
when present instead.

This public service announcement was brought to you by the Perl Toolchain
Gang, the irc.perl.org #toolchain IRC channel, and the number 42.

EOW

sleep 10 if -t STDIN;

# This Makefile.PL for  was generated by Dist::Zilla::Plugin::MakeMaker::Fallback 0.002.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;
check_conflicts();



my %WriteMakefileArgs = (
  "ABSTRACT" => "test the Kwalitee of a distribution before you release it",
  "AUTHOR" => "chromatic <chromatic\@wgz.org>, Karen Etheridge <ether\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "Dist::CheckConflicts" => "0.02",
    "ExtUtils::MakeMaker" => "6.30",
    "Module::Build::Tiny" => "0.027"
  },
  "DISTNAME" => "Test-Kwalitee",
  "EXE_FILES" => [
    "script/kwalitee-metrics"
  ],
  "LICENSE" => "perl",
  "NAME" => "Test::Kwalitee",
  "PREREQ_PM" => {
    "Cwd" => 0,
    "Dist::CheckConflicts" => "0.02",
    "Module::CPANTS::Analyse" => "0.87",
    "Test::Builder" => "0.88",
    "namespace::clean" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Spec::Functions" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "List::Util" => 0,
    "Test::CheckDeps" => "0.007",
    "Test::Deep" => 0,
    "Test::More" => "0.94",
    "Test::Tester" => "0.108",
    "Test::Warnings" => "0.005"
  },
  "VERSION" => "1.15",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);




sub check_conflicts {
    if ( eval { require 'lib/Test/Kwalitee/Conflicts.pm'; 1; } ) {
        if ( eval { Test::Kwalitee::Conflicts->check_conflicts; 1 } ) {
            return;
        }
        else {
            my $err = $@;
            $err =~ s/^/    /mg;
            warn "***\n$err***\n";
        }
    }
    else {
        print <<'EOF';
***
    Your toolchain doesn't support configure_requires, so Dist::CheckConflicts
    hasn't been installed yet. You should check for conflicting modules
    manually by examining the list of conflicts in Test::Kwalitee::Conflicts once the installation
    finishes.
***
EOF
    }

    return if $ENV{AUTOMATED_TESTING} || $ENV{NONINTERACTIVE_TESTING};

    # More or less copied from Module::Build
    return if $ENV{PERL_MM_USE_DEFAULT};
    return unless -t STDIN && ( -t STDOUT || !( -f STDOUT || -c STDOUT ) );

    sleep 4;
}
